import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestAdtranModels(DeviceTestCase):
    def test_adtran_sdx6000_SDX_6320_16_sdx6320_RL_23_5_33_10_59_5_254(self):
        if DeviceTestCase.TestDisabled:
                DeviceTestCase.skipTest(self, "Python 3.7 doesn't support this library")
        obj = self.run_data("adtran.sdx6000.SDX 6320-16.sdx6320-RL-23.5-33.10_59_5_254")
        exp_info = {
                'model': 'SDX 6320-16',
                'sta_count': 338,
                'sw_version': 'sdx6320-RL-23.5-33',
                'vendor': 'Adtran'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                'ADTN23123E9C': {       'dev_macs': ['38:f8:f6:52:b1:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU2',
                                        'serial': 'ADTN23123E9C'},
                'ADTN23123E9D': {       'dev_macs': ['cc:66:18:dd:8f:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU16',
                                        'serial': 'ADTN23123E9D'},
                'ADTN23123E9E': {       'dev_macs': ['cc:66:18:50:b7:70'],
                                        'ip_address': None,
                                        'name': 'ADTN23123E9E',
                                        'serial': 'ADTN23123E9E'},
                'ADTN23123EA1': {       'dev_macs': ['cc:66:18:db:77:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU17',
                                        'serial': 'ADTN23123EA1'},
                'ADTN23123EA8': {       'dev_macs': ['cc:66:18:dd:88:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU29',
                                        'serial': 'ADTN23123EA8'},
                'ADTN23123EB7': {       'dev_macs': ['38:f8:f6:52:ac:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU10',
                                        'serial': 'ADTN23123EB7'},
                'ADTN23123EBC': {       'dev_macs': ['cc:66:18:dc:77:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU13',
                                        'serial': 'ADTN23123EBC'},
                'ADTN23123EC0': {       'dev_macs': ['cc:66:18:db:65:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU11',
                                        'serial': 'ADTN23123EC0'},
                'ADTN23123F18': {       'dev_macs': ['cc:66:18:db:7d:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU4',
                                        'serial': 'ADTN23123F18'},
                'ADTN23123F2B': {       'dev_macs': ['cc:66:18:50:5c:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU11',
                                        'serial': 'ADTN23123F2B'},
                'ADTN23123F57': {       'dev_macs': ['cc:66:18:dc:68:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU2',
                                        'serial': 'ADTN23123F57'},
                'ADTN23123FAD': {       'dev_macs': ['cc:66:18:dc:76:60'],
                                        'ip_address': None,
                                        'name': 'ADTN23123FAD',
                                        'serial': 'ADTN23123FAD'},
                'ADTN23123FC4': {       'dev_macs': ['cc:66:18:dd:89:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU22',
                                        'serial': 'ADTN23123FC4'},
                'ADTN23123FDC': {       'dev_macs': ['cc:66:18:d6:37:81'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU23',
                                        'serial': 'ADTN23123FDC'},
                'ADTN23123FE9': {       'dev_macs': ['cc:66:18:50:b1:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU13',
                                        'serial': 'ADTN23123FE9'},
                'ADTN23123FEC': {       'dev_macs': ['cc:66:18:4c:03:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU28',
                                        'serial': 'ADTN23123FEC'},
                'ADTN23123FEE': {       'dev_macs': ['cc:66:18:db:65:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU12',
                                        'serial': 'ADTN23123FEE'},
                'ADTN23123FF5': {       'dev_macs': ['cc:66:18:d6:0c:10'],
                                        'ip_address': None,
                                        'name': 'ADTN23123FF5',
                                        'serial': 'ADTN23123FF5'},
                'ADTN23124008': {       'dev_macs': ['cc:66:18:d6:3b:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU33',
                                        'serial': 'ADTN23124008'},
                'ADTN2312408C': {       'dev_macs': ['38:f8:f6:52:ad:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU17',
                                        'serial': 'ADTN2312408C'},
                'ADTN23124097': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU17',
                                        'serial': 'ADTN23124097'},
                'ADTN23124099': {       'dev_macs': ['cc:66:18:51:50:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU19',
                                        'serial': 'ADTN23124099'},
                'ADTN231240A6': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU13',
                                        'serial': 'ADTN231240A6'},
                'ADTN231240B0': {       'dev_macs': ['cc:66:18:dc:5d:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU1',
                                        'serial': 'ADTN231240B0'},
                'ADTN23124128': {       'dev_macs': ['cc:66:18:dc:82:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU8',
                                        'serial': 'ADTN23124128'},
                'ADTN231241A2': {       'dev_macs': ['cc:66:18:50:ae:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU21',
                                        'serial': 'ADTN231241A2'},
                'ADTN231241BF': {       'dev_macs': ['cc:66:18:50:50:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU22',
                                        'serial': 'ADTN231241BF'},
                'ADTN231241C0': {       'dev_macs': ['cc:66:18:dd:8f:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU10',
                                        'serial': 'ADTN231241C0'},
                'ADTN231241D0': {       'dev_macs': ['cc:66:18:dd:7c:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU8',
                                        'serial': 'ADTN231241D0'},
                'ADTN231241D1': {       'dev_macs': ['38:f8:f6:52:ad:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU3',
                                        'serial': 'ADTN231241D1'},
                'ADTN23124214': {       'dev_macs': ['cc:66:18:50:f1:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU20',
                                        'serial': 'ADTN23124214'},
                'ADTN23124304': {       'dev_macs': ['cc:66:18:d6:0b:60'],
                                        'ip_address': None,
                                        'name': 'ADTN23124304',
                                        'serial': 'ADTN23124304'},
                'ADTN2312432E': {       'dev_macs': ['cc:66:18:d6:0a:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU0',
                                        'serial': 'ADTN2312432E'},
                'ADTN2312445C': {       'dev_macs': ['cc:66:18:50:d8:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU7',
                                        'serial': 'ADTN2312445C'},
                'ADTN23124491': {       'dev_macs': ['cc:66:18:d5:fd:61'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU19',
                                        'serial': 'ADTN23124491'},
                'ADTN231244BA': {       'dev_macs': ['38:f8:f6:52:aa:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU0',
                                        'serial': 'ADTN231244BA'},
                'ADTN231244BC': {       'dev_macs': ['38:f8:f6:52:a7:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU8',
                                        'serial': 'ADTN231244BC'},
                'ADTN231244EB': {       'dev_macs': ['cc:66:18:d6:3a:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU17',
                                        'serial': 'ADTN231244EB'},
                'ADTN23124510': {       'dev_macs': ['cc:66:18:50:3d:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU26',
                                        'serial': 'ADTN23124510'},
                'ADTN231245C6': {       'dev_macs': ['cc:66:18:4b:fa:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU6',
                                        'serial': 'ADTN231245C6'},
                'ADTN2312460A': {       'dev_macs': ['38:f8:f6:52:a3:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU2',
                                        'serial': 'ADTN2312460A'},
                'ADTN23124650': {       'dev_macs': ['cc:66:18:dc:81:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU3',
                                        'serial': 'ADTN23124650'},
                'ADTN23124713': {       'dev_macs': ['cc:66:18:dc:88:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU20',
                                        'serial': 'ADTN23124713'},
                'ADTN231247A1': {       'dev_macs': ['cc:66:18:50:51:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU26',
                                        'serial': 'ADTN231247A1'},
                'ADTN23124849': {       'dev_macs': ['cc:66:18:d6:07:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU1',
                                        'serial': 'ADTN23124849'},
                'ADTN231248A8': {       'dev_macs': ['cc:66:18:50:6c:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU9',
                                        'serial': 'ADTN231248A8'},
                'ADTN23124900': {       'dev_macs': ['cc:66:18:dc:72:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU7',
                                        'serial': 'ADTN23124900'},
                'ADTN2312491E': {       'dev_macs': ['cc:66:18:dd:88:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU6',
                                        'serial': 'ADTN2312491E'},
                'ADTN23124966': {       'dev_macs': ['cc:66:18:50:37:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU15',
                                        'serial': 'ADTN23124966'},
                'ADTN23124A18': {       'dev_macs': ['cc:66:18:d6:38:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU21',
                                        'serial': 'ADTN23124A18'},
                'ADTN23124A23': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU3',
                                        'serial': 'ADTN23124A23'},
                'ADTN23124A76': {       'dev_macs': [       '36:3a:c5:c7:0e:34',
                                                            'cc:66:18:50:b4:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU19',
                                        'serial': 'ADTN23124A76'},
                'ADTN23124B3F': {       'dev_macs': ['cc:66:18:50:43:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU22',
                                        'serial': 'ADTN23124B3F'},
                'ADTN23124B7E': {       'dev_macs': ['cc:66:18:50:ef:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU14',
                                        'serial': 'ADTN23124B7E'},
                'ADTN23124BA5': {       'dev_macs': ['cc:66:18:d6:38:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU23',
                                        'serial': 'ADTN23124BA5'},
                'ADTN23124C55': {       'dev_macs': ['cc:66:18:50:81:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU27',
                                        'serial': 'ADTN23124C55'},
                'ADTN23124C6A': {       'dev_macs': ['cc:66:18:51:26:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU27',
                                        'serial': 'ADTN23124C6A'},
                'ADTN23124C73': {       'dev_macs': ['cc:66:18:d6:3c:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU18',
                                        'serial': 'ADTN23124C73'},
                'ADTN23124D38': {       'dev_macs': ['cc:66:18:dc:77:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU6',
                                        'serial': 'ADTN23124D38'},
                'ADTN23124D41': {       'dev_macs': ['cc:66:18:dc:71:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU0',
                                        'serial': 'ADTN23124D41'},
                'ADTN23124D43': {       'dev_macs': ['cc:66:18:dc:56:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU1',
                                        'serial': 'ADTN23124D43'},
                'ADTN23124D46': {       'dev_macs': ['38:f8:f6:52:b4:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU5',
                                        'serial': 'ADTN23124D46'},
                'ADTN23124D50': {       'dev_macs': ['cc:66:18:dc:78:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU5',
                                        'serial': 'ADTN23124D50'},
                'ADTN23124D68': {       'dev_macs': ['cc:66:18:dc:88:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU0',
                                        'serial': 'ADTN23124D68'},
                'ADTN23124D7D': {       'dev_macs': ['38:f8:f6:52:7a:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU7',
                                        'serial': 'ADTN23124D7D'},
                'ADTN23124D7E': {       'dev_macs': ['cc:66:18:dc:74:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU5',
                                        'serial': 'ADTN23124D7E'},
                'ADTN23124D91': {       'dev_macs': ['38:f8:f6:52:a9:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU0',
                                        'serial': 'ADTN23124D91'},
                'ADTN23124D93': {       'dev_macs': ['cc:66:18:dc:87:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU4',
                                        'serial': 'ADTN23124D93'},
                'ADTN23124D98': {       'dev_macs': ['cc:66:18:dd:92:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU4',
                                        'serial': 'ADTN23124D98'},
                'ADTN23124D9E': {       'dev_macs': ['cc:66:18:db:66:60'],
                                        'ip_address': None,
                                        'name': 'ADTN23124D9E',
                                        'serial': 'ADTN23124D9E'},
                'ADTN23124DA0': {       'dev_macs': ['cc:66:18:50:48:80'],
                                        'ip_address': None,
                                        'name': 'ADTN23124DA0',
                                        'serial': 'ADTN23124DA0'},
                'ADTN23124DA6': {       'dev_macs': ['cc:66:18:dc:77:f0'],
                                        'ip_address': None,
                                        'name': 'ADTN23124DA6',
                                        'serial': 'ADTN23124DA6'},
                'ADTN23124DB0': {       'dev_macs': ['cc:66:18:dd:7e:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU7',
                                        'serial': 'ADTN23124DB0'},
                'ADTN23124DB2': {       'dev_macs': ['cc:66:18:dc:80:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU6',
                                        'serial': 'ADTN23124DB2'},
                'ADTN23124DB7': {       'dev_macs': ['cc:66:18:4b:fa:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU8',
                                        'serial': 'ADTN23124DB7'},
                'ADTN23124DBC': {       'dev_macs': ['38:f8:f6:52:ac:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU9',
                                        'serial': 'ADTN23124DBC'},
                'ADTN23124DC7': {       'dev_macs': ['cc:66:18:dd:75:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU1',
                                        'serial': 'ADTN23124DC7'},
                'ADTN23124DCE': {       'dev_macs': ['cc:66:18:dd:2a:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU11',
                                        'serial': 'ADTN23124DCE'},
                'ADTN23124DD9': {       'dev_macs': ['cc:66:18:dd:7e:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU2',
                                        'serial': 'ADTN23124DD9'},
                'ADTN23124DDA': {       'dev_macs': ['cc:66:18:dc:6e:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU1',
                                        'serial': 'ADTN23124DDA'},
                'ADTN23124DDD': {       'dev_macs': ['cc:66:18:dc:57:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU5',
                                        'serial': 'ADTN23124DDD'},
                'ADTN23124DDF': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU16',
                                        'serial': 'ADTN23124DDF'},
                'ADTN23124DE0': {       'dev_macs': ['cc:66:18:dd:8e:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU2',
                                        'serial': 'ADTN23124DE0'},
                'ADTN23124DE4': {       'dev_macs': ['cc:66:18:dc:76:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU6',
                                        'serial': 'ADTN23124DE4'},
                'ADTN23124DE8': {       'dev_macs': ['cc:66:18:50:b5:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU12',
                                        'serial': 'ADTN23124DE8'},
                'ADTN23124DEB': {       'dev_macs': ['38:f8:f6:52:9c:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU3',
                                        'serial': 'ADTN23124DEB'},
                'ADTN23124DF1': {       'dev_macs': ['cc:66:18:dc:7f:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU0',
                                        'serial': 'ADTN23124DF1'},
                'ADTN23124DF3': {       'dev_macs': ['cc:66:18:dc:7d:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU9',
                                        'serial': 'ADTN23124DF3'},
                'ADTN23124DF5': {       'dev_macs': ['cc:66:18:dc:6e:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU19',
                                        'serial': 'ADTN23124DF5'},
                'ADTN23124DF6': {       'dev_macs': ['38:f8:f6:52:ac:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU3',
                                        'serial': 'ADTN23124DF6'},
                'ADTN23124DF7': {       'dev_macs': ['cc:66:18:dd:7f:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU14',
                                        'serial': 'ADTN23124DF7'},
                'ADTN23124DFB': {       'dev_macs': ['cc:66:18:dd:73:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU0',
                                        'serial': 'ADTN23124DFB'},
                'ADTN23124DFC': {       'dev_macs': ['cc:66:18:dc:77:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU5',
                                        'serial': 'ADTN23124DFC'},
                'ADTN23124E04': {       'dev_macs': ['cc:66:18:4c:01:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU4',
                                        'serial': 'ADTN23124E04'},
                'ADTN23124E07': {       'dev_macs': ['cc:66:18:dc:56:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU0',
                                        'serial': 'ADTN23124E07'},
                'ADTN23124E0D': {       'dev_macs': ['cc:66:18:dc:75:a0'],
                                        'ip_address': None,
                                        'name': 'ADTN23124E0D',
                                        'serial': 'ADTN23124E0D'},
                'ADTN23124E14': {       'dev_macs': ['cc:66:18:dc:77:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU1',
                                        'serial': 'ADTN23124E14'},
                'ADTN23124E16': {       'dev_macs': ['cc:66:18:dc:73:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU9',
                                        'serial': 'ADTN23124E16'},
                'ADTN23124E17': {       'dev_macs': ['cc:66:18:dc:7d:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU15',
                                        'serial': 'ADTN23124E17'},
                'ADTN23124E18': {       'dev_macs': ['cc:66:18:dc:88:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU1',
                                        'serial': 'ADTN23124E18'},
                'ADTN23124E19': {       'dev_macs': ['cc:66:18:dd:7b:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU21',
                                        'serial': 'ADTN23124E19'},
                'ADTN23124E1F': {       'dev_macs': ['cc:66:18:dd:8b:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU30',
                                        'serial': 'ADTN23124E1F'},
                'ADTN23124E22': {       'dev_macs': ['cc:66:18:dd:8d:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU12',
                                        'serial': 'ADTN23124E22'},
                'ADTN23124E23': {       'dev_macs': ['cc:66:18:4c:03:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU24',
                                        'serial': 'ADTN23124E23'},
                'ADTN23124E25': {       'dev_macs': ['38:f8:f6:52:af:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU13',
                                        'serial': 'ADTN23124E25'},
                'ADTN23124E26': {       'dev_macs': ['cc:66:18:dd:93:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU3',
                                        'serial': 'ADTN23124E26'},
                'ADTN23124E27': {       'dev_macs': ['cc:66:18:dc:70:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU25',
                                        'serial': 'ADTN23124E27'},
                'ADTN23124E29': {       'dev_macs': ['cc:66:18:dd:68:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU7',
                                        'serial': 'ADTN23124E29'},
                'ADTN23124E2A': {       'dev_macs': ['cc:66:18:d6:08:e0'],
                                        'ip_address': None,
                                        'name': 'ADTN23124E2A',
                                        'serial': 'ADTN23124E2A'},
                'ADTN23124E2B': {       'dev_macs': ['38:f8:f6:52:b2:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU10',
                                        'serial': 'ADTN23124E2B'},
                'ADTN23124E2D': {       'dev_macs': ['cc:66:18:dd:8a:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU15',
                                        'serial': 'ADTN23124E2D'},
                'ADTN23124E30': {       'dev_macs': ['cc:66:18:dc:79:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU5',
                                        'serial': 'ADTN23124E30'},
                'ADTN23124E33': {       'dev_macs': ['cc:66:18:d6:08:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU17',
                                        'serial': 'ADTN23124E33'},
                'ADTN23124E35': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU3',
                                        'serial': 'ADTN23124E35'},
                'ADTN23124E37': {       'dev_macs': ['cc:66:18:dc:6e:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU11',
                                        'serial': 'ADTN23124E37'},
                'ADTN23124E3A': {       'dev_macs': ['cc:66:18:dd:8a:b1'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU7',
                                        'serial': 'ADTN23124E3A'},
                'ADTN23124E3E': {       'dev_macs': ['cc:66:18:dc:70:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU4',
                                        'serial': 'ADTN23124E3E'},
                'ADTN23124E3F': {       'dev_macs': ['cc:66:18:dd:83:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU23',
                                        'serial': 'ADTN23124E3F'},
                'ADTN23124E40': {       'dev_macs': ['cc:66:18:dd:8a:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU0',
                                        'serial': 'ADTN23124E40'},
                'ADTN23124E43': {       'dev_macs': ['cc:66:18:d6:03:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU18',
                                        'serial': 'ADTN23124E43'},
                'ADTN23124E45': {       'dev_macs': ['cc:66:18:dc:83:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU0',
                                        'serial': 'ADTN23124E45'},
                'ADTN23124E4B': {       'dev_macs': ['cc:66:18:dd:8f:b0'],
                                        'ip_address': None,
                                        'name': 'ADTN23124E4B',
                                        'serial': 'ADTN23124E4B'},
                'ADTN23124E4D': {       'dev_macs': ['cc:66:18:d6:08:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU4',
                                        'serial': 'ADTN23124E4D'},
                'ADTN23124E50': {       'dev_macs': ['cc:66:18:d6:00:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU11',
                                        'serial': 'ADTN23124E50'},
                'ADTN23124E52': {       'dev_macs': ['cc:66:18:dd:82:c0'],
                                        'ip_address': None,
                                        'name': 'ADTN23124E52',
                                        'serial': 'ADTN23124E52'},
                'ADTN23124E57': {       'dev_macs': ['38:f8:f6:52:ab:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU9',
                                        'serial': 'ADTN23124E57'},
                'ADTN23124E5B': {       'dev_macs': ['cc:66:18:4c:02:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU17',
                                        'serial': 'ADTN23124E5B'},
                'ADTN23124E64': {       'dev_macs': ['cc:66:18:4b:fa:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU26',
                                        'serial': 'ADTN23124E64'},
                'ADTN23124E67': {       'dev_macs': ['cc:66:18:dd:82:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU22',
                                        'serial': 'ADTN23124E67'},
                'ADTN23124E6A': {       'dev_macs': ['cc:66:18:d6:3a:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU5',
                                        'serial': 'ADTN23124E6A'},
                'ADTN23124E6B': {       'dev_macs': ['cc:66:18:dc:87:c0'],
                                        'ip_address': None,
                                        'name': 'ADTN23124E6B',
                                        'serial': 'ADTN23124E6B'},
                'ADTN23124E71': {       'dev_macs': ['cc:66:18:dd:84:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU0',
                                        'serial': 'ADTN23124E71'},
                'ADTN23124E73': {       'dev_macs': ['cc:66:18:50:52:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU13',
                                        'serial': 'ADTN23124E73'},
                'ADTN23124E7A': {       'dev_macs': ['cc:66:18:dd:7e:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU1',
                                        'serial': 'ADTN23124E7A'},
                'ADTN23124E84': {       'dev_macs': ['cc:66:18:dc:71:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU5',
                                        'serial': 'ADTN23124E84'},
                'ADTN23124E86': {       'dev_macs': ['cc:66:18:dc:6d:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU8',
                                        'serial': 'ADTN23124E86'},
                'ADTN23124E8A': {       'dev_macs': ['cc:66:18:51:30:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU14',
                                        'serial': 'ADTN23124E8A'},
                'ADTN23124E92': {       'dev_macs': ['38:f8:f6:52:a6:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU6',
                                        'serial': 'ADTN23124E92'},
                'ADTN23124EA4': {       'dev_macs': ['cc:66:18:4c:8d:d0'],
                                        'ip_address': None,
                                        'name': 'ADTN23124EA4',
                                        'serial': 'ADTN23124EA4'},
                'ADTN23124EA5': {       'dev_macs': ['cc:66:18:dc:8a:10'],
                                        'ip_address': None,
                                        'name': 'ADTN23124EA5',
                                        'serial': 'ADTN23124EA5'},
                'ADTN23124ED3': {       'dev_macs': ['cc:66:18:d6:32:11'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU7',
                                        'serial': 'ADTN23124ED3'},
                'ADTN23124ED9': {       'dev_macs': ['cc:66:18:dd:7c:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU3',
                                        'serial': 'ADTN23124ED9'},
                'ADTN23124EDF': {       'dev_macs': ['cc:66:18:dc:81:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU3',
                                        'serial': 'ADTN23124EDF'},
                'ADTN23124EFA': {       'dev_macs': ['cc:66:18:db:76:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU2',
                                        'serial': 'ADTN23124EFA'},
                'ADTN23124F06': {       'dev_macs': ['38:f8:f6:52:ab:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU10',
                                        'serial': 'ADTN23124F06'},
                'ADTN23124F14': {       'dev_macs': ['cc:66:18:dc:6b:c0'],
                                        'ip_address': None,
                                        'name': 'ADTN23124F14',
                                        'serial': 'ADTN23124F14'},
                'ADTN23124F2B': {       'dev_macs': ['cc:66:18:dc:81:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU10',
                                        'serial': 'ADTN23124F2B'},
                'ADTN23124F2D': {       'dev_macs': ['38:f8:f6:52:af:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU0',
                                        'serial': 'ADTN23124F2D'},
                'ADTN23124F30': {       'dev_macs': ['cc:66:18:dc:75:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU6',
                                        'serial': 'ADTN23124F30'},
                'ADTN23124F34': {       'dev_macs': ['38:f8:f6:52:ac:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU8',
                                        'serial': 'ADTN23124F34'},
                'ADTN23124F37': {       'dev_macs': ['cc:66:18:dd:89:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU5',
                                        'serial': 'ADTN23124F37'},
                'ADTN23124F3C': {       'dev_macs': ['cc:66:18:dc:78:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU4',
                                        'serial': 'ADTN23124F3C'},
                'ADTN23124F74': {       'dev_macs': ['cc:66:18:dd:83:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU16',
                                        'serial': 'ADTN23124F74'},
                'ADTN23124F99': {       'dev_macs': ['cc:66:18:dc:75:51'],
                                        'ip_address': None,
                                        'name': 'ADTN23124F99',
                                        'serial': 'ADTN23124F99'},
                'ADTN2312501D': {       'dev_macs': ['cc:66:18:dc:73:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU18',
                                        'serial': 'ADTN2312501D'},
                'ADTN23125020': {       'dev_macs': ['cc:66:18:dd:7d:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU4',
                                        'serial': 'ADTN23125020'},
                'ADTN23125026': {       'dev_macs': ['cc:66:18:dd:79:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU1',
                                        'serial': 'ADTN23125026'},
                'ADTN23125037': {       'dev_macs': ['38:f8:f6:52:ac:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU13',
                                        'serial': 'ADTN23125037'},
                'ADTN23125055': {       'dev_macs': ['cc:66:18:dc:81:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU2',
                                        'serial': 'ADTN23125055'},
                'ADTN23125061': {       'dev_macs': ['cc:66:18:4c:01:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU0',
                                        'serial': 'ADTN23125061'},
                'ADTN23125065': {       'dev_macs': ['cc:66:18:50:4f:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU15',
                                        'serial': 'ADTN23125065'},
                'ADTN2312506C': {       'dev_macs': ['cc:66:18:51:42:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU19',
                                        'serial': 'ADTN2312506C'},
                'ADTN23125088': {       'dev_macs': ['cc:66:18:dd:8b:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU3',
                                        'serial': 'ADTN23125088'},
                'ADTN2312509E': {       'dev_macs': ['cc:66:18:d6:08:f0'],
                                        'ip_address': None,
                                        'name': 'ADTN2312509E',
                                        'serial': 'ADTN2312509E'},
                'ADTN231250BB': {       'dev_macs': ['cc:66:18:db:65:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU13',
                                        'serial': 'ADTN231250BB'},
                'ADTN231250BF': {       'dev_macs': ['cc:66:18:d6:08:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU10',
                                        'serial': 'ADTN231250BF'},
                'ADTN231250C0': {       'dev_macs': ['cc:66:18:d6:09:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU9',
                                        'serial': 'ADTN231250C0'},
                'ADTN231250C3': {       'dev_macs': ['cc:66:18:dc:77:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU23',
                                        'serial': 'ADTN231250C3'},
                'ADTN231250C6': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU2',
                                        'serial': 'ADTN231250C6'},
                'ADTN231250C8': {       'dev_macs': ['cc:66:18:51:50:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU16',
                                        'serial': 'ADTN231250C8'},
                'ADTN231250CC': {       'dev_macs': ['cc:66:18:dd:7b:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU6',
                                        'serial': 'ADTN231250CC'},
                'ADTN231250CD': {       'dev_macs': ['cc:66:18:50:63:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU11',
                                        'serial': 'ADTN231250CD'},
                'ADTN231250D1': {       'dev_macs': ['cc:66:18:50:f5:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU14',
                                        'serial': 'ADTN231250D1'},
                'ADTN231250DD': {       'dev_macs': ['cc:66:18:4c:02:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU12',
                                        'serial': 'ADTN231250DD'},
                'ADTN231250FE': {       'dev_macs': ['cc:66:18:d6:02:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU8',
                                        'serial': 'ADTN231250FE'},
                'ADTN23125103': {       'dev_macs': ['cc:66:18:d6:04:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU9',
                                        'serial': 'ADTN23125103'},
                'ADTN2312510B': {       'dev_macs': ['cc:66:18:dc:88:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU20',
                                        'serial': 'ADTN2312510B'},
                'ADTN2312510C': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU11',
                                        'serial': 'ADTN2312510C'},
                'ADTN23125111': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU7',
                                        'serial': 'ADTN23125111'},
                'ADTN23125116': {       'dev_macs': ['cc:66:18:dc:79:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU14',
                                        'serial': 'ADTN23125116'},
                'ADTN2312511D': {       'dev_macs': ['cc:66:18:d6:0b:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU12',
                                        'serial': 'ADTN2312511D'},
                'ADTN23125126': {       'dev_macs': ['cc:66:18:dc:6a:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU18',
                                        'serial': 'ADTN23125126'},
                'ADTN23125129': {       'dev_macs': ['cc:66:18:d6:09:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU16',
                                        'serial': 'ADTN23125129'},
                'ADTN2312512C': {       'dev_macs': ['cc:66:18:dc:6c:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU16',
                                        'serial': 'ADTN2312512C'},
                'ADTN2312512E': {       'dev_macs': ['cc:66:18:dd:8e:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU10',
                                        'serial': 'ADTN2312512E'},
                'ADTN2312512F': {       'dev_macs': ['cc:66:18:4b:fa:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU15',
                                        'serial': 'ADTN2312512F'},
                'ADTN23125133': {       'dev_macs': ['cc:66:18:db:76:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU18',
                                        'serial': 'ADTN23125133'},
                'ADTN23125135': {       'dev_macs': ['cc:66:18:50:3e:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU26',
                                        'serial': 'ADTN23125135'},
                'ADTN2312513A': {       'dev_macs': ['cc:66:18:50:50:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU9',
                                        'serial': 'ADTN2312513A'},
                'ADTN23125143': {       'dev_macs': ['cc:66:18:d6:07:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU8',
                                        'serial': 'ADTN23125143'},
                'ADTN23125146': {       'dev_macs': ['cc:66:18:dd:91:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU7',
                                        'serial': 'ADTN23125146'},
                'ADTN23125148': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU12',
                                        'serial': 'ADTN23125148'},
                'ADTN23125149': {       'dev_macs': ['cc:66:18:d6:36:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU1',
                                        'serial': 'ADTN23125149'},
                'ADTN2312514A': {       'dev_macs': ['cc:66:18:dc:83:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU18',
                                        'serial': 'ADTN2312514A'},
                'ADTN2312514B': {       'dev_macs': ['cc:66:18:d6:35:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU12',
                                        'serial': 'ADTN2312514B'},
                'ADTN2312514C': {       'dev_macs': ['cc:66:18:50:87:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU21',
                                        'serial': 'ADTN2312514C'},
                'ADTN2312514D': {       'dev_macs': ['38:f8:f6:52:b3:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU9',
                                        'serial': 'ADTN2312514D'},
                'ADTN2312514E': {       'dev_macs': ['cc:66:18:dd:8a:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU11',
                                        'serial': 'ADTN2312514E'},
                'ADTN2312514F': {       'dev_macs': ['cc:66:18:51:24:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU21',
                                        'serial': 'ADTN2312514F'},
                'ADTN23125150': {       'dev_macs': ['cc:66:18:d6:36:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x14-ONU0',
                                        'serial': 'ADTN23125150'},
                'ADTN23125153': {       'dev_macs': ['38:f8:f6:52:a8:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU19',
                                        'serial': 'ADTN23125153'},
                'ADTN23125158': {       'dev_macs': ['cc:66:18:dd:92:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU11',
                                        'serial': 'ADTN23125158'},
                'ADTN2312515B': {       'dev_macs': ['cc:66:18:dc:7f:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU12',
                                        'serial': 'ADTN2312515B'},
                'ADTN23125160': {       'dev_macs': ['cc:66:18:dd:69:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU4',
                                        'serial': 'ADTN23125160'},
                'ADTN23125161': {       'dev_macs': ['cc:66:18:dc:65:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU6',
                                        'serial': 'ADTN23125161'},
                'ADTN23125166': {       'dev_macs': ['cc:66:18:dd:78:e0'],
                                        'ip_address': None,
                                        'name': 'ADTN23125166',
                                        'serial': 'ADTN23125166'},
                'ADTN23125171': {       'dev_macs': ['cc:66:18:4c:04:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU2',
                                        'serial': 'ADTN23125171'},
                'ADTN2312517D': {       'dev_macs': ['cc:66:18:dd:78:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU11',
                                        'serial': 'ADTN2312517D'},
                'ADTN2312517F': {       'dev_macs': ['cc:66:18:dd:23:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU11',
                                        'serial': 'ADTN2312517F'},
                'ADTN2312518D': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU23',
                                        'serial': 'ADTN2312518D'},
                'ADTN2312518E': {       'dev_macs': ['cc:66:18:db:74:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU10',
                                        'serial': 'ADTN2312518E'},
                'ADTN23125190': {       'dev_macs': ['cc:66:18:50:75:70'],
                                        'ip_address': None,
                                        'name': 'ADTN23125190',
                                        'serial': 'ADTN23125190'},
                'ADTN23125194': {       'dev_macs': ['cc:66:18:50:81:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU10',
                                        'serial': 'ADTN23125194'},
                'ADTN23125195': {       'dev_macs': ['cc:66:18:50:b8:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU5',
                                        'serial': 'ADTN23125195'},
                'ADTN231251AA': {       'dev_macs': ['cc:66:18:d6:37:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU20',
                                        'serial': 'ADTN231251AA'},
                'ADTN231251AB': {       'dev_macs': ['cc:66:18:4c:a3:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU20',
                                        'serial': 'ADTN231251AB'},
                'ADTN231251B0': {       'dev_macs': ['cc:66:18:dd:8d:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU15',
                                        'serial': 'ADTN231251B0'},
                'ADTN231251B1': {       'dev_macs': ['cc:66:18:dd:6a:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU13',
                                        'serial': 'ADTN231251B1'},
                'ADTN231251E2': {       'dev_macs': ['38:f8:f6:52:71:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU2',
                                        'serial': 'ADTN231251E2'},
                'ADTN231251EB': {       'dev_macs': ['cc:66:18:dc:56:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU5',
                                        'serial': 'ADTN231251EB'},
                'ADTN231251EE': {       'dev_macs': ['cc:66:18:dd:93:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU13',
                                        'serial': 'ADTN231251EE'},
                'ADTN231251F6': {       'dev_macs': ['cc:66:18:d6:08:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU6',
                                        'serial': 'ADTN231251F6'},
                'ADTN231251F7': {       'dev_macs': ['cc:66:18:dc:79:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU4',
                                        'serial': 'ADTN231251F7'},
                'ADTN23125206': {       'dev_macs': ['cc:66:18:50:6e:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU8',
                                        'serial': 'ADTN23125206'},
                'ADTN2314428A': {       'dev_macs': ['cc:66:18:dc:97:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU20',
                                        'serial': 'ADTN2314428A'},
                'ADTN23144666': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU25',
                                        'serial': 'ADTN23144666'},
                'ADTN23144681': {       'dev_macs': ['cc:66:18:d6:3b:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU5',
                                        'serial': 'ADTN23144681'},
                'ADTN2314468C': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU17',
                                        'serial': 'ADTN2314468C'},
                'ADTN23144699': {       'dev_macs': ['cc:66:18:dc:78:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU18',
                                        'serial': 'ADTN23144699'},
                'ADTN2314469E': {       'dev_macs': ['cc:66:18:dd:87:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU24',
                                        'serial': 'ADTN2314469E'},
                'ADTN231446A3': {       'dev_macs': ['38:f8:f6:52:a9:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU13',
                                        'serial': 'ADTN231446A3'},
                'ADTN231446A5': {       'dev_macs': ['cc:66:18:d6:3a:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU17',
                                        'serial': 'ADTN231446A5'},
                'ADTN231446B4': {       'dev_macs': ['cc:66:18:50:23:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU14',
                                        'serial': 'ADTN231446B4'},
                'ADTN231446B8': {       'dev_macs': ['38:f8:f6:52:a8:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU13',
                                        'serial': 'ADTN231446B8'},
                'ADTN231446BC': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU12',
                                        'serial': 'ADTN231446BC'},
                'ADTN231446C0': {       'dev_macs': ['cc:66:18:50:5b:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU18',
                                        'serial': 'ADTN231446C0'},
                'ADTN231446CB': {       'dev_macs': ['cc:66:18:dd:6a:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU14',
                                        'serial': 'ADTN231446CB'},
                'ADTN231446CC': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU14',
                                        'serial': 'ADTN231446CC'},
                'ADTN231446CE': {       'dev_macs': ['cc:66:18:dc:89:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU15',
                                        'serial': 'ADTN231446CE'},
                'ADTN23144702': {       'dev_macs': ['cc:66:18:d6:08:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU11',
                                        'serial': 'ADTN23144702'},
                'ADTN23144707': {       'dev_macs': ['cc:66:18:dd:52:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU10',
                                        'serial': 'ADTN23144707'},
                'ADTN23144714': {       'dev_macs': ['cc:66:18:dd:8d:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x14-ONU1',
                                        'serial': 'ADTN23144714'},
                'ADTN23144735': {       'dev_macs': ['cc:66:18:dc:84:51'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU25',
                                        'serial': 'ADTN23144735'},
                'ADTN23144748': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU14',
                                        'serial': 'ADTN23144748'},
                'ADTN23144759': {       'dev_macs': ['cc:66:18:4b:fc:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU15',
                                        'serial': 'ADTN23144759'},
                'ADTN23144773': {       'dev_macs': ['cc:66:18:dd:29:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU17',
                                        'serial': 'ADTN23144773'},
                'ADTN2314477A': {       'dev_macs': ['cc:66:18:dd:8a:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU26',
                                        'serial': 'ADTN2314477A'},
                'ADTN23144796': {       'dev_macs': ['cc:66:18:50:ce:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU14',
                                        'serial': 'ADTN23144796'},
                'ADTN231447A4': {       'dev_macs': ['cc:66:18:dc:86:d1'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU31',
                                        'serial': 'ADTN231447A4'},
                'ADTN231447A5': {       'dev_macs': ['cc:66:18:50:58:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU24',
                                        'serial': 'ADTN231447A5'},
                'ADTN231447AB': {       'dev_macs': ['cc:66:18:dc:b3:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU28',
                                        'serial': 'ADTN231447AB'},
                'ADTN231447AC': {       'dev_macs': ['cc:66:18:dc:b3:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU23',
                                        'serial': 'ADTN231447AC'},
                'ADTN231447AE': {       'dev_macs': ['cc:66:18:d6:03:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU15',
                                        'serial': 'ADTN231447AE'},
                'ADTN231447BD': {       'dev_macs': ['38:f8:f6:52:a8:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU12',
                                        'serial': 'ADTN231447BD'},
                'ADTN231447DA': {       'dev_macs': ['38:f8:f6:52:ab:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU24',
                                        'serial': 'ADTN231447DA'},
                'ADTN231447E3': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU15',
                                        'serial': 'ADTN231447E3'},
                'ADTN231447F3': {       'dev_macs': ['cc:66:18:dd:89:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU29',
                                        'serial': 'ADTN231447F3'},
                'ADTN231447F9': {       'dev_macs': ['38:f8:f6:52:a8:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU4',
                                        'serial': 'ADTN231447F9'},
                'ADTN2314480D': {       'dev_macs': ['cc:66:18:d6:0a:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU27',
                                        'serial': 'ADTN2314480D'},
                'ADTN2314483B': {       'dev_macs': ['cc:66:18:d6:07:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU13',
                                        'serial': 'ADTN2314483B'},
                'ADTN23144861': {       'dev_macs': ['cc:66:18:50:9a:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU15',
                                        'serial': 'ADTN23144861'},
                'ADTN2314486C': {       'dev_macs': ['cc:66:18:dc:84:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU16',
                                        'serial': 'ADTN2314486C'},
                'ADTN23144883': {       'dev_macs': ['cc:66:18:d6:0a:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU9',
                                        'serial': 'ADTN23144883'},
                'ADTN2314489C': {       'dev_macs': ['cc:66:18:d6:0c:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU6',
                                        'serial': 'ADTN2314489C'},
                'ADTN2314489D': {       'dev_macs': ['cc:66:18:50:6e:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU8',
                                        'serial': 'ADTN2314489D'},
                'ADTN231448B4': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU22',
                                        'serial': 'ADTN231448B4'},
                'ADTN231448B8': {       'dev_macs': ['cc:66:18:dd:8c:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU3',
                                        'serial': 'ADTN231448B8'},
                'ADTN231448BA': {       'dev_macs': ['cc:66:18:d6:38:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU7',
                                        'serial': 'ADTN231448BA'},
                'ADTN231448C9': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU18',
                                        'serial': 'ADTN231448C9'},
                'ADTN231448D1': {       'dev_macs': ['cc:66:18:50:b3:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU15',
                                        'serial': 'ADTN231448D1'},
                'ADTN231448D5': {       'dev_macs': ['cc:66:18:d6:0c:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU21',
                                        'serial': 'ADTN231448D5'},
                'ADTN231448FC': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU2',
                                        'serial': 'ADTN231448FC'},
                'ADTN231448FE': {       'dev_macs': ['cc:66:18:d6:0b:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU16',
                                        'serial': 'ADTN231448FE'},
                'ADTN23144916': {       'dev_macs': ['38:f8:f6:52:a8:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU19',
                                        'serial': 'ADTN23144916'},
                'ADTN23144A15': {       'dev_macs': ['cc:66:18:50:6e:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU7',
                                        'serial': 'ADTN23144A15'},
                'ADTN23144A2B': {       'dev_macs': ['cc:66:18:dc:89:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU22',
                                        'serial': 'ADTN23144A2B'},
                'ADTN23144A53': {       'dev_macs': ['cc:66:18:d6:38:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU4',
                                        'serial': 'ADTN23144A53'},
                'ADTN23144A5A': {       'dev_macs': ['cc:66:18:4c:03:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU3',
                                        'serial': 'ADTN23144A5A'},
                'ADTN23144A5C': {       'dev_macs': ['cc:66:18:4c:00:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU6',
                                        'serial': 'ADTN23144A5C'},
                'ADTN23144A69': {       'dev_macs': ['cc:66:18:51:04:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU32',
                                        'serial': 'ADTN23144A69'},
                'ADTN23144A70': {       'dev_macs': ['cc:66:18:50:d0:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU24',
                                        'serial': 'ADTN23144A70'},
                'ADTN23144A84': {       'dev_macs': ['cc:66:18:d6:34:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU5',
                                        'serial': 'ADTN23144A84'},
                'ADTN23144A86': {       'dev_macs': [       '08:55:31:e1:ea:4b',
                                                            '18:e8:29:34:ed:33',
                                                            '18:e8:29:36:d4:71',
                                                            '18:e8:29:3a:1a:3d',
                                                            '18:e8:29:8e:ed:6f',
                                                            '18:e8:29:8e:ed:78',
                                                            '18:e8:29:8e:f1:06',
                                                            '24:5a:4c:e4:c8:a1',
                                                            '74:83:c2:a6:5a:93',
                                                            '74:83:c2:a6:7f:9f',
                                                            '74:83:c2:a6:86:4e',
                                                            '74:83:c2:e8:a2:61',
                                                            '74:83:c2:ea:a6:01',
                                                            '74:83:c2:ea:a6:28',
                                                            '74:83:c2:ec:11:8b',
                                                            '74:ac:b9:80:d4:53',
                                                            '94:a6:7e:dd:ad:81',
                                                            'b4:fb:e4:5a:4f:8e',
                                                            'b8:94:70:f8:2b:2a',
                                                            'dc:2c:6e:dd:2e:26',
                                                            'f4:92:bf:38:a5:74',
                                                            'f4:92:bf:38:a7:25',
                                                            'f4:92:bf:38:a7:c2',
                                                            'f4:92:bf:d6:a8:ac'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU25',
                                        'serial': 'ADTN23144A86'},
                'ADTN23144A97': {       'dev_macs': ['cc:66:18:d6:37:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU16',
                                        'serial': 'ADTN23144A97'},
                'ADTN23144A9B': {       'dev_macs': ['cc:66:18:51:21:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU11',
                                        'serial': 'ADTN23144A9B'},
                'ADTN23144A9C': {       'dev_macs': ['cc:66:18:dd:8a:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU16',
                                        'serial': 'ADTN23144A9C'},
                'ADTN23144AB0': {       'dev_macs': ['cc:66:18:4c:01:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU26',
                                        'serial': 'ADTN23144AB0'},
                'ADTN23144ACF': {       'dev_macs': ['38:f8:f6:52:a1:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU12',
                                        'serial': 'ADTN23144ACF'},
                'ADTN23144B20': {       'dev_macs': ['cc:66:18:dc:aa:e1'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU31',
                                        'serial': 'ADTN23144B20'},
                'ADTN23144B24': {       'dev_macs': ['cc:66:18:dc:8b:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU18',
                                        'serial': 'ADTN23144B24'},
                'ADTN23144B2C': {       'dev_macs': ['cc:66:18:d6:3c:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU17',
                                        'serial': 'ADTN23144B2C'},
                'ADTN23144B3A': {       'dev_macs': ['cc:66:18:db:7e:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU20',
                                        'serial': 'ADTN23144B3A'},
                'ADTN23144B3F': {       'dev_macs': ['cc:66:18:50:63:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU8',
                                        'serial': 'ADTN23144B3F'},
                'ADTN23144B4D': {       'dev_macs': ['cc:66:18:50:9c:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU21',
                                        'serial': 'ADTN23144B4D'},
                'ADTN23144B58': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU19',
                                        'serial': 'ADTN23144B58'},
                'ADTN23144B5E': {       'dev_macs': ['cc:66:18:51:31:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU10',
                                        'serial': 'ADTN23144B5E'},
                'ADTN23144BF7': {       'dev_macs': ['cc:66:18:4c:55:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU16',
                                        'serial': 'ADTN23144BF7'},
                'ADTN23144C10': {       'dev_macs': ['cc:66:18:d6:36:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU21',
                                        'serial': 'ADTN23144C10'},
                'ADTN23144C17': {       'dev_macs': ['cc:66:18:51:04:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU25',
                                        'serial': 'ADTN23144C17'},
                'ADTN23144C33': {       'dev_macs': ['cc:66:18:dd:91:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x14-ONU2',
                                        'serial': 'ADTN23144C33'},
                'ADTN23144C46': {       'dev_macs': ['cc:66:18:dc:75:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU20',
                                        'serial': 'ADTN23144C46'},
                'ADTN23144C4E': {       'dev_macs': ['cc:66:18:50:a9:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU21',
                                        'serial': 'ADTN23144C4E'},
                'ADTN23144C8B': {       'dev_macs': ['cc:66:18:50:62:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU9',
                                        'serial': 'ADTN23144C8B'},
                'ADTN23144CC3': {       'dev_macs': ['cc:66:18:dd:8a:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU19',
                                        'serial': 'ADTN23144CC3'},
                'ADTN23144CD5': {       'dev_macs': ['cc:66:18:dd:93:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU18',
                                        'serial': 'ADTN23144CD5'},
                'ADTN23144D50': {       'dev_macs': ['cc:66:18:d6:0c:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU17',
                                        'serial': 'ADTN23144D50'},
                'ADTN23144D99': {       'dev_macs': ['cc:66:18:50:3f:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU7',
                                        'serial': 'ADTN23144D99'},
                'ADTN23144DDF': {       'dev_macs': ['cc:66:18:d6:37:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU16',
                                        'serial': 'ADTN23144DDF'},
                'ADTN23144EC8': {       'dev_macs': ['cc:66:18:50:ad:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU24',
                                        'serial': 'ADTN23144EC8'},
                'ADTN23144ED2': {       'dev_macs': ['cc:66:18:50:7b:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU30',
                                        'serial': 'ADTN23144ED2'},
                'ADTN23144ED3': {       'dev_macs': ['cc:66:18:50:b7:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU34',
                                        'serial': 'ADTN23144ED3'},
                'ADTN23144EDF': {       'dev_macs': ['cc:66:18:50:39:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU19',
                                        'serial': 'ADTN23144EDF'},
                'ADTN23144EE0': {       'dev_macs': ['cc:66:18:50:b6:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU23',
                                        'serial': 'ADTN23144EE0'},
                'ADTN23144EE3': {       'dev_macs': ['cc:66:18:dc:a8:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU28',
                                        'serial': 'ADTN23144EE3'},
                'ADTN23144EFB': {       'dev_macs': ['cc:66:18:dc:b4:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU17',
                                        'serial': 'ADTN23144EFB'},
                'ADTN23144EFD': {       'dev_macs': ['cc:66:18:dc:71:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU20',
                                        'serial': 'ADTN23144EFD'},
                'ADTN23144EFF': {       'dev_macs': ['cc:66:18:50:4a:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU20',
                                        'serial': 'ADTN23144EFF'},
                'ADTN23144F00': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU25',
                                        'serial': 'ADTN23144F00'},
                'ADTN23145120': {       'dev_macs': ['cc:66:18:4b:fe:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU20',
                                        'serial': 'ADTN23145120'},
                'ADTN24314195': {       'dev_macs': ['cc:66:18:d6:39:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU10',
                                        'serial': 'ADTN24314195'},
                'ADTN243141A3': {       'dev_macs': ['cc:66:18:50:e6:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU22',
                                        'serial': 'ADTN243141A3'},
                'ADTN243141AC': {       'dev_macs': ['cc:66:18:dd:81:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU19',
                                        'serial': 'ADTN243141AC'},
                'ADTN24314314': {       'dev_macs': ['cc:66:18:51:27:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU22',
                                        'serial': 'ADTN24314314'},
                'ADTN243144FB': {       'dev_macs': ['cc:66:18:50:fd:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU6',
                                        'serial': 'ADTN243144FB'},
                'ADTN24314766': {       'dev_macs': ['cc:66:18:50:3e:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU28',
                                        'serial': 'ADTN24314766'},
                'ADTN24363AE7': {       'dev_macs': ['38:f8:f6:52:ab:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU29',
                                        'serial': 'ADTN24363AE7'},
                'ADTN24363B6B': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU27',
                                        'serial': 'ADTN24363B6B'},
                'ADTN24363BBA': {       'dev_macs': ['cc:66:18:50:b6:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU18',
                                        'serial': 'ADTN24363BBA'},
                'ADTN24363C49': {       'dev_macs': ['cc:66:18:51:2e:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU31',
                                        'serial': 'ADTN24363C49'},
                'ADTN24363CC6': {       'dev_macs': ['cc:66:18:50:62:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU13',
                                        'serial': 'ADTN24363CC6'},
                'ADTN24363D3A': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU21',
                                        'serial': 'ADTN24363D3A'},
                'ADTN24363D4D': {       'dev_macs': ['cc:66:18:50:6a:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU32',
                                        'serial': 'ADTN24363D4D'},
                'ADTN24363DB9': {       'dev_macs': ['cc:66:18:50:b1:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU16',
                                        'serial': 'ADTN24363DB9'},
                'ADTN24363DC9': {       'dev_macs': ['cc:66:18:50:ac:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU28',
                                        'serial': 'ADTN24363DC9'},
                'ADTN243896F9': {       'dev_macs': ['cc:66:18:51:25:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU30',
                                        'serial': 'ADTN243896F9'},
                'ADTN244917A4': {       'dev_macs': ['cc:66:18:50:9b:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU22',
                                        'serial': 'ADTN244917A4'},
                'ADTN251521A2': {       'dev_macs': ['cc:66:18:50:ba:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU17',
                                        'serial': 'ADTN251521A2'},
                'CXNK00A4305B': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU19',
                                        'serial': 'CXNK00A4305B'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 53.35,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '0/1',
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/1',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8x',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/1',
                                                                                      'id': 'xgspon '
                                                                                            '0/1',
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/1',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8x',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/10',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:dc:88:30'],
                                                                                       'in_nucast_pkts': '17350',
                                                                                       'in_octets': '13335759005',
                                                                                       'in_ucast_pkts': '104288639',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '481481868213',
                                                                                       'out_ucast_pkts': '328067017',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDY4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:88:a0'],
                                                                                       'in_nucast_pkts': '17353',
                                                                                       'in_octets': '3375284024',
                                                                                       'in_ucast_pkts': '7643960',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '38970248215',
                                                                                       'out_ucast_pkts': '31960265',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTE4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:81:d0'],
                                                                                       'in_nucast_pkts': '116896',
                                                                                       'in_octets': '36055555296',
                                                                                       'in_ucast_pkts': '133646574',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '9898',
                                                                                       'out_octets': '481248857766',
                                                                                       'out_ucast_pkts': '378880965',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDU1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:81:e0'],
                                                                                       'in_nucast_pkts': '116891',
                                                                                       'in_octets': '49636365763',
                                                                                       'in_ucast_pkts': '281729576',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '9894',
                                                                                       'out_octets': '1329234239498',
                                                                                       'out_ucast_pkts': '918260033',
                                                                                       'poller_hash': 'QURUTjIzMTI0NjUwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:7d:00'],
                                                                                       'in_nucast_pkts': '24484',
                                                                                       'in_octets': '6556027515',
                                                                                       'in_ucast_pkts': '13343348',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2072',
                                                                                       'out_octets': '40619971557',
                                                                                       'out_ucast_pkts': '34613725',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDIwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:74:90'],
                                                                                       'in_nucast_pkts': '185353',
                                                                                       'in_octets': '62164914093',
                                                                                       'in_ucast_pkts': '236837758',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15625',
                                                                                       'out_octets': '875539994170',
                                                                                       'out_ucast_pkts': '653727994',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDdFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:80:50'],
                                                                                       'in_nucast_pkts': '17337',
                                                                                       'in_octets': '11797895551',
                                                                                       'in_ucast_pkts': '77635048',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1465',
                                                                                       'out_octets': '301282269730',
                                                                                       'out_ucast_pkts': '209671611',
                                                                                       'poller_hash': 'QURUTjIzMTI0REIyIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:68:b0'],
                                                                                       'in_nucast_pkts': '17355',
                                                                                       'in_octets': '3607712444',
                                                                                       'in_ucast_pkts': '16831967',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1468',
                                                                                       'out_octets': '60418812521',
                                                                                       'out_ucast_pkts': '45761191',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTI5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:7c:d0'],
                                                                                       'in_nucast_pkts': '17359',
                                                                                       'in_octets': '7555932399',
                                                                                       'in_ucast_pkts': '48517272',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1468',
                                                                                       'out_octets': '272090504758',
                                                                                       'out_ucast_pkts': '194566979',
                                                                                       'poller_hash': 'QURUTjIzMTI0MUQwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ac:d0'],
                                                                                       'in_nucast_pkts': '17497',
                                                                                       'in_octets': '12357854316',
                                                                                       'in_ucast_pkts': '39057101',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '195856588153',
                                                                                       'out_ucast_pkts': '146883781',
                                                                                       'poller_hash': 'QURUTjIzMTI0REJDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:b2:80'],
                                                                                       'in_nucast_pkts': '17074',
                                                                                       'in_octets': '5123053333',
                                                                                       'in_ucast_pkts': '12730687',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '39204583525',
                                                                                       'out_ucast_pkts': '35900007',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTJCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:23:20'],
                                                                                       'in_nucast_pkts': '56280',
                                                                                       'in_octets': '75997970204',
                                                                                       'in_ucast_pkts': '230241542',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '4649',
                                                                                       'out_octets': '983572185597',
                                                                                       'out_ucast_pkts': '706426217',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTdGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:7f:60'],
                                                                                       'in_nucast_pkts': '17350',
                                                                                       'in_octets': '24490568755',
                                                                                       'in_ucast_pkts': '74536339',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '219456576798',
                                                                                       'out_ucast_pkts': '166369684',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTVCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:6a:40'],
                                                                                       'in_nucast_pkts': '17357',
                                                                                       'in_octets': '11117991299',
                                                                                       'in_ucast_pkts': '50364145',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '137294957416',
                                                                                       'out_ucast_pkts': '117912283',
                                                                                       'poller_hash': 'QURUTjIzMTI1MUIxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:30:c0'],
                                                                                       'in_nucast_pkts': '114985',
                                                                                       'in_octets': '21659055433',
                                                                                       'in_ucast_pkts': '102931082',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3834',
                                                                                       'out_octets': '455566541671',
                                                                                       'out_ucast_pkts': '320085741',
                                                                                       'poller_hash': 'QURUTjIzMTI0RThBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:4f:90'],
                                                                                       'in_nucast_pkts': '114988',
                                                                                       'in_octets': '30698021276',
                                                                                       'in_ucast_pkts': '152237846',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3834',
                                                                                       'out_octets': '493904889370',
                                                                                       'out_ucast_pkts': '362374584',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDY1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8f:50'],
                                                                                       'in_nucast_pkts': '17354',
                                                                                       'in_octets': '29097681192',
                                                                                       'in_ucast_pkts': '95864727',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '281619296041',
                                                                                       'out_ucast_pkts': '225231276',
                                                                                       'poller_hash': 'QURUTjIzMTIzRTlEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:08:30'],
                                                                                       'in_nucast_pkts': '17776',
                                                                                       'in_octets': '95455458929',
                                                                                       'in_ucast_pkts': '224634758',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '598351349113',
                                                                                       'out_ucast_pkts': '459796937',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTMzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:03:40'],
                                                                                       'in_nucast_pkts': '116887',
                                                                                       'in_octets': '138058217301',
                                                                                       'in_ucast_pkts': '365230395',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '9896',
                                                                                       'out_octets': '1101010958219',
                                                                                       'out_ucast_pkts': '807821198',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTQzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d5:fd:61'],
                                                                                       'in_nucast_pkts': '309',
                                                                                       'in_octets': '6398862455',
                                                                                       'in_ucast_pkts': '46841830',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '218148219816',
                                                                                       'out_ucast_pkts': '148815866',
                                                                                       'poller_hash': 'QURUTjIzMTI0NDkxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:88:70'],
                                                                                       'in_nucast_pkts': '116887',
                                                                                       'in_octets': '174393990995',
                                                                                       'in_ucast_pkts': '494997024',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '9894',
                                                                                       'out_octets': '1118290591416',
                                                                                       'out_ucast_pkts': '932843019',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTBCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:0c:90'],
                                                                                       'in_nucast_pkts': '116924',
                                                                                       'in_octets': '90453348503',
                                                                                       'in_ucast_pkts': '160959414',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '9897',
                                                                                       'out_octets': '416534696335',
                                                                                       'out_ucast_pkts': '325483464',
                                                                                       'poller_hash': 'QURUTjIzMTQ0OEQ1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '08:55:31:e1:ea:4b',
                                                                                                                        '18:e8:29:34:ed:33',
                                                                                                                        '18:e8:29:36:d4:71',
                                                                                                                        '18:e8:29:3a:1a:3d',
                                                                                                                        '18:e8:29:8e:ed:6f',
                                                                                                                        '18:e8:29:8e:ed:78',
                                                                                                                        '18:e8:29:8e:f1:06',
                                                                                                                        '24:5a:4c:e4:c8:a1',
                                                                                                                        '74:83:c2:a6:5a:93',
                                                                                                                        '74:83:c2:a6:7f:9f',
                                                                                                                        '74:83:c2:a6:86:4e',
                                                                                                                        '74:83:c2:e8:a2:61',
                                                                                                                        '74:83:c2:ea:a6:01',
                                                                                                                        '74:83:c2:ea:a6:28',
                                                                                                                        '74:83:c2:ec:11:8b',
                                                                                                                        '74:ac:b9:80:d4:53',
                                                                                                                        '94:a6:7e:dd:ad:81',
                                                                                                                        'b4:fb:e4:5a:4f:8e',
                                                                                                                        'b8:94:70:f8:2b:2a',
                                                                                                                        'dc:2c:6e:dd:2e:26',
                                                                                                                        'f4:92:bf:38:a5:74',
                                                                                                                        'f4:92:bf:38:a7:25',
                                                                                                                        'f4:92:bf:38:a7:c2',
                                                                                                                        'f4:92:bf:d6:a8:ac'],
                                                                                       'in_nucast_pkts': '8119817',
                                                                                       'in_octets': '1884647079326',
                                                                                       'in_ucast_pkts': '9369806084',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '155642',
                                                                                       'out_octets': '28843170418904',
                                                                                       'out_ucast_pkts': '21400391889',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTg2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:b3:c0'],
                                                                                       'in_nucast_pkts': '40455',
                                                                                       'in_octets': '13102866261',
                                                                                       'in_ucast_pkts': '36130618',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3423',
                                                                                       'out_octets': '106071734827',
                                                                                       'out_ucast_pkts': '90461016',
                                                                                       'poller_hash': 'QURUTjIzMTQ0N0FDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:87:20'],
                                                                                       'in_nucast_pkts': '17355',
                                                                                       'in_octets': '13123606756',
                                                                                       'in_ucast_pkts': '69752375',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '290532092288',
                                                                                       'out_ucast_pkts': '204848809',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NjlFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:3e:d0'],
                                                                                       'in_nucast_pkts': '87861',
                                                                                       'in_octets': '47614043797',
                                                                                       'in_ucast_pkts': '200344149',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2878',
                                                                                       'out_octets': '609293328531',
                                                                                       'out_ucast_pkts': '439693210',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTM1IHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/10',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8xMA==',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/10',
                                                                                      'id': 'xgspon '
                                                                                            '0/10',
                                                                                      'links': [       {       'connected_time': '511515',
                                                                                                               'fiber_length': 5677,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDY4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '511514',
                                                                                                               'fiber_length': 6613,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTE4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '3449060',
                                                                                                               'fiber_length': 6229,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDU1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '3449056',
                                                                                                               'fiber_length': 5972,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NjUwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '721987',
                                                                                                               'fiber_length': 5554,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDIwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '5440106',
                                                                                                               'fiber_length': 6288,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDdFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '511514',
                                                                                                               'fiber_length': 5688,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REIyIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '511514',
                                                                                                               'fiber_length': 5757,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTI5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '511510',
                                                                                                               'fiber_length': 5845,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MUQwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '511514',
                                                                                                               'fiber_length': 6895,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REJDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '511513',
                                                                                                               'fiber_length': 5938,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTJCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '1620457',
                                                                                                               'fiber_length': 7112,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTdGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '511513',
                                                                                                               'fiber_length': 6916,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTVCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '511511',
                                                                                                               'fiber_length': 6439,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MUIxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '3449058',
                                                                                                               'fiber_length': 6277,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RThBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '3449060',
                                                                                                               'fiber_length': 6171,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDY1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '511511',
                                                                                                               'fiber_length': 6505,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRTlEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '511510',
                                                                                                               'fiber_length': 6490,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTMzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '3449061',
                                                                                                               'fiber_length': 6584,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTQzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '511515',
                                                                                                               'fiber_length': 6819,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NDkxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '3449060',
                                                                                                               'fiber_length': 6776,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTBCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '3449059',
                                                                                                               'fiber_length': 5964,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0OEQ1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '5440103',
                                                                                                               'fiber_length': 7783,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTg2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '1193288',
                                                                                                               'fiber_length': 6748,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0N0FDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '511513',
                                                                                                               'fiber_length': 6818,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NjlFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659},
                                                                                                       {       'connected_time': '2588442',
                                                                                                               'fiber_length': 6346,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTM1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.659}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/10',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8xMA==',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/11',
                                                              'links': [       {       'bridged_mac_addresses': [       '38:f8:f6:52:af:10'],
                                                                                       'in_nucast_pkts': '17492',
                                                                                       'in_octets': '5143788698',
                                                                                       'in_ucast_pkts': '12155920',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '52724693825',
                                                                                       'out_ucast_pkts': '41538448',
                                                                                       'poller_hash': 'QURUTjIzMTI0RjJEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:79:10'],
                                                                                       'in_nucast_pkts': '17767',
                                                                                       'in_octets': '19444386289',
                                                                                       'in_ucast_pkts': '36348646',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '144731181340',
                                                                                       'out_ucast_pkts': '110500290',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDI2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:68:90'],
                                                                                       'in_nucast_pkts': '17343',
                                                                                       'in_octets': '6881121985',
                                                                                       'in_ucast_pkts': '10791436',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '27921309796',
                                                                                       'out_ucast_pkts': '20288820',
                                                                                       'poller_hash': 'QURUTjIzMTIzRjU3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8b:b0'],
                                                                                       'in_nucast_pkts': '17777',
                                                                                       'in_octets': '19955393626',
                                                                                       'in_ucast_pkts': '80533969',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '296743546858',
                                                                                       'out_ucast_pkts': '220008288',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDg4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:6b:c0'],
                                                                                       'in_nucast_pkts': '17343',
                                                                                       'in_octets': '7546768448',
                                                                                       'in_ucast_pkts': '13490279',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '32999075131',
                                                                                       'out_ucast_pkts': '28090751',
                                                                                       'poller_hash': 'QURUTjIzMTI0RjE0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:89:00'],
                                                                                       'in_nucast_pkts': '17771',
                                                                                       'in_octets': '14552608567',
                                                                                       'in_ucast_pkts': '55071587',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '118612809491',
                                                                                       'out_ucast_pkts': '93178460',
                                                                                       'poller_hash': 'QURUTjIzMTI0RjM3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:65:60'],
                                                                                       'in_nucast_pkts': '17346',
                                                                                       'in_octets': '37249983009',
                                                                                       'in_ucast_pkts': '59033750',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '215519017972',
                                                                                       'out_ucast_pkts': '168055395',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTYxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:48:80'],
                                                                                       'in_nucast_pkts': '31563',
                                                                                       'in_octets': '33193181638',
                                                                                       'in_ucast_pkts': '112223303',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1053',
                                                                                       'out_octets': '458897956956',
                                                                                       'out_ucast_pkts': '325661781',
                                                                                       'poller_hash': 'QURUTjIzMTI0REEwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:02:b0'],
                                                                                       'in_nucast_pkts': '17346',
                                                                                       'in_octets': '2257714498',
                                                                                       'in_ucast_pkts': '10560616',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '36643183297',
                                                                                       'out_ucast_pkts': '27915703',
                                                                                       'poller_hash': 'QURUTjIzMTI1MEZFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:09:70'],
                                                                                       'in_nucast_pkts': '32302',
                                                                                       'in_octets': '15455041408',
                                                                                       'in_ucast_pkts': '68701404',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2719',
                                                                                       'out_octets': '311664606418',
                                                                                       'out_ucast_pkts': '223820942',
                                                                                       'poller_hash': 'QURUTjIzMTI1MEMwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:08:40'],
                                                                                       'in_nucast_pkts': '32074',
                                                                                       'in_octets': '15119379583',
                                                                                       'in_ucast_pkts': '98696275',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2713',
                                                                                       'out_octets': '354591641228',
                                                                                       'out_ucast_pkts': '250169385',
                                                                                       'poller_hash': 'QURUTjIzMTI1MEJGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:65:70'],
                                                                                       'in_nucast_pkts': '17349',
                                                                                       'in_octets': '6949689103',
                                                                                       'in_ucast_pkts': '30596842',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '154299720484',
                                                                                       'out_ucast_pkts': '111934773',
                                                                                       'poller_hash': 'QURUTjIzMTIzRUMwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:65:d0'],
                                                                                       'in_nucast_pkts': '32073',
                                                                                       'in_octets': '9337586634',
                                                                                       'in_ucast_pkts': '22417412',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2713',
                                                                                       'out_octets': '47856079004',
                                                                                       'out_ucast_pkts': '45368420',
                                                                                       'poller_hash': 'QURUTjIzMTIzRkVFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:b1:50'],
                                                                                       'in_nucast_pkts': '115000',
                                                                                       'in_octets': '66411983841',
                                                                                       'in_ucast_pkts': '250512278',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3835',
                                                                                       'out_octets': '1423739286835',
                                                                                       'out_ucast_pkts': '1044417982',
                                                                                       'poller_hash': 'QURUTjIzMTIzRkU5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:f5:40'],
                                                                                       'in_nucast_pkts': '114799',
                                                                                       'in_octets': '57045873988',
                                                                                       'in_ucast_pkts': '337607038',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3828',
                                                                                       'out_octets': '1524879113596',
                                                                                       'out_ucast_pkts': '1180391737',
                                                                                       'poller_hash': 'QURUTjIzMTI1MEQxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:89:30'],
                                                                                       'in_nucast_pkts': '17378',
                                                                                       'in_octets': '53122213483',
                                                                                       'in_ucast_pkts': '167810645',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1469',
                                                                                       'out_octets': '420548488076',
                                                                                       'out_ucast_pkts': '318233832',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NkNFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:37:10'],
                                                                                       'in_nucast_pkts': '32089',
                                                                                       'in_octets': '11857620441',
                                                                                       'in_ucast_pkts': '43266679',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2715',
                                                                                       'out_octets': '364213727415',
                                                                                       'out_ucast_pkts': '253032203',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RERGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:0c:40'],
                                                                                       'in_nucast_pkts': '17772',
                                                                                       'in_octets': '17672935333',
                                                                                       'in_ucast_pkts': '33715104',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '74712486667',
                                                                                       'out_ucast_pkts': '61735837',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RDUwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:3c:20'],
                                                                                       'in_nucast_pkts': '17356',
                                                                                       'in_octets': '7171049590',
                                                                                       'in_ucast_pkts': '46866609',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '260566772494',
                                                                                       'out_ucast_pkts': '186045618',
                                                                                       'poller_hash': 'QURUTjIzMTI0QzczIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:39:50'],
                                                                                       'in_nucast_pkts': '25782',
                                                                                       'in_octets': '37542868176',
                                                                                       'in_ucast_pkts': '76101459',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '849',
                                                                                       'out_octets': '149492399337',
                                                                                       'out_ucast_pkts': '149742341',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RURGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:97:70'],
                                                                                       'in_nucast_pkts': '17346',
                                                                                       'in_octets': '6349422540',
                                                                                       'in_ucast_pkts': '27790797',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '121891202937',
                                                                                       'out_ucast_pkts': '95008852',
                                                                                       'poller_hash': 'QURUTjIzMTQ0MjhBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:ae:70'],
                                                                                       'in_nucast_pkts': '116608',
                                                                                       'in_octets': '51659450960',
                                                                                       'in_ucast_pkts': '382203301',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3831',
                                                                                       'out_octets': '1410544228418',
                                                                                       'out_ucast_pkts': '992370722',
                                                                                       'poller_hash': 'QURUTjIzMTI0MUEyIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:9b:50'],
                                                                                       'in_nucast_pkts': '17496',
                                                                                       'in_octets': '57766222085',
                                                                                       'in_ucast_pkts': '69006479',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '153363791304',
                                                                                       'out_ucast_pkts': '125730792',
                                                                                       'poller_hash': 'QURUTjI0NDkxN0E0IHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/11',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8xMQ==',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/11',
                                                                                      'id': 'xgspon '
                                                                                            '0/11',
                                                                                      'links': [       {       'connected_time': '511502',
                                                                                                               'fiber_length': 4645,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RjJEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '511502',
                                                                                                               'fiber_length': 4747,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDI2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '511503',
                                                                                                               'fiber_length': 4661,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRjU3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '511502',
                                                                                                               'fiber_length': 4852,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDg4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '511503',
                                                                                                               'fiber_length': 7344,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RjE0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '511499',
                                                                                                               'fiber_length': 7364,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RjM3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '511503',
                                                                                                               'fiber_length': 5086,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTYxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '946254',
                                                                                                               'fiber_length': 8008,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REEwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '511500',
                                                                                                               'fiber_length': 4938,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MEZFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '946258',
                                                                                                               'fiber_length': 8251,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MEMwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '946255',
                                                                                                               'fiber_length': 8000,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MEJGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '511499',
                                                                                                               'fiber_length': 4770,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRUMwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '946255',
                                                                                                               'fiber_length': 8343,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRkVFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '3449049',
                                                                                                               'fiber_length': 8068,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRkU5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '3449048',
                                                                                                               'fiber_length': 8127,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MEQxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '511501',
                                                                                                               'fiber_length': 7294,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NkNFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '946257',
                                                                                                               'fiber_length': 8094,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RERGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '511501',
                                                                                                               'fiber_length': 7706,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RDUwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '511499',
                                                                                                               'fiber_length': 4666,
                                                                                                               'poller_hash': 'QURUTjIzMTI0QzczIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '762405',
                                                                                                               'fiber_length': 8136,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RURGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '511501',
                                                                                                               'fiber_length': 7421,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0MjhBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '3449046',
                                                                                                               'fiber_length': 8116,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MUEyIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913},
                                                                                                       {       'connected_time': '511506',
                                                                                                               'fiber_length': 4703,
                                                                                                               'poller_hash': 'QURUTjI0NDkxN0E0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4913}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/11',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8xMQ==',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/12',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:dd:78:e0'],
                                                                                       'in_nucast_pkts': '17345',
                                                                                       'in_octets': '13570085705',
                                                                                       'in_ucast_pkts': '46186668',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '166640051211',
                                                                                       'out_ucast_pkts': '149119825',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTY2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:75:70'],
                                                                                       'in_nucast_pkts': '13736',
                                                                                       'in_octets': '6225522635',
                                                                                       'in_ucast_pkts': '24138193',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '84342536497',
                                                                                       'out_ucast_pkts': '63254582',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTkwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8a:40'],
                                                                                       'in_nucast_pkts': '17347',
                                                                                       'in_octets': '5943079236',
                                                                                       'in_ucast_pkts': '24328987',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '170208238795',
                                                                                       'out_ucast_pkts': '125604721',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTQwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:7c:f0'],
                                                                                       'in_nucast_pkts': '17774',
                                                                                       'in_octets': '2445008553',
                                                                                       'in_ucast_pkts': '17998019',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '87124072293',
                                                                                       'out_ucast_pkts': '62663530',
                                                                                       'poller_hash': 'QURUTjIzMTI0RUQ5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:70:a0'],
                                                                                       'in_nucast_pkts': '184357',
                                                                                       'in_octets': '261894506093',
                                                                                       'in_ucast_pkts': '730736385',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15616',
                                                                                       'out_octets': '2036903540767',
                                                                                       'out_ucast_pkts': '1780740679',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTNFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:56:40'],
                                                                                       'in_nucast_pkts': '13959',
                                                                                       'in_octets': '21097991933',
                                                                                       'in_ucast_pkts': '51157611',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1182',
                                                                                       'out_octets': '245583176080',
                                                                                       'out_ucast_pkts': '187777485',
                                                                                       'poller_hash': 'QURUTjIzMTI1MUVCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:76:40'],
                                                                                       'in_nucast_pkts': '13960',
                                                                                       'in_octets': '4994513603',
                                                                                       'in_ucast_pkts': '13310420',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1182',
                                                                                       'out_octets': '44519148743',
                                                                                       'out_ucast_pkts': '38135069',
                                                                                       'poller_hash': 'QURUTjIzMTI0REU0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:7e:00'],
                                                                                       'in_nucast_pkts': '17344',
                                                                                       'in_octets': '71894337987',
                                                                                       'in_ucast_pkts': '116007144',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '261076709092',
                                                                                       'out_ucast_pkts': '208646296',
                                                                                       'poller_hash': 'QURUTjIzMTI0REIwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ac:20'],
                                                                                       'in_nucast_pkts': '17071',
                                                                                       'in_octets': '6657479764',
                                                                                       'in_ucast_pkts': '31241128',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '275313555690',
                                                                                       'out_ucast_pkts': '201361428',
                                                                                       'poller_hash': 'QURUTjIzMTI0RjM0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ab:30'],
                                                                                       'in_nucast_pkts': '14078',
                                                                                       'in_octets': '11207439649',
                                                                                       'in_ucast_pkts': '31634032',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '156037674829',
                                                                                       'out_ucast_pkts': '115883166',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTU3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ac:e0'],
                                                                                       'in_nucast_pkts': '17068',
                                                                                       'in_octets': '23508181967',
                                                                                       'in_ucast_pkts': '34230325',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '117692129423',
                                                                                       'out_ucast_pkts': '93226952',
                                                                                       'poller_hash': 'QURUTjIzMTIzRUI3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:6e:40'],
                                                                                       'in_nucast_pkts': '17767',
                                                                                       'in_octets': '5155013968',
                                                                                       'in_ucast_pkts': '34663408',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '210018721979',
                                                                                       'out_ucast_pkts': '145411454',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTM3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8f:b0'],
                                                                                       'in_nucast_pkts': '17662',
                                                                                       'in_octets': '27987474147',
                                                                                       'in_ucast_pkts': '114204034',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1465',
                                                                                       'out_octets': '429942845377',
                                                                                       'out_ucast_pkts': '308714554',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTRCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:52:10'],
                                                                                       'in_nucast_pkts': '13738',
                                                                                       'in_octets': '8150070916',
                                                                                       'in_ucast_pkts': '24703195',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '154412345995',
                                                                                       'out_ucast_pkts': '110311064',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTczIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:7d:70'],
                                                                                       'in_nucast_pkts': '17347',
                                                                                       'in_octets': '7152861603',
                                                                                       'in_ucast_pkts': '27555356',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '108732896514',
                                                                                       'out_ucast_pkts': '79082535',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTE3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:6c:b0'],
                                                                                       'in_nucast_pkts': '17771',
                                                                                       'in_octets': '9693079177',
                                                                                       'in_ucast_pkts': '67618894',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '287715030573',
                                                                                       'out_ucast_pkts': '201871393',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTJDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:77:30'],
                                                                                       'in_nucast_pkts': '17343',
                                                                                       'in_octets': '4519727774',
                                                                                       'in_ucast_pkts': '20018006',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '92169783415',
                                                                                       'out_ucast_pkts': '67778587',
                                                                                       'poller_hash': 'QURUTjIzMTIzRUExIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:76:40'],
                                                                                       'in_nucast_pkts': '17344',
                                                                                       'in_octets': '33003402586',
                                                                                       'in_ucast_pkts': '86853826',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '322535900258',
                                                                                       'out_ucast_pkts': '233738809',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTMzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:a3:c0'],
                                                                                       'in_nucast_pkts': '17075',
                                                                                       'in_octets': '38171933287',
                                                                                       'in_ucast_pkts': '91083116',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '333219784794',
                                                                                       'out_ucast_pkts': '239709601',
                                                                                       'poller_hash': 'QURUTjIzMTI1MUFCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:0b:60'],
                                                                                       'in_nucast_pkts': '14266',
                                                                                       'in_octets': '60905332',
                                                                                       'in_ucast_pkts': '220207',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1182',
                                                                                       'out_octets': '186254722',
                                                                                       'out_ucast_pkts': '254635',
                                                                                       'poller_hash': 'QURUTjIzMTI0MzA0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:87:b0'],
                                                                                       'in_nucast_pkts': '17069',
                                                                                       'in_octets': '5704883251',
                                                                                       'in_ucast_pkts': '7721731',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '11207396635',
                                                                                       'out_ucast_pkts': '10837380',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTRDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:89:60'],
                                                                                       'in_nucast_pkts': '17347',
                                                                                       'in_octets': '4868512344',
                                                                                       'in_ucast_pkts': '51003832',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '154865189855',
                                                                                       'out_ucast_pkts': '104664563',
                                                                                       'poller_hash': 'QURUTjIzMTIzRkM0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:77:10'],
                                                                                       'in_nucast_pkts': '17355',
                                                                                       'in_octets': '3985209650',
                                                                                       'in_ucast_pkts': '3739148',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '3947279049',
                                                                                       'out_ucast_pkts': '3942003',
                                                                                       'poller_hash': 'QURUTjIzMTI1MEMzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:58:40'],
                                                                                       'in_nucast_pkts': '182787',
                                                                                       'in_octets': '122285030297',
                                                                                       'in_ucast_pkts': '286802952',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6048',
                                                                                       'out_octets': '958305135954',
                                                                                       'out_ucast_pkts': '731293813',
                                                                                       'poller_hash': 'QURUTjIzMTQ0N0E1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8a:80'],
                                                                                       'in_nucast_pkts': '17346',
                                                                                       'in_octets': '2305401881',
                                                                                       'in_ucast_pkts': '8993831',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '26549022939',
                                                                                       'out_ucast_pkts': '21176507',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NzdBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:0a:00'],
                                                                                       'in_nucast_pkts': '33987',
                                                                                       'in_octets': '35230512504',
                                                                                       'in_ucast_pkts': '35656386',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2877',
                                                                                       'out_octets': '15607170836',
                                                                                       'out_ucast_pkts': '18811292',
                                                                                       'poller_hash': 'QURUTjIzMTQ0ODBEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:b3:a0'],
                                                                                       'in_nucast_pkts': '17347',
                                                                                       'in_octets': '18278042675',
                                                                                       'in_ucast_pkts': '39931214',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '187321586366',
                                                                                       'out_ucast_pkts': '136018147',
                                                                                       'poller_hash': 'QURUTjIzMTQ0N0FCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:89:30'],
                                                                                       'in_nucast_pkts': '17676',
                                                                                       'in_octets': '174845768581',
                                                                                       'in_ucast_pkts': '251770340',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '606185853600',
                                                                                       'out_ucast_pkts': '484055879',
                                                                                       'poller_hash': 'QURUTjIzMTQ0N0YzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:7b:50'],
                                                                                       'in_nucast_pkts': '17435',
                                                                                       'in_octets': '18736611599',
                                                                                       'in_ucast_pkts': '29611412',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '569',
                                                                                       'out_octets': '70520406471',
                                                                                       'out_ucast_pkts': '60883818',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RUQyIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:42:00'],
                                                                                       'in_nucast_pkts': '13735',
                                                                                       'in_octets': '5787604886',
                                                                                       'in_ucast_pkts': '50188010',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '140051627721',
                                                                                       'out_ucast_pkts': '98055630',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDZDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:6a:d0'],
                                                                                       'in_nucast_pkts': '17073',
                                                                                       'in_octets': '5040846635',
                                                                                       'in_ucast_pkts': '18204867',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '29200136912',
                                                                                       'out_ucast_pkts': '21341048',
                                                                                       'poller_hash': 'QURUTjI0MzYzRDREIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:aa:e1'],
                                                                                       'in_nucast_pkts': '307',
                                                                                       'in_octets': '12297137773',
                                                                                       'in_ucast_pkts': '74863842',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '254976806134',
                                                                                       'out_ucast_pkts': '187481803',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QjIwIHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/12',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8xMg==',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/12',
                                                                                      'id': 'xgspon '
                                                                                            '0/12',
                                                                                      'links': [       {       'connected_time': '511499',
                                                                                                               'fiber_length': 5195,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTY2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '411498',
                                                                                                               'fiber_length': 6895,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTkwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511500',
                                                                                                               'fiber_length': 5726,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTQwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511500',
                                                                                                               'fiber_length': 5679,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RUQ5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '5440063',
                                                                                                               'fiber_length': 5805,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTNFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '411498',
                                                                                                               'fiber_length': 6685,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MUVCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '411500',
                                                                                                               'fiber_length': 6822,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REU0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511498',
                                                                                                               'fiber_length': 5405,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REIwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511501',
                                                                                                               'fiber_length': 5229,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RjM0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '411499',
                                                                                                               'fiber_length': 6531,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTU3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511504',
                                                                                                               'fiber_length': 3552,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRUI3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511500',
                                                                                                               'fiber_length': 5276,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTM3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511495',
                                                                                                               'fiber_length': 5187,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTRCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '411498',
                                                                                                               'fiber_length': 4886,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTczIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511501',
                                                                                                               'fiber_length': 4322,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTE3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511500',
                                                                                                               'fiber_length': 5460,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTJDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511502',
                                                                                                               'fiber_length': 3586,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRUExIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511499',
                                                                                                               'fiber_length': 3613,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTMzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511499',
                                                                                                               'fiber_length': 5452,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MUFCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '411499',
                                                                                                               'fiber_length': 4895,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MzA0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511499',
                                                                                                               'fiber_length': 5052,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTRDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511501',
                                                                                                               'fiber_length': 3515,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRkM0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511504',
                                                                                                               'fiber_length': 3450,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MEMzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '5440060',
                                                                                                               'fiber_length': 4061,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0N0E1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511499',
                                                                                                               'fiber_length': 3993,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NzdBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '1002979',
                                                                                                               'fiber_length': 4007,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0ODBEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511498',
                                                                                                               'fiber_length': 4238,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0N0FCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511504',
                                                                                                               'fiber_length': 4128,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0N0YzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '508250',
                                                                                                               'fiber_length': 4439,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RUQyIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '411498',
                                                                                                               'fiber_length': 6899,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDZDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511510',
                                                                                                               'fiber_length': 3928,
                                                                                                               'poller_hash': 'QURUTjI0MzYzRDREIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135},
                                                                                                       {       'connected_time': '511504',
                                                                                                               'fiber_length': 5562,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QjIwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4135}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/12',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8xMg==',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/13',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:dd:84:00'],
                                                                                       'in_nucast_pkts': '14301',
                                                                                       'in_octets': '23521366774',
                                                                                       'in_ucast_pkts': '40895445',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1182',
                                                                                       'out_octets': '91736619845',
                                                                                       'out_ucast_pkts': '75806891',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTcxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:6e:f0'],
                                                                                       'in_nucast_pkts': '14301',
                                                                                       'in_octets': '4925425766',
                                                                                       'in_ucast_pkts': '26949352',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1182',
                                                                                       'out_octets': '166267130463',
                                                                                       'out_ucast_pkts': '116451702',
                                                                                       'poller_hash': 'QURUTjIzMTI0RERBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8e:50'],
                                                                                       'in_nucast_pkts': '14301',
                                                                                       'in_octets': '5965607609',
                                                                                       'in_ucast_pkts': '18743666',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1182',
                                                                                       'out_octets': '83538905826',
                                                                                       'out_ucast_pkts': '65251732',
                                                                                       'poller_hash': 'QURUTjIzMTI0REUwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ac:b0'],
                                                                                       'in_nucast_pkts': '13739',
                                                                                       'in_octets': '15227797031',
                                                                                       'in_ucast_pkts': '76341628',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '336060770122',
                                                                                       'out_ucast_pkts': '237694633',
                                                                                       'poller_hash': 'QURUTjIzMTI0REY2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:01:50'],
                                                                                       'in_nucast_pkts': '13739',
                                                                                       'in_octets': '545655781',
                                                                                       'in_ucast_pkts': '1123435',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '391776268',
                                                                                       'out_ucast_pkts': '722858',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTA0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:79:70'],
                                                                                       'in_nucast_pkts': '13956',
                                                                                       'in_octets': '8809687008',
                                                                                       'in_ucast_pkts': '24162714',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1182',
                                                                                       'out_octets': '57389462190',
                                                                                       'out_ucast_pkts': '46911227',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTMwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a6:80'],
                                                                                       'in_nucast_pkts': '13879',
                                                                                       'in_octets': '13903633169',
                                                                                       'in_ucast_pkts': '78829773',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '399712886520',
                                                                                       'out_ucast_pkts': '286849218',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTkyIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:6d:50'],
                                                                                       'in_nucast_pkts': '13955',
                                                                                       'in_octets': '2548805306',
                                                                                       'in_ucast_pkts': '16585756',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1182',
                                                                                       'out_octets': '67292117686',
                                                                                       'out_ucast_pkts': '49198748',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTg2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:81:b0'],
                                                                                       'in_nucast_pkts': '13739',
                                                                                       'in_octets': '42012549892',
                                                                                       'in_ucast_pkts': '61902384',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '291478069020',
                                                                                       'out_ucast_pkts': '212080804',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTk0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8a:e0'],
                                                                                       'in_nucast_pkts': '14289',
                                                                                       'in_octets': '2854488104',
                                                                                       'in_ucast_pkts': '9495644',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1182',
                                                                                       'out_octets': '40971690775',
                                                                                       'out_ucast_pkts': '29089697',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTRFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a8:00'],
                                                                                       'in_nucast_pkts': '14078',
                                                                                       'in_octets': '19069866624',
                                                                                       'in_ucast_pkts': '46572371',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '267524211604',
                                                                                       'out_ucast_pkts': '205567921',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NkI4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:6a:80'],
                                                                                       'in_nucast_pkts': '184398',
                                                                                       'in_octets': '152252613088',
                                                                                       'in_ucast_pkts': '614225179',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15623',
                                                                                       'out_octets': '2157383541720',
                                                                                       'out_ucast_pkts': '1604677636',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NkNCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:9a:d0'],
                                                                                       'in_nucast_pkts': '181358',
                                                                                       'in_octets': '144437797488',
                                                                                       'in_ucast_pkts': '1022860980',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6045',
                                                                                       'out_octets': '4872132831389',
                                                                                       'out_ucast_pkts': '3478110433',
                                                                                       'poller_hash': 'QURUTjIzMTQ0ODYxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:6e:b0'],
                                                                                       'in_nucast_pkts': '14079',
                                                                                       'in_octets': '3578998606',
                                                                                       'in_ucast_pkts': '25157851',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '92781727659',
                                                                                       'out_ucast_pkts': '65792280',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTE1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:55:80'],
                                                                                       'in_nucast_pkts': '13740',
                                                                                       'in_octets': '7157217416',
                                                                                       'in_ucast_pkts': '14080599',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '62900310056',
                                                                                       'out_ucast_pkts': '46212700',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QkY3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:02:90'],
                                                                                       'in_nucast_pkts': '14078',
                                                                                       'in_octets': '1317198415',
                                                                                       'in_ucast_pkts': '5401632',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '14367286856',
                                                                                       'out_ucast_pkts': '11234680',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTVCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:62:10'],
                                                                                       'in_nucast_pkts': '17070',
                                                                                       'in_octets': '6446512919',
                                                                                       'in_ucast_pkts': '9277120',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '25774365898',
                                                                                       'out_ucast_pkts': '22077595',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QzhCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:b6:c0'],
                                                                                       'in_nucast_pkts': '13739',
                                                                                       'in_octets': '3138746474',
                                                                                       'in_ucast_pkts': '11181202',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '56765714029',
                                                                                       'out_ucast_pkts': '41327644',
                                                                                       'poller_hash': 'QURUTjI0MzYzQkJBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:81:80'],
                                                                                       'in_nucast_pkts': '13960',
                                                                                       'in_octets': '2291465599',
                                                                                       'in_ucast_pkts': '10180171',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1182',
                                                                                       'out_octets': '27268442391',
                                                                                       'out_ucast_pkts': '21783386',
                                                                                       'poller_hash': 'QURUTjI0MzE0MUFDIHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/13',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8xMw==',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/13',
                                                                                      'id': 'xgspon '
                                                                                            '0/13',
                                                                                      'links': [       {       'connected_time': '411496',
                                                                                                               'fiber_length': 8742,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTcxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5691},
                                                                                                       {       'connected_time': '411500',
                                                                                                               'fiber_length': 8706,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RERBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5691},
                                                                                                       {       'connected_time': '411497',
                                                                                                               'fiber_length': 8348,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REUwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5691},
                                                                                                       {       'connected_time': '411500',
                                                                                                               'fiber_length': 8325,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REY2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5691},
                                                                                                       {       'connected_time': '411499',
                                                                                                               'fiber_length': 8705,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTA0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5691},
                                                                                                       {       'connected_time': '411496',
                                                                                                               'fiber_length': 8651,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTMwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5691},
                                                                                                       {       'connected_time': '411499',
                                                                                                               'fiber_length': 8747,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTkyIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5691},
                                                                                                       {       'connected_time': '411499',
                                                                                                               'fiber_length': 8737,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTg2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5691},
                                                                                                       {       'connected_time': '411493',
                                                                                                               'fiber_length': 9481,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTk0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5691},
                                                                                                       {       'connected_time': '411499',
                                                                                                               'fiber_length': 8614,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTRFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5691},
                                                                                                       {       'connected_time': '411498',
                                                                                                               'fiber_length': 9457,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NkI4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5691},
                                                                                                       {       'connected_time': '5440093',
                                                                                                               'fiber_length': 8828,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NkNCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5691},
                                                                                                       {       'connected_time': '5440092',
                                                                                                               'fiber_length': 8370,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0ODYxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5691},
                                                                                                       {       'connected_time': '411495',
                                                                                                               'fiber_length': 7986,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTE1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5691},
                                                                                                       {       'connected_time': '411498',
                                                                                                               'fiber_length': 8538,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QkY3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5691},
                                                                                                       {       'connected_time': '411499',
                                                                                                               'fiber_length': 8775,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTVCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5691},
                                                                                                       {       'connected_time': '511505',
                                                                                                               'fiber_length': 8911,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QzhCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5691},
                                                                                                       {       'connected_time': '411503',
                                                                                                               'fiber_length': 8469,
                                                                                                               'poller_hash': 'QURUTjI0MzYzQkJBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5691},
                                                                                                       {       'connected_time': '411503',
                                                                                                               'fiber_length': 9546,
                                                                                                               'poller_hash': 'QURUTjI0MzE0MUFDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5691}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/13',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8xMw==',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/14',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:d6:0a:70'],
                                                                                       'in_nucast_pkts': '13959',
                                                                                       'in_octets': '13239955667',
                                                                                       'in_ucast_pkts': '90565957',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1182',
                                                                                       'out_octets': '454831495229',
                                                                                       'out_ucast_pkts': '310897979',
                                                                                       'poller_hash': 'QURUTjIzMTI0MzJFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:07:e0'],
                                                                                       'in_nucast_pkts': '17345',
                                                                                       'in_octets': '7099641883',
                                                                                       'in_ucast_pkts': '60506241',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '149997063454',
                                                                                       'out_ucast_pkts': '111038622',
                                                                                       'poller_hash': 'QURUTjIzMTI0ODQ5IHBlZXJpbnRm'},
                                                                               {       'in_nucast_pkts': '380493',
                                                                                       'in_octets': '117104594',
                                                                                       'in_ucast_pkts': '0',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '0',
                                                                                       'out_ucast_pkts': '0',
                                                                                       'poller_hash': 'QURUTjIzMTI1MEM2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:03:f0'],
                                                                                       'in_nucast_pkts': '13741',
                                                                                       'in_octets': '14008554476',
                                                                                       'in_ucast_pkts': '40711560',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '109204659528',
                                                                                       'out_ucast_pkts': '84841729',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTVBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:38:f0'],
                                                                                       'in_nucast_pkts': '13433',
                                                                                       'in_octets': '7408149367',
                                                                                       'in_ucast_pkts': '37311232',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1108',
                                                                                       'out_octets': '127573221452',
                                                                                       'out_ucast_pkts': '92544293',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTUzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:34:50'],
                                                                                       'in_nucast_pkts': '13963',
                                                                                       'in_octets': '8590335792',
                                                                                       'in_ucast_pkts': '49772757',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1182',
                                                                                       'out_octets': '279308620557',
                                                                                       'out_ucast_pkts': '191253374',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTg0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:00:f0'],
                                                                                       'in_nucast_pkts': '13738',
                                                                                       'in_octets': '4460347522',
                                                                                       'in_ucast_pkts': '17508885',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '79367287959',
                                                                                       'out_ucast_pkts': '57326821',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTVDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:3f:10'],
                                                                                       'in_nucast_pkts': '17069',
                                                                                       'in_octets': '5898394823',
                                                                                       'in_ucast_pkts': '22128245',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '92783601530',
                                                                                       'out_ucast_pkts': '65414083',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RDk5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:63:f0'],
                                                                                       'in_nucast_pkts': '13737',
                                                                                       'in_octets': '8181387735',
                                                                                       'in_ucast_pkts': '17123621',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '105546938363',
                                                                                       'out_ucast_pkts': '77495536',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QjNGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:31:10'],
                                                                                       'in_nucast_pkts': '13740',
                                                                                       'in_octets': '14872244755',
                                                                                       'in_ucast_pkts': '66466167',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '278553882577',
                                                                                       'out_ucast_pkts': '195340506',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QjVFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:21:80'],
                                                                                       'in_nucast_pkts': '13738',
                                                                                       'in_octets': '5679942087',
                                                                                       'in_ucast_pkts': '27282218',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '160675401445',
                                                                                       'out_ucast_pkts': '123185468',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTlCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a1:70'],
                                                                                       'in_nucast_pkts': '13771',
                                                                                       'in_octets': '9428401483',
                                                                                       'in_ucast_pkts': '20053837',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '460',
                                                                                       'out_octets': '84235522516',
                                                                                       'out_ucast_pkts': '66454311',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QUNGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ac:30'],
                                                                                       'in_nucast_pkts': '17095',
                                                                                       'in_octets': '70748521978',
                                                                                       'in_ucast_pkts': '73321371',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '571',
                                                                                       'out_octets': '77868860229',
                                                                                       'out_ucast_pkts': '64782879',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDM3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:ef:c0'],
                                                                                       'in_nucast_pkts': '13737',
                                                                                       'in_octets': '4536473801',
                                                                                       'in_ucast_pkts': '13816992',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '72110420027',
                                                                                       'out_ucast_pkts': '51855448',
                                                                                       'poller_hash': 'QURUTjIzMTI0QjdFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:37:30'],
                                                                                       'in_nucast_pkts': '13737',
                                                                                       'in_octets': '13904986517',
                                                                                       'in_ucast_pkts': '44885617',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '182674651329',
                                                                                       'out_ucast_pkts': '136382090',
                                                                                       'poller_hash': 'QURUTjIzMTI0OTY2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:b1:30'],
                                                                                       'in_nucast_pkts': '13738',
                                                                                       'in_octets': '6350521169',
                                                                                       'in_ucast_pkts': '9334062',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '459',
                                                                                       'out_octets': '36665106028',
                                                                                       'out_ucast_pkts': '28912537',
                                                                                       'poller_hash': 'QURUTjI0MzYzREI5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:ba:f0'],
                                                                                       'in_nucast_pkts': '8180',
                                                                                       'in_octets': '18576547566',
                                                                                       'in_ucast_pkts': '55485289',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '268',
                                                                                       'out_octets': '163409177184',
                                                                                       'out_ucast_pkts': '128401759',
                                                                                       'poller_hash': 'QURUTjI1MTUyMUEyIHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/14',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8xNA==',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/14',
                                                                                      'id': 'xgspon '
                                                                                            '0/14',
                                                                                      'links': [       {       'connected_time': '411500',
                                                                                                               'fiber_length': 9068,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MzJFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4496},
                                                                                                       {       'connected_time': '511506',
                                                                                                               'fiber_length': 9154,
                                                                                                               'poller_hash': 'QURUTjIzMTI0ODQ5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4496},
                                                                                                       {       'connected_time': '411500',
                                                                                                               'fiber_length': 9038,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MEM2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4496},
                                                                                                       {       'connected_time': '411498',
                                                                                                               'fiber_length': 9303,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTVBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4496},
                                                                                                       {       'connected_time': '386516',
                                                                                                               'fiber_length': 9292,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTUzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4496},
                                                                                                       {       'connected_time': '411499',
                                                                                                               'fiber_length': 8903,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTg0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4496},
                                                                                                       {       'connected_time': '411500',
                                                                                                               'fiber_length': 9318,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTVDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4496},
                                                                                                       {       'connected_time': '511505',
                                                                                                               'fiber_length': 9196,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RDk5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4496},
                                                                                                       {       'connected_time': '411497',
                                                                                                               'fiber_length': 9156,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QjNGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4496},
                                                                                                       {       'connected_time': '411497',
                                                                                                               'fiber_length': 9074,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QjVFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4496},
                                                                                                       {       'connected_time': '411499',
                                                                                                               'fiber_length': 9481,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTlCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4496},
                                                                                                       {       'connected_time': '411497',
                                                                                                               'fiber_length': 9284,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QUNGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4496},
                                                                                                       {       'connected_time': '511504',
                                                                                                               'fiber_length': 9249,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDM3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4496},
                                                                                                       {       'connected_time': '411500',
                                                                                                               'fiber_length': 9207,
                                                                                                               'poller_hash': 'QURUTjIzMTI0QjdFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4496},
                                                                                                       {       'connected_time': '411500',
                                                                                                               'fiber_length': 9245,
                                                                                                               'poller_hash': 'QURUTjIzMTI0OTY2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4496},
                                                                                                       {       'connected_time': '411504',
                                                                                                               'fiber_length': 9079,
                                                                                                               'poller_hash': 'QURUTjI0MzYzREI5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4496},
                                                                                                       {       'connected_time': '238122',
                                                                                                               'fiber_length': 9416,
                                                                                                               'poller_hash': 'QURUTjI1MTUyMUEyIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4496}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/14',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8xNA==',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/15',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:d6:36:60'],
                                                                                       'in_nucast_pkts': '17345',
                                                                                       'in_octets': '27657546519',
                                                                                       'in_ucast_pkts': '50955624',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '136880871237',
                                                                                       'out_ucast_pkts': '103266280',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTUwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8d:b0'],
                                                                                       'in_nucast_pkts': '17781',
                                                                                       'in_octets': '1786217507',
                                                                                       'in_ucast_pkts': '3854069',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '28407662258',
                                                                                       'out_ucast_pkts': '19842664',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NzE0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:91:80'],
                                                                                       'in_nucast_pkts': '17349',
                                                                                       'in_octets': '505527167',
                                                                                       'in_ucast_pkts': '748493',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '1389952277',
                                                                                       'out_ucast_pkts': '1338405',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QzMzIHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/15',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8xNQ==',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/15',
                                                                                      'id': 'xgspon '
                                                                                            '0/15',
                                                                                      'links': [       {       'connected_time': '511506',
                                                                                                               'fiber_length': 1195,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTUwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.354},
                                                                                                       {       'connected_time': '511505',
                                                                                                               'fiber_length': 780,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NzE0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.354},
                                                                                                       {       'connected_time': '511505',
                                                                                                               'fiber_length': 539,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QzMzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.354}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/15',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8xNQ==',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/16',
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/16',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8xNg==',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/16',
                                                                                      'id': 'xgspon '
                                                                                            '0/16',
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/16',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8xNg==',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/2',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:dc:71:b0'],
                                                                                       'in_nucast_pkts': '17468',
                                                                                       'in_octets': '1991337600',
                                                                                       'in_ucast_pkts': '19911217',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '59145047964',
                                                                                       'out_ucast_pkts': '40137087',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDQxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:5d:e0'],
                                                                                       'in_nucast_pkts': '17340',
                                                                                       'in_octets': '1758382852',
                                                                                       'in_ucast_pkts': '6919707',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '31194916904',
                                                                                       'out_ucast_pkts': '22510192',
                                                                                       'poller_hash': 'QURUTjIzMTI0MEIwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:7e:90'],
                                                                                       'in_nucast_pkts': '17754',
                                                                                       'in_octets': '11748288735',
                                                                                       'in_ucast_pkts': '59006709',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '158629248942',
                                                                                       'out_ucast_pkts': '130598930',
                                                                                       'poller_hash': 'QURUTjIzMTI0REQ5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ad:c0'],
                                                                                       'in_nucast_pkts': '17128',
                                                                                       'in_octets': '12164965242',
                                                                                       'in_ucast_pkts': '54352699',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '173894020013',
                                                                                       'out_ucast_pkts': '132678844',
                                                                                       'poller_hash': 'QURUTjIzMTI0MUQxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:78:c0'],
                                                                                       'in_nucast_pkts': '17346',
                                                                                       'in_octets': '8328880127',
                                                                                       'in_ucast_pkts': '43387796',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '148958989222',
                                                                                       'out_ucast_pkts': '105207087',
                                                                                       'poller_hash': 'QURUTjIzMTI0RjNDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:77:70'],
                                                                                       'in_nucast_pkts': '17492',
                                                                                       'in_octets': '9017069532',
                                                                                       'in_ucast_pkts': '23865459',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '73342838858',
                                                                                       'out_ucast_pkts': '61095120',
                                                                                       'poller_hash': 'QURUTjIzMTI0REZDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:75:f0'],
                                                                                       'in_nucast_pkts': '17785',
                                                                                       'in_octets': '5986842931',
                                                                                       'in_ucast_pkts': '23664046',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1466',
                                                                                       'out_octets': '91673181754',
                                                                                       'out_ucast_pkts': '66103257',
                                                                                       'poller_hash': 'QURUTjIzMTI0RjMwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:91:b0'],
                                                                                       'in_nucast_pkts': '17348',
                                                                                       'in_octets': '15904022055',
                                                                                       'in_ucast_pkts': '42189853',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '114430149310',
                                                                                       'out_ucast_pkts': '95211145',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTQ2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4b:fa:80'],
                                                                                       'in_nucast_pkts': '77249',
                                                                                       'in_octets': '50957718414',
                                                                                       'in_ucast_pkts': '319700124',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2576',
                                                                                       'out_octets': '1204346775941',
                                                                                       'out_ucast_pkts': '845022783',
                                                                                       'poller_hash': 'QURUTjIzMTI0REI3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:6c:f0'],
                                                                                       'in_nucast_pkts': '77324',
                                                                                       'in_octets': '195543612937',
                                                                                       'in_ucast_pkts': '871541381',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2576',
                                                                                       'out_octets': '3617072709960',
                                                                                       'out_ucast_pkts': '2675239709',
                                                                                       'poller_hash': 'QURUTjIzMTI0OEE4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:08:f0'],
                                                                                       'in_nucast_pkts': '78522',
                                                                                       'in_octets': '29883348983',
                                                                                       'in_ucast_pkts': '165609852',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6648',
                                                                                       'out_octets': '593970879853',
                                                                                       'out_ucast_pkts': '422689492',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDlFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:00:60'],
                                                                                       'in_nucast_pkts': '80518',
                                                                                       'in_octets': '21490240212',
                                                                                       'in_ucast_pkts': '132756443',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6655',
                                                                                       'out_octets': '502414832140',
                                                                                       'out_ucast_pkts': '358664556',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTUwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:0b:a0'],
                                                                                       'in_nucast_pkts': '17335',
                                                                                       'in_octets': '5937602802',
                                                                                       'in_ucast_pkts': '26500273',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '98450751115',
                                                                                       'out_ucast_pkts': '73726980',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTFEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:77:60'],
                                                                                       'in_nucast_pkts': '79948',
                                                                                       'in_octets': '44008802832',
                                                                                       'in_ucast_pkts': '316733739',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6646',
                                                                                       'out_octets': '1441341370416',
                                                                                       'out_ucast_pkts': '988837617',
                                                                                       'poller_hash': 'QURUTjIzMTIzRUJDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:79:f0'],
                                                                                       'in_nucast_pkts': '17423',
                                                                                       'in_octets': '6462624002',
                                                                                       'in_ucast_pkts': '42174636',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '172648586399',
                                                                                       'out_ucast_pkts': '122316571',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTE2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4b:fa:60'],
                                                                                       'in_nucast_pkts': '78016',
                                                                                       'in_octets': '64001662950',
                                                                                       'in_ucast_pkts': '217080517',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2576',
                                                                                       'out_octets': '624482317804',
                                                                                       'out_ucast_pkts': '459967946',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTJGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:50:60'],
                                                                                       'in_nucast_pkts': '17490',
                                                                                       'in_octets': '9334372387',
                                                                                       'in_ucast_pkts': '31816728',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '184950235686',
                                                                                       'out_ucast_pkts': '139574894',
                                                                                       'poller_hash': 'QURUTjIzMTI1MEM4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:29:50'],
                                                                                       'in_nucast_pkts': '17342',
                                                                                       'in_octets': '12752149376',
                                                                                       'in_ucast_pkts': '123564297',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '378037658066',
                                                                                       'out_ucast_pkts': '258052921',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NzczIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:5b:70'],
                                                                                       'in_nucast_pkts': '17495',
                                                                                       'in_octets': '11301586522',
                                                                                       'in_ucast_pkts': '47241964',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '159092114439',
                                                                                       'out_ucast_pkts': '116924650',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NkMwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a8:40'],
                                                                                       'in_nucast_pkts': '17065',
                                                                                       'in_octets': '9987180858',
                                                                                       'in_ucast_pkts': '48716005',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '162591640679',
                                                                                       'out_ucast_pkts': '118790606',
                                                                                       'poller_hash': 'QURUTjIzMTQ0OTE2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:7e:b0'],
                                                                                       'in_nucast_pkts': '17771',
                                                                                       'in_octets': '3369267906',
                                                                                       'in_ucast_pkts': '19106450',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '93231884104',
                                                                                       'out_ucast_pkts': '66152081',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QjNBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:36:70'],
                                                                                       'in_nucast_pkts': '17345',
                                                                                       'in_octets': '5263934024',
                                                                                       'in_ucast_pkts': '12460366',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '31009469267',
                                                                                       'out_ucast_pkts': '25092088',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QzEwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:89:50'],
                                                                                       'in_nucast_pkts': '17786',
                                                                                       'in_octets': '15221587024',
                                                                                       'in_ucast_pkts': '84353268',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1469',
                                                                                       'out_octets': '395982070421',
                                                                                       'out_ucast_pkts': '292015605',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTJCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:b6:30'],
                                                                                       'in_nucast_pkts': '5130',
                                                                                       'in_octets': '831887605',
                                                                                       'in_ucast_pkts': '2077424',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '172',
                                                                                       'out_octets': '7914458678',
                                                                                       'out_ucast_pkts': '6076230',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RUUwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:ad:d0'],
                                                                                       'in_nucast_pkts': '17074',
                                                                                       'in_octets': '41487522417',
                                                                                       'in_ucast_pkts': '46058779',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '86523696291',
                                                                                       'out_ucast_pkts': '70721780',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RUM4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:04:00'],
                                                                                       'in_nucast_pkts': '17067',
                                                                                       'in_octets': '5557607180',
                                                                                       'in_ucast_pkts': '33598451',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '102148766689',
                                                                                       'out_ucast_pkts': '72254854',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QzE3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:3d:30'],
                                                                                       'in_nucast_pkts': '17069',
                                                                                       'in_octets': '17043278935',
                                                                                       'in_ucast_pkts': '35921917',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '275488666428',
                                                                                       'out_ucast_pkts': '194127485',
                                                                                       'poller_hash': 'QURUTjIzMTI0NTEwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:3e:40'],
                                                                                       'in_nucast_pkts': '17070',
                                                                                       'in_octets': '7687648925',
                                                                                       'in_ucast_pkts': '67999725',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '327100804142',
                                                                                       'out_ucast_pkts': '223208202',
                                                                                       'poller_hash': 'QURUTjI0MzE0NzY2IHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/2',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8y',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/2',
                                                                                      'id': 'xgspon '
                                                                                            '0/2',
                                                                                      'links': [       {       'connected_time': '511495',
                                                                                                               'fiber_length': 1926,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDQxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511496',
                                                                                                               'fiber_length': 1969,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MEIwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511496',
                                                                                                               'fiber_length': 1780,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REQ5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511490',
                                                                                                               'fiber_length': 2471,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MUQxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511495',
                                                                                                               'fiber_length': 1807,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RjNDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511501',
                                                                                                               'fiber_length': 1986,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REZDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -12.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511497',
                                                                                                               'fiber_length': 2396,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RjMwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511496',
                                                                                                               'fiber_length': 2088,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTQ2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '2317051',
                                                                                                               'fiber_length': 2058,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REI3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '2317053',
                                                                                                               'fiber_length': 2069,
                                                                                                               'poller_hash': 'QURUTjIzMTI0OEE4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '2317051',
                                                                                                               'fiber_length': 2313,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDlFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '2317052',
                                                                                                               'fiber_length': 2008,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTUwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511495',
                                                                                                               'fiber_length': 540,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTFEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '2317053',
                                                                                                               'fiber_length': 2230,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRUJDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511490',
                                                                                                               'fiber_length': 1746,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTE2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '2317051',
                                                                                                               'fiber_length': 1857,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTJGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511500',
                                                                                                               'fiber_length': 1996,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MEM4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511494',
                                                                                                               'fiber_length': 233,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NzczIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511502',
                                                                                                               'fiber_length': 1780,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NkMwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -12.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511499',
                                                                                                               'fiber_length': 2012,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0OTE2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511502',
                                                                                                               'fiber_length': 545,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QjNBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511498',
                                                                                                               'fiber_length': 1734,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QzEwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511493',
                                                                                                               'fiber_length': 324,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTJCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '153366',
                                                                                                               'fiber_length': 700,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RUUwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511498',
                                                                                                               'fiber_length': 489,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RUM4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511498',
                                                                                                               'fiber_length': 716,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QzE3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511500',
                                                                                                               'fiber_length': 313,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NTEwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -12.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737},
                                                                                                       {       'connected_time': '511505',
                                                                                                               'fiber_length': 859,
                                                                                                               'poller_hash': 'QURUTjI0MzE0NzY2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2737}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/2',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8y',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/3',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:dc:83:00'],
                                                                                       'in_nucast_pkts': '185143',
                                                                                       'in_octets': '114224840443',
                                                                                       'in_ucast_pkts': '284025037',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15627',
                                                                                       'out_octets': '1198673274406',
                                                                                       'out_ucast_pkts': '937808721',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTQ1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:36:e0'],
                                                                                       'in_nucast_pkts': '134175',
                                                                                       'in_octets': '41028323456',
                                                                                       'in_ucast_pkts': '85142587',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '11217',
                                                                                       'out_octets': '362600897682',
                                                                                       'out_ucast_pkts': '269818780',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTQ5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a8:a0'],
                                                                                       'in_nucast_pkts': '64552',
                                                                                       'in_octets': '100324784568',
                                                                                       'in_ucast_pkts': '420812486',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2100',
                                                                                       'out_octets': '1288077963545',
                                                                                       'out_ucast_pkts': '932948319',
                                                                                       'poller_hash': 'QURUTjIzMTQ0N0Y5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:3b:b0'],
                                                                                       'in_nucast_pkts': '184373',
                                                                                       'in_octets': '23546687807',
                                                                                       'in_ucast_pkts': '147610870',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15621',
                                                                                       'out_octets': '718037747535',
                                                                                       'out_ucast_pkts': '499348896',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NjgxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:0c:50'],
                                                                                       'in_nucast_pkts': '26506',
                                                                                       'in_octets': '17636558073',
                                                                                       'in_ucast_pkts': '103017701',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2241',
                                                                                       'out_octets': '413594199234',
                                                                                       'out_ucast_pkts': '300633066',
                                                                                       'poller_hash': 'QURUTjIzMTQ0ODlDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:38:50'],
                                                                                       'in_nucast_pkts': '184380',
                                                                                       'in_octets': '106130690715',
                                                                                       'in_ucast_pkts': '366861213',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15628',
                                                                                       'out_octets': '1545613386456',
                                                                                       'out_ucast_pkts': '1120007761',
                                                                                       'poller_hash': 'QURUTjIzMTQ0OEJBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:6e:e0'],
                                                                                       'in_nucast_pkts': '184524',
                                                                                       'in_octets': '760563575203',
                                                                                       'in_ucast_pkts': '1084810059',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6045',
                                                                                       'out_octets': '2715739030109',
                                                                                       'out_ucast_pkts': '2051082644',
                                                                                       'poller_hash': 'QURUTjIzMTQ0ODlEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:0a:f0'],
                                                                                       'in_nucast_pkts': '184391',
                                                                                       'in_octets': '120634866501',
                                                                                       'in_ucast_pkts': '753224717',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15614',
                                                                                       'out_octets': '1762704597089',
                                                                                       'out_ucast_pkts': '1355324479',
                                                                                       'poller_hash': 'QURUTjIzMTQ0ODgzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:52:20'],
                                                                                       'in_nucast_pkts': '184406',
                                                                                       'in_octets': '29353683826',
                                                                                       'in_ucast_pkts': '228444142',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15623',
                                                                                       'out_octets': '706729102780',
                                                                                       'out_ucast_pkts': '500738346',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NzA3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:08:c0'],
                                                                                       'in_nucast_pkts': '184449',
                                                                                       'in_octets': '40055826188',
                                                                                       'in_ucast_pkts': '113244758',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15617',
                                                                                       'out_octets': '301307270087',
                                                                                       'out_ucast_pkts': '261636539',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NzAyIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a8:10'],
                                                                                       'in_nucast_pkts': '181365',
                                                                                       'in_octets': '59332714181',
                                                                                       'in_ucast_pkts': '103988355',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6046',
                                                                                       'out_octets': '288012885834',
                                                                                       'out_ucast_pkts': '237523808',
                                                                                       'poller_hash': 'QURUTjIzMTQ0N0JEIHBlZXJpbnRm'},
                                                                               {       'in_nucast_pkts': '0',
                                                                                       'in_octets': '0',
                                                                                       'in_ucast_pkts': '0',
                                                                                       'oper_up': False,
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '0',
                                                                                       'out_ucast_pkts': '0',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NkNDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:03:a0'],
                                                                                       'in_nucast_pkts': '184400',
                                                                                       'in_octets': '40388633921',
                                                                                       'in_ucast_pkts': '169099413',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15615',
                                                                                       'out_octets': '901890785599',
                                                                                       'out_ucast_pkts': '640995591',
                                                                                       'poller_hash': 'QURUTjIzMTQ0N0FFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:0b:70'],
                                                                                       'in_nucast_pkts': '52015',
                                                                                       'in_octets': '1710802939',
                                                                                       'in_ucast_pkts': '2856140',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '4401',
                                                                                       'out_octets': '3567786663',
                                                                                       'out_ucast_pkts': '3617595',
                                                                                       'poller_hash': 'QURUTjIzMTQ0OEZFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:3a:70'],
                                                                                       'in_nucast_pkts': '34680',
                                                                                       'in_octets': '10840280335',
                                                                                       'in_ucast_pkts': '42618547',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2932',
                                                                                       'out_octets': '137901116493',
                                                                                       'out_ucast_pkts': '106451556',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NkE1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:83:50'],
                                                                                       'in_nucast_pkts': '165877',
                                                                                       'in_octets': '94609140575',
                                                                                       'in_ucast_pkts': '332441703',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '13938',
                                                                                       'out_octets': '1245110213602',
                                                                                       'out_ucast_pkts': '928888614',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTRBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:4a:f0'],
                                                                                       'in_nucast_pkts': '89585',
                                                                                       'in_octets': '44680359865',
                                                                                       'in_ucast_pkts': '158497249',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2988',
                                                                                       'out_octets': '563961505377',
                                                                                       'out_ucast_pkts': '406261121',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RUZGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:38:00'],
                                                                                       'in_nucast_pkts': '78181',
                                                                                       'in_octets': '27899552121',
                                                                                       'in_ucast_pkts': '54651869',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6617',
                                                                                       'out_octets': '90806962833',
                                                                                       'out_ucast_pkts': '86369262',
                                                                                       'poller_hash': 'QURUTjIzMTI0QTE4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '36:3a:c5:c7:0e:34',
                                                                                                                        'cc:66:18:50:b4:20'],
                                                                                       'in_nucast_pkts': '51748',
                                                                                       'in_octets': '449522113442',
                                                                                       'in_ucast_pkts': '526457874',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1725',
                                                                                       'out_octets': '848622428896',
                                                                                       'out_ucast_pkts': '737635649',
                                                                                       'poller_hash': 'QURUTjIzMTI0QTc2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:43:e0'],
                                                                                       'in_nucast_pkts': '181510',
                                                                                       'in_octets': '112941005951',
                                                                                       'in_ucast_pkts': '351102468',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6045',
                                                                                       'out_octets': '946005969035',
                                                                                       'out_ucast_pkts': '699659776',
                                                                                       'poller_hash': 'QURUTjIzMTI0QjNGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:38:30'],
                                                                                       'in_nucast_pkts': '29660',
                                                                                       'in_octets': '92826400199',
                                                                                       'in_ucast_pkts': '188162824',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2513',
                                                                                       'out_octets': '453129660973',
                                                                                       'out_ucast_pkts': '337137185',
                                                                                       'poller_hash': 'QURUTjIzMTI0QkE1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:62:90'],
                                                                                       'in_nucast_pkts': '182366',
                                                                                       'in_octets': '200222667955',
                                                                                       'in_ucast_pkts': '1068086035',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6047',
                                                                                       'out_octets': '5909796819926',
                                                                                       'out_ucast_pkts': '4494340833',
                                                                                       'poller_hash': 'QURUTjI0MzYzQ0M2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8c:80'],
                                                                                       'in_nucast_pkts': '53768',
                                                                                       'in_octets': '90783772980',
                                                                                       'in_ucast_pkts': '337362943',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '4457',
                                                                                       'out_octets': '888976983721',
                                                                                       'out_ucast_pkts': '643600902',
                                                                                       'poller_hash': 'QURUTjIzMTQ0OEI4IHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/3',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8z',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/3',
                                                                                      'id': 'xgspon '
                                                                                            '0/3',
                                                                                      'links': [       {       'connected_time': '5440096',
                                                                                                               'fiber_length': 13527,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTQ1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '3910768',
                                                                                                               'fiber_length': 13074,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTQ5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '1889034',
                                                                                                               'fiber_length': 14757,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0N0Y5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -23.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '5440063',
                                                                                                               'fiber_length': 14954,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NjgxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '781465',
                                                                                                               'fiber_length': 14487,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0ODlDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -23.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '5440092',
                                                                                                               'fiber_length': 14745,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0OEJBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -23.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '5440093',
                                                                                                               'fiber_length': 14466,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0ODlEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -23.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '5440093',
                                                                                                               'fiber_length': 14826,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0ODgzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -23.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '5440095',
                                                                                                               'fiber_length': 14521,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NzA3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '5440096',
                                                                                                               'fiber_length': 14662,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NzAyIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '5440094',
                                                                                                               'fiber_length': 13218,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0N0JEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '5440065',
                                                                                                               'fiber_length': 12154,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NkNDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '5440096',
                                                                                                               'fiber_length': 13016,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0N0FFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '1534721',
                                                                                                               'fiber_length': 14823,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0OEZFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '1022696',
                                                                                                               'fiber_length': 14178,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NkE1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '4857791',
                                                                                                               'fiber_length': 14481,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTRBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '2684908',
                                                                                                               'fiber_length': 14568,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RUZGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -26.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '2312767',
                                                                                                               'fiber_length': 14439,
                                                                                                               'poller_hash': 'QURUTjIzMTI0QTE4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '1551603',
                                                                                                               'fiber_length': 12765,
                                                                                                               'poller_hash': 'QURUTjIzMTI0QTc2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '5440065',
                                                                                                               'fiber_length': 13633,
                                                                                                               'poller_hash': 'QURUTjIzMTI0QjNGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '873712',
                                                                                                               'fiber_length': 14906,
                                                                                                               'poller_hash': 'QURUTjIzMTI0QkE1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -23.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '5440065',
                                                                                                               'fiber_length': 13230,
                                                                                                               'poller_hash': 'QURUTjI0MzYzQ0M2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471},
                                                                                                       {       'connected_time': '1553615',
                                                                                                               'fiber_length': 13206,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0OEI4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5471}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/3',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8z',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/4',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:dc:56:70'],
                                                                                       'in_nucast_pkts': '80464',
                                                                                       'in_octets': '64191871858',
                                                                                       'in_ucast_pkts': '294720133',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6629',
                                                                                       'out_octets': '1307641974656',
                                                                                       'out_ucast_pkts': '937844307',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTA3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:77:20'],
                                                                                       'in_nucast_pkts': '14661',
                                                                                       'in_octets': '6991765314',
                                                                                       'in_ucast_pkts': '30718708',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1210',
                                                                                       'out_octets': '110390447582',
                                                                                       'out_ucast_pkts': '78915022',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTE0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:69:60'],
                                                                                       'in_nucast_pkts': '66683',
                                                                                       'in_octets': '31690461601',
                                                                                       'in_ucast_pkts': '130691656',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5640',
                                                                                       'out_octets': '376612482296',
                                                                                       'out_ucast_pkts': '336192464',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTYwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:57:60'],
                                                                                       'in_nucast_pkts': '8874',
                                                                                       'in_octets': '1105351558',
                                                                                       'in_ucast_pkts': '5692128',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '750',
                                                                                       'out_octets': '33797115840',
                                                                                       'out_ucast_pkts': '24223033',
                                                                                       'poller_hash': 'QURUTjIzMTI0REREIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4b:fa:30'],
                                                                                       'in_nucast_pkts': '77250',
                                                                                       'in_octets': '31411288346',
                                                                                       'in_ucast_pkts': '99595628',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2567',
                                                                                       'out_octets': '402318506803',
                                                                                       'out_ucast_pkts': '294620515',
                                                                                       'poller_hash': 'QURUTjIzMTI0NUM2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:7a:e0'],
                                                                                       'in_nucast_pkts': '112203',
                                                                                       'in_octets': '178265876806',
                                                                                       'in_ucast_pkts': '377896222',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3734',
                                                                                       'out_octets': '974919567981',
                                                                                       'out_ucast_pkts': '749790248',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDdEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:76:60'],
                                                                                       'in_nucast_pkts': '80462',
                                                                                       'in_octets': '34208278773',
                                                                                       'in_ucast_pkts': '133402787',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6631',
                                                                                       'out_octets': '379173521004',
                                                                                       'out_ucast_pkts': '272048012',
                                                                                       'poller_hash': 'QURUTjIzMTIzRkFEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:75:51'],
                                                                                       'in_nucast_pkts': '1343',
                                                                                       'in_octets': '30099881929',
                                                                                       'in_ucast_pkts': '135547910',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6629',
                                                                                       'out_octets': '689845211523',
                                                                                       'out_ucast_pkts': '493316076',
                                                                                       'poller_hash': 'QURUTjIzMTI0Rjk5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ab:20'],
                                                                                       'in_nucast_pkts': '62088',
                                                                                       'in_octets': '69782859508',
                                                                                       'in_ucast_pkts': '222531899',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2020',
                                                                                       'out_octets': '560038723744',
                                                                                       'out_ucast_pkts': '407371035',
                                                                                       'poller_hash': 'QURUTjIzMTI0RjA2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:78:a0'],
                                                                                       'in_nucast_pkts': '78543',
                                                                                       'in_octets': '16544493187',
                                                                                       'in_ucast_pkts': '103247590',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6628',
                                                                                       'out_octets': '277598045489',
                                                                                       'out_ucast_pkts': '202126901',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTdEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:b5:50'],
                                                                                       'in_nucast_pkts': '77259',
                                                                                       'in_octets': '30947372870',
                                                                                       'in_ucast_pkts': '161571631',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2570',
                                                                                       'out_octets': '942520427841',
                                                                                       'out_ucast_pkts': '685844825',
                                                                                       'poller_hash': 'QURUTjIzMTI0REU4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:93:80'],
                                                                                       'in_nucast_pkts': '78132',
                                                                                       'in_octets': '37564494279',
                                                                                       'in_ucast_pkts': '212070619',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6587',
                                                                                       'out_octets': '705153503921',
                                                                                       'out_ucast_pkts': '503870012',
                                                                                       'poller_hash': 'QURUTjIzMTI1MUVFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:8a:10'],
                                                                                       'in_nucast_pkts': '23934',
                                                                                       'in_octets': '12259358305',
                                                                                       'in_ucast_pkts': '65309438',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1979',
                                                                                       'out_octets': '238371002118',
                                                                                       'out_ucast_pkts': '171853941',
                                                                                       'poller_hash': 'QURUTjIzMTI0RUE1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:b7:70'],
                                                                                       'in_nucast_pkts': '77254',
                                                                                       'in_octets': '9552622113',
                                                                                       'in_ucast_pkts': '30258842',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2574',
                                                                                       'out_octets': '85272096163',
                                                                                       'out_ucast_pkts': '69784441',
                                                                                       'poller_hash': 'QURUTjIzMTIzRTlFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:09:30'],
                                                                                       'in_nucast_pkts': '17430',
                                                                                       'in_octets': '19898956699',
                                                                                       'in_ucast_pkts': '131222900',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '357137099261',
                                                                                       'out_ucast_pkts': '244740097',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTI5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:6a:e0'],
                                                                                       'in_nucast_pkts': '79067',
                                                                                       'in_octets': '26256197341',
                                                                                       'in_ucast_pkts': '85186117',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6630',
                                                                                       'out_octets': '417679382577',
                                                                                       'out_ucast_pkts': '303843932',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTI2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a8:50'],
                                                                                       'in_nucast_pkts': '77253',
                                                                                       'in_octets': '28178292115',
                                                                                       'in_ucast_pkts': '152473006',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2570',
                                                                                       'out_octets': '693591396875',
                                                                                       'out_ucast_pkts': '490410131',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTUzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:37:60'],
                                                                                       'in_nucast_pkts': '78525',
                                                                                       'in_octets': '25125301558',
                                                                                       'in_ucast_pkts': '150490446',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6626',
                                                                                       'out_octets': '539450720535',
                                                                                       'out_ucast_pkts': '375595976',
                                                                                       'poller_hash': 'QURUTjIzMTI1MUFBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:24:e0'],
                                                                                       'in_nucast_pkts': '43114',
                                                                                       'in_octets': '4458164244',
                                                                                       'in_ucast_pkts': '13682224',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1417',
                                                                                       'out_octets': '39806039770',
                                                                                       'out_ucast_pkts': '28911659',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTRGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:50:b0'],
                                                                                       'in_nucast_pkts': '77255',
                                                                                       'in_octets': '19655585764',
                                                                                       'in_ucast_pkts': '71781369',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2572',
                                                                                       'out_octets': '275176434769',
                                                                                       'out_ucast_pkts': '202804538',
                                                                                       'poller_hash': 'QURUTjIzMTI0MUJGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:37:81'],
                                                                                       'in_nucast_pkts': '308',
                                                                                       'in_octets': '6353151082',
                                                                                       'in_ucast_pkts': '36858175',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1466',
                                                                                       'out_octets': '300504350152',
                                                                                       'out_ucast_pkts': '215317430',
                                                                                       'poller_hash': 'QURUTjIzMTIzRkRDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ab:00'],
                                                                                       'in_nucast_pkts': '43675',
                                                                                       'in_octets': '35810310413',
                                                                                       'in_ucast_pkts': '103057074',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1455',
                                                                                       'out_octets': '440061119703',
                                                                                       'out_ucast_pkts': '316118515',
                                                                                       'poller_hash': 'QURUTjIzMTQ0N0RBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:84:51'],
                                                                                       'in_nucast_pkts': '640',
                                                                                       'in_octets': '20128057580',
                                                                                       'in_ucast_pkts': '58996755',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3021',
                                                                                       'out_octets': '223867537482',
                                                                                       'out_ucast_pkts': '167630986',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NzM1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:01:10'],
                                                                                       'in_nucast_pkts': '77257',
                                                                                       'in_octets': '37842338820',
                                                                                       'in_ucast_pkts': '103822789',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2573',
                                                                                       'out_octets': '392270827975',
                                                                                       'out_ucast_pkts': '296845783',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QUIwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:81:70'],
                                                                                       'in_nucast_pkts': '77255',
                                                                                       'in_octets': '80112491001',
                                                                                       'in_ucast_pkts': '170775637',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2573',
                                                                                       'out_octets': '569526737669',
                                                                                       'out_ucast_pkts': '427832231',
                                                                                       'poller_hash': 'QURUTjIzMTI0QzU1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:a8:60'],
                                                                                       'in_nucast_pkts': '78535',
                                                                                       'in_octets': '48505866974',
                                                                                       'in_ucast_pkts': '136961601',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6626',
                                                                                       'out_octets': '478541428408',
                                                                                       'out_ucast_pkts': '341019414',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RUUzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a3:a0'],
                                                                                       'in_nucast_pkts': '69483',
                                                                                       'in_octets': '9445157701',
                                                                                       'in_ucast_pkts': '80859241',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2316',
                                                                                       'out_octets': '255804624224',
                                                                                       'out_ucast_pkts': '177152668',
                                                                                       'poller_hash': 'QURUTjIzMTI0NjBBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ab:a0'],
                                                                                       'in_nucast_pkts': '77256',
                                                                                       'in_octets': '8706303577',
                                                                                       'in_ucast_pkts': '42490684',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2571',
                                                                                       'out_octets': '215562903845',
                                                                                       'out_ucast_pkts': '162529006',
                                                                                       'poller_hash': 'QURUTjI0MzYzQUU3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:25:f0'],
                                                                                       'in_nucast_pkts': '77256',
                                                                                       'in_octets': '17543890243',
                                                                                       'in_ucast_pkts': '16181738',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2570',
                                                                                       'out_octets': '20443373744',
                                                                                       'out_ucast_pkts': '19280419',
                                                                                       'poller_hash': 'QURUTjI0Mzg5NkY5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:2e:00'],
                                                                                       'in_nucast_pkts': '56791',
                                                                                       'in_octets': '36629619784',
                                                                                       'in_ucast_pkts': '86480359',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1897',
                                                                                       'out_octets': '570731716285',
                                                                                       'out_ucast_pkts': '410052208',
                                                                                       'poller_hash': 'QURUTjI0MzYzQzQ5IHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/4',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC80',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/4',
                                                                                      'id': 'xgspon '
                                                                                            '0/4',
                                                                                      'links': [       {       'connected_time': '2317053',
                                                                                                               'fiber_length': 3992,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTA3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '421798',
                                                                                                               'fiber_length': 4123,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTE0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '1967097',
                                                                                                               'fiber_length': 4527,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTYwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '261424',
                                                                                                               'fiber_length': 3424,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REREIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '2317059',
                                                                                                               'fiber_length': 3878,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NUM2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '3363454',
                                                                                                               'fiber_length': 4613,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDdEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '2317055',
                                                                                                               'fiber_length': 3684,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRkFEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '2317057',
                                                                                                               'fiber_length': 3674,
                                                                                                               'poller_hash': 'QURUTjIzMTI0Rjk5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '1816875',
                                                                                                               'fiber_length': 4267,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RjA2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '2317056',
                                                                                                               'fiber_length': 3861,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTdEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '2317057',
                                                                                                               'fiber_length': 3367,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REU4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '2317050',
                                                                                                               'fiber_length': 4569,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MUVFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '688772',
                                                                                                               'fiber_length': 3857,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RUE1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '2317054',
                                                                                                               'fiber_length': 4488,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRTlFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '511507',
                                                                                                               'fiber_length': 4696,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTI5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '2317056',
                                                                                                               'fiber_length': 4079,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTI2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '2317051',
                                                                                                               'fiber_length': 3719,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTUzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '2317055',
                                                                                                               'fiber_length': 4022,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MUFBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '1293152',
                                                                                                               'fiber_length': 3775,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTRGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -24.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '2317058',
                                                                                                               'fiber_length': 4059,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MUJGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '511508',
                                                                                                               'fiber_length': 4481,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRkRDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '1309470',
                                                                                                               'fiber_length': 3596,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0N0RBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '1053537',
                                                                                                               'fiber_length': 4136,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NzM1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '2317047',
                                                                                                               'fiber_length': 4574,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QUIwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -23.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '2317058',
                                                                                                               'fiber_length': 4209,
                                                                                                               'poller_hash': 'QURUTjIzMTI0QzU1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '2317048',
                                                                                                               'fiber_length': 4287,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RUUzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '2083695',
                                                                                                               'fiber_length': 4437,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NjBBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '2317066',
                                                                                                               'fiber_length': 3543,
                                                                                                               'poller_hash': 'QURUTjI0MzYzQUU3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '2317062',
                                                                                                               'fiber_length': 3918,
                                                                                                               'poller_hash': 'QURUTjI0Mzg5NkY5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769},
                                                                                                       {       'connected_time': '1702391',
                                                                                                               'fiber_length': 4116,
                                                                                                               'poller_hash': 'QURUTjI0MzYzQzQ5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3769}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/4',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC80',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/5',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:dc:7f:40'],
                                                                                       'in_nucast_pkts': '78535',
                                                                                       'in_octets': '32074553609',
                                                                                       'in_ucast_pkts': '247138061',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6651',
                                                                                       'out_octets': '851716345889',
                                                                                       'out_ucast_pkts': '606755361',
                                                                                       'poller_hash': 'QURUTjIzMTI0REYxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:56:90'],
                                                                                       'in_nucast_pkts': '78530',
                                                                                       'in_octets': '9573246216',
                                                                                       'in_ucast_pkts': '28968827',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6646',
                                                                                       'out_octets': '94670181667',
                                                                                       'out_ucast_pkts': '79312527',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDQzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:71:00'],
                                                                                       'in_nucast_pkts': '79111',
                                                                                       'in_octets': '35790774369',
                                                                                       'in_ucast_pkts': '168984150',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2576',
                                                                                       'out_octets': '621131891083',
                                                                                       'out_ucast_pkts': '448566543',
                                                                                       'poller_hash': 'QURUTjIzMTI1MUUyIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:93:30'],
                                                                                       'in_nucast_pkts': '37776',
                                                                                       'in_octets': '17380293068',
                                                                                       'in_ucast_pkts': '88982916',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3197',
                                                                                       'out_octets': '493923471987',
                                                                                       'out_ucast_pkts': '350348488',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTI2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:92:20'],
                                                                                       'in_nucast_pkts': '78535',
                                                                                       'in_octets': '88158106536',
                                                                                       'in_ucast_pkts': '371249138',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6646',
                                                                                       'out_octets': '1100356693456',
                                                                                       'out_ucast_pkts': '806203412',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDk4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:78:60'],
                                                                                       'in_nucast_pkts': '78529',
                                                                                       'in_octets': '28476675251',
                                                                                       'in_ucast_pkts': '142287961',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6647',
                                                                                       'out_octets': '953590409355',
                                                                                       'out_ucast_pkts': '703346325',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDUwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:77:c0'],
                                                                                       'in_nucast_pkts': '78632',
                                                                                       'in_octets': '2863545110',
                                                                                       'in_ucast_pkts': '10210777',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6649',
                                                                                       'out_octets': '36091222902',
                                                                                       'out_ucast_pkts': '26579330',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDM4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:72:20'],
                                                                                       'in_nucast_pkts': '80130',
                                                                                       'in_octets': '42976698193',
                                                                                       'in_ucast_pkts': '299332771',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6651',
                                                                                       'out_octets': '1255152815589',
                                                                                       'out_ucast_pkts': '901031913',
                                                                                       'poller_hash': 'QURUTjIzMTI0OTAwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:77:f0'],
                                                                                       'in_nucast_pkts': '29041',
                                                                                       'in_octets': '88986655438',
                                                                                       'in_ucast_pkts': '119673652',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2456',
                                                                                       'out_octets': '271763618943',
                                                                                       'out_ucast_pkts': '249838064',
                                                                                       'poller_hash': 'QURUTjIzMTI0REE2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:73:e0'],
                                                                                       'in_nucast_pkts': '37777',
                                                                                       'in_octets': '2961602648',
                                                                                       'in_ucast_pkts': '26561230',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3197',
                                                                                       'out_octets': '82802554675',
                                                                                       'out_ucast_pkts': '56265867',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTE2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:81:10'],
                                                                                       'in_nucast_pkts': '78535',
                                                                                       'in_octets': '125019801865',
                                                                                       'in_ucast_pkts': '590023136',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6649',
                                                                                       'out_octets': '1927420214171',
                                                                                       'out_ucast_pkts': '1436718789',
                                                                                       'poller_hash': 'QURUTjIzMTI0RjJCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:5c:00'],
                                                                                       'in_nucast_pkts': '51160',
                                                                                       'in_octets': '54907922403',
                                                                                       'in_ucast_pkts': '175360064',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1706',
                                                                                       'out_octets': '621698507690',
                                                                                       'out_ucast_pkts': '454730480',
                                                                                       'poller_hash': 'QURUTjIzMTIzRjJCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:75:a0'],
                                                                                       'in_nucast_pkts': '37809',
                                                                                       'in_octets': '8907565649',
                                                                                       'in_ucast_pkts': '69442996',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3197',
                                                                                       'out_octets': '174818309953',
                                                                                       'out_ucast_pkts': '127345107',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTBEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:af:00'],
                                                                                       'in_nucast_pkts': '77271',
                                                                                       'in_octets': '29472585908',
                                                                                       'in_ucast_pkts': '59851576',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2576',
                                                                                       'out_octets': '187663777776',
                                                                                       'out_ucast_pkts': '152376578',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTI1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:7f:80'],
                                                                                       'in_nucast_pkts': '61715',
                                                                                       'in_octets': '94627388922',
                                                                                       'in_ucast_pkts': '167676867',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5228',
                                                                                       'out_octets': '406432771728',
                                                                                       'out_ucast_pkts': '346990952',
                                                                                       'poller_hash': 'QURUTjIzMTI0REY3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8d:c0'],
                                                                                       'in_nucast_pkts': '78533',
                                                                                       'in_octets': '25244124422',
                                                                                       'in_ucast_pkts': '77906098',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6647',
                                                                                       'out_octets': '201047220883',
                                                                                       'out_ucast_pkts': '154873044',
                                                                                       'poller_hash': 'QURUTjIzMTI1MUIwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:83:00'],
                                                                                       'in_nucast_pkts': '80396',
                                                                                       'in_octets': '90723615998',
                                                                                       'in_ucast_pkts': '231116455',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6647',
                                                                                       'out_octets': '770911853601',
                                                                                       'out_ucast_pkts': '568332465',
                                                                                       'poller_hash': 'QURUTjIzMTI0Rjc0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:3a:f0'],
                                                                                       'in_nucast_pkts': '78533',
                                                                                       'in_octets': '66612886069',
                                                                                       'in_ucast_pkts': '366803880',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6651',
                                                                                       'out_octets': '1174174610445',
                                                                                       'out_ucast_pkts': '859824473',
                                                                                       'poller_hash': 'QURUTjIzMTI0NEVCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:50:e0'],
                                                                                       'in_nucast_pkts': '77274',
                                                                                       'in_octets': '19847184105',
                                                                                       'in_ucast_pkts': '60122034',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2576',
                                                                                       'out_octets': '187773959886',
                                                                                       'out_ucast_pkts': '141393438',
                                                                                       'poller_hash': 'QURUTjIzMTI0MDk5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:71:10'],
                                                                                       'in_nucast_pkts': '78536',
                                                                                       'in_octets': '30883850198',
                                                                                       'in_ucast_pkts': '148123087',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6651',
                                                                                       'out_octets': '425517749953',
                                                                                       'out_ucast_pkts': '389834749',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RUZEIHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/5',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC81',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/5',
                                                                                      'id': 'xgspon '
                                                                                            '0/5',
                                                                                      'links': [       {       'connected_time': '2317053',
                                                                                                               'fiber_length': 5944,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REYxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097},
                                                                                                       {       'connected_time': '2317055',
                                                                                                               'fiber_length': 6063,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDQzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097},
                                                                                                       {       'connected_time': '2317054',
                                                                                                               'fiber_length': 5212,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MUUyIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097},
                                                                                                       {       'connected_time': '1114341',
                                                                                                               'fiber_length': 7531,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTI2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097},
                                                                                                       {       'connected_time': '2317056',
                                                                                                               'fiber_length': 5967,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDk4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097},
                                                                                                       {       'connected_time': '2317060',
                                                                                                               'fiber_length': 5915,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDUwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097},
                                                                                                       {       'connected_time': '2317054',
                                                                                                               'fiber_length': 6210,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDM4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097},
                                                                                                       {       'connected_time': '2317056',
                                                                                                               'fiber_length': 6197,
                                                                                                               'poller_hash': 'QURUTjIzMTI0OTAwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097},
                                                                                                       {       'connected_time': '856063',
                                                                                                               'fiber_length': 5510,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REE2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097},
                                                                                                       {       'connected_time': '1114341',
                                                                                                               'fiber_length': 7481,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTE2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097},
                                                                                                       {       'connected_time': '2317057',
                                                                                                               'fiber_length': 6120,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RjJCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097},
                                                                                                       {       'connected_time': '1534011',
                                                                                                               'fiber_length': 5584,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRjJCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097},
                                                                                                       {       'connected_time': '1114341',
                                                                                                               'fiber_length': 7351,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTBEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097},
                                                                                                       {       'connected_time': '2317058',
                                                                                                               'fiber_length': 5209,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTI1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097},
                                                                                                       {       'connected_time': '1820396',
                                                                                                               'fiber_length': 8168,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REY3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097},
                                                                                                       {       'connected_time': '2317055',
                                                                                                               'fiber_length': 5245,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MUIwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097},
                                                                                                       {       'connected_time': '2317057',
                                                                                                               'fiber_length': 6325,
                                                                                                               'poller_hash': 'QURUTjIzMTI0Rjc0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097},
                                                                                                       {       'connected_time': '2317059',
                                                                                                               'fiber_length': 8586,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NEVCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097},
                                                                                                       {       'connected_time': '2317059',
                                                                                                               'fiber_length': 6279,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MDk5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097},
                                                                                                       {       'connected_time': '2317058',
                                                                                                               'fiber_length': 6232,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RUZEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1097}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/5',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC81',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/6',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:d6:08:e0'],
                                                                                       'in_nucast_pkts': '78538',
                                                                                       'in_octets': '16840309678',
                                                                                       'in_ucast_pkts': '96638856',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6651',
                                                                                       'out_octets': '427069282997',
                                                                                       'out_ucast_pkts': '315618342',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTJBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:8d:d0'],
                                                                                       'in_nucast_pkts': '77453',
                                                                                       'in_octets': '178991664099',
                                                                                       'in_ucast_pkts': '614932667',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2574',
                                                                                       'out_octets': '1876167151735',
                                                                                       'out_ucast_pkts': '1340522307',
                                                                                       'poller_hash': 'QURUTjIzMTI0RUE0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:0c:10'],
                                                                                       'in_nucast_pkts': '168735',
                                                                                       'in_octets': '100638156252',
                                                                                       'in_ucast_pkts': '616564644',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '14159',
                                                                                       'out_octets': '973818902633',
                                                                                       'out_ucast_pkts': '937248545',
                                                                                       'poller_hash': 'QURUTjIzMTIzRkY1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:7d:e0'],
                                                                                       'in_nucast_pkts': '78531',
                                                                                       'in_octets': '11540874941',
                                                                                       'in_ucast_pkts': '73015080',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6647',
                                                                                       'out_octets': '296399143311',
                                                                                       'out_ucast_pkts': '208464895',
                                                                                       'poller_hash': 'QURUTjIzMTIzRjE4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:b8:50'],
                                                                                       'in_nucast_pkts': '79176',
                                                                                       'in_octets': '37525762453',
                                                                                       'in_ucast_pkts': '286489395',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2576',
                                                                                       'out_octets': '897851171839',
                                                                                       'out_ucast_pkts': '626176397',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTk1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:7b:30'],
                                                                                       'in_nucast_pkts': '80463',
                                                                                       'in_octets': '123766625329',
                                                                                       'in_ucast_pkts': '306487604',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6653',
                                                                                       'out_octets': '1029083777933',
                                                                                       'out_ucast_pkts': '824202792',
                                                                                       'poller_hash': 'QURUTjIzMTI1MENDIHBlZXJpbnRm'},
                                                                               {       'in_nucast_pkts': '4149318',
                                                                                       'in_octets': '1218507587',
                                                                                       'in_ucast_pkts': '1097786',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '0',
                                                                                       'out_ucast_pkts': '0',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTExIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:6e:30'],
                                                                                       'in_nucast_pkts': '181362',
                                                                                       'in_octets': '117476837393',
                                                                                       'in_ucast_pkts': '782362731',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6046',
                                                                                       'out_octets': '2690641132374',
                                                                                       'out_ucast_pkts': '1905365208',
                                                                                       'poller_hash': 'QURUTjIzMTI1MjA2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:b3:60'],
                                                                                       'in_nucast_pkts': '77257',
                                                                                       'in_octets': '25913101840',
                                                                                       'in_ucast_pkts': '195827682',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2576',
                                                                                       'out_octets': '538979312501',
                                                                                       'out_ucast_pkts': '388999274',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTREIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:63:40'],
                                                                                       'in_nucast_pkts': '77257',
                                                                                       'in_octets': '19421389746',
                                                                                       'in_ucast_pkts': '134022591',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2576',
                                                                                       'out_octets': '396004731028',
                                                                                       'out_ucast_pkts': '273905695',
                                                                                       'poller_hash': 'QURUTjIzMTI1MENEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:35:20'],
                                                                                       'in_nucast_pkts': '78535',
                                                                                       'in_octets': '22993023654',
                                                                                       'in_ucast_pkts': '119087151',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6649',
                                                                                       'out_octets': '578989661367',
                                                                                       'out_ucast_pkts': '410335584',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTRCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a9:70'],
                                                                                       'in_nucast_pkts': '77273',
                                                                                       'in_octets': '20153608281',
                                                                                       'in_ucast_pkts': '54448909',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2576',
                                                                                       'out_octets': '171013626473',
                                                                                       'out_ucast_pkts': '133959810',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NkEzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:23:70'],
                                                                                       'in_nucast_pkts': '77267',
                                                                                       'in_octets': '140871742311',
                                                                                       'in_ucast_pkts': '650119495',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2576',
                                                                                       'out_octets': '2152820974527',
                                                                                       'out_ucast_pkts': '1546960421',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NkI0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4b:fc:e0'],
                                                                                       'in_nucast_pkts': '6380',
                                                                                       'in_octets': '10392725188',
                                                                                       'in_ucast_pkts': '13276517',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '214',
                                                                                       'out_octets': '42341526171',
                                                                                       'out_ucast_pkts': '33214746',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NzU5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:37:40'],
                                                                                       'in_nucast_pkts': '78633',
                                                                                       'in_octets': '41130133183',
                                                                                       'in_ucast_pkts': '267578468',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6644',
                                                                                       'out_octets': '983360137787',
                                                                                       'out_ucast_pkts': '737983039',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTk3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:b4:b0'],
                                                                                       'in_nucast_pkts': '71032',
                                                                                       'in_octets': '91458886374',
                                                                                       'in_ucast_pkts': '156074061',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6014',
                                                                                       'out_octets': '492238996224',
                                                                                       'out_ucast_pkts': '357362480',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RUZCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:aa:e0'],
                                                                                       'in_nucast_pkts': '151308',
                                                                                       'in_octets': '8129995719',
                                                                                       'in_ucast_pkts': '14979672',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '4924',
                                                                                       'out_octets': '4163271384',
                                                                                       'out_ucast_pkts': '8737748',
                                                                                       'poller_hash': 'QURUTjIzMTI0NEJBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:8b:90'],
                                                                                       'in_nucast_pkts': '168',
                                                                                       'in_octets': '24287069',
                                                                                       'in_ucast_pkts': '268180',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '13',
                                                                                       'out_octets': '723445891',
                                                                                       'out_ucast_pkts': '488924',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QjI0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4b:fe:d0'],
                                                                                       'in_nucast_pkts': '2481',
                                                                                       'in_octets': '671175529',
                                                                                       'in_ucast_pkts': '4503121',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '84',
                                                                                       'out_octets': '23274656091',
                                                                                       'out_ucast_pkts': '16045359',
                                                                                       'poller_hash': 'QURUTjIzMTQ1MTIwIHBlZXJpbnRm'},
                                                                               {       'in_nucast_pkts': '0',
                                                                                       'in_octets': '0',
                                                                                       'in_ucast_pkts': '0',
                                                                                       'oper_up': False,
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '0',
                                                                                       'out_ucast_pkts': '0',
                                                                                       'poller_hash': 'QURUTjI0MzYzRDNBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:39:90'],
                                                                                       'in_nucast_pkts': '80304',
                                                                                       'in_octets': '183035148948',
                                                                                       'in_ucast_pkts': '1236860971',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6637',
                                                                                       'out_octets': '4528321524493',
                                                                                       'out_ucast_pkts': '3140107222',
                                                                                       'poller_hash': 'QURUTjI0MzE0MTk1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:e6:40'],
                                                                                       'in_nucast_pkts': '77272',
                                                                                       'in_octets': '33000539155',
                                                                                       'in_ucast_pkts': '261722329',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2576',
                                                                                       'out_octets': '754928010546',
                                                                                       'out_ucast_pkts': '529398495',
                                                                                       'poller_hash': 'QURUTjI0MzE0MUEzIHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/6',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC82',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/6',
                                                                                      'id': 'xgspon '
                                                                                            '0/6',
                                                                                      'links': [       {       'connected_time': '2317060',
                                                                                                               'fiber_length': 5521,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTJBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '2317056',
                                                                                                               'fiber_length': 5919,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RUE0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '4936369',
                                                                                                               'fiber_length': 5995,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRkY1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '2317061',
                                                                                                               'fiber_length': 5797,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRjE4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '2317059',
                                                                                                               'fiber_length': 6115,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTk1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '2317061',
                                                                                                               'fiber_length': 6181,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MENDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '2317060',
                                                                                                               'fiber_length': 6734,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTExIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '5440097',
                                                                                                               'fiber_length': 7635,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MjA2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '2317060',
                                                                                                               'fiber_length': 5523,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTREIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '2317056',
                                                                                                               'fiber_length': 5847,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MENEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '2317059',
                                                                                                               'fiber_length': 6444,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTRCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '2317052',
                                                                                                               'fiber_length': 6030,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NkEzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '2317058',
                                                                                                               'fiber_length': 6378,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NkI0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '190728',
                                                                                                               'fiber_length': 6744,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NzU5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '2317055',
                                                                                                               'fiber_length': 6051,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTk3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '2096136',
                                                                                                               'fiber_length': 6816,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RUZCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -23.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '5440101',
                                                                                                               'fiber_length': 7484,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NEJBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '4440',
                                                                                                               'fiber_length': 6580,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QjI0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '96470',
                                                                                                               'fiber_length': 5781,
                                                                                                               'poller_hash': 'QURUTjIzMTQ1MTIwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '1634735',
                                                                                                               'fiber_length': 6741,
                                                                                                               'poller_hash': 'QURUTjI0MzYzRDNBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '2317064',
                                                                                                               'fiber_length': 6741,
                                                                                                               'poller_hash': 'QURUTjI0MzE0MTk1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595},
                                                                                                       {       'connected_time': '2317064',
                                                                                                               'fiber_length': 6541,
                                                                                                               'poller_hash': 'QURUTjI0MzE0MUEzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4595}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/6',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC82',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/7',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:4c:01:c0'],
                                                                                       'in_nucast_pkts': '161659',
                                                                                       'in_octets': '50049796547',
                                                                                       'in_ucast_pkts': '152471599',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5396',
                                                                                       'out_octets': '508085431347',
                                                                                       'out_ucast_pkts': '392883353',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDYxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:04:00'],
                                                                                       'in_nucast_pkts': '79177',
                                                                                       'in_octets': '52585387879',
                                                                                       'in_ucast_pkts': '290160443',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2576',
                                                                                       'out_octets': '988651401643',
                                                                                       'out_ucast_pkts': '738980630',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTcxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:82:c0'],
                                                                                       'in_nucast_pkts': '186255',
                                                                                       'in_octets': '241400071505',
                                                                                       'in_ucast_pkts': '1428422001',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15626',
                                                                                       'out_octets': '4760659326578',
                                                                                       'out_ucast_pkts': '3461599307',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTUyIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:08:70'],
                                                                                       'in_nucast_pkts': '93222',
                                                                                       'in_octets': '47749529318',
                                                                                       'in_ucast_pkts': '316280876',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '7869',
                                                                                       'out_octets': '1402728868805',
                                                                                       'out_ucast_pkts': '1073548328',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTREIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:3a:e0'],
                                                                                       'in_nucast_pkts': '15047',
                                                                                       'in_octets': '8726665362',
                                                                                       'in_ucast_pkts': '29108039',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1273',
                                                                                       'out_octets': '76215660012',
                                                                                       'out_ucast_pkts': '56408305',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTZBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:d8:90'],
                                                                                       'in_nucast_pkts': '162985',
                                                                                       'in_octets': '23530899217',
                                                                                       'in_ucast_pkts': '109177020',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5398',
                                                                                       'out_octets': '480313137336',
                                                                                       'out_ucast_pkts': '355957819',
                                                                                       'poller_hash': 'QURUTjIzMTI0NDVDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a7:30'],
                                                                                       'in_nucast_pkts': '28072',
                                                                                       'in_octets': '24195404784',
                                                                                       'in_ucast_pkts': '129400634',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '936',
                                                                                       'out_octets': '612910262602',
                                                                                       'out_ucast_pkts': '440182029',
                                                                                       'poller_hash': 'QURUTjIzMTI0NEJDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:50:10'],
                                                                                       'in_nucast_pkts': '181362',
                                                                                       'in_octets': '156763924400',
                                                                                       'in_ucast_pkts': '451405583',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6046',
                                                                                       'out_octets': '1183497788545',
                                                                                       'out_ucast_pkts': '929911749',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTNBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8f:d0'],
                                                                                       'in_nucast_pkts': '186588',
                                                                                       'in_octets': '11791523102',
                                                                                       'in_ucast_pkts': '32348353',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15625',
                                                                                       'out_octets': '45114517815',
                                                                                       'out_ucast_pkts': '40397613',
                                                                                       'poller_hash': 'QURUTjIzMTI0MUMwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:92:e0'],
                                                                                       'in_nucast_pkts': '117189',
                                                                                       'in_octets': '120100217958',
                                                                                       'in_ucast_pkts': '671422934',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '9922',
                                                                                       'out_octets': '2910180516762',
                                                                                       'out_ucast_pkts': '2077796789',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTU4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:02:f0'],
                                                                                       'in_nucast_pkts': '181344',
                                                                                       'in_octets': '19922779626',
                                                                                       'in_ucast_pkts': '37878045',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6046',
                                                                                       'out_octets': '73347970096',
                                                                                       'out_ucast_pkts': '65446477',
                                                                                       'poller_hash': 'QURUTjIzMTI1MEREIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:65:a0'],
                                                                                       'in_nucast_pkts': '184824',
                                                                                       'in_octets': '120709171346',
                                                                                       'in_ucast_pkts': '222440403',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15627',
                                                                                       'out_octets': '704134560785',
                                                                                       'out_ucast_pkts': '529806623',
                                                                                       'poller_hash': 'QURUTjIzMTI1MEJCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:ce:70'],
                                                                                       'in_nucast_pkts': '181594',
                                                                                       'in_octets': '79498161718',
                                                                                       'in_ucast_pkts': '544856175',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6046',
                                                                                       'out_octets': '2679365284691',
                                                                                       'out_ucast_pkts': '1839981061',
                                                                                       'poller_hash': 'QURUTjIzMTQ0Nzk2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:84:90'],
                                                                                       'in_nucast_pkts': '70409',
                                                                                       'in_octets': '31887830912',
                                                                                       'in_ucast_pkts': '152296330',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5871',
                                                                                       'out_octets': '756680875145',
                                                                                       'out_ucast_pkts': '540611654',
                                                                                       'poller_hash': 'QURUTjIzMTQ0ODZDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:78:80'],
                                                                                       'in_nucast_pkts': '186260',
                                                                                       'in_octets': '32708626057',
                                                                                       'in_ucast_pkts': '75413117',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15613',
                                                                                       'out_octets': '151746807797',
                                                                                       'out_ucast_pkts': '132901226',
                                                                                       'poller_hash': 'QURUTjIzMTQ0Njk5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8a:50'],
                                                                                       'in_nucast_pkts': '56138',
                                                                                       'in_octets': '70658652100',
                                                                                       'in_ucast_pkts': '260887099',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '4750',
                                                                                       'out_octets': '1013212977198',
                                                                                       'out_ucast_pkts': '735130401',
                                                                                       'poller_hash': 'QURUTjIzMTQ0Q0MzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:f1:00'],
                                                                                       'in_nucast_pkts': '108558',
                                                                                       'in_octets': '128047818368',
                                                                                       'in_ucast_pkts': '389186495',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3756',
                                                                                       'out_octets': '1605817453286',
                                                                                       'out_ucast_pkts': '1183465374',
                                                                                       'poller_hash': 'QURUTjIzMTI0MjE0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:a9:00'],
                                                                                       'in_nucast_pkts': '19235',
                                                                                       'in_octets': '9067388101',
                                                                                       'in_ucast_pkts': '11640227',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '642',
                                                                                       'out_octets': '32123065177',
                                                                                       'out_ucast_pkts': '25321888',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QzRFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:fd:b0'],
                                                                                       'in_nucast_pkts': '19253',
                                                                                       'in_octets': '8221915797',
                                                                                       'in_ucast_pkts': '19612117',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '643',
                                                                                       'out_octets': '68669345709',
                                                                                       'out_ucast_pkts': '50805687',
                                                                                       'poller_hash': 'QURUTjI0MzE0NEZCIHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/7',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC83',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/7',
                                                                                      'id': 'xgspon '
                                                                                            '0/7',
                                                                                      'links': [       {       'connected_time': '4857795',
                                                                                                               'fiber_length': 10820,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDYxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.431},
                                                                                                       {       'connected_time': '2317062',
                                                                                                               'fiber_length': 10756,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTcxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.431},
                                                                                                       {       'connected_time': '5440101',
                                                                                                               'fiber_length': 9016,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTUyIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.431},
                                                                                                       {       'connected_time': '2742692',
                                                                                                               'fiber_length': 10425,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTREIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.431},
                                                                                                       {       'connected_time': '443591',
                                                                                                               'fiber_length': 10462,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTZBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.431},
                                                                                                       {       'connected_time': '4857797',
                                                                                                               'fiber_length': 10872,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NDVDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.431},
                                                                                                       {       'connected_time': '841331',
                                                                                                               'fiber_length': 9328,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NEJDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.431},
                                                                                                       {       'connected_time': '5440102',
                                                                                                               'fiber_length': 9589,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTNBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.431},
                                                                                                       {       'connected_time': '5440102',
                                                                                                               'fiber_length': 10748,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MUMwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.431},
                                                                                                       {       'connected_time': '3456381',
                                                                                                               'fiber_length': 10811,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTU4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.431},
                                                                                                       {       'connected_time': '5440069',
                                                                                                               'fiber_length': 8976,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MEREIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.431},
                                                                                                       {       'connected_time': '5440069',
                                                                                                               'fiber_length': 8993,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MEJCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.431},
                                                                                                       {       'connected_time': '5440100',
                                                                                                               'fiber_length': 9375,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0Nzk2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.431},
                                                                                                       {       'connected_time': '2045293',
                                                                                                               'fiber_length': 10744,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0ODZDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.431},
                                                                                                       {       'connected_time': '5440101',
                                                                                                               'fiber_length': 8892,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0Njk5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.431},
                                                                                                       {       'connected_time': '1656089',
                                                                                                               'fiber_length': 10521,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0Q0MzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.431},
                                                                                                       {       'connected_time': '3232209',
                                                                                                               'fiber_length': 9856,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MjE0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.431},
                                                                                                       {       'connected_time': '576233',
                                                                                                               'fiber_length': 10106,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QzRFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.431},
                                                                                                       {       'connected_time': '576799',
                                                                                                               'fiber_length': 10046,
                                                                                                               'poller_hash': 'QURUTjI0MzE0NEZCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.431}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/7',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC83',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/8',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:dd:73:50'],
                                                                                       'in_nucast_pkts': '17352',
                                                                                       'in_octets': '12583730852',
                                                                                       'in_ucast_pkts': '15238765',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '32349249168',
                                                                                       'out_ucast_pkts': '27675715',
                                                                                       'poller_hash': 'QURUTjIzMTI0REZCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:75:a0'],
                                                                                       'in_nucast_pkts': '17350',
                                                                                       'in_octets': '4068733367',
                                                                                       'in_ucast_pkts': '27154906',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '75599876134',
                                                                                       'out_ucast_pkts': '52488869',
                                                                                       'poller_hash': 'QURUTjIzMTI0REM3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:76:a0'],
                                                                                       'in_nucast_pkts': '13965',
                                                                                       'in_octets': '8718124297',
                                                                                       'in_ucast_pkts': '31366044',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1182',
                                                                                       'out_octets': '87654360048',
                                                                                       'out_ucast_pkts': '62827471',
                                                                                       'poller_hash': 'QURUTjIzMTI0RUZBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:81:80'],
                                                                                       'in_nucast_pkts': '17645',
                                                                                       'in_octets': '7043293710',
                                                                                       'in_ucast_pkts': '15487796',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '58159716504',
                                                                                       'out_ucast_pkts': '44857988',
                                                                                       'poller_hash': 'QURUTjIzMTI0RURGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:79:10'],
                                                                                       'in_nucast_pkts': '17350',
                                                                                       'in_octets': '1766869586',
                                                                                       'in_ucast_pkts': '9286544',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '22473306375',
                                                                                       'out_ucast_pkts': '16882303',
                                                                                       'poller_hash': 'QURUTjIzMTI1MUY3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:71:e0'],
                                                                                       'in_nucast_pkts': '17352',
                                                                                       'in_octets': '19201215989',
                                                                                       'in_ucast_pkts': '43126746',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '94247613907',
                                                                                       'out_ucast_pkts': '74374409',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTg0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:08:10'],
                                                                                       'in_nucast_pkts': '17354',
                                                                                       'in_octets': '63139814593',
                                                                                       'in_ucast_pkts': '195740707',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '575283213404',
                                                                                       'out_ucast_pkts': '422753217',
                                                                                       'poller_hash': 'QURUTjIzMTI1MUY2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:32:11'],
                                                                                       'in_nucast_pkts': '312',
                                                                                       'in_octets': '19165886336',
                                                                                       'in_ucast_pkts': '38938258',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '135508186721',
                                                                                       'out_ucast_pkts': '106776301',
                                                                                       'poller_hash': 'QURUTjIzMTI0RUQzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:07:b0'],
                                                                                       'in_nucast_pkts': '17349',
                                                                                       'in_octets': '535160215',
                                                                                       'in_ucast_pkts': '1205277',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '2244417648',
                                                                                       'out_ucast_pkts': '1800523',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTQzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:04:10'],
                                                                                       'in_nucast_pkts': '17349',
                                                                                       'in_octets': '57260055059',
                                                                                       'in_ucast_pkts': '185213121',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '715177338108',
                                                                                       'out_ucast_pkts': '502819501',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTAzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8e:b0'],
                                                                                       'in_nucast_pkts': '17357',
                                                                                       'in_octets': '8271351533',
                                                                                       'in_ucast_pkts': '41007607',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '239064115958',
                                                                                       'out_ucast_pkts': '176634277',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTJFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:07:60'],
                                                                                       'in_nucast_pkts': '17359',
                                                                                       'in_octets': '15589904464',
                                                                                       'in_ucast_pkts': '36724183',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '214990073767',
                                                                                       'out_ucast_pkts': '150125402',
                                                                                       'poller_hash': 'QURUTjIzMTQ0ODNCIHBlZXJpbnRm'},
                                                                               {       'in_nucast_pkts': '92656',
                                                                                       'in_octets': '1243896716',
                                                                                       'in_ucast_pkts': '1237098',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '451',
                                                                                       'out_octets': '1213350778',
                                                                                       'out_ucast_pkts': '1231323',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NzQ4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:b3:a0'],
                                                                                       'in_nucast_pkts': '17077',
                                                                                       'in_octets': '5288053961',
                                                                                       'in_ucast_pkts': '18085701',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '63945371536',
                                                                                       'out_ucast_pkts': '50263467',
                                                                                       'poller_hash': 'QURUTjIzMTQ0OEQxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8a:10'],
                                                                                       'in_nucast_pkts': '17358',
                                                                                       'in_octets': '5720460979',
                                                                                       'in_ucast_pkts': '54734286',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '170594327927',
                                                                                       'out_ucast_pkts': '116816421',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTlDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:3c:30'],
                                                                                       'in_nucast_pkts': '11978',
                                                                                       'in_octets': '3250210157',
                                                                                       'in_ucast_pkts': '24466505',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1013',
                                                                                       'out_octets': '75017766361',
                                                                                       'out_ucast_pkts': '51821106',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QjJDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:93:c0'],
                                                                                       'in_nucast_pkts': '17353',
                                                                                       'in_octets': '429884396',
                                                                                       'in_ucast_pkts': '648423',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '463891147',
                                                                                       'out_ucast_pkts': '612318',
                                                                                       'poller_hash': 'QURUTjIzMTQ0Q0Q1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:75:00'],
                                                                                       'in_nucast_pkts': '17344',
                                                                                       'in_octets': '4382109537',
                                                                                       'in_ucast_pkts': '9379472',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1465',
                                                                                       'out_octets': '26920753660',
                                                                                       'out_ucast_pkts': '21845818',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QzQ2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:9c:b0'],
                                                                                       'in_nucast_pkts': '17077',
                                                                                       'in_octets': '21087915910',
                                                                                       'in_ucast_pkts': '52964384',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '151984788371',
                                                                                       'out_ucast_pkts': '113414646',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QjREIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:d0:70'],
                                                                                       'in_nucast_pkts': '11789',
                                                                                       'in_octets': '1576302843',
                                                                                       'in_ucast_pkts': '7857963',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '394',
                                                                                       'out_octets': '29168052431',
                                                                                       'out_ucast_pkts': '21875490',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTcwIHBlZXJpbnRm'},
                                                                               {       'in_nucast_pkts': '0',
                                                                                       'in_octets': '0',
                                                                                       'in_ucast_pkts': '0',
                                                                                       'oper_up': False,
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '0',
                                                                                       'out_ucast_pkts': '0',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RjAwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:51:30'],
                                                                                       'in_nucast_pkts': '17074',
                                                                                       'in_octets': '8007726891',
                                                                                       'in_ucast_pkts': '57195326',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '170355661509',
                                                                                       'out_ucast_pkts': '126103840',
                                                                                       'poller_hash': 'QURUTjIzMTI0N0ExIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:26:a0'],
                                                                                       'in_nucast_pkts': '17076',
                                                                                       'in_octets': '5211792737',
                                                                                       'in_ucast_pkts': '32682412',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '104083040915',
                                                                                       'out_ucast_pkts': '72720282',
                                                                                       'poller_hash': 'QURUTjIzMTI0QzZBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:ac:60'],
                                                                                       'in_nucast_pkts': '17229',
                                                                                       'in_octets': '4548076901',
                                                                                       'in_ucast_pkts': '56225134',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '178557922115',
                                                                                       'out_ucast_pkts': '119393201',
                                                                                       'poller_hash': 'QURUTjI0MzYzREM5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:27:10'],
                                                                                       'in_nucast_pkts': '15132',
                                                                                       'in_octets': '30461726021',
                                                                                       'in_ucast_pkts': '153669174',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '505',
                                                                                       'out_octets': '472024713335',
                                                                                       'out_ucast_pkts': '353532698',
                                                                                       'poller_hash': 'QURUTjI0MzE0MzE0IHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/8',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC84',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/8',
                                                                                      'id': 'xgspon '
                                                                                            '0/8',
                                                                                      'links': [       {       'connected_time': '511510',
                                                                                                               'fiber_length': 2183,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REZCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511510',
                                                                                                               'fiber_length': 2394,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REM3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '411662',
                                                                                                               'fiber_length': 2496,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RUZBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511510',
                                                                                                               'fiber_length': 3018,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RURGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511508',
                                                                                                               'fiber_length': 2254,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MUY3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511511',
                                                                                                               'fiber_length': 3256,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTg0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511509',
                                                                                                               'fiber_length': 2382,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MUY2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511506',
                                                                                                               'fiber_length': 2629,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RUQzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511506',
                                                                                                               'fiber_length': 3430,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTQzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511509',
                                                                                                               'fiber_length': 3301,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTAzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511508',
                                                                                                               'fiber_length': 3383,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTJFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511506',
                                                                                                               'fiber_length': 2182,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0ODNCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511508',
                                                                                                               'fiber_length': 3353,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NzQ4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511504',
                                                                                                               'fiber_length': 2661,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0OEQxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511508',
                                                                                                               'fiber_length': 3282,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTlDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '352937',
                                                                                                               'fiber_length': 4011,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QjJDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511508',
                                                                                                               'fiber_length': 3249,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0Q0Q1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511503',
                                                                                                               'fiber_length': 2665,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QzQ2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511508',
                                                                                                               'fiber_length': 3298,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QjREIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '352937',
                                                                                                               'fiber_length': 3865,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTcwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511502',
                                                                                                               'fiber_length': 3323,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RjAwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511512',
                                                                                                               'fiber_length': 3094,
                                                                                                               'poller_hash': 'QURUTjIzMTI0N0ExIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511512',
                                                                                                               'fiber_length': 3062,
                                                                                                               'poller_hash': 'QURUTjIzMTI0QzZBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '511516',
                                                                                                               'fiber_length': 3347,
                                                                                                               'poller_hash': 'QURUTjI0MzYzREM5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577},
                                                                                                       {       'connected_time': '453158',
                                                                                                               'fiber_length': 3270,
                                                                                                               'poller_hash': 'QURUTjI0MzE0MzE0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2577}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/8',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC84',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/9',
                                                              'links': [       {       'bridged_mac_addresses': [       '38:f8:f6:52:a9:50'],
                                                                                       'in_nucast_pkts': '17678',
                                                                                       'in_octets': '31181646609',
                                                                                       'in_ucast_pkts': '145785231',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1469',
                                                                                       'out_octets': '521978203351',
                                                                                       'out_ucast_pkts': '375429160',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDkxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:7e:50'],
                                                                                       'in_nucast_pkts': '17350',
                                                                                       'in_octets': '6424793475',
                                                                                       'in_ucast_pkts': '15583782',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '66052251294',
                                                                                       'out_ucast_pkts': '52733391',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTdBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:b1:c0'],
                                                                                       'in_nucast_pkts': '17800',
                                                                                       'in_octets': '90235861365',
                                                                                       'in_ucast_pkts': '202145141',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1469',
                                                                                       'out_octets': '549655463279',
                                                                                       'out_ucast_pkts': '408842240',
                                                                                       'poller_hash': 'QURUTjIzMTIzRTlDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:9c:b0'],
                                                                                       'in_nucast_pkts': '17500',
                                                                                       'in_octets': '43499037247',
                                                                                       'in_ucast_pkts': '94176808',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '298195340695',
                                                                                       'out_ucast_pkts': '223126720',
                                                                                       'poller_hash': 'QURUTjIzMTI0REVCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:87:80'],
                                                                                       'in_nucast_pkts': '17350',
                                                                                       'in_octets': '8638783925',
                                                                                       'in_ucast_pkts': '46431856',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '133805388064',
                                                                                       'out_ucast_pkts': '99643458',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDkzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:b4:c0'],
                                                                                       'in_nucast_pkts': '17073',
                                                                                       'in_octets': '11314547205',
                                                                                       'in_ucast_pkts': '22941611',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '98372197237',
                                                                                       'out_ucast_pkts': '76185217',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDQ2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:88:60'],
                                                                                       'in_nucast_pkts': '17350',
                                                                                       'in_octets': '9058510653',
                                                                                       'in_ucast_pkts': '39985645',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '241684711586',
                                                                                       'out_ucast_pkts': '170715081',
                                                                                       'poller_hash': 'QURUTjIzMTI0OTFFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8a:b1'],
                                                                                       'in_nucast_pkts': '390',
                                                                                       'in_octets': '11166614608',
                                                                                       'in_ucast_pkts': '24360922',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '84529303524',
                                                                                       'out_ucast_pkts': '65666060',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTNBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:7d:c0'],
                                                                                       'in_nucast_pkts': '17779',
                                                                                       'in_octets': '18985244898',
                                                                                       'in_ucast_pkts': '106949594',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '438385612413',
                                                                                       'out_ucast_pkts': '315523487',
                                                                                       'poller_hash': 'QURUTjIzMTI0REYzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:74:b0'],
                                                                                       'in_nucast_pkts': '17349',
                                                                                       'in_octets': '930032427',
                                                                                       'in_ucast_pkts': '3534867',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '8545155679',
                                                                                       'out_ucast_pkts': '6754964',
                                                                                       'poller_hash': 'QURUTjIzMTI1MThFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:2a:40'],
                                                                                       'in_nucast_pkts': '17788',
                                                                                       'in_octets': '14946109629',
                                                                                       'in_ucast_pkts': '58363627',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1468',
                                                                                       'out_octets': '294012971396',
                                                                                       'out_ucast_pkts': '213405469',
                                                                                       'poller_hash': 'QURUTjIzMTI0RENFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8d:d0'],
                                                                                       'in_nucast_pkts': '17350',
                                                                                       'in_octets': '2315752953',
                                                                                       'in_ucast_pkts': '7552312',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '20525064080',
                                                                                       'out_ucast_pkts': '17015732',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTIyIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:66:60'],
                                                                                       'in_nucast_pkts': '17777',
                                                                                       'in_octets': '13446246092',
                                                                                       'in_ucast_pkts': '88985714',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '326420716091',
                                                                                       'out_ucast_pkts': '238645457',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDlFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8a:c0'],
                                                                                       'in_nucast_pkts': '17378',
                                                                                       'in_octets': '4864823600',
                                                                                       'in_ucast_pkts': '9100075',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '32633620755',
                                                                                       'out_ucast_pkts': '26720543',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTJEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ad:50'],
                                                                                       'in_nucast_pkts': '17075',
                                                                                       'in_octets': '11346630986',
                                                                                       'in_ucast_pkts': '57003429',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '229678363616',
                                                                                       'out_ucast_pkts': '168885489',
                                                                                       'poller_hash': 'QURUTjIzMTI0MDhDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:73:90'],
                                                                                       'in_nucast_pkts': '17349',
                                                                                       'in_octets': '44042595027',
                                                                                       'in_ucast_pkts': '73274929',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '235157386943',
                                                                                       'out_ucast_pkts': '174144687',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDFEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:6e:20'],
                                                                                       'in_nucast_pkts': '17358',
                                                                                       'in_octets': '8390216571',
                                                                                       'in_ucast_pkts': '66250060',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '324869683562',
                                                                                       'out_ucast_pkts': '223917456',
                                                                                       'poller_hash': 'QURUTjIzMTI0REY1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:88:c0'],
                                                                                       'in_nucast_pkts': '17349',
                                                                                       'in_octets': '13287612317',
                                                                                       'in_ucast_pkts': '83805288',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '266246543460',
                                                                                       'out_ucast_pkts': '186300386',
                                                                                       'poller_hash': 'QURUTjIzMTI0NzEzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:7b:70'],
                                                                                       'in_nucast_pkts': '17642',
                                                                                       'in_octets': '13216747722',
                                                                                       'in_ucast_pkts': '77811734',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '213176396900',
                                                                                       'out_ucast_pkts': '148724509',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTE5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:82:00'],
                                                                                       'in_nucast_pkts': '17351',
                                                                                       'in_octets': '4500406894',
                                                                                       'in_ucast_pkts': '13799152',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '64753526744',
                                                                                       'out_ucast_pkts': '51310902',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTY3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:83:40'],
                                                                                       'in_nucast_pkts': '17413',
                                                                                       'in_octets': '21108613447',
                                                                                       'in_ucast_pkts': '66454572',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1472',
                                                                                       'out_octets': '265124843284',
                                                                                       'out_ucast_pkts': '197979817',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTNGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:03:e0'],
                                                                                       'in_nucast_pkts': '17573',
                                                                                       'in_octets': '16510429418',
                                                                                       'in_ucast_pkts': '47316879',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '581',
                                                                                       'out_octets': '132080811021',
                                                                                       'out_ucast_pkts': '102434920',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTIzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:70:f0'],
                                                                                       'in_nucast_pkts': '17356',
                                                                                       'in_octets': '12201351423',
                                                                                       'in_ucast_pkts': '96462911',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '280128997438',
                                                                                       'out_ucast_pkts': '210615612',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTI3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4b:fa:00'],
                                                                                       'in_nucast_pkts': '17077',
                                                                                       'in_octets': '8081348185',
                                                                                       'in_ucast_pkts': '45173344',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '191072021092',
                                                                                       'out_ucast_pkts': '133766604',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTY0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:87:c0'],
                                                                                       'in_nucast_pkts': '17353',
                                                                                       'in_octets': '4808821172',
                                                                                       'in_ucast_pkts': '26666839',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '90330747117',
                                                                                       'out_ucast_pkts': '65389355',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTZCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:03:d0'],
                                                                                       'in_nucast_pkts': '2084',
                                                                                       'in_octets': '274980763',
                                                                                       'in_ucast_pkts': '775381',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '70',
                                                                                       'out_octets': '1458085763',
                                                                                       'out_ucast_pkts': '1423806',
                                                                                       'poller_hash': 'QURUTjIzMTIzRkVDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:88:b0'],
                                                                                       'in_nucast_pkts': '17354',
                                                                                       'in_octets': '1412860165',
                                                                                       'in_ucast_pkts': '5199266',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '18726906322',
                                                                                       'out_ucast_pkts': '14643689',
                                                                                       'poller_hash': 'QURUTjIzMTIzRUE4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8b:c0'],
                                                                                       'in_nucast_pkts': '17350',
                                                                                       'in_octets': '3183811034',
                                                                                       'in_ucast_pkts': '28605061',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '110348349871',
                                                                                       'out_ucast_pkts': '77108246',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTFGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:82:30'],
                                                                                       'in_nucast_pkts': '17351',
                                                                                       'in_octets': '5581427159',
                                                                                       'in_ucast_pkts': '22229830',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '61468584165',
                                                                                       'out_ucast_pkts': '53311404',
                                                                                       'poller_hash': 'QURUTjIzMTI0MTI4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:86:d1'],
                                                                                       'in_nucast_pkts': '314',
                                                                                       'in_octets': '9818933607',
                                                                                       'in_ucast_pkts': '26316509',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '108363902187',
                                                                                       'out_ucast_pkts': '77185946',
                                                                                       'poller_hash': 'QURUTjIzMTQ0N0E0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:04:e0'],
                                                                                       'in_nucast_pkts': '17075',
                                                                                       'in_octets': '11614398483',
                                                                                       'in_ucast_pkts': '26579067',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '72537821329',
                                                                                       'out_ucast_pkts': '60433602',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTY5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:3b:c0'],
                                                                                       'in_nucast_pkts': '17349',
                                                                                       'in_octets': '32971990275',
                                                                                       'in_ucast_pkts': '47577357',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1467',
                                                                                       'out_octets': '89779815388',
                                                                                       'out_ucast_pkts': '72520182',
                                                                                       'poller_hash': 'QURUTjIzMTI0MDA4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:b7:d0'],
                                                                                       'in_nucast_pkts': '17079',
                                                                                       'in_octets': '21339841748',
                                                                                       'in_ucast_pkts': '84681430',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '570',
                                                                                       'out_octets': '343899216165',
                                                                                       'out_ucast_pkts': '254910822',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RUQzIHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/9',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC85',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/9',
                                                                                      'id': 'xgspon '
                                                                                            '0/9',
                                                                                      'links': [       {       'connected_time': '511494',
                                                                                                               'fiber_length': 5783,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDkxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511506',
                                                                                                               'fiber_length': 5853,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTdBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511514',
                                                                                                               'fiber_length': 5669,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRTlDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511508',
                                                                                                               'fiber_length': 3861,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REVCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511497',
                                                                                                               'fiber_length': 4090,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDkzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511509',
                                                                                                               'fiber_length': 4612,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDQ2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511495',
                                                                                                               'fiber_length': 5476,
                                                                                                               'poller_hash': 'QURUTjIzMTI0OTFFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511498',
                                                                                                               'fiber_length': 5824,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTNBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511514',
                                                                                                               'fiber_length': 3643,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REYzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511497',
                                                                                                               'fiber_length': 3909,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MThFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511508',
                                                                                                               'fiber_length': 5338,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RENFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511508',
                                                                                                               'fiber_length': 3743,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTIyIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511509',
                                                                                                               'fiber_length': 4273,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDlFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511508',
                                                                                                               'fiber_length': 4867,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTJEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511501',
                                                                                                               'fiber_length': 5423,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MDhDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511506',
                                                                                                               'fiber_length': 4938,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDFEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511508',
                                                                                                               'fiber_length': 5198,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REY1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -23.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511499',
                                                                                                               'fiber_length': 5184,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NzEzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511513',
                                                                                                               'fiber_length': 5202,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTE5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511511',
                                                                                                               'fiber_length': 5100,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTY3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511512',
                                                                                                               'fiber_length': 5421,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTNGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511512',
                                                                                                               'fiber_length': 4748,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTIzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511508',
                                                                                                               'fiber_length': 4716,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTI3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511507',
                                                                                                               'fiber_length': 4657,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTY0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511507',
                                                                                                               'fiber_length': 5879,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTZCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '61774',
                                                                                                               'fiber_length': 5819,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRkVDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511509',
                                                                                                               'fiber_length': 4449,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRUE4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511512',
                                                                                                               'fiber_length': 4391,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTFGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511513',
                                                                                                               'fiber_length': 5794,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MTI4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511505',
                                                                                                               'fiber_length': 5397,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0N0E0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511511',
                                                                                                               'fiber_length': 4383,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTY5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511513',
                                                                                                               'fiber_length': 5786,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MDA4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975},
                                                                                                       {       'connected_time': '511498',
                                                                                                               'fiber_length': 5736,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RUQzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3975}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/9',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC85',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': False,
                                                              'id': 'hundred-gigabit-ethernet '
                                                                    '0/1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '38:f8:f6:ac:65:ce',
                                                              'manufacturer': 'Adtran',
                                                              'name': 'hundred-gigabit-ethernet '
                                                                      '0/1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgaHVuZHJlZC1naWdhYml0LWV0aGVybmV0IDAvMQ==',
                                                              'speed': '100000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': 'hundred-gigabit-ethernet '
                                                                    '0/2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '38:f8:f6:ac:65:cf',
                                                              'manufacturer': 'Adtran',
                                                              'name': 'hundred-gigabit-ethernet '
                                                                      '0/2',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgaHVuZHJlZC1naWdhYml0LWV0aGVybmV0IDAvMg==',
                                                              'speed': '100000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': 'hundred-gigabit-ethernet '
                                                                    '0/3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '38:f8:f6:ac:65:d0',
                                                              'manufacturer': 'Adtran',
                                                              'name': 'hundred-gigabit-ethernet '
                                                                      '0/3',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgaHVuZHJlZC1naWdhYml0LWV0aGVybmV0IDAvMw==',
                                                              'speed': '100000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': 'hundred-gigabit-ethernet '
                                                                    '0/4',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '38:f8:f6:ac:65:d1',
                                                              'manufacturer': 'Adtran',
                                                              'name': 'hundred-gigabit-ethernet '
                                                                      '0/4',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgaHVuZHJlZC1naWdhYml0LWV0aGVybmV0IDAvNA==',
                                                              'speed': '100000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': 'management 0/1',
                                                              'mac_address': '38:f8:f6:ac:65:c8',
                                                              'manufacturer': 'Adtran',
                                                              'name': 'management 0/1',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgbWFuYWdlbWVudCAwLzE=',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': 'ten-gigabit-ethernet '
                                                                    '0/1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '58275531',
                                                              'in_octets': '49816948633458',
                                                              'in_ucast_pkts': '450096209404',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '38:f8:f6:ac:65:ca',
                                                              'manufacturer': 'Adtran',
                                                              'name': 'ten-gigabit-ethernet '
                                                                      '0/1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '61592239',
                                                              'out_octets': '48973188331903',
                                                              'out_ucast_pkts': '176504962513',
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgdGVuLWdpZ2FiaXQtZXRoZXJuZXQgMC8x',
                                                              'speed': '10000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': 'ten-gigabit-ethernet '
                                                                    '0/2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '38:f8:f6:ac:65:cb',
                                                              'manufacturer': 'Adtran',
                                                              'name': 'ten-gigabit-ethernet '
                                                                      '0/2',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgdGVuLWdpZ2FiaXQtZXRoZXJuZXQgMC8y',
                                                              'speed': '10000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': 'ten-gigabit-ethernet '
                                                                    '0/3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '38:f8:f6:ac:65:cc',
                                                              'manufacturer': 'Adtran',
                                                              'name': 'ten-gigabit-ethernet '
                                                                      '0/3',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgdGVuLWdpZ2FiaXQtZXRoZXJuZXQgMC8z',
                                                              'speed': '10000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': 'ten-gigabit-ethernet '
                                                                    '0/4',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '38:f8:f6:ac:65:cd',
                                                              'manufacturer': 'Adtran',
                                                              'name': 'ten-gigabit-ethernet '
                                                                      '0/4',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgdGVuLWdpZ2FiaXQtZXRoZXJuZXQgMC80',
                                                              'speed': '10000000000',
                                                              'type': 6}],
                                'manufacturer': 'Adtran',
                                'mem': 55.04,
                                'model': 'SDX 6320-16',
                                'name': 'IndianBayou-x1',
                                'poller_hash': 'b2x0IExCQURUTjIzMjJBQTIzNA==',
                                'serial_number': 'LBADTN2322AA234',
                                'sw_version': 'sdx6320-RL-23.5-33',
                                'temperature': 68.0,
                                'uptime': '5440305'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.0.0.eth.1.phy',
                                                                       'in_nucast_pkts': '17678',
                                                                       'in_octets': '31181646609',
                                                                       'in_ucast_pkts': '145785231',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU0_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1469',
                                                                       'out_octets': '521978203351',
                                                                       'out_ucast_pkts': '375429160',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VMF9FVEhfMQ==',
                                                                       'speed': '1000000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1469',
                                                                       'in_octets': '521978203351',
                                                                       'in_ucast_pkts': '375429160',
                                                                       'links': [       {       'in_nucast_pkts': '1469',
                                                                                                'in_octets': '521978203351',
                                                                                                'in_ucast_pkts': '375429160',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '17678',
                                                                                                'out_octets': '31181646609',
                                                                                                'out_ucast_pkts': '145785231',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC85'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '17678',
                                                                       'out_octets': '31181646609',
                                                                       'out_ucast_pkts': '145785231',
                                                                       'poller_hash': 'QURUTjIzMTI0RDkxIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '511494',
                                                                                                                        'fiber_length': 5783,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC85',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -18.7,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.3}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDkxIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU0',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQ5MQ==',
                                         'serial_number': 'ADTN23124D91',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '511494'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-9.1.0.0.eth.1.phy',
                                                                       'in_nucast_pkts': '17350',
                                                                       'in_octets': '13335759005',
                                                                       'in_ucast_pkts': '104288639',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x9-ONU0_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1467',
                                                                       'out_octets': '481481868213',
                                                                       'out_ucast_pkts': '328067017',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDktT05VMF9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1467',
                                                                       'in_octets': '481481868213',
                                                                       'in_ucast_pkts': '328067017',
                                                                       'links': [       {       'in_nucast_pkts': '1467',
                                                                                                'in_octets': '481481868213',
                                                                                                'in_ucast_pkts': '328067017',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '17350',
                                                                                                'out_octets': '13335759005',
                                                                                                'out_ucast_pkts': '104288639',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8xMA=='}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '17350',
                                                                       'out_octets': '13335759005',
                                                                       'out_ucast_pkts': '104288639',
                                                                       'poller_hash': 'QURUTjIzMTI0RDY4IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '511515',
                                                                                                                        'fiber_length': 5677,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8xMA==',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -17.8,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDY4IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x9-ONU0',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQ2OA==',
                                         'serial_number': 'ADTN23124D68',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '511515'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.1.0.eth.1.phy',
                                                                       'in_nucast_pkts': '17350',
                                                                       'in_octets': '6424793475',
                                                                       'in_ucast_pkts': '15583782',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU1_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1467',
                                                                       'out_octets': '66052251294',
                                                                       'out_ucast_pkts': '52733391',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VMV9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1467',
                                                                       'in_octets': '66052251294',
                                                                       'in_ucast_pkts': '52733391',
                                                                       'links': [       {       'in_nucast_pkts': '1467',
                                                                                                'in_octets': '66052251294',
                                                                                                'in_ucast_pkts': '52733391',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '17350',
                                                                                                'out_octets': '6424793475',
                                                                                                'out_ucast_pkts': '15583782',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC85'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '17350',
                                                                       'out_octets': '6424793475',
                                                                       'out_ucast_pkts': '15583782',
                                                                       'poller_hash': 'QURUTjIzMTI0RTdBIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '511506',
                                                                                                                        'fiber_length': 5853,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC85',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -19.4,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.6}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RTdBIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU1',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEU3QQ==',
                                         'serial_number': 'ADTN23124E7A',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '511506'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-9.1.1.0.eth.1.phy',
                                                                       'in_nucast_pkts': '17353',
                                                                       'in_octets': '3375284024',
                                                                       'in_ucast_pkts': '7643960',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x9-ONU1_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1467',
                                                                       'out_octets': '38970248215',
                                                                       'out_ucast_pkts': '31960265',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDktT05VMV9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1467',
                                                                       'in_octets': '38970248215',
                                                                       'in_ucast_pkts': '31960265',
                                                                       'links': [       {       'in_nucast_pkts': '1467',
                                                                                                'in_octets': '38970248215',
                                                                                                'in_ucast_pkts': '31960265',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '17353',
                                                                                                'out_octets': '3375284024',
                                                                                                'out_ucast_pkts': '7643960',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8xMA=='}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '17353',
                                                                       'out_octets': '3375284024',
                                                                       'out_ucast_pkts': '7643960',
                                                                       'poller_hash': 'QURUTjIzMTI0RTE4IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '511514',
                                                                                                                        'fiber_length': 6613,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8xMA==',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -17.3,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.7}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RTE4IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x9-ONU1',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEUxOA==',
                                         'serial_number': 'ADTN23124E18',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '511514'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.2.0.eth.1.phy',
                                                                       'in_nucast_pkts': '17800',
                                                                       'in_octets': '90235861365',
                                                                       'in_ucast_pkts': '202145141',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU2_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1469',
                                                                       'out_octets': '549655463279',
                                                                       'out_ucast_pkts': '408842240',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VMl9FVEhfMQ==',
                                                                       'speed': '1000000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1469',
                                                                       'in_octets': '549655463279',
                                                                       'in_ucast_pkts': '408842240',
                                                                       'links': [       {       'in_nucast_pkts': '1469',
                                                                                                'in_octets': '549655463279',
                                                                                                'in_ucast_pkts': '408842240',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '17800',
                                                                                                'out_octets': '90235861365',
                                                                                                'out_ucast_pkts': '202145141',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC85'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '17800',
                                                                       'out_octets': '90235861365',
                                                                       'out_ucast_pkts': '202145141',
                                                                       'poller_hash': 'QURUTjIzMTIzRTlDIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '511514',
                                                                                                                        'fiber_length': 5669,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC85',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -19.4,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTIzRTlDIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU2',
                                         'poller_hash': 'b250IEFEVE4yMzEyM0U5Qw==',
                                         'serial_number': 'ADTN23123E9C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '511514'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.3.0.eth.1.phy',
                                                                       'in_nucast_pkts': '17500',
                                                                       'in_octets': '43499037247',
                                                                       'in_ucast_pkts': '94176808',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU3_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '570',
                                                                       'out_octets': '298195340695',
                                                                       'out_ucast_pkts': '223126720',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VM19FVEhfMQ==',
                                                                       'speed': '1000000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '570',
                                                                       'in_octets': '298195340695',
                                                                       'in_ucast_pkts': '223126720',
                                                                       'links': [       {       'in_nucast_pkts': '570',
                                                                                                'in_octets': '298195340695',
                                                                                                'in_ucast_pkts': '223126720',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '17500',
                                                                                                'out_octets': '43499037247',
                                                                                                'out_ucast_pkts': '94176808',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC85'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '17500',
                                                                       'out_octets': '43499037247',
                                                                       'out_ucast_pkts': '94176808',
                                                                       'poller_hash': 'QURUTjIzMTI0REVCIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '511508',
                                                                                                                        'fiber_length': 3861,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC85',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -18.6,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.8}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0REVCIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU3',
                                         'poller_hash': 'b250IEFEVE4yMzEyNERFQg==',
                                         'serial_number': 'ADTN23124DEB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '511508'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.4.0.eth.1.phy',
                                                                       'in_nucast_pkts': '17350',
                                                                       'in_octets': '8638783925',
                                                                       'in_ucast_pkts': '46431856',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU4_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1467',
                                                                       'out_octets': '133805388064',
                                                                       'out_ucast_pkts': '99643458',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VNF9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1467',
                                                                       'in_octets': '133805388064',
                                                                       'in_ucast_pkts': '99643458',
                                                                       'links': [       {       'in_nucast_pkts': '1467',
                                                                                                'in_octets': '133805388064',
                                                                                                'in_ucast_pkts': '99643458',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '17350',
                                                                                                'out_octets': '8638783925',
                                                                                                'out_ucast_pkts': '46431856',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC85'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '17350',
                                                                       'out_octets': '8638783925',
                                                                       'out_ucast_pkts': '46431856',
                                                                       'poller_hash': 'QURUTjIzMTI0RDkzIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '511497',
                                                                                                                        'fiber_length': 4090,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC85',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -23.4,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.6}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDkzIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU4',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQ5Mw==',
                                         'serial_number': 'ADTN23124D93',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '511497'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.5.0.eth.1.phy',
                                                                       'in_nucast_pkts': '17073',
                                                                       'in_octets': '11314547205',
                                                                       'in_ucast_pkts': '22941611',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU5_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '570',
                                                                       'out_octets': '98372197237',
                                                                       'out_ucast_pkts': '76185217',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VNV9FVEhfMQ==',
                                                                       'speed': '1000000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '570',
                                                                       'in_octets': '98372197237',
                                                                       'in_ucast_pkts': '76185217',
                                                                       'links': [       {       'in_nucast_pkts': '570',
                                                                                                'in_octets': '98372197237',
                                                                                                'in_ucast_pkts': '76185217',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '17073',
                                                                                                'out_octets': '11314547205',
                                                                                                'out_ucast_pkts': '22941611',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC85'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '17073',
                                                                       'out_octets': '11314547205',
                                                                       'out_ucast_pkts': '22941611',
                                                                       'poller_hash': 'QURUTjIzMTI0RDQ2IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '511509',
                                                                                                                        'fiber_length': 4612,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC85',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -20.5,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDQ2IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU5',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQ0Ng==',
                                         'serial_number': 'ADTN23124D46',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '511509'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.6.0.eth.1.phy',
                                                                       'in_nucast_pkts': '17350',
                                                                       'in_octets': '9058510653',
                                                                       'in_ucast_pkts': '39985645',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU6_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1467',
                                                                       'out_octets': '241684711586',
                                                                       'out_ucast_pkts': '170715081',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VNl9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1467',
                                                                       'in_octets': '241684711586',
                                                                       'in_ucast_pkts': '170715081',
                                                                       'links': [       {       'in_nucast_pkts': '1467',
                                                                                                'in_octets': '241684711586',
                                                                                                'in_ucast_pkts': '170715081',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '17350',
                                                                                                'out_octets': '9058510653',
                                                                                                'out_ucast_pkts': '39985645',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC85'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '17350',
                                                                       'out_octets': '9058510653',
                                                                       'out_ucast_pkts': '39985645',
                                                                       'poller_hash': 'QURUTjIzMTI0OTFFIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '511495',
                                                                                                                        'fiber_length': 5476,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC85',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0OTFFIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU6',
                                         'poller_hash': 'b250IEFEVE4yMzEyNDkxRQ==',
                                         'serial_number': 'ADTN2312491E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '511495'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.7.0.eth.1.phy',
                                                                       'in_nucast_pkts': '390',
                                                                       'in_octets': '11166614608',
                                                                       'in_ucast_pkts': '24360922',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU7_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1467',
                                                                       'out_octets': '84529303524',
                                                                       'out_ucast_pkts': '65666060',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VN19FVEhfMQ==',
                                                                       'speed': '1000000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1467',
                                                                       'in_octets': '84529303524',
                                                                       'in_ucast_pkts': '65666060',
                                                                       'links': [       {       'in_nucast_pkts': '1467',
                                                                                                'in_octets': '84529303524',
                                                                                                'in_ucast_pkts': '65666060',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '390',
                                                                                                'out_octets': '11166614608',
                                                                                                'out_ucast_pkts': '24360922',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC85'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '390',
                                                                       'out_octets': '11166614608',
                                                                       'out_ucast_pkts': '24360922',
                                                                       'poller_hash': 'QURUTjIzMTI0RTNBIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '511498',
                                                                                                                        'fiber_length': 5824,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC85',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -16.9,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.7}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RTNBIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU7',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEUzQQ==',
                                         'serial_number': 'ADTN23124E3A',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '511498'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.9.0.eth.1.phy',
                                                                       'in_nucast_pkts': '17779',
                                                                       'in_octets': '18985244898',
                                                                       'in_ucast_pkts': '106949594',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU9_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1467',
                                                                       'out_octets': '438385612413',
                                                                       'out_ucast_pkts': '315523487',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VOV9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1467',
                                                                       'in_octets': '438385612413',
                                                                       'in_ucast_pkts': '315523487',
                                                                       'links': [       {       'in_nucast_pkts': '1467',
                                                                                                'in_octets': '438385612413',
                                                                                                'in_ucast_pkts': '315523487',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '17779',
                                                                                                'out_octets': '18985244898',
                                                                                                'out_ucast_pkts': '106949594',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC85'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '17779',
                                                                       'out_octets': '18985244898',
                                                                       'out_ucast_pkts': '106949594',
                                                                       'poller_hash': 'QURUTjIzMTI0REYzIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '511514',
                                                                                                                        'fiber_length': 3643,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC85',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -17.3,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0REYzIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU9',
                                         'poller_hash': 'b250IEFEVE4yMzEyNERGMw==',
                                         'serial_number': 'ADTN23124DF3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5-5-b',
                                         'uptime': '511514'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.10.0.eth.1.phy',
                                                                       'in_nucast_pkts': '17349',
                                                                       'in_octets': '930032427',
                                                                       'in_ucast_pkts': '3534867',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU10_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1467',
                                                                       'out_octets': '8545155679',
                                                                       'out_ucast_pkts': '6754964',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VMTBfRVRIXzE=',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1467',
                                                                       'in_octets': '8545155679',
                                                                       'in_ucast_pkts': '6754964',
                                                                       'links': [       {       'in_nucast_pkts': '1467',
                                                                                                'in_octets': '8545155679',
                                                                                                'in_ucast_pkts': '6754964',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '17349',
                                                                                                'out_octets': '930032427',
                                                                                                'out_ucast_pkts': '3534867',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC85'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '17349',
                                                                       'out_octets': '930032427',
                                                                       'out_ucast_pkts': '3534867',
                                                                       'poller_hash': 'QURUTjIzMTI1MThFIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '511497',
                                                                                                                        'fiber_length': 3909,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC85',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -19.8,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.3}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI1MThFIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU10',
                                         'poller_hash': 'b250IEFEVE4yMzEyNTE4RQ==',
                                         'serial_number': 'ADTN2312518E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '511497'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.11.0.eth.1.phy',
                                                                       'in_nucast_pkts': '17788',
                                                                       'in_octets': '14946109629',
                                                                       'in_ucast_pkts': '58363627',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU11_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1468',
                                                                       'out_octets': '294012971396',
                                                                       'out_ucast_pkts': '213405469',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VMTFfRVRIXzE=',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1468',
                                                                       'in_octets': '294012971396',
                                                                       'in_ucast_pkts': '213405469',
                                                                       'links': [       {       'in_nucast_pkts': '1468',
                                                                                                'in_octets': '294012971396',
                                                                                                'in_ucast_pkts': '213405469',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '17788',
                                                                                                'out_octets': '14946109629',
                                                                                                'out_ucast_pkts': '58363627',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC85'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '17788',
                                                                       'out_octets': '14946109629',
                                                                       'out_ucast_pkts': '58363627',
                                                                       'poller_hash': 'QURUTjIzMTI0RENFIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '511508',
                                                                                                                        'fiber_length': 5338,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC85',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -18.9,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.6}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RENFIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU11',
                                         'poller_hash': 'b250IEFEVE4yMzEyNERDRQ==',
                                         'serial_number': 'ADTN23124DCE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '511508'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.12.0.eth.1.phy',
                                                                       'in_nucast_pkts': '17350',
                                                                       'in_octets': '2315752953',
                                                                       'in_ucast_pkts': '7552312',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU12_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1467',
                                                                       'out_octets': '20525064080',
                                                                       'out_ucast_pkts': '17015732',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VMTJfRVRIXzE=',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1467',
                                                                       'in_octets': '20525064080',
                                                                       'in_ucast_pkts': '17015732',
                                                                       'links': [       {       'in_nucast_pkts': '1467',
                                                                                                'in_octets': '20525064080',
                                                                                                'in_ucast_pkts': '17015732',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '17350',
                                                                                                'out_octets': '2315752953',
                                                                                                'out_ucast_pkts': '7552312',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC85'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '17350',
                                                                       'out_octets': '2315752953',
                                                                       'out_ucast_pkts': '7552312',
                                                                       'poller_hash': 'QURUTjIzMTI0RTIyIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '511508',
                                                                                                                        'fiber_length': 3743,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC85',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -20.1,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.6}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RTIyIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU12',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEUyMg==',
                                         'serial_number': 'ADTN23124E22',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '511508'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-9.1.2.0.eth.1.phy',
                                                                       'in_nucast_pkts': '116896',
                                                                       'in_octets': '36055555296',
                                                                       'in_ucast_pkts': '133646574',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x9-ONU2_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '9898',
                                                                       'out_octets': '481248857766',
                                                                       'out_ucast_pkts': '378880965',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDktT05VMl9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '9898',
                                                                       'in_octets': '481248857766',
                                                                       'in_ucast_pkts': '378880965',
                                                                       'links': [       {       'in_nucast_pkts': '9898',
                                                                                                'in_octets': '481248857766',
                                                                                                'in_ucast_pkts': '378880965',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '116896',
                                                                                                'out_octets': '36055555296',
                                                                                                'out_ucast_pkts': '133646574',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8xMA=='}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '116896',
                                                                       'out_octets': '36055555296',
                                                                       'out_ucast_pkts': '133646574',
                                                                       'poller_hash': 'QURUTjIzMTI1MDU1IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '3449060',
                                                                                                                        'fiber_length': 6229,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8xMA==',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -18.8,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI1MDU1IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x9-ONU2',
                                         'poller_hash': 'b250IEFEVE4yMzEyNTA1NQ==',
                                         'serial_number': 'ADTN23125055',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '3449060'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-1.1.0.0.eth.1.phy',
                                                                       'in_nucast_pkts': '17468',
                                                                       'in_octets': '1991337600',
                                                                       'in_ucast_pkts': '19911217',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x1-ONU0_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1467',
                                                                       'out_octets': '59145047964',
                                                                       'out_ucast_pkts': '40137087',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDEtT05VMF9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1467',
                                                                       'in_octets': '59145047964',
                                                                       'in_ucast_pkts': '40137087',
                                                                       'links': [       {       'in_nucast_pkts': '1467',
                                                                                                'in_octets': '59145047964',
                                                                                                'in_ucast_pkts': '40137087',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '17468',
                                                                                                'out_octets': '1991337600',
                                                                                                'out_ucast_pkts': '19911217',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8y'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '17468',
                                                                       'out_octets': '1991337600',
                                                                       'out_ucast_pkts': '19911217',
                                                                       'poller_hash': 'QURUTjIzMTI0RDQxIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '511495',
                                                                                                                        'fiber_length': 1926,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8y',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -14.7,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDQxIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x1-ONU0',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQ0MQ==',
                                         'serial_number': 'ADTN23124D41',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '511495'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-1.1.1.0.eth.1.phy',
                                                                       'in_nucast_pkts': '17340',
                                                                       'in_octets': '1758382852',
                                                                       'in_ucast_pkts': '6919707',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x1-ONU1_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1467',
                                                                       'out_octets': '31194916904',
                                                                       'out_ucast_pkts': '22510192',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDEtT05VMV9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1467',
                                                                       'in_octets': '31194916904',
                                                                       'in_ucast_pkts': '22510192',
                                                                       'links': [       {       'in_nucast_pkts': '1467',
                                                                                                'in_octets': '31194916904',
                                                                                                'in_ucast_pkts': '22510192',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '17340',
                                                                                                'out_octets': '1758382852',
                                                                                                'out_ucast_pkts': '6919707',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8y'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '17340',
                                                                       'out_octets': '1758382852',
                                                                       'out_ucast_pkts': '6919707',
                                                                       'poller_hash': 'QURUTjIzMTI0MEIwIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '511496',
                                                                                                                        'fiber_length': 1969,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8y',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -15.5,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.3}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0MEIwIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x1-ONU1',
                                         'poller_hash': 'b250IEFEVE4yMzEyNDBCMA==',
                                         'serial_number': 'ADTN231240B0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '511496'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-1.1.2.0.eth.1.phy',
                                                                       'in_nucast_pkts': '17754',
                                                                       'in_octets': '11748288735',
                                                                       'in_ucast_pkts': '59006709',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x1-ONU2_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1467',
                                                                       'out_octets': '158629248942',
                                                                       'out_ucast_pkts': '130598930',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDEtT05VMl9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1467',
                                                                       'in_octets': '158629248942',
                                                                       'in_ucast_pkts': '130598930',
                                                                       'links': [       {       'in_nucast_pkts': '1467',
                                                                                                'in_octets': '158629248942',
                                                                                                'in_ucast_pkts': '130598930',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '17754',
                                                                                                'out_octets': '11748288735',
                                                                                                'out_ucast_pkts': '59006709',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8y'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '17754',
                                                                       'out_octets': '11748288735',
                                                                       'out_ucast_pkts': '59006709',
                                                                       'poller_hash': 'QURUTjIzMTI0REQ5IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '511496',
                                                                                                                        'fiber_length': 1780,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8y',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0REQ5IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x1-ONU2',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEREOQ==',
                                         'serial_number': 'ADTN23124DD9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '511496'},
                                 {       'interfaces': [       {       'id': 'onu-subscr-if-8.1.13.0.eth.1.phy',
                                                                       'name': 'IndianBayou-x8-ONU13_ETH_1',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VMTNfRVRIXzE='},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIzMTI0MEE2IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0MEE2IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON'}]}],
                                         'manufacturer': 'Adtran',
                                         'name': 'IndianBayou-x8-ONU13',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'ONT is in '
                                                                  '"discovering" '
                                                                  'state: it was '
                                                                  'detected by the OLT '
                                                                  'but is not yet '
                                                                  'fully registered or '
                                                                  'activated.',
                                         'poller_hash': 'b250IEFEVE4yMzEyNDBBNg==',
                                         'serial_number': 'ADTN231240A6',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.14.0.eth.1.phy',
                                                                       'in_nucast_pkts': '17777',
                                                                       'in_octets': '13446246092',
                                                                       'in_ucast_pkts': '88985714',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'ADTN23124D9E_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1467',
                                                                       'out_octets': '326420716091',
                                                                       'out_ucast_pkts': '238645457',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgQURUTjIzMTI0RDlFX0VUSF8x',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1467',
                                                                       'in_octets': '326420716091',
                                                                       'in_ucast_pkts': '238645457',
                                                                       'links': [       {       'in_nucast_pkts': '1467',
                                                                                                'in_octets': '326420716091',
                                                                                                'in_ucast_pkts': '238645457',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '17777',
                                                                                                'out_octets': '13446246092',
                                                                                                'out_ucast_pkts': '88985714',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC85'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '17777',
                                                                       'out_octets': '13446246092',
                                                                       'out_ucast_pkts': '88985714',
                                                                       'poller_hash': 'QURUTjIzMTI0RDlFIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '511509',
                                                                                                                        'fiber_length': 4273,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC85',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -19.3,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDlFIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'ADTN23124D9E',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQ5RQ==',
                                         'serial_number': 'ADTN23124D9E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '511509'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-4.1.0.0.eth.1.phy',
                                                                       'in_nucast_pkts': '78535',
                                                                       'in_octets': '32074553609',
                                                                       'in_ucast_pkts': '247138061',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x4-ONU0_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '6651',
                                                                       'out_octets': '851716345889',
                                                                       'out_ucast_pkts': '606755361',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDQtT05VMF9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '6651',
                                                                       'in_octets': '851716345889',
                                                                       'in_ucast_pkts': '606755361',
                                                                       'links': [       {       'in_nucast_pkts': '6651',
                                                                                                'in_octets': '851716345889',
                                                                                                'in_ucast_pkts': '606755361',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '78535',
                                                                                                'out_octets': '32074553609',
                                                                                                'out_ucast_pkts': '247138061',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC81'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '78535',
                                                                       'out_octets': '32074553609',
                                                                       'out_ucast_pkts': '247138061',
                                                                       'poller_hash': 'QURUTjIzMTI0REYxIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '2317053',
                                                                                                                        'fiber_length': 5944,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC81',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -19.2,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0REYxIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x4-ONU0',
                                         'poller_hash': 'b250IEFEVE4yMzEyNERGMQ==',
                                         'serial_number': 'ADTN23124DF1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '2317053'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-3.1.0.0.eth.1.phy',
                                                                       'in_nucast_pkts': '80464',
                                                                       'in_octets': '64191871858',
                                                                       'in_ucast_pkts': '294720133',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x3-ONU0_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '6629',
                                                                       'out_octets': '1307641974656',
                                                                       'out_ucast_pkts': '937844307',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDMtT05VMF9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '6629',
                                                                       'in_octets': '1307641974656',
                                                                       'in_ucast_pkts': '937844307',
                                                                       'links': [       {       'in_nucast_pkts': '6629',
                                                                                                'in_octets': '1307641974656',
                                                                                                'in_ucast_pkts': '937844307',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '80464',
                                                                                                'out_octets': '64191871858',
                                                                                                'out_ucast_pkts': '294720133',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC80'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '80464',
                                                                       'out_octets': '64191871858',
                                                                       'out_ucast_pkts': '294720133',
                                                                       'poller_hash': 'QURUTjIzMTI0RTA3IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '2317053',
                                                                                                                        'fiber_length': 3992,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC80',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -20.7,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.6}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RTA3IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x3-ONU0',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEUwNw==',
                                         'serial_number': 'ADTN23124E07',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '2317053'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-3.1.1.0.eth.1.phy',
                                                                       'in_nucast_pkts': '14661',
                                                                       'in_octets': '6991765314',
                                                                       'in_ucast_pkts': '30718708',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x3-ONU1_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1210',
                                                                       'out_octets': '110390447582',
                                                                       'out_ucast_pkts': '78915022',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDMtT05VMV9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1210',
                                                                       'in_octets': '110390447582',
                                                                       'in_ucast_pkts': '78915022',
                                                                       'links': [       {       'in_nucast_pkts': '1210',
                                                                                                'in_octets': '110390447582',
                                                                                                'in_ucast_pkts': '78915022',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '14661',
                                                                                                'out_octets': '6991765314',
                                                                                                'out_ucast_pkts': '30718708',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC80'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '14661',
                                                                       'out_octets': '6991765314',
                                                                       'out_ucast_pkts': '30718708',
                                                                       'poller_hash': 'QURUTjIzMTI0RTE0IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '421798',
                                                                                                                        'fiber_length': 4123,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC80',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -19.1,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RTE0IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x3-ONU1',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEUxNA==',
                                         'serial_number': 'ADTN23124E14',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '421798'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-4.1.1.0.eth.1.phy',
                                                                       'in_nucast_pkts': '78530',
                                                                       'in_octets': '9573246216',
                                                                       'in_ucast_pkts': '28968827',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x4-ONU1_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '6646',
                                                                       'out_octets': '94670181667',
                                                                       'out_ucast_pkts': '79312527',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDQtT05VMV9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '6646',
                                                                       'in_octets': '94670181667',
                                                                       'in_ucast_pkts': '79312527',
                                                                       'links': [       {       'in_nucast_pkts': '6646',
                                                                                                'in_octets': '94670181667',
                                                                                                'in_ucast_pkts': '79312527',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '78530',
                                                                                                'out_octets': '9573246216',
                                                                                                'out_ucast_pkts': '28968827',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC81'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '78530',
                                                                       'out_octets': '9573246216',
                                                                       'out_ucast_pkts': '28968827',
                                                                       'poller_hash': 'QURUTjIzMTI0RDQzIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '2317055',
                                                                                                                        'fiber_length': 6063,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC81',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.6}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDQzIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x4-ONU1',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQ0Mw==',
                                         'serial_number': 'ADTN23124D43',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '2317055'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-4.1.2.0.eth.1.phy',
                                                                       'in_nucast_pkts': '79111',
                                                                       'in_octets': '35790774369',
                                                                       'in_ucast_pkts': '168984150',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x4-ONU2_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2576',
                                                                       'out_octets': '621131891083',
                                                                       'out_ucast_pkts': '448566543',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDQtT05VMl9FVEhfMQ==',
                                                                       'speed': '1000000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '2576',
                                                                       'in_octets': '621131891083',
                                                                       'in_ucast_pkts': '448566543',
                                                                       'links': [       {       'in_nucast_pkts': '2576',
                                                                                                'in_octets': '621131891083',
                                                                                                'in_ucast_pkts': '448566543',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '79111',
                                                                                                'out_octets': '35790774369',
                                                                                                'out_ucast_pkts': '168984150',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC81'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '79111',
                                                                       'out_octets': '35790774369',
                                                                       'out_ucast_pkts': '168984150',
                                                                       'poller_hash': 'QURUTjIzMTI1MUUyIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '2317054',
                                                                                                                        'fiber_length': 5212,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC81',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -20.9,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.6}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI1MUUyIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x4-ONU2',
                                         'poller_hash': 'b250IEFEVE4yMzEyNTFFMg==',
                                         'serial_number': 'ADTN231251E2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '2317054'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-9.1.3.0.eth.1.phy',
                                                                       'in_nucast_pkts': '116891',
                                                                       'in_octets': '49636365763',
                                                                       'in_ucast_pkts': '281729576',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x9-ONU3_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '9894',
                                                                       'out_octets': '1329234239498',
                                                                       'out_ucast_pkts': '918260033',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDktT05VM19FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '9894',
                                                                       'in_octets': '1329234239498',
                                                                       'in_ucast_pkts': '918260033',
                                                                       'links': [       {       'in_nucast_pkts': '9894',
                                                                                                'in_octets': '1329234239498',
                                                                                                'in_ucast_pkts': '918260033',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '116891',
                                                                                                'out_octets': '49636365763',
                                                                                                'out_ucast_pkts': '281729576',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8xMA=='}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '116891',
                                                                       'out_octets': '49636365763',
                                                                       'out_ucast_pkts': '281729576',
                                                                       'poller_hash': 'QURUTjIzMTI0NjUwIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '3449056',
                                                                                                                        'fiber_length': 5972,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8xMA==',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -20.3,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0NjUwIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x9-ONU3',
                                         'poller_hash': 'b250IEFEVE4yMzEyNDY1MA==',
                                         'serial_number': 'ADTN23124650',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '3449056'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-4.1.3.0.eth.1.phy',
                                                                       'in_nucast_pkts': '37776',
                                                                       'in_octets': '17380293068',
                                                                       'in_ucast_pkts': '88982916',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x4-ONU3_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '3197',
                                                                       'out_octets': '493923471987',
                                                                       'out_ucast_pkts': '350348488',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDQtT05VM19FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '3197',
                                                                       'in_octets': '493923471987',
                                                                       'in_ucast_pkts': '350348488',
                                                                       'links': [       {       'in_nucast_pkts': '3197',
                                                                                                'in_octets': '493923471987',
                                                                                                'in_ucast_pkts': '350348488',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '37776',
                                                                                                'out_octets': '17380293068',
                                                                                                'out_ucast_pkts': '88982916',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC81'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '37776',
                                                                       'out_octets': '17380293068',
                                                                       'out_ucast_pkts': '88982916',
                                                                       'poller_hash': 'QURUTjIzMTI0RTI2IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '1114341',
                                                                                                                        'fiber_length': 7531,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC81',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -18.9,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RTI2IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x4-ONU3',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEUyNg==',
                                         'serial_number': 'ADTN23124E26',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '1114341'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-4.1.4.0.eth.1.phy',
                                                                       'in_nucast_pkts': '78535',
                                                                       'in_octets': '88158106536',
                                                                       'in_ucast_pkts': '371249138',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x4-ONU4_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '6646',
                                                                       'out_octets': '1100356693456',
                                                                       'out_ucast_pkts': '806203412',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDQtT05VNF9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '6646',
                                                                       'in_octets': '1100356693456',
                                                                       'in_ucast_pkts': '806203412',
                                                                       'links': [       {       'in_nucast_pkts': '6646',
                                                                                                'in_octets': '1100356693456',
                                                                                                'in_ucast_pkts': '806203412',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '78535',
                                                                                                'out_octets': '88158106536',
                                                                                                'out_ucast_pkts': '371249138',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC81'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '78535',
                                                                       'out_octets': '88158106536',
                                                                       'out_ucast_pkts': '371249138',
                                                                       'poller_hash': 'QURUTjIzMTI0RDk4IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '2317056',
                                                                                                                        'fiber_length': 5967,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC81',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -19.8,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.6}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDk4IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x4-ONU4',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQ5OA==',
                                         'serial_number': 'ADTN23124D98',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '2317056'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-4.1.5.0.eth.1.phy',
                                                                       'in_nucast_pkts': '78529',
                                                                       'in_octets': '28476675251',
                                                                       'in_ucast_pkts': '142287961',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x4-ONU5_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '6647',
                                                                       'out_octets': '953590409355',
                                                                       'out_ucast_pkts': '703346325',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDQtT05VNV9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '6647',
                                                                       'in_octets': '953590409355',
                                                                       'in_ucast_pkts': '703346325',
                                                                       'links': [       {       'in_nucast_pkts': '6647',
                                                                                                'in_octets': '953590409355',
                                                                                                'in_ucast_pkts': '703346325',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '78529',
                                                                                                'out_octets': '28476675251',
                                                                                                'out_ucast_pkts': '142287961',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC81'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '78529',
                                                                       'out_octets': '28476675251',
                                                                       'out_ucast_pkts': '142287961',
                                                                       'poller_hash': 'QURUTjIzMTI0RDUwIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '2317060',
                                                                                                                        'fiber_length': 5915,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC81',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -18.7,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.7}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDUwIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x4-ONU5',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQ1MA==',
                                         'serial_number': 'ADTN23124D50',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '2317060'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-4.1.6.0.eth.1.phy',
                                                                       'in_nucast_pkts': '78632',
                                                                       'in_octets': '2863545110',
                                                                       'in_ucast_pkts': '10210777',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x4-ONU6_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '6649',
                                                                       'out_octets': '36091222902',
                                                                       'out_ucast_pkts': '26579330',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDQtT05VNl9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '6649',
                                                                       'in_octets': '36091222902',
                                                                       'in_ucast_pkts': '26579330',
                                                                       'links': [       {       'in_nucast_pkts': '6649',
                                                                                                'in_octets': '36091222902',
                                                                                                'in_ucast_pkts': '26579330',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '78632',
                                                                                                'out_octets': '2863545110',
                                                                                                'out_ucast_pkts': '10210777',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC81'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '78632',
                                                                       'out_octets': '2863545110',
                                                                       'out_ucast_pkts': '10210777',
                                                                       'poller_hash': 'QURUTjIzMTI0RDM4IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '2317054',
                                                                                                                        'fiber_length': 6210,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC81',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -18.6,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.6}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDM4IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x4-ONU6',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQzOA==',
                                         'serial_number': 'ADTN23124D38',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '2317054'},
                                 {       'interfaces': [       {       'id': 'onu-subscr-if-3.1.3.0.eth.1.phy',
                                                                       'name': 'IndianBayou-x3-ONU3_ETH_1',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDMtT05VM19FVEhfMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIzMTI0RTM1IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RTM1IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON'}]}],
                                         'manufacturer': 'Adtran',
                                         'name': 'IndianBayou-x3-ONU3',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'ONT is in '
                                                                  '"discovering" '
                                                                  'state: it was '
                                                                  'detected by the OLT '
                                                                  'but is not yet '
                                                                  'fully registered or '
                                                                  'activated.',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEUzNQ==',
                                         'serial_number': 'ADTN23124E35',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-4.1.7.0.eth.1.phy',
                                                                       'in_nucast_pkts': '80130',
                                                                       'in_octets': '42976698193',
                                                                       'in_ucast_pkts': '299332771',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x4-ONU7_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '6651',
                                                                       'out_octets': '1255152815589',
                                                                       'out_ucast