import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestAlvarionModels(DeviceTestCase):

    def test_alvarion_breezeaccess_BreezeACCESS_VL_6_5_7_01(self):
        obj = self.run_data("alvarion.breezeaccess.BreezeACCESS VL.6.5.7.01")
        exp_info = {
                'model': 'BreezeACCESS VL',
                'rf_freq': 5775,
                'rf_tx_power': 21,
                'sta_count': 12,
                'sw_version': '6.5.7',
                'vendor': 'Alvarion'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '00:10:e7:14:40:d3': {       'dev_macs': ['18:b1:69:44:56:d5'],
                                             'ip_address': '10.10.36.75',
                                             'mac_address': '00:10:e7:14:40:d3',
                                             'name': 'AGVALLEY-EUSTIS-EAST'},
                '00:10:e7:54:91:2b': {       'dev_macs': ['b4:75:0e:cf:8f:02'],
                                             'ip_address': '10.10.36.102',
                                             'mac_address': '00:10:e7:54:91:2b',
                                             'name': 'A&TRepair'},
                '00:10:e7:54:f3:b5': {       'dev_macs': ['c8:d1:2a:1a:a5:be'],
                                             'ip_address': '10.10.36.65',
                                             'mac_address': '00:10:e7:54:f3:b5',
                                             'name': 'HueftleNicole'},
                '00:10:e7:74:fd:20': {       'dev_macs': ['48:f8:b3:35:57:fa'],
                                             'ip_address': '10.10.36.87',
                                             'mac_address': '00:10:e7:74:fd:20',
                                             'name': 'EvansRaymond'},
                '00:10:e7:84:dc:7d': {       'dev_macs': ['d8:b6:b7:d8:b2:dd'],
                                             'ip_address': '10.10.36.71',
                                             'mac_address': '00:10:e7:84:dc:7d',
                                             'name': 'GundellKathy'},
                '00:10:e7:94:0f:bc': {       'dev_macs': ['00:19:21:2d:e3:51'],
                                             'ip_address': '10.10.36.68',
                                             'mac_address': '00:10:e7:94:0f:bc',
                                             'name': 'DehartyCharles'},
                '00:10:e7:94:5a:09': {       'dev_macs': ['60:38:e0:6e:b1:a3'],
                                             'ip_address': '10.10.36.84',
                                             'mac_address': '00:10:e7:94:5a:09',
                                             'name': 'SchutzDavy'},
                '00:10:e7:94:88:ee': {       'dev_macs': ['84:1b:5e:01:62:45'],
                                             'ip_address': '10.10.36.66',
                                             'mac_address': '00:10:e7:94:88:ee',
                                             'name': 'BulletinElwood'},
                '00:10:e7:94:8b:50': {       'dev_macs': ['e8:2c:6d:05:7d:60'],
                                             'ip_address': '10.10.36.86',
                                             'mac_address': '00:10:e7:94:8b:50',
                                             'name': 'GallJanice'},
                '00:10:e7:94:9c:1a': {       'dev_macs': ['c8:d7:19:65:7c:36'],
                                             'ip_address': '10.10.36.77',
                                             'mac_address': '00:10:e7:94:9c:1a',
                                             'name': 'KochMonte'},
                '00:10:e7:94:ae:4b': {       'dev_macs': ['e8:2c:6d:18:72:b0'],
                                             'ip_address': '10.10.36.92',
                                             'mac_address': '00:10:e7:94:ae:4b',
                                             'name': 'MooreKasie'},
                '00:10:e7:a4:d5:41': {       'dev_macs': ['d8:b6:b7:bb:6d:b4'],
                                             'ip_address': '10.10.36.89',
                                             'mac_address': '00:10:e7:a4:d5:41',
                                             'name': 'EustisFairBuilding'}
        }
        exp_ne_msg = {
                'data': {       'height': 30.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '634349508',
                                                              'in_nucast_pkts': '17126',
                                                              'in_octets': '617873915',
                                                              'in_ucast_pkts': '4249426873',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '48:f8:b3:35:57:fa'],
                                                                                       'mac_address': '00:10:e7:74:fd:20'},
                                                                               {       'bridged_mac_addresses': [       'd8:b6:b7:d8:b2:dd'],
                                                                                       'mac_address': '00:10:e7:84:dc:7d'},
                                                                               {       'bridged_mac_addresses': [       '84:1b:5e:01:62:45'],
                                                                                       'mac_address': '00:10:e7:94:88:ee'},
                                                                               {       'bridged_mac_addresses': [       'e8:2c:6d:05:7d:60'],
                                                                                       'mac_address': '00:10:e7:94:8b:50'},
                                                                               {       'bridged_mac_addresses': [       '00:19:21:2d:e3:51'],
                                                                                       'mac_address': '00:10:e7:94:0f:bc'},
                                                                               {       'bridged_mac_addresses': [       'c8:d7:19:65:7c:36'],
                                                                                       'mac_address': '00:10:e7:94:9c:1a'},
                                                                               {       'bridged_mac_addresses': [       'e8:2c:6d:18:72:b0'],
                                                                                       'mac_address': '00:10:e7:94:ae:4b'},
                                                                               {       'bridged_mac_addresses': [       '60:38:e0:6e:b1:a3'],
                                                                                       'mac_address': '00:10:e7:94:5a:09'},
                                                                               {       'bridged_mac_addresses': [       'd8:b6:b7:bb:6d:b4'],
                                                                                       'mac_address': '00:10:e7:a4:d5:41'},
                                                                               {       'bridged_mac_addresses': [       '18:b1:69:44:56:d5'],
                                                                                       'mac_address': '00:10:e7:14:40:d3'},
                                                                               {       'bridged_mac_addresses': [       'b4:75:0e:cf:8f:02'],
                                                                                       'mac_address': '00:10:e7:54:91:2b'},
                                                                               {       'bridged_mac_addresses': [       'c8:d1:2a:1a:a5:be'],
                                                                                       'mac_address': '00:10:e7:54:f3:b5'}],
                                                              'mac_address': '00:10:e7:74:d1:eb',
                                                              'mtu': 1514,
                                                              'name': 'Radio port',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '3075443',
                                                              'out_nucast_pkts': '31426987',
                                                              'out_octets': '3783677271',
                                                              'out_ucast_pkts': '324319348',
                                                              'radios': [       {       'frequency': 5775,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 1000,
                                                                                                                                            'mac_address': '00:10:e7:74:fd:20',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '6016000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 1000,
                                                                                                                                            'mac_address': '00:10:e7:84:dc:7d',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '5120000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 1000,
                                                                                                                                            'mac_address': '00:10:e7:94:88:ee',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -72.0,
                                                                                                                                            'rx_link_rate': '512000',
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '3072000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'distance': 1000,
                                                                                                                                            'mac_address': '00:10:e7:94:8b:50',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '5120000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 1000,
                                                                                                                                            'mac_address': '00:10:e7:94:0f:bc',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '5120000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 1000,
                                                                                                                                            'mac_address': '00:10:e7:94:9c:1a',
                                                                                                                                            'noise_floor': -101.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '512000',
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '3072000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 1000,
                                                                                                                                            'mac_address': '00:10:e7:94:ae:4b',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -72.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '5120000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'distance': 1000,
                                                                                                                                            'mac_address': '00:10:e7:94:5a:09',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '5120000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 1000,
                                                                                                                                            'mac_address': '00:10:e7:a4:d5:41',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '12288000',
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '12288000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 1000,
                                                                                                                                            'mac_address': '00:10:e7:14:40:d3',
                                                                                                                                            'noise_floor': -100.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '2304000',
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '11392000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 1000,
                                                                                                                                            'mac_address': '00:10:e7:54:91:2b',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '512000',
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '2048000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 6000,
                                                                                                                                            'mac_address': '00:10:e7:54:f3:b5',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -76.0,
                                                                                                                                            'rx_link_rate': '2048000',
                                                                                                                                            'snr': 22.0,
                                                                                                                                            'tx_link_rate': '11264000',
                                                                                                                                            'tx_mcs': 8}],
                                                                                                                   'noise_floor': -101.0}],
                                                                                        'tx_power': 21}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '8000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '28972786',
                                                              'in_octets': '4109104328',
                                                              'in_ucast_pkts': '545204669',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1514,
                                                              'name': 'Ethernet port',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '18490',
                                                              'out_octets': '2830388814',
                                                              'out_ucast_pkts': '4278759511',
                                                              'poller_hash': 'AQ53TR6/',
                                                              'speed': '10000000',
                                                              'type': 6}],
                                'manufacturer': 'Alvarion',
                                'model': 'BreezeACCESS VL',
                                'name': 'EUSTIS VLAU01',
                                'sw_version': '6.5.7',
                                'system_mac_address': '00:10:e7:74:d1:eb',
                                'uptime': '24098185'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:74:d1:eb'}],
                                                                       'mac_address': '00:10:e7:74:fd:20',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5775,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 1000,
                                                                                                                                                     'mac_address': '00:10:e7:74:d1:eb',
                                                                                                                                                     'rx_link_rate': '6016000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ53T9'}],
                                         'management_ip': '10.10.36.87',
                                         'manufacturer': 'Alvarion',
                                         'name': 'EvansRaymond',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:74:fd:20'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:74:d1:eb'}],
                                                                       'mac_address': '00:10:e7:84:dc:7d',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5775,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 1000,
                                                                                                                                                     'mac_address': '00:10:e7:74:d1:eb',
                                                                                                                                                     'rx_link_rate': '5120000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ54Tc'}],
                                         'management_ip': '10.10.36.71',
                                         'manufacturer': 'Alvarion',
                                         'name': 'GundellKathy',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '5.5.12',
                                         'system_mac_address': '00:10:e7:84:dc:7d'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:74:d1:eb'}],
                                                                       'mac_address': '00:10:e7:94:88:ee',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5775,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 1000,
                                                                                                                                                     'mac_address': '00:10:e7:74:d1:eb',
                                                                                                                                                     'rx_link_rate': '3072000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'tx_link_rate': '512000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ55SI'}],
                                         'management_ip': '10.10.36.66',
                                         'manufacturer': 'Alvarion',
                                         'name': 'BulletinElwood',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:94:88:ee'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:74:d1:eb'}],
                                                                       'mac_address': '00:10:e7:94:8b:50',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5775,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 1000,
                                                                                                                                                     'mac_address': '00:10:e7:74:d1:eb',
                                                                                                                                                     'rx_link_rate': '5120000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ55SL'}],
                                         'management_ip': '10.10.36.86',
                                         'manufacturer': 'Alvarion',
                                         'name': 'GallJanice',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:94:8b:50'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:74:d1:eb'}],
                                                                       'mac_address': '00:10:e7:94:0f:bc',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5775,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 1000,
                                                                                                                                                     'mac_address': '00:10:e7:74:d1:eb',
                                                                                                                                                     'rx_link_rate': '5120000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ55QP'}],
                                         'management_ip': '10.10.36.68',
                                         'manufacturer': 'Alvarion',
                                         'name': 'DehartyCharles',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:94:0f:bc'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:74:d1:eb'}],
                                                                       'mac_address': '00:10:e7:94:9c:1a',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5775,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 1000,
                                                                                                                                                     'mac_address': '00:10:e7:74:d1:eb',
                                                                                                                                                     'rx_link_rate': '3072000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '512000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ55Sc'}],
                                         'management_ip': '10.10.36.77',
                                         'manufacturer': 'Alvarion',
                                         'name': 'KochMonte',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:94:9c:1a'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:74:d1:eb'}],
                                                                       'mac_address': '00:10:e7:94:ae:4b',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5775,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 1000,
                                                                                                                                                     'mac_address': '00:10:e7:74:d1:eb',
                                                                                                                                                     'rx_link_rate': '5120000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ55Su'}],
                                         'management_ip': '10.10.36.92',
                                         'manufacturer': 'Alvarion',
                                         'name': 'MooreKasie',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:94:ae:4b'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:74:d1:eb'}],
                                                                       'mac_address': '00:10:e7:94:5a:09',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5775,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 1000,
                                                                                                                                                     'mac_address': '00:10:e7:74:d1:eb',
                                                                                                                                                     'rx_link_rate': '5120000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ55Ra'}],
                                         'management_ip': '10.10.36.84',
                                         'manufacturer': 'Alvarion',
                                         'name': 'SchutzDavy',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:94:5a:09'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:74:d1:eb'}],
                                                                       'mac_address': '00:10:e7:a4:d5:41',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5775,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 1000,
                                                                                                                                                     'mac_address': '00:10:e7:74:d1:eb',
                                                                                                                                                     'rx_link_rate': '12288000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '12288000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ56TV'}],
                                         'management_ip': '10.10.36.89',
                                         'manufacturer': 'Alvarion',
                                         'name': 'EustisFairBuilding',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:a4:d5:41'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:74:d1:eb'}],
                                                                       'mac_address': '00:10:e7:14:40:d3',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5775,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 1000,
                                                                                                                                                     'mac_address': '00:10:e7:74:d1:eb',
                                                                                                                                                     'rx_link_rate': '11392000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '2304000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ5xRA'}],
                                         'management_ip': '10.10.36.75',
                                         'manufacturer': 'Alvarion',
                                         'name': 'AGVALLEY-EUSTIS-EAST',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:14:40:d3'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:74:d1:eb'}],
                                                                       'mac_address': '00:10:e7:54:91:2b',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5775,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 1000,
                                                                                                                                                     'mac_address': '00:10:e7:74:d1:eb',
                                                                                                                                                     'rx_link_rate': '2048000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '512000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ51SR'}],
                                         'management_ip': '10.10.36.102',
                                         'manufacturer': 'Alvarion',
                                         'name': 'A&TRepair',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:54:91:2b'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:74:d1:eb'}],
                                                                       'mac_address': '00:10:e7:54:f3:b5',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5775,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 6000,
                                                                                                                                                     'mac_address': '00:10:e7:74:d1:eb',
                                                                                                                                                     'rx_link_rate': '11264000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '2048000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ51Tz'}],
                                         'management_ip': '10.10.36.65',
                                         'manufacturer': 'Alvarion',
                                         'name': 'HueftleNicole',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:54:f3:b5'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_alvarion_breezeaccess_BreezeACCESS_VL_6_6_2_01(self):
        obj = self.run_data("alvarion.breezeaccess.BreezeACCESS VL.6.6.2.01")
        exp_info = {
                'model': 'BreezeACCESS VL',
                'rf_freq': 5750,
                'rf_tx_power': 21,
                'sta_count': 26,
                'sw_version': '6.6.2',
                'vendor': 'Alvarion'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '00:10:e7:14:01:57': {       'dev_macs': ['d8:b6:b7:e5:d3:e7'],
                                             'ip_address': '10.10.20.136',
                                             'mac_address': '00:10:e7:14:01:57',
                                             'name': 'McclainRex'},
                '00:10:e7:54:2e:15': {       'dev_macs': ['b4:75:0e:9f:2b:e4'],
                                             'ip_address': '10.0.0.1',
                                             'mac_address': '00:10:e7:54:2e:15',
                                             'name': 'JoppaChris'},
                '00:10:e7:54:f4:2a': {       'dev_macs': ['00:18:f8:fe:f9:0c'],
                                             'ip_address': '10.10.20.180',
                                             'mac_address': '00:10:e7:54:f4:2a',
                                             'name': 'McClainRex'},
                '00:10:e7:54:f9:f1': {       'dev_macs': ['c8:d1:2a:02:a8:ed'],
                                             'ip_address': '10.10.20.85',
                                             'mac_address': '00:10:e7:54:f9:f1',
                                             'name': 'LENTZSARA'},
                '00:10:e7:64:7a:63': {       'dev_macs': ['d8:b6:b7:82:68:9b'],
                                             'ip_address': '10.10.20.78',
                                             'mac_address': '00:10:e7:64:7a:63',
                                             'name': 'HuntRyan'},
                '00:10:e7:64:a7:56': {       'dev_macs': ['c8:d1:2a:68:66:64'],
                                             'ip_address': '10.10.20.100',
                                             'mac_address': '00:10:e7:64:a7:56',
                                             'name': 'GareyDoug Kevins a putz'},
                '00:10:e7:64:bb:7b': {       'dev_macs': ['c8:d7:19:a4:ee:94'],
                                             'ip_address': '10.10.20.75',
                                             'mac_address': '00:10:e7:64:bb:7b',
                                             'name': 'GeiseEthan'},
                '00:10:e7:64:dd:3e': {       'dev_macs': ['c8:d7:19:60:b9:26'],
                                             'ip_address': '10.10.20.104',
                                             'mac_address': '00:10:e7:64:dd:3e',
                                             'name': 'WentlingCarolyn'},
                '00:10:e7:74:43:88': {       'dev_macs': ['b4:75:0e:cf:8f:17'],
                                             'ip_address': '10.10.20.107',
                                             'mac_address': '00:10:e7:74:43:88',
                                             'name': 'BeckerDave'},
                '00:10:e7:74:73:9d': {       'dev_macs': ['3c:90:66:f0:47:00'],
                                             'ip_address': '10.10.20.102',
                                             'mac_address': '00:10:e7:74:73:9d',
                                             'name': 'JarettVicki'},
                '00:10:e7:74:bd:cb': {       'dev_macs': ['68:7f:74:f1:7d:1c'],
                                             'ip_address': '10.0.0.1',
                                             'mac_address': '00:10:e7:74:bd:cb',
                                             'name': 'Stanleys-Spirits-RexMcClain'},
                '00:10:e7:94:0b:9d': {       'dev_macs': ['c8:d1:2a:01:08:5c'],
                                             'ip_address': '10.10.20.65',
                                             'mac_address': '00:10:e7:94:0b:9d',
                                             'name': 'StubbsMoiya'},
                '00:10:e7:94:0f:06': {       'dev_macs': ['d8:b6:b7:82:58:c9'],
                                             'ip_address': '10.10.20.79',
                                             'mac_address': '00:10:e7:94:0f:06',
                                             'name': 'HuntTracey'},
                '00:10:e7:94:24:3e': {       'dev_macs': ['b4:75:0e:c2:5d:60'],
                                             'ip_address': '10.10.20.111',
                                             'mac_address': '00:10:e7:94:24:3e',
                                             'name': 'WarnerMonte'},
                '00:10:e7:94:88:4d': {       'dev_macs': ['58:6d:8f:9c:9b:65'],
                                             'ip_address': '10.10.20.70',
                                             'mac_address': '00:10:e7:94:88:4d',
                                             'name': 'MccartyFarmsScale'},
                '00:10:e7:94:88:54': {       'dev_macs': ['c0:56:27:31:c2:cb'],
                                             'ip_address': '10.10.20.90',
                                             'mac_address': '00:10:e7:94:88:54',
                                             'name': 'RobinsonSeth'},
                '00:10:e7:94:8d:b0': {       'dev_macs': ['c8:d7:19:98:3f:9d'],
                                             'ip_address': '10.10.20.113',
                                             'mac_address': '00:10:e7:94:8d:b0',
                                             'name': 'SoderlundHomeierMeghan'},
                '00:10:e7:94:8d:d4': {       'dev_macs': ['d8:b6:b7:82:56:71'],
                                             'ip_address': '10.10.20.96',
                                             'mac_address': '00:10:e7:94:8d:d4',
                                             'name': 'WilliamsDavid'},
                '00:10:e7:94:8d:d8': {       'dev_macs': ['d8:b6:b7:bb:6c:1a'],
                                             'ip_address': '10.10.20.97',
                                             'mac_address': '00:10:e7:94:8d:d8',
                                             'name': 'WarnerDarren'},
                '00:10:e7:94:af:35': {       'dev_macs': ['7c:5a:1c:61:6b:09'],
                                             'ip_address': '10.10.20.86',
                                             'mac_address': '00:10:e7:94:af:35',
                                             'name': 'McCartyFamilyFarms'},
                '00:10:e7:94:c6:a4': {       'dev_macs': ['f8:8e:85:73:86:15'],
                                             'ip_address': '10.10.20.138',
                                             'mac_address': '00:10:e7:94:c6:a4',
                                             'name': 'BeckerJerome'},
                '00:10:e7:a4:75:05': {       'dev_macs': ['c8:d1:2a:01:13:c9'],
                                             'ip_address': '10.10.20.66',
                                             'mac_address': '00:10:e7:a4:75:05',
                                             'name': 'LaborieJohn'},
                '00:10:e7:c4:4e:7f': {       'dev_macs': ['c8:d1:2a:01:01:a9'],
                                             'ip_address': '10.0.0.1',
                                             'mac_address': '00:10:e7:c4:4e:7f',
                                             'name': 'BartlettTeresa'},
                '00:10:e7:c4:88:56': {       'dev_macs': ['c8:d1:2a:02:a9:6f'],
                                             'ip_address': '10.10.20.122',
                                             'mac_address': '00:10:e7:c4:88:56',
                                             'name': 'RobinsonDon'},
                '00:10:e7:c4:e2:66': {       'dev_macs': ['3c:90:66:fe:05:a0'],
                                             'ip_address': '10.10.20.84',
                                             'mac_address': '00:10:e7:c4:e2:66',
                                             'name': 'HuntSam'}
        }
        exp_ne_msg = {
                'data': {       'height': 30.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '188120052',
                                                              'in_nucast_pkts': '115539',
                                                              'in_octets': '3715635095',
                                                              'in_ucast_pkts': '1795383948',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       'd8:b6:b7:82:68:9b'],
                                                                                       'mac_address': '00:10:e7:64:7a:63'},
                                                                               {       'bridged_mac_addresses': [       'c8:d1:2a:68:66:64'],
                                                                                       'mac_address': '00:10:e7:64:a7:56'},
                                                                               {       'bridged_mac_addresses': [       'c8:d7:19:a4:ee:94'],
                                                                                       'mac_address': '00:10:e7:64:bb:7b'},
                                                                               {       'bridged_mac_addresses': [       'c8:d7:19:60:b9:26'],
                                                                                       'mac_address': '00:10:e7:64:dd:3e'},
                                                                               {       'bridged_mac_addresses': [       '3c:90:66:f0:47:00'],
                                                                                       'mac_address': '00:10:e7:74:73:9d'},
                                                                               {       'bridged_mac_addresses': [       '68:7f:74:f1:7d:1c'],
                                                                                       'mac_address': '00:10:e7:74:bd:cb'},
                                                                               {       'bridged_mac_addresses': [       'b4:75:0e:cf:8f:17'],
                                                                                       'mac_address': '00:10:e7:74:43:88'},
                                                                               {       'bridged_mac_addresses': [       'c8:d1:2a:01:08:5c'],
                                                                                       'mac_address': '00:10:e7:94:0b:9d'},
                                                                               {       'bridged_mac_addresses': [       '58:6d:8f:9c:9b:65'],
                                                                                       'mac_address': '00:10:e7:94:88:4d'},
                                                                               {       'bridged_mac_addresses': [       'c0:56:27:31:c2:cb'],
                                                                                       'mac_address': '00:10:e7:94:88:54'},
                                                                               {       'bridged_mac_addresses': [       'c8:d7:19:98:3f:9d'],
                                                                                       'mac_address': '00:10:e7:94:8d:b0'},
                                                                               {       'bridged_mac_addresses': [       'd8:b6:b7:82:56:71'],
                                                                                       'mac_address': '00:10:e7:94:8d:d4'},
                                                                               {       'bridged_mac_addresses': [       'd8:b6:b7:bb:6c:1a'],
                                                                                       'mac_address': '00:10:e7:94:8d:d8'},
                                                                               {       'bridged_mac_addresses': [       'd8:b6:b7:82:58:c9'],
                                                                                       'mac_address': '00:10:e7:94:0f:06'},
                                                                               {       'bridged_mac_addresses': [       '7c:5a:1c:61:6b:09'],
                                                                                       'mac_address': '00:10:e7:94:af:35'},
                                                                               {       'bridged_mac_addresses': [       'f8:8e:85:73:86:15'],
                                                                                       'mac_address': '00:10:e7:94:c6:a4'},
                                                                               {       'bridged_mac_addresses': [       'b4:75:0e:c2:5d:60'],
                                                                                       'mac_address': '00:10:e7:94:24:3e'},
                                                                               {       'bridged_mac_addresses': [       'c8:d1:2a:01:13:c9'],
                                                                                       'mac_address': '00:10:e7:a4:75:05'},
                                                                               {       'bridged_mac_addresses': [       'c8:d1:2a:02:a9:6f'],
                                                                                       'mac_address': '00:10:e7:c4:88:56'},
                                                                               {       'bridged_mac_addresses': [       '3c:90:66:fe:05:a0'],
                                                                                       'mac_address': '00:10:e7:c4:e2:66'},
                                                                               {       'bridged_mac_addresses': [       'c8:d1:2a:01:01:a9'],
                                                                                       'mac_address': '00:10:e7:c4:4e:7f'},
                                                                               {       'bridged_mac_addresses': [       'd8:b6:b7:e5:d3:e7'],
                                                                                       'mac_address': '00:10:e7:14:01:57'},
                                                                               {       'bridged_mac_addresses': [       '00:18:f8:fe:f9:0c'],
                                                                                       'mac_address': '00:10:e7:54:f4:2a'},
                                                                               {       'bridged_mac_addresses': [       'c8:d1:2a:02:a8:ed'],
                                                                                       'mac_address': '00:10:e7:54:f9:f1'},
                                                                               {       'bridged_mac_addresses': [       'b4:75:0e:9f:2b:e4'],
                                                                                       'mac_address': '00:10:e7:54:2e:15'}],
                                                              'mac_address': '00:10:e7:14:33:e0',
                                                              'mtu': 1514,
                                                              'name': 'Radio port',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '411984',
                                                              'out_nucast_pkts': '118425042',
                                                              'out_octets': '192555417',
                                                              'out_ucast_pkts': '1443082434',
                                                              'radios': [       {       'frequency': 5750,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 12000,
                                                                                                                                            'mac_address': '00:10:e7:64:7a:63',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -79.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 17.0,
                                                                                                                                            'tx_link_rate': '5120000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 2000,
                                                                                                                                            'mac_address': '00:10:e7:64:a7:56',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -82.0,
                                                                                                                                            'rx_link_rate': '512000',
                                                                                                                                            'snr': 14.0,
                                                                                                                                            'tx_link_rate': '3072000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 4000,
                                                                                                                                            'mac_address': '00:10:e7:64:bb:7b',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -75.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 21.0,
                                                                                                                                            'tx_link_rate': '8192000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 4000,
                                                                                                                                            'mac_address': '00:10:e7:64:dd:3e',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -77.0,
                                                                                                                                            'rx_link_rate': '512000',
                                                                                                                                            'snr': 18.0,
                                                                                                                                            'tx_link_rate': '3072000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 10000,
                                                                                                                                            'mac_address': '00:10:e7:74:73:9d',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -81.0,
                                                                                                                                            'rx_link_rate': '4096000',
                                                                                                                                            'snr': 15.0,
                                                                                                                                            'tx_link_rate': '6016000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'distance': 5000,
                                                                                                                                            'mac_address': '00:10:e7:74:bd:cb',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -78.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 16.0,
                                                                                                                                            'tx_link_rate': '6016000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 4000,
                                                                                                                                            'mac_address': '00:10:e7:74:43:88',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -73.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 23.0,
                                                                                                                                            'tx_link_rate': '6016000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 4000,
                                                                                                                                            'mac_address': '00:10:e7:94:0b:9d',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -76.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 19.0,
                                                                                                                                            'tx_link_rate': '5120000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 3000,
                                                                                                                                            'mac_address': '00:10:e7:94:88:4d',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '2048000',
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '5120000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 5000,
                                                                                                                                            'mac_address': '00:10:e7:94:88:54',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -77.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 19.0,
                                                                                                                                            'tx_link_rate': '5120000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 3000,
                                                                                                                                            'mac_address': '00:10:e7:94:8d:b0',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -78.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 18.0,
                                                                                                                                            'tx_link_rate': '5120000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 2000,
                                                                                                                                            'mac_address': '00:10:e7:94:8d:d4',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '5120000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 9000,
                                                                                                                                            'mac_address': '00:10:e7:94:8d:d8',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -87.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 9.0,
                                                                                                                                            'tx_link_rate': '5120000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'distance': 1000,
                                                                                                                                            'mac_address': '00:10:e7:94:0f:06',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_link_rate': '512000',
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '2048000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 2000,
                                                                                                                                            'mac_address': '00:10:e7:94:af:35',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_link_rate': '2048000',
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '5120000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 4000,
                                                                                                                                            'mac_address': '00:10:e7:94:c6:a4',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 24.0,
                                                                                                                                            'tx_link_rate': '5120000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 7000,
                                                                                                                                            'mac_address': '00:10:e7:94:24:3e',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -79.0,
                                                                                                                                            'rx_link_rate': '512000',
                                                                                                                                            'snr': 17.0,
                                                                                                                                            'tx_link_rate': '3072000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 4000,
                                                                                                                                            'mac_address': '00:10:e7:a4:75:05',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '2048000',
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '10240000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 5000,
                                                                                                                                            'mac_address': '00:10:e7:c4:88:56',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -73.0,
                                                                                                                                            'rx_link_rate': '2048000',
                                                                                                                                            'snr': 23.0,
                                                                                                                                            'tx_link_rate': '10240000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 1000,
                                                                                                                                            'mac_address': '00:10:e7:c4:e2:66',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '2048000',
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '10240000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 4000,
                                                                                                                                            'mac_address': '00:10:e7:c4:4e:7f',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '2048000',
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '10240000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 4000,
                                                                                                                                            'mac_address': '00:10:e7:14:01:57',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '5120000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 4000,
                                                                                                                                            'mac_address': '00:10:e7:54:f4:2a',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -72.0,
                                                                                                                                            'rx_link_rate': '512000',
                                                                                                                                            'snr': 23.0,
                                                                                                                                            'tx_link_rate': '3072000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 4000,
                                                                                                                                            'mac_address': '00:10:e7:54:f9:f1',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -74.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 21.0,
                                                                                                                                            'tx_link_rate': '5120000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 4000,
                                                                                                                                            'mac_address': '00:10:e7:54:2e:15',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -78.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 17.0,
                                                                                                                                            'tx_link_rate': '6016000',
                                                                                                                                            'tx_mcs': 8}],
                                                                                                                   'noise_floor': -96.0}],
                                                                                        'tx_power': 21}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '8000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '103569812',
                                                              'in_octets': '2787117090',
                                                              'in_ucast_pkts': '587332126',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1514,
                                                              'name': 'Ethernet port',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '118330',
                                                              'out_octets': '3024659323',
                                                              'out_ucast_pkts': '1806249651',
                                                              'poller_hash': 'AQ5xQz4P',
                                                              'speed': '10000000',
                                                              'type': 6}],
                                'manufacturer': 'Alvarion',
                                'model': 'BreezeACCESS VL',
                                'name': 'STRAYER-VLAU01',
                                'sw_version': '6.6.2',
                                'system_mac_address': '00:10:e7:14:33:e0',
                                'uptime': '34500209'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:64:7a:63',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 12000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '5120000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ52R6'}],
                                         'management_ip': '10.10.20.78',
                                         'manufacturer': 'Alvarion',
                                         'name': 'HuntRyan',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:64:7a:63'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:64:a7:56',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 2000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '3072000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '512000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ52Sn'}],
                                         'management_ip': '10.10.20.100',
                                         'manufacturer': 'Alvarion',
                                         'name': 'GareyDoug Kevins a putz',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:64:a7:56'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:64:bb:7b',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 4000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '8192000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ52S7'}],
                                         'management_ip': '10.10.20.75',
                                         'manufacturer': 'Alvarion',
                                         'name': 'GeiseEthan',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:64:bb:7b'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:64:dd:3e',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 4000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '3072000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '512000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ52Td'}],
                                         'management_ip': '10.10.20.104',
                                         'manufacturer': 'Alvarion',
                                         'name': 'WentlingCarolyn',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.5.7',
                                         'system_mac_address': '00:10:e7:64:dd:3e'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:74:73:9d',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 10000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '6016000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'tx_link_rate': '4096000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ53Rz'}],
                                         'management_ip': '10.10.20.102',
                                         'manufacturer': 'Alvarion',
                                         'name': 'JarettVicki',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:74:73:9d'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:74:bd:cb',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 5000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '6016000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ53S9'}],
                                         'management_ip': '10.0.0.1',
                                         'manufacturer': 'Alvarion',
                                         'name': 'Stanleys-Spirits-RexMcClain',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.5.7',
                                         'system_mac_address': '00:10:e7:74:bd:cb'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:74:43:88',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 4000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '6016000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ53RD'}],
                                         'management_ip': '10.10.20.107',
                                         'manufacturer': 'Alvarion',
                                         'name': 'BeckerDave',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.5.7',
                                         'system_mac_address': '00:10:e7:74:43:88'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:94:0b:9d',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 4000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '5120000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ55QL'}],
                                         'management_ip': '10.10.20.65',
                                         'manufacturer': 'Alvarion',
                                         'name': 'StubbsMoiya',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:94:0b:9d'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:94:88:4d',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 3000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '5120000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '2048000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ55SI'}],
                                         'management_ip': '10.10.20.70',
                                         'manufacturer': 'Alvarion',
                                         'name': 'MccartyFarmsScale',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:94:88:4d'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:94:88:54',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 5000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '5120000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ55SI'}],
                                         'management_ip': '10.10.20.90',
                                         'manufacturer': 'Alvarion',
                                         'name': 'RobinsonSeth',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:94:88:54'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:94:8d:b0',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 3000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '5120000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ55SN'}],
                                         'management_ip': '10.10.20.113',
                                         'manufacturer': 'Alvarion',
                                         'name': 'SoderlundHomeierMeghan',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:94:8d:b0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:94:8d:d4',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 2000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '5120000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ55SN'}],
                                         'management_ip': '10.10.20.96',
                                         'manufacturer': 'Alvarion',
                                         'name': 'WilliamsDavid',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:94:8d:d4'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:94:8d:d8',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 9000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '5120000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ55SN'}],
                                         'management_ip': '10.10.20.97',
                                         'manufacturer': 'Alvarion',
                                         'name': 'WarnerDarren',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:94:8d:d8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:94:0f:06',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 1000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '2048000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '512000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ55QP'}],
                                         'management_ip': '10.10.20.79',
                                         'manufacturer': 'Alvarion',
                                         'name': 'HuntTracey',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:94:0f:06'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:94:af:35',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 2000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '5120000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '2048000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ55Sv'}],
                                         'management_ip': '10.10.20.86',
                                         'manufacturer': 'Alvarion',
                                         'name': 'McCartyFamilyFarms',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:94:af:35'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:94:c6:a4',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 4000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '5120000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ55TG'}],
                                         'management_ip': '10.10.20.138',
                                         'manufacturer': 'Alvarion',
                                         'name': 'BeckerJerome',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:94:c6:a4'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:94:24:3e',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 7000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '3072000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '512000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ55Qk'}],
                                         'management_ip': '10.10.20.111',
                                         'manufacturer': 'Alvarion',
                                         'name': 'WarnerMonte',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:94:24:3e'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:a4:75:05',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 4000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '10240000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '2048000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ56R1'}],
                                         'management_ip': '10.10.20.66',
                                         'manufacturer': 'Alvarion',
                                         'name': 'LaborieJohn',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:a4:75:05'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:c4:88:56',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 5000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '10240000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '2048000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ58SI'}],
                                         'management_ip': '10.10.20.122',
                                         'manufacturer': 'Alvarion',
                                         'name': 'RobinsonDon',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:c4:88:56'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:c4:e2:66',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 1000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '10240000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '2048000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ58Ti'}],
                                         'management_ip': '10.10.20.84',
                                         'manufacturer': 'Alvarion',
                                         'name': 'HuntSam',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:c4:e2:66'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:c4:4e:7f',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 4000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '10240000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '2048000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ58RO'}],
                                         'management_ip': '10.0.0.1',
                                         'manufacturer': 'Alvarion',
                                         'name': 'BartlettTeresa',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:c4:4e:7f'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:14:01:57',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 4000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '5120000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ5xQB'}],
                                         'management_ip': '10.10.20.136',
                                         'manufacturer': 'Alvarion',
                                         'name': 'McclainRex',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.5.7',
                                         'system_mac_address': '00:10:e7:14:01:57'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:54:f4:2a',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 4000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '3072000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '512000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ51T0'}],
                                         'management_ip': '10.10.20.180',
                                         'manufacturer': 'Alvarion',
                                         'name': 'McClainRex',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.5.7',
                                         'system_mac_address': '00:10:e7:54:f4:2a'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:54:f9:f1',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 4000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '5120000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ51T5'}],
                                         'management_ip': '10.10.20.85',
                                         'manufacturer': 'Alvarion',
                                         'name': 'LENTZSARA',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:54:f9:f1'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:14:33:e0'}],
                                                                       'mac_address': '00:10:e7:54:2e:15',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 4000,
                                                                                                                                                     'mac_address': '00:10:e7:14:33:e0',
                                                                                                                                                     'rx_link_rate': '6016000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ51Qu'}],
                                         'management_ip': '10.0.0.1',
                                         'manufacturer': 'Alvarion',
                                         'name': 'JoppaChris',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:54:2e:15'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_alvarion_breezeaccess_BreezeACCESS_VL_6_6_2_02(self):
        obj = self.run_data("alvarion.breezeaccess.BreezeACCESS VL.6.6.2.02")
        exp_info = {
                'model': 'BreezeACCESS VL',
                'rf_freq': 5865,
                'rf_tx_power': 21,
                'sta_count': 1,
                'sw_version': '6.6.2',
                'vendor': 'Alvarion'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '00:10:e7:64:7a:8a': {       'dev_macs': ['e8:2c:6d:29:a5:80'],
                                             'ip_address': '10.10.26.93',
                                             'mac_address': '00:10:e7:64:7a:8a',
                                             'name': 'HinsonDani'}
        }
        exp_ne_msg = {
                'data': {       'height': 30.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '135639544',
                                                              'in_nucast_pkts': '27422',
                                                              'in_octets': '288130333',
                                                              'in_ucast_pkts': '308741977',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       'e8:2c:6d:29:a5:80'],
                                                                                       'mac_address': '00:10:e7:64:7a:8a'}],
                                                              'mac_address': '00:10:e7:c4:8b:76',
                                                              'mtu': 1514,
                                                              'name': 'Radio port',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '802861',
                                                              'out_nucast_pkts': '110257782',
                                                              'out_octets': '680120013',
                                                              'out_ucast_pkts': '60326534',
                                                              'radios': [       {       'frequency': 5865,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 16000,
                                                                                                                                            'mac_address': '00:10:e7:64:7a:8a',
                                                                                                                                            'noise_floor': -104.0,
                                                                                                                                            'rssi': -88.0,
                                                                                                                                            'rx_link_rate': '2048000',
                                                                                                                                            'snr': 16.0,
                                                                                                                                            'tx_link_rate': '10240000',
                                                                                                                                            'tx_mcs': 3}],
                                                                                                                   'noise_floor': -105.0}],
                                                                                        'tx_power': 21}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '8000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '196933164',
                                                              'in_octets': '1342413388',
                                                              'in_ucast_pkts': '1430903699',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1514,
                                                              'name': 'Ethernet port',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '29187',
                                                              'out_octets': '1367331624',
                                                              'out_ucast_pkts': '359039182',
                                                              'poller_hash': 'AQ58SLdv',
                                                              'speed': '10000000',
                                                              'type': 6}],
                                'manufacturer': 'Alvarion',
                                'model': 'BreezeACCESS VL',
                                'name': 'OXFDVLAU02 90 NORTH SOUTH',
                                'sw_version': '6.6.2',
                                'system_mac_address': '00:10:e7:c4:8b:76',
                                'uptime': '7135226'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:c4:8b:76'}],
                                                                       'mac_address': '00:10:e7:64:7a:8a',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5865,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 16000,
                                                                                                                                                     'mac_address': '00:10:e7:c4:8b:76',
                                                                                                                                                     'rx_link_rate': '10240000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'tx_link_rate': '2048000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ52R6'}],
                                         'management_ip': '10.10.26.93',
                                         'manufacturer': 'Alvarion',
                                         'name': 'HinsonDani',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:64:7a:8a'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_alvarion_breezeaccess_BreezeACCESS_VL_6_6_2_03(self):
        obj = self.run_data("alvarion.breezeaccess.BreezeACCESS VL.6.6.2.03")
        exp_info = {
                'model': 'BreezeACCESS VL',
                'rf_freq': 5830,
                'rf_tx_power': 21,
                'sta_count': 4,
                'sw_version': '6.6.2',
                'vendor': 'Alvarion'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '00:10:e7:44:c8:33': {       'dev_macs': ['c8:d1:2a:01:13:ab'],
                                             'ip_address': '10.10.4.93',
                                             'mac_address': '00:10:e7:44:c8:33',
                                             'name': 'AndersonWyatt'},
                '00:10:e7:54:33:34': {       'dev_macs': ['e8:2c:6d:18:ad:10'],
                                             'ip_address': '10.10.4.78',
                                             'mac_address': '00:10:e7:54:33:34',
                                             'name': 'RosackerBrian'},
                '00:10:e7:94:0c:16': {       'dev_macs': ['20:aa:4b:b8:65:e4'],
                                             'ip_address': '10.10.4.69',
                                             'mac_address': '00:10:e7:94:0c:16',
                                             'name': 'HammondKen'},
                '00:10:e7:94:0f:8f': {       'dev_macs': ['c8:d1:2a:01:14:50'],
                                             'ip_address': '10.0.0.1',
                                             'mac_address': '00:10:e7:94:0f:8f',
                                             'name': 'LansLynn'}
        }
        exp_ne_msg = {
                'data': {       'height': 30.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '183863000',
                                                              'in_nucast_pkts': '405',
                                                              'in_octets': '4221484447',
                                                              'in_ucast_pkts': '1905760539',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '20:aa:4b:b8:65:e4'],
                                                                                       'mac_address': '00:10:e7:94:0c:16'},
                                                                               {       'bridged_mac_addresses': [       'c8:d1:2a:01:14:50'],
                                                                                       'mac_address': '00:10:e7:94:0f:8f'},
                                                                               {       'bridged_mac_addresses': [       'c8:d1:2a:01:13:ab'],
                                                                                       'mac_address': '00:10:e7:44:c8:33'},
                                                                               {       'bridged_mac_addresses': [       'e8:2c:6d:18:ad:10'],
                                                                                       'mac_address': '00:10:e7:54:33:34'}],
                                                              'mac_address': '00:10:e7:74:69:bf',
                                                              'mtu': 1514,
                                                              'name': 'Radio port',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '23714',
                                                              'out_nucast_pkts': '33183968',
                                                              'out_octets': '348784709',
                                                              'out_ucast_pkts': '2278598679',
                                                              'radios': [       {       'frequency': 5830,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 9000,
                                                                                                                                            'mac_address': '00:10:e7:94:0c:16',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -82.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 16.0,
                                                                                                                                            'tx_link_rate': '5120000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'distance': 10000,
                                                                                                                                            'mac_address': '00:10:e7:94:0f:8f',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -79.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '5120000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 7000,
                                                                                                                                            'mac_address': '00:10:e7:44:c8:33',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -79.0,
                                                                                                                                            'rx_link_rate': '2048000',
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '10240000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 9000,
                                                                                                                                            'mac_address': '00:10:e7:54:33:34',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -80.0,
                                                                                                                                            'rx_link_rate': '1024000',
                                                                                                                                            'snr': 18.0,
                                                                                                                                            'tx_link_rate': '5120000',
                                                                                                                                            'tx_mcs': 7}],
                                                                                                                   'noise_floor': -97.0}],
                                                                                        'tx_power': 21}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '8000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '30923400',
                                                              'in_octets': '2400396087',
                                                              'in_ucast_pkts': '3206576767',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1514,
                                                              'name': 'Ethernet port',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '483',
                                                              'out_octets': '1369520679',
                                                              'out_ucast_pkts': '1913483553',
                                                              'poller_hash': 'AQ53Rpv/',
                                                              'speed': '10000000',
                                                              'type': 6}],
                                'manufacturer': 'Alvarion',
                                'model': 'BreezeACCESS VL',
                                'name': 'OVERTON VLAU01',
                                'sw_version': '6.6.2',
                                'system_mac_address': '00:10:e7:74:69:bf',
                                'uptime': '22297770'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:74:69:bf'}],
                                                                       'mac_address': '00:10:e7:94:0c:16',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5830,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 9000,
                                                                                                                                                     'mac_address': '00:10:e7:74:69:bf',
                                                                                                                                                     'rx_link_rate': '5120000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ55QM'}],
                                         'management_ip': '10.10.4.69',
                                         'manufacturer': 'Alvarion',
                                         'name': 'HammondKen',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:94:0c:16'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:74:69:bf'}],
                                                                       'mac_address': '00:10:e7:94:0f:8f',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5830,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 10000,
                                                                                                                                                     'mac_address': '00:10:e7:74:69:bf',
                                                                                                                                                     'rx_link_rate': '5120000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ55QP'}],
                                         'management_ip': '10.0.0.1',
                                         'manufacturer': 'Alvarion',
                                         'name': 'LansLynn',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:94:0f:8f'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:74:69:bf'}],
                                                                       'mac_address': '00:10:e7:44:c8:33',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5830,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 7000,
                                                                                                                                                     'mac_address': '00:10:e7:74:69:bf',
                                                                                                                                                     'rx_link_rate': '10240000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '2048000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ50TI'}],
                                         'management_ip': '10.10.4.93',
                                         'manufacturer': 'Alvarion',
                                         'name': 'AndersonWyatt',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:44:c8:33'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'links': [       {       'mac_address': '00:10:e7:74:69:bf'}],
                                                                       'mac_address': '00:10:e7:54:33:34',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'frequency': 5830,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 9000,
                                                                                                                                                     'mac_address': '00:10:e7:74:69:bf',
                                                                                                                                                     'rx_link_rate': '5120000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'tx_link_rate': '1024000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8gAQ51Qz'}],
                                         'management_ip': '10.10.4.78',
                                         'manufacturer': 'Alvarion',
                                         'name': 'RosackerBrian',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.6.2',
                                         'system_mac_address': '00:10:e7:54:33:34'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
