import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestCalixModels(DeviceTestCase):
    def test_calix_axos_E7_2_24_1_1_01(self):
        obj = self.run_data("calix.axos.E7-2.24.1.1.01")
        exp_info = {
         'model': 'E7-2', 'sta_count': 43, 'sw_version': '24.1.1', 'vendor': 'Calix'
        }
        exp_stats = {
         'serial_number': '472212071774', 'system_mac_address': '84:d3:43:d2:71:58'
        }
        exp_sta_stats = {
                None: {       'dev_macs': None,
                              'ip_address': None,
                              'mac_address': None,
                              'name': 'sonar_item_29640/g1',
                              'serial_number': '11026FF',
                              'system_mac_address': None},
                '04:bc:9f:66:8c:d4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:66:8c:d4',
                                             'name': 'sonar_item_51416/g1',
                                             'serial_number': '128575F',
                                             'system_mac_address': None},
                '04:bc:9f:78:d9:91': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:78:d9:91',
                                             'name': 'sonar_item_51718/g1',
                                             'serial_number': '12A51C7',
                                             'system_mac_address': None},
                '04:bc:9f:78:ea:53': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:78:ea:53',
                                             'name': 'sonar_item_51707/g1',
                                             'serial_number': '12A5521',
                                             'system_mac_address': None},
                '04:bc:9f:78:ec:33': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:78:ec:33',
                                             'name': 'sonar_item_52034/g1',
                                             'serial_number': '12A5581',
                                             'system_mac_address': None},
                '04:bc:9f:78:ec:ec': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:78:ec:ec',
                                             'name': 'sonar_item_51716/g1',
                                             'serial_number': '12A55A6',
                                             'system_mac_address': None},
                '04:bc:9f:78:ed:5f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:78:ed:5f',
                                             'name': 'sonar_item_51713/g1',
                                             'serial_number': '12A55BD',
                                             'system_mac_address': None},
                '04:bc:9f:78:ed:9b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:78:ed:9b',
                                             'name': 'sonar_item_51726/g1',
                                             'serial_number': '12A55C9',
                                             'system_mac_address': None},
                '04:bc:9f:78:ef:08': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:78:ef:08',
                                             'name': 'sonar_item_51719/g1',
                                             'serial_number': '12A5612',
                                             'system_mac_address': None},
                '14:21:03:47:37:d7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '14:21:03:47:37:d7',
                                             'name': 'sonar_item_59404/g1',
                                             'serial_number': '13C7891',
                                             'system_mac_address': None},
                'b8:94:70:50:ee:71': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:50:ee:71',
                                             'name': 'sonar_item_29594/g1',
                                             'serial_number': '110420D',
                                             'system_mac_address': None},
                'b8:94:70:50:ee:99': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:50:ee:99',
                                             'name': 'sonar_item_29557/g1',
                                             'serial_number': '1104215',
                                             'system_mac_address': None},
                'b8:94:70:50:ef:e3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:50:ef:e3',
                                             'name': 'sonar_item_29606/g1',
                                             'serial_number': '1104257',
                                             'system_mac_address': None},
                'b8:94:70:51:0d:9d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:51:0d:9d',
                                             'name': 'sonar_item_29553/g1',
                                             'serial_number': '1104849',
                                             'system_mac_address': None},
                'b8:94:70:51:0f:50': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:51:0f:50',
                                             'name': 'sonar_item_29605/g1',
                                             'serial_number': '11048A0',
                                             'system_mac_address': None},
                'b8:94:70:51:10:bd': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:51:10:bd',
                                             'name': 'sonar_item_29617/g1',
                                             'serial_number': '11048E9',
                                             'system_mac_address': None},
                'b8:94:70:7f:e8:e3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:7f:e8:e3',
                                             'name': 'sonar_item_69744/g1',
                                             'serial_number': '113CB31',
                                             'system_mac_address': None},
                'b8:94:70:7f:ee:c9': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:7f:ee:c9',
                                             'name': 'sonar_item_50361/g1',
                                             'serial_number': '113CC5F',
                                             'system_mac_address': None},
                'b8:94:70:ef:8b:ae': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ef:8b:ae',
                                             'name': 'sonar_item_36734/g1',
                                             'serial_number': '11FEAFB',
                                             'system_mac_address': None},
                'b8:94:70:ef:8e:b0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ef:8e:b0',
                                             'name': 'sonar_item_36750/g1',
                                             'serial_number': '11FEB95',
                                             'system_mac_address': None},
                'b8:94:70:ef:90:cc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ef:90:cc',
                                             'name': 'sonar_item_36743/g1',
                                             'serial_number': '11FEC01',
                                             'system_mac_address': None},
                'b8:94:70:f4:7b:a5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:f4:7b:a5',
                                             'name': 'sonar_item_52109/g1',
                                             'serial_number': '1207657',
                                             'system_mac_address': None},
                'b8:94:70:f4:7b:be': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:f4:7b:be',
                                             'name': 'sonar_item_52107/g1',
                                             'serial_number': '120765C',
                                             'system_mac_address': None},
                'b8:94:70:f4:7b:c3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:f4:7b:c3',
                                             'name': 'sonar_item_52114/g1',
                                             'serial_number': '120765D',
                                             'system_mac_address': None},
                'b8:94:70:f4:7b:eb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:f4:7b:eb',
                                             'name': 'sonar_item_52131/g1',
                                             'serial_number': '1207665',
                                             'system_mac_address': None},
                'b8:94:70:f4:7e:f2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:f4:7e:f2',
                                             'name': 'sonar_item_50862/g1',
                                             'serial_number': '1207700',
                                             'system_mac_address': None},
                'b8:94:70:f4:80:e1': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:f4:80:e1',
                                             'name': 'sonar_item_50861/g1',
                                             'serial_number': '1207763',
                                             'system_mac_address': None},
                'b8:94:70:f4:82:9e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:f4:82:9e',
                                             'name': 'sonar_item_50852/g1',
                                             'serial_number': '12077BC',
                                             'system_mac_address': None},
                'f8:85:f9:13:dd:43': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:13:dd:43',
                                             'name': 'sonar_item_27807/g1',
                                             'serial_number': 'DF5027',
                                             'system_mac_address': None},
                'f8:85:f9:13:dd:57': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:13:dd:57',
                                             'name': 'sonar_item_27866/g1',
                                             'serial_number': 'DF502B',
                                             'system_mac_address': None},
                'f8:85:f9:13:dd:98': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:13:dd:98',
                                             'name': 'sonar_item_27858/g1',
                                             'serial_number': 'DF5038',
                                             'system_mac_address': None},
                'f8:85:f9:13:df:eb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:13:df:eb',
                                             'name': 'sonar_item_27783/g1',
                                             'serial_number': 'DF50AF',
                                             'system_mac_address': None},
                'f8:85:f9:13:e3:c4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:13:e3:c4',
                                             'name': 'sonar_item_27834/g1',
                                             'serial_number': 'DF5174',
                                             'system_mac_address': None},
                'f8:85:f9:13:e3:e7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:13:e3:e7',
                                             'name': 'sonar_item_27835/g1',
                                             'serial_number': 'DF517B',
                                             'system_mac_address': None},
                'f8:85:f9:13:e4:4b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:13:e4:4b',
                                             'name': 'sonar_item_27823/g1',
                                             'serial_number': 'DF518F',
                                             'system_mac_address': None},
                'f8:85:f9:90:17:6d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:90:17:6d',
                                             'name': 'sonar_item_50259/g1',
                                             'serial_number': '1059859',
                                             'system_mac_address': None},
                'f8:85:f9:90:19:16': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:90:19:16',
                                             'name': 'sonar_item_50256/g1',
                                             'serial_number': '10598AE',
                                             'system_mac_address': None},
                'f8:85:f9:90:19:1b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:90:19:1b',
                                             'name': 'sonar_item_50252/g1',
                                             'serial_number': '10598AF',
                                             'system_mac_address': None},
                'f8:85:f9:90:19:7f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:90:19:7f',
                                             'name': 'sonar_item_50257/g1',
                                             'serial_number': '10598C3',
                                             'system_mac_address': None},
                'f8:85:f9:90:1a:01': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:90:1a:01',
                                             'name': 'sonar_item_50255/g1',
                                             'serial_number': '10598DD',
                                             'system_mac_address': None},
                'f8:85:f9:90:1a:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:90:1a:10',
                                             'name': 'sonar_item_50254/g1',
                                             'serial_number': '10598E0',
                                             'system_mac_address': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': '27',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '04:bc:9f:f3:70:df',
                                                              'mtu': 1500,
                                                              'name': 'craft 1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '44108',
                                                              'out_ucast_pkts': '1042',
                                                              'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZGZjcmFmdCAx'},
                                                      {       'admin_up': True,
                                                              'id': '29',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '8818610847',
                                                              'in_ucast_pkts': '154280166',
                                                              'mtu': 1500,
                                                              'name': 'craft 2',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '20632286803',
                                                              'out_ucast_pkts': '25695489',
                                                              'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZGZjcmFmdCAy'}],
                                'manufacturer': 'Calix',
                                'model': 'E7-2',
                                'modules': [       {       'cpu': 35.0,
                                                           'id': '1/1',
                                                           'interfaces': [       {       'admin_up': False,
                                                                                         'id': '110100101',
                                                                                         'mac_address': '04:bc:9f:f3:70:e4',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/q1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZTQxLzEvcTE='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110100102',
                                                                                         'mac_address': '04:bc:9f:f3:70:e5',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/q2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZTUxLzEvcTI='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110100103',
                                                                                         'mac_address': '04:bc:9f:f3:70:f7',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/q3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZjcxLzEvcTM='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110100104',
                                                                                         'mac_address': '04:bc:9f:f3:70:fb',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/q4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZmIxLzEvcTQ='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010101',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '126265568',
                                                                                         'in_octets': '43378630025618',
                                                                                         'in_ucast_pkts': '33835993602',
                                                                                         'in_unknown_protos': '0',
                                                                                         'mac_address': '04:bc:9f:f3:70:e6',
                                                                                         'manufacturer': 'FS',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/x1',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '2019036',
                                                                                         'out_octets': '5365270711923',
                                                                                         'out_ucast_pkts': '14006496216',
                                                                                         'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZTYxLzEveDE=',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110010102',
                                                                                         'mac_address': '04:bc:9f:f3:70:e7',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/x2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZTcxLzEveDI='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110010103',
                                                                                         'mac_address': '04:bc:9f:f3:70:e8',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/x3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZTgxLzEveDM='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110010104',
                                                                                         'mac_address': '04:bc:9f:f3:70:e9',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/x4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZTkxLzEveDQ='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010105',
                                                                                         'in_discards': '148',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1159170',
                                                                                         'in_octets': '3554974639042',
                                                                                         'in_ucast_pkts': '8161573500',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '238254',
                                                                                                                  'in_octets': '324897792360',
                                                                                                                  'in_ucast_pkts': '624442246',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937935',
                                                                                                                  'out_octets': '1386221087538',
                                                                                                                  'out_ucast_pkts': '1288508087',
                                                                                                                  'poller_hash': 'REY1MDI3cGVlcmludGZzb25hcl9pdGVtXzI3ODA3L2dwMQ=='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '525534',
                                                                                                                  'in_octets': '517700943651',
                                                                                                                  'in_ucast_pkts': '1507591541',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '938175',
                                                                                                                  'out_octets': '589629142716',
                                                                                                                  'out_ucast_pkts': '1512348580',
                                                                                                                  'poller_hash': 'REY1MDM4cGVlcmludGZzb25hcl9pdGVtXzI3ODU4L2dwMQ=='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '7379',
                                                                                                                  'in_octets': '51885604179',
                                                                                                                  'in_ucast_pkts': '171130484',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937929',
                                                                                                                  'out_octets': '343746285714',
                                                                                                                  'out_ucast_pkts': '334004349',
                                                                                                                  'poller_hash': 'MTEwNDg0OXBlZXJpbnRmc29uYXJfaXRlbV8yOTU1My9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '54539',
                                                                                                                  'in_octets': '22157402013',
                                                                                                                  'in_ucast_pkts': '47221133',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937960',
                                                                                                                  'out_octets': '179210528290',
                                                                                                                  'out_ucast_pkts': '145545335',
                                                                                                                  'poller_hash': 'MTEwNDIxNXBlZXJpbnRmc29uYXJfaXRlbV8yOTU1Ny9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '3216',
                                                                                                                  'in_octets': '27385989106',
                                                                                                                  'in_ucast_pkts': '96735024',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937747',
                                                                                                                  'out_octets': '174155474529',
                                                                                                                  'out_ucast_pkts': '162683854',
                                                                                                                  'poller_hash': 'MTEwNDIwRHBlZXJpbnRmc29uYXJfaXRlbV8yOTU5NC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '3214',
                                                                                                                  'in_octets': '1369667312446',
                                                                                                                  'in_ucast_pkts': '1944638404',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937970',
                                                                                                                  'out_octets': '1269957409602',
                                                                                                                  'out_ucast_pkts': '1468560442',
                                                                                                                  'poller_hash': 'MTEwNDhBMHBlZXJpbnRmc29uYXJfaXRlbV8yOTYwNS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '36',
                                                                                                                  'in_octets': '10507397700',
                                                                                                                  'in_ucast_pkts': '15226238',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '15',
                                                                                                                  'out_octets': '13903064752',
                                                                                                                  'out_ucast_pkts': '17501133',
                                                                                                                  'poller_hash': 'MTEwNDI1N3BlZXJpbnRmc29uYXJfaXRlbV8yOTYwNi9ncDE='},
                                                                                                          {       'in_errors': '1',
                                                                                                                  'in_nucast_pkts': '49582',
                                                                                                                  'in_octets': '66865514446',
                                                                                                                  'in_ucast_pkts': '440083847',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937961',
                                                                                                                  'out_octets': '2532060111589',
                                                                                                                  'out_ucast_pkts': '1762490657',
                                                                                                                  'poller_hash': 'MTEwNDhFOXBlZXJpbnRmc29uYXJfaXRlbV8yOTYxNy9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '64826',
                                                                                                                  'in_octets': '23097933507',
                                                                                                                  'in_ucast_pkts': '82226816',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '851727',
                                                                                                                  'out_octets': '20158356744',
                                                                                                                  'out_ucast_pkts': '63087247',
                                                                                                                  'poller_hash': 'MTFGRUFGQnBlZXJpbnRmc29uYXJfaXRlbV8zNjczNC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '24',
                                                                                                                  'in_octets': '76103709115',
                                                                                                                  'in_ucast_pkts': '238040611',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937954',
                                                                                                                  'out_octets': '347134263468',
                                                                                                                  'out_ucast_pkts': '326429086',
                                                                                                                  'poller_hash': 'MTFGRUMwMXBlZXJpbnRmc29uYXJfaXRlbV8zNjc0My9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '23',
                                                                                                                  'in_octets': '7399087829',
                                                                                                                  'in_ucast_pkts': '16007987',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '43445',
                                                                                                                  'out_octets': '9508272545',
                                                                                                                  'out_ucast_pkts': '17074613',
                                                                                                                  'poller_hash': 'MTFGRUI5NXBlZXJpbnRmc29uYXJfaXRlbV8zNjc1MC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '115115',
                                                                                                                  'in_octets': '305166780072',
                                                                                                                  'in_ucast_pkts': '1690086013',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937964',
                                                                                                                  'out_octets': '7196858206476',
                                                                                                                  'out_ucast_pkts': '5067955047',
                                                                                                                  'poller_hash': 'MTA1OThERHBlZXJpbnRmc29uYXJfaXRlbV81MDI1NS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '72995',
                                                                                                                  'in_octets': '17206542256',
                                                                                                                  'in_ucast_pkts': '65074970',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937978',
                                                                                                                  'out_octets': '423878012793',
                                                                                                                  'out_ucast_pkts': '332875406',
                                                                                                                  'poller_hash': 'MTA1OThBRXBlZXJpbnRmc29uYXJfaXRlbV81MDI1Ni9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '578',
                                                                                                                  'in_octets': '30565390310',
                                                                                                                  'in_ucast_pkts': '224523639',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937964',
                                                                                                                  'out_octets': '819707230597',
                                                                                                                  'out_ucast_pkts': '590841424',
                                                                                                                  'poller_hash': 'MTA1OTg1OXBlZXJpbnRmc29uYXJfaXRlbV81MDI1OS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '10770',
                                                                                                                  'in_octets': '102613579654',
                                                                                                                  'in_ucast_pkts': '323000774',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937947',
                                                                                                                  'out_octets': '834456129766',
                                                                                                                  'out_ucast_pkts': '620849090',
                                                                                                                  'poller_hash': 'MTIwNzdCQ3BlZXJpbnRmc29uYXJfaXRlbV81MDg1Mi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '644',
                                                                                                                  'in_octets': '2751921',
                                                                                                                  'in_ucast_pkts': '13788',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '14',
                                                                                                                  'out_octets': '16539097',
                                                                                                                  'out_ucast_pkts': '20611',
                                                                                                                  'poller_hash': 'MTI4NTc1RnBlZXJpbnRmc29uYXJfaXRlbV81MTQxNi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '54063',
                                                                                                                  'in_octets': '26171615527',
                                                                                                                  'in_ucast_pkts': '89665581',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937972',
                                                                                                                  'out_octets': '161759878534',
                                                                                                                  'out_ucast_pkts': '152632004',
                                                                                                                  'poller_hash': 'MTJBNTVCRHBlZXJpbnRmc29uYXJfaXRlbV81MTcxMy9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '7358',
                                                                                                                  'in_octets': '3953722888',
                                                                                                                  'in_ucast_pkts': '8618462',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '64474',
                                                                                                                  'out_octets': '20805255920',
                                                                                                                  'out_ucast_pkts': '18609744',
                                                                                                                  'poller_hash': 'MTJBNTVBNnBlZXJpbnRmc29uYXJfaXRlbV81MTcxNi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '72575',
                                                                                                                  'in_octets': '318771313030',
                                                                                                                  'in_ucast_pkts': '461068191',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937962',
                                                                                                                  'out_octets': '228936843042',
                                                                                                                  'out_ucast_pkts': '494691417',
                                                                                                                  'poller_hash': 'MTNDNzg5MXBlZXJpbnRmc29uYXJfaXRlbV81OTQwNC9ncDE='}],
                                                                                         'mac_address': '04:bc:9f:f3:70:ea',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05642',
                                                                                         'name': '1/1/xp1',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '17821081',
                                                                                         'out_octets': '16954463749943',
                                                                                         'out_ucast_pkts': '14531098949',
                                                                                         'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx',
                                                                                         'pons': [       {       'description': '1/1/xp1',
                                                                                                                 'id': '110010105',
                                                                                                                 'links': [       {       'connected_time': '3702031',
                                                                                                                                          'fiber_length': 2244,
                                                                                                                                          'poller_hash': 'REY1MDI3cGVlcnBvbnNvbmFyX2l0ZW1fMjc4MDcvZ3Ax',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -12.1,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.661988},
                                                                                                                                  {       'connected_time': '5256061',
                                                                                                                                          'fiber_length': 2244,
                                                                                                                                          'poller_hash': 'REY1MDM4cGVlcnBvbnNvbmFyX2l0ZW1fMjc4NTgvZ3Ax',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -11.9,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.661988},
                                                                                                                                  {       'connected_time': '3627819',
                                                                                                                                          'fiber_length': 1428,
                                                                                                                                          'poller_hash': 'MTEwNDg0OXBlZXJwb25zb25hcl9pdGVtXzI5NTUzL2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -11.5,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.661988},
                                                                                                                                  {       'connected_time': '3777714',
                                                                                                                                          'fiber_length': 918,
                                                                                                                                          'poller_hash': 'MTEwNDIxNXBlZXJwb25zb25hcl9pdGVtXzI5NTU3L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -10.8,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.661988},
                                                                                                                                  {       'connected_time': '3777721',
                                                                                                                                          'fiber_length': 1530,
                                                                                                                                          'poller_hash': 'MTEwNDIwRHBlZXJwb25zb25hcl9pdGVtXzI5NTk0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.661988},
                                                                                                                                  {       'connected_time': '3777713',
                                                                                                                                          'fiber_length': 2244,
                                                                                                                                          'poller_hash': 'MTEwNDhBMHBlZXJwb25zb25hcl9pdGVtXzI5NjA1L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -12.7,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.661988},
                                                                                                                                  {       'connected_time': '227381',
                                                                                                                                          'fiber_length': 2244,
                                                                                                                                          'poller_hash': 'MTEwNDI1N3BlZXJwb25zb25hcl9pdGVtXzI5NjA2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -12.1,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.661988},
                                                                                                                                  {       'connected_time': '3777721',
                                                                                                                                          'fiber_length': 1122,
                                                                                                                                          'poller_hash': 'MTEwNDhFOXBlZXJwb25zb25hcl9pdGVtXzI5NjE3L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -11.0,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.661988},
                                                                                                                                  {       'connected_time': '1296326',
                                                                                                                                          'fiber_length': 2244,
                                                                                                                                          'poller_hash': 'MTFGRUFGQnBlZXJwb25zb25hcl9pdGVtXzM2NzM0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -18.1,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.661988},
                                                                                                                                  {       'connected_time': '3776096',
                                                                                                                                          'fiber_length': 918,
                                                                                                                                          'poller_hash': 'MTFGRUMwMXBlZXJwb25zb25hcl9pdGVtXzM2NzQzL2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -22.0,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.661988},
                                                                                                                                  {       'connected_time': '682590',
                                                                                                                                          'fiber_length': 1122,
                                                                                                                                          'poller_hash': 'MTFGRUI5NXBlZXJwb25zb25hcl9pdGVtXzM2NzUwL2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -12.0,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.661988},
                                                                                                                                  {       'connected_time': '3777722',
                                                                                                                                          'fiber_length': 2346,
                                                                                                                                          'poller_hash': 'MTA1OThERHBlZXJwb25zb25hcl9pdGVtXzUwMjU1L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -11.8,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.661988},
                                                                                                                                  {       'connected_time': '3777721',
                                                                                                                                          'fiber_length': 1530,
                                                                                                                                          'poller_hash': 'MTA1OThBRXBlZXJwb25zb25hcl9pdGVtXzUwMjU2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -13.0,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.661988},
                                                                                                                                  {       'connected_time': '3777740',
                                                                                                                                          'fiber_length': 918,
                                                                                                                                          'poller_hash': 'MTA1OTg1OXBlZXJwb25zb25hcl9pdGVtXzUwMjU5L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -19.8,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.661988},
                                                                                                                                  {       'connected_time': '3777727',
                                                                                                                                          'fiber_length': 2244,
                                                                                                                                          'poller_hash': 'MTIwNzdCQ3BlZXJwb25zb25hcl9pdGVtXzUwODUyL2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -11.5,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.661988},
                                                                                                                                  {       'connected_time': '69559',
                                                                                                                                          'fiber_length': 918,
                                                                                                                                          'poller_hash': 'MTI4NTc1RnBlZXJwb25zb25hcl9pdGVtXzUxNDE2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -10.9,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.661988},
                                                                                                                                  {       'connected_time': '3777736',
                                                                                                                                          'fiber_length': 1020,
                                                                                                                                          'poller_hash': 'MTJBNTVCRHBlZXJwb25zb25hcl9pdGVtXzUxNzEzL2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -11.9,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.661988},
                                                                                                                                  {       'connected_time': '870796',
                                                                                                                                          'fiber_length': 918,
                                                                                                                                          'poller_hash': 'MTJBNTVBNnBlZXJwb25zb25hcl9pdGVtXzUxNzE2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -21.6,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.661988},
                                                                                                                                  {       'connected_time': '3777743',
                                                                                                                                          'fiber_length': 2244,
                                                                                                                                          'poller_hash': 'MTNDNzg5MXBlZXJwb25zb25hcl9pdGVtXzU5NDA0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -10.7,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.661988}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -5.0,
                                                                                                                 'minimum_loss': -26.0,
                                                                                                                 'name': '1/1/xp1',
                                                                                                                 'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010106',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '761931',
                                                                                         'in_octets': '1462117031819',
                                                                                         'in_ucast_pkts': '4002441849',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '80373',
                                                                                                                  'in_octets': '52253330373',
                                                                                                                  'in_ucast_pkts': '232994457',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937962',
                                                                                                                  'out_octets': '1129712484779',
                                                                                                                  'out_ucast_pkts': '805809908',
                                                                                                                  'poller_hash': 'REY1MEFGcGVlcmludGZzb25hcl9pdGVtXzI3NzgzL2dwMQ=='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1868',
                                                                                                                  'in_octets': '143191632466',
                                                                                                                  'in_ucast_pkts': '281721356',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937768',
                                                                                                                  'out_octets': '884544687656',
                                                                                                                  'out_ucast_pkts': '681464544',
                                                                                                                  'poller_hash': 'REY1MThGcGVlcmludGZzb25hcl9pdGVtXzI3ODIzL2dwMQ=='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '404',
                                                                                                                  'in_octets': '105973409543',
                                                                                                                  'in_ucast_pkts': '307272299',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937971',
                                                                                                                  'out_octets': '1276897082623',
                                                                                                                  'out_ucast_pkts': '903213014',
                                                                                                                  'poller_hash': 'REY1MTc0cGVlcmludGZzb25hcl9pdGVtXzI3ODM0L2dwMQ=='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '100595',
                                                                                                                  'in_octets': '85849855240',
                                                                                                                  'in_ucast_pkts': '425559540',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937962',
                                                                                                                  'out_octets': '2632939228385',
                                                                                                                  'out_ucast_pkts': '1915355668',
                                                                                                                  'poller_hash': 'REY1MTdCcGVlcmludGZzb25hcl9pdGVtXzI3ODM1L2dwMQ=='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '44865',
                                                                                                                  'in_octets': '24355520804',
                                                                                                                  'in_ucast_pkts': '40499412',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '851736',
                                                                                                                  'out_octets': '65852357204',
                                                                                                                  'out_ucast_pkts': '65654538',
                                                                                                                  'poller_hash': 'REY1MDJCcGVlcmludGZzb25hcl9pdGVtXzI3ODY2L2dwMQ=='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '27453',
                                                                                                                  'in_octets': '8706118668',
                                                                                                                  'in_ucast_pkts': '41193670',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '64512',
                                                                                                                  'out_octets': '237100340034',
                                                                                                                  'out_ucast_pkts': '184069828',
                                                                                                                  'poller_hash': 'MTA1OThFMHBlZXJpbnRmc29uYXJfaXRlbV81MDI1NC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '212',
                                                                                                                  'in_octets': '90080226560',
                                                                                                                  'in_ucast_pkts': '156053454',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937947',
                                                                                                                  'out_octets': '348016857404',
                                                                                                                  'out_ucast_pkts': '297955116',
                                                                                                                  'poller_hash': 'MTIwNzcwMHBlZXJpbnRmc29uYXJfaXRlbV81MDg2Mi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '4489',
                                                                                                                  'in_octets': '9588443790',
                                                                                                                  'in_ucast_pkts': '49254401',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '39',
                                                                                                                  'out_octets': '218780204945',
                                                                                                                  'out_ucast_pkts': '152202897',
                                                                                                                  'poller_hash': 'MTJBNTFDN3BlZXJpbnRmc29uYXJfaXRlbV81MTcxOC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '72885',
                                                                                                                  'in_octets': '343397446619',
                                                                                                                  'in_ucast_pkts': '633558750',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937962',
                                                                                                                  'out_octets': '2143085618407',
                                                                                                                  'out_ucast_pkts': '1651953546',
                                                                                                                  'poller_hash': 'MTJBNTVDOXBlZXJpbnRmc29uYXJfaXRlbV81MTcyNi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '44230',
                                                                                                                  'in_octets': '19373986554',
                                                                                                                  'in_ucast_pkts': '90679121',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '851748',
                                                                                                                  'out_octets': '585279112076',
                                                                                                                  'out_ucast_pkts': '418361144',
                                                                                                                  'poller_hash': 'MTJBNTU4MXBlZXJpbnRmc29uYXJfaXRlbV81MjAzNC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28463',
                                                                                                                  'in_octets': '13731364485',
                                                                                                                  'in_ucast_pkts': '109142332',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '64491',
                                                                                                                  'out_octets': '574076268733',
                                                                                                                  'out_ucast_pkts': '402146086',
                                                                                                                  'poller_hash': 'MTIwNzY1Q3BlZXJpbnRmc29uYXJfaXRlbV81MjEwNy9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '92854',
                                                                                                                  'in_octets': '218661704036',
                                                                                                                  'in_ucast_pkts': '519640106',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937963',
                                                                                                                  'out_octets': '2009893886690',
                                                                                                                  'out_ucast_pkts': '1425899875',
                                                                                                                  'poller_hash': 'MTIwNzY1N3BlZXJpbnRmc29uYXJfaXRlbV81MjEwOS9ncDE='}],
                                                                                         'mac_address': '04:bc:9f:f3:70:eb',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05642',
                                                                                         'name': '1/1/xp2',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '11255442',
                                                                                         'out_octets': '17312811368177',
                                                                                         'out_ucast_pkts': '12685606962',
                                                                                         'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWIxLzEveHAy',
                                                                                         'pons': [       {       'description': '1/1/xp2',
                                                                                                                 'id': '110010106',
                                                                                                                 'links': [       {       'connected_time': '3777719',
                                                                                                                                          'fiber_length': 1938,
                                                                                                                                          'poller_hash': 'REY1MEFGcGVlcnBvbnNvbmFyX2l0ZW1fMjc3ODMvZ3Ax',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -12.1,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.762484},
                                                                                                                                  {       'connected_time': '2380243',
                                                                                                                                          'fiber_length': 2040,
                                                                                                                                          'poller_hash': 'REY1MThGcGVlcnBvbnNvbmFyX2l0ZW1fMjc4MjMvZ3Ax',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -11.1,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.762484},
                                                                                                                                  {       'connected_time': '3777699',
                                                                                                                                          'fiber_length': 1938,
                                                                                                                                          'poller_hash': 'REY1MTc0cGVlcnBvbnNvbmFyX2l0ZW1fMjc4MzQvZ3Ax',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -13.2,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.762484},
                                                                                                                                  {       'connected_time': '3777723',
                                                                                                                                          'fiber_length': 1938,
                                                                                                                                          'poller_hash': 'REY1MTdCcGVlcnBvbnNvbmFyX2l0ZW1fMjc4MzUvZ3Ax',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -13.2,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.762484},
                                                                                                                                  {       'connected_time': '1350956',
                                                                                                                                          'fiber_length': 2040,
                                                                                                                                          'poller_hash': 'REY1MDJCcGVlcnBvbnNvbmFyX2l0ZW1fMjc4NjYvZ3Ax',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -10.6,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.762484},
                                                                                                                                  {       'connected_time': '1142729',
                                                                                                                                          'fiber_length': 2142,
                                                                                                                                          'poller_hash': 'MTA1OThFMHBlZXJwb25zb25hcl9pdGVtXzUwMjU0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.762484},
                                                                                                                                  {       'connected_time': '3777724',
                                                                                                                                          'fiber_length': 2040,
                                                                                                                                          'poller_hash': 'MTIwNzcwMHBlZXJwb25zb25hcl9pdGVtXzUwODYyL2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -11.5,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.762484},
                                                                                                                                  {       'connected_time': '521441',
                                                                                                                                          'fiber_length': 2142,
                                                                                                                                          'poller_hash': 'MTJBNTFDN3BlZXJwb25zb25hcl9pdGVtXzUxNzE4L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -10.8,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.762484},
                                                                                                                                  {       'connected_time': '3777754',
                                                                                                                                          'fiber_length': 1836,
                                                                                                                                          'poller_hash': 'MTJBNTVDOXBlZXJwb25zb25hcl9pdGVtXzUxNzI2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -23.2,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.762484},
                                                                                                                                  {       'connected_time': '1632522',
                                                                                                                                          'fiber_length': 1938,
                                                                                                                                          'poller_hash': 'MTJBNTU4MXBlZXJwb25zb25hcl9pdGVtXzUyMDM0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -10.8,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.762484},
                                                                                                                                  {       'connected_time': '913676',
                                                                                                                                          'fiber_length': 1836,
                                                                                                                                          'poller_hash': 'MTIwNzY1Q3BlZXJwb25zb25hcl9pdGVtXzUyMTA3L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -10.5,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.762484},
                                                                                                                                  {       'connected_time': '3777723',
                                                                                                                                          'fiber_length': 1836,
                                                                                                                                          'poller_hash': 'MTIwNzY1N3BlZXJwb25zb25hcl9pdGVtXzUyMTA5L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -11.8,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.762484}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -5.0,
                                                                                                                 'minimum_loss': -26.0,
                                                                                                                 'name': '1/1/xp2',
                                                                                                                 'poller_hash': 'MDRiYzlmZjM3MGViMTEwMDEwMTA2',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010107',
                                                                                         'mac_address': '04:bc:9f:f3:70:ec',
                                                                                         'name': '1/1/xp3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWMxLzEveHAz'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010108',
                                                                                         'in_discards': '3',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '529521',
                                                                                         'in_octets': '404361145925',
                                                                                         'in_ucast_pkts': '1845096936',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '163',
                                                                                                                  'in_octets': '17768416020',
                                                                                                                  'in_ucast_pkts': '138618024',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937961',
                                                                                                                  'out_octets': '622528064726',
                                                                                                                  'out_ucast_pkts': '429851873',
                                                                                                                  'poller_hash': 'MTA1OThBRnBlZXJpbnRmc29uYXJfaXRlbV81MDI1Mi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '93972',
                                                                                                                  'in_octets': '26095588336',
                                                                                                                  'in_ucast_pkts': '79352722',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937757',
                                                                                                                  'out_octets': '285320351830',
                                                                                                                  'out_ucast_pkts': '233434349',
                                                                                                                  'poller_hash': 'MTA1OThDM3BlZXJpbnRmc29uYXJfaXRlbV81MDI1Ny9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '47',
                                                                                                                  'in_octets': '719869270',
                                                                                                                  'in_ucast_pkts': '3850100',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '19',
                                                                                                                  'out_octets': '18555282218',
                                                                                                                  'out_ucast_pkts': '13256753',
                                                                                                                  'poller_hash': 'MTEzQ0M1RnBlZXJpbnRmc29uYXJfaXRlbV81MDM2MS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '50384',
                                                                                                                  'in_octets': '9354786912',
                                                                                                                  'in_ucast_pkts': '36005134',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937968',
                                                                                                                  'out_octets': '486417180471',
                                                                                                                  'out_ucast_pkts': '340105387',
                                                                                                                  'poller_hash': 'MTIwNzc2M3BlZXJpbnRmc29uYXJfaXRlbV81MDg2MS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '84359',
                                                                                                                  'in_octets': '46094542390',
                                                                                                                  'in_ucast_pkts': '219714116',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937977',
                                                                                                                  'out_octets': '1549687858475',
                                                                                                                  'out_ucast_pkts': '1090678006',
                                                                                                                  'poller_hash': 'MTJBNTUyMXBlZXJpbnRmc29uYXJfaXRlbV81MTcwNy9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '90994',
                                                                                                                  'in_octets': '7815743209',
                                                                                                                  'in_ucast_pkts': '29394053',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937978',
                                                                                                                  'out_octets': '136941788403',
                                                                                                                  'out_ucast_pkts': '110574621',
                                                                                                                  'poller_hash': 'MTJBNTYxMnBlZXJpbnRmc29uYXJfaXRlbV81MTcxOS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '43379',
                                                                                                                  'in_octets': '13908408687',
                                                                                                                  'in_ucast_pkts': '57212244',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937783',
                                                                                                                  'out_octets': '251886780371',
                                                                                                                  'out_ucast_pkts': '184511695',
                                                                                                                  'poller_hash': 'MTIwNzY1RHBlZXJpbnRmc29uYXJfaXRlbV81MjExNC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '61629',
                                                                                                                  'in_octets': '21142247277',
                                                                                                                  'in_ucast_pkts': '210188804',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '937770',
                                                                                                                  'out_octets': '1274640035819',
                                                                                                                  'out_ucast_pkts': '866816984',
                                                                                                                  'poller_hash': 'MTIwNzY2NXBlZXJpbnRmc29uYXJfaXRlbV81MjEzMS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '22344',
                                                                                                                  'in_octets': '35499014971',
                                                                                                                  'in_ucast_pkts': '120055235',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '64488',
                                                                                                                  'out_octets': '778695090139',
                                                                                                                  'out_ucast_pkts': '545207563',
                                                                                                                  'poller_hash': 'MTEzQ0IzMXBlZXJpbnRmc29uYXJfaXRlbV82OTc0NC9ncDE='}],
                                                                                         'mac_address': '04:bc:9f:f3:70:ed',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05642',
                                                                                         'name': '1/1/xp4',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '8441582',
                                                                                         'out_octets': '9241365987192',
                                                                                         'out_ucast_pkts': '6621627505',
                                                                                         'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWQxLzEveHA0',
                                                                                         'pons': [       {       'description': '1/1/xp4',
                                                                                                                 'id': '110010108',
                                                                                                                 'links': [       {       'connected_time': '3777719',
                                                                                                                                          'fiber_length': 1326,
                                                                                                                                          'poller_hash': 'MTA1OThBRnBlZXJwb25zb25hcl9pdGVtXzUwMjUyL2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.763214},
                                                                                                                                  {       'connected_time': '1974306',
                                                                                                                                          'fiber_length': 1224,
                                                                                                                                          'poller_hash': 'MTA1OThDM3BlZXJwb25zb25hcl9pdGVtXzUwMjU3L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.763214},
                                                                                                                                  {       'connected_time': '54892',
                                                                                                                                          'fiber_length': 1224,
                                                                                                                                          'poller_hash': 'MTEzQ0M1RnBlZXJwb25zb25hcl9pdGVtXzUwMzYxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.763214},
                                                                                                                                  {       'connected_time': '3777708',
                                                                                                                                          'fiber_length': 1224,
                                                                                                                                          'poller_hash': 'MTIwNzc2M3BlZXJwb25zb25hcl9pdGVtXzUwODYxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -13.5,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.763214},
                                                                                                                                  {       'connected_time': '3777535',
                                                                                                                                          'fiber_length': 1326,
                                                                                                                                          'poller_hash': 'MTJBNTUyMXBlZXJwb25zb25hcl9pdGVtXzUxNzA3L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.763214},
                                                                                                                                  {       'connected_time': '3777730',
                                                                                                                                          'fiber_length': 1326,
                                                                                                                                          'poller_hash': 'MTJBNTYxMnBlZXJwb25zb25hcl9pdGVtXzUxNzE5L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.763214},
                                                                                                                                  {       'connected_time': '2735879',
                                                                                                                                          'fiber_length': 1224,
                                                                                                                                          'poller_hash': 'MTIwNzY1RHBlZXJwb25zb25hcl9pdGVtXzUyMTE0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.763214},
                                                                                                                                  {       'connected_time': '2339919',
                                                                                                                                          'fiber_length': 1224,
                                                                                                                                          'poller_hash': 'MTIwNzY2NXBlZXJwb25zb25hcl9pdGVtXzUyMTMxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.763214},
                                                                                                                                  {       'connected_time': '909491',
                                                                                                                                          'fiber_length': 1224,
                                                                                                                                          'poller_hash': 'MTEzQ0IzMXBlZXJwb25zb25hcl9pdGVtXzY5NzQ0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 3.763214}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -5.0,
                                                                                                                 'minimum_loss': -26.0,
                                                                                                                 'name': '1/1/xp4',
                                                                                                                 'poller_hash': 'MDRiYzlmZjM3MGVkMTEwMDEwMTA4',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'}]},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110010109',
                                                                                         'mac_address': '04:bc:9f:f3:70:ee',
                                                                                         'name': '1/1/xp5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWUxLzEveHA1'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110010110',
                                                                                         'mac_address': '04:bc:9f:f3:70:ef',
                                                                                         'name': '1/1/xp6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWYxLzEveHA2'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110010111',
                                                                                         'mac_address': '04:bc:9f:f3:70:f0',
                                                                                         'name': '1/1/xp7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZjAxLzEveHA3'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110010112',
                                                                                         'mac_address': '04:bc:9f:f3:70:f1',
                                                                                         'name': '1/1/xp8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZjExLzEveHA4'}],
                                                           'manufacturer': 'Calix',
                                                           'mem': 56.0,
                                                           'model': 'XG801',
                                                           'name': '1/1',
                                                           'poller_hash': 'NDcyMzAyMDE0MDc1',
                                                           'serial_number': '472302014075',
                                                           'sw_version': '24.1.1',
                                                           'temperature': 44.5,
                                                           'uptime': '3777660'}],
                                'serial_number': '472212071774',
                                'sw_version': '24.1.1',
                                'system_mac_address': '84:d3:43:d2:71:58'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:8b:76:6b:a0:12'],
                                                                       'id': '1000577',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '80373',
                                                                       'in_octets': '52253330373',
                                                                       'in_ucast_pkts': '232994457',
                                                                       'mac_address': 'f8:85:f9:13:df:eb',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_27783/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937962',
                                                                       'out_octets': '1129712484779',
                                                                       'out_ucast_pkts': '805809908',
                                                                       'poller_hash': 'REY1MEFGcGVlcmludGZzb25hcl9pdGVtXzI3NzgzL2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_27783',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937962',
                                                                       'in_octets': '1129712484779',
                                                                       'in_ucast_pkts': '805809908',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937962',
                                                                                                'in_octets': '1129712484779',
                                                                                                'in_ucast_pkts': '805809908',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '80373',
                                                                                                'out_octets': '52253330373',
                                                                                                'out_ucast_pkts': '232994457',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWIxLzEveHAy'}],
                                                                       'name': 'sonar_item_27783/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '80373',
                                                                       'out_octets': '52253330373',
                                                                       'out_ucast_pkts': '232994457',
                                                                       'poller_hash': 'REY1MEFGcGVlcmludGZzb25hcl9pdGVtXzI3NzgzL2dwMQ==',
                                                                       'pons': [       {       'description': 'sonar_item_27783/gp1',
                                                                                               'id': 'sonar_item_27783',
                                                                                               'links': [       {       'connected_time': '3777719',
                                                                                                                        'fiber_length': 1938,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGViMTEwMDEwMTA2',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -14.596,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.346}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_27783/gp1',
                                                                                               'poller_hash': 'REY1MEFGcGVlcnBvbnNvbmFyX2l0ZW1fMjc3ODMvZ3Ax',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_27783',
                                         'poller_hash': 'REY1MEFG',
                                         'serial_number': 'DF50AF',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'f8:85:f9:13:df:eb',
                                         'uptime': '3777719'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '2c:3f:0b:b7:2f:06'],
                                                                       'id': '1000929',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '238254',
                                                                       'in_octets': '324897792360',
                                                                       'in_ucast_pkts': '624442246',
                                                                       'mac_address': 'f8:85:f9:13:dd:43',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_27807/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937935',
                                                                       'out_octets': '1386221087538',
                                                                       'out_ucast_pkts': '1288508087',
                                                                       'poller_hash': 'REY1MDI3cGVlcmludGZzb25hcl9pdGVtXzI3ODA3L2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_27807',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937935',
                                                                       'in_octets': '1386221087538',
                                                                       'in_ucast_pkts': '1288508087',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937935',
                                                                                                'in_octets': '1386221087538',
                                                                                                'in_ucast_pkts': '1288508087',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '238254',
                                                                                                'out_octets': '324897792360',
                                                                                                'out_ucast_pkts': '624442246',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx'}],
                                                                       'name': 'sonar_item_27807/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '238254',
                                                                       'out_octets': '324897792360',
                                                                       'out_ucast_pkts': '624442246',
                                                                       'poller_hash': 'REY1MDI3cGVlcmludGZzb25hcl9pdGVtXzI3ODA3L2dwMQ==',
                                                                       'pons': [       {       'description': 'sonar_item_27807/gp1',
                                                                                               'id': 'sonar_item_27807',
                                                                                               'links': [       {       'connected_time': '3702031',
                                                                                                                        'fiber_length': 2244,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -12.88,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.564}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_27807/gp1',
                                                                                               'poller_hash': 'REY1MDI3cGVlcnBvbnNvbmFyX2l0ZW1fMjc4MDcvZ3Ax',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_27807',
                                         'poller_hash': 'REY1MDI3',
                                         'serial_number': 'DF5027',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'f8:85:f9:13:dd:43',
                                         'uptime': '3702031'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'dc:62:79:21:b5:39'],
                                                                       'id': '1001633',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1868',
                                                                       'in_octets': '143191632466',
                                                                       'in_ucast_pkts': '281721356',
                                                                       'mac_address': 'f8:85:f9:13:e4:4b',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_27823/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937768',
                                                                       'out_octets': '884544687656',
                                                                       'out_ucast_pkts': '681464544',
                                                                       'poller_hash': 'REY1MThGcGVlcmludGZzb25hcl9pdGVtXzI3ODIzL2cx',
                                                                       'speed': '2500000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_27823',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937768',
                                                                       'in_octets': '884544687656',
                                                                       'in_ucast_pkts': '681464544',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937768',
                                                                                                'in_octets': '884544687656',
                                                                                                'in_ucast_pkts': '681464544',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '1868',
                                                                                                'out_octets': '143191632466',
                                                                                                'out_ucast_pkts': '281721356',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWIxLzEveHAy'}],
                                                                       'name': 'sonar_item_27823/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1868',
                                                                       'out_octets': '143191632466',
                                                                       'out_ucast_pkts': '281721356',
                                                                       'poller_hash': 'REY1MThGcGVlcmludGZzb25hcl9pdGVtXzI3ODIzL2dwMQ==',
                                                                       'pons': [       {       'description': 'sonar_item_27823/gp1',
                                                                                               'id': 'sonar_item_27823',
                                                                                               'links': [       {       'connected_time': '2380243',
                                                                                                                        'fiber_length': 2040,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGViMTEwMDEwMTA2',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -14.122,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.66}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_27823/gp1',
                                                                                               'poller_hash': 'REY1MThGcGVlcnBvbnNvbmFyX2l0ZW1fMjc4MjMvZ3Ax',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_27823',
                                         'poller_hash': 'REY1MThG',
                                         'serial_number': 'DF518F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'f8:85:f9:13:e4:4b',
                                         'uptime': '2380243'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:cd:d6:11:a8:9f'],
                                                                       'id': '1000321',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '404',
                                                                       'in_octets': '105973409543',
                                                                       'in_ucast_pkts': '307272299',
                                                                       'mac_address': 'f8:85:f9:13:e3:c4',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_27834/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937971',
                                                                       'out_octets': '1276897082623',
                                                                       'out_ucast_pkts': '903213014',
                                                                       'poller_hash': 'REY1MTc0cGVlcmludGZzb25hcl9pdGVtXzI3ODM0L2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_27834',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937971',
                                                                       'in_octets': '1276897082623',
                                                                       'in_ucast_pkts': '903213014',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937971',
                                                                                                'in_octets': '1276897082623',
                                                                                                'in_ucast_pkts': '903213014',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '404',
                                                                                                'out_octets': '105973409543',
                                                                                                'out_ucast_pkts': '307272299',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWIxLzEveHAy'}],
                                                                       'name': 'sonar_item_27834/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '404',
                                                                       'out_octets': '105973409543',
                                                                       'out_ucast_pkts': '307272299',
                                                                       'poller_hash': 'REY1MTc0cGVlcmludGZzb25hcl9pdGVtXzI3ODM0L2dwMQ==',
                                                                       'pons': [       {       'description': 'sonar_item_27834/gp1',
                                                                                               'id': 'sonar_item_27834',
                                                                                               'links': [       {       'connected_time': '3777699',
                                                                                                                        'fiber_length': 1938,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGViMTEwMDEwMTA2',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -13.946,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.366}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_27834/gp1',
                                                                                               'poller_hash': 'REY1MTc0cGVlcnBvbnNvbmFyX2l0ZW1fMjc4MzQvZ3Ax',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_27834',
                                         'poller_hash': 'REY1MTc0',
                                         'serial_number': 'DF5174',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'f8:85:f9:13:e3:c4',
                                         'uptime': '3777699'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f8:85:f9:0d:d8:94'],
                                                                       'id': '1000289',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '100595',
                                                                       'in_octets': '85849855240',
                                                                       'in_ucast_pkts': '425559540',
                                                                       'mac_address': 'f8:85:f9:13:e3:e7',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_27835/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937962',
                                                                       'out_octets': '2632939228385',
                                                                       'out_ucast_pkts': '1915355668',
                                                                       'poller_hash': 'REY1MTdCcGVlcmludGZzb25hcl9pdGVtXzI3ODM1L2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_27835',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937962',
                                                                       'in_octets': '2632939228385',
                                                                       'in_ucast_pkts': '1915355668',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937962',
                                                                                                'in_octets': '2632939228385',
                                                                                                'in_ucast_pkts': '1915355668',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '100595',
                                                                                                'out_octets': '85849855240',
                                                                                                'out_ucast_pkts': '425559540',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWIxLzEveHAy'}],
                                                                       'name': 'sonar_item_27835/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '100595',
                                                                       'out_octets': '85849855240',
                                                                       'out_ucast_pkts': '425559540',
                                                                       'poller_hash': 'REY1MTdCcGVlcmludGZzb25hcl9pdGVtXzI3ODM1L2dwMQ==',
                                                                       'pons': [       {       'description': 'sonar_item_27835/gp1',
                                                                                               'id': 'sonar_item_27835',
                                                                                               'links': [       {       'connected_time': '3777723',
                                                                                                                        'fiber_length': 1938,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGViMTEwMDEwMTA2',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -14.748,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.508}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_27835/gp1',
                                                                                               'poller_hash': 'REY1MTdCcGVlcnBvbnNvbmFyX2l0ZW1fMjc4MzUvZ3Ax',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_27835',
                                         'poller_hash': 'REY1MTdC',
                                         'serial_number': 'DF517B',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'f8:85:f9:13:e3:e7',
                                         'uptime': '3777723'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:1b:bc:2c:78:d0'],
                                                                       'id': '1000417',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '525534',
                                                                       'in_octets': '517700943651',
                                                                       'in_ucast_pkts': '1507591541',
                                                                       'mac_address': 'f8:85:f9:13:dd:98',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_27858/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '938175',
                                                                       'out_octets': '589629142716',
                                                                       'out_ucast_pkts': '1512348580',
                                                                       'poller_hash': 'REY1MDM4cGVlcmludGZzb25hcl9pdGVtXzI3ODU4L2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_27858',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '938175',
                                                                       'in_octets': '589629142716',
                                                                       'in_ucast_pkts': '1512348580',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '938175',
                                                                                                'in_octets': '589629142716',
                                                                                                'in_ucast_pkts': '1512348580',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '525534',
                                                                                                'out_octets': '517700943651',
                                                                                                'out_ucast_pkts': '1507591541',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx'}],
                                                                       'name': 'sonar_item_27858/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '525534',
                                                                       'out_octets': '517700943651',
                                                                       'out_ucast_pkts': '1507591541',
                                                                       'poller_hash': 'REY1MDM4cGVlcmludGZzb25hcl9pdGVtXzI3ODU4L2dwMQ==',
                                                                       'pons': [       {       'description': 'sonar_item_27858/gp1',
                                                                                               'id': 'sonar_item_27858',
                                                                                               'links': [       {       'connected_time': '5256061',
                                                                                                                        'fiber_length': 2244,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -13.26,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.35}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_27858/gp1',
                                                                                               'poller_hash': 'REY1MDM4cGVlcnBvbnNvbmFyX2l0ZW1fMjc4NTgvZ3Ax',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_27858',
                                         'poller_hash': 'REY1MDM4',
                                         'serial_number': 'DF5038',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'f8:85:f9:13:dd:98',
                                         'uptime': '5256061'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '04:bc:9f:5e:8d:fd'],
                                                                       'id': '1000353',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '44865',
                                                                       'in_octets': '24355520804',
                                                                       'in_ucast_pkts': '40499412',
                                                                       'mac_address': 'f8:85:f9:13:dd:57',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_27866/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '851736',
                                                                       'out_octets': '65852357204',
                                                                       'out_ucast_pkts': '65654538',
                                                                       'poller_hash': 'REY1MDJCcGVlcmludGZzb25hcl9pdGVtXzI3ODY2L2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_27866',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '851736',
                                                                       'in_octets': '65852357204',
                                                                       'in_ucast_pkts': '65654538',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '851736',
                                                                                                'in_octets': '65852357204',
                                                                                                'in_ucast_pkts': '65654538',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '44865',
                                                                                                'out_octets': '24355520804',
                                                                                                'out_ucast_pkts': '40499412',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWIxLzEveHAy'}],
                                                                       'name': 'sonar_item_27866/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '44865',
                                                                       'out_octets': '24355520804',
                                                                       'out_ucast_pkts': '40499412',
                                                                       'poller_hash': 'REY1MDJCcGVlcmludGZzb25hcl9pdGVtXzI3ODY2L2dwMQ==',
                                                                       'pons': [       {       'description': 'sonar_item_27866/gp1',
                                                                                               'id': 'sonar_item_27866',
                                                                                               'links': [       {       'connected_time': '1350956',
                                                                                                                        'fiber_length': 2040,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGViMTEwMDEwMTA2',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -13.85,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.59}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_27866/gp1',
                                                                                               'poller_hash': 'REY1MDJCcGVlcnBvbnNvbmFyX2l0ZW1fMjc4NjYvZ3Ax',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_27866',
                                         'poller_hash': 'REY1MDJC',
                                         'serial_number': 'DF502B',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'f8:85:f9:13:dd:57',
                                         'uptime': '1350956'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '18:c2:41:13:0d:f1'],
                                                                       'id': '1000161',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7379',
                                                                       'in_octets': '51885604179',
                                                                       'in_ucast_pkts': '171130484',
                                                                       'mac_address': 'b8:94:70:51:0d:9d',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_29553/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937929',
                                                                       'out_octets': '343746285714',
                                                                       'out_ucast_pkts': '334004349',
                                                                       'poller_hash': 'MTEwNDg0OXBlZXJpbnRmc29uYXJfaXRlbV8yOTU1My9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_29553',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937929',
                                                                       'in_octets': '343746285714',
                                                                       'in_ucast_pkts': '334004349',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937929',
                                                                                                'in_octets': '343746285714',
                                                                                                'in_ucast_pkts': '334004349',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '7379',
                                                                                                'out_octets': '51885604179',
                                                                                                'out_ucast_pkts': '171130484',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx'}],
                                                                       'name': 'sonar_item_29553/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7379',
                                                                       'out_octets': '51885604179',
                                                                       'out_ucast_pkts': '171130484',
                                                                       'poller_hash': 'MTEwNDg0OXBlZXJpbnRmc29uYXJfaXRlbV8yOTU1My9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_29553/gp1',
                                                                                               'id': 'sonar_item_29553',
                                                                                               'links': [       {       'connected_time': '3627819',
                                                                                                                        'fiber_length': 1428,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -12.152,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.412}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_29553/gp1',
                                                                                               'poller_hash': 'MTEwNDg0OXBlZXJwb25zb25hcl9pdGVtXzI5NTUzL2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_29553',
                                         'poller_hash': 'MTEwNDg0OQ==',
                                         'serial_number': '1104849',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'b8:94:70:51:0d:9d',
                                         'uptime': '3627819'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000193',
                                                                       'name': 'sonar_item_29555/g1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MTEwNDE5RXBlZXJpbnRmc29uYXJfaXRlbV8yOTU1NS9nMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_29555',
                                                                       'name': 'sonar_item_29555/gp1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MTEwNDE5RXBlZXJpbnRmc29uYXJfaXRlbV8yOTU1NS9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_29555/gp1',
                                                                                               'id': 'sonar_item_29555',
                                                                                               'max_distance': 20000,
                                                                                               'name': 'sonar_item_29555/gp1',
                                                                                               'poller_hash': 'MTEwNDE5RXBlZXJwb25zb25hcl9pdGVtXzI5NTU1L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'name': 'ont sonar_item_29555',
                                         'offline_reason': 'OFFLINE_REASON_LOSS_OF_SIGNAL',
                                         'offline_reason_detail': 'PON ont-missing '
                                                                  "/config/system/ont[ont-id='sonar_item_29555']",
                                         'offline_time': '2025-06-25T22:10:26Z',
                                         'poller_hash': 'MTEwNDE5RQ==',
                                         'serial_number': '110419E',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '04:bc:9f:83:a9:82'],
                                                                       'id': '1000225',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '54539',
                                                                       'in_octets': '22157402013',
                                                                       'in_ucast_pkts': '47221133',
                                                                       'mac_address': 'b8:94:70:50:ee:99',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_29557/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937960',
                                                                       'out_octets': '179210528290',
                                                                       'out_ucast_pkts': '145545335',
                                                                       'poller_hash': 'MTEwNDIxNXBlZXJpbnRmc29uYXJfaXRlbV8yOTU1Ny9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_29557',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937960',
                                                                       'in_octets': '179210528290',
                                                                       'in_ucast_pkts': '145545335',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937960',
                                                                                                'in_octets': '179210528290',
                                                                                                'in_ucast_pkts': '145545335',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '54539',
                                                                                                'out_octets': '22157402013',
                                                                                                'out_ucast_pkts': '47221133',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx'}],
                                                                       'name': 'sonar_item_29557/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '54539',
                                                                       'out_octets': '22157402013',
                                                                       'out_ucast_pkts': '47221133',
                                                                       'poller_hash': 'MTEwNDIxNXBlZXJpbnRmc29uYXJfaXRlbV8yOTU1Ny9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_29557/gp1',
                                                                                               'id': 'sonar_item_29557',
                                                                                               'links': [       {       'connected_time': '3777714',
                                                                                                                        'fiber_length': 918,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -12.246,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.342}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_29557/gp1',
                                                                                               'poller_hash': 'MTEwNDIxNXBlZXJwb25zb25hcl9pdGVtXzI5NTU3L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_29557',
                                         'poller_hash': 'MTEwNDIxNQ==',
                                         'serial_number': '1104215',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'b8:94:70:50:ee:99',
                                         'uptime': '3777714'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:11:0a:5d:f4:3a'],
                                                                       'id': '1001217',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3216',
                                                                       'in_octets': '27385989106',
                                                                       'in_ucast_pkts': '96735024',
                                                                       'mac_address': 'b8:94:70:50:ee:71',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_29594/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937747',
                                                                       'out_octets': '174155474529',
                                                                       'out_ucast_pkts': '162683854',
                                                                       'poller_hash': 'MTEwNDIwRHBlZXJpbnRmc29uYXJfaXRlbV8yOTU5NC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_29594',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937747',
                                                                       'in_octets': '174155474529',
                                                                       'in_ucast_pkts': '162683854',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937747',
                                                                                                'in_octets': '174155474529',
                                                                                                'in_ucast_pkts': '162683854',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '3216',
                                                                                                'out_octets': '27385989106',
                                                                                                'out_ucast_pkts': '96735024',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx'}],
                                                                       'name': 'sonar_item_29594/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3216',
                                                                       'out_octets': '27385989106',
                                                                       'out_ucast_pkts': '96735024',
                                                                       'poller_hash': 'MTEwNDIwRHBlZXJpbnRmc29uYXJfaXRlbV8yOTU5NC9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_29594/gp1',
                                                                                               'id': 'sonar_item_29594',
                                                                                               'links': [       {       'connected_time': '3777721',
                                                                                                                        'fiber_length': 1530,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -16.516,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.838}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_29594/gp1',
                                                                                               'poller_hash': 'MTEwNDIwRHBlZXJwb25zb25hcl9pdGVtXzI5NTk0L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_29594',
                                         'poller_hash': 'MTEwNDIwRA==',
                                         'serial_number': '110420D',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'b8:94:70:50:ee:71',
                                         'uptime': '3777721'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:90:0b:a2:ab:a1'],
                                                                       'id': '1000065',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3214',
                                                                       'in_octets': '1369667312446',
                                                                       'in_ucast_pkts': '1944638404',
                                                                       'mac_address': 'b8:94:70:51:0f:50',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_29605/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937970',
                                                                       'out_octets': '1269957409602',
                                                                       'out_ucast_pkts': '1468560442',
                                                                       'poller_hash': 'MTEwNDhBMHBlZXJpbnRmc29uYXJfaXRlbV8yOTYwNS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_29605',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937970',
                                                                       'in_octets': '1269957409602',
                                                                       'in_ucast_pkts': '1468560442',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937970',
                                                                                                'in_octets': '1269957409602',
                                                                                                'in_ucast_pkts': '1468560442',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '3214',
                                                                                                'out_octets': '1369667312446',
                                                                                                'out_ucast_pkts': '1944638404',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx'}],
                                                                       'name': 'sonar_item_29605/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3214',
                                                                       'out_octets': '1369667312446',
                                                                       'out_ucast_pkts': '1944638404',
                                                                       'poller_hash': 'MTEwNDhBMHBlZXJpbnRmc29uYXJfaXRlbV8yOTYwNS9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_29605/gp1',
                                                                                               'id': 'sonar_item_29605',
                                                                                               'links': [       {       'connected_time': '3777713',
                                                                                                                        'fiber_length': 2244,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -14.088,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.612}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_29605/gp1',
                                                                                               'poller_hash': 'MTEwNDhBMHBlZXJwb25zb25hcl9pdGVtXzI5NjA1L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_29605',
                                         'poller_hash': 'MTEwNDhBMA==',
                                         'serial_number': '11048A0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'b8:94:70:51:0f:50',
                                         'uptime': '3777713'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '34:98:b5:5c:b4:dc'],
                                                                       'id': '1000033',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '36',
                                                                       'in_octets': '10507397700',
                                                                       'in_ucast_pkts': '15226238',
                                                                       'mac_address': 'b8:94:70:50:ef:e3',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_29606/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '15',
                                                                       'out_octets': '13903064752',
                                                                       'out_ucast_pkts': '17501133',
                                                                       'poller_hash': 'MTEwNDI1N3BlZXJpbnRmc29uYXJfaXRlbV8yOTYwNi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_29606',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '15',
                                                                       'in_octets': '13903064752',
                                                                       'in_ucast_pkts': '17501133',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '15',
                                                                                                'in_octets': '13903064752',
                                                                                                'in_ucast_pkts': '17501133',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '36',
                                                                                                'out_octets': '10507397700',
                                                                                                'out_ucast_pkts': '15226238',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx'}],
                                                                       'name': 'sonar_item_29606/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '36',
                                                                       'out_octets': '10507397700',
                                                                       'out_ucast_pkts': '15226238',
                                                                       'poller_hash': 'MTEwNDI1N3BlZXJpbnRmc29uYXJfaXRlbV8yOTYwNi9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_29606/gp1',
                                                                                               'id': 'sonar_item_29606',
                                                                                               'links': [       {       'connected_time': '227381',
                                                                                                                        'fiber_length': 2244,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -13.26,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.398}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_29606/gp1',
                                                                                               'poller_hash': 'MTEwNDI1N3BlZXJwb25zb25hcl9pdGVtXzI5NjA2L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_29606',
                                         'poller_hash': 'MTEwNDI1Nw==',
                                         'serial_number': '1104257',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'b8:94:70:50:ef:e3',
                                         'uptime': '227381'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000129',
                                                                       'name': 'sonar_item_29607/g1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MTEwNDhFMHBlZXJpbnRmc29uYXJfaXRlbV8yOTYwNy9nMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_29607',
                                                                       'name': 'sonar_item_29607/gp1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MTEwNDhFMHBlZXJpbnRmc29uYXJfaXRlbV8yOTYwNy9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_29607/gp1',
                                                                                               'id': 'sonar_item_29607',
                                                                                               'max_distance': 20000,
                                                                                               'name': 'sonar_item_29607/gp1',
                                                                                               'poller_hash': 'MTEwNDhFMHBlZXJwb25zb25hcl9pdGVtXzI5NjA3L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'name': 'ont sonar_item_29607',
                                         'offline_reason': 'OFFLINE_REASON_LOSS_OF_SIGNAL',
                                         'offline_reason_detail': 'PON ont-missing '
                                                                  "/config/system/ont[ont-id='sonar_item_29607']",
                                         'offline_time': '2025-06-25T22:10:26Z',
                                         'poller_hash': 'MTEwNDhFMA==',
                                         'serial_number': '11048E0',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '14:21:03:46:04:44'],
                                                                       'id': '1001121',
                                                                       'in_errors': '1',
                                                                       'in_nucast_pkts': '49582',
                                                                       'in_octets': '66865514446',
                                                                       'in_ucast_pkts': '440083847',
                                                                       'mac_address': 'b8:94:70:51:10:bd',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_29617/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937961',
                                                                       'out_octets': '2532060111589',
                                                                       'out_ucast_pkts': '1762490657',
                                                                       'poller_hash': 'MTEwNDhFOXBlZXJpbnRmc29uYXJfaXRlbV8yOTYxNy9nMQ==',
                                                                       'speed': '2500000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_29617',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937961',
                                                                       'in_octets': '2532060111589',
                                                                       'in_ucast_pkts': '1762490657',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937961',
                                                                                                'in_octets': '2532060111589',
                                                                                                'in_ucast_pkts': '1762490657',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '1',
                                                                                                'out_nucast_pkts': '49582',
                                                                                                'out_octets': '66865514446',
                                                                                                'out_ucast_pkts': '440083847',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx'}],
                                                                       'name': 'sonar_item_29617/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '1',
                                                                       'out_nucast_pkts': '49582',
                                                                       'out_octets': '66865514446',
                                                                       'out_ucast_pkts': '440083847',
                                                                       'poller_hash': 'MTEwNDhFOXBlZXJpbnRmc29uYXJfaXRlbV8yOTYxNy9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_29617/gp1',
                                                                                               'id': 'sonar_item_29617',
                                                                                               'links': [       {       'connected_time': '3777721',
                                                                                                                        'fiber_length': 1122,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -12.644,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.504}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_29617/gp1',
                                                                                               'poller_hash': 'MTEwNDhFOXBlZXJwb25zb25hcl9pdGVtXzI5NjE3L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_29617',
                                         'poller_hash': 'MTEwNDhFOQ==',
                                         'serial_number': '11048E9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'b8:94:70:51:10:bd',
                                         'uptime': '3777721'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000001',
                                                                       'name': 'sonar_item_29640/g1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MTEwMjZGRnBlZXJpbnRmc29uYXJfaXRlbV8yOTY0MC9nMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_29640',
                                                                       'name': 'sonar_item_29640/gp1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MTEwMjZGRnBlZXJpbnRmc29uYXJfaXRlbV8yOTY0MC9ncDE='}],
                                         'manufacturer': 'Calix',
                                         'name': 'ont sonar_item_29640',
                                         'offline_reason': 'OFFLINE_REASON_LOSS_OF_SIGNAL',
                                         'offline_reason_detail': 'OLT PON port '
                                                                  '1/1/xp3 is down',
                                         'offline_time': '2024-02-10T02:23:40Z',
                                         'poller_hash': 'MTEwMjZGRg==',
                                         'serial_number': '11026FF',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '18:fd:74:0d:60:63'],
                                                                       'id': '1000961',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '64826',
                                                                       'in_octets': '23097933507',
                                                                       'in_ucast_pkts': '82226816',
                                                                       'mac_address': 'b8:94:70:ef:8b:ae',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_36734/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '851727',
                                                                       'out_octets': '20158356744',
                                                                       'out_ucast_pkts': '63087247',
                                                                       'poller_hash': 'MTFGRUFGQnBlZXJpbnRmc29uYXJfaXRlbV8zNjczNC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_36734',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '851727',
                                                                       'in_octets': '20158356744',
                                                                       'in_ucast_pkts': '63087247',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '851727',
                                                                                                'in_octets': '20158356744',
                                                                                                'in_ucast_pkts': '63087247',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '64826',
                                                                                                'out_octets': '23097933507',
                                                                                                'out_ucast_pkts': '82226816',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx'}],
                                                                       'name': 'sonar_item_36734/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '64826',
                                                                       'out_octets': '23097933507',
                                                                       'out_ucast_pkts': '82226816',
                                                                       'poller_hash': 'MTFGRUFGQnBlZXJpbnRmc29uYXJfaXRlbV8zNjczNC9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_36734/gp1',
                                                                                               'id': 'sonar_item_36734',
                                                                                               'links': [       {       'connected_time': '1296326',
                                                                                                                        'fiber_length': 2244,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -23.564,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.544}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_36734/gp1',
                                                                                               'poller_hash': 'MTFGRUFGQnBlZXJwb25zb25hcl9pdGVtXzM2NzM0L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_36734',
                                         'poller_hash': 'MTFGRUFGQg==',
                                         'serial_number': '11FEAFB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'b8:94:70:ef:8b:ae',
                                         'uptime': '1296326'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '9c:05:d6:36:a4:84'],
                                                                       'id': '1000481',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '24',
                                                                       'in_octets': '76103709115',
                                                                       'in_ucast_pkts': '238040611',
                                                                       'mac_address': 'b8:94:70:ef:90:cc',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_36743/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937954',
                                                                       'out_octets': '347134263468',
                                                                       'out_ucast_pkts': '326429086',
                                                                       'poller_hash': 'MTFGRUMwMXBlZXJpbnRmc29uYXJfaXRlbV8zNjc0My9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_36743',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937954',
                                                                       'in_octets': '347134263468',
                                                                       'in_ucast_pkts': '326429086',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937954',
                                                                                                'in_octets': '347134263468',
                                                                                                'in_ucast_pkts': '326429086',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '24',
                                                                                                'out_octets': '76103709115',
                                                                                                'out_ucast_pkts': '238040611',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx'}],
                                                                       'name': 'sonar_item_36743/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '24',
                                                                       'out_octets': '76103709115',
                                                                       'out_ucast_pkts': '238040611',
                                                                       'poller_hash': 'MTFGRUMwMXBlZXJpbnRmc29uYXJfaXRlbV8zNjc0My9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_36743/gp1',
                                                                                               'id': 'sonar_item_36743',
                                                                                               'links': [       {       'connected_time': '3776096',
                                                                                                                        'fiber_length': 918,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -22.924,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.554}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_36743/gp1',
                                                                                               'poller_hash': 'MTFGRUMwMXBlZXJwb25zb25hcl9pdGVtXzM2NzQzL2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_36743',
                                         'poller_hash': 'MTFGRUMwMQ==',
                                         'serial_number': '11FEC01',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'b8:94:70:ef:90:cc',
                                         'uptime': '3776096'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '2c:30:33:5b:05:1c'],
                                                                       'id': '1000513',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '23',
                                                                       'in_octets': '7399087829',
                                                                       'in_ucast_pkts': '16007987',
                                                                       'mac_address': 'b8:94:70:ef:8e:b0',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_36750/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '43445',
                                                                       'out_octets': '9508272545',
                                                                       'out_ucast_pkts': '17074613',
                                                                       'poller_hash': 'MTFGRUI5NXBlZXJpbnRmc29uYXJfaXRlbV8zNjc1MC9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_36750',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '43445',
                                                                       'in_octets': '9508272545',
                                                                       'in_ucast_pkts': '17074613',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '43445',
                                                                                                'in_octets': '9508272545',
                                                                                                'in_ucast_pkts': '17074613',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '23',
                                                                                                'out_octets': '7399087829',
                                                                                                'out_ucast_pkts': '16007987',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx'}],
                                                                       'name': 'sonar_item_36750/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '23',
                                                                       'out_octets': '7399087829',
                                                                       'out_ucast_pkts': '16007987',
                                                                       'poller_hash': 'MTFGRUI5NXBlZXJpbnRmc29uYXJfaXRlbV8zNjc1MC9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_36750/gp1',
                                                                                               'id': 'sonar_item_36750',
                                                                                               'links': [       {       'connected_time': '682590',
                                                                                                                        'fiber_length': 1122,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -12.068,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.504}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_36750/gp1',
                                                                                               'poller_hash': 'MTFGRUI5NXBlZXJwb25zb25hcl9pdGVtXzM2NzUwL2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_36750',
                                         'poller_hash': 'MTFGRUI5NQ==',
                                         'serial_number': '11FEB95',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'b8:94:70:ef:8e:b0',
                                         'uptime': '682590'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:38:e0:8e:4e:b2'],
                                                                       'id': '1001185',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '163',
                                                                       'in_octets': '17768416020',
                                                                       'in_ucast_pkts': '138618024',
                                                                       'mac_address': 'f8:85:f9:90:19:1b',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_50252/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937961',
                                                                       'out_octets': '622528064726',
                                                                       'out_ucast_pkts': '429851873',
                                                                       'poller_hash': 'MTA1OThBRnBlZXJpbnRmc29uYXJfaXRlbV81MDI1Mi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_50252',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937961',
                                                                       'in_octets': '622528064726',
                                                                       'in_ucast_pkts': '429851873',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937961',
                                                                                                'in_octets': '622528064726',
                                                                                                'in_ucast_pkts': '429851873',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '163',
                                                                                                'out_octets': '17768416020',
                                                                                                'out_ucast_pkts': '138618024',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWQxLzEveHA0'}],
                                                                       'name': 'sonar_item_50252/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '163',
                                                                       'out_octets': '17768416020',
                                                                       'out_ucast_pkts': '138618024',
                                                                       'poller_hash': 'MTA1OThBRnBlZXJpbnRmc29uYXJfaXRlbV81MDI1Mi9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_50252/gp1',
                                                                                               'id': 'sonar_item_50252',
                                                                                               'links': [       {       'connected_time': '3777719',
                                                                                                                        'fiber_length': 1326,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVkMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -15.228,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.358}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_50252/gp1',
                                                                                               'poller_hash': 'MTA1OThBRnBlZXJwb25zb25hcl9pdGVtXzUwMjUyL2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_50252',
                                         'poller_hash': 'MTA1OThBRg==',
                                         'serial_number': '10598AF',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'f8:85:f9:90:19:1b',
                                         'uptime': '3777719'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '04:bc:9f:4e:26:1c'],
                                                                       'id': '1001249',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '27453',
                                                                       'in_octets': '8706118668',
                                                                       'in_ucast_pkts': '41193670',
                                                                       'mac_address': 'f8:85:f9:90:1a:10',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_50254/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '64512',
                                                                       'out_octets': '237100340034',
                                                                       'out_ucast_pkts': '184069828',
                                                                       'poller_hash': 'MTA1OThFMHBlZXJpbnRmc29uYXJfaXRlbV81MDI1NC9nMQ==',
                                                                       'speed': '2500000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_50254',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '64512',
                                                                       'in_octets': '237100340034',
                                                                       'in_ucast_pkts': '184069828',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '64512',
                                                                                                'in_octets': '237100340034',
                                                                                                'in_ucast_pkts': '184069828',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '27453',
                                                                                                'out_octets': '8706118668',
                                                                                                'out_ucast_pkts': '41193670',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWIxLzEveHAy'}],
                                                                       'name': 'sonar_item_50254/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '27453',
                                                                       'out_octets': '8706118668',
                                                                       'out_ucast_pkts': '41193670',
                                                                       'poller_hash': 'MTA1OThFMHBlZXJpbnRmc29uYXJfaXRlbV81MDI1NC9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_50254/gp1',
                                                                                               'id': 'sonar_item_50254',
                                                                                               'links': [       {       'connected_time': '1142729',
                                                                                                                        'fiber_length': 2142,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGViMTEwMDEwMTA2',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -19.1,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.408}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_50254/gp1',
                                                                                               'poller_hash': 'MTA1OThFMHBlZXJwb25zb25hcl9pdGVtXzUwMjU0L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_50254',
                                         'poller_hash': 'MTA1OThFMA==',
                                         'serial_number': '10598E0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'f8:85:f9:90:1a:10',
                                         'uptime': '1142729'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'b8:94:70:ed:2a:50'],
                                                                       'id': '1001057',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '115115',
                                                                       'in_octets': '305166780072',
                                                                       'in_ucast_pkts': '1690086013',
                                                                       'mac_address': 'f8:85:f9:90:1a:01',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_50255/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937964',
                                                                       'out_octets': '7196858206476',
                                                                       'out_ucast_pkts': '5067955047',
                                                                       'poller_hash': 'MTA1OThERHBlZXJpbnRmc29uYXJfaXRlbV81MDI1NS9nMQ==',
                                                                       'speed': '2500000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_50255',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937964',
                                                                       'in_octets': '7196858206476',
                                                                       'in_ucast_pkts': '5067955047',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937964',
                                                                                                'in_octets': '7196858206476',
                                                                                                'in_ucast_pkts': '5067955047',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '115115',
                                                                                                'out_octets': '305166780072',
                                                                                                'out_ucast_pkts': '1690086013',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx'}],
                                                                       'name': 'sonar_item_50255/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '115115',
                                                                       'out_octets': '305166780072',
                                                                       'out_ucast_pkts': '1690086013',
                                                                       'poller_hash': 'MTA1OThERHBlZXJpbnRmc29uYXJfaXRlbV81MDI1NS9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_50255/gp1',
                                                                                               'id': 'sonar_item_50255',
                                                                                               'links': [       {       'connected_time': '3777722',
                                                                                                                        'fiber_length': 2346,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -13.16,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.47}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_50255/gp1',
                                                                                               'poller_hash': 'MTA1OThERHBlZXJwb25zb25hcl9pdGVtXzUwMjU1L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_50255',
                                         'poller_hash': 'MTA1OThERA==',
                                         'serial_number': '10598DD',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'f8:85:f9:90:1a:01',
                                         'uptime': '3777722'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'b8:94:70:9d:00:c3'],
                                                                       'id': '1001089',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '72995',
                                                                       'in_octets': '17206542256',
                                                                       'in_ucast_pkts': '65074970',
                                                                       'mac_address': 'f8:85:f9:90:19:16',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_50256/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937978',
                                                                       'out_octets': '423878012793',
                                                                       'out_ucast_pkts': '332875406',
                                                                       'poller_hash': 'MTA1OThBRXBlZXJpbnRmc29uYXJfaXRlbV81MDI1Ni9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_50256',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937978',
                                                                       'in_octets': '423878012793',
                                                                       'in_ucast_pkts': '332875406',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937978',
                                                                                                'in_octets': '423878012793',
                                                                                                'in_ucast_pkts': '332875406',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '72995',
                                                                                                'out_octets': '17206542256',
                                                                                                'out_ucast_pkts': '65074970',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx'}],
                                                                       'name': 'sonar_item_50256/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '72995',
                                                                       'out_octets': '17206542256',
                                                                       'out_ucast_pkts': '65074970',
                                                                       'poller_hash': 'MTA1OThBRXBlZXJpbnRmc29uYXJfaXRlbV81MDI1Ni9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_50256/gp1',
                                                                                               'id': 'sonar_item_50256',
                                                                                               'links': [       {       'connected_time': '3777721',
                                                                                                                        'fiber_length': 1530,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -14.774,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.534}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_50256/gp1',
                                                                                               'poller_hash': 'MTA1OThBRXBlZXJwb25zb25hcl9pdGVtXzUwMjU2L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_50256',
                                         'poller_hash': 'MTA1OThBRQ==',
                                         'serial_number': '10598AE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'f8:85:f9:90:19:16',
                                         'uptime': '3777721'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:83:a1:d5'],
                                                                       'id': '1001345',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '93972',
                                                                       'in_octets': '26095588336',
                                                                       'in_ucast_pkts': '79352722',
                                                                       'mac_address': 'f8:85:f9:90:19:7f',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_50257/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937757',
                                                                       'out_octets': '285320351830',
                                                                       'out_ucast_pkts': '233434349',
                                                                       'poller_hash': 'MTA1OThDM3BlZXJpbnRmc29uYXJfaXRlbV81MDI1Ny9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_50257',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937757',
                                                                       'in_octets': '285320351830',
                                                                       'in_ucast_pkts': '233434349',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937757',
                                                                                                'in_octets': '285320351830',
                                                                                                'in_ucast_pkts': '233434349',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '93972',
                                                                                                'out_octets': '26095588336',
                                                                                                'out_ucast_pkts': '79352722',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWQxLzEveHA0'}],
                                                                       'name': 'sonar_item_50257/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '93972',
                                                                       'out_octets': '26095588336',
                                                                       'out_ucast_pkts': '79352722',
                                                                       'poller_hash': 'MTA1OThDM3BlZXJpbnRmc29uYXJfaXRlbV81MDI1Ny9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_50257/gp1',
                                                                                               'id': 'sonar_item_50257',
                                                                                               'links': [       {       'connected_time': '1974306',
                                                                                                                        'fiber_length': 1224,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVkMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -15.916,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.652}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_50257/gp1',
                                                                                               'poller_hash': 'MTA1OThDM3BlZXJwb25zb25hcl9pdGVtXzUwMjU3L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_50257',
                                         'poller_hash': 'MTA1OThDMw==',
                                         'serial_number': '10598C3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'f8:85:f9:90:19:7f',
                                         'uptime': '1974306'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:5f:67:9c:21:f4'],
                                                                       'id': '1001761',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '578',
                                                                       'in_octets': '30565390310',
                                                                       'in_ucast_pkts': '224523639',
                                                                       'mac_address': 'f8:85:f9:90:17:6d',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_50259/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937964',
                                                                       'out_octets': '819707230597',
                                                                       'out_ucast_pkts': '590841424',
                                                                       'poller_hash': 'MTA1OTg1OXBlZXJpbnRmc29uYXJfaXRlbV81MDI1OS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_50259',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937964',
                                                                       'in_octets': '819707230597',
                                                                       'in_ucast_pkts': '590841424',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937964',
                                                                                                'in_octets': '819707230597',
                                                                                                'in_ucast_pkts': '590841424',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '578',
                                                                                                'out_octets': '30565390310',
                                                                                                'out_ucast_pkts': '224523639',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx'}],
                                                                       'name': 'sonar_item_50259/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '578',
                                                                       'out_octets': '30565390310',
                                                                       'out_ucast_pkts': '224523639',
                                                                       'poller_hash': 'MTA1OTg1OXBlZXJpbnRmc29uYXJfaXRlbV81MDI1OS9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_50259/gp1',
                                                                                               'id': 'sonar_item_50259',
                                                                                               'links': [       {       'connected_time': '3777740',
                                                                                                                        'fiber_length': 918,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -21.738,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.706}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_50259/gp1',
                                                                                               'poller_hash': 'MTA1OTg1OXBlZXJwb25zb25hcl9pdGVtXzUwMjU5L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_50259',
                                         'poller_hash': 'MTA1OTg1OQ==',
                                         'serial_number': '1059859',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'f8:85:f9:90:17:6d',
                                         'uptime': '3777740'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '30:23:03:fb:37:f6'],
                                                                       'id': '1001409',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '47',
                                                                       'in_octets': '719869270',
                                                                       'in_ucast_pkts': '3850100',
                                                                       'mac_address': 'b8:94:70:7f:ee:c9',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_50361/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '19',
                                                                       'out_octets': '18555282218',
                                                                       'out_ucast_pkts': '13256753',
                                                                       'poller_hash': 'MTEzQ0M1RnBlZXJpbnRmc29uYXJfaXRlbV81MDM2MS9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_50361',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '19',
                                                                       'in_octets': '18555282218',
                                                                       'in_ucast_pkts': '13256753',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '19',
                                                                                                'in_octets': '18555282218',
                                                                                                'in_ucast_pkts': '13256753',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '47',
                                                                                                'out_octets': '719869270',
                                                                                                'out_ucast_pkts': '3850100',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWQxLzEveHA0'}],
                                                                       'name': 'sonar_item_50361/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '47',
                                                                       'out_octets': '719869270',
                                                                       'out_ucast_pkts': '3850100',
                                                                       'poller_hash': 'MTEzQ0M1RnBlZXJpbnRmc29uYXJfaXRlbV81MDM2MS9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_50361/gp1',
                                                                                               'id': 'sonar_item_50361',
                                                                                               'links': [       {       'connected_time': '54892',
                                                                                                                        'fiber_length': 1224,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVkMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -16.362,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.636}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_50361/gp1',
                                                                                               'poller_hash': 'MTEzQ0M1RnBlZXJwb25zb25hcl9pdGVtXzUwMzYxL2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_50361',
                                         'poller_hash': 'MTEzQ0M1Rg==',
                                         'serial_number': '113CC5F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'b8:94:70:7f:ee:c9',
                                         'uptime': '54892'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '54:07:7d:e5:a5:25'],
                                                                       'id': '1001729',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '10770',
                                                                       'in_octets': '102613579654',
                                                                       'in_ucast_pkts': '323000774',
                                                                       'mac_address': 'b8:94:70:f4:82:9e',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_50852/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937947',
                                                                       'out_octets': '834456129766',
                                                                       'out_ucast_pkts': '620849090',
                                                                       'poller_hash': 'MTIwNzdCQ3BlZXJpbnRmc29uYXJfaXRlbV81MDg1Mi9nMQ==',
                                                                       'speed': '2500000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_50852',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937947',
                                                                       'in_octets': '834456129766',
                                                                       'in_ucast_pkts': '620849090',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937947',
                                                                                                'in_octets': '834456129766',
                                                                                                'in_ucast_pkts': '620849090',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '10770',
                                                                                                'out_octets': '102613579654',
                                                                                                'out_ucast_pkts': '323000774',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx'}],
                                                                       'name': 'sonar_item_50852/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '10770',
                                                                       'out_octets': '102613579654',
                                                                       'out_ucast_pkts': '323000774',
                                                                       'poller_hash': 'MTIwNzdCQ3BlZXJpbnRmc29uYXJfaXRlbV81MDg1Mi9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_50852/gp1',
                                                                                               'id': 'sonar_item_50852',
                                                                                               'links': [       {       'connected_time': '3777727',
                                                                                                                        'fiber_length': 2244,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -11.444,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.208}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_50852/gp1',
                                                                                               'poller_hash': 'MTIwNzdCQ3BlZXJwb25zb25hcl9pdGVtXzUwODUyL2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_50852',
                                         'poller_hash': 'MTIwNzdCQw==',
                                         'serial_number': '12077BC',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'b8:94:70:f4:82:9e',
                                         'uptime': '3777727'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f8:85:f9:10:bb:c8'],
                                                                       'id': '1001825',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '50384',
                                                                       'in_octets': '9354786912',
                                                                       'in_ucast_pkts': '36005134',
                                                                       'mac_address': 'b8:94:70:f4:80:e1',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_50861/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937968',
                                                                       'out_octets': '486417180471',
                                                                       'out_ucast_pkts': '340105387',
                                                                       'poller_hash': 'MTIwNzc2M3BlZXJpbnRmc29uYXJfaXRlbV81MDg2MS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_50861',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937968',
                                                                       'in_octets': '486417180471',
                                                                       'in_ucast_pkts': '340105387',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937968',
                                                                                                'in_octets': '486417180471',
                                                                                                'in_ucast_pkts': '340105387',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '50384',
                                                                                                'out_octets': '9354786912',
                                                                                                'out_ucast_pkts': '36005134',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWQxLzEveHA0'}],
                                                                       'name': 'sonar_item_50861/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '50384',
                                                                       'out_octets': '9354786912',
                                                                       'out_ucast_pkts': '36005134',
                                                                       'poller_hash': 'MTIwNzc2M3BlZXJpbnRmc29uYXJfaXRlbV81MDg2MS9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_50861/gp1',
                                                                                               'id': 'sonar_item_50861',
                                                                                               'links': [       {       'connected_time': '3777708',
                                                                                                                        'fiber_length': 1224,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVkMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -15.39,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.508}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_50861/gp1',
                                                                                               'poller_hash': 'MTIwNzc2M3BlZXJwb25zb25hcl9pdGVtXzUwODYxL2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_50861',
                                         'poller_hash': 'MTIwNzc2Mw==',
                                         'serial_number': '1207763',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'b8:94:70:f4:80:e1',
                                         'uptime': '3777708'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'ec:75:0c:78:41:91'],
                                                                       'id': '1001569',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '212',
                                                                       'in_octets': '90080226560',
                                                                       'in_ucast_pkts': '156053454',
                                                                       'mac_address': 'b8:94:70:f4:7e:f2',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_50862/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937947',
                                                                       'out_octets': '348016857404',
                                                                       'out_ucast_pkts': '297955116',
                                                                       'poller_hash': 'MTIwNzcwMHBlZXJpbnRmc29uYXJfaXRlbV81MDg2Mi9nMQ==',
                                                                       'speed': '2500000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_50862',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937947',
                                                                       'in_octets': '348016857404',
                                                                       'in_ucast_pkts': '297955116',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937947',
                                                                                                'in_octets': '348016857404',
                                                                                                'in_ucast_pkts': '297955116',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '212',
                                                                                                'out_octets': '90080226560',
                                                                                                'out_ucast_pkts': '156053454',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWIxLzEveHAy'}],
                                                                       'name': 'sonar_item_50862/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '212',
                                                                       'out_octets': '90080226560',
                                                                       'out_ucast_pkts': '156053454',
                                                                       'poller_hash': 'MTIwNzcwMHBlZXJpbnRmc29uYXJfaXRlbV81MDg2Mi9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_50862/gp1',
                                                                                               'id': 'sonar_item_50862',
                                                                                               'links': [       {       'connected_time': '3777724',
                                                                                                                        'fiber_length': 2040,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGViMTEwMDEwMTA2',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -12.026,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.434}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_50862/gp1',
                                                                                               'poller_hash': 'MTIwNzcwMHBlZXJwb25zb25hcl9pdGVtXzUwODYyL2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_50862',
                                         'poller_hash': 'MTIwNzcwMA==',
                                         'serial_number': '1207700',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'b8:94:70:f4:7e:f2',
                                         'uptime': '3777724'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:8b:76:6a:96:44'],
                                                                       'id': '1001953',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '644',
                                                                       'in_octets': '2751921',
                                                                       'in_ucast_pkts': '13788',
                                                                       'mac_address': '04:bc:9f:66:8c:d4',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_51416/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '14',
                                                                       'out_octets': '16539097',
                                                                       'out_ucast_pkts': '20611',
                                                                       'poller_hash': 'MTI4NTc1RnBlZXJpbnRmc29uYXJfaXRlbV81MTQxNi9nMQ==',
                                                                       'speed': '2500000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_51416',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '14',
                                                                       'in_octets': '16539097',
                                                                       'in_ucast_pkts': '20611',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '14',
                                                                                                'in_octets': '16539097',
                                                                                                'in_ucast_pkts': '20611',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '644',
                                                                                                'out_octets': '2751921',
                                                                                                'out_ucast_pkts': '13788',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx'}],
                                                                       'name': 'sonar_item_51416/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '644',
                                                                       'out_octets': '2751921',
                                                                       'out_ucast_pkts': '13788',
                                                                       'poller_hash': 'MTI4NTc1RnBlZXJpbnRmc29uYXJfaXRlbV81MTQxNi9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_51416/gp1',
                                                                                               'id': 'sonar_item_51416',
                                                                                               'links': [       {       'connected_time': '69559',
                                                                                                                        'fiber_length': 918,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -13.978,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.568}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_51416/gp1',
                                                                                               'poller_hash': 'MTI4NTc1RnBlZXJwb25zb25hcl9pdGVtXzUxNDE2L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_51416',
                                         'poller_hash': 'MTI4NTc1Rg==',
                                         'serial_number': '128575F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': '04:bc:9f:66:8c:d4',
                                         'uptime': '69559'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '14:21:03:e0:7a:db'],
                                                                       'id': '1001281',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '84359',
                                                                       'in_octets': '46094542390',
                                                                       'in_ucast_pkts': '219714116',
                                                                       'mac_address': '04:bc:9f:78:ea:53',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_51707/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937977',
                                                                       'out_octets': '1549687858475',
                                                                       'out_ucast_pkts': '1090678006',
                                                                       'poller_hash': 'MTJBNTUyMXBlZXJpbnRmc29uYXJfaXRlbV81MTcwNy9nMQ==',
                                                                       'speed': '2500000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_51707',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937977',
                                                                       'in_octets': '1549687858475',
                                                                       'in_ucast_pkts': '1090678006',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937977',
                                                                                                'in_octets': '1549687858475',
                                                                                                'in_ucast_pkts': '1090678006',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '84359',
                                                                                                'out_octets': '46094542390',
                                                                                                'out_ucast_pkts': '219714116',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWQxLzEveHA0'}],
                                                                       'name': 'sonar_item_51707/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '84359',
                                                                       'out_octets': '46094542390',
                                                                       'out_ucast_pkts': '219714116',
                                                                       'poller_hash': 'MTJBNTUyMXBlZXJpbnRmc29uYXJfaXRlbV81MTcwNy9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_51707/gp1',
                                                                                               'id': 'sonar_item_51707',
                                                                                               'links': [       {       'connected_time': '3777535',
                                                                                                                        'fiber_length': 1326,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVkMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -13.99,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.45}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_51707/gp1',
                                                                                               'poller_hash': 'MTJBNTUyMXBlZXJwb25zb25hcl9pdGVtXzUxNzA3L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_51707',
                                         'poller_hash': 'MTJBNTUyMQ==',
                                         'serial_number': '12A5521',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': '04:bc:9f:78:ea:53',
                                         'uptime': '3777535'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f8:85:f9:ae:ac:88'],
                                                                       'id': '1000769',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '54063',
                                                                       'in_octets': '26171615527',
                                                                       'in_ucast_pkts': '89665581',
                                                                       'mac_address': '04:bc:9f:78:ed:5f',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_51713/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937972',
                                                                       'out_octets': '161759878534',
                                                                       'out_ucast_pkts': '152632004',
                                                                       'poller_hash': 'MTJBNTVCRHBlZXJpbnRmc29uYXJfaXRlbV81MTcxMy9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_51713',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937972',
                                                                       'in_octets': '161759878534',
                                                                       'in_ucast_pkts': '152632004',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937972',
                                                                                                'in_octets': '161759878534',
                                                                                                'in_ucast_pkts': '152632004',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '54063',
                                                                                                'out_octets': '26171615527',
                                                                                                'out_ucast_pkts': '89665581',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx'}],
                                                                       'name': 'sonar_item_51713/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '54063',
                                                                       'out_octets': '26171615527',
                                                                       'out_ucast_pkts': '89665581',
                                                                       'poller_hash': 'MTJBNTVCRHBlZXJpbnRmc29uYXJfaXRlbV81MTcxMy9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_51713/gp1',
                                                                                               'id': 'sonar_item_51713',
                                                                                               'links': [       {       'connected_time': '3777736',
                                                                                                                        'fiber_length': 1020,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -13.214,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.522}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_51713/gp1',
                                                                                               'poller_hash': 'MTJBNTVCRHBlZXJwb25zb25hcl9pdGVtXzUxNzEzL2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_51713',
                                         'poller_hash': 'MTJBNTVCRA==',
                                         'serial_number': '12A55BD',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': '04:bc:9f:78:ed:5f',
                                         'uptime': '3777736'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:a4:9c:ad'],
                                                                       'id': '1000737',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7358',
                                                                       'in_octets': '3953722888',
                                                                       'in_ucast_pkts': '8618462',
                                                                       'mac_address': '04:bc:9f:78:ec:ec',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_51716/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '64474',
                                                                       'out_octets': '20805255920',
                                                                       'out_ucast_pkts': '18609744',
                                                                       'poller_hash': 'MTJBNTVBNnBlZXJpbnRmc29uYXJfaXRlbV81MTcxNi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_51716',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '64474',
                                                                       'in_octets': '20805255920',
                                                                       'in_ucast_pkts': '18609744',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '64474',
                                                                                                'in_octets': '20805255920',
                                                                                                'in_ucast_pkts': '18609744',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '7358',
                                                                                                'out_octets': '3953722888',
                                                                                                'out_ucast_pkts': '8618462',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx'}],
                                                                       'name': 'sonar_item_51716/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7358',
                                                                       'out_octets': '3953722888',
                                                                       'out_ucast_pkts': '8618462',
                                                                       'poller_hash': 'MTJBNTVBNnBlZXJpbnRmc29uYXJfaXRlbV81MTcxNi9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_51716/gp1',
                                                                                               'id': 'sonar_item_51716',
                                                                                               'links': [       {       'connected_time': '870796',
                                                                                                                        'fiber_length': 918,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -20.654,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.338}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_51716/gp1',
                                                                                               'poller_hash': 'MTJBNTVBNnBlZXJwb25zb25hcl9pdGVtXzUxNzE2L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_51716',
                                         'poller_hash': 'MTJBNTVBNg==',
                                         'serial_number': '12A55A6',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': '04:bc:9f:78:ec:ec',
                                         'uptime': '870796'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:a4:9c:d9'],
                                                                       'id': '1000897',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4489',
                                                                       'in_octets': '9588443790',
                                                                       'in_ucast_pkts': '49254401',
                                                                       'mac_address': '04:bc:9f:78:d9:91',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_51718/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '39',
                                                                       'out_octets': '218780204945',
                                                                       'out_ucast_pkts': '152202897',
                                                                       'poller_hash': 'MTJBNTFDN3BlZXJpbnRmc29uYXJfaXRlbV81MTcxOC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_51718',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '39',
                                                                       'in_octets': '218780204945',
                                                                       'in_ucast_pkts': '152202897',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '39',
                                                                                                'in_octets': '218780204945',
                                                                                                'in_ucast_pkts': '152202897',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '4489',
                                                                                                'out_octets': '9588443790',
                                                                                                'out_ucast_pkts': '49254401',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWIxLzEveHAy'}],
                                                                       'name': 'sonar_item_51718/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4489',
                                                                       'out_octets': '9588443790',
                                                                       'out_ucast_pkts': '49254401',
                                                                       'poller_hash': 'MTJBNTFDN3BlZXJpbnRmc29uYXJfaXRlbV81MTcxOC9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_51718/gp1',
                                                                                               'id': 'sonar_item_51718',
                                                                                               'links': [       {       'connected_time': '521441',
                                                                                                                        'fiber_length': 2142,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGViMTEwMDEwMTA2',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -13.936,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.516}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_51718/gp1',
                                                                                               'poller_hash': 'MTJBNTFDN3BlZXJwb25zb25hcl9pdGVtXzUxNzE4L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_51718',
                                         'poller_hash': 'MTJBNTFDNw==',
                                         'serial_number': '12A51C7',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': '04:bc:9f:78:d9:91',
                                         'uptime': '521441'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'b8:94:70:55:e1:d9'],
                                                                       'id': '1000865',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '90994',
                                                                       'in_octets': '7815743209',
                                                                       'in_ucast_pkts': '29394053',
                                                                       'mac_address': '04:bc:9f:78:ef:08',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_51719/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937978',
                                                                       'out_octets': '136941788403',
                                                                       'out_ucast_pkts': '110574621',
                                                                       'poller_hash': 'MTJBNTYxMnBlZXJpbnRmc29uYXJfaXRlbV81MTcxOS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_51719',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937978',
                                                                       'in_octets': '136941788403',
                                                                       'in_ucast_pkts': '110574621',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937978',
                                                                                                'in_octets': '136941788403',
                                                                                                'in_ucast_pkts': '110574621',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '90994',
                                                                                                'out_octets': '7815743209',
                                                                                                'out_ucast_pkts': '29394053',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWQxLzEveHA0'}],
                                                                       'name': 'sonar_item_51719/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '90994',
                                                                       'out_octets': '7815743209',
                                                                       'out_ucast_pkts': '29394053',
                                                                       'poller_hash': 'MTJBNTYxMnBlZXJpbnRmc29uYXJfaXRlbV81MTcxOS9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_51719/gp1',
                                                                                               'id': 'sonar_item_51719',
                                                                                               'links': [       {       'connected_time': '3777730',
                                                                                                                        'fiber_length': 1326,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVkMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -14.546,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.568}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_51719/gp1',
                                                                                               'poller_hash': 'MTJBNTYxMnBlZXJwb25zb25hcl9pdGVtXzUxNzE5L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_51719',
                                         'poller_hash': 'MTJBNTYxMg==',
                                         'serial_number': '12A5612',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': '04:bc:9f:78:ef:08',
                                         'uptime': '3777730'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '04:bc:9f:01:4d:f7'],
                                                                       'id': '1000673',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '72885',
                                                                       'in_octets': '343397446619',
                                                                       'in_ucast_pkts': '633558750',
                                                                       'mac_address': '04:bc:9f:78:ed:9b',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_51726/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937962',
                                                                       'out_octets': '2143085618407',
                                                                       'out_ucast_pkts': '1651953546',
                                                                       'poller_hash': 'MTJBNTVDOXBlZXJpbnRmc29uYXJfaXRlbV81MTcyNi9nMQ==',
                                                                       'speed': '2500000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_51726',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937962',
                                                                       'in_octets': '2143085618407',
                                                                       'in_ucast_pkts': '1651953546',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937962',
                                                                                                'in_octets': '2143085618407',
                                                                                                'in_ucast_pkts': '1651953546',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '72885',
                                                                                                'out_octets': '343397446619',
                                                                                                'out_ucast_pkts': '633558750',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWIxLzEveHAy'}],
                                                                       'name': 'sonar_item_51726/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '72885',
                                                                       'out_octets': '343397446619',
                                                                       'out_ucast_pkts': '633558750',
                                                                       'poller_hash': 'MTJBNTVDOXBlZXJpbnRmc29uYXJfaXRlbV81MTcyNi9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_51726/gp1',
                                                                                               'id': 'sonar_item_51726',
                                                                                               'links': [       {       'connected_time': '3777754',
                                                                                                                        'fiber_length': 1836,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGViMTEwMDEwMTA2',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -24.436,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.534}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_51726/gp1',
                                                                                               'poller_hash': 'MTJBNTVDOXBlZXJwb25zb25hcl9pdGVtXzUxNzI2L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_51726',
                                         'poller_hash': 'MTJBNTVDOQ==',
                                         'serial_number': '12A55C9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': '04:bc:9f:78:ed:9b',
                                         'uptime': '3777754'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'b8:94:70:ed:30:80'],
                                                                       'id': '1001601',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '44230',
                                                                       'in_octets': '19373986554',
                                                                       'in_ucast_pkts': '90679121',
                                                                       'mac_address': '04:bc:9f:78:ec:33',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_52034/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '851748',
                                                                       'out_octets': '585279112076',
                                                                       'out_ucast_pkts': '418361144',
                                                                       'poller_hash': 'MTJBNTU4MXBlZXJpbnRmc29uYXJfaXRlbV81MjAzNC9nMQ==',
                                                                       'speed': '2500000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_52034',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '851748',
                                                                       'in_octets': '585279112076',
                                                                       'in_ucast_pkts': '418361144',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '851748',
                                                                                                'in_octets': '585279112076',
                                                                                                'in_ucast_pkts': '418361144',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '44230',
                                                                                                'out_octets': '19373986554',
                                                                                                'out_ucast_pkts': '90679121',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWIxLzEveHAy'}],
                                                                       'name': 'sonar_item_52034/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '44230',
                                                                       'out_octets': '19373986554',
                                                                       'out_ucast_pkts': '90679121',
                                                                       'poller_hash': 'MTJBNTU4MXBlZXJpbnRmc29uYXJfaXRlbV81MjAzNC9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_52034/gp1',
                                                                                               'id': 'sonar_item_52034',
                                                                                               'links': [       {       'connected_time': '1632522',
                                                                                                                        'fiber_length': 1938,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGViMTEwMDEwMTA2',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -12.196,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.418}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_52034/gp1',
                                                                                               'poller_hash': 'MTJBNTU4MXBlZXJwb25zb25hcl9pdGVtXzUyMDM0L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_52034',
                                         'poller_hash': 'MTJBNTU4MQ==',
                                         'serial_number': '12A5581',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': '04:bc:9f:78:ec:33',
                                         'uptime': '1632522'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '14:21:03:35:b6:f0'],
                                                                       'id': '1001665',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '28463',
                                                                       'in_octets': '13731364485',
                                                                       'in_ucast_pkts': '109142332',
                                                                       'mac_address': 'b8:94:70:f4:7b:be',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_52107/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '64491',
                                                                       'out_octets': '574076268733',
                                                                       'out_ucast_pkts': '402146086',
                                                                       'poller_hash': 'MTIwNzY1Q3BlZXJpbnRmc29uYXJfaXRlbV81MjEwNy9nMQ==',
                                                                       'speed': '2500000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_52107',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '64491',
                                                                       'in_octets': '574076268733',
                                                                       'in_ucast_pkts': '402146086',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '64491',
                                                                                                'in_octets': '574076268733',
                                                                                                'in_ucast_pkts': '402146086',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '28463',
                                                                                                'out_octets': '13731364485',
                                                                                                'out_ucast_pkts': '109142332',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWIxLzEveHAy'}],
                                                                       'name': 'sonar_item_52107/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '28463',
                                                                       'out_octets': '13731364485',
                                                                       'out_ucast_pkts': '109142332',
                                                                       'poller_hash': 'MTIwNzY1Q3BlZXJpbnRmc29uYXJfaXRlbV81MjEwNy9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_52107/gp1',
                                                                                               'id': 'sonar_item_52107',
                                                                                               'links': [       {       'connected_time': '913676',
                                                                                                                        'fiber_length': 1836,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGViMTEwMDEwMTA2',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -12.822,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.386}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_52107/gp1',
                                                                                               'poller_hash': 'MTIwNzY1Q3BlZXJwb25zb25hcl9pdGVtXzUyMTA3L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_52107',
                                         'poller_hash': 'MTIwNzY1Qw==',
                                         'serial_number': '120765C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'b8:94:70:f4:7b:be',
                                         'uptime': '913676'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'b8:94:70:ed:31:f6'],
                                                                       'id': '1001505',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '92854',
                                                                       'in_octets': '218661704036',
                                                                       'in_ucast_pkts': '519640106',
                                                                       'mac_address': 'b8:94:70:f4:7b:a5',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_52109/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937963',
                                                                       'out_octets': '2009893886690',
                                                                       'out_ucast_pkts': '1425899875',
                                                                       'poller_hash': 'MTIwNzY1N3BlZXJpbnRmc29uYXJfaXRlbV81MjEwOS9nMQ==',
                                                                       'speed': '2500000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_52109',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937963',
                                                                       'in_octets': '2009893886690',
                                                                       'in_ucast_pkts': '1425899875',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937963',
                                                                                                'in_octets': '2009893886690',
                                                                                                'in_ucast_pkts': '1425899875',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '92854',
                                                                                                'out_octets': '218661704036',
                                                                                                'out_ucast_pkts': '519640106',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWIxLzEveHAy'}],
                                                                       'name': 'sonar_item_52109/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '92854',
                                                                       'out_octets': '218661704036',
                                                                       'out_ucast_pkts': '519640106',
                                                                       'poller_hash': 'MTIwNzY1N3BlZXJpbnRmc29uYXJfaXRlbV81MjEwOS9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_52109/gp1',
                                                                                               'id': 'sonar_item_52109',
                                                                                               'links': [       {       'connected_time': '3777723',
                                                                                                                        'fiber_length': 1836,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGViMTEwMDEwMTA2',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -14.248,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.366}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_52109/gp1',
                                                                                               'poller_hash': 'MTIwNzY1N3BlZXJwb25zb25hcl9pdGVtXzUyMTA5L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_52109',
                                         'poller_hash': 'MTIwNzY1Nw==',
                                         'serial_number': '1207657',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'b8:94:70:f4:7b:a5',
                                         'uptime': '3777723'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '14:21:03:35:b8:c9'],
                                                                       'id': '1001537',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '43379',
                                                                       'in_octets': '13908408687',
                                                                       'in_ucast_pkts': '57212244',
                                                                       'mac_address': 'b8:94:70:f4:7b:c3',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_52114/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937783',
                                                                       'out_octets': '251886780371',
                                                                       'out_ucast_pkts': '184511695',
                                                                       'poller_hash': 'MTIwNzY1RHBlZXJpbnRmc29uYXJfaXRlbV81MjExNC9nMQ==',
                                                                       'speed': '2500000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_52114',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937783',
                                                                       'in_octets': '251886780371',
                                                                       'in_ucast_pkts': '184511695',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937783',
                                                                                                'in_octets': '251886780371',
                                                                                                'in_ucast_pkts': '184511695',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '43379',
                                                                                                'out_octets': '13908408687',
                                                                                                'out_ucast_pkts': '57212244',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWQxLzEveHA0'}],
                                                                       'name': 'sonar_item_52114/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '43379',
                                                                       'out_octets': '13908408687',
                                                                       'out_ucast_pkts': '57212244',
                                                                       'poller_hash': 'MTIwNzY1RHBlZXJpbnRmc29uYXJfaXRlbV81MjExNC9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_52114/gp1',
                                                                                               'id': 'sonar_item_52114',
                                                                                               'links': [       {       'connected_time': '2735879',
                                                                                                                        'fiber_length': 1224,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVkMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -14.814,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.504}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_52114/gp1',
                                                                                               'poller_hash': 'MTIwNzY1RHBlZXJwb25zb25hcl9pdGVtXzUyMTE0L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_52114',
                                         'poller_hash': 'MTIwNzY1RA==',
                                         'serial_number': '120765D',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'b8:94:70:f4:7b:c3',
                                         'uptime': '2735879'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '04:bc:9f:83:0d:7a'],
                                                                       'id': '1001697',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '61629',
                                                                       'in_octets': '21142247277',
                                                                       'in_ucast_pkts': '210188804',
                                                                       'mac_address': 'b8:94:70:f4:7b:eb',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_52131/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937770',
                                                                       'out_octets': '1274640035819',
                                                                       'out_ucast_pkts': '866816984',
                                                                       'poller_hash': 'MTIwNzY2NXBlZXJpbnRmc29uYXJfaXRlbV81MjEzMS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_52131',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937770',
                                                                       'in_octets': '1274640035819',
                                                                       'in_ucast_pkts': '866816984',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937770',
                                                                                                'in_octets': '1274640035819',
                                                                                                'in_ucast_pkts': '866816984',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '61629',
                                                                                                'out_octets': '21142247277',
                                                                                                'out_ucast_pkts': '210188804',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWQxLzEveHA0'}],
                                                                       'name': 'sonar_item_52131/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '61629',
                                                                       'out_octets': '21142247277',
                                                                       'out_ucast_pkts': '210188804',
                                                                       'poller_hash': 'MTIwNzY2NXBlZXJpbnRmc29uYXJfaXRlbV81MjEzMS9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_52131/gp1',
                                                                                               'id': 'sonar_item_52131',
                                                                                               'links': [       {       'connected_time': '2339919',
                                                                                                                        'fiber_length': 1224,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVkMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -16.86,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.454}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_52131/gp1',
                                                                                               'poller_hash': 'MTIwNzY2NXBlZXJwb25zb25hcl9pdGVtXzUyMTMxL2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_52131',
                                         'poller_hash': 'MTIwNzY2NQ==',
                                         'serial_number': '1207665',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'b8:94:70:f4:7b:eb',
                                         'uptime': '2339919'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'b8:94:70:af:4d:a1'],
                                                                       'id': '1000833',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '72575',
                                                                       'in_octets': '318771313030',
                                                                       'in_ucast_pkts': '461068191',
                                                                       'mac_address': '14:21:03:47:37:d7',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_59404/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '937962',
                                                                       'out_octets': '228936843042',
                                                                       'out_ucast_pkts': '494691417',
                                                                       'poller_hash': 'MTNDNzg5MXBlZXJpbnRmc29uYXJfaXRlbV81OTQwNC9nMQ==',
                                                                       'speed': '2500000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_59404',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '937962',
                                                                       'in_octets': '228936843042',
                                                                       'in_ucast_pkts': '494691417',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '937962',
                                                                                                'in_octets': '228936843042',
                                                                                                'in_ucast_pkts': '494691417',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '72575',
                                                                                                'out_octets': '318771313030',
                                                                                                'out_ucast_pkts': '461068191',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWExLzEveHAx'}],
                                                                       'name': 'sonar_item_59404/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '72575',
                                                                       'out_octets': '318771313030',
                                                                       'out_ucast_pkts': '461068191',
                                                                       'poller_hash': 'MTNDNzg5MXBlZXJpbnRmc29uYXJfaXRlbV81OTQwNC9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_59404/gp1',
                                                                                               'id': 'sonar_item_59404',
                                                                                               'links': [       {       'connected_time': '3777743',
                                                                                                                        'fiber_length': 2244,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVhMTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -12.958,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.658}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_59404/gp1',
                                                                                               'poller_hash': 'MTNDNzg5MXBlZXJwb25zb25hcl9pdGVtXzU5NDA0L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_59404',
                                         'poller_hash': 'MTNDNzg5MQ==',
                                         'serial_number': '13C7891',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': '14:21:03:47:37:d7',
                                         'uptime': '3777743'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:8b:76:6a:9c:a0'],
                                                                       'id': '1001793',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '22344',
                                                                       'in_octets': '35499014971',
                                                                       'in_ucast_pkts': '120055235',
                                                                       'mac_address': 'b8:94:70:7f:e8:e3',
                                                                       'mtu': 9974,
                                                                       'name': 'sonar_item_69744/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '64488',
                                                                       'out_octets': '778695090139',
                                                                       'out_ucast_pkts': '545207563',
                                                                       'poller_hash': 'MTEzQ0IzMXBlZXJpbnRmc29uYXJfaXRlbV82OTc0NC9nMQ==',
                                                                       'speed': '2500000000'},
                                                               {       'admin_up': True,
                                                                       'id': 'sonar_item_69744',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '64488',
                                                                       'in_octets': '778695090139',
                                                                       'in_ucast_pkts': '545207563',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '64488',
                                                                                                'in_octets': '778695090139',
                                                                                                'in_ucast_pkts': '545207563',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '22344',
                                                                                                'out_octets': '35499014971',
                                                                                                'out_ucast_pkts': '120055235',
                                                                                                'poller_hash': 'MDQ6YmM6OWY6ZjM6NzA6ZWQxLzEveHA0'}],
                                                                       'name': 'sonar_item_69744/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '22344',
                                                                       'out_octets': '35499014971',
                                                                       'out_ucast_pkts': '120055235',
                                                                       'poller_hash': 'MTEzQ0IzMXBlZXJpbnRmc29uYXJfaXRlbV82OTc0NC9ncDE=',
                                                                       'pons': [       {       'description': 'sonar_item_69744/gp1',
                                                                                               'id': 'sonar_item_69744',
                                                                                               'links': [       {       'connected_time': '909491',
                                                                                                                        'fiber_length': 1224,
                                                                                                                        'poller_hash': 'MDRiYzlmZjM3MGVkMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -14.34,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.458}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': 9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'sonar_item_69744/gp1',
                                                                                               'poller_hash': 'MTEzQ0IzMXBlZXJwb25zb25hcl9pdGVtXzY5NzQ0L2dwMQ==',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': 'GP1100X',
                                         'name': 'ont sonar_item_69744',
                                         'poller_hash': 'MTEzQ0IzMQ==',
                                         'serial_number': '113CB31',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '24.1.0.0.39',
                                         'system_mac_address': 'b8:94:70:7f:e8:e3',
                                         'uptime': '909491'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_calix_axos_E7_2_24_3_0_01(self):
        obj = self.run_data("calix.axos.E7-2.24.3.0.01")
        exp_info = {
         'model': 'E7-2', 'sta_count': 217, 'sw_version': '24.3.0', 'vendor': 'Calix'
        }
        exp_stats = {
         'serial_number': '472407019056', 'system_mac_address': '84:d3:43:d2:d9:a3'
        }
        exp_sta_stats = {
                None: {       'dev_macs': None,
                              'ip_address': None,
                              'mac_address': None,
                              'name': '92/g1',
                              'serial_number': '770AB9',
                              'system_mac_address': None},
                '00:06:31:34:57:5d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:34:57:5d',
                                             'name': '377/g1',
                                             'serial_number': '776F1',
                                             'system_mac_address': None},
                '48:77:46:7f:22:12': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:22:12',
                                             'name': '154/g1',
                                             'serial_number': '7507C5',
                                             'system_mac_address': None},
                '48:77:46:7f:22:24': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:22:24',
                                             'name': '330/g1',
                                             'serial_number': '7507CB',
                                             'system_mac_address': None},
                '48:77:46:7f:22:6c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:22:6c',
                                             'name': '347/g1',
                                             'serial_number': '7507E3',
                                             'system_mac_address': None},
                '48:77:46:7f:22:72': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:22:72',
                                             'name': '230/g1',
                                             'serial_number': '7507E5',
                                             'system_mac_address': None},
                '48:77:46:7f:22:78': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:22:78',
                                             'name': '247/g1',
                                             'serial_number': '7507E7',
                                             'system_mac_address': None},
                '48:77:46:7f:22:8a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:22:8a',
                                             'name': '268/g1',
                                             'serial_number': '7507ED',
                                             'system_mac_address': None},
                '48:77:46:7f:22:ae': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:22:ae',
                                             'name': '128/g1',
                                             'serial_number': '7507F9',
                                             'system_mac_address': None},
                '48:77:46:7f:22:ba': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:22:ba',
                                             'name': '135/g1',
                                             'serial_number': '7507FD',
                                             'system_mac_address': None},
                '48:77:46:7f:22:bd': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:22:bd',
                                             'name': '19/g1',
                                             'serial_number': '7507FE',
                                             'system_mac_address': None},
                '48:77:46:7f:22:f9': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:22:f9',
                                             'name': '34/g1',
                                             'serial_number': '750812',
                                             'system_mac_address': None},
                '48:77:46:7f:23:17': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:23:17',
                                             'name': '260/g1',
                                             'serial_number': '75081C',
                                             'system_mac_address': None},
                '48:77:46:7f:23:1d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:23:1d',
                                             'name': '235/g1',
                                             'serial_number': '75081E',
                                             'system_mac_address': None},
                '48:77:46:7f:23:23': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:23:23',
                                             'name': '251/g1',
                                             'serial_number': '750820',
                                             'system_mac_address': None},
                '48:77:46:7f:23:44': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:23:44',
                                             'name': '200/g1',
                                             'serial_number': '75082B',
                                             'system_mac_address': None},
                '48:77:46:7f:23:47': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:23:47',
                                             'name': '299/g1',
                                             'serial_number': '75082C',
                                             'system_mac_address': None},
                '48:77:46:7f:23:83': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:23:83',
                                             'name': '104/g1',
                                             'serial_number': '750840',
                                             'system_mac_address': None},
                '48:77:46:7f:24:13': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:24:13',
                                             'name': '224/g1',
                                             'serial_number': '750870',
                                             'system_mac_address': None},
                '48:77:46:7f:24:1f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:24:1f',
                                             'name': '190/g1',
                                             'serial_number': '750874',
                                             'system_mac_address': None},
                '48:77:46:7f:24:70': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:24:70',
                                             'name': '339/g1',
                                             'serial_number': '75088F',
                                             'system_mac_address': None},
                '48:77:46:7f:24:73': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:24:73',
                                             'name': '297/g1',
                                             'serial_number': '750890',
                                             'system_mac_address': None},
                '48:77:46:7f:24:ac': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:24:ac',
                                             'name': '324/g1',
                                             'serial_number': '7508A3',
                                             'system_mac_address': None},
                '48:77:46:7f:25:75': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:25:75',
                                             'name': '300/g1',
                                             'serial_number': '7508E6',
                                             'system_mac_address': None},
                '48:77:46:7f:25:9f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:25:9f',
                                             'name': '55/g1',
                                             'serial_number': '7508F4',
                                             'system_mac_address': None},
                '48:77:46:7f:26:17': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:26:17',
                                             'name': '365/g1',
                                             'serial_number': '75091C',
                                             'system_mac_address': None},
                '48:77:46:7f:26:41': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:26:41',
                                             'name': '285/g1',
                                             'serial_number': '75092A',
                                             'system_mac_address': None},
                '48:77:46:7f:26:7d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:26:7d',
                                             'name': '256/g1',
                                             'serial_number': '75093E',
                                             'system_mac_address': None},
                '48:77:46:7f:26:b6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:26:b6',
                                             'name': '217/g1',
                                             'serial_number': '750951',
                                             'system_mac_address': None},
                '48:77:46:7f:26:c2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:26:c2',
                                             'name': '30/g1',
                                             'serial_number': '750955',
                                             'system_mac_address': None},
                '48:77:46:7f:26:c5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:26:c5',
                                             'name': '318/g1',
                                             'serial_number': '750956',
                                             'system_mac_address': None},
                '48:77:46:7f:26:c8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:26:c8',
                                             'name': '367/g1',
                                             'serial_number': '750957',
                                             'system_mac_address': None},
                '48:77:46:7f:26:ce': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:26:ce',
                                             'name': '327/g1',
                                             'serial_number': '750959',
                                             'system_mac_address': None},
                '48:77:46:7f:26:ec': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:26:ec',
                                             'name': '112/g1',
                                             'serial_number': '750963',
                                             'system_mac_address': None},
                '48:77:46:7f:26:f2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:26:f2',
                                             'name': '125/g1',
                                             'serial_number': '750965',
                                             'system_mac_address': None},
                '48:77:46:7f:26:f5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:26:f5',
                                             'name': '227/g1',
                                             'serial_number': '750966',
                                             'system_mac_address': None},
                '48:77:46:7f:27:0a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:27:0a',
                                             'name': '229/g1',
                                             'serial_number': '75096D',
                                             'system_mac_address': None},
                '48:77:46:7f:27:0d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:27:0d',
                                             'name': '317/g1',
                                             'serial_number': '75096E',
                                             'system_mac_address': None},
                '48:77:46:7f:27:16': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:27:16',
                                             'name': '129/g1',
                                             'serial_number': '750971',
                                             'system_mac_address': None},
                '48:77:46:7f:27:31': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:27:31',
                                             'name': '126/g1',
                                             'serial_number': '75097A',
                                             'system_mac_address': None},
                '48:77:46:7f:27:58': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:27:58',
                                             'name': '271/g1',
                                             'serial_number': '750987',
                                             'system_mac_address': None},
                '48:77:46:7f:27:5b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:27:5b',
                                             'name': '114/g1',
                                             'serial_number': '750988',
                                             'system_mac_address': None},
                '48:77:46:7f:27:7f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:27:7f',
                                             'name': '262/g1',
                                             'serial_number': '750994',
                                             'system_mac_address': None},
                '48:77:46:7f:27:88': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:27:88',
                                             'name': '222/g1',
                                             'serial_number': '750997',
                                             'system_mac_address': None},
                '48:77:46:7f:27:9d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:27:9d',
                                             'name': '337/g1',
                                             'serial_number': '75099E',
                                             'system_mac_address': None},
                '48:77:46:7f:27:bb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:27:bb',
                                             'name': '183/g1',
                                             'serial_number': '7509A8',
                                             'system_mac_address': None},
                '48:77:46:7f:27:cd': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:27:cd',
                                             'name': '254/g1',
                                             'serial_number': '7509AE',
                                             'system_mac_address': None},
                '48:77:46:7f:27:fa': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:27:fa',
                                             'name': '343/g1',
                                             'serial_number': '7509BD',
                                             'system_mac_address': None},
                '48:77:46:7f:28:00': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:28:00',
                                             'name': '345/g1',
                                             'serial_number': '7509BF',
                                             'system_mac_address': None},
                '48:77:46:7f:28:66': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:28:66',
                                             'name': '223/g1',
                                             'serial_number': '7509E1',
                                             'system_mac_address': None},
                '48:77:46:7f:28:6c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:28:6c',
                                             'name': '278/g1',
                                             'serial_number': '7509E3',
                                             'system_mac_address': None},
                '48:77:46:7f:28:6f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:28:6f',
                                             'name': '273/g1',
                                             'serial_number': '7509E4',
                                             'system_mac_address': None},
                '48:77:46:7f:28:72': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:28:72',
                                             'name': '71/g1',
                                             'serial_number': '7509E5',
                                             'system_mac_address': None},
                '48:77:46:7f:28:84': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:28:84',
                                             'name': '228/g1',
                                             'serial_number': '7509EB',
                                             'system_mac_address': None},
                '48:77:46:7f:28:8d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:28:8d',
                                             'name': '269/g1',
                                             'serial_number': '7509EE',
                                             'system_mac_address': None},
                '48:77:46:7f:2d:55': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:2d:55',
                                             'name': '64/g1',
                                             'serial_number': '750B86',
                                             'system_mac_address': None},
                '48:77:46:7f:2d:e2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:2d:e2',
                                             'name': '164/g1',
                                             'serial_number': '750BB5',
                                             'system_mac_address': None},
                '48:77:46:7f:32:4a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:32:4a',
                                             'name': '165/g1',
                                             'serial_number': '750D2D',
                                             'system_mac_address': None},
                '48:77:46:7f:32:ef': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:32:ef',
                                             'name': '202/g1',
                                             'serial_number': '750D64',
                                             'system_mac_address': None},
                '48:77:46:7f:33:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:33:10',
                                             'name': '37/g1',
                                             'serial_number': '750D6F',
                                             'system_mac_address': None},
                '48:77:46:7f:33:1f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:7f:33:1f',
                                             'name': '389/g1',
                                             'serial_number': '750D74',
                                             'system_mac_address': None},
                '48:77:46:84:0a:07': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:84:0a:07',
                                             'name': '348/g1',
                                             'serial_number': '7593CE',
                                             'system_mac_address': None},
                '48:77:46:84:0b:5a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:84:0b:5a',
                                             'name': '370/g1',
                                             'serial_number': '75943F',
                                             'system_mac_address': None},
                '48:77:46:84:0c:08': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:84:0c:08',
                                             'name': '344/g1',
                                             'serial_number': '759479',
                                             'system_mac_address': None},
                '48:77:46:84:0c:d4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:84:0c:d4',
                                             'name': '239/g1',
                                             'serial_number': '7594BD',
                                             'system_mac_address': None},
                '48:77:46:84:0d:91': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:84:0d:91',
                                             'name': '329/g1',
                                             'serial_number': '7594FC',
                                             'system_mac_address': None},
                '48:77:46:84:0d:94': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:84:0d:94',
                                             'name': '349/g1',
                                             'serial_number': '7594FD',
                                             'system_mac_address': None},
                '48:77:46:84:0e:18': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:84:0e:18',
                                             'name': '325/g1',
                                             'serial_number': '759529',
                                             'system_mac_address': None},
                '48:77:46:96:34:7c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:34:7c',
                                             'name': '364/g1',
                                             'serial_number': '7706B1',
                                             'system_mac_address': None},
                '48:77:46:96:36:6b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:36:6b',
                                             'name': '238/g1',
                                             'serial_number': '770756',
                                             'system_mac_address': None},
                '48:77:46:96:37:dc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:37:dc',
                                             'name': '420/g1',
                                             'serial_number': '7707D1',
                                             'system_mac_address': None},
                '48:77:46:96:3b:57': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3b:57',
                                             'name': '15/g1',
                                             'serial_number': '7708FA',
                                             'system_mac_address': None},
                '48:77:46:96:3b:63': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3b:63',
                                             'name': '16/g1',
                                             'serial_number': '7708FE',
                                             'system_mac_address': None},
                '48:77:46:96:3c:4a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3c:4a',
                                             'name': '151/g1',
                                             'serial_number': '77094B',
                                             'system_mac_address': None},
                '48:77:46:96:3d:4f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3d:4f',
                                             'name': '162/g1',
                                             'serial_number': '7709A2',
                                             'system_mac_address': None},
                '48:77:46:96:3d:6a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3d:6a',
                                             'name': '66/g1',
                                             'serial_number': '7709AB',
                                             'system_mac_address': None},
                '48:77:46:96:3d:8b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3d:8b',
                                             'name': '169/g1',
                                             'serial_number': '7709B6',
                                             'system_mac_address': None},
                '48:77:46:96:3d:fa': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3d:fa',
                                             'name': '39/g1',
                                             'serial_number': '7709DB',
                                             'system_mac_address': None},
                '48:77:46:96:3e:30': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3e:30',
                                             'name': '113/g1',
                                             'serial_number': '7709ED',
                                             'system_mac_address': None},
                '48:77:46:96:3e:3c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3e:3c',
                                             'name': '59/g1',
                                             'serial_number': '7709F1',
                                             'system_mac_address': None},
                '48:77:46:96:3e:5a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3e:5a',
                                             'name': '116/g1',
                                             'serial_number': '7709FB',
                                             'system_mac_address': None},
                '48:77:46:96:3e:6f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3e:6f',
                                             'name': '214/g1',
                                             'serial_number': '770A02',
                                             'system_mac_address': None},
                '48:77:46:96:3e:7e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3e:7e',
                                             'name': '410/g1',
                                             'serial_number': '770A07',
                                             'system_mac_address': None},
                '48:77:46:96:3e:93': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3e:93',
                                             'name': '213/g1',
                                             'serial_number': '770A0E',
                                             'system_mac_address': None},
                '48:77:46:96:3e:ea': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3e:ea',
                                             'name': '264/g1',
                                             'serial_number': '770A2B',
                                             'system_mac_address': None},
                '48:77:46:96:3e:f0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3e:f0',
                                             'name': '340/g1',
                                             'serial_number': '770A2D',
                                             'system_mac_address': None},
                '48:77:46:96:3e:f3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3e:f3',
                                             'name': '96/g1',
                                             'serial_number': '770A2E',
                                             'system_mac_address': None},
                '48:77:46:96:3e:f9': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3e:f9',
                                             'name': '306/g1',
                                             'serial_number': '770A30',
                                             'system_mac_address': None},
                '48:77:46:96:3f:02': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3f:02',
                                             'name': '294/g1',
                                             'serial_number': '770A33',
                                             'system_mac_address': None},
                '48:77:46:96:3f:17': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3f:17',
                                             'name': '335/g1',
                                             'serial_number': '770A3A',
                                             'system_mac_address': None},
                '48:77:46:96:3f:5c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3f:5c',
                                             'name': '284/g1',
                                             'serial_number': '770A51',
                                             'system_mac_address': None},
                '48:77:46:96:3f:5f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3f:5f',
                                             'name': '302/g1',
                                             'serial_number': '770A52',
                                             'system_mac_address': None},
                '48:77:46:96:3f:92': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3f:92',
                                             'name': '73/g1',
                                             'serial_number': '770A63',
                                             'system_mac_address': None},
                '48:77:46:96:3f:b9': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3f:b9',
                                             'name': '98/g1',
                                             'serial_number': '770A70',
                                             'system_mac_address': None},
                '48:77:46:96:3f:bc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3f:bc',
                                             'name': '220/g1',
                                             'serial_number': '770A71',
                                             'system_mac_address': None},
                '48:77:46:96:3f:c8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3f:c8',
                                             'name': '315/g1',
                                             'serial_number': '770A75',
                                             'system_mac_address': None},
                '48:77:46:96:3f:e3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3f:e3',
                                             'name': '281/g1',
                                             'serial_number': '770A7E',
                                             'system_mac_address': None},
                '48:77:46:96:3f:ec': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:3f:ec',
                                             'name': '400/g1',
                                             'serial_number': '770A81',
                                             'system_mac_address': None},
                '48:77:46:96:40:2b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:40:2b',
                                             'name': '133/g1',
                                             'serial_number': '770A96',
                                             'system_mac_address': None},
                '48:77:46:96:40:40': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:40:40',
                                             'name': '301/g1',
                                             'serial_number': '770A9D',
                                             'system_mac_address': None},
                '48:77:46:96:40:64': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:40:64',
                                             'name': '100/g1',
                                             'serial_number': '770AA9',
                                             'system_mac_address': None},
                '48:77:46:96:40:70': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:40:70',
                                             'name': '320/g1',
                                             'serial_number': '770AAD',
                                             'system_mac_address': None},
                '48:77:46:96:40:8e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:40:8e',
                                             'name': '25/g1',
                                             'serial_number': '770AB7',
                                             'system_mac_address': None},
                '48:77:46:96:40:9d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:40:9d',
                                             'name': '314/g1',
                                             'serial_number': '770ABC',
                                             'system_mac_address': None},
                '48:77:46:96:40:a0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:40:a0',
                                             'name': '65/g1',
                                             'serial_number': '770ABD',
                                             'system_mac_address': None},
                '48:77:46:96:40:a3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:40:a3',
                                             'name': '14/g1',
                                             'serial_number': '770ABE',
                                             'system_mac_address': None},
                '48:77:46:96:40:b5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:40:b5',
                                             'name': '53/g1',
                                             'serial_number': '770AC4',
                                             'system_mac_address': None},
                '48:77:46:96:40:c4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:40:c4',
                                             'name': '70/g1',
                                             'serial_number': '770AC9',
                                             'system_mac_address': None},
                '48:77:46:96:40:df': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:40:df',
                                             'name': '287/g1',
                                             'serial_number': '770AD2',
                                             'system_mac_address': None},
                '48:77:46:96:40:e2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:40:e2',
                                             'name': '282/g1',
                                             'serial_number': '770AD3',
                                             'system_mac_address': None},
                '48:77:46:96:40:e8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:40:e8',
                                             'name': '274/g1',
                                             'serial_number': '770AD5',
                                             'system_mac_address': None},
                '48:77:46:96:40:eb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:40:eb',
                                             'name': '298/g1',
                                             'serial_number': '770AD6',
                                             'system_mac_address': None},
                '48:77:46:96:40:f4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:40:f4',
                                             'name': '305/g1',
                                             'serial_number': '770AD9',
                                             'system_mac_address': None},
                '48:77:46:96:40:f7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:40:f7',
                                             'name': '245/g1',
                                             'serial_number': '770ADA',
                                             'system_mac_address': None},
                '48:77:46:96:40:fd': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:40:fd',
                                             'name': '27/g1',
                                             'serial_number': '770ADC',
                                             'system_mac_address': None},
                '48:77:46:96:41:00': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:41:00',
                                             'name': '283/g1',
                                             'serial_number': '770ADD',
                                             'system_mac_address': None},
                '48:77:46:96:41:06': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:41:06',
                                             'name': '109/g1',
                                             'serial_number': '770ADF',
                                             'system_mac_address': None},
                '48:77:46:96:41:0c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:41:0c',
                                             'name': '174/g1',
                                             'serial_number': '770AE1',
                                             'system_mac_address': None},
                '48:77:46:96:41:15': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:41:15',
                                             'name': '270/g1',
                                             'serial_number': '770AE4',
                                             'system_mac_address': None},
                '48:77:46:96:41:18': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:41:18',
                                             'name': '131/g1',
                                             'serial_number': '770AE5',
                                             'system_mac_address': None},
                '48:77:46:96:41:1b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:41:1b',
                                             'name': '118/g1',
                                             'serial_number': '770AE6',
                                             'system_mac_address': None},
                '48:77:46:96:41:1e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:41:1e',
                                             'name': '60/g1',
                                             'serial_number': '770AE7',
                                             'system_mac_address': None},
                '48:77:46:96:41:21': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:41:21',
                                             'name': '241/g1',
                                             'serial_number': '770AE8',
                                             'system_mac_address': None},
                '48:77:46:96:41:24': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:41:24',
                                             'name': '181/g1',
                                             'serial_number': '770AE9',
                                             'system_mac_address': None},
                '48:77:46:bc:03:05': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:bc:03:05',
                                             'name': '180/g1',
                                             'serial_number': '7A0728',
                                             'system_mac_address': None},
                '48:77:46:f5:47:9a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:f5:47:9a',
                                             'name': '199/g1',
                                             'serial_number': '823ADB',
                                             'system_mac_address': None},
                '60:db:98:25:45:b8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:25:45:b8',
                                             'name': '17/g1',
                                             'serial_number': 'A373CF',
                                             'system_mac_address': None},
                '60:db:98:27:df:90': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:27:df:90',
                                             'name': '188/g1',
                                             'serial_number': 'A3DCEE',
                                             'system_mac_address': None},
                '60:db:98:88:36:81': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:88:36:81',
                                             'name': '246/g1',
                                             'serial_number': 'B3A83B',
                                             'system_mac_address': None},
                '60:db:98:8d:95:31': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8d:95:31',
                                             'name': '233/g1',
                                             'serial_number': 'B4987F',
                                             'system_mac_address': None},
                '84:d3:43:4c:5b:83': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:4c:5b:83',
                                             'name': '303/g1',
                                             'serial_number': 'C0E5FE',
                                             'system_mac_address': None},
                'd0:76:8f:44:e0:ea': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:44:e0:ea',
                                             'name': '68/g1',
                                             'serial_number': '8AB527',
                                             'system_mac_address': None},
                'd0:76:8f:48:a4:30': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:48:a4:30',
                                             'name': '130/g1',
                                             'serial_number': '8D8770',
                                             'system_mac_address': None},
                'd0:76:8f:48:a4:f3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:48:a4:f3',
                                             'name': '250/g1',
                                             'serial_number': '8D87B1',
                                             'system_mac_address': None},
                'd0:76:8f:48:a5:0b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:48:a5:0b',
                                             'name': '310/g1',
                                             'serial_number': '8D87B9',
                                             'system_mac_address': None},
                'd0:76:8f:48:a5:2f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:48:a5:2f',
                                             'name': '215/g1',
                                             'serial_number': '8D87C5',
                                             'system_mac_address': None},
                'd0:76:8f:48:a5:32': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:48:a5:32',
                                             'name': '361/g1',
                                             'serial_number': '8D87C6',
                                             'system_mac_address': None},
                'd0:76:8f:48:a5:38': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:48:a5:38',
                                             'name': '422/g1',
                                             'serial_number': '8D87C8',
                                             'system_mac_address': None},
                'd0:76:8f:48:a5:3b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:48:a5:3b',
                                             'name': '149/g1',
                                             'serial_number': '8D87C9',
                                             'system_mac_address': None},
                'd0:76:8f:48:a5:47': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:48:a5:47',
                                             'name': '342/g1',
                                             'serial_number': '8D87CD',
                                             'system_mac_address': None},
                'd0:76:8f:48:a5:4a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:48:a5:4a',
                                             'name': '216/g1',
                                             'serial_number': '8D87CE',
                                             'system_mac_address': None},
                'd0:76:8f:48:a5:50': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:48:a5:50',
                                             'name': '350/g1',
                                             'serial_number': '8D87D0',
                                             'system_mac_address': None},
                'd0:76:8f:48:a5:53': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:48:a5:53',
                                             'name': '137/g1',
                                             'serial_number': '8D87D1',
                                             'system_mac_address': None},
                'd0:76:8f:4d:36:e8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:4d:36:e8',
                                             'name': '141/g1',
                                             'serial_number': '8E25F8',
                                             'system_mac_address': None},
                'd0:76:8f:4d:36:eb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:4d:36:eb',
                                             'name': '316/g1',
                                             'serial_number': '8E25F9',
                                             'system_mac_address': None},
                'd0:76:8f:4d:37:51': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:4d:37:51',
                                             'name': '56/g1',
                                             'serial_number': '8E261B',
                                             'system_mac_address': None},
                'd0:76:8f:4d:37:96': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:4d:37:96',
                                             'name': '338/g1',
                                             'serial_number': '8E2632',
                                             'system_mac_address': None},
                'd0:76:8f:4d:37:e7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:4d:37:e7',
                                             'name': '292/g1',
                                             'serial_number': '8E264D',
                                             'system_mac_address': None},
                'd0:76:8f:4d:38:7a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:4d:38:7a',
                                             'name': '331/g1',
                                             'serial_number': '8E267E',
                                             'system_mac_address': None},
                'd0:76:8f:4d:39:1f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:4d:39:1f',
                                             'name': '414/g1',
                                             'serial_number': '8E26B5',
                                             'system_mac_address': None},
                'd0:76:8f:4d:39:a0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:4d:39:a0',
                                             'name': '265/g1',
                                             'serial_number': '8E26E0',
                                             'system_mac_address': None},
                'd0:76:8f:4d:3a:bd': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:4d:3a:bd',
                                             'name': '248/g1',
                                             'serial_number': '8E273F',
                                             'system_mac_address': None},
                'd0:76:8f:4d:3b:71': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:4d:3b:71',
                                             'name': '336/g1',
                                             'serial_number': '8E277B',
                                             'system_mac_address': None},
                'd0:76:8f:4d:3b:c2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:4d:3b:c2',
                                             'name': '209/g1',
                                             'serial_number': '8E2796',
                                             'system_mac_address': None},
                'd0:76:8f:4d:3b:c5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:4d:3b:c5',
                                             'name': '291/g1',
                                             'serial_number': '8E2797',
                                             'system_mac_address': None},
                'd0:76:8f:4d:3b:d1': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:4d:3b:d1',
                                             'name': '415/g1',
                                             'serial_number': '8E279B',
                                             'system_mac_address': None},
                'd0:76:8f:4d:3b:f8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:4d:3b:f8',
                                             'name': '263/g1',
                                             'serial_number': '8E27A8',
                                             'system_mac_address': None},
                'e4:6c:d1:1c:74:77': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'e4:6c:d1:1c:74:77',
                                             'name': '412/g1',
                                             'serial_number': '1A641DB',
                                             'system_mac_address': None},
                'e4:6c:d1:1c:74:8b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'e4:6c:d1:1c:74:8b',
                                             'name': '404/g1',
                                             'serial_number': '1A641DF',
                                             'system_mac_address': None},
                'e4:6c:d1:1c:74:d6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'e4:6c:d1:1c:74:d6',
                                             'name': '397/g1',
                                             'serial_number': '1A641EE',
                                             'system_mac_address': None},
                'e4:6c:d1:1c:74:fe': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'e4:6c:d1:1c:74:fe',
                                             'name': '390/g1',
                                             'serial_number': '1A641F6',
                                             'system_mac_address': None},
                'e4:6c:d1:1c:76:ed': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'e4:6c:d1:1c:76:ed',
                                             'name': '409/g1',
                                             'serial_number': '1A64259',
                                             'system_mac_address': None},
                'e4:6c:d1:1c:82:c3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'e4:6c:d1:1c:82:c3',
                                             'name': '407/g1',
                                             'serial_number': '1A644B7',
                                             'system_mac_address': None},
                'e4:6c:d1:1e:69:e8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'e4:6c:d1:1e:69:e8',
                                             'name': '413/g1',
                                             'serial_number': '1A6A6E3',
                                             'system_mac_address': None},
                'e4:6c:d1:1e:6a:0b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'e4:6c:d1:1e:6a:0b',
                                             'name': '418/g1',
                                             'serial_number': '1A6A6EA',
                                             'system_mac_address': None},
                'e4:6c:d1:1e:6a:51': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'e4:6c:d1:1e:6a:51',
                                             'name': '417/g1',
                                             'serial_number': '1A6A6F8',
                                             'system_mac_address': None},
                'e4:6c:d1:1e:6a:f1': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'e4:6c:d1:1e:6a:f1',
                                             'name': '419/g1',
                                             'serial_number': '1A6A718',
                                             'system_mac_address': None},
                'ec:4f:82:ae:e9:cf': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:ae:e9:cf',
                                             'name': '43/g1',
                                             'serial_number': '360538',
                                             'system_mac_address': None},
                'f8:85:f9:78:82:07': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:82:07',
                                             'name': '62/g1',
                                             'serial_number': 'E9DA8A',
                                             'system_mac_address': None},
                'f8:85:f9:78:82:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:82:10',
                                             'name': '288/g1',
                                             'serial_number': 'E9DA8D',
                                             'system_mac_address': None},
                'f8:85:f9:78:82:49': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:82:49',
                                             'name': '50/g1',
                                             'serial_number': 'E9DAA0',
                                             'system_mac_address': None},
                'f8:85:f9:78:82:73': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:82:73',
                                             'name': '309/g1',
                                             'serial_number': 'E9DAAE',
                                             'system_mac_address': None},
                'f8:85:f9:78:82:88': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:82:88',
                                             'name': '196/g1',
                                             'serial_number': 'E9DAB5',
                                             'system_mac_address': None},
                'f8:85:f9:78:82:91': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:82:91',
                                             'name': '311/g1',
                                             'serial_number': 'E9DAB8',
                                             'system_mac_address': None},
                'f8:85:f9:78:82:94': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:82:94',
                                             'name': '372/g1',
                                             'serial_number': 'E9DAB9',
                                             'system_mac_address': None},
                'f8:85:f9:78:82:eb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:82:eb',
                                             'name': '366/g1',
                                             'serial_number': 'E9DAD6',
                                             'system_mac_address': None},
                'f8:85:f9:78:82:f4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:82:f4',
                                             'name': '381/g1',
                                             'serial_number': 'E9DAD9',
                                             'system_mac_address': None},
                'f8:85:f9:78:83:3f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:83:3f',
                                             'name': '255/g1',
                                             'serial_number': 'E9DAF2',
                                             'system_mac_address': None},
                'f8:85:f9:78:83:84': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:83:84',
                                             'name': '360/g1',
                                             'serial_number': 'E9DB09',
                                             'system_mac_address': None},
                'f8:85:f9:78:83:99': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:83:99',
                                             'name': '51/g1',
                                             'serial_number': 'E9DB10',
                                             'system_mac_address': None},
                'f8:85:f9:78:83:fc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:83:fc',
                                             'name': '252/g1',
                                             'serial_number': 'E9DB31',
                                             'system_mac_address': None},
                'f8:85:f9:78:84:05': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:84:05',
                                             'name': '280/g1',
                                             'serial_number': 'E9DB34',
                                             'system_mac_address': None},
                'f8:85:f9:78:84:17': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:84:17',
                                             'name': '147/g1',
                                             'serial_number': 'E9DB3A',
                                             'system_mac_address': None},
                'f8:85:f9:78:84:59': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:84:59',
                                             'name': '49/g1',
                                             'serial_number': 'E9DB50',
                                             'system_mac_address': None},
                'f8:85:f9:78:84:5f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:84:5f',
                                             'name': '293/g1',
                                             'serial_number': 'E9DB52',
                                             'system_mac_address': None},
                'f8:85:f9:78:84:77': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:84:77',
                                             'name': '136/g1',
                                             'serial_number': 'E9DB5A',
                                             'system_mac_address': None},
                'f8:85:f9:78:84:7d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:84:7d',
                                             'name': '146/g1',
                                             'serial_number': 'E9DB5C',
                                             'system_mac_address': None},
                'f8:85:f9:78:84:c5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:84:c5',
                                             'name': '121/g1',
                                             'serial_number': 'E9DB74',
                                             'system_mac_address': None},
                'f8:85:f9:78:84:d4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:84:d4',
                                             'name': '237/g1',
                                             'serial_number': 'E9DB79',
                                             'system_mac_address': None},
                'f8:85:f9:78:85:40': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:85:40',
                                             'name': '321/g1',
                                             'serial_number': 'E9DB9D',
                                             'system_mac_address': None},
                'f8:85:f9:78:85:43': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:85:43',
                                             'name': '332/g1',
                                             'serial_number': 'E9DB9E',
                                             'system_mac_address': None},
                'f8:85:f9:78:85:76': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:85:76',
                                             'name': '194/g1',
                                             'serial_number': 'E9DBAF',
                                             'system_mac_address': None},
                'f8:85:f9:78:86:00': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:86:00',
                                             'name': '296/g1',
                                             'serial_number': 'E9DBDD',
                                             'system_mac_address': None},
                'f8:85:f9:78:86:09': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:86:09',
                                             'name': '219/g1',
                                             'serial_number': 'E9DBE0',
                                             'system_mac_address': None},
                'f8:85:f9:78:86:42': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:86:42',
                                             'name': '212/g1',
                                             'serial_number': 'E9DBF3',
                                             'system_mac_address': None},
                'f8:85:f9:78:87:38': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:87:38',
                                             'name': '363/g1',
                                             'serial_number': 'E9DC45',
                                             'system_mac_address': None},
                'f8:85:f9:78:87:80': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:87:80',
                                             'name': '231/g1',
                                             'serial_number': 'E9DC5D',
                                             'system_mac_address': None},
                'f8:85:f9:78:87:aa': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:87:aa',
                                             'name': '369/g1',
                                             'serial_number': 'E9DC6B',
                                             'system_mac_address': None},
                'f8:85:f9:78:87:ad': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:87:ad',
                                             'name': '207/g1',
                                             'serial_number': 'E9DC6C',
                                             'system_mac_address': None},
                'f8:85:f9:78:88:7c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:88:7c',
                                             'name': '386/g1',
                                             'serial_number': 'E9DCB1',
                                             'system_mac_address': None},
                'f8:85:f9:78:88:af': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:88:af',
                                             'name': '132/g1',
                                             'serial_number': 'E9DCC2',
                                             'system_mac_address': None},
                'f8:85:f9:78:89:06': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:89:06',
                                             'name': '384/g1',
                                             'serial_number': 'E9DCDF',
                                             'system_mac_address': None},
                'f8:85:f9:78:8d:f8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:8d:f8',
                                             'name': '101/g1',
                                             'serial_number': 'E9DE85',
                                             'system_mac_address': None},
                'f8:85:f9:78:8e:6d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:78:8e:6d',
                                             'name': '323/g1',
                                             'serial_number': 'E9DEAC',
                                             'system_mac_address': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': '75',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '11257819015',
                                                              'in_ucast_pkts': '196502574',
                                                              'mac_address': '4c:43:41:c9:0b:7d',
                                                              'mtu': 1500,
                                                              'name': 'craft 1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '158194168367',
                                                              'out_ucast_pkts': '162145874',
                                                              'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6N2RjcmFmdCAx'},
                                                      {       'admin_up': False,
                                                              'id': '77',
                                                              'mtu': 1500,
                                                              'name': 'craft 2',
                                                              'oper_up': False,
                                                              'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6N2RjcmFmdCAy'}],
                                'manufacturer': 'Calix',
                                'model': 'E7-2',
                                'modules': [       {       'cpu': 12.0,
                                                           'id': '1/1',
                                                           'interfaces': [       {       'admin_up': False,
                                                                                         'id': '110100101',
                                                                                         'mac_address': '4c:43:41:c9:0a:f2',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/q1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGE6ZjIxLzEvcTE='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110100102',
                                                                                         'mac_address': '4c:43:41:c9:0a:f3',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/q2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGE6ZjMxLzEvcTI='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010101',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1313030523',
                                                                                         'in_octets': '996156072069842',
                                                                                         'in_ucast_pkts': '755744926577',
                                                                                         'in_unknown_protos': '0',
                                                                                         'mac_address': '4c:43:41:c9:0a:f4',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01423',
                                                                                         'mtu': 1500,
                                                                                         'name': '1/1/x1',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '26444162',
                                                                                         'out_octets': '112964755706821',
                                                                                         'out_ucast_pkts': '257809756569',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGE6ZjQxLzEveDE=',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110010102',
                                                                                         'mac_address': '4c:43:41:c9:0a:f5',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/x2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGE6ZjUxLzEveDI='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010105',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'in_unknown_protos': '0',
                                                                                         'mac_address': '4c:43:41:c9:0a:f8',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/1/xp1',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGE6ZjgxLzEveHAx',
                                                                                         'pons': [       {       'description': '1/1/xp1',
                                                                                                                 'id': '110010105',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': '1/1/xp1',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYWY4MTEwMDEwMTA1',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010106',
                                                                                         'in_discards': '18',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '4470693',
                                                                                         'in_octets': '7758028879308',
                                                                                         'in_ucast_pkts': '19615981911',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '89128',
                                                                                                                  'in_octets': '33246845174',
                                                                                                                  'in_ucast_pkts': '146081882',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585856',
                                                                                                                  'out_octets': '726144678313',
                                                                                                                  'out_ucast_pkts': '554030525',
                                                                                                                  'poller_hash': 'NzcwQURGcGVlcmludGYxMDkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '124687',
                                                                                                                  'in_octets': '32959581290',
                                                                                                                  'in_ucast_pkts': '106726385',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585902',
                                                                                                                  'out_octets': '336728125830',
                                                                                                                  'out_ucast_pkts': '259096198',
                                                                                                                  'poller_hash': 'NzcwOUVEcGVlcmludGYxMTMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '71418',
                                                                                                                  'in_octets': '265523455930',
                                                                                                                  'in_ucast_pkts': '500462029',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '4259132',
                                                                                                                  'out_octets': '1787685101405',
                                                                                                                  'out_ucast_pkts': '1390969171',
                                                                                                                  'poller_hash': 'RTlEQjc0cGVlcmludGYxMjEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '77',
                                                                                                                  'in_octets': '18365536435',
                                                                                                                  'in_ucast_pkts': '196756146',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585908',
                                                                                                                  'out_octets': '646225227265',
                                                                                                                  'out_ucast_pkts': '437189066',
                                                                                                                  'poller_hash': 'NzUwOTY1cGVlcmludGYxMjUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '51690',
                                                                                                                  'in_octets': '10103226716',
                                                                                                                  'in_ucast_pkts': '13672947',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585912',
                                                                                                                  'out_octets': '5865305397',
                                                                                                                  'out_ucast_pkts': '8625105',
                                                                                                                  'poller_hash': 'NzUwQkI1cGVlcmludGYxNjQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28773',
                                                                                                                  'in_octets': '28089627942',
                                                                                                                  'in_ucast_pkts': '96376523',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585808',
                                                                                                                  'out_octets': '743717629939',
                                                                                                                  'out_ucast_pkts': '558437187',
                                                                                                                  'poller_hash': 'NzcwNzU2cGVlcmludGYyMzgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28960',
                                                                                                                  'in_octets': '221296034906',
                                                                                                                  'in_ucast_pkts': '1113450537',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585906',
                                                                                                                  'out_octets': '1894658795578',
                                                                                                                  'out_ucast_pkts': '1707577099',
                                                                                                                  'poller_hash': 'NzcwQUU0cGVlcmludGYyNzAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '156528',
                                                                                                                  'in_octets': '118892698577',
                                                                                                                  'in_ucast_pkts': '461250996',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '8553119',
                                                                                                                  'out_octets': '2336934936327',
                                                                                                                  'out_ucast_pkts': '1652314350',
                                                                                                                  'poller_hash': 'RTlEQjM0cGVlcmludGYyODAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '25',
                                                                                                                  'in_octets': '66743900',
                                                                                                                  'in_ucast_pkts': '273097',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585907',
                                                                                                                  'out_octets': '125698221',
                                                                                                                  'out_ucast_pkts': '267169',
                                                                                                                  'poller_hash': 'NzcwQTUxcGVlcmludGYyODQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28900',
                                                                                                                  'in_octets': '181061551',
                                                                                                                  'in_ucast_pkts': '473349',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585899',
                                                                                                                  'out_octets': '180380666',
                                                                                                                  'out_ucast_pkts': '427584',
                                                                                                                  'poller_hash': 'NzcwQUQycGVlcmludGYyODcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28675',
                                                                                                                  'in_octets': '52298183490',
                                                                                                                  'in_ucast_pkts': '121251941',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585912',
                                                                                                                  'out_octets': '469930548169',
                                                                                                                  'out_ucast_pkts': '365266292',
                                                                                                                  'poller_hash': 'OEUyNjREcGVlcmludGYyOTIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1487663',
                                                                                                                  'in_octets': '1606870085144',
                                                                                                                  'in_ucast_pkts': '2934472138',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '6449844',
                                                                                                                  'out_octets': '9534074697526',
                                                                                                                  'out_ucast_pkts': '7065830831',
                                                                                                                  'poller_hash': 'NzUwODkwcGVlcmludGYyOTcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '25',
                                                                                                                  'in_octets': '41141065285',
                                                                                                                  'in_ucast_pkts': '121088619',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585906',
                                                                                                                  'out_octets': '796111715459',
                                                                                                                  'out_ucast_pkts': '564992574',
                                                                                                                  'poller_hash': 'NzUwOTlFcGVlcmludGYzMzcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '25',
                                                                                                                  'in_octets': '20637824288',
                                                                                                                  'in_ucast_pkts': '93405579',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585904',
                                                                                                                  'out_octets': '620355746563',
                                                                                                                  'out_ucast_pkts': '442104327',
                                                                                                                  'poller_hash': 'NzcwQTJEcGVlcmludGYzNDAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28811',
                                                                                                                  'in_octets': '9955363287',
                                                                                                                  'in_ucast_pkts': '29234130',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585899',
                                                                                                                  'out_octets': '151655070611',
                                                                                                                  'out_ucast_pkts': '116761139',
                                                                                                                  'poller_hash': 'NzUwOUJEcGVlcmludGYzNDMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '49544',
                                                                                                                  'in_octets': '25812150584',
                                                                                                                  'in_ucast_pkts': '153656566',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '2719537',
                                                                                                                  'out_octets': '897992955609',
                                                                                                                  'out_ucast_pkts': '657702708',
                                                                                                                  'poller_hash': 'RTlEQzQ1cGVlcmludGYzNjMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '16326',
                                                                                                                  'in_octets': '87552833814',
                                                                                                                  'in_ucast_pkts': '133344972',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585906',
                                                                                                                  'out_octets': '817383681464',
                                                                                                                  'out_ucast_pkts': '603930244',
                                                                                                                  'poller_hash': 'MzYwNTM4cGVlcmludGY0My9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '67863',
                                                                                                                  'in_octets': '688055262141',
                                                                                                                  'in_ucast_pkts': '1125897567',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '10162261',
                                                                                                                  'out_octets': '4067818380880',
                                                                                                                  'out_ucast_pkts': '3230496736',
                                                                                                                  'poller_hash': 'RTlEQUEwcGVlcmludGY1MC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '22',
                                                                                                                  'in_octets': '74275275083',
                                                                                                                  'in_ucast_pkts': '108962787',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585900',
                                                                                                                  'out_octets': '295062214093',
                                                                                                                  'out_ucast_pkts': '241161118',
                                                                                                                  'poller_hash': 'NzcwQUJEcGVlcmludGY2NS9ncDE='}],
                                                                                         'mac_address': '4c:43:41:c9:0a:f9',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/1/xp2',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '447511',
                                                                                         'out_octets': '74950830675963',
                                                                                         'out_ucast_pkts': '56761608836',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGE6ZjkxLzEveHAy',
                                                                                         'pons': [       {       'description': '1/1/xp2',
                                                                                                                 'id': '110010106',
                                                                                                                 'links': [       {       'connected_time': '3171546',
                                                                                                                                          'fiber_length': 1122,
                                                                                                                                          'poller_hash': 'NzcwQURGcGVlcnBvbjEwOS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.74448},
                                                                                                                                  {       'connected_time': '3171531',
                                                                                                                                          'fiber_length': 1224,
                                                                                                                                          'poller_hash': 'NzcwOUVEcGVlcnBvbjExMy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.74448},
                                                                                                                                  {       'connected_time': '8516859',
                                                                                                                                          'fiber_length': 1530,
                                                                                                                                          'poller_hash': 'RTlEQjc0cGVlcnBvbjEyMS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.74448},
                                                                                                                                  {       'connected_time': '3171545',
                                                                                                                                          'fiber_length': 1122,
                                                                                                                                          'poller_hash': 'NzUwOTY1cGVlcnBvbjEyNS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.74448},
                                                                                                                                  {       'connected_time': '3171548',
                                                                                                                                          'fiber_length': 1530,
                                                                                                                                          'poller_hash': 'NzUwQkI1cGVlcnBvbjE2NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.74448},
                                                                                                                                  {       'connected_time': '3171538',
                                                                                                                                          'fiber_length': 1122,
                                                                                                                                          'poller_hash': 'NzcwNzU2cGVlcnBvbjIzOC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.74448},
                                                                                                                                  {       'connected_time': '3171555',
                                                                                                                                          'fiber_length': 1224,
                                                                                                                                          'poller_hash': 'NzcwQUU0cGVlcnBvbjI3MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.74448},
                                                                                                                                  {       'connected_time': '17102566',
                                                                                                                                          'fiber_length': 1122,
                                                                                                                                          'poller_hash': 'RTlEQjM0cGVlcnBvbjI4MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.74448},
                                                                                                                                  {       'connected_time': '3171564',
                                                                                                                                          'fiber_length': 1530,
                                                                                                                                          'poller_hash': 'NzcwQTUxcGVlcnBvbjI4NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.74448},
                                                                                                                                  {       'connected_time': '3171559',
                                                                                                                                          'fiber_length': 1428,
                                                                                                                                          'poller_hash': 'NzcwQUQycGVlcnBvbjI4Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.74448},
                                                                                                                                  {       'connected_time': '3171557',
                                                                                                                                          'fiber_length': 1428,
                                                                                                                                          'poller_hash': 'OEUyNjREcGVlcnBvbjI5Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.74448},
                                                                                                                                  {       'connected_time': '12824707',
                                                                                                                                          'fiber_length': 1224,
                                                                                                                                          'poller_hash': 'NzUwODkwcGVlcnBvbjI5Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.74448},
                                                                                                                                  {       'connected_time': '3171566',
                                                                                                                                          'fiber_length': 1122,
                                                                                                                                          'poller_hash': 'NzUwOTlFcGVlcnBvbjMzNy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.74448},
                                                                                                                                  {       'connected_time': '3171559',
                                                                                                                                          'fiber_length': 1122,
                                                                                                                                          'poller_hash': 'NzcwQTJEcGVlcnBvbjM0MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.74448},
                                                                                                                                  {       'connected_time': '3171556',
                                                                                                                                          'fiber_length': 1428,
                                                                                                                                          'poller_hash': 'NzUwOUJEcGVlcnBvbjM0My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.74448},
                                                                                                                                  {       'connected_time': '5438078',
                                                                                                                                          'fiber_length': 1122,
                                                                                                                                          'poller_hash': 'RTlEQzQ1cGVlcnBvbjM2My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.74448},
                                                                                                                                  {       'connected_time': '3171553',
                                                                                                                                          'fiber_length': 1530,
                                                                                                                                          'poller_hash': 'MzYwNTM4cGVlcnBvbjQzL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.74448},
                                                                                                                                  {       'connected_time': '20310055',
                                                                                                                                          'fiber_length': 1122,
                                                                                                                                          'poller_hash': 'RTlEQUEwcGVlcnBvbjUwL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.74448},
                                                                                                                                  {       'connected_time': '3171539',
                                                                                                                                          'fiber_length': 1530,
                                                                                                                                          'poller_hash': 'NzcwQUJEcGVlcnBvbjY1L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.74448}],
                                                                                                                 'max_distance': 60000,
                                                                                                                 'name': '1/1/xp2',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYWY5MTEwMDEwMTA2',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010107',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'in_unknown_protos': '0',
                                                                                         'mac_address': '4c:43:41:c9:0a:fa',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/1/xp3',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGE6ZmExLzEveHAz',
                                                                                         'pons': [       {       'description': '1/1/xp3',
                                                                                                                 'id': '110010107',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': '1/1/xp3',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYWZhMTEwMDEwMTA3',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010108',
                                                                                         'in_discards': '6',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '24896',
                                                                                         'in_octets': '67970234504',
                                                                                         'in_ucast_pkts': '180213382',
                                                                                         'in_unknown_protos': '0',
                                                                                         'mac_address': '4c:43:41:c9:0a:fb',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/1/xp4',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '46507',
                                                                                         'out_octets': '623213508344',
                                                                                         'out_ucast_pkts': '466743035',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGE6ZmIxLzEveHA0',
                                                                                         'pons': [       {       'description': '1/1/xp4',
                                                                                                                 'id': '110010108',
                                                                                                                 'max_distance': 60000,
                                                                                                                 'name': '1/1/xp4',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYWZiMTEwMDEwMTA4',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010109',
                                                                                         'in_discards': '178',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '77862',
                                                                                         'in_octets': '473667823872',
                                                                                         'in_ucast_pkts': '1309913849',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '30',
                                                                                                                  'in_nucast_pkts': '9987',
                                                                                                                  'in_octets': '211618530879',
                                                                                                                  'in_ucast_pkts': '637023957',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '811',
                                                                                                                  'out_octets': '4535490995984',
                                                                                                                  'out_ucast_pkts': '3296237390',
                                                                                                                  'poller_hash': 'MUE2NDFFRXBlZXJpbnRmMzk3L2dwMQ=='},
                                                                                                          {       'in_errors': '1',
                                                                                                                  'in_nucast_pkts': '64691',
                                                                                                                  'in_octets': '34668790443',
                                                                                                                  'in_ucast_pkts': '107933419',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '162',
                                                                                                                  'out_octets': '537142540439',
                                                                                                                  'out_ucast_pkts': '396913166',
                                                                                                                  'poller_hash': 'MUE2NDFEQnBlZXJpbnRmNDEyL2dwMQ=='}],
                                                                                         'mac_address': '4c:43:41:c9:0a:fc',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/1/xp5',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '2256',
                                                                                         'out_octets': '7899949141842',
                                                                                         'out_ucast_pkts': '5737966882',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGE6ZmMxLzEveHA1',
                                                                                         'pons': [       {       'description': '1/1/xp5',
                                                                                                                 'id': '110010109',
                                                                                                                 'links': [       {       'connected_time': '9221259',
                                                                                                                                          'fiber_length': 2550,
                                                                                                                                          'poller_hash': 'MUE2NDFFRXBlZXJwb24zOTcvZ3Ax',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -11.7,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 5.625783},
                                                                                                                                  {       'connected_time': '3171425',
                                                                                                                                          'fiber_length': 2142,
                                                                                                                                          'poller_hash': 'MUE2NDFEQnBlZXJwb240MTIvZ3Ax',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -10.7,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 5.625783}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': '1/1/xp5',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYWZjMTEwMDEwMTA5',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010110',
                                                                                         'in_discards': '130',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1645198',
                                                                                         'in_octets': '11507973788238',
                                                                                         'in_ucast_pkts': '22802440190',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '115771',
                                                                                                                  'in_octets': '18363853795',
                                                                                                                  'in_ucast_pkts': '50202026',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585898',
                                                                                                                  'out_octets': '172042928636',
                                                                                                                  'out_ucast_pkts': '140008972',
                                                                                                                  'poller_hash': 'NzUwN0Y5cGVlcmludGYxMjgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '23',
                                                                                                                  'in_octets': '2267346251',
                                                                                                                  'in_ucast_pkts': '8556459',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '39511',
                                                                                                                  'out_octets': '55159650796',
                                                                                                                  'out_ucast_pkts': '39111790',
                                                                                                                  'poller_hash': 'NzcwOUEycGVlcmludGYxNjIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '22',
                                                                                                                  'in_octets': '34981918713',
                                                                                                                  'in_ucast_pkts': '135921228',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585899',
                                                                                                                  'out_octets': '1049222285949',
                                                                                                                  'out_ucast_pkts': '780002877',
                                                                                                                  'poller_hash': 'NzUwRDJEcGVlcmludGYxNjUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '26',
                                                                                                                  'in_octets': '69005994085',
                                                                                                                  'in_ucast_pkts': '224535340',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585885',
                                                                                                                  'out_octets': '959209496250',
                                                                                                                  'out_ucast_pkts': '704061423',
                                                                                                                  'poller_hash': 'QTM3M0NGcGVlcmludGYxNy9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '24',
                                                                                                                  'in_octets': '15382275738',
                                                                                                                  'in_ucast_pkts': '54844138',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585903',
                                                                                                                  'out_octets': '149925851388',
                                                                                                                  'out_ucast_pkts': '125233673',
                                                                                                                  'poller_hash': 'NzU5NEJEcGVlcmludGYyMzkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28101',
                                                                                                                  'in_octets': '119241691522',
                                                                                                                  'in_ucast_pkts': '368954978',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585889',
                                                                                                                  'out_octets': '1481140483257',
                                                                                                                  'out_ucast_pkts': '1073237032',
                                                                                                                  'poller_hash': 'QjNBODNCcGVlcmludGYyNDYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '18',
                                                                                                                  'in_octets': '1609181240',
                                                                                                                  'in_ucast_pkts': '4969977',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585911',
                                                                                                                  'out_octets': '7623437205',
                                                                                                                  'out_ucast_pkts': '6973252',
                                                                                                                  'poller_hash': 'NzcwQUI3cGVlcmludGYyNS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28919',
                                                                                                                  'in_octets': '3473894643',
                                                                                                                  'in_ucast_pkts': '16773835',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585891',
                                                                                                                  'out_octets': '135318214209',
                                                                                                                  'out_ucast_pkts': '101538553',
                                                                                                                  'poller_hash': 'OEUyNkUwcGVlcmludGYyNjUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '77633',
                                                                                                                  'in_octets': '118439967918',
                                                                                                                  'in_ucast_pkts': '435969821',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585639',
                                                                                                                  'out_octets': '2566490137082',
                                                                                                                  'out_ucast_pkts': '1782376687',
                                                                                                                  'poller_hash': 'NzcwQUQ1cGVlcmludGYyNzQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '19',
                                                                                                                  'in_octets': '4172982134762',
                                                                                                                  'in_ucast_pkts': '2940329667',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585868',
                                                                                                                  'out_octets': '750657593586',
                                                                                                                  'out_ucast_pkts': '1833176779',
                                                                                                                  'poller_hash': 'NzcwQTdFcGVlcmludGYyODEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28767',
                                                                                                                  'in_octets': '27664635586',
                                                                                                                  'in_ucast_pkts': '29535739',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585904',
                                                                                                                  'out_octets': '93303312097',
                                                                                                                  'out_ucast_pkts': '73751543',
                                                                                                                  'poller_hash': 'NzcwQTMzcGVlcmludGYyOTQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28889',
                                                                                                                  'in_octets': '14346156974',
                                                                                                                  'in_ucast_pkts': '40297735',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585908',
                                                                                                                  'out_octets': '75856629448',
                                                                                                                  'out_ucast_pkts': '63942493',
                                                                                                                  'poller_hash': 'NzUwODJDcGVlcmludGYyOTkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '25',
                                                                                                                  'in_octets': '86972343013',
                                                                                                                  'in_ucast_pkts': '115445926',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585892',
                                                                                                                  'out_octets': '220564767946',
                                                                                                                  'out_ucast_pkts': '174882292',
                                                                                                                  'poller_hash': 'NzcwQTMwcGVlcmludGYzMDYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '69726',
                                                                                                                  'in_octets': '1737704141',
                                                                                                                  'in_ucast_pkts': '3013213',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585882',
                                                                                                                  'out_octets': '2208166093',
                                                                                                                  'out_ucast_pkts': '3200123',
                                                                                                                  'poller_hash': 'NzcwQUJDcGVlcmludGYzMTQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '22',
                                                                                                                  'in_octets': '2176755776',
                                                                                                                  'in_ucast_pkts': '7305311',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585909',
                                                                                                                  'out_octets': '35715470727',
                                                                                                                  'out_ucast_pkts': '27859963',
                                                                                                                  'poller_hash': 'OEUyNUY5cGVlcmludGYzMTYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '21',
                                                                                                                  'in_octets': '10280338669',
                                                                                                                  'in_ucast_pkts': '14677202',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585908',
                                                                                                                  'out_octets': '10105917785',
                                                                                                                  'out_ucast_pkts': '11741218',
                                                                                                                  'poller_hash': 'NzUwOEEzcGVlcmludGYzMjQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '780',
                                                                                                                  'in_octets': '855389078',
                                                                                                                  'in_ucast_pkts': '4201473',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '40861',
                                                                                                                  'out_octets': '31424517030',
                                                                                                                  'out_ucast_pkts': '22751184',
                                                                                                                  'poller_hash': 'OEUyNjdFcGVlcmludGYzMzEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '17103',
                                                                                                                  'in_octets': '88185133016',
                                                                                                                  'in_ucast_pkts': '241702588',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585800',
                                                                                                                  'out_octets': '1033886480193',
                                                                                                                  'out_ucast_pkts': '799354225',
                                                                                                                  'poller_hash': 'NzUwOTU3cGVlcmludGYzNjcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28899',
                                                                                                                  'in_octets': '47496568428',
                                                                                                                  'in_ucast_pkts': '118352718',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585892',
                                                                                                                  'out_octets': '875576125326',
                                                                                                                  'out_ucast_pkts': '622876121',
                                                                                                                  'poller_hash': 'OEUyNjFCcGVlcmludGY1Ni9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '84311',
                                                                                                                  'in_octets': '27082438233',
                                                                                                                  'in_ucast_pkts': '80646819',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585792',
                                                                                                                  'out_octets': '285941228489',
                                                                                                                  'out_ucast_pkts': '225358404',
                                                                                                                  'poller_hash': 'NzcwOUYxcGVlcmludGY1OS9ncDE='}],
                                                                                         'mac_address': '4c:43:41:c9:0a:fd',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/1/xp6',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '167930',
                                                                                         'out_octets': '100265627323352',
                                                                                         'out_ucast_pkts': '74358865806',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGE6ZmQxLzEveHA2',
                                                                                         'pons': [       {       'description': '1/1/xp6',
                                                                                                                 'id': '110010110',
                                                                                                                 'links': [       {       'connected_time': '3171523',
                                                                                                                                          'fiber_length': 2550,
                                                                                                                                          'poller_hash': 'NzUwN0Y5cGVlcnBvbjEyOC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413},
                                                                                                                                  {       'connected_time': '79059',
                                                                                                                                          'fiber_length': 2448,
                                                                                                                                          'poller_hash': 'NzcwOUEycGVlcnBvbjE2Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413},
                                                                                                                                  {       'connected_time': '3171533',
                                                                                                                                          'fiber_length': 2550,
                                                                                                                                          'poller_hash': 'NzUwRDJEcGVlcnBvbjE2NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -26.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413},
                                                                                                                                  {       'connected_time': '3171552',
                                                                                                                                          'fiber_length': 2448,
                                                                                                                                          'poller_hash': 'QTM3M0NGcGVlcnBvbjE3L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413},
                                                                                                                                  {       'connected_time': '3171549',
                                                                                                                                          'fiber_length': 2550,
                                                                                                                                          'poller_hash': 'NzU5NEJEcGVlcnBvbjIzOS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413},
                                                                                                                                  {       'connected_time': '3171532',
                                                                                                                                          'fiber_length': 2346,
                                                                                                                                          'poller_hash': 'QjNBODNCcGVlcnBvbjI0Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413},
                                                                                                                                  {       'connected_time': '3171547',
                                                                                                                                          'fiber_length': 2040,
                                                                                                                                          'poller_hash': 'NzcwQUI3cGVlcnBvbjI1L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413},
                                                                                                                                  {       'connected_time': '3171541',
                                                                                                                                          'fiber_length': 2550,
                                                                                                                                          'poller_hash': 'OEUyNkUwcGVlcnBvbjI2NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -27.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413},
                                                                                                                                  {       'connected_time': '3171535',
                                                                                                                                          'fiber_length': 2040,
                                                                                                                                          'poller_hash': 'NzcwQUQ1cGVlcnBvbjI3NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413},
                                                                                                                                  {       'connected_time': '3171461',
                                                                                                                                          'fiber_length': 2346,
                                                                                                                                          'poller_hash': 'NzcwQTdFcGVlcnBvbjI4MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -28.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413},
                                                                                                                                  {       'connected_time': '3171541',
                                                                                                                                          'fiber_length': 2142,
                                                                                                                                          'poller_hash': 'NzcwQTMzcGVlcnBvbjI5NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413},
                                                                                                                                  {       'connected_time': '3171560',
                                                                                                                                          'fiber_length': 2550,
                                                                                                                                          'poller_hash': 'NzUwODJDcGVlcnBvbjI5OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413},
                                                                                                                                  {       'connected_time': '3171539',
                                                                                                                                          'fiber_length': 2550,
                                                                                                                                          'poller_hash': 'NzcwQTMwcGVlcnBvbjMwNi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413},
                                                                                                                                  {       'connected_time': '3171516',
                                                                                                                                          'fiber_length': 2448,
                                                                                                                                          'poller_hash': 'NzcwQUJDcGVlcnBvbjMxNC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413},
                                                                                                                                  {       'connected_time': '3171562',
                                                                                                                                          'fiber_length': 2142,
                                                                                                                                          'poller_hash': 'OEUyNUY5cGVlcnBvbjMxNi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413},
                                                                                                                                  {       'connected_time': '3171550',
                                                                                                                                          'fiber_length': 2550,
                                                                                                                                          'poller_hash': 'NzUwOEEzcGVlcnBvbjMyNC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413},
                                                                                                                                  {       'connected_time': '81766',
                                                                                                                                          'fiber_length': 2448,
                                                                                                                                          'poller_hash': 'OEUyNjdFcGVlcnBvbjMzMS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413},
                                                                                                                                  {       'connected_time': '3171540',
                                                                                                                                          'fiber_length': 2040,
                                                                                                                                          'poller_hash': 'NzUwOTU3cGVlcnBvbjM2Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413},
                                                                                                                                  {       'connected_time': '3171546',
                                                                                                                                          'fiber_length': 2142,
                                                                                                                                          'poller_hash': 'OEUyNjFCcGVlcnBvbjU2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413},
                                                                                                                                  {       'connected_time': '3171558',
                                                                                                                                          'fiber_length': 2550,
                                                                                                                                          'poller_hash': 'NzcwOUYxcGVlcnBvbjU5L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.906413}],
                                                                                                                 'max_distance': 60000,
                                                                                                                 'name': '1/1/xp6',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYWZkMTEwMDEwMTEw',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010111',
                                                                                         'in_discards': '4793',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '135270',
                                                                                         'in_octets': '677989595385',
                                                                                         'in_ucast_pkts': '1619383227',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '3',
                                                                                                                  'in_nucast_pkts': '24922',
                                                                                                                  'in_octets': '43474133206',
                                                                                                                  'in_ucast_pkts': '181094612',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '66',
                                                                                                                  'out_octets': '741576105679',
                                                                                                                  'out_ucast_pkts': '555852674',
                                                                                                                  'poller_hash': 'MUE2NDFERnBlZXJpbnRmNDA0L2dwMQ=='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '12',
                                                                                                                  'in_octets': '18338711282',
                                                                                                                  'in_ucast_pkts': '24611487',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '16',
                                                                                                                  'out_octets': '47692036711',
                                                                                                                  'out_ucast_pkts': '40381946',
                                                                                                                  'poller_hash': 'MUE2NDRCN3BlZXJpbnRmNDA3L2dwMQ=='}],
                                                                                         'mac_address': '4c:43:41:c9:0a:fe',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/1/xp7',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '2822',
                                                                                         'out_octets': '5548569509061',
                                                                                         'out_ucast_pkts': '4314898716',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGE6ZmUxLzEveHA3',
                                                                                         'pons': [       {       'description': '1/1/xp7',
                                                                                                                 'id': '110010111',
                                                                                                                 'links': [       {       'connected_time': '1888690',
                                                                                                                                          'fiber_length': 2040,
                                                                                                                                          'poller_hash': 'MUE2NDFERnBlZXJwb240MDQvZ3Ax',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 5.596912},
                                                                                                                                  {       'connected_time': '605874',
                                                                                                                                          'fiber_length': 1734,
                                                                                                                                          'poller_hash': 'MUE2NDRCN3BlZXJwb240MDcvZ3Ax',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 5.596912}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': '1/1/xp7',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYWZlMTEwMDEwMTEx',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010112',
                                                                                         'in_discards': '53',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1909859',
                                                                                         'in_octets': '6204041558978',
                                                                                         'in_ucast_pkts': '14554421250',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28759',
                                                                                                                  'in_octets': '54585556905',
                                                                                                                  'in_ucast_pkts': '103101015',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585895',
                                                                                                                  'out_octets': '524228092095',
                                                                                                                  'out_ucast_pkts': '385818638',
                                                                                                                  'poller_hash': 'NzUwODQwcGVlcmludGYxMDQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '24',
                                                                                                                  'in_octets': '104065054128',
                                                                                                                  'in_ucast_pkts': '186228556',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585886',
                                                                                                                  'out_octets': '505294566696',
                                                                                                                  'out_ucast_pkts': '406601010',
                                                                                                                  'poller_hash': 'NzcwOEZFcGVlcmludGYxNi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '24',
                                                                                                                  'in_octets': '89457212383',
                                                                                                                  'in_ucast_pkts': '206820142',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585897',
                                                                                                                  'out_octets': '1758557235482',
                                                                                                                  'out_ucast_pkts': '1297650512',
                                                                                                                  'poller_hash': 'N0EwNzI4cGVlcmludGYxODAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '9',
                                                                                                                  'in_octets': '77447682866',
                                                                                                                  'in_ucast_pkts': '188275632',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585905',
                                                                                                                  'out_octets': '1116131033051',
                                                                                                                  'out_ucast_pkts': '832480912',
                                                                                                                  'poller_hash': 'RTlEQkUwcGVlcmludGYyMTkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28701',
                                                                                                                  'in_octets': '41209962212',
                                                                                                                  'in_ucast_pkts': '161770010',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585900',
                                                                                                                  'out_octets': '583095681105',
                                                                                                                  'out_ucast_pkts': '425908346',
                                                                                                                  'poller_hash': 'NzUwN0U1cGVlcmludGYyMzAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '22',
                                                                                                                  'in_octets': '83792683222',
                                                                                                                  'in_ucast_pkts': '341612761',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585904',
                                                                                                                  'out_octets': '2030722126994',
                                                                                                                  'out_ucast_pkts': '1498036078',
                                                                                                                  'poller_hash': 'OEUyN0E4cGVlcmludGYyNjMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '27',
                                                                                                                  'in_octets': '7580056338',
                                                                                                                  'in_ucast_pkts': '21900664',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585882',
                                                                                                                  'out_octets': '71754767619',
                                                                                                                  'out_ucast_pkts': '61750709',
                                                                                                                  'poller_hash': 'NzcwQUQzcGVlcmludGYyODIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '184291',
                                                                                                                  'in_octets': '382497104569',
                                                                                                                  'in_ucast_pkts': '477520987',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '10162107',
                                                                                                                  'out_octets': '1049928208335',
                                                                                                                  'out_ucast_pkts': '844450401',
                                                                                                                  'poller_hash': 'RTlEQkREcGVlcmludGYyOTYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28767',
                                                                                                                  'in_octets': '242284981880',
                                                                                                                  'in_ucast_pkts': '316869610',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585845',
                                                                                                                  'out_octets': '872233184455',
                                                                                                                  'out_ucast_pkts': '712723462',
                                                                                                                  'poller_hash': 'NzcwQUQ2cGVlcmludGYyOTgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '21',
                                                                                                                  'in_octets': '25927121233',
                                                                                                                  'in_ucast_pkts': '80079819',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585908',
                                                                                                                  'out_octets': '546162038012',
                                                                                                                  'out_ucast_pkts': '397008768',
                                                                                                                  'poller_hash': 'NzcwQTlEcGVlcmludGYzMDEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '25',
                                                                                                                  'in_octets': '32826962850',
                                                                                                                  'in_ucast_pkts': '96254930',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585896',
                                                                                                                  'out_octets': '703008630068',
                                                                                                                  'out_ucast_pkts': '538950658',
                                                                                                                  'poller_hash': 'NzUwOTZFcGVlcmludGYzMTcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '88389',
                                                                                                                  'in_octets': '291086423178',
                                                                                                                  'in_ucast_pkts': '734427771',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '4838144',
                                                                                                                  'out_octets': '2742329403484',
                                                                                                                  'out_ucast_pkts': '2146705023',
                                                                                                                  'poller_hash': 'RTlEQjlEcGVlcmludGYzMjEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '105281',
                                                                                                                  'in_octets': '20904643059',
                                                                                                                  'in_ucast_pkts': '139945762',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '5773638',
                                                                                                                  'out_octets': '547448784206',
                                                                                                                  'out_ucast_pkts': '380846534',
                                                                                                                  'poller_hash': 'RTlEQjlFcGVlcmludGYzMzIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28815',
                                                                                                                  'in_octets': '8191350328',
                                                                                                                  'in_ucast_pkts': '64143460',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585920',
                                                                                                                  'out_octets': '174520595607',
                                                                                                                  'out_ucast_pkts': '125046697',
                                                                                                                  'poller_hash': 'NzUwRDc0cGVlcmludGYzODkvZ3Ax'},
                                                                                                          {       'in_errors': '272871',
                                                                                                                  'in_nucast_pkts': '120324',
                                                                                                                  'in_octets': '8310408097',
                                                                                                                  'in_ucast_pkts': '29588883',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585899',
                                                                                                                  'out_octets': '100453018673',
                                                                                                                  'out_ucast_pkts': '77596080',
                                                                                                                  'poller_hash': 'NzUwOEY0cGVlcmludGY1NS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '49416',
                                                                                                                  'in_octets': '41103429666',
                                                                                                                  'in_ucast_pkts': '170333348',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585896',
                                                                                                                  'out_octets': '716569142704',
                                                                                                                  'out_ucast_pkts': '509710965',
                                                                                                                  'poller_hash': 'NzcwQTYzcGVlcmludGY3My9ncDE='}],
                                                                                         'mac_address': '4c:43:41:c9:0a:ff',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/1/xp8',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '154551',
                                                                                         'out_octets': '68789263543556',
                                                                                         'out_ucast_pkts': '51316549463',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGE6ZmYxLzEveHA4',
                                                                                         'pons': [       {       'description': '1/1/xp8',
                                                                                                                 'id': '110010112',
                                                                                                                 'links': [       {       'connected_time': '3171538',
                                                                                                                                          'fiber_length': 2856,
                                                                                                                                          'poller_hash': 'NzUwODQwcGVlcnBvbjEwNC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.854156},
                                                                                                                                  {       'connected_time': '3171512',
                                                                                                                                          'fiber_length': 2448,
                                                                                                                                          'poller_hash': 'NzcwOEZFcGVlcnBvbjE2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.854156},
                                                                                                                                  {       'connected_time': '3171537',
                                                                                                                                          'fiber_length': 2754,
                                                                                                                                          'poller_hash': 'N0EwNzI4cGVlcnBvbjE4MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.854156},
                                                                                                                                  {       'connected_time': '3171556',
                                                                                                                                          'fiber_length': 2244,
                                                                                                                                          'poller_hash': 'RTlEQkUwcGVlcnBvbjIxOS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.854156},
                                                                                                                                  {       'connected_time': '3171536',
                                                                                                                                          'fiber_length': 1938,
                                                                                                                                          'poller_hash': 'NzUwN0U1cGVlcnBvbjIzMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -30.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.854156},
                                                                                                                                  {       'connected_time': '3171548',
                                                                                                                                          'fiber_length': 2754,
                                                                                                                                          'poller_hash': 'OEUyN0E4cGVlcnBvbjI2My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.854156},
                                                                                                                                  {       'connected_time': '3171544',
                                                                                                                                          'fiber_length': 1938,
                                                                                                                                          'poller_hash': 'NzcwQUQzcGVlcnBvbjI4Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.854156},
                                                                                                                                  {       'connected_time': '20308919',
                                                                                                                                          'fiber_length': 2652,
                                                                                                                                          'poller_hash': 'RTlEQkREcGVlcnBvbjI5Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.854156},
                                                                                                                                  {       'connected_time': '3171563',
                                                                                                                                          'fiber_length': 2448,
                                                                                                                                          'poller_hash': 'NzcwQUQ2cGVlcnBvbjI5OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.854156},
                                                                                                                                  {       'connected_time': '3171546',
                                                                                                                                          'fiber_length': 2754,
                                                                                                                                          'poller_hash': 'NzcwQTlEcGVlcnBvbjMwMS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.854156},
                                                                                                                                  {       'connected_time': '3171549',
                                                                                                                                          'fiber_length': 2652,
                                                                                                                                          'poller_hash': 'NzUwOTZFcGVlcnBvbjMxNy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.854156},
                                                                                                                                  {       'connected_time': '9673976',
                                                                                                                                          'fiber_length': 2754,
                                                                                                                                          'poller_hash': 'RTlEQjlEcGVlcnBvbjMyMS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.854156},
                                                                                                                                  {       'connected_time': '11544200',
                                                                                                                                          'fiber_length': 2040,
                                                                                                                                          'poller_hash': 'RTlEQjlFcGVlcnBvbjMzMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.854156},
                                                                                                                                  {       'connected_time': '3171568',
                                                                                                                                          'fiber_length': 2040,
                                                                                                                                          'poller_hash': 'NzUwRDc0cGVlcnBvbjM4OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.854156},
                                                                                                                                  {       'connected_time': '3171554',
                                                                                                                                          'fiber_length': 2040,
                                                                                                                                          'poller_hash': 'NzUwOEY0cGVlcnBvbjU1L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.854156},
                                                                                                                                  {       'connected_time': '3171552',
                                                                                                                                          'fiber_length': 1734,
                                                                                                                                          'poller_hash': 'NzcwQTYzcGVlcnBvbjczL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.854156}],
                                                                                                                 'max_distance': 60000,
                                                                                                                 'name': '1/1/xp8',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYWZmMTEwMDEwMTEy',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010113',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'in_unknown_protos': '0',
                                                                                         'mac_address': '4c:43:41:c9:0b:00',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/1/xp9',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6MDAxLzEveHA5',
                                                                                         'pons': [       {       'description': '1/1/xp9',
                                                                                                                 'id': '110010113',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': '1/1/xp9',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYjAwMTEwMDEwMTEz',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010114',
                                                                                         'in_discards': '2',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2337979',
                                                                                         'in_octets': '9333601124653',
                                                                                         'in_ucast_pkts': '19706631433',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '22371',
                                                                                                                  'in_octets': '51001062330',
                                                                                                                  'in_ucast_pkts': '180098488',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585887',
                                                                                                                  'out_octets': '697997546476',
                                                                                                                  'out_ucast_pkts': '554766233',
                                                                                                                  'poller_hash': 'NzUwOTYzcGVlcmludGYxMTIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1498672',
                                                                                                                  'in_octets': '985084363372',
                                                                                                                  'in_ucast_pkts': '1926330096',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '10134710',
                                                                                                                  'out_octets': '8081550496307',
                                                                                                                  'out_ucast_pkts': '6256202477',
                                                                                                                  'poller_hash': 'RTlEQ0MycGVlcmludGYxMzIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28790',
                                                                                                                  'in_octets': '39602120956',
                                                                                                                  'in_ucast_pkts': '100552953',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585902',
                                                                                                                  'out_octets': '486076356510',
                                                                                                                  'out_ucast_pkts': '371970217',
                                                                                                                  'poller_hash': 'OEQ4N0IxcGVlcmludGYyNTAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '7',
                                                                                                                  'in_octets': '27533842308',
                                                                                                                  'in_ucast_pkts': '119571220',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '161365',
                                                                                                                  'out_octets': '517246590528',
                                                                                                                  'out_ucast_pkts': '371704661',
                                                                                                                  'poller_hash': 'NzUwODFDcGVlcmludGYyNjAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '22332',
                                                                                                                  'in_octets': '11020921395',
                                                                                                                  'in_ucast_pkts': '73852305',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1205034',
                                                                                                                  'out_octets': '260370613762',
                                                                                                                  'out_ucast_pkts': '186036686',
                                                                                                                  'poller_hash': 'NzcwQUQ5cGVlcmludGYzMDUvZ3Ax'},
                                                                                                          {       'in_errors': '10277',
                                                                                                                  'in_nucast_pkts': '1582129',
                                                                                                                  'in_octets': '5072130430793',
                                                                                                                  'in_ucast_pkts': '5259406933',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '10162025',
                                                                                                                  'out_octets': '12750487448355',
                                                                                                                  'out_ucast_pkts': '10381398041',
                                                                                                                  'poller_hash': 'RTlERUFDcGVlcmludGYzMjMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '64373',
                                                                                                                  'in_octets': '265577671767',
                                                                                                                  'in_ucast_pkts': '647551374',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '4315718',
                                                                                                                  'out_octets': '2961778052617',
                                                                                                                  'out_ucast_pkts': '2335421263',
                                                                                                                  'poller_hash': 'RTlEQjA5cGVlcmludGYzNjAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '6737',
                                                                                                                  'in_octets': '38080529290',
                                                                                                                  'in_ucast_pkts': '167270735',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '368871',
                                                                                                                  'out_octets': '787614260172',
                                                                                                                  'out_ucast_pkts': '572255518',
                                                                                                                  'poller_hash': 'NzcwQTA3cGVlcmludGY0MTAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '79758',
                                                                                                                  'in_octets': '446422381739',
                                                                                                                  'in_ucast_pkts': '1092047187',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '10011074',
                                                                                                                  'out_octets': '2911539306381',
                                                                                                                  'out_ucast_pkts': '2481081106',
                                                                                                                  'poller_hash': 'RTlEQThBcGVlcmludGY2Mi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '25',
                                                                                                                  'in_octets': '16500133603',
                                                                                                                  'in_ucast_pkts': '69700136',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585888',
                                                                                                                  'out_octets': '166651335237',
                                                                                                                  'out_ucast_pkts': '129766535',
                                                                                                                  'poller_hash': 'NzUwOUU1cGVlcmludGY3MS9ncDE='}],
                                                                                         'mac_address': '4c:43:41:c9:0b:01',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/1/xp10',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '70021',
                                                                                         'out_octets': '80506574766746',
                                                                                         'out_ucast_pkts': '59852327095',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6MDExLzEveHAxMA==',
                                                                                         'pons': [       {       'description': '1/1/xp10',
                                                                                                                 'id': '110010114',
                                                                                                                 'links': [       {       'connected_time': '3171521',
                                                                                                                                          'fiber_length': 2754,
                                                                                                                                          'poller_hash': 'NzUwOTYzcGVlcnBvbjExMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.658951},
                                                                                                                                  {       'connected_time': '20308865',
                                                                                                                                          'fiber_length': 2448,
                                                                                                                                          'poller_hash': 'RTlEQ0MycGVlcnBvbjEzMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.658951},
                                                                                                                                  {       'connected_time': '3171553',
                                                                                                                                          'fiber_length': 2448,
                                                                                                                                          'poller_hash': 'OEQ4N0IxcGVlcnBvbjI1MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.658951},
                                                                                                                                  {       'connected_time': '322763',
                                                                                                                                          'fiber_length': 2448,
                                                                                                                                          'poller_hash': 'NzUwODFDcGVlcnBvbjI2MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.658951},
                                                                                                                                  {       'connected_time': '2409957',
                                                                                                                                          'fiber_length': 2652,
                                                                                                                                          'poller_hash': 'NzcwQUQ5cGVlcnBvbjMwNS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.658951},
                                                                                                                                  {       'connected_time': '20308910',
                                                                                                                                          'fiber_length': 2652,
                                                                                                                                          'poller_hash': 'RTlERUFDcGVlcnBvbjMyMy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.658951},
                                                                                                                                  {       'connected_time': '8629966',
                                                                                                                                          'fiber_length': 2652,
                                                                                                                                          'poller_hash': 'RTlEQjA5cGVlcnBvbjM2MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.658951},
                                                                                                                                  {       'connected_time': '737732',
                                                                                                                                          'fiber_length': 2958,
                                                                                                                                          'poller_hash': 'NzcwQTA3cGVlcnBvbjQxMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.658951},
                                                                                                                                  {       'connected_time': '20013006',
                                                                                                                                          'fiber_length': 2652,
                                                                                                                                          'poller_hash': 'RTlEQThBcGVlcnBvbjYyL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.658951},
                                                                                                                                  {       'connected_time': '3171537',
                                                                                                                                          'fiber_length': 2550,
                                                                                                                                          'poller_hash': 'NzUwOUU1cGVlcnBvbjcxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.658951}],
                                                                                                                 'max_distance': 60000,
                                                                                                                 'name': '1/1/xp10',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYjAxMTEwMDEwMTE0',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010115',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'in_unknown_protos': '0',
                                                                                         'mac_address': '4c:43:41:c9:0b:02',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/1/xp11',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6MDIxLzEveHAxMQ==',
                                                                                         'pons': [       {       'description': '1/1/xp11',
                                                                                                                 'id': '110010115',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': '1/1/xp11',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYjAyMTEwMDEwMTE1',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010116',
                                                                                         'in_discards': '126',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '9452652',
                                                                                         'in_octets': '14505533296126',
                                                                                         'in_ucast_pkts': '28319415643',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '23355',
                                                                                                                  'in_octets': '102221654068',
                                                                                                                  'in_ucast_pkts': '187869989',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585887',
                                                                                                                  'out_octets': '985833509223',
                                                                                                                  'out_ucast_pkts': '723170278',
                                                                                                                  'poller_hash': 'OEQ4NzcwcGVlcmludGYxMzAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1039503',
                                                                                                                  'in_octets': '205130775358',
                                                                                                                  'in_ucast_pkts': '577395422',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '2572953',
                                                                                                                  'out_octets': '4851978453354',
                                                                                                                  'out_ucast_pkts': '3366311829',
                                                                                                                  'poller_hash': 'RTlEQzZDcGVlcmludGYyMDcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '56',
                                                                                                                  'in_octets': '125900907647',
                                                                                                                  'in_ucast_pkts': '569529578',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585877',
                                                                                                                  'out_octets': '3449133854402',
                                                                                                                  'out_ucast_pkts': '2406515046',
                                                                                                                  'poller_hash': 'NzUwOUVCcGVlcmludGYyMjgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '204975',
                                                                                                                  'in_octets': '75989065042',
                                                                                                                  'in_ucast_pkts': '233928109',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '8803843',
                                                                                                                  'out_octets': '791663310453',
                                                                                                                  'out_ucast_pkts': '620377552',
                                                                                                                  'poller_hash': 'NzUwODFFcGVlcmludGYyMzUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '219884',
                                                                                                                  'in_octets': '422549159821',
                                                                                                                  'in_ucast_pkts': '693838089',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585875',
                                                                                                                  'out_octets': '1023690266423',
                                                                                                                  'out_ucast_pkts': '1030194036',
                                                                                                                  'poller_hash': 'NzUwODIwcGVlcmludGYyNTEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '73317',
                                                                                                                  'in_octets': '491286157086',
                                                                                                                  'in_ucast_pkts': '4089564090',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '9642877',
                                                                                                                  'out_octets': '11834290510542',
                                                                                                                  'out_ucast_pkts': '8279779401',
                                                                                                                  'poller_hash': 'RTlEQjMxcGVlcmludGYyNTIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '29491',
                                                                                                                  'in_octets': '69458840696',
                                                                                                                  'in_ucast_pkts': '155250571',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585880',
                                                                                                                  'out_octets': '462493660726',
                                                                                                                  'out_ucast_pkts': '373428305',
                                                                                                                  'poller_hash': 'NzUwOTJBcGVlcmludGYyODUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '752',
                                                                                                                  'in_octets': '668881148',
                                                                                                                  'in_ucast_pkts': '3801622',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '39033',
                                                                                                                  'out_octets': '15164751984',
                                                                                                                  'out_ucast_pkts': '10775827',
                                                                                                                  'poller_hash': 'RTlEQThEcGVlcmludGYyODgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '69',
                                                                                                                  'in_octets': '100491894247',
                                                                                                                  'in_ucast_pkts': '291334043',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585883',
                                                                                                                  'out_octets': '1403282015364',
                                                                                                                  'out_ucast_pkts': '1084972347',
                                                                                                                  'poller_hash': 'QzBFNUZFcGVlcmludGYzMDMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '2309',
                                                                                                                  'in_octets': '76444240147',
                                                                                                                  'in_ucast_pkts': '83972057',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '125632',
                                                                                                                  'out_octets': '80002774106',
                                                                                                                  'out_ucast_pkts': '59598282',
                                                                                                                  'poller_hash': 'OEQ4N0I5cGVlcmludGYzMTAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28860',
                                                                                                                  'in_octets': '56901157924',
                                                                                                                  'in_ucast_pkts': '190839197',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585890',
                                                                                                                  'out_octets': '1419437306099',
                                                                                                                  'out_ucast_pkts': '1001241248',
                                                                                                                  'poller_hash': 'OEQ4N0NEcGVlcmludGYzNDIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '2',
                                                                                                                  'in_octets': '3920333565',
                                                                                                                  'in_ucast_pkts': '8840998',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '171284',
                                                                                                                  'out_octets': '15674204255',
                                                                                                                  'out_ucast_pkts': '14779658',
                                                                                                                  'poller_hash': 'NzU5NEZEcGVlcmludGYzNDkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '61',
                                                                                                                  'in_octets': '134919075544',
                                                                                                                  'in_ucast_pkts': '212628396',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585892',
                                                                                                                  'out_octets': '760579690601',
                                                                                                                  'out_ucast_pkts': '589174543',
                                                                                                                  'poller_hash': 'OEQ4N0M2cGVlcmludGYzNjEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '29076',
                                                                                                                  'in_octets': '17144239013',
                                                                                                                  'in_ucast_pkts': '63421835',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585890',
                                                                                                                  'out_octets': '609510622832',
                                                                                                                  'out_ucast_pkts': '427908119',
                                                                                                                  'poller_hash': 'NzcwQTcwcGVlcmludGY5OC9ncDE='}],
                                                                                         'mac_address': '4c:43:41:c9:0b:03',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/1/xp12',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '380005',
                                                                                         'out_octets': '104272328624904',
                                                                                         'out_ucast_pkts': '77134673476',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6MDMxLzEveHAxMg==',
                                                                                         'pons': [       {       'description': '1/1/xp12',
                                                                                                                 'id': '110010116',
                                                                                                                 'links': [       {       'connected_time': '3171546',
                                                                                                                                          'fiber_length': 3774,
                                                                                                                                          'poller_hash': 'OEQ4NzcwcGVlcnBvbjEzMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.732663},
                                                                                                                                  {       'connected_time': '5144951',
                                                                                                                                          'fiber_length': 17136,
                                                                                                                                          'poller_hash': 'RTlEQzZDcGVlcnBvbjIwNy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.732663},
                                                                                                                                  {       'connected_time': '3171536',
                                                                                                                                          'fiber_length': 4182,
                                                                                                                                          'poller_hash': 'NzUwOUVCcGVlcnBvbjIyOC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -26.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.732663},
                                                                                                                                  {       'connected_time': '17700355',
                                                                                                                                          'fiber_length': 3468,
                                                                                                                                          'poller_hash': 'NzUwODFFcGVlcnBvbjIzNS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.732663},
                                                                                                                                  {       'connected_time': '3171548',
                                                                                                                                          'fiber_length': 3570,
                                                                                                                                          'poller_hash': 'NzUwODIwcGVlcnBvbjI1MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.732663},
                                                                                                                                  {       'connected_time': '20308790',
                                                                                                                                          'fiber_length': 3672,
                                                                                                                                          'poller_hash': 'RTlEQjMxcGVlcnBvbjI1Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.732663},
                                                                                                                                  {       'connected_time': '3171536',
                                                                                                                                          'fiber_length': 4386,
                                                                                                                                          'poller_hash': 'NzUwOTJBcGVlcnBvbjI4NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.732663},
                                                                                                                                  {       'connected_time': '78108',
                                                                                                                                          'fiber_length': 4080,
                                                                                                                                          'poller_hash': 'RTlEQThEcGVlcnBvbjI4OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.732663},
                                                                                                                                  {       'connected_time': '3171553',
                                                                                                                                          'fiber_length': 3876,
                                                                                                                                          'poller_hash': 'QzBFNUZFcGVlcnBvbjMwMy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.732663},
                                                                                                                                  {       'connected_time': '251295',
                                                                                                                                          'fiber_length': 3774,
                                                                                                                                          'poller_hash': 'OEQ4N0I5cGVlcnBvbjMxMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.732663},
                                                                                                                                  {       'connected_time': '3171547',
                                                                                                                                          'fiber_length': 3876,
                                                                                                                                          'poller_hash': 'OEQ4N0NEcGVlcnBvbjM0Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.732663},
                                                                                                                                  {       'connected_time': '333765',
                                                                                                                                          'fiber_length': 4488,
                                                                                                                                          'poller_hash': 'NzU5NEZEcGVlcnBvbjM0OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.732663},
                                                                                                                                  {       'connected_time': '3171556',
                                                                                                                                          'fiber_length': 3876,
                                                                                                                                          'poller_hash': 'OEQ4N0M2cGVlcnBvbjM2MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.732663},
                                                                                                                                  {       'connected_time': '3171557',
                                                                                                                                          'fiber_length': 3570,
                                                                                                                                          'poller_hash': 'NzcwQTcwcGVlcnBvbjk4L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.732663}],
                                                                                                                 'max_distance': 60000,
                                                                                                                 'name': '1/1/xp12',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYjAzMTEwMDEwMTE2',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010117',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '11608',
                                                                                         'in_octets': '1223363858',
                                                                                         'in_ucast_pkts': '1403515',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '2',
                                                                                                                  'in_nucast_pkts': '11592',
                                                                                                                  'in_octets': '1212043484',
                                                                                                                  'in_ucast_pkts': '1403521',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '49',
                                                                                                                  'out_octets': '2313784313',
                                                                                                                  'out_ucast_pkts': '1867047',
                                                                                                                  'poller_hash': 'MUE2QTcxOHBlZXJpbnRmNDE5L2dwMQ=='}],
                                                                                         'mac_address': '4c:43:41:c9:0b:04',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/1/xp13',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '49',
                                                                                         'out_octets': '2328739864',
                                                                                         'out_ucast_pkts': '1867080',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6MDQxLzEveHAxMw==',
                                                                                         'pons': [       {       'description': '1/1/xp13',
                                                                                                                 'id': '110010117',
                                                                                                                 'links': [       {       'connected_time': '1358366',
                                                                                                                                          'fiber_length': 4080,
                                                                                                                                          'poller_hash': 'MUE2QTcxOHBlZXJwb240MTkvZ3Ax',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -12.7,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 5.61483}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': '1/1/xp13',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYjA0MTEwMDEwMTE3',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010118',
                                                                                         'in_discards': '10',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '4283166',
                                                                                         'in_octets': '4756517830029',
                                                                                         'in_ucast_pkts': '13626836880',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '21',
                                                                                                                  'in_octets': '36399516980',
                                                                                                                  'in_ucast_pkts': '75920426',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585904',
                                                                                                                  'out_octets': '334149932850',
                                                                                                                  'out_ucast_pkts': '259650023',
                                                                                                                  'poller_hash': 'NzUwN0M1cGVlcmludGYxNTQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '80018',
                                                                                                                  'in_octets': '52005700269',
                                                                                                                  'in_ucast_pkts': '387727999',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585892',
                                                                                                                  'out_octets': '2052991636945',
                                                                                                                  'out_ucast_pkts': '1417960773',
                                                                                                                  'poller_hash': 'NzUwRDY0cGVlcmludGYyMDIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '9',
                                                                                                                  'in_octets': '678502836',
                                                                                                                  'in_ucast_pkts': '2201083',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '114165',
                                                                                                                  'out_octets': '8579177733',
                                                                                                                  'out_ucast_pkts': '6849807',
                                                                                                                  'poller_hash': 'OEQ4N0NFcGVlcmludGYyMTYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '72621',
                                                                                                                  'in_octets': '129771139929',
                                                                                                                  'in_ucast_pkts': '231009597',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585890',
                                                                                                                  'out_octets': '489462227000',
                                                                                                                  'out_ucast_pkts': '413818146',
                                                                                                                  'poller_hash': 'NzUwOTNFcGVlcmludGYyNTYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '25',
                                                                                                                  'in_octets': '23112647885',
                                                                                                                  'in_ucast_pkts': '85310864',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585897',
                                                                                                                  'out_octets': '611106246186',
                                                                                                                  'out_ucast_pkts': '451618544',
                                                                                                                  'poller_hash': 'NzcwQUREcGVlcmludGYyODMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '4371',
                                                                                                                  'in_octets': '16703359088',
                                                                                                                  'in_ucast_pkts': '48309309',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '236261',
                                                                                                                  'out_octets': '155907658760',
                                                                                                                  'out_ucast_pkts': '123418197',
                                                                                                                  'poller_hash': 'RTlEQUFFcGVlcmludGYzMDkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '173959',
                                                                                                                  'in_octets': '15906379775',
                                                                                                                  'in_ucast_pkts': '80337227',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585894',
                                                                                                                  'out_octets': '300863610048',
                                                                                                                  'out_ucast_pkts': '216361495',
                                                                                                                  'poller_hash': 'OEUyNzdCcGVlcmludGYzMzYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '20',
                                                                                                                  'in_octets': '15967128592',
                                                                                                                  'in_ucast_pkts': '71645211',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585907',
                                                                                                                  'out_octets': '535750983463',
                                                                                                                  'out_ucast_pkts': '370610750',
                                                                                                                  'poller_hash': 'NzU5NDc5cGVlcmludGYzNDQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '22959',
                                                                                                                  'in_octets': '22258492411',
                                                                                                                  'in_ucast_pkts': '93067220',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1365441',
                                                                                                                  'out_octets': '773186300472',
                                                                                                                  'out_ucast_pkts': '574502444',
                                                                                                                  'poller_hash': 'RTlEQUI5cGVlcmludGYzNzIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '188420',
                                                                                                                  'in_octets': '394012892280',
                                                                                                                  'in_ucast_pkts': '1097730524',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '10096733',
                                                                                                                  'out_octets': '4760297247641',
                                                                                                                  'out_ucast_pkts': '3734788681',
                                                                                                                  'poller_hash': 'RTlEQUQ5cGVlcmludGYzODEvZ3Ax'},
                                                                                                          {       'in_errors': '14133',
                                                                                                                  'in_nucast_pkts': '1185526',
                                                                                                                  'in_octets': '277615745568',
                                                                                                                  'in_ucast_pkts': '979174116',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '8453965',
                                                                                                                  'out_octets': '9475934459039',
                                                                                                                  'out_ucast_pkts': '6983030322',
                                                                                                                  'poller_hash': 'RTlEQ0RGcGVlcmludGYzODQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '17559',
                                                                                                                  'in_octets': '97956161752',
                                                                                                                  'in_ucast_pkts': '306872787',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585896',
                                                                                                                  'out_octets': '1118644648126',
                                                                                                                  'out_ucast_pkts': '821708807',
                                                                                                                  'poller_hash': 'OEUyNkI1cGVlcmludGY0MTQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '9367',
                                                                                                                  'in_octets': '338864369810',
                                                                                                                  'in_ucast_pkts': '628900928',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '3972953',
                                                                                                                  'out_octets': '2707137879312',
                                                                                                                  'out_ucast_pkts': '2072674254',
                                                                                                                  'poller_hash': 'NzcwOUFCcGVlcmludGY2Ni9ncDE='}],
                                                                                         'mac_address': '4c:43:41:c9:0b:05',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/1/xp14',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '111511',
                                                                                         'out_octets': '68033284106813',
                                                                                         'out_ucast_pkts': '50077621647',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6MDUxLzEveHAxNA==',
                                                                                         'pons': [       {       'description': '1/1/xp14',
                                                                                                                 'id': '110010118',
                                                                                                                 'links': [       {       'connected_time': '3171543',
                                                                                                                                          'fiber_length': 4488,
                                                                                                                                          'poller_hash': 'NzUwN0M1cGVlcnBvbjE1NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.889884},
                                                                                                                                  {       'connected_time': '3171537',
                                                                                                                                          'fiber_length': 4080,
                                                                                                                                          'poller_hash': 'NzUwRDY0cGVlcnBvbjIwMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.889884},
                                                                                                                                  {       'connected_time': '228363',
                                                                                                                                          'fiber_length': 4182,
                                                                                                                                          'poller_hash': 'OEQ4N0NFcGVlcnBvbjIxNi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.889884},
                                                                                                                                  {       'connected_time': '3171538',
                                                                                                                                          'fiber_length': 4488,
                                                                                                                                          'poller_hash': 'NzUwOTNFcGVlcnBvbjI1Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.889884},
                                                                                                                                  {       'connected_time': '3171540',
                                                                                                                                          'fiber_length': 4386,
                                                                                                                                          'poller_hash': 'NzcwQUREcGVlcnBvbjI4My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.889884},
                                                                                                                                  {       'connected_time': '472581',
                                                                                                                                          'fiber_length': 4284,
                                                                                                                                          'poller_hash': 'RTlEQUFFcGVlcnBvbjMwOS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.889884},
                                                                                                                                  {       'connected_time': '3171550',
                                                                                                                                          'fiber_length': 3876,
                                                                                                                                          'poller_hash': 'OEUyNzdCcGVlcnBvbjMzNi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.889884},
                                                                                                                                  {       'connected_time': '3171542',
                                                                                                                                          'fiber_length': 4284,
                                                                                                                                          'poller_hash': 'NzU5NDc5cGVlcnBvbjM0NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.889884},
                                                                                                                                  {       'connected_time': '2730824',
                                                                                                                                          'fiber_length': 3978,
                                                                                                                                          'poller_hash': 'RTlEQUI5cGVlcnBvbjM3Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.889884},
                                                                                                                                  {       'connected_time': '20189024',
                                                                                                                                          'fiber_length': 4080,
                                                                                                                                          'poller_hash': 'RTlEQUQ5cGVlcnBvbjM4MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.889884},
                                                                                                                                  {       'connected_time': '16904753',
                                                                                                                                          'fiber_length': 3978,
                                                                                                                                          'poller_hash': 'RTlEQ0RGcGVlcnBvbjM4NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.889884},
                                                                                                                                  {       'connected_time': '3171541',
                                                                                                                                          'fiber_length': 4590,
                                                                                                                                          'poller_hash': 'OEUyNkI1cGVlcnBvbjQxNC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.889884},
                                                                                                                                  {       'connected_time': '7944689',
                                                                                                                                          'fiber_length': 4488,
                                                                                                                                          'poller_hash': 'NzcwOUFCcGVlcnBvbjY2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.889884}],
                                                                                                                 'max_distance': 60000,
                                                                                                                 'name': '1/1/xp14',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYjA1MTEwMDEwMTE4',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010119',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'in_unknown_protos': '0',
                                                                                         'mac_address': '4c:43:41:c9:0b:06',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/1/xp15',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6MDYxLzEveHAxNQ==',
                                                                                         'pons': [       {       'description': '1/1/xp15',
                                                                                                                 'id': '110010119',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': '1/1/xp15',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYjA2MTEwMDEwMTE5',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010120',
                                                                                         'in_discards': '63',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2990925',
                                                                                         'in_octets': '7058077424716',
                                                                                         'in_ucast_pkts': '19650352126',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '82839',
                                                                                                                  'in_octets': '415064238113',
                                                                                                                  'in_ucast_pkts': '1498217670',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '10161733',
                                                                                                                  'out_octets': '11934753967753',
                                                                                                                  'out_ucast_pkts': '9105805578',
                                                                                                                  'poller_hash': 'RTlERTg1cGVlcmludGYxMDEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '23',
                                                                                                                  'in_octets': '4819710282',
                                                                                                                  'in_ucast_pkts': '18708612',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585898',
                                                                                                                  'out_octets': '57629110503',
                                                                                                                  'out_ucast_pkts': '50980377',
                                                                                                                  'poller_hash': 'NzUwOTg4cGVlcmludGYxMTQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '6959',
                                                                                                                  'in_octets': '235897454170',
                                                                                                                  'in_ucast_pkts': '840308256',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '2796954',
                                                                                                                  'out_octets': '3005653222935',
                                                                                                                  'out_ucast_pkts': '2164695257',
                                                                                                                  'poller_hash': 'RTlEQjVBcGVlcmludGYxMzYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '124703',
                                                                                                                  'in_octets': '37067445455',
                                                                                                                  'in_ucast_pkts': '126073514',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585890',
                                                                                                                  'out_octets': '776680368531',
                                                                                                                  'out_ucast_pkts': '571388944',
                                                                                                                  'poller_hash': 'NzcwQUJFcGVlcmludGYxNC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28797',
                                                                                                                  'in_octets': '39014333940',
                                                                                                                  'in_ucast_pkts': '150468249',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585893',
                                                                                                                  'out_octets': '812469264557',
                                                                                                                  'out_ucast_pkts': '601591624',
                                                                                                                  'poller_hash': 'OEUyNUY4cGVlcmludGYxNDEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '347',
                                                                                                                  'in_octets': '82927577021',
                                                                                                                  'in_ucast_pkts': '119538887',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585908',
                                                                                                                  'out_octets': '309703330941',
                                                                                                                  'out_ucast_pkts': '250348918',
                                                                                                                  'poller_hash': 'NzcwOEZBcGVlcmludGYxNS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '17179',
                                                                                                                  'in_octets': '59573240747',
                                                                                                                  'in_ucast_pkts': '168515389',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '945483',
                                                                                                                  'out_octets': '512921660130',
                                                                                                                  'out_ucast_pkts': '376118042',
                                                                                                                  'poller_hash': 'ODIzQURCcGVlcmludGYxOTkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '383895',
                                                                                                                  'in_octets': '369327691625',
                                                                                                                  'in_ucast_pkts': '525388578',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '10161883',
                                                                                                                  'out_octets': '1239465853671',
                                                                                                                  'out_ucast_pkts': '1005889811',
                                                                                                                  'poller_hash': 'RTlEQkYzcGVlcmludGYyMTIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28841',
                                                                                                                  'in_octets': '59882742927',
                                                                                                                  'in_ucast_pkts': '241763296',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585894',
                                                                                                                  'out_octets': '975938062118',
                                                                                                                  'out_ucast_pkts': '776350713',
                                                                                                                  'poller_hash': 'NzUwOTUxcGVlcmludGYyMTcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28786',
                                                                                                                  'in_octets': '865995269',
                                                                                                                  'in_ucast_pkts': '3305758',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585882',
                                                                                                                  'out_octets': '1639126110',
                                                                                                                  'out_ucast_pkts': '3258687',
                                                                                                                  'poller_hash': 'NzUwOTg3cGVlcmludGYyNzEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28962',
                                                                                                                  'in_octets': '88304180630',
                                                                                                                  'in_ucast_pkts': '122313297',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585894',
                                                                                                                  'out_octets': '522579882507',
                                                                                                                  'out_ucast_pkts': '396020376',
                                                                                                                  'poller_hash': 'NzUwOTU2cGVlcmludGYzMTgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28665',
                                                                                                                  'in_octets': '141375950081',
                                                                                                                  'in_ucast_pkts': '417263620',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585889',
                                                                                                                  'out_octets': '1297388040034',
                                                                                                                  'out_ucast_pkts': '991808335',
                                                                                                                  'poller_hash': 'OEUyNjMycGVlcmludGYzMzgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '31',
                                                                                                                  'in_octets': '53178638609',
                                                                                                                  'in_ucast_pkts': '215888600',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585893',
                                                                                                                  'out_octets': '635469923972',
                                                                                                                  'out_ucast_pkts': '455158340',
                                                                                                                  'poller_hash': 'NzUwN0UzcGVlcmludGYzNDcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28777',
                                                                                                                  'in_octets': '27819690832',
                                                                                                                  'in_ucast_pkts': '51613724',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585903',
                                                                                                                  'out_octets': '379758695794',
                                                                                                                  'out_ucast_pkts': '272711592',
                                                                                                                  'poller_hash': 'NzcwQUM0cGVlcmludGY1My9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '19',
                                                                                                                  'in_octets': '14376618063',
                                                                                                                  'in_ucast_pkts': '24904490',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '248521',
                                                                                                                  'out_octets': '44606153742',
                                                                                                                  'out_ucast_pkts': '37970002',
                                                                                                                  'poller_hash': 'OEFCNTI3cGVlcmludGY2OC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '23712',
                                                                                                                  'in_octets': '71430610927',
                                                                                                                  'in_ucast_pkts': '150405927',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1295060',
                                                                                                                  'out_octets': '454595276687',
                                                                                                                  'out_ucast_pkts': '357914912',
                                                                                                                  'poller_hash': 'NzcwQTJFcGVlcmludGY5Ni9ncDE='}],
                                                                                         'mac_address': '4c:43:41:c9:0b:07',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/1/xp16',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '138208',
                                                                                         'out_octets': '82682153675451',
                                                                                         'out_ucast_pkts': '62610617063',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6MDcxLzEveHAxNg==',
                                                                                         'pons': [       {       'description': '1/1/xp16',
                                                                                                                 'id': '110010120',
                                                                                                                 'links': [       {       'connected_time': '20308147',
                                                                                                                                          'fiber_length': 4080,
                                                                                                                                          'poller_hash': 'RTlERTg1cGVlcnBvbjEwMS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.821771},
                                                                                                                                  {       'connected_time': '3171547',
                                                                                                                                          'fiber_length': 4182,
                                                                                                                                          'poller_hash': 'NzUwOTg4cGVlcnBvbjExNC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.821771},
                                                                                                                                  {       'connected_time': '5593009',
                                                                                                                                          'fiber_length': 3978,
                                                                                                                                          'poller_hash': 'RTlEQjVBcGVlcnBvbjEzNi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.821771},
                                                                                                                                  {       'connected_time': '3171540',
                                                                                                                                          'fiber_length': 4080,
                                                                                                                                          'poller_hash': 'NzcwQUJFcGVlcnBvbjE0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.821771},
                                                                                                                                  {       'connected_time': '3171537',
                                                                                                                                          'fiber_length': 4182,
                                                                                                                                          'poller_hash': 'OEUyNUY4cGVlcnBvbjE0MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.821771},
                                                                                                                                  {       'connected_time': '3171548',
                                                                                                                                          'fiber_length': 4182,
                                                                                                                                          'poller_hash': 'NzcwOEZBcGVlcnBvbjE1L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.821771},
                                                                                                                                  {       'connected_time': '1890885',
                                                                                                                                          'fiber_length': 4080,
                                                                                                                                          'poller_hash': 'ODIzQURCcGVlcnBvbjE5OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.821771},
                                                                                                                                  {       'connected_time': '20308446',
                                                                                                                                          'fiber_length': 4182,
                                                                                                                                          'poller_hash': 'RTlEQkYzcGVlcnBvbjIxMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.821771},
                                                                                                                                  {       'connected_time': '3171531',
                                                                                                                                          'fiber_length': 3978,
                                                                                                                                          'poller_hash': 'NzUwOTUxcGVlcnBvbjIxNy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.821771},
                                                                                                                                  {       'connected_time': '3171532',
                                                                                                                                          'fiber_length': 4080,
                                                                                                                                          'poller_hash': 'NzUwOTg3cGVlcnBvbjI3MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.821771},
                                                                                                                                  {       'connected_time': '3171543',
                                                                                                                                          'fiber_length': 3978,
                                                                                                                                          'poller_hash': 'NzUwOTU2cGVlcnBvbjMxOC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.821771},
                                                                                                                                  {       'connected_time': '3171546',
                                                                                                                                          'fiber_length': 4182,
                                                                                                                                          'poller_hash': 'OEUyNjMycGVlcnBvbjMzOC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.821771},
                                                                                                                                  {       'connected_time': '3171553',
                                                                                                                                          'fiber_length': 3774,
                                                                                                                                          'poller_hash': 'NzUwN0UzcGVlcnBvbjM0Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.821771},
                                                                                                                                  {       'connected_time': '3171554',
                                                                                                                                          'fiber_length': 4080,
                                                                                                                                          'poller_hash': 'NzcwQUM0cGVlcnBvbjUzL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.821771},
                                                                                                                                  {       'connected_time': '497069',
                                                                                                                                          'fiber_length': 4080,
                                                                                                                                          'poller_hash': 'OEFCNTI3cGVlcnBvbjY4L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.821771},
                                                                                                                                  {       'connected_time': '2590037',
                                                                                                                                          'fiber_length': 3978,
                                                                                                                                          'poller_hash': 'NzcwQTJFcGVlcnBvbjk2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.821771}],
                                                                                                                 'max_distance': 60000,
                                                                                                                 'name': '1/1/xp16',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYjA3MTEwMDEwMTIw',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'Calix',
                                                           'mem': 18.0,
                                                           'model': 'XG1601',
                                                           'name': '1/1',
                                                           'poller_hash': 'NDcyNDA1MDE1NTMz',
                                                           'serial_number': '472405015533',
                                                           'sw_version': '24.3.0',
                                                           'temperature': 26.0,
                                                           'uptime': '22101720'},
                                                   {       'cpu': 17.0,
                                                           'id': '1/2',
                                                           'interfaces': [       {       'admin_up': False,
                                                                                         'id': '120100101',
                                                                                         'mac_address': '4c:43:41:c9:0b:82',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/q1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6ODIxLzIvcTE='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120100102',
                                                                                         'mac_address': '4c:43:41:c9:0b:83',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/q2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6ODMxLzIvcTI='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120010101',
                                                                                         'mac_address': '4c:43:41:c9:0b:84',
                                                                                         'mtu': 1500,
                                                                                         'name': '1/2/x1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6ODQxLzIveDE='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120010102',
                                                                                         'mac_address': '4c:43:41:c9:0b:85',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/x2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6ODUxLzIveDI='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010105',
                                                                                         'in_discards': '1077',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '23215',
                                                                                         'in_octets': '139248826039',
                                                                                         'in_ucast_pkts': '208299782',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '13',
                                                                                                                  'in_nucast_pkts': '29837',
                                                                                                                  'in_octets': '137587555997',
                                                                                                                  'in_ucast_pkts': '208306739',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '86',
                                                                                                                  'out_octets': '616809079988',
                                                                                                                  'out_ucast_pkts': '463410581',
                                                                                                                  'poller_hash': 'MUE2QTZGOHBlZXJpbnRmNDE3L2dwMQ=='}],
                                                                                         'mac_address': '4c:43:41:c9:0b:88',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/2/xp1',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '87',
                                                                                         'out_octets': '620511460978',
                                                                                         'out_ucast_pkts': '463405719',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6ODgxLzIveHAx',
                                                                                         'pons': [       {       'description': '1/2/xp1',
                                                                                                                 'id': '120010105',
                                                                                                                 'links': [       {       'connected_time': '2759815',
                                                                                                                                          'fiber_length': 510,
                                                                                                                                          'poller_hash': 'MUE2QTZGOHBlZXJwb240MTcvZ3Ax',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -13.3,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 5.705429}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': '1/2/xp1',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYjg4MTIwMDEwMTA1',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010106',
                                                                                         'in_discards': '2086',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '3392690',
                                                                                         'in_octets': '15217165713208',
                                                                                         'in_ucast_pkts': '26565168706',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '30',
                                                                                                                  'in_octets': '22894678981',
                                                                                                                  'in_ucast_pkts': '56486551',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585847',
                                                                                                                  'out_octets': '265794052515',
                                                                                                                  'out_ucast_pkts': '208961306',
                                                                                                                  'poller_hash': 'NzcwQUE5cGVlcmludGYxMDAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '26801',
                                                                                                                  'in_octets': '21909836599',
                                                                                                                  'in_ucast_pkts': '72459989',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1472592',
                                                                                                                  'out_octets': '253913311240',
                                                                                                                  'out_ucast_pkts': '201742434',
                                                                                                                  'poller_hash': 'NzcwQUU2cGVlcmludGYxMTgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '124747',
                                                                                                                  'in_octets': '10668715720',
                                                                                                                  'in_ucast_pkts': '30334251',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585905',
                                                                                                                  'out_octets': '167836106964',
                                                                                                                  'out_ucast_pkts': '134646277',
                                                                                                                  'poller_hash': 'NzcwQUU1cGVlcmludGYxMzEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '24',
                                                                                                                  'in_octets': '51914422321',
                                                                                                                  'in_ucast_pkts': '278237664',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585900',
                                                                                                                  'out_octets': '1039101417696',
                                                                                                                  'out_ucast_pkts': '762256553',
                                                                                                                  'poller_hash': 'NzcwQTAycGVlcmludGYyMTQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '78136',
                                                                                                                  'in_octets': '42997870219',
                                                                                                                  'in_ucast_pkts': '120136718',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1466303',
                                                                                                                  'out_octets': '596280814103',
                                                                                                                  'out_ucast_pkts': '442907699',
                                                                                                                  'poller_hash': 'NzcwQTcxcGVlcmludGYyMjAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28975',
                                                                                                                  'in_octets': '5572769707',
                                                                                                                  'in_ucast_pkts': '13024880',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585927',
                                                                                                                  'out_octets': '37979602762',
                                                                                                                  'out_ucast_pkts': '32027573',
                                                                                                                  'poller_hash': 'QjQ5ODdGcGVlcmludGYyMzMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '21',
                                                                                                                  'in_octets': '7745953729',
                                                                                                                  'in_ucast_pkts': '57838188',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585896',
                                                                                                                  'out_octets': '270204765437',
                                                                                                                  'out_ucast_pkts': '194334495',
                                                                                                                  'poller_hash': 'NzcwQTJCcGVlcmludGYyNjQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '124765',
                                                                                                                  'in_octets': '110639076812',
                                                                                                                  'in_ucast_pkts': '190199278',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585903',
                                                                                                                  'out_octets': '599210180836',
                                                                                                                  'out_ucast_pkts': '505491139',
                                                                                                                  'poller_hash': 'NzUwODhGcGVlcmludGYzMzkvZ3Ax'},
                                                                                                          {       'in_errors': '3',
                                                                                                                  'in_nucast_pkts': '260565',
                                                                                                                  'in_octets': '313608769240',
                                                                                                                  'in_ucast_pkts': '573708531',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '4404052',
                                                                                                                  'out_octets': '1861191279064',
                                                                                                                  'out_ucast_pkts': '1465817269',
                                                                                                                  'poller_hash': 'RTlEQzZCcGVlcmludGYzNjkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '10954',
                                                                                                                  'in_octets': '2582352404',
                                                                                                                  'in_ucast_pkts': '15930383',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '71778',
                                                                                                                  'out_octets': '62183556698',
                                                                                                                  'out_ucast_pkts': '43520312',
                                                                                                                  'poller_hash': 'OEUyNzlCcGVlcmludGY0MTUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '25',
                                                                                                                  'in_octets': '466410139047',
                                                                                                                  'in_ucast_pkts': '525790368',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '326970',
                                                                                                                  'out_octets': '944199048554',
                                                                                                                  'out_ucast_pkts': '801897464',
                                                                                                                  'poller_hash': 'RTlEQjUwcGVlcmludGY0OS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '148',
                                                                                                                  'in_octets': '13252570688',
                                                                                                                  'in_ucast_pkts': '60615698',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '584378',
                                                                                                                  'out_octets': '216569552266',
                                                                                                                  'out_ucast_pkts': '158696578',
                                                                                                                  'poller_hash': 'NzcwQUU3cGVlcmludGY2MC9ncDE='},
                                                                                                          {       'in_errors': '1',
                                                                                                                  'in_nucast_pkts': '29594',
                                                                                                                  'in_octets': '139566064320',
                                                                                                                  'in_ucast_pkts': '138847017',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585141',
                                                                                                                  'out_octets': '140943981814',
                                                                                                                  'out_ucast_pkts': '129091971',
                                                                                                                  'poller_hash': 'NzUwQjg2cGVlcmludGY2NC9ncDE='}],
                                                                                         'mac_address': '4c:43:41:c9:0b:89',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/2/xp2',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '107805',
                                                                                         'out_octets': '81484077216106',
                                                                                         'out_ucast_pkts': '62306169200',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6ODkxLzIveHAy',
                                                                                         'pons': [       {       'description': '1/2/xp2',
                                                                                                                 'id': '120010106',
                                                                                                                 'links': [       {       'connected_time': '3171537',
                                                                                                                                          'fiber_length': 918,
                                                                                                                                          'poller_hash': 'NzcwQUE5cGVlcnBvbjEwMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.769629},
                                                                                                                                  {       'connected_time': '2944954',
                                                                                                                                          'fiber_length': 714,
                                                                                                                                          'poller_hash': 'NzcwQUU2cGVlcnBvbjExOC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.769629},
                                                                                                                                  {       'connected_time': '3171529',
                                                                                                                                          'fiber_length': 816,
                                                                                                                                          'poller_hash': 'NzcwQUU1cGVlcnBvbjEzMS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.769629},
                                                                                                                                  {       'connected_time': '3171545',
                                                                                                                                          'fiber_length': 918,
                                                                                                                                          'poller_hash': 'NzcwQTAycGVlcnBvbjIxNC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.769629},
                                                                                                                                  {       'connected_time': '2932477',
                                                                                                                                          'fiber_length': 408,
                                                                                                                                          'poller_hash': 'NzcwQTcxcGVlcnBvbjIyMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -25.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.769629},
                                                                                                                                  {       'connected_time': '3171593',
                                                                                                                                          'fiber_length': 918,
                                                                                                                                          'poller_hash': 'QjQ5ODdGcGVlcnBvbjIzMy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.769629},
                                                                                                                                  {       'connected_time': '3171537',
                                                                                                                                          'fiber_length': 816,
                                                                                                                                          'poller_hash': 'NzcwQTJCcGVlcnBvbjI2NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.769629},
                                                                                                                                  {       'connected_time': '3171543',
                                                                                                                                          'fiber_length': 714,
                                                                                                                                          'poller_hash': 'NzUwODhGcGVlcnBvbjMzOS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.769629},
                                                                                                                                  {       'connected_time': '8806580',
                                                                                                                                          'fiber_length': 510,
                                                                                                                                          'poller_hash': 'RTlEQzZCcGVlcnBvbjM2OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.769629},
                                                                                                                                  {       'connected_time': '143622',
                                                                                                                                          'fiber_length': 612,
                                                                                                                                          'poller_hash': 'OEUyNzlCcGVlcnBvbjQxNS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.769629},
                                                                                                                                  {       'connected_time': '653940',
                                                                                                                                          'fiber_length': 612,
                                                                                                                                          'poller_hash': 'RTlEQjUwcGVlcnBvbjQ5L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.769629},
                                                                                                                                  {       'connected_time': '1168736',
                                                                                                                                          'fiber_length': 510,
                                                                                                                                          'poller_hash': 'NzcwQUU3cGVlcnBvbjYwL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.769629},
                                                                                                                                  {       'connected_time': '3171557',
                                                                                                                                          'fiber_length': 918,
                                                                                                                                          'poller_hash': 'NzUwQjg2cGVlcnBvbjY0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.769629}],
                                                                                                                 'max_distance': 60000,
                                                                                                                 'name': '1/2/xp2',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYjg5MTIwMDEwMTA2',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010107',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'in_unknown_protos': '0',
                                                                                         'mac_address': '4c:43:41:c9:0b:8a',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/2/xp3',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6OGExLzIveHAz',
                                                                                         'pons': [       {       'description': '1/2/xp3',
                                                                                                                 'id': '120010107',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': '1/2/xp3',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYjhhMTIwMDEwMTA3',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010108',
                                                                                         'in_discards': '29',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '21224750',
                                                                                         'in_octets': '8446574177957',
                                                                                         'in_ucast_pkts': '15715675270',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '124858',
                                                                                                                  'in_octets': '27191843909',
                                                                                                                  'in_ucast_pkts': '126261586',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585892',
                                                                                                                  'out_octets': '402410708862',
                                                                                                                  'out_ucast_pkts': '312729510',
                                                                                                                  'poller_hash': 'NzcwOTRCcGVlcmludGYxNTEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28',
                                                                                                                  'in_octets': '55863085335',
                                                                                                                  'in_ucast_pkts': '89569487',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585898',
                                                                                                                  'out_octets': '301196477744',
                                                                                                                  'out_ucast_pkts': '253524886',
                                                                                                                  'poller_hash': 'NzcwOUI2cGVlcmludGYxNjkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '3058',
                                                                                                                  'in_octets': '86841312139',
                                                                                                                  'in_ucast_pkts': '66050014',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585904',
                                                                                                                  'out_octets': '5657428394',
                                                                                                                  'out_ucast_pkts': '40440401',
                                                                                                                  'poller_hash': 'NzUwODc0cGVlcmludGYxOTAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '3229299',
                                                                                                                  'in_octets': '117809522220',
                                                                                                                  'in_ucast_pkts': '218969338',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '5281434',
                                                                                                                  'out_octets': '697093925508',
                                                                                                                  'out_ucast_pkts': '565823479',
                                                                                                                  'poller_hash': 'RTlEQUI1cGVlcmludGYxOTYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '220745',
                                                                                                                  'in_octets': '48848321630',
                                                                                                                  'in_ucast_pkts': '152560318',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585887',
                                                                                                                  'out_octets': '948352631679',
                                                                                                                  'out_ucast_pkts': '690564303',
                                                                                                                  'poller_hash': 'NzUwOUU0cGVlcmludGYyNzMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '29',
                                                                                                                  'in_octets': '38645635950',
                                                                                                                  'in_ucast_pkts': '116706690',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1451449',
                                                                                                                  'out_octets': '719845221284',
                                                                                                                  'out_ucast_pkts': '529823354',
                                                                                                                  'poller_hash': 'RTlEQjUycGVlcmludGYyOTMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '19367521',
                                                                                                                  'in_octets': '2289457822031',
                                                                                                                  'in_ucast_pkts': '3988197968',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '10145311',
                                                                                                                  'out_octets': '11258578698730',
                                                                                                                  'out_ucast_pkts': '9427981087',
                                                                                                                  'poller_hash': 'RTlEQUI4cGVlcmludGYzMTEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '303669',
                                                                                                                  'in_octets': '65931062359',
                                                                                                                  'in_ucast_pkts': '280146163',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585915',
                                                                                                                  'out_octets': '1329728509856',
                                                                                                                  'out_ucast_pkts': '959609377',
                                                                                                                  'poller_hash': 'NzcwQUFEcGVlcmludGYzMjAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '26',
                                                                                                                  'in_octets': '508164616237',
                                                                                                                  'in_ucast_pkts': '658451099',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585900',
                                                                                                                  'out_octets': '811873933750',
                                                                                                                  'out_ucast_pkts': '860953412',
                                                                                                                  'poller_hash': 'NzUwOTFDcGVlcmludGYzNjUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '54062',
                                                                                                                  'in_octets': '245554270525',
                                                                                                                  'in_ucast_pkts': '603138418',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '4000495',
                                                                                                                  'out_octets': '4689566100483',
                                                                                                                  'out_ucast_pkts': '3269681290',
                                                                                                                  'poller_hash': 'RTlEQjEwcGVlcmludGY1MS9ncDE='}],
                                                                                         'mac_address': '4c:43:41:c9:0b:8b',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/2/xp4',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '78654',
                                                                                         'out_octets': '55441211616639',
                                                                                         'out_ucast_pkts': '43676357441',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6OGIxLzIveHA0',
                                                                                         'pons': [       {       'description': '1/2/xp4',
                                                                                                                 'id': '120010108',
                                                                                                                 'links': [       {       'connected_time': '3171537',
                                                                                                                                          'fiber_length': 2652,
                                                                                                                                          'poller_hash': 'NzcwOTRCcGVlcnBvbjE1MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.843539},
                                                                                                                                  {       'connected_time': '3171557',
                                                                                                                                          'fiber_length': 2652,
                                                                                                                                          'poller_hash': 'NzcwOUI2cGVlcnBvbjE2OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.843539},
                                                                                                                                  {       'connected_time': '3171535',
                                                                                                                                          'fiber_length': 2448,
                                                                                                                                          'poller_hash': 'NzUwODc0cGVlcnBvbjE5MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.843539},
                                                                                                                                  {       'connected_time': '10586558',
                                                                                                                                          'fiber_length': 2754,
                                                                                                                                          'poller_hash': 'RTlEQUI1cGVlcnBvbjE5Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.843539},
                                                                                                                                  {       'connected_time': '3171539',
                                                                                                                                          'fiber_length': 2754,
                                                                                                                                          'poller_hash': 'NzUwOUU0cGVlcnBvbjI3My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.843539},
                                                                                                                                  {       'connected_time': '2902751',
                                                                                                                                          'fiber_length': 2346,
                                                                                                                                          'poller_hash': 'RTlEQjUycGVlcnBvbjI5My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.843539},
                                                                                                                                  {       'connected_time': '20281159',
                                                                                                                                          'fiber_length': 2346,
                                                                                                                                          'poller_hash': 'RTlEQUI4cGVlcnBvbjMxMS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.843539},
                                                                                                                                  {       'connected_time': '3171566',
                                                                                                                                          'fiber_length': 2550,
                                                                                                                                          'poller_hash': 'NzcwQUFEcGVlcnBvbjMyMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.843539},
                                                                                                                                  {       'connected_time': '3171546',
                                                                                                                                          'fiber_length': 2652,
                                                                                                                                          'poller_hash': 'NzUwOTFDcGVlcnBvbjM2NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.843539},
                                                                                                                                  {       'connected_time': '8000151',
                                                                                                                                          'fiber_length': 2448,
                                                                                                                                          'poller_hash': 'RTlEQjEwcGVlcnBvbjUxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.843539}],
                                                                                                                 'max_distance': 60000,
                                                                                                                 'name': '1/2/xp4',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYjhiMTIwMDEwMTA4',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010109',
                                                                                         'in_discards': '78',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '45083',
                                                                                         'in_octets': '192700934768',
                                                                                         'in_ucast_pkts': '927739973',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '38669',
                                                                                                                  'in_octets': '60681100609',
                                                                                                                  'in_ucast_pkts': '191073656',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '398',
                                                                                                                  'out_octets': '982339520852',
                                                                                                                  'out_ucast_pkts': '737703652',
                                                                                                                  'poller_hash': 'MUE2QTZFM3BlZXJpbnRmNDEzL2dwMQ=='}],
                                                                                         'mac_address': '4c:43:41:c9:0b:8c',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/2/xp5',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '2065',
                                                                                         'out_octets': '3365642703917',
                                                                                         'out_ucast_pkts': '2431341689',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6OGMxLzIveHA1',
                                                                                         'pons': [       {       'description': '1/2/xp5',
                                                                                                                 'id': '120010109',
                                                                                                                 'links': [       {       'connected_time': '4576652',
                                                                                                                                          'fiber_length': 3162,
                                                                                                                                          'poller_hash': 'MUE2QTZFM3BlZXJwb240MTMvZ3Ax',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -12.8,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 5.718718}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': '1/2/xp5',
                                                                                                                 'poller_hash': 'NGM0MzQxYzkwYjhjMTIwMDEwMTA5',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010110',
                                                                                         'in_discards': '375',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1638881',
                                                                                         'in_octets': '3987419234188',
                                                                                         'in_ucast_pkts': '11752891934',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28877',
                                                                                                                  'in_octets': '11385826079',
                                                                                                                  'in_ucast_pkts': '14201558',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585895',
                                                                                                                  'out_octets': '13862521674',
                                                                                                                  'out_ucast_pkts': '16855942',
                                                                                                                  'poller_hash': 'NzUwOTdBcGVlcmludGYxMjYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '19',
                                                                                                                  'in_octets': '2162553859',
                                                                                                                  'in_ucast_pkts': '3844387',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '208801',
                                                                                                                  'out_octets': '5304343409',
                                                                                                                  'out_ucast_pkts': '5554249',
                                                                                                                  'poller_hash': 'QTNEQ0VFcGVlcmludGYxODgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '19',
                                                                                                                  'in_octets': '7175435262',
                                                                                                                  'in_ucast_pkts': '10695561',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '89813',
                                                                                                                  'out_octets': '59459344333',
                                                                                                                  'out_ucast_pkts': '42459048',
                                                                                                                  'poller_hash': 'NzUwODJCcGVlcmludGYyMDAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28865',
                                                                                                                  'in_octets': '180480278102',
                                                                                                                  'in_ucast_pkts': '603372018',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585885',
                                                                                                                  'out_octets': '2014222487498',
                                                                                                                  'out_ucast_pkts': '1531879602',
                                                                                                                  'poller_hash': 'NzUwOTk3cGVlcmludGYyMjIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '9132',
                                                                                                                  'in_octets': '23152620752',
                                                                                                                  'in_ucast_pkts': '106428119',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1060848',
                                                                                                                  'out_octets': '284862869925',
                                                                                                                  'out_ucast_pkts': '226393729',
                                                                                                                  'poller_hash': 'NzUwOTZEcGVlcmludGYyMjkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1495',
                                                                                                                  'in_octets': '53691580801',
                                                                                                                  'in_ucast_pkts': '103144444',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585890',
                                                                                                                  'out_octets': '66119437260',
                                                                                                                  'out_ucast_pkts': '92116974',
                                                                                                                  'poller_hash': 'NzcwQURBcGVlcmludGYyNDUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '98732',
                                                                                                                  'in_octets': '51688102946',
                                                                                                                  'in_ucast_pkts': '398680686',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '2547853',
                                                                                                                  'out_octets': '1860915303836',
                                                                                                                  'out_ucast_pkts': '1306229826',
                                                                                                                  'poller_hash': 'RTlEQUYycGVlcmludGYyNTUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '268290',
                                                                                                                  'in_octets': '68210100856',
                                                                                                                  'in_ucast_pkts': '137664600',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585879',
                                                                                                                  'out_octets': '768982649046',
                                                                                                                  'out_ucast_pkts': '568498828',
                                                                                                                  'poller_hash': 'NzUwOUUzcGVlcmludGYyNzgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '23602',
                                                                                                                  'in_octets': '50698820168',
                                                                                                                  'in_ucast_pkts': '305354415',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1296023',
                                                                                                                  'out_octets': '803435074529',
                                                                                                                  'out_ucast_pkts': '590579989',
                                                                                                                  'poller_hash': 'NzU5NDNGcGVlcmludGYzNzAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28913',
                                                                                                                  'in_octets': '6317135420',
                                                                                                                  'in_ucast_pkts': '22598397',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1585879',
                                                                                                                  'out_octets': '71209276407',
                                                                                                                  'out_ucast_pkts': '55066277',
                                                                                                                  'poller_hash': 'NzcwQTgxcGVlcmludGY0MDAvZ3Ax'}],
                                                                                         'mac_address': '4c:43:41:c9:0b:8d',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05674',
                                                                                         'name': '1/2/xp6',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '76962',
                                                                                         'out_octets': '41212030644757',
                                                                                         'out_ucast_pkts': '30878081775',
                                                                                         'poller_hash': 'NGM6NDM6NDE6Yzk6MGI6OGQxLzIveHA2',
                                                                                         'pons': [       {       'description': '1/2/xp6',
                                                                                                                 'id': '120010110',
                                                                                                                 'links': [       {       'connected_time': '3171540',
                                                                                                                                          'fiber_length': 3366,
                                                                                                                                          'poller_hash': 'NzUwOTdBcGVlcnBvbjEyNi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.685772},
                                                                                                                                  {       'connected_time': '417627',
                                                                                                                                          'fiber_length': 3468,
                                                                                                                                          'poller_hash': 'QTNEQ0VFcGVlcnBvbjE4OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.685772},
                                                                                                                                  {       'connected_time': '179659',
                                                                                                                                          'fiber_length': 3366,
                                                                                                                                          'poller_hash': 'NzUwODJCcGVlcnBvbjIwMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.685772},
                                                                                                                                  {       'connected_time': '3171520',
                                                                                                                                          'fiber_length': 3468,
                                                                                                                                          'poller_hash': 'NzUwOTk3cGVlcnBvbjIyMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.685772},
                                                                                                                                  {       'connected_time': '2121636',
                                                                                                                                          'fiber_length': 3264,
                                                                                                                                          'poller_hash': 'NzUwOTZEcGVlcnBvbjIyOS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.685772},
                                                                                                                                  {       'connected_time': '3171546',
                                                                                                                                          'fiber_length': 2958,
                                                                                                                                          'poller_hash': 'NzcwQURBcGVlcnBvbjI0NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.685772},
                                                                                                                                  {       'connected_time': '5094797',
                                                                                                                                          'fiber_length': 3468,
                                                                                                                                          'poller_hash': 'RTlEQUYycGVlcnBvbjI1NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.685772},
                                                                                                                                  {       'connected_time': '3171559',
                                                                                                                                          'fiber_length': 3468,
                               