import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestCalixModels(DeviceTestCase):
    def test_calix_exa_E7_20_3_4_51_25_01(self):
        obj = self.run_data("calix.exa.E7-20.3.4.51.25.01")
        exp_info = {
         'model': 'E7-20', 'sta_count': 1644, 'sw_version': None, 'vendor': 'Calix'
        }
        exp_stats = {
         'serial_number': '71412913092', 'system_mac_address': None
        }
        exp_sta_stats = {
                '100AAF9': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': "6979 MILLBANK MAIN ST (ZEHR'S COUNTRY "
                                           'MARKET)',
                                   'serial': '100AAF9',
                                   'serial_number': '100AAF9',
                                   'system_mac_address': None},
                '10948B4': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '55 WILLIAM ST Unit 1 (Rahman Habibur)',
                                   'serial': '10948B4',
                                   'serial_number': '10948B4',
                                   'system_mac_address': None},
                '10948D1': {       'dev_macs': ['5c:0f:fb:2f:c6:e4'],
                                   'ip_address': None,
                                   'name': '10 MAIN ST N (JACOBS CHAD)',
                                   'serial': '10948D1',
                                   'serial_number': '10948D1',
                                   'system_mac_address': None},
                '10948FD': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '55 WILLIAM STREET APT 207 (FRASER KATHY)',
                                   'serial': '10948FD',
                                   'serial_number': '10948FD',
                                   'system_mac_address': None},
                '1094906': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '2 MAIN ST N (FOSTER ANNE)',
                                   'serial': '1094906',
                                   'serial_number': '1094906',
                                   'system_mac_address': None},
                '10A8635': {       'dev_macs': ['14:21:03:92:c7:19'],
                                   'ip_address': None,
                                   'name': '51 COULTER ST (MARCHESE ANTHONY)',
                                   'serial': '10A8635',
                                   'serial_number': '10A8635',
                                   'system_mac_address': None},
                '10A8641': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7088 PERTH ROAD 121 (SAUDER MAYNARD)',
                                   'serial': '10A8641',
                                   'serial_number': '10A8641',
                                   'system_mac_address': None},
                '10A8642': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4460 LINE 52 (ROPP RICHARD)',
                                   'serial': '10A8642',
                                   'serial_number': '10A8642',
                                   'system_mac_address': None},
                '10A8644': {       'dev_macs': ['14:21:03:a0:88:95'],
                                   'ip_address': None,
                                   'name': '2288 LINE 47 (BALFOUR WENDY F)',
                                   'serial': '10A8644',
                                   'serial_number': '10A8644',
                                   'system_mac_address': None},
                '10A86A1': {       'dev_macs': ['14:21:03:92:f0:f3'],
                                   'ip_address': None,
                                   'name': '6405 ROAD 116 (METZGER CHARLENE)',
                                   'serial': '10A86A1',
                                   'serial_number': '10A86A1',
                                   'system_mac_address': None},
                '10A86AB': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7106 PERTH ROAD 121 (SCHULTZ DALE)',
                                   'serial': '10A86AB',
                                   'serial_number': '10A86AB',
                                   'system_mac_address': None},
                '10A86AD': {       'dev_macs': ['14:21:03:a0:8a:58'],
                                   'ip_address': None,
                                   'name': '4149 LINE 46 (HARWOOD PAUL D)',
                                   'serial': '10A86AD',
                                   'serial_number': '10A86AD',
                                   'system_mac_address': None},
                '10A86BD': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6943 ROAD 124 (ALBRECHT MURRAY & LORETTA)',
                                   'serial': '10A86BD',
                                   'serial_number': '10A86BD',
                                   'system_mac_address': None},
                '10A86E7': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4213 LINE 67 (MARTIN PAUL M)',
                                   'serial': '10A86E7',
                                   'serial_number': '10A86E7',
                                   'system_mac_address': None},
                '10A86ED': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6409 PERTH ROAD 121 (SCHERING LUCAS)',
                                   'serial': '10A86ED',
                                   'serial_number': '10A86ED',
                                   'system_mac_address': None},
                '10A871D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '2700 LINE 45 (BALFOUR WESLEY)',
                                   'serial': '10A871D',
                                   'serial_number': '10A871D',
                                   'system_mac_address': None},
                '10A872C': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5719 PERTH LINE 55 (CHARMAINE VALDEZ '
                                           'JOYCE)',
                                   'serial': '10A872C',
                                   'serial_number': '10A872C',
                                   'system_mac_address': None},
                '111BC3': {       'dev_macs': [       '5c:0f:fb:3d:5a:32',
                                                      '5c:0f:fb:3d:5a:e4',
                                                      '5c:0f:fb:3d:57:d0',
                                                      '00:03:e6:a5:74:46'],
                                  'ip_address': None,
                                  'name': '50 WILLIAM ST',
                                  'serial': '111BC3',
                                  'serial_number': '111BC3',
                                  'system_mac_address': None},
                '117D97D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '25 MURRAY CT (SMITH JESSICA)',
                                   'serial': '117D97D',
                                   'serial_number': '117D97D',
                                   'system_mac_address': None},
                '117D993': {       'dev_macs': ['e4:6c:d1:4e:ec:ca'],
                                   'ip_address': None,
                                   'name': '29 AVERY PL (MCDOWELL PATTI)',
                                   'serial': '117D993',
                                   'serial_number': '117D993',
                                   'system_mac_address': None},
                '117D9DE': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '2520 LINE 45 (ACKERSVILLER BRADLEY)',
                                   'serial': '117D9DE',
                                   'serial_number': '117D9DE',
                                   'system_mac_address': None},
                '117DA11': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4454 PERTH LINE 72 (WILLIAMS JUSTIN)',
                                   'serial': '117DA11',
                                   'serial_number': '117DA11',
                                   'system_mac_address': None},
                '117DA1D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4538 LINE 46 (ROSE JOHN P)',
                                   'serial': '117DA1D',
                                   'serial_number': '117DA1D',
                                   'system_mac_address': None},
                '117DA3B': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4460 COMMUNITY CENTRE DR (ALBRECHT GREG)',
                                   'serial': '117DA3B',
                                   'serial_number': '117DA3B',
                                   'system_mac_address': None},
                '117DA6D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6267 PERTH ROAD 121 (ROES TYRELL)',
                                   'serial': '117DA6D',
                                   'serial_number': '117DA6D',
                                   'system_mac_address': None},
                '117DA73': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '111 PUGH ST (BECKER JANE)',
                                   'serial': '117DA73',
                                   'serial_number': '117DA73',
                                   'system_mac_address': None},
                '117DAA8': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4458 COMMUNITY CENTRE DR (HAWLEY ALAN)',
                                   'serial': '117DAA8',
                                   'serial_number': '117DAA8',
                                   'system_mac_address': None},
                '117DAB7': {       'dev_macs': ['14:21:03:8b:74:af'],
                                   'ip_address': None,
                                   'name': '5135 ROAD 122 (REIGER JOE)',
                                   'serial': '117DAB7',
                                   'serial_number': '117DAB7',
                                   'system_mac_address': None},
                '117DAB8': {       'dev_macs': ['14:21:03:92:e9:c6'],
                                   'ip_address': None,
                                   'name': '4290 LINE 46 (BRUBACHER PAUL & CATHY)',
                                   'serial': '117DAB8',
                                   'serial_number': '117DAB8',
                                   'system_mac_address': None},
                '117DAC1': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4081 PERTH LINE 72 (BARTSCH DAVID)',
                                   'serial': '117DAC1',
                                   'serial_number': '117DAC1',
                                   'system_mac_address': None},
                '117DAC6': {       'dev_macs': ['14:21:03:92:e9:6e'],
                                   'ip_address': None,
                                   'name': '4179 LINE 46 (PLAYERDISE FARMS LTD)',
                                   'serial': '117DAC6',
                                   'serial_number': '117DAC6',
                                   'system_mac_address': None},
                '117DAD1': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4458 PERTH LINE 72 (WINSTON MIKE & SHARON)',
                                   'serial': '117DAD1',
                                   'serial_number': '117DAD1',
                                   'system_mac_address': None},
                '117DAD2': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '94 Mill St. E. Milverton',
                                   'serial': '117DAD2',
                                   'serial_number': '117DAD2',
                                   'system_mac_address': None},
                '117DAD4': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4188 LINE 46 (VAN MEURS MARTEN)',
                                   'serial': '117DAD4',
                                   'serial_number': '117DAD4',
                                   'system_mac_address': None},
                '117DADC': {       'dev_macs': ['14:21:03:8b:6d:14'],
                                   'ip_address': None,
                                   'name': '4247 LINE 46 (THOMAS CHRISTIAN)',
                                   'serial': '117DADC',
                                   'serial_number': '117DADC',
                                   'system_mac_address': None},
                '117DAE3': {       'dev_macs': ['14:21:03:8b:6c:b1'],
                                   'ip_address': None,
                                   'name': '2493 LINE 45 (HYDE AMBER)',
                                   'serial': '117DAE3',
                                   'serial_number': '117DAE3',
                                   'system_mac_address': None},
                '117DAE8': {       'dev_macs': ['14:21:03:8b:72:e1'],
                                   'ip_address': None,
                                   'name': '2542 LINE 45 (ROSE JOHN & LOIS)',
                                   'serial': '117DAE8',
                                   'serial_number': '117DAE8',
                                   'system_mac_address': None},
                '117DAED': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6569 ROAD 129 (DIETRICH DIANE)',
                                   'serial': '117DAED',
                                   'serial_number': '117DAED',
                                   'system_mac_address': None},
                '117DAF8': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '2624 LINE 47 (PATCH DALE)',
                                   'serial': '117DAF8',
                                   'serial_number': '117DAF8',
                                   'system_mac_address': None},
                '117DAFC': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6889 ROAD 124 (JANTZI REUBEN K)',
                                   'serial': '117DAFC',
                                   'serial_number': '117DAFC',
                                   'system_mac_address': None},
                '117DAFE': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4434 PERTH LINE 72 (SCHMIDT KENDRICK)',
                                   'serial': '117DAFE',
                                   'serial_number': '117DAFE',
                                   'system_mac_address': None},
                '117DB0B': {       'dev_macs': ['14:21:03:8b:75:49'],
                                   'ip_address': None,
                                   'name': '15 MILL ST W (ANSTETT ADAM)',
                                   'serial': '117DB0B',
                                   'serial_number': '117DB0B',
                                   'system_mac_address': None},
                '117DB0E': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4452 COMMUNITY CENTRE DR (GERBER RONALD)',
                                   'serial': '117DB0E',
                                   'serial_number': '117DB0E',
                                   'system_mac_address': None},
                '117DB13': {       'dev_macs': ['14:21:03:92:f5:fa'],
                                   'ip_address': None,
                                   'name': '115 PUGH ST (BASHNIAK MYKOLA)',
                                   'serial': '117DB13',
                                   'serial_number': '117DB13',
                                   'system_mac_address': None},
                '117DB22': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4461 COMMUNITY CENTRE DR (WAGLER EDGAR)',
                                   'serial': '117DB22',
                                   'serial_number': '117DB22',
                                   'system_mac_address': None},
                '117DB2E': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '1 SCHADE ST MONKTON (WALL GEORGE)',
                                   'serial': '117DB2E',
                                   'serial_number': '117DB2E',
                                   'system_mac_address': None},
                '117DB30': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4463 PERTH LINE 72 (WAGLER LANELLE)',
                                   'serial': '117DB30',
                                   'serial_number': '117DB30',
                                   'system_mac_address': None},
                '117DB34': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4455 COMMUNITY CENTRE DR (ROLFE ROSANNE)',
                                   'serial': '117DB34',
                                   'serial_number': '117DB34',
                                   'system_mac_address': None},
                '117DB39': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6951 ELGIN ST (POOLE SAMANTHA)',
                                   'serial': '117DB39',
                                   'serial_number': '117DB39',
                                   'system_mac_address': None},
                '117DB41': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4174 LINE 61 (KUEPFER SARAH)',
                                   'serial': '117DB41',
                                   'serial_number': '117DB41',
                                   'system_mac_address': None},
                '117DB45': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5122 ROAD 122 (VAN STRAATEN DAVE)',
                                   'serial': '117DB45',
                                   'serial_number': '117DB45',
                                   'system_mac_address': None},
                '117DB48': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4168 LINE 46 (LOUWAGIE DENNIS)',
                                   'serial': '117DB48',
                                   'serial_number': '117DB48',
                                   'system_mac_address': None},
                '117DB4C': {       'dev_macs': ['14:21:03:8b:6f:be'],
                                   'ip_address': None,
                                   'name': '2483 LINE 51 (JANTZI ROBERT)',
                                   'serial': '117DB4C',
                                   'serial_number': '117DB4C',
                                   'system_mac_address': None},
                '117DB4F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6571 ROAD 140 (EBERSOL AMANDA)',
                                   'serial': '117DB4F',
                                   'serial_number': '117DB4F',
                                   'system_mac_address': None},
                '117DB51': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4442 PERTH LINE 72 (HIEBERT JACOB)',
                                   'serial': '117DB51',
                                   'serial_number': '117DB51',
                                   'system_mac_address': None},
                '117DB58': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '2460 LINE 47 (GERBER COLLIN)',
                                   'serial': '117DB58',
                                   'serial_number': '117DB58',
                                   'system_mac_address': None},
                '117DB60': {       'dev_macs': ['14:21:03:92:eb:52'],
                                   'ip_address': None,
                                   'name': '61 PUGH ST (WOODTHORPE PETER)',
                                   'serial': '117DB60',
                                   'serial_number': '117DB60',
                                   'system_mac_address': None},
                '117DB6E': {       'dev_macs': [       'd4:6e:0e:9f:e4:9b',
                                                       '48:ee:0c:28:e6:4f'],
                                   'ip_address': None,
                                   'name': '4467 PERTH LINE 72 (BUECKERT PETER & '
                                           'TRUDY)',
                                   'serial': '117DB6E',
                                   'serial_number': '117DB6E',
                                   'system_mac_address': None},
                '117DB71': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '14 CRUICKSHANK ST (BRAUN JACOB)',
                                   'serial': '117DB71',
                                   'serial_number': '117DB71',
                                   'system_mac_address': None},
                '117DB76': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4917 LINE 67 (EBERSOL ALVIN)',
                                   'serial': '117DB76',
                                   'serial_number': '117DB76',
                                   'system_mac_address': None},
                '117DB7A': {       'dev_macs': ['14:21:03:92:c6:a0'],
                                   'ip_address': None,
                                   'name': '4119 LINE 46 (QUAST CHERYL)',
                                   'serial': '117DB7A',
                                   'serial_number': '117DB7A',
                                   'system_mac_address': None},
                '117DB92': {       'dev_macs': ['14:21:03:92:c7:9d'],
                                   'ip_address': None,
                                   'name': '70 PUGH ST (ZINKEN JONATHAN)',
                                   'serial': '117DB92',
                                   'serial_number': '117DB92',
                                   'system_mac_address': None},
                '117DB98': {       'dev_macs': ['14:21:03:92:ed:83'],
                                   'ip_address': None,
                                   'name': '46 AVERY PL (BENDER BOB & JANINE)',
                                   'serial': '117DB98',
                                   'serial_number': '117DB98',
                                   'system_mac_address': None},
                '117DBB0': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4464 COMMUNITY CENTRE DR (GINGRICH NATHAN)',
                                   'serial': '117DBB0',
                                   'serial_number': '117DBB0',
                                   'system_mac_address': None},
                '117DBB2': {       'dev_macs': ['14:21:03:92:ea:60'],
                                   'ip_address': None,
                                   'name': '4463 COMMUNITY CENTRE DR (CARTER RUTH ANN)',
                                   'serial': '117DBB2',
                                   'serial_number': '117DBB2',
                                   'system_mac_address': None},
                '117DBBE': {       'dev_macs': ['14:21:03:92:f0:dd'],
                                   'ip_address': None,
                                   'name': '140 WINSTANLEY ST (BROWN ADAM)',
                                   'serial': '117DBBE',
                                   'serial_number': '117DBBE',
                                   'system_mac_address': None},
                '117DBC4': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '2435 LINE 47 (GERBER JAMES)',
                                   'serial': '117DBC4',
                                   'serial_number': '117DBC4',
                                   'system_mac_address': None},
                '117DBCA': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '2620 LINE 45 (SATCHELL DOUGLAS & BONNIE)',
                                   'serial': '117DBCA',
                                   'serial_number': '117DBCA',
                                   'system_mac_address': None},
                '117DBCD': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6033 PERTH ROAD 119 (GASCHO KEVIN & '
                                           'NADINE)',
                                   'serial': '117DBCD',
                                   'serial_number': '117DBCD',
                                   'system_mac_address': None},
                '117DBDB': {       'dev_macs': ['14:21:03:92:c6:d7'],
                                   'ip_address': None,
                                   'name': '143 PUGH ST (COURCHESNE BRIAN)',
                                   'serial': '117DBDB',
                                   'serial_number': '117DBDB',
                                   'system_mac_address': None},
                '117DBDF': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '2499 LINE 47 (ROTH JOHN & INGRID)',
                                   'serial': '117DBDF',
                                   'serial_number': '117DBDF',
                                   'system_mac_address': None},
                '117DBE0': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5261 ROAD 108 (NEEBVIEW ACRES LTD.)',
                                   'serial': '117DBE0',
                                   'serial_number': '117DBE0',
                                   'system_mac_address': None},
                '117DBE7': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4540 LINE 46 (RITSMA JOAN)',
                                   'serial': '117DBE7',
                                   'serial_number': '117DBE7',
                                   'system_mac_address': None},
                '117DBF1': {       'dev_macs': ['14:21:03:a1:e5:81'],
                                   'ip_address': None,
                                   'name': '66 PUGH ST (PEARCE DOUG)',
                                   'serial': '117DBF1',
                                   'serial_number': '117DBF1',
                                   'system_mac_address': None},
                '117DBF4': {       'dev_macs': ['14:21:03:8b:70:e7'],
                                   'ip_address': None,
                                   'name': '6B MAIN ST S (NEW ORLEANS PIZZA)',
                                   'serial': '117DBF4',
                                   'serial_number': '117DBF4',
                                   'system_mac_address': None},
                '117DBF6': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4433 PERTH LINE 72 (HAFEMANN CHRISTIAN)',
                                   'serial': '117DBF6',
                                   'serial_number': '117DBF6',
                                   'system_mac_address': None},
                '117DC00': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4466 COMMUNITY CENTRE DR (JANTZI EMMANUEL)',
                                   'serial': '117DC00',
                                   'serial_number': '117DC00',
                                   'system_mac_address': None},
                '117DC03': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '220 WINSTANLEY ST MONKTON (HEWITT ROBERT)',
                                   'serial': '117DC03',
                                   'serial_number': '117DC03',
                                   'system_mac_address': None},
                '117DC09': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7006 ROAD 129 (WAGLER BRIAN)',
                                   'serial': '117DC09',
                                   'serial_number': '117DC09',
                                   'system_mac_address': None},
                '117DC0C': {       'dev_macs': ['14:21:03:92:ea:8c'],
                                   'ip_address': None,
                                   'name': '121 PUGH ST (STONE STEPHEN)',
                                   'serial': '117DC0C',
                                   'serial_number': '117DC0C',
                                   'system_mac_address': None},
                '117DC11': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4619 LINE 61 (WAGLER JONATHAN)',
                                   'serial': '117DC11',
                                   'serial_number': '117DC11',
                                   'system_mac_address': None},
                '117DC19': {       'dev_macs': ['14:21:03:92:ea:ce'],
                                   'ip_address': None,
                                   'name': '5264 ROAD 108 (ROTH TIM)',
                                   'serial': '117DC19',
                                   'serial_number': '117DC19',
                                   'system_mac_address': None},
                '117DC1A': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4438 PERTH LINE 72 (POOLE TYLER)',
                                   'serial': '117DC1A',
                                   'serial_number': '117DC1A',
                                   'system_mac_address': None},
                '117DC1E': {       'dev_macs': ['5c:0f:fb:33:31:e6'],
                                   'ip_address': None,
                                   'name': '4446 PERTH LINE 72 (WAGLER SHIRLEY)',
                                   'serial': '117DC1E',
                                   'serial_number': '117DC1E',
                                   'system_mac_address': None},
                '117DC21': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4987 LINE 61 (STREICHER RON)',
                                   'serial': '117DC21',
                                   'serial_number': '117DC21',
                                   'system_mac_address': None},
                '117DC27': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '2580 LINE 45 (KINGSBURY STEVE)',
                                   'serial': '117DC27',
                                   'serial_number': '117DC27',
                                   'system_mac_address': None},
                '117DC2A': {       'dev_macs': ['14:21:03:92:f4:6e'],
                                   'ip_address': None,
                                   'name': '4847 ROAD 109 (HORNE ARTHUR)',
                                   'serial': '117DC2A',
                                   'serial_number': '117DC2A',
                                   'system_mac_address': None},
                '1192F9B': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5961 PERTH ROAD 119 (GASCHO ANDRE)',
                                   'serial': '1192F9B',
                                   'serial_number': '1192F9B',
                                   'system_mac_address': None},
                '1192FE9': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '3996A LINE 61 (BARTSCH DYCK PETER)',
                                   'serial': '1192FE9',
                                   'serial_number': '1192FE9',
                                   'system_mac_address': None},
                '1192FF5': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6005 PERTH ROAD 119 (GASCHO BRIAN)',
                                   'serial': '1192FF5',
                                   'serial_number': '1192FF5',
                                   'system_mac_address': None},
                '1192FF6': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7002 PERTH ROAD 121 (KUEPFER JEREMY)',
                                   'serial': '1192FF6',
                                   'serial_number': '1192FF6',
                                   'system_mac_address': None},
                '119300B': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6529 ROAD 129 (KUEPFER EDWARD)',
                                   'serial': '119300B',
                                   'serial_number': '119300B',
                                   'system_mac_address': None},
                '1193042': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6013 PERTH ROAD 119 (GEERTSMA PETER)',
                                   'serial': '1193042',
                                   'serial_number': '1193042',
                                   'system_mac_address': None},
                '11930CA': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5911 PERTH ROAD 119 (YANTZI AMY)',
                                   'serial': '11930CA',
                                   'serial_number': '11930CA',
                                   'system_mac_address': None},
                '11945D1': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4822 LINE 59 (GRAVELRIDGE WI HALL)',
                                   'serial': '11945D1',
                                   'serial_number': '11945D1',
                                   'system_mac_address': None},
                '1194A97': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '202 SELBY AV (TOM GOODYEAR)',
                                   'serial': '1194A97',
                                   'serial_number': '1194A97',
                                   'system_mac_address': None},
                '1194B8B': {       'dev_macs': ['84:39:8f:7e:b0:30'],
                                   'ip_address': None,
                                   'name': '4 COBALT ST N (AVON MAITLAND DISTRICT '
                                           'SCHOOL)',
                                   'serial': '1194B8B',
                                   'serial_number': '1194B8B',
                                   'system_mac_address': None},
                '1194D7D': {       'dev_macs': ['04:bc:9f:46:8e:86'],
                                   'ip_address': None,
                                   'name': '5640 PERTH LINE 55 (RAYCRAFT RANDY)',
                                   'serial': '1194D7D',
                                   'serial_number': '1194D7D',
                                   'system_mac_address': None},
                '1194E72': {       'dev_macs': [       '5c:0f:fb:3d:3f:5e',
                                                       '5c:0f:fb:43:96:e0'],
                                   'ip_address': None,
                                   'name': '5619A PERTH LINE 55 (MCEWEN BRIAN)',
                                   'serial': '1194E72',
                                   'serial_number': '1194E72',
                                   'system_mac_address': None},
                '1194E87': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6986 MILLBANK MAIN ST (KLASSEN JAKE & '
                                           'ANNA)',
                                   'serial': '1194E87',
                                   'serial_number': '1194E87',
                                   'system_mac_address': None},
                '1194E8C': {       'dev_macs': ['b8:94:70:f3:dd:4a'],
                                   'ip_address': None,
                                   'name': '25 MURRAY CT (ROTH CAROLYN)',
                                   'serial': '1194E8C',
                                   'serial_number': '1194E8C',
                                   'system_mac_address': None},
                '11950FA': {       'dev_macs': ['cc:be:59:7e:b8:d2'],
                                   'ip_address': None,
                                   'name': '194 WINSTANLEY ST (THOM KENNEDY)',
                                   'serial': '11950FA',
                                   'serial_number': '11950FA',
                                   'system_mac_address': None},
                '1195105': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6906 ELGIN ST (ZEHR ALMA)',
                                   'serial': '1195105',
                                   'serial_number': '1195105',
                                   'system_mac_address': None},
                '1195111': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '78 PUGH ST (ENSINGER JASON)',
                                   'serial': '1195111',
                                   'serial_number': '1195111',
                                   'system_mac_address': None},
                '119513E': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4095 WYNDHAM ST (SCHEERER JOHN)',
                                   'serial': '119513E',
                                   'serial_number': '119513E',
                                   'system_mac_address': None},
                '119513F': {       'dev_macs': ['04:bc:9f:46:8d:3c'],
                                   'ip_address': None,
                                   'name': '6985 RUTHERFORD ST (NIEWINSKI DAVE)',
                                   'serial': '119513F',
                                   'serial_number': '119513F',
                                   'system_mac_address': None},
                '1195143': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5262 LINE 52 (BVH EXCAVATION & '
                                           'CONTRACTING)',
                                   'serial': '1195143',
                                   'serial_number': '1195143',
                                   'system_mac_address': None},
                '1195144': {       'dev_macs': ['04:bc:9f:46:8f:f1'],
                                   'ip_address': None,
                                   'name': '5201 LINE 49 (NOON JOSHUA)',
                                   'serial': '1195144',
                                   'serial_number': '1195144',
                                   'system_mac_address': None},
                '1195146': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6983 MILLBANK MAIN ST (KROEKER ISAAK)',
                                   'serial': '1195146',
                                   'serial_number': '1195146',
                                   'system_mac_address': None},
                '119514D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '207 SELBY AV (REDEEMER LUTHERAN CHURCH)',
                                   'serial': '119514D',
                                   'serial_number': '119514D',
                                   'system_mac_address': None},
                '119515C': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5479 ROAD 144 (DEGROOT CHRIS & ANGELA)',
                                   'serial': '119515C',
                                   'serial_number': '119515C',
                                   'system_mac_address': None},
                '1195161': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6972 MILLBANK MAIN STREET (MARTIN ROGER)',
                                   'serial': '1195161',
                                   'serial_number': '1195161',
                                   'system_mac_address': None},
                '1195169': {       'dev_macs': ['b8:94:70:9e:cb:d0'],
                                   'ip_address': None,
                                   'name': '95 PUGH ST (ROOPRAM ANTHONY)',
                                   'serial': '1195169',
                                   'serial_number': '1195169',
                                   'system_mac_address': None},
                '119516F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6944 PERTH ROAD 121 (BARTSCH JOHN & '
                                           'SUSANA)',
                                   'serial': '119516F',
                                   'serial_number': '119516F',
                                   'system_mac_address': None},
                '1195172': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6906 ELGIN ST (FRIESEN HELENA & JACOB)',
                                   'serial': '1195172',
                                   'serial_number': '1195172',
                                   'system_mac_address': None},
                '1195173': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '212 WINSTANLEY ST (HULLEY LAWRENCE)',
                                   'serial': '1195173',
                                   'serial_number': '1195173',
                                   'system_mac_address': None},
                '119517E': {       'dev_macs': ['b8:94:70:f3:df:f4'],
                                   'ip_address': None,
                                   'name': '6935 HORIZON TL (MCARTHUR DOROTHY & DOUG)',
                                   'serial': '119517E',
                                   'serial_number': '119517E',
                                   'system_mac_address': None},
                '1195187': {       'dev_macs': ['04:bc:9f:46:8d:31'],
                                   'ip_address': None,
                                   'name': '55 WILLIAM ST (MURAWSKY PAUL)',
                                   'serial': '1195187',
                                   'serial_number': '1195187',
                                   'system_mac_address': None},
                '119518D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4095 HILLCREST ST (FRIESEN HEINRICH & EVA)',
                                   'serial': '119518D',
                                   'serial_number': '119518D',
                                   'system_mac_address': None},
                '1195191': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': "22 WILLIAM ST (O'MALLEY CAITLIN)",
                                   'serial': '1195191',
                                   'serial_number': '1195191',
                                   'system_mac_address': None},
                '1195199': {       'dev_macs': ['b8:94:70:f3:e4:f0'],
                                   'ip_address': None,
                                   'name': '6963 MILLBANK MAIN STREET (GOMES JOHN & '
                                           'NELIA)',
                                   'serial': '1195199',
                                   'serial_number': '1195199',
                                   'system_mac_address': None},
                '11951A5': {       'dev_macs': ['04:bc:9f:46:90:d8'],
                                   'ip_address': None,
                                   'name': '5657 PERTH LINE 55 (HAHN BRUCE)',
                                   'serial': '11951A5',
                                   'serial_number': '11951A5',
                                   'system_mac_address': None},
                '11951A7': {       'dev_macs': ['84:d3:43:6d:eb:e2'],
                                   'ip_address': None,
                                   'name': '14 MADDISON ST E (THIESSEN GERHARD)',
                                   'serial': '11951A7',
                                   'serial_number': '11951A7',
                                   'system_mac_address': None},
                '11951B0': {       'dev_macs': ['e4:6c:d1:4e:f0:5b'],
                                   'ip_address': None,
                                   'name': '2 MAIN ST N (WITMER TIM)',
                                   'serial': '11951B0',
                                   'serial_number': '11951B0',
                                   'system_mac_address': None},
                '11951B6': {       'dev_macs': ['04:bc:9f:46:ad:08'],
                                   'ip_address': None,
                                   'name': '129 PUGH ST (ANTHONY DAVE)',
                                   'serial': '11951B6',
                                   'serial_number': '11951B6',
                                   'system_mac_address': None},
                '11B227A': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4072 QUEEN ST (THOMAS JIM)',
                                   'serial': '11B227A',
                                   'serial_number': '11B227A',
                                   'system_mac_address': None},
                '11B22BB': {       'dev_macs': ['04:bc:9f:46:93:fb'],
                                   'ip_address': None,
                                   'name': '6906 ELGIN ST (ROES SHARON)',
                                   'serial': '11B22BB',
                                   'serial_number': '11B22BB',
                                   'system_mac_address': None},
                '11B24F7': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4075 PRINCESS ST (MISENER SCOTT)',
                                   'serial': '11B24F7',
                                   'serial_number': '11B24F7',
                                   'system_mac_address': None},
                '11B25D4': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4863 LINE 59 (DAVIDSON TIM)',
                                   'serial': '11B25D4',
                                   'serial_number': '11B25D4',
                                   'system_mac_address': None},
                '11B25E5': {       'dev_macs': ['b8:94:70:84:99:cd'],
                                   'ip_address': None,
                                   'name': '5592 DUKE ST (COUNTRY COUSINS)',
                                   'serial': '11B25E5',
                                   'serial_number': '11B25E5',
                                   'system_mac_address': None},
                '11B25F8': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6906 ELGIN ST (VAN ALLEN BARBIE)',
                                   'serial': '11B25F8',
                                   'serial_number': '11B25F8',
                                   'system_mac_address': None},
                '11B2612': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6906 ELGIN ST (VAN ALLEN TAUNYA)',
                                   'serial': '11B2612',
                                   'serial_number': '11B2612',
                                   'system_mac_address': None},
                '11BDFF4': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '15 MAIN ST S (HASTINGS MANDY)',
                                   'serial': '11BDFF4',
                                   'serial_number': '11BDFF4',
                                   'system_mac_address': None},
                '11BE141': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6837 ROAD 129 (JANTZI RAYMOND)',
                                   'serial': '11BE141',
                                   'serial_number': '11BE141',
                                   'system_mac_address': None},
                '11BE15A': {       'dev_macs': ['14:21:03:a9:75:59'],
                                   'ip_address': None,
                                   'name': '2621 LINE 47 (WILSON JENNIFER)',
                                   'serial': '11BE15A',
                                   'serial_number': '11BE15A',
                                   'system_mac_address': None},
                '11BE1DC': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4398 LINE 52 (WEBER DAN & TAMMY)',
                                   'serial': '11BE1DC',
                                   'serial_number': '11BE1DC',
                                   'system_mac_address': None},
                '11BE1EA': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4430 PERTH LINE 72 NEWTON (A&A '
                                           'CONTRACTING)',
                                   'serial': '11BE1EA',
                                   'serial_number': '11BE1EA',
                                   'system_mac_address': None},
                '11BE301': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6841 ROAD 129 (REIMER ABRAM)',
                                   'serial': '11BE301',
                                   'serial_number': '11BE301',
                                   'system_mac_address': None},
                '11BE369': {       'dev_macs': ['14:21:03:d1:8a:51'],
                                   'ip_address': None,
                                   'name': '4436 PERTH LINE 72 (KUEPFER RAYMOND)',
                                   'serial': '11BE369',
                                   'serial_number': '11BE369',
                                   'system_mac_address': None},
                '11BE395': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4230 LINE 67 (KUEPFER ROSEANA)',
                                   'serial': '11BE395',
                                   'serial_number': '11BE395',
                                   'system_mac_address': None},
                '11BE3A2': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '19 FULTON ST (TOTH DON)',
                                   'serial': '11BE3A2',
                                   'serial_number': '11BE3A2',
                                   'system_mac_address': None},
                '11D018': {       'dev_macs': ['48:a9:8a:22:67:6e'],
                                  'ip_address': None,
                                  'name': 'Peaceful Meadows Retirement (Office ONT)',
                                  'serial': '11D018',
                                  'serial_number': '11D018',
                                  'system_mac_address': None},
                '12483F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '3 Cobalt St. N. Milverton (Rick Banks)',
                                  'serial': '12483F',
                                  'serial_number': '12483F',
                                  'system_mac_address': None},
                '12484E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4837 Line 61 Milverton (Grace Mooney)',
                                  'serial': '12484E',
                                  'serial_number': '12484E',
                                  'system_mac_address': None},
                '1270D51': {       'dev_macs': ['e4:6c:d1:4e:f0:2f'],
                                   'ip_address': None,
                                   'name': '10 SCHADE ST (JARMUTH KEN & NORA)',
                                   'serial': '1270D51',
                                   'serial_number': '1270D51',
                                   'system_mac_address': None},
                '1270D6B': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5897 PERTH ROAD 119 (WAGLER SARAH)',
                                   'serial': '1270D6B',
                                   'serial_number': '1270D6B',
                                   'system_mac_address': None},
                '1270D6E': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '14 TEMPERANCE ST (DEBUS DAVID)',
                                   'serial': '1270D6E',
                                   'serial_number': '1270D6E',
                                   'system_mac_address': None},
                '1270D70': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4022 PERTH LINE 72 (KIPFER SAM S)',
                                   'serial': '1270D70',
                                   'serial_number': '1270D70',
                                   'system_mac_address': None},
                '1270D8E': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '2 MAIN ST N (COOPER JAMES)',
                                   'serial': '1270D8E',
                                   'serial_number': '1270D8E',
                                   'system_mac_address': None},
                '1270D92': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6905 PERTH ROAD 121 (WAGLER HAROLD)',
                                   'serial': '1270D92',
                                   'serial_number': '1270D92',
                                   'system_mac_address': None},
                '1270D9D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6771 PERTH ROAD 121 (KUEPFER SAM A)',
                                   'serial': '1270D9D',
                                   'serial_number': '1270D9D',
                                   'system_mac_address': None},
                '1270DE6': {       'dev_macs': [       '5c:0f:fb:2a:03:ea',
                                                       '5c:0f:fb:2a:13:e2'],
                                   'ip_address': None,
                                   'name': '5 GROSCH ST (DOUPE DOLORES)',
                                   'serial': '1270DE6',
                                   'serial_number': '1270DE6',
                                   'system_mac_address': None},
                '1270E05': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6484 ROAD 136 (COXON MRS LLOYD)',
                                   'serial': '1270E05',
                                   'serial_number': '1270E05',
                                   'system_mac_address': None},
                '1270E47': {       'dev_macs': ['e4:6c:d1:4e:f1:4d'],
                                   'ip_address': None,
                                   'name': '61 WILLIAM ST (ROTHWELL SARAH)',
                                   'serial': '1270E47',
                                   'serial_number': '1270E47',
                                   'system_mac_address': None},
                '1273117': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6600 PERTH ROAD 121 (SAUVE JOE)',
                                   'serial': '1273117',
                                   'serial_number': '1273117',
                                   'system_mac_address': None},
                '1273473': {       'dev_macs': ['60:db:98:09:1d:22'],
                                   'ip_address': None,
                                   'name': '82 GERBER DR (ANANTHAN SUBATHA)',
                                   'serial': '1273473',
                                   'serial_number': '1273473',
                                   'system_mac_address': None},
                '12738F3': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '86 MAIN ST N (FRIESEN SHAWN)',
                                   'serial': '12738F3',
                                   'serial_number': '12738F3',
                                   'system_mac_address': None},
                '12739D9': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '55 WILLIAM ST (METERGY SOLUTIONS INC)',
                                   'serial': '12739D9',
                                   'serial_number': '12739D9',
                                   'system_mac_address': None},
                '1273AA6': {       'dev_macs': ['8c:90:2d:44:30:a8'],
                                   'ip_address': None,
                                   'name': '2390 LINE 47 (SAUDER CANDICE)',
                                   'serial': '1273AA6',
                                   'serial_number': '1273AA6',
                                   'system_mac_address': None},
                '1273ADF': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4622 PERTH LINE 55 (EBERSOL RONALD)',
                                   'serial': '1273ADF',
                                   'serial_number': '1273ADF',
                                   'system_mac_address': None},
                '1273F55': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6238 ROAD 116 (NAFZIGER POULTRY INC)',
                                   'serial': '1273F55',
                                   'serial_number': '1273F55',
                                   'system_mac_address': None},
                '1273F6F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7098 PERTH ROAD 121 (MARTIN JAMES)',
                                   'serial': '1273F6F',
                                   'serial_number': '1273F6F',
                                   'system_mac_address': None},
                '1274029': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4133 LINE 67 (KUEPFER TREVOR)',
                                   'serial': '1274029',
                                   'serial_number': '1274029',
                                   'system_mac_address': None},
                '127402B': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4186 LINE 61 (FAIRHAVEN AMISH MENNONITE '
                                           'CH)',
                                   'serial': '127402B',
                                   'serial_number': '127402B',
                                   'system_mac_address': None},
                '127402D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4155 LINE 67 (ERB KENNETH & LAURIE)',
                                   'serial': '127402D',
                                   'serial_number': '127402D',
                                   'system_mac_address': None},
                '1274037': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '15 MAIN ST S APT 203 (Psi)',
                                   'serial': '1274037',
                                   'serial_number': '1274037',
                                   'system_mac_address': None},
                '127403F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4227 LINE 50 (BRUNK MELVIN)',
                                   'serial': '127403F',
                                   'serial_number': '127403F',
                                   'system_mac_address': None},
                '1274044': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4019 LINE 67 (KUEPFER JUDY)',
                                   'serial': '1274044',
                                   'serial_number': '1274044',
                                   'system_mac_address': None},
                '127404B': {       'dev_macs': ['b8:94:70:f3:e1:28'],
                                   'ip_address': None,
                                   'name': '4742 LINE 64 (BIEHN LOWELL)',
                                   'serial': '127404B',
                                   'serial_number': '127404B',
                                   'system_mac_address': None},
                '127404C': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7034 PERTH ROAD 121 (BAUMAN MURRAY)',
                                   'serial': '127404C',
                                   'serial_number': '127404C',
                                   'system_mac_address': None},
                '1274050': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6455 ROAD 140 (STREICHER MERLIN)',
                                   'serial': '1274050',
                                   'serial_number': '1274050',
                                   'system_mac_address': None},
                '1274054': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '13 MAIN ST N (DYCK BENJAMIN)',
                                   'serial': '1274054',
                                   'serial_number': '1274054',
                                   'system_mac_address': None},
                '127405B': {       'dev_macs': [       '5c:0f:fb:43:96:ba',
                                                       '5c:0f:fb:3d:3e:b8'],
                                   'ip_address': None,
                                   'name': '5619B PERTH LINE 55 (MCEWEN R DOUGLAS)',
                                   'serial': '127405B',
                                   'serial_number': '127405B',
                                   'system_mac_address': None},
                '127405F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '69 PUGH ST MILVERTON (SHANTZ TIFFANY)',
                                   'serial': '127405F',
                                   'serial_number': '127405F',
                                   'system_mac_address': None},
                '1274061': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7020 PERTH ROAD 121 (BARBU THOMAS & ROSE)',
                                   'serial': '1274061',
                                   'serial_number': '1274061',
                                   'system_mac_address': None},
                '1274064': {       'dev_macs': ['7c:5a:1c:8b:fa:33'],
                                   'ip_address': None,
                                   'name': '4078 WATERLOO ST (PRECISION WOODCRAFT)',
                                   'serial': '1274064',
                                   'serial_number': '1274064',
                                   'system_mac_address': None},
                '1274067': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7035 PERTH ROAD 121 (SCHULTZ DELMAR & '
                                           'JANET)',
                                   'serial': '1274067',
                                   'serial_number': '1274067',
                                   'system_mac_address': None},
                '127406D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '70 MAIN ST S (1000669244ONTARIO)',
                                   'serial': '127406D',
                                   'serial_number': '127406D',
                                   'system_mac_address': None},
                '1274070': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '33 MURRAY CT (SOUTHSIDE ESTATES INC)',
                                   'serial': '1274070',
                                   'serial_number': '1274070',
                                   'system_mac_address': None},
                '1274079': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4067 LINE 61 (VAN DEN TEMPEL TED & LIZ)',
                                   'serial': '1274079',
                                   'serial_number': '1274079',
                                   'system_mac_address': None},
                '127407A': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '55 WILLIAM ST (OWUSU SELINA)',
                                   'serial': '127407A',
                                   'serial_number': '127407A',
                                   'system_mac_address': None},
                '1274081': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4710 LINE 64 (MUELLER PAUL)',
                                   'serial': '1274081',
                                   'serial_number': '1274081',
                                   'system_mac_address': None},
                '1274090': {       'dev_macs': ['b8:94:70:f3:e8:76'],
                                   'ip_address': None,
                                   'name': '62 PUGH ST (LAUFER PETER)',
                                   'serial': '1274090',
                                   'serial_number': '1274090',
                                   'system_mac_address': None},
                '1274097': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6346 PERTH ROAD 121 (ZEHR GERALD & ALICE '
                                           'BARN)',
                                   'serial': '1274097',
                                   'serial_number': '1274097',
                                   'system_mac_address': None},
                '12740A0': {       'dev_macs': ['60:db:98:09:1c:d5'],
                                   'ip_address': None,
                                   'name': '25 MURRAY CT (IONCE ANCA)',
                                   'serial': '12740A0',
                                   'serial_number': '12740A0',
                                   'system_mac_address': None},
                '12740A1': {       'dev_macs': ['14:21:03:8b:68:bd'],
                                   'ip_address': None,
                                   'name': '4575 PERTH LINE 72 (WYATT JUDY)',
                                   'serial': '12740A1',
                                   'serial_number': '12740A1',
                                   'system_mac_address': None},
                '12740A5': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4360 LINE 67 (MARTIN AARON F)',
                                   'serial': '12740A5',
                                   'serial_number': '12740A5',
                                   'system_mac_address': None},
                '12740B4': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4224 LINE 61 (CARTER ALVIN)',
                                   'serial': '12740B4',
                                   'serial_number': '12740B4',
                                   'system_mac_address': None},
                '12740B8': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '13 MAIN ST N APT 6 MILVERTON',
                                   'serial': '12740B8',
                                   'serial_number': '12740B8',
                                   'system_mac_address': None},
                '12740BD': {       'dev_macs': ['60:db:98:09:39:c0'],
                                   'ip_address': None,
                                   'name': '25 MURRAY CT (POLANIC ADRIANA)',
                                   'serial': '12740BD',
                                   'serial_number': '12740BD',
                                   'system_mac_address': None},
                '12740BF': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6672 ROAD 129 (KUEPFER PAUL)',
                                   'serial': '12740BF',
                                   'serial_number': '12740BF',
                                   'system_mac_address': None},
                '12740C6': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4913 ROAD 122 (PLAYERDISE FARMS LTD)',
                                   'serial': '12740C6',
                                   'serial_number': '12740C6',
                                   'system_mac_address': None},
                '12740C8': {       'dev_macs': ['00:03:e6:fa:10:50'],
                                   'ip_address': None,
                                   'name': '7110 PERTH ROAD 121 (ZAWADZKI MAREK)',
                                   'serial': '12740C8',
                                   'serial_number': '12740C8',
                                   'system_mac_address': None},
                '12740C9': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4192 LINE 61 (RAYNER WILLIAM)',
                                   'serial': '12740C9',
                                   'serial_number': '12740C9',
                                   'system_mac_address': None},
                '12740DD': {       'dev_macs': ['44:65:7f:88:d2:67'],
                                   'ip_address': None,
                                   'name': '5225 ROAD 130 (STEPHENSON BOB)',
                                   'serial': '12740DD',
                                   'serial_number': '12740DD',
                                   'system_mac_address': None},
                '12740EB': {       'dev_macs': ['44:65:7f:72:7d:cd'],
                                   'ip_address': None,
                                   'name': '81 Reagan St Milverton (K Saysangkhy '
                                           '104355220)',
                                   'serial': '12740EB',
                                   'serial_number': '12740EB',
                                   'system_mac_address': None},
                '12740ED': {       'dev_macs': ['14:21:03:8b:70:6e'],
                                   'ip_address': None,
                                   'name': '2288 LINE 45 (MCMILLAN ROBERT)',
                                   'serial': '12740ED',
                                   'serial_number': '12740ED',
                                   'system_mac_address': None},
                '127411B': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4773 LINE 64 (BYLER JAMES)',
                                   'serial': '127411B',
                                   'serial_number': '127411B',
                                   'system_mac_address': None},
                '1274125': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '17 WEST ST (ALLEN JIM)',
                                   'serial': '1274125',
                                   'serial_number': '1274125',
                                   'system_mac_address': None},
                '127418D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4784 LINE 64 (FABER JOHN)',
                                   'serial': '127418D',
                                   'serial_number': '127418D',
                                   'system_mac_address': None},
                '127418F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6940 HORIZON TRAIL (KUEPFER CALVIN R)',
                                   'serial': '127418F',
                                   'serial_number': '127418F',
                                   'system_mac_address': None},
                '1274190': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '78 MAIN ST N (KUEPFER JOHN & EILEEN)',
                                   'serial': '1274190',
                                   'serial_number': '1274190',
                                   'system_mac_address': None},
                '1274193': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4223 LINE 61 (DIETRICH JESSE & JENNA)',
                                   'serial': '1274193',
                                   'serial_number': '1274193',
                                   'system_mac_address': None},
                '1274196': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4165 LINE 50 (JANTZI ROSS)',
                                   'serial': '1274196',
                                   'serial_number': '1274196',
                                   'system_mac_address': None},
                '127419A': {       'dev_macs': [       '5c:0f:fb:2a:c5:00',
                                                       '5c:0f:fb:2a:c7:32'],
                                   'ip_address': None,
                                   'name': '148 MADDISON ST E MONKTON (WICK GARY)',
                                   'serial': '127419A',
                                   'serial_number': '127419A',
                                   'system_mac_address': None},
                '127419D': {       'dev_macs': ['b8:94:70:f3:e0:15'],
                                   'ip_address': None,
                                   'name': '105 PUGH ST (HEIDENREICH MIKE & JEANETTE)',
                                   'serial': '127419D',
                                   'serial_number': '127419D',
                                   'system_mac_address': None},
                '127419E': {       'dev_macs': ['14:21:03:8b:7a:24'],
                                   'ip_address': None,
                                   'name': '113 PUGH ST (MAYNE STEPH)',
                                   'serial': '127419E',
                                   'serial_number': '127419E',
                                   'system_mac_address': None},
                '127419F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6700 ROAD 129 (JANTZI DOUG)',
                                   'serial': '127419F',
                                   'serial_number': '127419F',
                                   'system_mac_address': None},
                '12741A0': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6390 PERTH ROAD 121 (BUECKERT HENRY & '
                                           'TINA)',
                                   'serial': '12741A0',
                                   'serial_number': '12741A0',
                                   'system_mac_address': None},
                '12741A2': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7285 PERTH ROAD 121 (ALBRECHT LLOYD)',
                                   'serial': '12741A2',
                                   'serial_number': '12741A2',
                                   'system_mac_address': None},
                '12741AF': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6475 PERTH ROAD 121 (POOLE MENNONITE '
                                           'CHURCH)',
                                   'serial': '12741AF',
                                   'serial_number': '12741AF',
                                   'system_mac_address': None},
                '12741B0': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4187 LINE 61 (ZEHR TIM & LILLIAN)',
                                   'serial': '12741B0',
                                   'serial_number': '12741B0',
                                   'system_mac_address': None},
                '12741BB': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7401 PERTH ROAD 121 (SAUDER MERVIN)',
                                   'serial': '12741BB',
                                   'serial_number': '12741BB',
                                   'system_mac_address': None},
                '12741BC': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7033 PERTH ROAD 121 (SCHELLENBERGER '
                                           'FRIEDA)',
                                   'serial': '12741BC',
                                   'serial_number': '12741BC',
                                   'system_mac_address': None},
                '12741BF': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4410 LINE 61 (KUEPFER VERNON & DARLENE)',
                                   'serial': '12741BF',
                                   'serial_number': '12741BF',
                                   'system_mac_address': None},
                '12741CD': {       'dev_macs': ['6c:63:f8:39:1e:d7'],
                                   'ip_address': None,
                                   'name': '4199 LINE 61 MILVERTON (BOSHART '
                                           'INDUSTRIES)',
                                   'serial': '12741CD',
                                   'serial_number': '12741CD',
                                   'system_mac_address': None},
                '12741D0': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5346 PERTH ROAD 135 (SANDY PEAK DAIRY LTD)',
                                   'serial': '12741D0',
                                   'serial_number': '12741D0',
                                   'system_mac_address': None},
                '12741D2': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4560 PERTH LINE 72 (KUEPFER LESTER)',
                                   'serial': '12741D2',
                                   'serial_number': '12741D2',
                                   'system_mac_address': None},
                '1274214': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6345 PERTH ROAD 121 (VAN DEN TEMPEL '
                                           'LAUREN)',
                                   'serial': '1274214',
                                   'serial_number': '1274214',
                                   'system_mac_address': None},
                '1274217': {       'dev_macs': ['60:db:98:09:1f:f8'],
                                   'ip_address': None,
                                   'name': '4093 LINE 61 (YODER LYNFORD)',
                                   'serial': '1274217',
                                   'serial_number': '1274217',
                                   'system_mac_address': None},
                '1274220': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7446 PERTH ROAD 121 (BURKHART WAYNE)',
                                   'serial': '1274220',
                                   'serial_number': '1274220',
                                   'system_mac_address': None},
                '1274298': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7092 PERTH ROAD 121 (WEBER SARAH & EDNA)',
                                   'serial': '1274298',
                                   'serial_number': '1274298',
                                   'system_mac_address': None},
                '127429B': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7212 PERTH ROAD 121 (BURKHART JAMES M)',
                                   'serial': '127429B',
                                   'serial_number': '127429B',
                                   'system_mac_address': None},
                '12742A5': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4896 PERTH LINE 72 (CARTER MARY)',
                                   'serial': '12742A5',
                                   'serial_number': '12742A5',
                                   'system_mac_address': None},
                '12742A8': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '155 WINSTANLEY ST MONKTON (SIMPSON DENNIS)',
                                   'serial': '12742A8',
                                   'serial_number': '12742A8',
                                   'system_mac_address': None},
                '12742D2': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6346 PERTH ROAD 121 (ZEHR GERALD & ALICE '
                                           'HOUSE)',
                                   'serial': '12742D2',
                                   'serial_number': '12742D2',
                                   'system_mac_address': None},
                '12742D4': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4010 LINE 67 (KUEPFER PAUL A & MARY)',
                                   'serial': '12742D4',
                                   'serial_number': '12742D4',
                                   'system_mac_address': None},
                '12742D9': {       'dev_macs': ['04:bc:9f:46:ab:f5'],
                                   'ip_address': None,
                                   'name': '4111 LINE 73 (MORALES HUGO)',
                                   'serial': '12742D9',
                                   'serial_number': '12742D9',
                                   'system_mac_address': None},
                '12742DB': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4375 PERTH LINE 72 (FRIESEN ARNO)',
                                   'serial': '12742DB',
                                   'serial_number': '12742DB',
                                   'system_mac_address': None},
                '12742E0': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '3994 LINE 61 (VAN NES JAMES)',
                                   'serial': '12742E0',
                                   'serial_number': '12742E0',
                                   'system_mac_address': None},
                '12742E4': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7272 PERTH ROAD 121 (MARTIN BENJAMIN)',
                                   'serial': '12742E4',
                                   'serial_number': '12742E4',
                                   'system_mac_address': None},
                '12742E7': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '80 MAIN ST N (GOFTON LAURA)',
                                   'serial': '12742E7',
                                   'serial_number': '12742E7',
                                   'system_mac_address': None},
                '12742ED': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4084 LINE 50 (MANTLE BRUCE)',
                                   'serial': '12742ED',
                                   'serial_number': '12742ED',
                                   'system_mac_address': None},
                '12742F5': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7082 PERTH ROAD 121 (MORALES MAYDA)',
                                   'serial': '12742F5',
                                   'serial_number': '12742F5',
                                   'system_mac_address': None},
                '12742F6': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7452 PERTH ROAD 121 (FERNBANK PAROCHIAL '
                                           'SCHOOL)',
                                   'serial': '12742F6',
                                   'serial_number': '12742F6',
                                   'system_mac_address': None},
                '12742F8': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7007 ROAD 124 (LEIS ROBERT)',
                                   'serial': '12742F8',
                                   'serial_number': '12742F8',
                                   'system_mac_address': None},
                '1274304': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4229 LINE 61 (ZEHR SAWYER)',
                                   'serial': '1274304',
                                   'serial_number': '1274304',
                                   'system_mac_address': None},
                '1274309': {       'dev_macs': ['14:21:03:8b:6a:07'],
                                   'ip_address': None,
                                   'name': '6194 ROAD 116 (WAGLER RUTH)',
                                   'serial': '1274309',
                                   'serial_number': '1274309',
                                   'system_mac_address': None},
                '127430C': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4144 LINE 61 (KUEPFER FLOYD)',
                                   'serial': '127430C',
                                   'serial_number': '127430C',
                                   'system_mac_address': None},
                '127430F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6799 ROAD 129 (JANTZI LEVI K)',
                                   'serial': '127430F',
                                   'serial_number': '127430F',
                                   'system_mac_address': None},
                '1274317': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7374 PERTH ROAD 121 (BAUMAN DEAN)',
                                   'serial': '1274317',
                                   'serial_number': '1274317',
                                   'system_mac_address': None},
                '1274320': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4234 LINE 46 (CATANIA JACKIE)',
                                   'serial': '1274320',
                                   'serial_number': '1274320',
                                   'system_mac_address': None},
                '1274323': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6394 PERTH ROAD 121 (YANTZI AMY)',
                                   'serial': '1274323',
                                   'serial_number': '1274323',
                                   'system_mac_address': None},
                '1274329': {       'dev_macs': ['d0:76:8f:1f:53:52'],
                                   'ip_address': None,
                                   'name': '2 EDWARD ST (HOLST NELSON)',
                                   'serial': '1274329',
                                   'serial_number': '1274329',
                                   'system_mac_address': None},
                '1274333': {       'dev_macs': ['14:21:03:8b:6f:66'],
                                   'ip_address': None,
                                   'name': '5964 PERTH ROAD 119 (GERBER JOSEPH)',
                                   'serial': '1274333',
                                   'serial_number': '1274333',
                                   'system_mac_address': None},
                '1274335': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '113 MILL ST E (KIPFER REX)',
                                   'serial': '1274335',
                                   'serial_number': '1274335',
                                   'system_mac_address': None},
                '1274336': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7027 PERTH ROAD 121 (TERRY-ROSS ROBIN)',
                                   'serial': '1274336',
                                   'serial_number': '1274336',
                                   'system_mac_address': None},
                '127433A': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4184 LINE 61 (FAIRHAVEN CH DAY SCHOOL)',
                                   'serial': '127433A',
                                   'serial_number': '127433A',
                                   'system_mac_address': None},
                '1274341': {       'dev_macs': ['44:65:7f:89:0e:73'],
                                   'ip_address': None,
                                   'name': '5 MAIN ST S (GERBER CASSIDY)',
                                   'serial': '1274341',
                                   'serial_number': '1274341',
                                   'system_mac_address': None},
                '12743E4': {       'dev_macs': ['14:21:03:92:ec:de'],
                                   'ip_address': None,
                                   'name': '13 PIERSON ST (HENRY SHAWN)',
                                   'serial': '12743E4',
                                   'serial_number': '12743E4',
                                   'system_mac_address': None},
                '12744B2': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '2339 LINE 45 (HART DAWN)',
                                   'serial': '12744B2',
                                   'serial_number': '12744B2',
                                   'system_mac_address': None},
                '127458F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5083 LINE 60 (GINGRICH TONY)',
                                   'serial': '127458F',
                                   'serial_number': '127458F',
                                   'system_mac_address': None},
                '1274593': {       'dev_macs': ['14:21:03:92:ed:2b'],
                                   'ip_address': None,
                                   'name': '5454 ROAD 126 (NEFF ALLEN & IRMA)',
                                   'serial': '1274593',
                                   'serial_number': '1274593',
                                   'system_mac_address': None},
                '12745D9': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4107 LINE 61 (THIESSEN JACOB)',
                                   'serial': '12745D9',
                                   'serial_number': '12745D9',
                                   'system_mac_address': None},
                '12745FC': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4460B PERTH LINE 72',
                                   'serial': '12745FC',
                                   'serial_number': '12745FC',
                                   'system_mac_address': None},
                '127460E': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7 ST MARYS ST N (GROPP KEN (ESTATE OF))',
                                   'serial': '127460E',
                                   'serial_number': '127460E',
                                   'system_mac_address': None},
                '1274681': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4460B PERTH LINE 72 (PETERS WILHELM & '
                                           'ELIZABETH)',
                                   'serial': '1274681',
                                   'serial_number': '1274681',
                                   'system_mac_address': None},
                '127469C': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7477 PERTH ROAD 121 (SAUDER ORVIE)',
                                   'serial': '127469C',
                                   'serial_number': '127469C',
                                   'system_mac_address': None},
                '12746BB': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '14 ST MARYS ST S (KERSTEN THEO)',
                                   'serial': '12746BB',
                                   'serial_number': '12746BB',
                                   'system_mac_address': None},
                '12746CA': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4372 LINE 61 (ALBRECHT JOHN)',
                                   'serial': '12746CA',
                                   'serial_number': '12746CA',
                                   'system_mac_address': None},
                '12746CD': {       'dev_macs': ['14:21:03:d1:7e:33'],
                                   'ip_address': None,
                                   'name': '4578 LINE 46 (PETERSON MONTGOMERY)',
                                   'serial': '12746CD',
                                   'serial_number': '12746CD',
                                   'system_mac_address': None},
                '12746D0': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4429 PERTH LINE 72 (TOMIUK TIM)',
                                   'serial': '12746D0',
                                   'serial_number': '12746D0',
                                   'system_mac_address': None},
                '12746E1': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4113 LINE 61 (JANTZI GABRIEL)',
                                   'serial': '12746E1',
                                   'serial_number': '12746E1',
                                   'system_mac_address': None},
                '1274702': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '124 WINSTANLEY ST (COOK TAMMY)',
                                   'serial': '1274702',
                                   'serial_number': '1274702',
                                   'system_mac_address': None},
                '1274711': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4444 PERTH LINE 72 (MARTIN CHRIS)',
                                   'serial': '1274711',
                                   'serial_number': '1274711',
                                   'system_mac_address': None},
                '1274722': {       'dev_macs': ['b8:94:70:9e:cd:3b'],
                                   'ip_address': None,
                                   'name': '4056 LINE 46 (ROES MELVIN)',
                                   'serial': '1274722',
                                   'serial_number': '1274722',
                                   'system_mac_address': None},
                '127473A': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5595 ROAD 126 (ROTH BRENT)',
                                   'serial': '127473A',
                                   'serial_number': '127473A',
                                   'system_mac_address': None},
                '127473D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6019 PERTH ROAD 119 (GERLACH CONNIE)',
                                   'serial': '127473D',
                                   'serial_number': '127473D',
                                   'system_mac_address': None},
                '1274744': {       'dev_macs': ['84:39:8f:ed:41:5e'],
                                   'ip_address': None,
                                   'name': '42 AVERY PL (VAN NIEROP DAVE)',
                                   'serial': '1274744',
                                   'serial_number': '1274744',
                                   'system_mac_address': None},
                '1274761': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7464 PERTH ROAD 121 (ALBRECHT EDWARD)',
                                   'serial': '1274761',
                                   'serial_number': '1274761',
                                   'system_mac_address': None},
                '127478A': {       'dev_macs': ['14:21:03:d1:8c:82'],
                                   'ip_address': None,
                                   'name': '20 ARENA DR (NICHOLSON JOHN)',
                                   'serial': '127478A',
                                   'serial_number': '127478A',
                                   'system_mac_address': None},
                '127478D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4006 LINE 61 (STREICHER LAVERNE)',
                                   'serial': '127478D',
                                   'serial_number': '127478D',
                                   'system_mac_address': None},
                '127478F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6477A PERTH ROAD 121 (KUEPFER CLAYTON J '
                                           'AND SHARON)',
                                   'serial': '127478F',
                                   'serial_number': '127478F',
                                   'system_mac_address': None},
                '1274798': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6752 PERTH ROAD 121 (NITHVALLEY FARMS)',
                                   'serial': '1274798',
                                   'serial_number': '1274798',
                                   'system_mac_address': None},
                '127479A': {       'dev_macs': ['14:21:03:d1:89:07'],
                                   'ip_address': None,
                                   'name': '57 WILLIAM ST (EVANS HEATHER)',
                                   'serial': '127479A',
                                   'serial_number': '127479A',
                                   'system_mac_address': None},
                '12747A1': {       'dev_macs': ['d0:76:8f:1f:58:85'],
                                   'ip_address': None,
                                   'name': '34 MAIN ST S MILVERTON (FOSTER ANNE)',
                                   'serial': '12747A1',
                                   'serial_number': '12747A1',
                                   'system_mac_address': None},
                '12747A6': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '14 CRUICKSHANK ST (TIGANI JAMES)',
                                   'serial': '12747A6',
                                   'serial_number': '12747A6',
                                   'system_mac_address': None},
                '12747AF': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7014 PERTH ROAD 121 (KUEPFER WAYNE)',
                                   'serial': '12747AF',
                                   'serial_number': '12747AF',
                                   'system_mac_address': None},
                '12747B8': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5977 PERTH ROAD 119 (JANTZI BRIAN & BEV)',
                                   'serial': '12747B8',
                                   'serial_number': '12747B8',
                                   'system_mac_address': None},
                '12747B9': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4346 LINE 64 (JANTZI JASON & ROCHELLE)',
                                   'serial': '12747B9',
                                   'serial_number': '12747B9',
                                   'system_mac_address': None},
                '12747C1': {       'dev_macs': ['60:db:98:57:b5:0e'],
                                   'ip_address': None,
                                   'name': '5001 ROAD 109 (ROSE JOANNE)',
                                   'serial': '12747C1',
                                   'serial_number': '12747C1',
                                   'system_mac_address': None},
                '12747C4': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4785 LINE 67 (WAGLER WELDING)',
                                   'serial': '12747C4',
                                   'serial_number': '12747C4',
                                   'system_mac_address': None},
                '12747C6': {       'dev_macs': ['14:21:03:d1:8a:d5'],
                                   'ip_address': None,
                                   'name': '5250 LINE 60 (CARTER JORDAN)',
                                   'serial': '12747C6',
                                   'serial_number': '12747C6',
                                   'system_mac_address': None},
                '12747D6': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7026 PERTH ROAD 121 (SCHMIDT KATHRYN)',
                                   'serial': '12747D6',
                                   'serial_number': '12747D6',
                                   'system_mac_address': None},
                '12747E1': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4951 LINE 67 (KUEPFER MANUEL & IRENE)',
                                   'serial': '12747E1',
                                   'serial_number': '12747E1',
                                   'system_mac_address': None},
                '12747FB': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4462 PERTH LINE 72',
                                   'serial': '12747FB',
                                   'serial_number': '12747FB',
                                   'system_mac_address': None},
                '12747FF': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4513 LINE 49 (WAGLER MURRAY)',
                                   'serial': '12747FF',
                                   'serial_number': '12747FF',
                                   'system_mac_address': None},
                '1274800': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6023 PERTH ROAD 119 (ALBRECHT ARNOLD)',
                                   'serial': '1274800',
                                   'serial_number': '1274800',
                                   'system_mac_address': None},
                '1274801': {       'dev_macs': ['44:65:7f:3e:b2:36'],
                                   'ip_address': None,
                                   'name': '4 TEMPERANCE ST (BULMER STUART)',
                                   'serial': '1274801',
                                   'serial_number': '1274801',
                                   'system_mac_address': None},
                '127481E': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '17 PIERSON ST (MORNINGTON COMMUNICATIONS)',
                                   'serial': '127481E',
                                   'serial_number': '127481E',
                                   'system_mac_address': None},
                '1274829': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6908 PERTH ROAD 121 (DJ KUEPFER & FAMILY '
                                           'INC)',
                                   'serial': '1274829',
                                   'serial_number': '1274829',
                                   'system_mac_address': None},
                '1274844': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4003 LINE 61 (JANTZI ALLAN)',
                                   'serial': '1274844',
                                   'serial_number': '1274844',
                                   'system_mac_address': None},
                '127484E': {       'dev_macs': ['14:21:03:d1:8c:a3'],
                                   'ip_address': None,
                                   'name': '4042 WATERLOO ST (PENNER JOHAN)',
                                   'serial': '127484E',
                                   'serial_number': '127484E',
                                   'system_mac_address': None},
                '127485C': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7008 ROAD 129 (NEWTON IRON INC)',
                                   'serial': '127485C',
                                   'serial_number': '127485C',
                                   'system_mac_address': None},
                '127485D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6800 ROAD 129 (KUEPFER CARL A)',
                                   'serial': '127485D',
                                   'serial_number': '127485D',
                                   'system_mac_address': None},
                '1274862': {       'dev_macs': ['48:77:46:d2:79:8e'],
                                   'ip_address': None,
                                   'name': '38 AVERY PL (ALENCAR ISABEL)',
                                   'serial': '1274862',
                                   'serial_number': '1274862',
                                   'system_mac_address': None},
                '1274865': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4300 LINE 61 (KUEPFER MERVIN)',
                                   'serial': '1274865',
                                   'serial_number': '1274865',
                                   'system_mac_address': None},
                '1274869': {       'dev_macs': ['ec:4f:82:ac:ed:66'],
                                   'ip_address': None,
                                   'name': '10 SPENCER ST (AW MILLWRIGHTS)',
                                   'serial': '1274869',
                                   'serial_number': '1274869',
                                   'system_mac_address': None},
                '127486F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '8 GERBER DR (KNIPE DOROTHY)',
                                   'serial': '127486F',
                                   'serial_number': '127486F',
                                   'system_mac_address': None},
                '1274871': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4852 ROAD 109 (COOK CHRIS)',
                                   'serial': '1274871',
                                   'serial_number': '1274871',
                                   'system_mac_address': None},
                '1274874': {       'dev_macs': ['14:21:03:d1:8a:30'],
                                   'ip_address': None,
                                   'name': '4820 ROAD 108 (SCHULER KEVIN)',
                                   'serial': '1274874',
                                   'serial_number': '1274874',
                                   'system_mac_address': None},
                '1274875': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5445 ROAD 108 (LUCKHARDT SHELLEY)',
                                   'serial': '1274875',
                                   'serial_number': '1274875',
                                   'system_mac_address': None},
                '127488B': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6476 PERTH ROAD 121 (ROPP WAYNE)',
                                   'serial': '127488B',
                                   'serial_number': '127488B',
                                   'system_mac_address': None},
                '1274893': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '141 PUGH ST (HULLEY CRYSTAL)',
                                   'serial': '1274893',
                                   'serial_number': '1274893',
                                   'system_mac_address': None},
                '1274895': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': "7022 ROAD 129 (THIESSEN BROTHER'S CUSTOM "
                                           'WOOD)',
                                   'serial': '1274895',
                                   'serial_number': '1274895',
                                   'system_mac_address': None},
                '12748A1': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4943 ROAD 108 (COOK FRANCES)',
                                   'serial': '12748A1',
                                   'serial_number': '12748A1',
                                   'system_mac_address': None},
                '12748B1': {       'dev_macs': ['14:21:03:a9:70:7e'],
                                   'ip_address': None,
                                   'name': '6475 ROAD 116 (SCHULTZ WILLIAM)',
                                   'serial': '12748B1',
                                   'serial_number': '12748B1',
                                   'system_mac_address': None},
                '1274913': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6662 ROAD 116 (SCHMIDT TIM)',
                                   'serial': '1274913',
                                   'serial_number': '1274913',
                                   'system_mac_address': None},
                '1274917': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5384 PERTH LINE 55 (PARTRIDGE RYAN)',
                                   'serial': '1274917',
                                   'serial_number': '1274917',
                                   'system_mac_address': None},
                '1274946': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4348 PERTH LINE 72 (BAUMAN JOSEPH M)',
                                   'serial': '1274946',
                                   'serial_number': '1274946',
                                   'system_mac_address': None},
                '127495E': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4094A LINE 61 (STECKLY SHEILA)',
                                   'serial': '127495E',
                                   'serial_number': '127495E',
                                   'system_mac_address': None},
                '127496F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7 GEORGE ST (WAGLER CATHERINE)',
                                   'serial': '127496F',
                                   'serial_number': '127496F',
                                   'system_mac_address': None},
                '1274987': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '3984 LINE 67 (ZEHR TERRY & SUE)',
                                   'serial': '1274987',
                                   'serial_number': '1274987',
                                   'system_mac_address': None},
                '1274993': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4087 LINE 61 (GOOD DWIGHT)',
                                   'serial': '1274993',
                                   'serial_number': '1274993',
                                   'system_mac_address': None},
                '1274997': {       'dev_macs': ['b8:94:70:f3:e9:1b'],
                                   'ip_address': None,
                                   'name': '108 PUGH ST (SANGWA MARIE)',
                                   'serial': '1274997',
                                   'serial_number': '1274997',
                                   'system_mac_address': None},
                '127499C': {       'dev_macs': ['b8:94:70:f3:e2:7d'],
                                   'ip_address': None,
                                   'name': '4011 LINE 61 (BANKS BRETT)',
                                   'serial': '127499C',
                                   'serial_number': '127499C',
                                   'system_mac_address': None},
                '127499F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6143 ANA ST (NAFZIGER CHRIS)',
                                   'serial': '127499F',
                                   'serial_number': '127499F',
                                   'system_mac_address': None},
                '12749A5': {       'dev_macs': ['d0:76:8f:91:d5:a3'],
                                   'ip_address': None,
                                   'name': '101 PUGH ST MILVERTON (HENHOEFFER BONNIE)',
                                   'serial': '12749A5',
                                   'serial_number': '12749A5',
                                   'system_mac_address': None},
                '12749A7': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6404 PERTH ROAD 121 (ROTH IRENE I)',
                                   'serial': '12749A7',
                                   'serial_number': '12749A7',
                                   'system_mac_address': None},
                '12749A8': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '13 MAIN ST N (DURAN PEREZ SERGIO TOMAS)',
                                   'serial': '12749A8',
                                   'serial_number': '12749A8',
                                   'system_mac_address': None},
                '12749B3': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6755 ROAD 116 (JANTZI GERALD W)',
                                   'serial': '12749B3',
                                   'serial_number': '12749B3',
                                   'system_mac_address': None},
                '12749B4': {       'dev_macs': ['b8:94:70:f3:e7:42'],
                                   'ip_address': None,
                                   'name': '5913 PERTH ROAD 119 (THOMPSON STACY)',
                                   'serial': '12749B4',
                                   'serial_number': '12749B4',
                                   'system_mac_address': None},
                '12749C1': {       'dev_macs': ['14:21:03:8b:69:6d'],
                                   'ip_address': None,
                                   'name': '7116 PERTH ROAD 121 (KUEPFER GARY & MARY '
                                           'LOU)',
                                   'serial': '12749C1',
                                   'serial_number': '12749C1',
                                   'system_mac_address': None},
                '12749C3': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6799 ROAD 129 (JANTZI PERRY & KRISTA)',
                                   'serial': '12749C3',
                                   'serial_number': '12749C3',
                                   'system_mac_address': None},
                '12749C5': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7112 PERTH ROAD 121',
                                   'serial': '12749C5',
                                   'serial_number': '12749C5',
                                   'system_mac_address': None},
                '12749C6': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4001 LINE 61 (GINGERICH CLARE)',
                                   'serial': '12749C6',
                                   'serial_number': '12749C6',
                                   'system_mac_address': None},
                '12749C7': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': 'VICTOR POOLE (6314 RD 124)',
                                   'serial': '12749C7',
                                   'serial_number': '12749C7',
                                   'system_mac_address': None},
                '12749CC': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4413 PERTH LINE 72 (BAUMAN TOBIAS)',
                                   'serial': '12749CC',
                                   'serial_number': '12749CC',
                                   'system_mac_address': None},
                '12749E1': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6825 PERTH ROAD 121 (KUEPFER DAVID & ANNA '
                                           'MAE)',
                                   'serial': '12749E1',
                                   'serial_number': '12749E1',
                                   'system_mac_address': None},
                '12749EC': {       'dev_macs': ['b8:94:70:f3:e6:be'],
                                   'ip_address': None,
                                   'name': '57 MILL ST E MILVERTON (HUNTER BILL)',
                                   'serial': '12749EC',
                                   'serial_number': '12749EC',
                                   'system_mac_address': None},
                '12749F1': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6376 PERTH ROAD 121 (WAGLER CHARLES)',
                                   'serial': '12749F1',
                                   'serial_number': '12749F1',
                                   'system_mac_address': None},
                '12749F2': {       'dev_macs': ['b8:94:70:f3:e6:03'],
                                   'ip_address': None,
                                   'name': 'ont 232558',
                                   'serial': '12749F2',
                                   'serial_number': '12749F2',
                                   'system_mac_address': None},
                '12749F4': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '3948 LINE 67 (SCHMIDT JAMES)',
                                   'serial': '12749F4',
                                   'serial_number': '12749F4',
                                   'system_mac_address': None},
                '12749F5': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4741 LINE 64 (SCHADE MARY)',
                                   'serial': '12749F5',
                                   'serial_number': '12749F5',
                                   'system_mac_address': None},
                '12749FA': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4228 LINE 61 (GASCHO DAN)',
                                   'serial': '12749FA',
                                   'serial_number': '12749FA',
                                   'system_mac_address': None},
                '12749FC': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6946B PERTH ROAD 121 (THIBIDEAU KALEB)',
                                   'serial': '12749FC',
                                   'serial_number': '12749FC',
                                   'system_mac_address': None},
                '12749FF': {       'dev_macs': ['00:03:e6:f9:bc:38'],
                                   'ip_address': None,
                                   'name': '57 WILLIAM ST (PLAGER JEFFREY)',
                                   'serial': '12749FF',
                                   'serial_number': '12749FF',
                                   'system_mac_address': None},
                '1274A00': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4007 LINE 61 (BINKLE MURRAY)',
                                   'serial': '1274A00',
                                   'serial_number': '1274A00',
                                   'system_mac_address': None},
                '1274A01': {       'dev_macs': ['74:ac:b9:1f:74:ed'],
                                   'ip_address': None,
                                   'name': '15 MAIN ST S (ELLIS CHARLES)',
                                   'serial': '1274A01',
                                   'serial_number': '1274A01',
                                   'system_mac_address': None},
                '1274A05': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4404 PERTH LINE 72 (BAUMAN JESSE)',
                                   'serial': '1274A05',
                                   'serial_number': '1274A05',
                                   'system_mac_address': None},
                '1274A07': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6653 PERTH ROAD 121 (KUEPFER MANUEL A & '
                                           'RUTH ANNE)',
                                   'serial': '1274A07',
                                   'serial_number': '1274A07',
                                   'system_mac_address': None},
                '1274A08': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7120 PERTH ROAD 121 (ZEHR LAVERNE)',
                                   'serial': '1274A08',
                                   'serial_number': '1274A08',
                                   'system_mac_address': None},
                '1274A0B': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6765 PERTH ROAD 121 (ADAMS STEVE)',
                                   'serial': '1274A0B',
                                   'serial_number': '1274A0B',
                                   'system_mac_address': None},
                '1274A0D': {       'dev_macs': ['14:21:03:92:eb:31'],
                                   'ip_address': None,
                                   'name': '4091 LINE 61 (KUEPFER ROGER)',
                                   'serial': '1274A0D',
                                   'serial_number': '1274A0D',
                                   'system_mac_address': None},
                '1274A0E': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4898 PERTH LINE 72 (CARTER CHERYL)',
                                   'serial': '1274A0E',
                                   'serial_number': '1274A0E',
                                   'system_mac_address': None},
                '1274A0F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4410 LINE 64 (EGLI URS)',
                                   'serial': '1274A0F',
                                   'serial_number': '1274A0F',
                                   'system_mac_address': None},
                '1274A11': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4133 LINE 73 (MARTIN MELVIN & SHARON)',
                                   'serial': '1274A11',
                                   'serial_number': '1274A11',
                                   'system_mac_address': None},
                '1274A12': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6535 PERTH ROAD 121 (BRINSTON BRET)',
                                   'serial': '1274A12',
                                   'serial_number': '1274A12',
                                   'system_mac_address': None},
                '1274A19': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4094B LINE 61 (NEUFELD HELENA)',
                                   'serial': '1274A19',
                                   'serial_number': '1274A19',
                                   'system_mac_address': None},
                '1274A1D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4976 PERTH LINE 72 (CARTER CATHERINE)',
                                   'serial': '1274A1D',
                                   'serial_number': '1274A1D',
                                   'system_mac_address': None},
                '1274A1F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6906 ELGIN ST (HERRFORT MARLENE)',
                                   'serial': '1274A1F',
                                   'serial_number': '1274A1F',
                                   'system_mac_address': None},
                '1274A22': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6396 PERTH ROAD 121 (DEGROOT STEVEN)',
                                   'serial': '1274A22',
                                   'serial_number': '1274A22',
                                   'system_mac_address': None},
                '1274A23': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6574 ROAD 116 (MCCOY CHRISTINE)',
                                   'serial': '1274A23',
                                   'serial_number': '1274A23',
                                   'system_mac_address': None},
                '1274A25': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7019 ROAD 129 (STREICHER CARL)',
                                   'serial': '1274A25',
                                   'serial_number': '1274A25',
                                   'system_mac_address': None},
                '1274A26': {       'dev_macs': ['cc:32:e5:b2:c9:cd'],
                                   'ip_address': None,
                                   'name': '2541 LINE 54 (ERB HAROLD)',
                                   'serial': '1274A26',
                                   'serial_number': '1274A26',
                                   'system_mac_address': None},
                '1274A28': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4788 LINE 67 (EGLI ROGER)',
                                   'serial': '1274A28',
                                   'serial_number': '1274A28',
                                   'system_mac_address': None},
                '1274A2E': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4493 LINE 61 (ALBRECHT KEN K)',
                                   'serial': '1274A2E',
                                   'serial_number': '1274A2E',
                                   'system_mac_address': None},
                '1274A33': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6176 PERTH ROAD 121 (ALBRECHT SANDRA)',
                                   'serial': '1274A33',
                                   'serial_number': '1274A33',
                                   'system_mac_address': None},
                '1274A37': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4172 PERTH LINE 72 (FENTON EUGENE & '
                                           'LESLEY)',
                                   'serial': '1274A37',
                                   'serial_number': '1274A37',
                                   'system_mac_address': None},
                '1274A3C': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4013 LINE 61 (KUEPFER ROSS D)',
                                   'serial': '1274A3C',
                                   'serial_number': '1274A3C',
                                   'system_mac_address': None},
                '1274A3F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4097 LINE 50 (NEEB RICHARD)',
                                   'serial': '1274A3F',
                                   'serial_number': '1274A3F',
                                   'system_mac_address': None},
                '1274A40': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7455 PERTH ROAD 121 (KUEPFER MURRAY & '
                                           'ELIZABETH)',
                                   'serial': '1274A40',
                                   'serial_number': '1274A40',
                                   'system_mac_address': None},
                '1274A42': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4164 LINE 61 (SIEGNER PAUL)',
                                   'serial': '1274A42',
                                   'serial_number': '1274A42',
                                   'system_mac_address': None},
                '1274A44': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '139 MADDISON ST E (WEIR TERESA & ROBIN)',
                                   'serial': '1274A44',
                                   'serial_number': '1274A44',
                                   'system_mac_address': None},
                '1274A4A': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4112 LINE 61 (JANTZI NICK)',
                                   'serial': '1274A4A',
                                   'serial_number': '1274A4A',
                                   'system_mac_address': None},
                '1274A4C': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '162 SMITH ST (SMITH BRENDA)',
                                   'serial': '1274A4C',
                                   'serial_number': '1274A4C',
                                   'system_mac_address': None},
                '1274A50': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6566 PERTH ROAD 121 (ZEHR BRYAN & HEIDI)',
                                   'serial': '1274A50',
                                   'serial_number': '1274A50',
                                   'system_mac_address': None},
                '1274A51': {       'dev_macs': [       '00:03:e6:da:bb:34',
                                                       '00:03:e6:db:30:70'],
                                   'ip_address': None,
                                   'name': '5333 Line 49 Gadshill (Gerald Pol '
                                           '10401245)',
                                   'serial': '1274A51',
                                   'serial_number': '1274A51',
                                   'system_mac_address': None},
                '1274A52': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6395 PERTH ROAD 121 (JANTZI EXCAVATING & '
                                           'BULLDOZING)',
                                   'serial': '1274A52',
                                   'serial_number': '1274A52',
                                   'system_mac_address': None},
                '1274A55': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6400 PERTH ROAD 121 (KUEPFER VICTOR)',
                                   'serial': '1274A55',
                                   'serial_number': '1274A55',
                                   'system_mac_address': None},
                '1274A5A': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6401 PERTH ROAD 121 (MILES WILLIAM)',
                                   'serial': '1274A5A',
                                   'serial_number': '1274A5A',
                                   'system_mac_address': None},
                '1274A5B': {       'dev_macs': ['44:65:7f:89:0c:60'],
                                   'ip_address': None,
                                   'name': '25 MURRAY CT (HOSSFELD KRYSTAL)',
                                   'serial': '1274A5B',
                                   'serial_number': '1274A5B',
                                   'system_mac_address': None},
                '1274A5D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5311 LINE 52 (ERNST ERIKA)',
                                   'serial': '1274A5D',
                                   'serial_number': '1274A5D',
                                   'system_mac_address': None},
                '1274A5E': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6433 ROAD 124 (ANDERSON RYAN)',
                                   'serial': '1274A5E',
                                   'serial_number': '1274A5E',
                                   'system_mac_address': None},
                '1274A60': {       'dev_macs': ['14:21:03:d1:7c:02'],
                                   'ip_address': None,
                                   'name': '170 MARKET ST (REITZEL ETHAN)',
                                   'serial': '1274A60',
                                   'serial_number': '1274A60',
                                   'system_mac_address': None},
                '1274A68': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6621 ROAD 116 (ZEHR TERRY & SUE)',
                                   'serial': '1274A68',
                                   'serial_number': '1274A68',
                                   'system_mac_address': None},
                '1274A6D': {       'dev_macs': ['44:65:7f:89:0d:ad'],
                                   'ip_address': None,
                                   'name': '25 MURRAY CT (BAUMAN ROSEANNE)',
                                   'serial': '1274A6D',
                                   'serial_number': '1274A6D',
                                   'system_mac_address': None},
                '1274A6F': {       'dev_macs': ['00:03:e6:f9:fb:fc'],
                                   'ip_address': None,
                                   'name': '6405 PERTH ROAD 121 (LEIS ALBERT)',
                                   'serial': '1274A6F',
                                   'serial_number': '1274A6F',
                                   'system_mac_address': None},
                '1274A70': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '16 TEMPERANCE ST (LEIS STANLEY)',
                                   'serial': '1274A70',
                                   'serial_number': '1274A70',
                                   'system_mac_address': None},
                '1274A75': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5325 ROAD 140 (BRODHAGEN ELVEY)',
                                   'serial': '1274A75',
                                   'serial_number': '1274A75',
                                   'system_mac_address': None},
                '1274A76': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4577 LINE 61 (VAN NES JAMES)',
                                   'serial': '1274A76',
                                   'serial_number': '1274A76',
                                   'system_mac_address': None},
                '1274A78': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5899 PERTH RD 119 (BRAUN AARON & '
                                           'MARGARETHA)',
                                   'serial': '1274A78',
                                   'serial_number': '1274A78',
                                   'system_mac_address': None},
                '1274A79': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4464 LINE 64 (MCNALLY SHANE)',
                                   'serial': '1274A79',
                                   'serial_number': '1274A79',
                                   'system_mac_address': None},
                '1274A7A': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6535 PERTH ROAD 121 (ROES NORMAN)',
                                   'serial': '1274A7A',
                                   'serial_number': '1274A7A',
                                   'system_mac_address': None},
                '1274A7E': {       'dev_macs': ['b8:94:70:f3:d5:6d'],
                                   'ip_address': None,
                                   'name': '5198 LINE 49 (GRAUL NICOLE)',
                                   'serial': '1274A7E',
                                   'serial_number': '1274A7E',
                                   'system_mac_address': None},
                '1274A80': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': "6878 ROAD 116 (JOHN'S TRANSIT)",
                                   'serial': '1274A80',
                                   'serial_number': '1274A80',
                                   'system_mac_address': None},
                '1274A89': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6946 ROAD 124 (JANTZI JONATHAN)',
                                   'serial': '1274A89',
                                   'serial_number': '1274A89',
                                   'system_mac_address': None},
                '1274A8A': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5583 ROAD 164 MONKTON (FRANCIS CHRISTINE)',
                                   'serial': '1274A8A',
                                   'serial_number': '1274A8A',
                                   'system_mac_address': None},
                '1274A8C': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6573 ROAD 140 (EBERSOL ELI)',
                                   'serial': '1274A8C',
                                   'serial_number': '1274A8C',
                                   'system_mac_address': None},
                '1274A91': {       'dev_macs': ['44:65:7f:89:0d:1d'],
                                   'ip_address': None,
                                   'name': '25 MURRAY CT (PRIALA GHEORGHE)',
                                   'serial': '1274A91',
                                   'serial_number': '1274A91',
                                   'system_mac_address': None},
                '1274A94': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4341 PERTH LINE 72 (JANTZI JIM)',
                                   'serial': '1274A94',
                                   'serial_number': '1274A94',
                                   'system_mac_address': None},
                '1274A96': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6886 ROAD 129 (COOK WILLIAM & JEAN)',
                                   'serial': '1274A96',
                                   'serial_number': '1274A96',
                                   'system_mac_address': None},
                '1274A9A': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4059 LINE 76 (MILLBANK MFG INC)',
                                   'serial': '1274A9A',
                                   'serial_number': '1274A9A',
                                   'system_mac_address': None},
                '1274A9F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6602 PERTH ROAD 121 (HOOVER SAMUEL B)',
                                   'serial': '1274A9F',
                                   'serial_number': '1274A9F',
                                   'system_mac_address': None},
                '1274AA0': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6997 ROAD 124 (KUEPFER DANNIE)',
                                   'serial': '1274AA0',
                                   'serial_number': '1274AA0',
                                   'system_mac_address': None},
                '1274AA5': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6261 PERTH ROAD 121 (ROES SCOTT)',
                                   'serial': '1274AA5',
                                   'serial_number': '1274AA5',
                                   'system_mac_address': None},
                '1274AA7': {       'dev_macs': ['00:03:e6:f9:d4:bc'],
                                   'ip_address': None,
                                   'name': '77 MAIN ST N (RASMUSSEN FLORENCE)',
                                   'serial': '1274AA7',
                                   'serial_number': '1274AA7',
                                   'system_mac_address': None},
                '1274AAA': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6497 ROAD 124 (WAGLER JEREMY)',
                                   'serial': '1274AAA',
                                   'serial_number': '1274AAA',
                                   'system_mac_address': None},
                '1274AAD': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '3 MILL ST W (BRAUN DAVID & MARGARETHA)',
                                   'serial': '1274AAD',
                                   'serial_number': '1274AAD',
                                   'system_mac_address': None},
                '1274AB0': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4740 LINE 67 (5588269 ONTARIO INC)',
                                   'serial': '1274AB0',
                                   'serial_number': '1274AB0',
                                   'system_mac_address': None},
                '1274AB5': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4892 PERTH LINE 55 (WAGLER MRS KATIE)',
                                   'serial': '1274AB5',
                                   'serial_number': '1274AB5',
                                   'system_mac_address': None},
                '1274AB8': {       'dev_macs': ['d4:ca:6d:32:23:73'],
                                   'ip_address': None,
                                   'name': '4392 PERTH LINE 72 (NEWTON FURNITURE INC)',
                                   'serial': '1274AB8',
                                   'serial_number': '1274AB8',
                                   'system_mac_address': None},
                '1274AC2': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6193 PERTH ROAD 121 (HYATT PAUL & '
                                           'KIMBERLY)',
                                   'serial': '1274AC2',
                                   'serial_number': '1274AC2',
                                   'system_mac_address': None},
                '1274AC9': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6502 ROAD 124 (JANTZI RONALD)',
                                   'serial': '1274AC9',
                                   'serial_number': '1274AC9',
                                   'system_mac_address': None},
                '1274ACF': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6800 PERTH ROAD 121 (KUEPFER WAYNE S)',
                                   'serial': '1274ACF',
                                   'serial_number': '1274ACF',
                                   'system_mac_address': None},
                '1274AD0': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4119 PERTH LINE 72 (LIVESTOCK NUTRITIONAL '
                                           'SERVICES)',
                                   'serial': '1274AD0',
                                   'serial_number': '1274AD0',
                                   'system_mac_address': None},
                '1274AD5': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6551 ROAD 124 (MARTIN AARON F)',
                                   'serial': '1274AD5',
                                   'serial_number': '1274AD5',
                                   'system_mac_address': None},
                '1274AD7': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4341 PERTH LINE 72 (JANTZI LEVI K)',
                                   'serial': '1274AD7',
                                   'serial_number': '1274AD7',
                                   'system_mac_address': None},
                '1274ADF': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4434 LINE 67 (BANCROFT PETER)',
                                   'serial': '1274ADF',
                                   'serial_number': '1274ADF',
                                   'system_mac_address': None},
                '1274AE9': {       'dev_macs': ['44:65:7f:89:09:ab'],
                                   'ip_address': None,
                                   'name': '5 MAIN ST S UNIT 102 (GOETZ LORI)',
                                   'serial': '1274AE9',
                                   'serial_number': '1274AE9',
                                   'system_mac_address': None},
                '1274AED': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6720 PERTH ROAD 121 (KUEPFER KEN)',
                                   'serial': '1274AED',
                                   'serial_number': '1274AED',
                                   'system_mac_address': None},
                '1274AF5': {       'dev_macs': ['b8:94:70:f3:ec:54'],
                                   'ip_address': None,
                                   'name': '57 PUGH ST (HEALEY RYAN)',
                                   'serial': '1274AF5',
                                   'serial_number': '1274AF5',
                                   'system_mac_address': None},
                '1274AFB': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6752 PERTH ROAD 121 (ZEHR CHERYL)',
                                   'serial': '1274AFB',
                                   'serial_number': '1274AFB',
                                   'system_mac_address': None},
                '1274AFC': {       'dev_macs': ['5c:0f:fb:34:ac:02'],
                                   'ip_address': None,
                                   'name': '3 MURRAY CT MILVERTON (WILLIAM HORST '
                                           '10400332)',
                                   'serial': '1274AFC',
                                   'serial_number': '1274AFC',
                                   'system_mac_address': None},
                '1274AFE': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4147 PERTH LINE 72 (GERBER SHARON)',
                                   'serial': '1274AFE',
                                   'serial_number': '1274AFE',
                                   'system_mac_address': None},
                '1274AFF': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4976 PERTH LINE 72 (CARTER KEN & ANITA)',
                                   'serial': '1274AFF',
                                   'serial_number': '1274AFF',
                                   'system_mac_address': None},
                '1274B00': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4435 LINE 67 (KUEPFER ALMEDA & CLARE)',
                                   'serial': '1274B00',
                                   'serial_number': '1274B00',
                                   'system_mac_address': None},
                '1274B02': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '25 MURRAY CT (KAUR  SIMRAN)',
                                   'serial': '1274B02',
                                   'serial_number': '1274B02',
                                   'system_mac_address': None},
                '1274B0D': {       'dev_macs': ['44:65:7f:89:0c:c3'],
                                   'ip_address': None,
                                   'name': '25 MURRAY CT (JONES LOGAN)',
                                   'serial': '1274B0D',
                                   'serial_number': '1274B0D',
                                   'system_mac_address': None},
                '1274B0F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4232 LINE 61 (ERB WAYNE)',
                                   'serial': '1274B0F',
                                   'serial_number': '1274B0F',
                                   'system_mac_address': None},
                '1274B10': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '54 PUGH ST UNIT 4 (GERBER BUD)',
                                   'serial': '1274B10',
                                   'serial_number': '1274B10',
                                   'system_mac_address': None},
                '1274B14': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6551 PERTH ROAD 121 (MARTIN MERVIN M J)',
                                   'serial': '1274B14',
                                   'serial_number': '1274B14',
                                   'system_mac_address': None},
                '1274B1D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4287 LINE 67 (KUEPFER CALVIN)',
                                   'serial': '1274B1D',
                                   'serial_number': '1274B1D',
                                   'system_mac_address': None},
                '1274B20': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4230 LINE 61 (SCHWARTZENTRUBER JOYCE)',
                                   'serial': '1274B20',
                                   'serial_number': '1274B20',
                                   'system_mac_address': None},
                '1274B26': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4138 PERTH LINE 72 (BEREAN CHRISTIAN '
                                           'FELLOWSHIP)',
                                   'serial': '1274B26',
                                   'serial_number': '1274B26',
                                   'system_mac_address': None},
                '1274B2F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4137 PERTH LINE 72 (KUEPFER JOHN K)',
                                   'serial': '1274B2F',
                                   'serial_number': '1274B2F',
                                   'system_mac_address': None},
                '1274B30': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4939 PERTH LINE 72 (KUEPFER ALVIN K & ANNA '
                                           'MAE)',
                                   'serial': '1274B30',
                                   'serial_number': '1274B30',
                                   'system_mac_address': None},
                '1274B38': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6563 ROAD 116 (JANTZI SHARON)',
                                   'serial': '1274B38',
                                   'serial_number': '1274B38',
                                   'system_mac_address': None},
                '1274B3B': {       'dev_macs': ['b8:94:70:f3:e7:8f'],
                                   'ip_address': None,
                                   'name': '4092 QUEEN ST (BAUMAN DARRELL)',
                                   'serial': '1274B3B',
                                   'serial_number': '1274B3B',
                                   'system_mac_address': None},
                '1274B44': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4712 LINE 67 (ALBRECHT ELDON & CHRISTENA)',
                                   'serial': '1274B44',
                                   'serial_number': '1274B44',
                                   'system_mac_address': None},
                '1274B4A': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4899 PERTH LINE 72 (KUEPFER ROY)',
                                   'serial': '1274B4A',
                                   'serial_number': '1274B4A',
                                   'system_mac_address': None},
                '1274B5A': {       'dev_macs': ['b8:94:70:f3:df:c8'],
                                   'ip_address': None,
                                   'name': '4 EDWARD ST (CHALMERS JENNIFER)',
                                   'serial': '1274B5A',
                                   'serial_number': '1274B5A',
                                   'system_mac_address': None},
                '1274B6F': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4276 PERTH LINE 72 (BAUMAN AMSEY S)',
                                   'serial': '1274B6F',
                                   'serial_number': '1274B6F',
                                   'system_mac_address': None},
                '1274FA3': {       'dev_macs': ['00:90:7f:19:e4:a2'],
                                   'ip_address': None,
                                   'name': '4570 PERTH LINE 72 (BATEMAN EQUIPMENT '
                                           'CORPORATION)',
                                   'serial': '1274FA3',
                                   'serial_number': '1274FA3',
                                   'system_mac_address': None},
                '1274FF3': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4317 PERTH LINE 72 (KUEPFER SANFORD)',
                                   'serial': '1274FF3',
                                   'serial_number': '1274FF3',
                                   'system_mac_address': None},
                '1274FF9': {       'dev_macs': ['14:21:03:8b:71:d9'],
                                   'ip_address': None,
                                   'name': '4908 LINE 59 (DIEHL FRAZER FARMING LTD)',
                                   'serial': '1274FF9',
                                   'serial_number': '1274FF9',
                                   'system_mac_address': None},
                '1274FFB': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4492 PERTH LINE 72 (ALBRECHT AMMON)',
                                   'serial': '1274FFB',
                                   'serial_number': '1274FFB',
                                   'system_mac_address': None},
                '1275008': {       'dev_macs': ['b4:fb:e4:8e:43:79'],
                                   'ip_address': None,
                                   'name': '3 ST MARYS ST N (DRAGOI CRISTIAN & '
                                           'ADRIANA)',
                                   'serial': '1275008',
                                   'serial_number': '1275008',
                                   'system_mac_address': None},
                '1275036': {       'dev_macs': ['b8:94:70:f3:e0:e6'],
                                   'ip_address': None,
                                   'name': '5804 PERTH ROAD 119 (CNOSSEN SIMON & '
                                           'ANDREA)',
                                   'serial': '1275036',
                                   'serial_number': '1275036',
                                   'system_mac_address': None},
                '127503A': {       'dev_macs': ['14:21:03:92:ea:4a'],
                                   'ip_address': None,
                                   'name': '4244 PERTH LINE 72 (ALBRECHT ALEX)',
                                   'serial': '127503A',
                                   'serial_number': '127503A',
                                   'system_mac_address': None},
                '1275043': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4619 PERTH LINE 72 (MCTAVISH COLLEEN)',
                                   'serial': '1275043',
                                   'serial_number': '1275043',
                                   'system_mac_address': None},
                '1275053': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4620 PERTH LINE 72 (MCKERTCHER JOYCE)',
                                   'serial': '1275053',
                                   'serial_number': '1275053',
                                   'system_mac_address': None},
                '1275072': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '160 FISHLEIGH ST MONKTON (MCGIRR KENNETH  '
                                           '10433784)',
                                   'serial': '1275072',
                                   'serial_number': '1275072',
                                   'system_mac_address': None},
                '1275076': {       'dev_macs': ['00:03:e6:f9:d7:82'],
                                   'ip_address': None,
                                   'name': '26 MAIN ST N (DULIES ALMUTH)',
                                   'serial': '1275076',
                                   'serial_number': '1275076',
                                   'system_mac_address': None},
                '1275078': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5005 PERTH LINE 55 (ALBRECHT LESLIE)',
                                   'serial': '1275078',
                                   'serial_number': '1275078',
                                   'system_mac_address': None},
                '1275082': {       'dev_macs': ['b8:94:70:f3:e8:1e'],
                                   'ip_address': None,
                                   'name': '120 PUGH ST (SCHMIDT KELSEY)',
                                   'serial': '1275082',
                                   'serial_number': '1275082',
                                   'system_mac_address': None},
                '12750CC': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5134 PERTH LINE 55 (JANTZI MARTIN & '
                                           'PAULINE)',
                                   'serial': '12750CC',
                                   'serial_number': '12750CC',
                                   'system_mac_address': None},
                '12750CD': {       'dev_macs': ['b8:94:70:f3:e6:0e'],
                                   'ip_address': None,
                                   'name': '31 MAIN ST S (HOBBS KEN & GUDRUN)',
                                   'serial': '12750CD',
                                   'serial_number': '12750CD',
                                   'system_mac_address': None},
                '12750D7': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5808 PERTH ROAD 119 (FORLER RACHELLE)',
                                   'serial': '12750D7',
                                   'serial_number': '12750D7',
                                   'system_mac_address': None},
                '1275114': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '69 MAIN ST N (PRAYER HOUSE OF MILVERTON)',
                                   'serial': '1275114',
                                   'serial_number': '1275114',
                                   'system_mac_address': None},
                '127515A': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '27 ARENA DR (PUGH TIM & ROSE)',
                                   'serial': '127515A',
                                   'serial_number': '127515A',
                                   'system_mac_address': None},
                '127518B': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4482 PERTH LINE 72 (HOERLE MARY)',
                                   'serial': '127518B',
                                   'serial_number': '127518B',
                                   'system_mac_address': None},
                '127518F': {       'dev_macs': ['b8:94:70:f3:e4:e5'],
                                   'ip_address': None,
                                   'name': '103 PUGH ST (SABOL SAMANTHA)',
                                   'serial': '127518F',
                                   'serial_number': '127518F',
                                   'system_mac_address': None},
                '1275197': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4870 LINE 49 (TAMAS ALEXANDRA)',
                                   'serial': '1275197',
                                   'serial_number': '1275197',
                                   'system_mac_address': None},
                '12751C1': {       'dev_macs': ['44:65:7f:41:94:87'],
                                   'ip_address': None,
                                   'name': '57 WILLIAM ST (OWUSU SELINA)',
                                   'serial': '12751C1',
                                   'serial_number': '12751C1',
                                   'system_mac_address': None},
                '12751D0': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4516 PERTH LINE 72 (REIST STEVEN)',
                                   'serial': '12751D0',
                                   'serial_number': '12751D0',
                                   'system_mac_address': None},
                '12751D6': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4528 PERTH LINE 72 (THIESSEN JACOB)',
                                   'serial': '12751D6',
                                   'serial_number': '12751D6',
                                   'system_mac_address': None},
                '12751DA': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '57 WILLIAM ST APT 202 (HOWATT MITCHELL)',
                                   'serial': '12751DA',
                                   'serial_number': '12751DA',
                                   'system_mac_address': None},
                '12751DD': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6968 MILLBANK MAIN ST (FRANKLIN GARY)',
                                   'serial': '12751DD',
                                   'serial_number': '12751DD',
                                   'system_mac_address': None},
                '1295E37': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '54 AVERY PL (KUHL WADE)',
                                   'serial': '1295E37',
                                   'serial_number': '1295E37',
                                   'system_mac_address': None},
                '1295E49': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5883 PERTH ROAD 119 (JACOBS HERB K)',
                                   'serial': '1295E49',
                                   'serial_number': '1295E49',
                                   'system_mac_address': None},
                '1295E66': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4494 LINE 64 (ZEHR JACOB)',
                                   'serial': '1295E66',
                                   'serial_number': '1295E66',
                                   'system_mac_address': None},
                '1295E76': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '2332 LINE 47 (GERBER PAUL)',
                                   'serial': '1295E76',
                                   'serial_number': '1295E76',
                                   'system_mac_address': None},
                '1295E95': {       'dev_macs': ['e4:6c:d1:01:b9:e1'],
                                   'ip_address': None,
                                   'name': '58 AVERY PL (KARDAS BRANT)',
                                   'serial': '1295E95',
                                   'serial_number': '1295E95',
                                   'system_mac_address': None},
                '1295E97': {       'dev_macs': ['e4:6c:d1:4e:e6:bb'],
                                   'ip_address': None,
                                   'name': '112 PUGH ST (WITEN STACEY & LAURENCE)',
                                   'serial': '1295E97',
                                   'serial_number': '1295E97',
                                   'system_mac_address': None},
                '1295E9B': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '2263 LINE 51 (LINDNER JANE)',
                                   'serial': '1295E9B',
                                   'serial_number': '1295E9B',
                                   'system_mac_address': None},
                '1295EA3': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5979 PERTH ROAD 119 (MARTIN DARRYK)',
                                   'serial': '1295EA3',
                                   'serial_number': '1295EA3',
                                   'system_mac_address': None},
                '1295EA6': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4464 CRESCENT AV (ALBRECHT PAUL & MARILYN)',
                                   'serial': '1295EA6',
                                   'serial_number': '1295EA6',
                                   'system_mac_address': None},
                '1295EAA': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4432 PERTH LINE 72 (FABER SUSAN)',
                                   'serial': '1295EAA',
                                   'serial_number': '1295EAA',
                                   'system_mac_address': None},
                '1295EB8': {       'dev_macs': ['e4:6c:d1:4e:ec:a9'],
                                   'ip_address': None,
                                   'name': '33 MURRAY CT (SHAW DANIELLE)',
                                   'serial': '1295EB8',
                                   'serial_number': '1295EB8',
                                   'system_mac_address': None},
                '1295EBB': {       'dev_macs': ['e4:6c:d1:4f:bc:28'],
                                   'ip_address': None,
                                   'name': '5499 PERTH LINE 55 (MEULLER LINDA)',
                                   'serial': '1295EBB',
                                   'serial_number': '1295EBB',
                                   'system_mac_address': None},
                '1295EC1': {       'dev_macs': ['bc:fc:e7:22:8d:58'],
                                   'ip_address': None,
                                   'name': '4926 Line 61 Milverton (Markus Mueller)',
                                   'serial': '1295EC1',
                                   'serial_number': '1295EC1',
                                   'system_mac_address': None},
                '1295FB2': {       'dev_macs': ['e4:6c:d1:4f:b1:d8'],
                                   'ip_address': None,
                                   'name': '5915 SOMERSET DR (TOMBS GREG)',
                                   'serial': '1295FB2',
                                   'serial_number': '1295FB2',
                                   'system_mac_address': None},
                '129600E': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '128 PUGH ST',
                                   'serial': '129600E',
                                   'serial_number': '129600E',
                                   'system_mac_address': None},
                '1296012': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4460C PERTH LINE 72 (WALL AARON)',
                                   'serial': '1296012',
                                   'serial_number': '1296012',
                                   'system_mac_address': None},
                '1296022': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4957 ROAD 109 (ROTH CHRIS)',
                                   'serial': '1296022',
                                   'serial_number': '1296022',
                                   'system_mac_address': None},
                '129602E': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4072 WATERLOO ST (MILLBANK ENTERPRISES '
                                           'INC)',
                                   'serial': '129602E',
                                   'serial_number': '129602E',
                                   'system_mac_address': None},
                '1296041': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5930 LINE 57 (PELKMANS ELS)',
                                   'serial': '1296041',
                                   'serial_number': '1296041',
                                   'system_mac_address': None},
                '1296044': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6932 HORIZON TL (NICKEL AMANDA)',
                                   'serial': '1296044',
                                   'serial_number': '1296044',
                                   'system_mac_address': None},
                '129604E': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4486 LINE 52 (DEBUS RON)',
                                   'serial': '129604E',
                                   'serial_number': '129604E',
                                   'system_mac_address': None},
                '129605A': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6982 CHURCH ST (HORST LAVERNE)',
                                   'serial': '129605A',
                                   'serial_number': '129605A',
                                   'system_mac_address': None},
                '12960D8': {       'dev_macs': ['60:db:98:09:38:34'],
                                   'ip_address': None,
                                   'name': '208 WINSTANLEY ST (KAREN AND GORD BENDER)',
                                   'serial': '12960D8',
                                   'serial_number': '12960D8',
                                   'system_mac_address': None},
                '12960DB': {       'dev_macs': ['e4:6c:d1:01:b3:c7'],
                                   'ip_address': None,
                                   'name': '19 SCHADE ST MONKTON (HUBER DERRICK)',
                                   'serial': '12960DB',
                                   'serial_number': '12960DB',
                                   'system_mac_address': None},
                '12960E0': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6931 PERTH ROAD 121 (ED ZEHR)',
                                   'serial': '12960E0',
                                   'serial_number': '12960E0',
                                   'system_mac_address': None},
                '12960EF': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4374 LINE 64 (ALBRECHT DAVID Z)',
                                   'serial': '12960EF',
                                   'serial_number': '12960EF',
                                   'system_mac_address': None},
                '1296110': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6896 PERTH ROAD 121 (T & D RESTORATIONS '
                                           'INC)',
                                   'serial': '1296110',
                                   'serial_number': '1296110',
                                   'system_mac_address': None},
                '1296121': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6190 PERTH ROAD 131 (DAVIDSON JEREMY & '
                                           'MALINDA)',
                                   'serial': '1296121',
                                   'serial_number': '1296121',
                                   'system_mac_address': None},
                '1296122': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6478 ROAD 129 (KUEPFER ELDON R)',
                                   'serial': '1296122',
                                   'serial_number': '1296122',
                                   'system_mac_address': None},
                '1296127': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6015 PERTH ROAD 119 (KUEPFER JUDITH)',
                                   'serial': '1296127',
                                   'serial_number': '1296127',
                                   'system_mac_address': None},
                '129613B': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '74 PUGH ST (SCOTCHMER WAYNE)',
                                   'serial': '129613B',
                                   'serial_number': '129613B',
                                   'system_mac_address': None},
                '1296DED': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7118 PERTH ROAD 121 (BAUMAN ABNER)',
                                   'serial': '1296DED',
                                   'serial_number': '1296DED',
                                   'system_mac_address': None},
                '1296FCB': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4009 LINE 61 (CHALMERS KEVIN)',
                                   'serial': '1296FCB',
                                   'serial_number': '1296FCB',
                                   'system_mac_address': None},
                '1296FD4': {       'dev_macs': ['60:db:98:54:a4:67'],
                                   'ip_address': None,
                                   'name': '58 PUGH ST (PATHAMMAVONG LEE)',
                                   'serial': '1296FD4',
                                   'serial_number': '1296FD4',
                                   'system_mac_address': None},
                '1296FE0': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4198 LINE 61 (CONRAD JOHN)',
                                   'serial': '1296FE0',
                                   'serial_number': '1296FE0',
                                   'system_mac_address': None},
                '1297066': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4104 LINE 61 (BAUMAN FRED)',
                                   'serial': '1297066',
                                   'serial_number': '1297066',
                                   'system_mac_address': None},
                '12970D4': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4457 COMMUNITY CENTRE DRIVE (SHANTZ '
                                           'MARIANNE)',
                                   'serial': '12970D4',
                                   'serial_number': '12970D4',
                                   'system_mac_address': None},
                '1297268': {       'dev_macs': ['14:21:03:a9:6e:e7'],
                                   'ip_address': None,
                                   'name': '4499 LINE 46 (VANSTRAATEN CATHY)',
                                   'serial': '1297268',
                                   'serial_number': '1297268',
                                   'system_mac_address': None},
                '1297287': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4535 LINE 46 (VANSTRAATEN AMY)',
                                   'serial': '1297287',
                                   'serial_number': '1297287',
                                   'system_mac_address': None},
                '129734C': {       'dev_macs': ['d8:b3:70:20:13:d1'],
                                   'ip_address': None,
                                   'name': '218 WINSTANLEY ST (PEARL INSPIRATIONS)',
                                   'serial': '129734C',
                                   'serial_number': '129734C',
                                   'system_mac_address': None},
                '1297351': {       'dev_macs': ['c4:ad:34:b1:22:bf'],
                                   'ip_address': None,
                                   'name': '4676 HAWTHORNE CT (BADEN WOODTURNING INC.)',
                                   'serial': '1297351',
                                   'serial_number': '1297351',
                                   'system_mac_address': None},
                '1297360': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4028 LINE 50 (YODER ARNOLD)',
                                   'serial': '1297360',
                                   'serial_number': '1297360',
                                   'system_mac_address': None},
                '1297375': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': "4158 LINE 67 (ALBRECHT'S CHAIN SAW "
                                           'SERVICE)',
                                   'serial': '1297375',
                                   'serial_number': '1297375',
                                   'system_mac_address': None},
                '1297379': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '2568 LINE 47 (SCHNEIDER LARRY)',
                                   'serial': '1297379',
                                   'serial_number': '1297379',
                                   'system_mac_address': None},
                '1297389': {       'dev_macs': ['14:21:03:a1:e5:c3'],
                                   'ip_address': None,
                                   'name': '72 AVERY PL (MCINTOSH MARGO)',
                                   'serial': '1297389',
                                   'serial_number': '1297389',
                                   'system_mac_address': None},
                '129738A': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': "4464 PERTH LINE 72 (JACOBS' FAMILY "
                                           'SERVICE)',
                                   'serial': '129738A',
                                   'serial_number': '129738A',
                                   'system_mac_address': None},
                '129738E': {       'dev_macs': ['a8:6e:84:00:aa:1d'],
                                   'ip_address': None,
                                   'name': '4399 LINE 61 (HAVERKAMP RALPH)',
                                   'serial': '129738E',
                                   'serial_number': '129738E',
                                   'system_mac_address': None},
                '1297390': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4223 LINE 50 (VAN LEEUWEN WILLIAM)',
                                   'serial': '1297390',
                                   'serial_number': '1297390',
                                   'system_mac_address': None},
                '1297394': {       'dev_macs': ['14:21:03:a9:70:89'],
                                   'ip_address': None,
                                   'name': '2606 LINE 51 (CIPP-FREIBURGER DEBBIE)',
                                   'serial': '1297394',
                                   'serial_number': '1297394',
                                   'system_mac_address': None},
                '129739E': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6802 ROAD 124 (KUEPFER NELSON & DORIS)',
                                   'serial': '129739E',
                                   'serial_number': '129739E',
                                   'system_mac_address': None},
                '12973B0': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '2460 LINE 45 (GERBER TIMOTHY)',
                                   'serial': '12973B0',
                                   'serial_number': '12973B0',
                                   'system_mac_address': None},
                '12973B5': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '14 CRUICKSHANK APT 1 (REIS KEVIN)',
                                   'serial': '12973B5',
                                   'serial_number': '12973B5',
                                   'system_mac_address': None},
                '12973CF': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4109 LINE 61 (HILDEBRANDT ROSANA)',
                                   'serial': '12973CF',
                                   'serial_number': '12973CF',
                                   'system_mac_address': None},
                '12973D7': {       'dev_macs': ['14:21:03:92:c7:3a'],
                                   'ip_address': None,
                                   'name': '5 MAIN ST S (KETA LISA)',
                                   'serial': '12973D7',
                                   'serial_number': '12973D7',
                                   'system_mac_address': None},
                '12973DE': {       'dev_macs': ['14:21:03:a9:70:c0'],
                                   'ip_address': None,
                                   'name': '2339 LINE 51 (WAGLER CHRISTINE)',
                                   'serial': '12973DE',
                                   'serial_number': '12973DE',
                                   'system_mac_address': None},
                '12973E1': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '85 MAIN ST N (THEDORFF SANDY)',
                                   'serial': '12973E1',
                                   'serial_number': '12973E1',
                                   'system_mac_address': None},
                '12973E5': {       'dev_macs': ['14:21:03:8b:73:d3'],
                                   'ip_address': None,
                                   'name': '25 MURRAY CT (WEBER JOSH)',
                                   'serial': '12973E5',
                                   'serial_number': '12973E5',
                                   'system_mac_address': None},
                '12973ED': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7022 ROAD 129 (NEWTON RUSTICS)',
                                   'serial': '12973ED',
                                   'serial_number': '12973ED',
                                   'system_mac_address': None},
                '12973F0': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4085 PRINCESS ST (BARTEL ALLISON)',
                                   'serial': '12973F0',
                                   'serial_number': '12973F0',
                                   'system_mac_address': None},
                '12973F3': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4219 LINE 46 (BRUULSEMA HAROLD)',
                                   'serial': '12973F3',
                                   'serial_number': '12973F3',
                                   'system_mac_address': None},
                '12973FB': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': "6684 ROAD 129 (JANTZI'S SHOE BOX)",
                                   'serial': '12973FB',
                                   'serial_number': '12973FB',
                                   'system_mac_address': None},
                '12973FD': {       'dev_macs': ['14:21:03:8b:73:23'],
                                   'ip_address': None,
                                   'name': '6025 PERTH ROAD 119 (SCHEERER KEN & '
                                           'CONNIE)',
                                   'serial': '12973FD',
                                   'serial_number': '12973FD',
                                   'system_mac_address': None},
                '1297411': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5542 ROAD 126 (GASCHO KEITH & ANNETTE)',
                                   'serial': '1297411',
                                   'serial_number': '1297411',
                                   'system_mac_address': None},
                '129741B': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4505 LINE 46 (ROTH GARY & KIM)',
                                   'serial': '129741B',
                                   'serial_number': '129741B',
                                   'system_mac_address': None},
                '129741D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4721 LINE 64 (ARRO CRUSHING LTD)',
                                   'serial': '129741D',
                                   'serial_number': '129741D',
                                   'system_mac_address': None},
                '1297421': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4443 PERTH LINE 72 (ALBRECHT DIANE)',
                                   'serial': '1297421',
                                   'serial_number': '1297421',
                                   'system_mac_address': None},
                '1297426': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': "13 MILL ST E (KIPFER'S GARAGE LTD)",
                                   'serial': '1297426',
                                   'serial_number': '1297426',
                                   'system_mac_address': None},
                '129742A': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4424 PERTH LINE 72 (STECKLY ELSIE)',
                                   'serial': '129742A',
                                   'serial_number': '129742A',
                                   'system_mac_address': None},
                '129743D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4447 PERTH LINE 72 (PURCELL DOUG)',
                                   'serial': '129743D',
                                   'serial_number': '129743D',
                                   'system_mac_address': None},
                '1297457': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4878 ROAD 109 (REFRESHING WIND MINISTRIES)',
                                   'serial': '1297457',
                                   'serial_number': '1297457',
                                   'system_mac_address': None},
                '129745A': {       'dev_macs': ['14:21:03:a9:75:9b'],
                                   'ip_address': None,
                                   'name': '5205 LINE 58 (YOUNG JACOB)',
                                   'serial': '129745A',
                                   'serial_number': '129745A',
                                   'system_mac_address': None},
                '129745D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4188 LINE 61 (BULMER D)',
                                   'serial': '129745D',
                                   'serial_number': '129745D',
                                   'system_mac_address': None},
                '1297469': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4445 PERTH LINE 72 (A & A CONTRACTING)',
                                   'serial': '1297469',
                                   'serial_number': '1297469',
                                   'system_mac_address': None},
                '1297482': {       'dev_macs': ['14:21:03:a4:35:f3'],
                                   'ip_address': None,
                                   'name': '4 MAIN ST S (GARDNER ROBYN)',
                                   'serial': '1297482',
                                   'serial_number': '1297482',
                                   'system_mac_address': None},
                '129748B': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6034 PERTH ROAD 119 (SLITS PEDRO & '
                                           'JOLANDA)',
                                   'serial': '129748B',
                                   'serial_number': '129748B',
                                   'system_mac_address': None},
                '129748C': {       'dev_macs': ['14:21:03:a9:73:5f'],
                                   'ip_address': None,
                                   'name': '33 MURRAY CT (BRAUN HELENA)',
                                   'serial': '129748C',
                                   'serial_number': '129748C',
                                   'system_mac_address': None},
                '12974A9': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6000 PERTH ROAD 119 (ROPP STEPHEN)',
                                   'serial': '12974A9',
                                   'serial_number': '12974A9',
                                   'system_mac_address': None},
                '12974AC': {       'dev_macs': ['14:21:03:a9:74:88'],
                                   'ip_address': None,
                                   'name': '2733 LINE 45 (ROSE STEVEN & KERRY)',
                                   'serial': '12974AC',
                                   'serial_number': '12974AC',
                                   'system_mac_address': None},
                '12974AF': {       'dev_macs': ['e4:6c:d1:4e:f3:47'],
                                   'ip_address': None,
                                   'name': '109 PUGH ST (DAVIDSON DIANN)',
                                   'serial': '12974AF',
                                   'serial_number': '12974AF',
                                   'system_mac_address': None},
                '12974B2': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7009 ROAD 129 (MARTIN HOWARD)',
                                   'serial': '12974B2',
                                   'serial_number': '12974B2',
                                   'system_mac_address': None},
                '12974D6': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '7007 ROAD 129 (KLASSEN ANNA)',
                                   'serial': '12974D6',
                                   'serial_number': '12974D6',
                                   'system_mac_address': None},
                '12974D9': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4373 LINE 61 (VIANA KYLA)',
                                   'serial': '12974D9',
                                   'serial_number': '12974D9',
                                   'system_mac_address': None},
                '12974DC': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4555 PERTH LINE 72 (ALBRECHT NORMAN)',
                                   'serial': '12974DC',
                                   'serial_number': '12974DC',
                                   'system_mac_address': None},
                '12974E9': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4441 PERTH LINE 72 (KLASSEN KATHARIN)',
                                   'serial': '12974E9',
                                   'serial_number': '12974E9',
                                   'system_mac_address': None},
                '12974EC': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '4094 WATERLOO ST (HERRFORT RALPH)',
                                   'serial': '12974EC',
                                   'serial_number': '12974EC',
                                   'system_mac_address': None},
                '12FFD4': {       'dev_macs': ['60:db:98:09:1b:8b'],
                                  'ip_address': None,
                                  'name': '84 Mill St. E. Milverton (Sandi Jacobs '
                                          '10403134)',
                                  'serial': '12FFD4',
                                  'serial_number': '12FFD4',
                                  'system_mac_address': None},
                '12FFD9': {       'dev_macs': ['6c:b0:ce:e2:f6:4a'],
                                  'ip_address': None,
                                  'name': '12 GERBER DR (HUBER ERNA & KEVIN)',
                                  'serial': '12FFD9',
                                  'serial_number': '12FFD9',
                                  'system_mac_address': None},
                '12FFE1': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '169 WINSTANLEY ST (KORNELSEN DONOVEN)',
                                  'serial': '12FFE1',
                                  'serial_number': '12FFE1',
                                  'system_mac_address': None},
                '12FFE4': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '170 Queen Ave. Monkton (Julia Cork)',
                                  'serial': '12FFE4',
                                  'serial_number': '12FFE4',
                                  'system_mac_address': None},
                '12FFF3': {       'dev_macs': ['44:65:7f:89:0f:93'],
                                  'ip_address': None,
                                  'name': '92 MILL ST E (GRAUL SCHERI)',
                                  'serial': '12FFF3',
                                  'serial_number': '12FFF3',
                                  'system_mac_address': None},
                '12FFFA': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '18 Mill St. E. Milverton (Curvin Martin)',
                                  'serial': '12FFFA',
                                  'serial_number': '12FFFA',
                                  'system_mac_address': None},
                '130005': {       'dev_macs': ['d0:76:8f:02:e3:ec'],
                                  'ip_address': None,
                                  'name': '30 Mill St. E. Milverton (HABEL TOM)',
                                  'serial': '130005',
                                  'serial_number': '130005',
                                  'system_mac_address': None},
                '130006': {       'dev_macs': ['14:21:03:d1:7c:bd'],
                                  'ip_address': None,
                                  'name': '86A MILL ST E (CAMPBELL MIKE & TAMMY)',
                                  'serial': '130006',
                                  'serial_number': '130006',
                                  'system_mac_address': None},
                '130026': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '98 Mill St. E. Milverton (Krystina '
                                          'Stachelski 10401363)',
                                  'serial': '130026',
                                  'serial_number': '130026',
                                  'system_mac_address': None},
                '130053': {       'dev_macs': ['e8:9f:80:0b:99:69'],
                                  'ip_address': None,
                                  'name': '90 Mill St. E. Milverton (Debbie Tanner)',
                                  'serial': '130053',
                                  'serial_number': '130053',
                                  'system_mac_address': None},
                '130058': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '68 Mill St. E. Milverton (Nursery School)',
                                  'serial': '130058',
                                  'serial_number': '130058',
                                  'system_mac_address': None},
                '13008E': {       'dev_macs': ['14:21:03:d1:7d:d0'],
                                  'ip_address': None,
                                  'name': '96 MILL ST E (MORWOOD NATHAN)',
                                  'serial': '13008E',
                                  'serial_number': '13008E',
                                  'system_mac_address': None},
                '130091': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '125 Maddison St. E. Monkton (Robert '
                                          'McGuire)',
                                  'serial': '130091',
                                  'serial_number': '130091',
                                  'system_mac_address': None},
                '13009B': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '28 MILL ST E (JANTZI PAUL)',
                                  'serial': '13009B',
                                  'serial_number': '13009B',
                                  'system_mac_address': None},
                '13009C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '174 Winstanley St. Monkton',
                                  'serial': '13009C',
                                  'serial_number': '13009C',
                                  'system_mac_address': None},
                '13009F': {       'dev_macs': ['44:65:7f:88:d4:f8'],
                                  'ip_address': None,
                                  'name': '82 Mill St. E. Milverton (Craig Kipfer)',
                                  'serial': '13009F',
                                  'serial_number': '13009F',
                                  'system_mac_address': None},
                '1300A1': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '203 king St. Monkton (Joel Leis)',
                                  'serial': '1300A1',
                                  'serial_number': '1300A1',
                                  'system_mac_address': None},
                '1300A2': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '21 Maddison Av. E. Monkton (Kyle '
                                          'Donkers10431767)',
                                  'serial': '1300A2',
                                  'serial_number': '1300A2',
                                  'system_mac_address': None},
                '1300C5': {       'dev_macs': ['60:db:98:82:0a:f8'],
                                  'ip_address': None,
                                  'name': '40 MILL ST E (WARING ALICIA)',
                                  'serial': '1300C5',
                                  'serial_number': '1300C5',
                                  'system_mac_address': None},
                '1300C6': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '76 Mill St. E. Milverton (Helena Mulder)',
                                  'serial': '1300C6',
                                  'serial_number': '1300C6',
                                  'system_mac_address': None},
                '1300C9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4 Main St. S. Unit 1 Milverton (Huron view '
                                          'Insurance 10411009)',
                                  'serial': '1300C9',
                                  'serial_number': '1300C9',
                                  'system_mac_address': None},
                '1300CB': {       'dev_macs': ['ec:4f:82:ac:f1:56'],
                                  'ip_address': None,
                                  'name': '76 MILL ST E (RICHARDS ALEXIS)',
                                  'serial': '1300CB',
                                  'serial_number': '1300CB',
                                  'system_mac_address': None},
                '1300D6': {       'dev_macs': ['c0:56:27:b5:25:10'],
                                  'ip_address': None,
                                  'name': '4890 Line 61 Milverton (Eddie Jantzi '
                                          '10425951)',
                                  'serial': '1300D6',
                                  'serial_number': '1300D6',
                                  'system_mac_address': None},
                '13448F': {       'dev_macs': [       '5c:0f:fb:3d:80:2c',
                                                      '5c:0f:fb:3d:7c:5e',
                                                      '5c:0f:fb:3d:3f:3e',
                                                      '5c:0f:fb:3d:52:08'],
                                  'ip_address': None,
                                  'name': '50 WILLIAM ST (POOLE MADALENA)',
                                  'serial': '13448F',
                                  'serial_number': '13448F',
                                  'system_mac_address': None},
                '1380D4': {       'dev_macs': [       'ec:4f:82:a5:04:d2',
                                                      'ec:4f:82:a5:04:9c',
                                                      '30:68:93:49:c2:5d',
                                                      'ec:4f:82:ac:f0:3f',
                                                      'a4:2a:95:3e:22:80',
                                                      'cc:be:59:7e:b6:e3'],
                                  'ip_address': None,
                                  'name': "2 Llana Heights Milverton (Apt #'s 21 thr "
                                          '34)',
                                  'serial': '1380D4',
                                  'serial_number': '1380D4',
                                  'system_mac_address': None},
                '138139': {       'dev_macs': [       '08:62:66:9a:51:64',
                                                      'cc:32:e5:17:f2:45',
                                                      '14:21:03:8b:71:76'],
                                  'ip_address': None,
                                  'name': '54 PUGH ST (WOODS RUTH A)',
                                  'serial': '138139',
                                  'serial_number': '138139',
                                  'system_mac_address': None},
                '13813B': {       'dev_macs': ['48:a9:8a:75:88:59'],
                                  'ip_address': None,
                                  'name': '4705 Line 64 Milverton (Wagler Electric '
                                          '10400140)',
                                  'serial': '13813B',
                                  'serial_number': '13813B',
                                  'system_mac_address': None},
                '13813C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '50 William St. Milverton (Knollcrest Data '
                                          'Rm. 3)',
                                  'serial': '13813C',
                                  'serial_number': '13813C',
                                  'system_mac_address': None},
                '1520286': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '55 WILLIAM ST AP 104 (FOX LORI)',
                                   'serial': '1520286',
                                   'serial_number': '1520286',
                                   'system_mac_address': None},
                '152029D': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '57 WILLIAM ST APT 201 (BOBAN AISWARYA)',
                                   'serial': '152029D',
                                   'serial_number': '152029D',
                                   'system_mac_address': None},
                '15202A6': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': "16 MAIN ST N (O'HEARN DANIEL)",
                                   'serial': '15202A6',
                                   'serial_number': '15202A6',
                                   'system_mac_address': None},
                '15202C7': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '55 WILLIAM ST (ASSELSTINE MAGDELINA)',
                                   'serial': '15202C7',
                                   'serial_number': '15202C7',
                                   'system_mac_address': None},
                '15202CF': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '13 MILL ST E (SOCKETT KAREN)',
                                   'serial': '15202CF',
                                   'serial_number': '15202CF',
                                   'system_mac_address': None},
                '15242B7': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '25 MURRAY CT (COLE DANIELLE)',
                                   'serial': '15242B7',
                                   'serial_number': '15242B7',
                                   'system_mac_address': None},
                '15242D5': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '55 WILLIAM ST (ALBRECHT MATTHEW)',
                                   'serial': '15242D5',
                                   'serial_number': '15242D5',
                                   'system_mac_address': None},
                '153D8': {       'dev_macs': ['44:65:7f:88:d2:0d', 'a8:42:a1:2c:71:d0'],
                                 'ip_address': None,
                                 'name': '50 William St. Milverton (Countryside '
                                         'Midwifery Services 10400769)',
                                 'serial': '153D8',
                                 'serial_number': '153D8',
                                 'system_mac_address': None},
                '153E639': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6888 ROAD 124 (KIPFER LORETTA)',
                                   'serial': '153E639',
                                   'serial_number': '153E639',
                                   'system_mac_address': None},
                '155322': {       'dev_macs': ['00:03:e6:d8:e4:4c'],
                                  'ip_address': None,
                                  'name': '60 William St. Suite 108 (Betty Brubacher '
                                          '10401029)',
                                  'serial': '155322',
                                  'serial_number': '155322',
                                  'system_mac_address': None},
                '1553BA': {       'dev_macs': ['60:db:98:09:39:10'],
                                  'ip_address': None,
                                  'name': '93 Maddison Ave. Monkton (Mike Duncan '
                                          '10432186)',
                                  'serial': '1553BA',
                                  'serial_number': '1553BA',
                                  'system_mac_address': None},
                '1553BF': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '195 Winstanley St Monkton (Ron McKee '
                                          '10433696)',
                                  'serial': '1553BF',
                                  'serial_number': '1553BF',
                                  'system_mac_address': None},
                '1553C6': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '75 Maddison St. W. Monkton (Megan Mclean)',
                                  'serial': '1553C6',
                                  'serial_number': '1553C6',
                                  'system_mac_address': None},
                '1553D4': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '60 William St. Suite 112 (DEZELL '
                                          'BERNADETTE)',
                                  'serial': '1553D4',
                                  'serial_number': '1553D4',
                                  'system_mac_address': None},
                '155436': {       'dev_macs': ['14:21:03:8b:6a:8b'],
                                  'ip_address': None,
                                  'name': '60 William St. Suite 111 (ERB CONNIE)',
                                  'serial': '155436',
                                  'serial_number': '155436',
                                  'system_mac_address': None},
                '155460': {       'dev_macs': ['60:db:98:55:a3:1f'],
                                  'ip_address': None,
                                  'name': '164 WINSTANLEY ST (CARAPINHA KYLA)',
                                  'serial': '155460',
                                  'serial_number': '155460',
                                  'system_mac_address': None},
                '15549F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '40 Cobalt St. N. Milverton (Lorne Reis)',
                                  'serial': '15549F',
                                  'serial_number': '15549F',
                                  'system_mac_address': None},
                '158FA71': {       'dev_macs': ['00:30:44:3e:1a:55'],
                                   'ip_address': None,
                                   'name': '6433 PERTH ROAD 131 (GROWMARK,INC. D/B/A '
                                           'CENTRAL)',
                                   'serial': '158FA71',
                                   'serial_number': '158FA71',
                                   'system_mac_address': None},
                '158FA8F': {       'dev_macs': ['b4:fb:e4:d3:ff:15'],
                                   'ip_address': None,
                                   'name': '4478 PERTH LINE 72 (NEW STAR '
                                           'RENTALS&EQUIPMENT LTD)',
                                   'serial': '158FA8F',
                                   'serial_number': '158FA8F',
                                   'system_mac_address': None},
                '158FB6E': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '5592 DUKE STREET UNIT C (SEW-WEAR MFG CO '
                                           'LTD)',
                                   'serial': '158FB6E',
                                   'serial_number': '158FB6E',
                                   'system_mac_address': None},
                '159F7F9': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6751 ROAD 124 (KUEPFER ARNOLD)',
                                   'serial': '159F7F9',
                                   'serial_number': '159F7F9',
                                   'system_mac_address': None},
                '159F7FE': {       'dev_macs': [],
                                   'ip_address': None,
                                   'name': '6780 PERTH ROAD 121 (ALBRECHT ALVIN K)',
                                   'serial': '159F7FE',
                                   'serial_number': '159F7FE',
                                   'system_mac_address': None},
                '1606428': {       'dev_macs': [       'c8:4f:86:fc:00:03',
                                                       '60:be:b4:13:b6:c0'],
                                   'ip_address': None,
                                   'name': '40 Temperance St. Milverton (Perth East '
                                           'Complex 10401202)',
                                   'serial': '1606428',
                                   'serial_number': '1606428',
                                   'system_mac_address': None},
                '160D15': {       'dev_macs': ['ec:4f:82:2c:75:23'],
                                  'ip_address': None,
                                  'name': '22 Mill St. W. Milverton (County Of Perth '
                                          'EMS Base 10410443)',
                                  'serial': '160D15',
                                  'serial_number': '160D15',
                                  'system_mac_address': None},
                '161027': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '11 MADDISON ST E',
                                  'serial': '161027',
                                  'serial_number': '161027',
                                  'system_mac_address': None},
                '175E39': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '3 Jo-Lene Ct. Milverton (Bill&June Coulter)',
                                  'serial': '175E39',
                                  'serial_number': '175E39',
                                  'system_mac_address': None},
                '175E6A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '60 William St. Suite 106 (Clara Looser '
                                          '10400400)',
                                  'serial': '175E6A',
                                  'serial_number': '175E6A',
                                  'system_mac_address': None},
                '175E70': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5340 Line 60 Milverton (C VanDerStraeten '
                                          '10434906)',
                                  'serial': '175E70',
                                  'serial_number': '175E70',
                                  'system_mac_address': None},
                '175E72': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '60 WILLIAM ST (ZEHR SALLY)',
                                  'serial': '175E72',
                                  'serial_number': '175E72',
                                  'system_mac_address': None},
                '175EBA': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '1 Pacific Ave. Milverton',
                                  'serial': '175EBA',
                                  'serial_number': '175EBA',
                                  'system_mac_address': None},
                '176215': {       'dev_macs': ['a8:91:62:00:96:13'],
                                  'ip_address': None,
                                  'name': '4700 Line 61 (Perth East Shop 10401421)',
                                  'serial': '176215',
                                  'serial_number': '176215',
                                  'system_mac_address': None},
                '176239': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '60 William St. Suite 109',
                                  'serial': '176239',
                                  'serial_number': '176239',
                                  'system_mac_address': None},
                '17624E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '16 PACIFIC AV (SHOULDICE DARRYL & CHARIS)',
                                  'serial': '17624E',
                                  'serial_number': '17624E',
                                  'system_mac_address': None},
                '1999A7': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '215 Nelson St. Monkton',
                                  'serial': '1999A7',
                                  'serial_number': '1999A7',
                                  'system_mac_address': None},
                '1999FF': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4186 LINE 67 (JANTZI MAHLON K)',
                                  'serial': '1999FF',
                                  'serial_number': '1999FF',
                                  'system_mac_address': None},
                '199A2E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '190 Selby Ave. Monkton (Mandy Smith)',
                                  'serial': '199A2E',
                                  'serial_number': '199A2E',
                                  'system_mac_address': None},
                '199A3A': {       'dev_macs': ['7c:5a:1c:82:a3:57'],
                                  'ip_address': None,
                                  'name': '15 Davis St. Milverton (Gary Boshart)',
                                  'serial': '199A3A',
                                  'serial_number': '199A3A',
                                  'system_mac_address': None},
                '1C5BA6': {       'dev_macs': ['5c:0f:fb:2a:c7:aa'],
                                  'ip_address': None,
                                  'name': '40 Temperance St. Milverton (Mornington '
                                          'Communications)',
                                  'serial': '1C5BA6',
                                  'serial_number': '1C5BA6',
                                  'system_mac_address': None},
                '1C5CB7': {       'dev_macs': ['00:03:e6:f9:fb:7e'],
                                  'ip_address': None,
                                  'name': '60 WILLIAM ST (LUCKHARDT MARION)',
                                  'serial': '1C5CB7',
                                  'serial_number': '1C5CB7',
                                  'system_mac_address': None},
                '1C5CE9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '60 WILLIAM ST (SCHWEITZER DIANE)',
                                  'serial': '1C5CE9',
                                  'serial_number': '1C5CE9',
                                  'system_mac_address': None},
                '1C5D18': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '73 SCHADE ST (SCHMIDT RUTH)',
                                  'serial': '1C5D18',
                                  'serial_number': '1C5D18',
                                  'system_mac_address': None},
                '1CAB1B': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5 SIPPEL ST (CHAPMAN MICHELE)',
                                  'serial': '1CAB1B',
                                  'serial_number': '1CAB1B',
                                  'system_mac_address': None},
                '1CAB4A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '7 TEMPERANCE ST (MCKONE TYLER R)',
                                  'serial': '1CAB4A',
                                  'serial_number': '1CAB4A',
                                  'system_mac_address': None},
                '1CAB56': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '34 William St. Milverton (Melanie Sippel)',
                                  'serial': '1CAB56',
                                  'serial_number': '1CAB56',
                                  'system_mac_address': None},
                '1CC464': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': 'Milverton CO (844G)',
                                  'serial': '1CC464',
                                  'serial_number': '1CC464',
                                  'system_mac_address': None},
                '1CC4B3': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6 Macbeth St (Dan Gerber 10400548)',
                                  'serial': '1CC4B3',
                                  'serial_number': '1CC4B3',
                                  'system_mac_address': None},
                '1D0335': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '12 Pierson St. Milverton (Kyle Baillie)',
                                  'serial': '1D0335',
                                  'serial_number': '1D0335',
                                  'system_mac_address': None},
                '1D0337': {       'dev_macs': ['14:21:03:d1:7d:83'],
                                  'ip_address': None,
                                  'name': '16 MAIN ST N (PATTERSON REBEKKAH)',
                                  'serial': '1D0337',
                                  'serial_number': '1D0337',
                                  'system_mac_address': None},
                '1D033F': {       'dev_macs': ['d0:76:8f:02:ef:7b'],
                                  'ip_address': None,
                                  'name': '9 WILFRED ST (PURVES ALI JOY)',
                                  'serial': '1D033F',
                                  'serial_number': '1D033F',
                                  'system_mac_address': None},
                '1D0343': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '31 William St (Ken Lehmann 10400650)',
                                  'serial': '1D0343',
                                  'serial_number': '1D0343',
                                  'system_mac_address': None},
                '1D0345': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '16 WILLIAM ST (CHAINEY KEVIN)',
                                  'serial': '1D0345',
                                  'serial_number': '1D0345',
                                  'system_mac_address': None},
                '1D0347': {       'dev_macs': ['d0:76:8f:1f:57:30'],
                                  'ip_address': None,
                                  'name': '30 WILLIAM ST (HARRIS CASSIDY)',
                                  'serial': '1D0347',
                                  'serial_number': '1D0347',
                                  'system_mac_address': None},
                '1D04EC': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '22 Mill St E Milverton (Becky '
                                          'Steckly10422799)',
                                  'serial': '1D04EC',
                                  'serial_number': '1D04EC',
                                  'system_mac_address': None},
                '1D04EE': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '47 William St. Milverton (SABRI AKHMAD)',
                                  'serial': '1D04EE',
                                  'serial_number': '1D04EE',
                                  'system_mac_address': None},
                '1D04F0': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '27 William St. Milverton (Donald Schneider)',
                                  'serial': '1D04F0',
                                  'serial_number': '1D04F0',
                                  'system_mac_address': None},
                '1D04F1': {       'dev_macs': ['14:21:03:a9:7f:72'],
                                  'ip_address': None,
                                  'name': '4 WHALEY AVE. (Rod Steckly)',
                                  'serial': '1D04F1',
                                  'serial_number': '1D04F1',
                                  'system_mac_address': None},
                '1D04F2': {       'dev_macs': ['d0:76:8f:02:e2:b8'],
                                  'ip_address': None,
                                  'name': '49 WILLIAM ST (BOWMAN LAURA)',
                                  'serial': '1D04F2',
                                  'serial_number': '1D04F2',
                                  'system_mac_address': None},
                '1D04F5': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '16 MAIN ST N (SCHMITT TONY)',
                                  'serial': '1D04F5',
                                  'serial_number': '1D04F5',
                                  'system_mac_address': None},
                '1D04F6': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '40 William St. Milverton (Merton Kuepfer)',
                                  'serial': '1D04F6',
                                  'serial_number': '1D04F6',
                                  'system_mac_address': None},
                '1D04F7': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '25 Temperance St. Milverton (Cathy '
                                          'Wettlaufer)',
                                  'serial': '1D04F7',
                                  'serial_number': '1D04F7',
                                  'system_mac_address': None},
                '1D04F8': {       'dev_macs': ['60:a4:b7:dd:29:f3'],
                                  'ip_address': None,
                                  'name': '25 WILLIAM ST (ELROY WAGLER MASONRY)',
                                  'serial': '1D04F8',
                                  'serial_number': '1D04F8',
                                  'system_mac_address': None},
                '1D04FA': {       'dev_macs': ['d0:76:8f:02:ed:1e'],
                                  'ip_address': None,
                                  'name': '21 FULTON ST (BOWMAN RON & TRACEY)',
                                  'serial': '1D04FA',
                                  'serial_number': '1D04FA',
                                  'system_mac_address': None},
                '1D04FB': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '11 FULTON ST (DEVRIES MARTIN)',
                                  'serial': '1D04FB',
                                  'serial_number': '1D04FB',
                                  'system_mac_address': None},
                '1D04FC': {       'dev_macs': ['5c:0f:fb:2a:c7:1e'],
                                  'ip_address': None,
                                  'name': '3 John St. Milverton (Fred Jones 10401195)',
                                  'serial': '1D04FC',
                                  'serial_number': '1D04FC',
                                  'system_mac_address': None},
                '1D04FD': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '10 JOHN ST (GOWING COLE)',
                                  'serial': '1D04FD',
                                  'serial_number': '1D04FD',
                                  'system_mac_address': None},
                '1D0500': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '10 Adelaide St. Milverton (Jeremy Sippel '
                                          '10420159)',
                                  'serial': '1D0500',
                                  'serial_number': '1D0500',
                                  'system_mac_address': None},
                '1D0501': {       'dev_macs': ['d0:76:8f:1f:6a:f4'],
                                  'ip_address': None,
                                  'name': '1 Grosch St. Milverton (Joyce Riddell '
                                          '10432778)',
                                  'serial': '1D0501',
                                  'serial_number': '1D0501',
                                  'system_mac_address': None},
                '1D0502': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '11 Pugh St Milverton (Greg Storey)',
                                  'serial': '1D0502',
                                  'serial_number': '1D0502',
                                  'system_mac_address': None},
                '1D0503': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '8 ADELAIDE ST',
                                  'serial': '1D0503',
                                  'serial_number': '1D0503',
                                  'system_mac_address': None},
                '1D0504': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '17 MacBeth St. (David Schultz)',
                                  'serial': '1D0504',
                                  'serial_number': '1D0504',
                                  'system_mac_address': None},
                '1D0505': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '7 Wilfred St. Milverton (Gwen Moffat '
                                          '10431370)',
                                  'serial': '1D0505',
                                  'serial_number': '1D0505',
                                  'system_mac_address': None},
                '1D0506': {       'dev_macs': ['60:db:98:09:1b:96'],
                                  'ip_address': None,
                                  'name': '25A Temperance St. Milverton (Vince '
                                          'Etchells)',
                                  'serial': '1D0506',
                                  'serial_number': '1D0506',
                                  'system_mac_address': None},
                '1D0508': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '14 Fulton St. Milverton (Nathan Matheson '
                                          '10426412)',
                                  'serial': '1D0508',
                                  'serial_number': '1D0508',
                                  'system_mac_address': None},
                '1D050A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '12 John St. Milverton (Jim Abraham)',
                                  'serial': '1D050A',
                                  'serial_number': '1D050A',
                                  'system_mac_address': None},
                '1D050C': {       'dev_macs': ['44:65:7f:89:0d:89'],
                                  'ip_address': None,
                                  'name': '15 Fulton St. Milverton (Becky Westman '
                                          '10427702)',
                                  'serial': '1D050C',
                                  'serial_number': '1D050C',
                                  'system_mac_address': None},
                '1D050D': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '11 George St. Milverton',
                                  'serial': '1D050D',
                                  'serial_number': '1D050D',
                                  'system_mac_address': None},
                '1D050F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '19 Whaley Ave. Milverton (Monica&Joe Phelan '
                                          '10421673)',
                                  'serial': '1D050F',
                                  'serial_number': '1D050F',
                                  'system_mac_address': None},
                '1D0510': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '18 William St. Milverton (Landon Sellers)',
                                  'serial': '1D0510',
                                  'serial_number': '1D0510',
                                  'system_mac_address': None},
                '1D0512': {       'dev_macs': ['d0:76:8f:02:f1:54'],
                                  'ip_address': None,
                                  'name': '23 Fulton St. Milverton (Doug Egerdee)',
                                  'serial': '1D0512',
                                  'serial_number': '1D0512',
                                  'system_mac_address': None},
                '1D067B': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': 'William Nahrgang (12 George)',
                                  'serial': '1D067B',
                                  'serial_number': '1D067B',
                                  'system_mac_address': None},
                '1D067F': {       'dev_macs': ['ec:4f:82:a5:05:aa'],
                                  'ip_address': None,
                                  'name': '201 Winstanley St. Monkton (Neil Ward)',
                                  'serial': '1D067F',
                                  'serial_number': '1D067F',
                                  'system_mac_address': None},
                '1D0683': {       'dev_macs': ['b8:94:70:9d:af:21'],
                                  'ip_address': None,
                                  'name': '174 Maddison St. E. Monkton (Roy Beuerman)',
                                  'serial': '1D0683',
                                  'serial_number': '1D0683',
                                  'system_mac_address': None},
                '1D0687': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '42 William St. Milverton (Robert Sippel)',
                                  'serial': '1D0687',
                                  'serial_number': '1D0687',
                                  'system_mac_address': None},
                '1D0688': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '22 Pacific Ave. Milverton (Kevin Rich)',
                                  'serial': '1D0688',
                                  'serial_number': '1D0688',
                                  'system_mac_address': None},
                '1D0689': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 William St. Apt # 105 (Amanda Bush)',
                                  'serial': '1D0689',
                                  'serial_number': '1D0689',
                                  'system_mac_address': None},
                '1D068A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '53 Temperance St. Milverton (Heather Arand '
                                          '10401553)',
                                  'serial': '1D068A',
                                  'serial_number': '1D068A',
                                  'system_mac_address': None},
                '1D068B': {       'dev_macs': ['84:d3:43:6d:ed:bb'],
                                  'ip_address': None,
                                  'name': '112 Mill St. E. Milverton (Earl Leis)',
                                  'serial': '1D068B',
                                  'serial_number': '1D068B',
                                  'system_mac_address': None},
                '1D068C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '22 Pacific Ave. Milverton (Robert Paton)',
                                  'serial': '1D068C',
                                  'serial_number': '1D068C',
                                  'system_mac_address': None},
                '1D068D': {       'dev_macs': ['b8:94:70:f3:e5:5e'],
                                  'ip_address': None,
                                  'name': '44 Gerber Dr. Milverton (Ryan Harloff)',
                                  'serial': '1D068D',
                                  'serial_number': '1D068D',
                                  'system_mac_address': None},
                '1D068F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '108 Mill St. E. Milverton (Larry Kropf)',
                                  'serial': '1D068F',
                                  'serial_number': '1D068F',
                                  'system_mac_address': None},
                '1D0691': {       'dev_macs': ['d0:76:8f:91:d3:0f'],
                                  'ip_address': None,
                                  'name': '46 William St. Milverton (BRUBACHER MARK)',
                                  'serial': '1D0691',
                                  'serial_number': '1D0691',
                                  'system_mac_address': None},
                '1D0692': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '9 WEST ST (TRAINOR CASSIDY)',
                                  'serial': '1D0692',
                                  'serial_number': '1D0692',
                                  'system_mac_address': None},
                '1D0694': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '9 John St. Milverton (Shannon Cairns '
                                          '10432740)',
                                  'serial': '1D0694',
                                  'serial_number': '1D0694',
                                  'system_mac_address': None},
                '1D0695': {       'dev_macs': ['44:65:7f:5d:bd:9f'],
                                  'ip_address': None,
                                  'name': '41 Temperance St. Milverton (Charlene '
                                          'Lehman 10433199)',
                                  'serial': '1D0695',
                                  'serial_number': '1D0695',
                                  'system_mac_address': None},
                '1D069A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '18 Fulton St. Milverton (Joe Schlueter)',
                                  'serial': '1D069A',
                                  'serial_number': '1D069A',
                                  'system_mac_address': None},
                '1D069B': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '13 MacBeth St. Milverton (James '
                                          'Adams-Kipfer)',
                                  'serial': '1D069B',
                                  'serial_number': '1D069B',
                                  'system_mac_address': None},
                '1D069D': {       'dev_macs': ['84:d3:43:0f:62:99'],
                                  'ip_address': None,
                                  'name': '6 WHALEY AV (PHILLIPS JODI)',
                                  'serial': '1D069D',
                                  'serial_number': '1D069D',
                                  'system_mac_address': None},
                '1D069F': {       'dev_macs': ['14:21:03:d1:88:e6'],
                                  'ip_address': None,
                                  'name': '11 PACIFIC AV (WEBER SARAH)',
                                  'serial': '1D069F',
                                  'serial_number': '1D069F',
                                  'system_mac_address': None},
                '1D06A1': {       'dev_macs': ['04:bc:9f:46:95:45'],
                                  'ip_address': None,
                                  'name': '14 Whaley Ave. Milverton (MCARTHUR JIM)',
                                  'serial': '1D06A1',
                                  'serial_number': '1D06A1',
                                  'system_mac_address': None},
                '1D06B9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '16 Whaley Ave. Milverton (Sherri Gilbert)',
                                  'serial': '1D06B9',
                                  'serial_number': '1D06B9',
                                  'system_mac_address': None},
                '1D06CD': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '60 Mill St. E. Milverton (William Jantzi '
                                          '10432843)',
                                  'serial': '1D06CD',
                                  'serial_number': '1D06CD',
                                  'system_mac_address': None},
                '1D06D1': {       'dev_macs': ['d0:76:8f:91:d4:bc'],
                                  'ip_address': None,
                                  'name': '26 MAIN ST S (HOWE NICOLE)',
                                  'serial': '1D06D1',
                                  'serial_number': '1D06D1',
                                  'system_mac_address': None},
                '1D06D7': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '8 WHALEY AV (STECKLY DOUG)',
                                  'serial': '1D06D7',
                                  'serial_number': '1D06D7',
                                  'system_mac_address': None},
                '1D06E1': {       'dev_macs': ['14:21:03:d1:8a:e0'],
                                  'ip_address': None,
                                  'name': '217 Winstanley St. Monkton (Mike Chambers)',
                                  'serial': '1D06E1',
                                  'serial_number': '1D06E1',
                                  'system_mac_address': None},
                '1D0714': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '10 Whaley Ave. Milverton (Dave Dickson)',
                                  'serial': '1D0714',
                                  'serial_number': '1D0714',
                                  'system_mac_address': None},
                '1D0718': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '17 Mill St. W. (Peter Wall 10423210)',
                                  'serial': '1D0718',
                                  'serial_number': '1D0718',
                                  'system_mac_address': None},
                '1FD6B7': {       'dev_macs': ['70:4c:a5:6d:0c:b0'],
                                  'ip_address': None,
                                  'name': '68 Mill St. E. Milverton (Milverton Public '
                                          'School)',
                                  'serial': '1FD6B7',
                                  'serial_number': '1FD6B7',
                                  'system_mac_address': None},
                '1FD6DB': {       'dev_macs': [       '14:21:03:8b:71:55',
                                                      'ec:4f:82:a5:04:54',
                                                      'ec:4f:82:ac:eb:89',
                                                      '04:bc:9f:46:94:c1'],
                                  'ip_address': None,
                                  'name': "2 Llana Heights Milverton (Apt #'s "
                                          '11-12-14-15)',
                                  'serial': '1FD6DB',
                                  'serial_number': '1FD6DB',
                                  'system_mac_address': None},
                '205B38': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 MAIN ST S (COOK CONSTANCE)',
                                  'serial': '205B38',
                                  'serial_number': '205B38',
                                  'system_mac_address': None},
                '205B3C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 William St Apt 3',
                                  'serial': '205B3C',
                                  'serial_number': '205B3C',
                                  'system_mac_address': None},
                '205BDC': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4 Winstanley St Monkton (Cherie Smith '
                                          '10430700)',
                                  'serial': '205BDC',
                                  'serial_number': '205BDC',
                                  'system_mac_address': None},
                '205D97': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 MAIN ST S (MCCUTCHEN WINNIE)',
                                  'serial': '205D97',
                                  'serial_number': '205D97',
                                  'system_mac_address': None},
                '205D9B': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4 Mill St E Milverton Apt 2 (Maxine '
                                          'Kuepfer)',
                                  'serial': '205D9B',
                                  'serial_number': '205D9B',
                                  'system_mac_address': None},
                '205D9C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 William St Milverton (Jonathan Siderius '
                                          '10434882)',
                                  'serial': '205D9C',
                                  'serial_number': '205D9C',
                                  'system_mac_address': None},
                '205DA4': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '43 Maddison St E Monkton (Christine Rose '
                                          '10432948)',
                                  'serial': '205DA4',
                                  'serial_number': '205DA4',
                                  'system_mac_address': None},
                '205DB1': {       'dev_macs': ['b8:94:70:bc:b9:1f'],
                                  'ip_address': None,
                                  'name': '55 WILLIAM ST (ANDRE JOLY)',
                                  'serial': '205DB1',
                                  'serial_number': '205DB1',
                                  'system_mac_address': None},
                '205DB9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '104 Mill St. E. Milverton (Doug Fyfe '
                                          '10402350)',
                                  'serial': '205DB9',
                                  'serial_number': '205DB9',
                                  'system_mac_address': None},
                '205DBB': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 William St Apt 203 Milverton (Diane '
                                          'Playford 10435440)',
                                  'serial': '205DBB',
                                  'serial_number': '205DBB',
                                  'system_mac_address': None},
                '205DBC': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 WILLIAM ST (PAULNITZ CATHY)',
                                  'serial': '205DBC',
                                  'serial_number': '205DBC',
                                  'system_mac_address': None},
                '205DBD': {       'dev_macs': ['14:21:03:d1:64:8c'],
                                  'ip_address': None,
                                  'name': '23 PACIFIC AV (WILLIAMS TY)',
                                  'serial': '205DBD',
                                  'serial_number': '205DBD',
                                  'system_mac_address': None},
                '205DC0': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '15 MAIN ST APT. 202 (GOETZ MATTHEW)',
                                  'serial': '205DC0',
                                  'serial_number': '205DC0',
                                  'system_mac_address': None},
                '205DC2': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '7 MAIN ST N',
                                  'serial': '205DC2',
                                  'serial_number': '205DC2',
                                  'system_mac_address': None},
                '205DC3': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '78 MILL ST E (CARTER ROGER & MICHELLE)',
                                  'serial': '205DC3',
                                  'serial_number': '205DC3',
                                  'system_mac_address': None},
                '205DC5': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '26 MAIN ST N',
                                  'serial': '205DC5',
                                  'serial_number': '205DC5',
                                  'system_mac_address': None},
                '205DC8': {       'dev_macs': ['5c:0f:fb:3d:80:66'],
                                  'ip_address': None,
                                  'name': '60 WILLIAM ST STE 104 (COSSEY JEAN)',
                                  'serial': '205DC8',
                                  'serial_number': '205DC8',
                                  'system_mac_address': None},
                '205DCB': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '44 Main St. N. Milverton (David Weber)',
                                  'serial': '205DCB',
                                  'serial_number': '205DCB',
                                  'system_mac_address': None},
                '205DCF': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '65 MAIN ST S (HAHN LEWIS)',
                                  'serial': '205DCF',
                                  'serial_number': '205DCF',
                                  'system_mac_address': None},
                '205DD1': {       'dev_macs': ['44:65:7f:3e:98:0e'],
                                  'ip_address': None,
                                  'name': '20 Pacific Ave. Milverton (Debbie '
                                          'Timmermans10401639)',
                                  'serial': '205DD1',
                                  'serial_number': '205DD1',
                                  'system_mac_address': None},
                '205DDC': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4 Main St S Apt 2 Milverton (DUNBAR SARAH)',
                                  'serial': '205DDC',
                                  'serial_number': '205DDC',
                                  'system_mac_address': None},
                '205DDE': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '12 PUGH ST W (PRISECARU TIMOTEI)',
                                  'serial': '205DDE',
                                  'serial_number': '205DDE',
                                  'system_mac_address': None},
                '205DE3': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '34 Pacific Av Milverton (Jeremy Matheson)',
                                  'serial': '205DE3',
                                  'serial_number': '205DE3',
                                  'system_mac_address': None},
                '205DED': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '82 Reagan St. Milverton (Craig & Julie '
                                          'Purvis 10435983)',
                                  'serial': '205DED',
                                  'serial_number': '205DED',
                                  'system_mac_address': None},
                '205DEE': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '76 MAIN ST S (UHC OF WESTERN ONTARIO MCO '
                                          '839)',
                                  'serial': '205DEE',
                                  'serial_number': '205DEE',
                                  'system_mac_address': None},
                '205DF1': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 WILLIAM STREET APT 201 (HARVEY JANE)',
                                  'serial': '205DF1',
                                  'serial_number': '205DF1',
                                  'system_mac_address': None},
                '205DF4': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4 MAIN ST S (CASKANETTE BENJAMEN)',
                                  'serial': '205DF4',
                                  'serial_number': '205DF4',
                                  'system_mac_address': None},
                '205DF6': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '45 Main St. N. Milverton (Greg Guenther)',
                                  'serial': '205DF6',
                                  'serial_number': '205DF6',
                                  'system_mac_address': None},
                '205DF8': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '42 Main St S Milverton (Cook Millwrighting '
                                          '10401478)',
                                  'serial': '205DF8',
                                  'serial_number': '205DF8',
                                  'system_mac_address': None},
                '205DFC': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6480 Perth Rd. 131 (Fritz Ryter)',
                                  'serial': '205DFC',
                                  'serial_number': '205DFC',
                                  'system_mac_address': None},
                '205DFE': {       'dev_macs': ['14:21:03:92:ea:76'],
                                  'ip_address': None,
                                  'name': '4 George St. Milverton (Tom Broda)',
                                  'serial': '205DFE',
                                  'serial_number': '205DFE',
                                  'system_mac_address': None},
                '205E03': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '57 Temperance St. Milverton (Jim Schneuker '
                                          '10401435)',
                                  'serial': '205E03',
                                  'serial_number': '205E03',
                                  'system_mac_address': None},
                '205E05': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '62 MAIN STREET N (FOBEL RICHARD)',
                                  'serial': '205E05',
                                  'serial_number': '205E05',
                                  'system_mac_address': None},
                '205E06': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 WILLIAM ST (BARONETTE ROGER)',
                                  'serial': '205E06',
                                  'serial_number': '205E06',
                                  'system_mac_address': None},
                '205E1E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 WILLIAM ST (HUBERTS KIRK)',
                                  'serial': '205E1E',
                                  'serial_number': '205E1E',
                                  'system_mac_address': None},
                '205E20': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '13 Mill St.. W. Milverton (Trevor Woods)',
                                  'serial': '205E20',
                                  'serial_number': '205E20',
                                  'system_mac_address': None},
                '237A25': {       'dev_macs': ['cc:be:59:32:94:ce'],
                                  'ip_address': None,
                                  'name': '37 Mill St. W. Milverton (John Gerber '
                                          'Construction 10401482)',
                                  'serial': '237A25',
                                  'serial_number': '237A25',
                                  'system_mac_address': None},
                '237AE5': {       'dev_macs': [       'ec:4f:82:12:e4:cd',
                                                      '5c:0f:fb:2f:cc:9c'],
                                  'ip_address': None,
                                  'name': '14 Mill St. W. Milverton (Mill Wood Manor)',
                                  'serial': '237AE5',
                                  'serial_number': '237AE5',
                                  'system_mac_address': None},
                '248ACB': {       'dev_macs': ['ec:4f:82:a5:13:0f'],
                                  'ip_address': None,
                                  'name': '45A & 45B William St. (Norma& Neil Wilker)',
                                  'serial': '248ACB',
                                  'serial_number': '248ACB',
                                  'system_mac_address': None},
                '248AD4': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': 'Derick Stolz 10430219 (52 schade st)',
                                  'serial': '248AD4',
                                  'serial_number': '248AD4',
                                  'system_mac_address': None},
                '25982A': {       'dev_macs': ['ec:4f:82:2d:32:6b'],
                                  'ip_address': None,
                                  'name': '36 Main St. N. Milverton (Milverton '
                                          'Foodtown)',
                                  'serial': '25982A',
                                  'serial_number': '25982A',
                                  'system_mac_address': None},
                '259837': {       'dev_macs': ['00:0d:b9:57:ae:71'],
                                  'ip_address': None,
                                  'name': '6440 Perth Rd. 131 (Leis Feed 10422648)',
                                  'serial': '259837',
                                  'serial_number': '259837',
                                  'system_mac_address': None},
                '25D92E': {       'dev_macs': ['ec:4f:82:ac:ed:f6'],
                                  'ip_address': None,
                                  'name': '35 Main St. S. Milverton (Randy Martin '
                                          '10434943)',
                                  'serial': '25D92E',
                                  'serial_number': '25D92E',
                                  'system_mac_address': None},
                '260E6A': {       'dev_macs': ['d4:76:a0:a3:53:9a'],
                                  'ip_address': None,
                                  'name': '14 MILL ST W (VERELLEN GREG R)',
                                  'serial': '260E6A',
                                  'serial_number': '260E6A',
                                  'system_mac_address': None},
                '260E96': {       'dev_macs': ['70:4c:a5:f1:71:7a'],
                                  'ip_address': None,
                                  'name': '1 Main St. S. Milverton (Zehr Insurance)',
                                  'serial': '260E96',
                                  'serial_number': '260E96',
                                  'system_mac_address': None},
                '260E97': {       'dev_macs': [       'cc:be:59:7e:ba:ee',
                                                      '5c:0f:fb:2a:0a:48',
                                                      '44:65:7f:88:47:41',
                                                      '58:d9:d5:1a:75:99',
                                                      '44:65:7f:89:0a:44'],
                                  'ip_address': None,
                                  'name': '14 MILL ST W',
                                  'serial': '260E97',
                                  'serial_number': '260E97',
                                  'system_mac_address': None},
                '2625E5': {       'dev_macs': ['00:f8:2c:7f:5e:70'],
                                  'ip_address': None,
                                  'name': '12 Main St. S. Milverton (Kindred Credit '
                                          'Union)',
                                  'serial': '2625E5',
                                  'serial_number': '2625E5',
                                  'system_mac_address': None},
                '2625E7': {       'dev_macs': [       '00:03:e6:a4:db:66',
                                                      '00:03:e6:dd:32:0c',
                                                      '00:03:e6:a5:73:18',
                                                      '5c:0f:fb:43:96:d2',
                                                      '5c:0f:fb:3d:58:16'],
                                  'ip_address': None,
                                  'name': '50 WILLIAM ST',
                                  'serial': '2625E7',
                                  'serial_number': '2625E7',
                                  'system_mac_address': None},
                '2625EA': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '48 PUGH ST',
                                  'serial': '2625EA',
                                  'serial_number': '2625EA',
                                  'system_mac_address': None},
                '263200': {       'dev_macs': [       '00:03:e6:db:46:da',
                                                      '00:03:e6:a5:6e:9a',
                                                      '5c:0f:fb:3d:5b:d8',
                                                      'cc:be:59:c3:48:5f',
                                                      '00:03:e6:dd:30:52',
                                                      '5c:0f:fb:3d:74:50',
                                                      '5c:0f:fb:42:65:20'],
                                  'ip_address': None,
                                  'name': '50 WILLIAM ST (BRUCE WILLIAM)',
                                  'serial': '263200',
                                  'serial_number': '263200',
                                  'system_mac_address': None},
                '263201': {       'dev_macs': [       '5c:0f:fb:15:4f:0a',
                                                      '5c:0f:fb:3d:5b:e0',
                                                      '5c:0f:fb:3d:58:28'],
                                  'ip_address': None,
                                  'name': '50 WILLIAM ST',
                                  'serial': '263201',
                                  'serial_number': '263201',
                                  'system_mac_address': None},
                '263222': {       'dev_macs': [       '00:03:e6:a4:da:68',
                                                      '5c:0f:fb:3d:7d:a2',
                                                      '00:03:e6:a4:db:58',
                                                      '00:03:e6:a5:73:9e',
                                                      '5c:0f:fb:3d:5a:b2'],
                                  'ip_address': None,
                                  'name': '50 WILLIAM ST (ALBRECHT MISS CATHERINE)',
                                  'serial': '263222',
                                  'serial_number': '263222',
                                  'system_mac_address': None},
                '264414': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '54 Mill St. W. Milverton (Wesbell '
                                          'Technologies)',
                                  'serial': '264414',
                                  'serial_number': '264414',
                                  'system_mac_address': None},
                '26AC6F': {       'dev_macs': [       '5c:0f:fb:3d:5b:1c',
                                                      '5c:0f:fb:3d:7d:82',
                                                      '00:03:e6:dd:31:50',
                                                      '5c:0f:fb:3d:5b:0c',
                                                      '5c:0f:fb:3d:80:1c',
                                                      '5c:0f:fb:17:75:1a'],
                                  'ip_address': None,
                                  'name': '50 WILLIAM ST',
                                  'serial': '26AC6F',
                                  'serial_number': '26AC6F',
                                  'system_mac_address': None},
                '26CC54': {       'dev_macs': [       'cc:be:59:2d:a5:26',
                                                      '34:60:f9:0a:f2:d1',
                                                      '5c:0f:fb:2a:0e:10'],
                                  'ip_address': None,
                                  'name': '214 Winstanley St. Monkton (8 Plex Apt)',
                                  'serial': '26CC54',
                                  'serial_number': '26CC54',
                                  'system_mac_address': None},
                '26D966': {       'dev_macs': [       '00:03:e6:a5:70:b2',
                                                      '5c:0f:fb:3d:58:de',
                                                      '5c:0f:fb:43:97:58',
                                                      '5c:0f:fb:3d:7d:9a',
                                                      '00:03:e6:a5:6f:ae'],
                                  'ip_address': None,
                                  'name': '50 William St. Milverton (Data Rm 2 '
                                          'Knollcrest)',
                                  'serial': '26D966',
                                  'serial_number': '26D966',
                                  'system_mac_address': None},
                '26D992': {       'dev_macs': [       'b4:b0:24:8b:b9:11',
                                                      '88:d7:f6:b8:30:24',
                                                      '14:21:03:92:f6:1b'],
                                  'ip_address': None,
                                  'name': '1 LLANA HEIGHTS DR (KNIPE JACQUELYN)',
                                  'serial': '26D992',
                                  'serial_number': '26D992',
                                  'system_mac_address': None},
                '28F653': {       'dev_macs': ['40:5d:82:e1:9b:c9'],
                                  'ip_address': None,
                                  'name': '27 Mill St. W. Milverton (Mary Francis '
                                          'Lambert-Hill)',
                                  'serial': '28F653',
                                  'serial_number': '28F653',
                                  'system_mac_address': None},
                '28F664': {       'dev_macs': ['50:d4:f7:80:62:e9'],
                                  'ip_address': None,
                                  'name': '8 Edward St. Milverton (Katrina MacPherson)',
                                  'serial': '28F664',
                                  'serial_number': '28F664',
                                  'system_mac_address': None},
                '296FB8': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '2 Whaley Ave. Milverton (Dave Paradis '
                                          '10401473)',
                                  'serial': '296FB8',
                                  'serial_number': '296FB8',
                                  'system_mac_address': None},
                '296FC0': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '11 Whaley Ave. Milverton',
                                  'serial': '296FC0',
                                  'serial_number': '296FC0',
                                  'system_mac_address': None},
                '296FC1': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '13 Fulton St. Milverton (Richard Roulston '
                                          '10401073)',
                                  'serial': '296FC1',
                                  'serial_number': '296FC1',
                                  'system_mac_address': None},
                '296FC4': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '23 Mill St. W. Milverton (James Wagler '
                                          '10401047)',
                                  'serial': '296FC4',
                                  'serial_number': '296FC4',
                                  'system_mac_address': None},
                '296FC5': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '20 Fulton St. Milverton (Jeff Leblanc)',
                                  'serial': '296FC5',
                                  'serial_number': '296FC5',
                                  'system_mac_address': None},
                '296FC7': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '18 TEMPERANCE ST (DALE BRIAN)',
                                  'serial': '296FC7',
                                  'serial_number': '296FC7',
                                  'system_mac_address': None},
                '296FC9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '17 Whaley Ave. Milverton (Darrel Roth)',
                                  'serial': '296FC9',
                                  'serial_number': '296FC9',
                                  'system_mac_address': None},
                '296FEB': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '11 EDWARD ST (WATSON BRENNAN)',
                                  'serial': '296FEB',
                                  'serial_number': '296FEB',
                                  'system_mac_address': None},
                '2981E1': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '57 MAIN ST N (DZODAN DEJAN)',
                                  'serial': '2981E1',
                                  'serial_number': '2981E1',
                                  'system_mac_address': None},
                '2981E4': {       'dev_macs': [       '00:03:e6:a2:fd:72',
                                                      '00:03:e6:db:23:56'],
                                  'ip_address': None,
                                  'name': '19 West St. Milverton (Brennan Erb)',
                                  'serial': '2981E4',
                                  'serial_number': '2981E4',
                                  'system_mac_address': None},
                '2981E5': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '29 West St. Milverton (Tim Ellis 10401774)',
                                  'serial': '2981E5',
                                  'serial_number': '2981E5',
                                  'system_mac_address': None},
                '2981E6': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '3 PACIFIC AV',
                                  'serial': '2981E6',
                                  'serial_number': '2981E6',
                                  'system_mac_address': None},
                '2981FA': {       'dev_macs': ['04:bc:9f:46:8e:a7'],
                                  'ip_address': None,
                                  'name': '11 JOHN ST (HURAS JENNIFER)',
                                  'serial': '2981FA',
                                  'serial_number': '2981FA',
                                  'system_mac_address': None},
                '2981FF': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '18 West St. Milverton (Brian & Amy Martin '
                                          '10434104)',
                                  'serial': '2981FF',
                                  'serial_number': '2981FF',
                                  'system_mac_address': None},
                '298200': {       'dev_macs': ['b8:94:70:f3:e1:33'],
                                  'ip_address': None,
                                  'name': '18 Pacific Ave. Milverton (Allissa '
                                          'Wettlaufer)',
                                  'serial': '298200',
                                  'serial_number': '298200',
                                  'system_mac_address': None},
                '298212': {       'dev_macs': ['d0:76:8f:1f:58:9b'],
                                  'ip_address': None,
                                  'name': '6 PACIFIC AV (ROULSTON WAYNE)',
                                  'serial': '298212',
                                  'serial_number': '298212',
                                  'system_mac_address': None},
                '29821E': {       'dev_macs': ['14:21:03:92:f2:c1'],
                                  'ip_address': None,
                                  'name': '24 PACIFIC AV (SMITH CHRISTINA)',
                                  'serial': '29821E',
                                  'serial_number': '29821E',
                                  'system_mac_address': None},
                '29821F': {       'dev_macs': ['d0:76:8f:02:f1:ee'],
                                  'ip_address': None,
                                  'name': '10 WEST ST (MURRAY JENNIFER)',
                                  'serial': '29821F',
                                  'serial_number': '29821F',
                                  'system_mac_address': None},
                '298225': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '16 Fulton St. Milverton (Jill Ross '
                                          '10430010)',
                                  'serial': '298225',
                                  'serial_number': '298225',
                                  'system_mac_address': None},
                '298232': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '29 MAIN ST S (SCHWARTZENBERGER ALLAN '
                                          '10438370)',
                                  'serial': '298232',
                                  'serial_number': '298232',
                                  'system_mac_address': None},
                '298248': {       'dev_macs': ['d0:76:8f:1f:5b:5b'],
                                  'ip_address': None,
                                  'name': '3 Whaley Av. Milverton (MATHESON TYLER)',
                                  'serial': '298248',
                                  'serial_number': '298248',
                                  'system_mac_address': None},
                '29824D': {       'dev_macs': ['60:db:98:09:37:a5'],
                                  'ip_address': None,
                                  'name': '162 FISHLEIGH ST (MATTHEWS GRANT)',
                                  'serial': '29824D',
                                  'serial_number': '29824D',
                                  'system_mac_address': None},
                '29824E': {       'dev_macs': ['84:d3:43:6d:e7:5f'],
                                  'ip_address': None,
                                  'name': '13 West St. Milverton (Richard Harrow)',
                                  'serial': '29824E',
                                  'serial_number': '29824E',
                                  'system_mac_address': None},
                '29824F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6467 Perth Rd. 131 (Kate Arand)',
                                  'serial': '29824F',
                                  'serial_number': '29824F',
                                  'system_mac_address': None},
                '298253': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '20 Whaley Ave (FINNIE EVELYN)',
                                  'serial': '298253',
                                  'serial_number': '298253',
                                  'system_mac_address': None},
                '298254': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '38 William St. Milverton (James Brubacher)',
                                  'serial': '298254',
                                  'serial_number': '298254',
                                  'system_mac_address': None},
                '29825F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '9 MacBeth St. Milverton (Don Gascho)',
                                  'serial': '29825F',
                                  'serial_number': '29825F',
                                  'system_mac_address': None},
                '298262': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '8 WEST ST (DAGG DEVIN)',
                                  'serial': '298262',
                                  'serial_number': '298262',
                                  'system_mac_address': None},
                '298268': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '19 William St. Milverton (ROPP ADAM)',
                                  'serial': '298268',
                                  'serial_number': '298268',
                                  'system_mac_address': None},
                '29827C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '15 Pierson St. Milverton (Mryna Schmidt '
                                          '10400672)',
                                  'serial': '29827C',
                                  'serial_number': '29827C',
                                  'system_mac_address': None},
                '298289': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '14 William St. Milverton (Bill Moore '
                                          '10404221)',
                                  'serial': '298289',
                                  'serial_number': '298289',
                                  'system_mac_address': None},
                '29828D': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '15 Whaley Ave. Milverton (Ron Kipfer)',
                                  'serial': '29828D',
                                  'serial_number': '29828D',
                                  'system_mac_address': None},
                '2982B7': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '12 Whaley Ave. Milverton (Adam Sage)',
                                  'serial': '2982B7',
                                  'serial_number': '2982B7',
                                  'system_mac_address': None},
                '2982C4': {       'dev_macs': ['d0:76:8f:02:f3:01'],
                                  'ip_address': None,
                                  'name': '59 MAIN ST N (HOLMES  BRANDON)',
                                  'serial': '2982C4',
                                  'serial_number': '2982C4',
                                  'system_mac_address': None},
                '2982C8': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 William St. Apt#102 Milverton',
                                  'serial': '2982C8',
                                  'serial_number': '2982C8',
                                  'system_mac_address': None},
                '298301': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '26 Main St. N. Milverton (Innovapost Inc '
                                          '10431404)',
                                  'serial': '298301',
                                  'serial_number': '298301',
                                  'system_mac_address': None},
                '29834C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '33 Pacific Ave. Milverton (Jeffrey Plager '
                                          '10434465)',
                                  'serial': '29834C',
                                  'serial_number': '29834C',
                                  'system_mac_address': None},
                '298385': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6465 Perth Rd. 131 (Peggy Birmingham)',
                                  'serial': '298385',
                                  'serial_number': '298385',
                                  'system_mac_address': None},
                '2983ED': {       'dev_macs': ['d0:76:8f:02:f3:d2'],
                                  'ip_address': None,
                                  'name': '6469 Perth Rd. 131 (Brian Nafziger '
                                          '10427589)',
                                  'serial': '2983ED',
                                  'serial_number': '2983ED',
                                  'system_mac_address': None},
                '2983F8': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6 MILL ST E APT 2 (STREAMLINE ENGINEERING '
                                          'INC)',
                                  'serial': '2983F8',
                                  'serial_number': '2983F8',
                                  'system_mac_address': None},
                '298439': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6 ADELAIDE ST (SANGUYO DAVID)',
                                  'serial': '298439',
                                  'serial_number': '298439',
                                  'system_mac_address': None},
                '298442': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '166 Winstanley St. Monkton (Danielle '
                                          'MacDonald)',
                                  'serial': '298442',
                                  'serial_number': '298442',
                                  'system_mac_address': None},
                '29845A': {       'dev_macs': [       '44:65:7f:89:0b:ac',
                                                      '5c:0f:fb:2a:06:98',
                                                      '5c:0f:fb:2a:05:66'],
                                  'ip_address': None,
                                  'name': '6464 Perth Rd. 131 (Ross Gerber)',
                                  'serial': '29845A',
                                  'serial_number': '29845A',
                                  'system_mac_address': None},
                '298576': {       'dev_macs': ['84:d3:43:6d:f0:4f'],
                                  'ip_address': None,
                                  'name': '21 PACIFIC AV (EISENHOFER MARJ)',
                                  'serial': '298576',
                                  'serial_number': '298576',
                                  'system_mac_address': None},
                '2A1AD3': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '28 Main St. N. Milverton (Milverton Family '
                                          'Dental)',
                                  'serial': '2A1AD3',
                                  'serial_number': '2A1AD3',
                                  'system_mac_address': None},
                '2AC4B6': {       'dev_macs': ['cc:be:59:7e:ba:5e'],
                                  'ip_address': None,
                                  'name': '8 Temperance St. Milverton (Mike Crapper '
                                          '10425901)',
                                  'serial': '2AC4B6',
                                  'serial_number': '2AC4B6',
                                  'system_mac_address': None},
                '2AD0BC': {       'dev_macs': ['ec:4f:82:ac:e3:19'],
                                  'ip_address': None,
                                  'name': '49 Maddison St W (A & A McKenzie)',
                                  'serial': '2AD0BC',
                                  'serial_number': '2AD0BC',
                                  'system_mac_address': None},
                '2AD0F1': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '47 MILL ST (COXON ROBERT)',
                                  'serial': '2AD0F1',
                                  'serial_number': '2AD0F1',
                                  'system_mac_address': None},
                '2AFB74': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '3 Spencer St. Milverton (Jason Yantzi)',
                                  'serial': '2AFB74',
                                  'serial_number': '2AFB74',
                                  'system_mac_address': None},
                '2B0150': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5734 LINE 57 (VAN NULAND MARIA (MELANIE))',
                                  'serial': '2B0150',
                                  'serial_number': '2B0150',
                                  'system_mac_address': None},
                '2B0176': {       'dev_macs': ['5c:0f:fb:2a:0a:d2'],
                                  'ip_address': None,
                                  'name': '6 Grosch St. Milverton (Jim Partridge)',
                                  'serial': '2B0176',
                                  'serial_number': '2B0176',
                                  'system_mac_address': None},
                '2B0181': {       'dev_macs': ['60:db:98:09:38:8c'],
                                  'ip_address': None,
                                  'name': '6472 Perth Road 131 (Brett Kipfer)',
                                  'serial': '2B0181',
                                  'serial_number': '2B0181',
                                  'system_mac_address': None},
                '2B0182': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '78 Mill St. E. Milverton (MARTIN CHADRICK)',
                                  'serial': '2B0182',
                                  'serial_number': '2B0182',
                                  'system_mac_address': None},
                '2B0186': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '32 Mill St. E. Milverton (Brendan Barrett)',
                                  'serial': '2B0186',
                                  'serial_number': '2B0186',
                                  'system_mac_address': None},
                '2B018A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '28 Pacific Ave. Milverton (Jacob Harman)',
                                  'serial': '2B018A',
                                  'serial_number': '2B018A',
                                  'system_mac_address': None},
                '2B018D': {       'dev_macs': ['b8:94:70:9d:d9:8a'],
                                  'ip_address': None,
                                  'name': '74 MAIN ST N (MCCORMICK PHIL & CAROL)',
                                  'serial': '2B018D',
                                  'serial_number': '2B018D',
                                  'system_mac_address': None},
                '2B018F': {       'dev_macs': ['d0:76:8f:91:d4:9b'],
                                  'ip_address': None,
                                  'name': '55 MAIN ST N (MACDONALD ALANNA)',
                                  'serial': '2B018F',
                                  'serial_number': '2B018F',
                                  'system_mac_address': None},
                '2B0194': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '68 MAIN ST N (YOST RACHEL)',
                                  'serial': '2B0194',
                                  'serial_number': '2B0194',
                                  'system_mac_address': None},
                '2B0195': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '67 Main St. N. (Michele Duskocy 10400255)',
                                  'serial': '2B0195',
                                  'serial_number': '2B0195',
                                  'system_mac_address': None},
                '2B019B': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': "66 Main St. N. Milverton (Burn's "
                                          'Presbyterian Church)',
                                  'serial': '2B019B',
                                  'serial_number': '2B019B',
                                  'system_mac_address': None},
                '2B019C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '81 Main St. N. Milverton (Carrie Wagler)',
                                  'serial': '2B019C',
                                  'serial_number': '2B019C',
                                  'system_mac_address': None},
                '2B019E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '146 Brock St Monkton (Kelly '
                                          'Battams-Trussler 10430830)',
                                  'serial': '2B019E',
                                  'serial_number': '2B019E',
                                  'system_mac_address': None},
                '2B01B6': {       'dev_macs': ['5c:0f:fb:2a:0b:3a'],
                                  'ip_address': None,
                                  'name': '4 Spencer St. Milverton (Neil Schlueter)',
                                  'serial': '2B01B6',
                                  'serial_number': '2B01B6',
                                  'system_mac_address': None},
                '2B01B7': {       'dev_macs': ['84:d3:43:6d:e5:f4'],
                                  'ip_address': None,
                                  'name': '37 Temperance St. Milverton (Chuck Meyers '
                                          '10401071)',
                                  'serial': '2B01B7',
                                  'serial_number': '2B01B7',
                                  'system_mac_address': None},
                '2B01C6': {       'dev_macs': ['cc:be:59:7e:b7:df'],
                                  'ip_address': None,
                                  'name': '55 William St.Apt # 101 (Catharine Birch)',
                                  'serial': '2B01C6',
                                  'serial_number': '2B01C6',
                                  'system_mac_address': None},
                '2B01C8': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '53 MAIN ST N (HESSON CHRISTIAN FELLOWSHIP)',
                                  'serial': '2B01C8',
                                  'serial_number': '2B01C8',
                                  'system_mac_address': None},
                '2B01DE': {       'dev_macs': ['ec:4f:82:a5:04:42'],
                                  'ip_address': None,
                                  'name': '46 Main St. N. Milverton (John Kilmer)',
                                  'serial': '2B01DE',
                                  'serial_number': '2B01DE',
                                  'system_mac_address': None},
                '2B0206': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6432 Perth Rd 131 (Morris Gerber Excavating '
                                          '10401316)',
                                  'serial': '2B0206',
                                  'serial_number': '2B0206',
                                  'system_mac_address': None},
                '2B025D': {       'dev_macs': ['60:db:98:09:1c:3b'],
                                  'ip_address': None,
                                  'name': '6458 PERTH ROAD 131 (WAGLER  EZRA)',
                                  'serial': '2B025D',
                                  'serial_number': '2B025D',
                                  'system_mac_address': None},
                '2B0264': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '60 William St. Ste. 105 (Joyce Westman '
                                          '10433383)',
                                  'serial': '2B0264',
                                  'serial_number': '2B0264',
                                  'system_mac_address': None},
                '2B0266': {       'dev_macs': ['ec:4f:82:2c:6b:78'],
                                  'ip_address': None,
                                  'name': '19 Maddison St. W. Monkton (Rachel '
                                          'Chiarello)',
                                  'serial': '2B0266',
                                  'serial_number': '2B0266',
                                  'system_mac_address': None},
                '2B026A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '8 George St. Milverton (Stanley Kuepfer '
                                          '10400973)',
                                  'serial': '2B026A',
                                  'serial_number': '2B026A',
                                  'system_mac_address': None},
                '2B0272': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6468 Perth Rd. 131 (Jason Lantz 10430328)',
                                  'serial': '2B0272',
                                  'serial_number': '2B0272',
                                  'system_mac_address': None},
                '2B0294': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '9 Edward St. Milverton (Ezra Streicher)',
                                  'serial': '2B0294',
                                  'serial_number': '2B0294',
                                  'system_mac_address': None},
                '2B0298': {       'dev_macs': ['d0:76:8f:1f:51:dc'],
                                  'ip_address': None,
                                  'name': '169 SMITH ST (DOLSON ANDREA)',
                                  'serial': '2B0298',
                                  'serial_number': '2B0298',
                                  'system_mac_address': None},
                '2B0368': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '33 Temperance St. Milverton (Sarah&Mary '
                                          'Martin 10402460)',
                                  'serial': '2B0368',
                                  'serial_number': '2B0368',
                                  'system_mac_address': None},
                '2B03FA': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '39 Main St. S. Milverton (United Church '
                                          '10401217)',
                                  'serial': '2B03FA',
                                  'serial_number': '2B03FA',
                                  'system_mac_address': None},
                '2B0405': {       'dev_macs': ['ec:4f:82:a5:06:0d'],
                                  'ip_address': None,
                                  'name': '10 Llana Heights Milverton (Dirk Willemsen '
                                          '10401603)',
                                  'serial': '2B0405',
                                  'serial_number': '2B0405',
                                  'system_mac_address': None},
                '2B0421': {       'dev_macs': ['cc:be:59:7e:b7:fa'],
                                  'ip_address': None,
                                  'name': '19 Mill St. W. Milverton (Llori Nicholls)',
                                  'serial': '2B0421',
                                  'serial_number': '2B0421',
                                  'system_mac_address': None},
                '2B043C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '38 Main St. N. Milverton (Chris Donnelly)',
                                  'serial': '2B043C',
                                  'serial_number': '2B043C',
                                  'system_mac_address': None},
                '2B043F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '8 Grosch St. Milverton (Angela Schneider)',
                                  'serial': '2B043F',
                                  'serial_number': '2B043F',
                                  'system_mac_address': None},
                '2B0444': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '42 MAIN ST S (2495008 ONTARIO LTD.)',
                                  'serial': '2B0444',
                                  'serial_number': '2B0444',
                                  'system_mac_address': None},
                '2B044C': {       'dev_macs': ['ec:4f:82:a9:a6:41'],
                                  'ip_address': None,
                                  'name': '31 Temperance St. Milverton (Peter Ryter '
                                          '10425942)',
                                  'serial': '2B044C',
                                  'serial_number': '2B044C',
                                  'system_mac_address': None},
                '2B0450': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '7 EDWARD ST (HERD CATHY)',
                                  'serial': '2B0450',
                                  'serial_number': '2B0450',
                                  'system_mac_address': None},
                '2B0453': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '40 Main St. N. Milverton (Eric Sider)',
                                  'serial': '2B0453',
                                  'serial_number': '2B0453',
                                  'system_mac_address': None},
                '2B0454': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '7 Pugh St. W. Milverton (Don Hollinger)',
                                  'serial': '2B0454',
                                  'serial_number': '2B0454',
                                  'system_mac_address': None},
                '2B0462': {       'dev_macs': ['ec:4f:82:a9:a0:e9'],
                                  'ip_address': None,
                                  'name': '14 Pugh St. W. Milverton (Ken Zehr '
                                          '10429938)',
                                  'serial': '2B0462',
                                  'serial_number': '2B0462',
                                  'system_mac_address': None},
                '2B0471': {       'dev_macs': ['14:21:03:92:f0:2d'],
                                  'ip_address': None,
                                  'name': '31 PACIFIC AV (MCKAY ROBERT)',
                                  'serial': '2B0471',
                                  'serial_number': '2B0471',
                                  'system_mac_address': None},
                '2B05BE': {       'dev_macs': ['ec:4f:82:ac:e3:85'],
                                  'ip_address': None,
                                  'name': '68 GERBER DR',
                                  'serial': '2B05BE',
                                  'serial_number': '2B05BE',
                                  'system_mac_address': None},
                '2B05D7': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '29 PACIFIC AV (JUGDAVE VISHAAL)',
                                  'serial': '2B05D7',
                                  'serial_number': '2B05D7',
                                  'system_mac_address': None},
                '2BD241': {       'dev_macs': ['34:0a:33:81:59:d5'],
                                  'ip_address': None,
                                  'name': '9 Pugh St. W. Milverton (Ashley Mayberry)',
                                  'serial': '2BD241',
                                  'serial_number': '2BD241',
                                  'system_mac_address': None},
                '2BD264': {       'dev_macs': ['e4:6f:13:40:a4:f3'],
                                  'ip_address': None,
                                  'name': '82 Main St N (William & Krista Kuepfer)',
                                  'serial': '2BD264',
                                  'serial_number': '2BD264',
                                  'system_mac_address': None},
                '2BD26F': {       'dev_macs': ['ec:4f:82:2a:b0:41'],
                                  'ip_address': None,
                                  'name': '49 Temperance St Milverton (D&J Luyten '
                                          '10433326)',
                                  'serial': '2BD26F',
                                  'serial_number': '2BD26F',
                                  'system_mac_address': None},
                '2BD360': {       'dev_macs': ['84:d8:1b:e1:8f:89'],
                                  'ip_address': None,
                                  'name': '23 West St. Milverton (Tyson Londry '
                                          '10431157)',
                                  'serial': '2BD360',
                                  'serial_number': '2BD360',
                                  'system_mac_address': None},
                '2BD474': {       'dev_macs': ['78:32:1b:49:bf:78'],
                                  'ip_address': None,
                                  'name': '29 MADDISON ST W (DOCKING MELANIE)',
                                  'serial': '2BD474',
                                  'serial_number': '2BD474',
                                  'system_mac_address': None},
                '2BD478': {       'dev_macs': ['44:65:7f:89:0f:ed'],
                                  'ip_address': None,
                                  'name': '80 SCHADE ST (GOODMAN-SMITH ERIN)',
                                  'serial': '2BD478',
                                  'serial_number': '2BD478',
                                  'system_mac_address': None},
                '2BD5CA': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '171 Winstanley St. Monkton',
                                  'serial': '2BD5CA',
                                  'serial_number': '2BD5CA',
                                  'system_mac_address': None},
                '2BD66F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '12 Main St. S. Milverton (Execulink Credit '
                                          'union)',
                                  'serial': '2BD66F',
                                  'serial_number': '2BD66F',
                                  'system_mac_address': None},
                '2BD68D': {       'dev_macs': ['68:4a:76:d7:a4:20'],
                                  'ip_address': None,
                                  'name': '32 Pacific Ave. Milverton (Rachel Brennan)',
                                  'serial': '2BD68D',
                                  'serial_number': '2BD68D',
                                  'system_mac_address': None},
                '2BD693': {       'dev_macs': ['cc:be:59:2d:a5:da'],
                                  'ip_address': None,
                                  'name': '19 Pacific Av. Milverton (Wade Goodwin '
                                          '10426524)',
                                  'serial': '2BD693',
                                  'serial_number': '2BD693',
                                  'system_mac_address': None},
                '2BD696': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '8 Pacific Av. Milverton',
                                  'serial': '2BD696',
                                  'serial_number': '2BD696',
                                  'system_mac_address': None},
                '2BD69F': {       'dev_macs': ['cc:be:59:7e:b6:f5'],
                                  'ip_address': None,
                                  'name': '7 West St. Milverton (Ian Clark 10434646)',
                                  'serial': '2BD69F',
                                  'serial_number': '2BD69F',
                                  'system_mac_address': None},
                '2C9656': {       'dev_macs': ['ec:4f:82:2d:7a:35'],
                                  'ip_address': None,
                                  'name': '6611 Perth Rd. 131 Milverton (The '
                                          'Garage&R&J Wagler)',
                                  'serial': '2C9656',
                                  'serial_number': '2C9656',
                                  'system_mac_address': None},
                '2DCD18': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 WILLIAM ST (FELIX JAMES)',
                                  'serial': '2DCD18',
                                  'serial_number': '2DCD18',
                                  'system_mac_address': None},
                '2E91A8': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '187 Erskine St. Monkton (Robert Doell '
                                          '10432296)',
                                  'serial': '2E91A8',
                                  'serial_number': '2E91A8',
                                  'system_mac_address': None},
                '2ED67B': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6374 ROAD 154 (VAN NULAND MARIA)',
                                  'serial': '2ED67B',
                                  'serial_number': '2ED67B',
                                  'system_mac_address': None},
                '2ED92E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '47 Maddison St. E. Monkton (Mane Attraction '
                                          '10431045)',
                                  'serial': '2ED92E',
                                  'serial_number': '2ED92E',
                                  'system_mac_address': None},
                '2ED9C4': {       'dev_macs': ['b8:94:70:f3:e6:66'],
                                  'ip_address': None,
                                  'name': '32 WILLIAM ST (LEHMANN DON & SHARON)',
                                  'serial': '2ED9C4',
                                  'serial_number': '2ED9C4',
                                  'system_mac_address': None},
                '2ED9CD': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '147 Brock St. Monkton (Kevin Coulson)',
                                  'serial': '2ED9CD',
                                  'serial_number': '2ED9CD',
                                  'system_mac_address': None},
                '2F3B17': {       'dev_macs': ['c8:4f:86:fc:00:02'],
                                  'ip_address': None,
                                  'name': '7003 Raymond St (MIllbank Hardware)',
                                  'serial': '2F3B17',
                                  'serial_number': '2F3B17',
                                  'system_mac_address': None},
                '2FE9B2': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '149 BROCK STREET MONKTON (BROUGHTON JOANNE)',
                                  'serial': '2FE9B2',
                                  'serial_number': '2FE9B2',
                                  'system_mac_address': None},
                '2FE9C9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '37 Maddison St. W. Monkton (Amanda Pfeifer)',
                                  'serial': '2FE9C9',
                                  'serial_number': '2FE9C9',
                                  'system_mac_address': None},
                '2FE9E5': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '175 Winstanley St. Monkton (Vince '
                                          'Priestrap)',
                                  'serial': '2FE9E5',
                                  'serial_number': '2FE9E5',
                                  'system_mac_address': None},
                '2FEA05': {       'dev_macs': ['c0:06:c3:1c:9b:46'],
                                  'ip_address': None,
                                  'name': '16 SCHADE ST (MAYER MICHAEL)',
                                  'serial': '2FEA05',
                                  'serial_number': '2FEA05',
                                  'system_mac_address': None},
                '2FEA0D': {       'dev_macs': ['b8:94:70:bc:b4:4f'],
                                  'ip_address': None,
                                  'name': '163 BROCK STREET MONKTON (GREGORY DAWN)',
                                  'serial': '2FEA0D',
                                  'serial_number': '2FEA0D',
                                  'system_mac_address': None},
                '2FEA1D': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5020 LINE 49 (ROCDALE FARMS)',
                                  'serial': '2FEA1D',
                                  'serial_number': '2FEA1D',
                                  'system_mac_address': None},
                '2FEAF3': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6879A ROAD 140 (KUEPFER MARVIN & SARAH)',
                                  'serial': '2FEAF3',
                                  'serial_number': '2FEAF3',
                                  'system_mac_address': None},
                '2FEAFA': {       'dev_macs': ['14:21:03:92:e9:a5'],
                                  'ip_address': None,
                                  'name': '3 GROSCH ST MILVERTON (NAHRGANG GEORGE)',
                                  'serial': '2FEAFA',
                                  'serial_number': '2FEAFA',
                                  'system_mac_address': None},
                '2FEB5D': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '25 Maddison St. W. Monkton (Dean Smith)',
                                  'serial': '2FEB5D',
                                  'serial_number': '2FEB5D',
                                  'system_mac_address': None},
                '2FEB62': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '138 Maddison St. E. Monkton',
                                  'serial': '2FEB62',
                                  'serial_number': '2FEB62',
                                  'system_mac_address': None},
                '2FEC08': {       'dev_macs': ['14:21:03:92:f6:31'],
                                  'ip_address': None,
                                  'name': '103 Maddison St. W. Monkton (Charlene '
                                          'Hamilton 10430268)',
                                  'serial': '2FEC08',
                                  'serial_number': '2FEC08',
                                  'system_mac_address': None},
                '30039F': {       'dev_macs': ['14:21:03:a1:e6:7e'],
                                  'ip_address': None,
                                  'name': '55 WILLIAM ST (BRUCK SAMANTHA)',
                                  'serial': '30039F',
                                  'serial_number': '30039F',
                                  'system_mac_address': None},
                '30060A': {       'dev_macs': ['b4:75:0e:54:f6:19'],
                                  'ip_address': None,
                                  'name': '17 William St. Milverton (Barry Brick)',
                                  'serial': '30060A',
                                  'serial_number': '30060A',
                                  'system_mac_address': None},
                '300623': {       'dev_macs': ['84:d3:43:0f:bb:12'],
                                  'ip_address': None,
                                  'name': '36 PACIFIC AV (HORTON CHAD)',
                                  'serial': '300623',
                                  'serial_number': '300623',
                                  'system_mac_address': None},
                '30064C': {       'dev_macs': ['b8:94:70:f3:e6:24'],
                                  'ip_address': None,
                                  'name': '157 Smith St. Monkton (Judith Burwell)',
                                  'serial': '30064C',
                                  'serial_number': '30064C',
                                  'system_mac_address': None},
                '30079D': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 William St apt 207 Milverton',
                                  'serial': '30079D',
                                  'serial_number': '30079D',
                                  'system_mac_address': None},
                '3007AE': {       'dev_macs': ['cc:32:e5:11:31:61'],
                                  'ip_address': None,
                                  'name': '38 Maddison St. E. Monkton (Bjorn Makinen)',
                                  'serial': '3007AE',
                                  'serial_number': '3007AE',
                                  'system_mac_address': None},
                '3007AF': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5907 Perth Road 119 Brunner',
                                  'serial': '3007AF',
                                  'serial_number': '3007AF',
                                  'system_mac_address': None},
                '3007C5': {       'dev_macs': ['c4:e9:0a:56:56:57'],
                                  'ip_address': None,
                                  'name': '26 Mill St. E. Milverton (Tony Douglas)',
                                  'serial': '3007C5',
                                  'serial_number': '3007C5',
                                  'system_mac_address': None},
                '300D95': {       'dev_macs': ['60:63:4c:6d:fe:81'],
                                  'ip_address': None,
                                  'name': '5792 LINE 57 (VAN NULAND MARIA (MELANIE))',
                                  'serial': '300D95',
                                  'serial_number': '300D95',
                                  'system_mac_address': None},
                '300D9C': {       'dev_macs': ['44:65:7f:41:c5:2f'],
                                  'ip_address': None,
                                  'name': '87 Gerber Dr (CUNHA CARLOS)',
                                  'serial': '300D9C',
                                  'serial_number': '300D9C',
                                  'system_mac_address': None},
                '300DCB': {       'dev_macs': ['30:68:93:36:15:5d'],
                                  'ip_address': None,
                                  'name': '76 MAIN ST N (NAFZIGER COLE)',
                                  'serial': '300DCB',
                                  'serial_number': '300DCB',
                                  'system_mac_address': None},
                '300DDF': {       'dev_macs': ['60:db:98:08:d2:ed'],
                                  'ip_address': None,
                                  'name': '5 Whaley Ave. Milverton (DENOMME ZACH '
                                          '10438436)',
                                  'serial': '300DDF',
                                  'serial_number': '300DDF',
                                  'system_mac_address': None},
                '300DF1': {       'dev_macs': ['24:2f:d0:36:09:f1'],
                                  'ip_address': None,
                                  'name': '1 Whaley Ave. Milverton (Nick Beggs)',
                                  'serial': '300DF1',
                                  'serial_number': '300DF1',
                                  'system_mac_address': None},
                '300DFD': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '9 St. Marys St. N. Milverton (Alex Campbell '
                                          '10435536)',
                                  'serial': '300DFD',
                                  'serial_number': '300DFD',
                                  'system_mac_address': None},
                '300E72': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': 'test',
                                  'serial': '300E72',
                                  'serial_number': '300E72',
                                  'system_mac_address': None},
                '300E75': {       'dev_macs': ['24:f5:a2:09:16:62'],
                                  'ip_address': None,
                                  'name': '25 MAIN ST S (HALL MICHAEL)',
                                  'serial': '300E75',
                                  'serial_number': '300E75',
                                  'system_mac_address': None},
                '300E88': {       'dev_macs': ['1c:7e:e5:37:f4:9d'],
                                  'ip_address': None,
                                  'name': '7 Llana Heights Main Fl (Robyn Yost)',
                                  'serial': '300E88',
                                  'serial_number': '300E88',
                                  'system_mac_address': None},
                '300EF8': {       'dev_macs': ['ec:4f:82:ac:d0:53'],
                                  'ip_address': None,
                                  'name': '44 Main St S Milverton (JL Hallahan Ltd '
                                          '10435438)',
                                  'serial': '300EF8',
                                  'serial_number': '300EF8',
                                  'system_mac_address': None},
                '300F00': {       'dev_macs': ['d0:76:8f:02:ed:97'],
                                  'ip_address': None,
                                  'name': '60 MAIN ST N (NEWMAN ASHLYNNE)',
                                  'serial': '300F00',
                                  'serial_number': '300F00',
                                  'system_mac_address': None},
                '3210DE': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '76 GERBER DR',
                                  'serial': '3210DE',
                                  'serial_number': '3210DE',
                                  'system_mac_address': None},
                '3210E4': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '21 Arena Dr. Milverton (Denise Smith)',
                                  'serial': '3210E4',
                                  'serial_number': '3210E4',
                                  'system_mac_address': None},
                '3212EF': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '80 Mill St. E. Milverton (Lynda Kuepfer)',
                                  'serial': '3212EF',
                                  'serial_number': '3212EF',
                                  'system_mac_address': None},
                '32143A': {       'dev_macs': ['84:d3:43:6d:e6:fc'],
                                  'ip_address': None,
                                  'name': '80 Gerber Drive Milverton (Randal Leis '
                                          '10434200)',
                                  'serial': '32143A',
                                  'serial_number': '32143A',
                                  'system_mac_address': None},
                '32171B': {       'dev_macs': ['60:db:98:09:1d:e8'],
                                  'ip_address': None,
                                  'name': '5 PACIFIC AV (MILOVANCEV CHLOE AND NATHAN)',
                                  'serial': '32171B',
                                  'serial_number': '32171B',
                                  'system_mac_address': None},
                '321720': {       'dev_macs': ['b8:94:70:bc:b8:4e'],
                                  'ip_address': None,
                                  'name': '5842 Perth Road 119 Brunner (Don & Eva '
                                          'Anderson 10430386)',
                                  'serial': '321720',
                                  'serial_number': '321720',
                                  'system_mac_address': None},
                '321779': {       'dev_macs': ['cc:be:59:2f:2f:eb'],
                                  'ip_address': None,
                                  'name': '160 Smith St Monkton (Carl Steicher '
                                          '10434033)',
                                  'serial': '321779',
                                  'serial_number': '321779',
                                  'system_mac_address': None},
                '32177F': {       'dev_macs': ['14:21:03:92:ec:d3'],
                                  'ip_address': None,
                                  'name': '21 MILL ST W (SHANNON KEELIE)',
                                  'serial': '32177F',
                                  'serial_number': '32177F',
                                  'system_mac_address': None},
                '32178E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5752 Perth Rd. 119 (Micheal Weber 10400697)',
                                  'serial': '32178E',
                                  'serial_number': '32178E',
                                  'system_mac_address': None},
                '3217CC': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '68 Schade St Monkton (Ross Rennick '
                                          '10434031)',
                                  'serial': '3217CC',
                                  'serial_number': '3217CC',
                                  'system_mac_address': None},
                '3217E6': {       'dev_macs': ['cc:be:59:2d:a8:e9'],
                                  'ip_address': None,
                                  'name': '4345 LINE 61 (ROPP DAVID & BONNIE)',
                                  'serial': '3217E6',
                                  'serial_number': '3217E6',
                                  'system_mac_address': None},
                '321808': {       'dev_macs': ['14:21:03:8b:7a:a8'],
                                  'ip_address': None,
                                  'name': '24 Arena Dr Milverton (Shirley Weber '
                                          '10401054)',
                                  'serial': '321808',
                                  'serial_number': '321808',
                                  'system_mac_address': None},
                '321825': {       'dev_macs': [       '00:03:e6:a5:70:de',
                                                      '00:03:e6:a5:73:90'],
                                  'ip_address': None,
                                  'name': '93 Schade St Monkton (Steve Smith 10434116)',
                                  'serial': '321825',
                                  'serial_number': '321825',
                                  'system_mac_address': None},
                '321856': {       'dev_macs': ['cc:be:59:32:94:a1'],
                                  'ip_address': None,
                                  'name': '41 MILL ST W (GROPP KEN JR & INGRID)',
                                  'serial': '321856',
                                  'serial_number': '321856',
                                  'system_mac_address': None},
                '321889': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '29A William St. (Fred Manser)',
                                  'serial': '321889',
                                  'serial_number': '321889',
                                  'system_mac_address': None},
                '3218A5': {       'dev_macs': ['d0:76:8f:02:ee:26'],
                                  'ip_address': None,
                                  'name': '91 GERBER DR (DE KLEER SARAH)',
                                  'serial': '3218A5',
                                  'serial_number': '3218A5',
                                  'system_mac_address': None},
                '3218E5': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '54 MAIN ST N (GRANT ERIKA)',
                                  'serial': '3218E5',
                                  'serial_number': '3218E5',
                                  'system_mac_address': None},
                '32194B': {       'dev_macs': ['d0:76:8f:1f:69:89'],
                                  'ip_address': None,
                                  'name': '11 Schade St Monkton (STAHLKE KRISTEN)',
                                  'serial': '32194B',
                                  'serial_number': '32194B',
                                  'system_mac_address': None},
                '3219BA': {       'dev_macs': ['cc:be:59:2d:a8:50'],
                                  'ip_address': None,
                                  'name': '90 GERBER DR (LIVINGSTONE MATTHEW)',
                                  'serial': '3219BA',
                                  'serial_number': '3219BA',
                                  'system_mac_address': None},
                '3223CB': {       'dev_macs': ['cc:be:59:7e:b8:4b'],
                                  'ip_address': None,
                                  'name': '14 PIERSON ST (KUEPFER JEFF & SANDRA)',
                                  'serial': '3223CB',
                                  'serial_number': '3223CB',
                                  'system_mac_address': None},
                '322403': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '37 Main St. S. Milverton (Vicki Baier)',
                                  'serial': '322403',
                                  'serial_number': '322403',
                                  'system_mac_address': None},
                '322421': {       'dev_macs': ['e4:6c:d1:4e:ea:20'],
                                  'ip_address': None,
                                  'name': '6717 Rd 140 Milverton (Beat Looser '
                                          '10400601)',
                                  'serial': '322421',
                                  'serial_number': '322421',
                                  'system_mac_address': None},
                '322602': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '51 WILLIAM ST (ENNS JACOB)',
                                  'serial': '322602',
                                  'serial_number': '322602',
                                  'system_mac_address': None},
                '32273F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6680B Road 140 Milverton (Melanie Elg '
                                          '10427044)',
                                  'serial': '32273F',
                                  'serial_number': '32273F',
                                  'system_mac_address': None},
                '3227F1': {       'dev_macs': ['d0:76:8f:02:ef:86'],
                                  'ip_address': None,
                                  'name': '135 Brock St (MORRISON W & V)',
                                  'serial': '3227F1',
                                  'serial_number': '3227F1',
                                  'system_mac_address': None},
                '32281D': {       'dev_macs': ['d0:76:8f:1f:56:f9'],
                                  'ip_address': None,
                                  'name': '58 MAIN ST N (SYDNEY ROCKLAND)',
                                  'serial': '32281D',
                                  'serial_number': '32281D',
                                  'system_mac_address': None},
                '32281E': {       'dev_macs': ['d0:76:8f:1f:5f:c8'],
                                  'ip_address': None,
                                  'name': '86 GERBER DR (NAFZIGER MIKE)',
                                  'serial': '32281E',
                                  'serial_number': '32281E',
                                  'system_mac_address': None},
                '322825': {       'dev_macs': ['04:bc:9f:46:8a:7c'],
                                  'ip_address': None,
                                  'name': '93 GERBER DR (WITT BROOKLYNN)',
                                  'serial': '322825',
                                  'serial_number': '322825',
                                  'system_mac_address': None},
                '322841': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4952 Line 67 Milverton (Ivo Looser '
                                          '10400216)',
                                  'serial': '322841',
                                  'serial_number': '322841',
                                  'system_mac_address': None},
                '322849': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4994 LINE 67 (MCDONALD RICHARD)',
                                  'serial': '322849',
                                  'serial_number': '322849',
                                  'system_mac_address': None},
                '32284F': {       'dev_macs': ['84:d3:43:6d:ed:00'],
                                  'ip_address': None,
                                  'name': '12 Pacific Ave Milverton (Matthew Bancroft '
                                          '10436288)',
                                  'serial': '32284F',
                                  'serial_number': '32284F',
                                  'system_mac_address': None},
                '32288C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5903 Perth Rd 119 Brunner (Marie Lindner '
                                          '10431377)',
                                  'serial': '32288C',
                                  'serial_number': '32288C',
                                  'system_mac_address': None},
                '3228CE': {       'dev_macs': ['cc:be:59:32:95:55'],
                                  'ip_address': None,
                                  'name': '5678 Perth Rd 119 Brunner (Orval Zehr '
                                          '10400708)',
                                  'serial': '3228CE',
                                  'serial_number': '3228CE',
                                  'system_mac_address': None},
                '3229F2': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6680A Road 140 Milverton (Bruce Elg '
                                          '10401527)',
                                  'serial': '3229F2',
                                  'serial_number': '3229F2',
                                  'system_mac_address': None},
                '322A47': {       'dev_macs': ['b8:94:70:f3:e7:bb'],
                                  'ip_address': None,
                                  'name': '4344 LINE 61 (JANTZI JARRELL)',
                                  'serial': '322A47',
                                  'serial_number': '322A47',
                                  'system_mac_address': None},
                '329635': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '150 Winstanley St. Monkton (Andre Shtovba '
                                          '10431113)',
                                  'serial': '329635',
                                  'serial_number': '329635',
                                  'system_mac_address': None},
                '329655': {       'dev_macs': ['b8:94:70:9e:cc:d8'],
                                  'ip_address': None,
                                  'name': '48 MADDISON ST E (VILLEMAIRE JACQUELINE)',
                                  'serial': '329655',
                                  'serial_number': '329655',
                                  'system_mac_address': None},
                '329667': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '211 Yonge St., Monkton (Terry & Leslie '
                                          'Brown)',
                                  'serial': '329667',
                                  'serial_number': '329667',
                                  'system_mac_address': None},
                '329678': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '92 MADDISON ST E (HOWES BEN 10430142)',
                                  'serial': '329678',
                                  'serial_number': '329678',
                                  'system_mac_address': None},
                '32967D': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '34 MADDISON ST E MONKTON (FELLOWSHIP HAVEN '
                                          'MENNO)',
                                  'serial': '32967D',
                                  'serial_number': '32967D',
                                  'system_mac_address': None},
                '3303B1': {       'dev_macs': ['04:bc:9f:46:92:d2'],
                                  'ip_address': None,
                                  'name': '31 MADDISON ST E (DOHERTY KERRI)',
                                  'serial': '3303B1',
                                  'serial_number': '3303B1',
                                  'system_mac_address': None},
                '3480DD': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 WILLIAM ST APT 1',
                                  'serial': '3480DD',
                                  'serial_number': '3480DD',
                                  'system_mac_address': None},
                '349E51': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 Main St S Ste 17 Milverton (Katherine '
                                          'Priestap 10434089)',
                                  'serial': '349E51',
                                  'serial_number': '349E51',
                                  'system_mac_address': None},
                '349E7D': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '11 WEST ST (STEVENS NCHOLAS)',
                                  'serial': '349E7D',
                                  'serial_number': '349E7D',
                                  'system_mac_address': None},
                '349E85': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '27 Main St S Milverton (Richard Smallbone '
                                          '10433849)',
                                  'serial': '349E85',
                                  'serial_number': '349E85',
                                  'system_mac_address': None},
                '349E87': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 MAIN ST S STE 10 (GROPP BARRY)',
                                  'serial': '349E87',
                                  'serial_number': '349E87',
                                  'system_mac_address': None},
                '349E8A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '111 Mill St E (Adam Harloff)',
                                  'serial': '349E8A',
                                  'serial_number': '349E8A',
                                  'system_mac_address': None},
                '35E8E5': {       'dev_macs': ['84:d3:43:6d:fa:10'],
                                  'ip_address': None,
                                  'name': '5 Main St N Milverton (V & M Lemieux '
                                          '10400112)',
                                  'serial': '35E8E5',
                                  'serial_number': '35E8E5',
                                  'system_mac_address': None},
                '35E8FB': {       'dev_macs': ['a4:2b:8c:7c:8c:8d'],
                                  'ip_address': None,
                                  'name': '170 Winstanley St Monkton (STECKLY JEREMY)',
                                  'serial': '35E8FB',
                                  'serial_number': '35E8FB',
                                  'system_mac_address': None},
                '35E913': {       'dev_macs': ['cc:be:59:7e:b7:85'],
                                  'ip_address': None,
                                  'name': '5818 LINE 55 (ROPP KRISTI)',
                                  'serial': '35E913',
                                  'serial_number': '35E913',
                                  'system_mac_address': None},
                '35E936': {       'dev_macs': ['44:65:7f:89:0b:6d'],
                                  'ip_address': None,
                                  'name': '85 Schade St Monkton (Jesse Hamilton '
                                          '10434996)',
                                  'serial': '35E936',
                                  'serial_number': '35E936',
                                  'system_mac_address': None},
                '35E938': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '22 Whaley Av. Milverton (Roy Wolfe)',
                                  'serial': '35E938',
                                  'serial_number': '35E938',
                                  'system_mac_address': None},
                '35E94D': {       'dev_macs': ['84:d3:43:6d:eb:ab'],
                                  'ip_address': None,
                                  'name': '4316 Line 61 Milverton (E & P Hill '
                                          '10405285)',
                                  'serial': '35E94D',
                                  'serial_number': '35E94D',
                                  'system_mac_address': None},
                '35E94F': {       'dev_macs': ['14:21:03:a9:70:3c'],
                                  'ip_address': None,
                                  'name': '53 MILL ST W (PAULI ROGER)',
                                  'serial': '35E94F',
                                  'serial_number': '35E94F',
                                  'system_mac_address': None},
                '35E95B': {       'dev_macs': ['18:31:bf:e5:79:00'],
                                  'ip_address': None,
                                  'name': '5845 Perth Rd 119 (Matthew & Sheila Ropp '
                                          '10420100)',
                                  'serial': '35E95B',
                                  'serial_number': '35E95B',
                                  'system_mac_address': None},
                '35E95C': {       'dev_macs': ['d8:47:32:21:9a:59'],
                                  'ip_address': None,
                                  'name': 'Arnold Yantzi 10400583 (5734 Perth Rd 119)',
                                  'serial': '35E95C',
                                  'serial_number': '35E95C',
                                  'system_mac_address': None},
                '35E960': {       'dev_macs': ['3c:fa:30:a0:18:10'],
                                  'ip_address': None,
                                  'name': '50 William St. Milverton (Knollcrest Main '
                                          'Internet&Elevator phone)',
                                  'serial': '35E960',
                                  'serial_number': '35E960',
                                  'system_mac_address': None},
                '35E968': {       'dev_macs': ['90:98:38:54:67:72'],
                                  'ip_address': None,
                                  'name': '36 MILL ST E (NAFZIGER BRETT 10438396)',
                                  'serial': '35E968',
                                  'serial_number': '35E968',
                                  'system_mac_address': None},
                '35E96A': {       'dev_macs': ['98:25:4a:de:d1:91'],
                                  'ip_address': None,
                                  'name': '5 John St (Becky Hastings & Trevor Lines)',
                                  'serial': '35E96A',
                                  'serial_number': '35E96A',
                                  'system_mac_address': None},
                '35E96C': {       'dev_macs': ['ec:4f:82:2d:34:75'],
                                  'ip_address': None,
                                  'name': '24 temperance St. Milverton (Royal Can. '
                                          'Legion)',
                                  'serial': '35E96C',
                                  'serial_number': '35E96C',
                                  'system_mac_address': None},
                '35E972': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '1 Main St. N. Milverton (Mane Appeal '
                                          '(Phone))',
                                  'serial': '35E972',
                                  'serial_number': '35E972',
                                  'system_mac_address': None},
                '35E9C3': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': 'ont 6',
                                  'serial': '35E9C3',
                                  'serial_number': '35E9C3',
                                  'system_mac_address': None},
                '35E9CD': {       'dev_macs': ['ec:4f:82:ac:db:db'],
                                  'ip_address': None,
                                  'name': '100 Maddison S W Monkton (Gillian Ward)',
                                  'serial': '35E9CD',
                                  'serial_number': '35E9CD',
                                  'system_mac_address': None},
                '35EA08': {       'dev_macs': ['e8:9f:80:73:c0:9b'],
                                  'ip_address': None,
                                  'name': '5673 Perth Road 119 (Donald & Nelda Erb)',
                                  'serial': '35EA08',
                                  'serial_number': '35EA08',
                                  'system_mac_address': None},
                '35EA28': {       'dev_macs': ['14:dd:a9:92:18:70'],
                                  'ip_address': None,
                                  'name': '5894 Perth Road 119 (Robt & Esther Bitzer '
                                          '10400237)',
                                  'serial': '35EA28',
                                  'serial_number': '35EA28',
                                  'system_mac_address': None},
                '35EA2C': {       'dev_macs': ['e4:6c:d1:4e:f2:ef'],
                                  'ip_address': None,
                                  'name': '5720 PERTH ROAD 119 (BROADHURST EVAN)',
                                  'serial': '35EA2C',
                                  'serial_number': '35EA2C',
                                  'system_mac_address': None},
                '35EA2D': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': 'INVENTORY ROOM (IPTV RESET)',
                                  'serial': '35EA2D',
                                  'serial_number': '35EA2D',
                                  'system_mac_address': None},
                '35EA44': {       'dev_macs': ['ec:4f:82:a5:03:8e'],
                                  'ip_address': None,
                                  'name': '21 Whaley Av. Milverton (Murray Schneider)',
                                  'serial': '35EA44',
                                  'serial_number': '35EA44',
                                  'system_mac_address': None},
                '35EA87': {       'dev_macs': ['e4:6f:13:67:f3:3b'],
                                  'ip_address': None,
                                  'name': '39 Main St. N. Milverton (Guenthers Bakery)',
                                  'serial': '35EA87',
                                  'serial_number': '35EA87',
                                  'system_mac_address': None},
                '35EAA5': {       'dev_macs': ['bc:ee:7b:ec:b5:38'],
                                  'ip_address': None,
                                  'name': '17 Fulton St Milverton (Edward Wiebe '
                                          '10426867)',
                                  'serial': '35EAA5',
                                  'serial_number': '35EAA5',
                                  'system_mac_address': None},
                '35EB24': {       'dev_macs': ['c8:d3:a3:59:59:e3'],
                                  'ip_address': None,
                                  'name': '7 Colbalt St. N. Milverton (Judy Hamilton '
                                          '10422751)',
                                  'serial': '35EB24',
                                  'serial_number': '35EB24',
                                  'system_mac_address': None},
                '35F842': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '7 llana Heights Upper Apt (Dereth Kipfer)',
                                  'serial': '35F842',
                                  'serial_number': '35F842',
                                  'system_mac_address': None},
                '35F843': {       'dev_macs': ['78:32:1b:52:b3:c6'],
                                  'ip_address': None,
                                  'name': '5620 Perth Rd 119 Brunner (James & Donna '
                                          'Jantzi 10423020)',
                                  'serial': '35F843',
                                  'serial_number': '35F843',
                                  'system_mac_address': None},
                '35F84C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '170 SMITH ST (JANZEN EDDIE)',
                                  'serial': '35F84C',
                                  'serial_number': '35F84C',
                                  'system_mac_address': None},
                '35F851': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '165 Smith St. Monkton',
                                  'serial': '35F851',
                                  'serial_number': '35F851',
                                  'system_mac_address': None},
                '35F953': {       'dev_macs': ['3c:7c:3f:0b:45:d8'],
                                  'ip_address': None,
                                  'name': '82 MADDISON ST E (COCHRANE  DEREK)',
                                  'serial': '35F953',
                                  'serial_number': '35F953',
                                  'system_mac_address': None},
                '35F9A5': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '41 Main St. N. Milverton (Ginnie Perry)',
                                  'serial': '35F9A5',
                                  'serial_number': '35F9A5',
                                  'system_mac_address': None},
                '35F9B0': {       'dev_macs': ['a4:2b:b0:ee:cc:2b'],
                                  'ip_address': None,
                                  'name': '50 Mill St E Milverton (Barb Chalmers '
                                          '10400152)',
                                  'serial': '35F9B0',
                                  'serial_number': '35F9B0',
                                  'system_mac_address': None},
                '35F9B1': {       'dev_macs': ['ec:4f:82:a9:a9:11'],
                                  'ip_address': None,
                                  'name': '36 William St (Evan Hargrave)',
                                  'serial': '35F9B1',
                                  'serial_number': '35F9B1',
                                  'system_mac_address': None},
                '35F9E0': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '27 Temperance St. Milverton (Chris Potwarka '
                                          '10401128)',
                                  'serial': '35F9E0',
                                  'serial_number': '35F9E0',
                                  'system_mac_address': None},
                '35F9FD': {       'dev_macs': ['84:16:f9:42:b0:f6'],
                                  'ip_address': None,
                                  'name': '5843 Perth Road 119 (Larry P Janzti '
                                          '10400600)',
                                  'serial': '35F9FD',
                                  'serial_number': '35F9FD',
                                  'system_mac_address': None},
                '362811': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '53 MADDISON ST E (KUEPFER BRYCE)',
                                  'serial': '362811',
                                  'serial_number': '362811',
                                  'system_mac_address': None},
                '366C67': {       'dev_macs': [       '00:03:e6:a8:0e:56',
                                                      '00:03:e6:a8:0e:58'],
                                  'ip_address': None,
                                  'name': '23 Schade St., Monkton (Sherry Heibein)',
                                  'serial': '366C67',
                                  'serial_number': '366C67',
                                  'system_mac_address': None},
                '36CC2F': {       'dev_macs': [       'f0:09:0d:f4:23:fe',
                                                      'e8:9f:80:13:2f:f3'],
                                  'ip_address': None,
                                  'name': "34 MAIN ST N (KAREN'S KITCHEN)",
                                  'serial': '36CC2F',
                                  'serial_number': '36CC2F',
                                  'system_mac_address': None},
                '37882C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '9 Main St. N. Milverton (Milv. '
                                          'Accounting&Oak Fin)',
                                  'serial': '37882C',
                                  'serial_number': '37882C',
                                  'system_mac_address': None},
                '378832': {       'dev_macs': ['2c:b0:5d:26:9f:9d'],
                                  'ip_address': None,
                                  'name': '6 Spencer St Milverton (Parks Livestock '
                                          '10420629)',
                                  'serial': '378832',
                                  'serial_number': '378832',
                                  'system_mac_address': None},
                '3788B6': {       'dev_macs': [       '5c:0f:fb:3d:58:38',
                                                      '14:21:03:a1:8c:bb',
                                                      '5c:0f:fb:3d:60:16'],
                                  'ip_address': None,
                                  'name': '50 WILLIAM ST',
                                  'serial': '3788B6',
                                  'serial_number': '3788B6',
                                  'system_mac_address': None},
                '3788BC': {       'dev_macs': ['e0:23:ff:2c:38:ee'],
                                  'ip_address': None,
                                  'name': '20 Main St N Milverton (Ellis HHBC '
                                          '10433408)',
                                  'serial': '3788BC',
                                  'serial_number': '3788BC',
                                  'system_mac_address': None},
                '3788D0': {       'dev_macs': [       '00:15:65:d4:bb:53',
                                                      '00:21:b7:81:63:4b',
                                                      '00:23:24:73:26:76',
                                                      '00:23:24:73:26:f4',
                                                      '00:d8:61:1d:63:0c',
                                                      '00:d8:61:44:bf:14',
                                                      '00:d8:61:45:96:e0',
                                                      '00:d8:61:b5:97:bf',
                                                      '1c:ee:c9:20:75:c7',
                                                      '1c:ee:c9:2a:5b:83',
                                                      '24:9a:d8:2b:8b:69',
                                                      '24:9a:d8:6d:ec:18',
                                                      '30:9c:23:76:22:06',
                                                      '30:9c:23:76:22:35',
                                                      '3c:e3:6b:44:d2:e7',
                                                      '3c:e3:6b:e3:96:18',
                                                      '44:37:e6:7f:79:61',
                                                      '44:db:d2:22:8b:e2',
                                                      '44:db:d2:44:b6:da',
                                                      '44:db:d2:6b:ae:fc',
                                                      '44:db:d2:6b:b0:9d',
                                                      '4c:cc:6a:1c:7c:a8',
                                                      '6c:4b:90:ed:6c:04',
                                                      '6c:4b:90:ed:6c:e9',
                                                      '80:5e:0c:44:4c:85',
                                                      '80:5e:0c:cb:31:02',
                                                      '80:5e:0c:cd:ac:4b',
                                                      '80:5e:0c:f4:ab:9c',
                                                      '80:5e:c0:14:73:d4',
                                                      '80:5e:c0:1c:fe:22',
                                                      '80:5e:c0:1c:fe:c2',
                                                      '80:5e:c0:1d:00:03',
                                                      '80:5e:c0:1d:01:9e',
                                                      '80:5e:c0:1d:03:36',
                                                      '80:5e:c0:2f:63:44',
                                                      '80:5e:c0:2f:64:18',
                                                      '80:5e:c0:2f:69:51',
                                                      'cc:d5:39:1d:4d:82',
                                                      'cc:d5:39:1d:4d:c0',
                                                      'cc:d5:39:1d:4d:c1',
                                                      'd8:cb:8a:92:e1:bc',
                                                      'f4:93:9f:f0:69:cd',
                                                      'fc:4d:d4:d4:0a:a8',
                                                      'fc:4d:d4:f4:32:bb'],
                                  'ip_address': None,
                                  'name': '50 William St.  Milverton (Knollcrest Data '
                                          'Rm 3)',
                                  'serial': '3788D0',
                                  'serial_number': '3788D0',
                                  'system_mac_address': None},
                '38F22A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '15 Spencer St. Milverton (Township Perth '
                                          'East)',
                                  'serial': '38F22A',
                                  'serial_number': '38F22A',
                                  'system_mac_address': None},
                '38F285': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '205 Winstanley St. Monkton (TJ Choi)',
                                  'serial': '38F285',
                                  'serial_number': '38F285',
                                  'system_mac_address': None},
                '38FD7F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '91 MAIN ST N (KUEPFER TRAVIS)',
                                  'serial': '38FD7F',
                                  'serial_number': '38FD7F',
                                  'system_mac_address': None},
                '3901AA': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '86 Mill St. E. Milverton (John Spencer)',
                                  'serial': '3901AA',
                                  'serial_number': '3901AA',
                                  'system_mac_address': None},
                '3908F9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '33 Maddison St. W. (Paul Ward)',
                                  'serial': '3908F9',
                                  'serial_number': '3908F9',
                                  'system_mac_address': None},
                '390C5E': {       'dev_macs': ['60:db:98:82:08:01'],
                                  'ip_address': None,
                                  'name': '5384 Line 60 (Don&Barb Boyne)',
                                  'serial': '390C5E',
                                  'serial_number': '390C5E',
                                  'system_mac_address': None},
                '390DC8': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '61 SCHADE ST (BROUGHTON KELLY)',
                                  'serial': '390DC8',
                                  'serial_number': '390DC8',
                                  'system_mac_address': None},
                '3940DE': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '159 Fishleigh St. Monkton (Henry Vander '
                                          'Hyden)',
                                  'serial': '3940DE',
                                  'serial_number': '3940DE',
                                  'system_mac_address': None},
                '3961A8': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '7 SPENCER ST (MARK JUTZI FUNERAL HOME)',
                                  'serial': '3961A8',
                                  'serial_number': '3961A8',
                                  'system_mac_address': None},
                '3B61DE': {       'dev_macs': ['d0:76:8f:91:4b:52'],
                                  'ip_address': None,
                                  'name': '72 GERBER DR (MCCLUSKIE CODY)',
                                  'serial': '3B61DE',
                                  'serial_number': '3B61DE',
                                  'system_mac_address': None},
                '3B6200': {       'dev_macs': ['cc:be:59:2d:a6:2b'],
                                  'ip_address': None,
                                  'name': '15 Pacific Ave (Steven & Debbie Emerson, '
                                          '10404480)',
                                  'serial': '3B6200',
                                  'serial_number': '3B6200',
                                  'system_mac_address': None},
                '3CFA9': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '95 Mill St. E. Milverton (Pumphouse Perth '
                                         'East)',
                                 'serial': '3CFA9',
                                 'serial_number': '3CFA9',
                                 'system_mac_address': None},
                '3FA90D': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5460 LINE 60 (HARNEST ALEXANDER)',
                                  'serial': '3FA90D',
                                  'serial_number': '3FA90D',
                                  'system_mac_address': None},
                '3FC845': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '202 WINSTANLEY ST (KIRKHAM DOUG & KELLI)',
                                  'serial': '3FC845',
                                  'serial_number': '3FC845',
                                  'system_mac_address': None},
                '418B0': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '146 Winstanley St. Monkton (Robert Straeten)',
                                 'serial': '418B0',
                                 'serial_number': '418B0',
                                 'system_mac_address': None},
                '4281BF': {       'dev_macs': ['5c:0f:fb:43:97:c6'],
                                  'ip_address': None,
                                  'name': '76 Schade St Monkton (Murray Crawford '
                                          '10434552)',
                                  'serial': '4281BF',
                                  'serial_number': '4281BF',
                                  'system_mac_address': None},
                '4281C6': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '139 Brock St Monkton (Angela Pestell '
                                          '10412111)',
                                  'serial': '4281C6',
                                  'serial_number': '4281C6',
                                  'system_mac_address': None},
                '4281D3': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '94 GERBER DR (BUDDELL WILLIAM)',
                                  'serial': '4281D3',
                                  'serial_number': '4281D3',
                                  'system_mac_address': None},
                '4281E9': {       'dev_macs': ['14:21:03:a9:70:10'],
                                  'ip_address': None,
                                  'name': '161 Brock St Monkton (Wilma Acheson '
                                          '10434491)',
                                  'serial': '4281E9',
                                  'serial_number': '4281E9',
                                  'system_mac_address': None},
                '42844C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '126 Brock St (Kevin Mclean, 10422928)',
                                  'serial': '42844C',
                                  'serial_number': '42844C',
                                  'system_mac_address': None},
                '42B9B6': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '45 Temperance St (Lindsay Hammer 10423568)',
                                  'serial': '42B9B6',
                                  'serial_number': '42B9B6',
                                  'system_mac_address': None},
                '42B9C3': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6322 Rd. 148 (Kurt Gsell)',
                                  'serial': '42B9C3',
                                  'serial_number': '42B9C3',
                                  'system_mac_address': None},
                '42B9D7': {       'dev_macs': ['44:65:7f:41:8f:0b'],
                                  'ip_address': None,
                                  'name': '75 Gerber Drive Milverton (Cezary Cybulski '
                                          '10434099)',
                                  'serial': '42B9D7',
                                  'serial_number': '42B9D7',
                                  'system_mac_address': None},
                '42B9ED': {       'dev_macs': ['44:65:7f:79:d0:b7'],
                                  'ip_address': None,
                                  'name': '11 Main St S Milverton (Milverton Mini Mart '
                                          '10420723)',
                                  'serial': '42B9ED',
                                  'serial_number': '42B9ED',
                                  'system_mac_address': None},
                '42BE9A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4895 Line 67 House (Ron and Deborah '
                                          'Riddell)',
                                  'serial': '42BE9A',
                                  'serial_number': '42BE9A',
                                  'system_mac_address': None},
                '42BEA0': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4633 Line 61 Milverton (James Kuepfer '
                                          '10400294)',
                                  'serial': '42BEA0',
                                  'serial_number': '42BEA0',
                                  'system_mac_address': None},
                '42BEA2': {       'dev_macs': ['44:65:7f:88:d5:a3'],
                                  'ip_address': None,
                                  'name': '5126 Line 58 Milverton (J & B Crowley '
                                          '10404213)',
                                  'serial': '42BEA2',
                                  'serial_number': '42BEA2',
                                  'system_mac_address': None},
                '42BEA7': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5088 Line 58 Milverton (Franz & Susy Arnold '
                                          '10400118)',
                                  'serial': '42BEA7',
                                  'serial_number': '42BEA7',
                                  'system_mac_address': None},
                '42BEC1': {       'dev_macs': ['60:db:98:81:fa:a4'],
                                  'ip_address': None,
                                  'name': '47 MAIN ST N (WOLF JONATHAN)',
                                  'serial': '42BEC1',
                                  'serial_number': '42BEC1',
                                  'system_mac_address': None},
                '42BEDF': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '8 John St Milverton (Craig Lines 10422212)',
                                  'serial': '42BEDF',
                                  'serial_number': '42BEDF',
                                  'system_mac_address': None},
                '42BF03': {       'dev_macs': ['cc:be:59:2d:a5:e3'],
                                  'ip_address': None,
                                  'name': '88 GERBER DRIVE (DEWAR JAMIE & ANGIE)',
                                  'serial': '42BF03',
                                  'serial_number': '42BF03',
                                  'system_mac_address': None},
                '42BF08': {       'dev_macs': [       '00:03:e6:dd:2e:38',
                                                      '70:56:81:c5:c5:ba'],
                                  'ip_address': None,
                                  'name': '4900 LINE 52 (DEGROOT JIM & WENDY)',
                                  'serial': '42BF08',
                                  'serial_number': '42BF08',
                                  'system_mac_address': None},
                '42BF1B': {       'dev_macs': ['e4:6c:d1:4e:ea:83'],
                                  'ip_address': None,
                                  'name': '77A REAGAN ST (LARA MARCELLO)',
                                  'serial': '42BF1B',
                                  'serial_number': '42BF1B',
                                  'system_mac_address': None},
                '42BF1D': {       'dev_macs': ['ec:4f:82:ac:f0:12'],
                                  'ip_address': None,
                                  'name': '6238 Road 140 Milverton (Rick Diehl '
                                          '10404130)',
                                  'serial': '42BF1D',
                                  'serial_number': '42BF1D',
                                  'system_mac_address': None},
                '42C048': {       'dev_macs': ['44:65:7f:89:0f:39'],
                                  'ip_address': None,
                                  'name': '194 SELBY AV (SMITH LORI)',
                                  'serial': '42C048',
                                  'serial_number': '42C048',
                                  'system_mac_address': None},
                '42C0AF': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '37 Main St. N. Milverton (Doris Coultes)',
                                  'serial': '42C0AF',
                                  'serial_number': '42C0AF',
                                  'system_mac_address': None},
                '42C2D3': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5256 Line 49 Gadshill (M & K DeJong '
                                          '10427640)',
                                  'serial': '42C2D3',
                                  'serial_number': '42C2D3',
                                  'system_mac_address': None},
                '42C38C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5340B Line 49 Gadshill (Stu McDonald '
                                          '10422004)',
                                  'serial': '42C38C',
                                  'serial_number': '42C38C',
                                  'system_mac_address': None},
                '42C38E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5340A Line 49 (Malcolm McDonald 10400307)',
                                  'serial': '42C38E',
                                  'serial_number': '42C38E',
                                  'system_mac_address': None},
                '42C40E': {       'dev_macs': ['44:65:7f:41:8e:57'],
                                  'ip_address': None,
                                  'name': '36 Gerber Ct Milverton (Norman Bell '
                                          '10435005)',
                                  'serial': '42C40E',
                                  'serial_number': '42C40E',
                                  'system_mac_address': None},
                '42C467': {       'dev_macs': ['44:65:7f:88:d5:40'],
                                  'ip_address': None,
                                  'name': '51 MILL ST E (HIPPE AMANDA)',
                                  'serial': '42C467',
                                  'serial_number': '42C467',
                                  'system_mac_address': None},
                '42C4A9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '199 WINSTANLEY ST (WHETSTONE JOSH)',
                                  'serial': '42C4A9',
                                  'serial_number': '42C4A9',
                                  'system_mac_address': None},
                '42C4C9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '140 Brock St Monkton (R & B Buchanan '
                                          '10430719)',
                                  'serial': '42C4C9',
                                  'serial_number': '42C4C9',
                                  'system_mac_address': None},
                '42C523': {       'dev_macs': ['b8:94:70:f3:e3:64'],
                                  'ip_address': None,
                                  'name': '84 Reagan St Milverton (Martin Andrews '
                                          '10435676)',
                                  'serial': '42C523',
                                  'serial_number': '42C523',
                                  'system_mac_address': None},
                '42C595': {       'dev_macs': ['44:65:7f:88:d3:75'],
                                  'ip_address': None,
                                  'name': '136 Brock St Monkton (Dale MacCannell '
                                          '10435836)',
                                  'serial': '42C595',
                                  'serial_number': '42C595',
                                  'system_mac_address': None},
                '42C5B4': {       'dev_macs': ['44:65:7f:88:d5:0a'],
                                  'ip_address': None,
                                  'name': '67 Reagan St. Milverton (Joy Sheridan '
                                          '10435977)',
                                  'serial': '42C5B4',
                                  'serial_number': '42C5B4',
                                  'system_mac_address': None},
                '42C6D2': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '42 MADDISON ST E (MARTIN GERALD)',
                                  'serial': '42C6D2',
                                  'serial_number': '42C6D2',
                                  'system_mac_address': None},
                '42C702': {       'dev_macs': ['ec:4f:82:2b:48:69'],
                                  'ip_address': None,
                                  'name': '191 Selby Av. Monkton (Roger Orth)',
                                  'serial': '42C702',
                                  'serial_number': '42C702',
                                  'system_mac_address': None},
                '42C70A': {       'dev_macs': ['5c:0f:fb:2a:05:8a'],
                                  'ip_address': None,
                                  'name': '11 MacBeth St (David Sloat 10401199)',
                                  'serial': '42C70A',
                                  'serial_number': '42C70A',
                                  'system_mac_address': None},
                '42C70B': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5137 Line 49 Gadshill (MJD FARMS LTD)',
                                  'serial': '42C70B',
                                  'serial_number': '42C70B',
                                  'system_mac_address': None},
                '42C748': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4987 Line 59 (Prima Valley Farms Ltd '
                                          '10400278)',
                                  'serial': '42C748',
                                  'serial_number': '42C748',
                                  'system_mac_address': None},
                '42C89C': {       'dev_macs': ['b8:94:70:f3:cb:ac'],
                                  'ip_address': None,
                                  'name': '4660 LINE 61 (MILVERTON ROD & GUN CLUB INC)',
                                  'serial': '42C89C',
                                  'serial_number': '42C89C',
                                  'system_mac_address': None},
                '42C8D3': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4775 LINE 61 (BAKER TYLER & JULIE)',
                                  'serial': '42C8D3',
                                  'serial_number': '42C8D3',
                                  'system_mac_address': None},
                '42C8EA': {       'dev_macs': ['a8:42:a1:29:f2:75'],
                                  'ip_address': None,
                                  'name': '5383 Perth Road 135 (Ryan & Mandy '
                                          'Kuntze10421167)',
                                  'serial': '42C8EA',
                                  'serial_number': '42C8EA',
                                  'system_mac_address': None},
                '42C919': {       'dev_macs': ['00:09:0f:09:01:00'],
                                  'ip_address': None,
                                  'name': '4743 Line 52 Brunner (Milverton Layer '
                                          'Farms)',
                                  'serial': '42C919',
                                  'serial_number': '42C919',
                                  'system_mac_address': None},
                '42CA30': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '19 MAIN ST N APT 2 MILVERTON (FRIESEN '
                                          'HENRY)',
                                  'serial': '42CA30',
                                  'serial_number': '42CA30',
                                  'system_mac_address': None},
                '42CD66': {       'dev_macs': ['44:65:7f:88:45:7f'],
                                  'ip_address': None,
                                  'name': '5316 Road 144 Brunner (W & J Paxton '
                                          '10435748)',
                                  'serial': '42CD66',
                                  'serial_number': '42CD66',
                                  'system_mac_address': None},
                '42CDDC': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5099 Line 49 Gadshill (Andy Groenestege '
                                          '10400881)',
                                  'serial': '42CDDC',
                                  'serial_number': '42CDDC',
                                  'system_mac_address': None},
                '42CE32': {       'dev_macs': ['44:65:7f:89:0e:58'],
                                  'ip_address': None,
                                  'name': '4661 LINE 49 (ROES JASON & ANGELA)',
                                  'serial': '42CE32',
                                  'serial_number': '42CE32',
                                  'system_mac_address': None},
                '42CE4A': {       'dev_macs': ['44:65:7f:89:0c:45'],
                                  'ip_address': None,
                                  'name': '4860 Line 52 Brunner (Ronald Raycraft '
                                          '10400550)',
                                  'serial': '42CE4A',
                                  'serial_number': '42CE4A',
                                  'system_mac_address': None},
                '42D092': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4606 Line 49 Gadshill (J & A Debus '
                                          '10400821)',
                                  'serial': '42D092',
                                  'serial_number': '42D092',
                                  'system_mac_address': None},
                '42D0B4': {       'dev_macs': ['60:db:98:54:ab:1b'],
                                  'ip_address': None,
                                  'name': '9 Colbalt St. S. Milverton (Jamie Scott)',
                                  'serial': '42D0B4',
                                  'serial_number': '42D0B4',
                                  'system_mac_address': None},
                '42D154': {       'dev_macs': ['84:d3:43:6d:e7:e3'],
                                  'ip_address': None,
                                  'name': '4535 Line 49 (Helmut&Liz Mergl 10400543)',
                                  'serial': '42D154',
                                  'serial_number': '42D154',
                                  'system_mac_address': None},
                '42D196': {       'dev_macs': ['44:65:7f:89:0f:42'],
                                  'ip_address': None,
                                  'name': '4650 Line 49-3 (J & J Millwrighting '
                                          '10403280)',
                                  'serial': '42D196',
                                  'serial_number': '42D196',
                                  'system_mac_address': None},
                '42D1CE': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5113 Perth Road 135 Rostock (B & D Debus '
                                          '10402399)',
                                  'serial': '42D1CE',
                                  'serial_number': '42D1CE',
                                  'system_mac_address': None},
                '42D2AE': {       'dev_macs': ['44:65:7f:41:9c:9d'],
                                  'ip_address': None,
                                  'name': '79 GERBER DR (DOHERTY LARRY & DONNA)',
                                  'serial': '42D2AE',
                                  'serial_number': '42D2AE',
                                  'system_mac_address': None},
                '42D2AF': {       'dev_macs': ['d0:76:8f:02:ee:73'],
                                  'ip_address': None,
                                  'name': '5216 Line 49 (MCDONNELL MAGGIE)',
                                  'serial': '42D2AF',
                                  'serial_number': '42D2AF',
                                  'system_mac_address': None},
                '42D361': {       'dev_macs': ['e4:6c:d1:4e:f0:c9'],
                                  'ip_address': None,
                                  'name': '85B Mill St E Milverton (Tricia Nahrgang '
                                          '10435488)',
                                  'serial': '42D361',
                                  'serial_number': '42D361',
                                  'system_mac_address': None},
                '43B154': {       'dev_macs': ['d0:76:8f:02:ee:c0'],
                                  'ip_address': None,
                                  'name': '14 Pacific Ave (Mitchell Medeiros10434078)',
                                  'serial': '43B154',
                                  'serial_number': '43B154',
                                  'system_mac_address': None},
                '43B2D7': {       'dev_macs': ['d8:50:e6:c3:5a:05'],
                                  'ip_address': None,
                                  'name': '5668 Perth Rd 119 Brunner (Simon Jantzi '
                                          '10400499)',
                                  'serial': '43B2D7',
                                  'serial_number': '43B2D7',
                                  'system_mac_address': None},
                '43B37D': {       'dev_macs': ['d8:b3:70:12:51:39'],
                                  'ip_address': None,
                                  'name': '19 TEMPERANCE ST (BOWEY JOHN)',
                                  'serial': '43B37D',
                                  'serial_number': '43B37D',
                                  'system_mac_address': None},
                '43B38E': {       'dev_macs': ['6c:cd:d6:eb:84:7d'],
                                  'ip_address': None,
                                  'name': '4978 Line 52 Brunner (Andrew Brodhagen '
                                          '10433259)',
                                  'serial': '43B38E',
                                  'serial_number': '43B38E',
                                  'system_mac_address': None},
                '43B3A2': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 William St Apt 4 Milverton',
                                  'serial': '43B3A2',
                                  'serial_number': '43B3A2',
                                  'system_mac_address': None},
                '43B3B6': {       'dev_macs': ['38:d5:47:87:96:d0'],
                                  'ip_address': None,
                                  'name': '4934 LINE 49 (LEYBOURNE KEVIN)',
                                  'serial': '43B3B6',
                                  'serial_number': '43B3B6',
                                  'system_mac_address': None},
                '43B3F4': {       'dev_macs': ['28:3b:82:66:18:9e'],
                                  'ip_address': None,
                                  'name': '15 West St Milverton (Maggie Enns 10430560)',
                                  'serial': '43B3F4',
                                  'serial_number': '43B3F4',
                                  'system_mac_address': None},
                '43B508': {       'dev_macs': ['20:23:51:49:b5:a9'],
                                  'ip_address': None,
                                  'name': '73 REAGAN ST (MILLER PAUL)',
                                  'serial': '43B508',
                                  'serial_number': '43B508',
                                  'system_mac_address': None},
                '43B54C': {       'dev_macs': ['70:62:b8:2f:ef:61'],
                                  'ip_address': None,
                                  'name': '20 ST MARYS ST S (HIEBERT JUDITH)',
                                  'serial': '43B54C',
                                  'serial_number': '43B54C',
                                  'system_mac_address': None},
                '43B5B7': {       'dev_macs': ['d0:76:8f:1f:66:df'],
                                  'ip_address': None,
                                  'name': '6121 Ana St Brunner (Stephan Gingerich '
                                          '10435309)',
                                  'serial': '43B5B7',
                                  'serial_number': '43B5B7',
                                  'system_mac_address': None},
                '43C1B8': {       'dev_macs': ['0c:80:63:34:53:53'],
                                  'ip_address': None,
                                  'name': '78 GERBER DR (LAURIAULT NICOLE)',
                                  'serial': '43C1B8',
                                  'serial_number': '43C1B8',
                                  'system_mac_address': None},
                '43C24B': {       'dev_macs': ['a0:ab:1b:88:c0:af'],
                                  'ip_address': None,
                                  'name': '74 Gerber Drive Milverton (Shannon Stangen '
                                          '10434431)',
                                  'serial': '43C24B',
                                  'serial_number': '43C24B',
                                  'system_mac_address': None},
                '43C42C': {       'dev_macs': ['14:59:c0:bf:74:f6'],
                                  'ip_address': None,
                                  'name': '153 Winstanley St. Monkton (Ben Champion)',
                                  'serial': '43C42C',
                                  'serial_number': '43C42C',
                                  'system_mac_address': None},
                '44AA8F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '8 MAIN ST N MILVERTON (VILLAGE PHARMACY)',
                                  'serial': '44AA8F',
                                  'serial_number': '44AA8F',
                                  'system_mac_address': None},
                '44AAA8': {       'dev_macs': [       '00:03:e6:f9:e2:1e',
                                                      'f0:ad:4e:18:9f:1c',
                                                      '00:03:e6:f9:fb:6f'],
                                  'ip_address': None,
                                  'name': '200 Nelson St. Monkton (North Perth Elma '
                                          'Logan Rec Complex)',
                                  'serial': '44AAA8',
                                  'serial_number': '44AAA8',
                                  'system_mac_address': None},
                '459638': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '27 Main St. N. Milverton (Koertland Garage)',
                                  'serial': '459638',
                                  'serial_number': '459638',
                                  'system_mac_address': None},
                '45965D': {       'dev_macs': ['00:1e:e3:12:34:56'],
                                  'ip_address': None,
                                  'name': '111 Maddison St. W. Monkton (Steve Smith '
                                          'Auto Sales)',
                                  'serial': '45965D',
                                  'serial_number': '45965D',
                                  'system_mac_address': None},
                '45968C': {       'dev_macs': ['5c:0f:fb:3d:60:02'],
                                  'ip_address': None,
                                  'name': '50 William St. Milverton (Knollcrest Data '
                                          'Rm. 1)',
                                  'serial': '45968C',
                                  'serial_number': '45968C',
                                  'system_mac_address': None},
                '4596A5': {       'dev_macs': [       '00:5f:67:a4:50:5d',
                                                      '60:83:e7:7c:39:98',
                                                      '24:2f:d0:93:60:3b'],
                                  'ip_address': None,
                                  'name': '9 & 11 Maddison Street E (Multi-customer)',
                                  'serial': '4596A5',
                                  'serial_number': '4596A5',
                                  'system_mac_address': None},
                '471755': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5387 LINE 60 (COXON TYE M)',
                                  'serial': '471755',
                                  'serial_number': '471755',
                                  'system_mac_address': None},
                '47E37': {       'dev_macs': [       '5c:0f:fb:3d:52:86',
                                                     '5c:0f:fb:3d:80:08',
                                                     '00:03:e6:f9:7f:8a',
                                                     '5c:0f:fb:3d:58:aa'],
                                 'ip_address': None,
                                 'name': '50 WILLIAM ST (WOODS RUTH A)',
                                 'serial': '47E37',
                                 'serial_number': '47E37',
                                 'system_mac_address': None},
                '4D114C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '165 WINSTANLEY ST (KLOOSTRA ALEX)',
                                  'serial': '4D114C',
                                  'serial_number': '4D114C',
                                  'system_mac_address': None},
                '4D1152': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '206 Queen Ave, Monkton',
                                  'serial': '4D1152',
                                  'serial_number': '4D1152',
                                  'system_mac_address': None},
                '4D41F2': {       'dev_macs': ['00:03:e6:eb:7d:1e'],
                                  'ip_address': None,
                                  'name': '218 Selby Ave, Monkton (Steve & Krystle '
                                          'Pettapiece)',
                                  'serial': '4D41F2',
                                  'serial_number': '4D41F2',
                                  'system_mac_address': None},
                '4D4239': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '214 SELBY AVENUE (WARD KELLY-ANN)',
                                  'serial': '4D4239',
                                  'serial_number': '4D4239',
                                  'system_mac_address': None},
                '4D423B': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '100 MADDISON ST E (BOYD RON & KATHY)',
                                  'serial': '4D423B',
                                  'serial_number': '4D423B',
                                  'system_mac_address': None},
                '4D423F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '189 WINSTANLEY ST',
                                  'serial': '4D423F',
                                  'serial_number': '4D423F',
                                  'system_mac_address': None},
                '4D4244': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '22 Maddison St. West, Monkton (George & Pat '
                                          'Worth)',
                                  'serial': '4D4244',
                                  'serial_number': '4D4244',
                                  'system_mac_address': None},
                '4D424C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '170 Fishleigh St., Monkton (Ben Fizell)',
                                  'serial': '4D424C',
                                  'serial_number': '4D424C',
                                  'system_mac_address': None},
                '4D424E': {       'dev_macs': ['00:03:e6:a4:d3:80'],
                                  'ip_address': None,
                                  'name': '22 Winstanley St., Monkton (Natasha Baxter '
                                          '10433874)',
                                  'serial': '4D424E',
                                  'serial_number': '4D424E',
                                  'system_mac_address': None},
                '4EE08': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '8 Pugh St. Milverton (MCCL Cell Tower)',
                                 'serial': '4EE08',
                                 'serial_number': '4EE08',
                                 'system_mac_address': None},
                '4F8C9B': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '82 Gerber Drive Milverton',
                                  'serial': '4F8C9B',
                                  'serial_number': '4F8C9B',
                                  'system_mac_address': None},
                '4F91FF': {       'dev_macs': ['00:31:92:dc:5c:f9'],
                                  'ip_address': None,
                                  'name': '61 Reagan St (Philip & Rosemary '
                                          'Lebold,10411732)',
                                  'serial': '4F91FF',
                                  'serial_number': '4F91FF',
                                  'system_mac_address': None},
                '4F92CF': {       'dev_macs': ['78:32:1b:49:95:0f'],
                                  'ip_address': None,
                                  'name': '5713 Perth Rd 119 Brunner (Harry Walmsley '
                                          '10402219)',
                                  'serial': '4F92CF',
                                  'serial_number': '4F92CF',
                                  'system_mac_address': None},
                '4F9AE4': {       'dev_macs': ['b8:94:70:f3:ec:33'],
                                  'ip_address': None,
                                  'name': '8A WILLIAM ST (HOLST SAMUEL)',
                                  'serial': '4F9AE4',
                                  'serial_number': '4F9AE4',
                                  'system_mac_address': None},
                '4F9B37': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5 MacBeth St Milverton (Damion Bijman '
                                          '10434605)',
                                  'serial': '4F9B37',
                                  'serial_number': '4F9B37',
                                  'system_mac_address': None},
                '4F9B3C': {       'dev_macs': ['e8:fc:af:f9:6d:00'],
                                  'ip_address': None,
                                  'name': '6383 Road 124 Milverton (Brad Gascho '
                                          '10400853)',
                                  'serial': '4F9B3C',
                                  'serial_number': '4F9B3C',
                                  'system_mac_address': None},
                '4FA244': {       'dev_macs': ['cc:be:59:7e:b6:26'],
                                  'ip_address': None,
                                  'name': '3 West St Milverton (Joe Kuepfer 10426185)',
                                  'serial': '4FA244',
                                  'serial_number': '4FA244',
                                  'system_mac_address': None},
                '4FA249': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '8 MacBeth St Milverton (Abe Hildebrandt '
                                          '10435622)',
                                  'serial': '4FA249',
                                  'serial_number': '4FA249',
                                  'system_mac_address': None},
                '4FA25D': {       'dev_macs': ['04:bc:9f:46:94:11'],
                                  'ip_address': None,
                                  'name': '25 MILL ST W (ENNS ANTHONY)',
                                  'serial': '4FA25D',
                                  'serial_number': '4FA25D',
                                  'system_mac_address': None},
                '5124E1': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '17 MAIN ST N',
                                  'serial': '5124E1',
                                  'serial_number': '5124E1',
                                  'system_mac_address': None},
                '5124E6': {       'dev_macs': ['68:ff:7b:33:69:73'],
                                  'ip_address': None,
                                  'name': '4621 Line 49 Brunner (Andrew Debus '
                                          '10435392)',
                                  'serial': '5124E6',
                                  'serial_number': '5124E6',
                                  'system_mac_address': None},
                '51250D': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': 'Rueben Kuepfer 10431068 (85 Reagan St)',
                                  'serial': '51250D',
                                  'serial_number': '51250D',
                                  'system_mac_address': None},
                '512523': {       'dev_macs': ['44:65:7f:89:0e:97'],
                                  'ip_address': None,
                                  'name': '4538 Line 49 (Samuel Ebersol 10430136)',
                                  'serial': '512523',
                                  'serial_number': '512523',
                                  'system_mac_address': None},
                '512575': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4650 Line 49 (Linda Debus10403081)',
                                  'serial': '512575',
                                  'serial_number': '512575',
                                  'system_mac_address': None},
                '512576': {       'dev_macs': ['e8:8d:28:55:cd:f1'],
                                  'ip_address': None,
                                  'name': '89 Main St N Milverton (Doug & Anna Hodgins '
                                          '10403089)',
                                  'serial': '512576',
                                  'serial_number': '512576',
                                  'system_mac_address': None},
                '512588': {       'dev_macs': ['c4:e9:84:87:af:6d'],
                                  'ip_address': None,
                                  'name': '4660 Line 52 Brunner (Rick Reis 10400560)',
                                  'serial': '512588',
                                  'serial_number': '512588',
                                  'system_mac_address': None},
                '5125CA': {       'dev_macs': ['a0:ab:1b:7b:68:2d'],
                                  'ip_address': None,
                                  'name': '52 Main St N Milverton (Diane Schweitzer '
                                          '10401082)',
                                  'serial': '5125CA',
                                  'serial_number': '5125CA',
                                  'system_mac_address': None},
                '5125E0': {       'dev_macs': ['60:db:98:09:1b:3e'],
                                  'ip_address': None,
                                  'name': '5 GEORGE ST (KRAFT STEPHANIE)',
                                  'serial': '5125E0',
                                  'serial_number': '5125E0',
                                  'system_mac_address': None},
                '5125E3': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '32 MAIN ST N',
                                  'serial': '5125E3',
                                  'serial_number': '5125E3',
                                  'system_mac_address': None},
                '5125E4': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': "5183 ROAD 130 (ST PAUL'S LUTHERAN CHURCH)",
                                  'serial': '5125E4',
                                  'serial_number': '5125E4',
                                  'system_mac_address': None},
                '5125F0': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4514 Line 49 (Isaak Janzen 10429928)',
                                  'serial': '5125F0',
                                  'serial_number': '5125F0',
                                  'system_mac_address': None},
                '555C9F': {       'dev_macs': ['78:9a:18:18:7f:b0'],
                                  'ip_address': None,
                                  'name': '6380 Perth Rd 131 (MASONAL STONE)',
                                  'serial': '555C9F',
                                  'serial_number': '555C9F',
                                  'system_mac_address': None},
                '556382': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '69 Schade St. Monkton (Jay Yundt)',
                                  'serial': '556382',
                                  'serial_number': '556382',
                                  'system_mac_address': None},
                '556393': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '72 Schade St, Monkton (Geoff & Jodie '
                                          'Tummers 10430143)',
                                  'serial': '556393',
                                  'serial_number': '556393',
                                  'system_mac_address': None},
                '5563A9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '130 Maddison St. E. Monkton (Don Hymers)',
                                  'serial': '5563A9',
                                  'serial_number': '5563A9',
                                  'system_mac_address': None},
                '5563D4': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '59 Maddison St. West, Monkton (Kevin Cook '
                                          '10430147)',
                                  'serial': '5563D4',
                                  'serial_number': '5563D4',
                                  'system_mac_address': None},
                '5563DF': {       'dev_macs': ['cc:be:59:7e:b7:19'],
                                  'ip_address': None,
                                  'name': '197 King Ave, Monkton (Dana Verwey)',
                                  'serial': '5563DF',
                                  'serial_number': '5563DF',
                                  'system_mac_address': None},
                '5563E9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '71 REAGAN ST (CAO QUI PHUC)',
                                  'serial': '5563E9',
                                  'serial_number': '5563E9',
                                  'system_mac_address': None},
                '55F537': {       'dev_macs': [       '08:96:ad:ec:1f:2d',
                                                      '08:96:ad:ec:1f:40',
                                                      '00:50:56:a3:97:c5',
                                                      'f8:6b:d9:26:63:e1'],
                                  'ip_address': None,
                                  'name': '132 Maddison St. W. Monkton (WFS Great '
                                          'Lakes 10424552)',
                                  'serial': '55F537',
                                  'serial_number': '55F537',
                                  'system_mac_address': None},
                '55F9BC': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6432 ROAD 154 (OHM PERRY & JENNIFER)',
                                  'serial': '55F9BC',
                                  'serial_number': '55F9BC',
                                  'system_mac_address': None},
                '55F9C4': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '166 Fishleigh St. Monkton (Keith Kuepfer '
                                          '10403450)',
                                  'serial': '55F9C4',
                                  'serial_number': '55F9C4',
                                  'system_mac_address': None},
                '560258': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '185 Winstanley St. Monkton (Becky Beuerman)',
                                  'serial': '560258',
                                  'serial_number': '560258',
                                  'system_mac_address': None},
                '560296': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '210 Winstanley Ave, Monkton (Donna '
                                          'McConnell)',
                                  'serial': '560296',
                                  'serial_number': '560296',
                                  'system_mac_address': None},
                '560C10': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '164 Smith St. Monkton (Bob Mclean)',
                                  'serial': '560C10',
                                  'serial_number': '560C10',
                                  'system_mac_address': None},
                '561162': {       'dev_macs': ['cc:be:59:32:93:c9'],
                                  'ip_address': None,
                                  'name': '206 Winstanely St., Monkton (Nicole '
                                          'Willfong 10434242)',
                                  'serial': '561162',
                                  'serial_number': '561162',
                                  'system_mac_address': None},
                '56171C': {       'dev_macs': ['44:65:7f:79:de:01'],
                                  'ip_address': None,
                                  'name': '63 Reagan St Milverton (Megan Hines '
                                          '10435292)',
                                  'serial': '56171C',
                                  'serial_number': '56171C',
                                  'system_mac_address': None},
                '5A61E6': {       'dev_macs': ['44:65:7f:b5:29:55'],
                                  'ip_address': None,
                                  'name': '5 Murray Ct Milverton (Lorne Steckley '
                                          '10402394)',
                                  'serial': '5A61E6',
                                  'serial_number': '5A61E6',
                                  'system_mac_address': None},
                '5A621B': {       'dev_macs': ['a8:42:a1:5b:fc:71'],
                                  'ip_address': None,
                                  'name': '44 Mill St E Milverton (Douglas Fink '
                                          '10425982)',
                                  'serial': '5A621B',
                                  'serial_number': '5A621B',
                                  'system_mac_address': None},
                '5A6223': {       'dev_macs': ['b8:94:70:f3:e0:6d'],
                                  'ip_address': None,
                                  'name': '4725 LINE 61 (MUELLER STEFAN)',
                                  'serial': '5A6223',
                                  'serial_number': '5A6223',
                                  'system_mac_address': None},
                '5A6591': {       'dev_macs': ['78:d2:94:ad:58:1e'],
                                  'ip_address': None,
                                  'name': '5177 Line 49 Gadshill (John Mueller '
                                          '10400461)',
                                  'serial': '5A6591',
                                  'serial_number': '5A6591',
                                  'system_mac_address': None},
                '5A65BE': {       'dev_macs': ['60:22:32:43:8e:43'],
                                  'ip_address': None,
                                  'name': '4895 Line 67 Barn (Ron & Deb Riddell '
                                          '10426917)',
                                  'serial': '5A65BE',
                                  'serial_number': '5A65BE',
                                  'system_mac_address': None},
                '5A65F2': {       'dev_macs': ['14:21:03:92:ee:1d'],
                                  'ip_address': None,
                                  'name': '4910 Line 48 Gadshill (Dan Groenstege '
                                          '10421236)',
                                  'serial': '5A65F2',
                                  'serial_number': '5A65F2',
                                  'system_mac_address': None},
                '5A65F5': {       'dev_macs': ['44:65:7f:88:d2:28'],
                                  'ip_address': None,
                                  'name': '1 Murray Ct (Dawn Griffin 10435906)',
                                  'serial': '5A65F5',
                                  'serial_number': '5A65F5',
                                  'system_mac_address': None},
                '5A6607': {       'dev_macs': ['78:54:2e:a4:13:a9'],
                                  'ip_address': None,
                                  'name': '5368 Perth Rd 135B Brunner (Glen Diehl '
                                          '10400698)',
                                  'serial': '5A6607',
                                  'serial_number': '5A6607',
                                  'system_mac_address': None},
                '5A6616': {       'dev_macs': ['14:dd:a9:91:e4:90'],
                                  'ip_address': None,
                                  'name': '4860 Line 48 Gadshill (Bert Groenestege '
                                          '10400636)',
                                  'serial': '5A6616',
                                  'serial_number': '5A6616',
                                  'system_mac_address': None},
                '5A6627': {       'dev_macs': ['44:65:7f:88:d4:d4'],
                                  'ip_address': None,
                                  'name': '87 Min St N Milverton (George Raycraft '
                                          '10400878)',
                                  'serial': '5A6627',
                                  'serial_number': '5A6627',
                                  'system_mac_address': None},
                '5A662D': {       'dev_macs': ['1c:61:b4:5c:5c:94'],
                                  'ip_address': None,
                                  'name': '40 Tye St Milverton (B & P Huber 10403559)',
                                  'serial': '5A662D',
                                  'serial_number': '5A662D',
                                  'system_mac_address': None},
                '5A6632': {       'dev_macs': ['d8:07:b6:74:04:e1'],
                                  'ip_address': None,
                                  'name': '5909 PERTH ROAD 119 (FRIESEN KEVIN)',
                                  'serial': '5A6632',
                                  'serial_number': '5A6632',
                                  'system_mac_address': None},
                '5A6657': {       'dev_macs': ['b0:4e:26:7b:bf:a3'],
                                  'ip_address': None,
                                  'name': '6 Fulton St Milverton (P & M Bueckert '
                                          '10421013)',
                                  'serial': '5A6657',
                                  'serial_number': '5A6657',
                                  'system_mac_address': None},
                '5A6661': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4672 Line 49 Brunner (Stan Debus 10400507)',
                                  'serial': '5A6661',
                                  'serial_number': '5A6661',
                                  'system_mac_address': None},
                '5A6663': {       'dev_macs': ['a8:63:7d:7a:80:cb'],
                                  'ip_address': None,
                                  'name': '198 Queen St Monkton (Peter Enns 10431166)',
                                  'serial': '5A6663',
                                  'serial_number': '5A6663',
                                  'system_mac_address': None},
                '5A6665': {       'dev_macs': ['b8:62:1f:51:e9:39'],
                                  'ip_address': None,
                                  'name': '5087 Line 58 Milverton (Dale Zehr 10401364)',
                                  'serial': '5A6665',
                                  'serial_number': '5A6665',
                                  'system_mac_address': None},
                '5A6668': {       'dev_macs': ['2c:fd:a1:c2:80:48'],
                                  'ip_address': None,
                                  'name': '4911 Line 52 Brunner (M & L Brodhagen '
                                          '10400659)',
                                  'serial': '5A6668',
                                  'serial_number': '5A6668',
                                  'system_mac_address': None},
                '5A668C': {       'dev_macs': ['98:da:c4:63:4b:2a'],
                                  'ip_address': None,
                                  'name': '12 Main St N Milverton (Wicked Snips '
                                          '10402369)',
                                  'serial': '5A668C',
                                  'serial_number': '5A668C',
                                  'system_mac_address': None},
                '5A66BA': {       'dev_macs': ['3c:37:86:43:b0:d8'],
                                  'ip_address': None,
                                  'name': '6475 Perh Rd. 131 Milverton (Megan Ray)',
                                  'serial': '5A66BA',
                                  'serial_number': '5A66BA',
                                  'system_mac_address': None},
                '5A66C8': {       'dev_macs': ['08:36:c9:ed:65:1d'],
                                  'ip_address': None,
                                  'name': '4595 Line 49 (PEHLKE MARJORIE)',
                                  'serial': '5A66C8',
                                  'serial_number': '5A66C8',
                                  'system_mac_address': None},
                '5A69C9': {       'dev_macs': ['34:97:f6:a7:1a:ec'],
                                  'ip_address': None,
                                  'name': '4677 PERTH LINE 55 (KUNTZE MURRAY)',
                                  'serial': '5A69C9',
                                  'serial_number': '5A69C9',
                                  'system_mac_address': None},
                '5A6A13': {       'dev_macs': ['04:d9:f5:8c:e9:e0'],
                                  'ip_address': None,
                                  'name': '4723 LINE 52 (ZONDERVAN TONY & CYNTHIA)',
                                  'serial': '5A6A13',
                                  'serial_number': '5A6A13',
                                  'system_mac_address': None},
                '5A6A60': {       'dev_macs': ['60:db:98:09:3a:e9'],
                                  'ip_address': None,
                                  'name': '5735 PERTH ROAD 119 (NAFZIGER JAMES)',
                                  'serial': '5A6A60',
                                  'serial_number': '5A6A60',
                                  'system_mac_address': None},
                '5A6AEE': {       'dev_macs': ['44:65:7f:88:37:15'],
                                  'ip_address': None,
                                  'name': '5358 Road 140 Brunner (Martin Brodhagen '
                                          '10401375)',
                                  'serial': '5A6AEE',
                                  'serial_number': '5A6AEE',
                                  'system_mac_address': None},
                '5A6B63': {       'dev_macs': ['7a:23:3f:12:f3:92'],
                                  'ip_address': None,
                                  'name': '4 WEST ST (OJIGBO RUTE)',
                                  'serial': '5A6B63',
                                  'serial_number': '5A6B63',
                                  'system_mac_address': None},
                '5A6B6F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '67 MAIN ST (BOOSE ERIC)',
                                  'serial': '5A6B6F',
                                  'serial_number': '5A6B6F',
                                  'system_mac_address': None},
                '5A6B80': {       'dev_macs': ['c0:a0:bb:e7:a9:40'],
                                  'ip_address': None,
                                  'name': '5280 LINE 49 (YOUNGBLUT BILL & SARAH)',
                                  'serial': '5A6B80',
                                  'serial_number': '5A6B80',
                                  'system_mac_address': None},
                '5A6B8F': {       'dev_macs': ['3c:52:a1:96:ba:ed'],
                                  'ip_address': None,
                                  'name': '5133 Rd 140 (Paul and Carolyn Visser)',
                                  'serial': '5A6B8F',
                                  'serial_number': '5A6B8F',
                                  'system_mac_address': None},
                '5A6B93': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6314 ROAD 124 (POOLE VICTOR)',
                                  'serial': '5A6B93',
                                  'serial_number': '5A6B93',
                                  'system_mac_address': None},
                '5A6B9A': {       'dev_macs': ['24:2f:d0:d5:3c:61'],
                                  'ip_address': None,
                                  'name': '5088 Line 52 Brunner (Jim Van Herk '
                                          '10400809)',
                                  'serial': '5A6B9A',
                                  'serial_number': '5A6B9A',
                                  'system_mac_address': None},
                '5A6BA6': {       'dev_macs': ['00:ad:24:60:e2:2b'],
                                  'ip_address': None,
                                  'name': '5 West St. Milverton (Michael Gordon)',
                                  'serial': '5A6BA6',
                                  'serial_number': '5A6BA6',
                                  'system_mac_address': None},
                '5A6BAE': {       'dev_macs': ['c0:c9:e3:09:df:e5'],
                                  'ip_address': None,
                                  'name': '23 William St Milverton (C & H Lichti '
                                          '10424574)',
                                  'serial': '5A6BAE',
                                  'serial_number': '5A6BAE',
                                  'system_mac_address': None},
                '5A6BB2': {       'dev_macs': ['10:27:f5:63:45:ad'],
                                  'ip_address': None,
                                  'name': '5173 Road 150 Gadshill (NATYWARY TYLER)',
                                  'serial': '5A6BB2',
                                  'serial_number': '5A6BB2',
                                  'system_mac_address': None},
                '5A6BCD': {       'dev_macs': ['3c:84:6a:57:6c:f5'],
                                  'ip_address': None,
                                  'name': '5020 Line 52 Brunner (B & J Natywary '
                                          '10400723)',
                                  'serial': '5A6BCD',
                                  'serial_number': '5A6BCD',
                                  'system_mac_address': None},
                '5A6BF8': {       'dev_macs': ['24:f5:a2:8d:fb:8e'],
                                  'ip_address': None,
                                  'name': '14 WEST ST (SALZMAN BRUCE)',
                                  'serial': '5A6BF8',
                                  'serial_number': '5A6BF8',
                                  'system_mac_address': None},
                '5A6C39': {       'dev_macs': ['48:77:46:9a:50:9a'],
                                  'ip_address': None,
                                  'name': '22 WEST ST (STECKLY STEVE)',
                                  'serial': '5A6C39',
                                  'serial_number': '5A6C39',
                                  'system_mac_address': None},
                '5A6C68': {       'dev_macs': ['98:da:c4:30:8b:40'],
                                  'ip_address': None,
                                  'name': '6515 ROAD 154 (ERB MARK & RACHEL)',
                                  'serial': '5A6C68',
                                  'serial_number': '5A6C68',
                                  'system_mac_address': None},
                '5A6C89': {       'dev_macs': ['78:32:1b:63:f0:6a'],
                                  'ip_address': None,
                                  'name': '4575 Line 49 (Roosendale Theo)',
                                  'serial': '5A6C89',
                                  'serial_number': '5A6C89',
                                  'system_mac_address': None},
                '5A6C8A': {       'dev_macs': ['a8:63:7d:4f:07:30'],
                                  'ip_address': None,
                                  'name': '5357 ROAD 140 (ROOBROECK JEREMY)',
                                  'serial': '5A6C8A',
                                  'serial_number': '5A6C8A',
                                  'system_mac_address': None},
                '5A6C9D': {       'dev_macs': ['d0:76:8f:02:f4:f0'],
                                  'ip_address': None,
                                  'name': '24 MILL ST E (WEBER JUSTIN)',
                                  'serial': '5A6C9D',
                                  'serial_number': '5A6C9D',
                                  'system_mac_address': None},
                '64079A': {       'dev_macs': ['8c:90:2d:72:7d:85'],
                                  'ip_address': None,
                                  'name': '5154 Road 140 (Joseph White 10435270)',
                                  'serial': '64079A',
                                  'serial_number': '64079A',
                                  'system_mac_address': None},
                '640A0A': {       'dev_macs': ['24:f5:a2:00:96:a6'],
                                  'ip_address': None,
                                  'name': '29 William St (Addition) (Lorilee Streicher '
                                          '10401618)',
                                  'serial': '640A0A',
                                  'serial_number': '640A0A',
                                  'system_mac_address': None},
                '640A76': {       'dev_macs': ['c4:41:1e:77:6f:d0'],
                                  'ip_address': None,
                                  'name': '91 Mill St E Milverton (Carey Soehner '
                                          '10431225)',
                                  'serial': '640A76',
                                  'serial_number': '640A76',
                                  'system_mac_address': None},
                '640AB6': {       'dev_macs': ['14:59:c0:c1:50:28'],
                                  'ip_address': None,
                                  'name': '5 CObalt St (Matthew Yost 10436053)',
                                  'serial': '640AB6',
                                  'serial_number': '640AB6',
                                  'system_mac_address': None},
                '640ADD': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '13 Main St N Apt 5 Milverton',
                                  'serial': '640ADD',
                                  'serial_number': '640ADD',
                                  'system_mac_address': None},
                '640AF8': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '11 Main St N Ste 2 Milverton',
                                  'serial': '640AF8',
                                  'serial_number': '640AF8',
                                  'system_mac_address': None},
                '640AFB': {       'dev_macs': ['44:65:7f:38:35:e3'],
                                  'ip_address': None,
                                  'name': '94 REAGAN ST (DEWAR MELANIE)',
                                  'serial': '640AFB',
                                  'serial_number': '640AFB',
                                  'system_mac_address': None},
                '640AFF': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 MAIN ST S',
                                  'serial': '640AFF',
                                  'serial_number': '640AFF',
                                  'system_mac_address': None},
                '640B2D': {       'dev_macs': ['c0:56:27:68:f2:88'],
                                  'ip_address': None,
                                  'name': '5375 Rd 144 Brunner (Lisa Paxton 10432593)',
                                  'serial': '640B2D',
                                  'serial_number': '640B2D',
                                  'system_mac_address': None},
                '640B35': {       'dev_macs': [       '00:0b:82:ed:dc:35',
                                                      '00:18:39:73:29:7c',
                                                      '1c:61:b4:03:cd:d5'],
                                  'ip_address': None,
                                  'name': '150 Brock St Monkton (Ryan Buchanan '
                                          '10430196)',
                                  'serial': '640B35',
                                  'serial_number': '640B35',
                                  'system_mac_address': None},
                '640B3B': {       'dev_macs': ['f8:7b:8c:14:90:8f'],
                                  'ip_address': None,
                                  'name': '69 Reagan St Milverton (Richard Battrick, '
                                          '10436036)',
                                  'serial': '640B3B',
                                  'serial_number': '640B3B',
                                  'system_mac_address': None},
                '640B46': {       'dev_macs': ['a0:04:60:ca:69:e9'],
                                  'ip_address': None,
                                  'name': '46 Mill St E (Kyle Woodrow 10430299)',
                                  'serial': '640B46',
                                  'serial_number': '640B46',
                                  'system_mac_address': None},
                '640B4A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6 Main St N',
                                  'serial': '640B4A',
                                  'serial_number': '640B4A',
                                  'system_mac_address': None},
                '640B51': {       'dev_macs': ['44:65:7f:89:0c:96'],
                                  'ip_address': None,
                                  'name': '87 Reagan St. Milverton (Emily Mills '
                                          '10435602)',
                                  'serial': '640B51',
                                  'serial_number': '640B51',
                                  'system_mac_address': None},
                '640B67': {       'dev_macs': ['cc:be:59:c3:48:ef'],
                                  'ip_address': None,
                                  'name': '2 Coulter St Milverton (Lynn Giles '
                                          '10434418)',
                                  'serial': '640B67',
                                  'serial_number': '640B67',
                                  'system_mac_address': None},
                '66D53': {       'dev_macs': ['00:09:0f:09:01:02'],
                                 'ip_address': None,
                                 'name': '25 WHALEY AVE MILVERTON (BOSHART INDUSTRIES)',
                                 'serial': '66D53',
                                 'serial_number': '66D53',
                                 'system_mac_address': None},
                '71A4CC': {       'dev_macs': ['14:21:03:92:f1:35'],
                                  'ip_address': None,
                                  'name': '5223 Line 60 (Keith Reibeling 10400225)',
                                  'serial': '71A4CC',
                                  'serial_number': '71A4CC',
                                  'system_mac_address': None},
                '71A4CF': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5161 Line 60 (Jeanette Young 10431137)',
                                  'serial': '71A4CF',
                                  'serial_number': '71A4CF',
                                  'system_mac_address': None},
                '71A4F6': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '186 Selby Ave. Monkton (YUNDT JUD)',
                                  'serial': '71A4F6',
                                  'serial_number': '71A4F6',
                                  'system_mac_address': None},
                '71A51A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '124 Maddison St. W. Monkton (Walsh Truck '
                                          '10430198)',
                                  'serial': '71A51A',
                                  'serial_number': '71A51A',
                                  'system_mac_address': None},
                '71D7AE': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '159 Market St. Monkton (Delford Kuepfer)',
                                  'serial': '71D7AE',
                                  'serial_number': '71D7AE',
                                  'system_mac_address': None},
                '71D894': {       'dev_macs': [       '00:03:e6:db:4c:3c',
                                                      '00:03:e6:db:b7:34'],
                                  'ip_address': None,
                                  'name': '142 Queen St. Line 57 Monkton (Connie Bull)',
                                  'serial': '71D894',
                                  'serial_number': '71D894',
                                  'system_mac_address': None},
                '722207': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '168 Winstanley St. Monkton (Don Buchanan)',
                                  'serial': '722207',
                                  'serial_number': '722207',
                                  'system_mac_address': None},
                '7233EA': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '20 Schade St. Monkton (Ruby Rennick)',
                                  'serial': '7233EA',
                                  'serial_number': '7233EA',
                                  'system_mac_address': None},
                '724AD0': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6208 Rd. 164 Monkton (Ginny White)',
                                  'serial': '724AD0',
                                  'serial_number': '724AD0',
                                  'system_mac_address': None},
                '757AD': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '10A Temperance St. Milverton (Julie '
                                         'Gallinger)',
                                 'serial': '757AD',
                                 'serial_number': '757AD',
                                 'system_mac_address': None},
                '75C1DC': {       'dev_macs': ['18:fd:74:0b:c4:d1'],
                                  'ip_address': None,
                                  'name': '93 Main St. N. Milverton (Milverton Vet '
                                          'Clinic 10400849)',
                                  'serial': '75C1DC',
                                  'serial_number': '75C1DC',
                                  'system_mac_address': None},
                '769C1C': {       'dev_macs': ['60:db:98:81:fd:0c'],
                                  'ip_address': None,
                                  'name': '89 Schade St., Monkton (Gord &Helen Young)',
                                  'serial': '769C1C',
                                  'serial_number': '769C1C',
                                  'system_mac_address': None},
                '76B064': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '205 King Ave, Monkton (Mervin Subject)',
                                  'serial': '76B064',
                                  'serial_number': '76B064',
                                  'system_mac_address': None},
                '76D052': {       'dev_macs': ['d0:76:8f:02:f1:1d'],
                                  'ip_address': None,
                                  'name': '86 REAGAN ST (YANTZI MARCUS)',
                                  'serial': '76D052',
                                  'serial_number': '76D052',
                                  'system_mac_address': None},
                '76EDCD': {       'dev_macs': ['d0:76:8f:02:f5:27'],
                                  'ip_address': None,
                                  'name': '189 QUEEN AVENUE MONKTON (MORRISON COLTON)',
                                  'serial': '76EDCD',
                                  'serial_number': '76EDCD',
                                  'system_mac_address': None},
                '7E0E9': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '47 Schade St. Monkton (Fay Baker)',
                                 'serial': '7E0E9',
                                 'serial_number': '7E0E9',
                                 'system_mac_address': None},
                '7E0ED': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '51 SCHADE ST (JAKOBSEN SOREN & LEAH)',
                                 'serial': '7E0ED',
                                 'serial_number': '7E0ED',
                                 'system_mac_address': None},
                '7E210': {       'dev_macs': ['d0:76:8f:02:f6:0e'],
                                 'ip_address': None,
                                 'name': '125 BROCK STREET MONKTON (QUACKENBUSH PARKER '
                                         '10436791)',
                                 'serial': '7E210',
                                 'serial_number': '7E210',
                                 'system_mac_address': None},
                '800A9': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '221 Winstanley St. Monkton',
                                 'serial': '800A9',
                                 'serial_number': '800A9',
                                 'system_mac_address': None},
                '82A532': {       'dev_macs': ['d0:76:8f:02:f5:8a'],
                                  'ip_address': None,
                                  'name': '15 JO-LENE CT (HALE RICK)',
                                  'serial': '82A532',
                                  'serial_number': '82A532',
                                  'system_mac_address': None},
                '82A696': {       'dev_macs': ['d0:76:8f:02:f3:b1'],
                                  'ip_address': None,
                                  'name': '66 GERBER DR (SCHEERER JEFF & KAREN)',
                                  'serial': '82A696',
                                  'serial_number': '82A696',
                                  'system_mac_address': None},
                '82A6CB': {       'dev_macs': ['ec:4f:82:a4:92:12'],
                                  'ip_address': None,
                                  'name': '23 WINSTANLEY ST (HEIBEIN SHERRY)',
                                  'serial': '82A6CB',
                                  'serial_number': '82A6CB',
                                  'system_mac_address': None},
                '82A741': {       'dev_macs': ['f4:e2:c6:f2:3a:e9'],
                                  'ip_address': None,
                                  'name': '5960 PERTH RD 119 (715276 ONTARIO INC)',
                                  'serial': '82A741',
                                  'serial_number': '82A741',
                                  'system_mac_address': None},
                '82A750': {       'dev_macs': ['d0:76:8f:02:f3:22'],
                                  'ip_address': None,
                                  'name': '88 MILL ST E (GASCHO BRIAN & LIZ)',
                                  'serial': '82A750',
                                  'serial_number': '82A750',
                                  'system_mac_address': None},
                '844BBE': {       'dev_macs': ['60:db:98:55:bb:2f'],
                                  'ip_address': None,
                                  'name': '20 WEST ST (SCHNEIDER EVAN)',
                                  'serial': '844BBE',
                                  'serial_number': '844BBE',
                                  'system_mac_address': None},
                '844BC7': {       'dev_macs': ['d0:76:8f:02:f0:c5'],
                                  'ip_address': None,
                                  'name': '5163 ROAD 140 (WHITE JOSEPH)',
                                  'serial': '844BC7',
                                  'serial_number': '844BC7',
                                  'system_mac_address': None},
                '844BD6': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6466 PERTH ROAD 131 (WALL FRANK)',
                                  'serial': '844BD6',
                                  'serial_number': '844BD6',
                                  'system_mac_address': None},
                '844BEE': {       'dev_macs': ['24:f5:a2:a3:14:e0'],
                                  'ip_address': None,
                                  'name': '5136 LINE 49 (BAUER ELONA)',
                                  'serial': '844BEE',
                                  'serial_number': '844BEE',
                                  'system_mac_address': None},
                '844BEF': {       'dev_macs': ['cc:f4:11:60:9e:a9'],
                                  'ip_address': None,
                                  'name': '83 REAGAN ST (RUAN ZHIHENG)',
                                  'serial': '844BEF',
                                  'serial_number': '844BEF',
                                  'system_mac_address': None},
                '844BF5': {       'dev_macs': ['d0:76:8f:02:ef:bd'],
                                  'ip_address': None,
                                  'name': '7 MURRAY CT (JOSE NAJMA)',
                                  'serial': '844BF5',
                                  'serial_number': '844BF5',
                                  'system_mac_address': None},
                '845909': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '211 SELBY AV (HENRY NATHAN)',
                                  'serial': '845909',
                                  'serial_number': '845909',
                                  'system_mac_address': None},
                '845BB4': {       'dev_macs': [       '5c:0f:fb:17:68:76',
                                                      '5c:0f:fb:17:72:46'],
                                  'ip_address': None,
                                  'name': '193 QUEEN AVE (EARL JEFF & SUE)',
                                  'serial': '845BB4',
                                  'serial_number': '845BB4',
                                  'system_mac_address': None},
                '8678A2': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 MAIN ST S (KUEPFER RACHEL)',
                                  'serial': '8678A2',
                                  'serial_number': '8678A2',
                                  'system_mac_address': None},
                '869226': {       'dev_macs': ['d0:76:8f:02:ee:9f'],
                                  'ip_address': None,
                                  'name': '65 GERBER DR (NORRIS DEANNE)',
                                  'serial': '869226',
                                  'serial_number': '869226',
                                  'system_mac_address': None},
                '869271': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5317 ROAD 144 (GRAUL RODNEY)',
                                  'serial': '869271',
                                  'serial_number': '869271',
                                  'system_mac_address': None},
                '869376': {       'dev_macs': ['d0:76:8f:1f:58:c7'],
                                  'ip_address': None,
                                  'name': '85 GERBER DR (SNYDER ASHLEY)',
                                  'serial': '869376',
                                  'serial_number': '869376',
                                  'system_mac_address': None},
                '869384': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5922 SOMERSET DR (WAGLER CHRISTOPHER & '
                                          'ROSALIND)',
                                  'serial': '869384',
                                  'serial_number': '869384',
                                  'system_mac_address': None},
                '869385': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '208 Selby Av (Stephanie Priestap 10436138)',
                                  'serial': '869385',
                                  'serial_number': '869385',
                                  'system_mac_address': None},
                '86938A': {       'dev_macs': ['d0:76:8f:1f:5a:69'],
                                  'ip_address': None,
                                  'name': '21 MURRAY CT (ARMSTRONG SAMANTHA)',
                                  'serial': '86938A',
                                  'serial_number': '86938A',
                                  'system_mac_address': None},
                '8693A0': {       'dev_macs': ['d0:76:8f:1f:63:38'],
                                  'ip_address': None,
                                  'name': '162 Winstanley St. Monkton (Jessie '
                                          'Buchanan)',
                                  'serial': '8693A0',
                                  'serial_number': '8693A0',
                                  'system_mac_address': None},
                '8693A1': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6250 PERTH ROAD 131 (RAYCRAFT KEN & '
                                          'DARLENE)',
                                  'serial': '8693A1',
                                  'serial_number': '8693A1',
                                  'system_mac_address': None},
                '8693A5': {       'dev_macs': ['60:db:98:09:1c:67'],
                                  'ip_address': None,
                                  'name': '5597 DUKE ST (HIGGS TERRY)',
                                  'serial': '8693A5',
                                  'serial_number': '8693A5',
                                  'system_mac_address': None},
                '8693A7': {       'dev_macs': ['cc:be:59:2f:2d:12'],
                                  'ip_address': None,
                                  'name': '55 WILLIAM ST (CONLAN MANDY)',
                                  'serial': '8693A7',
                                  'serial_number': '8693A7',
                                  'system_mac_address': None},
                '8693AC': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '10400848 (GERBER STAN & ERMA)',
                                  'serial': '8693AC',
                                  'serial_number': '8693AC',
                                  'system_mac_address': None},
                '8693AF': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6146 ROAD 136 (KUEPFER GERALD & DARLENE)',
                                  'serial': '8693AF',
                                  'serial_number': '8693AF',
                                  'system_mac_address': None},
                '8693B2': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5931 SOMERSET DR (LICHTY HOWARD)',
                                  'serial': '8693B2',
                                  'serial_number': '8693B2',
                                  'system_mac_address': None},
                '8693B5': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5940 PERTH ROAD 119 (FRIJTERS MARIETTE)',
                                  'serial': '8693B5',
                                  'serial_number': '8693B5',
                                  'system_mac_address': None},
                '8693B9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5923 SOMERSET DR (NAFZIGER WAYNE)',
                                  'serial': '8693B9',
                                  'serial_number': '8693B9',
                                  'system_mac_address': None},
                '8693BC': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4540 LINE 61 (BUCHAN SCOTT)',
                                  'serial': '8693BC',
                                  'serial_number': '8693BC',
                                  'system_mac_address': None},
                '8693BE': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4994 PERTH LINE 55 (ZEHR SUSAN)',
                                  'serial': '8693BE',
                                  'serial_number': '8693BE',
                                  'system_mac_address': None},
                '8693C0': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5592 ROAD 126 (KOBUS DAN & BECCA)',
                                  'serial': '8693C0',
                                  'serial_number': '8693C0',
                                  'system_mac_address': None},
                '8693C3': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': 'Beside the Still Water',
                                  'serial': '8693C3',
                                  'serial_number': '8693C3',
                                  'system_mac_address': None},
                '8693C5': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': 'THOMAS DAHM (1-3 MADDISON ST E MONKTON)',
                                  'serial': '8693C5',
                                  'serial_number': '8693C5',
                                  'system_mac_address': None},
                '8693C7': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5940 PERTH ROAD 119 (HUBER RACHEL)',
                                  'serial': '8693C7',
                                  'serial_number': '8693C7',
                                  'system_mac_address': None},
                '8693CC': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '7 Cruikshank St. Milverton',
                                  'serial': '8693CC',
                                  'serial_number': '8693CC',
                                  'system_mac_address': None},
                '8693CE': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4868 LINE 49 (DEGROOT TY)',
                                  'serial': '8693CE',
                                  'serial_number': '8693CE',
                                  'system_mac_address': None},
                '8693D0': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6112 ANA ST (CRESSMAN STEVE & JUDY)',
                                  'serial': '8693D0',
                                  'serial_number': '8693D0',
                                  'system_mac_address': None},
                '8693D2': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4861 PERTH LINE 55 (ZOOK EPHRAIM)',
                                  'serial': '8693D2',
                                  'serial_number': '8693D2',
                                  'system_mac_address': None},
                '8693D8': {       'dev_macs': ['d0:76:8f:02:ef:a7'],
                                  'ip_address': None,
                                  'name': '5438 Line 60 (CARTER MIKE & BEV)',
                                  'serial': '8693D8',
                                  'serial_number': '8693D8',
                                  'system_mac_address': None},
                '8693D9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5934 PERTH ROAD 119 (YANTZI RHODA)',
                                  'serial': '8693D9',
                                  'serial_number': '8693D9',
                                  'system_mac_address': None},
                '8693DA': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5922 PERTH ROAD 119 (NAFZIGER TOM & ALYCIA)',
                                  'serial': '8693DA',
                                  'serial_number': '8693DA',
                                  'system_mac_address': None},
                '8693DE': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4977 PERTH LINE 55 (MOGK BROTHERS)',
                                  'serial': '8693DE',
                                  'serial_number': '8693DE',
                                  'system_mac_address': None},
                '8693E0': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6127 ANA ST (NAFZIGER KEN)',
                                  'serial': '8693E0',
                                  'serial_number': '8693E0',
                                  'system_mac_address': None},
                '8693E1': {       'dev_macs': [       'cc:be:59:c3:52:9a',
                                                      '04:42:1a:7a:b7:88',
                                                      '38:c0:ea:44:be:46'],
                                  'ip_address': None,
                                  'name': '209 NELSON STREET (MUNICIPALITY OF NORTH '
                                          'PERTH)',
                                  'serial': '8693E1',
                                  'serial_number': '8693E1',
                                  'system_mac_address': None},
                '8693E3': {       'dev_macs': ['b8:94:70:f3:e9:26'],
                                  'ip_address': None,
                                  'name': '5940 PERTH ROAD 119 (BANNON JOANNE)',
                                  'serial': '8693E3',
                                  'serial_number': '8693E3',
                                  'system_mac_address': None},
                '8693E4': {       'dev_macs': ['d0:76:8f:02:f4:da'],
                                  'ip_address': None,
                                  'name': '75 REAGAN ST (MILLER PATRICK)',
                                  'serial': '8693E4',
                                  'serial_number': '8693E4',
                                  'system_mac_address': None},
                '8693EE': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6212 PERTH ROAD 131 (MCCORMACK KELLY)',
                                  'serial': '8693EE',
                                  'serial_number': '8693EE',
                                  'system_mac_address': None},
                '8693F1': {       'dev_macs': ['d0:76:8f:1f:65:27'],
                                  'ip_address': None,
                                  'name': '5927 SOMERSET DR (HALLAHAN JAMIE & LAURA)',
                                  'serial': '8693F1',
                                  'serial_number': '8693F1',
                                  'system_mac_address': None},
                '8693F4': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4731 PERTH LINE 55 (SLITS PEDRO & JOLANDA)',
                                  'serial': '8693F4',
                                  'serial_number': '8693F4',
                                  'system_mac_address': None},
                '8693F5': {       'dev_macs': ['60:db:98:55:ba:c1'],
                                  'ip_address': None,
                                  'name': '6 West St. Milverton (MCLAUGHLIN CAMERON)',
                                  'serial': '8693F5',
                                  'serial_number': '8693F5',
                                  'system_mac_address': None},
                '8693F9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4728 PERTH LINE 55 (KUNTZE HOWARD)',
                                  'serial': '8693F9',
                                  'serial_number': '8693F9',
                                  'system_mac_address': None},
                '8693FA': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '89 REAGAN ST MILVERTON (VINK JASON)',
                                  'serial': '8693FA',
                                  'serial_number': '8693FA',
                                  'system_mac_address': None},
                '8693FB': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6108 ANA ST (DUNN ROBIN & WENDY)',
                                  'serial': '8693FB',
                                  'serial_number': '8693FB',
                                  'system_mac_address': None},
                '8693FD': {       'dev_macs': ['ec:4f:82:ac:ed:c9'],
                                  'ip_address': None,
                                  'name': '81 GERBER DR (MARSHALL GLEN)',
                                  'serial': '8693FD',
                                  'serial_number': '8693FD',
                                  'system_mac_address': None},
                '869400': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4631 PERTH LINE 55 (ROPP TITUS)',
                                  'serial': '869400',
                                  'serial_number': '869400',
                                  'system_mac_address': None},
                '869402': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4561 LINE 61 (LUPTON MACKENZIE (MAC))',
                                  'serial': '869402',
                                  'serial_number': '869402',
                                  'system_mac_address': None},
                '869404': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5916 PERTH ROAD 119 (ROTH DERRICK)',
                                  'serial': '869404',
                                  'serial_number': '869404',
                                  'system_mac_address': None},
                '869407': {       'dev_macs': ['cc:be:59:32:95:5e'],
                                  'ip_address': None,
                                  'name': '55 WILLIAM ST (GRAVES ANDREA)',
                                  'serial': '869407',
                                  'serial_number': '869407',
                                  'system_mac_address': None},
                '869408': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '154 SMITH ST (GINGERICH BRAEDEN)',
                                  'serial': '869408',
                                  'serial_number': '869408',
                                  'system_mac_address': None},
                '869409': {       'dev_macs': ['60:db:98:09:36:c9'],
                                  'ip_address': None,
                                  'name': '4509 LINE 61 (KUEPFER ALVIN)',
                                  'serial': '869409',
                                  'serial_number': '869409',
                                  'system_mac_address': None},
                '86940A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4821 PERTH LINE 55 (LOOSER CHRIS)',
                                  'serial': '86940A',
                                  'serial_number': '86940A',
                                  'system_mac_address': None},
                '86940E': {       'dev_macs': ['14:21:03:a9:72:8e'],
                                  'ip_address': None,
                                  'name': '5926 SOMERSET DR (HARRIS  STEVE)',
                                  'serial': '86940E',
                                  'serial_number': '86940E',
                                  'system_mac_address': None},
                '86940F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '12 WILLIAM ST',
                                  'serial': '86940F',
                                  'serial_number': '86940F',
                                  'system_mac_address': None},
                '869410': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5375 Road 144 Brunner (W & J Paxton '
                                          '10400532)',
                                  'serial': '869410',
                                  'serial_number': '869410',
                                  'system_mac_address': None},
                '869415': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5241 LINE 58 (BANNON NIKKI)',
                                  'serial': '869415',
                                  'serial_number': '869415',
                                  'system_mac_address': None},
                '869418': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '36 MAIN ST S (JOHNSON JAMIE & HEIDI)',
                                  'serial': '869418',
                                  'serial_number': '869418',
                                  'system_mac_address': None},
                '86941A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '70 GERBER DR (DARASCH SAMANTHA)',
                                  'serial': '86941A',
                                  'serial_number': '86941A',
                                  'system_mac_address': None},
                '869424': {       'dev_macs': ['60:db:98:09:1c:eb'],
                                  'ip_address': None,
                                  'name': '184 SELBY AV (BOYD DON)',
                                  'serial': '869424',
                                  'serial_number': '869424',
                                  'system_mac_address': None},
                '869427': {       'dev_macs': [       '00:03:e6:dd:46:4a',
                                                      '00:03:e6:eb:4b:14',
                                                      'd0:76:8f:02:ee:10'],
                                  'ip_address': None,
                                  'name': '79 REAGAN ST (ALVAREZ JOE)',
                                  'serial': '869427',
                                  'serial_number': '869427',
                                  'system_mac_address': None},
                '86942F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6109 ANA ST (WALL GEORGE (ESTATE OF))',
                                  'serial': '86942F',
                                  'serial_number': '86942F',
                                  'system_mac_address': None},
                '869431': {       'dev_macs': ['d0:76:8f:1f:65:8a'],
                                  'ip_address': None,
                                  'name': '90 REAGAN ST (GRAHAM DAVE)',
                                  'serial': '869431',
                                  'serial_number': '869431',
                                  'system_mac_address': None},
                '869432': {       'dev_macs': ['cc:be:59:2d:a3:be'],
                                  'ip_address': None,
                                  'name': '50 MAIN ST N (CAMERON JEFF)',
                                  'serial': '869432',
                                  'serial_number': '869432',
                                  'system_mac_address': None},
                '86946D': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6137 PERTH ROAD 131 (HADDOW BRIAN & REID)',
                                  'serial': '86946D',
                                  'serial_number': '86946D',
                                  'system_mac_address': None},
                '869473': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5929 SOMERSET DR (GERBER TOM & SHARON)',
                                  'serial': '869473',
                                  'serial_number': '869473',
                                  'system_mac_address': None},
                '869474': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4643 PERTH LINE 55 (REIS COURTNEY)',
                                  'serial': '869474',
                                  'serial_number': '869474',
                                  'system_mac_address': None},
                '869484': {       'dev_macs': ['d0:76:8f:02:ee:e1'],
                                  'ip_address': None,
                                  'name': '9 MURRAY CT (GREER SANDRA)',
                                  'serial': '869484',
                                  'serial_number': '869484',
                                  'system_mac_address': None},
                '86948C': {       'dev_macs': ['60:db:98:09:37:e7'],
                                  'ip_address': None,
                                  'name': '93 Reagan St Milverton (VANT VOORT M & C)',
                                  'serial': '86948C',
                                  'serial_number': '86948C',
                                  'system_mac_address': None},
                '869492': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4509 LINE 61 (LEGACY STONE INC)',
                                  'serial': '869492',
                                  'serial_number': '869492',
                                  'system_mac_address': None},
                '8704F': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '71 Mill St. E. Milverton (Valerie Yost '
                                         '10430631)',
                                 'serial': '8704F',
                                 'serial_number': '8704F',
                                 'system_mac_address': None},
                '87241E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '15 Main St. N. Milverton (Brenda Robertson)',
                                  'serial': '87241E',
                                  'serial_number': '87241E',
                                  'system_mac_address': None},
                '872420': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': "4679 LINE 61 (GJ'S HARVEST CENTRE INC.)",
                                  'serial': '872420',
                                  'serial_number': '872420',
                                  'system_mac_address': None},
                '872431': {       'dev_macs': ['60:db:98:09:37:b0'],
                                  'ip_address': None,
                                  'name': '15 MURRAY CT (BOWMAN JOHN)',
                                  'serial': '872431',
                                  'serial_number': '872431',
                                  'system_mac_address': None},
                '872432': {       'dev_macs': ['ec:4f:82:a9:a8:81'],
                                  'ip_address': None,
                                  'name': '5227 Line 60 (Mike Schultz 10421360)',
                                  'serial': '872432',
                                  'serial_number': '872432',
                                  'system_mac_address': None},
                '872435': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6104 RD 140 (DYCK PETER)',
                                  'serial': '872435',
                                  'serial_number': '872435',
                                  'system_mac_address': None},
                '872445': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '16 JOHN ST (ALBRECHT MIKE)',
                                  'serial': '872445',
                                  'serial_number': '872445',
                                  'system_mac_address': None},
                '872483': {       'dev_macs': ['f4:92:bf:8d:a7:f8'],
                                  'ip_address': None,
                                  'name': 'PERCON NEW SHOP 10434163 (4679 LINE 61)',
                                  'serial': '872483',
                                  'serial_number': '872483',
                                  'system_mac_address': None},
                '872484': {       'dev_macs': ['60:db:98:0c:d1:09'],
                                  'ip_address': None,
                                  'name': '6113 ANA ST (ERB DARYL)',
                                  'serial': '872484',
                                  'serial_number': '872484',
                                  'system_mac_address': None},
                '8724DE': {       'dev_macs': ['44:65:7f:88:d6:7b'],
                                  'ip_address': None,
                                  'name': '5376 LINE 49 (RIDLEY RYAN)',
                                  'serial': '8724DE',
                                  'serial_number': '8724DE',
                                  'system_mac_address': None},
                '8724EA': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '20 MILL ST E (FRESHNUP INC.)',
                                  'serial': '8724EA',
                                  'serial_number': '8724EA',
                                  'system_mac_address': None},
                '8724F3': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6168 RD 124 MILVERTON (SCHULTZ LONNIE)',
                                  'serial': '8724F3',
                                  'serial_number': '8724F3',
                                  'system_mac_address': None},
                '872503': {       'dev_macs': ['14:21:03:92:f0:17'],
                                  'ip_address': None,
                                  'name': '7 FULTON ST (KOCH JEREMY)',
                                  'serial': '872503',
                                  'serial_number': '872503',
                                  'system_mac_address': None},
                '872506': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5368 PERTH ROAD 135 (DIEHL BRAD)',
                                  'serial': '872506',
                                  'serial_number': '872506',
                                  'system_mac_address': None},
                '872507': {       'dev_macs': ['04:bc:9f:46:ac:6e'],
                                  'ip_address': None,
                                  'name': '17 MURRAY CT (AUSTIN MICHELLE)',
                                  'serial': '872507',
                                  'serial_number': '872507',
                                  'system_mac_address': None},
                '87250A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5267 ROAD 144 (GRAUL STEVE)',
                                  'serial': '87250A',
                                  'serial_number': '87250A',
                                  'system_mac_address': None},
                '87250E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6283 ROAD 124 (BAUMAN GREG)',
                                  'serial': '87250E',
                                  'serial_number': '87250E',
                                  'system_mac_address': None},
                '87250F': {       'dev_macs': ['ec:4f:82:2d:2f:c8'],
                                  'ip_address': None,
                                  'name': '4 MAIN ST S (BURGER AELAURA)',
                                  'serial': '87250F',
                                  'serial_number': '87250F',
                                  'system_mac_address': None},
                '872514': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '19 MURRAY CT MILVERTON (RIDDELL VANESSA)',
                                  'serial': '872514',
                                  'serial_number': '872514',
                                  'system_mac_address': None},
                '872524': {       'dev_macs': ['34:56:fe:2c:cc:ab'],
                                  'ip_address': None,
                                  'name': '4481 PERTH LINE 72 NEWTON (MITCHELL MILL '
                                          'SYSTEMS)',
                                  'serial': '872524',
                                  'serial_number': '872524',
                                  'system_mac_address': None},
                '872544': {       'dev_macs': ['14:21:03:d1:7d:6d'],
                                  'ip_address': None,
                                  'name': '10 MAIN ST N APT 2 (STREICHER DUSTIN)',
                                  'serial': '872544',
                                  'serial_number': '872544',
                                  'system_mac_address': None},
                '87254B': {       'dev_macs': ['d0:76:8f:1f:54:de'],
                                  'ip_address': None,
                                  'name': '6161 ROAD 124 (JANTZI BEN)',
                                  'serial': '87254B',
                                  'serial_number': '87254B',
                                  'system_mac_address': None},
                '872553': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6202 ROAD 148 (JANTZI SHAWN)',
                                  'serial': '872553',
                                  'serial_number': '872553',
                                  'system_mac_address': None},
                '872558': {       'dev_macs': ['b8:94:70:f3:e4:c4'],
                                  'ip_address': None,
                                  'name': '13 MURRAY CT (DOST MATTHEW)',
                                  'serial': '872558',
                                  'serial_number': '872558',
                                  'system_mac_address': None},
                '87257E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '11 MURRAY CT (ALBRECHT NIKKETA)',
                                  'serial': '87257E',
                                  'serial_number': '87257E',
                                  'system_mac_address': None},
                '87414': {       'dev_macs': ['b8:94:70:99:4d:4b'],
                                 'ip_address': None,
                                 'name': '148 Winstanley St. Monkton (Stan & Glenda '
                                         'Stolz 10430578)',
                                 'serial': '87414',
                                 'serial_number': '87414',
                                 'system_mac_address': None},
                '87F8BD': {       'dev_macs': ['d0:76:8f:1f:63:b1'],
                                  'ip_address': None,
                                  'name': '85A MILL ST E (KNUDSEN KAREN)',
                                  'serial': '87F8BD',
                                  'serial_number': '87F8BD',
                                  'system_mac_address': None},
                '87F965': {       'dev_macs': ['d0:76:8f:1f:54:0d'],
                                  'ip_address': None,
                                  'name': '18 Mill St. W. (MCCL Shop)',
                                  'serial': '87F965',
                                  'serial_number': '87F965',
                                  'system_mac_address': None},
                '885E5': {       'dev_macs': ['b0:6e:bf:95:30:18'],
                                 'ip_address': None,
                                 'name': '73 Mill St. E. Milverton (Theresa Hopf)',
                                 'serial': '885E5',
                                 'serial_number': '885E5',
                                 'system_mac_address': None},
                '8888F': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '93 Mill St. E. Milverton (Dan Crowley)',
                                 'serial': '8888F',
                                 'serial_number': '8888F',
                                 'system_mac_address': None},
                '888A5': {       'dev_macs': ['d0:76:8f:02:ee:05'],
                                 'ip_address': None,
                                 'name': '103 Mill St. E. Milverton (Jim Harloff)',
                                 'serial': '888A5',
                                 'serial_number': '888A5',
                                 'system_mac_address': None},
                '888F2': {       'dev_macs': ['d0:76:8f:02:ef:18'],
                                 'ip_address': None,
                                 'name': '107 Mill St. E. Milverton (Alvin Streicher)',
                                 'serial': '888F2',
                                 'serial_number': '888F2',
                                 'system_mac_address': None},
                '888F5': {       'dev_macs': ['bc:22:28:df:fb:c7'],
                                 'ip_address': None,
                                 'name': '99 Mill St. E. Milverton (C. '
                                         'Winegarden-Bynsdrop 10430437)',
                                 'serial': '888F5',
                                 'serial_number': '888F5',
                                 'system_mac_address': None},
                '888FA': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '75 Mill St. E. Milverton (Louise Campbell)',
                                 'serial': '888FA',
                                 'serial_number': '888FA',
                                 'system_mac_address': None},
                '88925': {       'dev_macs': ['60:db:98:09:1d:bc'],
                                 'ip_address': None,
                                 'name': '105 Mill St. E. Milverton (Ted Newman)',
                                 'serial': '88925',
                                 'serial_number': '88925',
                                 'system_mac_address': None},
                '88929': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '31 Mill St. E. Milverton (Dave Brand)',
                                 'serial': '88929',
                                 'serial_number': '88929',
                                 'system_mac_address': None},
                '8894F': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '48 GERBER DR (BAILLIE TERRY)',
                                 'serial': '8894F',
                                 'serial_number': '8894F',
                                 'system_mac_address': None},
                '88971': {       'dev_macs': ['00:03:e6:a1:c2:26'],
                                 'ip_address': None,
                                 'name': '43 Mill St. E. Milverton (Micheal Luckhardt '
                                         '10423461)',
                                 'serial': '88971',
                                 'serial_number': '88971',
                                 'system_mac_address': None},
                '889A5': {       'dev_macs': ['cc:be:59:32:94:1a'],
                                 'ip_address': None,
                                 'name': '97 Mill St. E. Milverton (Scott Steckly '
                                         '10402469)',
                                 'serial': '889A5',
                                 'serial_number': '889A5',
                                 'system_mac_address': None},
                '889A6': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '47 Gerber Dr. Milverton (Ron Hanna)',
                                 'serial': '889A6',
                                 'serial_number': '889A6',
                                 'system_mac_address': None},
                '889B7': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '8 Gerber Ct. Milverton (Maynard Streicher)',
                                 'serial': '889B7',
                                 'serial_number': '889B7',
                                 'system_mac_address': None},
                '889BA': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '4495 LINE 64 (KUEPFER KEN & CHRISTENA)',
                                 'serial': '889BA',
                                 'serial_number': '889BA',
                                 'system_mac_address': None},
                '889BD': {       'dev_macs': ['60:db:98:82:08:0c'],
                                 'ip_address': None,
                                 'name': '24 Gerber Dr. Milverton (Mark Matheson)',
                                 'serial': '889BD',
                                 'serial_number': '889BD',
                                 'system_mac_address': None},
                '889C1': {       'dev_macs': ['c8:9e:43:d6:7a:0a'],
                                 'ip_address': None,
                                 'name': '55 Mill St. E. Milverton (Kelly Hargrave '
                                         '10434003)',
                                 'serial': '889C1',
                                 'serial_number': '889C1',
                                 'system_mac_address': None},
                '889D1': {       'dev_macs': ['48:77:46:9a:56:1f'],
                                 'ip_address': None,
                                 'name': '37 MILL ST E (HORTON LEXY)',
                                 'serial': '889D1',
                                 'serial_number': '889D1',
                                 'system_mac_address': None},
                '889DE': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '109 Mill St. E. Milverton (Murray Stewart)',
                                 'serial': '889DE',
                                 'serial_number': '889DE',
                                 'system_mac_address': None},
                '889E1': {       'dev_macs': ['ec:4f:82:2b:47:fd'],
                                 'ip_address': None,
                                 'name': '83 MILL ST E (PAJOT MIKE)',
                                 'serial': '889E1',
                                 'serial_number': '889E1',
                                 'system_mac_address': None},
                '889E2': {       'dev_macs': ['d0:76:8f:1f:5c:16'],
                                 'ip_address': None,
                                 'name': '36 GERBER DR (PARKER JIM & SHEILA)',
                                 'serial': '889E2',
                                 'serial_number': '889E2',
                                 'system_mac_address': None},
                '889E6': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '56 Mill St. E. Milverton (Mark Gingerich '
                                         '10432800)',
                                 'serial': '889E6',
                                 'serial_number': '889E6',
                                 'system_mac_address': None},
                '889E7': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '10B TEMPERANCE STREET (PATERSON JOE & '
                                         'SHARON)',
                                 'serial': '889E7',
                                 'serial_number': '889E7',
                                 'system_mac_address': None},
                '889E9': {       'dev_macs': ['70:8b:cd:60:08:0c'],
                                 'ip_address': None,
                                 'name': '2 St. Marys St. S. Milverton (Darcy Bauman '
                                         '10433545)',
                                 'serial': '889E9',
                                 'serial_number': '889E9',
                                 'system_mac_address': None},
                '889EA': {       'dev_macs': ['b8:94:70:9e:cc:54'],
                                 'ip_address': None,
                                 'name': '87 Mill St. E. Milverton (David Kuehn)',
                                 'serial': '889EA',
                                 'serial_number': '889EA',
                                 'system_mac_address': None},
                '889EC': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '65 Mill St. E. Milverton',
                                 'serial': '889EC',
                                 'serial_number': '889EC',
                                 'system_mac_address': None},
                '889EF': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '28 Gerber Dr. Milverton (Norman Steckly)',
                                 'serial': '889EF',
                                 'serial_number': '889EF',
                                 'system_mac_address': None},
                '889F1': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '52 Gerber Dr. Milverton (Urius Bowman)',
                                 'serial': '889F1',
                                 'serial_number': '889F1',
                                 'system_mac_address': None},
                '889FD': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '12 JO-LENE CT (WOODTHORPE STEPHEN)',
                                 'serial': '889FD',
                                 'serial_number': '889FD',
                                 'system_mac_address': None},
                '88A00': {       'dev_macs': ['5c:0f:fb:2a:0b:d2'],
                                 'ip_address': None,
                                 'name': '33 Mill st. E. Milverton (Frank Huras)',
                                 'serial': '88A00',
                                 'serial_number': '88A00',
                                 'system_mac_address': None},
                '88A05': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '49 Mill St. E. Milverton (Bill Dale)',
                                 'serial': '88A05',
                                 'serial_number': '88A05',
                                 'system_mac_address': None},
                '88A1E': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '8 Colbalt St. S. Milverton (Elroy Horst)',
                                 'serial': '88A1E',
                                 'serial_number': '88A1E',
                                 'system_mac_address': None},
                '88A1F': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '53 Mill St. E. Milverton (Clark Moore '
                                         '10401228)',
                                 'serial': '88A1F',
                                 'serial_number': '88A1F',
                                 'system_mac_address': None},
                '8A06D': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '4 Gerber Dr. Milverton (Sean McCurdy)',
                                 'serial': '8A06D',
                                 'serial_number': '8A06D',
                                 'system_mac_address': None},
                '8A076': {       'dev_macs': ['f0:79:59:c8:1f:de'],
                                 'ip_address': None,
                                 'name': '16 Gerber Dr. Milverton (Peter Flanagan)',
                                 'serial': '8A076',
                                 'serial_number': '8A076',
                                 'system_mac_address': None},
                '8A090': {       'dev_macs': ['ec:4f:82:2d:32:47'],
                                 'ip_address': None,
                                 'name': '7 Gerber Dr. Milverton (Murray Pfeifer)',
                                 'serial': '8A090',
                                 'serial_number': '8A090',
                                 'system_mac_address': None},
                '8A231': {       'dev_macs': [       '00:03:e6:db:2f:90',
                                                     '00:03:e6:db:30:de',
                                                     'cc:be:59:32:95:9d'],
                                 'ip_address': None,
                                 'name': '77 Mill St. E. Milverton (Josh Ludwig, '
                                         '10431732)',
                                 'serial': '8A231',
                                 'serial_number': '8A231',
                                 'system_mac_address': None},
                '8A28C': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '109B Mill St. E. Milverton (Paul Jantzi '
                                         '10403500)',
                                 'serial': '8A28C',
                                 'serial_number': '8A28C',
                                 'system_mac_address': None},
                '8BDC8': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '3 GERBER DR (SCHMIDT CALVIN)',
                                 'serial': '8BDC8',
                                 'serial_number': '8BDC8',
                                 'system_mac_address': None},
                '8C300': {       'dev_macs': ['60:db:98:09:2c:63'],
                                 'ip_address': None,
                                 'name': '61 Mill St. E. Milverton (Jeff Scott)',
                                 'serial': '8C300',
                                 'serial_number': '8C300',
                                 'system_mac_address': None},
                '8E109': {       'dev_macs': ['60:db:98:09:2e:73'],
                                 'ip_address': None,
                                 'name': '69 Mill St. E. Milverton (Lois McEwin '
                                         '10401294)',
                                 'serial': '8E109',
                                 'serial_number': '8E109',
                                 'system_mac_address': None},
                '956DA6': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '213 Selby Ave, Monkton (Craig Burek '
                                          '10435498)',
                                  'serial': '956DA6',
                                  'serial_number': '956DA6',
                                  'system_mac_address': None},
                '956E58': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5095 PERTH RD 135 ROSTOCK (DEBUS JOSH)',
                                  'serial': '956E58',
                                  'serial_number': '956E58',
                                  'system_mac_address': None},
                '956E59': {       'dev_macs': ['84:d3:43:6d:e9:b1'],
                                  'ip_address': None,
                                  'name': '25 West St. Milverton (Tom Broughton '
                                          '10401292)',
                                  'serial': '956E59',
                                  'serial_number': '956E59',
                                  'system_mac_address': None},
                '956EF1': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '19 MAIN ST N Apt 1',
                                  'serial': '956EF1',
                                  'serial_number': '956EF1',
                                  'system_mac_address': None},
                '956F4A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 WILLIAM ST (WICE DAVID)',
                                  'serial': '956F4A',
                                  'serial_number': '956F4A',
                                  'system_mac_address': None},
                '956F67': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': "5920 PERTH ROAD 119 (JAY'S GARDEN GAZEBOS)",
                                  'serial': '956F67',
                                  'serial_number': '956F67',
                                  'system_mac_address': None},
                '956F75': {       'dev_macs': ['d0:76:8f:91:d5:e5'],
                                  'ip_address': None,
                                  'name': '92 REAGAN ST (KROEKER JOHN)',
                                  'serial': '956F75',
                                  'serial_number': '956F75',
                                  'system_mac_address': None},
                '956FAE': {       'dev_macs': ['d0:76:8f:91:d2:a1'],
                                  'ip_address': None,
                                  'name': '21 TEMPERANCE ST (RICHARDS MARTY)',
                                  'serial': '956FAE',
                                  'serial_number': '956FAE',
                                  'system_mac_address': None},
                '9C2EFB': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '13 MAIN ST N (FRIESEN HENRY)',
                                  'serial': '9C2EFB',
                                  'serial_number': '9C2EFB',
                                  'system_mac_address': None},
                '9C2F08': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '163 SMITH ST (FRIESEN CORNELIUS)',
                                  'serial': '9C2F08',
                                  'serial_number': '9C2F08',
                                  'system_mac_address': None},
                '9C3022': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '10 MAIN ST N (RAHMAN HABIBUR)',
                                  'serial': '9C3022',
                                  'serial_number': '9C3022',
                                  'system_mac_address': None},
                '9C3023': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '16 MAIN ST N (MILLIGAN JACKIE)',
                                  'serial': '9C3023',
                                  'serial_number': '9C3023',
                                  'system_mac_address': None},
                '9CA0D': {       'dev_macs': ['c8:4f:86:a5:0f:14'],
                                 'ip_address': None,
                                 'name': '25 Mill St. E. Milverton (Perth East Office '
                                         '10411713)',
                                 'serial': '9CA0D',
                                 'serial_number': '9CA0D',
                                 'system_mac_address': None},
                'A9C29E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '10 MAIN ST S (GERBER CAITLYN)',
                                  'serial': 'A9C29E',
                                  'serial_number': 'A9C29E',
                                  'system_mac_address': None},
                'A9C2B8': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '13 MAIN ST N',
                                  'serial': 'A9C2B8',
                                  'serial_number': 'A9C2B8',
                                  'system_mac_address': None},
                'A9C2BD': {       'dev_macs': ['d0:76:8f:02:f3:7a'],
                                  'ip_address': None,
                                  'name': '4676 Line 55 (MICHAEL GIBSON)',
                                  'serial': 'A9C2BD',
                                  'serial_number': 'A9C2BD',
                                  'system_mac_address': None},
                'A9C37D': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6A Main St. S. Milverton (ALLARD PIERRE & '
                                          'PETA)',
                                  'serial': 'A9C37D',
                                  'serial_number': 'A9C37D',
                                  'system_mac_address': None},
                'A9C3BB': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '58 MADDISON ST E (REDECOP JOHN)',
                                  'serial': 'A9C3BB',
                                  'serial_number': 'A9C3BB',
                                  'system_mac_address': None},
                'A9C3C6': {       'dev_macs': ['d0:76:8f:91:d5:cf'],
                                  'ip_address': None,
                                  'name': '39 SCHADE ST (CHANSE JORDAN)',
                                  'serial': 'A9C3C6',
                                  'serial_number': 'A9C3C6',
                                  'system_mac_address': None},
                'A9C3D2': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '128 WINSTANLEY ST (SWINKELS IAN)',
                                  'serial': 'A9C3D2',
                                  'serial_number': 'A9C3D2',
                                  'system_mac_address': None},
                'A9C3E8': {       'dev_macs': ['60:db:98:55:bb:a8'],
                                  'ip_address': None,
                                  'name': '21 WILLIAM ST (WAGNER ASHLEY)',
                                  'serial': 'A9C3E8',
                                  'serial_number': 'A9C3E8',
                                  'system_mac_address': None},
                'A9C40E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '63 GERBER DR (FALCONER DAVE)',
                                  'serial': 'A9C40E',
                                  'serial_number': 'A9C40E',
                                  'system_mac_address': None},
                'A9C41B': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '59 WILLIAM ST (MARTIN RENITA)',
                                  'serial': 'A9C41B',
                                  'serial_number': 'A9C41B',
                                  'system_mac_address': None},
                'A9C675': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '29 MILL ST E (HASENPFLUG ED & LOUISE)',
                                  'serial': 'A9C675',
                                  'serial_number': 'A9C675',
                                  'system_mac_address': None},
                'A9C6FA': {       'dev_macs': ['d0:76:8f:91:d4:dd'],
                                  'ip_address': None,
                                  'name': '29 TEMPERENCE ST, MILVERTON (Melissa & '
                                          'Chris Stahlke)',
                                  'serial': 'A9C6FA',
                                  'serial_number': 'A9C6FA',
                                  'system_mac_address': None},
                'A9C76F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '163 MARKET ST (BOESE PETER)',
                                  'serial': 'A9C76F',
                                  'serial_number': 'A9C76F',
                                  'system_mac_address': None},
                'A9C77B': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5948 PERTH ROAD 119 (ENGLER DON)',
                                  'serial': 'A9C77B',
                                  'serial_number': 'A9C77B',
                                  'system_mac_address': None},
                'A9C7F9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '13 MAIN ST N (KLASSEN CAMERON)',
                                  'serial': 'A9C7F9',
                                  'serial_number': 'A9C7F9',
                                  'system_mac_address': None},
                'A9C879': {       'dev_macs': ['d0:76:8f:91:d6:74'],
                                  'ip_address': None,
                                  'name': '20 Gerber Dr. Milverton (LUDWIG RYAN)',
                                  'serial': 'A9C879',
                                  'serial_number': 'A9C879',
                                  'system_mac_address': None},
                'A9C8AA': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '101 MADISON ST E MONKTON (GREEN MARIA)',
                                  'serial': 'A9C8AA',
                                  'serial_number': 'A9C8AA',
                                  'system_mac_address': None},
                'A9C8B4': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4249 LINE 61 (JANTZI NELSON)',
                                  'serial': 'A9C8B4',
                                  'serial_number': 'A9C8B4',
                                  'system_mac_address': None},
                'A9C8E5': {       'dev_macs': ['84:d3:43:0f:b7:ce'],
                                  'ip_address': None,
                                  'name': '77 SCHADE ST (VAN DYK HENRY)',
                                  'serial': 'A9C8E5',
                                  'serial_number': 'A9C8E5',
                                  'system_mac_address': None},
                'A9C8E6': {       'dev_macs': ['d0:76:8f:1f:54:ff'],
                                  'ip_address': None,
                                  'name': '195 SELBY AV (SMITH EDWARD)',
                                  'serial': 'A9C8E6',
                                  'serial_number': 'A9C8E6',
                                  'system_mac_address': None},
                'A9C90F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4924 PERTH LINE 55 (WESTMAN STEPHEN & '
                                          'LINDA)',
                                  'serial': 'A9C90F',
                                  'serial_number': 'A9C90F',
                                  'system_mac_address': None},
                'A9C94B': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5331 ROAD 144 (DAVIDSON FRASER & STARLA)',
                                  'serial': 'A9C94B',
                                  'serial_number': 'A9C94B',
                                  'system_mac_address': None},
                'A9C986': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '16 Mill St. E. Milverton (Tech Office '
                                          'Basement)',
                                  'serial': 'A9C986',
                                  'serial_number': 'A9C986',
                                  'system_mac_address': None},
                'A9C9C0': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '78 MADDISON ST E (HIEBERT ABRAHAM)',
                                  'serial': 'A9C9C0',
                                  'serial_number': 'A9C9C0',
                                  'system_mac_address': None},
                'A9F08': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '167 Fishleigh St. Monkton (Mike Danieli)',
                                 'serial': 'A9F08',
                                 'serial_number': 'A9F08',
                                 'system_mac_address': None},
                'AC44E': {       'dev_macs': [       '00:40:7f:96:4d:31',
                                                     '1e:2d:5d:56:58:9f',
                                                     '24:9a:d8:9b:4c:51',
                                                     '26:fe:73:5a:c2:78',
                                                     '28:d0:ea:d1:e1:10',
                                                     '3e:9a:82:71:b8:5d',
                                                     '44:db:d2:28:4a:7f',
                                                     '44:db:d2:4a:59:ca',
                                                     '4e:a7:31:1b:7e:2f',
                                                     '52:00:6c:aa:87:59',
                                                     '52:eb:16:84:bb:f0',
                                                     '58:1c:f8:6d:29:9b',
                                                     '5e:6f:dc:0f:75:4f',
                                                     '60:22:32:45:a4:38',
                                                     '64:00:6a:72:72:d6',
                                                     '74:86:e2:07:24:0c',
                                                     '74:86:e2:07:a1:9f',
                                                     '78:45:58:43:c3:d9',
                                                     'a8:3c:a5:20:a7:b5',
                                                     'c2:88:9e:d8:3f:a9',
                                                     'ca:51:32:b1:ca:30',
                                                     'ca:d9:b4:e9:b5:b2',
                                                     'cc:96:e5:20:76:47',
                                                     'cc:96:e5:20:77:d9',
                                                     'd0:8e:79:13:6d:c8',
                                                     'd0:8e:79:13:6d:d7',
                                                     'd4:f0:c9:0d:51:50'],
                                 'ip_address': None,
                                 'name': '19 Mill St. E. Milverton (Perth East '
                                         'Library)',
                                 'serial': 'AC44E',
                                 'serial_number': 'AC44E',
                                 'system_mac_address': None},
                'ADB03': {       'dev_macs': ['44:65:7f:88:48:10'],
                                 'ip_address': None,
                                 'name': '55 MADDISON ST W (REID MELISSA)',
                                 'serial': 'ADB03',
                                 'serial_number': 'ADB03',
                                 'system_mac_address': None},
                'B08EF6': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6988 MILLBANK MAIN ST (WEBER KACIE)',
                                  'serial': 'B08EF6',
                                  'serial_number': 'B08EF6',
                                  'system_mac_address': None},
                'B09F39': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6619 PERTH ROAD 131 (MILVERTON CHRISTIAN '
                                          'FELLOWSHIP)',
                                  'serial': 'B09F39',
                                  'serial_number': 'B09F39',
                                  'system_mac_address': None},
                'B0A14E': {       'dev_macs': ['00:03:e6:fa:10:92'],
                                  'ip_address': None,
                                  'name': '5944 PERTH ROAD 119 (PRONG DOUGLAS & LISA)',
                                  'serial': 'B0A14E',
                                  'serial_number': 'B0A14E',
                                  'system_mac_address': None},
                'B0A212': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6114 ANA ST (KRAEMER RICHARD & FRANCES)',
                                  'serial': 'B0A212',
                                  'serial_number': 'B0A212',
                                  'system_mac_address': None},
                'B0A274': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6414 ROAD 140 (ALIGN PLUMBING)',
                                  'serial': 'B0A274',
                                  'serial_number': 'B0A274',
                                  'system_mac_address': None},
                'B0A288': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5307 ROAD 130 (BALL ANDREW)',
                                  'serial': 'B0A288',
                                  'serial_number': 'B0A288',
                                  'system_mac_address': None},
                'B0A2A6': {       'dev_macs': ['60:db:98:55:b5:8e'],
                                  'ip_address': None,
                                  'name': '167 MADDISON ST E (MACHAN TORIE)',
                                  'serial': 'B0A2A6',
                                  'serial_number': 'B0A2A6',
                                  'system_mac_address': None},
                'B0AAE8': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4 MAIN ST S (MACEWAN ADAM)',
                                  'serial': 'B0AAE8',
                                  'serial_number': 'B0AAE8',
                                  'system_mac_address': None},
                'B0AAF1': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '55 WILLIAM ST 207-2',
                                  'serial': 'B0AAF1',
                                  'serial_number': 'B0AAF1',
                                  'system_mac_address': None},
                'B50DC4': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4699 Line 49 (Darryl Terpstra 10430074)',
                                  'serial': 'B50DC4',
                                  'serial_number': 'B50DC4',
                                  'system_mac_address': None},
                'B5114C': {       'dev_macs': ['b8:94:70:bc:b7:e0'],
                                  'ip_address': None,
                                  'name': '5593 DUKE ST (LEIS WARREN)',
                                  'serial': 'B5114C',
                                  'serial_number': 'B5114C',
                                  'system_mac_address': None},
                'B51169': {       'dev_macs': ['78:98:e8:5f:d5:94'],
                                  'ip_address': None,
                                  'name': '6313 ROAD 140 (FALCONER JOHN)',
                                  'serial': 'B51169',
                                  'serial_number': 'B51169',
                                  'system_mac_address': None},
                'B5116C': {       'dev_macs': ['10:27:f5:32:b8:bb'],
                                  'ip_address': None,
                                  'name': '5917 PERTH ROAD 119 (GERBER KATHRYN)',
                                  'serial': 'B5116C',
                                  'serial_number': 'B5116C',
                                  'system_mac_address': None},
                'B51178': {       'dev_macs': ['b0:4e:26:e9:95:54'],
                                  'ip_address': None,
                                  'name': '6248 ROAD 124 (CLAASSEN ELISABETH '
                                          '(ISABELLE))',
                                  'serial': 'B51178',
                                  'serial_number': 'B51178',
                                  'system_mac_address': None},
                'B511B7': {       'dev_macs': ['24:4b:fe:1f:59:d8'],
                                  'ip_address': None,
                                  'name': '56 MADDISON ST W (BOYD RYAN)',
                                  'serial': 'B511B7',
                                  'serial_number': 'B511B7',
                                  'system_mac_address': None},
                'B511B9': {       'dev_macs': ['b8:94:70:bc:b8:38'],
                                  'ip_address': None,
                                  'name': '6214 ROAD 124 (KUNTZE JOHN)',
                                  'serial': 'B511B9',
                                  'serial_number': 'B511B9',
                                  'system_mac_address': None},
                'B511E0': {       'dev_macs': ['e0:63:da:83:f9:f0'],
                                  'ip_address': None,
                                  'name': '64 GERBER DR (LOESCH JOSEPH)',
                                  'serial': 'B511E0',
                                  'serial_number': 'B511E0',
                                  'system_mac_address': None},
                'B512B7': {       'dev_macs': ['04:bc:9f:46:94:a0'],
                                  'ip_address': None,
                                  'name': '77 GERBER DR (SZCZEPANEK KRZYSZTOF (KRIS))',
                                  'serial': 'B512B7',
                                  'serial_number': 'B512B7',
                                  'system_mac_address': None},
                'B512DB': {       'dev_macs': ['dc:62:79:c7:74:71'],
                                  'ip_address': None,
                                  'name': '5956 PERTH RD 119-5 (ELROY WAGLER MASONRY)',
                                  'serial': 'B512DB',
                                  'serial_number': 'B512DB',
                                  'system_mac_address': None},
                'B512DC': {       'dev_macs': ['00:21:91:f8:32:4d'],
                                  'ip_address': None,
                                  'name': '14 MAIN ST N (NORTHERN DREAM INK)',
                                  'serial': 'B512DC',
                                  'serial_number': 'B512DC',
                                  'system_mac_address': None},
                'BA8C3': {       'dev_macs': [       '5c:0f:fb:3d:52:38',
                                                     '5c:0f:fb:17:75:30',
                                                     '00:03:e6:a5:6f:84',
                                                     '5c:0f:fb:43:96:ae',
                                                     '5c:0f:fb:3d:5a:a0'],
                                 'ip_address': None,
                                 'name': '50 WILLIAM ST',
                                 'serial': 'BA8C3',
                                 'serial_number': 'BA8C3',
                                 'system_mac_address': None},
                'BDD9F4': {       'dev_macs': ['60:32:b1:e9:de:bc'],
                                  'ip_address': None,
                                  'name': '4082 PERTH LINE 72 (GOSPEL ECHOES)',
                                  'serial': 'BDD9F4',
                                  'serial_number': 'BDD9F4',
                                  'system_mac_address': None},
                'BDD9FD': {       'dev_macs': ['f4:92:bf:84:2a:53'],
                                  'ip_address': None,
                                  'name': '4072 PERTH LINE 72 (MILESTONE EQUIPMENT '
                                          'LTD)',
                                  'serial': 'BDD9FD',
                                  'serial_number': 'BDD9FD',
                                  'system_mac_address': None},
                'BF2429': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '43 SCHADE ST (DUNCAN KELLY)',
                                  'serial': 'BF2429',
                                  'serial_number': 'BF2429',
                                  'system_mac_address': None},
                'BF250E': {       'dev_macs': ['14:eb:b6:58:a7:d5'],
                                  'ip_address': None,
                                  'name': '25 PACIFIC AV (DOBES SEBASTIAN)',
                                  'serial': 'BF250E',
                                  'serial_number': 'BF250E',
                                  'system_mac_address': None},
                'C4DD1': {       'dev_macs': ['84:d3:43:6d:e8:eb'],
                                 'ip_address': None,
                                 'name': '4 Jo-Lenne Ct. Milverton (Jay Schultz)',
                                 'serial': 'C4DD1',
                                 'serial_number': 'C4DD1',
                                 'system_mac_address': None},
                'C4DDF': {       'dev_macs': ['ec:4f:82:2c:70:52'],
                                 'ip_address': None,
                                 'name': '15 Gerber Dr. Milverton (Jeff Keller)',
                                 'serial': 'C4DDF',
                                 'serial_number': 'C4DDF',
                                 'system_mac_address': None},
                'C4DEA': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '19 St. Marys St. S. Milverton (KUEPFER '
                                         'MARTHA)',
                                 'serial': 'C4DEA',
                                 'serial_number': 'C4DEA',
                                 'system_mac_address': None},
                'C4DEC': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '5 St. Marys St. S. Milverton (Wayne Poole '
                                         '10421583)',
                                 'serial': 'C4DEC',
                                 'serial_number': 'C4DEC',
                                 'system_mac_address': None},
                'C4DF6': {       'dev_macs': ['d0:76:8f:02:f2:0f'],
                                 'ip_address': None,
                                 'name': '24 Gerber Ct. Milverton (John Rasmussen)',
                                 'serial': 'C4DF6',
                                 'serial_number': 'C4DF6',
                                 'system_mac_address': None},
                'C4DFB': {       'dev_macs': ['cc:be:59:32:94:74'],
                                 'ip_address': None,
                                 'name': '16 ST MARYS ST S (SCHMIDT DAVID & KAREN)',
                                 'serial': 'C4DFB',
                                 'serial_number': 'C4DFB',
                                 'system_mac_address': None},
                'C4DFD': {       'dev_macs': ['14:21:03:d1:7e:12'],
                                 'ip_address': None,
                                 'name': '8 JO-LENE CT (FARIES JACINTA)',
                                 'serial': 'C4DFD',
                                 'serial_number': 'C4DFD',
                                 'system_mac_address': None},
                'C4F9B': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '17 ST MARYS ST S (Kristin Brooks 10438137)',
                                 'serial': 'C4F9B',
                                 'serial_number': 'C4F9B',
                                 'system_mac_address': None},
                'C4FE7': {       'dev_macs': ['b8:94:70:f3:e2:b4'],
                                 'ip_address': None,
                                 'name': '185 ERSKINE ST (IRELAND MORRIS)',
                                 'serial': 'C4FE7',
                                 'serial_number': 'C4FE7',
                                 'system_mac_address': None},
                'C4FE9': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '14 Pugh St. Milverton (COOK GERALD)',
                                 'serial': 'C4FE9',
                                 'serial_number': 'C4FE9',
                                 'system_mac_address': None},
                'C4FEA': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '8 ST MARYS ST S (WADDELL DALE)',
                                 'serial': 'C4FEA',
                                 'serial_number': 'C4FEA',
                                 'system_mac_address': None},
                'C4FF8': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '4 St. Marys St. S. Milverton (Rick Baier)',
                                 'serial': 'C4FF8',
                                 'serial_number': 'C4FF8',
                                 'system_mac_address': None},
                'C4FFA': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '15 ST MARYS ST S (MOHR RON)',
                                 'serial': 'C4FFA',
                                 'serial_number': 'C4FFA',
                                 'system_mac_address': None},
                'C4FFB': {       'dev_macs': ['a0:ab:1b:48:c4:02'],
                                 'ip_address': None,
                                 'name': '12 Gerber Ct. Milverton (William Westman)',
                                 'serial': 'C4FFB',
                                 'serial_number': 'C4FFB',
                                 'system_mac_address': None},
                'C4FFC': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '39 Gerber Dr. Milverton (Allan Steckley)',
                                 'serial': 'C4FFC',
                                 'serial_number': 'C4FFC',
                                 'system_mac_address': None},
                'C5002': {       'dev_macs': ['44:65:7f:88:d5:13'],
                                 'ip_address': None,
                                 'name': '31 Gerber Dr. Milverton (Nadine Hanna)',
                                 'serial': 'C5002',
                                 'serial_number': 'C5002',
                                 'system_mac_address': None},
                'C5004': {       'dev_macs': ['d0:76:8f:02:f1:12'],
                                 'ip_address': None,
                                 'name': '23 Gerber Dr. Milverton (Joe Streicher)',
                                 'serial': 'C5004',
                                 'serial_number': 'C5004',
                                 'system_mac_address': None},
                'C5039': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '81 Mill St. E. Milverton (Brian Hall)',
                                 'serial': 'C5039',
                                 'serial_number': 'C5039',
                                 'system_mac_address': None},
                'C5703': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '19 Gerber Dr. Milverton (Rob McEwen)',
                                 'serial': 'C5703',
                                 'serial_number': 'C5703',
                                 'system_mac_address': None},
                'C5713': {       'dev_macs': ['d0:76:8f:02:f5:32'],
                                 'ip_address': None,
                                 'name': '16 GERBER CT (STOKER BRANDON)',
                                 'serial': 'C5713',
                                 'serial_number': 'C5713',
                                 'system_mac_address': None},
                'C573E': {       'dev_macs': ['b8:94:70:f3:e2:9e'],
                                 'ip_address': None,
                                 'name': '63 MILL ST E (GRAY JACKIE)',
                                 'serial': 'C573E',
                                 'serial_number': 'C573E',
                                 'system_mac_address': None},
                'C5745': {       'dev_macs': ['e4:6c:d1:4f:b7:4d'],
                                 'ip_address': None,
                                 'name': '40 GERBER DR (AMSTEIN DEBORAH)',
                                 'serial': 'C5745',
                                 'serial_number': 'C5745',
                                 'system_mac_address': None},
                'C574C': {       'dev_macs': ['ac:9e:17:b2:fb:f8'],
                                 'ip_address': None,
                                 'name': '4 GERBER CT (KIPFER COLBY)',
                                 'serial': 'C574C',
                                 'serial_number': 'C574C',
                                 'system_mac_address': None},
                'C5778': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '3 Gerber Ct. Milverton (Durell Brubacher)',
                                 'serial': 'C5778',
                                 'serial_number': 'C5778',
                                 'system_mac_address': None},
                'C578C': {       'dev_macs': ['50:91:e3:71:ac:20'],
                                 'ip_address': None,
                                 'name': '101 MILL ST E (BAIER ADAM)',
                                 'serial': 'C578C',
                                 'serial_number': 'C578C',
                                 'system_mac_address': None},
                'C57E8': {       'dev_macs': ['40:b0:76:33:aa:00'],
                                 'ip_address': None,
                                 'name': '13 St. Marys St. S. Milverton (Heather '
                                         'Westman)',
                                 'serial': 'C57E8',
                                 'serial_number': 'C57E8',
                                 'system_mac_address': None},
                'C57F1': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '20 GERBER CT. (SCHWARTZENTRUBER GRANT)',
                                 'serial': 'C57F1',
                                 'serial_number': 'C57F1',
                                 'system_mac_address': None},
                'C57FA': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '7 Pugh St. Milverton (Shawn Gilbert)',
                                 'serial': 'C57FA',
                                 'serial_number': 'C57FA',
                                 'system_mac_address': None},
                'C5849': {       'dev_macs': ['ac:8b:a9:11:38:c1'],
                                 'ip_address': None,
                                 'name': '52 MILL ST E (RICHARD MITCHELL)',
                                 'serial': 'C5849',
                                 'serial_number': 'C5849',
                                 'system_mac_address': None},
                'C5852': {       'dev_macs': ['70:4c:a5:35:93:c2'],
                                 'ip_address': None,
                                 'name': '54 Mill St. W. Milverton (Wesbell '
                                         'Technologies)',
                                 'serial': 'C5852',
                                 'serial_number': 'C5852',
                                 'system_mac_address': None},
                'C585F': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '28 Gerber Ct. Milverton (George Tanner)',
                                 'serial': 'C585F',
                                 'serial_number': 'C585F',
                                 'system_mac_address': None},
                'C811E2': {       'dev_macs': [       'e0:55:3d:89:d9:c5',
                                                      '00:0d:b9:55:21:19'],
                                  'ip_address': None,
                                  'name': '4060 PERTH LINE 72 (MILLBANK HOME BAKERY & '
                                          'COUNTRY)',
                                  'serial': 'C811E2',
                                  'serial_number': 'C811E2',
                                  'system_mac_address': None},
                'C811FE': {       'dev_macs': ['44:65:7f:88:d3:09'],
                                  'ip_address': None,
                                  'name': '65 PUGH ST (REKTOR SHANE)',
                                  'serial': 'C811FE',
                                  'serial_number': 'C811FE',
                                  'system_mac_address': None},
                'C81206': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '145 PUGH ST (HAMMER PAM)',
                                  'serial': 'C81206',
                                  'serial_number': 'C81206',
                                  'system_mac_address': None},
                'C81227': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6313 ROAD 124 (STREICHER MURRAY & JOANNE)',
                                  'serial': 'C81227',
                                  'serial_number': 'C81227',
                                  'system_mac_address': None},
                'C815C8': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '11 COLBALT ST (MCKONE STEPHANIE)',
                                  'serial': 'C815C8',
                                  'serial_number': 'C815C8',
                                  'system_mac_address': None},
                'C81609': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4097 QUEEN ST (ALBRECHT NATHAN)',
                                  'serial': 'C81609',
                                  'serial_number': 'C81609',
                                  'system_mac_address': None},
                'C816E6': {       'dev_macs': ['04:bc:9f:46:a7:bf'],
                                  'ip_address': None,
                                  'name': '5125 LINE 60 (EBERSOL ISRAEL & CHRISTENA)',
                                  'serial': 'C816E6',
                                  'serial_number': 'C816E6',
                                  'system_mac_address': None},
                'C8196A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6975 CHURCH ST (STREICHER FANNIE)',
                                  'serial': 'C8196A',
                                  'serial_number': 'C8196A',
                                  'system_mac_address': None},
                'C819B8': {       'dev_macs': ['60:db:98:09:1e:8d'],
                                  'ip_address': None,
                                  'name': '132 PUGH ST (GRAHAM JENNIFER)',
                                  'serial': 'C819B8',
                                  'serial_number': 'C819B8',
                                  'system_mac_address': None},
                'C819BA': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6914 PERTH ROAD 121 (BARTSCH JOHAN)',
                                  'serial': 'C819BA',
                                  'serial_number': 'C819BA',
                                  'system_mac_address': None},
                'C819DD': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6974 CHURCH ST (OXFORD MILKWAY - MILLBANK '
                                          'DEPO)',
                                  'serial': 'C819DD',
                                  'serial_number': 'C819DD',
                                  'system_mac_address': None},
                'C81BB5': {       'dev_macs': [       '04:eb:40:35:aa:f0',
                                                      '04:d4:c4:d6:79:5c'],
                                  'ip_address': None,
                                  'name': '4044 PERTH LINE 72 (MILLBANK FAMILY '
                                          'FURNITURE)',
                                  'serial': 'C81BB5',
                                  'serial_number': 'C81BB5',
                                  'system_mac_address': None},
                'C81C52': {       'dev_macs': [       '00:03:e6:eb:71:ce',
                                                      'd0:76:8f:1f:64:14'],
                                  'ip_address': None,
                                  'name': '169 MARKET ST (HOWARD MARDLING 10431857)',
                                  'serial': 'C81C52',
                                  'serial_number': 'C81C52',
                                  'system_mac_address': None},
                'C81C73': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6974 CHURCH ST (MILLBANK CHEESE AND BUTTER)',
                                  'serial': 'C81C73',
                                  'serial_number': 'C81C73',
                                  'system_mac_address': None},
                'C81C8F': {       'dev_macs': ['b8:94:70:9e:ce:dd'],
                                  'ip_address': None,
                                  'name': '100 PUGH ST (BOIVIN JASON)',
                                  'serial': 'C81C8F',
                                  'serial_number': 'C81C8F',
                                  'system_mac_address': None},
                'C81C91': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6906 ELGIN ST (WILLIS PAULINE)',
                                  'serial': 'C81C91',
                                  'serial_number': 'C81C91',
                                  'system_mac_address': None},
                'C81D2A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6939 ROAD 140 (LANNIN DON)',
                                  'serial': 'C81D2A',
                                  'serial_number': 'C81D2A',
                                  'system_mac_address': None},
                'C81D54': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '60 SCHADE ST (ARMSTRONG GERALD & BARB)',
                                  'serial': 'C81D54',
                                  'serial_number': 'C81D54',
                                  'system_mac_address': None},
                'C81D62': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6945 NICKLIN ST (ROES IVAN & RETA)',
                                  'serial': 'C81D62',
                                  'serial_number': 'C81D62',
                                  'system_mac_address': None},
                'C81D72': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6611D PERTH ROAD 131 (ACRE75)',
                                  'serial': 'C81D72',
                                  'serial_number': 'C81D72',
                                  'system_mac_address': None},
                'C81D7C': {       'dev_macs': ['b8:94:70:bc:c0:a4'],
                                  'ip_address': None,
                                  'name': '93 PUGH ST (SAMUEL MARK & GILLIAN)',
                                  'serial': 'C81D7C',
                                  'serial_number': 'C81D7C',
                                  'system_mac_address': None},
                'C81D80': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '25 MURRAY CT (SOUTH SIDE ESTATES INC)',
                                  'serial': 'C81D80',
                                  'serial_number': 'C81D80',
                                  'system_mac_address': None},
                'C81D85': {       'dev_macs': ['b8:94:70:84:92:69'],
                                  'ip_address': None,
                                  'name': '5 EDWARD ST MILVERTON (METZGER TREVOR & '
                                          'BRANDY)',
                                  'serial': 'C81D85',
                                  'serial_number': 'C81D85',
                                  'system_mac_address': None},
                'C81D86': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5 MADDISON ST E (SPEARS BARBARA)',
                                  'serial': 'C81D86',
                                  'serial_number': 'C81D86',
                                  'system_mac_address': None},
                'C81D87': {       'dev_macs': ['b8:94:70:9e:cd:b4'],
                                  'ip_address': None,
                                  'name': '104 PUGH ST (MOHAMED SOMSACK)',
                                  'serial': 'C81D87',
                                  'serial_number': 'C81D87',
                                  'system_mac_address': None},
                'C81D8A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6987 MILLBANK MAIN ST (FRIESEN JAKE)',
                                  'serial': 'C81D8A',
                                  'serial_number': 'C81D8A',
                                  'system_mac_address': None},
                'C81D8E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5905 PERTH ROAD 119 (JANTZI MARY J)',
                                  'serial': 'C81D8E',
                                  'serial_number': 'C81D8E',
                                  'system_mac_address': None},
                'C81DA5': {       'dev_macs': [       '00:03:e6:a8:0d:a6',
                                                      '5c:0f:fb:17:64:16',
                                                      '5c:0f:fb:17:72:10'],
                                  'ip_address': None,
                                  'name': '6983 CHURCH ST (KUEPFER WILLIAM R)',
                                  'serial': 'C81DA5',
                                  'serial_number': 'C81DA5',
                                  'system_mac_address': None},
                'C81DAA': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4104 WYNDHAM ST (TAM KEITH & JACQUI)',
                                  'serial': 'C81DAA',
                                  'serial_number': 'C81DAA',
                                  'system_mac_address': None},
                'C81DC1': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6928 HORIZON TL (GREEN DARRYL)',
                                  'serial': 'C81DC1',
                                  'serial_number': 'C81DC1',
                                  'system_mac_address': None},
                'C81DC5': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4069 NORFOLK ST (HORST PAULINE)',
                                  'serial': 'C81DC5',
                                  'serial_number': 'C81DC5',
                                  'system_mac_address': None},
                'C81DD1': {       'dev_macs': ['b8:94:70:bc:ae:ae'],
                                  'ip_address': None,
                                  'name': '152 PUGH ST (BURKE AMY)',
                                  'serial': 'C81DD1',
                                  'serial_number': 'C81DD1',
                                  'system_mac_address': None},
                'C81DD4': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4102 WYNDHAM ST (SOULLIERE LINDA)',
                                  'serial': 'C81DD4',
                                  'serial_number': 'C81DD4',
                                  'system_mac_address': None},
                'C81DD5': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4056 NORFOLK ST (ZACHARIAS JAKE)',
                                  'serial': 'C81DD5',
                                  'serial_number': 'C81DD5',
                                  'system_mac_address': None},
                'C81DDA': {       'dev_macs': ['b8:94:70:9e:ca:e9'],
                                  'ip_address': None,
                                  'name': '148 PUGH ST (CARREON ANNE)',
                                  'serial': 'C81DDA',
                                  'serial_number': 'C81DDA',
                                  'system_mac_address': None},
                'C81DEC': {       'dev_macs': ['b8:94:70:bc:ac:eb'],
                                  'ip_address': None,
                                  'name': "99 PUGH ST (D'HULSTER EMIEL)",
                                  'serial': 'C81DEC',
                                  'serial_number': 'C81DEC',
                                  'system_mac_address': None},
                'C81DF0': {       'dev_macs': ['60:db:98:09:1d:85'],
                                  'ip_address': None,
                                  'name': '6960 PERTH ROAD 121 (KUEPFER JAMES & SARAH)',
                                  'serial': 'C81DF0',
                                  'serial_number': 'C81DF0',
                                  'system_mac_address': None},
                'C81DF3': {       'dev_macs': [       '5c:0f:fb:17:6e:84',
                                                      '60:db:98:09:3c:49'],
                                  'ip_address': None,
                                  'name': '6540 ROAD 154 (SATCHELL SCOTT)',
                                  'serial': 'C81DF3',
                                  'serial_number': 'C81DF3',
                                  'system_mac_address': None},
                'C81DF4': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4062 NORFOLK ST (GUENTHER DAVID)',
                                  'serial': 'C81DF4',
                                  'serial_number': 'C81DF4',
                                  'system_mac_address': None},
                'C81E10': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4885 LINE 59 (WAGNER KYLE & CRYSTAL)',
                                  'serial': 'C81E10',
                                  'serial_number': 'C81E10',
                                  'system_mac_address': None},
                'C81E11': {       'dev_macs': ['14:21:03:cf:b8:4b'],
                                  'ip_address': None,
                                  'name': '6984 CHURCH ST (BRUBACHER DARREN & DARLENE)',
                                  'serial': 'C81E11',
                                  'serial_number': 'C81E11',
                                  'system_mac_address': None},
                'C81E23': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4091 QUEEN ST (WAGLER EARL)',
                                  'serial': 'C81E23',
                                  'serial_number': 'C81E23',
                                  'system_mac_address': None},
                'C81E2D': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4626 PERTH LINE 55 (JANTZI MARVIN A)',
                                  'serial': 'C81E2D',
                                  'serial_number': 'C81E2D',
                                  'system_mac_address': None},
                'C81E2E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6950 PERTH ROAD 121 (KUEPFER IVAN & '
                                          'ANNAMAE)',
                                  'serial': 'C81E2E',
                                  'serial_number': 'C81E2E',
                                  'system_mac_address': None},
                'C81E36': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4106 WYNDHAM ST MILLBANK (WAGLER WAYNE & '
                                          'DIANNE)',
                                  'serial': 'C81E36',
                                  'serial_number': 'C81E36',
                                  'system_mac_address': None},
                'C81E3E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6932 PERTH ST (DERKSEN ANDREAS)',
                                  'serial': 'C81E3E',
                                  'serial_number': 'C81E3E',
                                  'system_mac_address': None},
                'C81E40': {       'dev_macs': ['b8:94:70:f3:e1:ac'],
                                  'ip_address': None,
                                  'name': '92 GERBER DR (MEYER JACKIE)',
                                  'serial': 'C81E40',
                                  'serial_number': 'C81E40',
                                  'system_mac_address': None},
                'C81E50': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4092 PRINCESS ST (DELONG JOHN & JOCELYN)',
                                  'serial': 'C81E50',
                                  'serial_number': 'C81E50',
                                  'system_mac_address': None},
                'C81E56': {       'dev_macs': ['b8:94:70:bc:b7:1a'],
                                  'ip_address': None,
                                  'name': '11 COBALT STREET S (JUTZI TREVOR)',
                                  'serial': 'C81E56',
                                  'serial_number': 'C81E56',
                                  'system_mac_address': None},
                'C81E57': {       'dev_macs': ['b8:94:70:9d:ad:ab'],
                                  'ip_address': None,
                                  'name': '7201 ROAD 140 (SCOTT KRISTINE)',
                                  'serial': 'C81E57',
                                  'serial_number': 'C81E57',
                                  'system_mac_address': None},
                'C81E5C': {       'dev_macs': ['b8:94:70:bc:40:fb'],
                                  'ip_address': None,
                                  'name': '5610 PERTH LINE 55 (DAVIDSON KELLY)',
                                  'serial': 'C81E5C',
                                  'serial_number': 'C81E5C',
                                  'system_mac_address': None},
                'C81E5D': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6936 HORIZON TL (KEEPSAKES BY KLASSEN)',
                                  'serial': 'C81E5D',
                                  'serial_number': 'C81E5D',
                                  'system_mac_address': None},
                'C81E5E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6946 NICKLIN ST (JANSEN SHERI)',
                                  'serial': 'C81E5E',
                                  'serial_number': 'C81E5E',
                                  'system_mac_address': None},
                'C81E5F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6906 ELGIN ST (BAKER MARNIE)',
                                  'serial': 'C81E5F',
                                  'serial_number': 'C81E5F',
                                  'system_mac_address': None},
                'C81E60': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4081 QUEEN ST (JANTZI MURRAY & TRACILEE)',
                                  'serial': 'C81E60',
                                  'serial_number': 'C81E60',
                                  'system_mac_address': None},
                'C81E61': {       'dev_macs': [       '14:21:03:8b:73:5a',
                                                      '5c:0f:fb:2a:0e:26'],
                                  'ip_address': None,
                                  'name': '6927 HORIZON TL (KROPF AUDREY)',
                                  'serial': 'C81E61',
                                  'serial_number': 'C81E61',
                                  'system_mac_address': None},
                'C81E63': {       'dev_macs': [       '5c:0f:fb:3d:72:c8',
                                                      '5c:0f:fb:3d:61:34'],
                                  'ip_address': None,
                                  'name': '12 GROSCH ST (WETTLAUFER DWIGHT)',
                                  'serial': 'C81E63',
                                  'serial_number': 'C81E63',
                                  'system_mac_address': None},
                'C81E6F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '30 MAIN ST S (OAK TREE FINANCIAL)',
                                  'serial': 'C81E6F',
                                  'serial_number': 'C81E6F',
                                  'system_mac_address': None},
                'C81E71': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4461 PERTH LINE 72 (TAKACH DON)',
                                  'serial': 'C81E71',
                                  'serial_number': 'C81E71',
                                  'system_mac_address': None},
                'C81E75': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '8 LLANA HEIGHTS DR (STECKLY JAMES)',
                                  'serial': 'C81E75',
                                  'serial_number': 'C81E75',
                                  'system_mac_address': None},
                'C81E79': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4806 LINE 48 GADSHILL (LAURA DEWEERD)',
                                  'serial': 'C81E79',
                                  'serial_number': 'C81E79',
                                  'system_mac_address': None},
                'C81E7C': {       'dev_macs': ['84:d3:43:6d:e9:d2'],
                                  'ip_address': None,
                                  'name': '140 PUGH ST (WEST JAMES)',
                                  'serial': 'C81E7C',
                                  'serial_number': 'C81E7C',
                                  'system_mac_address': None},
                'C81E82': {       'dev_macs': ['60:db:98:09:39:aa'],
                                  'ip_address': None,
                                  'name': '136 PUGH ST (ROBARTS CHARLOTTE)',
                                  'serial': 'C81E82',
                                  'serial_number': 'C81E82',
                                  'system_mac_address': None},
                'C81E8D': {       'dev_macs': ['14:21:03:d1:8c:4b'],
                                  'ip_address': None,
                                  'name': '4866 LINE 59 (MILLER WILLIAM A)',
                                  'serial': 'C81E8D',
                                  'serial_number': 'C81E8D',
                                  'system_mac_address': None},
                'C81E96': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4071 WATERLOO ST (STREICHER ELLA & ERVIN)',
                                  'serial': 'C81E96',
                                  'serial_number': 'C81E96',
                                  'system_mac_address': None},
                'C81E9E': {       'dev_macs': ['84:d3:43:0f:b7:a2'],
                                  'ip_address': None,
                                  'name': '147 PUGH ST (BLOUSE ASHLEE)',
                                  'serial': 'C81E9E',
                                  'serial_number': 'C81E9E',
                                  'system_mac_address': None},
                'C81E9F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4074 WYNDHAM ST (CRUMMER TOM)',
                                  'serial': 'C81E9F',
                                  'serial_number': 'C81E9F',
                                  'system_mac_address': None},
                'C81EAC': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4092 WATERLOO ST (ELGIE CHAD)',
                                  'serial': 'C81EAC',
                                  'serial_number': 'C81EAC',
                                  'system_mac_address': None},
                'C81EAD': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '2 MAIN ST N (1262174 ONTARIO INC)',
                                  'serial': 'C81EAD',
                                  'serial_number': 'C81EAD',
                                  'system_mac_address': None},
                'C81EB0': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6237 ROAD 136 (DIEHL ERIC & SUE)',
                                  'serial': 'C81EB0',
                                  'serial_number': 'C81EB0',
                                  'system_mac_address': None},
                'C81EB7': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4088 PRINCESS ST (LICHTI NANCY)',
                                  'serial': 'C81EB7',
                                  'serial_number': 'C81EB7',
                                  'system_mac_address': None},
                'C81EB8': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6958 PERTH ROAD 121 (WOELK JOHN)',
                                  'serial': 'C81EB8',
                                  'serial_number': 'C81EB8',
                                  'system_mac_address': None},
                'C81EC3': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6927 PERTH ROAD 121 (SCHEERER MARK & SANDY)',
                                  'serial': 'C81EC3',
                                  'serial_number': 'C81EC3',
                                  'system_mac_address': None},
                'C81EC9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6948 ELGIN ST (PETERS ISAAK & SUSANA)',
                                  'serial': 'C81EC9',
                                  'serial_number': 'C81EC9',
                                  'system_mac_address': None},
                'C81ED9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '3 Sippel St. Milverton (Gerald Bain '
                                          '10430059)',
                                  'serial': 'C81ED9',
                                  'serial_number': 'C81ED9',
                                  'system_mac_address': None},
                'C81F02': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4105 CONNIE ST (GERBER DARLENE)',
                                  'serial': 'C81F02',
                                  'serial_number': 'C81F02',
                                  'system_mac_address': None},
                'C81F17': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4095 QUEEN ST (HOBDEN ROBERT & DIANE)',
                                  'serial': 'C81F17',
                                  'serial_number': 'C81F17',
                                  'system_mac_address': None},
                'C81F1A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4076 QUEEN ST (WATKINS JOANNA)',
                                  'serial': 'C81F1A',
                                  'serial_number': 'C81F1A',
                                  'system_mac_address': None},
                'C81F52': {       'dev_macs': ['cc:be:59:7e:b5:cc'],
                                  'ip_address': None,
                                  'name': '102 MILL ST E MILVERTON (JANTZI STEPHEN)',
                                  'serial': 'C81F52',
                                  'serial_number': 'C81F52',
                                  'system_mac_address': None},
                'C81F71': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '73 Maddison St. E. Monkton (Nancy '
                                          'Mcgoldrick)',
                                  'serial': 'C81F71',
                                  'serial_number': 'C81F71',
                                  'system_mac_address': None},
                'C820AC': {       'dev_macs': ['84:d3:43:0f:b5:71'],
                                  'ip_address': None,
                                  'name': '65 REAGAN ST (JORDAO JOSH)',
                                  'serial': 'C820AC',
                                  'serial_number': 'C820AC',
                                  'system_mac_address': None},
                'C820D2': {       'dev_macs': ['84:d3:43:0f:b5:5b'],
                                  'ip_address': None,
                                  'name': '160 QUEEN AVENUE MONKTON (GERBER MICHAEL)',
                                  'serial': 'C820D2',
                                  'serial_number': 'C820D2',
                                  'system_mac_address': None},
                'C83070': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4838 LINE 59 (WAGLER LEN)',
                                  'serial': 'C83070',
                                  'serial_number': 'C83070',
                                  'system_mac_address': None},
                'C8307E': {       'dev_macs': ['60:db:98:09:3c:f9'],
                                  'ip_address': None,
                                  'name': '125 PUGH ST (KIRCH STEVE)',
                                  'serial': 'C8307E',
                                  'serial_number': 'C8307E',
                                  'system_mac_address': None},
                'C83088': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4053 NORFOLK ST (WAGLER RICHARD)',
                                  'serial': 'C83088',
                                  'serial_number': 'C83088',
                                  'system_mac_address': None},
                'C830BA': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4083 HILLCREST ST (ERB BARBARA)',
                                  'serial': 'C830BA',
                                  'serial_number': 'C830BA',
                                  'system_mac_address': None},
                'C830CE': {       'dev_macs': ['14:21:03:d1:8a:72'],
                                  'ip_address': None,
                                  'name': '4084 WYNDHAM ST (ROPP DAVID & JANET)',
                                  'serial': 'C830CE',
                                  'serial_number': 'C830CE',
                                  'system_mac_address': None},
                'C830D4': {       'dev_macs': ['84:d3:43:0f:64:04'],
                                  'ip_address': None,
                                  'name': '5339 ROAD 130 (STADELMANN MARK)',
                                  'serial': 'C830D4',
                                  'serial_number': 'C830D4',
                                  'system_mac_address': None},
                'C830D9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5323 PERTH LINE 55 (MUELLER GEORGE)',
                                  'serial': 'C830D9',
                                  'serial_number': 'C830D9',
                                  'system_mac_address': None},
                'C830E8': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6990 RUTHERFORD ST (BURNS BLAKE)',
                                  'serial': 'C830E8',
                                  'serial_number': 'C830E8',
                                  'system_mac_address': None},
                'C830F5': {       'dev_macs': ['00:03:e6:dd:30:e8'],
                                  'ip_address': None,
                                  'name': '6963 PERTH ST MILLBANK (BRICK MARIE)',
                                  'serial': 'C830F5',
                                  'serial_number': 'C830F5',
                                  'system_mac_address': None},
                'C830F9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6989 CHURCH ST (ZWART JANELLE)',
                                  'serial': 'C830F9',
                                  'serial_number': 'C830F9',
                                  'system_mac_address': None},
                'C83108': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6939 ELGIN ST (GERBER RAY)',
                                  'serial': 'C83108',
                                  'serial_number': 'C83108',
                                  'system_mac_address': None},
                'C83114': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6972 NICKLIN ST MILLBANK (WAGLER ARLENE)',
                                  'serial': 'C83114',
                                  'serial_number': 'C83114',
                                  'system_mac_address': None},
                'C83116': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '155 PUGH ST (ZIERL MATTHEW)',
                                  'serial': 'C83116',
                                  'serial_number': 'C83116',
                                  'system_mac_address': None},
                'C8312C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5578 ROAD 144 (GINGRICH MAYNARD)',
                                  'serial': 'C8312C',
                                  'serial_number': 'C8312C',
                                  'system_mac_address': None},
                'C8313F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6998 MILLBANK MAIN ST (JANZEN GERHARD)',
                                  'serial': 'C8313F',
                                  'serial_number': 'C8313F',
                                  'system_mac_address': None},
                'C83146': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5921 SOMERSET DR (HART BEN)',
                                  'serial': 'C83146',
                                  'serial_number': 'C83146',
                                  'system_mac_address': None},
                'C8314A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '73 PUGH ST (SZYMIKOWSKI DARIUSZ)',
                                  'serial': 'C8314A',
                                  'serial_number': 'C8314A',
                                  'system_mac_address': None},
                'C83150': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5174 PERTH LINE 55 (BYLER JOHN)',
                                  'serial': 'C83150',
                                  'serial_number': 'C83150',
                                  'system_mac_address': None},
                'C83163': {       'dev_macs': ['84:d3:43:6d:e9:43'],
                                  'ip_address': None,
                                  'name': '165 MARKET ST (SUBJECT HELENA & FRED)',
                                  'serial': 'C83163',
                                  'serial_number': 'C83163',
                                  'system_mac_address': None},
                'C83169': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6927 NICKLIN ST MILLBANK (BAUMAN LAVERNE)',
                                  'serial': 'C83169',
                                  'serial_number': 'C83169',
                                  'system_mac_address': None},
                'C83174': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6994 MILLBANK MAIN STREET (LICHTI MATTHEW & '
                                          'SARAH)',
                                  'serial': 'C83174',
                                  'serial_number': 'C83174',
                                  'system_mac_address': None},
                'C8318D': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '110 MILL ST E (WAGLER ALVIN)',
                                  'serial': 'C8318D',
                                  'serial_number': 'C8318D',
                                  'system_mac_address': None},
                'C83193': {       'dev_macs': [       '5c:0f:fb:2f:cc:0f',
                                                      '5c:0f:fb:2f:ce:bb',
                                                      '84:d3:43:6d:ea:40'],
                                  'ip_address': None,
                                  'name': '6998 FREEBORN ST (RICHARDS BILL)',
                                  'serial': 'C83193',
                                  'serial_number': 'C83193',
                                  'system_mac_address': None},
                'C831EA': {       'dev_macs': ['84:d3:43:6d:e8:25'],
                                  'ip_address': None,
                                  'name': '31 WEST ST (TOPHAM-LINTHOME TYLER)',
                                  'serial': 'C831EA',
                                  'serial_number': 'C831EA',
                                  'system_mac_address': None},
                'C831F3': {       'dev_macs': ['14:21:03:d1:52:96'],
                                  'ip_address': None,
                                  'name': '6995 MILLBANK MAIN ST (KROPF BRUCE)',
                                  'serial': 'C831F3',
                                  'serial_number': 'C831F3',
                                  'system_mac_address': None},
                'C8321B': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4087 QUEEN ST (MARTIN MERLIN)',
                                  'serial': 'C8321B',
                                  'serial_number': 'C8321B',
                                  'system_mac_address': None},
                'C83246': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6420 ROAD 140 (STREICHER SAM & ESTHER)',
                                  'serial': 'C83246',
                                  'serial_number': 'C83246',
                                  'system_mac_address': None},
                'C83586': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4060 PRINCESS ST (SCHMITT GEOFF)',
                                  'serial': 'C83586',
                                  'serial_number': 'C83586',
                                  'system_mac_address': None},
                'C835A3': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5590 ROAD 126 (ZACH TREVOR)',
                                  'serial': 'C835A3',
                                  'serial_number': 'C835A3',
                                  'system_mac_address': None},
                'C83610': {       'dev_macs': ['34:0a:33:89:92:79'],
                                  'ip_address': None,
                                  'name': '4082B WATERLOO ST (ORANGE BARN)',
                                  'serial': 'C83610',
                                  'serial_number': 'C83610',
                                  'system_mac_address': None},
                'C83691': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6985 PARK ST (ORANGE BARN)',
                                  'serial': 'C83691',
                                  'serial_number': 'C83691',
                                  'system_mac_address': None},
                'C836C4': {       'dev_macs': ['e4:6c:d1:4e:ef:95'],
                                  'ip_address': None,
                                  'name': '6991 MILLBANK MAIN ST (WIEBE EVA)',
                                  'serial': 'C836C4',
                                  'serial_number': 'C836C4',
                                  'system_mac_address': None},
                'C83708': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4050 NORFOLK ST (WAGLER KRISTA)',
                                  'serial': 'C83708',
                                  'serial_number': 'C83708',
                                  'system_mac_address': None},
                'C83821': {       'dev_macs': ['44:65:7f:89:0d:bf'],
                                  'ip_address': None,
                                  'name': '2 MAIN ST N (KAUR LOVEPREET)',
                                  'serial': 'C83821',
                                  'serial_number': 'C83821',
                                  'system_mac_address': None},
                'C8392E': {       'dev_macs': ['14:21:03:92:ee:d8'],
                                  'ip_address': None,
                                  'name': '4 MILL ST E APT 1 (MANE APPEAL)',
                                  'serial': 'C8392E',
                                  'serial_number': 'C8392E',
                                  'system_mac_address': None},
                'C83954': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6213 Rd 124 (VAN NES MICHELLE)',
                                  'serial': 'C83954',
                                  'serial_number': 'C83954',
                                  'system_mac_address': None},
                'C83B0E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6280 ROAD 140',
                                  'serial': 'C83B0E',
                                  'serial_number': 'C83B0E',
                                  'system_mac_address': None},
                'C83B1E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6985 FREEBORN ST (GERBER BETTY)',
                                  'serial': 'C83B1E',
                                  'serial_number': 'C83B1E',
                                  'system_mac_address': None},
                'C83B33': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '20 COBALT STREET S (LEHMANN TRAVIS)',
                                  'serial': 'C83B33',
                                  'serial_number': 'C83B33',
                                  'system_mac_address': None},
                'C83B64': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4939 LINE 49 (BENNEWIES TREVOR)',
                                  'serial': 'C83B64',
                                  'serial_number': 'C83B64',
                                  'system_mac_address': None},
                'C83B6C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6990 CHURCH ST (ZEHR DYLAN)',
                                  'serial': 'C83B6C',
                                  'serial_number': 'C83B6C',
                                  'system_mac_address': None},
                'C83B73': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '9 PACIFIC AV (SCHAEFER ROBERT)',
                                  'serial': 'C83B73',
                                  'serial_number': 'C83B73',
                                  'system_mac_address': None},
                'C83B74': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5920 SOMERSET DR (WIEBE GERHARD)',
                                  'serial': 'C83B74',
                                  'serial_number': 'C83B74',
                                  'system_mac_address': None},
                'C83B7D': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '38 PACIFIC AVE MILVERTON (VAN ROOSMALEN '
                                          'KRISTIE)',
                                  'serial': 'C83B7D',
                                  'serial_number': 'C83B7D',
                                  'system_mac_address': None},
                'C83B88': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4051 NORFOLK ST MILLBANK (HORST BILL '
                                          'ACUTIONEER)',
                                  'serial': 'C83B88',
                                  'serial_number': 'C83B88',
                                  'system_mac_address': None},
                'C83B8B': {       'dev_macs': ['60:db:98:09:14:d7'],
                                  'ip_address': None,
                                  'name': '6947 NICKLIN ST (EDWARDS ERNEST & DONNA)',
                                  'serial': 'C83B8B',
                                  'serial_number': 'C83B8B',
                                  'system_mac_address': None},
                'C83B8F': {       'dev_macs': ['14:21:03:d1:8c:77'],
                                  'ip_address': None,
                                  'name': '6935 NICKLIN ST MILLBANK (LICHTY DEL)',
                                  'serial': 'C83B8F',
                                  'serial_number': 'C83B8F',
                                  'system_mac_address': None},
                'C83BA6': {       'dev_macs': ['84:d3:43:0f:b8:cb'],
                                  'ip_address': None,
                                  'name': '16 Jo-Lene Ct. Milverton (Doug Biesinger '
                                          '10402290)',
                                  'serial': 'C83BA6',
                                  'serial_number': 'C83BA6',
                                  'system_mac_address': None},
                'C83BAF': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4082 WATERLOO ST (WEBERS FOAM INSULATION)',
                                  'serial': 'C83BAF',
                                  'serial_number': 'C83BAF',
                                  'system_mac_address': None},
                'C83BB4': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4086 PRINCESS ST MILLBANK (ZEHR DAVID)',
                                  'serial': 'C83BB4',
                                  'serial_number': 'C83BB4',
                                  'system_mac_address': None},
                'C83BB8': {       'dev_macs': ['b8:94:70:9e:ca:a7'],
                                  'ip_address': None,
                                  'name': '81 PUGH ST (HEAD JOSH)',
                                  'serial': 'C83BB8',
                                  'serial_number': 'C83BB8',
                                  'system_mac_address': None},
                'C83BBC': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4049 PRINCESS ST (BIEHN RUTH ANNE)',
                                  'serial': 'C83BBC',
                                  'serial_number': 'C83BBC',
                                  'system_mac_address': None},
                'C83BC5': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '162 FISHLEIGH ST',
                                  'serial': 'C83BC5',
                                  'serial_number': 'C83BC5',
                                  'system_mac_address': None},
                'C83BC6': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6933 PERTH ROAD 121 (STREICHER ADAM)',
                                  'serial': 'C83BC6',
                                  'serial_number': 'C83BC6',
                                  'system_mac_address': None},
                'C83BC8': {       'dev_macs': ['60:db:98:09:3a:0d'],
                                  'ip_address': None,
                                  'name': '4059 NORFOLK ST (POOLE BRIAN)',
                                  'serial': 'C83BC8',
                                  'serial_number': 'C83BC8',
                                  'system_mac_address': None},
                'C83BC9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6976 MILLBANK MAIN ST (WYE CROSS '
                                          'PROPERTIES)',
                                  'serial': 'C83BC9',
                                  'serial_number': 'C83BC9',
                                  'system_mac_address': None},
                'C83BCF': {       'dev_macs': ['14:21:03:d1:7d:62'],
                                  'ip_address': None,
                                  'name': '188 ERSKINE ST (RAMIREZ CARLOS)',
                                  'serial': 'C83BCF',
                                  'serial_number': 'C83BCF',
                                  'system_mac_address': None},
                'C83BD5': {       'dev_macs': ['14:21:03:92:e9:8f'],
                                  'ip_address': None,
                                  'name': '6999 MILLBANK MAIN ST (JANTZI EZRA & '
                                          'ELIZABETH)',
                                  'serial': 'C83BD5',
                                  'serial_number': 'C83BD5',
                                  'system_mac_address': None},
                'C83BD8': {       'dev_macs': ['84:d3:43:6d:ed:0b'],
                                  'ip_address': None,
                                  'name': '11 ST MARYS ST S (FRIESEN PETER)',
                                  'serial': 'C83BD8',
                                  'serial_number': 'C83BD8',
                                  'system_mac_address': None},
                'C83BE6': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6476 PERTH ROAD 131 (DYCK ABRAM W)',
                                  'serial': 'C83BE6',
                                  'serial_number': 'C83BE6',
                                  'system_mac_address': None},
                'C83BED': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '85 PUGH ST (CARTER ASHLEY)',
                                  'serial': 'C83BED',
                                  'serial_number': 'C83BED',
                                  'system_mac_address': None},
                'C83BF0': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6996 MILLBANK MAIN ST (GERBER FLOYD)',
                                  'serial': 'C83BF0',
                                  'serial_number': 'C83BF0',
                                  'system_mac_address': None},
                'C83BF5': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '220 SELBY AV (GREENWALD ROBERT)',
                                  'serial': 'C83BF5',
                                  'serial_number': 'C83BF5',
                                  'system_mac_address': None},
                'C83BFA': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6989 FREEBORN ST (JANTZI JOHN & MALLORY)',
                                  'serial': 'C83BFA',
                                  'serial_number': 'C83BFA',
                                  'system_mac_address': None},
                'C83BFF': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6990 FREEBORN ST (ROBERTS RICHARD & JUDY)',
                                  'serial': 'C83BFF',
                                  'serial_number': 'C83BFF',
                                  'system_mac_address': None},
                'C83C02': {       'dev_macs': ['60:db:98:09:3b:6d'],
                                  'ip_address': None,
                                  'name': '61 MAIN ST N (VATERS CARLIE)',
                                  'serial': 'C83C02',
                                  'serial_number': 'C83C02',
                                  'system_mac_address': None},
                'C83C16': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4038 PERTH LINE 72 (KUEPFER JOE)',
                                  'serial': 'C83C16',
                                  'serial_number': 'C83C16',
                                  'system_mac_address': None},
                'C83C1D': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '77 MADDISON ST W (MCEWEN COLLEEN)',
                                  'serial': 'C83C1D',
                                  'serial_number': 'C83C1D',
                                  'system_mac_address': None},
                'C83C21': {       'dev_macs': ['60:db:98:82:01:8f'],
                                  'ip_address': None,
                                  'name': '64 SCHADE ST (YUNDT D DAWN)',
                                  'serial': 'C83C21',
                                  'serial_number': 'C83C21',
                                  'system_mac_address': None},
                'C83E3A': {       'dev_macs': ['84:d3:43:0f:bc:9e'],
                                  'ip_address': None,
                                  'name': '83 GERBER DR (JAMES COLLEEN)',
                                  'serial': 'C83E3A',
                                  'serial_number': 'C83E3A',
                                  'system_mac_address': None},
                'CBD160': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6964 MILLBANK MAIN ST (DORSCHT RANDY)',
                                  'serial': 'CBD160',
                                  'serial_number': 'CBD160',
                                  'system_mac_address': None},
                'CBD16C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '149 PUGH ST (WRIGHT BRITTANY)',
                                  'serial': 'CBD16C',
                                  'serial_number': 'CBD16C',
                                  'system_mac_address': None},
                'CBD16D': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '151 PUGH ST (PICKERING RICHARD)',
                                  'serial': 'CBD16D',
                                  'serial_number': 'CBD16D',
                                  'system_mac_address': None},
                'CBD189': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6975 FREEBORN ST (CHAPMAN GORDON R)',
                                  'serial': 'CBD189',
                                  'serial_number': 'CBD189',
                                  'system_mac_address': None},
                'CBD194': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6984 FREEBORN ST (CUNNINGHAM ELAINE)',
                                  'serial': 'CBD194',
                                  'serial_number': 'CBD194',
                                  'system_mac_address': None},
                'CBD19C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6994 FREEBORN ST (ERB LLOYD & LAURENE)',
                                  'serial': 'CBD19C',
                                  'serial_number': 'CBD19C',
                                  'system_mac_address': None},
                'CBD19D': {       'dev_macs': ['d0:76:8f:91:d6:5e'],
                                  'ip_address': None,
                                  'name': '77 PUGH ST (LUDWIG VICTOR)',
                                  'serial': 'CBD19D',
                                  'serial_number': 'CBD19D',
                                  'system_mac_address': None},
                'CBD1BC': {       'dev_macs': ['60:db:98:09:39:b5'],
                                  'ip_address': None,
                                  'name': '6980 MILLBANK MAIN ST (ELIZABETH WATSON '
                                          'FLORAL)',
                                  'serial': 'CBD1BC',
                                  'serial_number': 'CBD1BC',
                                  'system_mac_address': None},
                'CBD1D6': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '22 Maddison St., East, Monkton (Greg & '
                                          'Kathy Leung)',
                                  'serial': 'CBD1D6',
                                  'serial_number': 'CBD1D6',
                                  'system_mac_address': None},
                'CBD1E8': {       'dev_macs': ['84:d3:43:6d:fa:9f'],
                                  'ip_address': None,
                                  'name': '48 MAIN ST N (SCHLOSSER KYLE)',
                                  'serial': 'CBD1E8',
                                  'serial_number': 'CBD1E8',
                                  'system_mac_address': None},
                'CBD1F3': {       'dev_macs': ['b8:94:70:9e:cf:e5'],
                                  'ip_address': None,
                                  'name': '6996 FREEBORN ST (BIGAM RONALD)',
                                  'serial': 'CBD1F3',
                                  'serial_number': 'CBD1F3',
                                  'system_mac_address': None},
                'CBD212': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5908 PERTH ROAD 119 (JANTZI MYRON)',
                                  'serial': 'CBD212',
                                  'serial_number': 'CBD212',
                                  'system_mac_address': None},
                'CBD222': {       'dev_macs': [       '5c:0f:fb:14:3c:4a',
                                                      '5c:0f:fb:17:66:c8',
                                                      'd0:76:8f:02:f7:00'],
                                  'ip_address': None,
                                  'name': '89 GERBER DR (ALVES JORGE)',
                                  'serial': 'CBD222',
                                  'serial_number': 'CBD222',
                                  'system_mac_address': None},
                'CBD224': {       'dev_macs': ['d0:76:8f:91:d6:69'],
                                  'ip_address': None,
                                  'name': '91 REAGAN ST (CASTRO FATIMA  D)',
                                  'serial': 'CBD224',
                                  'serial_number': 'CBD224',
                                  'system_mac_address': None},
                'CBD233': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '32 GERBER DRIVE (NAFZIGER BARB)',
                                  'serial': 'CBD233',
                                  'serial_number': 'CBD233',
                                  'system_mac_address': None},
                'CBD27E': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4541 LINE 61 (NAFZIGER STEVE)',
                                  'serial': 'CBD27E',
                                  'serial_number': 'CBD27E',
                                  'system_mac_address': None},
                'CBD29D': {       'dev_macs': ['54:af:97:39:64:4d'],
                                  'ip_address': None,
                                  'name': '34 Mill St. E. Milverton (Dale Brubacher '
                                          '10431281)',
                                  'serial': 'CBD29D',
                                  'serial_number': 'CBD29D',
                                  'system_mac_address': None},
                'CBE02B': {       'dev_macs': ['d0:76:8f:02:f1:75'],
                                  'ip_address': None,
                                  'name': '153 PUGH ST (ZURBRIGG CHANTELLE)',
                                  'serial': 'CBE02B',
                                  'serial_number': 'CBE02B',
                                  'system_mac_address': None},
                'CBE05B': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '54 MILL ST E (STOREY GRANT)',
                                  'serial': 'CBE05B',
                                  'serial_number': 'CBE05B',
                                  'system_mac_address': None},
                'CBFF4': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '5250 Line 60 (Theo Kersten)',
                                 'serial': 'CBFF4',
                                 'serial_number': 'CBFF4',
                                 'system_mac_address': None},
                'CBFF5': {       'dev_macs': ['ec:4f:82:2d:48:f4'],
                                 'ip_address': None,
                                 'name': '5433 Line 60 (Joanne Ohm)',
                                 'serial': 'CBFF5',
                                 'serial_number': 'CBFF5',
                                 'system_mac_address': None},
                'CC074': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '4713 Line 64 (Scott Steckly 10421864)',
                                 'serial': 'CC074',
                                 'serial_number': 'CC074',
                                 'system_mac_address': None},
                'CC075': {       'dev_macs': ['e8:9f:80:75:ac:4f'],
                                 'ip_address': None,
                                 'name': '48 Mill St. E. Milverton (Michelle Corbett)',
                                 'serial': 'CC075',
                                 'serial_number': 'CC075',
                                 'system_mac_address': None},
                'CC07F': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '3 Llana Heights Milverton (Deewar Randy)',
                                 'serial': 'CC07F',
                                 'serial_number': 'CC07F',
                                 'system_mac_address': None},
                'CC08C': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '45 Maddison St. W. Monkton (Darryl Smith)',
                                 'serial': 'CC08C',
                                 'serial_number': 'CC08C',
                                 'system_mac_address': None},
                'CC095': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '41 Mill St. E. Milverton (Rob Woodrow)',
                                 'serial': 'CC095',
                                 'serial_number': 'CC095',
                                 'system_mac_address': None},
                'CC09A': {       'dev_macs': ['04:bc:9f:46:92:a6'],
                                 'ip_address': None,
                                 'name': '62 MILL ST E (RICHARDSON CLAIRE)',
                                 'serial': 'CC09A',
                                 'serial_number': 'CC09A',
                                 'system_mac_address': None},
                'CC0B4': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '30 Maddison St. W. Monkton (Nancy Diehl)',
                                 'serial': 'CC0B4',
                                 'serial_number': 'CC0B4',
                                 'system_mac_address': None},
                'CC0B8': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '66 Maddison St. E. Monkton (Dan Brown)',
                                 'serial': 'CC0B8',
                                 'serial_number': 'CC0B8',
                                 'system_mac_address': None},
                'CC0BF': {       'dev_macs': ['14:21:03:a9:6f:d9'],
                                 'ip_address': None,
                                 'name': '7 JO-LENE CT (ALEXANDER ADRIAN)',
                                 'serial': 'CC0BF',
                                 'serial_number': 'CC0BF',
                                 'system_mac_address': None},
                'CC0C1': {       'dev_macs': ['cc:be:59:2d:a4:f0'],
                                 'ip_address': None,
                                 'name': '11 JO-LENE CT (BARKER PATRICIA)',
                                 'serial': 'CC0C1',
                                 'serial_number': 'CC0C1',
                                 'system_mac_address': None},
                'CC0C2': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '22 Arena Dr. Milverton (Hairstyling '
                                         'Headquarters 10401026)',
                                 'serial': 'CC0C2',
                                 'serial_number': 'CC0C2',
                                 'system_mac_address': None},
                'CC0C5': {       'dev_macs': ['14:21:03:8b:71:6b'],
                                 'ip_address': None,
                                 'name': '60 WILLIAM ST (JANTZI AARON J/MARTHA)',
                                 'serial': 'CC0C5',
                                 'serial_number': 'CC0C5',
                                 'system_mac_address': None},
                'CC0C9': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '10 St. Marys St. S. Milverton (Ron '
                                         'Schweitzer)',
                                 'serial': 'CC0C9',
                                 'serial_number': 'CC0C9',
                                 'system_mac_address': None},
                'CC0CC': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '5 LLANA HEIGHTS DR (PRESCOTT BRENDA)',
                                 'serial': 'CC0CC',
                                 'serial_number': 'CC0CC',
                                 'system_mac_address': None},
                'CC0D4': {       'dev_macs': [       '00:03:4f:09:c6:0a',
                                                     '00:80:a3:d7:b0:51',
                                                     '24:0f:9b:14:2e:5d',
                                                     'd0:67:e5:ab:f7:82',
                                                     'f0:9f:c2:d0:dc:59'],
                                 'ip_address': None,
                                 'name': '6372 PERTH ROAD 131 (COUNTY OF PERTH)',
                                 'serial': 'CC0D4',
                                 'serial_number': 'CC0D4',
                                 'system_mac_address': None},
                'CC0D5': {       'dev_macs': ['10:c3:7b:a3:51:38'],
                                 'ip_address': None,
                                 'name': '32 Gerber Ct. Milverton (Ken Leduc)',
                                 'serial': 'CC0D5',
                                 'serial_number': 'CC0D5',
                                 'system_mac_address': None},
                'D3E32': {       'dev_macs': ['c8:4f:86:c6:42:10'],
                                 'ip_address': None,
                                 'name': '50 William St. Milverton (Dr. Hodes & '
                                         'Anderson 10401327)',
                                 'serial': 'D3E32',
                                 'serial_number': 'D3E32',
                                 'system_mac_address': None},
                'D3E4E': {       'dev_macs': [],
                                 'ip_address': None,
                                 'name': '111 Mill St. E. Milverton',
                                 'serial': 'D3E4E',
                                 'serial_number': 'D3E4E',
                                 'system_mac_address': None},
                'DFFB40': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4084 PRINCESS ST (REINDL MELISSA)',
                                  'serial': 'DFFB40',
                                  'serial_number': 'DFFB40',
                                  'system_mac_address': None},
                'DFFB59': {       'dev_macs': [       '5c:0f:fb:17:6b:86',
                                                      '60:db:98:09:3c:e3'],
                                  'ip_address': None,
                                  'name': '10 MACBETH ST, Milverton (SCHMIDT JOSH)',
                                  'serial': 'DFFB59',
                                  'serial_number': 'DFFB59',
                                  'system_mac_address': None},
                'DFFB8B': {       'dev_macs': ['14:21:03:92:ec:2e'],
                                  'ip_address': None,
                                  'name': '4063 NORFOLK ST (SADIWNYK CATHERINE)',
                                  'serial': 'DFFB8B',
                                  'serial_number': 'DFFB8B',
                                  'system_mac_address': None},
                'DFFB92': {       'dev_macs': ['84:d3:43:6d:ee:a2'],
                                  'ip_address': None,
                                  'name': '11 Wilfred St. Milverton (Steve Court '
                                          '10403171)',
                                  'serial': 'DFFB92',
                                  'serial_number': 'DFFB92',
                                  'system_mac_address': None},
                'DFFC02': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4058 NORFOLK ST (KUEPFER RAYMOND K)',
                                  'serial': 'DFFC02',
                                  'serial_number': 'DFFC02',
                                  'system_mac_address': None},
                'DFFC32': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4851 LINE 67 (KUEPFER BRIAN)',
                                  'serial': 'DFFC32',
                                  'serial_number': 'DFFC32',
                                  'system_mac_address': None},
                'DFFC70': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4056 WATERLOO ST (GIESBRECHT ABRAM & '
                                          'KATHARINA)',
                                  'serial': 'DFFC70',
                                  'serial_number': 'DFFC70',
                                  'system_mac_address': None},
                'DFFD38': {       'dev_macs': ['84:d3:43:6d:ec:2f'],
                                  'ip_address': None,
                                  'name': '4066 WATERLOO ST (BARRY ALEXANDER)',
                                  'serial': 'DFFD38',
                                  'serial_number': 'DFFD38',
                                  'system_mac_address': None},
                'DFFD90': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4079 PRINCESS ST (MAGDANZ VERONIKA)',
                                  'serial': 'DFFD90',
                                  'serial_number': 'DFFD90',
                                  'system_mac_address': None},
                'DFFD9C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4094 PRINCESS ST (DISTEFAN RIA)',
                                  'serial': 'DFFD9C',
                                  'serial_number': 'DFFD9C',
                                  'system_mac_address': None},
                'DFFDA2': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6991 CHURCH ST (TOMBLIN PAUL)',
                                  'serial': 'DFFDA2',
                                  'serial_number': 'DFFDA2',
                                  'system_mac_address': None},
                'DFFDB2': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6992 MILLBANK MAIN ST (BULMAR WYATT)',
                                  'serial': 'DFFDB2',
                                  'serial_number': 'DFFDB2',
                                  'system_mac_address': None},
                'DFFDB9': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4088 PERTH LINE 72 (MORNINGSTAR CHRISTIAN '
                                          'SCHOOL)',
                                  'serial': 'DFFDB9',
                                  'serial_number': 'DFFDB9',
                                  'system_mac_address': None},
                'DFFDD7': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4090 HILLCREST ST (WAGLER A M)',
                                  'serial': 'DFFDD7',
                                  'serial_number': 'DFFDD7',
                                  'system_mac_address': None},
                'DFFDE0': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4094 HILLCREST ST MILLBANK (LINGELBACH '
                                          'BRITTANY)',
                                  'serial': 'DFFDE0',
                                  'serial_number': 'DFFDE0',
                                  'system_mac_address': None},
                'DFFDE8': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '97 PUGH ST (SKOMRA MARGARET)',
                                  'serial': 'DFFDE8',
                                  'serial_number': 'DFFDE8',
                                  'system_mac_address': None},
                'DFFDFA': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '2 MAIN ST N (PHYSIOTHERAPY ALLIANCE)',
                                  'serial': 'DFFDFA',
                                  'serial_number': 'DFFDFA',
                                  'system_mac_address': None},
                'DFFDFF': {       'dev_macs': [       'e4:6c:d1:4e:eb:33',
                                                      'e4:6c:d1:4e:e8:52',
                                                      'e4:6c:d1:4e:ee:a3',
                                                      'e4:6c:d1:4e:f1:63'],
                                  'ip_address': None,
                                  'name': 'Inventory (Room)',
                                  'serial': 'DFFDFF',
                                  'serial_number': 'DFFDFF',
                                  'system_mac_address': None},
                'DFFE01': {       'dev_macs': ['84:d3:43:0f:bc:30'],
                                  'ip_address': None,
                                  'name': '7 SCHADE ST (BAST SANDI)',
                                  'serial': 'DFFE01',
                                  'serial_number': 'DFFE01',
                                  'system_mac_address': None},
                'DFFE0C': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6967 PERTH ST (BRENNEMAN JEREMY & BEVERLEY)',
                                  'serial': 'DFFE0C',
                                  'serial_number': 'DFFE0C',
                                  'system_mac_address': None},
                'DFFE10': {       'dev_macs': ['18:fd:74:1f:86:f6'],
                                  'ip_address': None,
                                  'name': '5208 LINE 58 (GINGRICH MIKE)',
                                  'serial': 'DFFE10',
                                  'serial_number': 'DFFE10',
                                  'system_mac_address': None},
                'DFFE12': {       'dev_macs': ['b8:94:70:bc:b5:41'],
                                  'ip_address': None,
                                  'name': '5518 ROAD 144 (PAXTON WAYNE & JUDY)',
                                  'serial': 'DFFE12',
                                  'serial_number': 'DFFE12',
                                  'system_mac_address': None},
                'DFFE27': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6973 CHURCH ST (HANDORF BEN)',
                                  'serial': 'DFFE27',
                                  'serial_number': 'DFFE27',
                                  'system_mac_address': None},
                'DFFE2D': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '6969 PERTH ST (WAGLER PAUL & DARLENE)',
                                  'serial': 'DFFE2D',
                                  'serial_number': 'DFFE2D',
                                  'system_mac_address': None},
                'DFFE31': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4052 NORFOLK ST (KUEPFER NELSON)',
                                  'serial': 'DFFE31',
                                  'serial_number': 'DFFE31',
                                  'system_mac_address': None},
                'DFFE3F': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4091 PRINCESS ST (REIMER DARREN & LISA)',
                                  'serial': 'DFFE3F',
                                  'serial_number': 'DFFE3F',
                                  'system_mac_address': None},
                'DFFE41': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4059 PRINCESS ST (BUECKERT HENRY & ANNA)',
                                  'serial': 'DFFE41',
                                  'serial_number': 'DFFE41',
                                  'system_mac_address': None},
                'DFFE42': {       'dev_macs': ['44:65:7f:89:0e:2b'],
                                  'ip_address': None,
                                  'name': '124 Maddison St. East, Monkton (Vanessa '
                                          'Schiestel 10435517)',
                                  'serial': 'DFFE42',
                                  'serial_number': 'DFFE42',
                                  'system_mac_address': None},
                'DFFE44': {       'dev_macs': ['ec:4f:82:2c:71:b1'],
                                  'ip_address': None,
                                  'name': '2 MAIN ST N (SUTHERLAND RAVEN)',
                                  'serial': 'DFFE44',
                                  'serial_number': 'DFFE44',
                                  'system_mac_address': None},
                'DFFE4A': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '4053 PRINCESS ST (VAN BAKEL BRYAN)',
                                  'serial': 'DFFE4A',
                                  'serial_number': 'DFFE4A',
                                  'system_mac_address': None},
                'EBBDB0': {       'dev_macs': [],
                                  'ip_address': None,
                                  'name': '5101 PERTH LINE 55 (VAN DER WAL JOHN)',
                                  'serial': 'EBBDB0',
                                  'serial_number': 'EBBDB0',
                                  'system_mac_address': None},
                'FD873C': {       'dev_macs': ['ec:4f:82:2b:48:d5'],
                                  'ip_address': None,
                                  'name': '5208 Line 60 (Louis Byler)',
                                  'serial': 'FD873C',
                                  'serial_number': 'FD873C',
                                  'system_mac_address': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': 'front',
                                                              'mac_address': '00:02:5d:db:26:8a',
                                                              'name': 'Craft-FE: front',
                                                              'oper_up': True,
                                                              'poller_hash': 'NzE0MTI5MTMwOTJmcm9udA=='},
                                                      {       'admin_up': False,
                                                              'id': 'rear-A',
                                                              'name': 'Craft-FE: '
                                                                      'rear-A',
                                                              'oper_up': False,
                                                              'poller_hash': 'NzE0MTI5MTMwOTJyZWFyLUE='},
                                                      {       'admin_up': False,
                                                              'id': 'rear-B',
                                                              'name': 'Craft-FE: '
                                                                      'rear-B',
                                                              'oper_up': False,
                                                              'poller_hash': 'NzE0MTI5MTMwOTJyZWFyLUI='}],
                                'manufacturer': 'Calix',
                                'model': 'E7-20',
                                'modules': [       {       'id': '1',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '1/1',
                                                                                         'in_discards': '1886',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2747107',
                                                                                         'in_octets': '3654748878252',
                                                                                         'in_ucast_pkts': '16421940592',
                                                                                         'links': [       {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '43543160581',
                                                                                                                  'in_ucast_pkts': '4590173464',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '25',
                                                                                                                  'out_octets': '1147333703828',
                                                                                                                  'out_ucast_pkts': '888658367',
                                                                                                                  'poller_hash': 'NDJDQTMwcGVlcmludGZwb24gNTU1'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '811310843311',
                                                                                                                  'in_ucast_pkts': '10258512801',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '8150663018680',
                                                                                                                  'out_ucast_pkts': '6113749652',
                                                                                                                  'poller_hash': 'ODcyNEVBcGVlcmludGZwb24gMTQzMTQ3'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '89852096030',
                                                                                                                  'in_ucast_pkts': '121120392',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '26',
                                                                                                                  'out_octets': '316429571559',
                                                                                                                  'out_ucast_pkts': '305085255',
                                                                                                                  'poller_hash': 'QzgxRUFEcGVlcmludGZwb24gMTU2ODcx'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '13429344474',
                                                                                                                  'in_ucast_pkts': '59313160',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '582538260235',
                                                                                                                  'out_ucast_pkts': '474729193',
                                                                                                                  'poller_hash': 'MTI3NDA1NHBlZXJpbnRmcG9uIDI1MTU2OQ=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '23941028851',
                                                                                                                  'in_ucast_pkts': '229513627',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '1195536599962',
                                                                                                                  'out_ucast_pkts': '823461452',
                                                                                                                  'poller_hash': 'MTI5NzNFMXBlZXJpbnRmcG9uIDI2Mzg5Ng=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MTI3MzlEOXBlZXJpbnRmcG9uIDI3NzM2Nw=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '5940634675',
                                                                                                                  'in_ucast_pkts': '16764845',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '44381762322',
                                                                                                                  'out_ucast_pkts': '40081754',
                                                                                                                  'poller_hash': 'MTI3MzhGM3BlZXJpbnRmcG9uIDI3OTk4NA=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-00000',
                                                                                         'name': 'gpon '
                                                                                                 '1/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '33879560977',
                                                                                         'out_octets': '118977625294158',
                                                                                         'out_ucast_pkts': '53297262333',
                                                                                         'poller_hash': 'MjExNDEwNjAxMjg5Z3BvbiAxLzE=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/1',
                                                                                                                 'id': '1/1',
                                                                                                                 'links': [       {       'connected_time': '688333',
                                                                                                                                          'fiber_length': 1340,
                                                                                                                                          'poller_hash': 'NDJDQTMwcGVlcnBvbnBvbiA1NTU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 2.118},
                                                                                                                                  {       'connected_time': '688334',
                                                                                                                                          'fiber_length': 1122,
                                                                                                                                          'poller_hash': 'ODcyNEVBcGVlcnBvbnBvbiAxNDMxNDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 2.118},
                                                                                                                                  {       'connected_time': '24119266',
                                                                                                                                          'fiber_length': 622,
                                                                                                                                          'poller_hash': 'QzgxRUFEcGVlcnBvbnBvbiAxNTY4NzE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 2.118},
                                                                                                                                  {       'connected_time': '688325',
                                                                                                                                          'fiber_length': 1370,
                                                                                                                                          'poller_hash': 'MTI3NDA1NHBlZXJwb25wb24gMjUxNTY5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 2.118},
                                                                                                                                  {       'connected_time': '688333',
                                                                                                                                          'fiber_length': 1336,
                                                                                                                                          'poller_hash': 'MTI5NzNFMXBlZXJwb25wb24gMjYzODk2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 2.118},
                                                                                                                                  {       'connected_time': '9698186',
                                                                                                                                          'fiber_length': 1639,
                                                                                                                                          'poller_hash': 'MTI3MzlEOXBlZXJwb25wb24gMjc3MzY3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 2.118},
                                                                                                                                  {       'connected_time': '688343',
                                                                                                                                          'fiber_length': 1599,
                                                                                                                                          'poller_hash': 'MTI3MzhGM3BlZXJwb25wb24gMjc5OTg0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 2.118}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/1',
                                                                                                                 'poller_hash': 'MjExNDEwNjAxMjg5cG9uZ3BvbiAxLzE=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/2',
                                                                                         'in_discards': '10030',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '3187421',
                                                                                         'in_octets': '3874726021771',
                                                                                         'in_ucast_pkts': '13768047395',
                                                                                         'links': [       {       'in_nucast_pkts': '670571',
                                                                                                                  'in_octets': '1099345285121',
                                                                                                                  'in_ucast_pkts': '3136493142',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '89055775',
                                                                                                                  'out_octets': '12246326613504',
                                                                                                                  'out_ucast_pkts': '9561568069',
                                                                                                                  'poller_hash': 'MTI3NDBFRHBlZXJpbnRmcG9uIDI0NjU3MQ=='},
                                                                                                          {       'in_nucast_pkts': '593380',
                                                                                                                  'in_octets': '254211694243',
                                                                                                                  'in_ucast_pkts': '2110349588',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '77346422',
                                                                                                                  'out_octets': '12963656033255',
                                                                                                                  'out_ucast_pkts': '8774499208',
                                                                                                                  'poller_hash': 'MTE3REFFOHBlZXJpbnRmcG9uIDI1MDA0NA=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '141415249998',
                                                                                                                  'in_ucast_pkts': '34710156580',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '26',
                                                                                                                  'out_octets': '2271014758427',
                                                                                                                  'out_ucast_pkts': '1719259161',
                                                                                                                  'poller_hash': 'MTE3RDlERXBlZXJpbnRmcG9uIDI1MDA1NA=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '51862057841',
                                                                                                                  'in_ucast_pkts': '299859186',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4',
                                                                                                                  'out_octets': '1609948040095',
                                                                                                                  'out_ucast_pkts': '1191846291',
                                                                                                                  'poller_hash': 'MTBBODcxRHBlZXJpbnRmcG9uIDI1MDA5NA=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '286214671837',
                                                                                                                  'in_ucast_pkts': '813104367',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '26',
                                                                                                                  'out_octets': '3280063497982',
                                                                                                                  'out_ucast_pkts': '2595178367',
                                                                                                                  'poller_hash': 'MTE3REMyN3BlZXJpbnRmcG9uIDI1MTgwNQ=='},
                                                                                                          {       'in_nucast_pkts': '4543',
                                                                                                                  'in_octets': '587983643',
                                                                                                                  'in_ucast_pkts': '1870851',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '541495',
                                                                                                                  'out_octets': '10391722720',
                                                                                                                  'out_ucast_pkts': '7816061',
                                                                                                                  'poller_hash': 'MTE3REMyQXBlZXJpbnRmcG9uIDI1MzQ5Ng=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '12955731561',
                                                                                                                  'in_ucast_pkts': '61565163',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '26',
                                                                                                                  'out_octets': '396613973719',
                                                                                                                  'out_ucast_pkts': '313195627',
                                                                                                                  'poller_hash': 'MTE3REJDQXBlZXJpbnRmcG9uIDI1MzUzNw=='},
                                                                                                          {       'in_nucast_pkts': '5370',
                                                                                                                  'in_octets': '3753327020',
                                                                                                                  'in_ucast_pkts': '7535005',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '541504',
                                                                                                                  'out_octets': '31709746042',
                                                                                                                  'out_ucast_pkts': '25903738',
                                                                                                                  'poller_hash': 'MTE3REFFM3BlZXJpbnRmcG9uIDI1NDU3MQ=='},
                                                                                                          {       'in_nucast_pkts': '9601',
                                                                                                                  'in_octets': '3179935927',
                                                                                                                  'in_ucast_pkts': '16421375',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1151535',
                                                                                                                  'out_octets': '112012841839',
                                                                                                                  'out_ucast_pkts': '79426269',
                                                                                                                  'poller_hash': 'MTI5NzRBQ3BlZXJpbnRmcG9uIDI1NjQ0Mg=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '49632428656',
                                                                                                                  'in_ucast_pkts': '62216055',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '26',
                                                                                                                  'out_octets': '100000718199',
                                                                                                                  'out_ucast_pkts': '126863025',
                                                                                                                  'poller_hash': 'MTI5NzQ1N3BlZXJpbnRmcG9uIDI1NjY2Ng=='},
                                                                                                          {       'in_nucast_pkts': '4585',
                                                                                                                  'in_octets': '2566691564',
                                                                                                                  'in_ucast_pkts': '11276635',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '541542',
                                                                                                                  'out_octets': '34862678993',
                                                                                                                  'out_ucast_pkts': '26565068',
                                                                                                                  'poller_hash': 'MTI3NDg3NHBlZXJpbnRmcG9uIDI2NTY0Nw=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '95544726483',
                                                                                                                  'in_ucast_pkts': '179516480',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '26',
                                                                                                                  'out_octets': '976682089103',
                                                                                                                  'out_ucast_pkts': '726155109',
                                                                                                                  'poller_hash': 'MTI3NDRCMnBlZXJpbnRmcG9uIDI2NjMxMA=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MTI5NzNCMHBlZXJpbnRmcG9uIDI3MjAzOQ=='},
                                                                                                          {       'in_nucast_pkts': '5196',
                                                                                                                  'in_octets': '4835430372',
                                                                                                                  'in_ucast_pkts': '13887485',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '541539',
                                                                                                                  'out_octets': '95566663649',
                                                                                                                  'out_ucast_pkts': '71523342',
                                                                                                                  'poller_hash': 'MTI3NDdDMXBlZXJpbnRmcG9uIDI3MjI3Mg=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '69931149231',
                                                                                                                  'in_ucast_pkts': '353607186',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '1332045539730',
                                                                                                                  'out_ucast_pkts': '978914800',
                                                                                                                  'poller_hash': 'MTI3NDg3MXBlZXJpbnRmcG9uIDI3MjU1Nw=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '28775729668',
                                                                                                                  'in_ucast_pkts': '257200647',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '1987845766194',
                                                                                                                  'out_ucast_pkts': '1354257246',
                                                                                                                  'poller_hash': 'MTI3NDhBMXBlZXJpbnRmcG9uIDI3MjU3Nw=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '5421787',
                                                                                                                  'in_ucast_pkts': '21112',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '221033891',
                                                                                                                  'out_ucast_pkts': '175166',
                                                                                                                  'poller_hash': 'MTI5NjAyMnBlZXJpbnRmcG9uIDI4NjMzNg=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': 'gpon '
                                                                                                 '1/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '146550636',
                                                                                         'out_octets': '70261794628565',
                                                                                         'out_ucast_pkts': '51410431473',
                                                                                         'poller_hash': 'MjExNDEwNjAxMjg5Z3BvbiAxLzI=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/2',
                                                                                                                 'id': '1/2',
                                                                                                                 'links': [       {       'connected_time': '68517793',
                                                                                                                                          'fiber_length': 20771,
                                                                                                                                          'poller_hash': 'MTI3NDBFRHBlZXJwb25wb24gMjQ2NTcx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.372},
                                                                                                                                  {       'connected_time': '64566130',
                                                                                                                                          'fiber_length': 20621,
                                                                                                                                          'poller_hash': 'MTE3REFFOHBlZXJwb25wb24gMjUwMDQ0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.372},
                                                                                                                                  {       'connected_time': '262226',
                                                                                                                                          'fiber_length': 20346,
                                                                                                                                          'poller_hash': 'MTE3RDlERXBlZXJwb25wb24gMjUwMDU0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.372},
                                                                                                                                  {       'connected_time': '538347',
                                                                                                                                          'fiber_length': 22266,
                                                                                                                                          'poller_hash': 'MTBBODcxRHBlZXJwb25wb24gMjUwMDk0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.372},
                                                                                                                                  {       'connected_time': '13204769',
                                                                                                                                          'fiber_length': 20919,
                                                                                                                                          'poller_hash': 'MTE3REMyN3BlZXJwb25wb24gMjUxODA1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.372},
                                                                                                                                  {       'connected_time': '262228',
                                                                                                                                          'fiber_length': 22072,
                                                                                                                                          'poller_hash': 'MTE3REMyQXBlZXJwb25wb24gMjUzNDk2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.372},
                                                                                                                                  {       'connected_time': '28787924',
                                                                                                                                          'fiber_length': 21660,
                                                                                                                                          'poller_hash': 'MTE3REJDQXBlZXJwb25wb24gMjUzNTM3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.372},
                                                                                                                                  {       'connected_time': '262229',
                                                                                                                                          'fiber_length': 20133,
                                                                                                                                          'poller_hash': 'MTE3REFFM3BlZXJwb25wb24gMjU0NTcx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.372},
                                                                                                                                  {       'connected_time': '538350',
                                                                                                                                          'fiber_length': 22718,
                                                                                                                                          'poller_hash': 'MTI5NzRBQ3BlZXJwb25wb24gMjU2NDQy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.372},
                                                                                                                                  {       'connected_time': '262227',
                                                                                                                                          'fiber_length': 21562,
                                                                                                                                          'poller_hash': 'MTI5NzQ1N3BlZXJwb25wb24gMjU2NjY2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.372},
                                                                                                                                  {       'connected_time': '262226',
                                                                                                                                          'fiber_length': 20065,
                                                                                                                                          'poller_hash': 'MTI3NDg3NHBlZXJwb25wb24gMjY1NjQ3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.372},
                                                                                                                                  {       'connected_time': '262226',
                                                                                                                                          'fiber_length': 19850,
                                                                                                                                          'poller_hash': 'MTI3NDRCMnBlZXJwb25wb24gMjY2MzEw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.372},
                                                                                                                                  {       'connected_time': '16333063',
                                                                                                                                          'fiber_length': 19984,
                                                                                                                                          'poller_hash': 'MTI5NzNCMHBlZXJwb25wb24gMjcyMDM5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.372},
                                                                                                                                  {       'connected_time': '262228',
                                                                                                                                          'fiber_length': 22256,
                                                                                                                                          'poller_hash': 'MTI3NDdDMXBlZXJwb25wb24gMjcyMjcy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.372},
                                                                                                                                  {       'connected_time': '262228',
                                                                                                                                          'fiber_length': 21896,
                                                                                                                                          'poller_hash': 'MTI3NDg3MXBlZXJwb25wb24gMjcyNTU3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.372},
                                                                                                                                  {       'connected_time': '15479602',
                                                                                                                                          'fiber_length': 18809,
                                                                                                                                          'poller_hash': 'MTI3NDhBMXBlZXJwb25wb24gMjcyNTc3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.372},
                                                                                                                                  {       'connected_time': '8527',
                                                                                                                                          'fiber_length': 21602,
                                                                                                                                          'poller_hash': 'MTI5NjAyMnBlZXJwb25wb24gMjg2MzM2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.372}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/2',
                                                                                                                 'poller_hash': 'MjExNDEwNjAxMjg5cG9uZ3BvbiAxLzI=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/3',
                                                                                         'in_discards': '6153',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '60236835',
                                                                                         'in_octets': '146642525803087',
                                                                                         'in_ucast_pkts': '153861008447',
                                                                                         'links': [       {       'in_nucast_pkts': '11976',
                                                                                                                  'in_octets': '6354362074',
                                                                                                                  'in_ucast_pkts': '46961627',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1464148',
                                                                                                                  'out_octets': '155316913847',
                                                                                                                  'out_ucast_pkts': '111019602',
                                                                                                                  'poller_hash': 'MkIwMUI3cGVlcmludGZwb24gNTE='},
                                                                                                          {       'in_nucast_pkts': '927303',
                                                                                                                  'in_octets': '914699400952',
                                                                                                                  'in_ucast_pkts': '2464535569',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '149411972',
                                                                                                                  'out_octets': '12316123095237',
                                                                                                                  'out_ucast_pkts': '9285011437',
                                                                                                                  'poller_hash': 'REZGQjkycGVlcmludGZwb24gNTM='},
                                                                                                          {       'in_nucast_pkts': '2741903',
                                                                                                                  'in_octets': '2416585084',
                                                                                                                  'in_ucast_pkts': '18653020',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2224499440',
                                                                                                                  'out_octets': '2868922608599',
                                                                                                                  'out_ucast_pkts': '73599187',
                                                                                                                  'poller_hash': 'MUM1QkE2cGVlcmludGZwb24gNTg='},
                                                                                                          {       'in_nucast_pkts': '1541',
                                                                                                                  'in_octets': '105610075866366',
                                                                                                                  'in_ucast_pkts': '87108680799',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '107535489',
                                                                                                                  'out_octets': '12032421437057',
                                                                                                                  'out_ucast_pkts': '52934690405',
                                                                                                                  'poller_hash': 'MTYwNjQyOHBlZXJpbnRmcG9uIDU5'},
                                                                                                          {       'in_nucast_pkts': '917679',
                                                                                                                  'in_octets': '364800707911',
                                                                                                                  'in_ucast_pkts': '2052409027',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '149410495',
                                                                                                                  'out_octets': '8664543806430',
                                                                                                                  'out_ucast_pkts': '6432738827',
                                                                                                                  'poller_hash': 'MUQwMzNGcGVlcmludGZwb24gNjU='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '452346816936',
                                                                                                                  'in_ucast_pkts': '74539523191',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '123',
                                                                                                                  'out_octets': '4407432749238',
                                                                                                                  'out_ucast_pkts': '3288162902',
                                                                                                                  'poller_hash': 'MUQwNTA1cGVlcmludGZwb24gNjY='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '73943621278',
                                                                                                                  'in_ucast_pkts': '603235882',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '123',
                                                                                                                  'out_octets': '4145346202955',
                                                                                                                  'out_ucast_pkts': '2841598088',
                                                                                                                  'poller_hash': 'MUQwNjhBcGVlcmludGZwb24gNzE='},
                                                                                                          {       'in_nucast_pkts': '9',
                                                                                                                  'in_octets': '2880364493',
                                                                                                                  'in_ucast_pkts': '15934851',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1464249',
                                                                                                                  'out_octets': '78110485530',
                                                                                                                  'out_ucast_pkts': '57736170',
                                                                                                                  'poller_hash': 'MkJEMjZGcGVlcmludGZwb24gMjUz'},
                                                                                                          {       'in_nucast_pkts': '12',
                                                                                                                  'in_octets': '31223212088',
                                                                                                                  'in_ucast_pkts': '159275601',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1464145',
                                                                                                                  'out_octets': '692089196995',
                                                                                                                  'out_ucast_pkts': '488716889',
                                                                                                                  'poller_hash': 'MUQwNjk1cGVlcmludGZwb24gMjg0'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '56113053889',
                                                                                                                  'in_ucast_pkts': '12966358882',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '214',
                                                                                                                  'out_octets': '346587674878',
                                                                                                                  'out_ucast_pkts': '377951399',
                                                                                                                  'poller_hash': 'MkIwMzY4cGVlcmludGZwb24gNDIy'},
                                                                                                          {       'in_nucast_pkts': '9028',
                                                                                                                  'in_octets': '1278341985153',
                                                                                                                  'in_ucast_pkts': '5311681210',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '149457820',
                                                                                                                  'out_octets': '17748755111674',
                                                                                                                  'out_ucast_pkts': '13097536764',
                                                                                                                  'poller_hash': 'MkIwNDRDcGVlcmludGZwb24gNDI5'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '99755286517',
                                                                                                                  'in_ucast_pkts': '488590493',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '123',
                                                                                                                  'out_octets': '3041233838786',
                                                                                                                  'out_ucast_pkts': '10023435811',
                                                                                                                  'poller_hash': 'MjA1RTAzcGVlcmludGZwb24gNDQ2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '471054396504',
                                                                                                                  'in_ucast_pkts': '4207853903',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '123',
                                                                                                                  'out_octets': '14346508048285',
                                                                                                                  'out_ucast_pkts': '10087272070',
                                                                                                                  'poller_hash': 'NDJCOUI2cGVlcmludGZwb24gNDkx'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MzVGOUUwcGVlcmludGZwb24gNTE2'},
                                                                                                          {       'in_nucast_pkts': '14882',
                                                                                                                  'in_octets': '6881749883',
                                                                                                                  'in_ucast_pkts': '44945106',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1464417',
                                                                                                                  'out_octets': '197250513106',
                                                                                                                  'out_ucast_pkts': '146960407',
                                                                                                                  'poller_hash': 'QTlDNkZBcGVlcmludGZwb24gMTQ3ODU0'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '77975867050',
                                                                                         'out_octets': '262614727929200',
                                                                                         'out_ucast_pkts': '175425730371',
                                                                                         'poller_hash': 'MjExNDEwNjAxMjg5Z3BvbiAxLzM=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/3',
                                                                                                                 'id': '1/3',
                                                                                                                 'links': [       {       'connected_time': '688339',
                                                                                                                                          'fiber_length': 1214,
                                                                                                                                          'poller_hash': 'MkIwMUI3cGVlcnBvbnBvbiA1MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -11.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.739},
                                                                                                                                  {       'connected_time': '21815840',
                                                                                                                                          'fiber_length': 1282,
                                                                                                                                          'poller_hash': 'REZGQjkycGVlcnBvbnBvbiA1Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.739},
                                                                                                                                  {       'connected_time': '17711637',
                                                                                                                                          'fiber_length': 1245,
                                                                                                                                          'poller_hash': 'MUM1QkE2cGVlcnBvbnBvbiA1OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -9.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.739},
                                                                                                                                  {       'connected_time': '28789464',
                                                                                                                                          'fiber_length': 1245,
                                                                                                                                          'poller_hash': 'MTYwNjQyOHBlZXJwb25wb24gNTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -12.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.739},
                                                                                                                                  {       'connected_time': '21816621',
                                                                                                                                          'fiber_length': 1304,
                                                                                                                                          'poller_hash': 'MUQwMzNGcGVlcnBvbnBvbiA2NQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -9.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.739},
                                                                                                                                  {       'connected_time': '21541485',
                                                                                                                                          'fiber_length': 1303,
                                                                                                                                          'poller_hash': 'MUQwNTA1cGVlcnBvbnBvbiA2Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.739},
                                                                                                                                  {       'connected_time': '30482265',
                                                                                                                                          'fiber_length': 1370,
                                                                                                                                          'poller_hash': 'MUQwNjhBcGVlcnBvbnBvbiA3MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.739},
                                                                                                                                  {       'connected_time': '688340',
                                                                                                                                          'fiber_length': 1354,
                                                                                                                                          'poller_hash': 'MkJEMjZGcGVlcnBvbnBvbiAyNTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.739},
                                                                                                                                  {       'connected_time': '688359',
                                                                                                                                          'fiber_length': 1301,
                                                                                                                                          'poller_hash': 'MUQwNjk1cGVlcnBvbnBvbiAyODQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -9.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.739},
                                                                                                                                  {       'connected_time': '688338',
                                                                                                                                          'fiber_length': 1205,
                                                                                                                                          'poller_hash': 'MkIwMzY4cGVlcnBvbnBvbiA0MjI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.739},
                                                                                                                                  {       'connected_time': '21815431',
                                                                                                                                          'fiber_length': 1163,
                                                                                                                                          'poller_hash': 'MkIwNDRDcGVlcnBvbnBvbiA0Mjk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -11.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.739},
                                                                                                                                  {       'connected_time': '9448326',
                                                                                                                                          'fiber_length': 1377,
                                                                                                                                          'poller_hash': 'MjA1RTAzcGVlcnBvbnBvbiA0NDY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -11.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.739},
                                                                                                                                  {       'connected_time': '2146718',
                                                                                                                                          'fiber_length': 1328,
                                                                                                                                          'poller_hash': 'NDJCOUI2cGVlcnBvbnBvbiA0OTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.739},
                                                                                                                                  {       'connected_time': '67790133',
                                                                                                                                          'fiber_length': 1193,
                                                                                                                                          'poller_hash': 'MzVGOUUwcGVlcnBvbnBvbiA1MTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -11.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.739},
                                                                                                                                  {       'connected_time': '688351',
                                                                                                                                          'fiber_length': 1183,
                                                                                                                                          'poller_hash': 'QTlDNkZBcGVlcnBvbnBvbiAxNDc4NTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.739}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/3',
                                                                                                                 'poller_hash': 'MjExNDEwNjAxMjg5cG9uZ3BvbiAxLzM=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/4',
                                                                                         'in_discards': '9473',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '12281782',
                                                                                         'in_octets': '4515442372812',
                                                                                         'in_ucast_pkts': '24085688123',
                                                                                         'links': [       {       'in_nucast_pkts': '463446',
                                                                                                                  'in_octets': '158186346784',
                                                                                                                  'in_ucast_pkts': '1063847162',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '58266095',
                                                                                                                  'out_octets': '6525792929733',
                                                                                                                  'out_ucast_pkts': '4552215267',
                                                                                                                  'poller_hash': 'MUQwNTA2cGVlcmludGZwb24gNjA='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '179741728032',
                                                                                                                  'in_ucast_pkts': '1222960041',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '123',
                                                                                                                  'out_octets': '4341598309688',
                                                                                                                  'out_ucast_pkts': '3169524762',
                                                                                                                  'poller_hash': 'MUQwNEY3cGVlcmludGZwb24gNjE='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '78129381355',
                                                                                                                  'in_ucast_pkts': '599263128',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '148',
                                                                                                                  'out_octets': '2311647974021',
                                                                                                                  'out_ucast_pkts': '1683981456',
                                                                                                                  'poller_hash': 'Mjk2RkM3cGVlcmludGZwb24gMTA5'},
                                                                                                          {       'in_nucast_pkts': '289819',
                                                                                                                  'in_octets': '63887590398',
                                                                                                                  'in_ucast_pkts': '734079880',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '36517218',
                                                                                                                  'out_octets': '3781335881931',
                                                                                                                  'out_ucast_pkts': '2525156997',
                                                                                                                  'poller_hash': 'MUQwNTAxcGVlcmludGZwb24gMTYw'},
                                                                                                          {       'in_nucast_pkts': '14728',
                                                                                                                  'in_octets': '6870349557',
                                                                                                                  'in_ucast_pkts': '52466482',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1464137',
                                                                                                                  'out_octets': '186854302522',
                                                                                                                  'out_ucast_pkts': '136376174',
                                                                                                                  'poller_hash': 'OTU2RkFFcGVlcmludGZwb24gMjA0'},
                                                                                                          {       'in_nucast_pkts': '2861729',
                                                                                                                  'in_octets': '191671062003',
                                                                                                                  'in_ucast_pkts': '2613210116',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '199404850',
                                                                                                                  'out_octets': '14602589163063',
                                                                                                                  'out_ucast_pkts': '10340161682',
                                                                                                                  'poller_hash': 'MkIwMTc2cGVlcmludGZwb24gNDA5'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '129576721655',
                                                                                                                  'in_ucast_pkts': '545239413',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '24',
                                                                                                                  'out_octets': '2981215854333',
                                                                                                                  'out_ucast_pkts': '2131144503',
                                                                                                                  'poller_hash': 'MkIwNDNGcGVlcmludGZwb24gNDI1'},
                                                                                                          {       'in_nucast_pkts': '75',
                                                                                                                  'in_octets': '153963567826',
                                                                                                                  'in_ucast_pkts': '409357579',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '15193058',
                                                                                                                  'out_octets': '1844170042210',
                                                                                                                  'out_ucast_pkts': '1287954961',
                                                                                                                  'poller_hash': 'MkIwNDYycGVlcmludGZwb24gNDI4'},
                                                                                                          {       'in_nucast_pkts': '231',
                                                                                                                  'in_octets': '62444615293',
                                                                                                                  'in_ucast_pkts': '520375644',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '69117245',
                                                                                                                  'out_octets': '2865613830770',
                                                                                                                  'out_ucast_pkts': '1951612121',
                                                                                                                  'poller_hash': 'MzVFOTZDcGVlcmludGZwb24gNDMy'},
                                                                                                          {       'in_nucast_pkts': '42',
                                                                                                                  'in_octets': '16115801888',
                                                                                                                  'in_ucast_pkts': '60127040',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1120144',
                                                                                                                  'out_octets': '313170434269',
                                                                                                                  'out_ucast_pkts': '244097670',
                                                                                                                  'poller_hash': 'NDNCMzdEcGVlcmludGZwb24gNzY3'},
                                                                                                          {       'in_nucast_pkts': '218524',
                                                                                                                  'in_octets': '187964415910',
                                                                                                                  'in_ucast_pkts': '1072731480',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '19805635',
                                                                                                                  'out_octets': '4215902741878',
                                                                                                                  'out_ucast_pkts': '2985392652',
                                                                                                                  'poller_hash': 'MkZFQUZBcGVlcmludGZwb24gMjA1NDA2'},
                                                                                                          {       'in_nucast_pkts': '41780097',
                                                                                                                  'in_octets': '388122268558',
                                                                                                                  'in_ucast_pkts': '1272309578',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '22291979323',
                                                                                                                  'out_octets': '33434616137731',
                                                                                                                  'out_ucast_pkts': '3101326650',
                                                                                                                  'poller_hash': 'QzgxRTYzcGVlcmludGZwb24gMjA5MTM0'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MTI3NEE3MHBlZXJpbnRmcG9uIDIzMzY5Mw=='},
                                                                                                          {       'in_nucast_pkts': '749762',
                                                                                                                  'in_octets': '36223637146',
                                                                                                                  'in_ucast_pkts': '471787326',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '163492831',
                                                                                                                  'out_octets': '2765176744157',
                                                                                                                  'out_ucast_pkts': '1926630150',
                                                                                                                  'poller_hash': 'MTI3MERFNnBlZXJpbnRmcG9uIDI3OTE1Nw=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '68536073872',
                                                                                         'out_octets': '196651151840767',
                                                                                         'out_ucast_pkts': '75047245471',
                                                                                         'poller_hash': 'MjExNDEwNjAxMjg5Z3BvbiAxLzQ=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/4',
                                                                                                                 'id': '1/4',
                                                                                                                 'links': [       {       'connected_time': '24544077',
                                                                                                                                          'fiber_length': 1251,
                                                                                                                                          'poller_hash': 'MUQwNTA2cGVlcnBvbnBvbiA2MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.647},
                                                                                                                                  {       'connected_time': '21816522',
                                                                                                                                          'fiber_length': 1250,
                                                                                                                                          'poller_hash': 'MUQwNEY3cGVlcnBvbnBvbiA2MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.647},
                                                                                                                                  {       'connected_time': '15498467',
                                                                                                                                          'fiber_length': 994,
                                                                                                                                          'poller_hash': 'Mjk2RkM3cGVlcnBvbnBvbiAxMDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -9.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.647},
                                                                                                                                  {       'connected_time': '16507268',
                                                                                                                                          'fiber_length': 1172,
                                                                                                                                          'poller_hash': 'MUQwNTAxcGVlcnBvbnBvbiAxNjA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -9.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.647},
                                                                                                                                  {       'connected_time': '688343',
                                                                                                                                          'fiber_length': 955,
                                                                                                                                          'poller_hash': 'OTU2RkFFcGVlcnBvbnBvbiAyMDQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -9.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.647},
                                                                                                                                  {       'connected_time': '30076165',
                                                                                                                                          'fiber_length': 1147,
                                                                                                                                          'poller_hash': 'MkIwMTc2cGVlcnBvbnBvbiA0MDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.647},
                                                                                                                                  {       'connected_time': '688343',
                                                                                                                                          'fiber_length': 1157,
                                                                                                                                          'poller_hash': 'MkIwNDNGcGVlcnBvbnBvbiA0MjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.647},
                                                                                                                                  {       'connected_time': '6487380',
                                                                                                                                          'fiber_length': 851,
                                                                                                                                          'poller_hash': 'MkIwNDYycGVlcnBvbnBvbiA0Mjg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -11.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.647},
                                                                                                                                  {       'connected_time': '29381420',
                                                                                                                                          'fiber_length': 1030,
                                                                                                                                          'poller_hash': 'MzVFOTZDcGVlcnBvbnBvbiA0MzI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -9.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.647},
                                                                                                                                  {       'connected_time': '688334',
                                                                                                                                          'fiber_length': 847,
                                                                                                                                          'poller_hash': 'NDNCMzdEcGVlcnBvbnBvbiA3Njc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -9.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.647},
                                                                                                                                  {       'connected_time': '10996353',
                                                                                                                                          'fiber_length': 1019,
                                                                                                                                          'poller_hash': 'MkZFQUZBcGVlcnBvbnBvbiAyMDU0MDY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.647},
                                                                                                                                  {       'connected_time': '21816835',
                                                                                                                                          'fiber_length': 1162,
                                                                                                                                          'poller_hash': 'QzgxRTYzcGVlcnBvbnBvbiAyMDkxMzQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.647},
                                                                                                                                  {       'connected_time': '4678524',
                                                                                                                                          'fiber_length': 1006,
                                                                                                                                          'poller_hash': 'MTI3NEE3MHBlZXJwb25wb24gMjMzNjkz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -9.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.647},
                                                                                                                                  {       'connected_time': '7351722',
                                                                                                                                          'fiber_length': 1076,
                                                                                                                                          'poller_hash': 'MTI3MERFNnBlZXJwb25wb24gMjc5MTU3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -8.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.647}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/4',
                                                                                                                 'poller_hash': 'MjExNDEwNjAxMjg5cG9uZ3BvbiAxLzQ=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/5',
                                                                                         'in_discards': '2488',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1021424',
                                                                                         'in_octets': '5220947861444',
                                                                                         'in_ucast_pkts': '30260621318',
                                                                                         'links': [       {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '47297301923',
                                                                                                                  'in_ucast_pkts': '111946135',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '111',
                                                                                                                  'out_octets': '300968323037',
                                                                                                                  'out_ucast_pkts': '310366662',
                                                                                                                  'poller_hash': 'MjA1REY4cGVlcmludGZwb24gMTI='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '421453026879',
                                                                                                                  'in_ucast_pkts': '1500968058',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '9935722168654',
                                                                                                                  'out_ucast_pkts': '7265312128',
                                                                                                                  'poller_hash': 'ODg5RTdwZWVyaW50ZnBvbiA2OA=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '542369992698',
                                                                                                                  'in_ucast_pkts': '106235913943',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '123',
                                                                                                                  'out_octets': '10041968279789',
                                                                                                                  'out_ucast_pkts': '7367503586',
                                                                                                                  'poller_hash': 'MUNBQjRBcGVlcmludGZwb24gNzM='},
                                                                                                          {       'in_nucast_pkts': '9',
                                                                                                                  'in_octets': '1475408762',
                                                                                                                  'in_ucast_pkts': '13443559',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1464199',
                                                                                                                  'out_octets': '62259095924',
                                                                                                                  'out_ucast_pkts': '43307763',
                                                                                                                  'poller_hash': 'MkFDNEI2cGVlcmludGZwb24gNzQ='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '279622632223',
                                                                                                                  'in_ucast_pkts': '1031731518',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '132',
                                                                                                                  'out_octets': '5441823747175',
                                                                                                                  'out_ucast_pkts': '3904607707',
                                                                                                                  'poller_hash': 'MUQwNTAycGVlcmludGZwb24gODA='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '37307404101',
                                                                                                                  'in_ucast_pkts': '475499357',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '100',
                                                                                                                  'out_octets': '3040616867677',
                                                                                                                  'out_ucast_pkts': '2050355436',
                                                                                                                  'poller_hash': 'Mjk4MjdDcGVlcmludGZwb24gMTM5'},
                                                                                                          {       'in_nucast_pkts': '41967',
                                                                                                                  'in_octets': '9412763854',
                                                                                                                  'in_ucast_pkts': '49563886',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1465360',
                                                                                                                  'out_octets': '278502084128',
                                                                                                                  'out_ucast_pkts': '208066315',
                                                                                                                  'poller_hash': 'MkJEMjQxcGVlcmludGZwb24gMTQ1'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '151366931829',
                                                                                                                  'in_ucast_pkts': '26613710912',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '122',
                                                                                                                  'out_octets': '4269273357183',
                                                                                                                  'out_ucast_pkts': '3111817644',
                                                                                                                  'poller_hash': 'MkIwNDU0cGVlcmludGZwb24gNDI0'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '3207379064',
                                                                                                                  'in_ucast_pkts': '18501115',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '70509937817',
                                                                                                                  'out_ucast_pkts': '64210620',
                                                                                                                  'poller_hash': 'MkIwNDQ0cGVlcmludGZwb24gNDMx'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '76837579929',
                                                                                                                  'in_ucast_pkts': '557865808',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '50',
                                                                                                                  'out_octets': '2004026278759',
                                                                                                                  'out_ucast_pkts': '1562216345',
                                                                                                                  'poller_hash': 'MjA1RERFcGVlcmludGZwb24gNDcz'},
                                                                                                          {       'in_nucast_pkts': '256768',
                                                                                                                  'in_octets': '209580692829',
                                                                                                                  'in_ucast_pkts': '257107761',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '31045783',
                                                                                                                  'out_octets': '415548364182',
                                                                                                                  'out_ucast_pkts': '446691296',
                                                                                                                  'poller_hash': 'MTE3REJGNHBlZXJpbnRmcG9uIDI1MzUyNw=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MTI3NDgxRXBlZXJpbnRmcG9uIDI3Mzg4MQ=='},
                                                                                                          {       'in_nucast_pkts': '60',
                                                                                                                  'in_octets': '13410363296',
                                                                                                                  'in_ucast_pkts': '30653618',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1123734',
                                                                                                                  'out_octets': '99462387213',
                                                                                                                  'out_ucast_pkts': '78667256',
                                                                                                                  'poller_hash': 'MTI3NDgwMXBlZXJpbnRmcG9uIDI3NDQ5NA=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '33245879400',
                                                                                                                  'in_ucast_pkts': '192362671',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '843574328311',
                                                                                                                  'out_ucast_pkts': '648273917',
                                                                                                                  'poller_hash': 'MTI3MEQ2RXBlZXJpbnRmcG9uIDI3NzAzNg=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '3923586126',
                                                                                         'out_octets': '116644258947493',
                                                                                         'out_ucast_pkts': '80223613563',
                                                                                         'poller_hash': 'MjExNDEwNjAxMjg5Z3BvbiAxLzU=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/5',
                                                                                                                 'id': '1/5',
                                                                                                                 'links': [       {       'connected_time': '688344',
                                                                                                                                          'fiber_length': 1130,
                                                                                                                                          'poller_hash': 'MjA1REY4cGVlcnBvbnBvbiAxMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -11.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.609},
                                                                                                                                  {       'connected_time': '688336',
                                                                                                                                          'fiber_length': 888,
                                                                                                                                          'poller_hash': 'ODg5RTdwZWVycG9ucG9uIDY4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -8.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.609},
                                                                                                                                  {       'connected_time': '11231777',
                                                                                                                                          'fiber_length': 988,
                                                                                                                                          'poller_hash': 'MUNBQjRBcGVlcnBvbnBvbiA3Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -8.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.609},
                                                                                                                                  {       'connected_time': '688348',
                                                                                                                                          'fiber_length': 962,
                                                                                                                                          'poller_hash': 'MkFDNEI2cGVlcnBvbnBvbiA3NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -9.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.609},
                                                                                                                                  {       'connected_time': '688349',
                                                                                                                                          'fiber_length': 841,
                                                                                                                                          'poller_hash': 'MUQwNTAycGVlcnBvbnBvbiA4MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.609},
                                                                                                                                  {       'connected_time': '24902851',
                                                                                                                                          'fiber_length': 1361,
                                                                                                                                          'poller_hash': 'Mjk4MjdDcGVlcnBvbnBvbiAxMzk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -9.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.609},
                                                                                                                                  {       'connected_time': '688345',
                                                                                                                                          'fiber_length': 838,
                                                                                                                                          'poller_hash': 'MkJEMjQxcGVlcnBvbnBvbiAxNDU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.609},
                                                                                                                                  {       'connected_time': '21815758',
                                                                                                                                          'fiber_length': 848,
                                                                                                                                          'poller_hash': 'MkIwNDU0cGVlcnBvbnBvbiA0MjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.609},
                                                                                                                                  {       'connected_time': '21815373',
                                                                                                                                          'fiber_length': 1137,
                                                                                                                                          'poller_hash': 'MkIwNDQ0cGVlcnBvbnBvbiA0MzE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -11.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.609},
                                                                                                                                  {       'connected_time': '688346',
                                                                                                                                          'fiber_length': 843,
                                                                                                                                          'poller_hash': 'MjA1RERFcGVlcnBvbnBvbiA0NzM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -11.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.609},
                                                                                                                                  {       'connected_time': '13642123',
                                                                                                                                          'fiber_length': 1020,
                                                                                                                                          'poller_hash': 'MTE3REJGNHBlZXJwb25wb24gMjUzNTI3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.609},
                                                                                                                                  {       'connected_time': '4587986',
                                                                                                                                          'fiber_length': 1503,
                                                                                                                                          'poller_hash': 'MTI3NDgxRXBlZXJwb25wb24gMjczODgx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -8.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.609},
                                                                                                                                  {       'connected_time': '688348',
                                                                                                                                          'fiber_length': 997,
                                                                                                                                          'poller_hash': 'MTI3NDgwMXBlZXJwb25wb24gMjc0NDk0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.609},
                                                                                                                                  {       'connected_time': '688343',
                                                                                                                                          'fiber_length': 975,
                                                                                                                                          'poller_hash': 'MTI3MEQ2RXBlZXJwb25wb24gMjc3MDM2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.609}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/5',
                                                                                                                 'poller_hash': 'MjExNDEwNjAxMjg5cG9uZ3BvbiAxLzU=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/6',
                                                                                         'in_discards': '3623',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1375974',
                                                                                         'in_octets': '4800456291403',
                                                                                         'in_ucast_pkts': '18572151691',
                                                                                         'links': [       {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '129837250126',
                                                                                                                  'in_ucast_pkts': '294748857',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '100',
                                                                                                                  'out_octets': '678522684122',
                                                                                                                  'out_ucast_pkts': '635337906',
                                                                                                                  'poller_hash': 'QzgzQkM5cGVlcmludGZwb24gMTcxOTI4'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '392537914599',
                                                                                                                  'in_ucast_pkts': '108641936525',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '74',
                                                                                                                  'out_octets': '4948946299963',
                                                                                                                  'out_ucast_pkts': '3725195165',
                                                                                                                  'poller_hash': 'QzgzMTc0cGVlcmludGZwb24gMTcyMjM5'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '88180927156',
                                                                                                                  'in_ucast_pkts': '486466288',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '100',
                                                                                                                  'out_octets': '1678403168165',
                                                                                                                  'out_ucast_pkts': '1259393553',
                                                                                                                  'poller_hash': 'QjA4RUY2cGVlcmludGZwb24gMTc1MTQ2'},
                                                                                                          {       'in_nucast_pkts': '452292',
                                                                                                                  'in_octets': '183323476460',
                                                                                                                  'in_ucast_pkts': '464803530',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '44806989',
                                                                                                                  'out_octets': '1220034012146',
                                                                                                                  'out_ucast_pkts': '1068628776',
                                                                                                                  'poller_hash': 'Q0JEMUJDcGVlcmludGZwb24gMTc1MzYx'},
                                                                                                          {       'in_nucast_pkts': '199457',
                                                                                                                  'in_octets': '17872795505',
                                                                                                                  'in_ucast_pkts': '46241494',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '23990096',
                                                                                                                  'out_octets': '165540549854',
                                                                                                                  'out_ucast_pkts': '144515071',
                                                                                                                  'poller_hash': 'QzgzNkM0cGVlcmludGZwb24gMTgyMjcx'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '28316392064',
                                                                                                                  'in_ucast_pkts': '123791302',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '148',
                                                                                                                  'out_octets': '850946041316',
                                                                                                                  'out_ucast_pkts': '722498072',
                                                                                                                  'poller_hash': 'QzgzQkYwcGVlcmludGZwb24gMTgyMzAy'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '86417134426',
                                                                                                                  'in_ucast_pkts': '21921868883',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '100',
                                                                                                                  'out_octets': '2016692764010',
                                                                                                                  'out_ucast_pkts': '1496282246',
                                                                                                                  'poller_hash': 'QzgxRDhBcGVlcmludGZwb24gMTk2OTA1'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '186214273425',
                                                                                                                  'in_ucast_pkts': '665263535',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '1839243489862',
                                                                                                                  'out_ucast_pkts': '1647351579',
                                                                                                                  'poller_hash': 'MTAwQUFGOXBlZXJpbnRmcG9uIDIwMTM1Ng=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '114189082198',
                                                                                                                  'in_ucast_pkts': '364936847',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '122',
                                                                                                                  'out_octets': '1834558033898',
                                                                                                                  'out_ucast_pkts': '1488736010',
                                                                                                                  'poller_hash': 'MTE5NEU4N3BlZXJpbnRmcG9uIDIxMjcyMA=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '201574888377',
                                                                                                                  'in_ucast_pkts': '56876949483',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '148',
                                                                                                                  'out_octets': '5857435651419',
                                                                                                                  'out_ucast_pkts': '4131900180',
                                                                                                                  'poller_hash': 'Q0JEMTYwcGVlcmludGZwb24gMjEzNTE3'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '488343378505',
                                                                                                                  'in_ucast_pkts': '69583600077',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '148',
                                                                                                                  'out_octets': '3065258784324',
                                                                                                                  'out_ucast_pkts': '2395717967',
                                                                                                                  'poller_hash': 'MTE5NTE0NnBlZXJpbnRmcG9uIDIxNTAyMQ=='},
                                                                                                          {       'in_nucast_pkts': '925310',
                                                                                                                  'in_octets': '1145224937597',
                                                                                                                  'in_ucast_pkts': '4822153098',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '137784697',
                                                                                                                  'out_octets': '15441594055366',
                                                                                                                  'out_ucast_pkts': '11455853966',
                                                                                                                  'poller_hash': 'MTE5NTE5OXBlZXJpbnRmcG9uIDIxNTAzMQ=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '422035260559',
                                                                                                                  'in_ucast_pkts': '32142966629',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '123',
                                                                                                                  'out_octets': '4512030014842',
                                                                                                                  'out_ucast_pkts': '4308826404',
                                                                                                                  'poller_hash': 'MTE5NTE2MXBlZXJpbnRmcG9uIDIxNTY2NA=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '112332165902',
                                                                                                                  'in_ucast_pkts': '889776891',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '72',
                                                                                                                  'out_octets': '5184818483767',
                                                                                                                  'out_ucast_pkts': '3602206490',
                                                                                                                  'poller_hash': 'MTI3NTFERHBlZXJpbnRmcG9uIDIyNDg3Mg=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05071',
                                                                                         'name': 'gpon '
                                                                                                 '1/6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '26496198028',
                                                                                         'out_octets': '103168349479835',
                                                                                         'out_ucast_pkts': '52261162366',
                                                                                         'poller_hash': 'MjExNDEwNjAxMjg5Z3BvbiAxLzY=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/6',
                                                                                                                 'id': '1/6',
                                                                                                                 'links': [       {       'connected_time': '15498459',
                                                                                                                                          'fiber_length': 12050,
                                                                                                                                          'poller_hash': 'QzgzQkM5cGVlcnBvbnBvbiAxNzE5Mjg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.163},
                                                                                                                                  {       'connected_time': '688348',
                                                                                                                                          'fiber_length': 11718,
                                                                                                                                          'poller_hash': 'QzgzMTc0cGVlcnBvbnBvbiAxNzIyMzk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.163},
                                                                                                                                  {       'connected_time': '687625',
                                                                                                                                          'fiber_length': 11694,
                                                                                                                                          'poller_hash': 'QjA4RUY2cGVlcnBvbnBvbiAxNzUxNDY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.163},
                                                                                                                                  {       'connected_time': '69480770',
                                                                                                                                          'fiber_length': 11800,
                                                                                                                                          'poller_hash': 'Q0JEMUJDcGVlcnBvbnBvbiAxNzUzNjE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.163},
                                                                                                                                  {       'connected_time': '21816857',
                                                                                                                                          'fiber_length': 11627,
                                                                                                                                          'poller_hash': 'QzgzNkM0cGVlcnBvbnBvbiAxODIyNzE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.163},
                                                                                                                                  {       'connected_time': '21816094',
                                                                                                                                          'fiber_length': 11750,
                                                                                                                                          'poller_hash': 'QzgzQkYwcGVlcnBvbnBvbiAxODIzMDI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.163},
                                                                                                                                  {       'connected_time': '688348',
                                                                                                                                          'fiber_length': 11613,
                                                                                                                                          'poller_hash': 'QzgxRDhBcGVlcnBvbnBvbiAxOTY5MDU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.163},
                                                                                                                                  {       'connected_time': '47827',
                                                                                                                                          'fiber_length': 11660,
                                                                                                                                          'poller_hash': 'MTAwQUFGOXBlZXJwb25wb24gMjAxMzU2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.163},
                                                                                                                                  {       'connected_time': '21792971',
                                                                                                                                          'fiber_length': 11745,
                                                                                                                                          'poller_hash': 'MTE5NEU4N3BlZXJwb25wb24gMjEyNzIw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.163},
                                                                                                                                  {       'connected_time': '28863',
                                                                                                                                          'fiber_length': 12028,
                                                                                                                                          'poller_hash': 'Q0JEMTYwcGVlcnBvbnBvbiAyMTM1MTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.163},
                                                                                                                                  {       'connected_time': '12765140',
                                                                                                                                          'fiber_length': 11644,
                                                                                                                                          'poller_hash': 'MTE5NTE0NnBlZXJwb25wb24gMjE1MDIx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.163},
                                                                                                                                  {       'connected_time': '19970731',
                                                                                                                                          'fiber_length': 11916,
                                                                                                                                          'poller_hash': 'MTE5NTE5OXBlZXJwb25wb24gMjE1MDMx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.163},
                                                                                                                                  {       'connected_time': '19801590',
                                                                                                                                          'fiber_length': 11966,
                                                                                                                                          'poller_hash': 'MTE5NTE2MXBlZXJwb25wb24gMjE1NjY0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.163},
                                                                                                                                  {       'connected_time': '68521034',
                                                                                                                                          'fiber_length': 11981,
                                                                                                                                          'poller_hash': 'MTI3NTFERHBlZXJwb25wb24gMjI0ODcy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.163}],
                                                                                                                 'max_distance': 60000,
                                                                                                                 'maximum_loss': -12.0,
                                                                                                                 'minimum_loss': -32.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/6',
                                                                                                                 'poller_hash': 'MjExNDEwNjAxMjg5cG9uZ3BvbiAxLzY=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/7',
                                                                                         'in_discards': '77011',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1983851',
                                                                                         'in_octets': '29412544604915',
                                                                                         'in_ucast_pkts': '49651173250',
                                                                                         'links': [       {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '27406028917',
                                                                                                                  'in_ucast_pkts': '114944376',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '152',
                                                                                                                  'out_octets': '226121164658',
                                                                                                                  'out_ucast_pkts': '252549702',
                                                                                                                  'poller_hash': 'QzgzQkFGcGVlcmludGZwb24gMTcxOTM4'},
                                                                                                          {       'in_nucast_pkts': '981641',
                                                                                                                  'in_octets': '2258603719014',
                                                                                                                  'in_ucast_pkts': '5963475083',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '149352519',
                                                                                                                  'out_octets': '13585090105034',
                                                                                                                  'out_ucast_pkts': '11883156656',
                                                                                                                  'poller_hash': 'REZGRDM4cGVlcmludGZwb24gMTcyNjEw'},
                                                                                                          {       'in_nucast_pkts': '4129',
                                                                                                                  'in_octets': '57441885',
                                                                                                                  'in_ucast_pkts': '176802',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1465893',
                                                                                                                  'out_octets': '353484219',
                                                                                                                  'out_ucast_pkts': '346087',
                                                                                                                  'poller_hash': 'QzgzNjEwcGVlcmludGZwb24gMTc3MDI1'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '64636598501',
                                                                                                                  'in_ucast_pkts': '248477589',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '148',
                                                                                                                  'out_octets': '536529126999',
                                                                                                                  'out_ucast_pkts': '551210987',
                                                                                                                  'poller_hash': 'QzgzNjkxcGVlcmludGZwb24gMTgwMjgy'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '66181739690',
                                                                                                                  'in_ucast_pkts': '17302872467',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '122',
                                                                                                                  'out_octets': '322163000643',
                                                                                                                  'out_ucast_pkts': '321808779',
                                                                                                                  'poller_hash': 'QzgzQjZDcGVlcmludGZwb24gMTgxMDAx'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '222688948643',
                                                                                                                  'in_ucast_pkts': '26549638688',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '74',
                                                                                                                  'out_octets': '2692933599529',
                                                                                                                  'out_ucast_pkts': '2120661577',
                                                                                                                  'poller_hash': 'QzgzMEY5cGVlcmludGZwb24gMTgzNjU2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '505822873053',
                                                                                                                  'in_ucast_pkts': '14951399657',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '148',
                                                                                                                  'out_octets': '7370525443020',
                                                                                                                  'out_ucast_pkts': '5640560103',
                                                                                                                  'poller_hash': 'REZGREEycGVlcmludGZwb24gMTgzNjY2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '113765594256',
                                                                                                                  'in_ucast_pkts': '560177583',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '148',
                                                                                                                  'out_octets': '2316304197789',
                                                                                                                  'out_ucast_pkts': '1908363399',
                                                                                                                  'poller_hash': 'REZGQzcwcGVlcmludGZwb24gMTg1MjU2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '1534004368891',
                                                                                                                  'in_ucast_pkts': '44851822037',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '148',
                                                                                                                  'out_octets': '1721015254856',
                                                                                                                  'out_ucast_pkts': '1628818068',
                                                                                                                  'poller_hash': 'QzgxQzczcGVlcmludGZwb24gMTg1NDk3'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '169112998667',
                                                                                                                  'in_ucast_pkts': '168574049',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '122',
                                                                                                                  'out_octets': '60741735729',
                                                                                                                  'out_ucast_pkts': '127997431',
                                                                                                                  'poller_hash': 'QzgxOUREcGVlcmludGZwb24gMTg1NzAx'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '371241092760',
                                                                                                                  'in_ucast_pkts': '100735757227',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '74',
                                                                                                                  'out_octets': '14243865456975',
                                                                                                                  'out_ucast_pkts': '9773719799',
                                                                                                                  'poller_hash': 'REZGRTI3cGVlcmludGZwb24gMTg2NjA3'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '407593910183',
                                                                                                                  'in_ucast_pkts': '78875691509',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '40638813257',
                                                                                                                  'out_octets': '60001615027638',
                                                                                                                  'out_ucast_pkts': '4038466742',
                                                                                                                  'poller_hash': 'QzgxREE1cGVlcmludGZwb24gMTkyODY1'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '100566926582',
                                                                                                                  'in_ucast_pkts': '1287234984',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '144',
                                                                                                                  'out_octets': '5346872929929',
                                                                                                                  'out_ucast_pkts': '3571137124',
                                                                                                                  'poller_hash': 'QzgxRTk2cGVlcmludGZwb24gMjAwMzg1'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '577135536638',
                                                                                                                  'in_ucast_pkts': '1383781709',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '74',
                                                                                                                  'out_octets': '5211627569264',
                                                                                                                  'out_ucast_pkts': '3813577860',
                                                                                                                  'poller_hash': 'QzgxRUFDcGVlcmludGZwb24gMjAxNjU0'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '246737583297',
                                                                                                                  'in_ucast_pkts': '129189300924',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '99',
                                                                                                                  'out_octets': '995607284861',
                                                                                                                  'out_ucast_pkts': '872432682',
                                                                                                                  'poller_hash': 'QzgxOTZBcGVlcmludGZwb24gMjAyNTk1'},
                                                                                                          {       'in_nucast_pkts': '378844',
                                                                                                                  'in_octets': '141974769016',
                                                                                                                  'in_ucast_pkts': '841270511',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '46232990',
                                                                                                                  'out_octets': '2225715288393',
                                                                                                                  'out_ucast_pkts': '1698640027',
                                                                                                                  'poller_hash': 'QzgxRTExcGVlcmludGZwb24gMjAyNjc0'},
                                                                                                          {       'in_nucast_pkts': '12117',
                                                                                                                  'in_octets': '13949976607',
                                                                                                                  'in_ucast_pkts': '49923038',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1464236',
                                                                                                                  'out_octets': '157425846690',
                                                                                                                  'out_ucast_pkts': '129190380',
                                                                                                                  'poller_hash': 'MTE5NTEzRnBlZXJpbnRmcG9uIDIxMjQxNg=='},
                                                                                                          {       'in_nucast_pkts': '6',
                                                                                                                  'in_octets': '13055530373067',
                                                                                                                  'in_ucast_pkts': '13609361751',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '35094860',
                                                                                                                  'out_octets': '5799129896248',
                                                                                                                  'out_ucast_pkts': '8737277792',
                                                                                                                  'poller_hash': 'MTI3NDA2NHBlZXJpbnRmcG9uIDI0NjkwMA=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MTE3REFDMXBlZXJpbnRmcG9uIDI1MTAyNA=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MTI5NzRFQ3BlZXJpbnRmcG9uIDI1NjgzNg=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '92409522',
                                                                                                                  'in_ucast_pkts': '200582',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '1433884571',
                                                                                                                  'out_ucast_pkts': '5623640',
                                                                                                                  'poller_hash': 'MTI5NjAyRXBlZXJpbnRmcG9uIDI4MDQwNA=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '2104009264',
                                                                                                                  'in_ucast_pkts': '6686474',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '38985987894',
                                                                                                                  'out_ucast_pkts': '31969022',
                                                                                                                  'poller_hash': 'MTI5NjA1QXBlZXJpbnRmcG9uIDI4MjMwMw=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05071',
                                                                                         'name': 'gpon '
                                                                                                 '1/7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '72602890608',
                                                                                         'out_octets': '208605481237532',
                                                                                         'out_ucast_pkts': '91740747261',
                                                                                         'poller_hash': 'MjExNDEwNjAxMjg5Z3BvbiAxLzc=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/7',
                                                                                                                 'id': '1/7',
                                                                                                                 'links': [       {       'connected_time': '3969452',
                                                                                                                                          'fiber_length': 11832,
                                                                                                                                          'poller_hash': 'QzgzQkFGcGVlcnBvbnBvbiAxNzE5Mzg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '21816175',
                                                                                                                                          'fiber_length': 11627,
                                                                                                                                          'poller_hash': 'REZGRDM4cGVlcnBvbnBvbiAxNzI2MTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '688348',
                                                                                                                                          'fiber_length': 11846,
                                                                                                                                          'poller_hash': 'QzgzNjEwcGVlcnBvbnBvbiAxNzcwMjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '27666955',
                                                                                                                                          'fiber_length': 11784,
                                                                                                                                          'poller_hash': 'QzgzNjkxcGVlcnBvbnBvbiAxODAyODI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '21816725',
                                                                                                                                          'fiber_length': 11426,
                                                                                                                                          'poller_hash': 'QzgzQjZDcGVlcnBvbnBvbiAxODEwMDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '688348',
                                                                                                                                          'fiber_length': 11445,
                                                                                                                                          'poller_hash': 'QzgzMEY5cGVlcnBvbnBvbiAxODM2NTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '74480379',
                                                                                                                                          'fiber_length': 11424,
                                                                                                                                          'poller_hash': 'REZGREEycGVlcnBvbnBvbiAxODM2NjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '69274060',
                                                                                                                                          'fiber_length': 11600,
                                                                                                                                          'poller_hash': 'REZGQzcwcGVlcnBvbnBvbiAxODUyNTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '21816941',
                                                                                                                                          'fiber_length': 11543,
                                                                                                                                          'poller_hash': 'QzgxQzczcGVlcnBvbnBvbiAxODU0OTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '6774594',
                                                                                                                                          'fiber_length': 11600,
                                                                                                                                          'poller_hash': 'QzgxOUREcGVlcnBvbnBvbiAxODU3MDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '688351',
                                                                                                                                          'fiber_length': 11602,
                                                                                                                                          'poller_hash': 'REZGRTI3cGVlcnBvbnBvbiAxODY2MDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '1026215',
                                                                                                                                          'fiber_length': 11451,
                                                                                                                                          'poller_hash': 'QzgxREE1cGVlcnBvbnBvbiAxOTI4NjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '21815653',
                                                                                                                                          'fiber_length': 11637,
                                                                                                                                          'poller_hash': 'QzgxRTk2cGVlcnBvbnBvbiAyMDAzODU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '523084',
                                                                                                                                          'fiber_length': 11803,
                                                                                                                                          'poller_hash': 'QzgxRUFDcGVlcnBvbnBvbiAyMDE2NTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '688353',
                                                                                                                                          'fiber_length': 11573,
                                                                                                                                          'poller_hash': 'QzgxOTZBcGVlcnBvbnBvbiAyMDI1OTU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '21815627',
                                                                                                                                          'fiber_length': 11546,
                                                                                                                                          'poller_hash': 'QzgxRTExcGVlcnBvbnBvbiAyMDI2NzQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '688354',
                                                                                                                                          'fiber_length': 11624,
                                                                                                                                          'poller_hash': 'MTE5NTEzRnBlZXJwb25wb24gMjEyNDE2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '15498714',
                                                                                                                                          'fiber_length': 11849,
                                                                                                                                          'poller_hash': 'MTI3NDA2NHBlZXJwb25wb24gMjQ2OTAw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '63443605',
                                                                                                                                          'fiber_length': 11556,
                                                                                                                                          'poller_hash': 'MTE3REFDMXBlZXJwb25wb24gMjUxMDI0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '24110006',
                                                                                                                                          'fiber_length': 11854,
                                                                                                                                          'poller_hash': 'MTI5NzRFQ3BlZXJwb25wb24gMjU2ODM2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '4257088',
                                                                                                                                          'fiber_length': 11703,
                                                                                                                                          'poller_hash': 'MTI5NjAyRXBlZXJwb25wb24gMjgwNDA0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002},
                                                                                                                                  {       'connected_time': '688352',
                                                                                                                                          'fiber_length': 11508,
                                                                                                                                          'poller_hash': 'MTI5NjA1QXBlZXJwb25wb24gMjgyMzAz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.002}],
                                                                                                                 'max_distance': 60000,
                                                                                                                 'maximum_loss': -12.0,
                                                                                                                 'minimum_loss': -32.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/7',
                                                                                                                 'poller_hash': 'MjExNDEwNjAxMjg5cG9uZ3BvbiAxLzc=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/8',
                                                                                         'in_discards': '2',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '45891',
                                                                                         'in_octets': '840837418843',
                                                                                         'in_ucast_pkts': '8165828988',
                                                                                         'links': [       {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '44766556446',
                                                                                                                  'in_ucast_pkts': '587943962',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '52',
                                                                                                                  'out_octets': '3742026782464',
                                                                                                                  'out_ucast_pkts': '2492691468',
                                                                                                                  'poller_hash': 'MjA1RDk3cGVlcmludGZwb24gNTI0'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '96633036714',
                                                                                                                  'in_ucast_pkts': '5329082604',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '144',
                                                                                                                  'out_octets': '5208321421769',
                                                                                                                  'out_ucast_pkts': '7807743112',
                                                                                                                  'poller_hash': 'MzQ5RTg3cGVlcmludGZwb24gNjkw'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MjA1QjM4cGVlcmludGZwb24gNjk0'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '102496007989',
                                                                                                                  'in_ucast_pkts': '22318210147',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '98',
                                                                                                                  'out_octets': '4909918565667',
                                                                                                                  'out_ucast_pkts': '3354070159',
                                                                                                                  'poller_hash': 'MzQ5RTUxcGVlcmludGZwb24gNzE1'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'NjQwQUZGcGVlcmludGZwb24gMTQxNzc0'},
                                                                                                          {       'in_nucast_pkts': '767296',
                                                                                                                  'in_octets': '118391865171',
                                                                                                                  'in_ucast_pkts': '872760014',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4815944432',
                                                                                                                  'out_octets': '10601189274562',
                                                                                                                  'out_ucast_pkts': '2865522368',
                                                                                                                  'poller_hash': 'ODY3OEEycGVlcmludGZwb24gMTcyNTk5'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '31433102625',
                                                                                         'out_octets': '86132965392919',
                                                                                         'out_ucast_pkts': '29597722807',
                                                                                         'poller_hash': 'MjExNDEwNjAxMjg5Z3BvbiAxLzg=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/8',
                                                                                                                 'id': '1/8',
                                                                                                                 'links': [       {       'connected_time': '21319494',
                                                                                                                                          'fiber_length': 1116,
                                                                                                                                          'poller_hash': 'MjA1RDk3cGVlcnBvbnBvbiA1MjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.981},
                                                                                                                                  {       'connected_time': '20839243',
                                                                                                                                          'fiber_length': 1046,
                                                                                                                                          'poller_hash': 'MzQ5RTg3cGVlcnBvbnBvbiA2OTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.981},
                                                                                                                                  {       'connected_time': '30595765',
                                                                                                                                          'fiber_length': 1115,
                                                                                                                                          'poller_hash': 'MjA1QjM4cGVlcnBvbnBvbiA2OTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.981},
                                                                                                                                  {       'connected_time': '68802632',
                                                                                                                                          'fiber_length': 1119,
                                                                                                                                          'poller_hash': 'MzQ5RTUxcGVlcnBvbnBvbiA3MTU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.981},
                                                                                                                                  {       'connected_time': '688346',
                                                                                                                                          'fiber_length': 901,
                                                                                                                                          'poller_hash': 'NjQwQUZGcGVlcnBvbnBvbiAxNDE3NzQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.981},
                                                                                                                                  {       'connected_time': '688356',
                                                                                                                                          'fiber_length': 1115,
                                                                                                                                          'poller_hash': 'ODY3OEEycGVlcnBvbnBvbiAxNzI1OTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.981}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/8',
                                                                                                                 'poller_hash': 'MjExNDEwNjAxMjg5cG9uZ3BvbiAxLzg=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-03007',
                                                           'name': 'GPON-8x',
                                                           'poller_hash': 'MjExNDEwNjAxMjg5',
                                                           'serial_number': '211410601289',
                                                           'sw_version': '3.4.51.25',
                                                           'uptime': '42991355'},
                                                   {       'id': '3',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '3/1',
                                                                                         'in_discards': '1146',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '236769',
                                                                                         'in_octets': '838847003493',
                                                                                         'in_ucast_pkts': '3297859328',
                                                                                         'links': [       {       'in_nucast_pkts': '20569',
                                                                                                                  'in_octets': '197253958927',
                                                                                                                  'in_ucast_pkts': '606034054',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '32346044',
                                                                                                                  'out_octets': '1830384241804',
                                                                                                                  'out_ucast_pkts': '1545447936',
                                                                                                                  'poller_hash': 'QjUxMkRCcGVlcmludGZwb24gOTEw'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '19639727250',
                                                                                                                  'in_ucast_pkts': '138626751',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '797490008257',
                                                                                                                  'out_ucast_pkts': '576831432',
                                                                                                                  'poller_hash': 'ODY5M0I1cGVlcmludGZwb24gMTQyMjQ0'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '58183189697',
                                                                                                                  'in_ucast_pkts': '259479199',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '1088240746343',
                                                                                                                  'out_ucast_pkts': '845403095',
                                                                                                                  'poller_hash': 'ODY5M0M3cGVlcmludGZwb24gMTQyMjU0'},
                                                                                                          {       'in_nucast_pkts': '752945',
                                                                                                                  'in_octets': '119660496513',
                                                                                                                  'in_ucast_pkts': '1083768890',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '95001851',
                                                                                                                  'out_octets': '6167832674671',
                                                                                                                  'out_ucast_pkts': '4226557460',
                                                                                                                  'poller_hash': 'ODY5M0UzcGVlcmludGZwb24gMTQyMjY0'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '85128767875',
                                                                                                                  'in_ucast_pkts': '343233681',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '1538863338824',
                                                                                                                  'out_ucast_pkts': '1167879766',
                                                                                                                  'poller_hash': 'ODY5M0UwcGVlcmludGZwb24gMTQyMjg2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '55847101573',
                                                                                                                  'in_ucast_pkts': '231915260',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '1065560722477',
                                                                                                                  'out_ucast_pkts': '811391259',
                                                                                                                  'poller_hash': 'ODY5M0QwcGVlcmludGZwb24gMTQyMjk2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '7035734623',
                                                                                                                  'in_ucast_pkts': '41494881',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '224869884836',
                                                                                                                  'out_ucast_pkts': '169078705',
                                                                                                                  'poller_hash': 'ODY5NDA0cGVlcmludGZwb24gMTQyMzE2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '41142730647',
                                                                                                                  'in_ucast_pkts': '161134276',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '583938080550',
                                                                                                                  'out_ucast_pkts': '435761469',
                                                                                                                  'poller_hash': 'ODY5M0RBcGVlcmludGZwb24gMTQyMzM2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '111949369665',
                                                                                                                  'in_ucast_pkts': '47381067021',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '264410448598',
                                                                                                                  'out_ucast_pkts': '255515672',
                                                                                                                  'poller_hash': 'ODY5NDczcGVlcmludGZwb24gMTQyMzY2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '98126934260',
                                                                                                                  'in_ucast_pkts': '277737030',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '1176580628118',
                                                                                                                  'out_ucast_pkts': '854856246',
                                                                                                                  'poller_hash': 'ODY5M0ZCcGVlcmludGZwb24gMTQyMzk2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '10015870208',
                                                                                                                  'in_ucast_pkts': '4312390751',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '92979438877',
                                                                                                                  'out_ucast_pkts': '87314502',
                                                                                                                  'poller_hash': 'ODY5Mzg0cGVlcmludGZwb24gMTQyNDA2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '7362389747',
                                                                                                                  'in_ucast_pkts': '36232489',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '223759019455',
                                                                                                                  'out_ucast_pkts': '175045468',
                                                                                                                  'poller_hash': 'ODY5M0FDcGVlcmludGZwb24gMTQyNDE2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '35198371045',
                                                                                                                  'in_ucast_pkts': '82263663',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '358224715890',
                                                                                                                  'out_ucast_pkts': '299747892',
                                                                                                                  'poller_hash': 'ODY5M0IycGVlcmludGZwb24gMTQyNDY2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'ODY5NDJGcGVlcmludGZwb24gMTQyNDc2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '101535944997',
                                                                                                                  'in_ucast_pkts': '9168315573',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '3609851534314',
                                                                                                                  'out_ucast_pkts': '2545108758',
                                                                                                                  'poller_hash': 'MTI3NDk5RnBlZXJpbnRmcG9uIDE0MjQ5Ng=='},
                                                                                                          {       'in_nucast_pkts': '916665',
                                                                                                                  'in_octets': '4572262513',
                                                                                                                  'in_ucast_pkts': '14000535',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '149217273',
                                                                                                                  'out_octets': '50650310535',
                                                                                                                  'out_ucast_pkts': '27712829',
                                                                                                                  'poller_hash': 'MTFCMjVFNXBlZXJpbnRmcG9uIDIxMDA4NQ=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '3/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '24238246',
                                                                                         'out_octets': '15205689565891',
                                                                                         'out_ucast_pkts': '11272334665',
                                                                                         'poller_hash': 'MjExNTEyNjAzNzE3Z3BvbiAzLzE=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '3/1',
                                                                                                                 'id': '3/1',
                                                                                                                 'links': [       {       'connected_time': '14251264',
                                                                                                                                          'fiber_length': 10790,
                                                                                                                                          'poller_hash': 'QjUxMkRCcGVlcnBvbnBvbiA5MTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.728},
                                                                                                                                  {       'connected_time': '18864638',
                                                                                                                                          'fiber_length': 10604,
                                                                                                                                          'poller_hash': 'ODY5M0I1cGVlcnBvbnBvbiAxNDIyNDQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.728},
                                                                                                                                  {       'connected_time': '688346',
                                                                                                                                          'fiber_length': 10585,
                                                                                                                                          'poller_hash': 'ODY5M0M3cGVlcnBvbnBvbiAxNDIyNTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.728},
                                                                                                                                  {       'connected_time': '71368108',
                                                                                                                                          'fiber_length': 10574,
                                                                                                                                          'poller_hash': 'ODY5M0UzcGVlcnBvbnBvbiAxNDIyNjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.728},
                                                                                                                                  {       'connected_time': '688349',
                                                                                                                                          'fiber_length': 10461,
                                                                                                                                          'poller_hash': 'ODY5M0UwcGVlcnBvbnBvbiAxNDIyODY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.728},
                                                                                                                                  {       'connected_time': '6552385',
                                                                                                                                          'fiber_length': 10442,
                                                                                                                                          'poller_hash': 'ODY5M0QwcGVlcnBvbnBvbiAxNDIyOTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.728},
                                                                                                                                  {       'connected_time': '688380',
                                                                                                                                          'fiber_length': 10495,
                                                                                                                                          'poller_hash': 'ODY5NDA0cGVlcnBvbnBvbiAxNDIzMTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.728},
                                                                                                                                  {       'connected_time': '688353',
                                                                                                                                          'fiber_length': 10377,
                                                                                                                                          'poller_hash': 'ODY5M0RBcGVlcnBvbnBvbiAxNDIzMzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.728},
                                                                                                                                  {       'connected_time': '13582346',
                                                                                                                                          'fiber_length': 10555,
                                                                                                                                          'poller_hash': 'ODY5NDczcGVlcnBvbnBvbiAxNDIzNjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.728},
                                                                                                                                  {       'connected_time': '688346',
                                                                                                                                          'fiber_length': 10471,
                                                                                                                                          'poller_hash': 'ODY5M0ZCcGVlcnBvbnBvbiAxNDIzOTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.728},
                                                                                                                                  {       'connected_time': '18660841',
                                                                                                                                          'fiber_length': 10582,
                                                                                                                                          'poller_hash': 'ODY5Mzg0cGVlcnBvbnBvbiAxNDI0MDY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.728},
                                                                                                                                  {       'connected_time': '21815921',
                                                                                                                                          'fiber_length': 10536,
                                                                                                                                          'poller_hash': 'ODY5M0FDcGVlcnBvbnBvbiAxNDI0MTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.728},
                                                                                                                                  {       'connected_time': '688353',
                                                                                                                                          'fiber_length': 10593,
                                                                                                                                          'poller_hash': 'ODY5M0IycGVlcnBvbnBvbiAxNDI0NjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.728},
                                                                                                                                  {       'connected_time': '688354',
                                                                                                                                          'fiber_length': 10373,
                                                                                                                                          'poller_hash': 'ODY5NDJGcGVlcnBvbnBvbiAxNDI0NzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.728},
                                                                                                                                  {       'connected_time': '4060597',
                                                                                                                                          'fiber_length': 10552,
                                                                                                                                          'poller_hash': 'MTI3NDk5RnBlZXJwb25wb24gMTQyNDk2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.728},
                                                                                                                                  {       'connected_time': '21816086',
                                                                                                                                          'fiber_length': 10633,
                                                                                                                                          'poller_hash': 'MTFCMjVFNXBlZXJwb25wb24gMjEwMDg1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.728}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '3/1',
                                                                                                                 'poller_hash': 'MjExNTEyNjAzNzE3cG9uZ3BvbiAzLzE=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/2',
                                                                                         'in_discards': '7185',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '330525',
                                                                                         'in_octets': '588038622418',
                                                                                         'in_ucast_pkts': '3112787849',
                                                                                         'links': [       {       'in_nucast_pkts': '14763',
                                                                                                                  'in_octets': '6407478930',
                                                                                                                  'in_ucast_pkts': '24295667',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1464403',
                                                                                                                  'out_octets': '91063223357',
                                                                                                                  'out_ucast_pkts': '69457078',
                                                                                                                  'poller_hash': 'ODY5M0E1cGVlcmludGZwb24gMTQyNTA2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '31620576089',
                                                                                                                  'in_ucast_pkts': '166688457',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '814883807358',
                                                                                                                  'out_ucast_pkts': '600510609',
                                                                                                                  'poller_hash': 'ODY5M0Q5cGVlcmludGZwb24gMTQyNTU2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '12139013374',
                                                                                                                  'in_ucast_pkts': '131607262',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '387120254706',
                                                                                                                  'out_ucast_pkts': '269441326',
                                                                                                                  'poller_hash': 'ODY5M0I5cGVlcmludGZwb24gMTQyNjA1'},
                                                                                                          {       'in_nucast_pkts': '952122',
                                                                                                                  'in_octets': '515850706480',
                                                                                                                  'in_ucast_pkts': '3792982580',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '149539546',
                                                                                                                  'out_octets': '14737857952500',
                                                                                                                  'out_ucast_pkts': '11090321461',
                                                                                                                  'poller_hash': 'ODcyNDg0cGVlcmludGZwb24gMTQyODAz'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '22117500414',
                                                                                                                  'in_ucast_pkts': '163054916',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '522818871620',
                                                                                                                  'out_ucast_pkts': '380055566',
                                                                                                                  'poller_hash': 'OTU2RjY3cGVlcmludGZwb24gMTQ1NTA4'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '45291303846',
                                                                                                                  'in_ucast_pkts': '295219888',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '880087551014',
                                                                                                                  'out_ucast_pkts': '628923100',
                                                                                                                  'poller_hash': 'QTlDNzdCcGVlcmludGZwb24gMTQ3MzY2'},
                                                                                                          {       'in_nucast_pkts': '119253',
                                                                                                                  'in_octets': '1012519937',
                                                                                                                  'in_ucast_pkts': '11282223',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '49519180',
                                                                                                                  'out_octets': '82644586229',
                                                                                                                  'out_ucast_pkts': '44686831',
                                                                                                                  'poller_hash': 'QjBBMTRFcGVlcmludGZwb24gMTQ5NjU1'},
                                                                                                          {       'in_nucast_pkts': '31819',
                                                                                                                  'in_octets': '54864245648',
                                                                                                                  'in_ucast_pkts': '95136356',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '85703255',
                                                                                                                  'out_octets': '182649242925',
                                                                                                                  'out_ucast_pkts': '162762136',
                                                                                                                  'poller_hash': 'QjUxMTZDcGVlcmludGZwb24gMTUxMjI3'},
                                                                                                          {       'in_nucast_pkts': '132634',
                                                                                                                  'in_octets': '10852915982',
                                                                                                                  'in_ucast_pkts': '21194325',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '14580570',
                                                                                                                  'out_octets': '127108458661',
                                                                                                                  'out_ucast_pkts': '96700608',
                                                                                                                  'poller_hash': 'QjUxMTRDcGVlcmludGZwb24gMTUxNjI4'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '61840548718',
                                                                                                                  'in_ucast_pkts': '300762560',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '1369935464804',
                                                                                                                  'out_ucast_pkts': '951651726',
                                                                                                                  'poller_hash': 'QjBBMjEycGVlcmludGZwb24gMTUyMzc3'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'QzgxRDhFcGVlcmludGZwb24gMTU3NDQ0'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'QzgzQjc0cGVlcmludGZwb24gMTYyNDcz'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '67348657846',
                                                                                                                  'in_ucast_pkts': '274571166',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '1631398275052',
                                                                                                                  'out_ucast_pkts': '1167797243',
                                                                                                                  'poller_hash': 'QzgzNUEzcGVlcmludGZwb24gMTYzMzA5'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '39249919677',
                                                                                                                  'in_ucast_pkts': '72036623',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '164944559804',
                                                                                                                  'out_ucast_pkts': '152153486',
                                                                                                                  'poller_hash': 'Q0JEMjEycGVlcmludGZwb24gMTY0ODA1'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '28257824664',
                                                                                                                  'in_ucast_pkts': '136492831',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '582785009363',
                                                                                                                  'out_ucast_pkts': '447523324',
                                                                                                                  'poller_hash': 'QzgzMTQ2cGVlcmludGZwb24gMTcyNTIx'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '50829907764',
                                                                                                                  'in_ucast_pkts': '374318656',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '1795952028331',
                                                                                                                  'out_ucast_pkts': '1251365948',
                                                                                                                  'poller_hash': 'MTE5MzBDQXBlZXJpbnRmcG9uIDI3NjQ4Mg=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05121',
                                                                                         'name': 'gpon '
                                                                                                 '3/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '223034323',
                                                                                         'out_octets': '13173962265924',
                                                                                         'out_ucast_pkts': '9397297049',
                                                                                         'poller_hash': 'MjExNTEyNjAzNzE3Z3BvbiAzLzI=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '3/2',
                                                                                                                 'id': '3/2',
                                                                                                                 'links': [       {       'connected_time': '688356',
                                                                                                                                          'fiber_length': 10370,
                                                                                                                                          'poller_hash': 'ODY5M0E1cGVlcnBvbnBvbiAxNDI1MDY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.842},
                                                                                                                                  {       'connected_time': '688349',
                                                                                                                                          'fiber_length': 10566,
                                                                                                                                          'poller_hash': 'ODY5M0Q5cGVlcnBvbnBvbiAxNDI1NTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.842},
                                                                                                                                  {       'connected_time': '71555921',
                                                                                                                                          'fiber_length': 10498,
                                                                                                                                          'poller_hash': 'ODY5M0I5cGVlcnBvbnBvbiAxNDI2MDU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.842},
                                                                                                                                  {       'connected_time': '21816583',
                                                                                                                                          'fiber_length': 10332,
                                                                                                                                          'poller_hash': 'ODcyNDg0cGVlcnBvbnBvbiAxNDI4MDM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.842},
                                                                                                                                  {       'connected_time': '688356',
                                                                                                                                          'fiber_length': 10397,
                                                                                                                                          'poller_hash': 'OTU2RjY3cGVlcnBvbnBvbiAxNDU1MDg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.842},
                                                                                                                                  {       'connected_time': '9084563',
                                                                                                                                          'fiber_length': 10866,
                                                                                                                                          'poller_hash': 'QTlDNzdCcGVlcnBvbnBvbiAxNDczNjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.842},
                                                                                                                                  {       'connected_time': '2138232',
                                                                                                                                          'fiber_length': 10885,
                                                                                                                                          'poller_hash': 'QjBBMTRFcGVlcnBvbnBvbiAxNDk2NTU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.842},
                                                                                                                                  {       'connected_time': '67790643',
                                                                                                                                          'fiber_length': 10181,
                                                                                                                                          'poller_hash': 'QjUxMTZDcGVlcnBvbnBvbiAxNTEyMjc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.842},
                                                                                                                                  {       'connected_time': '6230566',
                                                                                                                                          'fiber_length': 10606,
                                                                                                                                          'poller_hash': 'QjUxMTRDcGVlcnBvbnBvbiAxNTE2Mjg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.842},
                                                                                                                                  {       'connected_time': '21816063',
                                                                                                                                          'fiber_length': 10354,
                                                                                                                                          'poller_hash': 'QjBBMjEycGVlcnBvbnBvbiAxNTIzNzc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.842},
                                                                                                                                  {       'connected_time': '6377864',
                                                                                                                                          'fiber_length': 10142,
                                                                                                                                          'poller_hash': 'QzgxRDhFcGVlcnBvbnBvbiAxNTc0NDQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.842},
                                                                                                                                  {       'connected_time': '21816543',
                                                                                                                                          'fiber_length': 10575,
                                                                                                                                          'poller_hash': 'QzgzQjc0cGVlcnBvbnBvbiAxNjI0NzM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                 