import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestAdtranModels(DeviceTestCase):
    def test_adtran_sdx6000_SDX_6320_16_sdx6320_RL_23_5_33_10_59_5_254_02(self):
        if DeviceTestCase.TestDisabled:
                DeviceTestCase.skipTest(self, "Python 3.7 doesn't support this library")

        obj = self.run_data("adtran.sdx6000.SDX 6320-16.sdx6320-RL-23.5-33.10_59_5_254_02")
        exp_info = {
                'model': 'SDX 6320-16',
                'sta_count': 338,
                'sw_version': 'sdx6320-RL-23.5-33',
                'vendor': 'Adtran'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                'ADTN23123E9C': {       'dev_macs': ['38:f8:f6:52:b1:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU2',
                                        'serial': 'ADTN23123E9C'},
                'ADTN23123E9D': {       'dev_macs': ['cc:66:18:dd:8f:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU16',
                                        'serial': 'ADTN23123E9D'},
                'ADTN23123E9E': {       'dev_macs': ['cc:66:18:50:b7:70'],
                                        'ip_address': None,
                                        'name': 'ADTN23123E9E',
                                        'serial': 'ADTN23123E9E'},
                'ADTN23123EA1': {       'dev_macs': ['cc:66:18:db:77:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU17',
                                        'serial': 'ADTN23123EA1'},
                'ADTN23123EA8': {       'dev_macs': ['cc:66:18:dd:88:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU29',
                                        'serial': 'ADTN23123EA8'},
                'ADTN23123EB7': {       'dev_macs': ['38:f8:f6:52:ac:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU10',
                                        'serial': 'ADTN23123EB7'},
                'ADTN23123EBC': {       'dev_macs': ['cc:66:18:dc:77:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU13',
                                        'serial': 'ADTN23123EBC'},
                'ADTN23123EC0': {       'dev_macs': ['cc:66:18:db:65:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU11',
                                        'serial': 'ADTN23123EC0'},
                'ADTN23123F18': {       'dev_macs': ['cc:66:18:db:7d:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU4',
                                        'serial': 'ADTN23123F18'},
                'ADTN23123F2B': {       'dev_macs': ['cc:66:18:50:5c:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU11',
                                        'serial': 'ADTN23123F2B'},
                'ADTN23123F57': {       'dev_macs': ['cc:66:18:dc:68:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU2',
                                        'serial': 'ADTN23123F57'},
                'ADTN23123FAD': {       'dev_macs': ['cc:66:18:dc:76:60'],
                                        'ip_address': None,
                                        'name': 'ADTN23123FAD',
                                        'serial': 'ADTN23123FAD'},
                'ADTN23123FC4': {       'dev_macs': ['cc:66:18:dd:89:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU22',
                                        'serial': 'ADTN23123FC4'},
                'ADTN23123FDC': {       'dev_macs': ['cc:66:18:d6:37:81'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU23',
                                        'serial': 'ADTN23123FDC'},
                'ADTN23123FE9': {       'dev_macs': ['cc:66:18:50:b1:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU13',
                                        'serial': 'ADTN23123FE9'},
                'ADTN23123FEC': {       'dev_macs': ['cc:66:18:4c:03:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU28',
                                        'serial': 'ADTN23123FEC'},
                'ADTN23123FEE': {       'dev_macs': ['cc:66:18:db:65:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU12',
                                        'serial': 'ADTN23123FEE'},
                'ADTN23123FF5': {       'dev_macs': ['cc:66:18:d6:0c:10'],
                                        'ip_address': None,
                                        'name': 'ADTN23123FF5',
                                        'serial': 'ADTN23123FF5'},
                'ADTN23124008': {       'dev_macs': ['cc:66:18:d6:3b:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU33',
                                        'serial': 'ADTN23124008'},
                'ADTN2312408C': {       'dev_macs': ['38:f8:f6:52:ad:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU17',
                                        'serial': 'ADTN2312408C'},
                'ADTN23124097': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU17',
                                        'serial': 'ADTN23124097'},
                'ADTN23124099': {       'dev_macs': ['cc:66:18:51:50:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU19',
                                        'serial': 'ADTN23124099'},
                'ADTN231240A6': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU13',
                                        'serial': 'ADTN231240A6'},
                'ADTN231240B0': {       'dev_macs': ['cc:66:18:dc:5d:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU1',
                                        'serial': 'ADTN231240B0'},
                'ADTN23124128': {       'dev_macs': ['cc:66:18:dc:82:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU8',
                                        'serial': 'ADTN23124128'},
                'ADTN231241A2': {       'dev_macs': ['cc:66:18:50:ae:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU21',
                                        'serial': 'ADTN231241A2'},
                'ADTN231241BF': {       'dev_macs': ['cc:66:18:50:50:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU22',
                                        'serial': 'ADTN231241BF'},
                'ADTN231241C0': {       'dev_macs': ['cc:66:18:dd:8f:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU10',
                                        'serial': 'ADTN231241C0'},
                'ADTN231241D0': {       'dev_macs': ['cc:66:18:dd:7c:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU8',
                                        'serial': 'ADTN231241D0'},
                'ADTN231241D1': {       'dev_macs': ['38:f8:f6:52:ad:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU3',
                                        'serial': 'ADTN231241D1'},
                'ADTN23124214': {       'dev_macs': ['cc:66:18:50:f1:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU20',
                                        'serial': 'ADTN23124214'},
                'ADTN23124304': {       'dev_macs': ['cc:66:18:d6:0b:60'],
                                        'ip_address': None,
                                        'name': 'ADTN23124304',
                                        'serial': 'ADTN23124304'},
                'ADTN2312432E': {       'dev_macs': ['cc:66:18:d6:0a:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU0',
                                        'serial': 'ADTN2312432E'},
                'ADTN2312445C': {       'dev_macs': ['cc:66:18:50:d8:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU7',
                                        'serial': 'ADTN2312445C'},
                'ADTN23124491': {       'dev_macs': ['cc:66:18:d5:fd:61'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU19',
                                        'serial': 'ADTN23124491'},
                'ADTN231244BA': {       'dev_macs': ['38:f8:f6:52:aa:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU0',
                                        'serial': 'ADTN231244BA'},
                'ADTN231244BC': {       'dev_macs': ['38:f8:f6:52:a7:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU8',
                                        'serial': 'ADTN231244BC'},
                'ADTN231244EB': {       'dev_macs': ['cc:66:18:d6:3a:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU17',
                                        'serial': 'ADTN231244EB'},
                'ADTN23124510': {       'dev_macs': ['cc:66:18:50:3d:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU26',
                                        'serial': 'ADTN23124510'},
                'ADTN231245C6': {       'dev_macs': ['cc:66:18:4b:fa:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU6',
                                        'serial': 'ADTN231245C6'},
                'ADTN2312460A': {       'dev_macs': ['38:f8:f6:52:a3:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU2',
                                        'serial': 'ADTN2312460A'},
                'ADTN23124650': {       'dev_macs': ['cc:66:18:dc:81:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU3',
                                        'serial': 'ADTN23124650'},
                'ADTN23124713': {       'dev_macs': ['cc:66:18:dc:88:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU20',
                                        'serial': 'ADTN23124713'},
                'ADTN231247A1': {       'dev_macs': ['cc:66:18:50:51:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU26',
                                        'serial': 'ADTN231247A1'},
                'ADTN23124849': {       'dev_macs': ['cc:66:18:d6:07:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU1',
                                        'serial': 'ADTN23124849'},
                'ADTN231248A8': {       'dev_macs': ['cc:66:18:50:6c:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU9',
                                        'serial': 'ADTN231248A8'},
                'ADTN23124900': {       'dev_macs': ['cc:66:18:dc:72:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU7',
                                        'serial': 'ADTN23124900'},
                'ADTN2312491E': {       'dev_macs': ['cc:66:18:dd:88:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU6',
                                        'serial': 'ADTN2312491E'},
                'ADTN23124966': {       'dev_macs': ['cc:66:18:50:37:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU15',
                                        'serial': 'ADTN23124966'},
                'ADTN23124A18': {       'dev_macs': ['cc:66:18:d6:38:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU21',
                                        'serial': 'ADTN23124A18'},
                'ADTN23124A23': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU3',
                                        'serial': 'ADTN23124A23'},
                'ADTN23124A76': {       'dev_macs': [       '36:3a:c5:c7:0e:34',
                                                            'cc:66:18:50:b4:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU19',
                                        'serial': 'ADTN23124A76'},
                'ADTN23124B3F': {       'dev_macs': ['cc:66:18:50:43:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU22',
                                        'serial': 'ADTN23124B3F'},
                'ADTN23124B7E': {       'dev_macs': ['cc:66:18:50:ef:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU14',
                                        'serial': 'ADTN23124B7E'},
                'ADTN23124BA5': {       'dev_macs': ['cc:66:18:d6:38:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU23',
                                        'serial': 'ADTN23124BA5'},
                'ADTN23124C55': {       'dev_macs': ['cc:66:18:50:81:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU27',
                                        'serial': 'ADTN23124C55'},
                'ADTN23124C6A': {       'dev_macs': ['cc:66:18:51:26:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU27',
                                        'serial': 'ADTN23124C6A'},
                'ADTN23124C73': {       'dev_macs': ['cc:66:18:d6:3c:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU18',
                                        'serial': 'ADTN23124C73'},
                'ADTN23124D38': {       'dev_macs': ['cc:66:18:dc:77:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU6',
                                        'serial': 'ADTN23124D38'},
                'ADTN23124D41': {       'dev_macs': ['cc:66:18:dc:71:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU0',
                                        'serial': 'ADTN23124D41'},
                'ADTN23124D43': {       'dev_macs': ['cc:66:18:dc:56:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU1',
                                        'serial': 'ADTN23124D43'},
                'ADTN23124D46': {       'dev_macs': ['38:f8:f6:52:b4:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU5',
                                        'serial': 'ADTN23124D46'},
                'ADTN23124D50': {       'dev_macs': ['cc:66:18:dc:78:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU5',
                                        'serial': 'ADTN23124D50'},
                'ADTN23124D68': {       'dev_macs': ['cc:66:18:dc:88:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU0',
                                        'serial': 'ADTN23124D68'},
                'ADTN23124D7D': {       'dev_macs': ['38:f8:f6:52:7a:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU7',
                                        'serial': 'ADTN23124D7D'},
                'ADTN23124D7E': {       'dev_macs': ['cc:66:18:dc:74:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU5',
                                        'serial': 'ADTN23124D7E'},
                'ADTN23124D91': {       'dev_macs': ['38:f8:f6:52:a9:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU0',
                                        'serial': 'ADTN23124D91'},
                'ADTN23124D93': {       'dev_macs': ['cc:66:18:dc:87:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU4',
                                        'serial': 'ADTN23124D93'},
                'ADTN23124D98': {       'dev_macs': ['cc:66:18:dd:92:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU4',
                                        'serial': 'ADTN23124D98'},
                'ADTN23124D9E': {       'dev_macs': ['cc:66:18:db:66:60'],
                                        'ip_address': None,
                                        'name': 'ADTN23124D9E',
                                        'serial': 'ADTN23124D9E'},
                'ADTN23124DA0': {       'dev_macs': ['cc:66:18:50:48:80'],
                                        'ip_address': None,
                                        'name': 'ADTN23124DA0',
                                        'serial': 'ADTN23124DA0'},
                'ADTN23124DA6': {       'dev_macs': ['cc:66:18:dc:77:f0'],
                                        'ip_address': None,
                                        'name': 'ADTN23124DA6',
                                        'serial': 'ADTN23124DA6'},
                'ADTN23124DB0': {       'dev_macs': ['cc:66:18:dd:7e:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU7',
                                        'serial': 'ADTN23124DB0'},
                'ADTN23124DB2': {       'dev_macs': ['cc:66:18:dc:80:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU6',
                                        'serial': 'ADTN23124DB2'},
                'ADTN23124DB7': {       'dev_macs': ['cc:66:18:4b:fa:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU8',
                                        'serial': 'ADTN23124DB7'},
                'ADTN23124DBC': {       'dev_macs': ['38:f8:f6:52:ac:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU9',
                                        'serial': 'ADTN23124DBC'},
                'ADTN23124DC7': {       'dev_macs': ['cc:66:18:dd:75:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU1',
                                        'serial': 'ADTN23124DC7'},
                'ADTN23124DCE': {       'dev_macs': ['cc:66:18:dd:2a:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU11',
                                        'serial': 'ADTN23124DCE'},
                'ADTN23124DD9': {       'dev_macs': ['cc:66:18:dd:7e:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU2',
                                        'serial': 'ADTN23124DD9'},
                'ADTN23124DDA': {       'dev_macs': ['cc:66:18:dc:6e:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU1',
                                        'serial': 'ADTN23124DDA'},
                'ADTN23124DDD': {       'dev_macs': ['cc:66:18:dc:57:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU5',
                                        'serial': 'ADTN23124DDD'},
                'ADTN23124DDF': {       'dev_macs': ['cc:66:18:dd:24:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU16',
                                        'serial': 'ADTN23124DDF'},
                'ADTN23124DE0': {       'dev_macs': ['cc:66:18:dd:8e:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU2',
                                        'serial': 'ADTN23124DE0'},
                'ADTN23124DE4': {       'dev_macs': ['cc:66:18:dc:76:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU6',
                                        'serial': 'ADTN23124DE4'},
                'ADTN23124DE8': {       'dev_macs': ['cc:66:18:50:b5:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU12',
                                        'serial': 'ADTN23124DE8'},
                'ADTN23124DEB': {       'dev_macs': ['38:f8:f6:52:9c:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU3',
                                        'serial': 'ADTN23124DEB'},
                'ADTN23124DF1': {       'dev_macs': ['cc:66:18:dc:7f:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU0',
                                        'serial': 'ADTN23124DF1'},
                'ADTN23124DF3': {       'dev_macs': ['cc:66:18:dc:7d:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU9',
                                        'serial': 'ADTN23124DF3'},
                'ADTN23124DF5': {       'dev_macs': ['cc:66:18:dc:6e:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU19',
                                        'serial': 'ADTN23124DF5'},
                'ADTN23124DF6': {       'dev_macs': ['38:f8:f6:52:ac:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU3',
                                        'serial': 'ADTN23124DF6'},
                'ADTN23124DF7': {       'dev_macs': ['cc:66:18:dd:7f:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU14',
                                        'serial': 'ADTN23124DF7'},
                'ADTN23124DFB': {       'dev_macs': ['cc:66:18:dd:73:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU0',
                                        'serial': 'ADTN23124DFB'},
                'ADTN23124DFC': {       'dev_macs': ['cc:66:18:dc:77:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU5',
                                        'serial': 'ADTN23124DFC'},
                'ADTN23124E04': {       'dev_macs': ['cc:66:18:4c:01:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU4',
                                        'serial': 'ADTN23124E04'},
                'ADTN23124E07': {       'dev_macs': ['cc:66:18:dc:56:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU0',
                                        'serial': 'ADTN23124E07'},
                'ADTN23124E0D': {       'dev_macs': ['cc:66:18:dc:75:a0'],
                                        'ip_address': None,
                                        'name': 'ADTN23124E0D',
                                        'serial': 'ADTN23124E0D'},
                'ADTN23124E14': {       'dev_macs': ['cc:66:18:dc:77:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU1',
                                        'serial': 'ADTN23124E14'},
                'ADTN23124E16': {       'dev_macs': ['cc:66:18:dc:73:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU9',
                                        'serial': 'ADTN23124E16'},
                'ADTN23124E17': {       'dev_macs': ['cc:66:18:dc:7d:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU15',
                                        'serial': 'ADTN23124E17'},
                'ADTN23124E18': {       'dev_macs': ['cc:66:18:dc:88:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU1',
                                        'serial': 'ADTN23124E18'},
                'ADTN23124E19': {       'dev_macs': ['cc:66:18:dd:7b:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU21',
                                        'serial': 'ADTN23124E19'},
                'ADTN23124E1F': {       'dev_macs': ['cc:66:18:dd:8b:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU30',
                                        'serial': 'ADTN23124E1F'},
                'ADTN23124E22': {       'dev_macs': ['cc:66:18:dd:8d:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU12',
                                        'serial': 'ADTN23124E22'},
                'ADTN23124E23': {       'dev_macs': ['cc:66:18:4c:03:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU24',
                                        'serial': 'ADTN23124E23'},
                'ADTN23124E25': {       'dev_macs': ['38:f8:f6:52:af:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU13',
                                        'serial': 'ADTN23124E25'},
                'ADTN23124E26': {       'dev_macs': ['cc:66:18:dd:93:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU3',
                                        'serial': 'ADTN23124E26'},
                'ADTN23124E27': {       'dev_macs': ['cc:66:18:dc:70:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU25',
                                        'serial': 'ADTN23124E27'},
                'ADTN23124E29': {       'dev_macs': ['cc:66:18:dd:68:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU7',
                                        'serial': 'ADTN23124E29'},
                'ADTN23124E2A': {       'dev_macs': ['cc:66:18:d6:08:e0'],
                                        'ip_address': None,
                                        'name': 'ADTN23124E2A',
                                        'serial': 'ADTN23124E2A'},
                'ADTN23124E2B': {       'dev_macs': ['38:f8:f6:52:b2:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU10',
                                        'serial': 'ADTN23124E2B'},
                'ADTN23124E2D': {       'dev_macs': ['cc:66:18:dd:8a:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU15',
                                        'serial': 'ADTN23124E2D'},
                'ADTN23124E30': {       'dev_macs': ['cc:66:18:dc:79:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU5',
                                        'serial': 'ADTN23124E30'},
                'ADTN23124E33': {       'dev_macs': ['cc:66:18:d6:08:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU17',
                                        'serial': 'ADTN23124E33'},
                'ADTN23124E35': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU3',
                                        'serial': 'ADTN23124E35'},
                'ADTN23124E37': {       'dev_macs': ['cc:66:18:dc:6e:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU11',
                                        'serial': 'ADTN23124E37'},
                'ADTN23124E3A': {       'dev_macs': ['cc:66:18:dd:8a:b1'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU7',
                                        'serial': 'ADTN23124E3A'},
                'ADTN23124E3E': {       'dev_macs': ['cc:66:18:dc:70:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU4',
                                        'serial': 'ADTN23124E3E'},
                'ADTN23124E3F': {       'dev_macs': ['cc:66:18:dd:83:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU23',
                                        'serial': 'ADTN23124E3F'},
                'ADTN23124E40': {       'dev_macs': ['cc:66:18:dd:8a:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU0',
                                        'serial': 'ADTN23124E40'},
                'ADTN23124E43': {       'dev_macs': ['cc:66:18:d6:03:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU18',
                                        'serial': 'ADTN23124E43'},
                'ADTN23124E45': {       'dev_macs': ['cc:66:18:dc:83:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU0',
                                        'serial': 'ADTN23124E45'},
                'ADTN23124E4B': {       'dev_macs': ['cc:66:18:dd:8f:b0'],
                                        'ip_address': None,
                                        'name': 'ADTN23124E4B',
                                        'serial': 'ADTN23124E4B'},
                'ADTN23124E4D': {       'dev_macs': ['cc:66:18:d6:08:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU4',
                                        'serial': 'ADTN23124E4D'},
                'ADTN23124E50': {       'dev_macs': ['cc:66:18:d6:00:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU11',
                                        'serial': 'ADTN23124E50'},
                'ADTN23124E52': {       'dev_macs': ['cc:66:18:dd:82:c0'],
                                        'ip_address': None,
                                        'name': 'ADTN23124E52',
                                        'serial': 'ADTN23124E52'},
                'ADTN23124E57': {       'dev_macs': ['38:f8:f6:52:ab:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU9',
                                        'serial': 'ADTN23124E57'},
                'ADTN23124E5B': {       'dev_macs': ['cc:66:18:4c:02:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU17',
                                        'serial': 'ADTN23124E5B'},
                'ADTN23124E64': {       'dev_macs': ['cc:66:18:4b:fa:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU26',
                                        'serial': 'ADTN23124E64'},
                'ADTN23124E67': {       'dev_macs': ['cc:66:18:dd:82:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU22',
                                        'serial': 'ADTN23124E67'},
                'ADTN23124E6A': {       'dev_macs': ['cc:66:18:d6:3a:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU5',
                                        'serial': 'ADTN23124E6A'},
                'ADTN23124E6B': {       'dev_macs': ['cc:66:18:dc:87:c0'],
                                        'ip_address': None,
                                        'name': 'ADTN23124E6B',
                                        'serial': 'ADTN23124E6B'},
                'ADTN23124E71': {       'dev_macs': ['cc:66:18:dd:84:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU0',
                                        'serial': 'ADTN23124E71'},
                'ADTN23124E73': {       'dev_macs': ['cc:66:18:50:52:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU13',
                                        'serial': 'ADTN23124E73'},
                'ADTN23124E7A': {       'dev_macs': ['cc:66:18:dd:7e:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU1',
                                        'serial': 'ADTN23124E7A'},
                'ADTN23124E84': {       'dev_macs': ['cc:66:18:dc:71:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU5',
                                        'serial': 'ADTN23124E84'},
                'ADTN23124E86': {       'dev_macs': ['cc:66:18:dc:6d:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU8',
                                        'serial': 'ADTN23124E86'},
                'ADTN23124E8A': {       'dev_macs': ['cc:66:18:51:30:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU14',
                                        'serial': 'ADTN23124E8A'},
                'ADTN23124E92': {       'dev_macs': ['38:f8:f6:52:a6:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU6',
                                        'serial': 'ADTN23124E92'},
                'ADTN23124EA4': {       'dev_macs': ['cc:66:18:4c:8d:d0'],
                                        'ip_address': None,
                                        'name': 'ADTN23124EA4',
                                        'serial': 'ADTN23124EA4'},
                'ADTN23124EA5': {       'dev_macs': ['cc:66:18:dc:8a:10'],
                                        'ip_address': None,
                                        'name': 'ADTN23124EA5',
                                        'serial': 'ADTN23124EA5'},
                'ADTN23124ED3': {       'dev_macs': ['cc:66:18:d6:32:11'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU7',
                                        'serial': 'ADTN23124ED3'},
                'ADTN23124ED9': {       'dev_macs': ['cc:66:18:dd:7c:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU3',
                                        'serial': 'ADTN23124ED9'},
                'ADTN23124EDF': {       'dev_macs': ['cc:66:18:dc:81:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU3',
                                        'serial': 'ADTN23124EDF'},
                'ADTN23124EFA': {       'dev_macs': ['cc:66:18:db:76:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU2',
                                        'serial': 'ADTN23124EFA'},
                'ADTN23124F06': {       'dev_macs': ['38:f8:f6:52:ab:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU10',
                                        'serial': 'ADTN23124F06'},
                'ADTN23124F14': {       'dev_macs': ['cc:66:18:dc:6b:c0'],
                                        'ip_address': None,
                                        'name': 'ADTN23124F14',
                                        'serial': 'ADTN23124F14'},
                'ADTN23124F2B': {       'dev_macs': ['cc:66:18:dc:81:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU10',
                                        'serial': 'ADTN23124F2B'},
                'ADTN23124F2D': {       'dev_macs': ['38:f8:f6:52:af:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU0',
                                        'serial': 'ADTN23124F2D'},
                'ADTN23124F30': {       'dev_macs': ['cc:66:18:dc:75:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU6',
                                        'serial': 'ADTN23124F30'},
                'ADTN23124F34': {       'dev_macs': ['38:f8:f6:52:ac:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU8',
                                        'serial': 'ADTN23124F34'},
                'ADTN23124F37': {       'dev_macs': ['cc:66:18:dd:89:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU5',
                                        'serial': 'ADTN23124F37'},
                'ADTN23124F3C': {       'dev_macs': ['cc:66:18:dc:78:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU4',
                                        'serial': 'ADTN23124F3C'},
                'ADTN23124F74': {       'dev_macs': ['cc:66:18:dd:83:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU16',
                                        'serial': 'ADTN23124F74'},
                'ADTN23124F99': {       'dev_macs': ['cc:66:18:dc:75:51'],
                                        'ip_address': None,
                                        'name': 'ADTN23124F99',
                                        'serial': 'ADTN23124F99'},
                'ADTN2312501D': {       'dev_macs': ['cc:66:18:dc:73:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU18',
                                        'serial': 'ADTN2312501D'},
                'ADTN23125020': {       'dev_macs': ['cc:66:18:dd:7d:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU4',
                                        'serial': 'ADTN23125020'},
                'ADTN23125026': {       'dev_macs': ['cc:66:18:dd:79:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU1',
                                        'serial': 'ADTN23125026'},
                'ADTN23125037': {       'dev_macs': ['38:f8:f6:52:ac:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU13',
                                        'serial': 'ADTN23125037'},
                'ADTN23125055': {       'dev_macs': ['cc:66:18:dc:81:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU2',
                                        'serial': 'ADTN23125055'},
                'ADTN23125061': {       'dev_macs': ['cc:66:18:4c:01:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU0',
                                        'serial': 'ADTN23125061'},
                'ADTN23125065': {       'dev_macs': ['cc:66:18:50:4f:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU15',
                                        'serial': 'ADTN23125065'},
                'ADTN2312506C': {       'dev_macs': ['cc:66:18:51:42:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU19',
                                        'serial': 'ADTN2312506C'},
                'ADTN23125088': {       'dev_macs': ['cc:66:18:dd:8b:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU3',
                                        'serial': 'ADTN23125088'},
                'ADTN2312509E': {       'dev_macs': ['cc:66:18:d6:08:f0'],
                                        'ip_address': None,
                                        'name': 'ADTN2312509E',
                                        'serial': 'ADTN2312509E'},
                'ADTN231250BB': {       'dev_macs': ['cc:66:18:db:65:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU13',
                                        'serial': 'ADTN231250BB'},
                'ADTN231250BF': {       'dev_macs': ['cc:66:18:d6:08:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU10',
                                        'serial': 'ADTN231250BF'},
                'ADTN231250C0': {       'dev_macs': ['cc:66:18:d6:09:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU9',
                                        'serial': 'ADTN231250C0'},
                'ADTN231250C3': {       'dev_macs': ['cc:66:18:dc:77:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU23',
                                        'serial': 'ADTN231250C3'},
                'ADTN231250C6': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU2',
                                        'serial': 'ADTN231250C6'},
                'ADTN231250C8': {       'dev_macs': ['cc:66:18:51:50:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU16',
                                        'serial': 'ADTN231250C8'},
                'ADTN231250CC': {       'dev_macs': ['cc:66:18:dd:7b:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU6',
                                        'serial': 'ADTN231250CC'},
                'ADTN231250CD': {       'dev_macs': ['cc:66:18:50:63:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU11',
                                        'serial': 'ADTN231250CD'},
                'ADTN231250D1': {       'dev_macs': ['cc:66:18:50:f5:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU14',
                                        'serial': 'ADTN231250D1'},
                'ADTN231250DD': {       'dev_macs': ['cc:66:18:4c:02:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU12',
                                        'serial': 'ADTN231250DD'},
                'ADTN231250FE': {       'dev_macs': ['cc:66:18:d6:02:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU8',
                                        'serial': 'ADTN231250FE'},
                'ADTN23125103': {       'dev_macs': ['cc:66:18:d6:04:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU9',
                                        'serial': 'ADTN23125103'},
                'ADTN2312510B': {       'dev_macs': ['cc:66:18:dc:88:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU20',
                                        'serial': 'ADTN2312510B'},
                'ADTN2312510C': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU11',
                                        'serial': 'ADTN2312510C'},
                'ADTN23125111': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU7',
                                        'serial': 'ADTN23125111'},
                'ADTN23125116': {       'dev_macs': ['cc:66:18:dc:79:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU14',
                                        'serial': 'ADTN23125116'},
                'ADTN2312511D': {       'dev_macs': ['cc:66:18:d6:0b:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU12',
                                        'serial': 'ADTN2312511D'},
                'ADTN23125126': {       'dev_macs': ['cc:66:18:dc:6a:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU18',
                                        'serial': 'ADTN23125126'},
                'ADTN23125129': {       'dev_macs': ['cc:66:18:d6:09:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU16',
                                        'serial': 'ADTN23125129'},
                'ADTN2312512C': {       'dev_macs': ['cc:66:18:dc:6c:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU16',
                                        'serial': 'ADTN2312512C'},
                'ADTN2312512E': {       'dev_macs': ['cc:66:18:dd:8e:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU10',
                                        'serial': 'ADTN2312512E'},
                'ADTN2312512F': {       'dev_macs': ['cc:66:18:4b:fa:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU15',
                                        'serial': 'ADTN2312512F'},
                'ADTN23125133': {       'dev_macs': ['cc:66:18:db:76:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU18',
                                        'serial': 'ADTN23125133'},
                'ADTN23125135': {       'dev_macs': ['cc:66:18:50:3e:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU26',
                                        'serial': 'ADTN23125135'},
                'ADTN2312513A': {       'dev_macs': ['cc:66:18:50:50:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU9',
                                        'serial': 'ADTN2312513A'},
                'ADTN23125143': {       'dev_macs': ['cc:66:18:d6:07:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU8',
                                        'serial': 'ADTN23125143'},
                'ADTN23125146': {       'dev_macs': ['cc:66:18:dd:91:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU7',
                                        'serial': 'ADTN23125146'},
                'ADTN23125148': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU12',
                                        'serial': 'ADTN23125148'},
                'ADTN23125149': {       'dev_macs': ['cc:66:18:d6:36:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU1',
                                        'serial': 'ADTN23125149'},
                'ADTN2312514A': {       'dev_macs': ['cc:66:18:dc:83:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU18',
                                        'serial': 'ADTN2312514A'},
                'ADTN2312514B': {       'dev_macs': ['cc:66:18:d6:35:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU12',
                                        'serial': 'ADTN2312514B'},
                'ADTN2312514C': {       'dev_macs': ['cc:66:18:50:87:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU21',
                                        'serial': 'ADTN2312514C'},
                'ADTN2312514D': {       'dev_macs': ['38:f8:f6:52:b3:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU9',
                                        'serial': 'ADTN2312514D'},
                'ADTN2312514E': {       'dev_macs': ['cc:66:18:dd:8a:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU11',
                                        'serial': 'ADTN2312514E'},
                'ADTN2312514F': {       'dev_macs': ['cc:66:18:51:24:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU21',
                                        'serial': 'ADTN2312514F'},
                'ADTN23125150': {       'dev_macs': ['cc:66:18:d6:36:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x14-ONU0',
                                        'serial': 'ADTN23125150'},
                'ADTN23125153': {       'dev_macs': ['38:f8:f6:52:a8:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU19',
                                        'serial': 'ADTN23125153'},
                'ADTN23125158': {       'dev_macs': ['cc:66:18:dd:92:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU11',
                                        'serial': 'ADTN23125158'},
                'ADTN2312515B': {       'dev_macs': ['cc:66:18:dc:7f:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU12',
                                        'serial': 'ADTN2312515B'},
                'ADTN23125160': {       'dev_macs': ['cc:66:18:dd:69:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU4',
                                        'serial': 'ADTN23125160'},
                'ADTN23125161': {       'dev_macs': ['cc:66:18:dc:65:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU6',
                                        'serial': 'ADTN23125161'},
                'ADTN23125166': {       'dev_macs': ['cc:66:18:dd:78:e0'],
                                        'ip_address': None,
                                        'name': 'ADTN23125166',
                                        'serial': 'ADTN23125166'},
                'ADTN23125171': {       'dev_macs': ['cc:66:18:4c:04:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU2',
                                        'serial': 'ADTN23125171'},
                'ADTN2312517D': {       'dev_macs': ['cc:66:18:dd:78:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU11',
                                        'serial': 'ADTN2312517D'},
                'ADTN2312517F': {       'dev_macs': ['cc:66:18:dd:23:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU11',
                                        'serial': 'ADTN2312517F'},
                'ADTN2312518D': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU23',
                                        'serial': 'ADTN2312518D'},
                'ADTN2312518E': {       'dev_macs': ['cc:66:18:db:74:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU10',
                                        'serial': 'ADTN2312518E'},
                'ADTN23125190': {       'dev_macs': ['cc:66:18:50:75:70'],
                                        'ip_address': None,
                                        'name': 'ADTN23125190',
                                        'serial': 'ADTN23125190'},
                'ADTN23125194': {       'dev_macs': ['cc:66:18:50:81:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU10',
                                        'serial': 'ADTN23125194'},
                'ADTN23125195': {       'dev_macs': ['cc:66:18:50:b8:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU5',
                                        'serial': 'ADTN23125195'},
                'ADTN231251AA': {       'dev_macs': ['cc:66:18:d6:37:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU20',
                                        'serial': 'ADTN231251AA'},
                'ADTN231251AB': {       'dev_macs': ['cc:66:18:4c:a3:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU20',
                                        'serial': 'ADTN231251AB'},
                'ADTN231251B0': {       'dev_macs': ['cc:66:18:dd:8d:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU15',
                                        'serial': 'ADTN231251B0'},
                'ADTN231251B1': {       'dev_macs': ['cc:66:18:dd:6a:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU13',
                                        'serial': 'ADTN231251B1'},
                'ADTN231251E2': {       'dev_macs': ['38:f8:f6:52:71:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU2',
                                        'serial': 'ADTN231251E2'},
                'ADTN231251EB': {       'dev_macs': ['cc:66:18:dc:56:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU5',
                                        'serial': 'ADTN231251EB'},
                'ADTN231251EE': {       'dev_macs': ['cc:66:18:dd:93:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU13',
                                        'serial': 'ADTN231251EE'},
                'ADTN231251F6': {       'dev_macs': ['cc:66:18:d6:08:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU6',
                                        'serial': 'ADTN231251F6'},
                'ADTN231251F7': {       'dev_macs': ['cc:66:18:dc:79:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU4',
                                        'serial': 'ADTN231251F7'},
                'ADTN23125206': {       'dev_macs': ['cc:66:18:50:6e:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU8',
                                        'serial': 'ADTN23125206'},
                'ADTN2314428A': {       'dev_macs': ['cc:66:18:dc:97:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU20',
                                        'serial': 'ADTN2314428A'},
                'ADTN23144666': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU25',
                                        'serial': 'ADTN23144666'},
                'ADTN23144681': {       'dev_macs': ['cc:66:18:d6:3b:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU5',
                                        'serial': 'ADTN23144681'},
                'ADTN2314468C': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU17',
                                        'serial': 'ADTN2314468C'},
                'ADTN23144699': {       'dev_macs': ['cc:66:18:dc:78:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU18',
                                        'serial': 'ADTN23144699'},
                'ADTN2314469E': {       'dev_macs': ['cc:66:18:dd:87:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU24',
                                        'serial': 'ADTN2314469E'},
                'ADTN231446A3': {       'dev_macs': ['38:f8:f6:52:a9:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU13',
                                        'serial': 'ADTN231446A3'},
                'ADTN231446A5': {       'dev_macs': ['cc:66:18:d6:3a:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU17',
                                        'serial': 'ADTN231446A5'},
                'ADTN231446B4': {       'dev_macs': ['cc:66:18:50:23:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU14',
                                        'serial': 'ADTN231446B4'},
                'ADTN231446B8': {       'dev_macs': ['38:f8:f6:52:a8:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU13',
                                        'serial': 'ADTN231446B8'},
                'ADTN231446BC': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU12',
                                        'serial': 'ADTN231446BC'},
                'ADTN231446C0': {       'dev_macs': ['cc:66:18:50:5b:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU18',
                                        'serial': 'ADTN231446C0'},
                'ADTN231446CB': {       'dev_macs': ['cc:66:18:dd:6a:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU14',
                                        'serial': 'ADTN231446CB'},
                'ADTN231446CC': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU14',
                                        'serial': 'ADTN231446CC'},
                'ADTN231446CE': {       'dev_macs': ['cc:66:18:dc:89:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU15',
                                        'serial': 'ADTN231446CE'},
                'ADTN23144702': {       'dev_macs': ['cc:66:18:d6:08:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU11',
                                        'serial': 'ADTN23144702'},
                'ADTN23144707': {       'dev_macs': ['cc:66:18:dd:52:20'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU10',
                                        'serial': 'ADTN23144707'},
                'ADTN23144714': {       'dev_macs': ['cc:66:18:dd:8d:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x14-ONU1',
                                        'serial': 'ADTN23144714'},
                'ADTN23144735': {       'dev_macs': ['cc:66:18:dc:84:51'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU25',
                                        'serial': 'ADTN23144735'},
                'ADTN23144748': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU14',
                                        'serial': 'ADTN23144748'},
                'ADTN23144759': {       'dev_macs': ['cc:66:18:4b:fc:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU15',
                                        'serial': 'ADTN23144759'},
                'ADTN23144773': {       'dev_macs': ['cc:66:18:dd:29:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU17',
                                        'serial': 'ADTN23144773'},
                'ADTN2314477A': {       'dev_macs': ['cc:66:18:dd:8a:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU26',
                                        'serial': 'ADTN2314477A'},
                'ADTN23144796': {       'dev_macs': ['cc:66:18:50:ce:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU14',
                                        'serial': 'ADTN23144796'},
                'ADTN231447A4': {       'dev_macs': ['cc:66:18:dc:86:d1'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU31',
                                        'serial': 'ADTN231447A4'},
                'ADTN231447A5': {       'dev_macs': ['cc:66:18:50:58:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU24',
                                        'serial': 'ADTN231447A5'},
                'ADTN231447AB': {       'dev_macs': ['cc:66:18:dc:b3:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU28',
                                        'serial': 'ADTN231447AB'},
                'ADTN231447AC': {       'dev_macs': ['cc:66:18:dc:b3:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU23',
                                        'serial': 'ADTN231447AC'},
                'ADTN231447AE': {       'dev_macs': ['cc:66:18:d6:03:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU15',
                                        'serial': 'ADTN231447AE'},
                'ADTN231447BD': {       'dev_macs': ['38:f8:f6:52:a8:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU12',
                                        'serial': 'ADTN231447BD'},
                'ADTN231447DA': {       'dev_macs': ['38:f8:f6:52:ab:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU24',
                                        'serial': 'ADTN231447DA'},
                'ADTN231447E3': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU15',
                                        'serial': 'ADTN231447E3'},
                'ADTN231447F3': {       'dev_macs': ['cc:66:18:dd:89:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU29',
                                        'serial': 'ADTN231447F3'},
                'ADTN231447F9': {       'dev_macs': ['38:f8:f6:52:a8:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU4',
                                        'serial': 'ADTN231447F9'},
                'ADTN2314480D': {       'dev_macs': ['cc:66:18:d6:0a:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU27',
                                        'serial': 'ADTN2314480D'},
                'ADTN2314483B': {       'dev_macs': ['cc:66:18:d6:07:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU13',
                                        'serial': 'ADTN2314483B'},
                'ADTN23144861': {       'dev_macs': ['cc:66:18:50:9a:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU15',
                                        'serial': 'ADTN23144861'},
                'ADTN2314486C': {       'dev_macs': ['cc:66:18:dc:84:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU16',
                                        'serial': 'ADTN2314486C'},
                'ADTN23144883': {       'dev_macs': ['cc:66:18:d6:0a:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU9',
                                        'serial': 'ADTN23144883'},
                'ADTN2314489C': {       'dev_macs': ['cc:66:18:d6:0c:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU6',
                                        'serial': 'ADTN2314489C'},
                'ADTN2314489D': {       'dev_macs': ['cc:66:18:50:6e:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU8',
                                        'serial': 'ADTN2314489D'},
                'ADTN231448B4': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU22',
                                        'serial': 'ADTN231448B4'},
                'ADTN231448B8': {       'dev_macs': ['cc:66:18:dd:8c:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU3',
                                        'serial': 'ADTN231448B8'},
                'ADTN231448BA': {       'dev_macs': ['cc:66:18:d6:38:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU7',
                                        'serial': 'ADTN231448BA'},
                'ADTN231448C9': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU18',
                                        'serial': 'ADTN231448C9'},
                'ADTN231448D1': {       'dev_macs': ['cc:66:18:50:b3:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU15',
                                        'serial': 'ADTN231448D1'},
                'ADTN231448D5': {       'dev_macs': ['cc:66:18:d6:0c:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU21',
                                        'serial': 'ADTN231448D5'},
                'ADTN231448FC': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU2',
                                        'serial': 'ADTN231448FC'},
                'ADTN231448FE': {       'dev_macs': ['cc:66:18:d6:0b:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU16',
                                        'serial': 'ADTN231448FE'},
                'ADTN23144916': {       'dev_macs': ['38:f8:f6:52:a8:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU19',
                                        'serial': 'ADTN23144916'},
                'ADTN23144A15': {       'dev_macs': ['cc:66:18:50:6e:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU7',
                                        'serial': 'ADTN23144A15'},
                'ADTN23144A2B': {       'dev_macs': ['cc:66:18:dc:89:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU22',
                                        'serial': 'ADTN23144A2B'},
                'ADTN23144A53': {       'dev_macs': ['cc:66:18:d6:38:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU4',
                                        'serial': 'ADTN23144A53'},
                'ADTN23144A5A': {       'dev_macs': ['cc:66:18:4c:03:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU3',
                                        'serial': 'ADTN23144A5A'},
                'ADTN23144A5C': {       'dev_macs': ['cc:66:18:4c:00:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU6',
                                        'serial': 'ADTN23144A5C'},
                'ADTN23144A69': {       'dev_macs': ['cc:66:18:51:04:e0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU32',
                                        'serial': 'ADTN23144A69'},
                'ADTN23144A70': {       'dev_macs': ['cc:66:18:50:d0:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU24',
                                        'serial': 'ADTN23144A70'},
                'ADTN23144A84': {       'dev_macs': ['cc:66:18:d6:34:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU5',
                                        'serial': 'ADTN23144A84'},
                'ADTN23144A86': {       'dev_macs': [       '08:55:31:e1:ea:4b',
                                                            '18:e8:29:34:ed:33',
                                                            '18:e8:29:36:d4:71',
                                                            '18:e8:29:3a:1a:3d',
                                                            '18:e8:29:8e:ed:6f',
                                                            '18:e8:29:8e:ed:78',
                                                            '18:e8:29:8e:f1:06',
                                                            '24:5a:4c:e4:c8:a1',
                                                            '74:83:c2:a6:5a:93',
                                                            '74:83:c2:a6:7f:9f',
                                                            '74:83:c2:a6:86:4e',
                                                            '74:83:c2:e8:a2:61',
                                                            '74:83:c2:ea:a6:01',
                                                            '74:83:c2:ea:a6:28',
                                                            '74:83:c2:ec:11:8b',
                                                            '74:ac:b9:80:d4:53',
                                                            '94:a6:7e:dd:ad:81',
                                                            'b4:fb:e4:5a:4f:8e',
                                                            'b8:94:70:f8:2b:2a',
                                                            'dc:2c:6e:dd:2e:26',
                                                            'f4:92:bf:38:a5:74',
                                                            'f4:92:bf:38:a7:25',
                                                            'f4:92:bf:38:a7:c2',
                                                            'f4:92:bf:d6:a8:ac'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x9-ONU25',
                                        'serial': 'ADTN23144A86'},
                'ADTN23144A97': {       'dev_macs': ['cc:66:18:d6:37:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU16',
                                        'serial': 'ADTN23144A97'},
                'ADTN23144A9B': {       'dev_macs': ['cc:66:18:51:21:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU11',
                                        'serial': 'ADTN23144A9B'},
                'ADTN23144A9C': {       'dev_macs': ['cc:66:18:dd:8a:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU16',
                                        'serial': 'ADTN23144A9C'},
                'ADTN23144AB0': {       'dev_macs': ['cc:66:18:4c:01:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU26',
                                        'serial': 'ADTN23144AB0'},
                'ADTN23144ACF': {       'dev_macs': ['38:f8:f6:52:a1:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU12',
                                        'serial': 'ADTN23144ACF'},
                'ADTN23144B20': {       'dev_macs': ['cc:66:18:dc:aa:e1'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU31',
                                        'serial': 'ADTN23144B20'},
                'ADTN23144B24': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU18',
                                        'serial': 'ADTN23144B24'},
                'ADTN23144B2C': {       'dev_macs': ['cc:66:18:d6:3c:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU17',
                                        'serial': 'ADTN23144B2C'},
                'ADTN23144B3A': {       'dev_macs': ['cc:66:18:db:7e:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU20',
                                        'serial': 'ADTN23144B3A'},
                'ADTN23144B3F': {       'dev_macs': ['cc:66:18:50:63:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU8',
                                        'serial': 'ADTN23144B3F'},
                'ADTN23144B4D': {       'dev_macs': ['cc:66:18:50:9c:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU21',
                                        'serial': 'ADTN23144B4D'},
                'ADTN23144B58': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU19',
                                        'serial': 'ADTN23144B58'},
                'ADTN23144B5E': {       'dev_macs': ['cc:66:18:51:31:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU10',
                                        'serial': 'ADTN23144B5E'},
                'ADTN23144BF7': {       'dev_macs': ['cc:66:18:4c:55:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU16',
                                        'serial': 'ADTN23144BF7'},
                'ADTN23144C10': {       'dev_macs': ['cc:66:18:d6:36:70'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU21',
                                        'serial': 'ADTN23144C10'},
                'ADTN23144C17': {       'dev_macs': ['cc:66:18:51:04:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU25',
                                        'serial': 'ADTN23144C17'},
                'ADTN23144C33': {       'dev_macs': ['cc:66:18:dd:91:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x14-ONU2',
                                        'serial': 'ADTN23144C33'},
                'ADTN23144C46': {       'dev_macs': ['cc:66:18:dc:75:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU20',
                                        'serial': 'ADTN23144C46'},
                'ADTN23144C4E': {       'dev_macs': ['cc:66:18:50:a9:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU21',
                                        'serial': 'ADTN23144C4E'},
                'ADTN23144C8B': {       'dev_macs': ['cc:66:18:50:62:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU9',
                                        'serial': 'ADTN23144C8B'},
                'ADTN23144CC3': {       'dev_macs': ['cc:66:18:dd:8a:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU19',
                                        'serial': 'ADTN23144CC3'},
                'ADTN23144CD5': {       'dev_macs': ['cc:66:18:dd:93:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU18',
                                        'serial': 'ADTN23144CD5'},
                'ADTN23144D50': {       'dev_macs': ['cc:66:18:d6:0c:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU17',
                                        'serial': 'ADTN23144D50'},
                'ADTN23144D99': {       'dev_macs': ['cc:66:18:50:3f:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU7',
                                        'serial': 'ADTN23144D99'},
                'ADTN23144DDF': {       'dev_macs': ['cc:66:18:d6:37:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU16',
                                        'serial': 'ADTN23144DDF'},
                'ADTN23144EC8': {       'dev_macs': ['cc:66:18:50:ad:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU24',
                                        'serial': 'ADTN23144EC8'},
                'ADTN23144ED2': {       'dev_macs': ['cc:66:18:50:7b:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU30',
                                        'serial': 'ADTN23144ED2'},
                'ADTN23144ED3': {       'dev_macs': ['cc:66:18:50:b7:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x8-ONU34',
                                        'serial': 'ADTN23144ED3'},
                'ADTN23144EDF': {       'dev_macs': ['cc:66:18:50:39:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU19',
                                        'serial': 'ADTN23144EDF'},
                'ADTN23144EE0': {       'dev_macs': ['cc:66:18:50:b6:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU23',
                                        'serial': 'ADTN23144EE0'},
                'ADTN23144EE3': {       'dev_macs': ['cc:66:18:dc:a8:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU28',
                                        'serial': 'ADTN23144EE3'},
                'ADTN23144EFB': {       'dev_macs': ['cc:66:18:dc:b4:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU17',
                                        'serial': 'ADTN23144EFB'},
                'ADTN23144EFD': {       'dev_macs': ['cc:66:18:dc:71:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x4-ONU20',
                                        'serial': 'ADTN23144EFD'},
                'ADTN23144EFF': {       'dev_macs': ['cc:66:18:50:4a:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU20',
                                        'serial': 'ADTN23144EFF'},
                'ADTN23144F00': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU25',
                                        'serial': 'ADTN23144F00'},
                'ADTN23145120': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU20',
                                        'serial': 'ADTN23145120'},
                'ADTN24314195': {       'dev_macs': ['cc:66:18:d6:39:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU10',
                                        'serial': 'ADTN24314195'},
                'ADTN243141A3': {       'dev_macs': ['cc:66:18:50:e6:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU22',
                                        'serial': 'ADTN243141A3'},
                'ADTN243141AC': {       'dev_macs': ['cc:66:18:dd:81:80'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU19',
                                        'serial': 'ADTN243141AC'},
                'ADTN24314314': {       'dev_macs': ['cc:66:18:51:27:10'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU22',
                                        'serial': 'ADTN24314314'},
                'ADTN243144FB': {       'dev_macs': ['cc:66:18:50:fd:b0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x6-ONU6',
                                        'serial': 'ADTN243144FB'},
                'ADTN24314766': {       'dev_macs': ['cc:66:18:50:3e:40'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU28',
                                        'serial': 'ADTN24314766'},
                'ADTN24363AE7': {       'dev_macs': ['38:f8:f6:52:ab:a0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU29',
                                        'serial': 'ADTN24363AE7'},
                'ADTN24363B6B': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x1-ONU27',
                                        'serial': 'ADTN24363B6B'},
                'ADTN24363BBA': {       'dev_macs': ['cc:66:18:50:b6:c0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x12-ONU18',
                                        'serial': 'ADTN24363BBA'},
                'ADTN24363C49': {       'dev_macs': ['cc:66:18:51:2e:00'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU31',
                                        'serial': 'ADTN24363C49'},
                'ADTN24363CC6': {       'dev_macs': ['cc:66:18:50:62:90'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x2-ONU13',
                                        'serial': 'ADTN24363CC6'},
                'ADTN24363D3A': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x5-ONU21',
                                        'serial': 'ADTN24363D3A'},
                'ADTN24363D4D': {       'dev_macs': ['cc:66:18:50:6a:d0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x11-ONU32',
                                        'serial': 'ADTN24363D4D'},
                'ADTN24363DB9': {       'dev_macs': ['cc:66:18:50:b1:30'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU16',
                                        'serial': 'ADTN24363DB9'},
                'ADTN24363DC9': {       'dev_macs': ['cc:66:18:50:ac:60'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU28',
                                        'serial': 'ADTN24363DC9'},
                'ADTN243896F9': {       'dev_macs': ['cc:66:18:51:25:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x3-ONU30',
                                        'serial': 'ADTN243896F9'},
                'ADTN244917A4': {       'dev_macs': ['cc:66:18:50:9b:50'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x10-ONU22',
                                        'serial': 'ADTN244917A4'},
                'ADTN251521A2': {       'dev_macs': ['cc:66:18:50:ba:f0'],
                                        'ip_address': None,
                                        'name': 'IndianBayou-x13-ONU17',
                                        'serial': 'ADTN251521A2'},
                'CXNK00A4305B': {       'dev_macs': set(),
                                        'ip_address': None,
                                        'name': 'IndianBayou-x7-ONU19',
                                        'serial': 'CXNK00A4305B'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 39.37,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '0/1',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:dc:71:b0'],
                                                                                       'in_nucast_pkts': '14537',
                                                                                       'in_octets': '983568170',
                                                                                       'in_ucast_pkts': '6528585',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '17955758353',
                                                                                       'out_ucast_pkts': '12484499',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDQxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:5d:e0'],
                                                                                       'in_nucast_pkts': '14480',
                                                                                       'in_octets': '1572259937',
                                                                                       'in_ucast_pkts': '6243316',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '29939132609',
                                                                                       'out_ucast_pkts': '21426454',
                                                                                       'poller_hash': 'QURUTjIzMTI0MEIwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:7e:90'],
                                                                                       'in_nucast_pkts': '14820',
                                                                                       'in_octets': '9477065744',
                                                                                       'in_ucast_pkts': '46725402',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '131191620822',
                                                                                       'out_ucast_pkts': '105992610',
                                                                                       'poller_hash': 'QURUTjIzMTI0REQ5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ad:c0'],
                                                                                       'in_nucast_pkts': '14280',
                                                                                       'in_octets': '10173859269',
                                                                                       'in_ucast_pkts': '47770475',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '154648734777',
                                                                                       'out_ucast_pkts': '117667977',
                                                                                       'poller_hash': 'QURUTjIzMTI0MUQxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:78:c0'],
                                                                                       'in_nucast_pkts': '14481',
                                                                                       'in_octets': '6742653477',
                                                                                       'in_ucast_pkts': '36837158',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '128934177076',
                                                                                       'out_ucast_pkts': '90637709',
                                                                                       'poller_hash': 'QURUTjIzMTI0RjNDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:77:70'],
                                                                                       'in_nucast_pkts': '14558',
                                                                                       'in_octets': '6938004105',
                                                                                       'in_ucast_pkts': '19551545',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '65772753626',
                                                                                       'out_ucast_pkts': '52111151',
                                                                                       'poller_hash': 'QURUTjIzMTI0REZDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:75:f0'],
                                                                                       'in_nucast_pkts': '14852',
                                                                                       'in_octets': '5085781923',
                                                                                       'in_ucast_pkts': '20757790',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1226',
                                                                                       'out_octets': '79970505613',
                                                                                       'out_ucast_pkts': '56820648',
                                                                                       'poller_hash': 'QURUTjIzMTI0RjMwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:91:b0'],
                                                                                       'in_nucast_pkts': '14483',
                                                                                       'in_octets': '14960213903',
                                                                                       'in_ucast_pkts': '38797550',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '104093424075',
                                                                                       'out_ucast_pkts': '86505373',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTQ2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4b:fa:80'],
                                                                                       'in_nucast_pkts': '74431',
                                                                                       'in_octets': '49201605747',
                                                                                       'in_ucast_pkts': '312371320',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2482',
                                                                                       'out_octets': '1167157019048',
                                                                                       'out_ucast_pkts': '818793600',
                                                                                       'poller_hash': 'QURUTjIzMTI0REI3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:6c:f0'],
                                                                                       'in_nucast_pkts': '74476',
                                                                                       'in_octets': '192252977689',
                                                                                       'in_ucast_pkts': '847205322',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2482',
                                                                                       'out_octets': '3450434962360',
                                                                                       'out_ucast_pkts': '2556552687',
                                                                                       'poller_hash': 'QURUTjIzMTI0OEE4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:08:f0'],
                                                                                       'in_nucast_pkts': '75663',
                                                                                       'in_octets': '28885852860',
                                                                                       'in_ucast_pkts': '160066746',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6406',
                                                                                       'out_octets': '570354592812',
                                                                                       'out_ucast_pkts': '405768101',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDlFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:00:60'],
                                                                                       'in_nucast_pkts': '77590',
                                                                                       'in_octets': '21008714935',
                                                                                       'in_ucast_pkts': '130418590',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6414',
                                                                                       'out_octets': '494392636187',
                                                                                       'out_ucast_pkts': '353071836',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTUwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:0b:a0'],
                                                                                       'in_nucast_pkts': '14475',
                                                                                       'in_octets': '5294014205',
                                                                                       'in_ucast_pkts': '24438441',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '92267892089',
                                                                                       'out_ucast_pkts': '68782014',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTFEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:77:60'],
                                                                                       'in_nucast_pkts': '77020',
                                                                                       'in_octets': '42963108958',
                                                                                       'in_ucast_pkts': '308691492',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6404',
                                                                                       'out_octets': '1383576104760',
                                                                                       'out_ucast_pkts': '949831788',
                                                                                       'poller_hash': 'QURUTjIzMTIzRUJDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:79:f0'],
                                                                                       'in_nucast_pkts': '14564',
                                                                                       'in_octets': '5936188625',
                                                                                       'in_ucast_pkts': '39928554',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '161793611585',
                                                                                       'out_ucast_pkts': '113854837',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTE2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4b:fa:60'],
                                                                                       'in_nucast_pkts': '75200',
                                                                                       'in_octets': '62366534715',
                                                                                       'in_ucast_pkts': '213576772',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2482',
                                                                                       'out_octets': '615271594261',
                                                                                       'out_ucast_pkts': '452854306',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTJGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:50:60'],
                                                                                       'in_nucast_pkts': '14604',
                                                                                       'in_octets': '7802515320',
                                                                                       'in_ucast_pkts': '26916176',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '154402388649',
                                                                                       'out_ucast_pkts': '116621269',
                                                                                       'poller_hash': 'QURUTjIzMTI1MEM4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:29:50'],
                                                                                       'in_nucast_pkts': '14477',
                                                                                       'in_octets': '10649180489',
                                                                                       'in_ucast_pkts': '104194724',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '319260136551',
                                                                                       'out_ucast_pkts': '217951826',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NzczIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:5b:70'],
                                                                                       'in_nucast_pkts': '14608',
                                                                                       'in_octets': '10170294001',
                                                                                       'in_ucast_pkts': '42209559',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '142833690444',
                                                                                       'out_ucast_pkts': '105137132',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NkMwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a8:40'],
                                                                                       'in_nucast_pkts': '14249',
                                                                                       'in_octets': '9238663898',
                                                                                       'in_ucast_pkts': '44807023',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '144197548729',
                                                                                       'out_ucast_pkts': '105308065',
                                                                                       'poller_hash': 'QURUTjIzMTQ0OTE2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:7e:b0'],
                                                                                       'in_nucast_pkts': '14837',
                                                                                       'in_octets': '2937545669',
                                                                                       'in_ucast_pkts': '17554396',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '88281793537',
                                                                                       'out_ucast_pkts': '62529827',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QjNBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:36:70'],
                                                                                       'in_nucast_pkts': '14481',
                                                                                       'in_octets': '4562146411',
                                                                                       'in_ucast_pkts': '11084217',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '27854038641',
                                                                                       'out_ucast_pkts': '22226636',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QzEwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:89:50'],
                                                                                       'in_nucast_pkts': '14852',
                                                                                       'in_octets': '13081311719',
                                                                                       'in_ucast_pkts': '67658493',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '320476692980',
                                                                                       'out_ucast_pkts': '237606249',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTJCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:b6:30'],
                                                                                       'in_nucast_pkts': '2312',
                                                                                       'in_octets': '298049450',
                                                                                       'in_ucast_pkts': '876509',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '78',
                                                                                       'out_octets': '2928972974',
                                                                                       'out_ucast_pkts': '2279665',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RUUwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:ad:d0'],
                                                                                       'in_nucast_pkts': '14254',
                                                                                       'in_octets': '28850937908',
                                                                                       'in_ucast_pkts': '35236369',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '76317764218',
                                                                                       'out_ucast_pkts': '61085997',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RUM4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:04:00'],
                                                                                       'in_nucast_pkts': '14249',
                                                                                       'in_octets': '4157814749',
                                                                                       'in_ucast_pkts': '19666598',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '60994460314',
                                                                                       'out_ucast_pkts': '44172062',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QzE3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:3d:30'],
                                                                                       'in_nucast_pkts': '14252',
                                                                                       'in_octets': '14656916626',
                                                                                       'in_ucast_pkts': '30525972',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '231750491985',
                                                                                       'out_ucast_pkts': '163367025',
                                                                                       'poller_hash': 'QURUTjIzMTI0NTEwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:3e:40'],
                                                                                       'in_nucast_pkts': '14253',
                                                                                       'in_octets': '6706964484',
                                                                                       'in_ucast_pkts': '58361129',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '283054358159',
                                                                                       'out_ucast_pkts': '193514948',
                                                                                       'poller_hash': 'QURUTjI0MzE0NzY2IHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/1',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8x',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/1',
                                                                                      'id': 'xgspon '
                                                                                            '0/1',
                                                                                      'links': [       {       'connected_time': '427025',
                                                                                                               'fiber_length': 1926,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDQxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427026',
                                                                                                               'fiber_length': 1969,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MEIwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427026',
                                                                                                               'fiber_length': 1780,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REQ5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427020',
                                                                                                               'fiber_length': 2471,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MUQxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427025',
                                                                                                               'fiber_length': 1807,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RjNDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427030',
                                                                                                               'fiber_length': 1986,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REZDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -12.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427027',
                                                                                                               'fiber_length': 2396,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RjMwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427026',
                                                                                                               'fiber_length': 2088,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTQ2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '2232581',
                                                                                                               'fiber_length': 2058,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REI3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '2232583',
                                                                                                               'fiber_length': 2069,
                                                                                                               'poller_hash': 'QURUTjIzMTI0OEE4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '2232581',
                                                                                                               'fiber_length': 2313,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDlFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '2232581',
                                                                                                               'fiber_length': 2008,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTUwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427024',
                                                                                                               'fiber_length': 540,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTFEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '2232583',
                                                                                                               'fiber_length': 2230,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRUJDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427020',
                                                                                                               'fiber_length': 1746,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTE2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '2232581',
                                                                                                               'fiber_length': 1857,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTJGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427030',
                                                                                                               'fiber_length': 1996,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MEM4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427024',
                                                                                                               'fiber_length': 233,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NzczIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427032',
                                                                                                               'fiber_length': 1780,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NkMwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -12.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427029',
                                                                                                               'fiber_length': 2012,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0OTE2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427032',
                                                                                                               'fiber_length': 545,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QjNBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427028',
                                                                                                               'fiber_length': 1734,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QzEwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427023',
                                                                                                               'fiber_length': 324,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTJCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '68896',
                                                                                                               'fiber_length': 700,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RUUwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427028',
                                                                                                               'fiber_length': 489,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RUM4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427028',
                                                                                                               'fiber_length': 716,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QzE3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427030',
                                                                                                               'fiber_length': 313,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NTEwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -12.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825},
                                                                                                       {       'connected_time': '427035',
                                                                                                               'fiber_length': 859,
                                                                                                               'poller_hash': 'QURUTjI0MzE0NzY2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2825}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/1',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8x',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/10',
                                                              'links': [       {       'bridged_mac_addresses': [       '38:f8:f6:52:af:10'],
                                                                                       'in_nucast_pkts': '14605',
                                                                                       'in_octets': '4074282793',
                                                                                       'in_ucast_pkts': '9703049',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '42205526052',
                                                                                       'out_ucast_pkts': '33256315',
                                                                                       'poller_hash': 'QURUTjIzMTI0RjJEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:79:10'],
                                                                                       'in_nucast_pkts': '14833',
                                                                                       'in_octets': '18005021720',
                                                                                       'in_ucast_pkts': '32996865',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '130581815576',
                                                                                       'out_ucast_pkts': '99475924',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDI2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:68:90'],
                                                                                       'in_nucast_pkts': '14478',
                                                                                       'in_octets': '6509985184',
                                                                                       'in_ucast_pkts': '10001038',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '23997518580',
                                                                                       'out_ucast_pkts': '17479618',
                                                                                       'poller_hash': 'QURUTjIzMTIzRjU3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8b:b0'],
                                                                                       'in_nucast_pkts': '14842',
                                                                                       'in_octets': '17964625070',
                                                                                       'in_ucast_pkts': '72846985',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '261600566960',
                                                                                       'out_ucast_pkts': '192987362',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDg4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:6b:c0'],
                                                                                       'in_nucast_pkts': '14478',
                                                                                       'in_octets': '4192434431',
                                                                                       'in_ucast_pkts': '9735185',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '27110650859',
                                                                                       'out_ucast_pkts': '23016861',
                                                                                       'poller_hash': 'QURUTjIzMTI0RjE0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:89:00'],
                                                                                       'in_nucast_pkts': '14836',
                                                                                       'in_octets': '11623302477',
                                                                                       'in_ucast_pkts': '42961367',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '90157267496',
                                                                                       'out_ucast_pkts': '71266091',
                                                                                       'poller_hash': 'QURUTjIzMTI0RjM3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:65:60'],
                                                                                       'in_nucast_pkts': '14481',
                                                                                       'in_octets': '32821474532',
                                                                                       'in_ucast_pkts': '51829091',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '185633626970',
                                                                                       'out_ucast_pkts': '144377013',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTYxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:48:80'],
                                                                                       'in_nucast_pkts': '28745',
                                                                                       'in_octets': '27617544835',
                                                                                       'in_ucast_pkts': '103034840',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '959',
                                                                                       'out_octets': '424807630451',
                                                                                       'out_ucast_pkts': '301205551',
                                                                                       'poller_hash': 'QURUTjIzMTI0REEwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:02:b0'],
                                                                                       'in_nucast_pkts': '14482',
                                                                                       'in_octets': '2081111609',
                                                                                       'in_ucast_pkts': '9893508',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '35193394551',
                                                                                       'out_ucast_pkts': '26825096',
                                                                                       'poller_hash': 'QURUTjIzMTI1MEZFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:09:70'],
                                                                                       'in_nucast_pkts': '29438',
                                                                                       'in_octets': '14131521633',
                                                                                       'in_ucast_pkts': '62966197',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2478',
                                                                                       'out_octets': '288886403265',
                                                                                       'out_ucast_pkts': '207388734',
                                                                                       'poller_hash': 'QURUTjIzMTI1MEMwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:08:40'],
                                                                                       'in_nucast_pkts': '29210',
                                                                                       'in_octets': '13692612528',
                                                                                       'in_ucast_pkts': '90428390',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2472',
                                                                                       'out_octets': '327230078932',
                                                                                       'out_ucast_pkts': '230788998',
                                                                                       'poller_hash': 'QURUTjIzMTI1MEJGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:65:70'],
                                                                                       'in_nucast_pkts': '14483',
                                                                                       'in_octets': '5950362229',
                                                                                       'in_ucast_pkts': '25236495',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '130148994270',
                                                                                       'out_ucast_pkts': '93649767',
                                                                                       'poller_hash': 'QURUTjIzMTIzRUMwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:65:d0'],
                                                                                       'in_nucast_pkts': '29209',
                                                                                       'in_octets': '8844157372',
                                                                                       'in_ucast_pkts': '21227697',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2472',
                                                                                       'out_octets': '45819930297',
                                                                                       'out_ucast_pkts': '43332910',
                                                                                       'poller_hash': 'QURUTjIzMTIzRkVFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:b1:50'],
                                                                                       'in_nucast_pkts': '112182',
                                                                                       'in_octets': '65293876011',
                                                                                       'in_ucast_pkts': '244388608',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3741',
                                                                                       'out_octets': '1379640415195',
                                                                                       'out_ucast_pkts': '1013050052',
                                                                                       'poller_hash': 'QURUTjIzMTIzRkU5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:f5:40'],
                                                                                       'in_nucast_pkts': '111982',
                                                                                       'in_octets': '55559806667',
                                                                                       'in_ucast_pkts': '326687744',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3734',
                                                                                       'out_octets': '1471543734583',
                                                                                       'out_ucast_pkts': '1139963640',
                                                                                       'poller_hash': 'QURUTjIzMTI1MEQxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:89:30'],
                                                                                       'in_nucast_pkts': '14514',
                                                                                       'in_octets': '44117505825',
                                                                                       'in_ucast_pkts': '140548890',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1228',
                                                                                       'out_octets': '355477843613',
                                                                                       'out_ucast_pkts': '268863394',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NkNFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:37:10'],
                                                                                       'in_nucast_pkts': '29225',
                                                                                       'in_octets': '11170979770',
                                                                                       'in_ucast_pkts': '40121588',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2474',
                                                                                       'out_octets': '333470491980',
                                                                                       'out_ucast_pkts': '231950841',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RERGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:0c:40'],
                                                                                       'in_nucast_pkts': '14837',
                                                                                       'in_octets': '6618612021',
                                                                                       'in_ucast_pkts': '22102834',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '60367612439',
                                                                                       'out_ucast_pkts': '49153075',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RDUwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:3c:20'],
                                                                                       'in_nucast_pkts': '14491',
                                                                                       'in_octets': '5945748995',
                                                                                       'in_ucast_pkts': '38403602',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '211846856617',
                                                                                       'out_ucast_pkts': '151900586',
                                                                                       'poller_hash': 'QURUTjIzMTI0QzczIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:39:50'],
                                                                                       'in_nucast_pkts': '22894',
                                                                                       'in_octets': '34295336756',
                                                                                       'in_ucast_pkts': '69203173',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '755',
                                                                                       'out_octets': '137053450797',
                                                                                       'out_ucast_pkts': '137839818',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RURGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:97:70'],
                                                                                       'in_nucast_pkts': '14481',
                                                                                       'in_octets': '5086119669',
                                                                                       'in_ucast_pkts': '22447222',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '99081591641',
                                                                                       'out_ucast_pkts': '78561562',
                                                                                       'poller_hash': 'QURUTjIzMTQ0MjhBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:ae:70'],
                                                                                       'in_nucast_pkts': '113720',
                                                                                       'in_octets': '50182795525',
                                                                                       'in_ucast_pkts': '367529678',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3738',
                                                                                       'out_octets': '1355404021797',
                                                                                       'out_ucast_pkts': '954516758',
                                                                                       'poller_hash': 'QURUTjIzMTI0MUEyIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:9b:50'],
                                                                                       'in_nucast_pkts': '14609',
                                                                                       'in_octets': '55959688032',
                                                                                       'in_ucast_pkts': '63282989',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '134362196864',
                                                                                       'out_ucast_pkts': '112053823',
                                                                                       'poller_hash': 'QURUTjI0NDkxN0E0IHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/10',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8xMA==',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/10',
                                                                                      'id': 'xgspon '
                                                                                            '0/10',
                                                                                      'links': [       {       'connected_time': '427032',
                                                                                                               'fiber_length': 4645,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RjJEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '427032',
                                                                                                               'fiber_length': 4747,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDI2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '427033',
                                                                                                               'fiber_length': 4661,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRjU3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '427032',
                                                                                                               'fiber_length': 4852,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDg4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '427033',
                                                                                                               'fiber_length': 7344,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RjE0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '427029',
                                                                                                               'fiber_length': 7364,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RjM3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '427032',
                                                                                                               'fiber_length': 5086,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTYxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '861783',
                                                                                                               'fiber_length': 8008,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REEwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '427029',
                                                                                                               'fiber_length': 4938,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MEZFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '861787',
                                                                                                               'fiber_length': 8251,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MEMwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '861785',
                                                                                                               'fiber_length': 8000,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MEJGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '427029',
                                                                                                               'fiber_length': 4770,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRUMwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '861785',
                                                                                                               'fiber_length': 8343,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRkVFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '3364579',
                                                                                                               'fiber_length': 8068,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRkU5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '3364578',
                                                                                                               'fiber_length': 8127,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MEQxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '427031',
                                                                                                               'fiber_length': 7294,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NkNFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '861787',
                                                                                                               'fiber_length': 8094,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RERGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '427031',
                                                                                                               'fiber_length': 7706,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RDUwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '427029',
                                                                                                               'fiber_length': 4666,
                                                                                                               'poller_hash': 'QURUTjIzMTI0QzczIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '677935',
                                                                                                               'fiber_length': 8136,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RURGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '427031',
                                                                                                               'fiber_length': 7421,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0MjhBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '3364576',
                                                                                                               'fiber_length': 8116,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MUEyIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649},
                                                                                                       {       'connected_time': '427036',
                                                                                                               'fiber_length': 4703,
                                                                                                               'poller_hash': 'QURUTjI0NDkxN0E0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.649}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/10',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8xMA==',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/11',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:dd:78:e0'],
                                                                                       'in_nucast_pkts': '14481',
                                                                                       'in_octets': '12010142280',
                                                                                       'in_ucast_pkts': '40833955',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '139273338352',
                                                                                       'out_ucast_pkts': '125281266',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTY2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:75:70'],
                                                                                       'in_nucast_pkts': '10918',
                                                                                       'in_octets': '4909755664',
                                                                                       'in_ucast_pkts': '21306651',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '71098510942',
                                                                                       'out_ucast_pkts': '52730022',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTkwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8a:40'],
                                                                                       'in_nucast_pkts': '14484',
                                                                                       'in_octets': '5087837331',
                                                                                       'in_ucast_pkts': '20715264',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '144634995117',
                                                                                       'out_ucast_pkts': '106640068',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTQwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:7c:f0'],
                                                                                       'in_nucast_pkts': '14840',
                                                                                       'in_octets': '2117419990',
                                                                                       'in_ucast_pkts': '16432791',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '76155224064',
                                                                                       'out_ucast_pkts': '54375468',
                                                                                       'poller_hash': 'QURUTjIzMTI0RUQ5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:70:a0'],
                                                                                       'in_nucast_pkts': '181493',
                                                                                       'in_octets': '260250861320',
                                                                                       'in_ucast_pkts': '725172539',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15373',
                                                                                       'out_octets': '2021601751723',
                                                                                       'out_ucast_pkts': '1766925366',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTNFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:56:40'],
                                                                                       'in_nucast_pkts': '11095',
                                                                                       'in_octets': '14171450420',
                                                                                       'in_ucast_pkts': '40353367',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '938',
                                                                                       'out_octets': '202237039839',
                                                                                       'out_ucast_pkts': '154765636',
                                                                                       'poller_hash': 'QURUTjIzMTI1MUVCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:76:40'],
                                                                                       'in_nucast_pkts': '11096',
                                                                                       'in_octets': '3889093495',
                                                                                       'in_ucast_pkts': '10543113',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '938',
                                                                                       'out_octets': '36279580423',
                                                                                       'out_ucast_pkts': '30627633',
                                                                                       'poller_hash': 'QURUTjIzMTI0REU0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:7e:00'],
                                                                                       'in_nucast_pkts': '14481',
                                                                                       'in_octets': '69004973439',
                                                                                       'in_ucast_pkts': '106561031',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '235491527014',
                                                                                       'out_ucast_pkts': '189025158',
                                                                                       'poller_hash': 'QURUTjIzMTI0REIwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ac:20'],
                                                                                       'in_nucast_pkts': '14254',
                                                                                       'in_octets': '5606187983',
                                                                                       'in_ucast_pkts': '27182948',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '242397156682',
                                                                                       'out_ucast_pkts': '177117374',
                                                                                       'poller_hash': 'QURUTjIzMTI0RjM0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ab:30'],
                                                                                       'in_nucast_pkts': '11191',
                                                                                       'in_octets': '9781526284',
                                                                                       'in_ucast_pkts': '24332014',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '119157782184',
                                                                                       'out_ucast_pkts': '89684982',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTU3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ac:e0'],
                                                                                       'in_nucast_pkts': '14251',
                                                                                       'in_octets': '17584067874',
                                                                                       'in_ucast_pkts': '26547393',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '99416976968',
                                                                                       'out_ucast_pkts': '77910131',
                                                                                       'poller_hash': 'QURUTjIzMTIzRUI3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:6e:40'],
                                                                                       'in_nucast_pkts': '14833',
                                                                                       'in_octets': '4278648759',
                                                                                       'in_ucast_pkts': '28535445',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '173726757260',
                                                                                       'out_ucast_pkts': '120494076',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTM3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8f:b0'],
                                                                                       'in_nucast_pkts': '14728',
                                                                                       'in_octets': '24093737952',
                                                                                       'in_ucast_pkts': '106219013',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1223',
                                                                                       'out_octets': '404520882600',
                                                                                       'out_ucast_pkts': '288398654',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTRCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:52:10'],
                                                                                       'in_nucast_pkts': '10919',
                                                                                       'in_octets': '7054881425',
                                                                                       'in_ucast_pkts': '20904973',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '139917712727',
                                                                                       'out_ucast_pkts': '99189673',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTczIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:7d:70'],
                                                                                       'in_nucast_pkts': '14483',
                                                                                       'in_octets': '6218284263',
                                                                                       'in_ucast_pkts': '24698100',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '92812486069',
                                                                                       'out_ucast_pkts': '66531067',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTE3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:6c:b0'],
                                                                                       'in_nucast_pkts': '14837',
                                                                                       'in_octets': '8526432020',
                                                                                       'in_ucast_pkts': '61587656',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '260945147663',
                                                                                       'out_ucast_pkts': '182878707',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTJDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:77:30'],
                                                                                       'in_nucast_pkts': '14479',
                                                                                       'in_octets': '3965871616',
                                                                                       'in_ucast_pkts': '17863515',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '83823481543',
                                                                                       'out_ucast_pkts': '61501151',
                                                                                       'poller_hash': 'QURUTjIzMTIzRUExIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:76:40'],
                                                                                       'in_nucast_pkts': '14480',
                                                                                       'in_octets': '31320035261',
                                                                                       'in_ucast_pkts': '78000070',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '276529278879',
                                                                                       'out_ucast_pkts': '201540243',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTMzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:a3:c0'],
                                                                                       'in_nucast_pkts': '14258',
                                                                                       'in_octets': '37144367397',
                                                                                       'in_ucast_pkts': '86633184',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '319146165890',
                                                                                       'out_ucast_pkts': '229692615',
                                                                                       'poller_hash': 'QURUTjIzMTI1MUFCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:0b:60'],
                                                                                       'in_nucast_pkts': '11367',
                                                                                       'in_octets': '27663153',
                                                                                       'in_ucast_pkts': '90402',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '938',
                                                                                       'out_octets': '18021876',
                                                                                       'out_ucast_pkts': '72331',
                                                                                       'poller_hash': 'QURUTjIzMTI0MzA0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:87:b0'],
                                                                                       'in_nucast_pkts': '14252',
                                                                                       'in_octets': '4570785449',
                                                                                       'in_ucast_pkts': '6288909',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '9000467123',
                                                                                       'out_ucast_pkts': '8758129',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTRDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:89:60'],
                                                                                       'in_nucast_pkts': '14483',
                                                                                       'in_octets': '4288421826',
                                                                                       'in_ucast_pkts': '45952539',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '140797273463',
                                                                                       'out_ucast_pkts': '94877340',
                                                                                       'poller_hash': 'QURUTjIzMTIzRkM0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:77:10'],
                                                                                       'in_nucast_pkts': '14484',
                                                                                       'in_octets': '3321663322',
                                                                                       'in_ucast_pkts': '3122814',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '3289045895',
                                                                                       'out_ucast_pkts': '3279753',
                                                                                       'poller_hash': 'QURUTjIzMTI1MEMzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:58:40'],
                                                                                       'in_nucast_pkts': '179971',
                                                                                       'in_octets': '121539742062',
                                                                                       'in_ucast_pkts': '283895598',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5954',
                                                                                       'out_octets': '946344226230',
                                                                                       'out_ucast_pkts': '722438556',
                                                                                       'poller_hash': 'QURUTjIzMTQ0N0E1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8a:80'],
                                                                                       'in_nucast_pkts': '14482',
                                                                                       'in_octets': '1923211696',
                                                                                       'in_ucast_pkts': '8016011',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '22878018917',
                                                                                       'out_ucast_pkts': '17994918',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NzdBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:0a:00'],
                                                                                       'in_nucast_pkts': '31123',
                                                                                       'in_octets': '29998733749',
                                                                                       'in_ucast_pkts': '30479439',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2633',
                                                                                       'out_octets': '15272543552',
                                                                                       'out_ucast_pkts': '17448007',
                                                                                       'poller_hash': 'QURUTjIzMTQ0ODBEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:b3:a0'],
                                                                                       'in_nucast_pkts': '14483',
                                                                                       'in_octets': '13072353988',
                                                                                       'in_ucast_pkts': '27611640',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '159270900949',
                                                                                       'out_ucast_pkts': '113977534',
                                                                                       'poller_hash': 'QURUTjIzMTQ0N0FCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:89:30'],
                                                                                       'in_nucast_pkts': '14812',
                                                                                       'in_octets': '140478805070',
                                                                                       'in_ucast_pkts': '206090775',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '509510772101',
                                                                                       'out_ucast_pkts': '407999782',
                                                                                       'poller_hash': 'QURUTjIzMTQ0N0YzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:7b:50'],
                                                                                       'in_nucast_pkts': '14548',
                                                                                       'in_octets': '16103184483',
                                                                                       'in_ucast_pkts': '24497332',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '475',
                                                                                       'out_octets': '49677874682',
                                                                                       'out_ucast_pkts': '44710176',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RUQyIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:42:00'],
                                                                                       'in_nucast_pkts': '10918',
                                                                                       'in_octets': '4741021242',
                                                                                       'in_ucast_pkts': '40561298',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '113233366598',
                                                                                       'out_ucast_pkts': '79471298',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDZDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:6a:d0'],
                                                                                       'in_nucast_pkts': '14257',
                                                                                       'in_octets': '3901163862',
                                                                                       'in_ucast_pkts': '12196554',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '16966615768',
                                                                                       'out_ucast_pkts': '12577131',
                                                                                       'poller_hash': 'QURUTjI0MzYzRDREIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:aa:e1'],
                                                                                       'in_nucast_pkts': '258',
                                                                                       'in_octets': '9643762835',
                                                                                       'in_ucast_pkts': '55490510',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '203171251388',
                                                                                       'out_ucast_pkts': '150409881',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QjIwIHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/11',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8xMQ==',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/11',
                                                                                      'id': 'xgspon '
                                                                                            '0/11',
                                                                                      'links': [       {       'connected_time': '427028',
                                                                                                               'fiber_length': 5195,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTY2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '327028',
                                                                                                               'fiber_length': 6895,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTkwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427029',
                                                                                                               'fiber_length': 5726,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTQwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427030',
                                                                                                               'fiber_length': 5679,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RUQ5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '5355592',
                                                                                                               'fiber_length': 5805,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTNFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '327027',
                                                                                                               'fiber_length': 6685,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MUVCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '327029',
                                                                                                               'fiber_length': 6822,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REU0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427027',
                                                                                                               'fiber_length': 5405,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REIwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427030',
                                                                                                               'fiber_length': 5229,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RjM0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '327028',
                                                                                                               'fiber_length': 6531,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTU3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427033',
                                                                                                               'fiber_length': 3552,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRUI3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427029',
                                                                                                               'fiber_length': 5276,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTM3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427025',
                                                                                                               'fiber_length': 5187,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTRCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '327028',
                                                                                                               'fiber_length': 4886,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTczIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427031',
                                                                                                               'fiber_length': 4322,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTE3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427030',
                                                                                                               'fiber_length': 5460,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTJDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427032',
                                                                                                               'fiber_length': 3586,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRUExIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427029',
                                                                                                               'fiber_length': 3613,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTMzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427029',
                                                                                                               'fiber_length': 5452,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MUFCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '327029',
                                                                                                               'fiber_length': 4895,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MzA0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427029',
                                                                                                               'fiber_length': 5052,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTRDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427031',
                                                                                                               'fiber_length': 3515,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRkM0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427034',
                                                                                                               'fiber_length': 3450,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MEMzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '5355590',
                                                                                                               'fiber_length': 4061,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0N0E1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427029',
                                                                                                               'fiber_length': 3993,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NzdBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '918509',
                                                                                                               'fiber_length': 4007,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0ODBEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427028',
                                                                                                               'fiber_length': 4238,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0N0FCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427034',
                                                                                                               'fiber_length': 4128,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0N0YzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '423780',
                                                                                                               'fiber_length': 4439,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RUQyIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '327028',
                                                                                                               'fiber_length': 6899,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDZDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427039',
                                                                                                               'fiber_length': 3928,
                                                                                                               'poller_hash': 'QURUTjI0MzYzRDREIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868},
                                                                                                       {       'connected_time': '427033',
                                                                                                               'fiber_length': 5562,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QjIwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4868}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/11',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8xMQ==',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/12',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:dd:84:00'],
                                                                                       'in_nucast_pkts': '11367',
                                                                                       'in_octets': '15767760415',
                                                                                       'in_ucast_pkts': '30683773',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '938',
                                                                                       'out_octets': '73447962648',
                                                                                       'out_ucast_pkts': '60143172',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTcxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:6e:f0'],
                                                                                       'in_nucast_pkts': '11367',
                                                                                       'in_octets': '4050843218',
                                                                                       'in_ucast_pkts': '22475505',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '938',
                                                                                       'out_octets': '148833022375',
                                                                                       'out_ucast_pkts': '104104029',
                                                                                       'poller_hash': 'QURUTjIzMTI0RERBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8e:50'],
                                                                                       'in_nucast_pkts': '11367',
                                                                                       'in_octets': '4949456657',
                                                                                       'in_ucast_pkts': '16426571',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '938',
                                                                                       'out_octets': '72751942766',
                                                                                       'out_ucast_pkts': '56652163',
                                                                                       'poller_hash': 'QURUTjIzMTI0REUwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ac:b0'],
                                                                                       'in_nucast_pkts': '10922',
                                                                                       'in_octets': '12769370752',
                                                                                       'in_ucast_pkts': '61778045',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '284107873798',
                                                                                       'out_ucast_pkts': '200982987',
                                                                                       'poller_hash': 'QURUTjIzMTI0REY2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:01:50'],
                                                                                       'in_nucast_pkts': '10920',
                                                                                       'in_octets': '437383688',
                                                                                       'in_ucast_pkts': '893267',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '308702946',
                                                                                       'out_ucast_pkts': '570377',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTA0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:79:70'],
                                                                                       'in_nucast_pkts': '11093',
                                                                                       'in_octets': '7916900498',
                                                                                       'in_ucast_pkts': '19430276',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '938',
                                                                                       'out_octets': '39267826124',
                                                                                       'out_ucast_pkts': '33836502',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTMwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a6:80'],
                                                                                       'in_nucast_pkts': '10993',
                                                                                       'in_octets': '11999564548',
                                                                                       'in_ucast_pkts': '69806944',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '352265173015',
                                                                                       'out_ucast_pkts': '253140500',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTkyIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:6d:50'],
                                                                                       'in_nucast_pkts': '11091',
                                                                                       'in_octets': '1957758834',
                                                                                       'in_ucast_pkts': '11873930',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '938',
                                                                                       'out_octets': '46479498752',
                                                                                       'out_ucast_pkts': '34686590',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTg2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:81:b0'],
                                                                                       'in_nucast_pkts': '10921',
                                                                                       'in_octets': '24621439854',
                                                                                       'in_ucast_pkts': '47282680',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '279360494658',
                                                                                       'out_ucast_pkts': '197894118',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTk0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8a:e0'],
                                                                                       'in_nucast_pkts': '11355',
                                                                                       'in_octets': '2030971762',
                                                                                       'in_ucast_pkts': '8552994',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '938',
                                                                                       'out_octets': '39794992093',
                                                                                       'out_ucast_pkts': '27978558',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTRFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a8:00'],
                                                                                       'in_nucast_pkts': '11192',
                                                                                       'in_octets': '15555701442',
                                                                                       'in_ucast_pkts': '37628460',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '212251197099',
                                                                                       'out_ucast_pkts': '163182738',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NkI4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:6a:80'],
                                                                                       'in_nucast_pkts': '181534',
                                                                                       'in_octets': '150318711426',
                                                                                       'in_ucast_pkts': '604576406',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15379',
                                                                                       'out_octets': '2125424430048',
                                                                                       'out_ucast_pkts': '1580422205',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NkNCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:9a:d0'],
                                                                                       'in_nucast_pkts': '178542',
                                                                                       'in_octets': '141812945571',
                                                                                       'in_ucast_pkts': '1004023051',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5952',
                                                                                       'out_octets': '4783940559298',
                                                                                       'out_ucast_pkts': '3415646167',
                                                                                       'poller_hash': 'QURUTjIzMTQ0ODYxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:6e:b0'],
                                                                                       'in_nucast_pkts': '11193',
                                                                                       'in_octets': '2614312908',
                                                                                       'in_ucast_pkts': '17215659',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '65148013224',
                                                                                       'out_ucast_pkts': '46404667',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTE1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:55:80'],
                                                                                       'in_nucast_pkts': '10920',
                                                                                       'in_octets': '5696191608',
                                                                                       'in_ucast_pkts': '11625565',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '57625493901',
                                                                                       'out_ucast_pkts': '41738950',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QkY3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:02:90'],
                                                                                       'in_nucast_pkts': '11192',
                                                                                       'in_octets': '1012604589',
                                                                                       'in_ucast_pkts': '4080931',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '10986661054',
                                                                                       'out_ucast_pkts': '8636314',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTVCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:62:10'],
                                                                                       'in_nucast_pkts': '14253',
                                                                                       'in_octets': '5439487007',
                                                                                       'in_ucast_pkts': '7838907',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '22414068884',
                                                                                       'out_ucast_pkts': '19152768',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QzhCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:b6:c0'],
                                                                                       'in_nucast_pkts': '10923',
                                                                                       'in_octets': '2414262555',
                                                                                       'in_ucast_pkts': '8667815',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '45045431911',
                                                                                       'out_ucast_pkts': '32186109',
                                                                                       'poller_hash': 'QURUTjI0MzYzQkJBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:81:80'],
                                                                                       'in_nucast_pkts': '11097',
                                                                                       'in_octets': '1764676337',
                                                                                       'in_ucast_pkts': '7642458',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '938',
                                                                                       'out_octets': '19920110767',
                                                                                       'out_ucast_pkts': '16158235',
                                                                                       'poller_hash': 'QURUTjI0MzE0MUFDIHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/12',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8xMg==',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/12',
                                                                                      'id': 'xgspon '
                                                                                            '0/12',
                                                                                      'links': [       {       'connected_time': '327025',
                                                                                                               'fiber_length': 8742,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTcxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.411},
                                                                                                       {       'connected_time': '327029',
                                                                                                               'fiber_length': 8706,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RERBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.411},
                                                                                                       {       'connected_time': '327027',
                                                                                                               'fiber_length': 8348,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REUwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.411},
                                                                                                       {       'connected_time': '327030',
                                                                                                               'fiber_length': 8325,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REY2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.411},
                                                                                                       {       'connected_time': '327029',
                                                                                                               'fiber_length': 8705,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTA0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.411},
                                                                                                       {       'connected_time': '327026',
                                                                                                               'fiber_length': 8651,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTMwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.411},
                                                                                                       {       'connected_time': '327029',
                                                                                                               'fiber_length': 8747,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTkyIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.411},
                                                                                                       {       'connected_time': '327029',
                                                                                                               'fiber_length': 8737,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTg2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.411},
                                                                                                       {       'connected_time': '327022',
                                                                                                               'fiber_length': 9481,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTk0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.411},
                                                                                                       {       'connected_time': '327028',
                                                                                                               'fiber_length': 8614,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTRFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.411},
                                                                                                       {       'connected_time': '327027',
                                                                                                               'fiber_length': 9457,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NkI4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.411},
                                                                                                       {       'connected_time': '5355622',
                                                                                                               'fiber_length': 8828,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NkNCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.411},
                                                                                                       {       'connected_time': '5355621',
                                                                                                               'fiber_length': 8370,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0ODYxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.411},
                                                                                                       {       'connected_time': '327025',
                                                                                                               'fiber_length': 7986,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTE1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.411},
                                                                                                       {       'connected_time': '327028',
                                                                                                               'fiber_length': 8538,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QkY3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.411},
                                                                                                       {       'connected_time': '327029',
                                                                                                               'fiber_length': 8775,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTVCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.411},
                                                                                                       {       'connected_time': '427035',
                                                                                                               'fiber_length': 8911,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QzhCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.411},
                                                                                                       {       'connected_time': '327033',
                                                                                                               'fiber_length': 8469,
                                                                                                               'poller_hash': 'QURUTjI0MzYzQkJBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.411},
                                                                                                       {       'connected_time': '327033',
                                                                                                               'fiber_length': 9546,
                                                                                                               'poller_hash': 'QURUTjI0MzE0MUFDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.411}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/12',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8xMg==',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/13',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:d6:0a:70'],
                                                                                       'in_nucast_pkts': '11095',
                                                                                       'in_octets': '11364743835',
                                                                                       'in_ucast_pkts': '80052462',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '938',
                                                                                       'out_octets': '384501951861',
                                                                                       'out_ucast_pkts': '263215609',
                                                                                       'poller_hash': 'QURUTjIzMTI0MzJFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:07:e0'],
                                                                                       'in_nucast_pkts': '14480',
                                                                                       'in_octets': '5893619517',
                                                                                       'in_ucast_pkts': '50997649',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '125013412365',
                                                                                       'out_ucast_pkts': '93707406',
                                                                                       'poller_hash': 'QURUTjIzMTI0ODQ5IHBlZXJpbnRm'},
                                                                               {       'in_nucast_pkts': '302422',
                                                                                       'in_octets': '93074964',
                                                                                       'in_ucast_pkts': '0',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '0',
                                                                                       'out_ucast_pkts': '0',
                                                                                       'poller_hash': 'QURUTjIzMTI1MEM2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:03:f0'],
                                                                                       'in_nucast_pkts': '10925',
                                                                                       'in_octets': '11584582976',
                                                                                       'in_ucast_pkts': '36155516',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '97260334575',
                                                                                       'out_ucast_pkts': '74915668',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTVBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:38:f0'],
                                                                                       'in_nucast_pkts': '10500',
                                                                                       'in_octets': '4315964990',
                                                                                       'in_ucast_pkts': '17363552',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '867',
                                                                                       'out_octets': '57026256345',
                                                                                       'out_ucast_pkts': '42378102',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTUzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:34:50'],
                                                                                       'in_nucast_pkts': '11100',
                                                                                       'in_octets': '6681485962',
                                                                                       'in_ucast_pkts': '42967152',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '938',
                                                                                       'out_octets': '249261259637',
                                                                                       'out_ucast_pkts': '170364556',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTg0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:00:f0'],
                                                                                       'in_nucast_pkts': '10921',
                                                                                       'in_octets': '3043675623',
                                                                                       'in_ucast_pkts': '9936676',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '45570325495',
                                                                                       'out_ucast_pkts': '33509700',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTVDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:3f:10'],
                                                                                       'in_nucast_pkts': '14252',
                                                                                       'in_octets': '4816574218',
                                                                                       'in_ucast_pkts': '16714166',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '68442769578',
                                                                                       'out_ucast_pkts': '48338264',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RDk5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:63:f0'],
                                                                                       'in_nucast_pkts': '10920',
                                                                                       'in_octets': '6155899121',
                                                                                       'in_ucast_pkts': '13805941',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '85065250252',
                                                                                       'out_ucast_pkts': '62297141',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QjNGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:31:10'],
                                                                                       'in_nucast_pkts': '10923',
                                                                                       'in_octets': '11113504970',
                                                                                       'in_ucast_pkts': '38851489',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '178322644314',
                                                                                       'out_ucast_pkts': '125756425',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QjVFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:21:80'],
                                                                                       'in_nucast_pkts': '10921',
                                                                                       'in_octets': '4787032931',
                                                                                       'in_ucast_pkts': '23749412',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '140274218693',
                                                                                       'out_ucast_pkts': '107161210',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTlCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a1:70'],
                                                                                       'in_nucast_pkts': '10953',
                                                                                       'in_octets': '4102645831',
                                                                                       'in_ucast_pkts': '13734254',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '366',
                                                                                       'out_octets': '72279718107',
                                                                                       'out_ucast_pkts': '55541440',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QUNGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ac:30'],
                                                                                       'in_nucast_pkts': '14277',
                                                                                       'in_octets': '54397660066',
                                                                                       'in_ucast_pkts': '56952448',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '477',
                                                                                       'out_octets': '62495928412',
                                                                                       'out_ucast_pkts': '52136476',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDM3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:ef:c0'],
                                                                                       'in_nucast_pkts': '10920',
                                                                                       'in_octets': '3578492675',
                                                                                       'in_ucast_pkts': '10367495',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '53634846440',
                                                                                       'out_ucast_pkts': '38760531',
                                                                                       'poller_hash': 'QURUTjIzMTI0QjdFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:37:30'],
                                                                                       'in_nucast_pkts': '10920',
                                                                                       'in_octets': '12111820901',
                                                                                       'in_ucast_pkts': '34746453',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '138901108970',
                                                                                       'out_ucast_pkts': '106039018',
                                                                                       'poller_hash': 'QURUTjIzMTI0OTY2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:b1:30'],
                                                                                       'in_nucast_pkts': '10921',
                                                                                       'in_octets': '5131827869',
                                                                                       'in_ucast_pkts': '7642544',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '365',
                                                                                       'out_octets': '31461333787',
                                                                                       'out_ucast_pkts': '24629401',
                                                                                       'poller_hash': 'QURUTjI0MzYzREI5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:ba:f0'],
                                                                                       'in_nucast_pkts': '5293',
                                                                                       'in_octets': '12671935772',
                                                                                       'in_ucast_pkts': '40421903',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '174',
                                                                                       'out_octets': '126488221476',
                                                                                       'out_ucast_pkts': '96314100',
                                                                                       'poller_hash': 'QURUTjI1MTUyMUEyIHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/13',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8xMw==',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/13',
                                                                                      'id': 'xgspon '
                                                                                            '0/13',
                                                                                      'links': [       {       'connected_time': '327030',
                                                                                                               'fiber_length': 9068,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MzJFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5666},
                                                                                                       {       'connected_time': '427035',
                                                                                                               'fiber_length': 9154,
                                                                                                               'poller_hash': 'QURUTjIzMTI0ODQ5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5666},
                                                                                                       {       'connected_time': '327029',
                                                                                                               'fiber_length': 9038,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MEM2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5666},
                                                                                                       {       'connected_time': '327027',
                                                                                                               'fiber_length': 9303,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTVBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5666},
                                                                                                       {       'connected_time': '302045',
                                                                                                               'fiber_length': 9292,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTUzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5666},
                                                                                                       {       'connected_time': '327028',
                                                                                                               'fiber_length': 8903,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTg0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5666},
                                                                                                       {       'connected_time': '327029',
                                                                                                               'fiber_length': 9318,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTVDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5666},
                                                                                                       {       'connected_time': '427034',
                                                                                                               'fiber_length': 9196,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RDk5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5666},
                                                                                                       {       'connected_time': '327026',
                                                                                                               'fiber_length': 9156,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QjNGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5666},
                                                                                                       {       'connected_time': '327026',
                                                                                                               'fiber_length': 9074,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QjVFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5666},
                                                                                                       {       'connected_time': '327028',
                                                                                                               'fiber_length': 9481,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTlCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5666},
                                                                                                       {       'connected_time': '327026',
                                                                                                               'fiber_length': 9284,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QUNGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5666},
                                                                                                       {       'connected_time': '427033',
                                                                                                               'fiber_length': 9249,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDM3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5666},
                                                                                                       {       'connected_time': '327029',
                                                                                                               'fiber_length': 9207,
                                                                                                               'poller_hash': 'QURUTjIzMTI0QjdFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5666},
                                                                                                       {       'connected_time': '327029',
                                                                                                               'fiber_length': 9245,
                                                                                                               'poller_hash': 'QURUTjIzMTI0OTY2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5666},
                                                                                                       {       'connected_time': '327033',
                                                                                                               'fiber_length': 9079,
                                                                                                               'poller_hash': 'QURUTjI0MzYzREI5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5666},
                                                                                                       {       'connected_time': '153651',
                                                                                                               'fiber_length': 9416,
                                                                                                               'poller_hash': 'QURUTjI1MTUyMUEyIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5666}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/13',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8xMw==',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/14',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:d6:36:60'],
                                                                                       'in_nucast_pkts': '14481',
                                                                                       'in_octets': '27007301589',
                                                                                       'in_ucast_pkts': '46146504',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '114919981146',
                                                                                       'out_ucast_pkts': '87784650',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTUwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8d:b0'],
                                                                                       'in_nucast_pkts': '14848',
                                                                                       'in_octets': '1440796980',
                                                                                       'in_ucast_pkts': '2796705',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '17436492765',
                                                                                       'out_ucast_pkts': '12461495',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NzE0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:91:80'],
                                                                                       'in_nucast_pkts': '14485',
                                                                                       'in_octets': '431823514',
                                                                                       'in_ucast_pkts': '650656',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '1314724262',
                                                                                       'out_ucast_pkts': '1246654',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QzMzIHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/14',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8xNA==',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/14',
                                                                                      'id': 'xgspon '
                                                                                            '0/14',
                                                                                      'links': [       {       'connected_time': '427035',
                                                                                                               'fiber_length': 1195,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTUwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4476},
                                                                                                       {       'connected_time': '427034',
                                                                                                               'fiber_length': 780,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NzE0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4476},
                                                                                                       {       'connected_time': '427034',
                                                                                                               'fiber_length': 539,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QzMzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4476}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/14',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8xNA==',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/15',
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/15',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8xNQ==',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/15',
                                                                                      'id': 'xgspon '
                                                                                            '0/15',
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/15',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8xNQ==',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/16',
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/16',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8xNg==',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/16',
                                                                                      'id': 'xgspon '
                                                                                            '0/16',
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/16',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8xNg==',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/2',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:dc:83:00'],
                                                                                       'in_nucast_pkts': '182279',
                                                                                       'in_octets': '113227085394',
                                                                                       'in_ucast_pkts': '281784683',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15383',
                                                                                       'out_octets': '1188113516971',
                                                                                       'out_ucast_pkts': '929359604',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTQ1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:36:e0'],
                                                                                       'in_nucast_pkts': '131312',
                                                                                       'in_octets': '40046711094',
                                                                                       'in_ucast_pkts': '80198771',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '10973',
                                                                                       'out_octets': '343142535187',
                                                                                       'out_ucast_pkts': '256076050',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTQ5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a8:a0'],
                                                                                       'in_nucast_pkts': '61665',
                                                                                       'in_octets': '95356553219',
                                                                                       'in_ucast_pkts': '401599977',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2006',
                                                                                       'out_octets': '1226720307132',
                                                                                       'out_ucast_pkts': '888283807',
                                                                                       'poller_hash': 'QURUTjIzMTQ0N0Y5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:3b:b0'],
                                                                                       'in_nucast_pkts': '181509',
                                                                                       'in_octets': '23060195890',
                                                                                       'in_ucast_pkts': '143995367',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15377',
                                                                                       'out_octets': '705058396714',
                                                                                       'out_ucast_pkts': '490329991',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NjgxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:0c:50'],
                                                                                       'in_nucast_pkts': '23643',
                                                                                       'in_octets': '15570400974',
                                                                                       'in_ucast_pkts': '93138719',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2000',
                                                                                       'out_octets': '371021531560',
                                                                                       'out_ucast_pkts': '269070296',
                                                                                       'poller_hash': 'QURUTjIzMTQ0ODlDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:38:50'],
                                                                                       'in_nucast_pkts': '181515',
                                                                                       'in_octets': '103624194410',
                                                                                       'in_ucast_pkts': '359433717',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15384',
                                                                                       'out_octets': '1507930273863',
                                                                                       'out_ucast_pkts': '1092314172',
                                                                                       'poller_hash': 'QURUTjIzMTQ0OEJBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:6e:e0'],
                                                                                       'in_nucast_pkts': '181637',
                                                                                       'in_octets': '747454418392',
                                                                                       'in_ucast_pkts': '1068389034',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5952',
                                                                                       'out_octets': '2679772269223',
                                                                                       'out_ucast_pkts': '2022632883',
                                                                                       'poller_hash': 'QURUTjIzMTQ0ODlEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:0a:f0'],
                                                                                       'in_nucast_pkts': '181527',
                                                                                       'in_octets': '118694247227',
                                                                                       'in_ucast_pkts': '744512617',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15370',
                                                                                       'out_octets': '1744583538342',
                                                                                       'out_ucast_pkts': '1340512502',
                                                                                       'poller_hash': 'QURUTjIzMTQ0ODgzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:52:20'],
                                                                                       'in_nucast_pkts': '181542',
                                                                                       'in_octets': '28908246753',
                                                                                       'in_ucast_pkts': '225045072',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15379',
                                                                                       'out_octets': '696477307941',
                                                                                       'out_ucast_pkts': '493506105',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NzA3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:08:c0'],
                                                                                       'in_nucast_pkts': '181585',
                                                                                       'in_octets': '39407377498',
                                                                                       'in_ucast_pkts': '111477829',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15373',
                                                                                       'out_octets': '296003448852',
                                                                                       'out_ucast_pkts': '256938233',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NzAyIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a8:10'],
                                                                                       'in_nucast_pkts': '178548',
                                                                                       'in_octets': '58400515225',
                                                                                       'in_ucast_pkts': '102604284',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5952',
                                                                                       'out_octets': '283805844020',
                                                                                       'out_ucast_pkts': '233979174',
                                                                                       'poller_hash': 'QURUTjIzMTQ0N0JEIHBlZXJpbnRm'},
                                                                               {       'in_nucast_pkts': '0',
                                                                                       'in_octets': '0',
                                                                                       'in_ucast_pkts': '0',
                                                                                       'oper_up': False,
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '0',
                                                                                       'out_ucast_pkts': '0',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NkNDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:03:a0'],
                                                                                       'in_nucast_pkts': '181535',
                                                                                       'in_octets': '39608918242',
                                                                                       'in_ucast_pkts': '165154942',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15371',
                                                                                       'out_octets': '880189602473',
                                                                                       'out_ucast_pkts': '626030024',
                                                                                       'poller_hash': 'QURUTjIzMTQ0N0FFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:0b:70'],
                                                                                       'in_nucast_pkts': '49152',
                                                                                       'in_octets': '1631760670',
                                                                                       'in_ucast_pkts': '2740950',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '4159',
                                                                                       'out_octets': '3452620893',
                                                                                       'out_ucast_pkts': '3491273',
                                                                                       'poller_hash': 'QURUTjIzMTQ0OEZFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:3a:70'],
                                                                                       'in_nucast_pkts': '31817',
                                                                                       'in_octets': '10028074215',
                                                                                       'in_ucast_pkts': '37876254',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2691',
                                                                                       'out_octets': '121263697438',
                                                                                       'out_ucast_pkts': '94319708',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NkE1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:83:50'],
                                                                                       'in_nucast_pkts': '163013',
                                                                                       'in_octets': '89954696087',
                                                                                       'in_ucast_pkts': '322041214',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '13694',
                                                                                       'out_octets': '1215213876404',
                                                                                       'out_ucast_pkts': '907506591',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTRBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:4a:f0'],
                                                                                       'in_nucast_pkts': '86768',
                                                                                       'in_octets': '43839947049',
                                                                                       'in_ucast_pkts': '155302953',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2894',
                                                                                       'out_octets': '549023046624',
                                                                                       'out_ucast_pkts': '395156955',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RUZGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:38:00'],
                                                                                       'in_nucast_pkts': '75317',
                                                                                       'in_octets': '26957671546',
                                                                                       'in_ucast_pkts': '52874363',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6375',
                                                                                       'out_octets': '88318159755',
                                                                                       'out_ucast_pkts': '83722263',
                                                                                       'poller_hash': 'QURUTjIzMTI0QTE4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '36:3a:c5:c7:0e:34',
                                                                                                                        'cc:66:18:50:b4:20'],
                                                                                       'in_nucast_pkts': '48931',
                                                                                       'in_octets': '436383774512',
                                                                                       'in_ucast_pkts': '507681784',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1631',
                                                                                       'out_octets': '796936082032',
                                                                                       'out_ucast_pkts': '698475722',
                                                                                       'poller_hash': 'QURUTjIzMTI0QTc2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:43:e0'],
                                                                                       'in_nucast_pkts': '178694',
                                                                                       'in_octets': '110469006288',
                                                                                       'in_ucast_pkts': '344223166',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5951',
                                                                                       'out_octets': '929286519505',
                                                                                       'out_ucast_pkts': '686797219',
                                                                                       'poller_hash': 'QURUTjIzMTI0QjNGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:38:30'],
                                                                                       'in_nucast_pkts': '26797',
                                                                                       'in_octets': '84175078455',
                                                                                       'in_ucast_pkts': '173298172',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2272',
                                                                                       'out_octets': '423674434887',
                                                                                       'out_ucast_pkts': '315344278',
                                                                                       'poller_hash': 'QURUTjIzMTI0QkE1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:62:90'],
                                                                                       'in_nucast_pkts': '179550',
                                                                                       'in_octets': '198479562751',
                                                                                       'in_ucast_pkts': '1057037287',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5953',
                                                                                       'out_octets': '5820242453077',
                                                                                       'out_ucast_pkts': '4428697131',
                                                                                       'poller_hash': 'QURUTjI0MzYzQ0M2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8c:80'],
                                                                                       'in_nucast_pkts': '50835',
                                                                                       'in_octets': '85868828443',
                                                                                       'in_ucast_pkts': '313251806',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '4214',
                                                                                       'out_octets': '820631184990',
                                                                                       'out_ucast_pkts': '594871244',
                                                                                       'poller_hash': 'QURUTjIzMTQ0OEI4IHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/2',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8y',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/2',
                                                                                      'id': 'xgspon '
                                                                                            '0/2',
                                                                                      'links': [       {       'connected_time': '5355625',
                                                                                                               'fiber_length': 13527,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTQ1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '3826297',
                                                                                                               'fiber_length': 13074,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTQ5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '1804563',
                                                                                                               'fiber_length': 14757,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0N0Y5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -23.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '5355592',
                                                                                                               'fiber_length': 14954,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NjgxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '696994',
                                                                                                               'fiber_length': 14487,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0ODlDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -23.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '5355621',
                                                                                                               'fiber_length': 14745,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0OEJBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -24.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '5355622',
                                                                                                               'fiber_length': 14466,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0ODlEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -23.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '5355622',
                                                                                                               'fiber_length': 14826,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0ODgzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -23.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '5355624',
                                                                                                               'fiber_length': 14521,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NzA3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '5355626',
                                                                                                               'fiber_length': 14662,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NzAyIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '5355624',
                                                                                                               'fiber_length': 13218,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0N0JEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '5355594',
                                                                                                               'fiber_length': 12154,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NkNDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '5355625',
                                                                                                               'fiber_length': 13016,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0N0FFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '1450250',
                                                                                                               'fiber_length': 14823,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0OEZFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '938225',
                                                                                                               'fiber_length': 14178,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NkE1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '4773320',
                                                                                                               'fiber_length': 14481,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTRBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '2600437',
                                                                                                               'fiber_length': 14568,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RUZGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -26.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '2228296',
                                                                                                               'fiber_length': 14439,
                                                                                                               'poller_hash': 'QURUTjIzMTI0QTE4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '1467132',
                                                                                                               'fiber_length': 12765,
                                                                                                               'poller_hash': 'QURUTjIzMTI0QTc2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '5355594',
                                                                                                               'fiber_length': 13633,
                                                                                                               'poller_hash': 'QURUTjIzMTI0QjNGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '789241',
                                                                                                               'fiber_length': 14906,
                                                                                                               'poller_hash': 'QURUTjIzMTI0QkE1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -23.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '5355594',
                                                                                                               'fiber_length': 13230,
                                                                                                               'poller_hash': 'QURUTjI0MzYzQ0M2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268},
                                                                                                       {       'connected_time': '1469144',
                                                                                                               'fiber_length': 13206,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0OEI4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.268}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/2',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8y',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/3',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:dc:56:70'],
                                                                                       'in_nucast_pkts': '77530',
                                                                                       'in_octets': '62439363189',
                                                                                       'in_ucast_pkts': '286217570',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6385',
                                                                                       'out_octets': '1268052424980',
                                                                                       'out_ucast_pkts': '909777139',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTA3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:77:20'],
                                                                                       'in_nucast_pkts': '11726',
                                                                                       'in_octets': '6215172481',
                                                                                       'in_ucast_pkts': '26752970',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '967',
                                                                                       'out_octets': '92677070435',
                                                                                       'out_ucast_pkts': '66622657',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTE0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:69:60'],
                                                                                       'in_nucast_pkts': '63819',
                                                                                       'in_octets': '29946671985',
                                                                                       'in_ucast_pkts': '123997316',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5396',
                                                                                       'out_octets': '358573734229',
                                                                                       'out_ucast_pkts': '321869766',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTYwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:57:60'],
                                                                                       'in_nucast_pkts': '6011',
                                                                                       'in_octets': '763293728',
                                                                                       'in_ucast_pkts': '4151642',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '508',
                                                                                       'out_octets': '26958327833',
                                                                                       'out_ucast_pkts': '19150838',
                                                                                       'poller_hash': 'QURUTjIzMTI0REREIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4b:fa:30'],
                                                                                       'in_nucast_pkts': '74433',
                                                                                       'in_octets': '29191281244',
                                                                                       'in_ucast_pkts': '94770633',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2473',
                                                                                       'out_octets': '375087618014',
                                                                                       'out_ucast_pkts': '274711552',
                                                                                       'poller_hash': 'QURUTjIzMTI0NUM2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:7a:e0'],
                                                                                       'in_nucast_pkts': '109387',
                                                                                       'in_octets': '174666695788',
                                                                                       'in_ucast_pkts': '363170979',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3640',
                                                                                       'out_octets': '933167134518',
                                                                                       'out_ucast_pkts': '719789175',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDdEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:76:60'],
                                                                                       'in_nucast_pkts': '77528',
                                                                                       'in_octets': '32641247852',
                                                                                       'in_ucast_pkts': '126568489',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6387',
                                                                                       'out_octets': '362483997378',
                                                                                       'out_ucast_pkts': '260331198',
                                                                                       'poller_hash': 'QURUTjIzMTIzRkFEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:75:51'],
                                                                                       'in_nucast_pkts': '1294',
                                                                                       'in_octets': '29294916315',
                                                                                       'in_ucast_pkts': '132421807',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6385',
                                                                                       'out_octets': '669835731171',
                                                                                       'out_ucast_pkts': '478712474',
                                                                                       'poller_hash': 'QURUTjIzMTI0Rjk5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ab:20'],
                                                                                       'in_nucast_pkts': '59201',
                                                                                       'in_octets': '68196870753',
                                                                                       'in_ucast_pkts': '219278469',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1926',
                                                                                       'out_octets': '551753915216',
                                                                                       'out_ucast_pkts': '400848215',
                                                                                       'poller_hash': 'QURUTjIzMTI0RjA2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:78:a0'],
                                                                                       'in_nucast_pkts': '75678',
                                                                                       'in_octets': '16154703523',
                                                                                       'in_ucast_pkts': '100747676',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6384',
                                                                                       'out_octets': '270403354462',
                                                                                       'out_ucast_pkts': '197093412',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTdEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:b5:50'],
                                                                                       'in_nucast_pkts': '74443',
                                                                                       'in_octets': '29275910389',
                                                                                       'in_ucast_pkts': '150037707',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2476',
                                                                                       'out_octets': '892621609407',
                                                                                       'out_ucast_pkts': '650891503',
                                                                                       'poller_hash': 'QURUTjIzMTI0REU4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:93:80'],
                                                                                       'in_nucast_pkts': '75269',
                                                                                       'in_octets': '36222598925',
                                                                                       'in_ucast_pkts': '207835924',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6347',
                                                                                       'out_octets': '689783876933',
                                                                                       'out_ucast_pkts': '491851054',
                                                                                       'poller_hash': 'QURUTjIzMTI1MUVFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:8a:10'],
                                                                                       'in_nucast_pkts': '21001',
                                                                                       'in_octets': '11161088054',
                                                                                       'in_ucast_pkts': '58228056',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1735',
                                                                                       'out_octets': '218225110338',
                                                                                       'out_ucast_pkts': '157171893',
                                                                                       'poller_hash': 'QURUTjIzMTI0RUE1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:b7:70'],
                                                                                       'in_nucast_pkts': '74438',
                                                                                       'in_octets': '9283026051',
                                                                                       'in_ucast_pkts': '29323621',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2480',
                                                                                       'out_octets': '82760998155',
                                                                                       'out_ucast_pkts': '67787830',
                                                                                       'poller_hash': 'QURUTjIzMTIzRTlFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:09:30'],
                                                                                       'in_nucast_pkts': '14496',
                                                                                       'in_octets': '17081454320',
                                                                                       'in_ucast_pkts': '118761085',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1226',
                                                                                       'out_octets': '325121783026',
                                                                                       'out_ucast_pkts': '222443442',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTI5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:6a:e0'],
                                                                                       'in_nucast_pkts': '76202',
                                                                                       'in_octets': '25252545824',
                                                                                       'in_ucast_pkts': '81251484',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6386',
                                                                                       'out_octets': '401436456616',
                                                                                       'out_ucast_pkts': '292023857',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTI2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a8:50'],
                                                                                       'in_nucast_pkts': '74436',
                                                                                       'in_octets': '27238749941',
                                                                                       'in_ucast_pkts': '145779371',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2477',
                                                                                       'out_octets': '663778846525',
                                                                                       'out_ucast_pkts': '469434828',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTUzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:37:60'],
                                                                                       'in_nucast_pkts': '75662',
                                                                                       'in_octets': '24561795550',
                                                                                       'in_ucast_pkts': '147022405',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6382',
                                                                                       'out_octets': '527052006636',
                                                                                       'out_ucast_pkts': '366905481',
                                                                                       'poller_hash': 'QURUTjIzMTI1MUFBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:24:e0'],
                                                                                       'in_nucast_pkts': '40298',
                                                                                       'in_octets': '4243954573',
                                                                                       'in_ucast_pkts': '12895145',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1324',
                                                                                       'out_octets': '37437659973',
                                                                                       'out_ucast_pkts': '27245498',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTRGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:50:b0'],
                                                                                       'in_nucast_pkts': '74438',
                                                                                       'in_octets': '18974555818',
                                                                                       'in_ucast_pkts': '69047685',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2478',
                                                                                       'out_octets': '268453639730',
                                                                                       'out_ucast_pkts': '197348696',
                                                                                       'poller_hash': 'QURUTjIzMTI0MUJGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:37:81'],
                                                                                       'in_nucast_pkts': '259',
                                                                                       'in_octets': '5241450276',
                                                                                       'in_ucast_pkts': '29662030',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '248025810009',
                                                                                       'out_ucast_pkts': '177604089',
                                                                                       'poller_hash': 'QURUTjIzMTIzRkRDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ab:00'],
                                                                                       'in_nucast_pkts': '40855',
                                                                                       'in_octets': '34452701031',
                                                                                       'in_ucast_pkts': '98440496',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1361',
                                                                                       'out_octets': '418703305580',
                                                                                       'out_ucast_pkts': '301311136',
                                                                                       'poller_hash': 'QURUTjIzMTQ0N0RBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:84:51'],
                                                                                       'in_nucast_pkts': '592',
                                                                                       'in_octets': '18872725877',
                                                                                       'in_ucast_pkts': '54923384',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2779',
                                                                                       'out_octets': '197713632354',
                                                                                       'out_ucast_pkts': '149092553',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NzM1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:01:10'],
                                                                                       'in_nucast_pkts': '74436',
                                                                                       'in_octets': '36425499264',
                                                                                       'in_ucast_pkts': '101071453',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2479',
                                                                                       'out_octets': '385596721031',
                                                                                       'out_ucast_pkts': '291389941',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QUIwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:81:70'],
                                                                                       'in_nucast_pkts': '74437',
                                                                                       'in_octets': '79842049203',
                                                                                       'in_ucast_pkts': '169807253',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2479',
                                                                                       'out_octets': '564242287128',
                                                                                       'out_ucast_pkts': '423924209',
                                                                                       'poller_hash': 'QURUTjIzMTI0QzU1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:a8:60'],
                                                                                       'in_nucast_pkts': '75672',
                                                                                       'in_octets': '45888934802',
                                                                                       'in_ucast_pkts': '130477397',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6384',
                                                                                       'out_octets': '459567680266',
                                                                                       'out_ucast_pkts': '327328544',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RUUzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a3:a0'],
                                                                                       'in_nucast_pkts': '66667',
                                                                                       'in_octets': '9328434308',
                                                                                       'in_ucast_pkts': '80529385',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2222',
                                                                                       'out_octets': '255358029288',
                                                                                       'out_ucast_pkts': '176691746',
                                                                                       'poller_hash': 'QURUTjIzMTI0NjBBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ab:a0'],
                                                                                       'in_nucast_pkts': '74439',
                                                                                       'in_octets': '8471193592',
                                                                                       'in_ucast_pkts': '41579304',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2477',
                                                                                       'out_octets': '212613192305',
                                                                                       'out_ucast_pkts': '160210824',
                                                                                       'poller_hash': 'QURUTjI0MzYzQUU3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:25:f0'],
                                                                                       'in_nucast_pkts': '74439',
                                                                                       'in_octets': '16883087413',
                                                                                       'in_ucast_pkts': '15576212',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2477',
                                                                                       'out_octets': '19789729593',
                                                                                       'out_ucast_pkts': '18624355',
                                                                                       'poller_hash': 'QURUTjI0Mzg5NkY5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:2e:00'],
                                                                                       'in_nucast_pkts': '53974',
                                                                                       'in_octets': '35067790418',
                                                                                       'in_ucast_pkts': '83574139',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1803',
                                                                                       'out_octets': '555199089656',
                                                                                       'out_ucast_pkts': '398797477',
                                                                                       'poller_hash': 'QURUTjI0MzYzQzQ5IHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/3',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8z',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/3',
                                                                                      'id': 'xgspon '
                                                                                            '0/3',
                                                                                      'links': [       {       'connected_time': '2232581',
                                                                                                               'fiber_length': 3992,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTA3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '337326',
                                                                                                               'fiber_length': 4123,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTE0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '1882625',
                                                                                                               'fiber_length': 4527,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTYwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '176952',
                                                                                                               'fiber_length': 3424,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REREIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '2232587',
                                                                                                               'fiber_length': 3878,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NUM2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '3278982',
                                                                                                               'fiber_length': 4613,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDdEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '2232583',
                                                                                                               'fiber_length': 3684,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRkFEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '2232585',
                                                                                                               'fiber_length': 3674,
                                                                                                               'poller_hash': 'QURUTjIzMTI0Rjk5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '1732403',
                                                                                                               'fiber_length': 4267,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RjA2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '2232584',
                                                                                                               'fiber_length': 3861,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTdEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '2232585',
                                                                                                               'fiber_length': 3367,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REU4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '2232578',
                                                                                                               'fiber_length': 4569,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MUVFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '604300',
                                                                                                               'fiber_length': 3857,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RUE1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '2232582',
                                                                                                               'fiber_length': 4488,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRTlFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '427035',
                                                                                                               'fiber_length': 4696,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTI5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '2232584',
                                                                                                               'fiber_length': 4079,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTI2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '2232579',
                                                                                                               'fiber_length': 3719,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTUzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '2232583',
                                                                                                               'fiber_length': 4022,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MUFBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '1208680',
                                                                                                               'fiber_length': 3775,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTRGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -24.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '2232586',
                                                                                                               'fiber_length': 4059,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MUJGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '427037',
                                                                                                               'fiber_length': 4481,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRkRDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '1224999',
                                                                                                               'fiber_length': 3596,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0N0RBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '969066',
                                                                                                               'fiber_length': 4136,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NzM1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '2232576',
                                                                                                               'fiber_length': 4574,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QUIwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '2232586',
                                                                                                               'fiber_length': 4209,
                                                                                                               'poller_hash': 'QURUTjIzMTI0QzU1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '2232576',
                                                                                                               'fiber_length': 4287,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RUUzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '1999223',
                                                                                                               'fiber_length': 4437,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NjBBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '2232594',
                                                                                                               'fiber_length': 3543,
                                                                                                               'poller_hash': 'QURUTjI0MzYzQUU3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '2232590',
                                                                                                               'fiber_length': 3918,
                                                                                                               'poller_hash': 'QURUTjI0Mzg5NkY5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456},
                                                                                                       {       'connected_time': '1617919',
                                                                                                               'fiber_length': 4116,
                                                                                                               'poller_hash': 'QURUTjI0MzYzQzQ5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.5456}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/3',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8z',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/4',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:dc:7f:40'],
                                                                                       'in_nucast_pkts': '75670',
                                                                                       'in_octets': '31365538729',
                                                                                       'in_ucast_pkts': '242077913',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6407',
                                                                                       'out_octets': '829089433233',
                                                                                       'out_ucast_pkts': '590504210',
                                                                                       'poller_hash': 'QURUTjIzMTI0REYxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:56:90'],
                                                                                       'in_nucast_pkts': '75665',
                                                                                       'in_octets': '9338582863',
                                                                                       'in_ucast_pkts': '28219211',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6402',
                                                                                       'out_octets': '92332925860',
                                                                                       'out_ucast_pkts': '77335772',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDQzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:71:00'],
                                                                                       'in_nucast_pkts': '76288',
                                                                                       'in_octets': '33947972487',
                                                                                       'in_ucast_pkts': '162391808',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2482',
                                                                                       'out_octets': '599415877956',
                                                                                       'out_ucast_pkts': '432388381',
                                                                                       'poller_hash': 'QURUTjIzMTI1MUUyIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:93:30'],
                                                                                       'in_nucast_pkts': '34912',
                                                                                       'in_octets': '16610401362',
                                                                                       'in_ucast_pkts': '85236877',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2953',
                                                                                       'out_octets': '458100236742',
                                                                                       'out_ucast_pkts': '324936178',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTI2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:92:20'],
                                                                                       'in_nucast_pkts': '75672',
                                                                                       'in_octets': '85674469971',
                                                                                       'in_ucast_pkts': '348962087',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6402',
                                                                                       'out_octets': '1033461819978',
                                                                                       'out_ucast_pkts': '758406064',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDk4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:78:60'],
                                                                                       'in_nucast_pkts': '75665',
                                                                                       'in_octets': '27739920116',
                                                                                       'in_ucast_pkts': '138623369',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6403',
                                                                                       'out_octets': '922022364186',
                                                                                       'out_ucast_pkts': '680231536',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDUwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:77:c0'],
                                                                                       'in_nucast_pkts': '75767',
                                                                                       'in_octets': '2784186285',
                                                                                       'in_ucast_pkts': '10090190',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6405',
                                                                                       'out_octets': '35990375455',
                                                                                       'out_ucast_pkts': '26460817',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDM4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:72:20'],
                                                                                       'in_nucast_pkts': '77266',
                                                                                       'in_octets': '41123582384',
                                                                                       'in_ucast_pkts': '281917848',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6407',
                                                                                       'out_octets': '1196558938007',
                                                                                       'out_ucast_pkts': '859399516',
                                                                                       'poller_hash': 'QURUTjIzMTI0OTAwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:77:f0'],
                                                                                       'in_nucast_pkts': '26178',
                                                                                       'in_octets': '85650039323',
                                                                                       'in_ucast_pkts': '114289475',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2214',
                                                                                       'out_octets': '250406646440',
                                                                                       'out_ucast_pkts': '232063765',
                                                                                       'poller_hash': 'QURUTjIzMTI0REE2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:73:e0'],
                                                                                       'in_nucast_pkts': '34913',
                                                                                       'in_octets': '2840283832',
                                                                                       'in_ucast_pkts': '26225482',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2953',
                                                                                       'out_octets': '82265357604',
                                                                                       'out_ucast_pkts': '55788751',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTE2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:81:10'],
                                                                                       'in_nucast_pkts': '75672',
                                                                                       'in_octets': '120872407124',
                                                                                       'in_ucast_pkts': '568591069',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6405',
                                                                                       'out_octets': '1832551536574',
                                                                                       'out_ucast_pkts': '1367600034',
                                                                                       'poller_hash': 'QURUTjIzMTI0RjJCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:5c:00'],
                                                                                       'in_nucast_pkts': '48342',
                                                                                       'in_octets': '47394728515',
                                                                                       'in_ucast_pkts': '165295208',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1612',
                                                                                       'out_octets': '587936001059',
                                                                                       'out_ucast_pkts': '429751557',
                                                                                       'poller_hash': 'QURUTjIzMTIzRjJCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:75:a0'],
                                                                                       'in_nucast_pkts': '34947',
                                                                                       'in_octets': '8301950420',
                                                                                       'in_ucast_pkts': '63624076',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2956',
                                                                                       'out_octets': '157804370907',
                                                                                       'out_ucast_pkts': '115544537',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTBEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:af:00'],
                                                                                       'in_nucast_pkts': '74455',
                                                                                       'in_octets': '20700678576',
                                                                                       'in_ucast_pkts': '51489624',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2482',
                                                                                       'out_octets': '171434867308',
                                                                                       'out_ucast_pkts': '139976763',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTI1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:7f:80'],
                                                                                       'in_nucast_pkts': '58851',
                                                                                       'in_octets': '90918435541',
                                                                                       'in_ucast_pkts': '161774759',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '4984',
                                                                                       'out_octets': '394429533551',
                                                                                       'out_ucast_pkts': '335201598',
                                                                                       'poller_hash': 'QURUTjIzMTI0REY3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8d:c0'],
                                                                                       'in_nucast_pkts': '75669',
                                                                                       'in_octets': '24276410552',
                                                                                       'in_ucast_pkts': '74655460',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6403',
                                                                                       'out_octets': '189926341187',
                                                                                       'out_ucast_pkts': '146275978',
                                                                                       'poller_hash': 'QURUTjIzMTI1MUIwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:83:00'],
                                                                                       'in_nucast_pkts': '77462',
                                                                                       'in_octets': '89905790007',
                                                                                       'in_ucast_pkts': '229297951',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6403',
                                                                                       'out_octets': '764692895348',
                                                                                       'out_ucast_pkts': '563283399',
                                                                                       'poller_hash': 'QURUTjIzMTI0Rjc0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:3a:f0'],
                                                                                       'in_nucast_pkts': '75669',
                                                                                       'in_octets': '59160943607',
                                                                                       'in_ucast_pkts': '354938436',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6407',
                                                                                       'out_octets': '1144840804202',
                                                                                       'out_ucast_pkts': '838247141',
                                                                                       'poller_hash': 'QURUTjIzMTI0NEVCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:50:e0'],
                                                                                       'in_nucast_pkts': '74457',
                                                                                       'in_octets': '18963024446',
                                                                                       'in_ucast_pkts': '55212384',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2482',
                                                                                       'out_octets': '173927629920',
                                                                                       'out_ucast_pkts': '131762938',
                                                                                       'poller_hash': 'QURUTjIzMTI0MDk5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:71:10'],
                                                                                       'in_nucast_pkts': '75672',
                                                                                       'in_octets': '30042834672',
                                                                                       'in_ucast_pkts': '143586465',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6407',
                                                                                       'out_octets': '405418036092',
                                                                                       'out_ucast_pkts': '371197083',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RUZEIHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/4',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC80',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/4',
                                                                                      'id': 'xgspon '
                                                                                            '0/4',
                                                                                      'links': [       {       'connected_time': '2232582',
                                                                                                               'fiber_length': 5944,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REYxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749},
                                                                                                       {       'connected_time': '2232584',
                                                                                                               'fiber_length': 6063,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDQzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749},
                                                                                                       {       'connected_time': '2232582',
                                                                                                               'fiber_length': 5212,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MUUyIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749},
                                                                                                       {       'connected_time': '1029869',
                                                                                                               'fiber_length': 7531,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTI2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749},
                                                                                                       {       'connected_time': '2232584',
                                                                                                               'fiber_length': 5967,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDk4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749},
                                                                                                       {       'connected_time': '2232588',
                                                                                                               'fiber_length': 5915,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDUwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749},
                                                                                                       {       'connected_time': '2232582',
                                                                                                               'fiber_length': 6210,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDM4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749},
                                                                                                       {       'connected_time': '2232584',
                                                                                                               'fiber_length': 6197,
                                                                                                               'poller_hash': 'QURUTjIzMTI0OTAwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749},
                                                                                                       {       'connected_time': '771591',
                                                                                                               'fiber_length': 5510,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REE2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749},
                                                                                                       {       'connected_time': '1029869',
                                                                                                               'fiber_length': 7481,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTE2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749},
                                                                                                       {       'connected_time': '2232586',
                                                                                                               'fiber_length': 6120,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RjJCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749},
                                                                                                       {       'connected_time': '1449540',
                                                                                                               'fiber_length': 5584,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRjJCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749},
                                                                                                       {       'connected_time': '1029870',
                                                                                                               'fiber_length': 7351,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTBEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749},
                                                                                                       {       'connected_time': '2232587',
                                                                                                               'fiber_length': 5209,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTI1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749},
                                                                                                       {       'connected_time': '1735925',
                                                                                                               'fiber_length': 8168,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REY3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749},
                                                                                                       {       'connected_time': '2232584',
                                                                                                               'fiber_length': 5245,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MUIwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749},
                                                                                                       {       'connected_time': '2232586',
                                                                                                               'fiber_length': 6325,
                                                                                                               'poller_hash': 'QURUTjIzMTI0Rjc0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749},
                                                                                                       {       'connected_time': '2232588',
                                                                                                               'fiber_length': 8586,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NEVCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749},
                                                                                                       {       'connected_time': '2232588',
                                                                                                               'fiber_length': 6279,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MDk5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749},
                                                                                                       {       'connected_time': '2232586',
                                                                                                               'fiber_length': 6232,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RUZEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3749}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/4',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC80',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/5',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:d6:08:e0'],
                                                                                       'in_nucast_pkts': '75673',
                                                                                       'in_octets': '16375391903',
                                                                                       'in_ucast_pkts': '94315921',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6407',
                                                                                       'out_octets': '416345970025',
                                                                                       'out_ucast_pkts': '307636158',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTJBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:8d:d0'],
                                                                                       'in_nucast_pkts': '74566',
                                                                                       'in_octets': '168473594025',
                                                                                       'in_ucast_pkts': '584126252',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2480',
                                                                                       'out_octets': '1789470340955',
                                                                                       'out_ucast_pkts': '1279183727',
                                                                                       'poller_hash': 'QURUTjIzMTI0RUE0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:0c:10'],
                                                                                       'in_nucast_pkts': '165871',
                                                                                       'in_octets': '99808996995',
                                                                                       'in_ucast_pkts': '610693991',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '13915',
                                                                                       'out_octets': '954629699928',
                                                                                       'out_ucast_pkts': '923394512',
                                                                                       'poller_hash': 'QURUTjIzMTIzRkY1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:7d:e0'],
                                                                                       'in_nucast_pkts': '75667',
                                                                                       'in_octets': '11102011713',
                                                                                       'in_ucast_pkts': '70121762',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6403',
                                                                                       'out_octets': '263864899151',
                                                                                       'out_ucast_pkts': '186484050',
                                                                                       'poller_hash': 'QURUTjIzMTIzRjE4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:b8:50'],
                                                                                       'in_nucast_pkts': '76288',
                                                                                       'in_octets': '36720060506',
                                                                                       'in_ucast_pkts': '279046156',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2482',
                                                                                       'out_octets': '873140339405',
                                                                                       'out_ucast_pkts': '608947037',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTk1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:7b:30'],
                                                                                       'in_nucast_pkts': '77528',
                                                                                       'in_octets': '121194056410',
                                                                                       'in_ucast_pkts': '294951548',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6409',
                                                                                       'out_octets': '999471470264',
                                                                                       'out_ucast_pkts': '796610270',
                                                                                       'poller_hash': 'QURUTjIzMTI1MENDIHBlZXJpbnRm'},
                                                                               {       'in_nucast_pkts': '4038463',
                                                                                       'in_octets': '1185329785',
                                                                                       'in_ucast_pkts': '1052807',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '0',
                                                                                       'out_ucast_pkts': '0',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTExIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:6e:30'],
                                                                                       'in_nucast_pkts': '178546',
                                                                                       'in_octets': '116680277023',
                                                                                       'in_ucast_pkts': '778141606',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5952',
                                                                                       'out_octets': '2677020422440',
                                                                                       'out_ucast_pkts': '1895563390',
                                                                                       'poller_hash': 'QURUTjIzMTI1MjA2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:b3:60'],
                                                                                       'in_nucast_pkts': '74440',
                                                                                       'in_octets': '25203479449',
                                                                                       'in_ucast_pkts': '190860845',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2482',
                                                                                       'out_octets': '522456534596',
                                                                                       'out_ucast_pkts': '377160431',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTREIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:63:40'],
                                                                                       'in_nucast_pkts': '74441',
                                                                                       'in_octets': '19241109251',
                                                                                       'in_ucast_pkts': '133289436',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2482',
                                                                                       'out_octets': '394019870049',
                                                                                       'out_ucast_pkts': '272349105',
                                                                                       'poller_hash': 'QURUTjIzMTI1MENEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:35:20'],
                                                                                       'in_nucast_pkts': '75670',
                                                                                       'in_octets': '22487044850',
                                                                                       'in_ucast_pkts': '116863573',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6405',
                                                                                       'out_octets': '568621225123',
                                                                                       'out_ucast_pkts': '402931634',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTRCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a9:70'],
                                                                                       'in_nucast_pkts': '74456',
                                                                                       'in_octets': '19525953906',
                                                                                       'in_ucast_pkts': '52938837',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2482',
                                                                                       'out_octets': '165640553610',
                                                                                       'out_ucast_pkts': '129636471',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NkEzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:23:70'],
                                                                                       'in_nucast_pkts': '74451',
                                                                                       'in_octets': '136938371849',
                                                                                       'in_ucast_pkts': '615456612',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2482',
                                                                                       'out_octets': '2040535594782',
                                                                                       'out_ucast_pkts': '1469568415',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NkI0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4b:fc:e0'],
                                                                                       'in_nucast_pkts': '3563',
                                                                                       'in_octets': '5015036161',
                                                                                       'in_ucast_pkts': '7132338',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '120',
                                                                                       'out_octets': '29720959044',
                                                                                       'out_ucast_pkts': '22368483',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NzU5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:37:40'],
                                                                                       'in_nucast_pkts': '75769',
                                                                                       'in_octets': '40434694715',
                                                                                       'in_ucast_pkts': '264411380',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6404',
                                                                                       'out_octets': '970857885258',
                                                                                       'out_ucast_pkts': '728217544',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTk3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:b4:b0'],
                                                                                       'in_nucast_pkts': '68169',
                                                                                       'in_octets': '84935880657',
                                                                                       'in_ucast_pkts': '148044448',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5773',
                                                                                       'out_octets': '475176904238',
                                                                                       'out_ucast_pkts': '345196782',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RUZCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:aa:e0'],
                                                                                       'in_nucast_pkts': '148421',
                                                                                       'in_octets': '7943819348',
                                                                                       'in_ucast_pkts': '14707772',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '4830',
                                                                                       'out_octets': '4078142804',
                                                                                       'out_ucast_pkts': '8557943',
                                                                                       'poller_hash': 'QURUTjIzMTI0NEJBIHBlZXJpbnRm'},
                                                                               {       'in_nucast_pkts': '0',
                                                                                       'in_octets': '0',
                                                                                       'in_ucast_pkts': '0',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '0',
                                                                                       'out_ucast_pkts': '0',
                                                                                       'poller_hash': 'QURUTjIzMTQ1MTIwIHBlZXJpbnRm'},
                                                                               {       'in_nucast_pkts': '0',
                                                                                       'in_octets': '0',
                                                                                       'in_ucast_pkts': '0',
                                                                                       'oper_up': False,
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '0',
                                                                                       'out_ucast_pkts': '0',
                                                                                       'poller_hash': 'QURUTjI0MzYzRDNBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:39:90'],
                                                                                       'in_nucast_pkts': '77372',
                                                                                       'in_octets': '173473435611',
                                                                                       'in_ucast_pkts': '1165260072',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '6395',
                                                                                       'out_octets': '4284904575408',
                                                                                       'out_ucast_pkts': '2972646601',
                                                                                       'poller_hash': 'QURUTjI0MzE0MTk1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:e6:40'],
                                                                                       'in_nucast_pkts': '74456',
                                                                                       'in_octets': '32172783742',
                                                                                       'in_ucast_pkts': '255295421',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2482',
                                                                                       'out_octets': '735907349926',
                                                                                       'out_ucast_pkts': '516063150',
                                                                                       'poller_hash': 'QURUTjI0MzE0MUEzIHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/5',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC81',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/5',
                                                                                      'id': 'xgspon '
                                                                                            '0/5',
                                                                                      'links': [       {       'connected_time': '2232588',
                                                                                                               'fiber_length': 5521,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTJBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '2232585',
                                                                                                               'fiber_length': 5919,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RUE0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '4851897',
                                                                                                               'fiber_length': 5995,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRkY1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '2232589',
                                                                                                               'fiber_length': 5797,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRjE4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '2232587',
                                                                                                               'fiber_length': 6115,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTk1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '2232589',
                                                                                                               'fiber_length': 6181,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MENDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '2232588',
                                                                                                               'fiber_length': 6734,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTExIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '5355625',
                                                                                                               'fiber_length': 7635,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MjA2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '2232588',
                                                                                                               'fiber_length': 5523,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTREIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '2232584',
                                                                                                               'fiber_length': 5847,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MENEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '2232587',
                                                                                                               'fiber_length': 6444,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTRCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '2232580',
                                                                                                               'fiber_length': 6030,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NkEzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '2232586',
                                                                                                               'fiber_length': 6378,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NkI0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '106257',
                                                                                                               'fiber_length': 6744,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NzU5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '2232584',
                                                                                                               'fiber_length': 6051,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTk3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '2011665',
                                                                                                               'fiber_length': 6816,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RUZCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -22.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '5355629',
                                                                                                               'fiber_length': 7484,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NEJBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '11998',
                                                                                                               'fiber_length': 5781,
                                                                                                               'poller_hash': 'QURUTjIzMTQ1MTIwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '1550263',
                                                                                                               'fiber_length': 6741,
                                                                                                               'poller_hash': 'QURUTjI0MzYzRDNBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '2232592',
                                                                                                               'fiber_length': 6741,
                                                                                                               'poller_hash': 'QURUTjI0MzE0MTk1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071},
                                                                                                       {       'connected_time': '2232592',
                                                                                                               'fiber_length': 6541,
                                                                                                               'poller_hash': 'QURUTjI0MzE0MUEzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.1071}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/5',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC81',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/6',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:4c:01:c0'],
                                                                                       'in_nucast_pkts': '158840',
                                                                                       'in_octets': '49755568489',
                                                                                       'in_ucast_pkts': '151433781',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5302',
                                                                                       'out_octets': '504357300674',
                                                                                       'out_ucast_pkts': '390076108',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDYxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:04:00'],
                                                                                       'in_nucast_pkts': '76290',
                                                                                       'in_octets': '51219008561',
                                                                                       'in_ucast_pkts': '286936107',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2482',
                                                                                       'out_octets': '978368486421',
                                                                                       'out_ucast_pkts': '730330180',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTcxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:82:c0'],
                                                                                       'in_nucast_pkts': '183322',
                                                                                       'in_octets': '237506751290',
                                                                                       'in_ucast_pkts': '1415059809',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15384',
                                                                                       'out_octets': '4720683348841',
                                                                                       'out_ucast_pkts': '3430807496',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTUyIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:08:70'],
                                                                                       'in_nucast_pkts': '90358',
                                                                                       'in_octets': '46234900077',
                                                                                       'in_ucast_pkts': '306741005',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '7625',
                                                                                       'out_octets': '1355647793471',
                                                                                       'out_ucast_pkts': '1038143637',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTREIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:3a:e0'],
                                                                                       'in_nucast_pkts': '12185',
                                                                                       'in_octets': '7659325026',
                                                                                       'in_ucast_pkts': '25544182',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1032',
                                                                                       'out_octets': '66306366365',
                                                                                       'out_ucast_pkts': '49152844',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTZBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:d8:90'],
                                                                                       'in_nucast_pkts': '160098',
                                                                                       'in_octets': '22879317435',
                                                                                       'in_ucast_pkts': '105664544',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5304',
                                                                                       'out_octets': '461411238133',
                                                                                       'out_ucast_pkts': '341084502',
                                                                                       'poller_hash': 'QURUTjIzMTI0NDVDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:a7:30'],
                                                                                       'in_nucast_pkts': '25252',
                                                                                       'in_octets': '20642883768',
                                                                                       'in_ucast_pkts': '113167798',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '843',
                                                                                       'out_octets': '530696181797',
                                                                                       'out_ucast_pkts': '381264008',
                                                                                       'poller_hash': 'QURUTjIzMTI0NEJDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:50:10'],
                                                                                       'in_nucast_pkts': '178545',
                                                                                       'in_octets': '153882517082',
                                                                                       'in_ucast_pkts': '446613554',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5952',
                                                                                       'out_octets': '1172709230629',
                                                                                       'out_ucast_pkts': '920785112',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTNBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8f:d0'],
                                                                                       'in_nucast_pkts': '183654',
                                                                                       'in_octets': '11693088997',
                                                                                       'in_ucast_pkts': '32136695',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15381',
                                                                                       'out_octets': '44985435977',
                                                                                       'out_ucast_pkts': '40222103',
                                                                                       'poller_hash': 'QURUTjIzMTI0MUMwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:92:e0'],
                                                                                       'in_nucast_pkts': '114326',
                                                                                       'in_octets': '116923921474',
                                                                                       'in_ucast_pkts': '644934805',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '9678',
                                                                                       'out_octets': '2824710093476',
                                                                                       'out_ucast_pkts': '2018653090',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTU4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:02:f0'],
                                                                                       'in_nucast_pkts': '178527',
                                                                                       'in_octets': '19649965190',
                                                                                       'in_ucast_pkts': '37384091',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5952',
                                                                                       'out_octets': '72406994171',
                                                                                       'out_ucast_pkts': '64572035',
                                                                                       'poller_hash': 'QURUTjIzMTI1MEREIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:65:a0'],
                                                                                       'in_nucast_pkts': '181960',
                                                                                       'in_octets': '118797021115',
                                                                                       'in_ucast_pkts': '220053985',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15383',
                                                                                       'out_octets': '700092925660',
                                                                                       'out_ucast_pkts': '526170506',
                                                                                       'poller_hash': 'QURUTjIzMTI1MEJCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:ce:70'],
                                                                                       'in_nucast_pkts': '178708',
                                                                                       'in_octets': '78648404371',
                                                                                       'in_ucast_pkts': '538668066',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5952',
                                                                                       'out_octets': '2649428185093',
                                                                                       'out_ucast_pkts': '1818879008',
                                                                                       'poller_hash': 'QURUTjIzMTQ0Nzk2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:84:90'],
                                                                                       'in_nucast_pkts': '67546',
                                                                                       'in_octets': '30381695416',
                                                                                       'in_ucast_pkts': '148236549',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '5627',
                                                                                       'out_octets': '731272078042',
                                                                                       'out_ucast_pkts': '522495069',
                                                                                       'poller_hash': 'QURUTjIzMTQ0ODZDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:78:80'],
                                                                                       'in_nucast_pkts': '183326',
                                                                                       'in_octets': '31927005547',
                                                                                       'in_ucast_pkts': '73791556',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15369',
                                                                                       'out_octets': '148961018578',
                                                                                       'out_ucast_pkts': '130331928',
                                                                                       'poller_hash': 'QURUTjIzMTQ0Njk5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8a:50'],
                                                                                       'in_nucast_pkts': '53275',
                                                                                       'in_octets': '66181121606',
                                                                                       'in_ucast_pkts': '251617020',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '4507',
                                                                                       'out_octets': '975716368421',
                                                                                       'out_ucast_pkts': '706761030',
                                                                                       'poller_hash': 'QURUTjIzMTQ0Q0MzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:f1:00'],
                                                                                       'in_nucast_pkts': '105741',
                                                                                       'in_octets': '125867370590',
                                                                                       'in_ucast_pkts': '380855656',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3662',
                                                                                       'out_octets': '1578961306528',
                                                                                       'out_ucast_pkts': '1164173803',
                                                                                       'poller_hash': 'QURUTjIzMTI0MjE0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:a9:00'],
                                                                                       'in_nucast_pkts': '16418',
                                                                                       'in_octets': '8947474311',
                                                                                       'in_ucast_pkts': '11200592',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '548',
                                                                                       'out_octets': '30754950510',
                                                                                       'out_ucast_pkts': '24258646',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QzRFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:fd:b0'],
                                                                                       'in_nucast_pkts': '16436',
                                                                                       'in_octets': '7606830915',
                                                                                       'in_ucast_pkts': '17153075',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '549',
                                                                                       'out_octets': '59503336499',
                                                                                       'out_ucast_pkts': '44103819',
                                                                                       'poller_hash': 'QURUTjI0MzE0NEZCIHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/6',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC82',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/6',
                                                                                      'id': 'xgspon '
                                                                                            '0/6',
                                                                                      'links': [       {       'connected_time': '4773323',
                                                                                                               'fiber_length': 10820,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDYxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4625},
                                                                                                       {       'connected_time': '2232590',
                                                                                                               'fiber_length': 10756,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTcxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4625},
                                                                                                       {       'connected_time': '5355629',
                                                                                                               'fiber_length': 9016,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTUyIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4625},
                                                                                                       {       'connected_time': '2658219',
                                                                                                               'fiber_length': 10425,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTREIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4625},
                                                                                                       {       'connected_time': '359118',
                                                                                                               'fiber_length': 10462,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTZBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4625},
                                                                                                       {       'connected_time': '4773324',
                                                                                                               'fiber_length': 10872,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NDVDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4625},
                                                                                                       {       'connected_time': '756858',
                                                                                                               'fiber_length': 9328,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NEJDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4625},
                                                                                                       {       'connected_time': '5355629',
                                                                                                               'fiber_length': 9589,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTNBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4625},
                                                                                                       {       'connected_time': '5355630',
                                                                                                               'fiber_length': 10748,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MUMwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4625},
                                                                                                       {       'connected_time': '3371909',
                                                                                                               'fiber_length': 10811,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTU4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4625},
                                                                                                       {       'connected_time': '5355597',
                                                                                                               'fiber_length': 8976,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MEREIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4625},
                                                                                                       {       'connected_time': '5355597',
                                                                                                               'fiber_length': 8993,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MEJCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4625},
                                                                                                       {       'connected_time': '5355628',
                                                                                                               'fiber_length': 9375,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0Nzk2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4625},
                                                                                                       {       'connected_time': '1960821',
                                                                                                               'fiber_length': 10744,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0ODZDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4625},
                                                                                                       {       'connected_time': '5355629',
                                                                                                               'fiber_length': 8892,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0Njk5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4625},
                                                                                                       {       'connected_time': '1571617',
                                                                                                               'fiber_length': 10521,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0Q0MzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4625},
                                                                                                       {       'connected_time': '3147736',
                                                                                                               'fiber_length': 9856,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MjE0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4625},
                                                                                                       {       'connected_time': '491760',
                                                                                                               'fiber_length': 10106,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QzRFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4625},
                                                                                                       {       'connected_time': '492326',
                                                                                                               'fiber_length': 10046,
                                                                                                               'poller_hash': 'QURUTjI0MzE0NEZCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.4625}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/6',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC82',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/7',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:dd:73:50'],
                                                                                       'in_nucast_pkts': '14488',
                                                                                       'in_octets': '11123096046',
                                                                                       'in_ucast_pkts': '13511000',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '30079611459',
                                                                                       'out_ucast_pkts': '25371278',
                                                                                       'poller_hash': 'QURUTjIzMTI0REZCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:75:a0'],
                                                                                       'in_nucast_pkts': '14487',
                                                                                       'in_octets': '3409732582',
                                                                                       'in_ucast_pkts': '24706889',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '69705065738',
                                                                                       'out_ucast_pkts': '48123549',
                                                                                       'poller_hash': 'QURUTjIzMTI0REM3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:76:a0'],
                                                                                       'in_nucast_pkts': '11102',
                                                                                       'in_octets': '8102513606',
                                                                                       'in_ucast_pkts': '28691963',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '938',
                                                                                       'out_octets': '80493637516',
                                                                                       'out_ucast_pkts': '57497526',
                                                                                       'poller_hash': 'QURUTjIzMTI0RUZBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:81:80'],
                                                                                       'in_nucast_pkts': '14711',
                                                                                       'in_octets': '6058566606',
                                                                                       'in_ucast_pkts': '14324366',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '56384755529',
                                                                                       'out_ucast_pkts': '43173980',
                                                                                       'poller_hash': 'QURUTjIzMTI0RURGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:79:10'],
                                                                                       'in_nucast_pkts': '14487',
                                                                                       'in_octets': '1408453082',
                                                                                       'in_ucast_pkts': '7039557',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '16740090927',
                                                                                       'out_ucast_pkts': '12732063',
                                                                                       'poller_hash': 'QURUTjIzMTI1MUY3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:71:e0'],
                                                                                       'in_nucast_pkts': '14489',
                                                                                       'in_octets': '17033134539',
                                                                                       'in_ucast_pkts': '38082733',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '83737263849',
                                                                                       'out_ucast_pkts': '65683823',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTg0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:08:10'],
                                                                                       'in_nucast_pkts': '14491',
                                                                                       'in_octets': '50179152392',
                                                                                       'in_ucast_pkts': '165755454',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '509052632069',
                                                                                       'out_ucast_pkts': '368118322',
                                                                                       'poller_hash': 'QURUTjIzMTI1MUY2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:32:11'],
                                                                                       'in_nucast_pkts': '264',
                                                                                       'in_octets': '16626695046',
                                                                                       'in_ucast_pkts': '31430246',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '110967086335',
                                                                                       'out_ucast_pkts': '87932377',
                                                                                       'poller_hash': 'QURUTjIzMTI0RUQzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:07:b0'],
                                                                                       'in_nucast_pkts': '14486',
                                                                                       'in_octets': '454089503',
                                                                                       'in_ucast_pkts': '1098388',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '2165466570',
                                                                                       'out_ucast_pkts': '1700019',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTQzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:04:10'],
                                                                                       'in_nucast_pkts': '14486',
                                                                                       'in_octets': '46466954692',
                                                                                       'in_ucast_pkts': '162384018',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '629137532340',
                                                                                       'out_ucast_pkts': '440714131',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTAzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8e:b0'],
                                                                                       'in_nucast_pkts': '14494',
                                                                                       'in_octets': '6049417954',
                                                                                       'in_ucast_pkts': '34033927',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1226',
                                                                                       'out_octets': '211119778048',
                                                                                       'out_ucast_pkts': '156321241',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTJFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:07:60'],
                                                                                       'in_nucast_pkts': '14494',
                                                                                       'in_octets': '4484194474',
                                                                                       'in_ucast_pkts': '25912450',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1226',
                                                                                       'out_octets': '193882004883',
                                                                                       'out_ucast_pkts': '132819587',
                                                                                       'poller_hash': 'QURUTjIzMTQ0ODNCIHBlZXJpbnRm'},
                                                                               {       'in_nucast_pkts': '29989',
                                                                                       'in_octets': '1221926735',
                                                                                       'in_ucast_pkts': '1237098',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '451',
                                                                                       'out_octets': '1213350778',
                                                                                       'out_ucast_pkts': '1231323',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NzQ4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:b3:a0'],
                                                                                       'in_nucast_pkts': '14261',
                                                                                       'in_octets': '4585573724',
                                                                                       'in_ucast_pkts': '15384444',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '54811201689',
                                                                                       'out_ucast_pkts': '43212303',
                                                                                       'poller_hash': 'QURUTjIzMTQ0OEQxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8a:10'],
                                                                                       'in_nucast_pkts': '14493',
                                                                                       'in_octets': '4479141903',
                                                                                       'in_ucast_pkts': '41446317',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '130555458155',
                                                                                       'out_ucast_pkts': '89477649',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTlDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:3c:30'],
                                                                                       'in_nucast_pkts': '9115',
                                                                                       'in_octets': '2830692519',
                                                                                       'in_ucast_pkts': '22765801',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '772',
                                                                                       'out_octets': '70890071883',
                                                                                       'out_ucast_pkts': '48865187',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QjJDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:93:c0'],
                                                                                       'in_nucast_pkts': '14490',
                                                                                       'in_octets': '351591502',
                                                                                       'in_ucast_pkts': '528810',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '372614589',
                                                                                       'out_ucast_pkts': '498076',
                                                                                       'poller_hash': 'QURUTjIzMTQ0Q0Q1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:75:00'],
                                                                                       'in_nucast_pkts': '14481',
                                                                                       'in_octets': '3791904941',
                                                                                       'in_ucast_pkts': '8423097',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1225',
                                                                                       'out_octets': '25578469812',
                                                                                       'out_ucast_pkts': '20420027',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QzQ2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:9c:b0'],
                                                                                       'in_nucast_pkts': '14260',
                                                                                       'in_octets': '18330245862',
                                                                                       'in_ucast_pkts': '46570425',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '133623055334',
                                                                                       'out_ucast_pkts': '99196688',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QjREIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:d0:70'],
                                                                                       'in_nucast_pkts': '8972',
                                                                                       'in_octets': '1209998692',
                                                                                       'in_ucast_pkts': '5042376',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '300',
                                                                                       'out_octets': '17772443257',
                                                                                       'out_ucast_pkts': '13503826',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTcwIHBlZXJpbnRm'},
                                                                               {       'in_nucast_pkts': '0',
                                                                                       'in_octets': '0',
                                                                                       'in_ucast_pkts': '0',
                                                                                       'oper_up': False,
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '0',
                                                                                       'out_ucast_pkts': '0',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RjAwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:51:30'],
                                                                                       'in_nucast_pkts': '14258',
                                                                                       'in_octets': '5556961097',
                                                                                       'in_ucast_pkts': '44970447',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '137130796457',
                                                                                       'out_ucast_pkts': '99273180',
                                                                                       'poller_hash': 'QURUTjIzMTI0N0ExIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:26:a0'],
                                                                                       'in_nucast_pkts': '14260',
                                                                                       'in_octets': '4745824547',
                                                                                       'in_ucast_pkts': '28323993',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '91040367405',
                                                                                       'out_ucast_pkts': '63611691',
                                                                                       'poller_hash': 'QURUTjIzMTI0QzZBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:ac:60'],
                                                                                       'in_nucast_pkts': '14413',
                                                                                       'in_octets': '3836087366',
                                                                                       'in_ucast_pkts': '47521683',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '150917148362',
                                                                                       'out_ucast_pkts': '100852685',
                                                                                       'poller_hash': 'QURUTjI0MzYzREM5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:27:10'],
                                                                                       'in_nucast_pkts': '12315',
                                                                                       'in_octets': '24721684604',
                                                                                       'in_ucast_pkts': '136340685',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '411',
                                                                                       'out_octets': '411841066531',
                                                                                       'out_ucast_pkts': '304654174',
                                                                                       'poller_hash': 'QURUTjI0MzE0MzE0IHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/7',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC83',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/7',
                                                                                      'id': 'xgspon '
                                                                                            '0/7',
                                                                                      'links': [       {       'connected_time': '427037',
                                                                                                               'fiber_length': 2183,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REZCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427037',
                                                                                                               'fiber_length': 2394,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REM3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '327189',
                                                                                                               'fiber_length': 2496,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RUZBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427037',
                                                                                                               'fiber_length': 3018,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RURGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427035',
                                                                                                               'fiber_length': 2254,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MUY3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427038',
                                                                                                               'fiber_length': 3256,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTg0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427036',
                                                                                                               'fiber_length': 2382,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MUY2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427033',
                                                                                                               'fiber_length': 2629,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RUQzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427033',
                                                                                                               'fiber_length': 3430,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTQzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427036',
                                                                                                               'fiber_length': 3301,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTAzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427036',
                                                                                                               'fiber_length': 3383,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTJFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427033',
                                                                                                               'fiber_length': 2182,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0ODNCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427035',
                                                                                                               'fiber_length': 3353,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NzQ4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427031',
                                                                                                               'fiber_length': 2661,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0OEQxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427035',
                                                                                                               'fiber_length': 3282,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTlDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '268464',
                                                                                                               'fiber_length': 4011,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QjJDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427035',
                                                                                                               'fiber_length': 3249,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0Q0Q1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427030',
                                                                                                               'fiber_length': 2665,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QzQ2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427035',
                                                                                                               'fiber_length': 3298,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QjREIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '268464',
                                                                                                               'fiber_length': 3865,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTcwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427029',
                                                                                                               'fiber_length': 3323,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RjAwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427039',
                                                                                                               'fiber_length': 3094,
                                                                                                               'poller_hash': 'QURUTjIzMTI0N0ExIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427039',
                                                                                                               'fiber_length': 3062,
                                                                                                               'poller_hash': 'QURUTjIzMTI0QzZBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '427043',
                                                                                                               'fiber_length': 3347,
                                                                                                               'poller_hash': 'QURUTjI0MzYzREM5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429},
                                                                                                       {       'connected_time': '368685',
                                                                                                               'fiber_length': 3270,
                                                                                                               'poller_hash': 'QURUTjI0MzE0MzE0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.429}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/7',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC83',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/8',
                                                              'links': [       {       'bridged_mac_addresses': [       '38:f8:f6:52:a9:50'],
                                                                                       'in_nucast_pkts': '14745',
                                                                                       'in_octets': '27560742812',
                                                                                       'in_ucast_pkts': '124826761',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1226',
                                                                                       'out_octets': '441183690755',
                                                                                       'out_ucast_pkts': '317382052',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDkxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:7e:50'],
                                                                                       'in_nucast_pkts': '14487',
                                                                                       'in_octets': '5327360268',
                                                                                       'in_ucast_pkts': '12580045',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '52274437849',
                                                                                       'out_ucast_pkts': '41675343',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTdBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:b1:c0'],
                                                                                       'in_nucast_pkts': '14846',
                                                                                       'in_octets': '77541879154',
                                                                                       'in_ucast_pkts': '144166953',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '363149263500',
                                                                                       'out_ucast_pkts': '278103635',
                                                                                       'poller_hash': 'QURUTjIzMTIzRTlDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:9c:b0'],
                                                                                       'in_nucast_pkts': '14613',
                                                                                       'in_octets': '37044453415',
                                                                                       'in_ucast_pkts': '60328336',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '186031888166',
                                                                                       'out_ucast_pkts': '144934536',
                                                                                       'poller_hash': 'QURUTjIzMTI0REVCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:87:80'],
                                                                                       'in_nucast_pkts': '14488',
                                                                                       'in_octets': '7182857775',
                                                                                       'in_ucast_pkts': '36284466',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '102633796554',
                                                                                       'out_ucast_pkts': '77660339',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDkzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:b4:c0'],
                                                                                       'in_nucast_pkts': '14259',
                                                                                       'in_octets': '8477882963',
                                                                                       'in_ucast_pkts': '18924820',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '84457489770',
                                                                                       'out_ucast_pkts': '65016933',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDQ2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:88:60'],
                                                                                       'in_nucast_pkts': '14487',
                                                                                       'in_octets': '7352355370',
                                                                                       'in_ucast_pkts': '32956583',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '201948414523',
                                                                                       'out_ucast_pkts': '142178378',
                                                                                       'poller_hash': 'QURUTjIzMTI0OTFFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8a:b1'],
                                                                                       'in_nucast_pkts': '342',
                                                                                       'in_octets': '9898390739',
                                                                                       'in_ucast_pkts': '22190380',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '80594217954',
                                                                                       'out_ucast_pkts': '61996459',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTNBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:7d:c0'],
                                                                                       'in_nucast_pkts': '14846',
                                                                                       'in_octets': '10434238744',
                                                                                       'in_ucast_pkts': '50310389',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '257756685243',
                                                                                       'out_ucast_pkts': '190759006',
                                                                                       'poller_hash': 'QURUTjIzMTI0REYzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:74:b0'],
                                                                                       'in_nucast_pkts': '14487',
                                                                                       'in_octets': '790422525',
                                                                                       'in_ucast_pkts': '2958689',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '7130903493',
                                                                                       'out_ucast_pkts': '5656972',
                                                                                       'poller_hash': 'QURUTjIzMTI1MThFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:2a:40'],
                                                                                       'in_nucast_pkts': '14845',
                                                                                       'in_octets': '12476280102',
                                                                                       'in_ucast_pkts': '51926230',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '266208528670',
                                                                                       'out_ucast_pkts': '191938908',
                                                                                       'poller_hash': 'QURUTjIzMTI0RENFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8d:d0'],
                                                                                       'in_nucast_pkts': '14487',
                                                                                       'in_octets': '1975280843',
                                                                                       'in_ucast_pkts': '6538177',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '17893158561',
                                                                                       'out_ucast_pkts': '14760521',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTIyIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:db:66:60'],
                                                                                       'in_nucast_pkts': '14845',
                                                                                       'in_octets': '11065164565',
                                                                                       'in_ucast_pkts': '73336480',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '276809440559',
                                                                                       'out_ucast_pkts': '202956573',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDlFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8a:c0'],
                                                                                       'in_nucast_pkts': '14515',
                                                                                       'in_octets': '3639779298',
                                                                                       'in_ucast_pkts': '7358348',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '26974714761',
                                                                                       'out_ucast_pkts': '22277576',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTJEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:24:f0'],
                                                                                       'in_nucast_pkts': '3685',
                                                                                       'in_octets': '5017196441',
                                                                                       'in_ucast_pkts': '12594970',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '312',
                                                                                       'out_octets': '43937685021',
                                                                                       'out_ucast_pkts': '32852011',
                                                                                       'poller_hash': 'QURUTjIzMTI0RERGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ad:50'],
                                                                                       'in_nucast_pkts': '14258',
                                                                                       'in_octets': '8179937368',
                                                                                       'in_ucast_pkts': '48036719',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '197105393156',
                                                                                       'out_ucast_pkts': '143812436',
                                                                                       'poller_hash': 'QURUTjIzMTI0MDhDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:73:90'],
                                                                                       'in_nucast_pkts': '14487',
                                                                                       'in_octets': '41206052671',
                                                                                       'in_ucast_pkts': '67857055',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '212344229386',
                                                                                       'out_ucast_pkts': '157460453',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDFEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:6e:20'],
                                                                                       'in_nucast_pkts': '14496',
                                                                                       'in_octets': '7685322089',
                                                                                       'in_ucast_pkts': '61007810',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '289160274295',
                                                                                       'out_ucast_pkts': '198393026',
                                                                                       'poller_hash': 'QURUTjIzMTI0REY1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:88:c0'],
                                                                                       'in_nucast_pkts': '14487',
                                                                                       'in_octets': '11594417795',
                                                                                       'in_ucast_pkts': '74432212',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '237652363977',
                                                                                       'out_ucast_pkts': '165639326',
                                                                                       'poller_hash': 'QURUTjIzMTI0NzEzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:7b:70'],
                                                                                       'in_nucast_pkts': '14779',
                                                                                       'in_octets': '11099335936',
                                                                                       'in_ucast_pkts': '67664231',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '185374996354',
                                                                                       'out_ucast_pkts': '129135376',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTE5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:82:00'],
                                                                                       'in_nucast_pkts': '14488',
                                                                                       'in_octets': '3843776317',
                                                                                       'in_ucast_pkts': '11663473',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '54436132368',
                                                                                       'out_ucast_pkts': '43264779',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTY3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:83:40'],
                                                                                       'in_nucast_pkts': '14538',
                                                                                       'in_octets': '19593481234',
                                                                                       'in_ucast_pkts': '59439003',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1229',
                                                                                       'out_octets': '246726206538',
                                                                                       'out_ucast_pkts': '183721766',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTNGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:03:e0'],
                                                                                       'in_nucast_pkts': '14687',
                                                                                       'in_octets': '16436354372',
                                                                                       'in_ucast_pkts': '47215406',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '487',
                                                                                       'out_octets': '132008364272',
                                                                                       'out_ucast_pkts': '102344793',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTIzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:70:f0'],
                                                                                       'in_nucast_pkts': '14493',
                                                                                       'in_octets': '7921703286',
                                                                                       'in_ucast_pkts': '58170493',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '169020056180',
                                                                                       'out_ucast_pkts': '133811964',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTI3IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4b:fa:00'],
                                                                                       'in_nucast_pkts': '14260',
                                                                                       'in_octets': '6557138016',
                                                                                       'in_ucast_pkts': '37645152',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '163595952937',
                                                                                       'out_ucast_pkts': '114245219',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTY0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:87:c0'],
                                                                                       'in_nucast_pkts': '14490',
                                                                                       'in_octets': '3504213634',
                                                                                       'in_ucast_pkts': '17893442',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '60693102340',
                                                                                       'out_ucast_pkts': '43963678',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTZCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:4c:03:d0'],
                                                                                       'in_nucast_pkts': '2283',
                                                                                       'in_octets': '217397666',
                                                                                       'in_ucast_pkts': '576131',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '76',
                                                                                       'out_octets': '699514356',
                                                                                       'out_ucast_pkts': '834306',
                                                                                       'poller_hash': 'QURUTjIzMTIzRkVDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:88:b0'],
                                                                                       'in_nucast_pkts': '14491',
                                                                                       'in_octets': '1222611241',
                                                                                       'in_ucast_pkts': '4483675',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '14554324780',
                                                                                       'out_ucast_pkts': '11327632',
                                                                                       'poller_hash': 'QURUTjIzMTIzRUE4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8b:c0'],
                                                                                       'in_nucast_pkts': '14488',
                                                                                       'in_octets': '2563843765',
                                                                                       'in_ucast_pkts': '23288569',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '94069604523',
                                                                                       'out_ucast_pkts': '65745034',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTFGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:82:30'],
                                                                                       'in_nucast_pkts': '14489',
                                                                                       'in_octets': '4871916230',
                                                                                       'in_ucast_pkts': '19295162',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '53219380465',
                                                                                       'out_ucast_pkts': '46179521',
                                                                                       'poller_hash': 'QURUTjIzMTI0MTI4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:86:d1'],
                                                                                       'in_nucast_pkts': '265',
                                                                                       'in_octets': '9081539991',
                                                                                       'in_ucast_pkts': '24965850',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '102797141730',
                                                                                       'out_ucast_pkts': '72870428',
                                                                                       'poller_hash': 'QURUTjIzMTQ0N0E0IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:04:e0'],
                                                                                       'in_nucast_pkts': '14259',
                                                                                       'in_octets': '9556335117',
                                                                                       'in_ucast_pkts': '22133906',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '62700366416',
                                                                                       'out_ucast_pkts': '51739233',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTY5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:3b:c0'],
                                                                                       'in_nucast_pkts': '14487',
                                                                                       'in_octets': '31752714694',
                                                                                       'in_ucast_pkts': '44450073',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '81359961853',
                                                                                       'out_ucast_pkts': '65945504',
                                                                                       'poller_hash': 'QURUTjIzMTI0MDA4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:b7:d0'],
                                                                                       'in_nucast_pkts': '14260',
                                                                                       'in_octets': '17809587612',
                                                                                       'in_ucast_pkts': '67320477',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '270026241546',
                                                                                       'out_ucast_pkts': '199676509',
                                                                                       'poller_hash': 'QURUTjIzMTQ0RUQzIHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/8',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC84',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/8',
                                                                                      'id': 'xgspon '
                                                                                            '0/8',
                                                                                      'links': [       {       'connected_time': '427021',
                                                                                                               'fiber_length': 5783,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDkxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427033',
                                                                                                               'fiber_length': 5853,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTdBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427040',
                                                                                                               'fiber_length': 5669,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRTlDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427035',
                                                                                                               'fiber_length': 3861,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REVCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427024',
                                                                                                               'fiber_length': 4090,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDkzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427036',
                                                                                                               'fiber_length': 4612,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDQ2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427022',
                                                                                                               'fiber_length': 5476,
                                                                                                               'poller_hash': 'QURUTjIzMTI0OTFFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427025',
                                                                                                               'fiber_length': 5824,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTNBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427040',
                                                                                                               'fiber_length': 3643,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REYzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427024',
                                                                                                               'fiber_length': 3909,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MThFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427035',
                                                                                                               'fiber_length': 5338,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RENFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427034',
                                                                                                               'fiber_length': 3743,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTIyIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427035',
                                                                                                               'fiber_length': 4273,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDlFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427034',
                                                                                                               'fiber_length': 4867,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTJEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '108153',
                                                                                                               'fiber_length': 4825,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RERGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427027',
                                                                                                               'fiber_length': 5423,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MDhDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427032',
                                                                                                               'fiber_length': 4938,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDFEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427034',
                                                                                                               'fiber_length': 5198,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REY1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -23.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427026',
                                                                                                               'fiber_length': 5184,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NzEzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427040',
                                                                                                               'fiber_length': 5202,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTE5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427038',
                                                                                                               'fiber_length': 5100,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTY3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427039',
                                                                                                               'fiber_length': 5421,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTNGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427039',
                                                                                                               'fiber_length': 4748,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTIzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427035',
                                                                                                               'fiber_length': 4716,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTI3IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427034',
                                                                                                               'fiber_length': 4657,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTY0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -20.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427034',
                                                                                                               'fiber_length': 5879,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTZCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '68291',
                                                                                                               'fiber_length': 5819,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRkVDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427036',
                                                                                                               'fiber_length': 4449,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRUE4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427039',
                                                                                                               'fiber_length': 4391,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTFGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427040',
                                                                                                               'fiber_length': 5794,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MTI4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427032',
                                                                                                               'fiber_length': 5397,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0N0E0IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.1,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427038',
                                                                                                               'fiber_length': 4383,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTY5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427040',
                                                                                                               'fiber_length': 5786,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MDA4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541},
                                                                                                       {       'connected_time': '427025',
                                                                                                               'fiber_length': 5736,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0RUQzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -21.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.2541}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/8',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC84',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': True,
                                                              'id': '0/9',
                                                              'links': [       {       'bridged_mac_addresses': [       'cc:66:18:dc:88:30'],
                                                                                       'in_nucast_pkts': '14488',
                                                                                       'in_octets': '10550726467',
                                                                                       'in_ucast_pkts': '78959047',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '372201121743',
                                                                                       'out_ucast_pkts': '254564839',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDY4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:88:a0'],
                                                                                       'in_nucast_pkts': '14491',
                                                                                       'in_octets': '2971603812',
                                                                                       'in_ucast_pkts': '6478397',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '32270863710',
                                                                                       'out_ucast_pkts': '26537850',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTE4IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:81:d0'],
                                                                                       'in_nucast_pkts': '114032',
                                                                                       'in_octets': '34146902875',
                                                                                       'in_ucast_pkts': '130691237',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '9654',
                                                                                       'out_octets': '471523767208',
                                                                                       'out_ucast_pkts': '370552154',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDU1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:81:e0'],
                                                                                       'in_nucast_pkts': '114027',
                                                                                       'in_octets': '48597335655',
                                                                                       'in_ucast_pkts': '274600145',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '9650',
                                                                                       'out_octets': '1294769624337',
                                                                                       'out_ucast_pkts': '894488302',
                                                                                       'poller_hash': 'QURUTjIzMTI0NjUwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:7d:00'],
                                                                                       'in_nucast_pkts': '21619',
                                                                                       'in_octets': '5281560674',
                                                                                       'in_ucast_pkts': '11555894',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1828',
                                                                                       'out_octets': '37139094766',
                                                                                       'out_ucast_pkts': '31182483',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDIwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:74:90'],
                                                                                       'in_nucast_pkts': '182420',
                                                                                       'in_octets': '61330425016',
                                                                                       'in_ucast_pkts': '233445066',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '15381',
                                                                                       'out_octets': '863383765062',
                                                                                       'out_ucast_pkts': '644759562',
                                                                                       'poller_hash': 'QURUTjIzMTI0RDdFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:80:50'],
                                                                                       'in_nucast_pkts': '14474',
                                                                                       'in_octets': '9698208206',
                                                                                       'in_ucast_pkts': '63773063',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1224',
                                                                                       'out_octets': '245329448787',
                                                                                       'out_ucast_pkts': '170570158',
                                                                                       'poller_hash': 'QURUTjIzMTI0REIyIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:68:b0'],
                                                                                       'in_nucast_pkts': '14492',
                                                                                       'in_octets': '2697660819',
                                                                                       'in_ucast_pkts': '10709779',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '43209532271',
                                                                                       'out_ucast_pkts': '33612964',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTI5IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:7c:d0'],
                                                                                       'in_nucast_pkts': '14496',
                                                                                       'in_octets': '6562879945',
                                                                                       'in_ucast_pkts': '44066207',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '250735238169',
                                                                                       'out_ucast_pkts': '178667406',
                                                                                       'poller_hash': 'QURUTjIzMTI0MUQwIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:ac:d0'],
                                                                                       'in_nucast_pkts': '14611',
                                                                                       'in_octets': '10465029520',
                                                                                       'in_ucast_pkts': '32886879',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '178250999676',
                                                                                       'out_ucast_pkts': '132715489',
                                                                                       'poller_hash': 'QURUTjIzMTI0REJDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '38:f8:f6:52:b2:80'],
                                                                                       'in_nucast_pkts': '14258',
                                                                                       'in_octets': '4222787347',
                                                                                       'in_ucast_pkts': '10744367',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '476',
                                                                                       'out_octets': '31820503360',
                                                                                       'out_ucast_pkts': '28427247',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTJCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:23:20'],
                                                                                       'in_nucast_pkts': '53346',
                                                                                       'in_octets': '71092519004',
                                                                                       'in_ucast_pkts': '217419329',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '4406',
                                                                                       'out_octets': '911286037291',
                                                                                       'out_ucast_pkts': '655351516',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTdGIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:7f:60'],
                                                                                       'in_nucast_pkts': '14487',
                                                                                       'in_octets': '22467858323',
                                                                                       'in_ucast_pkts': '66788495',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '192046021310',
                                                                                       'out_ucast_pkts': '146416225',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTVCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:6a:40'],
                                                                                       'in_nucast_pkts': '14495',
                                                                                       'in_octets': '10077191716',
                                                                                       'in_ucast_pkts': '46633002',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '121818231744',
                                                                                       'out_ucast_pkts': '104751984',
                                                                                       'poller_hash': 'QURUTjIzMTI1MUIxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:51:30:c0'],
                                                                                       'in_nucast_pkts': '112169',
                                                                                       'in_octets': '21016518482',
                                                                                       'in_ucast_pkts': '99931401',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3740',
                                                                                       'out_octets': '441127091202',
                                                                                       'out_ucast_pkts': '309978043',
                                                                                       'poller_hash': 'QURUTjIzMTI0RThBIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:4f:90'],
                                                                                       'in_nucast_pkts': '112172',
                                                                                       'in_octets': '29451437801',
                                                                                       'in_ucast_pkts': '146969540',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3740',
                                                                                       'out_octets': '477818042319',
                                                                                       'out_ucast_pkts': '349944811',
                                                                                       'poller_hash': 'QURUTjIzMTI1MDY1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:8f:50'],
                                                                                       'in_nucast_pkts': '14491',
                                                                                       'in_octets': '25747209778',
                                                                                       'in_ucast_pkts': '86361868',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '258710619021',
                                                                                       'out_ucast_pkts': '205310075',
                                                                                       'poller_hash': 'QURUTjIzMTIzRTlEIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:08:30'],
                                                                                       'in_nucast_pkts': '14843',
                                                                                       'in_octets': '86559397424',
                                                                                       'in_ucast_pkts': '191752268',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '511160420142',
                                                                                       'out_ucast_pkts': '393278257',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTMzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:03:40'],
                                                                                       'in_nucast_pkts': '114024',
                                                                                       'in_octets': '132343926606',
                                                                                       'in_ucast_pkts': '358229940',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '9652',
                                                                                       'out_octets': '1077935386793',
                                                                                       'out_ucast_pkts': '789288784',
                                                                                       'poller_hash': 'QURUTjIzMTI0RTQzIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d5:fd:61'],
                                                                                       'in_nucast_pkts': '261',
                                                                                       'in_octets': '5627074010',
                                                                                       'in_ucast_pkts': '41991202',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '198998846990',
                                                                                       'out_ucast_pkts': '135593488',
                                                                                       'poller_hash': 'QURUTjIzMTI0NDkxIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:88:70'],
                                                                                       'in_nucast_pkts': '114024',
                                                                                       'in_octets': '171519733498',
                                                                                       'in_ucast_pkts': '490137850',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '9650',
                                                                                       'out_octets': '1102102393438',
                                                                                       'out_ucast_pkts': '920098124',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTBCIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:d6:0c:90'],
                                                                                       'in_nucast_pkts': '114060',
                                                                                       'in_octets': '89909882389',
                                                                                       'in_ucast_pkts': '158297701',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '9654',
                                                                                       'out_octets': '404682300236',
                                                                                       'out_ucast_pkts': '317195659',
                                                                                       'poller_hash': 'QURUTjIzMTQ0OEQ1IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '08:55:31:e1:ea:4b',
                                                                                                                        '18:e8:29:34:ed:33',
                                                                                                                        '18:e8:29:36:d4:71',
                                                                                                                        '18:e8:29:3a:1a:3d',
                                                                                                                        '18:e8:29:8e:ed:6f',
                                                                                                                        '18:e8:29:8e:ed:78',
                                                                                                                        '18:e8:29:8e:f1:06',
                                                                                                                        '24:5a:4c:e4:c8:a1',
                                                                                                                        '74:83:c2:a6:5a:93',
                                                                                                                        '74:83:c2:a6:7f:9f',
                                                                                                                        '74:83:c2:a6:86:4e',
                                                                                                                        '74:83:c2:e8:a2:61',
                                                                                                                        '74:83:c2:ea:a6:01',
                                                                                                                        '74:83:c2:ea:a6:28',
                                                                                                                        '74:83:c2:ec:11:8b',
                                                                                                                        '74:ac:b9:80:d4:53',
                                                                                                                        '94:a6:7e:dd:ad:81',
                                                                                                                        'b4:fb:e4:5a:4f:8e',
                                                                                                                        'b8:94:70:f8:2b:2a',
                                                                                                                        'dc:2c:6e:dd:2e:26',
                                                                                                                        'f4:92:bf:38:a5:74',
                                                                                                                        'f4:92:bf:38:a7:25',
                                                                                                                        'f4:92:bf:38:a7:c2',
                                                                                                                        'f4:92:bf:d6:a8:ac'],
                                                                                       'in_nucast_pkts': '7995507',
                                                                                       'in_octets': '1858309971876',
                                                                                       'in_ucast_pkts': '9243126879',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '153208',
                                                                                       'out_octets': '28429412683572',
                                                                                       'out_ucast_pkts': '21092874583',
                                                                                       'poller_hash': 'QURUTjIzMTQ0QTg2IHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dc:b3:c0'],
                                                                                       'in_nucast_pkts': '37592',
                                                                                       'in_octets': '12713140314',
                                                                                       'in_ucast_pkts': '33577218',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '3182',
                                                                                       'out_octets': '98263455711',
                                                                                       'out_ucast_pkts': '84012258',
                                                                                       'poller_hash': 'QURUTjIzMTQ0N0FDIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:dd:87:20'],
                                                                                       'in_nucast_pkts': '14492',
                                                                                       'in_octets': '9889045754',
                                                                                       'in_ucast_pkts': '57345105',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '1227',
                                                                                       'out_octets': '242042243181',
                                                                                       'out_ucast_pkts': '170513907',
                                                                                       'poller_hash': 'QURUTjIzMTQ0NjlFIHBlZXJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'cc:66:18:50:3e:d0'],
                                                                                       'in_nucast_pkts': '84975',
                                                                                       'in_octets': '45699713263',
                                                                                       'in_ucast_pkts': '190445833',
                                                                                       'oper_up': True,
                                                                                       'out_nucast_pkts': '2784',
                                                                                       'out_octets': '579520275565',
                                                                                       'out_ucast_pkts': '418521378',
                                                                                       'poller_hash': 'QURUTjIzMTI1MTM1IHBlZXJpbnRm'}],
                                                              'manufacturer': 'Adtran',
                                                              'model': '1442544F2',
                                                              'name': '0/9',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC85',
                                                              'pons': [       {       'description': 'xgspon '
                                                                                                     '0/9',
                                                                                      'id': 'xgspon '
                                                                                            '0/9',
                                                                                      'links': [       {       'connected_time': '427041',
                                                                                                               'fiber_length': 5677,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDY4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '427040',
                                                                                                               'fiber_length': 6613,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTE4IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '3364586',
                                                                                                               'fiber_length': 6229,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDU1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '3364583',
                                                                                                               'fiber_length': 5972,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NjUwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '637514',
                                                                                                               'fiber_length': 5554,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDIwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '5355633',
                                                                                                               'fiber_length': 6288,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RDdFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.3,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '427041',
                                                                                                               'fiber_length': 5688,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REIyIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.4,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '427041',
                                                                                                               'fiber_length': 5757,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTI5IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '427037',
                                                                                                               'fiber_length': 5845,
                                                                                                               'poller_hash': 'QURUTjIzMTI0MUQwIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '427041',
                                                                                                               'fiber_length': 6895,
                                                                                                               'poller_hash': 'QURUTjIzMTI0REJDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '427039',
                                                                                                               'fiber_length': 5938,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTJCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.7,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '1535983',
                                                                                                               'fiber_length': 7112,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTdGIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '427039',
                                                                                                               'fiber_length': 6916,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTVCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '427037',
                                                                                                               'fiber_length': 6439,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MUIxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.8,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '3364584',
                                                                                                               'fiber_length': 6277,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RThBIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '3364586',
                                                                                                               'fiber_length': 6171,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MDY1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -13.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '427037',
                                                                                                               'fiber_length': 6505,
                                                                                                               'poller_hash': 'QURUTjIzMTIzRTlEIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '427036',
                                                                                                               'fiber_length': 6490,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTMzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '3364587',
                                                                                                               'fiber_length': 6584,
                                                                                                               'poller_hash': 'QURUTjIzMTI0RTQzIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '427041',
                                                                                                               'fiber_length': 6819,
                                                                                                               'poller_hash': 'QURUTjIzMTI0NDkxIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.5,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '3364587',
                                                                                                               'fiber_length': 6776,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTBCIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -18.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '3364586',
                                                                                                               'fiber_length': 5964,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0OEQ1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -14.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '5355630',
                                                                                                               'fiber_length': 7783,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0QTg2IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -17.0,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '1108815',
                                                                                                               'fiber_length': 6748,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0N0FDIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -19.2,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '427040',
                                                                                                               'fiber_length': 6818,
                                                                                                               'poller_hash': 'QURUTjIzMTQ0NjlFIHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -16.6,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955},
                                                                                                       {       'connected_time': '2503969',
                                                                                                               'fiber_length': 6346,
                                                                                                               'poller_hash': 'QURUTjIzMTI1MTM1IHBlZXJwb24=',
                                                                                                               'rx_link_rate': '10000000000',
                                                                                                               'rx_power': -15.9,
                                                                                                               'tx_link_rate': '10000000000',
                                                                                                               'tx_power': 5.3955}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -7.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'xgspon '
                                                                                              '0/9',
                                                                                      'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC85',
                                                                                      'pon_technology': 'XGS_PON',
                                                                                      'rx_link_rate': '10000000000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '10000000000'}]},
                                                      {       'admin_up': False,
                                                              'id': 'hundred-gigabit-ethernet '
                                                                    '0/1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '38:f8:f6:ac:65:ce',
                                                              'manufacturer': 'Adtran',
                                                              'name': 'hundred-gigabit-ethernet '
                                                                      '0/1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgaHVuZHJlZC1naWdhYml0LWV0aGVybmV0IDAvMQ==',
                                                              'speed': '100000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': 'hundred-gigabit-ethernet '
                                                                    '0/2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '38:f8:f6:ac:65:cf',
                                                              'manufacturer': 'Adtran',
                                                              'name': 'hundred-gigabit-ethernet '
                                                                      '0/2',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgaHVuZHJlZC1naWdhYml0LWV0aGVybmV0IDAvMg==',
                                                              'speed': '100000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': 'hundred-gigabit-ethernet '
                                                                    '0/3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '38:f8:f6:ac:65:d0',
                                                              'manufacturer': 'Adtran',
                                                              'name': 'hundred-gigabit-ethernet '
                                                                      '0/3',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgaHVuZHJlZC1naWdhYml0LWV0aGVybmV0IDAvMw==',
                                                              'speed': '100000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': 'hundred-gigabit-ethernet '
                                                                    '0/4',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '38:f8:f6:ac:65:d1',
                                                              'manufacturer': 'Adtran',
                                                              'name': 'hundred-gigabit-ethernet '
                                                                      '0/4',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgaHVuZHJlZC1naWdhYml0LWV0aGVybmV0IDAvNA==',
                                                              'speed': '100000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': 'management 0/1',
                                                              'mac_address': '38:f8:f6:ac:65:c8',
                                                              'manufacturer': 'Adtran',
                                                              'name': 'management 0/1',
                                                              'oper_up': True,
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgbWFuYWdlbWVudCAwLzE=',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': 'ten-gigabit-ethernet '
                                                                    '0/1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '56931807',
                                                              'in_octets': '40995186676973',
                                                              'in_ucast_pkts': '443630565079',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '38:f8:f6:ac:65:ca',
                                                              'manufacturer': 'Adtran',
                                                              'name': 'ten-gigabit-ethernet '
                                                                      '0/1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '60638424',
                                                              'out_octets': '48218558459893',
                                                              'out_ucast_pkts': '173991433096',
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgdGVuLWdpZ2FiaXQtZXRoZXJuZXQgMC8x',
                                                              'speed': '10000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': 'ten-gigabit-ethernet '
                                                                    '0/2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '38:f8:f6:ac:65:cb',
                                                              'manufacturer': 'Adtran',
                                                              'name': 'ten-gigabit-ethernet '
                                                                      '0/2',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgdGVuLWdpZ2FiaXQtZXRoZXJuZXQgMC8y',
                                                              'speed': '10000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': 'ten-gigabit-ethernet '
                                                                    '0/3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '38:f8:f6:ac:65:cc',
                                                              'manufacturer': 'Adtran',
                                                              'name': 'ten-gigabit-ethernet '
                                                                      '0/3',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgdGVuLWdpZ2FiaXQtZXRoZXJuZXQgMC8z',
                                                              'speed': '10000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': 'ten-gigabit-ethernet '
                                                                    '0/4',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '38:f8:f6:ac:65:cd',
                                                              'manufacturer': 'Adtran',
                                                              'name': 'ten-gigabit-ethernet '
                                                                      '0/4',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgdGVuLWdpZ2FiaXQtZXRoZXJuZXQgMC80',
                                                              'speed': '10000000000',
                                                              'type': 6}],
                                'manufacturer': 'Adtran',
                                'mem': 53.82,
                                'model': 'SDX 6320-16',
                                'name': 'IndianBayou-x1',
                                'poller_hash': 'b2x0IExCQURUTjIzMjJBQTIzNA==',
                                'serial_number': 'LBADTN2322AA234',
                                'sw_version': 'sdx6320-RL-23.5-33',
                                'temperature': 72.0,
                                'uptime': '5355835'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.0.0.eth.1.phy',
                                                                       'in_nucast_pkts': '14745',
                                                                       'in_octets': '27560742812',
                                                                       'in_ucast_pkts': '124826761',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU0_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1226',
                                                                       'out_octets': '441183690755',
                                                                       'out_ucast_pkts': '317382052',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VMF9FVEhfMQ==',
                                                                       'speed': '1000000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1226',
                                                                       'in_octets': '441183690755',
                                                                       'in_ucast_pkts': '317382052',
                                                                       'links': [       {       'in_nucast_pkts': '1226',
                                                                                                'in_octets': '441183690755',
                                                                                                'in_ucast_pkts': '317382052',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '14745',
                                                                                                'out_octets': '27560742812',
                                                                                                'out_ucast_pkts': '124826761',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC84'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '14745',
                                                                       'out_octets': '27560742812',
                                                                       'out_ucast_pkts': '124826761',
                                                                       'poller_hash': 'QURUTjIzMTI0RDkxIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '427021',
                                                                                                                        'fiber_length': 5783,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC84',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -18.9,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.3}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDkxIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU0',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQ5MQ==',
                                         'serial_number': 'ADTN23124D91',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '427021'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-9.1.0.0.eth.1.phy',
                                                                       'in_nucast_pkts': '14488',
                                                                       'in_octets': '10550726467',
                                                                       'in_ucast_pkts': '78959047',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x9-ONU0_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1227',
                                                                       'out_octets': '372201121743',
                                                                       'out_ucast_pkts': '254564839',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDktT05VMF9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1227',
                                                                       'in_octets': '372201121743',
                                                                       'in_ucast_pkts': '254564839',
                                                                       'links': [       {       'in_nucast_pkts': '1227',
                                                                                                'in_octets': '372201121743',
                                                                                                'in_ucast_pkts': '254564839',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '14488',
                                                                                                'out_octets': '10550726467',
                                                                                                'out_ucast_pkts': '78959047',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC85'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '14488',
                                                                       'out_octets': '10550726467',
                                                                       'out_ucast_pkts': '78959047',
                                                                       'poller_hash': 'QURUTjIzMTI0RDY4IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '427041',
                                                                                                                        'fiber_length': 5677,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC85',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -17.9,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDY4IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x9-ONU0',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQ2OA==',
                                         'serial_number': 'ADTN23124D68',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '427041'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.1.0.eth.1.phy',
                                                                       'in_nucast_pkts': '14487',
                                                                       'in_octets': '5327360268',
                                                                       'in_ucast_pkts': '12580045',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU1_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1227',
                                                                       'out_octets': '52274437849',
                                                                       'out_ucast_pkts': '41675343',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VMV9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1227',
                                                                       'in_octets': '52274437849',
                                                                       'in_ucast_pkts': '41675343',
                                                                       'links': [       {       'in_nucast_pkts': '1227',
                                                                                                'in_octets': '52274437849',
                                                                                                'in_ucast_pkts': '41675343',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '14487',
                                                                                                'out_octets': '5327360268',
                                                                                                'out_ucast_pkts': '12580045',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC84'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '14487',
                                                                       'out_octets': '5327360268',
                                                                       'out_ucast_pkts': '12580045',
                                                                       'poller_hash': 'QURUTjIzMTI0RTdBIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '427033',
                                                                                                                        'fiber_length': 5853,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC84',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -19.5,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RTdBIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU1',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEU3QQ==',
                                         'serial_number': 'ADTN23124E7A',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '427033'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-9.1.1.0.eth.1.phy',
                                                                       'in_nucast_pkts': '14491',
                                                                       'in_octets': '2971603812',
                                                                       'in_ucast_pkts': '6478397',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x9-ONU1_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1227',
                                                                       'out_octets': '32270863710',
                                                                       'out_ucast_pkts': '26537850',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDktT05VMV9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1227',
                                                                       'in_octets': '32270863710',
                                                                       'in_ucast_pkts': '26537850',
                                                                       'links': [       {       'in_nucast_pkts': '1227',
                                                                                                'in_octets': '32270863710',
                                                                                                'in_ucast_pkts': '26537850',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '14491',
                                                                                                'out_octets': '2971603812',
                                                                                                'out_ucast_pkts': '6478397',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC85'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '14491',
                                                                       'out_octets': '2971603812',
                                                                       'out_ucast_pkts': '6478397',
                                                                       'poller_hash': 'QURUTjIzMTI0RTE4IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '427040',
                                                                                                                        'fiber_length': 6613,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC85',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -17.4,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.8}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RTE4IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x9-ONU1',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEUxOA==',
                                         'serial_number': 'ADTN23124E18',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '427040'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.2.0.eth.1.phy',
                                                                       'in_nucast_pkts': '14846',
                                                                       'in_octets': '77541879154',
                                                                       'in_ucast_pkts': '144166953',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU2_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1227',
                                                                       'out_octets': '363149263500',
                                                                       'out_ucast_pkts': '278103635',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VMl9FVEhfMQ==',
                                                                       'speed': '1000000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1227',
                                                                       'in_octets': '363149263500',
                                                                       'in_ucast_pkts': '278103635',
                                                                       'links': [       {       'in_nucast_pkts': '1227',
                                                                                                'in_octets': '363149263500',
                                                                                                'in_ucast_pkts': '278103635',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '14846',
                                                                                                'out_octets': '77541879154',
                                                                                                'out_ucast_pkts': '144166953',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC84'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '14846',
                                                                       'out_octets': '77541879154',
                                                                       'out_ucast_pkts': '144166953',
                                                                       'poller_hash': 'QURUTjIzMTIzRTlDIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '427040',
                                                                                                                        'fiber_length': 5669,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC84',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -19.6,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.3}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTIzRTlDIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU2',
                                         'poller_hash': 'b250IEFEVE4yMzEyM0U5Qw==',
                                         'serial_number': 'ADTN23123E9C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '427040'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.3.0.eth.1.phy',
                                                                       'in_nucast_pkts': '14613',
                                                                       'in_octets': '37044453415',
                                                                       'in_ucast_pkts': '60328336',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU3_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '476',
                                                                       'out_octets': '186031888166',
                                                                       'out_ucast_pkts': '144934536',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VM19FVEhfMQ==',
                                                                       'speed': '1000000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '476',
                                                                       'in_octets': '186031888166',
                                                                       'in_ucast_pkts': '144934536',
                                                                       'links': [       {       'in_nucast_pkts': '476',
                                                                                                'in_octets': '186031888166',
                                                                                                'in_ucast_pkts': '144934536',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '14613',
                                                                                                'out_octets': '37044453415',
                                                                                                'out_ucast_pkts': '60328336',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC84'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '14613',
                                                                       'out_octets': '37044453415',
                                                                       'out_ucast_pkts': '60328336',
                                                                       'poller_hash': 'QURUTjIzMTI0REVCIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '427035',
                                                                                                                        'fiber_length': 3861,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC84',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -18.7,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.8}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0REVCIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU3',
                                         'poller_hash': 'b250IEFEVE4yMzEyNERFQg==',
                                         'serial_number': 'ADTN23124DEB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '427035'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.4.0.eth.1.phy',
                                                                       'in_nucast_pkts': '14488',
                                                                       'in_octets': '7182857775',
                                                                       'in_ucast_pkts': '36284466',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU4_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1227',
                                                                       'out_octets': '102633796554',
                                                                       'out_ucast_pkts': '77660339',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VNF9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1227',
                                                                       'in_octets': '102633796554',
                                                                       'in_ucast_pkts': '77660339',
                                                                       'links': [       {       'in_nucast_pkts': '1227',
                                                                                                'in_octets': '102633796554',
                                                                                                'in_ucast_pkts': '77660339',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '14488',
                                                                                                'out_octets': '7182857775',
                                                                                                'out_ucast_pkts': '36284466',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC84'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '14488',
                                                                       'out_octets': '7182857775',
                                                                       'out_ucast_pkts': '36284466',
                                                                       'poller_hash': 'QURUTjIzMTI0RDkzIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '427024',
                                                                                                                        'fiber_length': 4090,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC84',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -23.4,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.7}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDkzIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU4',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQ5Mw==',
                                         'serial_number': 'ADTN23124D93',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '427024'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.5.0.eth.1.phy',
                                                                       'in_nucast_pkts': '14259',
                                                                       'in_octets': '8477882963',
                                                                       'in_ucast_pkts': '18924820',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU5_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '476',
                                                                       'out_octets': '84457489770',
                                                                       'out_ucast_pkts': '65016933',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VNV9FVEhfMQ==',
                                                                       'speed': '1000000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '476',
                                                                       'in_octets': '84457489770',
                                                                       'in_ucast_pkts': '65016933',
                                                                       'links': [       {       'in_nucast_pkts': '476',
                                                                                                'in_octets': '84457489770',
                                                                                                'in_ucast_pkts': '65016933',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '14259',
                                                                                                'out_octets': '8477882963',
                                                                                                'out_ucast_pkts': '18924820',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC84'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '14259',
                                                                       'out_octets': '8477882963',
                                                                       'out_ucast_pkts': '18924820',
                                                                       'poller_hash': 'QURUTjIzMTI0RDQ2IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '427036',
                                                                                                                        'fiber_length': 4612,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC84',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -20.7,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDQ2IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU5',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQ0Ng==',
                                         'serial_number': 'ADTN23124D46',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '427036'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.6.0.eth.1.phy',
                                                                       'in_nucast_pkts': '14487',
                                                                       'in_octets': '7352355370',
                                                                       'in_ucast_pkts': '32956583',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU6_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1227',
                                                                       'out_octets': '201948414523',
                                                                       'out_ucast_pkts': '142178378',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VNl9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1227',
                                                                       'in_octets': '201948414523',
                                                                       'in_ucast_pkts': '142178378',
                                                                       'links': [       {       'in_nucast_pkts': '1227',
                                                                                                'in_octets': '201948414523',
                                                                                                'in_ucast_pkts': '142178378',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '14487',
                                                                                                'out_octets': '7352355370',
                                                                                                'out_ucast_pkts': '32956583',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC84'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '14487',
                                                                       'out_octets': '7352355370',
                                                                       'out_ucast_pkts': '32956583',
                                                                       'poller_hash': 'QURUTjIzMTI0OTFFIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '427022',
                                                                                                                        'fiber_length': 5476,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC84',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -20.1,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0OTFFIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU6',
                                         'poller_hash': 'b250IEFEVE4yMzEyNDkxRQ==',
                                         'serial_number': 'ADTN2312491E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '427022'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.7.0.eth.1.phy',
                                                                       'in_nucast_pkts': '342',
                                                                       'in_octets': '9898390739',
                                                                       'in_ucast_pkts': '22190380',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU7_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1227',
                                                                       'out_octets': '80594217954',
                                                                       'out_ucast_pkts': '61996459',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VN19FVEhfMQ==',
                                                                       'speed': '1000000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1227',
                                                                       'in_octets': '80594217954',
                                                                       'in_ucast_pkts': '61996459',
                                                                       'links': [       {       'in_nucast_pkts': '1227',
                                                                                                'in_octets': '80594217954',
                                                                                                'in_ucast_pkts': '61996459',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '342',
                                                                                                'out_octets': '9898390739',
                                                                                                'out_ucast_pkts': '22190380',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC84'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '342',
                                                                       'out_octets': '9898390739',
                                                                       'out_ucast_pkts': '22190380',
                                                                       'poller_hash': 'QURUTjIzMTI0RTNBIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '427025',
                                                                                                                        'fiber_length': 5824,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC84',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -17.1,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.7}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RTNBIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU7',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEUzQQ==',
                                         'serial_number': 'ADTN23124E3A',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '427025'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.9.0.eth.1.phy',
                                                                       'in_nucast_pkts': '14846',
                                                                       'in_octets': '10434238744',
                                                                       'in_ucast_pkts': '50310389',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU9_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1227',
                                                                       'out_octets': '257756685243',
                                                                       'out_ucast_pkts': '190759006',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VOV9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1227',
                                                                       'in_octets': '257756685243',
                                                                       'in_ucast_pkts': '190759006',
                                                                       'links': [       {       'in_nucast_pkts': '1227',
                                                                                                'in_octets': '257756685243',
                                                                                                'in_ucast_pkts': '190759006',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '14846',
                                                                                                'out_octets': '10434238744',
                                                                                                'out_ucast_pkts': '50310389',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC84'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '14846',
                                                                       'out_octets': '10434238744',
                                                                       'out_ucast_pkts': '50310389',
                                                                       'poller_hash': 'QURUTjIzMTI0REYzIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '427040',
                                                                                                                        'fiber_length': 3643,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC84',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -17.3,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0REYzIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU9',
                                         'poller_hash': 'b250IEFEVE4yMzEyNERGMw==',
                                         'serial_number': 'ADTN23124DF3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5-5-b',
                                         'uptime': '427040'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.10.0.eth.1.phy',
                                                                       'in_nucast_pkts': '14487',
                                                                       'in_octets': '790422525',
                                                                       'in_ucast_pkts': '2958689',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU10_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1227',
                                                                       'out_octets': '7130903493',
                                                                       'out_ucast_pkts': '5656972',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VMTBfRVRIXzE=',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1227',
                                                                       'in_octets': '7130903493',
                                                                       'in_ucast_pkts': '5656972',
                                                                       'links': [       {       'in_nucast_pkts': '1227',
                                                                                                'in_octets': '7130903493',
                                                                                                'in_ucast_pkts': '5656972',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '14487',
                                                                                                'out_octets': '790422525',
                                                                                                'out_ucast_pkts': '2958689',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC84'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '14487',
                                                                       'out_octets': '790422525',
                                                                       'out_ucast_pkts': '2958689',
                                                                       'poller_hash': 'QURUTjIzMTI1MThFIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '427024',
                                                                                                                        'fiber_length': 3909,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC84',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -19.8,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI1MThFIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU10',
                                         'poller_hash': 'b250IEFEVE4yMzEyNTE4RQ==',
                                         'serial_number': 'ADTN2312518E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '427024'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.11.0.eth.1.phy',
                                                                       'in_nucast_pkts': '14845',
                                                                       'in_octets': '12476280102',
                                                                       'in_ucast_pkts': '51926230',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU11_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1227',
                                                                       'out_octets': '266208528670',
                                                                       'out_ucast_pkts': '191938908',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VMTFfRVRIXzE=',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1227',
                                                                       'in_octets': '266208528670',
                                                                       'in_ucast_pkts': '191938908',
                                                                       'links': [       {       'in_nucast_pkts': '1227',
                                                                                                'in_octets': '266208528670',
                                                                                                'in_ucast_pkts': '191938908',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '14845',
                                                                                                'out_octets': '12476280102',
                                                                                                'out_ucast_pkts': '51926230',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC84'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '14845',
                                                                       'out_octets': '12476280102',
                                                                       'out_ucast_pkts': '51926230',
                                                                       'poller_hash': 'QURUTjIzMTI0RENFIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '427035',
                                                                                                                        'fiber_length': 5338,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC84',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -18.9,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RENFIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU11',
                                         'poller_hash': 'b250IEFEVE4yMzEyNERDRQ==',
                                         'serial_number': 'ADTN23124DCE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '427035'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.12.0.eth.1.phy',
                                                                       'in_nucast_pkts': '14487',
                                                                       'in_octets': '1975280843',
                                                                       'in_ucast_pkts': '6538177',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x8-ONU12_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1227',
                                                                       'out_octets': '17893158561',
                                                                       'out_ucast_pkts': '14760521',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VMTJfRVRIXzE=',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1227',
                                                                       'in_octets': '17893158561',
                                                                       'in_ucast_pkts': '14760521',
                                                                       'links': [       {       'in_nucast_pkts': '1227',
                                                                                                'in_octets': '17893158561',
                                                                                                'in_ucast_pkts': '14760521',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '14487',
                                                                                                'out_octets': '1975280843',
                                                                                                'out_ucast_pkts': '6538177',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC84'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '14487',
                                                                       'out_octets': '1975280843',
                                                                       'out_ucast_pkts': '6538177',
                                                                       'poller_hash': 'QURUTjIzMTI0RTIyIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '427034',
                                                                                                                        'fiber_length': 3743,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC84',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -20.2,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.6}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RTIyIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x8-ONU12',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEUyMg==',
                                         'serial_number': 'ADTN23124E22',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '427034'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-9.1.2.0.eth.1.phy',
                                                                       'in_nucast_pkts': '114032',
                                                                       'in_octets': '34146902875',
                                                                       'in_ucast_pkts': '130691237',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x9-ONU2_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '9654',
                                                                       'out_octets': '471523767208',
                                                                       'out_ucast_pkts': '370552154',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDktT05VMl9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '9654',
                                                                       'in_octets': '471523767208',
                                                                       'in_ucast_pkts': '370552154',
                                                                       'links': [       {       'in_nucast_pkts': '9654',
                                                                                                'in_octets': '471523767208',
                                                                                                'in_ucast_pkts': '370552154',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '114032',
                                                                                                'out_octets': '34146902875',
                                                                                                'out_ucast_pkts': '130691237',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC85'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '114032',
                                                                       'out_octets': '34146902875',
                                                                       'out_ucast_pkts': '130691237',
                                                                       'poller_hash': 'QURUTjIzMTI1MDU1IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '3364586',
                                                                                                                        'fiber_length': 6229,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC85',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI1MDU1IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x9-ONU2',
                                         'poller_hash': 'b250IEFEVE4yMzEyNTA1NQ==',
                                         'serial_number': 'ADTN23125055',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '3364586'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-1.1.0.0.eth.1.phy',
                                                                       'in_nucast_pkts': '14537',
                                                                       'in_octets': '983568170',
                                                                       'in_ucast_pkts': '6528585',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x1-ONU0_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1224',
                                                                       'out_octets': '17955758353',
                                                                       'out_ucast_pkts': '12484499',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDEtT05VMF9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1224',
                                                                       'in_octets': '17955758353',
                                                                       'in_ucast_pkts': '12484499',
                                                                       'links': [       {       'in_nucast_pkts': '1224',
                                                                                                'in_octets': '17955758353',
                                                                                                'in_ucast_pkts': '12484499',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '14537',
                                                                                                'out_octets': '983568170',
                                                                                                'out_ucast_pkts': '6528585',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8x'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '14537',
                                                                       'out_octets': '983568170',
                                                                       'out_ucast_pkts': '6528585',
                                                                       'poller_hash': 'QURUTjIzMTI0RDQxIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '427025',
                                                                                                                        'fiber_length': 1926,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8x',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -14.8,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.3}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDQxIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x1-ONU0',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQ0MQ==',
                                         'serial_number': 'ADTN23124D41',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '427025'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-1.1.1.0.eth.1.phy',
                                                                       'in_nucast_pkts': '14480',
                                                                       'in_octets': '1572259937',
                                                                       'in_ucast_pkts': '6243316',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x1-ONU1_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1224',
                                                                       'out_octets': '29939132609',
                                                                       'out_ucast_pkts': '21426454',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDEtT05VMV9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1224',
                                                                       'in_octets': '29939132609',
                                                                       'in_ucast_pkts': '21426454',
                                                                       'links': [       {       'in_nucast_pkts': '1224',
                                                                                                'in_octets': '29939132609',
                                                                                                'in_ucast_pkts': '21426454',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '14480',
                                                                                                'out_octets': '1572259937',
                                                                                                'out_ucast_pkts': '6243316',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8x'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '14480',
                                                                       'out_octets': '1572259937',
                                                                       'out_ucast_pkts': '6243316',
                                                                       'poller_hash': 'QURUTjIzMTI0MEIwIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '427026',
                                                                                                                        'fiber_length': 1969,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8x',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -15.7,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0MEIwIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x1-ONU1',
                                         'poller_hash': 'b250IEFEVE4yMzEyNDBCMA==',
                                         'serial_number': 'ADTN231240B0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '427026'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-1.1.2.0.eth.1.phy',
                                                                       'in_nucast_pkts': '14820',
                                                                       'in_octets': '9477065744',
                                                                       'in_ucast_pkts': '46725402',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x1-ONU2_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1224',
                                                                       'out_octets': '131191620822',
                                                                       'out_ucast_pkts': '105992610',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDEtT05VMl9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1224',
                                                                       'in_octets': '131191620822',
                                                                       'in_ucast_pkts': '105992610',
                                                                       'links': [       {       'in_nucast_pkts': '1224',
                                                                                                'in_octets': '131191620822',
                                                                                                'in_ucast_pkts': '105992610',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '14820',
                                                                                                'out_octets': '9477065744',
                                                                                                'out_ucast_pkts': '46725402',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8x'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '14820',
                                                                       'out_octets': '9477065744',
                                                                       'out_ucast_pkts': '46725402',
                                                                       'poller_hash': 'QURUTjIzMTI0REQ5IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '427026',
                                                                                                                        'fiber_length': 1780,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8x',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -18.1,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0REQ5IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x1-ONU2',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEREOQ==',
                                         'serial_number': 'ADTN23124DD9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '427026'},
                                 {       'interfaces': [       {       'id': 'onu-subscr-if-8.1.13.0.eth.1.phy',
                                                                       'name': 'IndianBayou-x8-ONU13_ETH_1',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDgtT05VMTNfRVRIXzE='},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIzMTI0MEE2IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0MEE2IHBlZXJwb24='}]}],
                                         'manufacturer': 'Adtran',
                                         'name': 'IndianBayou-x8-ONU13',
                                         'poller_hash': 'b250IEFEVE4yMzEyNDBBNg==',
                                         'serial_number': 'ADTN231240A6',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-8.1.14.0.eth.1.phy',
                                                                       'in_nucast_pkts': '14845',
                                                                       'in_octets': '11065164565',
                                                                       'in_ucast_pkts': '73336480',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'ADTN23124D9E_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1227',
                                                                       'out_octets': '276809440559',
                                                                       'out_ucast_pkts': '202956573',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgQURUTjIzMTI0RDlFX0VUSF8x',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '1227',
                                                                       'in_octets': '276809440559',
                                                                       'in_ucast_pkts': '202956573',
                                                                       'links': [       {       'in_nucast_pkts': '1227',
                                                                                                'in_octets': '276809440559',
                                                                                                'in_ucast_pkts': '202956573',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '14845',
                                                                                                'out_octets': '11065164565',
                                                                                                'out_ucast_pkts': '73336480',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC84'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '14845',
                                                                       'out_octets': '11065164565',
                                                                       'out_ucast_pkts': '73336480',
                                                                       'poller_hash': 'QURUTjIzMTI0RDlFIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '427035',
                                                                                                                        'fiber_length': 4273,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC84',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -19.6,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDlFIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'ADTN23124D9E',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQ5RQ==',
                                         'serial_number': 'ADTN23124D9E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '427035'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-4.1.0.0.eth.1.phy',
                                                                       'in_nucast_pkts': '75670',
                                                                       'in_octets': '31365538729',
                                                                       'in_ucast_pkts': '242077913',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x4-ONU0_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '6407',
                                                                       'out_octets': '829089433233',
                                                                       'out_ucast_pkts': '590504210',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDQtT05VMF9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '6407',
                                                                       'in_octets': '829089433233',
                                                                       'in_ucast_pkts': '590504210',
                                                                       'links': [       {       'in_nucast_pkts': '6407',
                                                                                                'in_octets': '829089433233',
                                                                                                'in_ucast_pkts': '590504210',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '75670',
                                                                                                'out_octets': '31365538729',
                                                                                                'out_ucast_pkts': '242077913',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC80'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '75670',
                                                                       'out_octets': '31365538729',
                                                                       'out_ucast_pkts': '242077913',
                                                                       'poller_hash': 'QURUTjIzMTI0REYxIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '2232582',
                                                                                                                        'fiber_length': 5944,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC80',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -19.3,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0REYxIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x4-ONU0',
                                         'poller_hash': 'b250IEFEVE4yMzEyNERGMQ==',
                                         'serial_number': 'ADTN23124DF1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '2232582'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-3.1.0.0.eth.1.phy',
                                                                       'in_nucast_pkts': '77530',
                                                                       'in_octets': '62439363189',
                                                                       'in_ucast_pkts': '286217570',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x3-ONU0_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '6385',
                                                                       'out_octets': '1268052424980',
                                                                       'out_ucast_pkts': '909777139',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDMtT05VMF9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '6385',
                                                                       'in_octets': '1268052424980',
                                                                       'in_ucast_pkts': '909777139',
                                                                       'links': [       {       'in_nucast_pkts': '6385',
                                                                                                'in_octets': '1268052424980',
                                                                                                'in_ucast_pkts': '909777139',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '77530',
                                                                                                'out_octets': '62439363189',
                                                                                                'out_ucast_pkts': '286217570',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8z'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '77530',
                                                                       'out_octets': '62439363189',
                                                                       'out_ucast_pkts': '286217570',
                                                                       'poller_hash': 'QURUTjIzMTI0RTA3IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '2232581',
                                                                                                                        'fiber_length': 3992,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8z',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -20.8,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RTA3IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x3-ONU0',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEUwNw==',
                                         'serial_number': 'ADTN23124E07',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '2232581'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-3.1.1.0.eth.1.phy',
                                                                       'in_nucast_pkts': '11726',
                                                                       'in_octets': '6215172481',
                                                                       'in_ucast_pkts': '26752970',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x3-ONU1_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '967',
                                                                       'out_octets': '92677070435',
                                                                       'out_ucast_pkts': '66622657',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDMtT05VMV9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '967',
                                                                       'in_octets': '92677070435',
                                                                       'in_ucast_pkts': '66622657',
                                                                       'links': [       {       'in_nucast_pkts': '967',
                                                                                                'in_octets': '92677070435',
                                                                                                'in_ucast_pkts': '66622657',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '11726',
                                                                                                'out_octets': '6215172481',
                                                                                                'out_ucast_pkts': '26752970',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC8z'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '11726',
                                                                       'out_octets': '6215172481',
                                                                       'out_ucast_pkts': '26752970',
                                                                       'poller_hash': 'QURUTjIzMTI0RTE0IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '337326',
                                                                                                                        'fiber_length': 4123,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC8z',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -19.2,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RTE0IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x3-ONU1',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEUxNA==',
                                         'serial_number': 'ADTN23124E14',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '337326'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-4.1.1.0.eth.1.phy',
                                                                       'in_nucast_pkts': '75665',
                                                                       'in_octets': '9338582863',
                                                                       'in_ucast_pkts': '28219211',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x4-ONU1_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '6402',
                                                                       'out_octets': '92332925860',
                                                                       'out_ucast_pkts': '77335772',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDQtT05VMV9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '6402',
                                                                       'in_octets': '92332925860',
                                                                       'in_ucast_pkts': '77335772',
                                                                       'links': [       {       'in_nucast_pkts': '6402',
                                                                                                'in_octets': '92332925860',
                                                                                                'in_ucast_pkts': '77335772',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '75665',
                                                                                                'out_octets': '9338582863',
                                                                                                'out_ucast_pkts': '28219211',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC80'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '75665',
                                                                       'out_octets': '9338582863',
                                                                       'out_ucast_pkts': '28219211',
                                                                       'poller_hash': 'QURUTjIzMTI0RDQzIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '2232584',
                                                                                                                        'fiber_length': 6063,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC80',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -20.1,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.6}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDQzIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x4-ONU1',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQ0Mw==',
                                         'serial_number': 'ADTN23124D43',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '2232584'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-4.1.2.0.eth.1.phy',
                                                                       'in_nucast_pkts': '76288',
                                                                       'in_octets': '33947972487',
                                                                       'in_ucast_pkts': '162391808',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x4-ONU2_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2482',
                                                                       'out_octets': '599415877956',
                                                                       'out_ucast_pkts': '432388381',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDQtT05VMl9FVEhfMQ==',
                                                                       'speed': '1000000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '2482',
                                                                       'in_octets': '599415877956',
                                                                       'in_ucast_pkts': '432388381',
                                                                       'links': [       {       'in_nucast_pkts': '2482',
                                                                                                'in_octets': '599415877956',
                                                                                                'in_ucast_pkts': '432388381',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '76288',
                                                                                                'out_octets': '33947972487',
                                                                                                'out_ucast_pkts': '162391808',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC80'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '76288',
                                                                       'out_octets': '33947972487',
                                                                       'out_ucast_pkts': '162391808',
                                                                       'poller_hash': 'QURUTjIzMTI1MUUyIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '2232582',
                                                                                                                        'fiber_length': 5212,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC80',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -20.9,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 6.2}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI1MUUyIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x4-ONU2',
                                         'poller_hash': 'b250IEFEVE4yMzEyNTFFMg==',
                                         'serial_number': 'ADTN231251E2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '2232582'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-9.1.3.0.eth.1.phy',
                                                                       'in_nucast_pkts': '114027',
                                                                       'in_octets': '48597335655',
                                                                       'in_ucast_pkts': '274600145',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x9-ONU3_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '9650',
                                                                       'out_octets': '1294769624337',
                                                                       'out_ucast_pkts': '894488302',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDktT05VM19FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '9650',
                                                                       'in_octets': '1294769624337',
                                                                       'in_ucast_pkts': '894488302',
                                                                       'links': [       {       'in_nucast_pkts': '9650',
                                                                                                'in_octets': '1294769624337',
                                                                                                'in_ucast_pkts': '894488302',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '114027',
                                                                                                'out_octets': '48597335655',
                                                                                                'out_ucast_pkts': '274600145',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC85'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '114027',
                                                                       'out_octets': '48597335655',
                                                                       'out_ucast_pkts': '274600145',
                                                                       'poller_hash': 'QURUTjIzMTI0NjUwIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '3364583',
                                                                                                                        'fiber_length': 5972,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC85',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -20.7,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.6}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0NjUwIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x9-ONU3',
                                         'poller_hash': 'b250IEFEVE4yMzEyNDY1MA==',
                                         'serial_number': 'ADTN23124650',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '3364583'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-4.1.3.0.eth.1.phy',
                                                                       'in_nucast_pkts': '34912',
                                                                       'in_octets': '16610401362',
                                                                       'in_ucast_pkts': '85236877',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x4-ONU3_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2953',
                                                                       'out_octets': '458100236742',
                                                                       'out_ucast_pkts': '324936178',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDQtT05VM19FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '2953',
                                                                       'in_octets': '458100236742',
                                                                       'in_ucast_pkts': '324936178',
                                                                       'links': [       {       'in_nucast_pkts': '2953',
                                                                                                'in_octets': '458100236742',
                                                                                                'in_ucast_pkts': '324936178',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '34912',
                                                                                                'out_octets': '16610401362',
                                                                                                'out_ucast_pkts': '85236877',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC80'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '34912',
                                                                       'out_octets': '16610401362',
                                                                       'out_ucast_pkts': '85236877',
                                                                       'poller_hash': 'QURUTjIzMTI0RTI2IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '1029869',
                                                                                                                        'fiber_length': 7531,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC80',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RTI2IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x4-ONU3',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEUyNg==',
                                         'serial_number': 'ADTN23124E26',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '1029869'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-4.1.4.0.eth.1.phy',
                                                                       'in_nucast_pkts': '75672',
                                                                       'in_octets': '85674469971',
                                                                       'in_ucast_pkts': '348962087',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x4-ONU4_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '6402',
                                                                       'out_octets': '1033461819978',
                                                                       'out_ucast_pkts': '758406064',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDQtT05VNF9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '6402',
                                                                       'in_octets': '1033461819978',
                                                                       'in_ucast_pkts': '758406064',
                                                                       'links': [       {       'in_nucast_pkts': '6402',
                                                                                                'in_octets': '1033461819978',
                                                                                                'in_ucast_pkts': '758406064',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '75672',
                                                                                                'out_octets': '85674469971',
                                                                                                'out_ucast_pkts': '348962087',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC80'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '75672',
                                                                       'out_octets': '85674469971',
                                                                       'out_ucast_pkts': '348962087',
                                                                       'poller_hash': 'QURUTjIzMTI0RDk4IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '2232584',
                                                                                                                        'fiber_length': 5967,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC80',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -19.9,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.6}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDk4IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x4-ONU4',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQ5OA==',
                                         'serial_number': 'ADTN23124D98',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '2232584'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-4.1.5.0.eth.1.phy',
                                                                       'in_nucast_pkts': '75665',
                                                                       'in_octets': '27739920116',
                                                                       'in_ucast_pkts': '138623369',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x4-ONU5_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '6403',
                                                                       'out_octets': '922022364186',
                                                                       'out_ucast_pkts': '680231536',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDQtT05VNV9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '6403',
                                                                       'in_octets': '922022364186',
                                                                       'in_ucast_pkts': '680231536',
                                                                       'links': [       {       'in_nucast_pkts': '6403',
                                                                                                'in_octets': '922022364186',
                                                                                                'in_ucast_pkts': '680231536',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '75665',
                                                                                                'out_octets': '27739920116',
                                                                                                'out_ucast_pkts': '138623369',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC80'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '75665',
                                                                       'out_octets': '27739920116',
                                                                       'out_ucast_pkts': '138623369',
                                                                       'poller_hash': 'QURUTjIzMTI0RDUwIHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '2232588',
                                                                                                                        'fiber_length': 5915,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC80',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -18.8,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.6}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDUwIHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x4-ONU5',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQ1MA==',
                                         'serial_number': 'ADTN23124D50',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '2232588'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-4.1.6.0.eth.1.phy',
                                                                       'in_nucast_pkts': '75767',
                                                                       'in_octets': '2784186285',
                                                                       'in_ucast_pkts': '10090190',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x4-ONU6_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '6405',
                                                                       'out_octets': '35990375455',
                                                                       'out_ucast_pkts': '26460817',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDQtT05VNl9FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '6405',
                                                                       'in_octets': '35990375455',
                                                                       'in_ucast_pkts': '26460817',
                                                                       'links': [       {       'in_nucast_pkts': '6405',
                                                                                                'in_octets': '35990375455',
                                                                                                'in_ucast_pkts': '26460817',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '75767',
                                                                                                'out_octets': '2784186285',
                                                                                                'out_ucast_pkts': '10090190',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC80'}],
                                                                       'name': 'pon1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '75767',
                                                                       'out_octets': '2784186285',
                                                                       'out_ucast_pkts': '10090190',
                                                                       'poller_hash': 'QURUTjIzMTI0RDM4IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'links': [       {       'connected_time': '2232582',
                                                                                                                        'fiber_length': 6210,
                                                                                                                        'poller_hash': 'TEJBRFROMjMyMkFBMjM0IG9sdHBvbiB4Z3Nwb24gMC80',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -18.8,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 5.6}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -9.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RDM4IHBlZXJwb24=',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX 631q',
                                         'name': 'IndianBayou-x4-ONU6',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEQzOA==',
                                         'serial_number': 'ADTN23124D38',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12_5_2-28-b',
                                         'uptime': '2232582'},
                                 {       'interfaces': [       {       'id': 'onu-subscr-if-3.1.3.0.eth.1.phy',
                                                                       'name': 'IndianBayou-x3-ONU3_ETH_1',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDMtT05VM19FVEhfMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIzMTI0RTM1IHBlZXJpbnRm',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': 'pon1',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'QURUTjIzMTI0RTM1IHBlZXJwb24='}]}],
                                         'manufacturer': 'Adtran',
                                         'name': 'IndianBayou-x3-ONU3',
                                         'poller_hash': 'b250IEFEVE4yMzEyNEUzNQ==',
                                         'serial_number': 'ADTN23124E35',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'onu-subscr-if-4.1.7.0.eth.1.phy',
                                                                       'in_nucast_pkts': '77266',
                                                                       'in_octets': '41123582384',
                                                                       'in_ucast_pkts': '281917848',
                                                                       'manufacturer': 'Adtran',
                                                                       'mtu': 9216,
                                                                       'name': 'IndianBayou-x4-ONU7_ETH_1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '6407',
                                                                       'out_octets': '1196558938007',
                                                                       'out_ucast_pkts': '859399516',
                                                                       'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgSW5kaWFuQmF5b3UteDQtT05VN19FVEhfMQ==',
                                                                       'speed': '2500000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': 'pon1',
                                                                       'in_nucast_pkts': '6407',
                                                                       'in_octets': '1196558938007',
                                                                       'in_ucast_pkts': '859399516',
                                                                       'links': [       {       'in_nucast_pkts': '6407',
                                                                                                'in_octets': '1196558938007',
                                                                                                'in_ucast_pkts': '859399516',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '77266',
                                                                                                'out_octets': '41123582384',
                                                                                                'out_ucast_pkts': '281917848',
                                                                                                'poller_hash': 'TEJBRFROMjMyMkFBMjM0IGludGYgMC80'}],
                                                                       'name': 'pon1',
                                   