import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestRadioStats(DeviceTestCase):

    def test_ignitenet_metrolinq_ML1_60_19_US_2_4_2_4531_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML1-60-19-US.2.4.2-4531.01")
        exp_info = {
                'model': 'ML1-60-19-US',
                'rf_freq': 64800,
                'rf_tx_power': 14,
                'sta_count': 1,
                'sw_version': '2.4.2-4531',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 1026894779,
                'dl_en_packets': 4119500849,
                'dl_en_packets_dropped': 13,
                'dl_rf_bytes': 17496198695550,
                'dl_rf_packets': 28645219,
                'dl_rf_packets_dropped': 3093,
                'en_if_speed': 1000000000,
                'ul_en_bytes': 1461533731,
                'ul_en_packets': 3227964555,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 1869312215184,
                'ul_rf_packets': 3428772315,
                'ul_rf_packets_dropped': 3
        }
        exp_sta_stats = {
                '28:76:10:1f:72:e4': {       'alt_macs': ['28:76:10:1f:72:e7'],
                                             'dev_macs': None,
                                             'dl_link_rate': 130000000,
                                             'dl_rf_bytes': 3610988258,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1f:72:e4',
                                             'name': 'cpe-7',
                                             'ul_link_rate': 192000000,
                                             'ul_rf_bytes': 2460786734,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '13',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1026894779',
                                                              'in_ucast_pkts': '4119500849',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:1f:73:e8',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1461533731',
                                                              'out_ucast_pkts': '3227964555',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:1f:73:e9',
                                                              'mtu': 1500,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '3',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '1121170',
                                                              'in_octets': '1869312215184',
                                                              'in_ucast_pkts': '3427651145',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '2460786734',
                                                                                       'mac_address': '28:76:10:1f:72:e4',
                                                                                       'out_octets': '3610988258'}],
                                                              'mac_address': '28:76:10:1f:82:74',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '3093',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '17496198695550',
                                                              'out_ucast_pkts': '28645219',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '3841844',
                                                                                                                                            'mac_address': '28:76:10:1f:72:e4',
                                                                                                                                            'rx_link_rate': '192000000',
                                                                                                                                            'tx_link_rate': '130000000'}]}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML1-60-19-US',
                                'poller_hash': 'KHYQH4J0',
                                'sw_version': '2.4.2-4531',
                                'system_mac_address': '28:76:10:1f:73:e8',
                                'uptime': '28808805'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '3610988258',
                                                                       'links': [       {       'in_octets': '3610988258',
                                                                                                'mac_address': '28:76:10:1f:82:74',
                                                                                                'out_octets': '2460786734'}],
                                                                       'mac_address': '28:76:10:1f:72:e4',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2460786734',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3841844',
                                                                                                                                                     'mac_address': '28:76:10:1f:82:74',
                                                                                                                                                     'rx_link_rate': '130000000',
                                                                                                                                                     'tx_link_rate': '192000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2460786734',
                                                                       'mac_address': '28:76:10:1f:72:e7',
                                                                       'name': 'eth0',
                                                                       'out_octets': '3610988258',
                                                                       'poller_hash': 'Mjg3NjEwMWY3MmU0ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'name': 'cpe-7',
                                         'poller_hash': 'KHYQH3Lk',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML1_60_35_FCC_2_4_2_4542_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML1-60-35-FCC.2.4.2-4542.01")
        exp_info = {
                'model': 'ML1-60-35-FCC',
                'rf_freq': 58320,
                'rf_tx_power': 14,
                'sta_count': 1,
                'sw_version': '2.4.2-4542',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 520129167,
                'dl_en_packets': 587350043,
                'dl_en_packets_dropped': 43317,
                'dl_rf_bytes': 7452327068746,
                'dl_rf_packets': 77992176,
                'dl_rf_packets_dropped': 390,
                'en_if_speed': 1000000000,
                'ul_en_bytes': 1283211789,
                'ul_en_packets': 3742158187,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 28520765297146,
                'ul_rf_packets': 937077851,
                'ul_rf_packets_dropped': 43780
        }
        exp_sta_stats = {
                '28:76:10:1f:71:1c': {       'alt_macs': ['28:76:10:1f:a3:34'],
                                             'dev_macs': None,
                                             'dl_link_rate': 2502000000,
                                             'dl_rf_bytes': 7452327042032,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1f:71:1c',
                                             'name': 'Delfino-AP',
                                             'ul_link_rate': 2502000000,
                                             'ul_rf_bytes': 28520765216074,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '43780',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '634723493',
                                                              'in_octets': '28520765297146',
                                                              'in_ucast_pkts': '302354358',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '28520765216074',
                                                                                       'mac_address': '28:76:10:1f:71:1c',
                                                                                       'out_octets': '7452327042032'}],
                                                              'mac_address': '28:76:10:1f:a1:e7',
                                                              'mtu': 2000,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '390',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '7452327068746',
                                                              'out_ucast_pkts': '77992176',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '6239467',
                                                                                                                                            'mac_address': '28:76:10:1f:71:1c',
                                                                                                                                            'rssi': -53.0,
                                                                                                                                            'rx_link_rate': '2502000000',
                                                                                                                                            'tx_link_rate': '2502000000'}]}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '43317',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '520129167',
                                                              'in_ucast_pkts': '587350043',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:1f:3c:58',
                                                              'mtu': 2000,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1283211789',
                                                              'out_ucast_pkts': '3742158187',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:1f:3c:59',
                                                              'mtu': 2000,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML1-60-35-FCC',
                                'poller_hash': 'KHYQH6Hn',
                                'sw_version': '2.4.2-4542',
                                'system_mac_address': '28:76:10:1f:3c:58',
                                'uptime': '14774577'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '7452327042032',
                                                                       'links': [       {       'in_octets': '7452327042032',
                                                                                                'mac_address': '28:76:10:1f:a1:e7',
                                                                                                'out_octets': '28520765216074'}],
                                                                       'mac_address': '28:76:10:1f:71:1c',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '28520765216074',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '6239467',
                                                                                                                                                     'mac_address': '28:76:10:1f:a1:e7',
                                                                                                                                                     'rx_link_rate': '2502000000',
                                                                                                                                                     'tx_link_rate': '2502000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '28520765216074',
                                                                       'mac_address': '28:76:10:1f:a3:34',
                                                                       'name': 'eth0',
                                                                       'out_octets': '7452327042032',
                                                                       'poller_hash': 'Mjg3NjEwMWY3MTFjZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'name': 'Delfino-AP',
                                         'poller_hash': 'KHYQH3Ec',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML2_5_60_35_2_0_1_1306_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML2.5-60-35.2.0.1-1306.01")
        exp_info = {
                'model': 'ML2.5-60-35',
                'rf_freq': 60480,
                'rf_tx_power': 9,
                'sta_count': 0,
                'sw_version': '2.0.1-1306',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 4671756281328,
                'dl_en_packets': 996204177,
                'dl_en_packets_dropped': 177452,
                'dl_rf_bytes': 4747511969680,
                'dl_rf_packets': 1031121166,
                'dl_rf_packets_dropped': 6,
                'en_if_speed': 10000000,
                'ul_en_bytes': 1019459095474,
                'ul_en_packets': 3535104198,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 1020885209679,
                'ul_rf_packets': 3599637940,
                'ul_rf_packets_dropped': 1
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '176740',
                                                              'in_errors': '712',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '4671756281328',
                                                              'in_ucast_pkts': '996204177',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:1a:60:fb',
                                                              'mtu': 7912,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1019459094431',
                                                              'out_ucast_pkts': '3535104197',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:1a:60:fc',
                                                              'mtu': 7912,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1043',
                                                              'out_ucast_pkts': '1',
                                                              'speed': '10000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '1',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '29353727',
                                                              'in_octets': '1020885047766',
                                                              'in_ucast_pkts': '3570282472',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:1a:af:ee',
                                                              'mtu': 1540,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '6',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '4747511807767',
                                                              'out_ucast_pkts': '1031119425',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1'}],
                                                                                        'tx_power': 9}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML2.5-60-35',
                                'poller_hash': 'KHYQGq/u',
                                'sw_version': '2.0.1-1306',
                                'system_mac_address': '28:76:10:1a:60:fb',
                                'uptime': '10595125'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML2_5_60_35_2_1_1_2446_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML2.5-60-35.2.1.1-2446.01")
        exp_info = {
                'model': 'ML2.5-60-35',
                'rf_freq': 64800,
                'rf_tx_power': 14,
                'sta_count': 1,
                'sw_version': '2.1.1-2446',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 1135707785491,
                'dl_en_packets': 1066752560,
                'dl_en_packets_dropped': 3640,
                'dl_rf_bytes': 622,
                'dl_rf_packets': 7,
                'dl_rf_packets_dropped': 0,
                'en_if_speed': 1000000000,
                'ul_en_bytes': 150042727023,
                'ul_en_packets': 724139691,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 622,
                'ul_rf_packets': 7,
                'ul_rf_packets_dropped': 0
        }
        exp_sta_stats = {
                '28:76:10:0c:34:61': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 144000000,
                                             'dl_rf_bytes': 604954426,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:0c:34:61',
                                             'name': None,
                                             'ul_link_rate': 192000000,
                                             'ul_rf_bytes': 352761836,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '3640',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1135707785491',
                                                              'in_ucast_pkts': '1066752560',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:19:7f:d4',
                                                              'mtu': 7912,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '150042725980',
                                                              'out_ucast_pkts': '724139690',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:19:7f:d5',
                                                              'mtu': 7912,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1043',
                                                              'out_ucast_pkts': '1',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2324562313',
                                                              'in_ucast_pkts': '36301642',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '352761836',
                                                                                       'mac_address': '28:76:10:0c:34:61',
                                                                                       'out_octets': '604954426'}],
                                                              'mac_address': '28:76:10:19:7b:b4',
                                                              'mtu': 1500,
                                                              'name': 'wifi0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2336131225',
                                                              'out_ucast_pkts': '36306329',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1376870',
                                                                                                                                            'mac_address': '28:76:10:0c:34:61',
                                                                                                                                            'rssi': -53.0,
                                                                                                                                            'rx_link_rate': '192000000',
                                                                                                                                            'tx_link_rate': '144000000'}]}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '173000000',
                                                              'type': 6}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML2.5-60-35',
                                'poller_hash': 'KHYQGXu0',
                                'sw_version': '2.1.1-2446',
                                'system_mac_address': '28:76:10:19:7f:d4',
                                'uptime': '9088583'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '604954426',
                                                                       'links': [       {       'in_octets': '604954426',
                                                                                                'mac_address': '28:76:10:19:7b:b4',
                                                                                                'out_octets': '352761836'}],
                                                                       'mac_address': '28:76:10:0c:34:61',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '352761836',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1376870',
                                                                                                                                                     'mac_address': '28:76:10:19:7b:b4',
                                                                                                                                                     'rx_link_rate': '144000000',
                                                                                                                                                     'tx_link_rate': '192000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '352761836',
                                                                       'name': 'eth0',
                                                                       'out_octets': '604954426',
                                                                       'poller_hash': 'Mjg3NjEwMGMzNDYxZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQDDRh',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML2_5_60_BF_18_2_3_0_3031_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML2.5-60-BF-18.2.3.0-3031.01")
        exp_info = {
                'model': 'ML2.5-60-BF-18',
                'rf_freq': 64800,
                'rf_tx_power': 14,
                'sta_count': 1,
                'sw_version': '2.3.0-3031',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 53979525305,
                'dl_en_packets': 43478036,
                'dl_en_packets_dropped': 2706,
                'dl_rf_bytes': 54837478228,
                'dl_rf_packets': 47457138,
                'dl_rf_packets_dropped': 0,
                'en_if_speed': 1000000000,
                'ul_en_bytes': 5350566356,
                'ul_en_packets': 28428115,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 5487110537,
                'ul_rf_packets': 31107788,
                'ul_rf_packets_dropped': 2
        }
        exp_sta_stats = {
                '28:76:10:19:f6:76': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 54779946619,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:19:f6:76',
                                             'name': None,
                                             'ul_link_rate': 2502000000,
                                             'ul_rf_bytes': 5389972375,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '2706',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '53979525305',
                                                              'in_ucast_pkts': '43478036',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:17:e3:7f',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '5350565313',
                                                              'out_ucast_pkts': '28428114',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:17:e3:80',
                                                              'mtu': 1500,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1043',
                                                              'out_ucast_pkts': '1',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '2',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '2737',
                                                              'in_octets': '5487110537',
                                                              'in_ucast_pkts': '31105051',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '5389972375',
                                                                                       'mac_address': '28:76:10:19:f6:76',
                                                                                       'out_octets': '54779946619'}],
                                                              'mac_address': '28:76:10:16:a0:43',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '54837478228',
                                                              'out_ucast_pkts': '47457138',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1032530',
                                                                                                                                            'mac_address': '28:76:10:19:f6:76',
                                                                                                                                            'rssi': -48.0,
                                                                                                                                            'rx_link_rate': '2502000000',
                                                                                                                                            'tx_link_rate': '4620000000'}]}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML2.5-60-BF-18',
                                'poller_hash': 'KHYQFqBD',
                                'sw_version': '2.3.0-3031',
                                'system_mac_address': '28:76:10:17:e3:7f',
                                'uptime': '65369'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '54779946619',
                                                                       'links': [       {       'in_octets': '54779946619',
                                                                                                'mac_address': '28:76:10:16:a0:43',
                                                                                                'out_octets': '5389972375'}],
                                                                       'mac_address': '28:76:10:19:f6:76',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '5389972375',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1032530',
                                                                                                                                                     'mac_address': '28:76:10:16:a0:43',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '2502000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '5389972375',
                                                                       'name': 'eth0',
                                                                       'out_octets': '54779946619',
                                                                       'poller_hash': 'Mjg3NjEwMTlmNjc2ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQGfZ2',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML2_5_60_BF_18_2_3_5_3677_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML2.5-60-BF-18.2.3.5-3677.01")
        exp_info = {
                'model': 'ML2.5-60-BF-18',
                'rf_freq': 64800,
                'rf_tx_power': 14,
                'sta_count': 2,
                'sw_version': '2.3.5-3677',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 586607038406,
                'dl_en_packets': 466414687,
                'dl_en_packets_dropped': 5047,
                'dl_rf_bytes': 595364783033,
                'dl_rf_packets': 501253566,
                'dl_rf_packets_dropped': 147,
                'en_if_speed': 1000000000,
                'ul_en_bytes': 40692854574,
                'ul_en_packets': 293376799,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 42407099390,
                'ul_rf_packets': 321189341,
                'ul_rf_packets_dropped': 166
        }
        exp_sta_stats = {
                '28:76:10:19:f6:76': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 1155000000,
                                             'dl_rf_bytes': 63909916824,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:19:f6:76',
                                             'name': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 4636914618,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1c:56:ea': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 310237528,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1c:56:ea',
                                             'name': None,
                                             'ul_link_rate': 3080000000,
                                             'ul_rf_bytes': 36213892,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '5047',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '586607038406',
                                                              'in_ucast_pkts': '466414687',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:17:e3:7f',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '40692853531',
                                                              'out_ucast_pkts': '293376798',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:17:e3:80',
                                                              'mtu': 1500,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1043',
                                                              'out_ucast_pkts': '1',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '166',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '122646',
                                                              'in_octets': '42407099390',
                                                              'in_ucast_pkts': '321066695',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '36213892',
                                                                                       'mac_address': '28:76:10:1c:56:ea',
                                                                                       'out_octets': '310237528'},
                                                                               {       'in_octets': '4636914618',
                                                                                       'mac_address': '28:76:10:19:f6:76',
                                                                                       'out_octets': '63909916824'}],
                                                              'mac_address': '28:76:10:16:a0:43',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '147',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '595364783033',
                                                              'out_ucast_pkts': '501253566',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '17301',
                                                                                                                                            'mac_address': '28:76:10:1c:56:ea',
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_link_rate': '3080000000',
                                                                                                                                            'tx_link_rate': '4620000000'},
                                                                                                                                    {       'connected_time': '411895',
                                                                                                                                            'mac_address': '28:76:10:19:f6:76',
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'tx_link_rate': '1155000000'}]}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML2.5-60-BF-18',
                                'poller_hash': 'KHYQFqBD',
                                'sw_version': '2.3.5-3677',
                                'system_mac_address': '28:76:10:17:e3:7f',
                                'uptime': '3340070'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '310237528',
                                                                       'links': [       {       'in_octets': '310237528',
                                                                                                'mac_address': '28:76:10:16:a0:43',
                                                                                                'out_octets': '36213892'}],
                                                                       'mac_address': '28:76:10:1c:56:ea',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '36213892',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '17301',
                                                                                                                                                     'mac_address': '28:76:10:16:a0:43',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '3080000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '36213892',
                                                                       'name': 'eth0',
                                                                       'out_octets': '310237528',
                                                                       'poller_hash': 'Mjg3NjEwMWM1NmVhZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHFbq',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '63909916824',
                                                                       'links': [       {       'in_octets': '63909916824',
                                                                                                'mac_address': '28:76:10:16:a0:43',
                                                                                                'out_octets': '4636914618'}],
                                                                       'mac_address': '28:76:10:19:f6:76',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '4636914618',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '411895',
                                                                                                                                                     'mac_address': '28:76:10:16:a0:43',
                                                                                                                                                     'rx_link_rate': '1155000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '4636914618',
                                                                       'name': 'eth0',
                                                                       'out_octets': '63909916824',
                                                                       'poller_hash': 'Mjg3NjEwMTlmNjc2ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQGfZ2',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML2_5_60_BF_18_2_4_1_4004_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML2.5-60-BF-18.2.4.1-4004.01")
        exp_info = {
                'model': 'ML2.5-60-BF-18',
                'rf_freq': 64800,
                'rf_tx_power': 14,
                'sta_count': 21,
                'sw_version': '2.4.1-4004',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 11922587622563,
                'dl_en_packets': 54568234,
                'dl_en_packets_dropped': 11615,
                'dl_rf_bytes': 8967166838539,
                'dl_rf_packets': 2725623257,
                'dl_rf_packets_dropped': 35744061,
                'en_if_speed': 1000000000,
                'ul_en_bytes': 673842149617,
                'ul_en_packets': 682735590,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 549593776255,
                'ul_rf_packets': 4115387251,
                'ul_rf_packets_dropped': 28074
        }
        exp_sta_stats = {
                '28:76:10:1a:4d:70': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_rf_bytes': 189195031,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1a:4d:70',
                                             'name': None,
                                             'ul_link_rate': 144000000,
                                             'ul_rf_bytes': 110350717,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1a:4e:68': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 86000000,
                                             'dl_rf_bytes': 766183187,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1a:4e:68',
                                             'name': None,
                                             'ul_link_rate': 144000000,
                                             'ul_rf_bytes': 447279498,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1a:4e:6c': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 86000000,
                                             'dl_rf_bytes': 4369537789,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1a:4e:6c',
                                             'name': None,
                                             'ul_link_rate': 7000000,
                                             'ul_rf_bytes': 979264094,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1a:50:64': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 86000000,
                                             'dl_rf_bytes': 1598417120,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1a:50:64',
                                             'name': None,
                                             'ul_link_rate': 144000000,
                                             'ul_rf_bytes': 932549820,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1a:64:6a': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 1925000000,
                                             'dl_rf_bytes': 602864979678,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1a:64:6a',
                                             'name': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 34809078751,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1a:64:d6': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 2310000000,
                                             'dl_rf_bytes': 642196062341,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1a:64:d6',
                                             'name': None,
                                             'ul_link_rate': 1925000000,
                                             'ul_rf_bytes': 35324124417,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1a:64:ff': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 2310000000,
                                             'dl_rf_bytes': 476830778280,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1a:64:ff',
                                             'name': None,
                                             'ul_link_rate': 1251000000,
                                             'ul_rf_bytes': 39378388107,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1a:65:e8': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 2310000000,
                                             'dl_rf_bytes': 172220993904,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1a:65:e8',
                                             'name': None,
                                             'ul_link_rate': 1155000000,
                                             'ul_rf_bytes': 14199094716,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1b:ff:da': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 2310000000,
                                             'dl_rf_bytes': 1149644640678,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1b:ff:da',
                                             'name': None,
                                             'ul_link_rate': 1251000000,
                                             'ul_rf_bytes': 49589965904,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1c:2c:65': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 1540000000,
                                             'dl_rf_bytes': 186482866327,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1c:2c:65',
                                             'name': None,
                                             'ul_link_rate': 1251000000,
                                             'ul_rf_bytes': 15097116871,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1c:2d:19': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 2310000000,
                                             'dl_rf_bytes': 393122255289,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1c:2d:19',
                                             'name': None,
                                             'ul_link_rate': 1540000000,
                                             'ul_rf_bytes': 20947154574,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1c:5b:40': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 57000000,
                                             'dl_rf_bytes': 1552840134,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1c:5b:40',
                                             'name': None,
                                             'ul_link_rate': 117000000,
                                             'ul_rf_bytes': 932395819,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1c:5d:0c': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_rf_bytes': 84577052495,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1c:5d:0c',
                                             'name': None,
                                             'ul_link_rate': 115000000,
                                             'ul_rf_bytes': 5521829807,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1c:5d:30': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 57000000,
                                             'dl_rf_bytes': 4127898716,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1c:5d:30',
                                             'name': None,
                                             'ul_link_rate': 130000000,
                                             'ul_rf_bytes': 929184866,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1c:96:55': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 2310000000,
                                             'dl_rf_bytes': 474365611861,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1c:96:55',
                                             'name': None,
                                             'ul_link_rate': 1251000000,
                                             'ul_rf_bytes': 53260810581,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1d:6d:dc': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 57000000,
                                             'dl_rf_bytes': 1884389398,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1d:6d:dc',
                                             'name': None,
                                             'ul_link_rate': 115000000,
                                             'ul_rf_bytes': 943082645,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1d:6d:e0': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 86000000,
                                             'dl_rf_bytes': 1456597058,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1d:6d:e0',
                                             'name': None,
                                             'ul_link_rate': 192000000,
                                             'ul_rf_bytes': 850210611,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1d:6e:e8': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 86000000,
                                             'dl_rf_bytes': 1420110290,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1d:6e:e8',
                                             'name': None,
                                             'ul_link_rate': 144000000,
                                             'ul_rf_bytes': 784381015,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1d:82:6d': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 1925000000,
                                             'dl_rf_bytes': 328213275153,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1d:82:6d',
                                             'name': None,
                                             'ul_link_rate': 1251000000,
                                             'ul_rf_bytes': 30327134157,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1d:83:2b': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 2310000000,
                                             'dl_rf_bytes': 341889962410,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1d:83:2b',
                                             'name': None,
                                             'ul_link_rate': 1251000000,
                                             'ul_rf_bytes': 25706281084,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1d:83:40': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 2310000000,
                                             'dl_rf_bytes': 756932689042,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1d:83:40',
                                             'name': None,
                                             'ul_link_rate': 1925000000,
                                             'ul_rf_bytes': 32546589743,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '11615',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '11922587622563',
                                                              'in_ucast_pkts': '54568234',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:0c:46:9e',
                                                              'mtu': 7912,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '673842148574',
                                                              'out_ucast_pkts': '682735589',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:0c:46:9f',
                                                              'mtu': 7912,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1043',
                                                              'out_ucast_pkts': '1',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '28074',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '2698432',
                                                              'in_octets': '549593776255',
                                                              'in_ucast_pkts': '4112688819',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '932395819',
                                                                                       'mac_address': '28:76:10:1c:5b:40',
                                                                                       'out_octets': '1552840134'},
                                                                               {       'in_octets': '110350717',
                                                                                       'mac_address': '28:76:10:1a:4d:70',
                                                                                       'out_octets': '189195031'},
                                                                               {       'in_octets': '20947154574',
                                                                                       'mac_address': '28:76:10:1c:2d:19',
                                                                                       'out_octets': '393122255289'},
                                                                               {       'in_octets': '53260810581',
                                                                                       'mac_address': '28:76:10:1c:96:55',
                                                                                       'out_octets': '474365611861'},
                                                                               {       'in_octets': '15097116871',
                                                                                       'mac_address': '28:76:10:1c:2c:65',
                                                                                       'out_octets': '186482866327'},
                                                                               {       'in_octets': '49589965904',
                                                                                       'mac_address': '28:76:10:1b:ff:da',
                                                                                       'out_octets': '1149644640678'},
                                                                               {       'in_octets': '30327134157',
                                                                                       'mac_address': '28:76:10:1d:82:6d',
                                                                                       'out_octets': '328213275153'},
                                                                               {       'in_octets': '14199094716',
                                                                                       'mac_address': '28:76:10:1a:65:e8',
                                                                                       'out_octets': '172220993904'},
                                                                               {       'in_octets': '32546589743',
                                                                                       'mac_address': '28:76:10:1d:83:40',
                                                                                       'out_octets': '756932689042'},
                                                                               {       'in_octets': '39378388107',
                                                                                       'mac_address': '28:76:10:1a:64:ff',
                                                                                       'out_octets': '476830778280'},
                                                                               {       'in_octets': '35324124417',
                                                                                       'mac_address': '28:76:10:1a:64:d6',
                                                                                       'out_octets': '642196062341'},
                                                                               {       'in_octets': '5521829807',
                                                                                       'mac_address': '28:76:10:1c:5d:0c',
                                                                                       'out_octets': '84577052495'},
                                                                               {       'in_octets': '25706281084',
                                                                                       'mac_address': '28:76:10:1d:83:2b',
                                                                                       'out_octets': '341889962410'},
                                                                               {       'in_octets': '34809078751',
                                                                                       'mac_address': '28:76:10:1a:64:6a',
                                                                                       'out_octets': '602864979678'},
                                                                               {       'in_octets': '932549820',
                                                                                       'mac_address': '28:76:10:1a:50:64',
                                                                                       'out_octets': '1598417120'},
                                                                               {       'in_octets': '943082645',
                                                                                       'mac_address': '28:76:10:1d:6d:dc',
                                                                                       'out_octets': '1884389398'},
                                                                               {       'in_octets': '979264094',
                                                                                       'mac_address': '28:76:10:1a:4e:6c',
                                                                                       'out_octets': '4369537789'},
                                                                               {       'in_octets': '929184866',
                                                                                       'mac_address': '28:76:10:1c:5d:30',
                                                                                       'out_octets': '4127898716'},
                                                                               {       'in_octets': '850210611',
                                                                                       'mac_address': '28:76:10:1d:6d:e0',
                                                                                       'out_octets': '1456597058'},
                                                                               {       'in_octets': '784381015',
                                                                                       'mac_address': '28:76:10:1d:6e:e8',
                                                                                       'out_octets': '1420110290'},
                                                                               {       'in_octets': '447279498',
                                                                                       'mac_address': '28:76:10:1a:4e:68',
                                                                                       'out_octets': '766183187'}],
                                                              'mac_address': '28:76:10:0c:30:40',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '35744061',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '8967166838539',
                                                              'out_ucast_pkts': '2725623257',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '3636153',
                                                                                                                                            'mac_address': '28:76:10:1c:5b:40',
                                                                                                                                            'rx_link_rate': '117000000',
                                                                                                                                            'tx_link_rate': '57000000'},
                                                                                                                                    {       'connected_time': '429473',
                                                                                                                                            'mac_address': '28:76:10:1a:4d:70',
                                                                                                                                            'rx_link_rate': '144000000',
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'connected_time': '1738766',
                                                                                                                                            'mac_address': '28:76:10:1c:2d:19',
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '1540000000',
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'connected_time': '1743565',
                                                                                                                                            'mac_address': '28:76:10:1c:96:55',
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '1251000000',
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'connected_time': '22483',
                                                                                                                                            'mac_address': '28:76:10:1c:2c:65',
                                                                                                                                            'rssi': -74.0,
                                                                                                                                            'rx_link_rate': '1251000000',
                                                                                                                                            'tx_link_rate': '1540000000'},
                                                                                                                                    {       'connected_time': '22306',
                                                                                                                                            'mac_address': '28:76:10:1b:ff:da',
                                                                                                                                            'rssi': -74.0,
                                                                                                                                            'rx_link_rate': '1251000000',
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'connected_time': '22691',
                                                                                                                                            'mac_address': '28:76:10:1d:82:6d',
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '1251000000',
                                                                                                                                            'tx_link_rate': '1925000000'},
                                                                                                                                    {       'connected_time': '429415',
                                                                                                                                            'mac_address': '28:76:10:1a:65:e8',
                                                                                                                                            'rssi': -75.0,
                                                                                                                                            'rx_link_rate': '1155000000',
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'connected_time': '1738757',
                                                                                                                                            'mac_address': '28:76:10:1d:83:40',
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_link_rate': '1925000000',
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'connected_time': '1738754',
                                                                                                                                            'mac_address': '28:76:10:1a:64:ff',
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '1251000000',
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'connected_time': '1738759',
                                                                                                                                            'mac_address': '28:76:10:1a:64:d6',
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_link_rate': '1925000000',
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'connected_time': '3636150',
                                                                                                                                            'mac_address': '28:76:10:1c:5d:0c',
                                                                                                                                            'rx_link_rate': '115000000',
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'connected_time': '1124098',
                                                                                                                                            'mac_address': '28:76:10:1d:83:2b',
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_link_rate': '1251000000',
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'connected_time': '26907',
                                                                                                                                            'mac_address': '28:76:10:1a:64:6a',
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'tx_link_rate': '1925000000'},
                                                                                                                                    {       'connected_time': '3636148',
                                                                                                                                            'mac_address': '28:76:10:1a:50:64',
                                                                                                                                            'rx_link_rate': '144000000',
                                                                                                                                            'tx_link_rate': '86000000'},
                                                                                                                                    {       'connected_time': '3636148',
                                                                                                                                            'mac_address': '28:76:10:1d:6d:dc',
                                                                                                                                            'rx_link_rate': '115000000',
                                                                                                                                            'tx_link_rate': '57000000'},
                                                                                                                                    {       'connected_time': '3635770',
                                                                                                                                            'mac_address': '28:76:10:1a:4e:6c',
                                                                                                                                            'rx_link_rate': '7000000',
                                                                                                                                            'tx_link_rate': '86000000'},
                                                                                                                                    {       'connected_time': '3455256',
                                                                                                                                            'mac_address': '28:76:10:1c:5d:30',
                                                                                                                                            'rx_link_rate': '130000000',
                                                                                                                                            'tx_link_rate': '57000000'},
                                                                                                                                    {       'connected_time': '3319069',
                                                                                                                                            'mac_address': '28:76:10:1d:6d:e0',
                                                                                                                                            'rx_link_rate': '192000000',
                                                                                                                                            'tx_link_rate': '86000000'},
                                                                                                                                    {       'connected_time': '3046607',
                                                                                                                                            'mac_address': '28:76:10:1d:6e:e8',
                                                                                                                                            'rx_link_rate': '144000000',
                                                                                                                                            'tx_link_rate': '86000000'},
                                                                                                                                    {       'connected_time': '1743228',
                                                                                                                                            'mac_address': '28:76:10:1a:4e:68',
                                                                                                                                            'rx_link_rate': '144000000',
                                                                                                                                            'tx_link_rate': '86000000'}]}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML2.5-60-BF-18',
                                'poller_hash': 'KHYQDDBA',
                                'sw_version': '2.4.1-4004',
                                'system_mac_address': '28:76:10:0c:46:9e',
                                'uptime': '3636175'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '1552840134',
                                                                       'links': [       {       'in_octets': '1552840134',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '932395819'}],
                                                                       'mac_address': '28:76:10:1c:5b:40',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '932395819',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3636153',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '57000000',
                                                                                                                                                     'tx_link_rate': '117000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '932395819',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1552840134',
                                                                       'poller_hash': 'Mjg3NjEwMWM1YjQwZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHFtA',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '189195031',
                                                                       'links': [       {       'in_octets': '189195031',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '110350717'}],
                                                                       'mac_address': '28:76:10:1a:4d:70',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '110350717',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '429473',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'tx_link_rate': '144000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '110350717',
                                                                       'name': 'eth0',
                                                                       'out_octets': '189195031',
                                                                       'poller_hash': 'Mjg3NjEwMWE0ZDcwZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQGk1w',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '393122255289',
                                                                       'links': [       {       'in_octets': '393122255289',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '20947154574'}],
                                                                       'mac_address': '28:76:10:1c:2d:19',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '20947154574',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1738766',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '2310000000',
                                                                                                                                                     'tx_link_rate': '1540000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '20947154574',
                                                                       'name': 'eth0',
                                                                       'out_octets': '393122255289',
                                                                       'poller_hash': 'Mjg3NjEwMWMyZDE5ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHC0Z',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '474365611861',
                                                                       'links': [       {       'in_octets': '474365611861',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '53260810581'}],
                                                                       'mac_address': '28:76:10:1c:96:55',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '53260810581',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1743565',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '2310000000',
                                                                                                                                                     'tx_link_rate': '1251000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '53260810581',
                                                                       'name': 'eth0',
                                                                       'out_octets': '474365611861',
                                                                       'poller_hash': 'Mjg3NjEwMWM5NjU1ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHJZV',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '186482866327',
                                                                       'links': [       {       'in_octets': '186482866327',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '15097116871'}],
                                                                       'mac_address': '28:76:10:1c:2c:65',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '15097116871',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '22483',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '1540000000',
                                                                                                                                                     'tx_link_rate': '1251000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '15097116871',
                                                                       'name': 'eth0',
                                                                       'out_octets': '186482866327',
                                                                       'poller_hash': 'Mjg3NjEwMWMyYzY1ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHCxl',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '1149644640678',
                                                                       'links': [       {       'in_octets': '1149644640678',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '49589965904'}],
                                                                       'mac_address': '28:76:10:1b:ff:da',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '49589965904',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '22306',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '2310000000',
                                                                                                                                                     'tx_link_rate': '1251000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '49589965904',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1149644640678',
                                                                       'poller_hash': 'Mjg3NjEwMWJmZmRhZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQG//a',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '328213275153',
                                                                       'links': [       {       'in_octets': '328213275153',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '30327134157'}],
                                                                       'mac_address': '28:76:10:1d:82:6d',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '30327134157',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '22691',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '1925000000',
                                                                                                                                                     'tx_link_rate': '1251000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '30327134157',
                                                                       'name': 'eth0',
                                                                       'out_octets': '328213275153',
                                                                       'poller_hash': 'Mjg3NjEwMWQ4MjZkZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHYJt',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '172220993904',
                                                                       'links': [       {       'in_octets': '172220993904',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '14199094716'}],
                                                                       'mac_address': '28:76:10:1a:65:e8',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '14199094716',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '429415',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '2310000000',
                                                                                                                                                     'tx_link_rate': '1155000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '14199094716',
                                                                       'name': 'eth0',
                                                                       'out_octets': '172220993904',
                                                                       'poller_hash': 'Mjg3NjEwMWE2NWU4ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQGmXo',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '756932689042',
                                                                       'links': [       {       'in_octets': '756932689042',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '32546589743'}],
                                                                       'mac_address': '28:76:10:1d:83:40',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '32546589743',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1738757',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '2310000000',
                                                                                                                                                     'tx_link_rate': '1925000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '32546589743',
                                                                       'name': 'eth0',
                                                                       'out_octets': '756932689042',
                                                                       'poller_hash': 'Mjg3NjEwMWQ4MzQwZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHYNA',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '476830778280',
                                                                       'links': [       {       'in_octets': '476830778280',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '39378388107'}],
                                                                       'mac_address': '28:76:10:1a:64:ff',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '39378388107',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1738754',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '2310000000',
                                                                                                                                                     'tx_link_rate': '1251000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '39378388107',
                                                                       'name': 'eth0',
                                                                       'out_octets': '476830778280',
                                                                       'poller_hash': 'Mjg3NjEwMWE2NGZmZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQGmT/',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '642196062341',
                                                                       'links': [       {       'in_octets': '642196062341',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '35324124417'}],
                                                                       'mac_address': '28:76:10:1a:64:d6',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '35324124417',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1738759',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '2310000000',
                                                                                                                                                     'tx_link_rate': '1925000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '35324124417',
                                                                       'name': 'eth0',
                                                                       'out_octets': '642196062341',
                                                                       'poller_hash': 'Mjg3NjEwMWE2NGQ2ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQGmTW',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '84577052495',
                                                                       'links': [       {       'in_octets': '84577052495',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '5521829807'}],
                                                                       'mac_address': '28:76:10:1c:5d:0c',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '5521829807',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3636150',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'tx_link_rate': '115000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '5521829807',
                                                                       'name': 'eth0',
                                                                       'out_octets': '84577052495',
                                                                       'poller_hash': 'Mjg3NjEwMWM1ZDBjZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHF0M',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '341889962410',
                                                                       'links': [       {       'in_octets': '341889962410',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '25706281084'}],
                                                                       'mac_address': '28:76:10:1d:83:2b',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '25706281084',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1124098',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '2310000000',
                                                                                                                                                     'tx_link_rate': '1251000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '25706281084',
                                                                       'name': 'eth0',
                                                                       'out_octets': '341889962410',
                                                                       'poller_hash': 'Mjg3NjEwMWQ4MzJiZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHYMr',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '602864979678',
                                                                       'links': [       {       'in_octets': '602864979678',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '34809078751'}],
                                                                       'mac_address': '28:76:10:1a:64:6a',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '34809078751',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '26907',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '1925000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '34809078751',
                                                                       'name': 'eth0',
                                                                       'out_octets': '602864979678',
                                                                       'poller_hash': 'Mjg3NjEwMWE2NDZhZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQGmRq',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '1598417120',
                                                                       'links': [       {       'in_octets': '1598417120',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '932549820'}],
                                                                       'mac_address': '28:76:10:1a:50:64',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '932549820',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3636148',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '86000000',
                                                                                                                                                     'tx_link_rate': '144000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '932549820',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1598417120',
                                                                       'poller_hash': 'Mjg3NjEwMWE1MDY0ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQGlBk',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '1884389398',
                                                                       'links': [       {       'in_octets': '1884389398',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '943082645'}],
                                                                       'mac_address': '28:76:10:1d:6d:dc',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '943082645',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3636148',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '57000000',
                                                                                                                                                     'tx_link_rate': '115000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '943082645',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1884389398',
                                                                       'poller_hash': 'Mjg3NjEwMWQ2ZGRjZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHW3c',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '4369537789',
                                                                       'links': [       {       'in_octets': '4369537789',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '979264094'}],
                                                                       'mac_address': '28:76:10:1a:4e:6c',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '979264094',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3635770',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '86000000',
                                                                                                                                                     'tx_link_rate': '7000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '979264094',
                                                                       'name': 'eth0',
                                                                       'out_octets': '4369537789',
                                                                       'poller_hash': 'Mjg3NjEwMWE0ZTZjZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQGk5s',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '4127898716',
                                                                       'links': [       {       'in_octets': '4127898716',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '929184866'}],
                                                                       'mac_address': '28:76:10:1c:5d:30',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '929184866',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3455256',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '57000000',
                                                                                                                                                     'tx_link_rate': '130000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '929184866',
                                                                       'name': 'eth0',
                                                                       'out_octets': '4127898716',
                                                                       'poller_hash': 'Mjg3NjEwMWM1ZDMwZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHF0w',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '1456597058',
                                                                       'links': [       {       'in_octets': '1456597058',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '850210611'}],
                                                                       'mac_address': '28:76:10:1d:6d:e0',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '850210611',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3319069',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '86000000',
                                                                                                                                                     'tx_link_rate': '192000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '850210611',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1456597058',
                                                                       'poller_hash': 'Mjg3NjEwMWQ2ZGUwZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHW3g',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '1420110290',
                                                                       'links': [       {       'in_octets': '1420110290',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '784381015'}],
                                                                       'mac_address': '28:76:10:1d:6e:e8',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '784381015',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3046607',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '86000000',
                                                                                                                                                     'tx_link_rate': '144000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '784381015',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1420110290',
                                                                       'poller_hash': 'Mjg3NjEwMWQ2ZWU4ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHW7o',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '766183187',
                                                                       'links': [       {       'in_octets': '766183187',
                                                                                                'mac_address': '28:76:10:0c:30:40',
                                                                                                'out_octets': '447279498'}],
                                                                       'mac_address': '28:76:10:1a:4e:68',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '447279498',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1743228',
                                                                                                                                                     'mac_address': '28:76:10:0c:30:40',
                                                                                                                                                     'rx_link_rate': '86000000',
                                                                                                                                                     'tx_link_rate': '144000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '447279498',
                                                                       'name': 'eth0',
                                                                       'out_octets': '766183187',
                                                                       'poller_hash': 'Mjg3NjEwMWE0ZTY4ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQGk5o',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML2_5_60_BF_18_2_4_2_4104_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML2.5-60-BF-18.2.4.2-4104.01")
        exp_info = {
                'model': 'ML2.5-60-BF-18',
                'rf_freq': 64800,
                'rf_tx_power': 14,
                'sta_count': 2,
                'sw_version': '2.4.2-4104',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 334895700707,
                'dl_en_packets': 455721741,
                'dl_en_packets_dropped': 498,
                'dl_rf_bytes': 270757683561,
                'dl_rf_packets': 383131131,
                'dl_rf_packets_dropped': 2,
                'en_if_speed': 2500000000,
                'ul_en_bytes': 843015408774,
                'ul_en_packets': 562977146,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 743052683841,
                'ul_rf_packets': 496099501,
                'ul_rf_packets_dropped': 20
        }
        exp_sta_stats = {
                '28:76:10:16:a0:cf': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 10524935,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:16:a0:cf',
                                             'name': None,
                                             'ul_link_rate': 4620000000,
                                             'ul_rf_bytes': 8475623,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:17:e1:2e': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 866000000,
                                             'dl_rf_bytes': 9465550,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:17:e1:2e',
                                             'name': None,
                                             'ul_link_rate': 866000000,
                                             'ul_rf_bytes': 5524229,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '498',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '334895700707',
                                                              'in_ucast_pkts': '455721741',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:19:80:4a',
                                                              'mtu': 7912,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '843015407731',
                                                              'out_ucast_pkts': '562977145',
                                                              'speed': '2500000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:19:80:4b',
                                                              'mtu': 7912,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1043',
                                                              'out_ucast_pkts': '1',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '20',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '5029',
                                                              'in_octets': '743052683841',
                                                              'in_ucast_pkts': '496094472',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '5524229',
                                                                                       'mac_address': '28:76:10:17:e1:2e',
                                                                                       'out_octets': '9465550'},
                                                                               {       'in_octets': '8475623',
                                                                                       'mac_address': '28:76:10:16:a0:cf',
                                                                                       'out_octets': '10524935'}],
                                                              'mac_address': '28:76:10:17:dd:3e',
                                                              'mtu': 7912,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '2',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '270757683561',
                                                              'out_ucast_pkts': '383131131',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '21543',
                                                                                                                                            'mac_address': '28:76:10:17:e1:2e',
                                                                                                                                            'rx_link_rate': '866000000',
                                                                                                                                            'tx_link_rate': '866000000'},
                                                                                                                                    {       'connected_time': '21540',
                                                                                                                                            'mac_address': '28:76:10:16:a0:cf',
                                                                                                                                            'rssi': -45.0,
                                                                                                                                            'rx_link_rate': '4620000000',
                                                                                                                                            'tx_link_rate': '4620000000'}]}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML2.5-60-BF-18',
                                'poller_hash': 'KHYQF90+',
                                'sw_version': '2.4.2-4104',
                                'system_mac_address': '28:76:10:19:80:4a',
                                'uptime': '184804'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '9465550',
                                                                       'links': [       {       'in_octets': '9465550',
                                                                                                'mac_address': '28:76:10:17:dd:3e',
                                                                                                'out_octets': '5524229'}],
                                                                       'mac_address': '28:76:10:17:e1:2e',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '5524229',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '21543',
                                                                                                                                                     'mac_address': '28:76:10:17:dd:3e',
                                                                                                                                                     'rx_link_rate': '866000000',
                                                                                                                                                     'tx_link_rate': '866000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '5524229',
                                                                       'name': 'eth0',
                                                                       'out_octets': '9465550',
                                                                       'poller_hash': 'Mjg3NjEwMTdlMTJlZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQF+Eu',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '10524935',
                                                                       'links': [       {       'in_octets': '10524935',
                                                                                                'mac_address': '28:76:10:17:dd:3e',
                                                                                                'out_octets': '8475623'}],
                                                                       'mac_address': '28:76:10:16:a0:cf',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '8475623',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '21540',
                                                                                                                                                     'mac_address': '28:76:10:17:dd:3e',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '4620000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '8475623',
                                                                       'name': 'eth0',
                                                                       'out_octets': '10524935',
                                                                       'poller_hash': 'Mjg3NjEwMTZhMGNmZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQFqDP',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML2_5_60_BF_35_2_5_0_4225_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML2.5-60-BF-35.2.5.0-4225.01")
        exp_info = {
                'model': 'ML2.5-60-35',
                'rf_freq': 64800,
                'rf_tx_power': 14,
                'sta_count': 1,
                'sw_version': '2.5.0-4225',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 2662820225314,
                'dl_en_packets': 2508051197,
                'dl_en_packets_dropped': 186,
                'dl_rf_bytes': 2138222810929,
                'dl_rf_packets': 2038244218,
                'dl_rf_packets_dropped': 444,
                'en_if_speed': 1000000000,
                'ul_en_bytes': 541852866402,
                'ul_en_packets': 1510632385,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 421234513416,
                'ul_rf_packets': 1252476571,
                'ul_rf_packets_dropped': 30
        }
        exp_sta_stats = {
                '28:76:10:1e:b7:64': {       'alt_macs': ['28:76:10:1e:ab:65'],
                                             'dev_macs': None,
                                             'dl_link_rate': 300000000,
                                             'dl_rf_bytes': 7145671994,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1e:b7:64',
                                             'name': 'church-to-home-newest',
                                             'ul_link_rate': 240000000,
                                             'ul_rf_bytes': 4041538821,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '185',
                                                              'in_errors': '1',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2662820225314',
                                                              'in_ucast_pkts': '2508051197',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:1c:37:1f',
                                                              'mtu': 7912,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '541852866402',
                                                              'out_ucast_pkts': '1510632385',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:1c:37:20',
                                                              'mtu': 7912,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '30',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '165851',
                                                              'in_octets': '421234513416',
                                                              'in_ucast_pkts': '1252310720',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '4041538821',
                                                                                       'mac_address': '28:76:10:1e:b7:64',
                                                                                       'out_octets': '7145671994'}],
                                                              'mac_address': '28:76:10:1c:2c:9f',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '444',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2138222810929',
                                                              'out_ucast_pkts': '2038244218',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '9166945',
                                                                                                                                            'mac_address': '28:76:10:1e:b7:64',
                                                                                                                                            'rx_link_rate': '240000000',
                                                                                                                                            'tx_link_rate': '300000000'}]}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML2.5-60-35',
                                'poller_hash': 'KHYQHCyf',
                                'sw_version': '2.5.0-4225',
                                'system_mac_address': '28:76:10:1c:37:1f',
                                'uptime': '9301990'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '7145671994',
                                                                       'links': [       {       'in_octets': '7145671994',
                                                                                                'mac_address': '28:76:10:1c:2c:9f',
                                                                                                'out_octets': '4041538821'}],
                                                                       'mac_address': '28:76:10:1e:b7:64',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '4041538821',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '9166945',
                                                                                                                                                     'mac_address': '28:76:10:1c:2c:9f',
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'tx_link_rate': '240000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '4041538821',
                                                                       'mac_address': '28:76:10:1e:ab:65',
                                                                       'name': 'eth0',
                                                                       'out_octets': '7145671994',
                                                                       'poller_hash': 'Mjg3NjEwMWViNzY0ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'name': 'church-to-home-newest',
                                         'poller_hash': 'KHYQHrdk',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML_60_10G_360_2_3_0_3059_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML-60-10G-360.2.3.0-3059.01")
        exp_info = {
                'model': 'ML-60-10G-360',
                'rf_freq': 62640,
                'rf_tx_power': 14,
                'sta_count': 7,
                'sw_version': '2.3.0-3059',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 3862914595232,
                'dl_en_packets': 3500263378,
                'dl_en_packets_dropped': 0,
                'dl_rf_bytes': 4003093853764,
                'dl_rf_packets': 4810630805,
                'dl_rf_packets_dropped': 31,
                'en_if_speed': 1410065408,
                'ul_en_bytes': 257917896700,
                'ul_en_packets': 1776417994,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 260935866055,
                'ul_rf_packets': 1828435987,
                'ul_rf_packets_dropped': 10
        }
        exp_sta_stats = {
                '28:76:10:13:4f:c3': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 1251000000,
                                             'dl_rf_bytes': 33705265290,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:13:4f:c3',
                                             'name': None,
                                             'ul_link_rate': 1251000000,
                                             'ul_rf_bytes': 3013818437,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:13:51:51': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 2502000000,
                                             'dl_rf_bytes': 376689919587,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:13:51:51',
                                             'name': None,
                                             'ul_link_rate': 2502000000,
                                             'ul_rf_bytes': 43304964263,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:17:f4:70': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 733013635650,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:17:f4:70',
                                             'name': None,
                                             'ul_link_rate': 4620000000,
                                             'ul_rf_bytes': 27855772902,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:17:f4:9a': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 230788474052,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:17:f4:9a',
                                             'name': None,
                                             'ul_link_rate': 4620000000,
                                             'ul_rf_bytes': 17477921535,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1a:64:bb': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 1306814142079,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1a:64:bb',
                                             'name': None,
                                             'ul_link_rate': 3080000000,
                                             'ul_rf_bytes': 81237485259,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1a:65:e3': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 178394668614,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1a:65:e3',
                                             'name': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 6921636257,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1a:66:0f': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 440582589039,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1a:66:0f',
                                             'name': None,
                                             'ul_link_rate': 3850000000,
                                             'ul_rf_bytes': 35839987706,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '305863',
                                                              'in_octets': '13148180186',
                                                              'in_ucast_pkts': '151553796',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:14:c2:ea',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '28',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '179952540190',
                                                              'out_ucast_pkts': '404581342',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1'}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '3862914595232',
                                                              'in_ucast_pkts': '3500263378',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:15:c8:64',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '257917896700',
                                                              'out_ucast_pkts': '1776417994',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:15:c8:65',
                                                              'mtu': 1500,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'speed': '1410065408',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '10',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '835710',
                                                              'in_octets': '197694984057',
                                                              'in_ucast_pkts': '1331450648',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '17477921535',
                                                                                       'mac_address': '28:76:10:17:f4:9a',
                                                                                       'out_octets': '230788474052'},
                                                                               {       'in_octets': '27855772902',
                                                                                       'mac_address': '28:76:10:17:f4:70',
                                                                                       'out_octets': '733013635650'},
                                                                               {       'in_octets': '81237485259',
                                                                                       'mac_address': '28:76:10:1a:64:bb',
                                                                                       'out_octets': '1306814142079'},
                                                                               {       'in_octets': '43304964263',
                                                                                       'mac_address': '28:76:10:13:51:51',
                                                                                       'out_octets': '376689919587'},
                                                                               {       'in_octets': '3013818437',
                                                                                       'mac_address': '28:76:10:13:4f:c3',
                                                                                       'out_octets': '33705265290'},
                                                                               {       'in_octets': '35839987706',
                                                                                       'mac_address': '28:76:10:1a:66:0f',
                                                                                       'out_octets': '440582589039'},
                                                                               {       'in_octets': '6921636257',
                                                                                       'mac_address': '28:76:10:1a:65:e3',
                                                                                       'out_octets': '178394668614'}],
                                                              'mac_address': '28:76:10:14:c0:ff',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3084440625601',
                                                              'out_ucast_pkts': '3310422178',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1539793',
                                                                                                                                            'mac_address': '28:76:10:17:f4:9a',
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '4620000000',
                                                                                                                                            'tx_link_rate': '4620000000'},
                                                                                                                                    {       'connected_time': '2593193',
                                                                                                                                            'mac_address': '28:76:10:17:f4:70',
                                                                                                                                            'rssi': -49.0,
                                                                                                                                            'rx_link_rate': '4620000000',
                                                                                                                                            'tx_link_rate': '4620000000'},
                                                                                                                                    {       'connected_time': '2593173',
                                                                                                                                            'mac_address': '28:76:10:1a:64:bb',
                                                                                                                                            'rssi': -40.0,
                                                                                                                                            'rx_link_rate': '3080000000',
                                                                                                                                            'tx_link_rate': '4620000000'},
                                                                                                                                    {       'connected_time': '1379527',
                                                                                                                                            'mac_address': '28:76:10:13:51:51',
                                                                                                                                            'rssi': -54.0,
                                                                                                                                            'rx_link_rate': '2502000000',
                                                                                                                                            'tx_link_rate': '2502000000'},
                                                                                                                                    {       'connected_time': '586587',
                                                                                                                                            'mac_address': '28:76:10:13:4f:c3',
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '1251000000',
                                                                                                                                            'tx_link_rate': '1251000000'},
                                                                                                                                    {       'connected_time': '2593150',
                                                                                                                                            'mac_address': '28:76:10:1a:66:0f',
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '3850000000',
                                                                                                                                            'tx_link_rate': '4620000000'},
                                                                                                                                    {       'connected_time': '1201819',
                                                                                                                                            'mac_address': '28:76:10:1a:65:e3',
                                                                                                                                            'rssi': -42.0,
                                                                                                                                            'tx_link_rate': '4620000000'}]}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML-60-10G-360',
                                'poller_hash': 'KHYQFMD/',
                                'sw_version': '2.3.0-3059',
                                'system_mac_address': '28:76:10:15:c8:64',
                                'uptime': '2593216'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '230788474052',
                                                                       'links': [       {       'in_octets': '230788474052',
                                                                                                'mac_address': '28:76:10:14:c0:ff',
                                                                                                'out_octets': '17477921535'}],
                                                                       'mac_address': '28:76:10:17:f4:9a',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '17477921535',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1539793',
                                                                                                                                                     'mac_address': '28:76:10:14:c0:ff',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '4620000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '17477921535',
                                                                       'name': 'eth0',
                                                                       'out_octets': '230788474052',
                                                                       'poller_hash': 'Mjg3NjEwMTdmNDlhZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQF/Sa',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '733013635650',
                                                                       'links': [       {       'in_octets': '733013635650',
                                                                                                'mac_address': '28:76:10:14:c0:ff',
                                                                                                'out_octets': '27855772902'}],
                                                                       'mac_address': '28:76:10:17:f4:70',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '27855772902',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2593193',
                                                                                                                                                     'mac_address': '28:76:10:14:c0:ff',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '4620000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '27855772902',
                                                                       'name': 'eth0',
                                                                       'out_octets': '733013635650',
                                                                       'poller_hash': 'Mjg3NjEwMTdmNDcwZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQF/Rw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '1306814142079',
                                                                       'links': [       {       'in_octets': '1306814142079',
                                                                                                'mac_address': '28:76:10:14:c0:ff',
                                                                                                'out_octets': '81237485259'}],
                                                                       'mac_address': '28:76:10:1a:64:bb',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '81237485259',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2593173',
                                                                                                                                                     'mac_address': '28:76:10:14:c0:ff',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '3080000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '81237485259',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1306814142079',
                                                                       'poller_hash': 'Mjg3NjEwMWE2NGJiZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQGmS7',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '376689919587',
                                                                       'links': [       {       'in_octets': '376689919587',
                                                                                                'mac_address': '28:76:10:14:c0:ff',
                                                                                                'out_octets': '43304964263'}],
                                                                       'mac_address': '28:76:10:13:51:51',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '43304964263',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1379527',
                                                                                                                                                     'mac_address': '28:76:10:14:c0:ff',
                                                                                                                                                     'rx_link_rate': '2502000000',
                                                                                                                                                     'tx_link_rate': '2502000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '43304964263',
                                                                       'name': 'eth0',
                                                                       'out_octets': '376689919587',
                                                                       'poller_hash': 'Mjg3NjEwMTM1MTUxZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQE1FR',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '33705265290',
                                                                       'links': [       {       'in_octets': '33705265290',
                                                                                                'mac_address': '28:76:10:14:c0:ff',
                                                                                                'out_octets': '3013818437'}],
                                                                       'mac_address': '28:76:10:13:4f:c3',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3013818437',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '586587',
                                                                                                                                                     'mac_address': '28:76:10:14:c0:ff',
                                                                                                                                                     'rx_link_rate': '1251000000',
                                                                                                                                                     'tx_link_rate': '1251000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3013818437',
                                                                       'name': 'eth0',
                                                                       'out_octets': '33705265290',
                                                                       'poller_hash': 'Mjg3NjEwMTM0ZmMzZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQE0/D',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '440582589039',
                                                                       'links': [       {       'in_octets': '440582589039',
                                                                                                'mac_address': '28:76:10:14:c0:ff',
                                                                                                'out_octets': '35839987706'}],
                                                                       'mac_address': '28:76:10:1a:66:0f',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '35839987706',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2593150',
                                                                                                                                                     'mac_address': '28:76:10:14:c0:ff',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '3850000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '35839987706',
                                                                       'name': 'eth0',
                                                                       'out_octets': '440582589039',
                                                                       'poller_hash': 'Mjg3NjEwMWE2NjBmZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQGmYP',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '178394668614',
                                                                       'links': [       {       'in_octets': '178394668614',
                                                                                                'mac_address': '28:76:10:14:c0:ff',
                                                                                                'out_octets': '6921636257'}],
                                                                       'mac_address': '28:76:10:1a:65:e3',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '6921636257',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1201819',
                                                                                                                                                     'mac_address': '28:76:10:14:c0:ff',
                                                                                                                                                     'rx_link_rate': '4620000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '6921636257',
                                                                       'name': 'eth0',
                                                                       'out_octets': '178394668614',
                                                                       'poller_hash': 'Mjg3NjEwMWE2NWUzZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQGmXj',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML_60_10G_360_2_3_5_3677_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML-60-10G-360.2.3.5-3677.01")
        exp_info = {
                'model': 'ML-60-10G-360',
                'rf_freq': 62640,
                'rf_tx_power': 14,
                'sta_count': 2,
                'sw_version': '2.3.5-3677',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 3788318687687,
                'dl_en_packets': 109812369,
                'dl_en_packets_dropped': 15614,
                'dl_rf_bytes': 3656887243508,
                'dl_rf_packets': 4203328386,
                'dl_rf_packets_dropped': 14,
                'en_if_speed': 10000000000,
                'ul_en_bytes': 1989472396974,
                'ul_en_packets': 3608018132,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 1969758333277,
                'ul_rf_packets': 3611581374,
                'ul_rf_packets_dropped': 609
        }
        exp_sta_stats = {
                '28:76:10:13:63:b8': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 2502000000,
                                             'dl_rf_bytes': 714576582560,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:13:63:b8',
                                             'name': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 829933976964,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:13:9f:82': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 65000000,
                                             'dl_rf_bytes': 35888055399,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:13:9f:82',
                                             'name': None,
                                             'ul_link_rate': 72000000,
                                             'ul_rf_bytes': 20272190665,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '1',
                                                              'in_errors': '15613',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '3788318687687',
                                                              'in_ucast_pkts': '109812369',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:15:c8:d6',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1989472396974',
                                                              'out_ucast_pkts': '3608018132',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:15:c8:d7',
                                                              'mtu': 1500,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'speed': '10000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '609',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '4974562',
                                                              'in_octets': '1969758333277',
                                                              'in_ucast_pkts': '3606606812',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '20272190665',
                                                                                       'mac_address': '28:76:10:13:9f:82',
                                                                                       'out_octets': '35888055399'},
                                                                               {       'in_octets': '829933976964',
                                                                                       'mac_address': '28:76:10:13:63:b8',
                                                                                       'out_octets': '714576582560'}],
                                                              'mac_address': '28:76:10:14:c3:6a',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '14',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3656887243508',
                                                              'out_ucast_pkts': '4203328386',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '2886845',
                                                                                                                                            'mac_address': '28:76:10:13:9f:82',
                                                                                                                                            'rx_link_rate': '72000000',
                                                                                                                                            'tx_link_rate': '65000000'},
                                                                                                                                    {       'connected_time': '2741528',
                                                                                                                                            'mac_address': '28:76:10:13:63:b8',
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'tx_link_rate': '2502000000'}]}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML-60-10G-360',
                                'poller_hash': 'KHYQFMNq',
                                'sw_version': '2.3.5-3677',
                                'system_mac_address': '28:76:10:15:c8:d6',
                                'uptime': '11844454'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '35888055399',
                                                                       'links': [       {       'in_octets': '35888055399',
                                                                                                'mac_address': '28:76:10:14:c3:6a',
                                                                                                'out_octets': '20272190665'}],
                                                                       'mac_address': '28:76:10:13:9f:82',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '20272190665',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2886845',
                                                                                                                                                     'mac_address': '28:76:10:14:c3:6a',
                                                                                                                                                     'rx_link_rate': '65000000',
                                                                                                                                                     'tx_link_rate': '72000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '20272190665',
                                                                       'name': 'eth0',
                                                                       'out_octets': '35888055399',
                                                                       'poller_hash': 'Mjg3NjEwMTM5ZjgyZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQE5+C',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '714576582560',
                                                                       'links': [       {       'in_octets': '714576582560',
                                                                                                'mac_address': '28:76:10:14:c3:6a',
                                                                                                'out_octets': '829933976964'}],
                                                                       'mac_address': '28:76:10:13:63:b8',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '829933976964',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2741528',
                                                                                                                                                     'mac_address': '28:76:10:14:c3:6a',
                                                                                                                                                     'rx_link_rate': '2502000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '829933976964',
                                                                       'name': 'eth0',
                                                                       'out_octets': '714576582560',
                                                                       'poller_hash': 'Mjg3NjEwMTM2M2I4ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQE2O4',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML_60_10G_360_2_4_2_4179_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML-60-10G-360.2.4.2-4179.01")
        exp_info = {
                'model': 'ML-60-10G-360',
                'rf_freq': 62640,
                'rf_tx_power': 14,
                'sta_count': 6,
                'sw_version': '2.4.2-4179',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 0,
                'dl_en_packets': 0,
                'dl_en_packets_dropped': 0,
                'dl_rf_bytes': 11710471998180,
                'dl_rf_packets': 454794724,
                'dl_rf_packets_dropped': 7821,
                'en_if_speed': 1410065408,
                'ul_en_bytes': 0,
                'ul_en_packets': 0,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 817536825279,
                'ul_rf_packets': 4209681510,
                'ul_rf_packets_dropped': 634
        }
        exp_sta_stats = {
                '28:76:10:15:ed:4c': {       'alt_macs': ['28:76:10:14:e8:58'],
                                             'dev_macs': None,
                                             'dl_link_rate': 2502000000,
                                             'dl_rf_bytes': 1542203908958,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:15:ed:4c',
                                             'name': 'cpe-riise',
                                             'ul_link_rate': 2310000000,
                                             'ul_rf_bytes': 69479073098,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:20:99:1e': {       'alt_macs': ['28:76:10:20:9e:0b'],
                                             'dev_macs': None,
                                             'dl_link_rate': 3850000000,
                                             'dl_rf_bytes': 717875847312,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:20:99:1e',
                                             'name': 'cpe-badams',
                                             'ul_link_rate': 2310000000,
                                             'ul_rf_bytes': 80565029406,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:22:c0:8f': {       'alt_macs': ['28:76:10:17:f6:64'],
                                             'dev_macs': None,
                                             'dl_link_rate': 192000000,
                                             'dl_rf_bytes': 1155410434,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:22:c0:8f',
                                             'name': 'cpe-bausten',
                                             'ul_link_rate': 192000000,
                                             'ul_rf_bytes': 658515211,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:22:c1:9d': {       'alt_macs': ['28:76:10:1f:87:25'],
                                             'dev_macs': None,
                                             'dl_link_rate': 192000000,
                                             'dl_rf_bytes': 397536454,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:22:c1:9d',
                                             'name': 'cpe-keichorn',
                                             'ul_link_rate': 144000000,
                                             'ul_rf_bytes': 231685404,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:22:c1:f1': {       'alt_macs': ['28:76:10:1b:d5:bb'],
                                             'dev_macs': None,
                                             'dl_link_rate': 144000000,
                                             'dl_rf_bytes': 902025440,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:22:c1:f1',
                                             'name': 'rmain',
                                             'ul_link_rate': 192000000,
                                             'ul_rf_bytes': 539384906,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:27:31:dc': {       'alt_macs': ['28:76:10:27:0d:42'],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 474775579504,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:27:31:dc',
                                             'name': 'cpe-adeutsch',
                                             'ul_link_rate': 2502000000,
                                             'ul_rf_bytes': 13888537118,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:1f:a1:5b',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1'}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:19:f2:80',
                                                              'mtu': 7912,
                                                              'name': 'eth0',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'speed': '10000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:19:f2:81',
                                                              'mtu': 7912,
                                                              'name': 'eth1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'speed': '1410065408',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '528',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '921826',
                                                              'in_octets': '602410857348',
                                                              'in_ucast_pkts': '3885676127',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '658515211',
                                                                                       'mac_address': '28:76:10:22:c0:8f',
                                                                                       'out_octets': '1155410434'},
                                                                               {       'in_octets': '539384906',
                                                                                       'mac_address': '28:76:10:22:c1:f1',
                                                                                       'out_octets': '902025440'},
                                                                               {       'in_octets': '231685404',
                                                                                       'mac_address': '28:76:10:22:c1:9d',
                                                                                       'out_octets': '397536454'},
                                                                               {       'in_octets': '80565029406',
                                                                                       'mac_address': '28:76:10:20:99:1e',
                                                                                       'out_octets': '717875847312'},
                                                                               {       'in_octets': '13888537118',
                                                                                       'mac_address': '28:76:10:27:31:dc',
                                                                                       'out_octets': '474775579504'},
                                                                               {       'in_octets': '69479073098',
                                                                                       'mac_address': '28:76:10:15:ed:4c',
                                                                                       'out_octets': '1542203908958'}],
                                                              'mac_address': '28:76:10:1f:a1:89',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '6917',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '11618964800937',
                                                              'out_ucast_pkts': '209906042',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1052937',
                                                                                                                                            'mac_address': '28:76:10:22:c0:8f',
                                                                                                                                            'rx_link_rate': '192000000',
                                                                                                                                            'tx_link_rate': '192000000'},
                                                                                                                                    {       'connected_time': '858014',
                                                                                                                                            'mac_address': '28:76:10:22:c1:f1',
                                                                                                                                            'rx_link_rate': '192000000',
                                                                                                                                            'tx_link_rate': '144000000'},
                                                                                                                                    {       'connected_time': '370701',
                                                                                                                                            'mac_address': '28:76:10:22:c1:9d',
                                                                                                                                            'rx_link_rate': '144000000',
                                                                                                                                            'tx_link_rate': '192000000'},
                                                                                                                                    {       'connected_time': '3056361',
                                                                                                                                            'mac_address': '28:76:10:20:99:1e',
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_link_rate': '2310000000',
                                                                                                                                            'tx_link_rate': '3850000000'},
                                                                                                                                    {       'connected_time': '1208050',
                                                                                                                                            'mac_address': '28:76:10:27:31:dc',
                                                                                                                                            'rssi': -48.0,
                                                                                                                                            'rx_link_rate': '2502000000',
                                                                                                                                            'tx_link_rate': '4620000000'},
                                                                                                                                    {       'connected_time': '511237',
                                                                                                                                            'mac_address': '28:76:10:15:ed:4c',
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_link_rate': '2310000000',
                                                                                                                                            'tx_link_rate': '2502000000'}]}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML-60-10G-360',
                                'poller_hash': 'KHYQH6GJ',
                                'sw_version': '2.4.2-4179',
                                'system_mac_address': '28:76:10:19:f2:80',
                                'uptime': '7199794'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '1155410434',
                                                                       'links': [       {       'in_octets': '1155410434',
                                                                                                'mac_address': '28:76:10:1f:a1:89',
                                                                                                'out_octets': '658515211'}],
                                                                       'mac_address': '28:76:10:22:c0:8f',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '658515211',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1052937',
                                                                                                                                                     'mac_address': '28:76:10:1f:a1:89',
                                                                                                                                                     'rx_link_rate': '192000000',
                                                                                                                                                     'tx_link_rate': '192000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '658515211',
                                                                       'mac_address': '28:76:10:17:f6:64',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1155410434',
                                                                       'poller_hash': 'Mjg3NjEwMjJjMDhmZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'name': 'cpe-bausten',
                                         'poller_hash': 'KHYQIsCP',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '902025440',
                                                                       'links': [       {       'in_octets': '902025440',
                                                                                                'mac_address': '28:76:10:1f:a1:89',
                                                                                                'out_octets': '539384906'}],
                                                                       'mac_address': '28:76:10:22:c1:f1',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '539384906',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '858014',
                                                                                                                                                     'mac_address': '28:76:10:1f:a1:89',
                                                                                                                                                     'rx_link_rate': '144000000',
                                                                                                                                                     'tx_link_rate': '192000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '539384906',
                                                                       'mac_address': '28:76:10:1b:d5:bb',
                                                                       'name': 'eth0',
                                                                       'out_octets': '902025440',
                                                                       'poller_hash': 'Mjg3NjEwMjJjMWYxZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'name': 'rmain',
                                         'poller_hash': 'KHYQIsHx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '397536454',
                                                                       'links': [       {       'in_octets': '397536454',
                                                                                                'mac_address': '28:76:10:1f:a1:89',
                                                                                                'out_octets': '231685404'}],
                                                                       'mac_address': '28:76:10:22:c1:9d',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '231685404',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '370701',
                                                                                                                                                     'mac_address': '28:76:10:1f:a1:89',
                                                                                                                                                     'rx_link_rate': '192000000',
                                                                                                                                                     'tx_link_rate': '144000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '231685404',
                                                                       'mac_address': '28:76:10:1f:87:25',
                                                                       'name': 'eth0',
                                                                       'out_octets': '397536454',
                                                                       'poller_hash': 'Mjg3NjEwMjJjMTlkZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'name': 'cpe-keichorn',
                                         'poller_hash': 'KHYQIsGd',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '717875847312',
                                                                       'links': [       {       'in_octets': '717875847312',
                                                                                                'mac_address': '28:76:10:1f:a1:89',
                                                                                                'out_octets': '80565029406'}],
                                                                       'mac_address': '28:76:10:20:99:1e',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '80565029406',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3056361',
                                                                                                                                                     'mac_address': '28:76:10:1f:a1:89',
                                                                                                                                                     'rx_link_rate': '3850000000',
                                                                                                                                                     'tx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '80565029406',
                                                                       'mac_address': '28:76:10:20:9e:0b',
                                                                       'name': 'eth0',
                                                                       'out_octets': '717875847312',
                                                                       'poller_hash': 'Mjg3NjEwMjA5OTFlZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'name': 'cpe-badams',
                                         'poller_hash': 'KHYQIJke',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '474775579504',
                                                                       'links': [       {       'in_octets': '474775579504',
                                                                                                'mac_address': '28:76:10:1f:a1:89',
                                                                                                'out_octets': '13888537118'}],
                                                                       'mac_address': '28:76:10:27:31:dc',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '13888537118',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1208050',
                                                                                                                                                     'mac_address': '28:76:10:1f:a1:89',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '2502000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '13888537118',
                                                                       'mac_address': '28:76:10:27:0d:42',
                                                                       'name': 'eth0',
                                                                       'out_octets': '474775579504',
                                                                       'poller_hash': 'Mjg3NjEwMjczMWRjZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'name': 'cpe-adeutsch',
                                         'poller_hash': 'KHYQJzHc',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '1542203908958',
                                                                       'links': [       {       'in_octets': '1542203908958',
                                                                                                'mac_address': '28:76:10:1f:a1:89',
                                                                                                'out_octets': '69479073098'}],
                                                                       'mac_address': '28:76:10:15:ed:4c',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '69479073098',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '511237',
                                                                                                                                                     'mac_address': '28:76:10:1f:a1:89',
                                                                                                                                                     'rx_link_rate': '2502000000',
                                                                                                                                                     'tx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '69479073098',
                                                                       'mac_address': '28:76:10:14:e8:58',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1542203908958',
                                                                       'poller_hash': 'Mjg3NjEwMTVlZDRjZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'name': 'cpe-riise',
                                         'poller_hash': 'KHYQFe1M',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML_60_10G_360_FCC_2_3_5_3677_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML-60-10G-360-FCC.2.3.5-3677.01")
        exp_info = {
                'model': 'ML-60-10G-360-FCC',
                'rf_freq': 64800,
                'rf_tx_power': 14,
                'sta_count': 12,
                'sw_version': '2.3.5-3677',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 2163107886015,
                'dl_en_packets': 1561037975,
                'dl_en_packets_dropped': 0,
                'dl_rf_bytes': 1181754660955,
                'dl_rf_packets': 875497793,
                'dl_rf_packets_dropped': 3,
                'en_if_speed': 10000000000,
                'ul_en_bytes': 125216174894,
                'ul_en_packets': 928820103,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 65456779005,
                'ul_rf_packets': 506774576,
                'ul_rf_packets_dropped': 108
        }
        exp_sta_stats = {
                '28:76:10:1e:39:3d': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 2502000000,
                                             'dl_rf_bytes': 79207821513,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1e:39:3d',
                                             'name': None,
                                             'ul_link_rate': 2310000000,
                                             'ul_rf_bytes': 2931286197,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1e:88:b2': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 3080000000,
                                             'dl_rf_bytes': 72106777982,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1e:88:b2',
                                             'name': None,
                                             'ul_link_rate': 2502000000,
                                             'ul_rf_bytes': 2866693144,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1e:88:f9': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 179988862234,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1e:88:f9',
                                             'name': None,
                                             'ul_link_rate': 3850000000,
                                             'ul_rf_bytes': 7688516544,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1e:b3:9d': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 223065295,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1e:b3:9d',
                                             'name': None,
                                             'ul_link_rate': 4620000000,
                                             'ul_rf_bytes': 6562160,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1e:b3:9e': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 82733432975,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1e:b3:9e',
                                             'name': None,
                                             'ul_link_rate': 4620000000,
                                             'ul_rf_bytes': 2708009814,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1e:b3:e7': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 86226536848,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1e:b3:e7',
                                             'name': None,
                                             'ul_link_rate': 4620000000,
                                             'ul_rf_bytes': 4811212704,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1e:b4:e5': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 3080000000,
                                             'dl_rf_bytes': 65257015549,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1e:b4:e5',
                                             'name': None,
                                             'ul_link_rate': 2502000000,
                                             'ul_rf_bytes': 11022279238,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1e:b5:0f': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 169297759914,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1e:b5:0f',
                                             'name': None,
                                             'ul_link_rate': 3080000000,
                                             'ul_rf_bytes': 5712599504,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1e:b5:c6': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 2502000000,
                                             'dl_rf_bytes': 2357634681,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1e:b5:c6',
                                             'name': None,
                                             'ul_link_rate': 1540000000,
                                             'ul_rf_bytes': 105433088,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1e:b5:cc': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 112985313215,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1e:b5:cc',
                                             'name': None,
                                             'ul_link_rate': 3850000000,
                                             'ul_rf_bytes': 5202973028,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1e:b5:d2': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 53243781632,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1e:b5:d2',
                                             'name': None,
                                             'ul_link_rate': 2502000000,
                                             'ul_rf_bytes': 2591494851,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1e:b5:dc': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 3850000000,
                                             'dl_rf_bytes': 95945305892,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1e:b5:dc',
                                             'name': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 3874771401,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '11373',
                                                              'in_octets': '8591193770',
                                                              'in_ucast_pkts': '26847300',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:16:f1:0a',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '1',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '61440259038',
                                                              'out_ucast_pkts': '48852025',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1'}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2163107886015',
                                                              'in_ucast_pkts': '1561037975',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:16:ef:cf',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '125216174894',
                                                              'out_ucast_pkts': '928820103',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:16:ef:d0',
                                                              'mtu': 1500,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'speed': '10000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '38',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '38587',
                                                              'in_octets': '24275418922',
                                                              'in_ucast_pkts': '149126246',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '2866693144',
                                                                                       'mac_address': '28:76:10:1e:88:b2',
                                                                                       'out_octets': '72106777982'},
                                                                               {       'in_octets': '4811212704',
                                                                                       'mac_address': '28:76:10:1e:b3:e7',
                                                                                       'out_octets': '86226536848'},
                                                                               {       'in_octets': '5202973028',
                                                                                       'mac_address': '28:76:10:1e:b5:cc',
                                                                                       'out_octets': '112985313215'},
                                                                               {       'in_octets': '3874771401',
                                                                                       'mac_address': '28:76:10:1e:b5:dc',
                                                                                       'out_octets': '95945305892'},
                                                                               {       'in_octets': '11022279238',
                                                                                       'mac_address': '28:76:10:1e:b4:e5',
                                                                                       'out_octets': '65257015549'},
                                                                               {       'in_octets': '105433088',
                                                                                       'mac_address': '28:76:10:1e:b5:c6',
                                                                                       'out_octets': '2357634681'},
                                                                               {       'in_octets': '2931286197',
                                                                                       'mac_address': '28:76:10:1e:39:3d',
                                                                                       'out_octets': '79207821513'},
                                                                               {       'in_octets': '6562160',
                                                                                       'mac_address': '28:76:10:1e:b3:9d',
                                                                                       'out_octets': '223065295'},
                                                                               {       'in_octets': '2708009814',
                                                                                       'mac_address': '28:76:10:1e:b3:9e',
                                                                                       'out_octets': '82733432975'},
                                                                               {       'in_octets': '5712599504',
                                                                                       'mac_address': '28:76:10:1e:b5:0f',
                                                                                       'out_octets': '169297759914'},
                                                                               {       'in_octets': '7688516544',
                                                                                       'mac_address': '28:76:10:1e:88:f9',
                                                                                       'out_octets': '179988862234'},
                                                                               {       'in_octets': '2591494851',
                                                                                       'mac_address': '28:76:10:1e:b5:d2',
                                                                                       'out_octets': '53243781632'}],
                                                              'mac_address': '28:76:10:16:f1:a3',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '2',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '339877596610',
                                                              'out_ucast_pkts': '261552600',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '556028',
                                                                                                                                            'mac_address': '28:76:10:1e:88:b2',
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_link_rate': '2502000000',
                                                                                                                                            'tx_link_rate': '3080000000'},
                                                                                                                                    {       'connected_time': '556035',
                                                                                                                                            'mac_address': '28:76:10:1e:b3:e7',
                                                                                                                                            'rssi': -52.0,
                                                                                                                                            'rx_link_rate': '4620000000',
                                                                                                                                            'tx_link_rate': '4620000000'},
                                                                                                                                    {       'connected_time': '552991',
                                                                                                                                            'mac_address': '28:76:10:1e:b5:cc',
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '3850000000',
                                                                                                                                            'tx_link_rate': '4620000000'},
                                                                                                                                    {       'connected_time': '550594',
                                                                                                                                            'mac_address': '28:76:10:1e:b5:dc',
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'tx_link_rate': '3850000000'},
                                                                                                                                    {       'connected_time': '556028',
                                                                                                                                            'mac_address': '28:76:10:1e:b4:e5',
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_link_rate': '2502000000',
                                                                                                                                            'tx_link_rate': '3080000000'},
                                                                                                                                    {       'connected_time': '11185',
                                                                                                                                            'mac_address': '28:76:10:1e:b5:c6',
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '1540000000',
                                                                                                                                            'tx_link_rate': '2502000000'},
                                                                                                                                    {       'connected_time': '121592',
                                                                                                                                            'mac_address': '28:76:10:1e:39:3d',
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '2310000000',
                                                                                                                                            'tx_link_rate': '2502000000'},
                                                                                                                                    {       'connected_time': '1205',
                                                                                                                                            'mac_address': '28:76:10:1e:b3:9d',
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_link_rate': '4620000000',
                                                                                                                                            'tx_link_rate': '4620000000'},
                                                                                                                                    {       'connected_time': '556047',
                                                                                                                                            'mac_address': '28:76:10:1e:b3:9e',
                                                                                                                                            'rssi': -52.0,
                                                                                                                                            'rx_link_rate': '4620000000',
                                                                                                                                            'tx_link_rate': '4620000000'},
                                                                                                                                    {       'connected_time': '556038',
                                                                                                                                            'mac_address': '28:76:10:1e:b5:0f',
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_link_rate': '3080000000',
                                                                                                                                            'tx_link_rate': '4620000000'},
                                                                                                                                    {       'connected_time': '556018',
                                                                                                                                            'mac_address': '28:76:10:1e:88:f9',
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_link_rate': '3850000000',
                                                                                                                                            'tx_link_rate': '4620000000'},
                                                                                                                                    {       'connected_time': '556038',
                                                                                                                                            'mac_address': '28:76:10:1e:b5:d2',
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_link_rate': '2502000000',
                                                                                                                                            'tx_link_rate': '4620000000'}]}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML-60-10G-360-FCC',
                                'poller_hash': 'KHYQFvGj',
                                'sw_version': '2.3.5-3677',
                                'system_mac_address': '28:76:10:16:ef:cf',
                                'uptime': '3452634'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '72106777982',
                                                                       'links': [       {       'in_octets': '72106777982',
                                                                                                'mac_address': '28:76:10:16:f1:a3',
                                                                                                'out_octets': '2866693144'}],
                                                                       'mac_address': '28:76:10:1e:88:b2',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2866693144',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '556028',
                                                                                                                                                     'mac_address': '28:76:10:16:f1:a3',
                                                                                                                                                     'rx_link_rate': '3080000000',
                                                                                                                                                     'tx_link_rate': '2502000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2866693144',
                                                                       'name': 'eth0',
                                                                       'out_octets': '72106777982',
                                                                       'poller_hash': 'Mjg3NjEwMWU4OGIyZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHoiy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '86226536848',
                                                                       'links': [       {       'in_octets': '86226536848',
                                                                                                'mac_address': '28:76:10:16:f1:a3',
                                                                                                'out_octets': '4811212704'}],
                                                                       'mac_address': '28:76:10:1e:b3:e7',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '4811212704',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '556035',
                                                                                                                                                     'mac_address': '28:76:10:16:f1:a3',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '4620000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '4811212704',
                                                                       'name': 'eth0',
                                                                       'out_octets': '86226536848',
                                                                       'poller_hash': 'Mjg3NjEwMWViM2U3ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHrPn',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '112985313215',
                                                                       'links': [       {       'in_octets': '112985313215',
                                                                                                'mac_address': '28:76:10:16:f1:a3',
                                                                                                'out_octets': '5202973028'}],
                                                                       'mac_address': '28:76:10:1e:b5:cc',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '5202973028',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '552991',
                                                                                                                                                     'mac_address': '28:76:10:16:f1:a3',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '3850000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '5202973028',
                                                                       'name': 'eth0',
                                                                       'out_octets': '112985313215',
                                                                       'poller_hash': 'Mjg3NjEwMWViNWNjZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHrXM',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '95945305892',
                                                                       'links': [       {       'in_octets': '95945305892',
                                                                                                'mac_address': '28:76:10:16:f1:a3',
                                                                                                'out_octets': '3874771401'}],
                                                                       'mac_address': '28:76:10:1e:b5:dc',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3874771401',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '550594',
                                                                                                                                                     'mac_address': '28:76:10:16:f1:a3',
                                                                                                                                                     'rx_link_rate': '3850000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3874771401',
                                                                       'name': 'eth0',
                                                                       'out_octets': '95945305892',
                                                                       'poller_hash': 'Mjg3NjEwMWViNWRjZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHrXc',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '65257015549',
                                                                       'links': [       {       'in_octets': '65257015549',
                                                                                                'mac_address': '28:76:10:16:f1:a3',
                                                                                                'out_octets': '11022279238'}],
                                                                       'mac_address': '28:76:10:1e:b4:e5',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '11022279238',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '556028',
                                                                                                                                                     'mac_address': '28:76:10:16:f1:a3',
                                                                                                                                                     'rx_link_rate': '3080000000',
                                                                                                                                                     'tx_link_rate': '2502000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '11022279238',
                                                                       'name': 'eth0',
                                                                       'out_octets': '65257015549',
                                                                       'poller_hash': 'Mjg3NjEwMWViNGU1ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHrTl',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '2357634681',
                                                                       'links': [       {       'in_octets': '2357634681',
                                                                                                'mac_address': '28:76:10:16:f1:a3',
                                                                                                'out_octets': '105433088'}],
                                                                       'mac_address': '28:76:10:1e:b5:c6',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '105433088',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '11185',
                                                                                                                                                     'mac_address': '28:76:10:16:f1:a3',
                                                                                                                                                     'rx_link_rate': '2502000000',
                                                                                                                                                     'tx_link_rate': '1540000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '105433088',
                                                                       'name': 'eth0',
                                                                       'out_octets': '2357634681',
                                                                       'poller_hash': 'Mjg3NjEwMWViNWM2ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHrXG',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '79207821513',
                                                                       'links': [       {       'in_octets': '79207821513',
                                                                                                'mac_address': '28:76:10:16:f1:a3',
                                                                                                'out_octets': '2931286197'}],
                                                                       'mac_address': '28:76:10:1e:39:3d',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2931286197',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '121592',
                                                                                                                                                     'mac_address': '28:76:10:16:f1:a3',
                                                                                                                                                     'rx_link_rate': '2502000000',
                                                                                                                                                     'tx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2931286197',
                                                                       'name': 'eth0',
                                                                       'out_octets': '79207821513',
                                                                       'poller_hash': 'Mjg3NjEwMWUzOTNkZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHjk9',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '223065295',
                                                                       'links': [       {       'in_octets': '223065295',
                                                                                                'mac_address': '28:76:10:16:f1:a3',
                                                                                                'out_octets': '6562160'}],
                                                                       'mac_address': '28:76:10:1e:b3:9d',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '6562160',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1205',
                                                                                                                                                     'mac_address': '28:76:10:16:f1:a3',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '4620000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '6562160',
                                                                       'name': 'eth0',
                                                                       'out_octets': '223065295',
                                                                       'poller_hash': 'Mjg3NjEwMWViMzlkZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHrOd',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '82733432975',
                                                                       'links': [       {       'in_octets': '82733432975',
                                                                                                'mac_address': '28:76:10:16:f1:a3',
                                                                                                'out_octets': '2708009814'}],
                                                                       'mac_address': '28:76:10:1e:b3:9e',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2708009814',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '556047',
                                                                                                                                                     'mac_address': '28:76:10:16:f1:a3',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '4620000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2708009814',
                                                                       'name': 'eth0',
                                                                       'out_octets': '82733432975',
                                                                       'poller_hash': 'Mjg3NjEwMWViMzllZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHrOe',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '169297759914',
                                                                       'links': [       {       'in_octets': '169297759914',
                                                                                                'mac_address': '28:76:10:16:f1:a3',
                                                                                                'out_octets': '5712599504'}],
                                                                       'mac_address': '28:76:10:1e:b5:0f',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '5712599504',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '556038',
                                                                                                                                                     'mac_address': '28:76:10:16:f1:a3',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '3080000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '5712599504',
                                                                       'name': 'eth0',
                                                                       'out_octets': '169297759914',
                                                                       'poller_hash': 'Mjg3NjEwMWViNTBmZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHrUP',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '179988862234',
                                                                       'links': [       {       'in_octets': '179988862234',
                                                                                                'mac_address': '28:76:10:16:f1:a3',
                                                                                                'out_octets': '7688516544'}],
                                                                       'mac_address': '28:76:10:1e:88:f9',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '7688516544',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '556018',
                                                                                                                                                     'mac_address': '28:76:10:16:f1:a3',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '3850000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '7688516544',
                                                                       'name': 'eth0',
                                                                       'out_octets': '179988862234',
                                                                       'poller_hash': 'Mjg3NjEwMWU4OGY5ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHoj5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '53243781632',
                                                                       'links': [       {       'in_octets': '53243781632',
                                                                                                'mac_address': '28:76:10:16:f1:a3',
                                                                                                'out_octets': '2591494851'}],
                                                                       'mac_address': '28:76:10:1e:b5:d2',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2591494851',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '556038',
                                                                                                                                                     'mac_address': '28:76:10:16:f1:a3',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '2502000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2591494851',
                                                                       'name': 'eth0',
                                                                       'out_octets': '53243781632',
                                                                       'poller_hash': 'Mjg3NjEwMWViNWQyZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHrXS',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML_60_10G_360_FCC_2_4_2_4179_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML-60-10G-360-FCC.2.4.2-4179.01")
        exp_info = {
                'model': 'ML-60-10G-360-FCC',
                'rf_freq': 62640,
                'rf_tx_power': 14,
                'sta_count': 3,
                'sw_version': '2.4.2-4179',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 40473575897,
                'dl_en_packets': 33458239,
                'dl_en_packets_dropped': 138,
                'dl_rf_bytes': 10674821127,
                'dl_rf_packets': 16713605,
                'dl_rf_packets_dropped': 0,
                'en_if_speed': 1410065408,
                'ul_en_bytes': 10041659214,
                'ul_en_packets': 20656854,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 9244793947,
                'ul_rf_packets': 19245668,
                'ul_rf_packets_dropped': 46
        }
        exp_sta_stats = {
                '18:e8:29:3a:71:6c': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 300000000,
                                             'dl_rf_bytes': 31200515395,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:3a:71:6c',
                                             'name': 'Dale White',
                                             'ul_link_rate': 162000000,
                                             'ul_rf_bytes': 941499486,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1f:71:98': {       'alt_macs': ['28:76:10:1f:a2:93'],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 9558135765,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1f:71:98',
                                             'name': 'Karlie-Peacock',
                                             'ul_link_rate': 385000000,
                                             'ul_rf_bytes': 8719174186,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1f:71:e4': {       'alt_macs': ['28:76:10:1f:a3:00'],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 1116292865,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1f:71:e4',
                                             'name': 'Linda-McMicheal',
                                             'ul_link_rate': 2502000000,
                                             'ul_rf_bytes': 524167625,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '14',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '390962',
                                                              'in_octets': '525598522',
                                                              'in_ucast_pkts': '2762897',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '941499486',
                                                                                       'mac_address': '18:e8:29:3a:71:6c',
                                                                                       'out_octets': '31200515395'},
                                                                               {       'in_octets': '524167625',
                                                                                       'mac_address': '28:76:10:1f:71:e4',
                                                                                       'out_octets': '1116292865'},
                                                                               {       'in_octets': '8719174186',
                                                                                       'mac_address': '28:76:10:1f:71:98',
                                                                                       'out_octets': '9558135765'}],
                                                              'mac_address': '28:76:10:14:c2:1e',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1116675027',
                                                              'out_ucast_pkts': '3098990',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '267355',
                                                                                                                                            'mac_address': '18:e8:29:3a:71:6c',
                                                                                                                                            'rx_link_rate': '162000000',
                                                                                                                                            'tx_link_rate': '300000000'},
                                                                                                                                    {       'connected_time': '193650',
                                                                                                                                            'mac_address': '28:76:10:1f:71:e4',
                                                                                                                                            'rssi': -37.0,
                                                                                                                                            'rx_link_rate': '2502000000',
                                                                                                                                            'tx_link_rate': '4620000000'},
                                                                                                                                    {       'connected_time': '267407',
                                                                                                                                            'mac_address': '28:76:10:1f:71:98',
                                                                                                                                            'rssi': -38.0,
                                                                                                                                            'rx_link_rate': '385000000',
                                                                                                                                            'tx_link_rate': '4620000000'}]}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:15:c9:80',
                                                              'mtu': 7912,
                                                              'name': 'eth0',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1043',
                                                              'out_ucast_pkts': '1',
                                                              'speed': '10000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '1',
                                                              'in_errors': '137',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '40473575897',
                                                              'in_ucast_pkts': '33458239',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:15:c9:81',
                                                              'mtu': 7912,
                                                              'name': 'eth1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '10041658171',
                                                              'out_ucast_pkts': '20656853',
                                                              'speed': '1410065408',
                                                              'type': 6}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML-60-10G-360-FCC',
                                'poller_hash': 'KHYQFMIe',
                                'sw_version': '2.4.2-4179',
                                'system_mac_address': '28:76:10:15:c9:80',
                                'uptime': '27761'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '31200515395',
                                                                       'links': [       {       'in_octets': '31200515395',
                                                                                                'mac_address': '28:76:10:14:c2:1e',
                                                                                                'out_octets': '941499486'}],
                                                                       'mac_address': '18:e8:29:3a:71:6c',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '941499486',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '267355',
                                                                                                                                                     'mac_address': '28:76:10:14:c2:1e',
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'tx_link_rate': '162000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '941499486',
                                                                       'name': 'eth0',
                                                                       'out_octets': '31200515395',
                                                                       'poller_hash': 'MThlODI5M2E3MTZjZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'name': 'Dale White',
                                         'poller_hash': 'GOgpOnFs',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '1116292865',
                                                                       'links': [       {       'in_octets': '1116292865',
                                                                                                'mac_address': '28:76:10:14:c2:1e',
                                                                                                'out_octets': '524167625'}],
                                                                       'mac_address': '28:76:10:1f:71:e4',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '524167625',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '193650',
                                                                                                                                                     'mac_address': '28:76:10:14:c2:1e',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '2502000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '524167625',
                                                                       'mac_address': '28:76:10:1f:a3:00',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1116292865',
                                                                       'poller_hash': 'Mjg3NjEwMWY3MWU0ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'name': 'Linda-McMicheal',
                                         'poller_hash': 'KHYQH3Hk',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '9558135765',
                                                                       'links': [       {       'in_octets': '9558135765',
                                                                                                'mac_address': '28:76:10:14:c2:1e',
                                                                                                'out_octets': '8719174186'}],
                                                                       'mac_address': '28:76:10:1f:71:98',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '8719174186',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '267407',
                                                                                                                                                     'mac_address': '28:76:10:14:c2:1e',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '385000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '8719174186',
                                                                       'mac_address': '28:76:10:1f:a2:93',
                                                                       'name': 'eth0',
                                                                       'out_octets': '9558135765',
                                                                       'poller_hash': 'Mjg3NjEwMWY3MTk4ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'name': 'Karlie-Peacock',
                                         'poller_hash': 'KHYQH3GY',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML_60_10G_360_US_2_4_2_4179_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML-60-10G-360-US.2.4.2-4179.01")
        exp_info = {
                'model': 'ML-60-10G-360-US',
                'rf_freq': 62640,
                'rf_tx_power': 14,
                'sta_count': 7,
                'sw_version': '2.4.2-4179',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 0,
                'dl_en_packets': 0,
                'dl_en_packets_dropped': 0,
                'dl_rf_bytes': 4471532066758,
                'dl_rf_packets': 3436406788,
                'dl_rf_packets_dropped': 3,
                'en_if_speed': 1410065408,
                'ul_en_bytes': 0,
                'ul_en_packets': 0,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 352551753987,
                'ul_rf_packets': 1573693737,
                'ul_rf_packets_dropped': 84
        }
        exp_sta_stats = {
                '28:76:10:22:8e:17': {       'alt_macs': ['28:76:10:22:8e:1a'],
                                             'dev_macs': None,
                                             'dl_link_rate': 433000000,
                                             'dl_rf_bytes': 11341639508,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:22:8e:17',
                                             'name': 'cpe-rboyer',
                                             'ul_link_rate': 585000000,
                                             'ul_rf_bytes': 6606540336,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:22:c0:cb': {       'alt_macs': ['28:76:10:1b:55:11'],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 330178687938,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:22:c0:cb',
                                             'name': 'cpe-ssaathoff',
                                             'ul_link_rate': 4620000000,
                                             'ul_rf_bytes': 11513240520,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:23:c9:4a': {       'alt_macs': ['28:76:10:23:70:fd'],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 2649564789391,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:23:c9:4a',
                                             'name': 'cpe-jkalkwarf',
                                             'ul_link_rate': 2310000000,
                                             'ul_rf_bytes': 200299746194,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:27:2d:fc': {       'alt_macs': ['28:76:10:27:0d:48'],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 393069382031,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:27:2d:fc',
                                             'name': 'cpe-vgarth',
                                             'ul_link_rate': 3850000000,
                                             'ul_rf_bytes': 30830398805,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:27:2e:00': {       'alt_macs': ['28:76:10:27:0d:5d'],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 40706677156,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:27:2e:00',
                                             'name': 'cpe-ddiaz-s1tdr',
                                             'ul_link_rate': 2502000000,
                                             'ul_rf_bytes': 10925823735,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:27:32:0c': {       'alt_macs': ['28:76:10:27:05:fb'],
                                             'dev_macs': None,
                                             'dl_link_rate': 585000000,
                                             'dl_rf_bytes': 5852698514,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:27:32:0c',
                                             'name': 'cpe-jclark',
                                             'ul_link_rate': 650000000,
                                             'ul_rf_bytes': 3410074555,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:27:b1:cc': {       'alt_macs': ['28:76:10:20:18:b9'],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 612714849,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:27:b1:cc',
                                             'name': 'cpe-ccole3',
                                             'ul_link_rate': 3850000000,
                                             'ul_rf_bytes': 536453553,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '32',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '2174036',
                                                              'in_octets': '301462476205',
                                                              'in_ucast_pkts': '1395689752',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '6606540336',
                                                                                       'mac_address': '28:76:10:22:8e:17',
                                                                                       'out_octets': '11341639508'},
                                                                               {       'in_octets': '536453553',
                                                                                       'mac_address': '28:76:10:27:b1:cc',
                                                                                       'out_octets': '612714849'},
                                                                               {       'in_octets': '30830398805',
                                                                                       'mac_address': '28:76:10:27:2d:fc',
                                                                                       'out_octets': '393069382031'},
                                                                               {       'in_octets': '11513240520',
                                                                                       'mac_address': '28:76:10:22:c0:cb',
                                                                                       'out_octets': '330178687938'},
                                                                               {       'in_octets': '10925823735',
                                                                                       'mac_address': '28:76:10:27:2e:00',
                                                                                       'out_octets': '40706677156'},
                                                                               {       'in_octets': '3410074555',
                                                                                       'mac_address': '28:76:10:27:32:0c',
                                                                                       'out_octets': '5852698514'},
                                                                               {       'in_octets': '200299746194',
                                                                                       'mac_address': '28:76:10:23:c9:4a',
                                                                                       'out_octets': '2649564789391'}],
                                                              'mac_address': '28:76:10:21:9d:68',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '2',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '4009355718732',
                                                              'out_ucast_pkts': '3035949029',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1721091',
                                                                                                                                            'mac_address': '28:76:10:22:8e:17',
                                                                                                                                            'rx_link_rate': '585000000',
                                                                                                                                            'tx_link_rate': '433000000'},
                                                                                                                                    {       'connected_time': '741560',
                                                                                                                                            'mac_address': '28:76:10:27:b1:cc',
                                                                                                                                            'rssi': -54.0,
                                                                                                                                            'rx_link_rate': '3850000000',
                                                                                                                                            'tx_link_rate': '4620000000'},
                                                                                                                                    {       'connected_time': '652816',
                                                                                                                                            'mac_address': '28:76:10:27:2d:fc',
                                                                                                                                            'rssi': -32.0,
                                                                                                                                            'rx_link_rate': '3850000000',
                                                                                                                                            'tx_link_rate': '4620000000'},
                                                                                                                                    {       'connected_time': '907736',
                                                                                                                                            'mac_address': '28:76:10:22:c0:cb',
                                                                                                                                            'rssi': -39.0,
                                                                                                                                            'rx_link_rate': '4620000000',
                                                                                                                                            'tx_link_rate': '4620000000'},
                                                                                                                                    {       'connected_time': '566861',
                                                                                                                                            'mac_address': '28:76:10:27:2e:00',
                                                                                                                                            'rssi': -53.0,
                                                                                                                                            'rx_link_rate': '2502000000',
                                                                                                                                            'tx_link_rate': '4620000000'},
                                                                                                                                    {       'connected_time': '1162528',
                                                                                                                                            'mac_address': '28:76:10:27:32:0c',
                                                                                                                                            'rx_link_rate': '650000000',
                                                                                                                                            'tx_link_rate': '585000000'},
                                                                                                                                    {       'connected_time': '8169775',
                                                                                                                                            'mac_address': '28:76:10:23:c9:4a',
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '2310000000',
                                                                                                                                            'tx_link_rate': '4620000000'}]}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:19:ef:de',
                                                              'mtu': 7912,
                                                              'name': 'eth0',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'speed': '10000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:19:ef:df',
                                                              'mtu': 7912,
                                                              'name': 'eth1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'speed': '1410065408',
                                                              'type': 6}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML-60-10G-360-US',
                                'poller_hash': 'KHYQIZ1o',
                                'sw_version': '2.4.2-4179',
                                'system_mac_address': '28:76:10:19:ef:de',
                                'uptime': '15338141'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '11341639508',
                                                                       'links': [       {       'in_octets': '11341639508',
                                                                                                'mac_address': '28:76:10:21:9d:68',
                                                                                                'out_octets': '6606540336'}],
                                                                       'mac_address': '28:76:10:22:8e:17',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '6606540336',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1721091',
                                                                                                                                                     'mac_address': '28:76:10:21:9d:68',
                                                                                                                                                     'rx_link_rate': '433000000',
                                                                                                                                                     'tx_link_rate': '585000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '6606540336',
                                                                       'mac_address': '28:76:10:22:8e:1a',
                                                                       'name': 'eth0',
                                                                       'out_octets': '11341639508',
                                                                       'poller_hash': 'Mjg3NjEwMjI4ZTE3ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'name': 'cpe-rboyer',
                                         'poller_hash': 'KHYQIo4X',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '612714849',
                                                                       'links': [       {       'in_octets': '612714849',
                                                                                                'mac_address': '28:76:10:21:9d:68',
                                                                                                'out_octets': '536453553'}],
                                                                       'mac_address': '28:76:10:27:b1:cc',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '536453553',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '741560',
                                                                                                                                                     'mac_address': '28:76:10:21:9d:68',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '3850000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '536453553',
                                                                       'mac_address': '28:76:10:20:18:b9',
                                                                       'name': 'eth0',
                                                                       'out_octets': '612714849',
                                                                       'poller_hash': 'Mjg3NjEwMjdiMWNjZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'name': 'cpe-ccole3',
                                         'poller_hash': 'KHYQJ7HM',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '393069382031',
                                                                       'links': [       {       'in_octets': '393069382031',
                                                                                                'mac_address': '28:76:10:21:9d:68',
                                                                                                'out_octets': '30830398805'}],
                                                                       'mac_address': '28:76:10:27:2d:fc',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '30830398805',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '652816',
                                                                                                                                                     'mac_address': '28:76:10:21:9d:68',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '3850000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '30830398805',
                                                                       'mac_address': '28:76:10:27:0d:48',
                                                                       'name': 'eth0',
                                                                       'out_octets': '393069382031',
                                                                       'poller_hash': 'Mjg3NjEwMjcyZGZjZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'name': 'cpe-vgarth',
                                         'poller_hash': 'KHYQJy38',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '330178687938',
                                                                       'links': [       {       'in_octets': '330178687938',
                                                                                                'mac_address': '28:76:10:21:9d:68',
                                                                                                'out_octets': '11513240520'}],
                                                                       'mac_address': '28:76:10:22:c0:cb',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '11513240520',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '907736',
                                                                                                                                                     'mac_address': '28:76:10:21:9d:68',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '4620000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '11513240520',
                                                                       'mac_address': '28:76:10:1b:55:11',
                                                                       'name': 'eth0',
                                                                       'out_octets': '330178687938',
                                                                       'poller_hash': 'Mjg3NjEwMjJjMGNiZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'name': 'cpe-ssaathoff',
                                         'poller_hash': 'KHYQIsDL',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '40706677156',
                                                                       'links': [       {       'in_octets': '40706677156',
                                                                                                'mac_address': '28:76:10:21:9d:68',
                                                                                                'out_octets': '10925823735'}],
                                                                       'mac_address': '28:76:10:27:2e:00',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '10925823735',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '566861',
                                                                                                                                                     'mac_address': '28:76:10:21:9d:68',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '2502000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '10925823735',
                                                                       'mac_address': '28:76:10:27:0d:5d',
                                                                       'name': 'eth0',
                                                                       'out_octets': '40706677156',
                                                                       'poller_hash': 'Mjg3NjEwMjcyZTAwZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'name': 'cpe-ddiaz-s1tdr',
                                         'poller_hash': 'KHYQJy4A',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '5852698514',
                                                                       'links': [       {       'in_octets': '5852698514',
                                                                                                'mac_address': '28:76:10:21:9d:68',
                                                                                                'out_octets': '3410074555'}],
                                                                       'mac_address': '28:76:10:27:32:0c',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3410074555',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1162528',
                                                                                                                                                     'mac_address': '28:76:10:21:9d:68',
                                                                                                                                                     'rx_link_rate': '585000000',
                                                                                                                                                     'tx_link_rate': '650000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3410074555',
                                                                       'mac_address': '28:76:10:27:05:fb',
                                                                       'name': 'eth0',
                                                                       'out_octets': '5852698514',
                                                                       'poller_hash': 'Mjg3NjEwMjczMjBjZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'name': 'cpe-jclark',
                                         'poller_hash': 'KHYQJzIM',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '2649564789391',
                                                                       'links': [       {       'in_octets': '2649564789391',
                                                                                                'mac_address': '28:76:10:21:9d:68',
                                                                                                'out_octets': '200299746194'}],
                                                                       'mac_address': '28:76:10:23:c9:4a',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '200299746194',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '8169775',
                                                                                                                                                     'mac_address': '28:76:10:21:9d:68',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '200299746194',
                                                                       'mac_address': '28:76:10:23:70:fd',
                                                                       'name': 'eth0',
                                                                       'out_octets': '2649564789391',
                                                                       'poller_hash': 'Mjg3NjEwMjNjOTRhZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'name': 'cpe-jkalkwarf',
                                         'poller_hash': 'KHYQI8lK',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML_60_19d_1_2_1_9909_09a35b5e_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML-60-19d.1.2.1-9909-09a35b5e.01")
        exp_info = {
                'model': 'ML-60-19d',
                'rf_freq': 58320,
                'rf_tx_power': 14,
                'sta_count': 0,
                'sw_version': '1.2.1-9909-09a35b5e',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 2108803895,
                'dl_en_packets': 6185111,
                'dl_en_packets_dropped': 0,
                'dl_rf_bytes': 54609,
                'dl_rf_packets': 584,
                'dl_rf_packets_dropped': 0,
                'en_if_speed': 1000000000,
                'ul_en_bytes': 996716926,
                'ul_en_packets': 2159790,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 54609,
                'ul_rf_packets': 584,
                'ul_rf_packets_dropped': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '2076740',
                                                              'in_octets': '2108803895',
                                                              'in_ucast_pkts': '4108371',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:05:51:b2',
                                                              'mtu': 7912,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '996716926',
                                                              'out_ucast_pkts': '2159790',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:05:51:b3',
                                                              'mtu': 7912,
                                                              'name': 'eth1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:05:51:b4',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1'}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML-60-19d',
                                'poller_hash': 'KHYQBVG0',
                                'sw_version': '1.2.1-9909-09a35b5e',
                                'system_mac_address': '28:76:10:05:51:b2',
                                'uptime': '3777911'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML_60_35_1_1_1_7_9309_3e17531_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML-60-35-1.1.1.7-9309-3e17531.01")
        exp_info = {
                'model': 'ML-60-35-1',
                'rf_freq': 60480,
                'rf_tx_power': 8,
                'sta_count': 0,
                'sw_version': '1.1.7-9309-3e17531',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 0,
                'dl_en_packets': 0,
                'dl_en_packets_dropped': 0,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'dl_rf_packets_dropped': 0,
                'en_if_speed': None,
                'ul_en_bytes': 0,
                'ul_en_packets': 0,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0,
                'ul_rf_packets_dropped': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': False,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '3716254047',
                                                              'in_ucast_pkts': '104870207',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:05:86:1c',
                                                              'mtu': 7912,
                                                              'name': 'wlan1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1493945285',
                                                              'out_ucast_pkts': '106700602',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1'}],
                                                                                        'tx_power': 8}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 71}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML-60-35-1',
                                'poller_hash': 'KHYQBYYc',
                                'sw_version': '1.1.7-9309-3e17531',
                                'uptime': '3790524'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML_60_35d_1_1_7_9309_3e17531_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML-60-35d.1.1.7-9309-3e17531.01")
        exp_info = {
                'model': 'ML-60-35d',
                'rf_freq': 60480,
                'rf_tx_power': 7,
                'sta_count': 0,
                'sw_version': '1.1.7-9309-3e17531',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 0,
                'dl_en_packets': 0,
                'dl_en_packets_dropped': 0,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'dl_rf_packets_dropped': 0,
                'en_if_speed': None,
                'ul_en_bytes': 0,
                'ul_en_packets': 0,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0,
                'ul_rf_packets_dropped': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': False,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1583337770',
                                                              'in_ucast_pkts': '2539391799',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:08:64:10',
                                                              'mtu': 7912,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3928957615',
                                                              'out_ucast_pkts': '2226082786',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1'}],
                                                                                        'tx_power': 7}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '2502000000',
                                                              'type': 71}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML-60-35d',
                                'poller_hash': 'KHYQCGQQ',
                                'sw_version': '1.1.7-9309-3e17531',
                                'uptime': '3222157'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML_60_35d_1_1_7_9309_3e17531_02(self):
        obj = self.run_data("ignitenet.metrolinq.ML-60-35d.1.1.7-9309-3e17531.02")
        exp_info = {
                'model': 'ML-60-35d',
                'rf_freq': 60480,
                'rf_tx_power': 7,
                'sta_count': 0,
                'sw_version': '1.1.7-9309-3e17531',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 0,
                'dl_en_packets': 0,
                'dl_en_packets_dropped': 0,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'dl_rf_packets_dropped': 0,
                'en_if_speed': None,
                'ul_en_bytes': 0,
                'ul_en_packets': 0,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0,
                'ul_rf_packets_dropped': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': False,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '3204136706',
                                                              'in_ucast_pkts': '846195724',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:08:63:fc',
                                                              'mtu': 7912,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3942298151',
                                                              'out_ucast_pkts': '2313622551',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1'}],
                                                                                        'tx_power': 7}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '2502000000',
                                                              'type': 71}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML-60-35d',
                                'poller_hash': 'KHYQCGP8',
                                'sw_version': '1.1.7-9309-3e17531',
                                'uptime': '3222113'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML_60_LW_US_2_3_5_4023_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML-60-LW-US.2.3.5-4023.01")
        exp_info = {
                'model': 'ML-60-LW-US',
                'rf_freq': 60480,
                'rf_tx_power': 14,
                'sta_count': 3,
                'sw_version': '2.3.5-4023',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 4163805105,
                'dl_en_packets': 617866421,
                'dl_en_packets_dropped': 6,
                'dl_rf_bytes': 857071573034,
                'dl_rf_packets': 655304225,
                'dl_rf_packets_dropped': 11,
                'en_if_speed': 1000000000,
                'ul_en_bytes': 1752100441,
                'ul_en_packets': 349780185,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 59351831612,
                'ul_rf_packets': 384151892,
                'ul_rf_packets_dropped': 0
        }
        exp_sta_stats = {
                '28:76:10:1e:89:54': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 30394916188,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1e:89:54',
                                             'name': None,
                                             'ul_link_rate': 3080000000,
                                             'ul_rf_bytes': 1784081291,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1e:89:94': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 4620000000,
                                             'dl_rf_bytes': 436619389290,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1e:89:94',
                                             'name': None,
                                             'ul_link_rate': 385000000,
                                             'ul_rf_bytes': 21013938565,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1e:b4:7d': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 2502000000,
                                             'dl_rf_bytes': 15375300076,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1e:b4:7d',
                                             'name': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 3148565767,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '663987',
                                                              'in_octets': '59351831612',
                                                              'in_ucast_pkts': '383487905',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '21013938565',
                                                                                       'mac_address': '28:76:10:1e:89:94',
                                                                                       'out_octets': '436619389290'},
                                                                               {       'in_octets': '1784081291',
                                                                                       'mac_address': '28:76:10:1e:89:54',
                                                                                       'out_octets': '30394916188'},
                                                                               {       'in_octets': '3148565767',
                                                                                       'mac_address': '28:76:10:1e:b4:7d',
                                                                                       'out_octets': '15375300076'}],
                                                              'mac_address': '28:76:10:17:dc:eb',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '11',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '857071573034',
                                                              'out_ucast_pkts': '655304225',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '2872947',
                                                                                                                                            'mac_address': '28:76:10:1e:89:94',
                                                                                                                                            'rssi': -45.0,
                                                                                                                                            'rx_link_rate': '385000000',
                                                                                                                                            'tx_link_rate': '4620000000'},
                                                                                                                                    {       'connected_time': '696706',
                                                                                                                                            'mac_address': '28:76:10:1e:89:54',
                                                                                                                                            'rssi': -54.0,
                                                                                                                                            'rx_link_rate': '3080000000',
                                                                                                                                            'tx_link_rate': '4620000000'},
                                                                                                                                    {       'connected_time': '164289',
                                                                                                                                            'mac_address': '28:76:10:1e:b4:7d',
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'tx_link_rate': '2502000000'}]}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '6',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '4163805105',
                                                              'in_ucast_pkts': '617866421',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:1a:80:25',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1752100441',
                                                              'out_ucast_pkts': '349780185',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:1a:80:26',
                                                              'mtu': 1500,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML-60-LW-US',
                                'poller_hash': 'KHYQF9zr',
                                'sw_version': '2.3.5-4023',
                                'system_mac_address': '28:76:10:1a:80:25',
                                'uptime': '2948507'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '436619389290',
                                                                       'links': [       {       'in_octets': '436619389290',
                                                                                                'mac_address': '28:76:10:17:dc:eb',
                                                                                                'out_octets': '21013938565'}],
                                                                       'mac_address': '28:76:10:1e:89:94',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '21013938565',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2872947',
                                                                                                                                                     'mac_address': '28:76:10:17:dc:eb',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '385000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '21013938565',
                                                                       'name': 'eth0',
                                                                       'out_octets': '436619389290',
                                                                       'poller_hash': 'Mjg3NjEwMWU4OTk0ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHomU',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '30394916188',
                                                                       'links': [       {       'in_octets': '30394916188',
                                                                                                'mac_address': '28:76:10:17:dc:eb',
                                                                                                'out_octets': '1784081291'}],
                                                                       'mac_address': '28:76:10:1e:89:54',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1784081291',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '696706',
                                                                                                                                                     'mac_address': '28:76:10:17:dc:eb',
                                                                                                                                                     'rx_link_rate': '4620000000',
                                                                                                                                                     'tx_link_rate': '3080000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1784081291',
                                                                       'name': 'eth0',
                                                                       'out_octets': '30394916188',
                                                                       'poller_hash': 'Mjg3NjEwMWU4OTU0ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHolU',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '15375300076',
                                                                       'links': [       {       'in_octets': '15375300076',
                                                                                                'mac_address': '28:76:10:17:dc:eb',
                                                                                                'out_octets': '3148565767'}],
                                                                       'mac_address': '28:76:10:1e:b4:7d',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3148565767',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '164289',
                                                                                                                                                     'mac_address': '28:76:10:17:dc:eb',
                                                                                                                                                     'rx_link_rate': '2502000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3148565767',
                                                                       'name': 'eth0',
                                                                       'out_octets': '15375300076',
                                                                       'poller_hash': 'Mjg3NjEwMWViNDdkZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHrR9',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ignitenet_metrolinq_ML_60_LW_US_2_4_1_4363_01(self):
        obj = self.run_data("ignitenet.metrolinq.ML-60-LW-US.2.4.1-4363.01")
        exp_info = {
                'model': 'ML-60-LW-US',
                'rf_freq': 60480,
                'rf_tx_power': 14,
                'sta_count': 6,
                'sw_version': '2.4.1-4363',
                'vendor': 'IgniteNet'
        }
        exp_stats = {
                'dl_en_bytes': 631820766,
                'dl_en_packets': 19673935,
                'dl_en_packets_dropped': 2,
                'dl_rf_bytes': 26513465938,
                'dl_rf_packets': 21367156,
                'dl_rf_packets_dropped': 0,
                'en_if_speed': 1000000000,
                'ul_en_bytes': 1288600332,
                'ul_en_packets': 8644276,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 1320283470,
                'ul_rf_packets': 9368314,
                'ul_rf_packets_dropped': 0
        }
        exp_sta_stats = {
                '28:76:10:1c:56:c9': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 2310000000,
                                             'dl_rf_bytes': 3554687777,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1c:56:c9',
                                             'name': None,
                                             'ul_link_rate': 1925000000,
                                             'ul_rf_bytes': 262453924,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1c:59:48': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 96000000,
                                             'dl_rf_bytes': 21344141,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1c:59:48',
                                             'name': None,
                                             'ul_link_rate': 130000000,
                                             'ul_rf_bytes': 13165149,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1d:6c:04': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 86000000,
                                             'dl_rf_bytes': 21339837,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1d:6c:04',
                                             'name': None,
                                             'ul_link_rate': 65000000,
                                             'ul_rf_bytes': 13164673,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1d:6d:4c': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 192000000,
                                             'dl_rf_bytes': 22691674,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1d:6d:4c',
                                             'name': None,
                                             'ul_link_rate': 192000000,
                                             'ul_rf_bytes': 13250353,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1d:83:42': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 2310000000,
                                             'dl_rf_bytes': 9286035377,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1d:83:42',
                                             'name': None,
                                             'ul_link_rate': 1251000000,
                                             'ul_rf_bytes': 588464751,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None},
                '28:76:10:1d:83:89': {       'alt_macs': [],
                                             'dev_macs': None,
                                             'dl_link_rate': 2310000000,
                                             'dl_rf_bytes': 13666000045,
                                             'dl_rf_packets': 0,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': None,
                                             'mac_address': '28:76:10:1d:83:89',
                                             'name': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 469164589,
                                             'ul_rf_packets': 0,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '11511',
                                                              'in_octets': '1320283470',
                                                              'in_ucast_pkts': '9356803',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '13165149',
                                                                                       'mac_address': '28:76:10:1c:59:48',
                                                                                       'out_octets': '21344141'},
                                                                               {       'in_octets': '13164673',
                                                                                       'mac_address': '28:76:10:1d:6c:04',
                                                                                       'out_octets': '21339837'},
                                                                               {       'in_octets': '13250353',
                                                                                       'mac_address': '28:76:10:1d:6d:4c',
                                                                                       'out_octets': '22691674'},
                                                                               {       'in_octets': '262453924',
                                                                                       'mac_address': '28:76:10:1c:56:c9',
                                                                                       'out_octets': '3554687777'},
                                                                               {       'in_octets': '588464751',
                                                                                       'mac_address': '28:76:10:1d:83:42',
                                                                                       'out_octets': '9286035377'},
                                                                               {       'in_octets': '469164589',
                                                                                       'mac_address': '28:76:10:1d:83:89',
                                                                                       'out_octets': '13666000045'}],
                                                              'mac_address': '28:76:10:18:68:3e',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '26513465938',
                                                              'out_ucast_pkts': '21367156',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '51385',
                                                                                                                                            'mac_address': '28:76:10:1c:59:48',
                                                                                                                                            'rx_link_rate': '130000000',
                                                                                                                                            'tx_link_rate': '96000000'},
                                                                                                                                    {       'connected_time': '51385',
                                                                                                                                            'mac_address': '28:76:10:1d:6c:04',
                                                                                                                                            'rx_link_rate': '65000000',
                                                                                                                                            'tx_link_rate': '86000000'},
                                                                                                                                    {       'connected_time': '51383',
                                                                                                                                            'mac_address': '28:76:10:1d:6d:4c',
                                                                                                                                            'rx_link_rate': '192000000',
                                                                                                                                            'tx_link_rate': '192000000'},
                                                                                                                                    {       'connected_time': '51388',
                                                                                                                                            'mac_address': '28:76:10:1c:56:c9',
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '1925000000',
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'connected_time': '51386',
                                                                                                                                            'mac_address': '28:76:10:1d:83:42',
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '1251000000',
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'connected_time': '51370',
                                                                                                                                            'mac_address': '28:76:10:1d:83:89',
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'tx_link_rate': '2310000000'}]}],
                                                                                        'tx_power': 14}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '2',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '631820766',
                                                              'in_ucast_pkts': '19673935',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:1a:80:29',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1288600332',
                                                              'out_ucast_pkts': '8644276',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '28:76:10:1a:80:2a',
                                                              'mtu': 1500,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'IgniteNet',
                                'model': 'ML-60-LW-US',
                                'poller_hash': 'KHYQGGg+',
                                'sw_version': '2.4.1-4363',
                                'system_mac_address': '28:76:10:1a:80:29',
                                'uptime': '51402'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '21344141',
                                                                       'links': [       {       'in_octets': '21344141',
                                                                                                'mac_address': '28:76:10:18:68:3e',
                                                                                                'out_octets': '13165149'}],
                                                                       'mac_address': '28:76:10:1c:59:48',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '13165149',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '51385',
                                                                                                                                                     'mac_address': '28:76:10:18:68:3e',
                                                                                                                                                     'rx_link_rate': '96000000',
                                                                                                                                                     'tx_link_rate': '130000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '13165149',
                                                                       'name': 'eth0',
                                                                       'out_octets': '21344141',
                                                                       'poller_hash': 'Mjg3NjEwMWM1OTQ4ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHFlI',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '21339837',
                                                                       'links': [       {       'in_octets': '21339837',
                                                                                                'mac_address': '28:76:10:18:68:3e',
                                                                                                'out_octets': '13164673'}],
                                                                       'mac_address': '28:76:10:1d:6c:04',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '13164673',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '51385',
                                                                                                                                                     'mac_address': '28:76:10:18:68:3e',
                                                                                                                                                     'rx_link_rate': '86000000',
                                                                                                                                                     'tx_link_rate': '65000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '13164673',
                                                                       'name': 'eth0',
                                                                       'out_octets': '21339837',
                                                                       'poller_hash': 'Mjg3NjEwMWQ2YzA0ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHWwE',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '22691674',
                                                                       'links': [       {       'in_octets': '22691674',
                                                                                                'mac_address': '28:76:10:18:68:3e',
                                                                                                'out_octets': '13250353'}],
                                                                       'mac_address': '28:76:10:1d:6d:4c',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '13250353',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '51383',
                                                                                                                                                     'mac_address': '28:76:10:18:68:3e',
                                                                                                                                                     'rx_link_rate': '192000000',
                                                                                                                                                     'tx_link_rate': '192000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '13250353',
                                                                       'name': 'eth0',
                                                                       'out_octets': '22691674',
                                                                       'poller_hash': 'Mjg3NjEwMWQ2ZDRjZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHW1M',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '3554687777',
                                                                       'links': [       {       'in_octets': '3554687777',
                                                                                                'mac_address': '28:76:10:18:68:3e',
                                                                                                'out_octets': '262453924'}],
                                                                       'mac_address': '28:76:10:1c:56:c9',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '262453924',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '51388',
                                                                                                                                                     'mac_address': '28:76:10:18:68:3e',
                                                                                                                                                     'rx_link_rate': '2310000000',
                                                                                                                                                     'tx_link_rate': '1925000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '262453924',
                                                                       'name': 'eth0',
                                                                       'out_octets': '3554687777',
                                                                       'poller_hash': 'Mjg3NjEwMWM1NmM5ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHFbJ',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '9286035377',
                                                                       'links': [       {       'in_octets': '9286035377',
                                                                                                'mac_address': '28:76:10:18:68:3e',
                                                                                                'out_octets': '588464751'}],
                                                                       'mac_address': '28:76:10:1d:83:42',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '588464751',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '51386',
                                                                                                                                                     'mac_address': '28:76:10:18:68:3e',
                                                                                                                                                     'rx_link_rate': '2310000000',
                                                                                                                                                     'tx_link_rate': '1251000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '588464751',
                                                                       'name': 'eth0',
                                                                       'out_octets': '9286035377',
                                                                       'poller_hash': 'Mjg3NjEwMWQ4MzQyZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHYNC',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '13666000045',
                                                                       'links': [       {       'in_octets': '13666000045',
                                                                                                'mac_address': '28:76:10:18:68:3e',
                                                                                                'out_octets': '469164589'}],
                                                                       'mac_address': '28:76:10:1d:83:89',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '469164589',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '51370',
                                                                                                                                                     'mac_address': '28:76:10:18:68:3e',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '469164589',
                                                                       'name': 'eth0',
                                                                       'out_octets': '13666000045',
                                                                       'poller_hash': 'Mjg3NjEwMWQ4Mzg5ZXRoMA=='}],
                                         'manufacturer': 'IgniteNet',
                                         'poller_hash': 'KHYQHYOJ',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
