import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestCalixModels(DeviceTestCase):

    def test_calix_axos_E7_2_21_3_0_10_255_2_254(self):
        obj = self.run_data("calix.axos.E7-2.21.3.0.10_255_2_254")
        exp_info = {
         'model': 'E7-2', 'sta_count': 138, 'sw_version': '21.3.0', 'vendor': 'Calix'
        }
        exp_stats = {
         'serial_number': '071707983043', 'system_mac_address': '00:02:5d:de:69:95'
        }
        exp_sta_stats = {
                '48:77:46:d2:63:76': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d2:63:76',
                                             'name': '367/g1',
                                             'serial_number': '7DAB4F',
                                             'system_mac_address': None},
                '48:77:46:d2:63:9d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d2:63:9d',
                                             'name': '369/g1',
                                             'serial_number': '7DAB5C',
                                             'system_mac_address': None},
                '48:77:46:d2:63:b8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d2:63:b8',
                                             'name': '372/g1',
                                             'serial_number': '7DAB65',
                                             'system_mac_address': None},
                '48:77:46:d2:63:c1': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d2:63:c1',
                                             'name': '376/g1',
                                             'serial_number': '7DAB68',
                                             'system_mac_address': None},
                '48:77:46:d2:63:d0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d2:63:d0',
                                             'name': '324/g1',
                                             'serial_number': '7DAB6D',
                                             'system_mac_address': None},
                '48:77:46:d2:63:d6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d2:63:d6',
                                             'name': '377/g1',
                                             'serial_number': '7DAB6F',
                                             'system_mac_address': None},
                '48:77:46:d2:63:e5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d2:63:e5',
                                             'name': '326/g1',
                                             'serial_number': '7DAB74',
                                             'system_mac_address': None},
                '48:77:46:d2:63:ee': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d2:63:ee',
                                             'name': '375/g1',
                                             'serial_number': '7DAB77',
                                             'system_mac_address': None},
                '48:77:46:d2:63:f4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d2:63:f4',
                                             'name': '374/g1',
                                             'serial_number': '7DAB79',
                                             'system_mac_address': None},
                '48:77:46:d6:1b:2a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d6:1b:2a',
                                             'name': '373/g1',
                                             'serial_number': '7E2ED1',
                                             'system_mac_address': None},
                '48:77:46:d6:1b:6f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d6:1b:6f',
                                             'name': '336/g1',
                                             'serial_number': '7E2EE8',
                                             'system_mac_address': None},
                '48:77:46:d6:1b:78': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d6:1b:78',
                                             'name': '335/g1',
                                             'serial_number': '7E2EEB',
                                             'system_mac_address': None},
                '48:77:46:d6:1b:7b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d6:1b:7b',
                                             'name': '371/g1',
                                             'serial_number': '7E2EEC',
                                             'system_mac_address': None},
                '48:77:46:d8:65:16': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d8:65:16',
                                             'name': '345/g1',
                                             'serial_number': '7F33D4',
                                             'system_mac_address': None},
                '48:77:46:d8:65:8b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d8:65:8b',
                                             'name': '333/g1',
                                             'serial_number': '7F33FB',
                                             'system_mac_address': None},
                '48:77:46:d8:65:fd': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d8:65:fd',
                                             'name': '347/g1',
                                             'serial_number': '7F3421',
                                             'system_mac_address': None},
                '48:77:46:d8:66:0c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d8:66:0c',
                                             'name': '519/g1',
                                             'serial_number': '7F3426',
                                             'system_mac_address': None},
                '48:77:46:d8:66:15': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d8:66:15',
                                             'name': '368/g1',
                                             'serial_number': '7F3429',
                                             'system_mac_address': None},
                '48:77:46:d8:66:21': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d8:66:21',
                                             'name': '366/g1',
                                             'serial_number': '7F342D',
                                             'system_mac_address': None},
                '48:77:46:d8:66:24': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d8:66:24',
                                             'name': '348/g1',
                                             'serial_number': '7F342E',
                                             'system_mac_address': None},
                '48:77:46:d8:66:27': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d8:66:27',
                                             'name': '364/g1',
                                             'serial_number': '7F342F',
                                             'system_mac_address': None},
                '48:77:46:d8:66:30': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d8:66:30',
                                             'name': '363/g1',
                                             'serial_number': '7F3432',
                                             'system_mac_address': None},
                '48:77:46:d8:6b:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d8:6b:10',
                                             'name': '332/g1',
                                             'serial_number': '7F35D2',
                                             'system_mac_address': None},
                '60:db:98:24:c6:1d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:24:c6:1d',
                                             'name': '130/g1',
                                             'serial_number': 'A34946',
                                             'system_mac_address': None},
                '60:db:98:24:c7:46': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:24:c7:46',
                                             'name': '338/g1',
                                             'serial_number': 'A349A9',
                                             'system_mac_address': None},
                '60:db:98:24:c7:79': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:24:c7:79',
                                             'name': '331/g1',
                                             'serial_number': 'A349BA',
                                             'system_mac_address': None},
                '60:db:98:24:c7:dc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:24:c7:dc',
                                             'name': '362/g1',
                                             'serial_number': 'A349DB',
                                             'system_mac_address': None},
                '60:db:98:24:c7:eb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:24:c7:eb',
                                             'name': '339/g1',
                                             'serial_number': 'A349E0',
                                             'system_mac_address': None},
                '60:db:98:24:c8:00': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:24:c8:00',
                                             'name': '361/g1',
                                             'serial_number': 'A349E7',
                                             'system_mac_address': None},
                '60:db:98:24:c8:1b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:24:c8:1b',
                                             'name': '378/g1',
                                             'serial_number': 'A349F0',
                                             'system_mac_address': None},
                '60:db:98:24:c8:1e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:24:c8:1e',
                                             'name': '360/g1',
                                             'serial_number': 'A349F1',
                                             'system_mac_address': None},
                '60:db:98:24:c8:24': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:24:c8:24',
                                             'name': '359/g1',
                                             'serial_number': 'A349F3',
                                             'system_mac_address': None},
                '60:db:98:24:c8:27': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:24:c8:27',
                                             'name': '344/g1',
                                             'serial_number': 'A349F4',
                                             'system_mac_address': None},
                '60:db:98:24:c8:2a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:24:c8:2a',
                                             'name': '325/g1',
                                             'serial_number': 'A349F5',
                                             'system_mac_address': None},
                '60:db:98:24:c8:3c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:24:c8:3c',
                                             'name': '342/g1',
                                             'serial_number': 'A349FB',
                                             'system_mac_address': None},
                '60:db:98:24:c8:3f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:24:c8:3f',
                                             'name': '341/g1',
                                             'serial_number': 'A349FC',
                                             'system_mac_address': None},
                '60:db:98:24:c8:4b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:24:c8:4b',
                                             'name': '358/g1',
                                             'serial_number': 'A34A00',
                                             'system_mac_address': None},
                '60:db:98:24:c8:5a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:24:c8:5a',
                                             'name': '357/g1',
                                             'serial_number': 'A34A05',
                                             'system_mac_address': None},
                '60:db:98:24:c8:72': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:24:c8:72',
                                             'name': '351/g1',
                                             'serial_number': 'A34A0D',
                                             'system_mac_address': None},
                '60:db:98:25:24:a6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:25:24:a6',
                                             'name': '346/g1',
                                             'serial_number': 'A368C9',
                                             'system_mac_address': None},
                '60:db:98:25:25:1e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:25:25:1e',
                                             'name': '356/g1',
                                             'serial_number': 'A368F1',
                                             'system_mac_address': None},
                '60:db:98:25:25:24': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:25:25:24',
                                             'name': '381/g1',
                                             'serial_number': 'A368F3',
                                             'system_mac_address': None},
                '60:db:98:25:25:4e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:25:25:4e',
                                             'name': '434/g1',
                                             'serial_number': 'A36901',
                                             'system_mac_address': None},
                '60:db:98:25:25:81': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:25:25:81',
                                             'name': '343/g1',
                                             'serial_number': 'A36912',
                                             'system_mac_address': None},
                '60:db:98:25:25:d5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:25:25:d5',
                                             'name': '386/g1',
                                             'serial_number': 'A3692E',
                                             'system_mac_address': None},
                '60:db:98:25:25:ff': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:25:25:ff',
                                             'name': '340/g1',
                                             'serial_number': 'A3693C',
                                             'system_mac_address': None},
                '60:db:98:25:26:20': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:25:26:20',
                                             'name': '380/g1',
                                             'serial_number': 'A36947',
                                             'system_mac_address': None},
                '60:db:98:30:ee:78': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:30:ee:78',
                                             'name': '379/g1',
                                             'serial_number': 'A55C01',
                                             'system_mac_address': None},
                '60:db:98:30:ef:08': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:30:ef:08',
                                             'name': '337/g1',
                                             'serial_number': 'A55C31',
                                             'system_mac_address': None},
                '60:db:98:30:ef:5c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:30:ef:5c',
                                             'name': '322/g1',
                                             'serial_number': 'A55C4D',
                                             'system_mac_address': None},
                '60:db:98:30:ef:7a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:30:ef:7a',
                                             'name': '352/g1',
                                             'serial_number': 'A55C57',
                                             'system_mac_address': None},
                '60:db:98:45:8b:83': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:45:8b:83',
                                             'name': '318/g1',
                                             'serial_number': 'A8B469',
                                             'system_mac_address': None},
                '60:db:98:68:6c:d9': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:68:6c:d9',
                                             'name': '432/g1',
                                             'serial_number': 'AD0F4D',
                                             'system_mac_address': None},
                '60:db:98:68:81:c4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:68:81:c4',
                                             'name': '417/g1',
                                             'serial_number': 'AD1646',
                                             'system_mac_address': None},
                '60:db:98:68:86:8c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:68:86:8c',
                                             'name': '441/g1',
                                             'serial_number': 'AD17DE',
                                             'system_mac_address': None},
                '60:db:98:68:87:52': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:68:87:52',
                                             'name': '433/g1',
                                             'serial_number': 'AD1820',
                                             'system_mac_address': None},
                '60:db:98:68:88:4b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:68:88:4b',
                                             'name': '440/g1',
                                             'serial_number': 'AD1873',
                                             'system_mac_address': None},
                '60:db:98:68:88:4e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:68:88:4e',
                                             'name': '407/g1',
                                             'serial_number': 'AD1874',
                                             'system_mac_address': None},
                '60:db:98:6f:f8:85': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:6f:f8:85',
                                             'name': '556/g1',
                                             'serial_number': 'AFF077',
                                             'system_mac_address': None},
                '60:db:98:70:00:e0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:70:00:e0',
                                             'name': '543/g1',
                                             'serial_number': 'AFF340',
                                             'system_mac_address': None},
                '60:db:98:70:01:f4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:70:01:f4',
                                             'name': '786/g1',
                                             'serial_number': 'AFF39C',
                                             'system_mac_address': None},
                '60:db:98:70:02:b1': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:70:02:b1',
                                             'name': '606/g1',
                                             'serial_number': 'AFF3DB',
                                             'system_mac_address': None},
                '60:db:98:72:6e:5a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:72:6e:5a',
                                             'name': '661/g1',
                                             'serial_number': 'B067C6',
                                             'system_mac_address': None},
                '60:db:98:75:f2:e7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:75:f2:e7',
                                             'name': '397/g1',
                                             'serial_number': 'B121D1',
                                             'system_mac_address': None},
                '60:db:98:75:f6:7d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:75:f6:7d',
                                             'name': '390/g1',
                                             'serial_number': 'B12303',
                                             'system_mac_address': None},
                '60:db:98:75:fa:a6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:75:fa:a6',
                                             'name': '382/g1',
                                             'serial_number': 'B12466',
                                             'system_mac_address': None},
                '60:db:98:75:fa:e8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:75:fa:e8',
                                             'name': '383/g1',
                                             'serial_number': 'B1247C',
                                             'system_mac_address': None},
                '60:db:98:75:fb:d5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:75:fb:d5',
                                             'name': '355/g1',
                                             'serial_number': 'B124CB',
                                             'system_mac_address': None},
                '60:db:98:75:fc:4d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:75:fc:4d',
                                             'name': '405/g1',
                                             'serial_number': 'B124F3',
                                             'system_mac_address': None},
                '60:db:98:75:fc:50': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:75:fc:50',
                                             'name': '385/g1',
                                             'serial_number': 'B124F4',
                                             'system_mac_address': None},
                '60:db:98:75:fc:aa': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:75:fc:aa',
                                             'name': '392/g1',
                                             'serial_number': 'B12512',
                                             'system_mac_address': None},
                '60:db:98:83:8a:69': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:83:8a:69',
                                             'name': '460/g1',
                                             'serial_number': 'B2DAF1',
                                             'system_mac_address': None},
                '60:db:98:83:8a:93': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:83:8a:93',
                                             'name': '479/g1',
                                             'serial_number': 'B2DAFF',
                                             'system_mac_address': None},
                '60:db:98:83:8a:b1': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:83:8a:b1',
                                             'name': '470/g1',
                                             'serial_number': 'B2DB09',
                                             'system_mac_address': None},
                '60:db:98:8d:a0:77': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8d:a0:77',
                                             'name': '493/g1',
                                             'serial_number': 'B49C41',
                                             'system_mac_address': None},
                '60:db:98:8d:a7:7c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8d:a7:7c',
                                             'name': '354/g1',
                                             'serial_number': 'B49E98',
                                             'system_mac_address': None},
                '60:db:98:8d:a7:f1': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8d:a7:f1',
                                             'name': '349/g1',
                                             'serial_number': 'B49EBF',
                                             'system_mac_address': None},
                '60:db:98:8d:a8:7e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8d:a8:7e',
                                             'name': '384/g1',
                                             'serial_number': 'B49EEE',
                                             'system_mac_address': None},
                '60:db:98:8e:53:75': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8e:53:75',
                                             'name': '430/g1',
                                             'serial_number': 'B4D7EB',
                                             'system_mac_address': None},
                '60:db:98:8e:53:7e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8e:53:7e',
                                             'name': '605/g1',
                                             'serial_number': 'B4D7EE',
                                             'system_mac_address': None},
                '60:db:98:8e:53:c9': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8e:53:c9',
                                             'name': '420/g1',
                                             'serial_number': 'B4D807',
                                             'system_mac_address': None},
                '60:db:98:8e:53:cc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8e:53:cc',
                                             'name': '428/g1',
                                             'serial_number': 'B4D808',
                                             'system_mac_address': None},
                '60:db:98:8e:8f:72': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8e:8f:72',
                                             'name': '496/g1',
                                             'serial_number': 'B4EBEA',
                                             'system_mac_address': None},
                '60:db:98:8e:90:26': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8e:90:26',
                                             'name': '484/g1',
                                             'serial_number': 'B4EC26',
                                             'system_mac_address': None},
                '84:d3:43:4d:31:e7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:4d:31:e7',
                                             'name': '472/g1',
                                             'serial_number': 'C12D50',
                                             'system_mac_address': None},
                '84:d3:43:4d:3a:72': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:4d:3a:72',
                                             'name': '464/g1',
                                             'serial_number': 'C13029',
                                             'system_mac_address': None},
                '84:d3:43:4d:3b:e0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:4d:3b:e0',
                                             'name': '473/g1',
                                             'serial_number': 'C130A3',
                                             'system_mac_address': None},
                '84:d3:43:4f:86:7f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:4f:86:7f',
                                             'name': '546/g1',
                                             'serial_number': 'C1B760',
                                             'system_mac_address': None},
                '84:d3:43:4f:87:ab': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:4f:87:ab',
                                             'name': '598/g1',
                                             'serial_number': 'C1B7C4',
                                             'system_mac_address': None},
                '84:d3:43:4f:87:cc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:4f:87:cc',
                                             'name': '686/g1',
                                             'serial_number': 'C1B7CF',
                                             'system_mac_address': None},
                '84:d3:43:4f:88:38': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:4f:88:38',
                                             'name': '552/g1',
                                             'serial_number': 'C1B7F3',
                                             'system_mac_address': None},
                '84:d3:43:4f:d5:48': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:4f:d5:48',
                                             'name': '495/g1',
                                             'serial_number': 'C1D1A3',
                                             'system_mac_address': None},
                '84:d3:43:4f:d7:7c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:4f:d7:7c',
                                             'name': '530/g1',
                                             'serial_number': 'C1D25F',
                                             'system_mac_address': None},
                '84:d3:43:4f:d7:8e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:4f:d7:8e',
                                             'name': '516/g1',
                                             'serial_number': 'C1D265',
                                             'system_mac_address': None},
                '84:d3:43:4f:d7:b2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:4f:d7:b2',
                                             'name': '481/g1',
                                             'serial_number': 'C1D271',
                                             'system_mac_address': None},
                '84:d3:43:4f:d8:21': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:4f:d8:21',
                                             'name': '505/g1',
                                             'serial_number': 'C1D296',
                                             'system_mac_address': None},
                '84:d3:43:54:34:9a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:54:34:9a',
                                             'name': '500/g1',
                                             'serial_number': 'C2760F',
                                             'system_mac_address': None},
                '84:d3:43:54:35:45': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:54:35:45',
                                             'name': '527/g1',
                                             'serial_number': 'C27648',
                                             'system_mac_address': None},
                '84:d3:43:54:35:c9': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:54:35:c9',
                                             'name': '506/g1',
                                             'serial_number': 'C27674',
                                             'system_mac_address': None},
                '84:d3:43:65:cd:53': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:65:cd:53',
                                             'name': '687/g1',
                                             'serial_number': 'C52248',
                                             'system_mac_address': None},
                '84:d3:43:65:ce:07': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:65:ce:07',
                                             'name': '674/g1',
                                             'serial_number': 'C52284',
                                             'system_mac_address': None},
                '84:d3:43:65:ce:88': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:65:ce:88',
                                             'name': '673/g1',
                                             'serial_number': 'C522AF',
                                             'system_mac_address': None},
                '84:d3:43:65:ce:9a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:65:ce:9a',
                                             'name': '685/g1',
                                             'serial_number': 'C522B5',
                                             'system_mac_address': None},
                '84:d3:43:65:ce:f1': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:65:ce:f1',
                                             'name': '680/g1',
                                             'serial_number': 'C522D2',
                                             'system_mac_address': None},
                '84:d3:43:65:d1:37': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:65:d1:37',
                                             'name': '675/g1',
                                             'serial_number': 'C52394',
                                             'system_mac_address': None},
                '84:d3:43:65:d1:49': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:65:d1:49',
                                             'name': '688/g1',
                                             'serial_number': 'C5239A',
                                             'system_mac_address': None},
                '84:d3:43:92:8d:31': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:92:8d:31',
                                             'name': '634/g1',
                                             'serial_number': 'CB6AED',
                                             'system_mac_address': None},
                '84:d3:43:92:8d:fa': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:92:8d:fa',
                                             'name': '579/g1',
                                             'serial_number': 'CB6B30',
                                             'system_mac_address': None},
                '84:d3:43:92:8e:93': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:92:8e:93',
                                             'name': '602/g1',
                                             'serial_number': 'CB6B63',
                                             'system_mac_address': None},
                '84:d3:43:92:8e:db': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:92:8e:db',
                                             'name': '624/g1',
                                             'serial_number': 'CB6B7B',
                                             'system_mac_address': None},
                '84:d3:43:92:8f:6e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:92:8f:6e',
                                             'name': '625/g1',
                                             'serial_number': 'CB6BAC',
                                             'system_mac_address': None},
                '84:d3:43:92:8f:8f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:92:8f:8f',
                                             'name': '631/g1',
                                             'serial_number': 'CB6BB7',
                                             'system_mac_address': None},
                '84:d3:43:a7:49:99': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:a7:49:99',
                                             'name': '656/g1',
                                             'serial_number': 'DAD20C',
                                             'system_mac_address': None},
                '84:d3:43:ae:55:4d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:ae:55:4d',
                                             'name': '584/g1',
                                             'serial_number': 'DC26EE',
                                             'system_mac_address': None},
                '84:d3:43:ae:56:82': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:ae:56:82',
                                             'name': '627/g1',
                                             'serial_number': 'DC2755',
                                             'system_mac_address': None},
                '84:d3:43:ae:56:b2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:ae:56:b2',
                                             'name': '615/g1',
                                             'serial_number': 'DC2765',
                                             'system_mac_address': None},
                '84:d3:43:ae:56:ca': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:ae:56:ca',
                                             'name': '626/g1',
                                             'serial_number': 'DC276D',
                                             'system_mac_address': None},
                '84:d3:43:ae:57:b4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:ae:57:b4',
                                             'name': '648/g1',
                                             'serial_number': 'DC27BB',
                                             'system_mac_address': None},
                '84:d3:43:ae:59:82': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:ae:59:82',
                                             'name': '620/g1',
                                             'serial_number': 'DC2855',
                                             'system_mac_address': None},
                '84:d3:43:ae:65:9d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:ae:65:9d',
                                             'name': '654/g1',
                                             'serial_number': 'DC2C5E',
                                             'system_mac_address': None},
                'cc:be:59:ae:4b:bc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ae:4b:bc',
                                             'name': '329/g1',
                                             'serial_number': '501984',
                                             'system_mac_address': None},
                'cc:be:59:ae:4c:1e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ae:4c:1e',
                                             'name': '28/g1',
                                             'serial_number': '5019B5',
                                             'system_mac_address': None},
                'cc:be:59:ae:4c:22': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ae:4c:22',
                                             'name': '328/g1',
                                             'serial_number': '5019B7',
                                             'system_mac_address': None},
                'cc:be:59:ae:4c:3a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ae:4c:3a',
                                             'name': '31/g1',
                                             'serial_number': '5019C3',
                                             'system_mac_address': None},
                'cc:be:59:ae:4c:3e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ae:4c:3e',
                                             'name': '365/g1',
                                             'serial_number': '5019C5',
                                             'system_mac_address': None},
                'cc:be:59:ae:4c:40': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ae:4c:40',
                                             'name': '327/g1',
                                             'serial_number': '5019C6',
                                             'system_mac_address': None},
                'f8:85:f9:0b:8f:0c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:0b:8f:0c',
                                             'name': '744/g1',
                                             'serial_number': 'DE13B2',
                                             'system_mac_address': None},
                'f8:85:f9:71:23:6f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:71:23:6f',
                                             'name': '750/g1',
                                             'serial_number': 'E0E7EA',
                                             'system_mac_address': None},
                'f8:85:f9:71:26:00': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:71:26:00',
                                             'name': '736/g1',
                                             'serial_number': 'E0E8C5',
                                             'system_mac_address': None},
                'f8:85:f9:94:c8:0d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:94:c8:0d',
                                             'name': '801/g1',
                                             'serial_number': '1068B8D',
                                             'system_mac_address': None},
                'f8:85:f9:94:c8:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:94:c8:10',
                                             'name': '807/g1',
                                             'serial_number': '1068B8E',
                                             'system_mac_address': None},
                'f8:85:f9:94:c8:3a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:94:c8:3a',
                                             'name': '802/g1',
                                             'serial_number': '1068B9C',
                                             'system_mac_address': None},
                'f8:85:f9:94:c8:4f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:94:c8:4f',
                                             'name': '834/g1',
                                             'serial_number': '1068BA3',
                                             'system_mac_address': None},
                'f8:85:f9:94:c8:ee': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:94:c8:ee',
                                             'name': '1062/g1',
                                             'serial_number': '1068BD8',
                                             'system_mac_address': None},
                'f8:85:f9:94:cb:58': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:94:cb:58',
                                             'name': '1032/g1',
                                             'serial_number': '1068CA6',
                                             'system_mac_address': None},
                'f8:85:f9:94:cf:45': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:94:cf:45',
                                             'name': '882/g1',
                                             'serial_number': '1068DF5',
                                             'system_mac_address': None},
                'f8:85:f9:94:d3:59': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:94:d3:59',
                                             'name': '1063/g1',
                                             'serial_number': '1068F51',
                                             'system_mac_address': None},
                'f8:85:f9:94:d4:70': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:94:d4:70',
                                             'name': '933/g1',
                                             'serial_number': '1068FAE',
                                             'system_mac_address': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': '24',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': 'cc:be:59:dc:72:b0',
                                                              'mtu': 1500,
                                                              'name': 'craft 1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '5403',
                                                              'out_ucast_pkts': '121',
                                                              'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YjBjcmFmdCAx'},
                                                      {       'admin_up': False,
                                                              'id': '28',
                                                              'mtu': 1500,
                                                              'name': 'craft 2',
                                                              'oper_up': False,
                                                              'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YjBjcmFmdCAy'}],
                                'manufacturer': 'Calix',
                                'model': 'E7-2',
                                'modules': [       {       'id': '1/1',
                                                           'interfaces': [       {       'admin_up': False,
                                                                                         'id': '110000101',
                                                                                         'mac_address': 'cc:be:59:dc:72:c5',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YzUxLzEvZzE='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000102',
                                                                                         'mac_address': 'cc:be:59:dc:72:c6',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YzYxLzEvZzI='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000103',
                                                                                         'mac_address': 'cc:be:59:dc:72:c7',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YzcxLzEvZzM='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000104',
                                                                                         'mac_address': 'cc:be:59:dc:72:c8',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YzgxLzEvZzQ='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000105',
                                                                                         'mac_address': 'cc:be:59:dc:72:c9',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YzkxLzEvZzU='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000106',
                                                                                         'mac_address': 'cc:be:59:dc:72:ca',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6Y2ExLzEvZzY='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000107',
                                                                                         'mac_address': 'cc:be:59:dc:72:cb',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6Y2IxLzEvZzc='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000108',
                                                                                         'mac_address': 'cc:be:59:dc:72:cc',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6Y2MxLzEvZzg='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110010101',
                                                                                         'mac_address': 'cc:be:59:dc:72:b5',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/x1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YjUxLzEveDE='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110010102',
                                                                                         'mac_address': 'cc:be:59:dc:72:b6',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/x2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YjYxLzEveDI='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110010103',
                                                                                         'mac_address': 'cc:be:59:dc:72:b7',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/x3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YjcxLzEveDM='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110010104',
                                                                                         'mac_address': 'cc:be:59:dc:72:b8',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/x4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YjgxLzEveDQ='},
                                                                                 {       'admin_up': False,
                                                                                         'name': '1/1/gp1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'cG9uIGludGYgMS8xL2dwMQ=='},
                                                                                 {       'admin_up': False,
                                                                                         'name': '1/1/gp2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'cG9uIGludGYgMS8xL2dwMg=='},
                                                                                 {       'admin_up': False,
                                                                                         'name': '1/1/gp3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'cG9uIGludGYgMS8xL2dwMw=='},
                                                                                 {       'admin_up': False,
                                                                                         'name': '1/1/gp4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'cG9uIGludGYgMS8xL2dwNA=='},
                                                                                 {       'admin_up': False,
                                                                                         'name': '1/1/gp5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'cG9uIGludGYgMS8xL2dwNQ=='},
                                                                                 {       'admin_up': False,
                                                                                         'name': '1/1/gp6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'cG9uIGludGYgMS8xL2dwNg=='},
                                                                                 {       'admin_up': False,
                                                                                         'name': '1/1/gp7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'cG9uIGludGYgMS8xL2dwNw=='},
                                                                                 {       'admin_up': False,
                                                                                         'name': '1/1/gp8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'cG9uIGludGYgMS8xL2dwOA=='}],
                                                           'manufacturer': 'Calix',
                                                           'name': '1/1',
                                                           'poller_hash': 'bW9kdWxlIDEvMQ==',
                                                           'sw_version': '21.3.0'},
                                                   {       'cpu': 15.0,
                                                           'id': '1/2',
                                                           'interfaces': [       {       'admin_up': False,
                                                                                         'id': '120000101',
                                                                                         'mac_address': 'cc:be:59:dc:72:c5',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YzUxLzIvZzE='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000102',
                                                                                         'mac_address': 'cc:be:59:dc:72:c6',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YzYxLzIvZzI='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000103',
                                                                                         'mac_address': 'cc:be:59:dc:72:c7',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YzcxLzIvZzM='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000104',
                                                                                         'mac_address': 'cc:be:59:dc:72:c8',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YzgxLzIvZzQ='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000105',
                                                                                         'mac_address': 'cc:be:59:dc:72:c9',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YzkxLzIvZzU='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000106',
                                                                                         'mac_address': 'cc:be:59:dc:72:ca',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6Y2ExLzIvZzY='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000107',
                                                                                         'mac_address': 'cc:be:59:dc:72:cb',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6Y2IxLzIvZzc='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000108',
                                                                                         'mac_address': 'cc:be:59:dc:72:cc',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6Y2MxLzIvZzg='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010101',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '21490171',
                                                                                         'in_octets': '223558547096280',
                                                                                         'in_ucast_pkts': '165162937728',
                                                                                         'in_unknown_protos': '0',
                                                                                         'mac_address': 'cc:be:59:dc:72:b5',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01508',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/x1',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '3487643',
                                                                                         'out_octets': '17886998896110',
                                                                                         'out_ucast_pkts': '61797770741',
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YjUxLzIveDE=',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120010102',
                                                                                         'mac_address': 'cc:be:59:dc:72:b6',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/x2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YjYxLzIveDI='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010103',
                                                                                         'mac_address': 'cc:be:59:dc:72:b7',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/x3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YjcxLzIveDM='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120010104',
                                                                                         'mac_address': 'cc:be:59:dc:72:b8',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/x4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YjgxLzIveDQ='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010105',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2446533',
                                                                                         'in_octets': '514030606450',
                                                                                         'in_ucast_pkts': '1258991958',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '82',
                                                                                                                  'in_octets': '63018558933',
                                                                                                                  'in_ucast_pkts': '127260727',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '328274977866',
                                                                                                                  'out_ucast_pkts': '300678159',
                                                                                                                  'poller_hash': 'NTAxOUI1cGVlcmludGYyOC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '20',
                                                                                                                  'in_octets': '135591327565',
                                                                                                                  'in_ucast_pkts': '221701563',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '350629106778',
                                                                                                                  'out_ucast_pkts': '344895224',
                                                                                                                  'poller_hash': 'NTAxOUMzcGVlcmludGYzMS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '16272993',
                                                                                                                  'in_octets': '844356100650',
                                                                                                                  'in_ucast_pkts': '2093399260',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '24339243',
                                                                                                                  'out_octets': '4298730039980',
                                                                                                                  'out_ucast_pkts': '3543311930',
                                                                                                                  'poller_hash': 'QTM0OTQ2cGVlcmludGYxMzAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '17427',
                                                                                                                  'in_octets': '96688362047',
                                                                                                                  'in_ucast_pkts': '232276064',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '10331421',
                                                                                                                  'out_octets': '739885761092',
                                                                                                                  'out_ucast_pkts': '635211083',
                                                                                                                  'poller_hash': 'QjEyMUQxcGVlcmludGYzOTcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '16955',
                                                                                                                  'in_octets': '65954505813',
                                                                                                                  'in_ucast_pkts': '100508525',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '9996897',
                                                                                                                  'out_octets': '274032721679',
                                                                                                                  'out_ucast_pkts': '227631283',
                                                                                                                  'poller_hash': 'QzFCN0YzcGVlcmludGY1NTIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '25035',
                                                                                                                  'in_octets': '85655324563',
                                                                                                                  'in_ucast_pkts': '497186768',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '14786881',
                                                                                                                  'out_octets': '2566526731691',
                                                                                                                  'out_ucast_pkts': '1796833532',
                                                                                                                  'poller_hash': 'REMyNzY1cGVlcmludGY2MTUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '11665',
                                                                                                                  'in_octets': '94509731166',
                                                                                                                  'in_ucast_pkts': '707491795',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '6919139',
                                                                                                                  'out_octets': '2512358124423',
                                                                                                                  'out_ucast_pkts': '1782118710',
                                                                                                                  'poller_hash': 'MTA2OEJBM3BlZXJpbnRmODM0L2dwMQ=='}],
                                                                                         'mac_address': 'cc:be:59:dc:72:b9',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp1',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '3628608045725',
                                                                                         'out_ucast_pkts': '2889093761',
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YjkxLzIvZ3Ax',
                                                                                         'pons': [       {       'description': '1/2/gp1',
                                                                                                                 'id': '120010105',
                                                                                                                 'links': [       {       'connected_time': '5368012',
                                                                                                                                          'fiber_length': 471,
                                                                                                                                          'poller_hash': 'NTAxOUI1cGVlcnBvbjI4L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7696},
                                                                                                                                  {       'connected_time': '5725059',
                                                                                                                                          'fiber_length': 475,
                                                                                                                                          'poller_hash': 'NTAxOUMzcGVlcnBvbjMxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -5.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7696},
                                                                                                                                  {       'connected_time': '5727419',
                                                                                                                                          'fiber_length': 1077,
                                                                                                                                          'poller_hash': 'QTM0OTQ2cGVlcnBvbjEzMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7696},
                                                                                                                                  {       'connected_time': '20661455',
                                                                                                                                          'fiber_length': 898,
                                                                                                                                          'poller_hash': 'QjEyMUQxcGVlcnBvbjM5Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7696},
                                                                                                                                  {       'connected_time': '19992426',
                                                                                                                                          'fiber_length': 1678,
                                                                                                                                          'poller_hash': 'QzFCN0YzcGVlcnBvbjU1Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7696},
                                                                                                                                  {       'connected_time': '29572578',
                                                                                                                                          'fiber_length': 1809,
                                                                                                                                          'poller_hash': 'REMyNzY1cGVlcnBvbjYxNS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7696},
                                                                                                                                  {       'connected_time': '13837308',
                                                                                                                                          'fiber_length': 752,
                                                                                                                                          'poller_hash': 'MTA2OEJBM3BlZXJwb244MzQvZ3Ax',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7696}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/2/gp1',
                                                                                                                 'poller_hash': 'Y2NiZTU5ZGM3MmI5MTIwMDEwMTA1',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010106',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '14111',
                                                                                         'in_octets': '1548055402951',
                                                                                         'in_ucast_pkts': '2928747823',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '22',
                                                                                                                  'in_octets': '253023859',
                                                                                                                  'in_ucast_pkts': '1300146',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '9826',
                                                                                                                  'out_octets': '8253119064',
                                                                                                                  'out_ucast_pkts': '8078648',
                                                                                                                  'poller_hash': 'QTU1QzREcGVlcmludGYzMjIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '4829',
                                                                                                                  'in_octets': '101115263621',
                                                                                                                  'in_ucast_pkts': '433594890',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '2689788',
                                                                                                                  'out_octets': '3159972141320',
                                                                                                                  'out_ucast_pkts': '2185856535',
                                                                                                                  'poller_hash': 'QTM0OUY1cGVlcmludGYzMjUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1752059',
                                                                                                                  'in_octets': '27182637189',
                                                                                                                  'in_ucast_pkts': '142645595',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '777994933510',
                                                                                                                  'out_ucast_pkts': '571799307',
                                                                                                                  'poller_hash': 'NTAxOUI3cGVlcmludGYzMjgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '982',
                                                                                                                  'in_octets': '9670249607',
                                                                                                                  'in_ucast_pkts': '54590829',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '571428',
                                                                                                                  'out_octets': '308865582243',
                                                                                                                  'out_ucast_pkts': '210583990',
                                                                                                                  'poller_hash': 'MTA2OEY1MXBlZXJpbnRmMTA2My9ncDE='}],
                                                                                         'mac_address': 'cc:be:59:dc:72:ba',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp2',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '7932619725535',
                                                                                         'out_ucast_pkts': '6910401416',
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmExLzIvZ3Ay',
                                                                                         'pons': [       {       'description': '1/2/gp2',
                                                                                                                 'id': '120010106',
                                                                                                                 'links': [       {       'connected_time': '18141',
                                                                                                                                          'fiber_length': 3274,
                                                                                                                                          'poller_hash': 'QTU1QzREcGVlcnBvbjMyMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.668524},
                                                                                                                                  {       'connected_time': '5378061',
                                                                                                                                          'fiber_length': 2966,
                                                                                                                                          'poller_hash': 'QTM0OUY1cGVlcnBvbjMyNS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.668524},
                                                                                                                                  {       'connected_time': '9885581',
                                                                                                                                          'fiber_length': 2393,
                                                                                                                                          'poller_hash': 'NTAxOUI3cGVlcnBvbjMyOC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.668524},
                                                                                                                                  {       'connected_time': '1141934',
                                                                                                                                          'fiber_length': 2814,
                                                                                                                                          'poller_hash': 'MTA2OEY1MXBlZXJwb24xMDYzL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.668524}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/2/gp2',
                                                                                                                 'poller_hash': 'Y2NiZTU5ZGM3MmJhMTIwMDEwMTA2',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010107',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '69959',
                                                                                         'in_octets': '1564474982904',
                                                                                         'in_ucast_pkts': '5067683519',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '223105',
                                                                                                                  'in_octets': '633025332',
                                                                                                                  'in_ucast_pkts': '6794442',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '6331861',
                                                                                                                  'out_octets': '680088855',
                                                                                                                  'out_ucast_pkts': '2968971',
                                                                                                                  'poller_hash': 'N0RBQjZEcGVlcmludGYzMjQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13008',
                                                                                                                  'in_octets': '138288318783',
                                                                                                                  'in_ucast_pkts': '360482796',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723288',
                                                                                                                  'out_octets': '1338279325311',
                                                                                                                  'out_ucast_pkts': '1014582011',
                                                                                                                  'poller_hash': 'N0RBQjc0cGVlcmludGYzMjYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '65807',
                                                                                                                  'in_octets': '165806616154',
                                                                                                                  'in_ucast_pkts': '5031447623',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '256',
                                                                                                                  'out_octets': '2760545906016',
                                                                                                                  'out_ucast_pkts': '6338208405',
                                                                                                                  'poller_hash': 'NTAxOUM2cGVlcmludGYzMjcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '206',
                                                                                                                  'in_octets': '89409498295',
                                                                                                                  'in_ucast_pkts': '621647017',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '2231565065303',
                                                                                                                  'out_ucast_pkts': '1559842552',
                                                                                                                  'poller_hash': 'NTAxOTg0cGVlcmludGYzMjkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13052',
                                                                                                                  'in_octets': '113228643288',
                                                                                                                  'in_ucast_pkts': '300979064',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723208',
                                                                                                                  'out_octets': '968400707052',
                                                                                                                  'out_ucast_pkts': '774329833',
                                                                                                                  'poller_hash': 'QTM0OUJBcGVlcmludGYzMzEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '136',
                                                                                                                  'in_octets': '142493068235',
                                                                                                                  'in_ucast_pkts': '250653024',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '6319513',
                                                                                                                  'out_octets': '817067734824',
                                                                                                                  'out_ucast_pkts': '618943698',
                                                                                                                  'poller_hash': 'N0YzNUQycGVlcmludGYzMzIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '142',
                                                                                                                  'in_octets': '134135706458',
                                                                                                                  'in_ucast_pkts': '474848946',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723395',
                                                                                                                  'out_octets': '1091370172147',
                                                                                                                  'out_ucast_pkts': '892257160',
                                                                                                                  'poller_hash': 'N0YzM0ZCcGVlcmludGYzMzMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13045',
                                                                                                                  'in_octets': '456222703535',
                                                                                                                  'in_ucast_pkts': '883844408',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723345',
                                                                                                                  'out_octets': '1788955704787',
                                                                                                                  'out_ucast_pkts': '1365550656',
                                                                                                                  'poller_hash': 'N0UyRUVCcGVlcmludGYzMzUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '14',
                                                                                                                  'in_octets': '18609329627',
                                                                                                                  'in_ucast_pkts': '60839447',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '953173',
                                                                                                                  'out_octets': '250126147164',
                                                                                                                  'out_ucast_pkts': '181067775',
                                                                                                                  'poller_hash': 'N0UyRUU4cGVlcmludGYzMzYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13013',
                                                                                                                  'in_octets': '250548111270',
                                                                                                                  'in_ucast_pkts': '1512767041',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723365',
                                                                                                                  'out_octets': '4747348412347',
                                                                                                                  'out_ucast_pkts': '3435037475',
                                                                                                                  'poller_hash': 'QTM0OUZCcGVlcmludGYzNDIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13032',
                                                                                                                  'in_octets': '80289101832',
                                                                                                                  'in_ucast_pkts': '266479701',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723523',
                                                                                                                  'out_octets': '1053507487724',
                                                                                                                  'out_ucast_pkts': '817518791',
                                                                                                                  'poller_hash': 'QTM2OTJFcGVlcmludGYzODYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '8358',
                                                                                                                  'in_octets': '59226060623',
                                                                                                                  'in_ucast_pkts': '137549835',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '4983693',
                                                                                                                  'out_octets': '833896649840',
                                                                                                                  'out_ucast_pkts': '666363730',
                                                                                                                  'poller_hash': 'QUQxODc0cGVlcmludGY0MDcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '3721997',
                                                                                                                  'in_octets': '194760893047',
                                                                                                                  'in_ucast_pkts': '1005556541',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723454',
                                                                                                                  'out_octets': '3903031608060',
                                                                                                                  'out_ucast_pkts': '2838138319',
                                                                                                                  'poller_hash': 'QUQxODczcGVlcmludGY0NDAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '2344',
                                                                                                                  'in_octets': '31678210599',
                                                                                                                  'in_ucast_pkts': '136836652',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1380752',
                                                                                                                  'out_octets': '783580280414',
                                                                                                                  'out_ucast_pkts': '581606020',
                                                                                                                  'poller_hash': 'QzI3NjQ4cGVlcmludGY1MjcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '18242',
                                                                                                                  'in_octets': '289789939533',
                                                                                                                  'in_ucast_pkts': '853137641',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '10748394',
                                                                                                                  'out_octets': '4753733909979',
                                                                                                                  'out_ucast_pkts': '3399062453',
                                                                                                                  'poller_hash': 'QzFEMjVGcGVlcmludGY1MzAvZ3Ax'}],
                                                                                         'mac_address': 'cc:be:59:dc:72:bb',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05121',
                                                                                         'name': '1/2/gp3',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '17958217048094',
                                                                                         'out_ucast_pkts': '13259978262',
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmIxLzIvZ3Az',
                                                                                         'pons': [       {       'description': '1/2/gp3',
                                                                                                                 'id': '120010107',
                                                                                                                 'links': [       {       'connected_time': '15445270',
                                                                                                                                          'fiber_length': 4803,
                                                                                                                                          'poller_hash': 'N0RBQjZEcGVlcnBvbjMyNC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.688817},
                                                                                                                                  {       'connected_time': '15445071',
                                                                                                                                          'fiber_length': 3329,
                                                                                                                                          'poller_hash': 'N0RBQjc0cGVlcnBvbjMyNi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.688817},
                                                                                                                                  {       'connected_time': '7624794',
                                                                                                                                          'fiber_length': 3218,
                                                                                                                                          'poller_hash': 'NTAxOUM2cGVlcnBvbjMyNy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.688817},
                                                                                                                                  {       'connected_time': '8559598',
                                                                                                                                          'fiber_length': 3417,
                                                                                                                                          'poller_hash': 'NTAxOTg0cGVlcnBvbjMyOS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.688817},
                                                                                                                                  {       'connected_time': '15445190',
                                                                                                                                          'fiber_length': 4790,
                                                                                                                                          'poller_hash': 'QTM0OUJBcGVlcnBvbjMzMS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.688817},
                                                                                                                                  {       'connected_time': '12637532',
                                                                                                                                          'fiber_length': 4916,
                                                                                                                                          'poller_hash': 'N0YzNUQycGVlcnBvbjMzMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.688817},
                                                                                                                                  {       'connected_time': '15445272',
                                                                                                                                          'fiber_length': 4251,
                                                                                                                                          'poller_hash': 'N0YzM0ZCcGVlcnBvbjMzMy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.688817},
                                                                                                                                  {       'connected_time': '15445198',
                                                                                                                                          'fiber_length': 4362,
                                                                                                                                          'poller_hash': 'N0UyRUVCcGVlcnBvbjMzNS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.688817},
                                                                                                                                  {       'connected_time': '1904810',
                                                                                                                                          'fiber_length': 4608,
                                                                                                                                          'poller_hash': 'N0UyRUU4cGVlcnBvbjMzNi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.688817},
                                                                                                                                  {       'connected_time': '15445279',
                                                                                                                                          'fiber_length': 4857,
                                                                                                                                          'poller_hash': 'QTM0OUZCcGVlcnBvbjM0Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.688817},
                                                                                                                                  {       'connected_time': '15445653',
                                                                                                                                          'fiber_length': 4924,
                                                                                                                                          'poller_hash': 'QTM2OTJFcGVlcnBvbjM4Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.688817},
                                                                                                                                  {       'connected_time': '9965926',
                                                                                                                                          'fiber_length': 3262,
                                                                                                                                          'poller_hash': 'QUQxODc0cGVlcnBvbjQwNy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.688817},
                                                                                                                                  {       'connected_time': '15445525',
                                                                                                                                          'fiber_length': 4775,
                                                                                                                                          'poller_hash': 'QUQxODczcGVlcnBvbjQ0MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.688817},
                                                                                                                                  {       'connected_time': '2760056',
                                                                                                                                          'fiber_length': 3363,
                                                                                                                                          'poller_hash': 'QzI3NjQ4cGVlcnBvbjUyNy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.688817},
                                                                                                                                  {       'connected_time': '21495614',
                                                                                                                                          'fiber_length': 3265,
                                                                                                                                          'poller_hash': 'QzFEMjVGcGVlcnBvbjUzMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.688817}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/2/gp3',
                                                                                                                 'poller_hash': 'Y2NiZTU5ZGM3MmJiMTIwMDEwMTA3',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010108',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '163314',
                                                                                         'in_octets': '3322954944344',
                                                                                         'in_ucast_pkts': '10609917993',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13015',
                                                                                                                  'in_octets': '84229277945',
                                                                                                                  'in_ucast_pkts': '409199665',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723314',
                                                                                                                  'out_octets': '2499565148593',
                                                                                                                  'out_ucast_pkts': '1810329632',
                                                                                                                  'poller_hash': 'QThCNDY5cGVlcmludGYzMTgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '6429',
                                                                                                                  'in_octets': '64184032487',
                                                                                                                  'in_ucast_pkts': '378113050',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '3811384',
                                                                                                                  'out_octets': '1456289704119',
                                                                                                                  'out_ucast_pkts': '1047371459',
                                                                                                                  'poller_hash': 'QjQ5RTk4cGVlcmludGYzNTQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13036',
                                                                                                                  'in_octets': '1422089291794',
                                                                                                                  'in_ucast_pkts': '2460686575',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723426',
                                                                                                                  'out_octets': '10398292446419',
                                                                                                                  'out_ucast_pkts': '7494448002',
                                                                                                                  'poller_hash': 'QjEyNENCcGVlcmludGYzNTUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '6298',
                                                                                                                  'in_octets': '43347855406',
                                                                                                                  'in_ucast_pkts': '353519047',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '3722237',
                                                                                                                  'out_octets': '560789727940',
                                                                                                                  'out_ucast_pkts': '393320641',
                                                                                                                  'poller_hash': 'QTM2OEYxcGVlcmludGYzNTYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '3810',
                                                                                                                  'in_octets': '83276674731',
                                                                                                                  'in_ucast_pkts': '242135800',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '2258347',
                                                                                                                  'out_octets': '761226679017',
                                                                                                                  'out_ucast_pkts': '573298378',
                                                                                                                  'poller_hash': 'QTM0QTA1cGVlcmludGYzNTcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '7292',
                                                                                                                  'in_octets': '49226623373',
                                                                                                                  'in_ucast_pkts': '199514299',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '4315576',
                                                                                                                  'out_octets': '1310215566763',
                                                                                                                  'out_ucast_pkts': '917323158',
                                                                                                                  'poller_hash': 'QTM0QTAwcGVlcmludGYzNTgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13046',
                                                                                                                  'in_octets': '93635445923',
                                                                                                                  'in_ucast_pkts': '529649580',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723388',
                                                                                                                  'out_octets': '2073497392431',
                                                                                                                  'out_ucast_pkts': '1555893356',
                                                                                                                  'poller_hash': 'QTM0OUYzcGVlcmludGYzNTkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '12996',
                                                                                                                  'in_octets': '161979462609',
                                                                                                                  'in_ucast_pkts': '1080402278',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723364',
                                                                                                                  'out_octets': '5729387291130',
                                                                                                                  'out_ucast_pkts': '3972313832',
                                                                                                                  'poller_hash': 'QTM0OUYxcGVlcmludGYzNjAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13028',
                                                                                                                  'in_octets': '50040965179',
                                                                                                                  'in_ucast_pkts': '456111598',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723297',
                                                                                                                  'out_octets': '2283239668339',
                                                                                                                  'out_ucast_pkts': '1552262374',
                                                                                                                  'poller_hash': 'QTM0OUU3cGVlcmludGYzNjEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13020',
                                                                                                                  'in_octets': '366181922176',
                                                                                                                  'in_ucast_pkts': '1428403392',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723384',
                                                                                                                  'out_octets': '5997380995885',
                                                                                                                  'out_ucast_pkts': '4508043256',
                                                                                                                  'poller_hash': 'QTM0OURCcGVlcmludGYzNjIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '4972739',
                                                                                                                  'in_octets': '139976927860',
                                                                                                                  'in_ucast_pkts': '519043778',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7674009',
                                                                                                                  'out_octets': '2338571259838',
                                                                                                                  'out_ucast_pkts': '1717824270',
                                                                                                                  'poller_hash': 'N0YzNDMycGVlcmludGYzNjMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13073',
                                                                                                                  'in_octets': '234460374936',
                                                                                                                  'in_ucast_pkts': '1750993977',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723301',
                                                                                                                  'out_octets': '7172315602568',
                                                                                                                  'out_ucast_pkts': '4933655875',
                                                                                                                  'poller_hash': 'N0YzNDJGcGVlcmludGYzNjQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '65807',
                                                                                                                  'in_octets': '38128213414',
                                                                                                                  'in_ucast_pkts': '4484737258',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '256',
                                                                                                                  'out_octets': '598840586662',
                                                                                                                  'out_ucast_pkts': '4749484968',
                                                                                                                  'poller_hash': 'NTAxOUM1cGVlcmludGYzNjUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '147',
                                                                                                                  'in_octets': '361653239526',
                                                                                                                  'in_ucast_pkts': '1707836249',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723371',
                                                                                                                  'out_octets': '6507383282850',
                                                                                                                  'out_ucast_pkts': '4824742594',
                                                                                                                  'poller_hash': 'N0YzNDJEcGVlcmludGYzNjYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '11658',
                                                                                                                  'in_octets': '392808412922',
                                                                                                                  'in_ucast_pkts': '1392416369',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '6943655',
                                                                                                                  'out_octets': '3307534443278',
                                                                                                                  'out_ucast_pkts': '2964842274',
                                                                                                                  'poller_hash': 'N0RBQjRGcGVlcmludGYzNjcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13021',
                                                                                                                  'in_octets': '122767967546',
                                                                                                                  'in_ucast_pkts': '314089975',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723464',
                                                                                                                  'out_octets': '943981825406',
                                                                                                                  'out_ucast_pkts': '738825681',
                                                                                                                  'poller_hash': 'N0YzNDI5cGVlcmludGYzNjgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '8692',
                                                                                                                  'in_octets': '40816328045',
                                                                                                                  'in_ucast_pkts': '156979859',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '5143551',
                                                                                                                  'out_octets': '1251025958867',
                                                                                                                  'out_ucast_pkts': '902384809',
                                                                                                                  'poller_hash': 'N0RBQjVDcGVlcmludGYzNjkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '10123',
                                                                                                                  'in_octets': '57445688181',
                                                                                                                  'in_ucast_pkts': '186237188',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '6000192',
                                                                                                                  'out_octets': '656569545350',
                                                                                                                  'out_ucast_pkts': '509734189',
                                                                                                                  'poller_hash': 'N0UyRUVDcGVlcmludGYzNzEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '12950',
                                                                                                                  'in_octets': '116551717912',
                                                                                                                  'in_ucast_pkts': '423640530',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7660790',
                                                                                                                  'out_octets': '2477121976943',
                                                                                                                  'out_ucast_pkts': '1873502070',
                                                                                                                  'poller_hash': 'N0RBQjY1cGVlcmludGYzNzIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '5534',
                                                                                                                  'in_octets': '265452166030',
                                                                                                                  'in_ucast_pkts': '723370765',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '3279437',
                                                                                                                  'out_octets': '2095548320732',
                                                                                                                  'out_ucast_pkts': '1595184817',
                                                                                                                  'poller_hash': 'N0UyRUQxcGVlcmludGYzNzMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '5257',
                                                                                                                  'in_octets': '22875737331',
                                                                                                                  'in_ucast_pkts': '76275939',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '3117173',
                                                                                                                  'out_octets': '223285407886',
                                                                                                                  'out_ucast_pkts': '176165384',
                                                                                                                  'poller_hash': 'N0RBQjc5cGVlcmludGYzNzQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13026',
                                                                                                                  'in_octets': '22162943386',
                                                                                                                  'in_ucast_pkts': '134564468',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723187',
                                                                                                                  'out_octets': '278982345258',
                                                                                                                  'out_ucast_pkts': '239973445',
                                                                                                                  'poller_hash': 'N0RBQjc3cGVlcmludGYzNzUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '7383',
                                                                                                                  'in_octets': '74976998788',
                                                                                                                  'in_ucast_pkts': '262706787',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '4370990',
                                                                                                                  'out_octets': '1723139241103',
                                                                                                                  'out_ucast_pkts': '1251376943',
                                                                                                                  'poller_hash': 'N0RBQjY4cGVlcmludGYzNzYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '5851',
                                                                                                                  'in_octets': '32602905526',
                                                                                                                  'in_ucast_pkts': '140595457',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '3465258',
                                                                                                                  'out_octets': '422006962855',
                                                                                                                  'out_ucast_pkts': '326505000',
                                                                                                                  'poller_hash': 'N0RBQjZGcGVlcmludGYzNzcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '9482',
                                                                                                                  'in_octets': '100127588494',
                                                                                                                  'in_ucast_pkts': '422617041',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '5617869',
                                                                                                                  'out_octets': '1153475469629',
                                                                                                                  'out_ucast_pkts': '885130356',
                                                                                                                  'poller_hash': 'QUQxN0RFcGVlcmludGY0NDEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '14',
                                                                                                                  'in_octets': '118435599317',
                                                                                                                  'in_ucast_pkts': '178106124',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1165964',
                                                                                                                  'out_octets': '553471351893',
                                                                                                                  'out_ucast_pkts': '449197688',
                                                                                                                  'poller_hash': 'N0YzNDI2cGVlcmludGY1MTkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13030',
                                                                                                                  'in_octets': '308861279453',
                                                                                                                  'in_ucast_pkts': '1311903648',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723571',
                                                                                                                  'out_octets': '5930986126303',
                                                                                                                  'out_ucast_pkts': '4174563933',
                                                                                                                  'poller_hash': 'QUZGM0RCcGVlcmludGY2MDYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13005',
                                                                                                                  'in_octets': '17114565844',
                                                                                                                  'in_ucast_pkts': '148017639',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723724',
                                                                                                                  'out_octets': '44720744048',
                                                                                                                  'out_ucast_pkts': '92668082',
                                                                                                                  'poller_hash': 'RTBFOEM1cGVlcmludGY3MzYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '998',
                                                                                                                  'in_octets': '19588515759',
                                                                                                                  'in_ucast_pkts': '87246063',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '579043',
                                                                                                                  'out_octets': '333121747008',
                                                                                                                  'out_ucast_pkts': '229350067',
                                                                                                                  'poller_hash': 'MTA2OEJEOHBlZXJpbnRmMTA2Mi9ncDE='}],
                                                                                         'mac_address': 'cc:be:59:dc:72:bc',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp4',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '41434821063143',
                                                                                         'out_ucast_pkts': '30413522021',
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0',
                                                                                         'pons': [       {       'description': '1/2/gp4',
                                                                                                                 'id': '120010108',
                                                                                                                 'links': [       {       'connected_time': '15445184',
                                                                                                                                          'fiber_length': 4899,
                                                                                                                                          'poller_hash': 'QThCNDY5cGVlcnBvbjMxOC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '7621307',
                                                                                                                                          'fiber_length': 4572,
                                                                                                                                          'poller_hash': 'QjQ5RTk4cGVlcnBvbjM1NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '15445390',
                                                                                                                                          'fiber_length': 5314,
                                                                                                                                          'poller_hash': 'QjEyNENCcGVlcnBvbjM1NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '7442989',
                                                                                                                                          'fiber_length': 4650,
                                                                                                                                          'poller_hash': 'QTM2OEYxcGVlcnBvbjM1Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '4515208',
                                                                                                                                          'fiber_length': 4554,
                                                                                                                                          'poller_hash': 'QTM0QTA1cGVlcnBvbjM1Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '8629703',
                                                                                                                                          'fiber_length': 4807,
                                                                                                                                          'poller_hash': 'QTM0QTAwcGVlcnBvbjM1OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '15445311',
                                                                                                                                          'fiber_length': 4680,
                                                                                                                                          'poller_hash': 'QTM0OUYzcGVlcnBvbjM1OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '15445386',
                                                                                                                                          'fiber_length': 4408,
                                                                                                                                          'poller_hash': 'QTM0OUYxcGVlcnBvbjM2MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '15445279',
                                                                                                                                          'fiber_length': 4700,
                                                                                                                                          'poller_hash': 'QTM0OUU3cGVlcnBvbjM2MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '15445368',
                                                                                                                                          'fiber_length': 4854,
                                                                                                                                          'poller_hash': 'QTM0OURCcGVlcnBvbjM2Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '15445969',
                                                                                                                                          'fiber_length': 5165,
                                                                                                                                          'poller_hash': 'N0YzNDMycGVlcnBvbjM2My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '15445248',
                                                                                                                                          'fiber_length': 4506,
                                                                                                                                          'poller_hash': 'N0YzNDJGcGVlcnBvbjM2NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '15444626',
                                                                                                                                          'fiber_length': 5101,
                                                                                                                                          'poller_hash': 'NTAxOUM1cGVlcnBvbjM2NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '15445317',
                                                                                                                                          'fiber_length': 4791,
                                                                                                                                          'poller_hash': 'N0YzNDJEcGVlcnBvbjM2Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '13885852',
                                                                                                                                          'fiber_length': 4821,
                                                                                                                                          'poller_hash': 'N0RBQjRGcGVlcnBvbjM2Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '15445474',
                                                                                                                                          'fiber_length': 5415,
                                                                                                                                          'poller_hash': 'N0YzNDI5cGVlcnBvbjM2OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '10285708',
                                                                                                                                          'fiber_length': 5446,
                                                                                                                                          'poller_hash': 'N0RBQjVDcGVlcnBvbjM2OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '11998926',
                                                                                                                                          'fiber_length': 5447,
                                                                                                                                          'poller_hash': 'N0UyRUVDcGVlcnBvbjM3MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '15320149',
                                                                                                                                          'fiber_length': 5224,
                                                                                                                                          'poller_hash': 'N0RBQjY1cGVlcnBvbjM3Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '6557489',
                                                                                                                                          'fiber_length': 4618,
                                                                                                                                          'poller_hash': 'N0UyRUQxcGVlcnBvbjM3My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '6232878',
                                                                                                                                          'fiber_length': 5078,
                                                                                                                                          'poller_hash': 'N0RBQjc5cGVlcnBvbjM3NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '15445361',
                                                                                                                                          'fiber_length': 4481,
                                                                                                                                          'poller_hash': 'N0RBQjc3cGVlcnBvbjM3NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '8740552',
                                                                                                                                          'fiber_length': 5004,
                                                                                                                                          'poller_hash': 'N0RBQjY4cGVlcnBvbjM3Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '6929047',
                                                                                                                                          'fiber_length': 4408,
                                                                                                                                          'poller_hash': 'N0RBQjZGcGVlcnBvbjM3Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '11234282',
                                                                                                                                          'fiber_length': 5202,
                                                                                                                                          'poller_hash': 'QUQxN0RFcGVlcnBvbjQ0MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '2330480',
                                                                                                                                          'fiber_length': 4896,
                                                                                                                                          'poller_hash': 'N0YzNDI2cGVlcnBvbjUxOS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '15445726',
                                                                                                                                          'fiber_length': 4856,
                                                                                                                                          'poller_hash': 'QUZGM0RCcGVlcnBvbjYwNi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '15445951',
                                                                                                                                          'fiber_length': 5262,
                                                                                                                                          'poller_hash': 'RTBFOEM1cGVlcnBvbjczNi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346},
                                                                                                                                  {       'connected_time': '1157159',
                                                                                                                                          'fiber_length': 4672,
                                                                                                                                          'poller_hash': 'MTA2OEJEOHBlZXJwb24xMDYyL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.629346}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/2/gp4',
                                                                                                                 'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010109',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '119507',
                                                                                         'in_octets': '2095028940790',
                                                                                         'in_ucast_pkts': '7438348963',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '739',
                                                                                                                  'in_octets': '7298109035',
                                                                                                                  'in_ucast_pkts': '64829128',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '525267',
                                                                                                                  'out_octets': '310058779880',
                                                                                                                  'out_ucast_pkts': '214303848',
                                                                                                                  'poller_hash': 'QTU1QzMxcGVlcmludGYzMzcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13024',
                                                                                                                  'in_octets': '123587328536',
                                                                                                                  'in_ucast_pkts': '401909388',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723326',
                                                                                                                  'out_octets': '1326934887425',
                                                                                                                  'out_ucast_pkts': '996402422',
                                                                                                                  'poller_hash': 'QTM0OUE5cGVlcmludGYzMzgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '9206',
                                                                                                                  'in_octets': '75505126977',
                                                                                                                  'in_ucast_pkts': '582643216',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '5451329',
                                                                                                                  'out_octets': '2326272762029',
                                                                                                                  'out_ucast_pkts': '1601380714',
                                                                                                                  'poller_hash': 'QTM0OUUwcGVlcmludGYzMzkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13135',
                                                                                                                  'in_octets': '512549282556',
                                                                                                                  'in_ucast_pkts': '1612167013',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723396',
                                                                                                                  'out_octets': '5459069457092',
                                                                                                                  'out_ucast_pkts': '4177504971',
                                                                                                                  'poller_hash': 'QTM2OTNDcGVlcmludGYzNDAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '3171',
                                                                                                                  'in_octets': '35153948927',
                                                                                                                  'in_ucast_pkts': '87905958',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1879420',
                                                                                                                  'out_octets': '334443765098',
                                                                                                                  'out_ucast_pkts': '237913128',
                                                                                                                  'poller_hash': 'QTM0OUZDcGVlcmludGYzNDEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '4963',
                                                                                                                  'in_octets': '15972796121',
                                                                                                                  'in_ucast_pkts': '87897834',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '2943935',
                                                                                                                  'out_octets': '260110885319',
                                                                                                                  'out_ucast_pkts': '196500630',
                                                                                                                  'poller_hash': 'QTM2OTEycGVlcmludGYzNDMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '11137',
                                                                                                                  'in_octets': '129400562917',
                                                                                                                  'in_ucast_pkts': '787804756',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '6611601',
                                                                                                                  'out_octets': '2488133015574',
                                                                                                                  'out_ucast_pkts': '1761262963',
                                                                                                                  'poller_hash': 'QTM0OUY0cGVlcmludGYzNDQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '12989',
                                                                                                                  'in_octets': '99163697940',
                                                                                                                  'in_ucast_pkts': '384149281',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723357',
                                                                                                                  'out_octets': '1365549039503',
                                                                                                                  'out_ucast_pkts': '1107384100',
                                                                                                                  'poller_hash': 'N0YzM0Q0cGVlcmludGYzNDUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '7998',
                                                                                                                  'in_octets': '68212885156',
                                                                                                                  'in_ucast_pkts': '197093146',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '4723588',
                                                                                                                  'out_octets': '558682073988',
                                                                                                                  'out_ucast_pkts': '458438304',
                                                                                                                  'poller_hash': 'QTM2OEM5cGVlcmludGYzNDYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '12990',
                                                                                                                  'in_octets': '311526107640',
                                                                                                                  'in_ucast_pkts': '1366393337',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723254',
                                                                                                                  'out_octets': '4816058702161',
                                                                                                                  'out_ucast_pkts': '3646757578',
                                                                                                                  'poller_hash': 'N0YzNDIxcGVlcmludGYzNDcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '12875',
                                                                                                                  'in_octets': '109189190425',
                                                                                                                  'in_ucast_pkts': '410881483',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723413',
                                                                                                                  'out_octets': '2134044198009',
                                                                                                                  'out_ucast_pkts': '1578899348',
                                                                                                                  'poller_hash': 'N0YzNDJFcGVlcmludGYzNDgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '194',
                                                                                                                  'in_octets': '12749231884',
                                                                                                                  'in_ucast_pkts': '16696693',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '103509',
                                                                                                                  'out_octets': '12910439586',
                                                                                                                  'out_ucast_pkts': '14596832',
                                                                                                                  'poller_hash': 'QjQ5RUJGcGVlcmludGYzNDkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13041',
                                                                                                                  'in_octets': '447681220457',
                                                                                                                  'in_ucast_pkts': '984239194',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723426',
                                                                                                                  'out_octets': '2599654002328',
                                                                                                                  'out_ucast_pkts': '2072962314',
                                                                                                                  'poller_hash': 'QTM0QTBEcGVlcmludGYzNTEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '10821',
                                                                                                                  'in_octets': '324056696966',
                                                                                                                  'in_ucast_pkts': '1891708268',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '6413966',
                                                                                                                  'out_octets': '6705627882392',
                                                                                                                  'out_ucast_pkts': '4771614462',
                                                                                                                  'poller_hash': 'QTU1QzU3cGVlcmludGYzNTIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '6735',
                                                                                                                  'in_octets': '23267700195',
                                                                                                                  'in_ucast_pkts': '79911018',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '3977575',
                                                                                                                  'out_octets': '350244933375',
                                                                                                                  'out_ucast_pkts': '271760425',
                                                                                                                  'poller_hash': 'QTM2OTAxcGVlcmludGY0MzQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13016',
                                                                                                                  'in_octets': '17223020800',
                                                                                                                  'in_ucast_pkts': '62050513',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723515',
                                                                                                                  'out_octets': '189715050069',
                                                                                                                  'out_ucast_pkts': '149162500',
                                                                                                                  'poller_hash': 'QjJEQUYxcGVlcmludGY0NjAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13050',
                                                                                                                  'in_octets': '6314073499',
                                                                                                                  'in_ucast_pkts': '17789233',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723758',
                                                                                                                  'out_octets': '33471526324',
                                                                                                                  'out_ucast_pkts': '31056330',
                                                                                                                  'poller_hash': 'Q0I2QkI3cGVlcmludGY2MzEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '7455',
                                                                                                                  'in_octets': '14821289800',
                                                                                                                  'in_ucast_pkts': '78523895',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '6272766',
                                                                                                                  'out_octets': '206541865762',
                                                                                                                  'out_ucast_pkts': '159299063',
                                                                                                                  'poller_hash': 'QjA2N0M2cGVlcmludGY2NjEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13018',
                                                                                                                  'in_octets': '67299425125',
                                                                                                                  'in_ucast_pkts': '361539732',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723676',
                                                                                                                  'out_octets': '3367385929857',
                                                                                                                  'out_ucast_pkts': '2343767960',
                                                                                                                  'poller_hash': 'QzUyMzlBcGVlcmludGY2ODgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '56',
                                                                                                                  'in_octets': '757737563',
                                                                                                                  'in_ucast_pkts': '5144384',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '24854',
                                                                                                                  'out_octets': '15133081848',
                                                                                                                  'out_ucast_pkts': '12482072',
                                                                                                                  'poller_hash': 'REUxM0IycGVlcmludGY3NDQvZ3Ax'}],
                                                                                         'mac_address': 'cc:be:59:dc:72:bd',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp5',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '24784565955042',
                                                                                         'out_ucast_pkts': '18354884420',
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmQxLzIvZ3A1',
                                                                                         'pons': [       {       'description': '1/2/gp5',
                                                                                                                 'id': '120010109',
                                                                                                                 'links': [       {       'connected_time': '1049070',
                                                                                                                                          'fiber_length': 4665,
                                                                                                                                          'poller_hash': 'QTU1QzMxcGVlcnBvbjMzNy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166},
                                                                                                                                  {       'connected_time': '15445150',
                                                                                                                                          'fiber_length': 4754,
                                                                                                                                          'poller_hash': 'QTM0OUE5cGVlcnBvbjMzOC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166},
                                                                                                                                  {       'connected_time': '10901195',
                                                                                                                                          'fiber_length': 4761,
                                                                                                                                          'poller_hash': 'QTM0OUUwcGVlcnBvbjMzOS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166},
                                                                                                                                  {       'connected_time': '15445315',
                                                                                                                                          'fiber_length': 4798,
                                                                                                                                          'poller_hash': 'QTM2OTNDcGVlcnBvbjM0MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166},
                                                                                                                                  {       'connected_time': '3757315',
                                                                                                                                          'fiber_length': 4818,
                                                                                                                                          'poller_hash': 'QTM0OUZDcGVlcnBvbjM0MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166},
                                                                                                                                  {       'connected_time': '5886339',
                                                                                                                                          'fiber_length': 5439,
                                                                                                                                          'poller_hash': 'QTM2OTEycGVlcnBvbjM0My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166},
                                                                                                                                  {       'connected_time': '13221795',
                                                                                                                                          'fiber_length': 4848,
                                                                                                                                          'poller_hash': 'QTM0OUY0cGVlcnBvbjM0NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166},
                                                                                                                                  {       'connected_time': '15445218',
                                                                                                                                          'fiber_length': 5038,
                                                                                                                                          'poller_hash': 'N0YzM0Q0cGVlcnBvbjM0NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166},
                                                                                                                                  {       'connected_time': '9448153',
                                                                                                                                          'fiber_length': 5404,
                                                                                                                                          'poller_hash': 'QTM2OEM5cGVlcnBvbjM0Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166},
                                                                                                                                  {       'connected_time': '15445257',
                                                                                                                                          'fiber_length': 4994,
                                                                                                                                          'poller_hash': 'N0YzNDIxcGVlcnBvbjM0Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166},
                                                                                                                                  {       'connected_time': '15445336',
                                                                                                                                          'fiber_length': 5139,
                                                                                                                                          'poller_hash': 'N0YzNDJFcGVlcnBvbjM0OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166},
                                                                                                                                  {       'connected_time': '205503',
                                                                                                                                          'fiber_length': 5480,
                                                                                                                                          'poller_hash': 'QjQ5RUJGcGVlcnBvbjM0OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166},
                                                                                                                                  {       'connected_time': '15445373',
                                                                                                                                          'fiber_length': 5831,
                                                                                                                                          'poller_hash': 'QTM0QTBEcGVlcnBvbjM1MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166},
                                                                                                                                  {       'connected_time': '12826488',
                                                                                                                                          'fiber_length': 5602,
                                                                                                                                          'poller_hash': 'QTU1QzU3cGVlcnBvbjM1Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166},
                                                                                                                                  {       'connected_time': '7953716',
                                                                                                                                          'fiber_length': 5480,
                                                                                                                                          'poller_hash': 'QTM2OTAxcGVlcnBvbjQzNC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166},
                                                                                                                                  {       'connected_time': '15445580',
                                                                                                                                          'fiber_length': 5329,
                                                                                                                                          'poller_hash': 'QjJEQUYxcGVlcnBvbjQ2MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166},
                                                                                                                                  {       'connected_time': '15446057',
                                                                                                                                          'fiber_length': 4866,
                                                                                                                                          'poller_hash': 'Q0I2QkI3cGVlcnBvbjYzMS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166},
                                                                                                                                  {       'connected_time': '12544047',
                                                                                                                                          'fiber_length': 5472,
                                                                                                                                          'poller_hash': 'QjA2N0M2cGVlcnBvbjY2MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166},
                                                                                                                                  {       'connected_time': '15445860',
                                                                                                                                          'fiber_length': 5463,
                                                                                                                                          'poller_hash': 'QzUyMzlBcGVlcnBvbjY4OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166},
                                                                                                                                  {       'connected_time': '48141',
                                                                                                                                          'fiber_length': 5734,
                                                                                                                                          'poller_hash': 'REUxM0IycGVlcnBvbjc0NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.742166}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/2/gp5',
                                                                                                                 'poller_hash': 'Y2NiZTU5ZGM3MmJkMTIwMDEwMTA5',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010110',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '85223',
                                                                                         'in_octets': '2363544475669',
                                                                                         'in_ucast_pkts': '8070034291',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '3288',
                                                                                                                  'in_octets': '887473069496',
                                                                                                                  'in_ucast_pkts': '1977609490',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1948577',
                                                                                                                  'out_octets': '4324449149282',
                                                                                                                  'out_ucast_pkts': '3574456160',
                                                                                                                  'poller_hash': 'QTM0OUYwcGVlcmludGYzNzgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '12940',
                                                                                                                  'in_octets': '72190794985',
                                                                                                                  'in_ucast_pkts': '143128064',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723482',
                                                                                                                  'out_octets': '442628608902',
                                                                                                                  'out_ucast_pkts': '358209919',
                                                                                                                  'poller_hash': 'QTU1QzAxcGVlcmludGYzNzkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13070',
                                                                                                                  'in_octets': '129622482716',
                                                                                                                  'in_ucast_pkts': '961931116',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723493',
                                                                                                                  'out_octets': '4295847259061',
                                                                                                                  'out_ucast_pkts': '3044256397',
                                                                                                                  'poller_hash': 'QUQxODIwcGVlcmludGY0MzMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '31333',
                                                                                                                  'in_octets': '280196310509',
                                                                                                                  'in_ucast_pkts': '1791431798',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '18582343',
                                                                                                                  'out_octets': '9076402434933',
                                                                                                                  'out_ucast_pkts': '6343090877',
                                                                                                                  'poller_hash': 'QzEzMDI5cGVlcmludGY0NjQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '5681',
                                                                                                                  'in_octets': '23037202011',
                                                                                                                  'in_ucast_pkts': '132592945',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '3366493',
                                                                                                                  'out_octets': '348208701229',
                                                                                                                  'out_ucast_pkts': '295545971',
                                                                                                                  'poller_hash': 'QjJEQjA5cGVlcmludGY0NzAvZ3Ax'},
                                                                                                          {       'in_errors': '1',
                                                                                                                  'in_nucast_pkts': '19061',
                                                                                                                  'in_octets': '139902604409',
                                                                                                                  'in_ucast_pkts': '717932496',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '9730761',
                                                                                                                  'out_octets': '8028459139591',
                                                                                                                  'out_ucast_pkts': '5415183628',
                                                                                                                  'poller_hash': 'QjJEQUZGcGVlcmludGY0NzkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '31414',
                                                                                                                  'in_octets': '299454566847',
                                                                                                                  'in_ucast_pkts': '1746162349',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '18582298',
                                                                                                                  'out_octets': '10709982438630',
                                                                                                                  'out_ucast_pkts': '7449221599',
                                                                                                                  'poller_hash': 'QjRFQzI2cGVlcmludGY0ODQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '49569',
                                                                                                                  'in_octets': '411196601622',
                                                                                                                  'in_ucast_pkts': '2337704418',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '23647498',
                                                                                                                  'out_octets': '6257336042658',
                                                                                                                  'out_ucast_pkts': '4676203614',
                                                                                                                  'poller_hash': 'QjRFQkVBcGVlcmludGY0OTYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '3067',
                                                                                                                  'in_octets': '54251764568',
                                                                                                                  'in_ucast_pkts': '379766122',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1815009',
                                                                                                                  'out_octets': '1397722402762',
                                                                                                                  'out_ucast_pkts': '986903996',
                                                                                                                  'poller_hash': 'Q0I2QjYzcGVlcmludGY2MDIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '23702',
                                                                                                                  'in_octets': '203102793481',
                                                                                                                  'in_ucast_pkts': '832469468',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '13664374',
                                                                                                                  'out_octets': '4760793796608',
                                                                                                                  'out_ucast_pkts': '3538644768',
                                                                                                                  'poller_hash': 'REMyN0JCcGVlcmludGY2NDgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '8412',
                                                                                                                  'in_octets': '20050215839',
                                                                                                                  'in_ucast_pkts': '97594971',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '4886659',
                                                                                                                  'out_octets': '156438521452',
                                                                                                                  'out_ucast_pkts': '158665744',
                                                                                                                  'poller_hash': 'QzUyMjg0cGVlcmludGY2NzQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '2927',
                                                                                                                  'in_octets': '23945624640',
                                                                                                                  'in_ucast_pkts': '210516569',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1441654',
                                                                                                                  'out_octets': '1117134773578',
                                                                                                                  'out_ucast_pkts': '765394236',
                                                                                                                  'poller_hash': 'QzUyMzk0cGVlcmludGY2NzUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '26104',
                                                                                                                  'in_octets': '215206395924',
                                                                                                                  'in_ucast_pkts': '702502197',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '11854035',
                                                                                                                  'out_octets': '3076573701105',
                                                                                                                  'out_ucast_pkts': '2329960783',
                                                                                                                  'poller_hash': 'QzUyMkQycGVlcmludGY2ODAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '7329',
                                                                                                                  'in_octets': '185772928402',
                                                                                                                  'in_ucast_pkts': '560018271',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '4329927',
                                                                                                                  'out_octets': '1997143575581',
                                                                                                                  'out_ucast_pkts': '1641958035',
                                                                                                                  'poller_hash': 'QzUyMjQ4cGVlcmludGY2ODcvZ3Ax'}],
                                                                                         'mac_address': 'cc:be:59:dc:72:be',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp6',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '28390777126943',
                                                                                         'out_ucast_pkts': '21163790898',
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmUxLzIvZ3A2',
                                                                                         'pons': [       {       'description': '1/2/gp6',
                                                                                                                 'id': '120010110',
                                                                                                                 'links': [       {       'connected_time': '3895683',
                                                                                                                                          'fiber_length': 4782,
                                                                                                                                          'poller_hash': 'QTM0OUYwcGVlcnBvbjM3OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.69902},
                                                                                                                                  {       'connected_time': '15445563',
                                                                                                                                          'fiber_length': 5895,
                                                                                                                                          'poller_hash': 'QTU1QzAxcGVlcnBvbjM3OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.69902},
                                                                                                                                  {       'connected_time': '15445592',
                                                                                                                                          'fiber_length': 5983,
                                                                                                                                          'poller_hash': 'QUQxODIwcGVlcnBvbjQzMy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.69902},
                                                                                                                                  {       'connected_time': '37163687',
                                                                                                                                          'fiber_length': 2409,
                                                                                                                                          'poller_hash': 'QzEzMDI5cGVlcnBvbjQ2NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.69902},
                                                                                                                                  {       'connected_time': '6731517',
                                                                                                                                          'fiber_length': 2357,
                                                                                                                                          'poller_hash': 'QjJEQjA5cGVlcnBvbjQ3MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.69902},
                                                                                                                                  {       'connected_time': '28458082',
                                                                                                                                          'fiber_length': 2667,
                                                                                                                                          'poller_hash': 'QjJEQUZGcGVlcnBvbjQ3OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.69902},
                                                                                                                                  {       'connected_time': '37163304',
                                                                                                                                          'fiber_length': 2322,
                                                                                                                                          'poller_hash': 'QjRFQzI2cGVlcnBvbjQ4NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.69902},
                                                                                                                                  {       'connected_time': '4344452',
                                                                                                                                          'fiber_length': 2502,
                                                                                                                                          'poller_hash': 'QjRFQkVBcGVlcnBvbjQ5Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.69902},
                                                                                                                                  {       'connected_time': '3628554',
                                                                                                                                          'fiber_length': 2736,
                                                                                                                                          'poller_hash': 'Q0I2QjYzcGVlcnBvbjYwMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.69902},
                                                                                                                                  {       'connected_time': '27329124',
                                                                                                                                          'fiber_length': 2730,
                                                                                                                                          'poller_hash': 'REMyN0JCcGVlcnBvbjY0OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.69902},
                                                                                                                                  {       'connected_time': '9771793',
                                                                                                                                          'fiber_length': 2805,
                                                                                                                                          'poller_hash': 'QzUyMjg0cGVlcnBvbjY3NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.69902},
                                                                                                                                  {       'connected_time': '2881765',
                                                                                                                                          'fiber_length': 2388,
                                                                                                                                          'poller_hash': 'QzUyMzk0cGVlcnBvbjY3NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.69902},
                                                                                                                                  {       'connected_time': '23708031',
                                                                                                                                          'fiber_length': 2412,
                                                                                                                                          'poller_hash': 'QzUyMkQycGVlcnBvbjY4MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.69902},
                                                                                                                                  {       'connected_time': '8658391',
                                                                                                                                          'fiber_length': 2530,
                                                                                                                                          'poller_hash': 'QzUyMjQ4cGVlcnBvbjY4Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.69902}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/2/gp6',
                                                                                                                 'poller_hash': 'Y2NiZTU5ZGM3MmJlMTIwMDEwMTEw',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010111',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '143705',
                                                                                         'in_octets': '2331100758948',
                                                                                         'in_ucast_pkts': '13643149262',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1509',
                                                                                                                  'in_octets': '12116148502',
                                                                                                                  'in_ucast_pkts': '26519213',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879782',
                                                                                                                  'out_octets': '96227368369',
                                                                                                                  'out_ucast_pkts': '77876467',
                                                                                                                  'poller_hash': 'QTM2OTQ3cGVlcmludGYzODAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1492',
                                                                                                                  'in_octets': '29918809750',
                                                                                                                  'in_ucast_pkts': '92828928',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879789',
                                                                                                                  'out_octets': '354051476100',
                                                                                                                  'out_ucast_pkts': '255120823',
                                                                                                                  'poller_hash': 'QjEyNDY2cGVlcmludGYzODIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1502',
                                                                                                                  'in_octets': '3675520894',
                                                                                                                  'in_ucast_pkts': '20462413',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879791',
                                                                                                                  'out_octets': '60760945918',
                                                                                                                  'out_ucast_pkts': '49315422',
                                                                                                                  'poller_hash': 'QjEyNDdDcGVlcmludGYzODMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1491',
                                                                                                                  'in_octets': '31745144119',
                                                                                                                  'in_ucast_pkts': '134313468',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879808',
                                                                                                                  'out_octets': '476451686171',
                                                                                                                  'out_ucast_pkts': '359334556',
                                                                                                                  'poller_hash': 'QUQxNjQ2cGVlcmludGY0MTcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '569906',
                                                                                                                  'in_octets': '53105572823',
                                                                                                                  'in_ucast_pkts': '509569434',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879825',
                                                                                                                  'out_octets': '1491793254399',
                                                                                                                  'out_ucast_pkts': '1030625280',
                                                                                                                  'poller_hash': 'QjREODA3cGVlcmludGY0MjAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1485',
                                                                                                                  'in_octets': '7308004005',
                                                                                                                  'in_ucast_pkts': '39190853',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879824',
                                                                                                                  'out_octets': '146881368388',
                                                                                                                  'out_ucast_pkts': '104411076',
                                                                                                                  'poller_hash': 'QjREODA4cGVlcmludGY0MjgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1487',
                                                                                                                  'in_octets': '914033315',
                                                                                                                  'in_ucast_pkts': '6510802',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879825',
                                                                                                                  'out_octets': '17564535742',
                                                                                                                  'out_ucast_pkts': '14111435',
                                                                                                                  'poller_hash': 'QjREN0VCcGVlcmludGY0MzAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1487',
                                                                                                                  'in_octets': '1063533482',
                                                                                                                  'in_ucast_pkts': '5326105',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879850',
                                                                                                                  'out_octets': '18528220635',
                                                                                                                  'out_ucast_pkts': '14883044',
                                                                                                                  'poller_hash': 'QzEyRDUwcGVlcmludGY0NzIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1501',
                                                                                                                  'in_octets': '11824554994',
                                                                                                                  'in_ucast_pkts': '95018689',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879832',
                                                                                                                  'out_octets': '265606491079',
                                                                                                                  'out_ucast_pkts': '185642757',
                                                                                                                  'poller_hash': 'QzEzMEEzcGVlcmludGY0NzMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1496',
                                                                                                                  'in_octets': '36647276546',
                                                                                                                  'in_ucast_pkts': '72169148',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879857',
                                                                                                                  'out_octets': '237082710201',
                                                                                                                  'out_ucast_pkts': '184877863',
                                                                                                                  'poller_hash': 'QzFEMjcxcGVlcmludGY0ODEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1500',
                                                                                                                  'in_octets': '1421790939',
                                                                                                                  'in_ucast_pkts': '7053322',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879874',
                                                                                                                  'out_octets': '6410158451',
                                                                                                                  'out_ucast_pkts': '6966096',
                                                                                                                  'poller_hash': 'QzFEMjY1cGVlcmludGY1MTYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1349',
                                                                                                                  'in_octets': '39111158447',
                                                                                                                  'in_ucast_pkts': '324479924',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '790177',
                                                                                                                  'out_octets': '1180176791163',
                                                                                                                  'out_ucast_pkts': '856702508',
                                                                                                                  'poller_hash': 'QzFCNzYwcGVlcmludGY1NDYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1489',
                                                                                                                  'in_octets': '32088574669',
                                                                                                                  'in_ucast_pkts': '205217088',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879885',
                                                                                                                  'out_octets': '1658787221733',
                                                                                                                  'out_ucast_pkts': '1129161403',
                                                                                                                  'poller_hash': 'QUZGMDc3cGVlcmludGY1NTYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1485',
                                                                                                                  'in_octets': '7005033540',
                                                                                                                  'in_ucast_pkts': '59696288',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879928',
                                                                                                                  'out_octets': '159286107820',
                                                                                                                  'out_ucast_pkts': '111761493',
                                                                                                                  'poller_hash': 'QjREN0VFcGVlcmludGY2MDUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1493',
                                                                                                                  'in_octets': '691396641',
                                                                                                                  'in_ucast_pkts': '4069002',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879926',
                                                                                                                  'out_octets': '26686600137',
                                                                                                                  'out_ucast_pkts': '20607012',
                                                                                                                  'poller_hash': 'REMyODU1cGVlcmludGY2MjAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1484',
                                                                                                                  'in_octets': '931650737',
                                                                                                                  'in_ucast_pkts': '8934747',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879939',
                                                                                                                  'out_octets': '45127971490',
                                                                                                                  'out_ucast_pkts': '30674861',
                                                                                                                  'poller_hash': 'Q0I2QkFDcGVlcmludGY2MjUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1496',
                                                                                                                  'in_octets': '63604682974',
                                                                                                                  'in_ucast_pkts': '387444759',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879981',
                                                                                                                  'out_octets': '1500857885851',
                                                                                                                  'out_ucast_pkts': '1063909106',
                                                                                                                  'poller_hash': 'QzUyMkFGcGVlcmludGY2NzMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1493',
                                                                                                                  'in_octets': '102089409982',
                                                                                                                  'in_ucast_pkts': '920139498',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879982',
                                                                                                                  'out_octets': '2751645662183',
                                                                                                                  'out_ucast_pkts': '1911614707',
                                                                                                                  'poller_hash': 'QzUyMkI1cGVlcmludGY2ODUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '468',
                                                                                                                  'in_octets': '3218349622',
                                                                                                                  'in_ucast_pkts': '11158986',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '273457',
                                                                                                                  'out_octets': '65618243736',
                                                                                                                  'out_ucast_pkts': '47933239',
                                                                                                                  'poller_hash': 'QzFCN0NGcGVlcmludGY2ODYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1397',
                                                                                                                  'in_octets': '3816167073',
                                                                                                                  'in_ucast_pkts': '18591513',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '821017',
                                                                                                                  'out_octets': '111274117388',
                                                                                                                  'out_ucast_pkts': '78053414',
                                                                                                                  'poller_hash': 'RTBFN0VBcGVlcmludGY3NTAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1492',
                                                                                                                  'in_octets': '540534054',
                                                                                                                  'in_ucast_pkts': '2715280',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '880020',
                                                                                                                  'out_octets': '9340308152',
                                                                                                                  'out_ucast_pkts': '7853791',
                                                                                                                  'poller_hash': 'MTA2OEI5Q3BlZXJpbnRmODAyL2dwMQ=='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1498',
                                                                                                                  'in_octets': '18893846272',
                                                                                                                  'in_ucast_pkts': '52982402',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '880040',
                                                                                                                  'out_octets': '303258418452',
                                                                                                                  'out_ucast_pkts': '218973170',
                                                                                                                  'poller_hash': 'MTA2OERGNXBlZXJpbnRmODgyL2dwMQ=='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1487',
                                                                                                                  'in_octets': '7485042289',
                                                                                                                  'in_ucast_pkts': '56236742',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '880027',
                                                                                                                  'out_octets': '373061031945',
                                                                                                                  'out_ucast_pkts': '259645648',
                                                                                                                  'poller_hash': 'MTA2OEZBRXBlZXJpbnRmOTMzL2dwMQ=='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1495',
                                                                                                                  'in_octets': '17651076847',
                                                                                                                  'in_ucast_pkts': '105371614',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '880037',
                                                                                                                  'out_octets': '397543832904',
                                                                                                                  'out_ucast_pkts': '283505927',
                                                                                                                  'poller_hash': 'MTA2OENBNnBlZXJpbnRmMTAzMi9ncDE='}],
                                                                                         'mac_address': 'cc:be:59:dc:72:bf',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp7',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '52587843664270',
                                                                                         'out_ucast_pkts': '37194227669',
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmYxLzIvZ3A3',
                                                                                         'pons': [       {       'description': '1/2/gp7',
                                                                                                                 'id': '120010111',
                                                                                                                 'links': [       {       'connected_time': '1758083',
                                                                                                                                          'fiber_length': 4116,
                                                                                                                                          'poller_hash': 'QTM2OTQ3cGVlcnBvbjM4MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758097',
                                                                                                                                          'fiber_length': 5425,
                                                                                                                                          'poller_hash': 'QjEyNDY2cGVlcnBvbjM4Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758098',
                                                                                                                                          'fiber_length': 5026,
                                                                                                                                          'poller_hash': 'QjEyNDdDcGVlcnBvbjM4My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758147',
                                                                                                                                          'fiber_length': 5082,
                                                                                                                                          'poller_hash': 'QUQxNjQ2cGVlcnBvbjQxNy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758180',
                                                                                                                                          'fiber_length': 4694,
                                                                                                                                          'poller_hash': 'QjREODA3cGVlcnBvbjQyMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758175',
                                                                                                                                          'fiber_length': 5361,
                                                                                                                                          'poller_hash': 'QjREODA4cGVlcnBvbjQyOC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758177',
                                                                                                                                          'fiber_length': 5663,
                                                                                                                                          'poller_hash': 'QjREN0VCcGVlcnBvbjQzMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758235',
                                                                                                                                          'fiber_length': 4458,
                                                                                                                                          'poller_hash': 'QzEyRDUwcGVlcnBvbjQ3Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758227',
                                                                                                                                          'fiber_length': 4465,
                                                                                                                                          'poller_hash': 'QzEzMEEzcGVlcnBvbjQ3My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758249',
                                                                                                                                          'fiber_length': 4311,
                                                                                                                                          'poller_hash': 'QzFEMjcxcGVlcnBvbjQ4MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758300',
                                                                                                                                          'fiber_length': 4629,
                                                                                                                                          'poller_hash': 'QzFEMjY1cGVlcnBvbjUxNi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1578909',
                                                                                                                                          'fiber_length': 4727,
                                                                                                                                          'poller_hash': 'QzFCNzYwcGVlcnBvbjU0Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758324',
                                                                                                                                          'fiber_length': 4399,
                                                                                                                                          'poller_hash': 'QUZGMDc3cGVlcnBvbjU1Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758386',
                                                                                                                                          'fiber_length': 4539,
                                                                                                                                          'poller_hash': 'QjREN0VFcGVlcnBvbjYwNS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758370',
                                                                                                                                          'fiber_length': 5301,
                                                                                                                                          'poller_hash': 'REMyODU1cGVlcnBvbjYyMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758392',
                                                                                                                                          'fiber_length': 4171,
                                                                                                                                          'poller_hash': 'Q0I2QkFDcGVlcnBvbjYyNS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758425',
                                                                                                                                          'fiber_length': 4928,
                                                                                                                                          'poller_hash': 'QzUyMkFGcGVlcnBvbjY3My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758422',
                                                                                                                                          'fiber_length': 4145,
                                                                                                                                          'poller_hash': 'QzUyMkI1cGVlcnBvbjY4NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '545364',
                                                                                                                                          'fiber_length': 4539,
                                                                                                                                          'poller_hash': 'QzFCN0NGcGVlcnBvbjY4Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1640468',
                                                                                                                                          'fiber_length': 5846,
                                                                                                                                          'poller_hash': 'RTBFN0VBcGVlcnBvbjc1MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758461',
                                                                                                                                          'fiber_length': 5993,
                                                                                                                                          'poller_hash': 'MTA2OEI5Q3BlZXJwb244MDIvZ3Ax',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758490',
                                                                                                                                          'fiber_length': 4483,
                                                                                                                                          'poller_hash': 'MTA2OERGNXBlZXJwb244ODIvZ3Ax',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758466',
                                                                                                                                          'fiber_length': 6103,
                                                                                                                                          'poller_hash': 'MTA2OEZBRXBlZXJwb245MzMvZ3Ax',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067},
                                                                                                                                  {       'connected_time': '1758488',
                                                                                                                                          'fiber_length': 4166,
                                                                                                                                          'poller_hash': 'MTA2OENBNnBlZXJwb24xMDMyL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.655067}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/2/gp7',
                                                                                                                 'poller_hash': 'Y2NiZTU5ZGM3MmJmMTIwMDEwMTEx',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010112',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '191369',
                                                                                         'in_octets': '4139844328829',
                                                                                         'in_ucast_pkts': '12767374039',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '623',
                                                                                                                  'in_octets': '8147120708',
                                                                                                                  'in_ucast_pkts': '29727052',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '361437',
                                                                                                                  'out_octets': '155263278300',
                                                                                                                  'out_ucast_pkts': '117583191',
                                                                                                                  'poller_hash': 'QTM2OEYzcGVlcmludGYzODEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '10053',
                                                                                                                  'in_octets': '54994238017',
                                                                                                                  'in_ucast_pkts': '83341728',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879789',
                                                                                                                  'out_octets': '396561843770',
                                                                                                                  'out_ucast_pkts': '299114439',
                                                                                                                  'poller_hash': 'QjQ5RUVFcGVlcmludGYzODQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13823',
                                                                                                                  'in_octets': '48968692953',
                                                                                                                  'in_ucast_pkts': '380679769',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '8145800',
                                                                                                                  'out_octets': '1444230624010',
                                                                                                                  'out_ucast_pkts': '1014296483',
                                                                                                                  'poller_hash': 'QjEyNEY0cGVlcmludGYzODUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '6437',
                                                                                                                  'in_octets': '200076813191',
                                                                                                                  'in_ucast_pkts': '1162874309',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '3811401',
                                                                                                                  'out_octets': '5938177204094',
                                                                                                                  'out_ucast_pkts': '4131439876',
                                                                                                                  'poller_hash': 'QjEyMzAzcGVlcmludGYzOTAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '4407',
                                                                                                                  'in_octets': '17542386541',
                                                                                                                  'in_ucast_pkts': '78857616',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1982465',
                                                                                                                  'out_octets': '415625263139',
                                                                                                                  'out_ucast_pkts': '319810959',
                                                                                                                  'poller_hash': 'QjEyNTEycGVlcmludGYzOTIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '51',
                                                                                                                  'in_octets': '186608731',
                                                                                                                  'in_ucast_pkts': '1370684',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '6363',
                                                                                                                  'out_octets': '3815339620',
                                                                                                                  'out_ucast_pkts': '2787341',
                                                                                                                  'poller_hash': 'QjEyNEYzcGVlcmludGY0MDUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '6433',
                                                                                                                  'in_octets': '134745769589',
                                                                                                                  'in_ucast_pkts': '349935860',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '3811434',
                                                                                                                  'out_octets': '1321134283345',
                                                                                                                  'out_ucast_pkts': '967935348',
                                                                                                                  'poller_hash': 'QUQwRjREcGVlcmludGY0MzIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1486',
                                                                                                                  'in_octets': '19334858863',
                                                                                                                  'in_ucast_pkts': '99361467',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879864',
                                                                                                                  'out_octets': '347409990026',
                                                                                                                  'out_ucast_pkts': '261938860',
                                                                                                                  'poller_hash': 'QjQ5QzQxcGVlcmludGY0OTMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '24301',
                                                                                                                  'in_octets': '513606548163',
                                                                                                                  'in_ucast_pkts': '3462815307',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '14379468',
                                                                                                                  'out_octets': '13587835971465',
                                                                                                                  'out_ucast_pkts': '9317360454',
                                                                                                                  'poller_hash': 'QzFEMUEzcGVlcmludGY0OTUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '24394',
                                                                                                                  'in_octets': '539396397269',
                                                                                                                  'in_ucast_pkts': '3598382276',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '14381334',
                                                                                                                  'out_octets': '11728398516888',
                                                                                                                  'out_ucast_pkts': '8171110574',
                                                                                                                  'poller_hash': 'QzI3NjBGcGVlcmludGY1MDAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '24853',
                                                                                                                  'in_octets': '302079215986',
                                                                                                                  'in_ucast_pkts': '1550253374',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '14381315',
                                                                                                                  'out_octets': '7040609062488',
                                                                                                                  'out_ucast_pkts': '5131985877',
                                                                                                                  'poller_hash': 'QzFEMjk2cGVlcmludGY1MDUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '5105',
                                                                                                                  'in_octets': '58311563762',
                                                                                                                  'in_ucast_pkts': '400367759',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '7723479',
                                                                                                                  'out_octets': '1666137717598',
                                                                                                                  'out_ucast_pkts': '1159395107',
                                                                                                                  'poller_hash': 'QzI3Njc0cGVlcmludGY1MDYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '7630',
                                                                                                                  'in_octets': '282767660082',
                                                                                                                  'in_ucast_pkts': '432037873',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '4507521',
                                                                                                                  'out_octets': '753879615999',
                                                                                                                  'out_ucast_pkts': '650908821',
                                                                                                                  'poller_hash': 'QUZGMzQwcGVlcmludGY1NDMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1494',
                                                                                                                  'in_octets': '545650152',
                                                                                                                  'in_ucast_pkts': '2646610',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879904',
                                                                                                                  'out_octets': '6636732737',
                                                                                                                  'out_ucast_pkts': '5574799',
                                                                                                                  'poller_hash': 'Q0I2QjMwcGVlcmludGY1NzkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1489',
                                                                                                                  'in_octets': '19858154660',
                                                                                                                  'in_ucast_pkts': '132196751',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879883',
                                                                                                                  'out_octets': '407770761009',
                                                                                                                  'out_ucast_pkts': '291240621',
                                                                                                                  'poller_hash': 'REMyNkVFcGVlcmludGY1ODQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '2866',
                                                                                                                  'in_octets': '58726638445',
                                                                                                                  'in_ucast_pkts': '124159031',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1694388',
                                                                                                                  'out_octets': '544034372603',
                                                                                                                  'out_ucast_pkts': '399547281',
                                                                                                                  'poller_hash': 'QzFCN0M0cGVlcmludGY1OTgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1488',
                                                                                                                  'in_octets': '10221547647',
                                                                                                                  'in_ucast_pkts': '56984616',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879932',
                                                                                                                  'out_octets': '182045876605',
                                                                                                                  'out_ucast_pkts': '136029254',
                                                                                                                  'poller_hash': 'Q0I2QjdCcGVlcmludGY2MjQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '11584',
                                                                                                                  'in_octets': '1253253142838',
                                                                                                                  'in_ucast_pkts': '1574147759',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '6876673',
                                                                                                                  'out_octets': '2498560024937',
                                                                                                                  'out_ucast_pkts': '2084064778',
                                                                                                                  'poller_hash': 'REMyNzZEcGVlcmludGY2MjYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '10611',
                                                                                                                  'in_octets': '591483739030',
                                                                                                                  'in_ucast_pkts': '1402974329',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '6300615',
                                                                                                                  'out_octets': '5854546960209',
                                                                                                                  'out_ucast_pkts': '4381440518',
                                                                                                                  'poller_hash': 'REMyNzU1cGVlcmludGY2MjcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '11238',
                                                                                                                  'in_octets': '1113640072924',
                                                                                                                  'in_ucast_pkts': '1518005751',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '11414461',
                                                                                                                  'out_octets': '5855343284964',
                                                                                                                  'out_ucast_pkts': '4604008310',
                                                                                                                  'poller_hash': 'Q0I2QUVEcGVlcmludGY2MzQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1491',
                                                                                                                  'in_octets': '7154739140',
                                                                                                                  'in_ucast_pkts': '51962122',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879964',
                                                                                                                  'out_octets': '170509745568',
                                                                                                                  'out_ucast_pkts': '125176352',
                                                                                                                  'poller_hash': 'REMyQzVFcGVlcmludGY2NTQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1487',
                                                                                                                  'in_octets': '182459002798',
                                                                                                                  'in_ucast_pkts': '366604544',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '879972',
                                                                                                                  'out_octets': '1197155991560',
                                                                                                                  'out_ucast_pkts': '981398113',
                                                                                                                  'poller_hash': 'REFEMjBDcGVlcmludGY2NTYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '9364',
                                                                                                                  'in_octets': '283817689958',
                                                                                                                  'in_ucast_pkts': '993462220',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '5368493',
                                                                                                                  'out_octets': '3587989500799',
                                                                                                                  'out_ucast_pkts': '2591132829',
                                                                                                                  'poller_hash': 'QUZGMzlDcGVlcmludGY3ODYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1491',
                                                                                                                  'in_octets': '10432437050',
                                                                                                                  'in_ucast_pkts': '77990895',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '880012',
                                                                                                                  'out_octets': '225437355388',
                                                                                                                  'out_ucast_pkts': '167589382',
                                                                                                                  'poller_hash': 'MTA2OEI4RHBlZXJpbnRmODAxL2dwMQ=='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1488',
                                                                                                                  'in_octets': '6043947715',
                                                                                                                  'in_ucast_pkts': '43366669',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '880036',
                                                                                                                  'out_octets': '158171461198',
                                                                                                                  'out_ucast_pkts': '118743668',
                                                                                                                  'poller_hash': 'MTA2OEI4RXBlZXJpbnRmODA3L2dwMQ=='}],
                                                                                         'mac_address': 'cc:be:59:dc:72:c0',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp8',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '47502034680092',
                                                                                         'out_ucast_pkts': '34966125026',
                                                                                         'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YzAxLzIvZ3A4',
                                                                                         'pons': [       {       'description': '1/2/gp8',
                                                                                                                 'id': '120010112',
                                                                                                                 'links': [       {       'connected_time': '721389',
                                                                                                                                          'fiber_length': 6217,
                                                                                                                                          'poller_hash': 'QTM2OEYzcGVlcnBvbjM4MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '1758101',
                                                                                                                                          'fiber_length': 3595,
                                                                                                                                          'poller_hash': 'QjQ5RUVFcGVlcnBvbjM4NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '16290187',
                                                                                                                                          'fiber_length': 2999,
                                                                                                                                          'poller_hash': 'QjEyNEY0cGVlcnBvbjM4NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -28.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '7621336',
                                                                                                                                          'fiber_length': 3130,
                                                                                                                                          'poller_hash': 'QjEyMzAzcGVlcnBvbjM5MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -27.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '5975885',
                                                                                                                                          'fiber_length': 3068,
                                                                                                                                          'poller_hash': 'QjEyNTEycGVlcnBvbjM5Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '11254',
                                                                                                                                          'fiber_length': 6205,
                                                                                                                                          'poller_hash': 'QjEyNEYzcGVlcnBvbjQwNS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '7621413',
                                                                                                                                          'fiber_length': 3750,
                                                                                                                                          'poller_hash': 'QUQwRjREcGVlcnBvbjQzMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '1758268',
                                                                                                                                          'fiber_length': 3880,
                                                                                                                                          'poller_hash': 'QjQ5QzQxcGVlcnBvbjQ5My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '28761587',
                                                                                                                                          'fiber_length': 2968,
                                                                                                                                          'poller_hash': 'QzFEMUEzcGVlcnBvbjQ5NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '28761389',
                                                                                                                                          'fiber_length': 3153,
                                                                                                                                          'poller_hash': 'QzI3NjBGcGVlcnBvbjUwMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -25.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '28761381',
                                                                                                                                          'fiber_length': 3193,
                                                                                                                                          'poller_hash': 'QzFEMjk2cGVlcnBvbjUwNS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '15445590',
                                                                                                                                          'fiber_length': 3622,
                                                                                                                                          'poller_hash': 'QzI3Njc0cGVlcnBvbjUwNi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '9013611',
                                                                                                                                          'fiber_length': 2916,
                                                                                                                                          'poller_hash': 'QUZGMzQwcGVlcnBvbjU0My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -25.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '1758358',
                                                                                                                                          'fiber_length': 3810,
                                                                                                                                          'poller_hash': 'Q0I2QjMwcGVlcnBvbjU3OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '1758324',
                                                                                                                                          'fiber_length': 6171,
                                                                                                                                          'poller_hash': 'REMyNkVFcGVlcnBvbjU4NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '3387346',
                                                                                                                                          'fiber_length': 3057,
                                                                                                                                          'poller_hash': 'QzFCN0M0cGVlcnBvbjU5OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '1758381',
                                                                                                                                          'fiber_length': 3815,
                                                                                                                                          'poller_hash': 'Q0I2QjdCcGVlcnBvbjYyNC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '13751954',
                                                                                                                                          'fiber_length': 3713,
                                                                                                                                          'poller_hash': 'REMyNzZEcGVlcnBvbjYyNi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '12599781',
                                                                                                                                          'fiber_length': 3638,
                                                                                                                                          'poller_hash': 'REMyNzU1cGVlcnBvbjYyNy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '22827493',
                                                                                                                                          'fiber_length': 2969,
                                                                                                                                          'poller_hash': 'Q0I2QUVEcGVlcnBvbjYzNC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -26.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '1758407',
                                                                                                                                          'fiber_length': 3718,
                                                                                                                                          'poller_hash': 'REMyQzVFcGVlcnBvbjY1NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '1758417',
                                                                                                                                          'fiber_length': 3754,
                                                                                                                                          'poller_hash': 'REFEMjBDcGVlcnBvbjY1Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '10735472',
                                                                                                                                          'fiber_length': 3594,
                                                                                                                                          'poller_hash': 'QUZGMzlDcGVlcnBvbjc4Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -25.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '1758456',
                                                                                                                                          'fiber_length': 3784,
                                                                                                                                          'poller_hash': 'MTA2OEI4RHBlZXJwb244MDEvZ3Ax',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509},
                                                                                                                                  {       'connected_time': '1758487',
                                                                                                                                          'fiber_length': 3603,
                                                                                                                                          'poller_hash': 'MTA2OEI4RXBlZXJwb244MDcvZ3Ax',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.595509}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/2/gp8',
                                                                                                                 'poller_hash': 'Y2NiZTU5ZGM3MmMwMTIwMDEwMTEy',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'Calix',
                                                           'mem': 44.0,
                                                           'model': 'GPON-8 r2',
                                                           'name': '1/2',
                                                           'poller_hash': 'MjExODA3NjAzNjk5',
                                                           'serial_number': '211807603699',
                                                           'sw_version': '21.3.0',
                                                           'temperature': 26.4,
                                                           'uptime': '7620060'}],
                                'serial_number': '071707983043',
                                'sw_version': '21.3.0',
                                'system_mac_address': '00:02:5d:de:69:95'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'c4:ad:34:fb:0d:27'],
                                                                       'id': '1000065',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '82',
                                                                       'in_octets': '63018558933',
                                                                       'in_ucast_pkts': '127260727',
                                                                       'mac_address': 'cc:be:59:ae:4c:1e',
                                                                       'mtu': 2000,
                                                                       'name': '28/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '328274977866',
                                                                       'out_ucast_pkts': '300678159',
                                                                       'poller_hash': 'NTAxOUI1cGVlcmludGYyOC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '28',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '328274977866',
                                                                       'in_ucast_pkts': '300678159',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '328274977866',
                                                                                                'in_ucast_pkts': '300678159',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '82',
                                                                                                'out_octets': '63018558933',
                                                                                                'out_ucast_pkts': '127260727',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YjkxLzIvZ3Ax'}],
                                                                       'name': '28/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '82',
                                                                       'out_octets': '63018558933',
                                                                       'out_ucast_pkts': '127260727',
                                                                       'poller_hash': 'NTAxOUI1cGVlcmludGYyOC9ncDE=',
                                                                       'pons': [       {       'description': '28/gp1',
                                                                                               'id': '28',
                                                                                               'links': [       {       'connected_time': '5368012',
                                                                                                                        'fiber_length': 471,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmI5MTIwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.64,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.294}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '28/gp1',
                                                                                               'poller_hash': 'NTAxOUI1cGVlcnBvbjI4L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '801Gv2',
                                         'name': 'ont 28',
                                         'poller_hash': 'NTAxOUI1',
                                         'serial_number': '5019B5',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '1.0.5.0.120',
                                         'system_mac_address': 'cc:be:59:ae:4c:1e',
                                         'uptime': '5368012'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e0:63:da:23:d9:d2'],
                                                                       'id': '1000129',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '20',
                                                                       'in_octets': '135591327565',
                                                                       'in_ucast_pkts': '221701563',
                                                                       'mac_address': 'cc:be:59:ae:4c:3a',
                                                                       'mtu': 2000,
                                                                       'name': '31/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '350629106778',
                                                                       'out_ucast_pkts': '344895224',
                                                                       'poller_hash': 'NTAxOUMzcGVlcmludGYzMS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '31',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '350629106778',
                                                                       'in_ucast_pkts': '344895224',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '350629106778',
                                                                                                'in_ucast_pkts': '344895224',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '20',
                                                                                                'out_octets': '135591327565',
                                                                                                'out_ucast_pkts': '221701563',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YjkxLzIvZ3Ax'}],
                                                                       'name': '31/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '20',
                                                                       'out_octets': '135591327565',
                                                                       'out_ucast_pkts': '221701563',
                                                                       'poller_hash': 'NTAxOUMzcGVlcmludGYzMS9ncDE=',
                                                                       'pons': [       {       'description': '31/gp1',
                                                                                               'id': '31',
                                                                                               'links': [       {       'connected_time': '5725059',
                                                                                                                        'fiber_length': 475,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmI5MTIwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -7.128,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.558}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '31/gp1',
                                                                                               'poller_hash': 'NTAxOUMzcGVlcnBvbjMxL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '801Gv2',
                                         'name': 'ont 31',
                                         'poller_hash': 'NTAxOUMz',
                                         'serial_number': '5019C3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '1.0.5.0.120',
                                         'system_mac_address': 'cc:be:59:ae:4c:3a',
                                         'uptime': '5725059'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e4:8d:8c:a3:b2:be'],
                                                                       'id': '1001857',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '16272993',
                                                                       'in_octets': '844356100650',
                                                                       'in_ucast_pkts': '2093399260',
                                                                       'mac_address': '60:db:98:24:c6:1d',
                                                                       'mtu': 2000,
                                                                       'name': '130/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '24339243',
                                                                       'out_octets': '4298730039980',
                                                                       'out_ucast_pkts': '3543311930',
                                                                       'poller_hash': 'QTM0OTQ2cGVlcmludGYxMzAvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '130',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '24339243',
                                                                       'in_octets': '4298730039980',
                                                                       'in_ucast_pkts': '3543311930',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '24339243',
                                                                                                'in_octets': '4298730039980',
                                                                                                'in_ucast_pkts': '3543311930',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '16272993',
                                                                                                'out_octets': '844356100650',
                                                                                                'out_ucast_pkts': '2093399260',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YjkxLzIvZ3Ax'}],
                                                                       'name': '130/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '16272993',
                                                                       'out_octets': '844356100650',
                                                                       'out_ucast_pkts': '2093399260',
                                                                       'poller_hash': 'QTM0OTQ2cGVlcmludGYxMzAvZ3Ax',
                                                                       'pons': [       {       'description': '130/gp1',
                                                                                               'id': '130',
                                                                                               'links': [       {       'connected_time': '5727419',
                                                                                                                        'fiber_length': 1077,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmI5MTIwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '130/gp1',
                                                                                               'poller_hash': 'QTM0OTQ2cGVlcnBvbjEzMC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 130',
                                         'poller_hash': 'QTM0OTQ2',
                                         'serial_number': 'A34946',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:24:c6:1d',
                                         'uptime': '5727419'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e6:7e:9b'],
                                                                       'id': '1005025',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13015',
                                                                       'in_octets': '84229277945',
                                                                       'in_ucast_pkts': '409199665',
                                                                       'mac_address': '60:db:98:45:8b:83',
                                                                       'mtu': 2000,
                                                                       'name': '318/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723314',
                                                                       'out_octets': '2499565148593',
                                                                       'out_ucast_pkts': '1810329632',
                                                                       'poller_hash': 'QThCNDY5cGVlcmludGYzMTgvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '318',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723314',
                                                                       'in_octets': '2499565148593',
                                                                       'in_ucast_pkts': '1810329632',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723314',
                                                                                                'in_octets': '2499565148593',
                                                                                                'in_ucast_pkts': '1810329632',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13015',
                                                                                                'out_octets': '84229277945',
                                                                                                'out_ucast_pkts': '409199665',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '318/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13015',
                                                                       'out_octets': '84229277945',
                                                                       'out_ucast_pkts': '409199665',
                                                                       'poller_hash': 'QThCNDY5cGVlcmludGYzMTgvZ3Ax',
                                                                       'pons': [       {       'description': '318/gp1',
                                                                                               'id': '318',
                                                                                               'links': [       {       'connected_time': '15445184',
                                                                                                                        'fiber_length': 4899,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '318/gp1',
                                                                                               'poller_hash': 'QThCNDY5cGVlcnBvbjMxOC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 318',
                                         'poller_hash': 'QThCNDY5',
                                         'serial_number': 'A8B469',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:45:8b:83',
                                         'uptime': '15445184'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e2:df:08'],
                                                                       'id': '1002977',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '22',
                                                                       'in_octets': '253023859',
                                                                       'in_ucast_pkts': '1300146',
                                                                       'mac_address': '60:db:98:30:ef:5c',
                                                                       'mtu': 2000,
                                                                       'name': '322/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '9826',
                                                                       'out_octets': '8253119064',
                                                                       'out_ucast_pkts': '8078648',
                                                                       'poller_hash': 'QTU1QzREcGVlcmludGYzMjIvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '322',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '9826',
                                                                       'in_octets': '8253119064',
                                                                       'in_ucast_pkts': '8078648',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '9826',
                                                                                                'in_octets': '8253119064',
                                                                                                'in_ucast_pkts': '8078648',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '22',
                                                                                                'out_octets': '253023859',
                                                                                                'out_ucast_pkts': '1300146',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmExLzIvZ3Ay'}],
                                                                       'name': '322/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '22',
                                                                       'out_octets': '253023859',
                                                                       'out_ucast_pkts': '1300146',
                                                                       'poller_hash': 'QTU1QzREcGVlcmludGYzMjIvZ3Ax',
                                                                       'pons': [       {       'description': '322/gp1',
                                                                                               'id': '322',
                                                                                               'links': [       {       'connected_time': '18141',
                                                                                                                        'fiber_length': 3274,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJhMTIwMDEwMTA2',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '322/gp1',
                                                                                               'poller_hash': 'QTU1QzREcGVlcnBvbjMyMi9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 322',
                                         'poller_hash': 'QTU1QzRE',
                                         'serial_number': 'A55C4D',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:30:ef:5c',
                                         'uptime': '18141'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003041',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '223105',
                                                                       'in_octets': '633025332',
                                                                       'in_ucast_pkts': '6794442',
                                                                       'mac_address': '48:77:46:d2:63:d0',
                                                                       'mtu': 2000,
                                                                       'name': '324/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '6331861',
                                                                       'out_octets': '680088855',
                                                                       'out_ucast_pkts': '2968971',
                                                                       'poller_hash': 'N0RBQjZEcGVlcmludGYzMjQvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '324',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6331861',
                                                                       'in_octets': '680088855',
                                                                       'in_ucast_pkts': '2968971',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '6331861',
                                                                                                'in_octets': '680088855',
                                                                                                'in_ucast_pkts': '2968971',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '223105',
                                                                                                'out_octets': '633025332',
                                                                                                'out_ucast_pkts': '6794442',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmIxLzIvZ3Az'}],
                                                                       'name': '324/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '223105',
                                                                       'out_octets': '633025332',
                                                                       'out_ucast_pkts': '6794442',
                                                                       'poller_hash': 'N0RBQjZEcGVlcmludGYzMjQvZ3Ax',
                                                                       'pons': [       {       'description': '324/gp1',
                                                                                               'id': '324',
                                                                                               'links': [       {       'connected_time': '15445270',
                                                                                                                        'fiber_length': 4803,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJiMTIwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '324/gp1',
                                                                                               'poller_hash': 'N0RBQjZEcGVlcnBvbjMyNC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 324',
                                         'poller_hash': 'N0RBQjZE',
                                         'serial_number': '7DAB6D',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d2:63:d0',
                                         'uptime': '15445270'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e6:7f:14'],
                                                                       'id': '1003073',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4829',
                                                                       'in_octets': '101115263621',
                                                                       'in_ucast_pkts': '433594890',
                                                                       'mac_address': '60:db:98:24:c8:2a',
                                                                       'mtu': 2000,
                                                                       'name': '325/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2689788',
                                                                       'out_octets': '3159972141320',
                                                                       'out_ucast_pkts': '2185856535',
                                                                       'poller_hash': 'QTM0OUY1cGVlcmludGYzMjUvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '325',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2689788',
                                                                       'in_octets': '3159972141320',
                                                                       'in_ucast_pkts': '2185856535',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '2689788',
                                                                                                'in_octets': '3159972141320',
                                                                                                'in_ucast_pkts': '2185856535',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '4829',
                                                                                                'out_octets': '101115263621',
                                                                                                'out_ucast_pkts': '433594890',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmExLzIvZ3Ay'}],
                                                                       'name': '325/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4829',
                                                                       'out_octets': '101115263621',
                                                                       'out_ucast_pkts': '433594890',
                                                                       'poller_hash': 'QTM0OUY1cGVlcmludGYzMjUvZ3Ax',
                                                                       'pons': [       {       'description': '325/gp1',
                                                                                               'id': '325',
                                                                                               'links': [       {       'connected_time': '5378061',
                                                                                                                        'fiber_length': 2966,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJhMTIwMDEwMTA2',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '325/gp1',
                                                                                               'poller_hash': 'QTM0OUY1cGVlcnBvbjMyNS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 325',
                                         'poller_hash': 'QTM0OUY1',
                                         'serial_number': 'A349F5',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:24:c8:2a',
                                         'uptime': '5378061'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:42:0a:f5'],
                                                                       'id': '1003105',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13008',
                                                                       'in_octets': '138288318783',
                                                                       'in_ucast_pkts': '360482796',
                                                                       'mac_address': '48:77:46:d2:63:e5',
                                                                       'mtu': 2000,
                                                                       'name': '326/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723288',
                                                                       'out_octets': '1338279325311',
                                                                       'out_ucast_pkts': '1014582011',
                                                                       'poller_hash': 'N0RBQjc0cGVlcmludGYzMjYvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '326',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723288',
                                                                       'in_octets': '1338279325311',
                                                                       'in_ucast_pkts': '1014582011',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723288',
                                                                                                'in_octets': '1338279325311',
                                                                                                'in_ucast_pkts': '1014582011',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13008',
                                                                                                'out_octets': '138288318783',
                                                                                                'out_ucast_pkts': '360482796',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmIxLzIvZ3Az'}],
                                                                       'name': '326/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13008',
                                                                       'out_octets': '138288318783',
                                                                       'out_ucast_pkts': '360482796',
                                                                       'poller_hash': 'N0RBQjc0cGVlcmludGYzMjYvZ3Ax',
                                                                       'pons': [       {       'description': '326/gp1',
                                                                                               'id': '326',
                                                                                               'links': [       {       'connected_time': '15445071',
                                                                                                                        'fiber_length': 3329,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJiMTIwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '326/gp1',
                                                                                               'poller_hash': 'N0RBQjc0cGVlcnBvbjMyNi9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 326',
                                         'poller_hash': 'N0RBQjc0',
                                         'serial_number': '7DAB74',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d2:63:e5',
                                         'uptime': '15445071'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:77:46:9a:c2:8b'],
                                                                       'id': '1003137',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '65807',
                                                                       'in_octets': '165806616154',
                                                                       'in_ucast_pkts': '5031447623',
                                                                       'mac_address': 'cc:be:59:ae:4c:40',
                                                                       'mtu': 2000,
                                                                       'name': '327/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '256',
                                                                       'out_octets': '2760545906016',
                                                                       'out_ucast_pkts': '6338208405',
                                                                       'poller_hash': 'NTAxOUM2cGVlcmludGYzMjcvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '327',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '256',
                                                                       'in_octets': '2760545906016',
                                                                       'in_ucast_pkts': '6338208405',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '256',
                                                                                                'in_octets': '2760545906016',
                                                                                                'in_ucast_pkts': '6338208405',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '65807',
                                                                                                'out_octets': '165806616154',
                                                                                                'out_ucast_pkts': '5031447623',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmIxLzIvZ3Az'}],
                                                                       'name': '327/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '65807',
                                                                       'out_octets': '165806616154',
                                                                       'out_ucast_pkts': '5031447623',
                                                                       'poller_hash': 'NTAxOUM2cGVlcmludGYzMjcvZ3Ax',
                                                                       'pons': [       {       'description': '327/gp1',
                                                                                               'id': '327',
                                                                                               'links': [       {       'connected_time': '7624794',
                                                                                                                        'fiber_length': 3218,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJiMTIwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.932,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.178}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '327/gp1',
                                                                                               'poller_hash': 'NTAxOUM2cGVlcnBvbjMyNy9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '801Gv2',
                                         'name': 'ont 327',
                                         'poller_hash': 'NTAxOUM2',
                                         'serial_number': '5019C6',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '1.0.5.0.120',
                                         'system_mac_address': 'cc:be:59:ae:4c:40',
                                         'uptime': '7624794'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:05:d2:08'],
                                                                       'id': '1003169',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1752059',
                                                                       'in_octets': '27182637189',
                                                                       'in_ucast_pkts': '142645595',
                                                                       'mac_address': 'cc:be:59:ae:4c:22',
                                                                       'mtu': 2000,
                                                                       'name': '328/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '777994933510',
                                                                       'out_ucast_pkts': '571799307',
                                                                       'poller_hash': 'NTAxOUI3cGVlcmludGYzMjgvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '328',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '777994933510',
                                                                       'in_ucast_pkts': '571799307',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '777994933510',
                                                                                                'in_ucast_pkts': '571799307',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '1752059',
                                                                                                'out_octets': '27182637189',
                                                                                                'out_ucast_pkts': '142645595',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmExLzIvZ3Ay'}],
                                                                       'name': '328/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1752059',
                                                                       'out_octets': '27182637189',
                                                                       'out_ucast_pkts': '142645595',
                                                                       'poller_hash': 'NTAxOUI3cGVlcmludGYzMjgvZ3Ax',
                                                                       'pons': [       {       'description': '328/gp1',
                                                                                               'id': '328',
                                                                                               'links': [       {       'connected_time': '9885581',
                                                                                                                        'fiber_length': 2393,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJhMTIwMDEwMTA2',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.554,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.508}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '328/gp1',
                                                                                               'poller_hash': 'NTAxOUI3cGVlcnBvbjMyOC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '801Gv2',
                                         'name': 'ont 328',
                                         'poller_hash': 'NTAxOUI3',
                                         'serial_number': '5019B7',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '1.0.5.0.120',
                                         'system_mac_address': 'cc:be:59:ae:4c:22',
                                         'uptime': '9885581'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f8:85:f9:b3:8c:a9'],
                                                                       'id': '1003201',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '206',
                                                                       'in_octets': '89409498295',
                                                                       'in_ucast_pkts': '621647017',
                                                                       'mac_address': 'cc:be:59:ae:4b:bc',
                                                                       'mtu': 2000,
                                                                       'name': '329/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2231565065303',
                                                                       'out_ucast_pkts': '1559842552',
                                                                       'poller_hash': 'NTAxOTg0cGVlcmludGYzMjkvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '329',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '2231565065303',
                                                                       'in_ucast_pkts': '1559842552',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '2231565065303',
                                                                                                'in_ucast_pkts': '1559842552',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '206',
                                                                                                'out_octets': '89409498295',
                                                                                                'out_ucast_pkts': '621647017',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmIxLzIvZ3Az'}],
                                                                       'name': '329/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '206',
                                                                       'out_octets': '89409498295',
                                                                       'out_ucast_pkts': '621647017',
                                                                       'poller_hash': 'NTAxOTg0cGVlcmludGYzMjkvZ3Ax',
                                                                       'pons': [       {       'description': '329/gp1',
                                                                                               'id': '329',
                                                                                               'links': [       {       'connected_time': '8559598',
                                                                                                                        'fiber_length': 3417,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJiMTIwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.074,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.276}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '329/gp1',
                                                                                               'poller_hash': 'NTAxOTg0cGVlcnBvbjMyOS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '801Gv2',
                                         'name': 'ont 329',
                                         'poller_hash': 'NTAxOTg0',
                                         'serial_number': '501984',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '1.0.5.0.120',
                                         'system_mac_address': 'cc:be:59:ae:4b:bc',
                                         'uptime': '8559598'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:8d:58:f3'],
                                                                       'id': '1003265',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13052',
                                                                       'in_octets': '113228643288',
                                                                       'in_ucast_pkts': '300979064',
                                                                       'mac_address': '60:db:98:24:c7:79',
                                                                       'mtu': 2000,
                                                                       'name': '331/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723208',
                                                                       'out_octets': '968400707052',
                                                                       'out_ucast_pkts': '774329833',
                                                                       'poller_hash': 'QTM0OUJBcGVlcmludGYzMzEvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '331',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723208',
                                                                       'in_octets': '968400707052',
                                                                       'in_ucast_pkts': '774329833',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723208',
                                                                                                'in_octets': '968400707052',
                                                                                                'in_ucast_pkts': '774329833',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13052',
                                                                                                'out_octets': '113228643288',
                                                                                                'out_ucast_pkts': '300979064',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmIxLzIvZ3Az'}],
                                                                       'name': '331/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13052',
                                                                       'out_octets': '113228643288',
                                                                       'out_ucast_pkts': '300979064',
                                                                       'poller_hash': 'QTM0OUJBcGVlcmludGYzMzEvZ3Ax',
                                                                       'pons': [       {       'description': '331/gp1',
                                                                                               'id': '331',
                                                                                               'links': [       {       'connected_time': '15445190',
                                                                                                                        'fiber_length': 4790,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJiMTIwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '331/gp1',
                                                                                               'poller_hash': 'QTM0OUJBcGVlcnBvbjMzMS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 331',
                                         'poller_hash': 'QTM0OUJB',
                                         'serial_number': 'A349BA',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:24:c7:79',
                                         'uptime': '15445190'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:78:84:cd'],
                                                                       'id': '1003297',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '136',
                                                                       'in_octets': '142493068235',
                                                                       'in_ucast_pkts': '250653024',
                                                                       'mac_address': '48:77:46:d8:6b:10',
                                                                       'mtu': 2000,
                                                                       'name': '332/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '6319513',
                                                                       'out_octets': '817067734824',
                                                                       'out_ucast_pkts': '618943698',
                                                                       'poller_hash': 'N0YzNUQycGVlcmludGYzMzIvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '332',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6319513',
                                                                       'in_octets': '817067734824',
                                                                       'in_ucast_pkts': '618943698',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '6319513',
                                                                                                'in_octets': '817067734824',
                                                                                                'in_ucast_pkts': '618943698',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '136',
                                                                                                'out_octets': '142493068235',
                                                                                                'out_ucast_pkts': '250653024',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmIxLzIvZ3Az'}],
                                                                       'name': '332/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '136',
                                                                       'out_octets': '142493068235',
                                                                       'out_ucast_pkts': '250653024',
                                                                       'poller_hash': 'N0YzNUQycGVlcmludGYzMzIvZ3Ax',
                                                                       'pons': [       {       'description': '332/gp1',
                                                                                               'id': '332',
                                                                                               'links': [       {       'connected_time': '12637532',
                                                                                                                        'fiber_length': 4916,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJiMTIwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '332/gp1',
                                                                                               'poller_hash': 'N0YzNUQycGVlcnBvbjMzMi9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 332',
                                         'poller_hash': 'N0YzNUQy',
                                         'serial_number': '7F35D2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d8:6b:10',
                                         'uptime': '12637532'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:78:85:0c'],
                                                                       'id': '1003329',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '142',
                                                                       'in_octets': '134135706458',
                                                                       'in_ucast_pkts': '474848946',
                                                                       'mac_address': '48:77:46:d8:65:8b',
                                                                       'mtu': 2000,
                                                                       'name': '333/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723395',
                                                                       'out_octets': '1091370172147',
                                                                       'out_ucast_pkts': '892257160',
                                                                       'poller_hash': 'N0YzM0ZCcGVlcmludGYzMzMvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '333',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723395',
                                                                       'in_octets': '1091370172147',
                                                                       'in_ucast_pkts': '892257160',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723395',
                                                                                                'in_octets': '1091370172147',
                                                                                                'in_ucast_pkts': '892257160',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '142',
                                                                                                'out_octets': '134135706458',
                                                                                                'out_ucast_pkts': '474848946',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmIxLzIvZ3Az'}],
                                                                       'name': '333/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '142',
                                                                       'out_octets': '134135706458',
                                                                       'out_ucast_pkts': '474848946',
                                                                       'poller_hash': 'N0YzM0ZCcGVlcmludGYzMzMvZ3Ax',
                                                                       'pons': [       {       'description': '333/gp1',
                                                                                               'id': '333',
                                                                                               'links': [       {       'connected_time': '15445272',
                                                                                                                        'fiber_length': 4251,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJiMTIwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '333/gp1',
                                                                                               'poller_hash': 'N0YzM0ZCcGVlcnBvbjMzMy9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 333',
                                         'poller_hash': 'N0YzM0ZC',
                                         'serial_number': '7F33FB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d8:65:8b',
                                         'uptime': '15445272'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:9b:e3:6a'],
                                                                       'id': '1003361',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13045',
                                                                       'in_octets': '456222703535',
                                                                       'in_ucast_pkts': '883844408',
                                                                       'mac_address': '48:77:46:d6:1b:78',
                                                                       'mtu': 2000,
                                                                       'name': '335/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723345',
                                                                       'out_octets': '1788955704787',
                                                                       'out_ucast_pkts': '1365550656',
                                                                       'poller_hash': 'N0UyRUVCcGVlcmludGYzMzUvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '335',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723345',
                                                                       'in_octets': '1788955704787',
                                                                       'in_ucast_pkts': '1365550656',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723345',
                                                                                                'in_octets': '1788955704787',
                                                                                                'in_ucast_pkts': '1365550656',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13045',
                                                                                                'out_octets': '456222703535',
                                                                                                'out_ucast_pkts': '883844408',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmIxLzIvZ3Az'}],
                                                                       'name': '335/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13045',
                                                                       'out_octets': '456222703535',
                                                                       'out_ucast_pkts': '883844408',
                                                                       'poller_hash': 'N0UyRUVCcGVlcmludGYzMzUvZ3Ax',
                                                                       'pons': [       {       'description': '335/gp1',
                                                                                               'id': '335',
                                                                                               'links': [       {       'connected_time': '15445198',
                                                                                                                        'fiber_length': 4362,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJiMTIwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '335/gp1',
                                                                                               'poller_hash': 'N0UyRUVCcGVlcnBvbjMzNS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 335',
                                         'poller_hash': 'N0UyRUVC',
                                         'serial_number': '7E2EEB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d6:1b:78',
                                         'uptime': '15445198'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:78:85:8a'],
                                                                       'id': '1003393',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '14',
                                                                       'in_octets': '18609329627',
                                                                       'in_ucast_pkts': '60839447',
                                                                       'mac_address': '48:77:46:d6:1b:6f',
                                                                       'mtu': 2000,
                                                                       'name': '336/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '953173',
                                                                       'out_octets': '250126147164',
                                                                       'out_ucast_pkts': '181067775',
                                                                       'poller_hash': 'N0UyRUU4cGVlcmludGYzMzYvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '336',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '953173',
                                                                       'in_octets': '250126147164',
                                                                       'in_ucast_pkts': '181067775',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '953173',
                                                                                                'in_octets': '250126147164',
                                                                                                'in_ucast_pkts': '181067775',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '14',
                                                                                                'out_octets': '18609329627',
                                                                                                'out_ucast_pkts': '60839447',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmIxLzIvZ3Az'}],
                                                                       'name': '336/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '14',
                                                                       'out_octets': '18609329627',
                                                                       'out_ucast_pkts': '60839447',
                                                                       'poller_hash': 'N0UyRUU4cGVlcmludGYzMzYvZ3Ax',
                                                                       'pons': [       {       'description': '336/gp1',
                                                                                               'id': '336',
                                                                                               'links': [       {       'connected_time': '1904810',
                                                                                                                        'fiber_length': 4608,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJiMTIwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '336/gp1',
                                                                                               'poller_hash': 'N0UyRUU4cGVlcnBvbjMzNi9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 336',
                                         'poller_hash': 'N0UyRUU4',
                                         'serial_number': '7E2EE8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d6:1b:6f',
                                         'uptime': '1904810'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:49:e7:ff'],
                                                                       'id': '1003425',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '739',
                                                                       'in_octets': '7298109035',
                                                                       'in_ucast_pkts': '64829128',
                                                                       'mac_address': '60:db:98:30:ef:08',
                                                                       'mtu': 2000,
                                                                       'name': '337/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '525267',
                                                                       'out_octets': '310058779880',
                                                                       'out_ucast_pkts': '214303848',
                                                                       'poller_hash': 'QTU1QzMxcGVlcmludGYzMzcvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '337',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '525267',
                                                                       'in_octets': '310058779880',
                                                                       'in_ucast_pkts': '214303848',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '525267',
                                                                                                'in_octets': '310058779880',
                                                                                                'in_ucast_pkts': '214303848',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '739',
                                                                                                'out_octets': '7298109035',
                                                                                                'out_ucast_pkts': '64829128',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmQxLzIvZ3A1'}],
                                                                       'name': '337/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '739',
                                                                       'out_octets': '7298109035',
                                                                       'out_ucast_pkts': '64829128',
                                                                       'poller_hash': 'QTU1QzMxcGVlcmludGYzMzcvZ3Ax',
                                                                       'pons': [       {       'description': '337/gp1',
                                                                                               'id': '337',
                                                                                               'links': [       {       'connected_time': '1049070',
                                                                                                                        'fiber_length': 4665,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJkMTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '337/gp1',
                                                                                               'poller_hash': 'QTU1QzMxcGVlcnBvbjMzNy9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 337',
                                         'poller_hash': 'QTU1QzMx',
                                         'serial_number': 'A55C31',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:30:ef:08',
                                         'uptime': '1049070'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:dd:0a:99'],
                                                                       'id': '1003457',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13024',
                                                                       'in_octets': '123587328536',
                                                                       'in_ucast_pkts': '401909388',
                                                                       'mac_address': '60:db:98:24:c7:46',
                                                                       'mtu': 2000,
                                                                       'name': '338/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723326',
                                                                       'out_octets': '1326934887425',
                                                                       'out_ucast_pkts': '996402422',
                                                                       'poller_hash': 'QTM0OUE5cGVlcmludGYzMzgvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '338',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723326',
                                                                       'in_octets': '1326934887425',
                                                                       'in_ucast_pkts': '996402422',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723326',
                                                                                                'in_octets': '1326934887425',
                                                                                                'in_ucast_pkts': '996402422',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13024',
                                                                                                'out_octets': '123587328536',
                                                                                                'out_ucast_pkts': '401909388',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmQxLzIvZ3A1'}],
                                                                       'name': '338/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13024',
                                                                       'out_octets': '123587328536',
                                                                       'out_ucast_pkts': '401909388',
                                                                       'poller_hash': 'QTM0OUE5cGVlcmludGYzMzgvZ3Ax',
                                                                       'pons': [       {       'description': '338/gp1',
                                                                                               'id': '338',
                                                                                               'links': [       {       'connected_time': '15445150',
                                                                                                                        'fiber_length': 4754,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJkMTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '338/gp1',
                                                                                               'poller_hash': 'QTM0OUE5cGVlcnBvbjMzOC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 338',
                                         'poller_hash': 'QTM0OUE5',
                                         'serial_number': 'A349A9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:24:c7:46',
                                         'uptime': '15445150'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:93:04:fc'],
                                                                       'id': '1003489',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '9206',
                                                                       'in_octets': '75505126977',
                                                                       'in_ucast_pkts': '582643216',
                                                                       'mac_address': '60:db:98:24:c7:eb',
                                                                       'mtu': 2000,
                                                                       'name': '339/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '5451329',
                                                                       'out_octets': '2326272762029',
                                                                       'out_ucast_pkts': '1601380714',
                                                                       'poller_hash': 'QTM0OUUwcGVlcmludGYzMzkvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '339',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5451329',
                                                                       'in_octets': '2326272762029',
                                                                       'in_ucast_pkts': '1601380714',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '5451329',
                                                                                                'in_octets': '2326272762029',
                                                                                                'in_ucast_pkts': '1601380714',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '9206',
                                                                                                'out_octets': '75505126977',
                                                                                                'out_ucast_pkts': '582643216',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmQxLzIvZ3A1'}],
                                                                       'name': '339/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '9206',
                                                                       'out_octets': '75505126977',
                                                                       'out_ucast_pkts': '582643216',
                                                                       'poller_hash': 'QTM0OUUwcGVlcmludGYzMzkvZ3Ax',
                                                                       'pons': [       {       'description': '339/gp1',
                                                                                               'id': '339',
                                                                                               'links': [       {       'connected_time': '10901195',
                                                                                                                        'fiber_length': 4761,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJkMTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '339/gp1',
                                                                                               'poller_hash': 'QTM0OUUwcGVlcnBvbjMzOS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 339',
                                         'poller_hash': 'QTM0OUUw',
                                         'serial_number': 'A349E0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:24:c7:eb',
                                         'uptime': '10901195'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e6:2a:8f'],
                                                                       'id': '1003521',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13135',
                                                                       'in_octets': '512549282556',
                                                                       'in_ucast_pkts': '1612167013',
                                                                       'mac_address': '60:db:98:25:25:ff',
                                                                       'mtu': 2000,
                                                                       'name': '340/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723396',
                                                                       'out_octets': '5459069457092',
                                                                       'out_ucast_pkts': '4177504971',
                                                                       'poller_hash': 'QTM2OTNDcGVlcmludGYzNDAvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '340',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723396',
                                                                       'in_octets': '5459069457092',
                                                                       'in_ucast_pkts': '4177504971',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723396',
                                                                                                'in_octets': '5459069457092',
                                                                                                'in_ucast_pkts': '4177504971',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13135',
                                                                                                'out_octets': '512549282556',
                                                                                                'out_ucast_pkts': '1612167013',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmQxLzIvZ3A1'}],
                                                                       'name': '340/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13135',
                                                                       'out_octets': '512549282556',
                                                                       'out_ucast_pkts': '1612167013',
                                                                       'poller_hash': 'QTM2OTNDcGVlcmludGYzNDAvZ3Ax',
                                                                       'pons': [       {       'description': '340/gp1',
                                                                                               'id': '340',
                                                                                               'links': [       {       'connected_time': '15445315',
                                                                                                                        'fiber_length': 4798,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJkMTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '340/gp1',
                                                                                               'poller_hash': 'QTM2OTNDcGVlcnBvbjM0MC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 340',
                                         'poller_hash': 'QTM2OTND',
                                         'serial_number': 'A3693C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:25:25:ff',
                                         'uptime': '15445315'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:1b:a6:36'],
                                                                       'id': '1003553',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3171',
                                                                       'in_octets': '35153948927',
                                                                       'in_ucast_pkts': '87905958',
                                                                       'mac_address': '60:db:98:24:c8:3f',
                                                                       'mtu': 2000,
                                                                       'name': '341/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1879420',
                                                                       'out_octets': '334443765098',
                                                                       'out_ucast_pkts': '237913128',
                                                                       'poller_hash': 'QTM0OUZDcGVlcmludGYzNDEvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '341',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1879420',
                                                                       'in_octets': '334443765098',
                                                                       'in_ucast_pkts': '237913128',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '1879420',
                                                                                                'in_octets': '334443765098',
                                                                                                'in_ucast_pkts': '237913128',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '3171',
                                                                                                'out_octets': '35153948927',
                                                                                                'out_ucast_pkts': '87905958',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmQxLzIvZ3A1'}],
                                                                       'name': '341/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3171',
                                                                       'out_octets': '35153948927',
                                                                       'out_ucast_pkts': '87905958',
                                                                       'poller_hash': 'QTM0OUZDcGVlcmludGYzNDEvZ3Ax',
                                                                       'pons': [       {       'description': '341/gp1',
                                                                                               'id': '341',
                                                                                               'links': [       {       'connected_time': '3757315',
                                                                                                                        'fiber_length': 4818,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJkMTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '341/gp1',
                                                                                               'poller_hash': 'QTM0OUZDcGVlcnBvbjM0MS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 341',
                                         'poller_hash': 'QTM0OUZD',
                                         'serial_number': 'A349FC',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:24:c8:3f',
                                         'uptime': '3757315'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:1b:a6:83'],
                                                                       'id': '1003585',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13013',
                                                                       'in_octets': '250548111270',
                                                                       'in_ucast_pkts': '1512767041',
                                                                       'mac_address': '60:db:98:24:c8:3c',
                                                                       'mtu': 2000,
                                                                       'name': '342/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723365',
                                                                       'out_octets': '4747348412347',
                                                                       'out_ucast_pkts': '3435037475',
                                                                       'poller_hash': 'QTM0OUZCcGVlcmludGYzNDIvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '342',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723365',
                                                                       'in_octets': '4747348412347',
                                                                       'in_ucast_pkts': '3435037475',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723365',
                                                                                                'in_octets': '4747348412347',
                                                                                                'in_ucast_pkts': '3435037475',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13013',
                                                                                                'out_octets': '250548111270',
                                                                                                'out_ucast_pkts': '1512767041',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmIxLzIvZ3Az'}],
                                                                       'name': '342/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13013',
                                                                       'out_octets': '250548111270',
                                                                       'out_ucast_pkts': '1512767041',
                                                                       'poller_hash': 'QTM0OUZCcGVlcmludGYzNDIvZ3Ax',
                                                                       'pons': [       {       'description': '342/gp1',
                                                                                               'id': '342',
                                                                                               'links': [       {       'connected_time': '15445279',
                                                                                                                        'fiber_length': 4857,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJiMTIwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '342/gp1',
                                                                                               'poller_hash': 'QTM0OUZCcGVlcnBvbjM0Mi9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 342',
                                         'poller_hash': 'QTM0OUZC',
                                         'serial_number': 'A349FB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:24:c8:3c',
                                         'uptime': '15445279'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e6:2b:97'],
                                                                       'id': '1003617',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4963',
                                                                       'in_octets': '15972796121',
                                                                       'in_ucast_pkts': '87897834',
                                                                       'mac_address': '60:db:98:25:25:81',
                                                                       'mtu': 2000,
                                                                       'name': '343/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2943935',
                                                                       'out_octets': '260110885319',
                                                                       'out_ucast_pkts': '196500630',
                                                                       'poller_hash': 'QTM2OTEycGVlcmludGYzNDMvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '343',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2943935',
                                                                       'in_octets': '260110885319',
                                                                       'in_ucast_pkts': '196500630',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '2943935',
                                                                                                'in_octets': '260110885319',
                                                                                                'in_ucast_pkts': '196500630',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '4963',
                                                                                                'out_octets': '15972796121',
                                                                                                'out_ucast_pkts': '87897834',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmQxLzIvZ3A1'}],
                                                                       'name': '343/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4963',
                                                                       'out_octets': '15972796121',
                                                                       'out_ucast_pkts': '87897834',
                                                                       'poller_hash': 'QTM2OTEycGVlcmludGYzNDMvZ3Ax',
                                                                       'pons': [       {       'description': '343/gp1',
                                                                                               'id': '343',
                                                                                               'links': [       {       'connected_time': '5886339',
                                                                                                                        'fiber_length': 5439,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJkMTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '343/gp1',
                                                                                               'poller_hash': 'QTM2OTEycGVlcnBvbjM0My9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 343',
                                         'poller_hash': 'QTM2OTEy',
                                         'serial_number': 'A36912',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:25:25:81',
                                         'uptime': '5886339'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:1b:a4:d6'],
                                                                       'id': '1003649',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '11137',
                                                                       'in_octets': '129400562917',
                                                                       'in_ucast_pkts': '787804756',
                                                                       'mac_address': '60:db:98:24:c8:27',
                                                                       'mtu': 2000,
                                                                       'name': '344/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '6611601',
                                                                       'out_octets': '2488133015574',
                                                                       'out_ucast_pkts': '1761262963',
                                                                       'poller_hash': 'QTM0OUY0cGVlcmludGYzNDQvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '344',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6611601',
                                                                       'in_octets': '2488133015574',
                                                                       'in_ucast_pkts': '1761262963',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '6611601',
                                                                                                'in_octets': '2488133015574',
                                                                                                'in_ucast_pkts': '1761262963',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '11137',
                                                                                                'out_octets': '129400562917',
                                                                                                'out_ucast_pkts': '787804756',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmQxLzIvZ3A1'}],
                                                                       'name': '344/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '11137',
                                                                       'out_octets': '129400562917',
                                                                       'out_ucast_pkts': '787804756',
                                                                       'poller_hash': 'QTM0OUY0cGVlcmludGYzNDQvZ3Ax',
                                                                       'pons': [       {       'description': '344/gp1',
                                                                                               'id': '344',
                                                                                               'links': [       {       'connected_time': '13221795',
                                                                                                                        'fiber_length': 4848,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJkMTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '344/gp1',
                                                                                               'poller_hash': 'QTM0OUY0cGVlcnBvbjM0NC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 344',
                                         'poller_hash': 'QTM0OUY0',
                                         'serial_number': 'A349F4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:24:c8:27',
                                         'uptime': '13221795'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:1b:a1:0e'],
                                                                       'id': '1003681',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '12989',
                                                                       'in_octets': '99163697940',
                                                                       'in_ucast_pkts': '384149281',
                                                                       'mac_address': '48:77:46:d8:65:16',
                                                                       'mtu': 2000,
                                                                       'name': '345/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723357',
                                                                       'out_octets': '1365549039503',
                                                                       'out_ucast_pkts': '1107384100',
                                                                       'poller_hash': 'N0YzM0Q0cGVlcmludGYzNDUvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '345',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723357',
                                                                       'in_octets': '1365549039503',
                                                                       'in_ucast_pkts': '1107384100',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723357',
                                                                                                'in_octets': '1365549039503',
                                                                                                'in_ucast_pkts': '1107384100',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '12989',
                                                                                                'out_octets': '99163697940',
                                                                                                'out_ucast_pkts': '384149281',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmQxLzIvZ3A1'}],
                                                                       'name': '345/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '12989',
                                                                       'out_octets': '99163697940',
                                                                       'out_ucast_pkts': '384149281',
                                                                       'poller_hash': 'N0YzM0Q0cGVlcmludGYzNDUvZ3Ax',
                                                                       'pons': [       {       'description': '345/gp1',
                                                                                               'id': '345',
                                                                                               'links': [       {       'connected_time': '15445218',
                                                                                                                        'fiber_length': 5038,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJkMTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '345/gp1',
                                                                                               'poller_hash': 'N0YzM0Q0cGVlcnBvbjM0NS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 345',
                                         'poller_hash': 'N0YzM0Q0',
                                         'serial_number': '7F33D4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d8:65:16',
                                         'uptime': '15445218'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:72:88:22'],
                                                                       'id': '1003713',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7998',
                                                                       'in_octets': '68212885156',
                                                                       'in_ucast_pkts': '197093146',
                                                                       'mac_address': '60:db:98:25:24:a6',
                                                                       'mtu': 2000,
                                                                       'name': '346/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4723588',
                                                                       'out_octets': '558682073988',
                                                                       'out_ucast_pkts': '458438304',
                                                                       'poller_hash': 'QTM2OEM5cGVlcmludGYzNDYvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '346',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4723588',
                                                                       'in_octets': '558682073988',
                                                                       'in_ucast_pkts': '458438304',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '4723588',
                                                                                                'in_octets': '558682073988',
                                                                                                'in_ucast_pkts': '458438304',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '7998',
                                                                                                'out_octets': '68212885156',
                                                                                                'out_ucast_pkts': '197093146',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmQxLzIvZ3A1'}],
                                                                       'name': '346/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7998',
                                                                       'out_octets': '68212885156',
                                                                       'out_ucast_pkts': '197093146',
                                                                       'poller_hash': 'QTM2OEM5cGVlcmludGYzNDYvZ3Ax',
                                                                       'pons': [       {       'description': '346/gp1',
                                                                                               'id': '346',
                                                                                               'links': [       {       'connected_time': '9448153',
                                                                                                                        'fiber_length': 5404,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJkMTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '346/gp1',
                                                                                               'poller_hash': 'QTM2OEM5cGVlcnBvbjM0Ni9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 346',
                                         'poller_hash': 'QTM2OEM5',
                                         'serial_number': 'A368C9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:25:24:a6',
                                         'uptime': '9448153'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:a3:7d:7b'],
                                                                       'id': '1003745',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '12990',
                                                                       'in_octets': '311526107640',
                                                                       'in_ucast_pkts': '1366393337',
                                                                       'mac_address': '48:77:46:d8:65:fd',
                                                                       'mtu': 2000,
                                                                       'name': '347/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723254',
                                                                       'out_octets': '4816058702161',
                                                                       'out_ucast_pkts': '3646757578',
                                                                       'poller_hash': 'N0YzNDIxcGVlcmludGYzNDcvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '347',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723254',
                                                                       'in_octets': '4816058702161',
                                                                       'in_ucast_pkts': '3646757578',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723254',
                                                                                                'in_octets': '4816058702161',
                                                                                                'in_ucast_pkts': '3646757578',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '12990',
                                                                                                'out_octets': '311526107640',
                                                                                                'out_ucast_pkts': '1366393337',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmQxLzIvZ3A1'}],
                                                                       'name': '347/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '12990',
                                                                       'out_octets': '311526107640',
                                                                       'out_ucast_pkts': '1366393337',
                                                                       'poller_hash': 'N0YzNDIxcGVlcmludGYzNDcvZ3Ax',
                                                                       'pons': [       {       'description': '347/gp1',
                                                                                               'id': '347',
                                                                                               'links': [       {       'connected_time': '15445257',
                                                                                                                        'fiber_length': 4994,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJkMTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '347/gp1',
                                                                                               'poller_hash': 'N0YzNDIxcGVlcnBvbjM0Ny9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 347',
                                         'poller_hash': 'N0YzNDIx',
                                         'serial_number': '7F3421',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d8:65:fd',
                                         'uptime': '15445257'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e6:32:2a'],
                                                                       'id': '1003777',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '12875',
                                                                       'in_octets': '109189190425',
                                                                       'in_ucast_pkts': '410881483',
                                                                       'mac_address': '48:77:46:d8:66:24',
                                                                       'mtu': 2000,
                                                                       'name': '348/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723413',
                                                                       'out_octets': '2134044198009',
                                                                       'out_ucast_pkts': '1578899348',
                                                                       'poller_hash': 'N0YzNDJFcGVlcmludGYzNDgvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '348',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723413',
                                                                       'in_octets': '2134044198009',
                                                                       'in_ucast_pkts': '1578899348',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723413',
                                                                                                'in_octets': '2134044198009',
                                                                                                'in_ucast_pkts': '1578899348',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '12875',
                                                                                                'out_octets': '109189190425',
                                                                                                'out_ucast_pkts': '410881483',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmQxLzIvZ3A1'}],
                                                                       'name': '348/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '12875',
                                                                       'out_octets': '109189190425',
                                                                       'out_ucast_pkts': '410881483',
                                                                       'poller_hash': 'N0YzNDJFcGVlcmludGYzNDgvZ3Ax',
                                                                       'pons': [       {       'description': '348/gp1',
                                                                                               'id': '348',
                                                                                               'links': [       {       'connected_time': '15445336',
                                                                                                                        'fiber_length': 5139,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJkMTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '348/gp1',
                                                                                               'poller_hash': 'N0YzNDJFcGVlcnBvbjM0OC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 348',
                                         'poller_hash': 'N0YzNDJF',
                                         'serial_number': '7F342E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d8:66:24',
                                         'uptime': '15445336'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:49:ea:04'],
                                                                       'id': '1003809',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '194',
                                                                       'in_octets': '12749231884',
                                                                       'in_ucast_pkts': '16696693',
                                                                       'mac_address': '60:db:98:8d:a7:f1',
                                                                       'mtu': 2000,
                                                                       'name': '349/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '103509',
                                                                       'out_octets': '12910439586',
                                                                       'out_ucast_pkts': '14596832',
                                                                       'poller_hash': 'QjQ5RUJGcGVlcmludGYzNDkvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '349',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '103509',
                                                                       'in_octets': '12910439586',
                                                                       'in_ucast_pkts': '14596832',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '103509',
                                                                                                'in_octets': '12910439586',
                                                                                                'in_ucast_pkts': '14596832',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '194',
                                                                                                'out_octets': '12749231884',
                                                                                                'out_ucast_pkts': '16696693',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmQxLzIvZ3A1'}],
                                                                       'name': '349/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '194',
                                                                       'out_octets': '12749231884',
                                                                       'out_ucast_pkts': '16696693',
                                                                       'poller_hash': 'QjQ5RUJGcGVlcmludGYzNDkvZ3Ax',
                                                                       'pons': [       {       'description': '349/gp1',
                                                                                               'id': '349',
                                                                                               'links': [       {       'connected_time': '205503',
                                                                                                                        'fiber_length': 5480,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJkMTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '349/gp1',
                                                                                               'poller_hash': 'QjQ5RUJGcGVlcnBvbjM0OS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 349',
                                         'poller_hash': 'QjQ5RUJG',
                                         'serial_number': 'B49EBF',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:8d:a7:f1',
                                         'uptime': '205503'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:1b:ac:45'],
                                                                       'id': '1003873',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13041',
                                                                       'in_octets': '447681220457',
                                                                       'in_ucast_pkts': '984239194',
                                                                       'mac_address': '60:db:98:24:c8:72',
                                                                       'mtu': 2000,
                                                                       'name': '351/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723426',
                                                                       'out_octets': '2599654002328',
                                                                       'out_ucast_pkts': '2072962314',
                                                                       'poller_hash': 'QTM0QTBEcGVlcmludGYzNTEvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '351',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723426',
                                                                       'in_octets': '2599654002328',
                                                                       'in_ucast_pkts': '2072962314',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723426',
                                                                                                'in_octets': '2599654002328',
                                                                                                'in_ucast_pkts': '2072962314',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13041',
                                                                                                'out_octets': '447681220457',
                                                                                                'out_ucast_pkts': '984239194',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmQxLzIvZ3A1'}],
                                                                       'name': '351/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13041',
                                                                       'out_octets': '447681220457',
                                                                       'out_ucast_pkts': '984239194',
                                                                       'poller_hash': 'QTM0QTBEcGVlcmludGYzNTEvZ3Ax',
                                                                       'pons': [       {       'description': '351/gp1',
                                                                                               'id': '351',
                                                                                               'links': [       {       'connected_time': '15445373',
                                                                                                                        'fiber_length': 5831,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJkMTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '351/gp1',
                                                                                               'poller_hash': 'QTM0QTBEcGVlcnBvbjM1MS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 351',
                                         'poller_hash': 'QTM0QTBE',
                                         'serial_number': 'A34A0D',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:24:c8:72',
                                         'uptime': '15445373'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e2:dd:ea'],
                                                                       'id': '1003905',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '10821',
                                                                       'in_octets': '324056696966',
                                                                       'in_ucast_pkts': '1891708268',
                                                                       'mac_address': '60:db:98:30:ef:7a',
                                                                       'mtu': 2000,
                                                                       'name': '352/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '6413966',
                                                                       'out_octets': '6705627882392',
                                                                       'out_ucast_pkts': '4771614462',
                                                                       'poller_hash': 'QTU1QzU3cGVlcmludGYzNTIvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '352',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6413966',
                                                                       'in_octets': '6705627882392',
                                                                       'in_ucast_pkts': '4771614462',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '6413966',
                                                                                                'in_octets': '6705627882392',
                                                                                                'in_ucast_pkts': '4771614462',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '10821',
                                                                                                'out_octets': '324056696966',
                                                                                                'out_ucast_pkts': '1891708268',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmQxLzIvZ3A1'}],
                                                                       'name': '352/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '10821',
                                                                       'out_octets': '324056696966',
                                                                       'out_ucast_pkts': '1891708268',
                                                                       'poller_hash': 'QTU1QzU3cGVlcmludGYzNTIvZ3Ax',
                                                                       'pons': [       {       'description': '352/gp1',
                                                                                               'id': '352',
                                                                                               'links': [       {       'connected_time': '12826488',
                                                                                                                        'fiber_length': 5602,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJkMTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '352/gp1',
                                                                                               'poller_hash': 'QTU1QzU3cGVlcnBvbjM1Mi9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 352',
                                         'poller_hash': 'QTU1QzU3',
                                         'serial_number': 'A55C57',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:30:ef:7a',
                                         'uptime': '12826488'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:31:b5:55'],
                                                                       'id': '1003969',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6429',
                                                                       'in_octets': '64184032487',
                                                                       'in_ucast_pkts': '378113050',
                                                                       'mac_address': '60:db:98:8d:a7:7c',
                                                                       'mtu': 2000,
                                                                       'name': '354/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3811384',
                                                                       'out_octets': '1456289704119',
                                                                       'out_ucast_pkts': '1047371459',
                                                                       'poller_hash': 'QjQ5RTk4cGVlcmludGYzNTQvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '354',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3811384',
                                                                       'in_octets': '1456289704119',
                                                                       'in_ucast_pkts': '1047371459',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '3811384',
                                                                                                'in_octets': '1456289704119',
                                                                                                'in_ucast_pkts': '1047371459',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '6429',
                                                                                                'out_octets': '64184032487',
                                                                                                'out_ucast_pkts': '378113050',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '354/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '6429',
                                                                       'out_octets': '64184032487',
                                                                       'out_ucast_pkts': '378113050',
                                                                       'poller_hash': 'QjQ5RTk4cGVlcmludGYzNTQvZ3Ax',
                                                                       'pons': [       {       'description': '354/gp1',
                                                                                               'id': '354',
                                                                                               'links': [       {       'connected_time': '7621307',
                                                                                                                        'fiber_length': 4572,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '354/gp1',
                                                                                               'poller_hash': 'QjQ5RTk4cGVlcnBvbjM1NC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 354',
                                         'poller_hash': 'QjQ5RTk4',
                                         'serial_number': 'B49E98',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:8d:a7:7c',
                                         'uptime': '7621307'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e6:7f:09'],
                                                                       'id': '1004001',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13036',
                                                                       'in_octets': '1422089291794',
                                                                       'in_ucast_pkts': '2460686575',
                                                                       'mac_address': '60:db:98:75:fb:d5',
                                                                       'mtu': 2000,
                                                                       'name': '355/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723426',
                                                                       'out_octets': '10398292446419',
                                                                       'out_ucast_pkts': '7494448002',
                                                                       'poller_hash': 'QjEyNENCcGVlcmludGYzNTUvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '355',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723426',
                                                                       'in_octets': '10398292446419',
                                                                       'in_ucast_pkts': '7494448002',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723426',
                                                                                                'in_octets': '10398292446419',
                                                                                                'in_ucast_pkts': '7494448002',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13036',
                                                                                                'out_octets': '1422089291794',
                                                                                                'out_ucast_pkts': '2460686575',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '355/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13036',
                                                                       'out_octets': '1422089291794',
                                                                       'out_ucast_pkts': '2460686575',
                                                                       'poller_hash': 'QjEyNENCcGVlcmludGYzNTUvZ3Ax',
                                                                       'pons': [       {       'description': '355/gp1',
                                                                                               'id': '355',
                                                                                               'links': [       {       'connected_time': '15445390',
                                                                                                                        'fiber_length': 5314,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '355/gp1',
                                                                                               'poller_hash': 'QjEyNENCcGVlcnBvbjM1NS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 355',
                                         'poller_hash': 'QjEyNENC',
                                         'serial_number': 'B124CB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:75:fb:d5',
                                         'uptime': '15445390'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:1b:a6:a4'],
                                                                       'id': '1004033',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6298',
                                                                       'in_octets': '43347855406',
                                                                       'in_ucast_pkts': '353519047',
                                                                       'mac_address': '60:db:98:25:25:1e',
                                                                       'mtu': 2000,
                                                                       'name': '356/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3722237',
                                                                       'out_octets': '560789727940',
                                                                       'out_ucast_pkts': '393320641',
                                                                       'poller_hash': 'QTM2OEYxcGVlcmludGYzNTYvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '356',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3722237',
                                                                       'in_octets': '560789727940',
                                                                       'in_ucast_pkts': '393320641',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '3722237',
                                                                                                'in_octets': '560789727940',
                                                                                                'in_ucast_pkts': '393320641',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '6298',
                                                                                                'out_octets': '43347855406',
                                                                                                'out_ucast_pkts': '353519047',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '356/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '6298',
                                                                       'out_octets': '43347855406',
                                                                       'out_ucast_pkts': '353519047',
                                                                       'poller_hash': 'QTM2OEYxcGVlcmludGYzNTYvZ3Ax',
                                                                       'pons': [       {       'description': '356/gp1',
                                                                                               'id': '356',
                                                                                               'links': [       {       'connected_time': '7442989',
                                                                                                                        'fiber_length': 4650,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '356/gp1',
                                                                                               'poller_hash': 'QTM2OEYxcGVlcnBvbjM1Ni9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 356',
                                         'poller_hash': 'QTM2OEYx',
                                         'serial_number': 'A368F1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:25:25:1e',
                                         'uptime': '7442989'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:a3:7e:36'],
                                                                       'id': '1004065',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3810',
                                                                       'in_octets': '83276674731',
                                                                       'in_ucast_pkts': '242135800',
                                                                       'mac_address': '60:db:98:24:c8:5a',
                                                                       'mtu': 2000,
                                                                       'name': '357/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2258347',
                                                                       'out_octets': '761226679017',
                                                                       'out_ucast_pkts': '573298378',
                                                                       'poller_hash': 'QTM0QTA1cGVlcmludGYzNTcvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '357',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2258347',
                                                                       'in_octets': '761226679017',
                                                                       'in_ucast_pkts': '573298378',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '2258347',
                                                                                                'in_octets': '761226679017',
                                                                                                'in_ucast_pkts': '573298378',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '3810',
                                                                                                'out_octets': '83276674731',
                                                                                                'out_ucast_pkts': '242135800',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '357/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3810',
                                                                       'out_octets': '83276674731',
                                                                       'out_ucast_pkts': '242135800',
                                                                       'poller_hash': 'QTM0QTA1cGVlcmludGYzNTcvZ3Ax',
                                                                       'pons': [       {       'description': '357/gp1',
                                                                                               'id': '357',
                                                                                               'links': [       {       'connected_time': '4515208',
                                                                                                                        'fiber_length': 4554,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '357/gp1',
                                                                                               'poller_hash': 'QTM0QTA1cGVlcnBvbjM1Ny9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 357',
                                         'poller_hash': 'QTM0QTA1',
                                         'serial_number': 'A34A05',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:24:c8:5a',
                                         'uptime': '4515208'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e5:87:26'],
                                                                       'id': '1004097',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7292',
                                                                       'in_octets': '49226623373',
                                                                       'in_ucast_pkts': '199514299',
                                                                       'mac_address': '60:db:98:24:c8:4b',
                                                                       'mtu': 2000,
                                                                       'name': '358/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4315576',
                                                                       'out_octets': '1310215566763',
                                                                       'out_ucast_pkts': '917323158',
                                                                       'poller_hash': 'QTM0QTAwcGVlcmludGYzNTgvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '358',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4315576',
                                                                       'in_octets': '1310215566763',
                                                                       'in_ucast_pkts': '917323158',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '4315576',
                                                                                                'in_octets': '1310215566763',
                                                                                                'in_ucast_pkts': '917323158',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '7292',
                                                                                                'out_octets': '49226623373',
                                                                                                'out_ucast_pkts': '199514299',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '358/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7292',
                                                                       'out_octets': '49226623373',
                                                                       'out_ucast_pkts': '199514299',
                                                                       'poller_hash': 'QTM0QTAwcGVlcmludGYzNTgvZ3Ax',
                                                                       'pons': [       {       'description': '358/gp1',
                                                                                               'id': '358',
                                                                                               'links': [       {       'connected_time': '8629703',
                                                                                                                        'fiber_length': 4807,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '358/gp1',
                                                                                               'poller_hash': 'QTM0QTAwcGVlcnBvbjM1OC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 358',
                                         'poller_hash': 'QTM0QTAw',
                                         'serial_number': 'A34A00',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:24:c8:4b',
                                         'uptime': '8629703'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:1b:a3:ce'],
                                                                       'id': '1004129',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13046',
                                                                       'in_octets': '93635445923',
                                                                       'in_ucast_pkts': '529649580',
                                                                       'mac_address': '60:db:98:24:c8:24',
                                                                       'mtu': 2000,
                                                                       'name': '359/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723388',
                                                                       'out_octets': '2073497392431',
                                                                       'out_ucast_pkts': '1555893356',
                                                                       'poller_hash': 'QTM0OUYzcGVlcmludGYzNTkvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '359',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723388',
                                                                       'in_octets': '2073497392431',
                                                                       'in_ucast_pkts': '1555893356',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723388',
                                                                                                'in_octets': '2073497392431',
                                                                                                'in_ucast_pkts': '1555893356',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13046',
                                                                                                'out_octets': '93635445923',
                                                                                                'out_ucast_pkts': '529649580',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '359/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13046',
                                                                       'out_octets': '93635445923',
                                                                       'out_ucast_pkts': '529649580',
                                                                       'poller_hash': 'QTM0OUYzcGVlcmludGYzNTkvZ3Ax',
                                                                       'pons': [       {       'description': '359/gp1',
                                                                                               'id': '359',
                                                                                               'links': [       {       'connected_time': '15445311',
                                                                                                                        'fiber_length': 4680,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '359/gp1',
                                                                                               'poller_hash': 'QTM0OUYzcGVlcnBvbjM1OS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 359',
                                         'poller_hash': 'QTM0OUYz',
                                         'serial_number': 'A349F3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:24:c8:24',
                                         'uptime': '15445311'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:a2:02:74'],
                                                                       'id': '1004161',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '12996',
                                                                       'in_octets': '161979462609',
                                                                       'in_ucast_pkts': '1080402278',
                                                                       'mac_address': '60:db:98:24:c8:1e',
                                                                       'mtu': 2000,
                                                                       'name': '360/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723364',
                                                                       'out_octets': '5729387291130',
                                                                       'out_ucast_pkts': '3972313832',
                                                                       'poller_hash': 'QTM0OUYxcGVlcmludGYzNjAvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '360',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723364',
                                                                       'in_octets': '5729387291130',
                                                                       'in_ucast_pkts': '3972313832',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723364',
                                                                                                'in_octets': '5729387291130',
                                                                                                'in_ucast_pkts': '3972313832',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '12996',
                                                                                                'out_octets': '161979462609',
                                                                                                'out_ucast_pkts': '1080402278',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '360/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '12996',
                                                                       'out_octets': '161979462609',
                                                                       'out_ucast_pkts': '1080402278',
                                                                       'poller_hash': 'QTM0OUYxcGVlcmludGYzNjAvZ3Ax',
                                                                       'pons': [       {       'description': '360/gp1',
                                                                                               'id': '360',
                                                                                               'links': [       {       'connected_time': '15445386',
                                                                                                                        'fiber_length': 4408,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '360/gp1',
                                                                                               'poller_hash': 'QTM0OUYxcGVlcnBvbjM2MC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 360',
                                         'poller_hash': 'QTM0OUYx',
                                         'serial_number': 'A349F1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:24:c8:1e',
                                         'uptime': '15445386'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:1b:a6:db'],
                                                                       'id': '1004193',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13028',
                                                                       'in_octets': '50040965179',
                                                                       'in_ucast_pkts': '456111598',
                                                                       'mac_address': '60:db:98:24:c8:00',
                                                                       'mtu': 2000,
                                                                       'name': '361/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723297',
                                                                       'out_octets': '2283239668339',
                                                                       'out_ucast_pkts': '1552262374',
                                                                       'poller_hash': 'QTM0OUU3cGVlcmludGYzNjEvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '361',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723297',
                                                                       'in_octets': '2283239668339',
                                                                       'in_ucast_pkts': '1552262374',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723297',
                                                                                                'in_octets': '2283239668339',
                                                                                                'in_ucast_pkts': '1552262374',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13028',
                                                                                                'out_octets': '50040965179',
                                                                                                'out_ucast_pkts': '456111598',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '361/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13028',
                                                                       'out_octets': '50040965179',
                                                                       'out_ucast_pkts': '456111598',
                                                                       'poller_hash': 'QTM0OUU3cGVlcmludGYzNjEvZ3Ax',
                                                                       'pons': [       {       'description': '361/gp1',
                                                                                               'id': '361',
                                                                                               'links': [       {       'connected_time': '15445279',
                                                                                                                        'fiber_length': 4700,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '361/gp1',
                                                                                               'poller_hash': 'QTM0OUU3cGVlcnBvbjM2MS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 361',
                                         'poller_hash': 'QTM0OUU3',
                                         'serial_number': 'A349E7',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:24:c8:00',
                                         'uptime': '15445279'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:93:04:36'],
                                                                       'id': '1004225',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13020',
                                                                       'in_octets': '366181922176',
                                                                       'in_ucast_pkts': '1428403392',
                                                                       'mac_address': '60:db:98:24:c7:dc',
                                                                       'mtu': 2000,
                                                                       'name': '362/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723384',
                                                                       'out_octets': '5997380995885',
                                                                       'out_ucast_pkts': '4508043256',
                                                                       'poller_hash': 'QTM0OURCcGVlcmludGYzNjIvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '362',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723384',
                                                                       'in_octets': '5997380995885',
                                                                       'in_ucast_pkts': '4508043256',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723384',
                                                                                                'in_octets': '5997380995885',
                                                                                                'in_ucast_pkts': '4508043256',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13020',
                                                                                                'out_octets': '366181922176',
                                                                                                'out_ucast_pkts': '1428403392',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '362/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13020',
                                                                       'out_octets': '366181922176',
                                                                       'out_ucast_pkts': '1428403392',
                                                                       'poller_hash': 'QTM0OURCcGVlcmludGYzNjIvZ3Ax',
                                                                       'pons': [       {       'description': '362/gp1',
                                                                                               'id': '362',
                                                                                               'links': [       {       'connected_time': '15445368',
                                                                                                                        'fiber_length': 4854,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '362/gp1',
                                                                                               'poller_hash': 'QTM0OURCcGVlcnBvbjM2Mi9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 362',
                                         'poller_hash': 'QTM0OURC',
                                         'serial_number': 'A349DB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:24:c7:dc',
                                         'uptime': '15445368'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1004257',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4972739',
                                                                       'in_octets': '139976927860',
                                                                       'in_ucast_pkts': '519043778',
                                                                       'mac_address': '48:77:46:d8:66:30',
                                                                       'mtu': 2000,
                                                                       'name': '363/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7674009',
                                                                       'out_octets': '2338571259838',
                                                                       'out_ucast_pkts': '1717824270',
                                                                       'poller_hash': 'N0YzNDMycGVlcmludGYzNjMvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '363',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7674009',
                                                                       'in_octets': '2338571259838',
                                                                       'in_ucast_pkts': '1717824270',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7674009',
                                                                                                'in_octets': '2338571259838',
                                                                                                'in_ucast_pkts': '1717824270',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '4972739',
                                                                                                'out_octets': '139976927860',
                                                                                                'out_ucast_pkts': '519043778',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '363/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4972739',
                                                                       'out_octets': '139976927860',
                                                                       'out_ucast_pkts': '519043778',
                                                                       'poller_hash': 'N0YzNDMycGVlcmludGYzNjMvZ3Ax',
                                                                       'pons': [       {       'description': '363/gp1',
                                                                                               'id': '363',
                                                                                               'links': [       {       'connected_time': '15445969',
                                                                                                                        'fiber_length': 5165,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '363/gp1',
                                                                                               'poller_hash': 'N0YzNDMycGVlcnBvbjM2My9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 363',
                                         'poller_hash': 'N0YzNDMy',
                                         'serial_number': '7F3432',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d8:66:30',
                                         'uptime': '15445969'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:1b:a8:0f'],
                                                                       'id': '1004289',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13073',
                                                                       'in_octets': '234460374936',
                                                                       'in_ucast_pkts': '1750993977',
                                                                       'mac_address': '48:77:46:d8:66:27',
                                                                       'mtu': 2000,
                                                                       'name': '364/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723301',
                                                                       'out_octets': '7172315602568',
                                                                       'out_ucast_pkts': '4933655875',
                                                                       'poller_hash': 'N0YzNDJGcGVlcmludGYzNjQvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '364',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723301',
                                                                       'in_octets': '7172315602568',
                                                                       'in_ucast_pkts': '4933655875',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723301',
                                                                                                'in_octets': '7172315602568',
                                                                                                'in_ucast_pkts': '4933655875',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13073',
                                                                                                'out_octets': '234460374936',
                                                                                                'out_ucast_pkts': '1750993977',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '364/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13073',
                                                                       'out_octets': '234460374936',
                                                                       'out_ucast_pkts': '1750993977',
                                                                       'poller_hash': 'N0YzNDJGcGVlcmludGYzNjQvZ3Ax',
                                                                       'pons': [       {       'description': '364/gp1',
                                                                                               'id': '364',
                                                                                               'links': [       {       'connected_time': '15445248',
                                                                                                                        'fiber_length': 4506,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '364/gp1',
                                                                                               'poller_hash': 'N0YzNDJGcGVlcnBvbjM2NC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 364',
                                         'poller_hash': 'N0YzNDJG',
                                         'serial_number': '7F342F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d8:66:27',
                                         'uptime': '15445248'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:77:46:e0:bb:f9'],
                                                                       'id': '1004321',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '65807',
                                                                       'in_octets': '38128213414',
                                                                       'in_ucast_pkts': '4484737258',
                                                                       'mac_address': 'cc:be:59:ae:4c:3e',
                                                                       'mtu': 2000,
                                                                       'name': '365/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '256',
                                                                       'out_octets': '598840586662',
                                                                       'out_ucast_pkts': '4749484968',
                                                                       'poller_hash': 'NTAxOUM1cGVlcmludGYzNjUvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '365',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '256',
                                                                       'in_octets': '598840586662',
                                                                       'in_ucast_pkts': '4749484968',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '256',
                                                                                                'in_octets': '598840586662',
                                                                                                'in_ucast_pkts': '4749484968',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '65807',
                                                                                                'out_octets': '38128213414',
                                                                                                'out_ucast_pkts': '4484737258',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '365/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '65807',
                                                                       'out_octets': '38128213414',
                                                                       'out_ucast_pkts': '4484737258',
                                                                       'poller_hash': 'NTAxOUM1cGVlcmludGYzNjUvZ3Ax',
                                                                       'pons': [       {       'description': '365/gp1',
                                                                                               'id': '365',
                                                                                               'links': [       {       'connected_time': '15444626',
                                                                                                                        'fiber_length': 5101,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.194,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.176}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '365/gp1',
                                                                                               'poller_hash': 'NTAxOUM1cGVlcnBvbjM2NS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '801Gv2',
                                         'name': 'ont 365',
                                         'poller_hash': 'NTAxOUM1',
                                         'serial_number': '5019C5',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '1.0.5.0.120',
                                         'system_mac_address': 'cc:be:59:ae:4c:3e',
                                         'uptime': '15444626'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:78:84:f1'],
                                                                       'id': '1004353',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '147',
                                                                       'in_octets': '361653239526',
                                                                       'in_ucast_pkts': '1707836249',
                                                                       'mac_address': '48:77:46:d8:66:21',
                                                                       'mtu': 2000,
                                                                       'name': '366/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723371',
                                                                       'out_octets': '6507383282850',
                                                                       'out_ucast_pkts': '4824742594',
                                                                       'poller_hash': 'N0YzNDJEcGVlcmludGYzNjYvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '366',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723371',
                                                                       'in_octets': '6507383282850',
                                                                       'in_ucast_pkts': '4824742594',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723371',
                                                                                                'in_octets': '6507383282850',
                                                                                                'in_ucast_pkts': '4824742594',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '147',
                                                                                                'out_octets': '361653239526',
                                                                                                'out_ucast_pkts': '1707836249',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '366/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '147',
                                                                       'out_octets': '361653239526',
                                                                       'out_ucast_pkts': '1707836249',
                                                                       'poller_hash': 'N0YzNDJEcGVlcmludGYzNjYvZ3Ax',
                                                                       'pons': [       {       'description': '366/gp1',
                                                                                               'id': '366',
                                                                                               'links': [       {       'connected_time': '15445317',
                                                                                                                        'fiber_length': 4791,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '366/gp1',
                                                                                               'poller_hash': 'N0YzNDJEcGVlcnBvbjM2Ni9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 366',
                                         'poller_hash': 'N0YzNDJE',
                                         'serial_number': '7F342D',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d8:66:21',
                                         'uptime': '15445317'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:8d:5a:11'],
                                                                       'id': '1004385',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '11658',
                                                                       'in_octets': '392808412922',
                                                                       'in_ucast_pkts': '1392416369',
                                                                       'mac_address': '48:77:46:d2:63:76',
                                                                       'mtu': 2000,
                                                                       'name': '367/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '6943655',
                                                                       'out_octets': '3307534443278',
                                                                       'out_ucast_pkts': '2964842274',
                                                                       'poller_hash': 'N0RBQjRGcGVlcmludGYzNjcvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '367',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6943655',
                                                                       'in_octets': '3307534443278',
                                                                       'in_ucast_pkts': '2964842274',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '6943655',
                                                                                                'in_octets': '3307534443278',
                                                                                                'in_ucast_pkts': '2964842274',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '11658',
                                                                                                'out_octets': '392808412922',
                                                                                                'out_ucast_pkts': '1392416369',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '367/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '11658',
                                                                       'out_octets': '392808412922',
                                                                       'out_ucast_pkts': '1392416369',
                                                                       'poller_hash': 'N0RBQjRGcGVlcmludGYzNjcvZ3Ax',
                                                                       'pons': [       {       'description': '367/gp1',
                                                                                               'id': '367',
                                                                                               'links': [       {       'connected_time': '13885852',
                                                                                                                        'fiber_length': 4821,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '367/gp1',
                                                                                               'poller_hash': 'N0RBQjRGcGVlcnBvbjM2Ny9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 367',
                                         'poller_hash': 'N0RBQjRG',
                                         'serial_number': '7DAB4F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d2:63:76',
                                         'uptime': '13885852'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:15:29:3c'],
                                                                       'id': '1004417',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13021',
                                                                       'in_octets': '122767967546',
                                                                       'in_ucast_pkts': '314089975',
                                                                       'mac_address': '48:77:46:d8:66:15',
                                                                       'mtu': 2000,
                                                                       'name': '368/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723464',
                                                                       'out_octets': '943981825406',
                                                                       'out_ucast_pkts': '738825681',
                                                                       'poller_hash': 'N0YzNDI5cGVlcmludGYzNjgvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '368',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723464',
                                                                       'in_octets': '943981825406',
                                                                       'in_ucast_pkts': '738825681',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723464',
                                                                                                'in_octets': '943981825406',
                                                                                                'in_ucast_pkts': '738825681',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13021',
                                                                                                'out_octets': '122767967546',
                                                                                                'out_ucast_pkts': '314089975',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '368/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13021',
                                                                       'out_octets': '122767967546',
                                                                       'out_ucast_pkts': '314089975',
                                                                       'poller_hash': 'N0YzNDI5cGVlcmludGYzNjgvZ3Ax',
                                                                       'pons': [       {       'description': '368/gp1',
                                                                                               'id': '368',
                                                                                               'links': [       {       'connected_time': '15445474',
                                                                                                                        'fiber_length': 5415,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '368/gp1',
                                                                                               'poller_hash': 'N0YzNDI5cGVlcnBvbjM2OC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 368',
                                         'poller_hash': 'N0YzNDI5',
                                         'serial_number': '7F3429',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d8:66:15',
                                         'uptime': '15445474'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:a2:02:53'],
                                                                       'id': '1004449',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '8692',
                                                                       'in_octets': '40816328045',
                                                                       'in_ucast_pkts': '156979859',
                                                                       'mac_address': '48:77:46:d2:63:9d',
                                                                       'mtu': 2000,
                                                                       'name': '369/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '5143551',
                                                                       'out_octets': '1251025958867',
                                                                       'out_ucast_pkts': '902384809',
                                                                       'poller_hash': 'N0RBQjVDcGVlcmludGYzNjkvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '369',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5143551',
                                                                       'in_octets': '1251025958867',
                                                                       'in_ucast_pkts': '902384809',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '5143551',
                                                                                                'in_octets': '1251025958867',
                                                                                                'in_ucast_pkts': '902384809',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '8692',
                                                                                                'out_octets': '40816328045',
                                                                                                'out_ucast_pkts': '156979859',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '369/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '8692',
                                                                       'out_octets': '40816328045',
                                                                       'out_ucast_pkts': '156979859',
                                                                       'poller_hash': 'N0RBQjVDcGVlcmludGYzNjkvZ3Ax',
                                                                       'pons': [       {       'description': '369/gp1',
                                                                                               'id': '369',
                                                                                               'links': [       {       'connected_time': '10285708',
                                                                                                                        'fiber_length': 5446,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '369/gp1',
                                                                                               'poller_hash': 'N0RBQjVDcGVlcnBvbjM2OS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 369',
                                         'poller_hash': 'N0RBQjVD',
                                         'serial_number': '7DAB5C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d2:63:9d',
                                         'uptime': '10285708'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:93:04:2b'],
                                                                       'id': '1004513',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '10123',
                                                                       'in_octets': '57445688181',
                                                                       'in_ucast_pkts': '186237188',
                                                                       'mac_address': '48:77:46:d6:1b:7b',
                                                                       'mtu': 2000,
                                                                       'name': '371/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '6000192',
                                                                       'out_octets': '656569545350',
                                                                       'out_ucast_pkts': '509734189',
                                                                       'poller_hash': 'N0UyRUVDcGVlcmludGYzNzEvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '371',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6000192',
                                                                       'in_octets': '656569545350',
                                                                       'in_ucast_pkts': '509734189',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '6000192',
                                                                                                'in_octets': '656569545350',
                                                                                                'in_ucast_pkts': '509734189',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '10123',
                                                                                                'out_octets': '57445688181',
                                                                                                'out_ucast_pkts': '186237188',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '371/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '10123',
                                                                       'out_octets': '57445688181',
                                                                       'out_ucast_pkts': '186237188',
                                                                       'poller_hash': 'N0UyRUVDcGVlcmludGYzNzEvZ3Ax',
                                                                       'pons': [       {       'description': '371/gp1',
                                                                                               'id': '371',
                                                                                               'links': [       {       'connected_time': '11998926',
                                                                                                                        'fiber_length': 5447,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '371/gp1',
                                                                                               'poller_hash': 'N0UyRUVDcGVlcnBvbjM3MS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 371',
                                         'poller_hash': 'N0UyRUVD',
                                         'serial_number': '7E2EEC',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d6:1b:7b',
                                         'uptime': '11998926'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:93:05:1d'],
                                                                       'id': '1004545',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '12950',
                                                                       'in_octets': '116551717912',
                                                                       'in_ucast_pkts': '423640530',
                                                                       'mac_address': '48:77:46:d2:63:b8',
                                                                       'mtu': 2000,
                                                                       'name': '372/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7660790',
                                                                       'out_octets': '2477121976943',
                                                                       'out_ucast_pkts': '1873502070',
                                                                       'poller_hash': 'N0RBQjY1cGVlcmludGYzNzIvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '372',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7660790',
                                                                       'in_octets': '2477121976943',
                                                                       'in_ucast_pkts': '1873502070',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7660790',
                                                                                                'in_octets': '2477121976943',
                                                                                                'in_ucast_pkts': '1873502070',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '12950',
                                                                                                'out_octets': '116551717912',
                                                                                                'out_ucast_pkts': '423640530',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '372/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '12950',
                                                                       'out_octets': '116551717912',
                                                                       'out_ucast_pkts': '423640530',
                                                                       'poller_hash': 'N0RBQjY1cGVlcmludGYzNzIvZ3Ax',
                                                                       'pons': [       {       'description': '372/gp1',
                                                                                               'id': '372',
                                                                                               'links': [       {       'connected_time': '15320149',
                                                                                                                        'fiber_length': 5224,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '372/gp1',
                                                                                               'poller_hash': 'N0RBQjY1cGVlcnBvbjM3Mi9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 372',
                                         'poller_hash': 'N0RBQjY1',
                                         'serial_number': '7DAB65',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d2:63:b8',
                                         'uptime': '15320149'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e6:7e:17'],
                                                                       'id': '1004577',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5534',
                                                                       'in_octets': '265452166030',
                                                                       'in_ucast_pkts': '723370765',
                                                                       'mac_address': '48:77:46:d6:1b:2a',
                                                                       'mtu': 2000,
                                                                       'name': '373/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3279437',
                                                                       'out_octets': '2095548320732',
                                                                       'out_ucast_pkts': '1595184817',
                                                                       'poller_hash': 'N0UyRUQxcGVlcmludGYzNzMvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '373',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3279437',
                                                                       'in_octets': '2095548320732',
                                                                       'in_ucast_pkts': '1595184817',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '3279437',
                                                                                                'in_octets': '2095548320732',
                                                                                                'in_ucast_pkts': '1595184817',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '5534',
                                                                                                'out_octets': '265452166030',
                                                                                                'out_ucast_pkts': '723370765',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '373/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '5534',
                                                                       'out_octets': '265452166030',
                                                                       'out_ucast_pkts': '723370765',
                                                                       'poller_hash': 'N0UyRUQxcGVlcmludGYzNzMvZ3Ax',
                                                                       'pons': [       {       'description': '373/gp1',
                                                                                               'id': '373',
                                                                                               'links': [       {       'connected_time': '6557489',
                                                                                                                        'fiber_length': 4618,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '373/gp1',
                                                                                               'poller_hash': 'N0UyRUQxcGVlcnBvbjM3My9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 373',
                                         'poller_hash': 'N0UyRUQx',
                                         'serial_number': '7E2ED1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d6:1b:2a',
                                         'uptime': '6557489'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e6:2f:c2'],
                                                                       'id': '1004609',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5257',
                                                                       'in_octets': '22875737331',
                                                                       'in_ucast_pkts': '76275939',
                                                                       'mac_address': '48:77:46:d2:63:f4',
                                                                       'mtu': 2000,
                                                                       'name': '374/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3117173',
                                                                       'out_octets': '223285407886',
                                                                       'out_ucast_pkts': '176165384',
                                                                       'poller_hash': 'N0RBQjc5cGVlcmludGYzNzQvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '374',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3117173',
                                                                       'in_octets': '223285407886',
                                                                       'in_ucast_pkts': '176165384',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '3117173',
                                                                                                'in_octets': '223285407886',
                                                                                                'in_ucast_pkts': '176165384',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '5257',
                                                                                                'out_octets': '22875737331',
                                                                                                'out_ucast_pkts': '76275939',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '374/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '5257',
                                                                       'out_octets': '22875737331',
                                                                       'out_ucast_pkts': '76275939',
                                                                       'poller_hash': 'N0RBQjc5cGVlcmludGYzNzQvZ3Ax',
                                                                       'pons': [       {       'description': '374/gp1',
                                                                                               'id': '374',
                                                                                               'links': [       {       'connected_time': '6232878',
                                                                                                                        'fiber_length': 5078,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '374/gp1',
                                                                                               'poller_hash': 'N0RBQjc5cGVlcnBvbjM3NC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 374',
                                         'poller_hash': 'N0RBQjc5',
                                         'serial_number': '7DAB79',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d2:63:f4',
                                         'uptime': '6232878'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:93:05:12'],
                                                                       'id': '1004641',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13026',
                                                                       'in_octets': '22162943386',
                                                                       'in_ucast_pkts': '134564468',
                                                                       'mac_address': '48:77:46:d2:63:ee',
                                                                       'mtu': 2000,
                                                                       'name': '375/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723187',
                                                                       'out_octets': '278982345258',
                                                                       'out_ucast_pkts': '239973445',
                                                                       'poller_hash': 'N0RBQjc3cGVlcmludGYzNzUvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '375',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723187',
                                                                       'in_octets': '278982345258',
                                                                       'in_ucast_pkts': '239973445',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723187',
                                                                                                'in_octets': '278982345258',
                                                                                                'in_ucast_pkts': '239973445',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13026',
                                                                                                'out_octets': '22162943386',
                                                                                                'out_ucast_pkts': '134564468',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '375/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13026',
                                                                       'out_octets': '22162943386',
                                                                       'out_ucast_pkts': '134564468',
                                                                       'poller_hash': 'N0RBQjc3cGVlcmludGYzNzUvZ3Ax',
                                                                       'pons': [       {       'description': '375/gp1',
                                                                                               'id': '375',
                                                                                               'links': [       {       'connected_time': '15445361',
                                                                                                                        'fiber_length': 4481,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '375/gp1',
                                                                                               'poller_hash': 'N0RBQjc3cGVlcnBvbjM3NS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 375',
                                         'poller_hash': 'N0RBQjc3',
                                         'serial_number': '7DAB77',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d2:63:ee',
                                         'uptime': '15445361'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:1b:a7:49'],
                                                                       'id': '1004673',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7383',
                                                                       'in_octets': '74976998788',
                                                                       'in_ucast_pkts': '262706787',
                                                                       'mac_address': '48:77:46:d2:63:c1',
                                                                       'mtu': 2000,
                                                                       'name': '376/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4370990',
                                                                       'out_octets': '1723139241103',
                                                                       'out_ucast_pkts': '1251376943',
                                                                       'poller_hash': 'N0RBQjY4cGVlcmludGYzNzYvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '376',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4370990',
                                                                       'in_octets': '1723139241103',
                                                                       'in_ucast_pkts': '1251376943',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '4370990',
                                                                                                'in_octets': '1723139241103',
                                                                                                'in_ucast_pkts': '1251376943',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '7383',
                                                                                                'out_octets': '74976998788',
                                                                                                'out_ucast_pkts': '262706787',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '376/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7383',
                                                                       'out_octets': '74976998788',
                                                                       'out_ucast_pkts': '262706787',
                                                                       'poller_hash': 'N0RBQjY4cGVlcmludGYzNzYvZ3Ax',
                                                                       'pons': [       {       'description': '376/gp1',
                                                                                               'id': '376',
                                                                                               'links': [       {       'connected_time': '8740552',
                                                                                                                        'fiber_length': 5004,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '376/gp1',
                                                                                               'poller_hash': 'N0RBQjY4cGVlcnBvbjM3Ni9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 376',
                                         'poller_hash': 'N0RBQjY4',
                                         'serial_number': '7DAB68',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d2:63:c1',
                                         'uptime': '8740552'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:1b:a6:fc'],
                                                                       'id': '1004705',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5851',
                                                                       'in_octets': '32602905526',
                                                                       'in_ucast_pkts': '140595457',
                                                                       'mac_address': '48:77:46:d2:63:d6',
                                                                       'mtu': 2000,
                                                                       'name': '377/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3465258',
                                                                       'out_octets': '422006962855',
                                                                       'out_ucast_pkts': '326505000',
                                                                       'poller_hash': 'N0RBQjZGcGVlcmludGYzNzcvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '377',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3465258',
                                                                       'in_octets': '422006962855',
                                                                       'in_ucast_pkts': '326505000',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '3465258',
                                                                                                'in_octets': '422006962855',
                                                                                                'in_ucast_pkts': '326505000',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '5851',
                                                                                                'out_octets': '32602905526',
                                                                                                'out_ucast_pkts': '140595457',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmMxLzIvZ3A0'}],
                                                                       'name': '377/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '5851',
                                                                       'out_octets': '32602905526',
                                                                       'out_ucast_pkts': '140595457',
                                                                       'poller_hash': 'N0RBQjZGcGVlcmludGYzNzcvZ3Ax',
                                                                       'pons': [       {       'description': '377/gp1',
                                                                                               'id': '377',
                                                                                               'links': [       {       'connected_time': '6929047',
                                                                                                                        'fiber_length': 4408,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJjMTIwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '377/gp1',
                                                                                               'poller_hash': 'N0RBQjZGcGVlcnBvbjM3Ny9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 377',
                                         'poller_hash': 'N0RBQjZG',
                                         'serial_number': '7DAB6F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:d2:63:d6',
                                         'uptime': '6929047'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:03:e4:e4'],
                                                                       'id': '1004737',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3288',
                                                                       'in_octets': '887473069496',
                                                                       'in_ucast_pkts': '1977609490',
                                                                       'mac_address': '60:db:98:24:c8:1b',
                                                                       'mtu': 2000,
                                                                       'name': '378/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1948577',
                                                                       'out_octets': '4324449149282',
                                                                       'out_ucast_pkts': '3574456160',
                                                                       'poller_hash': 'QTM0OUYwcGVlcmludGYzNzgvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '378',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1948577',
                                                                       'in_octets': '4324449149282',
                                                                       'in_ucast_pkts': '3574456160',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '1948577',
                                                                                                'in_octets': '4324449149282',
                                                                                                'in_ucast_pkts': '3574456160',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '3288',
                                                                                                'out_octets': '887473069496',
                                                                                                'out_ucast_pkts': '1977609490',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmUxLzIvZ3A2'}],
                                                                       'name': '378/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3288',
                                                                       'out_octets': '887473069496',
                                                                       'out_ucast_pkts': '1977609490',
                                                                       'poller_hash': 'QTM0OUYwcGVlcmludGYzNzgvZ3Ax',
                                                                       'pons': [       {       'description': '378/gp1',
                                                                                               'id': '378',
                                                                                               'links': [       {       'connected_time': '3895683',
                                                                                                                        'fiber_length': 4782,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJlMTIwMDEwMTEw',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '378/gp1',
                                                                                               'poller_hash': 'QTM0OUYwcGVlcnBvbjM3OC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 378',
                                         'poller_hash': 'QTM0OUYw',
                                         'serial_number': 'A349F0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:24:c8:1b',
                                         'uptime': '3895683'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e6:2b:ce'],
                                                                       'id': '1004769',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '12940',
                                                                       'in_octets': '72190794985',
                                                                       'in_ucast_pkts': '143128064',
                                                                       'mac_address': '60:db:98:30:ee:78',
                                                                       'mtu': 2000,
                                                                       'name': '379/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723482',
                                                                       'out_octets': '442628608902',
                                                                       'out_ucast_pkts': '358209919',
                                                                       'poller_hash': 'QTU1QzAxcGVlcmludGYzNzkvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '379',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723482',
                                                                       'in_octets': '442628608902',
                                                                       'in_ucast_pkts': '358209919',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723482',
                                                                                                'in_octets': '442628608902',
                                                                                                'in_ucast_pkts': '358209919',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '12940',
                                                                                                'out_octets': '72190794985',
                                                                                                'out_ucast_pkts': '143128064',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmUxLzIvZ3A2'}],
                                                                       'name': '379/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '12940',
                                                                       'out_octets': '72190794985',
                                                                       'out_ucast_pkts': '143128064',
                                                                       'poller_hash': 'QTU1QzAxcGVlcmludGYzNzkvZ3Ax',
                                                                       'pons': [       {       'description': '379/gp1',
                                                                                               'id': '379',
                                                                                               'links': [       {       'connected_time': '15445563',
                                                                                                                        'fiber_length': 5895,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJlMTIwMDEwMTEw',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '379/gp1',
                                                                                               'poller_hash': 'QTU1QzAxcGVlcnBvbjM3OS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 379',
                                         'poller_hash': 'QTU1QzAx',
                                         'serial_number': 'A55C01',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:30:ee:78',
                                         'uptime': '15445563'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:24:17:b3'],
                                                                       'id': '1004801',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1509',
                                                                       'in_octets': '12116148502',
                                                                       'in_ucast_pkts': '26519213',
                                                                       'mac_address': '60:db:98:25:26:20',
                                                                       'mtu': 2000,
                                                                       'name': '380/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '879782',
                                                                       'out_octets': '96227368369',
                                                                       'out_ucast_pkts': '77876467',
                                                                       'poller_hash': 'QTM2OTQ3cGVlcmludGYzODAvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '380',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '879782',
                                                                       'in_octets': '96227368369',
                                                                       'in_ucast_pkts': '77876467',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '879782',
                                                                                                'in_octets': '96227368369',
                                                                                                'in_ucast_pkts': '77876467',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '1509',
                                                                                                'out_octets': '12116148502',
                                                                                                'out_ucast_pkts': '26519213',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmYxLzIvZ3A3'}],
                                                                       'name': '380/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1509',
                                                                       'out_octets': '12116148502',
                                                                       'out_ucast_pkts': '26519213',
                                                                       'poller_hash': 'QTM2OTQ3cGVlcmludGYzODAvZ3Ax',
                                                                       'pons': [       {       'description': '380/gp1',
                                                                                               'id': '380',
                                                                                               'links': [       {       'connected_time': '1758083',
                                                                                                                        'fiber_length': 4116,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJmMTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '380/gp1',
                                                                                               'poller_hash': 'QTM2OTQ3cGVlcnBvbjM4MC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 380',
                                         'poller_hash': 'QTM2OTQ3',
                                         'serial_number': 'A36947',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:25:26:20',
                                         'uptime': '1758083'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e6:7c:e3'],
                                                                       'id': '1004833',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '623',
                                                                       'in_octets': '8147120708',
                                                                       'in_ucast_pkts': '29727052',
                                                                       'mac_address': '60:db:98:25:25:24',
                                                                       'mtu': 2000,
                                                                       'name': '381/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '361437',
                                                                       'out_octets': '155263278300',
                                                                       'out_ucast_pkts': '117583191',
                                                                       'poller_hash': 'QTM2OEYzcGVlcmludGYzODEvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '381',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '361437',
                                                                       'in_octets': '155263278300',
                                                                       'in_ucast_pkts': '117583191',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '361437',
                                                                                                'in_octets': '155263278300',
                                                                                                'in_ucast_pkts': '117583191',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '623',
                                                                                                'out_octets': '8147120708',
                                                                                                'out_ucast_pkts': '29727052',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YzAxLzIvZ3A4'}],
                                                                       'name': '381/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '623',
                                                                       'out_octets': '8147120708',
                                                                       'out_ucast_pkts': '29727052',
                                                                       'poller_hash': 'QTM2OEYzcGVlcmludGYzODEvZ3Ax',
                                                                       'pons': [       {       'description': '381/gp1',
                                                                                               'id': '381',
                                                                                               'links': [       {       'connected_time': '721389',
                                                                                                                        'fiber_length': 6217,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmMwMTIwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '381/gp1',
                                                                                               'poller_hash': 'QTM2OEYzcGVlcnBvbjM4MS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 381',
                                         'poller_hash': 'QTM2OEYz',
                                         'serial_number': 'A368F3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:25:25:24',
                                         'uptime': '721389'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:24:17:d4'],
                                                                       'id': '1004865',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1492',
                                                                       'in_octets': '29918809750',
                                                                       'in_ucast_pkts': '92828928',
                                                                       'mac_address': '60:db:98:75:fa:a6',
                                                                       'mtu': 2000,
                                                                       'name': '382/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '879789',
                                                                       'out_octets': '354051476100',
                                                                       'out_ucast_pkts': '255120823',
                                                                       'poller_hash': 'QjEyNDY2cGVlcmludGYzODIvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '382',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '879789',
                                                                       'in_octets': '354051476100',
                                                                       'in_ucast_pkts': '255120823',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '879789',
                                                                                                'in_octets': '354051476100',
                                                                                                'in_ucast_pkts': '255120823',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '1492',
                                                                                                'out_octets': '29918809750',
                                                                                                'out_ucast_pkts': '92828928',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmYxLzIvZ3A3'}],
                                                                       'name': '382/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1492',
                                                                       'out_octets': '29918809750',
                                                                       'out_ucast_pkts': '92828928',
                                                                       'poller_hash': 'QjEyNDY2cGVlcmludGYzODIvZ3Ax',
                                                                       'pons': [       {       'description': '382/gp1',
                                                                                               'id': '382',
                                                                                               'links': [       {       'connected_time': '1758097',
                                                                                                                        'fiber_length': 5425,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJmMTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -22.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '382/gp1',
                                                                                               'poller_hash': 'QjEyNDY2cGVlcnBvbjM4Mi9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 382',
                                         'poller_hash': 'QjEyNDY2',
                                         'serial_number': 'B12466',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:75:fa:a6',
                                         'uptime': '1758097'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e6:7e:b1'],
                                                                       'id': '1004897',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1502',
                                                                       'in_octets': '3675520894',
                                                                       'in_ucast_pkts': '20462413',
                                                                       'mac_address': '60:db:98:75:fa:e8',
                                                                       'mtu': 2000,
                                                                       'name': '383/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '879791',
                                                                       'out_octets': '60760945918',
                                                                       'out_ucast_pkts': '49315422',
                                                                       'poller_hash': 'QjEyNDdDcGVlcmludGYzODMvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '383',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '879791',
                                                                       'in_octets': '60760945918',
                                                                       'in_ucast_pkts': '49315422',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '879791',
                                                                                                'in_octets': '60760945918',
                                                                                                'in_ucast_pkts': '49315422',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '1502',
                                                                                                'out_octets': '3675520894',
                                                                                                'out_ucast_pkts': '20462413',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmYxLzIvZ3A3'}],
                                                                       'name': '383/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1502',
                                                                       'out_octets': '3675520894',
                                                                       'out_ucast_pkts': '20462413',
                                                                       'poller_hash': 'QjEyNDdDcGVlcmludGYzODMvZ3Ax',
                                                                       'pons': [       {       'description': '383/gp1',
                                                                                               'id': '383',
                                                                                               'links': [       {       'connected_time': '1758098',
                                                                                                                        'fiber_length': 5026,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJmMTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '383/gp1',
                                                                                               'poller_hash': 'QjEyNDdDcGVlcnBvbjM4My9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 383',
                                         'poller_hash': 'QjEyNDdD',
                                         'serial_number': 'B1247C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:75:fa:e8',
                                         'uptime': '1758098'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:fb:98:63'],
                                                                       'id': '1004929',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '10053',
                                                                       'in_octets': '54994238017',
                                                                       'in_ucast_pkts': '83341728',
                                                                       'mac_address': '60:db:98:8d:a8:7e',
                                                                       'mtu': 2000,
                                                                       'name': '384/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '879789',
                                                                       'out_octets': '396561843770',
                                                                       'out_ucast_pkts': '299114439',
                                                                       'poller_hash': 'QjQ5RUVFcGVlcmludGYzODQvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '384',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '879789',
                                                                       'in_octets': '396561843770',
                                                                       'in_ucast_pkts': '299114439',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '879789',
                                                                                                'in_octets': '396561843770',
                                                                                                'in_ucast_pkts': '299114439',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '10053',
                                                                                                'out_octets': '54994238017',
                                                                                                'out_ucast_pkts': '83341728',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YzAxLzIvZ3A4'}],
                                                                       'name': '384/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '10053',
                                                                       'out_octets': '54994238017',
                                                                       'out_ucast_pkts': '83341728',
                                                                       'poller_hash': 'QjQ5RUVFcGVlcmludGYzODQvZ3Ax',
                                                                       'pons': [       {       'description': '384/gp1',
                                                                                               'id': '384',
                                                                                               'links': [       {       'connected_time': '1758101',
                                                                                                                        'fiber_length': 3595,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmMwMTIwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '384/gp1',
                                                                                               'poller_hash': 'QjQ5RUVFcGVlcnBvbjM4NC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 384',
                                         'poller_hash': 'QjQ5RUVF',
                                         'serial_number': 'B49EEE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:8d:a8:7e',
                                         'uptime': '1758101'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e6:7c:f9'],
                                                                       'id': '1004961',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13823',
                                                                       'in_octets': '48968692953',
                                                                       'in_ucast_pkts': '380679769',
                                                                       'mac_address': '60:db:98:75:fc:50',
                                                                       'mtu': 2000,
                                                                       'name': '385/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '8145800',
                                                                       'out_octets': '1444230624010',
                                                                       'out_ucast_pkts': '1014296483',
                                                                       'poller_hash': 'QjEyNEY0cGVlcmludGYzODUvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '385',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '8145800',
                                                                       'in_octets': '1444230624010',
                                                                       'in_ucast_pkts': '1014296483',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '8145800',
                                                                                                'in_octets': '1444230624010',
                                                                                                'in_ucast_pkts': '1014296483',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13823',
                                                                                                'out_octets': '48968692953',
                                                                                                'out_ucast_pkts': '380679769',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YzAxLzIvZ3A4'}],
                                                                       'name': '385/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13823',
                                                                       'out_octets': '48968692953',
                                                                       'out_ucast_pkts': '380679769',
                                                                       'poller_hash': 'QjEyNEY0cGVlcmludGYzODUvZ3Ax',
                                                                       'pons': [       {       'description': '385/gp1',
                                                                                               'id': '385',
                                                                                               'links': [       {       'connected_time': '16290187',
                                                                                                                        'fiber_length': 2999,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmMwMTIwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -26.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '385/gp1',
                                                                                               'poller_hash': 'QjEyNEY0cGVlcnBvbjM4NS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 385',
                                         'poller_hash': 'QjEyNEY0',
                                         'serial_number': 'B124F4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:75:fc:50',
                                         'uptime': '16290187'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:0e:a7:0a'],
                                                                       'id': '1004993',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13032',
                                                                       'in_octets': '80289101832',
                                                                       'in_ucast_pkts': '266479701',
                                                                       'mac_address': '60:db:98:25:25:d5',
                                                                       'mtu': 2000,
                                                                       'name': '386/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723523',
                                                                       'out_octets': '1053507487724',
                                                                       'out_ucast_pkts': '817518791',
                                                                       'poller_hash': 'QTM2OTJFcGVlcmludGYzODYvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '386',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723523',
                                                                       'in_octets': '1053507487724',
                                                                       'in_ucast_pkts': '817518791',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723523',
                                                                                                'in_octets': '1053507487724',
                                                                                                'in_ucast_pkts': '817518791',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13032',
                                                                                                'out_octets': '80289101832',
                                                                                                'out_ucast_pkts': '266479701',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmIxLzIvZ3Az'}],
                                                                       'name': '386/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13032',
                                                                       'out_octets': '80289101832',
                                                                       'out_ucast_pkts': '266479701',
                                                                       'poller_hash': 'QTM2OTJFcGVlcmludGYzODYvZ3Ax',
                                                                       'pons': [       {       'description': '386/gp1',
                                                                                               'id': '386',
                                                                                               'links': [       {       'connected_time': '15445653',
                                                                                                                        'fiber_length': 4924,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJiMTIwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '386/gp1',
                                                                                               'poller_hash': 'QTM2OTJFcGVlcnBvbjM4Ni9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 386',
                                         'poller_hash': 'QTM2OTJF',
                                         'serial_number': 'A3692E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:25:25:d5',
                                         'uptime': '15445653'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e6:7e:2d'],
                                                                       'id': '1005057',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6437',
                                                                       'in_octets': '200076813191',
                                                                       'in_ucast_pkts': '1162874309',
                                                                       'mac_address': '60:db:98:75:f6:7d',
                                                                       'mtu': 2000,
                                                                       'name': '390/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3811401',
                                                                       'out_octets': '5938177204094',
                                                                       'out_ucast_pkts': '4131439876',
                                                                       'poller_hash': 'QjEyMzAzcGVlcmludGYzOTAvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '390',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3811401',
                                                                       'in_octets': '5938177204094',
                                                                       'in_ucast_pkts': '4131439876',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '3811401',
                                                                                                'in_octets': '5938177204094',
                                                                                                'in_ucast_pkts': '4131439876',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '6437',
                                                                                                'out_octets': '200076813191',
                                                                                                'out_ucast_pkts': '1162874309',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YzAxLzIvZ3A4'}],
                                                                       'name': '390/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '6437',
                                                                       'out_octets': '200076813191',
                                                                       'out_ucast_pkts': '1162874309',
                                                                       'poller_hash': 'QjEyMzAzcGVlcmludGYzOTAvZ3Ax',
                                                                       'pons': [       {       'description': '390/gp1',
                                                                                               'id': '390',
                                                                                               'links': [       {       'connected_time': '7621336',
                                                                                                                        'fiber_length': 3130,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmMwMTIwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '390/gp1',
                                                                                               'poller_hash': 'QjEyMzAzcGVlcnBvbjM5MC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 390',
                                         'poller_hash': 'QjEyMzAz',
                                         'serial_number': 'B12303',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:75:f6:7d',
                                         'uptime': '7621336'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e6:7f:56'],
                                                                       'id': '1005089',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4407',
                                                                       'in_octets': '17542386541',
                                                                       'in_ucast_pkts': '78857616',
                                                                       'mac_address': '60:db:98:75:fc:aa',
                                                                       'mtu': 2000,
                                                                       'name': '392/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1982465',
                                                                       'out_octets': '415625263139',
                                                                       'out_ucast_pkts': '319810959',
                                                                       'poller_hash': 'QjEyNTEycGVlcmludGYzOTIvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '392',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1982465',
                                                                       'in_octets': '415625263139',
                                                                       'in_ucast_pkts': '319810959',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '1982465',
                                                                                                'in_octets': '415625263139',
                                                                                                'in_ucast_pkts': '319810959',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '4407',
                                                                                                'out_octets': '17542386541',
                                                                                                'out_ucast_pkts': '78857616',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YzAxLzIvZ3A4'}],
                                                                       'name': '392/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4407',
                                                                       'out_octets': '17542386541',
                                                                       'out_ucast_pkts': '78857616',
                                                                       'poller_hash': 'QjEyNTEycGVlcmludGYzOTIvZ3Ax',
                                                                       'pons': [       {       'description': '392/gp1',
                                                                                               'id': '392',
                                                                                               'links': [       {       'connected_time': '5975885',
                                                                                                                        'fiber_length': 3068,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmMwMTIwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -22.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '392/gp1',
                                                                                               'poller_hash': 'QjEyNTEycGVlcnBvbjM5Mi9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 392',
                                         'poller_hash': 'QjEyNTEy',
                                         'serial_number': 'B12512',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:75:fc:aa',
                                         'uptime': '5975885'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:24:14:b1'],
                                                                       'id': '1005185',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '17427',
                                                                       'in_octets': '96688362047',
                                                                       'in_ucast_pkts': '232276064',
                                                                       'mac_address': '60:db:98:75:f2:e7',
                                                                       'mtu': 2000,
                                                                       'name': '397/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '10331421',
                                                                       'out_octets': '739885761092',
                                                                       'out_ucast_pkts': '635211083',
                                                                       'poller_hash': 'QjEyMUQxcGVlcmludGYzOTcvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '397',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '10331421',
                                                                       'in_octets': '739885761092',
                                                                       'in_ucast_pkts': '635211083',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '10331421',
                                                                                                'in_octets': '739885761092',
                                                                                                'in_ucast_pkts': '635211083',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '17427',
                                                                                                'out_octets': '96688362047',
                                                                                                'out_ucast_pkts': '232276064',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YjkxLzIvZ3Ax'}],
                                                                       'name': '397/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '17427',
                                                                       'out_octets': '96688362047',
                                                                       'out_ucast_pkts': '232276064',
                                                                       'poller_hash': 'QjEyMUQxcGVlcmludGYzOTcvZ3Ax',
                                                                       'pons': [       {       'description': '397/gp1',
                                                                                               'id': '397',
                                                                                               'links': [       {       'connected_time': '20661455',
                                                                                                                        'fiber_length': 898,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmI5MTIwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '397/gp1',
                                                                                               'poller_hash': 'QjEyMUQxcGVlcnBvbjM5Ny9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 397',
                                         'poller_hash': 'QjEyMUQx',
                                         'serial_number': 'B121D1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:75:f2:e7',
                                         'uptime': '20661455'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:09:6b:ee',
                                                                                                        '84:d3:43:09:6b:ef'],
                                                                       'id': '1005217',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '51',
                                                                       'in_octets': '186608731',
                                                                       'in_ucast_pkts': '1370684',
                                                                       'mac_address': '60:db:98:75:fc:4d',
                                                                       'mtu': 2000,
                                                                       'name': '405/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '6363',
                                                                       'out_octets': '3815339620',
                                                                       'out_ucast_pkts': '2787341',
                                                                       'poller_hash': 'QjEyNEYzcGVlcmludGY0MDUvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '405',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6363',
                                                                       'in_octets': '3815339620',
                                                                       'in_ucast_pkts': '2787341',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '6363',
                                                                                                'in_octets': '3815339620',
                                                                                                'in_ucast_pkts': '2787341',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '51',
                                                                                                'out_octets': '186608731',
                                                                                                'out_ucast_pkts': '1370684',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YzAxLzIvZ3A4'}],
                                                                       'name': '405/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '51',
                                                                       'out_octets': '186608731',
                                                                       'out_ucast_pkts': '1370684',
                                                                       'poller_hash': 'QjEyNEYzcGVlcmludGY0MDUvZ3Ax',
                                                                       'pons': [       {       'description': '405/gp1',
                                                                                               'id': '405',
                                                                                               'links': [       {       'connected_time': '11254',
                                                                                                                        'fiber_length': 6205,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmMwMTIwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '405/gp1',
                                                                                               'poller_hash': 'QjEyNEYzcGVlcnBvbjQwNS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 405',
                                         'poller_hash': 'QjEyNEYz',
                                         'serial_number': 'B124F3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:75:fc:4d',
                                         'uptime': '11254'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:09:6c:f6'],
                                                                       'id': '1005249',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '8358',
                                                                       'in_octets': '59226060623',
                                                                       'in_ucast_pkts': '137549835',
                                                                       'mac_address': '60:db:98:68:88:4e',
                                                                       'mtu': 2000,
                                                                       'name': '407/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4983693',
                                                                       'out_octets': '833896649840',
                                                                       'out_ucast_pkts': '666363730',
                                                                       'poller_hash': 'QUQxODc0cGVlcmludGY0MDcvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '407',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4983693',
                                                                       'in_octets': '833896649840',
                                                                       'in_ucast_pkts': '666363730',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '4983693',
                                                                                                'in_octets': '833896649840',
                                                                                                'in_ucast_pkts': '666363730',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '8358',
                                                                                                'out_octets': '59226060623',
                                                                                                'out_ucast_pkts': '137549835',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmIxLzIvZ3Az'}],
                                                                       'name': '407/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '8358',
                                                                       'out_octets': '59226060623',
                                                                       'out_ucast_pkts': '137549835',
                                                                       'poller_hash': 'QUQxODc0cGVlcmludGY0MDcvZ3Ax',
                                                                       'pons': [       {       'description': '407/gp1',
                                                                                               'id': '407',
                                                                                               'links': [       {       'connected_time': '9965926',
                                                                                                                        'fiber_length': 3262,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJiMTIwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '407/gp1',
                                                                                               'poller_hash': 'QUQxODc0cGVlcnBvbjQwNy9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 407',
                                         'poller_hash': 'QUQxODc0',
                                         'serial_number': 'AD1874',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:68:88:4e',
                                         'uptime': '9965926'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:42:0b:2c'],
                                                                       'id': '1005281',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1491',
                                                                       'in_octets': '31745144119',
                                                                       'in_ucast_pkts': '134313468',
                                                                       'mac_address': '60:db:98:68:81:c4',
                                                                       'mtu': 2000,
                                                                       'name': '417/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '879808',
                                                                       'out_octets': '476451686171',
                                                                       'out_ucast_pkts': '359334556',
                                                                       'poller_hash': 'QUQxNjQ2cGVlcmludGY0MTcvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '417',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '879808',
                                                                       'in_octets': '476451686171',
                                                                       'in_ucast_pkts': '359334556',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '879808',
                                                                                                'in_octets': '476451686171',
                                                                                                'in_ucast_pkts': '359334556',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '1491',
                                                                                                'out_octets': '31745144119',
                                                                                                'out_ucast_pkts': '134313468',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmYxLzIvZ3A3'}],
                                                                       'name': '417/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1491',
                                                                       'out_octets': '31745144119',
                                                                       'out_ucast_pkts': '134313468',
                                                                       'poller_hash': 'QUQxNjQ2cGVlcmludGY0MTcvZ3Ax',
                                                                       'pons': [       {       'description': '417/gp1',
                                                                                               'id': '417',
                                                                                               'links': [       {       'connected_time': '1758147',
                                                                                                                        'fiber_length': 5082,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJmMTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '417/gp1',
                                                                                               'poller_hash': 'QUQxNjQ2cGVlcnBvbjQxNy9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 417',
                                         'poller_hash': 'QUQxNjQ2',
                                         'serial_number': 'AD1646',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:68:81:c4',
                                         'uptime': '1758147'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e6:7e:85'],
                                                                       'id': '1005313',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '569906',
                                                                       'in_octets': '53105572823',
                                                                       'in_ucast_pkts': '509569434',
                                                                       'mac_address': '60:db:98:8e:53:c9',
                                                                       'mtu': 2000,
                                                                       'name': '420/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '879825',
                                                                       'out_octets': '1491793254399',
                                                                       'out_ucast_pkts': '1030625280',
                                                                       'poller_hash': 'QjREODA3cGVlcmludGY0MjAvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '420',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '879825',
                                                                       'in_octets': '1491793254399',
                                                                       'in_ucast_pkts': '1030625280',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '879825',
                                                                                                'in_octets': '1491793254399',
                                                                                                'in_ucast_pkts': '1030625280',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '569906',
                                                                                                'out_octets': '53105572823',
                                                                                                'out_ucast_pkts': '509569434',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmYxLzIvZ3A3'}],
                                                                       'name': '420/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '569906',
                                                                       'out_octets': '53105572823',
                                                                       'out_ucast_pkts': '509569434',
                                                                       'poller_hash': 'QjREODA3cGVlcmludGY0MjAvZ3Ax',
                                                                       'pons': [       {       'description': '420/gp1',
                                                                                               'id': '420',
                                                                                               'links': [       {       'connected_time': '1758180',
                                                                                                                        'fiber_length': 4694,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJmMTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '420/gp1',
                                                                                               'poller_hash': 'QjREODA3cGVlcnBvbjQyMC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 420',
                                         'poller_hash': 'QjREODA3',
                                         'serial_number': 'B4D807',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:8e:53:c9',
                                         'uptime': '1758180'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e6:7a:d3'],
                                                                       'id': '1005377',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1485',
                                                                       'in_octets': '7308004005',
                                                                       'in_ucast_pkts': '39190853',
                                                                       'mac_address': '60:db:98:8e:53:cc',
                                                                       'mtu': 2000,
                                                                       'name': '428/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '879824',
                                                                       'out_octets': '146881368388',
                                                                       'out_ucast_pkts': '104411076',
                                                                       'poller_hash': 'QjREODA4cGVlcmludGY0MjgvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '428',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '879824',
                                                                       'in_octets': '146881368388',
                                                                       'in_ucast_pkts': '104411076',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '879824',
                                                                                                'in_octets': '146881368388',
                                                                                                'in_ucast_pkts': '104411076',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '1485',
                                                                                                'out_octets': '7308004005',
                                                                                                'out_ucast_pkts': '39190853',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmYxLzIvZ3A3'}],
                                                                       'name': '428/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1485',
                                                                       'out_octets': '7308004005',
                                                                       'out_ucast_pkts': '39190853',
                                                                       'poller_hash': 'QjREODA4cGVlcmludGY0MjgvZ3Ax',
                                                                       'pons': [       {       'description': '428/gp1',
                                                                                               'id': '428',
                                                                                               'links': [       {       'connected_time': '1758175',
                                                                                                                        'fiber_length': 5361,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJmMTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '428/gp1',
                                                                                               'poller_hash': 'QjREODA4cGVlcnBvbjQyOC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 428',
                                         'poller_hash': 'QjREODA4',
                                         'serial_number': 'B4D808',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:8e:53:cc',
                                         'uptime': '1758175'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:82:8c:6f'],
                                                                       'id': '1005409',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1487',
                                                                       'in_octets': '914033315',
                                                                       'in_ucast_pkts': '6510802',
                                                                       'mac_address': '60:db:98:8e:53:75',
                                                                       'mtu': 2000,
                                                                       'name': '430/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '879825',
                                                                       'out_octets': '17564535742',
                                                                       'out_ucast_pkts': '14111435',
                                                                       'poller_hash': 'QjREN0VCcGVlcmludGY0MzAvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '430',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '879825',
                                                                       'in_octets': '17564535742',
                                                                       'in_ucast_pkts': '14111435',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '879825',
                                                                                                'in_octets': '17564535742',
                                                                                                'in_ucast_pkts': '14111435',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '1487',
                                                                                                'out_octets': '914033315',
                                                                                                'out_ucast_pkts': '6510802',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmYxLzIvZ3A3'}],
                                                                       'name': '430/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1487',
                                                                       'out_octets': '914033315',
                                                                       'out_ucast_pkts': '6510802',
                                                                       'poller_hash': 'QjREN0VCcGVlcmludGY0MzAvZ3Ax',
                                                                       'pons': [       {       'description': '430/gp1',
                                                                                               'id': '430',
                                                                                               'links': [       {       'connected_time': '1758177',
                                                                                                                        'fiber_length': 5663,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJmMTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '430/gp1',
                                                                                               'poller_hash': 'QjREN0VCcGVlcnBvbjQzMC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 430',
                                         'poller_hash': 'QjREN0VC',
                                         'serial_number': 'B4D7EB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:8e:53:75',
                                         'uptime': '1758177'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:09:6c:bf'],
                                                                       'id': '1005441',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6433',
                                                                       'in_octets': '134745769589',
                                                                       'in_ucast_pkts': '349935860',
                                                                       'mac_address': '60:db:98:68:6c:d9',
                                                                       'mtu': 2000,
                                                                       'name': '432/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3811434',
                                                                       'out_octets': '1321134283345',
                                                                       'out_ucast_pkts': '967935348',
                                                                       'poller_hash': 'QUQwRjREcGVlcmludGY0MzIvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '432',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3811434',
                                                                       'in_octets': '1321134283345',
                                                                       'in_ucast_pkts': '967935348',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '3811434',
                                                                                                'in_octets': '1321134283345',
                                                                                                'in_ucast_pkts': '967935348',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '6433',
                                                                                                'out_octets': '134745769589',
                                                                                                'out_ucast_pkts': '349935860',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YzAxLzIvZ3A4'}],
                                                                       'name': '432/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '6433',
                                                                       'out_octets': '134745769589',
                                                                       'out_ucast_pkts': '349935860',
                                                                       'poller_hash': 'QUQwRjREcGVlcmludGY0MzIvZ3Ax',
                                                                       'pons': [       {       'description': '432/gp1',
                                                                                               'id': '432',
                                                                                               'links': [       {       'connected_time': '7621413',
                                                                                                                        'fiber_length': 3750,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmMwMTIwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '432/gp1',
                                                                                               'poller_hash': 'QUQwRjREcGVlcnBvbjQzMi9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 432',
                                         'poller_hash': 'QUQwRjRE',
                                         'serial_number': 'AD0F4D',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:68:6c:d9',
                                         'uptime': '7621413'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e6:7e:4e'],
                                                                       'id': '1005473',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13070',
                                                                       'in_octets': '129622482716',
                                                                       'in_ucast_pkts': '961931116',
                                                                       'mac_address': '60:db:98:68:87:52',
                                                                       'mtu': 2000,
                                                                       'name': '433/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7723493',
                                                                       'out_octets': '4295847259061',
                                                                       'out_ucast_pkts': '3044256397',
                                                                       'poller_hash': 'QUQxODIwcGVlcmludGY0MzMvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '433',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7723493',
                                                                       'in_octets': '4295847259061',
                                                                       'in_ucast_pkts': '3044256397',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '7723493',
                                                                                                'in_octets': '4295847259061',
                                                                                                'in_ucast_pkts': '3044256397',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13070',
                                                                                                'out_octets': '129622482716',
                                                                                                'out_ucast_pkts': '961931116',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmUxLzIvZ3A2'}],
                                                                       'name': '433/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13070',
                                                                       'out_octets': '129622482716',
                                                                       'out_ucast_pkts': '961931116',
                                                                       'poller_hash': 'QUQxODIwcGVlcmludGY0MzMvZ3Ax',
                                                                       'pons': [       {       'description': '433/gp1',
                                                                                               'id': '433',
                                                                                               'links': [       {       'connected_time': '15445592',
                                                                                                                        'fiber_length': 5983,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJlMTIwMDEwMTEw',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '433/gp1',
                                                                                               'poller_hash': 'QUQxODIwcGVlcnBvbjQzMy9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 433',
                                         'poller_hash': 'QUQxODIw',
                                         'serial_number': 'AD1820',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:68:87:52',
                                         'uptime': '15445592'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e5:8b:e0'],
                                                                       'id': '1005505',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6735',
                                                                       'in_octets': '23267700195',
                                                                       'in_ucast_pkts': '79911018',
                                                                       'mac_address': '60:db:98:25:25:4e',
                                                                       'mtu': 2000,
                                                                       'name': '434/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3977575',
                                                                       'out_octets': '350244933375',
                                                                       'out_ucast_pkts': '271760425',
                                                                       'poller_hash': 'QTM2OTAxcGVlcmludGY0MzQvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '434',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3977575',
                                                                       'in_octets': '350244933375',
                                                                       'in_ucast_pkts': '271760425',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '3977575',
                                                                                                'in_octets': '350244933375',
                                                                                                'in_ucast_pkts': '271760425',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '6735',
                                                                                                'out_octets': '23267700195',
                                                                                                'out_ucast_pkts': '79911018',
                                                                                                'poller_hash': 'Y2M6YmU6NTk6ZGM6NzI6YmQxLzIvZ3A1'}],
                                                                       'name': '434/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '6735',
                                                                       'out_octets': '23267700195',
                                                                       'out_ucast_pkts': '79911018',
                                                                       'poller_hash': 'QTM2OTAxcGVlcmludGY0MzQvZ3Ax',
                                                                       'pons': [       {       'description': '434/gp1',
                                                                                               'id': '434',
                                                                                               'links': [       {       'connected_time': '7953716',
                                                                                                                        'fiber_length': 5480,
                                                                                                                        'poller_hash': 'Y2NiZTU5ZGM3MmJkMTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '434/gp1',
                                                                                               'poller_hash': 'QTM2OTAxcGVlcnBvbjQzNC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 434',
                                         'poller_hash': 'QTM2OTAx',
                                         'serial_number': 'A36901',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '60:db:98:25:25:4e',
                                         'uptime': '7953716'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:09:6b:07',
                                                                                                        '84:d3:43:09:6b:08'],
                                                                       'id': '1005537',
