import os.path
import sys
sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase
 
class TestAlbentiaModels(DeviceTestCase):
    def test_albentia_arba_access_AXS_BS_450_N_GrasshopperM5_18_3_11718_01(self):
        obj = self.run_data("albentia.arba-access.AXS-BS-450-N.GrasshopperM5 18.3.11718.01")
        exp_info = {
                'model': 'AXS-BS-450-N',
                'sta_count': 4,
                'sw_version': 'GrasshopperM5 18.3.11718',
                'vendor': 'Albentia'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '00:1f:4a:00:b9:89': {       'dev_macs': None,
                                             'dl_rssi': -67.0,
                                             'dl_snr': 22.0,
                                             'ip_address': '37.122.216.66',
                                             'mac_address': '00:1f:4a:00:b9:89',
                                             'name': '00:1F:4A:00:B9:89',
                                             'ul_rssi': -68.25,
                                             'ul_snr': 21.0},
                '00:1f:4a:00:ba:62': {       'dev_macs': None,
                                             'dl_rssi': -58.0,
                                             'dl_snr': 24.0,
                                             'ip_address': '100.71.53.25',
                                             'mac_address': '00:1f:4a:00:ba:62',
                                             'name': '00:1F:4A:00:BA:62',
                                             'ul_rssi': -60.75,
                                             'ul_snr': 26.0},
                '00:1f:4a:00:bb:fc': {       'dev_macs': None,
                                             'dl_rssi': -59.0,
                                             'dl_snr': 24.0,
                                             'ip_address': '100.71.53.13',
                                             'mac_address': '00:1f:4a:00:bb:fc',
                                             'name': '00:1F:4A:00:BB:FC',
                                             'ul_rssi': -60.75,
                                             'ul_snr': 25.0},
                '00:1f:4a:01:17:31': {       'dev_macs': None,
                                             'dl_rssi': -54.0,
                                             'dl_snr': 25.0,
                                             'ip_address': '100.71.53.12',
                                             'mac_address': '00:1f:4a:01:17:31',
                                             'name': '00:1F:4A:01:17:31 ',
                                             'ul_rssi': -58.75,
                                             'ul_snr': 26.0}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '240',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2890219088',
                                                              'in_ucast_pkts': '1522383801',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '4226135307',
                                                              'out_ucast_pkts': '659242102',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '3291491031',
                                                              'in_ucast_pkts': '2995758140',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '00:1f:4a:00:b9:89'},
                                                                               {       'mac_address': '00:1f:4a:00:ba:62'},
                                                                               {       'mac_address': '00:1f:4a:00:bb:fc'},
                                                                               {       'mac_address': '00:1f:4a:01:17:31'}],
                                                              'mac_address': '00:1f:4a:00:b9:93',
                                                              'mtu': 1600,
                                                              'name': 'weth',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '4291267872',
                                                              'out_ucast_pkts': '779038186',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:1f:4a:00:b9:89',
                                                                                                                                            'rssi': -68.25,
                                                                                                                                            'snr': 21.0},
                                                                                                                                    {       'mac_address': '00:1f:4a:00:ba:62',
                                                                                                                                            'rssi': -60.75,
                                                                                                                                            'snr': 26.0},
                                                                                                                                    {       'mac_address': '00:1f:4a:00:bb:fc',
                                                                                                                                            'rssi': -60.75,
                                                                                                                                            'snr': 25.0},
                                                                                                                                    {       'mac_address': '00:1f:4a:01:17:31',
                                                                                                                                            'rssi': -58.75,
                                                                                                                                            'snr': 26.0}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Albentia',
                                'model': 'AXS-BS-450-N',
                                'sw_version': 'GrasshopperM5 18.3.11718',
                                'system_mac_address': '00:1f:4a:00:b9:93',
                                'uptime': '12120620'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:1f:4a:00:b9:93'}],
                                                                       'mac_address': '00:1f:4a:00:b9:89',
                                                                       'name': 'weth',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:1f:4a:00:b9:93',
                                                                                                                                                     'rssi': -67.0,
                                                                                                                                                     'snr': 22.0}]}],
                                                                                                 'tx_power': 23}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '37.122.216.66',
                                         'name': '00:1F:4A:00:B9:89',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:1f:4a:00:b9:89'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:1f:4a:00:b9:93'}],
                                                                       'mac_address': '00:1f:4a:00:ba:62',
                                                                       'name': 'weth',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:1f:4a:00:b9:93',
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'snr': 24.0}]}],
                                                                                                 'tx_power': 23}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '100.71.53.25',
                                         'name': '00:1F:4A:00:BA:62',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:1f:4a:00:ba:62'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:1f:4a:00:b9:93'}],
                                                                       'mac_address': '00:1f:4a:00:bb:fc',
                                                                       'name': 'weth',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:1f:4a:00:b9:93',
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'snr': 24.0}]}],
                                                                                                 'tx_power': 23}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '100.71.53.13',
                                         'name': '00:1F:4A:00:BB:FC',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:1f:4a:00:bb:fc'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:1f:4a:00:b9:93'}],
                                                                       'mac_address': '00:1f:4a:01:17:31',
                                                                       'name': 'weth',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:1f:4a:00:b9:93',
                                                                                                                                                     'rssi': -54.0,
                                                                                                                                                     'snr': 25.0}]}],
                                                                                                 'tx_power': 23}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '100.71.53.12',
                                         'name': '00:1F:4A:01:17:31 ',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:1f:4a:01:17:31'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
