import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestTarana(DeviceTestCase):
    def test_tarana_tarana_30_0134_001_0_977_016_00_10_135_132_131(self):
        obj = self.run_data("tarana.tarana.30-0134-001.0.977.016.00.10_135_132_131")
        exp_info = {
                'model': '30-0134-001',
                'sta_count': 14,
                'sw_version': '0.977.016.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S134F1211300003',
                'system_mac_address': None,
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                'S128F1211400031': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 111545078110,
                                           'dl_rf_packets': 81291434,
                                           'ip_address': None,
                                           'name': 'Kieyah_Fyffe',
                                           'serial': 'S128F1211400031',
                                           'serial_number': 'S128F1211400031',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 7359657609,
                                           'ul_rf_packets': 42327105},
                'S128F1211400132': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 10051144497,
                                           'dl_rf_packets': 8820136,
                                           'ip_address': None,
                                           'name': 'Angie_Kroeger',
                                           'serial': 'S128F1211400132',
                                           'serial_number': 'S128F1211400132',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 2733726156,
                                           'ul_rf_packets': 6875524},
                'S128F1211400171': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 702092934,
                                           'dl_rf_packets': 642830,
                                           'ip_address': None,
                                           'name': 'Jennifer_Ray_49051',
                                           'serial': 'S128F1211400171',
                                           'serial_number': 'S128F1211400171',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 78492505,
                                           'ul_rf_packets': 492909},
                'S128F1211500013': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 113867872218,
                                           'dl_rf_packets': 90367207,
                                           'ip_address': None,
                                           'name': 'Savannah_Szymanski',
                                           'serial': 'S128F1211500013',
                                           'serial_number': 'S128F1211500013',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 25475107589,
                                           'ul_rf_packets': 50702193},
                'S128F1211500072': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 82589886935,
                                           'dl_rf_packets': 56608704,
                                           'ip_address': None,
                                           'name': 'Carla_Childers',
                                           'serial': 'S128F1211500072',
                                           'serial_number': 'S128F1211500072',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 2038966760,
                                           'ul_rf_packets': 16098680},
                'S128F1212500234': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 666373607312,
                                           'dl_rf_packets': 472455749,
                                           'ip_address': None,
                                           'name': 'Clayton_Corbett_50530',
                                           'serial': 'S128F1212500234',
                                           'serial_number': 'S128F1212500234',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 25695928166,
                                           'ul_rf_packets': 232755799},
                'S128F1212500548': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 53809661651,
                                           'dl_rf_packets': 43130994,
                                           'ip_address': None,
                                           'name': 'Heather_Sullivan',
                                           'serial': 'S128F1212500548',
                                           'serial_number': 'S128F1212500548',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 3517554304,
                                           'ul_rf_packets': 21470664},
                'S128F1212700257': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 407114452703,
                                           'dl_rf_packets': 280482511,
                                           'ip_address': None,
                                           'name': 'Renee_Dove',
                                           'serial': 'S128F1212700257',
                                           'serial_number': 'S128F1212700257',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 11245769456,
                                           'ul_rf_packets': 126478788},
                'S128F1212800054': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 409924967218,
                                           'dl_rf_packets': 311815755,
                                           'ip_address': None,
                                           'name': 'Danita_Bittle',
                                           'serial': 'S128F1212800054',
                                           'serial_number': 'S128F1212800054',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 17431373891,
                                           'ul_rf_packets': 76981758},
                'S128F1212800154': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 773910937027,
                                           'dl_rf_packets': 696398826,
                                           'ip_address': None,
                                           'name': 'Steve_Brockman_46913',
                                           'serial': 'S128F1212800154',
                                           'serial_number': 'S128F1212800154',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 131531096939,
                                           'ul_rf_packets': 497346328},
                'S128F1212800181': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 242352872853,
                                           'dl_rf_packets': 176246456,
                                           'ip_address': None,
                                           'name': 'Rose_Martin_49117',
                                           'serial': 'S128F1212800181',
                                           'serial_number': 'S128F1212800181',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 12424890198,
                                           'ul_rf_packets': 59148886},
                'S150F2224125595': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 471906591144,
                                           'dl_rf_packets': 318549251,
                                           'ip_address': None,
                                           'name': 'Dustin_Draper_47015',
                                           'serial': 'S150F2224125595',
                                           'serial_number': 'S150F2224125595',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 13864498472,
                                           'ul_rf_packets': 152388342},
                'S150F2224125599': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 48388445836,
                                           'dl_rf_packets': 38263708,
                                           'ip_address': None,
                                           'name': 'Wesley_White_49956',
                                           'serial': 'S150F2224125599',
                                           'serial_number': 'S150F2224125599',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 5264949395,
                                           'ul_rf_packets': 25847714},
                'S150F2224125601': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 90793124384,
                                           'dl_rf_packets': 72503965,
                                           'ip_address': None,
                                           'name': 'Larry_Soles_49451',
                                           'serial': 'S150F2224125601',
                                           'serial_number': 'S150F2224125601',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 15247110856,
                                           'ul_rf_packets': 57147321}
        }
        exp_ne_msg = {
                'data': {       'cpu': 33.412533,
                                'elevation': 336.58,
                                'gps_sats_tracked': 17,
                                'height': 562.0,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '422427',
                                                                                       'in_octets': '7359657609',
                                                                                       'in_ucast_pkts': '42327105',
                                                                                       'out_errors': '1804747',
                                                                                       'out_octets': '111545078110',
                                                                                       'out_ucast_pkts': '81291434',
                                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMDMxMQ=='},
                                                                               {       'in_errors': '1912251',
                                                                                       'in_octets': '11245769456',
                                                                                       'in_ucast_pkts': '126478788',
                                                                                       'out_errors': '9338056',
                                                                                       'out_octets': '407114452703',
                                                                                       'out_ucast_pkts': '280482511',
                                                                                       'poller_hash': 'UzEyOEYxMjEyNzAwMjU3MQ=='},
                                                                               {       'in_errors': '1927202',
                                                                                       'in_octets': '25475107589',
                                                                                       'in_ucast_pkts': '50702193',
                                                                                       'out_errors': '5806455',
                                                                                       'out_octets': '113867872218',
                                                                                       'out_ucast_pkts': '90367207',
                                                                                       'poller_hash': 'UzEyOEYxMjExNTAwMDEzMQ=='},
                                                                               {       'in_errors': '6120175',
                                                                                       'in_octets': '131531096939',
                                                                                       'in_ucast_pkts': '497346328',
                                                                                       'out_errors': '29433563',
                                                                                       'out_octets': '773910937027',
                                                                                       'out_ucast_pkts': '696398826',
                                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTU0MQ=='},
                                                                               {       'in_errors': '397930',
                                                                                       'in_octets': '3517554304',
                                                                                       'in_ucast_pkts': '21470664',
                                                                                       'out_errors': '1921034',
                                                                                       'out_octets': '53809661651',
                                                                                       'out_ucast_pkts': '43130994',
                                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwNTQ4MQ=='},
                                                                               {       'in_errors': '13742',
                                                                                       'in_octets': '78492505',
                                                                                       'in_ucast_pkts': '492909',
                                                                                       'out_errors': '45064',
                                                                                       'out_octets': '702092934',
                                                                                       'out_ucast_pkts': '642830',
                                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMTcxMQ=='},
                                                                               {       'in_errors': '2919236',
                                                                                       'in_octets': '25695928166',
                                                                                       'in_ucast_pkts': '232755799',
                                                                                       'out_errors': '13889372',
                                                                                       'out_octets': '666373607312',
                                                                                       'out_ucast_pkts': '472455749',
                                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwMjM0MQ=='},
                                                                               {       'in_errors': '2119119',
                                                                                       'in_octets': '17431373891',
                                                                                       'in_ucast_pkts': '76981758',
                                                                                       'out_errors': '11193598',
                                                                                       'out_octets': '409924967218',
                                                                                       'out_ucast_pkts': '311815755',
                                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMDU0MQ=='},
                                                                               {       'in_errors': '568332',
                                                                                       'in_octets': '12424890198',
                                                                                       'in_ucast_pkts': '59148886',
                                                                                       'out_errors': '4049822',
                                                                                       'out_octets': '242352872853',
                                                                                       'out_ucast_pkts': '176246456',
                                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTgxMQ=='},
                                                                               {       'in_errors': '90557',
                                                                                       'in_octets': '2733726156',
                                                                                       'in_ucast_pkts': '6875524',
                                                                                       'out_errors': '330964',
                                                                                       'out_octets': '10051144497',
                                                                                       'out_ucast_pkts': '8820136',
                                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMTMyMQ=='},
                                                                               {       'in_errors': '1308940',
                                                                                       'in_octets': '13864498472',
                                                                                       'in_ucast_pkts': '152388342',
                                                                                       'out_errors': '5992835',
                                                                                       'out_octets': '471906591144',
                                                                                       'out_ucast_pkts': '318549251',
                                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NTk1MQ=='},
                                                                               {       'in_errors': '637110',
                                                                                       'in_octets': '15247110856',
                                                                                       'in_ucast_pkts': '57147321',
                                                                                       'out_errors': '3065344',
                                                                                       'out_octets': '90793124384',
                                                                                       'out_ucast_pkts': '72503965',
                                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NjAxMQ=='},
                                                                               {       'in_errors': '414063',
                                                                                       'in_octets': '2038966760',
                                                                                       'in_ucast_pkts': '16098680',
                                                                                       'out_errors': '1229025',
                                                                                       'out_octets': '82589886935',
                                                                                       'out_ucast_pkts': '56608704',
                                                                                       'poller_hash': 'UzEyOEYxMjExNTAwMDcyMQ=='},
                                                                               {       'in_errors': '361262',
                                                                                       'in_octets': '5264949395',
                                                                                       'in_ucast_pkts': '25847714',
                                                                                       'out_errors': '1792137',
                                                                                       'out_octets': '48388445836',
                                                                                       'out_ucast_pkts': '38263708',
                                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NTk5MQ=='}],
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'dl_percent': 82,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5230,
                                                                                        'gps_sync': True,
                                                                                        'id': '0',
                                                                                        'rx_max_interference_noise_ratio': 32.934494,
                                                                                        'rx_max_sensitivity_loss': 0.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '615729',
                                                                                                                                            'distance': 2465,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMDMxMQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '660559',
                                                                                                                                            'distance': 12837,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNzAwMjU3MQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '499379',
                                                                                                                                            'distance': 7148,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNTAwMDEzMQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '13211649',
                                                                                                                                            'distance': 10874,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMTU0MQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '561019',
                                                                                                                                            'distance': 10190,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwNTQ4MQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '26889',
                                                                                                                                            'distance': 14043,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMTcxMQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '6128339',
                                                                                                                                            'distance': 6994,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwMjM0MQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '2796999',
                                                                                                                                            'distance': 6499,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMDU0MQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '670589',
                                                                                                                                            'distance': 9359,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMTgxMQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '589919',
                                                                                                                                            'distance': 2144,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMTMyMQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '517679',
                                                                                                                                            'distance': 3597,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MTI1NTk1MQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '692229',
                                                                                                                                            'distance': 9272,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MTI1NjAxMQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '569469',
                                                                                                                                            'distance': 6492,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNTAwMDcyMQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '662599',
                                                                                                                                            'distance': 3711,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MTI1NTk5MQ==',
                                                                                                                                            'rssi': -83.26275}]}],
                                                                                        'tx_power': 0},
                                                                                {       'chan_width': 40,
                                                                                        'dl_percent': 82,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5805,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'rx_max_interference_noise_ratio': 31.241343,
                                                                                        'rx_max_sensitivity_loss': 0.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '615729',
                                                                                                                                            'distance': 2465,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMDMxMQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '660559',
                                                                                                                                            'distance': 12837,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNzAwMjU3MQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '499379',
                                                                                                                                            'distance': 7148,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNTAwMDEzMQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '13211649',
                                                                                                                                            'distance': 10874,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMTU0MQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '561019',
                                                                                                                                            'distance': 10190,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwNTQ4MQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '26889',
                                                                                                                                            'distance': 14043,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMTcxMQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '6128339',
                                                                                                                                            'distance': 6994,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwMjM0MQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '2796999',
                                                                                                                                            'distance': 6499,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMDU0MQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '670589',
                                                                                                                                            'distance': 9359,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMTgxMQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '589919',
                                                                                                                                            'distance': 2144,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMTMyMQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '517679',
                                                                                                                                            'distance': 3597,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MTI1NTk1MQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '692229',
                                                                                                                                            'distance': 9272,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MTI1NjAxMQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '569469',
                                                                                                                                            'distance': 6492,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNTAwMDcyMQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '662599',
                                                                                                                                            'distance': 3711,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MTI1NTk5MQ==',
                                                                                                                                            'rssi': -82.366684}]}],
                                                                                        'tx_power': -4}],
                                                              'rf_aggregation_groups': [       {       'airtime': 0.5208334,
                                                                                                       'name': 'rf_group'}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '564',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '25080442',
                                                              'in_octets': '38698663489263',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '2358353',
                                                              'out_octets': '3320911369647',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDAzZXgx',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '152',
                                                              'out_octets': '11386',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDAzZXgy'},
                                                      {       'admin_up': True,
                                                              'id': 'gi1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '17434',
                                                              'out_octets': '1228160',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDAzZ2kx'}],
                                'latitude': 38.7607536315918,
                                'longitude': -93.46488952636719,
                                'manufacturer': 'Tarana',
                                'mem': 2.9162247,
                                'model': '30-0134-001',
                                'poller_hash': 'UzEzNEYxMjExMzAwMDAz',
                                'serial_number': 'S134F1211300003',
                                'sw_version': '0.977.016.00',
                                'temperature': 29.125,
                                'uptime': '17481742'},
                'peers': [       {       'cpu': 20.154552,
                                         'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '111545078110',
                                                                       'in_ucast_pkts': '81291434',
                                                                       'links': [       {       'in_octets': '111545078110',
                                                                                                'in_ucast_pkts': '81291434',
                                                                                                'out_octets': '7359657609',
                                                                                                'out_ucast_pkts': '42327105',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '7359657609',
                                                                       'out_ucast_pkts': '42327105',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMDMxMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 33.188564,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 135.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '615729',
                                                                                                                                                     'distance': 2465,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -87.82189}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 8.404329,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 135.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '615729',
                                                                                                                                                     'distance': 2465,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -92.796486}]}],
                                                                                                 'tx_power': 10}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 1.6467513,
                                                                                                                'tx_packet_error_rate': 0.00021413276}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5632',
                                                                       'in_octets': '7359766082',
                                                                       'in_ucast_pkts': '42321173',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '111222722782',
                                                                       'out_ucast_pkts': '81291685',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMDMxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.73887252807617,
                                         'longitude': -93.4662857055664,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0128-001',
                                         'name': 'Kieyah_Fyffe',
                                         'poller_hash': 'UzEyOEYxMjExNDAwMDMx',
                                         'serial_number': 'S128F1211400031',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 13.958,
                                         'uptime': '616070'},
                                 {       'cpu': 20.255016,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '407114452703',
                                                                       'in_ucast_pkts': '280482511',
                                                                       'links': [       {       'in_octets': '407114452703',
                                                                                                'in_ucast_pkts': '280482511',
                                                                                                'out_octets': '11245769456',
                                                                                                'out_ucast_pkts': '126478788',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '11245769456',
                                                                       'out_ucast_pkts': '126478788',
                                                                       'poller_hash': 'UzEyOEYxMjEyNzAwMjU3MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 50.8767,
                                                                                                 'rx_max_sensitivity_loss': 0.3000002,
                                                                                                 'rx_path_loss': 138.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '660559',
                                                                                                                                                     'distance': 12837,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -91.02102}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.7420254,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 138.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '660559',
                                                                                                                                                     'distance': 12837,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -95.4528}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 5.510536,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '763',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6131',
                                                                       'in_octets': '11246419217',
                                                                       'in_ucast_pkts': '126472618',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '405980799892',
                                                                       'out_ucast_pkts': '280475681',
                                                                       'poller_hash': 'UzEyOEYxMjEyNzAwMjU3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.646331787109375,
                                         'longitude': -93.47783660888672,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0128-001',
                                         'name': 'Renee_Dove',
                                         'poller_hash': 'UzEyOEYxMjEyNzAwMjU3',
                                         'serial_number': 'S128F1212700257',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 13.9,
                                         'uptime': '660768'},
                                 {       'cpu': 21.595655,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '113867872218',
                                                                       'in_ucast_pkts': '90367207',
                                                                       'links': [       {       'in_octets': '113867872218',
                                                                                                'in_ucast_pkts': '90367207',
                                                                                                'out_octets': '25475107589',
                                                                                                'out_ucast_pkts': '50702193',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '25475107589',
                                                                       'out_ucast_pkts': '50702193',
                                                                       'poller_hash': 'UzEyOEYxMjExNTAwMDEzMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 32.142952,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 140.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '499379',
                                                                                                                                                     'distance': 7148,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -92.90506}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 30.87093,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 138.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '499379',
                                                                                                                                                     'distance': 7148,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -87.35327}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 13.00416,
                                                                                                                'rx_packet_error_rate': 0.0034482758,
                                                                                                                'tx_interference_signal_ratio': 6.969064,
                                                                                                                'tx_packet_error_rate': 0.0017391305}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '13',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4554',
                                                                       'in_octets': '25485803220',
                                                                       'in_ucast_pkts': '50707390',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '113495461528',
                                                                       'out_ucast_pkts': '90360161',
                                                                       'poller_hash': 'UzEyOEYxMjExNTAwMDEzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.71567916870117,
                                         'longitude': -93.40946960449219,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0128-001',
                                         'name': 'Savannah_Szymanski',
                                         'poller_hash': 'UzEyOEYxMjExNTAwMDEz',
                                         'serial_number': 'S128F1211500013',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 13.088,
                                         'uptime': '499613'},
                                 {       'cpu': 19.87967,
                                         'elevation': 295.5,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '773910937027',
                                                                       'in_ucast_pkts': '696398826',
                                                                       'links': [       {       'in_octets': '773910937027',
                                                                                                'in_ucast_pkts': '696398826',
                                                                                                'out_octets': '131531096939',
                                                                                                'out_ucast_pkts': '497346328',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '131531096939',
                                                                       'out_ucast_pkts': '497346328',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTU0MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 17.130322,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 134.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '13211649',
                                                                                                                                                     'distance': 10874,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -91.802155}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 39.419678,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 134.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '13211649',
                                                                                                                                                     'distance': 10874,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -91.19456}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '32',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '116448',
                                                                       'in_octets': '131534569065',
                                                                       'in_ucast_pkts': '497231985',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '771260519282',
                                                                       'out_ucast_pkts': '696430566',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTU0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.66176223754883,
                                         'longitude': -93.46878051757812,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0128-001',
                                         'name': 'Steve_Brockman_46913',
                                         'poller_hash': 'UzEyOEYxMjEyODAwMTU0',
                                         'serial_number': 'S128F1212800154',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 12.333,
                                         'uptime': '13211868'},
                                 {       'cpu': 20.683191,
                                         'elevation': 12.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '53809661651',
                                                                       'in_ucast_pkts': '43130994',
                                                                       'links': [       {       'in_octets': '53809661651',
                                                                                                'in_ucast_pkts': '43130994',
                                                                                                'out_octets': '3517554304',
                                                                                                'out_ucast_pkts': '21470664',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3517554304',
                                                                       'out_ucast_pkts': '21470664',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwNTQ4MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 50.980167,
                                                                                                 'rx_max_sensitivity_loss': 0.80999994,
                                                                                                 'rx_path_loss': 137.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '561019',
                                                                                                                                                     'distance': 10190,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -91.90199}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.099776,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 137.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '561019',
                                                                                                                                                     'distance': 10190,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -95.10579}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 25.936317,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5082',
                                                                       'in_octets': '3517646983',
                                                                       'in_ucast_pkts': '21465404',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '53634599610',
                                                                       'out_ucast_pkts': '43128758',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwNTQ4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.669837951660156,
                                         'longitude': -93.45140838623047,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0128-001',
                                         'name': 'Heather_Sullivan',
                                         'poller_hash': 'UzEyOEYxMjEyNTAwNTQ4',
                                         'serial_number': 'S128F1212500548',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 12.913,
                                         'uptime': '561235'},
                                 {       'cpu': 18.86753,
                                         'elevation': 7.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '702092934',
                                                                       'in_ucast_pkts': '642830',
                                                                       'links': [       {       'in_octets': '702092934',
                                                                                                'in_ucast_pkts': '642830',
                                                                                                'out_octets': '78492505',
                                                                                                'out_ucast_pkts': '492909',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '78492505',
                                                                       'out_ucast_pkts': '492909',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMTcxMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 27.634466,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '26889',
                                                                                                                                                     'distance': 14043,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -88.71975}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 6.831443,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '26889',
                                                                                                                                                     'distance': 14043,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -97.16272}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 15.948604,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '18',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '128542',
                                                                       'in_octets': '84380312351',
                                                                       'in_ucast_pkts': '539823167',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1338557309709',
                                                                       'out_ucast_pkts': '1029140427',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMTcxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.634849548339844,
                                         'longitude': -93.4756088256836,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7035775,
                                         'model': '30-0128-001',
                                         'name': 'Jennifer_Ray_49051',
                                         'poller_hash': 'UzEyOEYxMjExNDAwMTcx',
                                         'serial_number': 'S128F1211400171',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 12.913,
                                         'uptime': '12954419'},
                                 {       'cpu': 20.758032,
                                         'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '666373607312',
                                                                       'in_ucast_pkts': '472455749',
                                                                       'links': [       {       'in_octets': '666373607312',
                                                                                                'in_ucast_pkts': '472455749',
                                                                                                'out_octets': '25695928166',
                                                                                                'out_ucast_pkts': '232755799',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '25695928166',
                                                                       'out_ucast_pkts': '232755799',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwMjM0MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 16.074371,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 132.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '6128339',
                                                                                                                                                     'distance': 6994,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -87.83722}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 19.747107,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 132.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '6128339',
                                                                                                                                                     'distance': 6994,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -91.97674}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '17',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '53730',
                                                                       'in_octets': '25696902263',
                                                                       'in_ucast_pkts': '232699943',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '664481589399',
                                                                       'out_ucast_pkts': '472467201',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwMjM0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.69669723510742,
                                         'longitude': -93.4757308959961,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0128-001',
                                         'name': 'Clayton_Corbett_50530',
                                         'poller_hash': 'UzEyOEYxMjEyNTAwMjM0',
                                         'serial_number': 'S128F1212500234',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 15.816,
                                         'uptime': '6128560'},
                                 {       'cpu': 19.744823,
                                         'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '409924967218',
                                                                       'in_ucast_pkts': '311815755',
                                                                       'links': [       {       'in_octets': '409924967218',
                                                                                                'in_ucast_pkts': '311815755',
                                                                                                'out_octets': '17431373891',
                                                                                                'out_ucast_pkts': '76981758',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '17431373891',
                                                                       'out_ucast_pkts': '76981758',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMDU0MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.180329,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 141.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2796999',
                                                                                                                                                     'distance': 6499,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -94.69003}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 6.89307,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 141.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2796999',
                                                                                                                                                     'distance': 6499,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -96.19803}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -16.110044,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '25',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '25378',
                                                                       'in_octets': '17432430978',
                                                                       'in_ucast_pkts': '76955912',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '408655748081',
                                                                       'out_ucast_pkts': '311802886',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMDU0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.70980453491211,
                                         'longitude': -93.42867279052734,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0128-001',
                                         'name': 'Danita_Bittle',
                                         'poller_hash': 'UzEyOEYxMjEyODAwMDU0',
                                         'serial_number': 'S128F1212800054',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 16.629,
                                         'uptime': '2797346'},
                                 {       'cpu': 20.692532,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '242352872853',
                                                                       'in_ucast_pkts': '176246456',
                                                                       'links': [       {       'in_octets': '242352872853',
                                                                                                'in_ucast_pkts': '176246456',
                                                                                                'out_octets': '12424890198',
                                                                                                'out_ucast_pkts': '59148886',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '12424890198',
                                                                       'out_ucast_pkts': '59148886',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTgxMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 13.300032,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 132.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '670589',
                                                                                                                                                     'distance': 9359,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -91.707466}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 9.605277,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 133.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '670589',
                                                                                                                                                     'distance': 9359,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -93.05461}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -15.585099,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '13',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '11255',
                                                                       'in_octets': '12425028667',
                                                                       'in_ucast_pkts': '59137467',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '241649723785',
                                                                       'out_ucast_pkts': '176245541',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTgxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.67723083496094,
                                         'longitude': -93.45409393310547,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0128-001',
                                         'name': 'Rose_Martin_49117',
                                         'poller_hash': 'UzEyOEYxMjEyODAwMTgx',
                                         'serial_number': 'S128F1212800181',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 15.526,
                                         'uptime': '670938'},
                                 {       'cpu': 19.563581,
                                         'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '10051144497',
                                                                       'in_ucast_pkts': '8820136',
                                                                       'links': [       {       'in_octets': '10051144497',
                                                                                                'in_ucast_pkts': '8820136',
                                                                                                'out_octets': '2733726156',
                                                                                                'out_ucast_pkts': '6875524',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2733726156',
                                                                       'out_ucast_pkts': '6875524',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMTMyMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 18.273315,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 126.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '589919',
                                                                                                                                                     'distance': 2144,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -84.87994}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 12.92862,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 127.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '589919',
                                                                                                                                                     'distance': 2144,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -87.807106}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5321',
                                                                       'in_octets': '2733846174',
                                                                       'in_ucast_pkts': '6870038',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '10016733287',
                                                                       'out_ucast_pkts': '8820741',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMTMyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.742218017578125,
                                         'longitude': -93.47102355957031,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0128-001',
                                         'name': 'Angie_Kroeger',
                                         'poller_hash': 'UzEyOEYxMjExNDAwMTMy',
                                         'serial_number': 'S128F1211400132',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 10.243,
                                         'uptime': '590142'},
                                 {       'cpu': 20.722528,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '471906591144',
                                                                       'in_ucast_pkts': '318549251',
                                                                       'links': [       {       'in_octets': '471906591144',
                                                                                                'in_ucast_pkts': '318549251',
                                                                                                'out_octets': '13864498472',
                                                                                                'out_ucast_pkts': '152388342',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '13864498472',
                                                                       'out_ucast_pkts': '152388342',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NTk1MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 12.526282,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 128.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '517679',
                                                                                                                                                     'distance': 3597,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -87.77588}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 16.061642,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 127.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '517679',
                                                                                                                                                     'distance': 3597,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -87.16747}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.007518797,
                                                                                                                'tx_interference_signal_ratio': -11.637901,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '382',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '14623',
                                                                       'in_octets': '13865693161',
                                                                       'in_ucast_pkts': '152374767',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '470629734193',
                                                                       'out_ucast_pkts': '318548562',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NTk1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.733699798583984,
                                         'longitude': -93.48733520507812,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0150-001',
                                         'name': 'Dustin_Draper_47015',
                                         'poller_hash': 'UzE1MEYyMjI0MTI1NTk1',
                                         'serial_number': 'S150F2224125595',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 15.352,
                                         'uptime': '517916'},
                                 {       'cpu': 20.981472,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '90793124384',
                                                                       'in_ucast_pkts': '72503965',
                                                                       'links': [       {       'in_octets': '90793124384',
                                                                                                'in_ucast_pkts': '72503965',
                                                                                                'out_octets': '15247110856',
                                                                                                'out_ucast_pkts': '57147321',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '15247110856',
                                                                       'out_ucast_pkts': '57147321',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NjAxMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 43.594646,
                                                                                                 'rx_max_sensitivity_loss': 0.3000002,
                                                                                                 'rx_path_loss': 135.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '692229',
                                                                                                                                                     'distance': 9272,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -88.947586}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 48.555214,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 139.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '692229',
                                                                                                                                                     'distance': 9272,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -95.148315}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 14.205947,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '55675',
                                                                       'in_errors': '50038',
                                                                       'in_nucast_pkts': '6276',
                                                                       'in_octets': '15317417462',
                                                                       'in_ucast_pkts': '57211466',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '90501473019',
                                                                       'out_ucast_pkts': '72503428',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NjAxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.6778564453125,
                                         'longitude': -93.47520446777344,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0150-001',
                                         'name': 'Larry_Soles_49451',
                                         'poller_hash': 'UzE1MEYyMjI0MTI1NjAx',
                                         'serial_number': 'S150F2224125601',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 13.088,
                                         'uptime': '692493'},
                                 {       'cpu': 19.684448,
                                         'elevation': 25.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '82589886935',
                                                                       'in_ucast_pkts': '56608704',
                                                                       'links': [       {       'in_octets': '82589886935',
                                                                                                'in_ucast_pkts': '56608704',
                                                                                                'out_octets': '2038966760',
                                                                                                'out_ucast_pkts': '16098680',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2038966760',
                                                                       'out_ucast_pkts': '16098680',
                                                                       'poller_hash': 'UzEyOEYxMjExNTAwMDcyMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.047847,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 143.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '569469',
                                                                                                                                                     'distance': 6492,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -94.85479}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 41.340603,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 145.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '569469',
                                                                                                                                                     'distance': 6492,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -86.23133}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5255',
                                                                       'in_octets': '2039116077',
                                                                       'in_ucast_pkts': '16093389',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '82363060257',
                                                                       'out_ucast_pkts': '56608690',
                                                                       'poller_hash': 'UzEyOEYxMjExNTAwMDcyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.71841812133789,
                                         'longitude': -93.4135971069336,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0128-001',
                                         'name': 'Carla_Childers',
                                         'poller_hash': 'UzEyOEYxMjExNTAwMDcy',
                                         'serial_number': 'S128F1211500072',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 15.004,
                                         'uptime': '569981'},
                                 {       'cpu': 20.670671,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '48388445836',
                                                                       'in_ucast_pkts': '38263708',
                                                                       'links': [       {       'in_octets': '48388445836',
                                                                                                'in_ucast_pkts': '38263708',
                                                                                                'out_octets': '5264949395',
                                                                                                'out_ucast_pkts': '25847714',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '5264949395',
                                                                       'out_ucast_pkts': '25847714',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NTk5MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 32.61564,
                                                                                                 'rx_max_sensitivity_loss': 0.3000002,
                                                                                                 'rx_path_loss': 126.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '662599',
                                                                                                                                                     'distance': 3711,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -82.56106}]}],
                                                                                                 'tx_power': 3},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 20.366928,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 134.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '662599',
                                                                                                                                                     'distance': 3711,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -94.234314}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 1.5598637,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -0.023837408,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '31',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5955',
                                                                       'in_octets': '5260006478',
                                                                       'in_ucast_pkts': '25836805',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '48233678231',
                                                                       'out_ucast_pkts': '38263311',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NTk5Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.728084564208984,
                                         'longitude': -93.47294616699219,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0150-001',
                                         'name': 'Wesley_White_49956',
                                         'poller_hash': 'UzE1MEYyMjI0MTI1NTk5',
                                         'serial_number': 'S150F2224125599',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 13.784,
                                         'uptime': '662804'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tarana_tarana_30_0134_001_0_988_004_00_10_100_8_14(self):
        obj = self.run_data("tarana.tarana.30-0134-001.0.988.004.00.10_100_8_14")
        exp_info = {
                'model': '30-0134-001',
                'sta_count': 3,
                'sw_version': '0.988.004.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S134F1211300017',
                'system_mac_address': '04:f1:7d:00:25:eb',
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                '04:f1:7d:00:23:b0': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 2556,
                                             'dl_rf_packets': 14,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:23:b0',
                                             'name': '03-WALTON_COUNTY_COURT_HOUSE-FREE-R',
                                             'serial_number': 'S128F1211800086',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 3084441,
                                             'ul_rf_packets': 35078},
                '04:f1:7d:00:28:bd': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 23066481102,
                                             'dl_rf_packets': 25536783,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:28:bd',
                                             'name': '1074-GUARDIAN_AD_LITEM-FREE-R',
                                             'serial_number': 'S128F1211600018',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 2040239347,
                                             'ul_rf_packets': 15781673},
                '04:f1:7d:00:29:1a': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 15173457732,
                                             'dl_rf_packets': 10824924,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:29:1a',
                                             'name': '810-BETH_MOONEY-RES25-R',
                                             'serial_number': 'S128F1211600118',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 762375140,
                                             'ul_rf_packets': 7370516}
        }
        exp_ne_msg = {
                'data': {       'cpu': 30.954504,
                                'elevation': 123.159,
                                'gps_sats_tracked': 14,
                                'height': 45.0,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '599',
                                                                                       'in_octets': '3084441',
                                                                                       'in_ucast_pkts': '35078',
                                                                                       'out_errors': '2695',
                                                                                       'out_octets': '2556',
                                                                                       'out_ucast_pkts': '14',
                                                                                       'poller_hash': 'UzEyOEYxMjExODAwMDg2MQ=='},
                                                                               {       'in_errors': '300',
                                                                                       'in_octets': '2040239347',
                                                                                       'in_ucast_pkts': '15781673',
                                                                                       'out_errors': '117511',
                                                                                       'out_octets': '23066481102',
                                                                                       'out_ucast_pkts': '25536783',
                                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMDE4MQ=='},
                                                                               {       'in_errors': '73024',
                                                                                       'in_octets': '762375140',
                                                                                       'in_ucast_pkts': '7370516',
                                                                                       'out_errors': '543609',
                                                                                       'out_octets': '15173457732',
                                                                                       'out_ucast_pkts': '10824924',
                                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMTE4MQ=='}],
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'dl_percent': 82,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5755,
                                                                                        'gps_sync': True,
                                                                                        'id': '0',
                                                                                        'rx_max_interference_noise_ratio': 26.164675,
                                                                                        'rx_max_sensitivity_loss': 0.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '140076',
                                                                                                                                            'distance': 716,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExODAwMDg2MQ==',
                                                                                                                                            'rssi': -87.32196},
                                                                                                                                    {       'connected_time': '140066',
                                                                                                                                            'distance': 636,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMDE4MQ==',
                                                                                                                                            'rssi': -87.32196},
                                                                                                                                    {       'connected_time': '140066',
                                                                                                                                            'distance': 1092,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMTE4MQ==',
                                                                                                                                            'rssi': -87.32196}]}],
                                                                                        'tx_power': -61},
                                                                                {       'chan_width': 40,
                                                                                        'dl_percent': 82,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5230,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'rx_max_interference_noise_ratio': 30.10134,
                                                                                        'rx_max_sensitivity_loss': 0.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '140076',
                                                                                                                                            'distance': 716,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExODAwMDg2MQ==',
                                                                                                                                            'rssi': -78.134865},
                                                                                                                                    {       'connected_time': '140066',
                                                                                                                                            'distance': 636,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMDE4MQ==',
                                                                                                                                            'rssi': -78.134865},
                                                                                                                                    {       'connected_time': '140066',
                                                                                                                                            'distance': 1092,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMTE4MQ==',
                                                                                                                                            'rssi': -78.134865}]}],
                                                                                        'tx_power': 15}],
                                                              'rf_aggregation_groups': [       {       'airtime': 2.3394456,
                                                                                                       'name': 'rf_group'}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': True,
                                                              'id': 'gi1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '54',
                                                              'out_octets': '4148',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDE3Z2kx'},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '9',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '414291',
                                                              'in_octets': '38381328754',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '63264',
                                                              'out_octets': '4626724732',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDE3ZXgx',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': False,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDE3ZXgy'}],
                                'latitude': 30.71991539001465,
                                'longitude': -86.11815643310547,
                                'manufacturer': 'Tarana',
                                'mem': 2.1208909,
                                'model': '30-0134-001',
                                'poller_hash': 'UzEzNEYxMjExMzAwMDE3',
                                'serial_number': 'S134F1211300017',
                                'sw_version': '0.988.004.00',
                                'system_mac_address': '04:f1:7d:00:25:eb',
                                'temperature': 51.25,
                                'uptime': '140409'},
                'peers': [       {       'cpu': 21.147583,
                                         'elevation': 15.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '2556',
                                                                       'in_ucast_pkts': '14',
                                                                       'links': [       {       'in_octets': '2556',
                                                                                                'in_ucast_pkts': '14',
                                                                                                'out_octets': '3084441',
                                                                                                'out_ucast_pkts': '35078',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3084441',
                                                                       'out_ucast_pkts': '35078',
                                                                       'poller_hash': 'UzEyOEYxMjExODAwMDg2MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 27.18464,
                                                                                                 'rx_max_sensitivity_loss': 0.9299998,
                                                                                                 'rx_path_loss': 110.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '140076',
                                                                                                                                                     'distance': 716,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx',
                                                                                                                                                     'rssi': -71.66321}]}],
                                                                                                 'tx_power': -77},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 19.301258,
                                                                                                 'rx_max_sensitivity_loss': 2.98,
                                                                                                 'rx_path_loss': 112.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '140076',
                                                                                                                                                     'distance': 716,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx',
                                                                                                                                                     'rssi': -69.60998}]}],
                                                                                                 'tx_power': -77}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 6.750889,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '35153',
                                                                       'in_octets': '3116843',
                                                                       'in_ucast_pkts': '10',
                                                                       'mac_address': '04:f1:7d:00:23:b0',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '34120',
                                                                       'out_ucast_pkts': '399',
                                                                       'poller_hash': 'UzEyOEYxMjExODAwMDg2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.721792221069336,
                                         'longitude': -86.11119842529297,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5891033,
                                         'model': '30-0128-001',
                                         'name': '03-WALTON_COUNTY_COURT_HOUSE-FREE-R',
                                         'poller_hash': 'UzEyOEYxMjExODAwMDg2',
                                         'serial_number': 'S128F1211800086',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:23:b0',
                                         'temperature': 24.293,
                                         'uptime': '140430'},
                                 {       'cpu': 23.013287,
                                         'elevation': 5.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '23066481102',
                                                                       'in_ucast_pkts': '25536783',
                                                                       'links': [       {       'in_octets': '23066481102',
                                                                                                'in_ucast_pkts': '25536783',
                                                                                                'out_octets': '2040239347',
                                                                                                'out_ucast_pkts': '15781673',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2040239347',
                                                                       'out_ucast_pkts': '15781673',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMDE4MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.1334214,
                                                                                                 'rx_max_sensitivity_loss': 1.8299999,
                                                                                                 'rx_path_loss': 111.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '140066',
                                                                                                                                                     'distance': 636,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx',
                                                                                                                                                     'rssi': -71.14302}]}],
                                                                                                 'tx_power': -7},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 14.8108835,
                                                                                                 'rx_max_sensitivity_loss': 4.96,
                                                                                                 'rx_path_loss': 111.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '140066',
                                                                                                                                                     'distance': 636,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx',
                                                                                                                                                     'rssi': -67.60989}]}],
                                                                                                 'tx_power': -77}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 8.290967,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 12.12927,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2159583',
                                                                       'in_octets': '63082667566',
                                                                       'in_ucast_pkts': '362354881',
                                                                       'mac_address': '04:f1:7d:00:28:bd',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '578988164771',
                                                                       'out_ucast_pkts': '614897955',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMDE4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.720535278320312,
                                         'longitude': -86.11167907714844,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.816118,
                                         'model': '30-0128-001',
                                         'name': '1074-GUARDIAN_AD_LITEM-FREE-R',
                                         'poller_hash': 'UzEyOEYxMjExNjAwMDE4',
                                         'serial_number': 'S128F1211600018',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:28:bd',
                                         'temperature': 23.887,
                                         'uptime': '8632580'},
                                 {       'cpu': 20.260782,
                                         'elevation': 2.5,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '15173457732',
                                                                       'in_ucast_pkts': '10824924',
                                                                       'links': [       {       'in_octets': '15173457732',
                                                                                                'in_ucast_pkts': '10824924',
                                                                                                'out_octets': '762375140',
                                                                                                'out_ucast_pkts': '7370516',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '762375140',
                                                                       'out_ucast_pkts': '7370516',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMTE4MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 31.097239,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 146.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '140066',
                                                                                                                                                     'distance': 1092,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx',
                                                                                                                                                     'rssi': -79.306335}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 44.558765,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 142.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '140066',
                                                                                                                                                     'distance': 1092,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx',
                                                                                                                                                     'rssi': -82.42502}]}],
                                                                                                 'tx_power': 18}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 11.851149,
                                                                                                                'rx_packet_error_rate': 1.6204041e-05,
                                                                                                                'tx_interference_signal_ratio': 31.699345,
                                                                                                                'tx_packet_error_rate': 0.00032784988}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '14197',
                                                                       'in_octets': '1600579939',
                                                                       'in_ucast_pkts': '14522302',
                                                                       'mac_address': '04:f1:7d:00:29:1a',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '29794304713',
                                                                       'out_ucast_pkts': '21375281',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMTE4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.716629028320312,
                                         'longitude': -86.10767364501953,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5891033,
                                         'model': '30-0128-001',
                                         'name': '810-BETH_MOONEY-RES25-R',
                                         'poller_hash': 'UzEyOEYxMjExNjAwMTE4',
                                         'serial_number': 'S128F1211600118',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:29:1a',
                                         'temperature': 26.616,
                                         'uptime': '275381'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tarana_tarana_30_0134_001_0_997_028_00_10_11_240_91(self):
        obj = self.run_data("tarana.tarana.30-0134-001.0.997.028.00.10_11_240_91")
        exp_info = {
                'model': '30-0134-001',
                'sta_count': 3,
                'sw_version': '0.997.028.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S134F2224809083',
                'system_mac_address': '04:f1:7d:01:4e:3a',
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                '04:f1:7d:01:20:4a': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 51844262121,
                                             'dl_rf_packets': 40922953,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:20:4a',
                                             'name': '11232-RMX6',
                                             'serial_number': 'S150F2224402665',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 3394798411,
                                             'ul_rf_packets': 17435256},
                '04:f1:7d:01:88:39': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 22357725769,
                                             'dl_rf_packets': 18157047,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:88:39',
                                             'name': '7904-CED5',
                                             'serial_number': 'S150F2230121277',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 2624678709,
                                             'ul_rf_packets': 10539180},
                '04:f1:7d:03:59:04': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 15499814885,
                                             'dl_rf_packets': 15062937,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:03:59:04',
                                             'name': '12833-RMX33',
                                             'serial_number': 'S150F2232417671',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 8202864435,
                                             'ul_rf_packets': 10067820}
        }
        exp_ne_msg = {
                'data': {       'cpu': 18.495779,
                                'elevation': 1910.963,
                                'gps_sats_tracked': 21,
                                'height': 0.0,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '253329',
                                                                                       'in_octets': '8202864435',
                                                                                       'in_ucast_pkts': '10067820',
                                                                                       'out_errors': '877516',
                                                                                       'out_octets': '15499814885',
                                                                                       'out_ucast_pkts': '15062937',
                                                                                       'poller_hash': 'UzE1MEYyMjMyNDE3NjcxMQ=='},
                                                                               {       'in_errors': '78439',
                                                                                       'in_octets': '2624678709',
                                                                                       'in_ucast_pkts': '10539180',
                                                                                       'out_errors': '282618',
                                                                                       'out_octets': '22357725769',
                                                                                       'out_ucast_pkts': '18157047',
                                                                                       'poller_hash': 'UzE1MEYyMjMwMTIxMjc3MQ=='},
                                                                               {       'in_errors': '331847',
                                                                                       'in_octets': '3394798411',
                                                                                       'in_ucast_pkts': '17435256',
                                                                                       'out_errors': '1193471',
                                                                                       'out_octets': '51844262121',
                                                                                       'out_ucast_pkts': '40922953',
                                                                                       'poller_hash': 'UzE1MEYyMjI0NDAyNjY1MQ=='}],
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'dl_percent': 80,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5795,
                                                                                        'gps_sync': True,
                                                                                        'id': '0',
                                                                                        'rx_max_interference_noise_ratio': 59.667503,
                                                                                        'rx_max_sensitivity_loss': 3.1,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1087824',
                                                                                                                                            'distance': 2566,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjMyNDE3NjcxMQ==',
                                                                                                                                            'rssi': -73.46582,
                                                                                                                                            'rx_link_rate': '49753937',
                                                                                                                                            'tx_link_rate': '148963828'},
                                                                                                                                    {       'connected_time': '334255',
                                                                                                                                            'distance': 221,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjMwMTIxMjc3MQ==',
                                                                                                                                            'rssi': -73.46582,
                                                                                                                                            'rx_link_rate': '71270453',
                                                                                                                                            'tx_link_rate': '285081812'},
                                                                                                                                    {       'connected_time': '172444',
                                                                                                                                            'distance': 1400,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0NDAyNjY1MQ==',
                                                                                                                                            'rssi': -73.46582,
                                                                                                                                            'rx_link_rate': '39793628',
                                                                                                                                            'tx_link_rate': '78433500'}]}],
                                                                                        'tx_power': 1},
                                                                                {       'chan_width': 40,
                                                                                        'dl_percent': 80,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5230,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'rx_max_interference_noise_ratio': 44.726063,
                                                                                        'rx_max_sensitivity_loss': 0.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1087824',
                                                                                                                                            'distance': 2566,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjMyNDE3NjcxMQ==',
                                                                                                                                            'rssi': -74.25467,
                                                                                                                                            'rx_link_rate': '36491117',
                                                                                                                                            'tx_link_rate': '102934171'},
                                                                                                                                    {       'connected_time': '334255',
                                                                                                                                            'distance': 221,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjMwMTIxMjc3MQ==',
                                                                                                                                            'rssi': -74.25467,
                                                                                                                                            'rx_link_rate': '71070226',
                                                                                                                                            'tx_link_rate': '282486375'},
                                                                                                                                    {       'connected_time': '172444',
                                                                                                                                            'distance': 1400,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0NDAyNjY1MQ==',
                                                                                                                                            'rssi': -74.25467,
                                                                                                                                            'rx_link_rate': '26156505',
                                                                                                                                            'tx_link_rate': '35080667'}]}],
                                                                                        'tx_power': -61}],
                                                              'rf_aggregation_groups': [       {       'airtime': 0.2711777,
                                                                                                       'name': 'rf_group'}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': False,
                                                              'id': 'gi1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzEzNEYyMjI0ODA5MDgzZ2kx'},
                                                      {       'admin_up': False,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzEzNEYyMjI0ODA5MDgzZXgy'},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '142',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '194187132',
                                                              'in_octets': '2782358419665',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '637560',
                                                              'out_octets': '381883912609',
                                                              'poller_hash': 'UzEzNEYyMjI0ODA5MDgzZXgx',
                                                              'speed': '10000000000'}],
                                'latitude': 40.512184143066406,
                                'longitude': -107.54761505126953,
                                'manufacturer': 'Tarana',
                                'mem': 1.7497349,
                                'model': '30-0134-001',
                                'poller_hash': 'UzEzNEYyMjI0ODA5MDgz',
                                'serial_number': 'S134F2224809083',
                                'sw_version': '0.997.028.00',
                                'system_mac_address': '04:f1:7d:01:4e:3a',
                                'temperature': 50.641,
                                'uptime': '6760237'},
                'peers': [       {       'cpu': 21.407686,
                                         'elevation': 0.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '15499814885',
                                                                       'in_ucast_pkts': '15062937',
                                                                       'links': [       {       'in_octets': '15499814885',
                                                                                                'in_ucast_pkts': '15062937',
                                                                                                'out_octets': '8202864435',
                                                                                                'out_ucast_pkts': '10067820',
                                                                                                'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '8202864435',
                                                                       'out_ucast_pkts': '10067820',
                                                                       'poller_hash': 'UzE1MEYyMjMyNDE3NjcxMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 80,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5795,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 40.352093,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 137.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1087824',
                                                                                                                                                     'distance': 2566,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx',
                                                                                                                                                     'rssi': -82.14493,
                                                                                                                                                     'rx_link_rate': '148963828',
                                                                                                                                                     'tx_link_rate': '49753937'}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 80,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 37.56776,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 137.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1087824',
                                                                                                                                                     'distance': 2566,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx',
                                                                                                                                                     'rssi': -73.73435,
                                                                                                                                                     'rx_link_rate': '102934171',
                                                                                                                                                     'tx_link_rate': '36491117'}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 26.29049,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 17.199945,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '225',
                                                                       'in_octets': '8202921099',
                                                                       'in_ucast_pkts': '10067273',
                                                                       'mac_address': '04:f1:7d:03:59:04',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '15868314258',
                                                                       'out_ucast_pkts': '15316198',
                                                                       'poller_hash': 'UzE1MEYyMjMyNDE3NjcxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 40.5145378112793,
                                         'longitude': -107.57792663574219,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.3620886,
                                         'model': '30-0150-001',
                                         'name': '12833-RMX33',
                                         'poller_hash': 'UzE1MEYyMjMyNDE3Njcx',
                                         'serial_number': 'S150F2232417671',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.997.028.00',
                                         'system_mac_address': '04:f1:7d:03:59:04',
                                         'temperature': 28.416,
                                         'uptime': '1088178'},
                                 {       'cpu': 25.426706,
                                         'elevation': 0.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '22357725769',
                                                                       'in_ucast_pkts': '18157047',
                                                                       'links': [       {       'in_octets': '22357725769',
                                                                                                'in_ucast_pkts': '18157047',
                                                                                                'out_octets': '2624678709',
                                                                                                'out_ucast_pkts': '10539180',
                                                                                                'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2624678709',
                                                                       'out_ucast_pkts': '10539180',
                                                                       'poller_hash': 'UzE1MEYyMjMwMTIxMjc3MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 80,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5795,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 25.062023,
                                                                                                 'rx_max_sensitivity_loss': 0.9299998,
                                                                                                 'rx_path_loss': 112.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '334255',
                                                                                                                                                     'distance': 221,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx',
                                                                                                                                                     'rssi': -70.43143,
                                                                                                                                                     'rx_link_rate': '285081812',
                                                                                                                                                     'tx_link_rate': '71270453'}]}],
                                                                                                 'tx_power': -71},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 80,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 27.27884,
                                                                                                 'rx_max_sensitivity_loss': 2.98,
                                                                                                 'rx_path_loss': 109.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '334255',
                                                                                                                                                     'distance': 221,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx',
                                                                                                                                                     'rssi': -65.20434,
                                                                                                                                                     'rx_link_rate': '282486375',
                                                                                                                                                     'tx_link_rate': '71070226'}]}],
                                                                                                 'tx_power': -71}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 25.392645,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 7.3731446,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1009',
                                                                       'in_octets': '2625096890',
                                                                       'in_ucast_pkts': '10539296',
                                                                       'mac_address': '04:f1:7d:01:88:39',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '22470841269',
                                                                       'out_ucast_pkts': '18234590',
                                                                       'poller_hash': 'UzE1MEYyMjMwMTIxMjc3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 40.51382827758789,
                                         'longitude': -107.54873657226562,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.3620886,
                                         'model': '30-0150-001',
                                         'name': '7904-CED5',
                                         'poller_hash': 'UzE1MEYyMjMwMTIxMjc3',
                                         'serial_number': 'S150F2230121277',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.997.028.00',
                                         'system_mac_address': '04:f1:7d:01:88:39',
                                         'temperature': 26.964,
                                         'uptime': '335424'},
                                 {       'cpu': 22.78428,
                                         'elevation': 0.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '51844262121',
                                                                       'in_ucast_pkts': '40922953',
                                                                       'links': [       {       'in_octets': '51844262121',
                                                                                                'in_ucast_pkts': '40922953',
                                                                                                'out_octets': '3394798411',
                                                                                                'out_ucast_pkts': '17435256',
                                                                                                'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3394798411',
                                                                       'out_ucast_pkts': '17435256',
                                                                       'poller_hash': 'UzE1MEYyMjI0NDAyNjY1MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 80,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5795,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 29.553392,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 144.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '172444',
                                                                                                                                                     'distance': 1400,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx',
                                                                                                                                                     'rssi': -85.795685,
                                                                                                                                                     'rx_link_rate': '78433500',
                                                                                                                                                     'tx_link_rate': '39793628'}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 80,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 29.251186,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 139.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '172444',
                                                                                                                                                     'distance': 1400,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx',
                                                                                                                                                     'rssi': -81.82978,
                                                                                                                                                     'rx_link_rate': '35080667',
                                                                                                                                                     'tx_link_rate': '26156505'}]}],
                                                                                                 'tx_power': 18}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 24.54049,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 14.144942,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '9321',
                                                                       'in_octets': '3394940888',
                                                                       'in_ucast_pkts': '17426670',
                                                                       'mac_address': '04:f1:7d:01:20:4a',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '51901315378',
                                                                       'out_ucast_pkts': '40962312',
                                                                       'poller_hash': 'UzE1MEYyMjI0NDAyNjY1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 40.521949768066406,
                                         'longitude': -107.55876159667969,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.3620886,
                                         'model': '30-0150-001',
                                         'name': '11232-RMX6',
                                         'poller_hash': 'UzE1MEYyMjI0NDAyNjY1',
                                         'serial_number': 'S150F2224402665',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.997.028.00',
                                         'system_mac_address': '04:f1:7d:01:20:4a',
                                         'temperature': 28.822,
                                         'uptime': '172760'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tarana_tarana_30_0141_001_0_977_016_00_10_135_112_131(self):
        obj = self.run_data("tarana.tarana.30-0141-001.0.977.016.00.10_135_112_131")
        exp_info = {
                'model': '30-0141-001',
                'sta_count': 25,
                'sw_version': '0.977.016.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S141F2221600607',
                'system_mac_address': None,
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                'S142F1214600005': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 10541395,
                                           'dl_rf_packets': 20044,
                                           'ip_address': None,
                                           'name': 'Raubach_Randy_7106',
                                           'serial': 'S142F1214600005',
                                           'serial_number': 'S142F1214600005',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 3206124,
                                           'ul_rf_packets': 19571},
                'S142F1214700097': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 64307864850,
                                           'dl_rf_packets': 50335423,
                                           'ip_address': None,
                                           'name': 'Matthew_wolfe_20005',
                                           'serial': 'S142F1214700097',
                                           'serial_number': 'S142F1214700097',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 6755180685,
                                           'ul_rf_packets': 27317079},
                'S142F2221006740': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 15656880292,
                                           'dl_rf_packets': 13193016,
                                           'ip_address': None,
                                           'name': 'Admas_Williams',
                                           'serial': 'S142F2221006740',
                                           'serial_number': 'S142F2221006740',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 2526462376,
                                           'ul_rf_packets': 10922741},
                'S142F2221202151': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 49622064821,
                                           'dl_rf_packets': 38667699,
                                           'ip_address': None,
                                           'name': 'Sharon_Pulliam',
                                           'serial': 'S142F2221202151',
                                           'serial_number': 'S142F2221202151',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 2388727454,
                                           'ul_rf_packets': 15395613},
                'S142F2221202454': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 3165611194,
                                           'dl_rf_packets': 2983445,
                                           'ip_address': None,
                                           'name': 'Vernon_Dotson',
                                           'serial': 'S142F2221202454',
                                           'serial_number': 'S142F2221202454',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 443224473,
                                           'ul_rf_packets': 2226695},
                'S142F2221205997': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 217187438084,
                                           'dl_rf_packets': 146838753,
                                           'ip_address': None,
                                           'name': 'Janet_Ronchetto',
                                           'serial': 'S142F2221205997',
                                           'serial_number': 'S142F2221205997',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 7297249822,
                                           'ul_rf_packets': 83954413},
                'S142F2221301987': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 142236663613,
                                           'dl_rf_packets': 101956515,
                                           'ip_address': None,
                                           'name': 'Stephanie_Bennett_13698',
                                           'serial': 'S142F2221301987',
                                           'serial_number': 'S142F2221301987',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 6096513066,
                                           'ul_rf_packets': 55390254},
                'S142F2221400006': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 178741237195,
                                           'dl_rf_packets': 133683367,
                                           'ip_address': None,
                                           'name': 'Carla_Pulliam_7166HQ',
                                           'serial': 'S142F2221400006',
                                           'serial_number': 'S142F2221400006',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 26870197927,
                                           'ul_rf_packets': 65794059},
                'S142F2221400012': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 761039,
                                           'dl_rf_packets': 1731,
                                           'ip_address': None,
                                           'name': 'Richard_Cremer',
                                           'serial': 'S142F2221400012',
                                           'serial_number': 'S142F2221400012',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 546742,
                                           'ul_rf_packets': 1744},
                'S142F2221805235': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 53858265770,
                                           'dl_rf_packets': 40520225,
                                           'ip_address': None,
                                           'name': 'Bryan_Salina',
                                           'serial': 'S142F2221805235',
                                           'serial_number': 'S142F2221805235',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 3739258867,
                                           'ul_rf_packets': 18054637},
                'S142F2221805255': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 1426540191,
                                           'dl_rf_packets': 1308455,
                                           'ip_address': None,
                                           'name': 'Casey_Melissa_17432',
                                           'serial': 'S142F2221805255',
                                           'serial_number': 'S142F2221805255',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 147704358,
                                           'ul_rf_packets': 563327},
                'S142F2221805302': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 70337594941,
                                           'dl_rf_packets': 51919282,
                                           'ip_address': None,
                                           'name': 'Harkins_Jerry_7202',
                                           'serial': 'S142F2221805302',
                                           'serial_number': 'S142F2221805302',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 6716455094,
                                           'ul_rf_packets': 30844468},
                'S142F2221805317': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 43577557139,
                                           'dl_rf_packets': 30695429,
                                           'ip_address': None,
                                           'name': 'marie_craig_9508',
                                           'serial': 'S142F2221805317',
                                           'serial_number': 'S142F2221805317',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 2412734823,
                                           'ul_rf_packets': 23550751},
                'S142F2221805326': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 81050819557,
                                           'dl_rf_packets': 61498541,
                                           'ip_address': None,
                                           'name': 'Ryan_Eaton',
                                           'serial': 'S142F2221805326',
                                           'serial_number': 'S142F2221805326',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 6136387794,
                                           'ul_rf_packets': 30179221},
                'S142F2221805333': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 236310526669,
                                           'dl_rf_packets': 159734063,
                                           'ip_address': None,
                                           'name': 'Jacy_Page',
                                           'serial': 'S142F2221805333',
                                           'serial_number': 'S142F2221805333',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 10266717522,
                                           'ul_rf_packets': 106710238},
                'S142F2221805353': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 42309368327,
                                           'dl_rf_packets': 32414335,
                                           'ip_address': None,
                                           'name': 'Becky_Clay',
                                           'serial': 'S142F2221805353',
                                           'serial_number': 'S142F2221805353',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 2899415558,
                                           'ul_rf_packets': 21577750},
                'S142F2222203668': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 66000619011,
                                           'dl_rf_packets': 51158308,
                                           'ip_address': None,
                                           'name': 'John.Odle',
                                           'serial': 'S142F2222203668',
                                           'serial_number': 'S142F2222203668',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 7113663389,
                                           'ul_rf_packets': 30132741},
                'S142F2222205276': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 85678777250,
                                           'dl_rf_packets': 61728674,
                                           'ip_address': None,
                                           'name': 'Kearney_Ashley',
                                           'serial': 'S142F2222205276',
                                           'serial_number': 'S142F2222205276',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 4382786706,
                                           'ul_rf_packets': 20278567},
                'S142F2222205577': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 59906290788,
                                           'dl_rf_packets': 42209178,
                                           'ip_address': None,
                                           'name': 'Kim_Cabaness',
                                           'serial': 'S142F2222205577',
                                           'serial_number': 'S142F2222205577',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 1968421908,
                                           'ul_rf_packets': 16765697},
                'S142F2222807390': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 53691680803,
                                           'dl_rf_packets': 46120274,
                                           'ip_address': None,
                                           'name': 'jason_adams',
                                           'serial': 'S142F2222807390',
                                           'serial_number': 'S142F2222807390',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 8165532458,
                                           'ul_rf_packets': 29840895},
                'S142F2223100340': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 54200145085,
                                           'dl_rf_packets': 39677626,
                                           'ip_address': None,
                                           'name': 'Kenneth_Martinsen_13662HQ',
                                           'serial': 'S142F2223100340',
                                           'serial_number': 'S142F2223100340',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 2675496251,
                                           'ul_rf_packets': 20933604},
                'S142F2223305916': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 87075149115,
                                           'dl_rf_packets': 64018083,
                                           'ip_address': None,
                                           'name': 'Elijah_Murphey',
                                           'serial': 'S142F2223305916',
                                           'serial_number': 'S142F2223305916',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 4637538241,
                                           'ul_rf_packets': 46564740},
                'S142F2223500125': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 4036644188,
                                           'dl_rf_packets': 3039365,
                                           'ip_address': None,
                                           'name': 'Lauren_Taylor',
                                           'serial': 'S142F2223500125',
                                           'serial_number': 'S142F2223500125',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 282078049,
                                           'ul_rf_packets': 1977449},
                'S142F2223501032': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 52721218288,
                                           'dl_rf_packets': 44128037,
                                           'ip_address': None,
                                           'name': 'Jerry_Suspinac',
                                           'serial': 'S142F2223501032',
                                           'serial_number': 'S142F2223501032',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 7449750477,
                                           'ul_rf_packets': 28830272},
                'S142F2223800692': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 9378763869,
                                           'dl_rf_packets': 7637159,
                                           'ip_address': None,
                                           'name': 'MUTCHEK.JOHN',
                                           'serial': 'S142F2223800692',
                                           'serial_number': 'S142F2223800692',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 849338425,
                                           'ul_rf_packets': 4147433}
        }
        exp_ne_msg = {
                'data': {       'cpu': 53.554134,
                                'elevation': 220.677,
                                'gps_sats_tracked': 18,
                                'height': 290.0,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '1184660',
                                                                                       'in_octets': '2412734823',
                                                                                       'in_ucast_pkts': '23550751',
                                                                                       'out_errors': '738703',
                                                                                       'out_octets': '43577557139',
                                                                                       'out_ucast_pkts': '30695429',
                                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzE3MQ=='},
                                                                               {       'in_errors': '182864',
                                                                                       'in_octets': '1968421908',
                                                                                       'in_ucast_pkts': '16765697',
                                                                                       'out_errors': '651047',
                                                                                       'out_octets': '59906290788',
                                                                                       'out_ucast_pkts': '42209178',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NTc3MQ=='},
                                                                               {       'in_errors': '520469',
                                                                                       'in_octets': '4637538241',
                                                                                       'in_ucast_pkts': '46564740',
                                                                                       'out_errors': '2567673',
                                                                                       'out_octets': '87075149115',
                                                                                       'out_ucast_pkts': '64018083',
                                                                                       'poller_hash': 'UzE0MkYyMjIzMzA1OTE2MQ=='},
                                                                               {       'in_errors': '469806',
                                                                                       'in_octets': '7113663389',
                                                                                       'in_ucast_pkts': '30132741',
                                                                                       'out_errors': '2346140',
                                                                                       'out_octets': '66000619011',
                                                                                       'out_ucast_pkts': '51158308',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMjAzNjY4MQ=='},
                                                                               {       'in_errors': '742592',
                                                                                       'in_octets': '4382786706',
                                                                                       'in_ucast_pkts': '20278567',
                                                                                       'out_errors': '3728832',
                                                                                       'out_octets': '85678777250',
                                                                                       'out_ucast_pkts': '61728674',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1Mjc2MQ=='},
                                                                               {       'in_errors': '556906',
                                                                                       'in_octets': '6136387794',
                                                                                       'in_ucast_pkts': '30179221',
                                                                                       'out_errors': '2571804',
                                                                                       'out_octets': '81050819557',
                                                                                       'out_ucast_pkts': '61498541',
                                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzI2MQ=='},
                                                                               {       'in_errors': '543432',
                                                                                       'in_octets': '3739258867',
                                                                                       'in_ucast_pkts': '18054637',
                                                                                       'out_errors': '2697299',
                                                                                       'out_octets': '53858265770',
                                                                                       'out_ucast_pkts': '40520225',
                                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjM1MQ=='},
                                                                               {       'in_errors': '312397',
                                                                                       'in_octets': '8165532458',
                                                                                       'in_ucast_pkts': '29840895',
                                                                                       'out_errors': '561561',
                                                                                       'out_octets': '53691680803',
                                                                                       'out_ucast_pkts': '46120274',
                                                                                       'poller_hash': 'UzE0MkYyMjIyODA3MzkwMQ=='},
                                                                               {       'in_errors': '24064',
                                                                                       'in_octets': '282078049',
                                                                                       'in_ucast_pkts': '1977449',
                                                                                       'out_errors': '122309',
                                                                                       'out_octets': '4036644188',
                                                                                       'out_ucast_pkts': '3039365',
                                                                                       'poller_hash': 'UzE0MkYyMjIzNTAwMTI1MQ=='},
                                                                               {       'in_errors': '807',
                                                                                       'in_octets': '546742',
                                                                                       'in_ucast_pkts': '1744',
                                                                                       'out_errors': '1863',
                                                                                       'out_octets': '761039',
                                                                                       'out_ucast_pkts': '1731',
                                                                                       'poller_hash': 'UzE0MkYyMjIxNDAwMDEyMQ=='},
                                                                               {       'in_errors': '1317787',
                                                                                       'in_octets': '6716455094',
                                                                                       'in_ucast_pkts': '30844468',
                                                                                       'out_errors': '1349514',
                                                                                       'out_octets': '70337594941',
                                                                                       'out_ucast_pkts': '51919282',
                                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzAyMQ=='},
                                                                               {       'in_errors': '57899',
                                                                                       'in_octets': '849338425',
                                                                                       'in_ucast_pkts': '4147433',
                                                                                       'out_errors': '292426',
                                                                                       'out_octets': '9378763869',
                                                                                       'out_ucast_pkts': '7637159',
                                                                                       'poller_hash': 'UzE0MkYyMjIzODAwNjkyMQ=='},
                                                                               {       'in_errors': '248411',
                                                                                       'in_octets': '7449750477',
                                                                                       'in_ucast_pkts': '28830272',
                                                                                       'out_errors': '25172',
                                                                                       'out_octets': '52721218288',
                                                                                       'out_ucast_pkts': '44128037',
                                                                                       'poller_hash': 'UzE0MkYyMjIzNTAxMDMyMQ=='},
                                                                               {       'in_errors': '162484',
                                                                                       'in_octets': '2526462376',
                                                                                       'in_ucast_pkts': '10922741',
                                                                                       'out_errors': '772221',
                                                                                       'out_octets': '15656880292',
                                                                                       'out_ucast_pkts': '13193016',
                                                                                       'poller_hash': 'UzE0MkYyMjIxMDA2NzQwMQ=='},
                                                                               {       'in_errors': '1244854',
                                                                                       'in_octets': '6096513066',
                                                                                       'in_ucast_pkts': '55390254',
                                                                                       'out_errors': '5652260',
                                                                                       'out_octets': '142236663613',
                                                                                       'out_ucast_pkts': '101956515',
                                                                                       'poller_hash': 'UzE0MkYyMjIxMzAxOTg3MQ=='},
                                                                               {       'in_errors': '203715',
                                                                                       'in_octets': '2899415558',
                                                                                       'in_ucast_pkts': '21577750',
                                                                                       'out_errors': '567864',
                                                                                       'out_octets': '42309368327',
                                                                                       'out_ucast_pkts': '32414335',
                                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzUzMQ=='},
                                                                               {       'in_errors': '399283',
                                                                                       'in_octets': '6755180685',
                                                                                       'in_ucast_pkts': '27317079',
                                                                                       'out_errors': '1718427',
                                                                                       'out_octets': '64307864850',
                                                                                       'out_ucast_pkts': '50335423',
                                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDk3MQ=='},
                                                                               {       'in_errors': '1841907',
                                                                                       'in_octets': '26870197927',
                                                                                       'in_ucast_pkts': '65794059',
                                                                                       'out_errors': '8016163',
                                                                                       'out_octets': '178741237195',
                                                                                       'out_ucast_pkts': '133683367',
                                                                                       'poller_hash': 'UzE0MkYyMjIxNDAwMDA2MQ=='},
                                                                               {       'in_errors': '1195738',
                                                                                       'in_octets': '7297249822',
                                                                                       'in_ucast_pkts': '83954413',
                                                                                       'out_errors': '5641653',
                                                                                       'out_octets': '217187438084',
                                                                                       'out_ucast_pkts': '146838753',
                                                                                       'poller_hash': 'UzE0MkYyMjIxMjA1OTk3MQ=='},
                                                                               {       'in_errors': '796699',
                                                                                       'in_octets': '10266717522',
                                                                                       'in_ucast_pkts': '106710238',
                                                                                       'out_errors': '3784752',
                                                                                       'out_octets': '236310526669',
                                                                                       'out_ucast_pkts': '159734063',
                                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzMzMQ=='},
                                                                               {       'in_errors': '369132',
                                                                                       'in_octets': '2388727454',
                                                                                       'in_ucast_pkts': '15395613',
                                                                                       'out_errors': '1840888',
                                                                                       'out_octets': '49622064821',
                                                                                       'out_ucast_pkts': '38667699',
                                                                                       'poller_hash': 'UzE0MkYyMjIxMjAyMTUxMQ=='},
                                                                               {       'in_errors': '2243',
                                                                                       'in_octets': '3206124',
                                                                                       'in_ucast_pkts': '19571',
                                                                                       'out_errors': '5508',
                                                                                       'out_octets': '10541395',
                                                                                       'out_ucast_pkts': '20044',
                                                                                       'poller_hash': 'UzE0MkYxMjE0NjAwMDA1MQ=='},
                                                                               {       'in_errors': '26674',
                                                                                       'in_octets': '147704358',
                                                                                       'in_ucast_pkts': '563327',
                                                                                       'out_errors': '86317',
                                                                                       'out_octets': '1426540191',
                                                                                       'out_ucast_pkts': '1308455',
                                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjU1MQ=='},
                                                                               {       'in_errors': '100714',
                                                                                       'in_octets': '443224473',
                                                                                       'in_ucast_pkts': '2226695',
                                                                                       'out_errors': '339977',
                                                                                       'out_octets': '3165611194',
                                                                                       'out_ucast_pkts': '2983445',
                                                                                       'poller_hash': 'UzE0MkYyMjIxMjAyNDU0MQ=='},
                                                                               {       'in_errors': '326596',
                                                                                       'in_octets': '2675496251',
                                                                                       'in_ucast_pkts': '20933604',
                                                                                       'out_errors': '1411445',
                                                                                       'out_octets': '54200145085',
                                                                                       'out_ucast_pkts': '39677626',
                                                                                       'poller_hash': 'UzE0MkYyMjIzMTAwMzQwMQ=='}],
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'dl_percent': 82,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 3570,
                                                                                        'gps_sync': True,
                                                                                        'id': '0',
                                                                                        'rx_max_interference_noise_ratio': 28.346535,
                                                                                        'rx_max_sensitivity_loss': 0.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '447298',
                                                                                                                                            'distance': 11034,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MzE3MQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '447248',
                                                                                                                                            'distance': 7296,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjA1NTc3MQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '447198',
                                                                                                                                            'distance': 6251,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMzA1OTE2MQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '447248',
                                                                                                                                            'distance': 7303,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjAzNjY4MQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '447148',
                                                                                                                                            'distance': 1922,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjA1Mjc2MQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '447148',
                                                                                                                                            'distance': 2505,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MzI2MQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '447148',
                                                                                                                                            'distance': 2398,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MjM1MQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '447198',
                                                                                                                                            'distance': 7148,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyODA3MzkwMQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '165898',
                                                                                                                                            'distance': 11852,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNTAwMTI1MQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '1756',
                                                                                                                                            'distance': 7584,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNDAwMDEyMQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '409048',
                                                                                                                                            'distance': 11061,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MzAyMQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '390756',
                                                                                                                                            'distance': 7584,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzODAwNjkyMQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '390756',
                                                                                                                                            'distance': 4093,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNTAxMDMyMQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '390758',
                                                                                                                                            'distance': 2968,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxMDA2NzQwMQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '390756',
                                                                                                                                            'distance': 6371,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxMzAxOTg3MQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '390759',
                                                                                                                                            'distance': 3356,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MzUzMQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '390057',
                                                                                                                                            'distance': 3343,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0NzAwMDk3MQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '389943',
                                                                                                                                            'distance': 5266,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNDAwMDA2MQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '389804',
                                                                                                                                            'distance': 2961,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxMjA1OTk3MQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '389791',
                                                                                                                                            'distance': 3015,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MzMzMQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '389777',
                                                                                                                                            'distance': 5628,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxMjAyMTUxMQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '19791',
                                                                                                                                            'distance': 10565,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0NjAwMDA1MQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '18472',
                                                                                                                                            'distance': 3551,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MjU1MQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '205648',
                                                                                                                                            'distance': 7664,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxMjAyNDU0MQ==',
                                                                                                                                            'rssi': -72.91897},
                                                                                                                                    {       'connected_time': '205348',
                                                                                                                                            'distance': 7403,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMTAwMzQwMQ==',
                                                                                                                                            'rssi': -72.91897}]}],
                                                                                        'tx_power': 30},
                                                                                {       'chan_width': 40,
                                                                                        'dl_percent': 82,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 3640,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'rx_max_interference_noise_ratio': 26.748543,
                                                                                        'rx_max_sensitivity_loss': 0.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '447298',
                                                                                                                                            'distance': 11034,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MzE3MQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '447248',
                                                                                                                                            'distance': 7296,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjA1NTc3MQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '447198',
                                                                                                                                            'distance': 6251,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMzA1OTE2MQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '447248',
                                                                                                                                            'distance': 7303,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjAzNjY4MQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '447148',
                                                                                                                                            'distance': 1922,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjA1Mjc2MQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '447148',
                                                                                                                                            'distance': 2505,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MzI2MQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '447148',
                                                                                                                                            'distance': 2398,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MjM1MQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '447198',
                                                                                                                                            'distance': 7148,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyODA3MzkwMQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '165898',
                                                                                                                                            'distance': 11852,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNTAwMTI1MQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '1756',
                                                                                                                                            'distance': 7584,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNDAwMDEyMQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '409048',
                                                                                                                                            'distance': 11061,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MzAyMQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '390756',
                                                                                                                                            'distance': 7584,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzODAwNjkyMQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '390756',
                                                                                                                                            'distance': 4093,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNTAxMDMyMQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '390758',
                                                                                                                                            'distance': 2968,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxMDA2NzQwMQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '390756',
                                                                                                                                            'distance': 6371,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxMzAxOTg3MQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '390759',
                                                                                                                                            'distance': 3356,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MzUzMQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '390057',
                                                                                                                                            'distance': 3343,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0NzAwMDk3MQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '389943',
                                                                                                                                            'distance': 5266,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNDAwMDA2MQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '389804',
                                                                                                                                            'distance': 2961,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxMjA1OTk3MQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '389791',
                                                                                                                                            'distance': 3015,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MzMzMQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '389777',
                                                                                                                                            'distance': 5628,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxMjAyMTUxMQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '19791',
                                                                                                                                            'distance': 10565,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0NjAwMDA1MQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '18472',
                                                                                                                                            'distance': 3551,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MjU1MQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '205648',
                                                                                                                                            'distance': 7664,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxMjAyNDU0MQ==',
                                                                                                                                            'rssi': -77.20153},
                                                                                                                                    {       'connected_time': '205348',
                                                                                                                                            'distance': 7403,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMTAwMzQwMQ==',
                                                                                                                                            'rssi': -77.20153}]}],
                                                                                        'tx_power': 26}],
                                                              'rf_aggregation_groups': [       {       'airtime': 13.020833,
                                                                                                       'name': 'rf_group'}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '695',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '24513276',
                                                              'in_octets': '1882286607446',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '136204',
                                                              'out_octets': '163120212470',
                                                              'poller_hash': 'UzE0MUYyMjIxNjAwNjA3ZXgx',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': False,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzE0MUYyMjIxNjAwNjA3ZXgy'},
                                                      {       'admin_up': False,
                                                              'id': 'gi1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzE0MUYyMjIxNjAwNjA3Z2kx'}],
                                'latitude': 37.987972259521484,
                                'longitude': -88.8926773071289,
                                'manufacturer': 'Tarana',
                                'mem': 2.2269354,
                                'model': '30-0141-001',
                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3',
                                'serial_number': 'S141F2221600607',
                                'sw_version': '0.977.016.00',
                                'temperature': 53.375,
                                'uptime': '447780'},
                'peers': [       {       'cpu': 20.566784,
                                         'elevation': 15.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '43577557139',
                                                                       'in_ucast_pkts': '30695429',
                                                                       'links': [       {       'in_octets': '43577557139',
                                                                                                'in_ucast_pkts': '30695429',
                                                                                                'out_octets': '2412734823',
                                                                                                'out_ucast_pkts': '23550751',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2412734823',
                                                                       'out_ucast_pkts': '23550751',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzE3MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.9569798,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 136.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447298',
                                                                                                                                                     'distance': 11034,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -86.0101}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 17.08342,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 135.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447298',
                                                                                                                                                     'distance': 11034,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -86.74151}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '4',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '43250',
                                                                       'in_octets': '22388090950',
                                                                       'in_ucast_pkts': '195943138',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '370244929903',
                                                                       'out_ucast_pkts': '268452273',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzE3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.89215087890625,
                                         'longitude': -88.85618591308594,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0142-001',
                                         'name': 'marie_craig_9508',
                                         'poller_hash': 'UzE0MkYyMjIxODA1MzE3',
                                         'serial_number': 'S142F2221805317',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.899,
                                         'uptime': '4727579'},
                                 {       'cpu': 19.736841,
                                         'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '59906290788',
                                                                       'in_ucast_pkts': '42209178',
                                                                       'links': [       {       'in_octets': '59906290788',
                                                                                                'in_ucast_pkts': '42209178',
                                                                                                'out_octets': '1968421908',
                                                                                                'out_ucast_pkts': '16765697',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1968421908',
                                                                       'out_ucast_pkts': '16765697',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NTc3MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 33.442047,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 133.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447248',
                                                                                                                                                     'distance': 7296,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -81.67908}]}],
                                                                                                 'tx_power': -53},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 10.002434,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 133.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447248',
                                                                                                                                                     'distance': 7296,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -82.836365}]}],
                                                                                                 'tx_power': -53}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 2.699189,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '15',
                                                                       'in_errors': '4',
                                                                       'in_nucast_pkts': '70456',
                                                                       'in_octets': '11317103172',
                                                                       'in_ucast_pkts': '99256403',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '385404963266',
                                                                       'out_ucast_pkts': '265006012',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NTc3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.92168426513672,
                                         'longitude': -88.89781951904297,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0142-001',
                                         'name': 'Kim_Cabaness',
                                         'poller_hash': 'UzE0MkYyMjIyMjA1NTc3',
                                         'serial_number': 'S142F2222205577',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.899,
                                         'uptime': '4397957'},
                                 {       'cpu': 19.528704,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '87075149115',
                                                                       'in_ucast_pkts': '64018083',
                                                                       'links': [       {       'in_octets': '87075149115',
                                                                                                'in_ucast_pkts': '64018083',
                                                                                                'out_octets': '4637538241',
                                                                                                'out_ucast_pkts': '46564740',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '4637538241',
                                                                       'out_ucast_pkts': '46564740',
                                                                       'poller_hash': 'UzE0MkYyMjIzMzA1OTE2MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.3889003,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 146.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447198',
                                                                                                                                                     'distance': 6251,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -90.37476}]}],
                                                                                                 'tx_power': 16},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 13.682929,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 144.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447198',
                                                                                                                                                     'distance': 6251,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -90.44348}]}],
                                                                                                 'tx_power': 25}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 11.553722,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 5.0858088,
                                                                                                                'tx_packet_error_rate': 6.437492e-05}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '25',
                                                                       'in_errors': '1',
                                                                       'in_nucast_pkts': '85676',
                                                                       'in_octets': '65086419905',
                                                                       'in_ucast_pkts': '643079224',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1269509601065',
                                                                       'out_ucast_pkts': '920494418',
                                                                       'poller_hash': 'UzE0MkYyMjIzMzA1OTE2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.93168640136719,
                                         'longitude': -88.89076232910156,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7035775,
                                         'model': '30-0142-001',
                                         'name': 'Elijah_Murphey',
                                         'poller_hash': 'UzE0MkYyMjIzMzA1OTE2',
                                         'serial_number': 'S142F2223305916',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.086,
                                         'uptime': '7248940'},
                                 {       'cpu': 19.207508,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '66000619011',
                                                                       'in_ucast_pkts': '51158308',
                                                                       'links': [       {       'in_octets': '66000619011',
                                                                                                'in_ucast_pkts': '51158308',
                                                                                                'out_octets': '7113663389',
                                                                                                'out_ucast_pkts': '30132741',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '7113663389',
                                                                       'out_ucast_pkts': '30132741',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjAzNjY4MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 26.76771,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 142.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447248',
                                                                                                                                                     'distance': 7303,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -86.581566}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 16.012312,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 140.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447248',
                                                                                                                                                     'distance': 7303,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -87.86026}]}],
                                                                                                 'tx_power': 20}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 7.920784,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 11.744523,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '700',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '91484',
                                                                       'in_octets': '155874877711',
                                                                       'in_ucast_pkts': '730032823',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1842164616886',
                                                                       'out_ucast_pkts': '1378501777',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjAzNjY4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.92151641845703,
                                         'longitude': -88.8956069946289,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7603635,
                                         'model': '30-0142-001',
                                         'name': 'John.Odle',
                                         'poller_hash': 'UzE0MkYyMjIyMjAzNjY4',
                                         'serial_number': 'S142F2222203668',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 32.538,
                                         'uptime': '8179474'},
                                 {       'cpu': 19.93988,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '85678777250',
                                                                       'in_ucast_pkts': '61728674',
                                                                       'links': [       {       'in_octets': '85678777250',
                                                                                                'in_ucast_pkts': '61728674',
                                                                                                'out_octets': '4382786706',
                                                                                                'out_ucast_pkts': '20278567',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '4382786706',
                                                                       'out_ucast_pkts': '20278567',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1Mjc2MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.913399,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 142.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447148',
                                                                                                                                                     'distance': 1922,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -88.7185}]}],
                                                                                                 'tx_power': 16},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 12.997916,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 141.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447148',
                                                                                                                                                     'distance': 1922,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -91.02745}]}],
                                                                                                 'tx_power': 20}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 17.82887,
                                                                                                                'rx_packet_error_rate': 0.00065487885,
                                                                                                                'tx_interference_signal_ratio': 1.5220928,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '9',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13638',
                                                                       'in_octets': '14981017731',
                                                                       'in_ucast_pkts': '80953372',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '378148955575',
                                                                       'out_ucast_pkts': '271606912',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1Mjc2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.9760627746582,
                                         'longitude': -88.90961456298828,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Kearney_Ashley',
                                         'poller_hash': 'UzE0MkYyMjIyMjA1Mjc2',
                                         'serial_number': 'S142F2222205276',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.157,
                                         'uptime': '1457055'},
                                 {       'cpu': 18.95,
                                         'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '81050819557',
                                                                       'in_ucast_pkts': '61498541',
                                                                       'links': [       {       'in_octets': '81050819557',
                                                                                                'in_ucast_pkts': '61498541',
                                                                                                'out_octets': '6136387794',
                                                                                                'out_ucast_pkts': '30179221',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '6136387794',
                                                                       'out_ucast_pkts': '30179221',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzI2MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.9977803,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 138.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447148',
                                                                                                                                                     'distance': 2505,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -90.94774}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 9.344116,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 141.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447148',
                                                                                                                                                     'distance': 2505,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -91.22802}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 16.016514,
                                                                                                                'rx_packet_error_rate': 3.4202065e-05,
                                                                                                                'tx_interference_signal_ratio': -7.99399,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '51',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13709',
                                                                       'in_octets': '29759103662',
                                                                       'in_ucast_pkts': '151804368',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '374221517025',
                                                                       'out_ucast_pkts': '293706634',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzI2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.969635009765625,
                                         'longitude': -88.91056823730469,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Ryan_Eaton',
                                         'poller_hash': 'UzE0MkYyMjIxODA1MzI2',
                                         'serial_number': 'S142F2221805326',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.783,
                                         'uptime': '1457060'},
                                 {       'cpu': 19.303955,
                                         'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '53858265770',
                                                                       'in_ucast_pkts': '40520225',
                                                                       'links': [       {       'in_octets': '53858265770',
                                                                                                'in_ucast_pkts': '40520225',
                                                                                                'out_octets': '3739258867',
                                                                                                'out_ucast_pkts': '18054637',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3739258867',
                                                                       'out_ucast_pkts': '18054637',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjM1MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.881923,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 142.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447148',
                                                                                                                                                     'distance': 2398,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -89.845505}]}],
                                                                                                 'tx_power': 21},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 12.328622,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 144.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447148',
                                                                                                                                                     'distance': 2398,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -91.16957}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 24.267424,
                                                                                                                'rx_packet_error_rate': 0.0044247787,
                                                                                                                'tx_interference_signal_ratio': 5.202652,
                                                                                                                'tx_packet_error_rate': 0.009879254}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '29',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13752',
                                                                       'in_octets': '12612268012',
                                                                       'in_ucast_pkts': '66099201',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '196970797281',
                                                                       'out_ucast_pkts': '149518144',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjM1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.97060775756836,
                                         'longitude': -88.91015625,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Bryan_Salina',
                                         'poller_hash': 'UzE0MkYyMjIxODA1MjM1',
                                         'serial_number': 'S142F2221805235',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 37.821,
                                         'uptime': '1457058'},
                                 {       'cpu': 20.363409,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '53691680803',
                                                                       'in_ucast_pkts': '46120274',
                                                                       'links': [       {       'in_octets': '53691680803',
                                                                                                'in_ucast_pkts': '46120274',
                                                                                                'out_octets': '8165532458',
                                                                                                'out_ucast_pkts': '29840895',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '8165532458',
                                                                       'out_ucast_pkts': '29840895',
                                                                       'poller_hash': 'UzE0MkYyMjIyODA3MzkwMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 44.455875,
                                                                                                 'rx_max_sensitivity_loss': 0.3000002,
                                                                                                 'rx_path_loss': 125.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447198',
                                                                                                                                                     'distance': 7148,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -73.01744}]}],
                                                                                                 'tx_power': -56},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 11.860315,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 125.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447198',
                                                                                                                                                     'distance': 7148,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -75.51485}]}],
                                                                                                 'tx_power': -56}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 2.1909816,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 11.666041,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '298',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '36380',
                                                                       'in_octets': '87032157985',
                                                                       'in_ucast_pkts': '322075541',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '872661109114',
                                                                       'out_ucast_pkts': '670127857',
                                                                       'poller_hash': 'UzE0MkYyMjIyODA3MzkwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.922977447509766,
                                         'longitude': -88.89509582519531,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0142-001',
                                         'name': 'jason_adams',
                                         'poller_hash': 'UzE0MkYyMjIyODA3Mzkw',
                                         'serial_number': 'S142F2222807390',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.738,
                                         'uptime': '4017769'},
                                 {       'cpu': 19.85958,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '4036644188',
                                                                       'in_ucast_pkts': '3039365',
                                                                       'links': [       {       'in_octets': '4036644188',
                                                                                                'in_ucast_pkts': '3039365',
                                                                                                'out_octets': '282078049',
                                                                                                'out_ucast_pkts': '1977449',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '282078049',
                                                                       'out_ucast_pkts': '1977449',
                                                                       'poller_hash': 'UzE0MkYyMjIzNTAwMTI1MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 17.154175,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 131.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '165898',
                                                                                                                                                     'distance': 11852,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -75.754906}]}],
                                                                                                 'tx_power': -53},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 46.953716,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 134.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '165898',
                                                                                                                                                     'distance': 11852,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -69.44828}]}],
                                                                                                 'tx_power': -53}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 8.352948,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '23210',
                                                                       'in_octets': '6320704023',
                                                                       'in_ucast_pkts': '43849962',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '111514196278',
                                                                       'out_ucast_pkts': '80342587',
                                                                       'poller_hash': 'UzE0MkYyMjIzNTAwMTI1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.88165283203125,
                                         'longitude': -88.87371826171875,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Lauren_Taylor',
                                         'poller_hash': 'UzE0MkYyMjIzNTAwMTI1',
                                         'serial_number': 'S142F2223500125',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.506,
                                         'uptime': '1549047'},
                                 {       'cpu': 18.40619,
                                         'elevation': 9.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '761039',
                                                                       'in_ucast_pkts': '1731',
                                                                       'links': [       {       'in_octets': '761039',
                                                                                                'in_ucast_pkts': '1731',
                                                                                                'out_octets': '546742',
                                                                                                'out_ucast_pkts': '1744',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '546742',
                                                                       'out_ucast_pkts': '1744',
                                                                       'poller_hash': 'UzE0MkYyMjIxNDAwMDEyMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.894119,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1756',
                                                                                                                                                     'distance': 7584,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -89.8455}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 11.997881,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1756',
                                                                                                                                                     'distance': 7584,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -91.503654}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 18.80889,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '1',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '11464',
                                                                       'in_octets': '321588377',
                                                                       'in_ucast_pkts': '2060780',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3014050691',
                                                                       'out_ucast_pkts': '2628846',
                                                                       'poller_hash': 'UzE0MkYyMjIxNDAwMDEyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.91940689086914,
                                         'longitude': -88.88265228271484,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Richard_Cremer',
                                         'poller_hash': 'UzE0MkYyMjIxNDAwMDEy',
                                         'serial_number': 'S142F2221400012',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 32.073,
                                         'uptime': '205965'},
                                 {       'cpu': 20.11552,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '70337594941',
                                                                       'in_ucast_pkts': '51919282',
                                                                       'links': [       {       'in_octets': '70337594941',
                                                                                                'in_ucast_pkts': '51919282',
                                                                                                'out_octets': '6716455094',
                                                                                                'out_ucast_pkts': '30844468',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '6716455094',
                                                                       'out_ucast_pkts': '30844468',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzAyMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 11.136763,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 135.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '409048',
                                                                                                                                                     'distance': 11061,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -82.2129}]}],
                                                                                                 'tx_power': 23},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 10.829498,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 136.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '409048',
                                                                                                                                                     'distance': 11061,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -84.551735}]}],
                                                                                                 'tx_power': 17}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 9.627324,
                                                                                                                'rx_packet_error_rate': 0.00032258066,
                                                                                                                'tx_interference_signal_ratio': -13.205738,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3704',
                                                                       'in_octets': '6742504101',
                                                                       'in_ucast_pkts': '30875175',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '70120135105',
                                                                       'out_ucast_pkts': '51914672',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzAyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.89228820800781,
                                         'longitude': -88.85506439208984,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Harkins_Jerry_7202',
                                         'poller_hash': 'UzE0MkYyMjIxODA1MzAy',
                                         'serial_number': 'S142F2221805302',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 32.073,
                                         'uptime': '409443'},
                                 {       'cpu': 22.069254,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '9378763869',
                                                                       'in_ucast_pkts': '7637159',
                                                                       'links': [       {       'in_octets': '9378763869',
                                                                                                'in_ucast_pkts': '7637159',
                                                                                                'out_octets': '849338425',
                                                                                                'out_ucast_pkts': '4147433',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '849338425',
                                                                       'out_ucast_pkts': '4147433',
                                                                       'poller_hash': 'UzE0MkYyMjIzODAwNjkyMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 10.60275,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 133.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '390756',
                                                                                                                                                     'distance': 7584,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -83.895676}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.4621773,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 133.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '390756',
                                                                                                                                                     'distance': 7584,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -84.86819}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '1',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3684',
                                                                       'in_octets': '849480531',
                                                                       'in_ucast_pkts': '4143716',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '9348356567',
                                                                       'out_ucast_pkts': '7638815',
                                                                       'poller_hash': 'UzE0MkYyMjIzODAwNjkyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.93523025512695,
                                         'longitude': -88.94892120361328,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'MUTCHEK.JOHN',
                                         'poller_hash': 'UzE0MkYyMjIzODAwNjky',
                                         'serial_number': 'S142F2223800692',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.377,
                                         'uptime': '391263'},
                                 {       'cpu': 21.23302,
                                         'elevation': 5.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '52721218288',
                                                                       'in_ucast_pkts': '44128037',
                                                                       'links': [       {       'in_octets': '52721218288',
                                                                                                'in_ucast_pkts': '44128037',
                                                                                                'out_octets': '7449750477',
                                                                                                'out_ucast_pkts': '28830272',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '7449750477',
                                                                       'out_ucast_pkts': '28830272',
                                                                       'poller_hash': 'UzE0MkYyMjIzNTAxMDMyMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.854785,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 125.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '390756',
                                                                                                                                                     'distance': 4093,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -79.56644}]}],
                                                                                                 'tx_power': -56},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 8.315865,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 126.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '390756',
                                                                                                                                                     'distance': 4093,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -82.24519}]}],
                                                                                                 'tx_power': -56}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3614',
                                                                       'in_octets': '7450417599',
                                                                       'in_ucast_pkts': '28827176',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '52548504947',
                                                                       'out_ucast_pkts': '44129892',
                                                                       'poller_hash': 'UzE0MkYyMjIzNTAxMDMyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.95406723022461,
                                         'longitude': -88.91439819335938,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Jerry_Suspinac',
                                         'poller_hash': 'UzE0MkYyMjIzNTAxMDMy',
                                         'serial_number': 'S142F2223501032',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.783,
                                         'uptime': '391278'},
                                 {       'cpu': 19.53663,
                                         'elevation': 2.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '15656880292',
                                                                       'in_ucast_pkts': '13193016',
                                                                       'links': [       {       'in_octets': '15656880292',
                                                                                                'in_ucast_pkts': '13193016',
                                                                                                'out_octets': '2526462376',
                                                                                                'out_ucast_pkts': '10922741',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2526462376',
                                                                       'out_ucast_pkts': '10922741',
                                                                       'poller_hash': 'UzE0MkYyMjIxMDA2NzQwMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.052652,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 149.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '390758',
                                                                                                                                                     'distance': 2968,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -92.171196}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.4377694,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 144.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '390758',
                                                                                                                                                     'distance': 2968,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -92.879105}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3601',
                                                                       'in_octets': '2527500534',
                                                                       'in_ucast_pkts': '10920253',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '15597854002',
                                                                       'out_ucast_pkts': '13189677',
                                                                       'poller_hash': 'UzE0MkYyMjIxMDA2NzQwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.96778869628906,
                                         'longitude': -88.915771484375,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Admas_Williams',
                                         'poller_hash': 'UzE0MkYyMjIxMDA2NzQw',
                                         'serial_number': 'S142F2221006740',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.086,
                                         'uptime': '391253'},
                                 {       'cpu': 20.848131,
                                         'elevation': 2.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '142236663613',
                                                                       'in_ucast_pkts': '101956515',
                                                                       'links': [       {       'in_octets': '142236663613',
                                                                                                'in_ucast_pkts': '101956515',
                                                                                                'out_octets': '6096513066',
                                                                                                'out_ucast_pkts': '55390254',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '6096513066',
                                                                       'out_ucast_pkts': '55390254',
                                                                       'poller_hash': 'UzE0MkYyMjIxMzAxOTg3MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.917364,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 148.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '390756',
                                                                                                                                                     'distance': 6371,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -90.01293}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 8.323339,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 149.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '390756',
                                                                                                                                                     'distance': 6371,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -92.035736}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 17.153866,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -4.7480965,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '85',
                                                                       'in_errors': '46',
                                                                       'in_nucast_pkts': '3583',
                                                                       'in_octets': '6100170936',
                                                                       'in_ucast_pkts': '55391550',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '141814132983',
                                                                       'out_ucast_pkts': '101945503',
                                                                       'poller_hash': 'UzE0MkYyMjIxMzAxOTg3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.94938278198242,
                                         'longitude': -88.94747924804688,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Stephanie_Bennett_13698',
                                         'poller_hash': 'UzE0MkYyMjIxMzAxOTg3',
                                         'serial_number': 'S142F2221301987',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.912,
                                         'uptime': '391256'},
                                 {       'cpu': 20.580256,
                                         'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '42309368327',
                                                                       'in_ucast_pkts': '32414335',
                                                                       'links': [       {       'in_octets': '42309368327',
                                                                                                'in_ucast_pkts': '32414335',
                                                                                                'out_octets': '2899415558',
                                                                                                'out_ucast_pkts': '21577750',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2899415558',
                                                                       'out_ucast_pkts': '21577750',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzUzMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.643004,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 131.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '390759',
                                                                                                                                                     'distance': 3356,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -83.431335}]}],
                                                                                                 'tx_power': -53},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.882551,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 130.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '390759',
                                                                                                                                                     'distance': 3356,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -84.036385}]}],
                                                                                                 'tx_power': -53}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 10.992263,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3676',
                                                                       'in_octets': '2902062498',
                                                                       'in_ucast_pkts': '21579115',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '42179185102',
                                                                       'out_ucast_pkts': '32415508',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzUzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.96281433105469,
                                         'longitude': -88.91524505615234,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Becky_Clay',
                                         'poller_hash': 'UzE0MkYyMjIxODA1MzUz',
                                         'serial_number': 'S142F2221805353',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 32.886,
                                         'uptime': '391272'},
                                 {       'cpu': 20.912739,
                                         'elevation': 3.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '64307864850',
                                                                       'in_ucast_pkts': '50335423',
                                                                       'links': [       {       'in_octets': '64307864850',
                                                                                                'in_ucast_pkts': '50335423',
                                                                                                'out_octets': '6755180685',
                                                                                                'out_ucast_pkts': '27317079',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '6755180685',
                                                                       'out_ucast_pkts': '27317079',
                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDk3MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.7207327,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 145.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '390057',
                                                                                                                                                     'distance': 3343,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -89.42012}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.8549986,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 144.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '390057',
                                                                                                                                                     'distance': 3343,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -91.32107}]}],
                                                                                                 'tx_power': 18}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 8.728821,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -4.942441,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '5',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3860',
                                                                       'in_octets': '6755792322',
                                                                       'in_ucast_pkts': '27313830',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '64111357100',
                                                                       'out_ucast_pkts': '50336490',
                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDk3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.97086715698242,
                                         'longitude': -88.9247055053711,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Matthew_wolfe_20005',
                                         'poller_hash': 'UzE0MkYxMjE0NzAwMDk3',
                                         'serial_number': 'S142F1214700097',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 32.248,
                                         'uptime': '391282'},
                                 {       'cpu': 18.692564,
                                         'elevation': 7.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '178741237195',
                                                                       'in_ucast_pkts': '133683367',
                                                                       'links': [       {       'in_octets': '178741237195',
                                                                                                'in_ucast_pkts': '133683367',
                                                                                                'out_octets': '26870197927',
                                                                                                'out_ucast_pkts': '65794059',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '26870197927',
                                                                       'out_ucast_pkts': '65794059',
                                                                       'poller_hash': 'UzE0MkYyMjIxNDAwMDA2MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.7491136,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 145.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '389943',
                                                                                                                                                     'distance': 5266,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -90.42638}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.872594,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 149.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '389943',
                                                                                                                                                     'distance': 5266,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -92.97241}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 17.00372,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '6',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '174',
                                                                       'in_octets': '26872960301',
                                                                       'in_ucast_pkts': '65795547',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '178195949499',
                                                                       'out_ucast_pkts': '133672782',
                                                                       'poller_hash': 'UzE0MkYyMjIxNDAwMDA2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.94259262084961,
                                         'longitude': -88.91342163085938,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Carla_Pulliam_7166HQ',
                                         'poller_hash': 'UzE0MkYyMjIxNDAwMDA2',
                                         'serial_number': 'S142F2221400006',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.377,
                                         'uptime': '391275'},
                                 {       'cpu': 18.55283,
                                         'elevation': 2.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '217187438084',
                                                                       'in_ucast_pkts': '146838753',
                                                                       'links': [       {       'in_octets': '217187438084',
                                                                                                'in_ucast_pkts': '146838753',
                                                                                                'out_octets': '7297249822',
                                                                                                'out_ucast_pkts': '83954413',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '7297249822',
                                                                       'out_ucast_pkts': '83954413',
                                                                       'poller_hash': 'UzE0MkYyMjIxMjA1OTk3MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.918336,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 144.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '389804',
                                                                                                                                                     'distance': 2961,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -90.585}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 9.006898,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 143.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '389804',
                                                                                                                                                     'distance': 2961,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -90.88741}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 13.940966,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -7.5914326,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '1',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3888',
                                                                       'in_octets': '7298579879',
                                                                       'in_ucast_pkts': '83953255',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '216569323264',
                                                                       'out_ucast_pkts': '146819179',
                                                                       'poller_hash': 'UzE0MkYyMjIxMjA1OTk3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.96733093261719,
                                         'longitude': -88.9152603149414,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Janet_Ronchetto',
                                         'poller_hash': 'UzE0MkYyMjIxMjA1OTk3',
                                         'serial_number': 'S142F2221205997',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.899,
                                         'uptime': '391263'},
                                 {       'cpu': 19.66433,
                                         'elevation': 5.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '236310526669',
                                                                       'in_ucast_pkts': '159734063',
                                                                       'links': [       {       'in_octets': '236310526669',
                                                                                                'in_ucast_pkts': '159734063',
                                                                                                'out_octets': '10266717522',
                                                                                                'out_ucast_pkts': '106710238',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '10266717522',
                                                                       'out_ucast_pkts': '106710238',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzMzMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.557425,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 140.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '389791',
                                                                                                                                                     'distance': 3015,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -89.312584}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.1672564,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 138.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '389791',
                                                                                                                                                     'distance': 3015,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -89.64001}]}],
                                                                                                 'tx_power': 26}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 9.613429,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -9.885858,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '187',
                                                                       'in_octets': '10269375775',
                                                                       'in_ucast_pkts': '106711000',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '235648080772',
                                                                       'out_ucast_pkts': '159719038',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzMzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.966514587402344,
                                         'longitude': -88.91500854492188,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Jacy_Page',
                                         'poller_hash': 'UzE0MkYyMjIxODA1MzMz',
                                         'serial_number': 'S142F2221805333',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.028,
                                         'uptime': '391273'},
                                 {       'cpu': 19.407345,
                                         'elevation': 3.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '49622064821',
                                                                       'in_ucast_pkts': '38667699',
                                                                       'links': [       {       'in_octets': '49622064821',
                                                                                                'in_ucast_pkts': '38667699',
                                                                                                'out_octets': '2388727454',
                                                                                                'out_ucast_pkts': '15395613',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2388727454',
                                                                       'out_ucast_pkts': '15395613',
                                                                       'poller_hash': 'UzE0MkYyMjIxMjAyMTUxMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.9038315,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 142.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '389777',
                                                                                                                                                     'distance': 5628,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -89.42477}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 9.716909,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 143.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '389777',
                                                                                                                                                     'distance': 5628,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -90.74948}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -5.2876935,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '1',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3923',
                                                                       'in_octets': '2389533629',
                                                                       'in_ucast_pkts': '15392425',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '49465044458',
                                                                       'out_ucast_pkts': '38667298',
                                                                       'poller_hash': 'UzE0MkYyMjIxMjAyMTUxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.93960952758789,
                                         'longitude': -88.91454315185547,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Sharon_Pulliam',
                                         'poller_hash': 'UzE0MkYyMjIxMjAyMTUx',
                                         'serial_number': 'S142F2221202151',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 34.686,
                                         'uptime': '391264'},
                                 {       'cpu': 20.33091,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '10541395',
                                                                       'in_ucast_pkts': '20044',
                                                                       'links': [       {       'in_octets': '10541395',
                                                                                                'in_ucast_pkts': '20044',
                                                                                                'out_octets': '3206124',
                                                                                                'out_ucast_pkts': '19571',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3206124',
                                                                       'out_ucast_pkts': '19571',
                                                                       'poller_hash': 'UzE0MkYxMjE0NjAwMDA1MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 11.962394,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '19791',
                                                                                                                                                     'distance': 10565,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -91.24863}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.4401765,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '19791',
                                                                                                                                                     'distance': 10565,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -91.128006}]}],
                                                                                                 'tx_power': 18}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.036036037,
                                                                                                                'tx_interference_signal_ratio': 10.387932,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3560',
                                                                       'in_octets': '75034169',
                                                                       'in_ucast_pkts': '422037',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '387772120',
                                                                       'out_ucast_pkts': '551522',
                                                                       'poller_hash': 'UzE0MkYxMjE0NjAwMDA1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.89767837524414,
                                         'longitude': -88.9328384399414,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Raubach_Randy_7106',
                                         'poller_hash': 'UzE0MkYxMjE0NjAwMDA1',
                                         'serial_number': 'S142F1214600005',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.319,
                                         'uptime': '329550'},
                                 {       'cpu': 21.285643,
                                         'elevation': 5.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '1426540191',
                                                                       'in_ucast_pkts': '1308455',
                                                                       'links': [       {       'in_octets': '1426540191',
                                                                                                'in_ucast_pkts': '1308455',
                                                                                                'out_octets': '147704358',
                                                                                                'out_ucast_pkts': '563327',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '147704358',
                                                                       'out_ucast_pkts': '563327',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjU1MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.605777,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 145.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '18472',
                                                                                                                                                     'distance': 3551,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -90.09357}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.4429603,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 146.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '18472',
                                                                                                                                                     'distance': 3551,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -92.438515}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 19.20687,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -9.608915,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1522',
                                                                       'in_octets': '407124237',
                                                                       'in_ucast_pkts': '1805529',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '4671134915',
                                                                       'out_ucast_pkts': '4173495',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjU1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.97806930541992,
                                         'longitude': -88.93434143066406,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Casey_Melissa_17432',
                                         'poller_hash': 'UzE0MkYyMjIxODA1MjU1',
                                         'serial_number': 'S142F2221805255',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.912,
                                         'uptime': '90221'},
                                 {       'cpu': 20.546516,
                                         'elevation': 2.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '3165611194',
                                                                       'in_ucast_pkts': '2983445',
                                                                       'links': [       {       'in_octets': '3165611194',
                                                                                                'in_ucast_pkts': '2983445',
                                                                                                'out_octets': '443224473',
                                                                                                'out_ucast_pkts': '2226695',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '443224473',
                                                                       'out_ucast_pkts': '2226695',
                                                                       'poller_hash': 'UzE0MkYyMjIxMjAyNDU0MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 9.339626,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 144.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '205648',
                                                                                                                                                     'distance': 7664,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -88.103546}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 17.570772,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 145.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '205648',
                                                                                                                                                     'distance': 7664,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -90.56086}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 23.490234,
                                                                                                                'rx_packet_error_rate': 0.015238095,
                                                                                                                'tx_interference_signal_ratio': 9.776861,
                                                                                                                'tx_packet_error_rate': 0.00407332}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2022',
                                                                       'in_octets': '444963352',
                                                                       'in_ucast_pkts': '2226262',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3152790096',
                                                                       'out_ucast_pkts': '2982814',
                                                                       'poller_hash': 'UzE0MkYyMjIxMjAyNDU0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.91835021972656,
                                         'longitude': -88.8901138305664,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Vernon_Dotson',
                                         'poller_hash': 'UzE0MkYyMjIxMjAyNDU0',
                                         'serial_number': 'S142F2221202454',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.796,
                                         'uptime': '205981'},
                                 {       'cpu': 20.651493,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '54200145085',
                                                                       'in_ucast_pkts': '39677626',
                                                                       'links': [       {       'in_octets': '54200145085',
                                                                                                'in_ucast_pkts': '39677626',
                                                                                                'out_octets': '2675496251',
                                                                                                'out_ucast_pkts': '20933604',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2675496251',
                                                                       'out_ucast_pkts': '20933604',
                                                                       'poller_hash': 'UzE0MkYyMjIzMTAwMzQwMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.3423557,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 146.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '205348',
                                                                                                                                                     'distance': 7403,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -90.06292}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 13.311281,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 147.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '205348',
                                                                                                                                                     'distance': 7403,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                                                                                                                     'rssi': -91.61126}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 17.193249,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 0.33307314,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1972',
                                                                       'in_octets': '2677154555',
                                                                       'in_ucast_pkts': '20933097',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '54039697898',
                                                                       'out_ucast_pkts': '39677228',
                                                                       'poller_hash': 'UzE0MkYyMjIzMTAwMzQwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.921043395996094,
                                         'longitude': -88.88288116455078,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Kenneth_Martinsen_13662HQ',
                                         'poller_hash': 'UzE0MkYyMjIzMTAwMzQw',
                                         'serial_number': 'S142F2223100340',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 32.189,
                                         'uptime': '205988'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tarana_tarana_30_0141_001_0_977_016_00_10_135_112_132(self):
        obj = self.run_data("tarana.tarana.30-0141-001.0.977.016.00.10_135_112_132")
        exp_info = {
                'model': '30-0141-001',
                'sta_count': 32,
                'sw_version': '0.977.016.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S141F2221600576',
                'system_mac_address': None,
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                'S142F1215000075': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 18954704836,
                                           'dl_rf_packets': 14679626,
                                           'ip_address': None,
                                           'name': 'S142F1215000075',
                                           'serial': 'S142F1215000075',
                                           'serial_number': 'S142F1215000075',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 1031629440,
                                           'ul_rf_packets': 8580737},
                'S142F1215000099': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 550566016064,
                                           'dl_rf_packets': 368393006,
                                           'ip_address': None,
                                           'name': 'Charles_Bushue_19078',
                                           'serial': 'S142F1215000099',
                                           'serial_number': 'S142F1215000099',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 20126393499,
                                           'ul_rf_packets': 242436242},
                'S142F2221706261': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 580103542,
                                           'dl_rf_packets': 550207,
                                           'ip_address': None,
                                           'name': 'ronald_rose',
                                           'serial': 'S142F2221706261',
                                           'serial_number': 'S142F2221706261',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 59274912,
                                           'ul_rf_packets': 475424},
                'S142F2221706350': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 1833151799,
                                           'dl_rf_packets': 3478405,
                                           'ip_address': None,
                                           'name': 'Susan_Quindry',
                                           'serial': 'S142F2221706350',
                                           'serial_number': 'S142F2221706350',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 560306977,
                                           'ul_rf_packets': 3020991},
                'S142F2221706351': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 387769331125,
                                           'dl_rf_packets': 270754772,
                                           'ip_address': None,
                                           'name': 'Lane_Gibbens',
                                           'serial': 'S142F2221706351',
                                           'serial_number': 'S142F2221706351',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 21337189844,
                                           'ul_rf_packets': 227087730},
                'S142F2221706352': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 280092069781,
                                           'dl_rf_packets': 211108010,
                                           'ip_address': None,
                                           'name': 'Amanda_Hartline',
                                           'serial': 'S142F2221706352',
                                           'serial_number': 'S142F2221706352',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 18503805725,
                                           'ul_rf_packets': 96187954},
                'S142F2221706374': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 22270246612,
                                           'dl_rf_packets': 15828062,
                                           'ip_address': None,
                                           'name': 'Matt_Garrett',
                                           'serial': 'S142F2221706374',
                                           'serial_number': 'S142F2221706374',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 1037550466,
                                           'ul_rf_packets': 8704176},
                'S142F2221706376': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 16927660191,
                                           'dl_rf_packets': 14661232,
                                           'ip_address': None,
                                           'name': 'Marsha_Wyant',
                                           'serial': 'S142F2221706376',
                                           'serial_number': 'S142F2221706376',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 1262509508,
                                           'ul_rf_packets': 7229877},
                'S142F2221805250': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 155636605970,
                                           'dl_rf_packets': 114556323,
                                           'ip_address': None,
                                           'name': 'lisa_keener_7769',
                                           'serial': 'S142F2221805250',
                                           'serial_number': 'S142F2221805250',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 9980309010,
                                           'ul_rf_packets': 69529293},
                'S142F2221805254': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 1457374909,
                                           'dl_rf_packets': 1788002,
                                           'ip_address': None,
                                           'name': 'Sherry_drysdale',
                                           'serial': 'S142F2221805254',
                                           'serial_number': 'S142F2221805254',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 345442010,
                                           'ul_rf_packets': 1308129},
                'S142F2221902685': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 69773423798,
                                           'dl_rf_packets': 56700032,
                                           'ip_address': None,
                                           'name': 'Sanders_Leon_15612',
                                           'serial': 'S142F2221902685',
                                           'serial_number': 'S142F2221902685',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 6604497835,
                                           'ul_rf_packets': 43759625},
                'S142F2222000079': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 378606716,
                                           'dl_rf_packets': 530178,
                                           'ip_address': None,
                                           'name': 'merrill_rose_8486',
                                           'serial': 'S142F2222000079',
                                           'serial_number': 'S142F2222000079',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 52129655,
                                           'ul_rf_packets': 466077},
                'S142F2222000261': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 382757607427,
                                           'dl_rf_packets': 304117214,
                                           'ip_address': None,
                                           'name': 'Poole_Dennis_17811',
                                           'serial': 'S142F2222000261',
                                           'serial_number': 'S142F2222000261',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 25988630317,
                                           'ul_rf_packets': 158514494},
                'S142F2222002095': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 21690877062,
                                           'dl_rf_packets': 16057690,
                                           'ip_address': None,
                                           'name': 'John_Grutzius',
                                           'serial': 'S142F2222002095',
                                           'serial_number': 'S142F2222002095',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 1279354917,
                                           'ul_rf_packets': 8414644},
                'S142F2222002333': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 2576243597,
                                           'dl_rf_packets': 1895776,
                                           'ip_address': None,
                                           'name': 'Forsythe_Sandy_20054',
                                           'serial': 'S142F2222002333',
                                           'serial_number': 'S142F2222002333',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 105755144,
                                           'ul_rf_packets': 955277},
                'S142F2222203400': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 1142548329069,
                                           'dl_rf_packets': 801367868,
                                           'ip_address': None,
                                           'name': 'Ronald_Lancaster_55858HQ',
                                           'serial': 'S142F2222203400',
                                           'serial_number': 'S142F2222203400',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 35372390901,
                                           'ul_rf_packets': 375899736},
                'S142F2222203594': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 184101143312,
                                           'dl_rf_packets': 125280866,
                                           'ip_address': None,
                                           'name': 'Dawn_Sullivan_8311HQ',
                                           'serial': 'S142F2222203594',
                                           'serial_number': 'S142F2222203594',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 7743503178,
                                           'ul_rf_packets': 85439536},
                'S142F2222205447': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 15504858207,
                                           'dl_rf_packets': 10892170,
                                           'ip_address': None,
                                           'name': 'David_Moss',
                                           'serial': 'S142F2222205447',
                                           'serial_number': 'S142F2222205447',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 692907235,
                                           'ul_rf_packets': 5088086},
                'S142F2222205503': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 140398968101,
                                           'dl_rf_packets': 97085680,
                                           'ip_address': None,
                                           'name': 'Kelsey_Stroud',
                                           'serial': 'S142F2222205503',
                                           'serial_number': 'S142F2222205503',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 5174840865,
                                           'ul_rf_packets': 44486433},
                'S142F2222205631': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 252508155788,
                                           'dl_rf_packets': 181631369,
                                           'ip_address': None,
                                           'name': 'Ferrell_Winemiller',
                                           'serial': 'S142F2222205631',
                                           'serial_number': 'S142F2222205631',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 13871078358,
                                           'ul_rf_packets': 97025735},
                'S142F2222601578': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 94303264102,
                                           'dl_rf_packets': 78323898,
                                           'ip_address': None,
                                           'name': 'Jonathan_Edwards',
                                           'serial': 'S142F2222601578',
                                           'serial_number': 'S142F2222601578',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 8134259991,
                                           'ul_rf_packets': 47169508},
                'S142F2222601624': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 128922670071,
                                           'dl_rf_packets': 87797648,
                                           'ip_address': None,
                                           'name': 'Shelton_7260',
                                           'serial': 'S142F2222601624',
                                           'serial_number': 'S142F2222601624',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 5958544442,
                                           'ul_rf_packets': 60644078},
                'S142F2222807396': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 84155474302,
                                           'dl_rf_packets': 61825004,
                                           'ip_address': None,
                                           'name': 'Elaine_Rich',
                                           'serial': 'S142F2222807396',
                                           'serial_number': 'S142F2222807396',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 5535733148,
                                           'ul_rf_packets': 46773258},
                'S142F2223000123': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 329395571688,
                                           'dl_rf_packets': 269049813,
                                           'ip_address': None,
                                           'name': 'Linda_Swan',
                                           'serial': 'S142F2223000123',
                                           'serial_number': 'S142F2223000123',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 66556973474,
                                           'ul_rf_packets': 196693126},
                'S142F2223000361': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 2245801028,
                                           'dl_rf_packets': 2068306,
                                           'ip_address': None,
                                           'name': 'Ben_Clements',
                                           'serial': 'S142F2223000361',
                                           'serial_number': 'S142F2223000361',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 241212630,
                                           'ul_rf_packets': 1554229},
                'S142F2223000368': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 582337180223,
                                           'dl_rf_packets': 400114756,
                                           'ip_address': None,
                                           'name': 'Ben_Clements',
                                           'serial': 'S142F2223000368',
                                           'serial_number': 'S142F2223000368',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 29458572364,
                                           'ul_rf_packets': 272980031},
                'S142F2223100853': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 40216527668,
                                           'dl_rf_packets': 31067876,
                                           'ip_address': None,
                                           'name': 'Wilcox.Richard',
                                           'serial': 'S142F2223100853',
                                           'serial_number': 'S142F2223100853',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 3194813044,
                                           'ul_rf_packets': 25276597},
                'S142F2223400754': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 33247475528,
                                           'dl_rf_packets': 27175994,
                                           'ip_address': None,
                                           'name': 'JonesArview_22099',
                                           'serial': 'S142F2223400754',
                                           'serial_number': 'S142F2223400754',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 2649795479,
                                           'ul_rf_packets': 15291496},
                'S142F2223400782': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 283955492874,
                                           'dl_rf_packets': 200080213,
                                           'ip_address': None,
                                           'name': 'Lewis_RobertAndRebecca_15948HQ',
                                           'serial': 'S142F2223400782',
                                           'serial_number': 'S142F2223400782',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 17734281013,
                                           'ul_rf_packets': 165220138},
                'S142F2223500139': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 179038668841,
                                           'dl_rf_packets': 160763414,
                                           'ip_address': None,
                                           'name': 'Ricky_Robinson',
                                           'serial': 'S142F2223500139',
                                           'serial_number': 'S142F2223500139',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 22033348629,
                                           'ul_rf_packets': 96797455},
                'S142F2223500202': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 24051396484,
                                           'dl_rf_packets': 19322858,
                                           'ip_address': None,
                                           'name': 'William_Armstrong',
                                           'serial': 'S142F2223500202',
                                           'serial_number': 'S142F2223500202',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 1257486737,
                                           'ul_rf_packets': 9251466},
                'S142F2223803537': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 8424206679,
                                           'dl_rf_packets': 7895845,
                                           'ip_address': None,
                                           'name': 'Stowers_Derek_19338HQ',
                                           'serial': 'S142F2223803537',
                                           'serial_number': 'S142F2223803537',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 1094492842,
                                           'ul_rf_packets': 6887613}
        }
        exp_ne_msg = {
                'data': {       'cpu': 44.87144,
                                'elevation': 225.173,
                                'gps_sats_tracked': 15,
                                'height': 228.728,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '1632200',
                                                                                       'in_octets': '29458572364',
                                                                                       'in_ucast_pkts': '272980031',
                                                                                       'out_errors': '8125311',
                                                                                       'out_octets': '582337180223',
                                                                                       'out_ucast_pkts': '400114756',
                                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMzY4MQ=='},
                                                                               {       'in_errors': '820071',
                                                                                       'in_octets': '17734281013',
                                                                                       'in_ucast_pkts': '165220138',
                                                                                       'out_errors': '378114',
                                                                                       'out_octets': '283955492874',
                                                                                       'out_ucast_pkts': '200080213',
                                                                                       'poller_hash': 'UzE0MkYyMjIzNDAwNzgyMQ=='},
                                                                               {       'in_errors': '2447006',
                                                                                       'in_octets': '18503805725',
                                                                                       'in_ucast_pkts': '96187954',
                                                                                       'out_errors': '10303882',
                                                                                       'out_octets': '280092069781',
                                                                                       'out_ucast_pkts': '211108010',
                                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MzUyMQ=='},
                                                                               {       'in_errors': '709337',
                                                                                       'in_octets': '9980309010',
                                                                                       'in_ucast_pkts': '69529293',
                                                                                       'out_errors': '3009605',
                                                                                       'out_octets': '155636605970',
                                                                                       'out_ucast_pkts': '114556323',
                                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjUwMQ=='},
                                                                               {       'in_errors': '1840825',
                                                                                       'in_octets': '66556973474',
                                                                                       'in_ucast_pkts': '196693126',
                                                                                       'out_errors': '5654547',
                                                                                       'out_octets': '329395571688',
                                                                                       'out_ucast_pkts': '269049813',
                                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMTIzMQ=='},
                                                                               {       'in_errors': '5067810',
                                                                                       'in_octets': '35372390901',
                                                                                       'in_ucast_pkts': '375899736',
                                                                                       'out_errors': '23935848',
                                                                                       'out_octets': '1142548329069',
                                                                                       'out_ucast_pkts': '801367868',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMjAzNDAwMQ=='},
                                                                               {       'in_errors': '38260',
                                                                                       'in_octets': '241212630',
                                                                                       'in_ucast_pkts': '1554229',
                                                                                       'out_errors': '185913',
                                                                                       'out_octets': '2245801028',
                                                                                       'out_ucast_pkts': '2068306',
                                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMzYxMQ=='},
                                                                               {       'in_errors': '1470055',
                                                                                       'in_octets': '20126393499',
                                                                                       'in_ucast_pkts': '242436242',
                                                                                       'out_errors': '7074353',
                                                                                       'out_octets': '550566016064',
                                                                                       'out_ucast_pkts': '368393006',
                                                                                       'poller_hash': 'UzE0MkYxMjE1MDAwMDk5MQ=='},
                                                                               {       'in_errors': '253767',
                                                                                       'in_octets': '560306977',
                                                                                       'in_ucast_pkts': '3020991',
                                                                                       'out_errors': '1247115',
                                                                                       'out_octets': '1833151799',
                                                                                       'out_ucast_pkts': '3478405',
                                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MzUwMQ=='},
                                                                               {       'in_errors': '97300',
                                                                                       'in_octets': '1031629440',
                                                                                       'in_ucast_pkts': '8580737',
                                                                                       'out_errors': '468522',
                                                                                       'out_octets': '18954704836',
                                                                                       'out_ucast_pkts': '14679626',
                                                                                       'poller_hash': 'UzE0MkYxMjE1MDAwMDc1MQ=='},
                                                                               {       'in_errors': '181071',
                                                                                       'in_octets': '3194813044',
                                                                                       'in_ucast_pkts': '25276597',
                                                                                       'out_errors': '939942',
                                                                                       'out_octets': '40216527668',
                                                                                       'out_ucast_pkts': '31067876',
                                                                                       'poller_hash': 'UzE0MkYyMjIzMTAwODUzMQ=='},
                                                                               {       'in_errors': '1064977',
                                                                                       'in_octets': '21337189844',
                                                                                       'in_ucast_pkts': '227087730',
                                                                                       'out_errors': '5013118',
                                                                                       'out_octets': '387769331125',
                                                                                       'out_ucast_pkts': '270754772',
                                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MzUxMQ=='},
                                                                               {       'in_errors': '1028123',
                                                                                       'in_octets': '8134259991',
                                                                                       'in_ucast_pkts': '47169508',
                                                                                       'out_errors': '4791036',
                                                                                       'out_octets': '94303264102',
                                                                                       'out_ucast_pkts': '78323898',
                                                                                       'poller_hash': 'UzE0MkYyMjIyNjAxNTc4MQ=='},
                                                                               {       'in_errors': '34174',
                                                                                       'in_octets': '345442010',
                                                                                       'in_ucast_pkts': '1308129',
                                                                                       'out_errors': '6886',
                                                                                       'out_octets': '1457374909',
                                                                                       'out_ucast_pkts': '1788002',
                                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjU0MQ=='},
                                                                               {       'in_errors': '382844',
                                                                                       'in_octets': '6604497835',
                                                                                       'in_ucast_pkts': '43759625',
                                                                                       'out_errors': '1661814',
                                                                                       'out_octets': '69773423798',
                                                                                       'out_ucast_pkts': '56700032',
                                                                                       'poller_hash': 'UzE0MkYyMjIxOTAyNjg1MQ=='},
                                                                               {       'in_errors': '1262839',
                                                                                       'in_octets': '5535733148',
                                                                                       'in_ucast_pkts': '46773258',
                                                                                       'out_errors': '3488282',
                                                                                       'out_octets': '84155474302',
                                                                                       'out_ucast_pkts': '61825004',
                                                                                       'poller_hash': 'UzE0MkYyMjIyODA3Mzk2MQ=='},
                                                                               {       'in_errors': '197023',
                                                                                       'in_octets': '1279354917',
                                                                                       'in_ucast_pkts': '8414644',
                                                                                       'out_errors': '846409',
                                                                                       'out_octets': '21690877062',
                                                                                       'out_ucast_pkts': '16057690',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMDAyMDk1MQ=='},
                                                                               {       'in_errors': '122895',
                                                                                       'in_octets': '692907235',
                                                                                       'in_ucast_pkts': '5088086',
                                                                                       'out_errors': '586461',
                                                                                       'out_octets': '15504858207',
                                                                                       'out_ucast_pkts': '10892170',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NDQ3MQ=='},
                                                                               {       'in_errors': '336642',
                                                                                       'in_octets': '5958544442',
                                                                                       'in_ucast_pkts': '60644078',
                                                                                       'out_errors': '1713469',
                                                                                       'out_octets': '128922670071',
                                                                                       'out_ucast_pkts': '87797648',
                                                                                       'poller_hash': 'UzE0MkYyMjIyNjAxNjI0MQ=='},
                                                                               {       'in_errors': '141221',
                                                                                       'in_octets': '1037550466',
                                                                                       'in_ucast_pkts': '8704176',
                                                                                       'out_errors': '670263',
                                                                                       'out_octets': '22270246612',
                                                                                       'out_ucast_pkts': '15828062',
                                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2Mzc0MQ=='},
                                                                               {       'in_errors': '1517769',
                                                                                       'in_octets': '13871078358',
                                                                                       'in_ucast_pkts': '97025735',
                                                                                       'out_errors': '7377276',
                                                                                       'out_octets': '252508155788',
                                                                                       'out_ucast_pkts': '181631369',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NjMxMQ=='},
                                                                               {       'in_errors': '18298',
                                                                                       'in_octets': '59274912',
                                                                                       'in_ucast_pkts': '475424',
                                                                                       'out_errors': '86830',
                                                                                       'out_octets': '580103542',
                                                                                       'out_ucast_pkts': '550207',
                                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MjYxMQ=='},
                                                                               {       'in_errors': '129314',
                                                                                       'in_octets': '1257486737',
                                                                                       'in_ucast_pkts': '9251466',
                                                                                       'out_errors': '634742',
                                                                                       'out_octets': '24051396484',
                                                                                       'out_ucast_pkts': '19322858',
                                                                                       'poller_hash': 'UzE0MkYyMjIzNTAwMjAyMQ=='},
                                                                               {       'in_errors': '843551',
                                                                                       'in_octets': '5174840865',
                                                                                       'in_ucast_pkts': '44486433',
                                                                                       'out_errors': '4351836',
                                                                                       'out_octets': '140398968101',
                                                                                       'out_ucast_pkts': '97085680',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NTAzMQ=='},
                                                                               {       'in_errors': '229936',
                                                                                       'in_octets': '1262509508',
                                                                                       'in_ucast_pkts': '7229877',
                                                                                       'out_errors': '985749',
                                                                                       'out_octets': '16927660191',
                                                                                       'out_ucast_pkts': '14661232',
                                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2Mzc2MQ=='},
                                                                               {       'in_errors': '407049',
                                                                                       'in_octets': '7743503178',
                                                                                       'in_ucast_pkts': '85439536',
                                                                                       'out_errors': '1979207',
                                                                                       'out_octets': '184101143312',
                                                                                       'out_ucast_pkts': '125280866',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMjAzNTk0MQ=='},
                                                                               {       'in_errors': '219619',
                                                                                       'in_octets': '2649795479',
                                                                                       'in_ucast_pkts': '15291496',
                                                                                       'out_errors': '1281115',
                                                                                       'out_octets': '33247475528',
                                                                                       'out_ucast_pkts': '27175994',
                                                                                       'poller_hash': 'UzE0MkYyMjIzNDAwNzU0MQ=='},
                                                                               {       'in_errors': '66362',
                                                                                       'in_octets': '1094492842',
                                                                                       'in_ucast_pkts': '6887613',
                                                                                       'out_errors': '228190',
                                                                                       'out_octets': '8424206679',
                                                                                       'out_ucast_pkts': '7895845',
                                                                                       'poller_hash': 'UzE0MkYyMjIzODAzNTM3MQ=='},
                                                                               {       'in_errors': '6513',
                                                                                       'in_octets': '52129655',
                                                                                       'in_ucast_pkts': '466077',
                                                                                       'out_errors': '26488',
                                                                                       'out_octets': '378606716',
                                                                                       'out_ucast_pkts': '530178',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMDAwMDc5MQ=='},
                                                                               {       'in_errors': '26593',
                                                                                       'in_octets': '105755144',
                                                                                       'in_ucast_pkts': '955277',
                                                                                       'out_errors': '125279',
                                                                                       'out_octets': '2576243597',
                                                                                       'out_ucast_pkts': '1895776',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMDAyMzMzMQ=='},
                                                                               {       'in_errors': '1061444',
                                                                                       'in_octets': '22033348629',
                                                                                       'in_ucast_pkts': '96797455',
                                                                                       'out_errors': '488954',
                                                                                       'out_octets': '179038668841',
                                                                                       'out_ucast_pkts': '160763414',
                                                                                       'poller_hash': 'UzE0MkYyMjIzNTAwMTM5MQ=='},
                                                                               {       'in_errors': '2267823',
                                                                                       'in_octets': '25988630317',
                                                                                       'in_ucast_pkts': '158514494',
                                                                                       'out_errors': '10277924',
                                                                                       'out_octets': '382757607427',
                                                                                       'out_ucast_pkts': '304117214',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMDAwMjYxMQ=='}],
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'dl_percent': 82,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 3570,
                                                                                        'gps_sync': True,
                                                                                        'id': '0',
                                                                                        'rx_max_interference_noise_ratio': 23.132069,
                                                                                        'rx_max_sensitivity_loss': 0.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '2333083',
                                                                                                                                            'distance': 9112,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMDAwMzY4MQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '2328187',
                                                                                                                                            'distance': 2358,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNDAwNzgyMQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '4218113',
                                                                                                                                            'distance': 2445,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNzA2MzUyMQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '2328637',
                                                                                                                                            'distance': 4884,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MjUwMQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '2327636',
                                                                                                                                            'distance': 1400,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMDAwMTIzMQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '1367054',
                                                                                                                                            'distance': 2780,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjAzNDAwMQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '1186089',
                                                                                                                                            'distance': 9065,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMDAwMzYxMQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '1127235',
                                                                                                                                            'distance': 1045,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE1MDAwMDk5MQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '4174443',
                                                                                                                                            'distance': 1835,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNzA2MzUwMQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '1066538',
                                                                                                                                            'distance': 3041,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE1MDAwMDc1MQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '985749',
                                                                                                                                            'distance': 6720,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMTAwODUzMQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '985749',
                                                                                                                                            'distance': 1889,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNzA2MzUxMQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '955819',
                                                                                                                                            'distance': 4388,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyNjAxNTc4MQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '955004',
                                                                                                                                            'distance': 562,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MjU0MQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '933604',
                                                                                                                                            'distance': 6344,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxOTAyNjg1MQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '869297',
                                                                                                                                            'distance': 7048,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyODA3Mzk2MQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '867698',
                                                                                                                                            'distance': 1949,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMDAyMDk1MQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '813966',
                                                                                                                                            'distance': 917,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjA1NDQ3MQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '798538',
                                                                                                                                            'distance': 1152,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyNjAxNjI0MQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '703758',
                                                                                                                                            'distance': 2284,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNzA2Mzc0MQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '641454',
                                                                                                                                            'distance': 3745,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjA1NjMxMQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '508268',
                                                                                                                                            'distance': 5025,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNzA2MjYxMQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '497000',
                                                                                                                                            'distance': 3356,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNTAwMjAyMQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '488676',
                                                                                                                                            'distance': 9487,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjA1NTAzMQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '410319',
                                                                                                                                            'distance': 2539,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNzA2Mzc2MQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '368250',
                                                                                                                                            'distance': 87,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjAzNTk0MQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '335400',
                                                                                                                                            'distance': 8622,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNDAwNzU0MQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '174600',
                                                                                                                                            'distance': 6170,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzODAzNTM3MQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '79750',
                                                                                                                                            'distance': 4991,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMDAwMDc5MQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '74117',
                                                                                                                                            'distance': 4602,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMDAyMzMzMQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '3994265',
                                                                                                                                            'distance': 6231,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNTAwMTM5MQ==',
                                                                                                                                            'rssi': -76.047554},
                                                                                                                                    {       'connected_time': '3045811',
                                                                                                                                            'distance': 5071,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMDAwMjYxMQ==',
                                                                                                                                            'rssi': -76.047554}]}],
                                                                                        'tx_power': 23},
                                                                                {       'chan_width': 40,
                                                                                        'dl_percent': 82,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 3660,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'rx_max_interference_noise_ratio': 23.765137,
                                                                                        'rx_max_sensitivity_loss': 0.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '2333083',
                                                                                                                                            'distance': 9112,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMDAwMzY4MQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '2328187',
                                                                                                                                            'distance': 2358,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNDAwNzgyMQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '4218113',
                                                                                                                                            'distance': 2445,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNzA2MzUyMQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '2328637',
                                                                                                                                            'distance': 4884,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MjUwMQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '2327636',
                                                                                                                                            'distance': 1400,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMDAwMTIzMQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '1367054',
                                                                                                                                            'distance': 2780,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjAzNDAwMQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '1186089',
                                                                                                                                            'distance': 9065,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMDAwMzYxMQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '1127235',
                                                                                                                                            'distance': 1045,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE1MDAwMDk5MQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '4174443',
                                                                                                                                            'distance': 1835,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNzA2MzUwMQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '1066538',
                                                                                                                                            'distance': 3041,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE1MDAwMDc1MQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '985749',
                                                                                                                                            'distance': 6720,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMTAwODUzMQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '985749',
                                                                                                                                            'distance': 1889,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNzA2MzUxMQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '955819',
                                                                                                                                            'distance': 4388,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyNjAxNTc4MQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '955004',
                                                                                                                                            'distance': 562,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MjU0MQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '933604',
                                                                                                                                            'distance': 6344,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxOTAyNjg1MQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '869297',
                                                                                                                                            'distance': 7048,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyODA3Mzk2MQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '867698',
                                                                                                                                            'distance': 1949,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMDAyMDk1MQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '813966',
                                                                                                                                            'distance': 917,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjA1NDQ3MQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '798538',
                                                                                                                                            'distance': 1152,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyNjAxNjI0MQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '703758',
                                                                                                                                            'distance': 2284,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNzA2Mzc0MQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '641454',
                                                                                                                                            'distance': 3745,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjA1NjMxMQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '508268',
                                                                                                                                            'distance': 5025,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNzA2MjYxMQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '497000',
                                                                                                                                            'distance': 3356,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNTAwMjAyMQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '488676',
                                                                                                                                            'distance': 9487,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjA1NTAzMQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '410319',
                                                                                                                                            'distance': 2539,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNzA2Mzc2MQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '368250',
                                                                                                                                            'distance': 87,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjAzNTk0MQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '335400',
                                                                                                                                            'distance': 8622,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNDAwNzU0MQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '174600',
                                                                                                                                            'distance': 6170,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzODAzNTM3MQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '79750',
                                                                                                                                            'distance': 4991,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMDAwMDc5MQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '74117',
                                                                                                                                            'distance': 4602,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMDAyMzMzMQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '3994265',
                                                                                                                                            'distance': 6231,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNTAwMTM5MQ==',
                                                                                                                                            'rssi': -81.93752},
                                                                                                                                    {       'connected_time': '3045811',
                                                                                                                                            'distance': 5071,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMDAwMjYxMQ==',
                                                                                                                                            'rssi': -81.93752}]}],
                                                                                        'tx_power': 12}],
                                                              'rf_aggregation_groups': [       {       'airtime': 2.6041665,
                                                                                                       'name': 'rf_group'}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '250',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '268131000',
                                                              'in_octets': '18621757671587',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '1284453',
                                                              'out_octets': '1251393274346',
                                                              'poller_hash': 'UzE0MUYyMjIxNjAwNTc2ZXgx',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': False,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzE0MUYyMjIxNjAwNTc2ZXgy'},
                                                      {       'admin_up': False,
                                                              'id': 'gi1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzE0MUYyMjIxNjAwNTc2Z2kx'}],
                                'latitude': 37.988006591796875,
                                'longitude': -88.89268493652344,
                                'manufacturer': 'Tarana',
                                'mem': 2.8632026,
                                'model': '30-0141-001',
                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2',
                                'serial_number': 'S141F2221600576',
                                'sw_version': '0.977.016.00',
                                'temperature': 45.375,
                                'uptime': '4272139'},
                'peers': [       {       'cpu': 21.636547,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '582337180223',
                                                                       'in_ucast_pkts': '400114756',
                                                                       'links': [       {       'in_octets': '582337180223',
                                                                                                'in_ucast_pkts': '400114756',
                                                                                                'out_octets': '29458572364',
                                                                                                'out_ucast_pkts': '272980031',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '29458572364',
                                                                       'out_ucast_pkts': '272980031',
                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMzY4MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.043313,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 135.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2333083',
                                                                                                                                                     'distance': 9112,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -85.437614}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.7342157,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 136.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2333083',
                                                                                                                                                     'distance': 9112,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -87.10614}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': -0.38460618,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -17.938988,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '6',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '20730',
                                                                       'in_octets': '29460697995',
                                                                       'in_ucast_pkts': '272960163',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '580707484000',
                                                                       'out_ucast_pkts': '400099102',
                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMzY4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.050235748291016,
                                         'longitude': -88.8232421875,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Ben_Clements',
                                         'poller_hash': 'UzE0MkYyMjIzMDAwMzY4',
                                         'serial_number': 'S142F2223000368',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.551,
                                         'uptime': '2333414'},
                                 {       'cpu': 21.494858,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '283955492874',
                                                                       'in_ucast_pkts': '200080213',
                                                                       'links': [       {       'in_octets': '283955492874',
                                                                                                'in_ucast_pkts': '200080213',
                                                                                                'out_octets': '17734281013',
                                                                                                'out_ucast_pkts': '165220138',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '17734281013',
                                                                       'out_ucast_pkts': '165220138',
                                                                       'poller_hash': 'UzE0MkYyMjIzNDAwNzgyMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.68698,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 119.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2328187',
                                                                                                                                                     'distance': 2358,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -68.279236}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 9.711245,
                                                                                                 'rx_max_sensitivity_loss': 0.3000002,
                                                                                                 'rx_path_loss': 117.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2328187',
                                                                                                                                                     'distance': 2358,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -70.623665}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': -0.35824427,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -16.215408,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '10',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '20764',
                                                                       'in_octets': '17733429783',
                                                                       'in_ucast_pkts': '165187083',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '283142973628',
                                                                       'out_ucast_pkts': '200073509',
                                                                       'poller_hash': 'UzE0MkYyMjIzNDAwNzgyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.00625228881836,
                                         'longitude': -88.87940216064453,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Lewis_RobertAndRebecca_15948HQ',
                                         'poller_hash': 'UzE0MkYyMjIzNDAwNzgy',
                                         'serial_number': 'S142F2223400782',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 29.577,
                                         'uptime': '2328531'},
                                 {       'cpu': 20.170383,
                                         'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '280092069781',
                                                                       'in_ucast_pkts': '211108010',
                                                                       'links': [       {       'in_octets': '280092069781',
                                                                                                'in_ucast_pkts': '211108010',
                                                                                                'out_octets': '18503805725',
                                                                                                'out_ucast_pkts': '96187954',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '18503805725',
                                                                       'out_ucast_pkts': '96187954',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MzUyMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.2101245,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 148.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4218113',
                                                                                                                                                     'distance': 2445,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -89.825455}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.144369,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 148.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4218113',
                                                                                                                                                     'distance': 2445,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -91.92375}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -7.379182,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '8',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '40809',
                                                                       'in_octets': '18576750813',
                                                                       'in_ucast_pkts': '96669278',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '279944731293',
                                                                       'out_ucast_pkts': '211669034',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MzUyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.00816345214844,
                                         'longitude': -88.90579986572266,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7035775,
                                         'model': '30-0142-001',
                                         'name': 'Amanda_Hartline',
                                         'poller_hash': 'UzE0MkYyMjIxNzA2MzUy',
                                         'serial_number': 'S142F2221706352',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.667,
                                         'uptime': '4233630'},
                                 {       'cpu': 21.813173,
                                         'elevation': 3.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '155636605970',
                                                                       'in_ucast_pkts': '114556323',
                                                                       'links': [       {       'in_octets': '155636605970',
                                                                                                'in_ucast_pkts': '114556323',
                                                                                                'out_octets': '9980309010',
                                                                                                'out_ucast_pkts': '69529293',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '9980309010',
                                                                       'out_ucast_pkts': '69529293',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjUwMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.1838527,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 143.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2328637',
                                                                                                                                                     'distance': 4884,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -91.19268}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 6.811644,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 145.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2328637',
                                                                                                                                                     'distance': 4884,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -93.22122}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 6.4366236,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '1',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '20674',
                                                                       'in_octets': '9982457759',
                                                                       'in_ucast_pkts': '69514984',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '155176889089',
                                                                       'out_ucast_pkts': '114560685',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjUwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.01287841796875,
                                         'longitude': -88.84589385986328,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'lisa_keener_7769',
                                         'poller_hash': 'UzE0MkYyMjIxODA1MjUw',
                                         'serial_number': 'S142F2221805250',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 28.125,
                                         'uptime': '2328941'},
                                 {       'cpu': 20.74668,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '329395571688',
                                                                       'in_ucast_pkts': '269049813',
                                                                       'links': [       {       'in_octets': '329395571688',
                                                                                                'in_ucast_pkts': '269049813',
                                                                                                'out_octets': '66556973474',
                                                                                                'out_ucast_pkts': '196693126',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '66556973474',
                                                                       'out_ucast_pkts': '196693126',
                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMTIzMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 8.820621,
                                                                                                 'rx_max_sensitivity_loss': 0.8000002,
                                                                                                 'rx_path_loss': 121.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2327636',
                                                                                                                                                     'distance': 1400,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -76.23488}]}],
                                                                                                 'tx_power': -56},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 8.942052,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 123.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2327636',
                                                                                                                                                     'distance': 1400,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -80.89058}]}],
                                                                                                 'tx_power': -56}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 1.4924264,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -18.919056,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '40',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '21028',
                                                                       'in_octets': '66580188216',
                                                                       'in_ucast_pkts': '196699050',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '328325290761',
                                                                       'out_ucast_pkts': '269050745',
                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMTIzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.00062942504883,
                                         'longitude': -88.88574981689453,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0142-001',
                                         'name': 'Linda_Swan',
                                         'poller_hash': 'UzE0MkYyMjIzMDAwMTIz',
                                         'serial_number': 'S142F2223000123',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.551,
                                         'uptime': '2328940'},
                                 {       'cpu': 22.294426,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '1142548329069',
                                                                       'in_ucast_pkts': '801367868',
                                                                       'links': [       {       'in_octets': '1142548329069',
                                                                                                'in_ucast_pkts': '801367868',
                                                                                                'out_octets': '35372390901',
                                                                                                'out_ucast_pkts': '375899736',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '35372390901',
                                                                       'out_ucast_pkts': '375899736',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjAzNDAwMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.9893484,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 146.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1367054',
                                                                                                                                                     'distance': 2780,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -89.73176}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.8605156,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 142.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1367054',
                                                                                                                                                     'distance': 2780,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -89.88675}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 3.542163,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -10.944746,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '165',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '12250',
                                                                       'in_octets': '35377008137',
                                                                       'in_ucast_pkts': '375889573',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1139300563030',
                                                                       'out_ucast_pkts': '801336036',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjAzNDAwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.00863265991211,
                                         'longitude': -88.91160583496094,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Ronald_Lancaster_55858HQ',
                                         'poller_hash': 'UzE0MkYyMjIyMjAzNDAw',
                                         'serial_number': 'S142F2222203400',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 34.222,
                                         'uptime': '1367401'},
                                 {       'cpu': 20.74668,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '2245801028',
                                                                       'in_ucast_pkts': '2068306',
                                                                       'links': [       {       'in_octets': '2245801028',
                                                                                                'in_ucast_pkts': '2068306',
                                                                                                'out_octets': '241212630',
                                                                                                'out_ucast_pkts': '1554229',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '241212630',
                                                                       'out_ucast_pkts': '1554229',
                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMzYxMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.233947,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 134.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1186089',
                                                                                                                                                     'distance': 9065,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -84.856476}]}],
                                                                                                 'tx_power': -53},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 8.640876,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 134.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1186089',
                                                                                                                                                     'distance': 9065,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -86.22162}]}],
                                                                                                 'tx_power': -53}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '21325',
                                                                       'in_octets': '447125034',
                                                                       'in_ucast_pkts': '2934971',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '4580955494',
                                                                       'out_ucast_pkts': '4166755',
                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMzYxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.050235748291016,
                                         'longitude': -88.8232421875,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0142-001',
                                         'name': 'Ben_Clements',
                                         'poller_hash': 'UzE0MkYyMjIzMDAwMzYx',
                                         'serial_number': 'S142F2223000361',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 27.719,
                                         'uptime': '2330872'},
                                 {       'cpu': 18.67636,
                                         'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '550566016064',
                                                                       'in_ucast_pkts': '368393006',
                                                                       'links': [       {       'in_octets': '550566016064',
                                                                                                'in_ucast_pkts': '368393006',
                                                                                                'out_octets': '20126393499',
                                                                                                'out_ucast_pkts': '242436242',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '20126393499',
                                                                       'out_ucast_pkts': '242436242',
                                                                       'poller_hash': 'UzE0MkYxMjE1MDAwMDk5MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.844697,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 134.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1127235',
                                                                                                                                                     'distance': 1045,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -84.24677}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.0363765,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 134.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1127235',
                                                                                                                                                     'distance': 1045,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -87.35695}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 3.065122,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '29',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '20702',
                                                                       'in_octets': '44450492364',
                                                                       'in_ucast_pkts': '525543532',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1175440773740',
                                                                       'out_ucast_pkts': '789883811',
                                                                       'poller_hash': 'UzE0MkYxMjE1MDAwMDk5Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.998291015625,
                                         'longitude': -88.88893127441406,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Charles_Bushue_19078',
                                         'poller_hash': 'UzE0MkYxMjE1MDAwMDk5',
                                         'serial_number': 'S142F1215000099',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 32.828,
                                         'uptime': '2328240'},
                                 {       'cpu': 20.527308,
                                         'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '1833151799',
                                                                       'in_ucast_pkts': '3478405',
                                                                       'links': [       {       'in_octets': '1833151799',
                                                                                                'in_ucast_pkts': '3478405',
                                                                                                'out_octets': '560306977',
                                                                                                'out_ucast_pkts': '3020991',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '560306977',
                                                                       'out_ucast_pkts': '3020991',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MzUwMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.8089957,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 147.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4174443',
                                                                                                                                                     'distance': 1835,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -89.10926}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 6.768831,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 147.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4174443',
                                                                                                                                                     'distance': 1835,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -91.16674}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '4',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '42362',
                                                                       'in_octets': '564772135',
                                                                       'in_ucast_pkts': '3032049',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1839157029',
                                                                       'out_ucast_pkts': '3543966',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MzUwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.92168426513672,
                                         'longitude': -88.89781951904297,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7035775,
                                         'model': '30-0142-001',
                                         'name': 'Susan_Quindry',
                                         'poller_hash': 'UzE0MkYyMjIxNzA2MzUw',
                                         'serial_number': 'S142F2221706350',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 32.886,
                                         'uptime': '4233611'},
                                 {       'cpu': 19.76574,
                                         'elevation': 2.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '18954704836',
                                                                       'in_ucast_pkts': '14679626',
                                                                       'links': [       {       'in_octets': '18954704836',
                                                                                                'in_ucast_pkts': '14679626',
                                                                                                'out_octets': '1031629440',
                                                                                                'out_ucast_pkts': '8580737',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1031629440',
                                                                       'out_ucast_pkts': '8580737',
                                                                       'poller_hash': 'UzE0MkYxMjE1MDAwMDc1MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.265917,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 129.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1066538',
                                                                                                                                                     'distance': 3041,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -76.80012}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 9.883881,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 130.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1066538',
                                                                                                                                                     'distance': 3041,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -82.00355}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': -4.3207097,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -16.517012,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '4',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '37849',
                                                                       'in_octets': '10695870587',
                                                                       'in_ucast_pkts': '103260168',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '264731501163',
                                                                       'out_ucast_pkts': '194622385',
                                                                       'poller_hash': 'UzE0MkYxMjE1MDAwMDc1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.52296829223633,
                                         'longitude': -89.1353988647461,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0142-001',
                                         'name': 'S142F1215000075',
                                         'poller_hash': 'UzE0MkYxMjE1MDAwMDc1',
                                         'serial_number': 'S142F1215000075',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.273,
                                         'uptime': '4177714'},
                                 {       'cpu': 20.961683,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '40216527668',
                                                                       'in_ucast_pkts': '31067876',
                                                                       'links': [       {       'in_octets': '40216527668',
                                                                                                'in_ucast_pkts': '31067876',
                                                                                                'out_octets': '3194813044',
                                                                                                'out_ucast_pkts': '25276597',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3194813044',
                                                                       'out_ucast_pkts': '25276597',
                                                                       'poller_hash': 'UzE0MkYyMjIzMTAwODUzMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.7740035,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 135.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '985749',
                                                                                                                                                     'distance': 6720,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -84.56688}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 9.247819,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 138.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '985749',
                                                                                                                                                     'distance': 6720,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -87.4079}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '34608',
                                                                       'in_octets': '14085299737',
                                                                       'in_ucast_pkts': '120803415',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '189943933302',
                                                                       'out_ucast_pkts': '143814966',
                                                                       'poller_hash': 'UzE0MkYyMjIzMTAwODUzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.03328323364258,
                                         'longitude': -88.84077453613281,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0142-001',
                                         'name': 'Wilcox.Richard',
                                         'poller_hash': 'UzE0MkYyMjIzMTAwODUz',
                                         'serial_number': 'S142F2223100853',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.332,
                                         'uptime': '3816897'},
                                 {       'cpu': 20.48585,
                                         'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '387769331125',
                                                                       'in_ucast_pkts': '270754772',
                                                                       'links': [       {       'in_octets': '387769331125',
                                                                                                'in_ucast_pkts': '270754772',
                                                                                                'out_octets': '21337189844',
                                                                                                'out_ucast_pkts': '227087730',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '21337189844',
                                                                       'out_ucast_pkts': '227087730',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MzUxMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.613334,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 135.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '985749',
                                                                                                                                                     'distance': 1889,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -85.68134}]}],
                                                                                                 'tx_power': 16},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.1549525,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 134.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '985749',
                                                                                                                                                     'distance': 1889,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -85.637054}]}],
                                                                                                 'tx_power': -53}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 1.1568257,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -17.057785,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '26',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '42482',
                                                                       'in_octets': '93513994880',
                                                                       'in_ucast_pkts': '1003775368',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1716351132639',
                                                                       'out_ucast_pkts': '1191913756',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MzUxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.001434326171875,
                                         'longitude': -88.90713500976562,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7035775,
                                         'model': '30-0142-001',
                                         'name': 'Lane_Gibbens',
                                         'poller_hash': 'UzE0MkYyMjIxNzA2MzUx',
                                         'serial_number': 'S142F2221706351',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 33.467,
                                         'uptime': '4233656'},
                                 {       'cpu': 19.156048,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '94303264102',
                                                                       'in_ucast_pkts': '78323898',
                                                                       'links': [       {       'in_octets': '94303264102',
                                                                                                'in_ucast_pkts': '78323898',
                                                                                                'out_octets': '8134259991',
                                                                                                'out_ucast_pkts': '47169508',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '8134259991',
                                                                       'out_ucast_pkts': '47169508',
                                                                       'poller_hash': 'UzE0MkYyMjIyNjAxNTc4MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.900168,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '955819',
                                                                                                                                                     'distance': 4388,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -89.28028}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 8.661738,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '955819',
                                                                                                                                                     'distance': 4388,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -91.7346}]}],
                                                                                                 'tx_power': 20}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 10.068618,
                                                                                                                'rx_packet_error_rate': 0.0039646234,
                                                                                                                'tx_interference_signal_ratio': -2.329147,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '12',
                                                                       'in_errors': '1',
                                                                       'in_nucast_pkts': '35792',
                                                                       'in_octets': '31691256616',
                                                                       'in_ucast_pkts': '181325348',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '404900665320',
                                                                       'out_ucast_pkts': '331096808',
                                                                       'poller_hash': 'UzE0MkYyMjIyNjAxNTc4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.02140426635742,
                                         'longitude': -88.86434173583984,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Jonathan_Edwards',
                                         'poller_hash': 'UzE0MkYyMjIyNjAxNTc4',
                                         'serial_number': 'S142F2222601578',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.493,
                                         'uptime': '3711170'},
                                 {       'cpu': 20.672375,
                                         'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '1457374909',
                                                                       'in_ucast_pkts': '1788002',
                                                                       'links': [       {       'in_octets': '1457374909',
                                                                                                'in_ucast_pkts': '1788002',
                                                                                                'out_octets': '345442010',
                                                                                                'out_ucast_pkts': '1308129',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '345442010',
                                                                       'out_ucast_pkts': '1308129',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjU0MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.86185,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 126.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '955004',
                                                                                                                                                     'distance': 562,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -82.220055}]}],
                                                                                                 'tx_power': -56},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.2405534,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 127.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '955004',
                                                                                                                                                     'distance': 562,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -83.00425}]}],
                                                                                                 'tx_power': -56}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': -0.01085043,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '8524',
                                                                       'in_octets': '345469834',
                                                                       'in_ucast_pkts': '1299205',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1450970146',
                                                                       'out_ucast_pkts': '1790893',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjU0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.992591857910156,
                                         'longitude': -88.89274597167969,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Sherry_drysdale',
                                         'poller_hash': 'UzE0MkYyMjIxODA1MjU0',
                                         'serial_number': 'S142F2221805254',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.273,
                                         'uptime': '955364'},
                                 {       'cpu': 22.850584,
                                         'elevation': 5.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '69773423798',
                                                                       'in_ucast_pkts': '56700032',
                                                                       'links': [       {       'in_octets': '69773423798',
                                                                                                'in_ucast_pkts': '56700032',
                                                                                                'out_octets': '6604497835',
                                                                                                'out_ucast_pkts': '43759625',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '6604497835',
                                                                       'out_ucast_pkts': '43759625',
                                                                       'poller_hash': 'UzE0MkYyMjIxOTAyNjg1MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 5.7861814,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 137.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '933604',
                                                                                                                                                     'distance': 6344,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -88.35074}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 6.428436,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 137.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '933604',
                                                                                                                                                     'distance': 6344,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -89.7737}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '4',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '8361',
                                                                       'in_octets': '6604745238',
                                                                       'in_ucast_pkts': '43751052',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '69548326820',
                                                                       'out_ucast_pkts': '56700619',
                                                                       'poller_hash': 'UzE0MkYyMjIxOTAyNjg1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.04445266723633,
                                         'longitude': -88.87718200683594,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Sanders_Leon_15612',
                                         'poller_hash': 'UzE0MkYyMjIxOTAyNjg1',
                                         'serial_number': 'S142F2221902685',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.68,
                                         'uptime': '934027'},
                                 {       'cpu': 21.528503,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '84155474302',
                                                                       'in_ucast_pkts': '61825004',
                                                                       'links': [       {       'in_octets': '84155474302',
                                                                                                'in_ucast_pkts': '61825004',
                                                                                                'out_octets': '5535733148',
                                                                                                'out_ucast_pkts': '46773258',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '5535733148',
                                                                       'out_ucast_pkts': '46773258',
                                                                       'poller_hash': 'UzE0MkYyMjIyODA3Mzk2MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.583604,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 147.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '869297',
                                                                                                                                                     'distance': 7048,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -89.243576}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.4155917,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 144.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '869297',
                                                                                                                                                     'distance': 7048,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -90.610146}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 13.229816,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -8.317916,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '20735',
                                                                       'in_octets': '16000129359',
                                                                       'in_ucast_pkts': '143112525',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '250068350547',
                                                                       'out_ucast_pkts': '181752669',
                                                                       'poller_hash': 'UzE0MkYyMjIyODA3Mzk2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.03420639038086,
                                         'longitude': -88.83478546142578,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Elaine_Rich',
                                         'poller_hash': 'UzE0MkYyMjIyODA3Mzk2',
                                         'serial_number': 'S142F2222807396',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.448,
                                         'uptime': '2328932'},
                                 {       'cpu': 18.696741,
                                         'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '21690877062',
                                                                       'in_ucast_pkts': '16057690',
                                                                       'links': [       {       'in_octets': '21690877062',
                                                                                                'in_ucast_pkts': '16057690',
                                                                                                'out_octets': '1279354917',
                                                                                                'out_ucast_pkts': '8414644',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1279354917',
                                                                       'out_ucast_pkts': '8414644',
                                                                       'poller_hash': 'UzE0MkYyMjIyMDAyMDk1MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.4086113,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 149.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '867698',
                                                                                                                                                     'distance': 1949,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -89.353424}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 8.301936,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 141.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '867698',
                                                                                                                                                     'distance': 1949,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -89.417206}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '4',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '32102',
                                                                       'in_octets': '6319262784',
                                                                       'in_ucast_pkts': '43363931',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '114088647008',
                                                                       'out_ucast_pkts': '83153812',
                                                                       'poller_hash': 'UzE0MkYyMjIyMDAyMDk1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.001102447509766,
                                         'longitude': -88.90853881835938,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7035775,
                                         'model': '30-0142-001',
                                         'name': 'John_Grutzius',
                                         'poller_hash': 'UzE0MkYyMjIyMDAyMDk1',
                                         'serial_number': 'S142F2222002095',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 34.047,
                                         'uptime': '3550167'},
                                 {       'cpu': 20.041754,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '15504858207',
                                                                       'in_ucast_pkts': '10892170',
                                                                       'links': [       {       'in_octets': '15504858207',
                                                                                                'in_ucast_pkts': '10892170',
                                                                                                'out_octets': '692907235',
                                                                                                'out_ucast_pkts': '5088086',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '692907235',
                                                                       'out_ucast_pkts': '5088086',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NDQ3MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.450585,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 141.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '813966',
                                                                                                                                                     'distance': 917,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -88.74967}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.3662567,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 141.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '813966',
                                                                                                                                                     'distance': 917,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -89.700424}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 5.9487047,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '14',
                                                                       'in_errors': '2',
                                                                       'in_nucast_pkts': '39552',
                                                                       'in_octets': '2598996124',
                                                                       'in_ucast_pkts': '25579758',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '67011146968',
                                                                       'out_ucast_pkts': '46378996',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NDQ3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.99394989013672,
                                         'longitude': -88.90081024169922,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7035775,
                                         'model': '30-0142-001',
                                         'name': 'David_Moss',
                                         'poller_hash': 'UzE0MkYyMjIyMjA1NDQ3',
                                         'serial_number': 'S142F2222205447',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.957,
                                         'uptime': '4233649'},
                                 {       'cpu': 18.682009,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '128922670071',
                                                                       'in_ucast_pkts': '87797648',
                                                                       'links': [       {       'in_octets': '128922670071',
                                                                                                'in_ucast_pkts': '87797648',
                                                                                                'out_octets': '5958544442',
                                                                                                'out_ucast_pkts': '60644078',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '5958544442',
                                                                       'out_ucast_pkts': '60644078',
                                                                       'poller_hash': 'UzE0MkYyMjIyNjAxNjI0MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.637875,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 129.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '798538',
                                                                                                                                                     'distance': 1152,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -80.07085}]}],
                                                                                                 'tx_power': -53},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 8.605344,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 129.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '798538',
                                                                                                                                                     'distance': 1152,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -81.43973}]}],
                                                                                                 'tx_power': -53}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -16.535332,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '1',
                                                                       'in_errors': '1',
                                                                       'in_nucast_pkts': '7877',
                                                                       'in_octets': '5960687490',
                                                                       'in_ucast_pkts': '60654671',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '128580226998',
                                                                       'out_ucast_pkts': '87824883',
                                                                       'poller_hash': 'UzE0MkYyMjIyNjAxNjI0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.995784759521484,
                                         'longitude': -88.88191223144531,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Shelton_7260',
                                         'poller_hash': 'UzE0MkYyMjIyNjAxNjI0',
                                         'serial_number': 'S142F2222601624',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.215,
                                         'uptime': '799296'},
                                 {       'cpu': 19.278866,
                                         'elevation': 7.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '22270246612',
                                                                       'in_ucast_pkts': '15828062',
                                                                       'links': [       {       'in_octets': '22270246612',
                                                                                                'in_ucast_pkts': '15828062',
                                                                                                'out_octets': '1037550466',
                                                                                                'out_ucast_pkts': '8704176',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1037550466',
                                                                       'out_ucast_pkts': '8704176',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2Mzc0MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.9472713,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 144.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '703758',
                                                                                                                                                     'distance': 2284,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -90.19772}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.745083,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 141.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '703758',
                                                                                                                                                     'distance': 2284,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -91.58331}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '8',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '41425',
                                                                       'in_octets': '12247415710',
                                                                       'in_ucast_pkts': '113616126',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '275929503245',
                                                                       'out_ucast_pkts': '192773892',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2Mzc0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.005714416503906,
                                         'longitude': -88.90699005126953,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7035775,
                                         'model': '30-0142-001',
                                         'name': 'Matt_Garrett',
                                         'poller_hash': 'UzE0MkYyMjIxNzA2Mzc0',
                                         'serial_number': 'S142F2221706374',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.086,
                                         'uptime': '4233628'},
                                 {       'cpu': 18.567251,
                                         'elevation': 10.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '252508155788',
                                                                       'in_ucast_pkts': '181631369',
                                                                       'links': [       {       'in_octets': '252508155788',
                                                                                                'in_ucast_pkts': '181631369',
                                                                                                'out_octets': '13871078358',
                                                                                                'out_ucast_pkts': '97025735',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '13871078358',
                                                                       'out_ucast_pkts': '97025735',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NjMxMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.911624,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 142.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '641454',
                                                                                                                                                     'distance': 3745,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -89.09579}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.49731,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 142.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '641454',
                                                                                                                                                     'distance': 3745,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -91.62322}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 2.808839,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -11.424986,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '5',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '36291',
                                                                       'in_octets': '14912984117',
                                                                       'in_ucast_pkts': '105032308',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '266485437369',
                                                                       'out_ucast_pkts': '194363883',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NjMxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.01695251464844,
                                         'longitude': -88.8694839477539,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0142-001',
                                         'name': 'Ferrell_Winemiller',
                                         'poller_hash': 'UzE0MkYyMjIyMjA1NjMx',
                                         'serial_number': 'S142F2222205631',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 33.873,
                                         'uptime': '2328960'},
                                 {       'cpu': 21.206429,
                                         'elevation': 20.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '580103542',
                                                                       'in_ucast_pkts': '550207',
                                                                       'links': [       {       'in_octets': '580103542',
                                                                                                'in_ucast_pkts': '550207',
                                                                                                'out_octets': '59274912',
                                                                                                'out_ucast_pkts': '475424',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '59274912',
                                                                       'out_ucast_pkts': '475424',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MjYxMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.3605227,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 130.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '508268',
                                                                                                                                                     'distance': 5025,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -81.49319}]}],
                                                                                                 'tx_power': -56},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 9.682647,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 129.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '508268',
                                                                                                                                                     'distance': 5025,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -81.40793}]}],
                                                                                                 'tx_power': -56}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '114984',
                                                                       'in_octets': '683461667',
                                                                       'in_ucast_pkts': '5559169',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '9480686856',
                                                                       'out_ucast_pkts': '8246498',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MjYxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.023128509521484,
                                         'longitude': -88.85501861572266,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0142-001',
                                         'name': 'ronald_rose',
                                         'poller_hash': 'UzE0MkYyMjIxNzA2MjYx',
                                         'serial_number': 'S142F2221706261',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.796,
                                         'uptime': '3889598'},
                                 {       'cpu': 21.86326,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '24051396484',
                                                                       'in_ucast_pkts': '19322858',
                                                                       'links': [       {       'in_octets': '24051396484',
                                                                                                'in_ucast_pkts': '19322858',
                                                                                                'out_octets': '1257486737',
                                                                                                'out_ucast_pkts': '9251466',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1257486737',
                                                                       'out_ucast_pkts': '9251466',
                                                                       'poller_hash': 'UzE0MkYyMjIzNTAwMjAyMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.0872564,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 136.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '497000',
                                                                                                                                                     'distance': 3356,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -84.5868}]}],
                                                                                                 'tx_power': 19},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.4158454,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 136.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '497000',
                                                                                                                                                     'distance': 3356,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -86.518135}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 0.6908307,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -15.377223,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4565',
                                                                       'in_octets': '1257572370',
                                                                       'in_ucast_pkts': '9246443',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '23973207484',
                                                                       'out_ucast_pkts': '19323235',
                                                                       'poller_hash': 'UzE0MkYyMjIzNTAwMjAyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.01100540161133,
                                         'longitude': -88.91854095458984,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'William_Armstrong',
                                         'poller_hash': 'UzE0MkYyMjIzNTAwMjAy',
                                         'serial_number': 'S142F2223500202',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 29.751,
                                         'uptime': '497316'},
                                 {       'cpu': 21.537691,
                                         'elevation': 5.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '140398968101',
                                                                       'in_ucast_pkts': '97085680',
                                                                       'links': [       {       'in_octets': '140398968101',
                                                                                                'in_ucast_pkts': '97085680',
                                                                                                'out_octets': '5174840865',
                                                                                                'out_ucast_pkts': '44486433',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '5174840865',
                                                                       'out_ucast_pkts': '44486433',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NTAzMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.055592,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 149.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '488676',
                                                                                                                                                     'distance': 9487,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -91.94151}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 8.859931,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '488676',
                                                                                                                                                     'distance': 9487,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -92.987465}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 13.459937,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '21',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '28122',
                                                                       'in_octets': '23131267296',
                                                                       'in_ucast_pkts': '220427275',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '698677196047',
                                                                       'out_ucast_pkts': '481444584',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NTAzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.04951095581055,
                                         'longitude': -88.8168716430664,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Kelsey_Stroud',
                                         'poller_hash': 'UzE0MkYyMjIyMjA1NTAz',
                                         'serial_number': 'S142F2222205503',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 28.996,
                                         'uptime': '2261784'},
                                 {       'cpu': 19.253233,
                                         'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '16927660191',
                                                                       'in_ucast_pkts': '14661232',
                                                                       'links': [       {       'in_octets': '16927660191',
                                                                                                'in_ucast_pkts': '14661232',
                                                                                                'out_octets': '1262509508',
                                                                                                'out_ucast_pkts': '7229877',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1262509508',
                                                                       'out_ucast_pkts': '7229877',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2Mzc2MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.964775,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '410319',
                                                                                                                                                     'distance': 2539,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -91.52017}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.3289866,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '410319',
                                                                                                                                                     'distance': 2539,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -93.09699}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 17.65667,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 1.5949677,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '45871',
                                                                       'in_octets': '12059435024',
                                                                       'in_ucast_pkts': '53891611',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '123364818270',
                                                                       'out_ucast_pkts': '113545243',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2Mzc2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.008548736572266,
                                         'longitude': -88.90560913085938,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7035775,
                                         'model': '30-0142-001',
                                         'name': 'Marsha_Wyant',
                                         'poller_hash': 'UzE0MkYyMjIxNzA2Mzc2',
                                         'serial_number': 'S142F2221706376',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 32.77,
                                         'uptime': '4233666'},
                                 {       'cpu': 20.759441,
                                         'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '184101143312',
                                                                       'in_ucast_pkts': '125280866',
                                                                       'links': [       {       'in_octets': '184101143312',
                                                                                                'in_ucast_pkts': '125280866',
                                                                                                'out_octets': '7743503178',
                                                                                                'out_ucast_pkts': '85439536',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '7743503178',
                                                                       'out_ucast_pkts': '85439536',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjAzNTk0MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.181511,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 130.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '368250',
                                                                                                                                                     'distance': 87,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -79.68096}]}],
                                                                                                 'tx_power': -53},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 8.141134,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 130.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '368250',
                                                                                                                                                     'distance': 87,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -81.816696}]}],
                                                                                                 'tx_power': -53}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': -0.0071071624,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -19.213448,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3504',
                                                                       'in_octets': '7743173067',
                                                                       'in_ucast_pkts': '85430448',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '183581126420',
                                                                       'out_ucast_pkts': '125269074',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjAzNTk0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.98866653442383,
                                         'longitude': -88.89169311523438,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Dawn_Sullivan_8311HQ',
                                         'poller_hash': 'UzE0MkYyMjIyMjAzNTk0',
                                         'serial_number': 'S142F2222203594',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 28.357,
                                         'uptime': '369094'},
                                 {       'cpu': 20.422241,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '33247475528',
                                                                       'in_ucast_pkts': '27175994',
                                                                       'links': [       {       'in_octets': '33247475528',
                                                                                                'in_ucast_pkts': '27175994',
                                                                                                'out_octets': '2649795479',
                                                                                                'out_ucast_pkts': '15291496',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2649795479',
                                                                       'out_ucast_pkts': '15291496',
                                                                       'poller_hash': 'UzE0MkYyMjIzNDAwNzU0MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.377423,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 139.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '335400',
                                                                                                                                                     'distance': 8622,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -87.07505}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.310751,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 142.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '335400',
                                                                                                                                                     'distance': 8622,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -88.54706}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -9.483688,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '3',
                                                                       'in_errors': '2',
                                                                       'in_nucast_pkts': '3146',
                                                                       'in_octets': '2651067949',
                                                                       'in_ucast_pkts': '15290204',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '33131363466',
                                                                       'out_ucast_pkts': '27170621',
                                                                       'poller_hash': 'UzE0MkYyMjIzNDAwNzU0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.03839874267578,
                                         'longitude': -88.81697082519531,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'JonesArview_22099',
                                         'poller_hash': 'UzE0MkYyMjIzNDAwNzU0',
                                         'serial_number': 'S142F2223400754',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 29.751,
                                         'uptime': '335792'},
                                 {       'cpu': 21.357035,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '8424206679',
                                                                       'in_ucast_pkts': '7895845',
                                                                       'links': [       {       'in_octets': '8424206679',
                                                                                                'in_ucast_pkts': '7895845',
                                                                                                'out_octets': '1094492842',
                                                                                                'out_ucast_pkts': '6887613',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1094492842',
                                                                       'out_ucast_pkts': '6887613',
                                                                       'poller_hash': 'UzE0MkYyMjIzODAzNTM3MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.7363305,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 133.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '174600',
                                                                                                                                                     'distance': 6170,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -85.22162}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 8.44824,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 132.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '174600',
                                                                                                                                                     'distance': 6170,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -85.929985}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1687',
                                                                       'in_octets': '1094898429',
                                                                       'in_ucast_pkts': '6886392',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '8392731846',
                                                                       'out_ucast_pkts': '7896277',
                                                                       'poller_hash': 'UzE0MkYyMjIzODAzNTM3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.042510986328125,
                                         'longitude': -88.9098129272461,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Stowers_Derek_19338HQ',
                                         'poller_hash': 'UzE0MkYyMjIzODAzNTM3',
                                         'serial_number': 'S142F2223803537',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.738,
                                         'uptime': '175142'},
                                 {       'cpu': 21.205172,
                                         'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '378606716',
                                                                       'in_ucast_pkts': '530178',
                                                                       'links': [       {       'in_octets': '378606716',
                                                                                                'in_ucast_pkts': '530178',
                                                                                                'out_octets': '52129655',
                                                                                                'out_ucast_pkts': '466077',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '52129655',
                                                                       'out_ucast_pkts': '466077',
                                                                       'poller_hash': 'UzE0MkYyMjIyMDAwMDc5MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.8966203,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 131.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '79750',
                                                                                                                                                     'distance': 4991,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -81.10944}]}],
                                                                                                 'tx_power': 17},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 14.242602,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 132.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '79750',
                                                                                                                                                     'distance': 4991,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -83.73388}]}],
                                                                                                 'tx_power': -56}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 1.4604943,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -13.413069,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '864',
                                                                       'in_octets': '52167573',
                                                                       'in_ucast_pkts': '465125',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '376415348',
                                                                       'out_ucast_pkts': '529968',
                                                                       'poller_hash': 'UzE0MkYyMjIyMDAwMDc5Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.023128509521484,
                                         'longitude': -88.85501861572266,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'merrill_rose_8486',
                                         'poller_hash': 'UzE0MkYyMjIyMDAwMDc5',
                                         'serial_number': 'S142F2222000079',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 28.416,
                                         'uptime': '80297'},
                                 {       'cpu': 19.824524,
                                         'elevation': 3.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '2576243597',
                                                                       'in_ucast_pkts': '1895776',
                                                                       'links': [       {       'in_octets': '2576243597',
                                                                                                'in_ucast_pkts': '1895776',
                                                                                                'out_octets': '105755144',
                                                                                                'out_ucast_pkts': '955277',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '105755144',
                                                                       'out_ucast_pkts': '955277',
                                                                       'poller_hash': 'UzE0MkYyMjIyMDAyMzMzMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.944728,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 148.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '74117',
                                                                                                                                                     'distance': 4602,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -88.99927}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 7.56951,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 149.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '74117',
                                                                                                                                                     'distance': 4602,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -90.892105}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 0.26963562,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6359',
                                                                       'in_octets': '985946153',
                                                                       'in_ucast_pkts': '7968892',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '22850546779',
                                                                       'out_ucast_pkts': '17453875',
                                                                       'poller_hash': 'UzE0MkYyMjIyMDAyMzMzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.02571105957031,
                                         'longitude': -88.86808013916016,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Forsythe_Sandy_20054',
                                         'poller_hash': 'UzE0MkYyMjIyMDAyMzMz',
                                         'serial_number': 'S142F2222002333',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 28.532,
                                         'uptime': '661675'},
                                 {       'cpu': 22.308336,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '179038668841',
                                                                       'in_ucast_pkts': '160763414',
                                                                       'links': [       {       'in_octets': '179038668841',
                                                                                                'in_ucast_pkts': '160763414',
                                                                                                'out_octets': '22033348629',
                                                                                                'out_ucast_pkts': '96797455',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '22033348629',
                                                                       'out_ucast_pkts': '96797455',
                                                                       'poller_hash': 'UzE0MkYyMjIzNTAwMTM5MQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.2011185,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 128.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3994265',
                                                                                                                                                     'distance': 6231,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -83.36334}]}],
                                                                                                 'tx_power': -56},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 8.812829,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 127.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3994265',
                                                                                                                                                     'distance': 6231,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -82.859856}]}],
                                                                                                 'tx_power': -56}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 0.866103,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -20.296928,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '359',
                                                                       'in_octets': '22041665953',
                                                                       'in_ucast_pkts': '96812516',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '178401874023',
                                                                       'out_ucast_pkts': '160800637',
                                                                       'poller_hash': 'UzE0MkYyMjIzNTAwMTM5Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.0434684753418,
                                         'longitude': -88.90764617919922,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Ricky_Robinson',
                                         'poller_hash': 'UzE0MkYyMjIzNTAwMTM5',
                                         'serial_number': 'S142F2223500139',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 28.474,
                                         'uptime': '3994730'},
                                 {       'cpu': 20.57057,
                                         'elevation': 10.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '382757607427',
                                                                       'in_ucast_pkts': '304117214',
                                                                       'links': [       {       'in_octets': '382757607427',
                                                                                                'in_ucast_pkts': '304117214',
                                                                                                'out_octets': '25988630317',
                                                                                                'out_ucast_pkts': '158514494',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '25988630317',
                                                                       'out_ucast_pkts': '158514494',
                                                                       'poller_hash': 'UzE0MkYyMjIyMDAwMjYxMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 6.4952254,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 146.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3045811',
                                                                                                                                                     'distance': 5071,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -91.726326}]}],
                                                                                                 'tx_power': -50},
                                                                                         {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3660,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_max_interference_noise_ratio': 10.902691,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 144.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3045811',
                                                                                                                                                     'distance': 5071,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                                                                                                                     'rssi': -91.70657}]}],
                                                                                                 'tx_power': -50}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -9.722099,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '4',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '27263',
                                                                       'in_octets': '25995742125',
                                                                       'in_ucast_pkts': '158498786',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '381545853417',
                                                                       'out_ucast_pkts': '304125775',
                                                                       'poller_hash': 'UzE0MkYyMjIyMDAwMjYxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.03155517578125,
                                         'longitude': -88.87805938720703,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Poole_Dennis_17811',
                                         'poller_hash': 'UzE0MkYyMjIyMDAwMjYx',
                                         'serial_number': 'S142F2222000261',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 27.719,
                                         'uptime': '3046131'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tarana_tarana_30_0141_001_0_988_004_00_10_100_0_10(self):
        obj = self.run_data("tarana.tarana.30-0141-001.0.988.004.00.10_100_0_10")
        exp_info = {
                'model': '30-0141-001',
                'sta_count': 4,
                'sw_version': '0.988.004.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S141F2222312193',
                'system_mac_address': '04:f1:7d:00:89:64',
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                '04:f1:7d:00:2a:60': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 744027980,
                                             'dl_rf_packets': 630686,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:2a:60',
                                             'name': '1277-PAXTON_HANGAR-FREE-R',
                                             'serial_number': 'S154F1212600026',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 87655892,
                                             'ul_rf_packets': 240998},
                '04:f1:7d:00:2b:67': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 449024948,
                                             'dl_rf_packets': 402242,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:2b:67',
                                             'name': '1279-PAXTON_TOWN_HALL-FREE-R',
                                             'serial_number': 'S154F1212900008',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 52878472,
                                             'ul_rf_packets': 333004},
                '04:f1:7d:00:3c:e1': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 699707366688,
                                             'dl_rf_packets': 527943854,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:3c:e1',
                                             'name': '492-SCOTT_ANDERSON-RES100-R',
                                             'serial_number': 'S142F1214900123',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 149350617247,
                                             'ul_rf_packets': 430040870},
                '04:f1:7d:00:ef:7d': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 63168865530,
                                             'dl_rf_packets': 50067436,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:ef:7d',
                                             'name': '2382-SHELLEY_SMITH-RES100-R',
                                             'serial_number': 'S142F2224001956',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 4207592885,
                                             'ul_rf_packets': 21011515}
        }
        exp_ne_msg = {
                'data': {       'cpu': 33.175354,
                                'elevation': 167.032,
                                'gps_sats_tracked': 16,
                                'height': 0.0,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '11219299',
                                                                                       'in_octets': '149350617247',
                                                                                       'in_ucast_pkts': '430040870',
                                                                                       'out_errors': '38693684',
                                                                                       'out_octets': '699707366688',
                                                                                       'out_ucast_pkts': '527943854',
                                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMTIzMQ=='},
                                                                               {       'in_errors': '131054',
                                                                                       'in_octets': '4207592885',
                                                                                       'in_ucast_pkts': '21011515',
                                                                                       'out_errors': '1299750',
                                                                                       'out_octets': '63168865530',
                                                                                       'out_ucast_pkts': '50067436',
                                                                                       'poller_hash': 'UzE0MkYyMjI0MDAxOTU2MQ=='},
                                                                               {       'in_errors': '7012',
                                                                                       'in_octets': '52878472',
                                                                                       'in_ucast_pkts': '333004',
                                                                                       'out_errors': '263',
                                                                                       'out_octets': '449024948',
                                                                                       'out_ucast_pkts': '402242',
                                                                                       'poller_hash': 'UzE1NEYxMjEyOTAwMDA4MQ=='},
                                                                               {       'in_errors': '3817',
                                                                                       'in_octets': '87655892',
                                                                                       'in_ucast_pkts': '240998',
                                                                                       'out_errors': '14563',
                                                                                       'out_octets': '744027980',
                                                                                       'out_ucast_pkts': '630686',
                                                                                       'poller_hash': 'UzE1NEYxMjEyNjAwMDI2MQ=='}],
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzE0MUYyMjIyMzEyMTkzd2wx',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'dl_percent': 82,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 3600,
                                                                                        'gps_sync': True,
                                                                                        'id': '0',
                                                                                        'rx_max_interference_noise_ratio': 9.797392,
                                                                                        'rx_max_sensitivity_loss': 0.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1757526',
                                                                                                                                            'distance': 2144,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0OTAwMTIzMQ==',
                                                                                                                                            'rssi': -77.50168},
                                                                                                                                    {       'connected_time': '710026',
                                                                                                                                            'distance': 314,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjI0MDAxOTU2MQ==',
                                                                                                                                            'rssi': -77.50168},
                                                                                                                                    {       'connected_time': '458583',
                                                                                                                                            'distance': 710,
                                                                                                                                            'poller_hash': 'UzE1NEYxMjEyOTAwMDA4MQ==',
                                                                                                                                            'rssi': -77.50168},
                                                                                                                                    {       'connected_time': '155326',
                                                                                                                                            'distance': 247,
                                                                                                                                            'poller_hash': 'UzE1NEYxMjEyNjAwMDI2MQ==',
                                                                                                                                            'rssi': -77.50168}]}],
                                                                                        'tx_power': 22},
                                                                                {       'chan_width': 40,
                                                                                        'dl_percent': 82,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 3680,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'rx_max_interference_noise_ratio': 27.4458,
                                                                                        'rx_max_sensitivity_loss': 0.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1757526',
                                                                                                                                            'distance': 2144,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0OTAwMTIzMQ==',
                                                                                                                                            'rssi': -84.9038},
                                                                                                                                    {       'connected_time': '710026',
                                                                                                                                            'distance': 314,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjI0MDAxOTU2MQ==',
                                                                                                                                            'rssi': -84.9038},
                                                                                                                                    {       'connected_time': '458583',
                                                                                                                                            'distance': 710,
                                                                                                                                            'poller_hash': 'UzE1NEYxMjEyOTAwMDA4MQ==',
                                                                                                                                            'rssi': -84.9038},
                                                                                                                                    {       'connected_time': '155326',
                                                                                                                                            'distance': 247,
                                                                                                                                            'poller_hash': 'UzE1NEYxMjEyNjAwMDI2MQ==',
                                                                                                                                            'rssi': -84.9038}]}],
                                                                                        'tx_power': -46}],
                                                              'rf_aggregation_groups': [       {       'airtime': 2.5073175,
                                                                                                       'name': 'rf_group'}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': True,
                                                              'id': 'gi1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '492',
                                                              'out_octets': '36490',
                                                              'poller_hash': 'UzE0MUYyMjIyMzEyMTkzZ2kx'},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '4',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '2175250',
                                                              'in_octets': '965834268472',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '1201191',
                                                              'out_octets': '194569597528',
                                                              'poller_hash': 'UzE0MUYyMjIyMzEyMTkzZXgx',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '147',
                                                              'out_octets': '11010',
                                                              'poller_hash': 'UzE0MUYyMjIyMzEyMTkzZXgy'}],
                                'latitude': 30.96637725830078,
                                'longitude': -86.30143737792969,
                                'manufacturer': 'Tarana',
                                'mem': 2.2269354,
                                'model': '30-0141-001',
                                'poller_hash': 'UzE0MUYyMjIyMzEyMTkz',
                                'serial_number': 'S141F2222312193',
                                'sw_version': '0.988.004.00',
                                'system_mac_address': '04:f1:7d:00:89:64',
                                'temperature': 47.625,
                                'uptime': '1758163'},
                'peers': [       {       'cpu': 21.63992,
                                         'elevation': 10.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '699707366688',
                                                                       'in_ucast_pkts': '527943854',
                                                                       'links': [       {       'in_octets': '699707366688',
                                                                                                'in_ucast_pkts': '527943854',
                                                                                                'out_octets': '149350617247',
                                                                                                'out_ucast_pkts': '430040870',
                                                                                                'poller_hash': 'UzE0MUYyMjIyMzEyMTkzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '149350617247',
                                                                       'out_ucast_pkts': '430040870',
                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMTIzMQ==',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3600,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '0',
                                                                                                 'rx_max_interference_noise_ratio': 7.005174,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 145.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1757526',
                                                                                                                                                     'distance': 2144,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIyMzEyMTkzd2wx',
                                                                                                                                                     'rssi': -89.275566}]}],
                                                                                                 'tx_power': 30},
                       