import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase


class TestBdcomModels(DeviceTestCase):

    def test_bdcom_p3600_P3310D_10_7_90_12(self):
        obj = self.run_data("bdcom.p3600.P3310D.10_7_90_12")
        exp_info = {
                'model': 'P3310D',
                'sta_count': 23,
                'sw_version': '10.1.0F Build 74816',
                'vendor': 'BDCOM'
        }
        exp_stats = {
         'serial_number': '00325001127'
        }
        exp_sta_stats = {
                '1c:ef:03:05:a8:c2': {       'dev_macs': [       '1c:56:8e:32:e9:51',
                                                                 '1c:ef:03:05:a8:c3'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:05:a8:c2',
                                             'name': 'EPON0/2:12',
                                             'serial_number': None},
                '1c:ef:03:bd:cd:a2': {       'dev_macs': ['1c:ef:03:bd:cd:a3'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:bd:cd:a2',
                                             'name': 'EPON0/2:15',
                                             'serial_number': None},
                '1c:ef:03:bd:cf:12': {       'dev_macs': ['1c:ef:03:bd:cf:13'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:bd:cf:12',
                                             'name': 'EPON0/2:13',
                                             'serial_number': None},
                '1c:ef:03:d6:88:ad': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:d6:88:ad',
                                             'name': 'EPON0/2:10',
                                             'serial_number': None},
                '1c:ef:03:d6:89:4d': {       'dev_macs': ['1c:ef:03:d6:89:4e'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:d6:89:4d',
                                             'name': 'EPON0/2:11',
                                             'serial_number': None},
                '1c:ef:03:d6:8d:5d': {       'dev_macs': ['1c:ef:03:d6:8d:5e'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:d6:8d:5d',
                                             'name': 'EPON0/1:18',
                                             'serial_number': None},
                '1c:ef:03:d6:9d:5d': {       'dev_macs': ['1c:ef:03:d6:9d:5e'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:d6:9d:5d',
                                             'name': 'EPON0/1:17',
                                             'serial_number': None},
                '6c:68:a4:2c:88:56': {       'dev_macs': ['6c:68:a4:2c:88:57'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:2c:88:56',
                                             'name': 'EPON0/2:14',
                                             'serial_number': None},
                '70:b6:4f:00:0b:48': {       'dev_macs': ['40:ee:15:3e:8e:99'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:00:0b:48',
                                             'name': 'EPON0/2:2',
                                             'serial_number': None},
                '70:b6:4f:00:2c:18': {       'dev_macs': ['40:ee:15:3f:24:d9'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:00:2c:18',
                                             'name': 'EPON0/1:3',
                                             'serial_number': None},
                '70:b6:4f:4d:96:90': {       'dev_macs': [       '40:ee:15:51:fd:8d',
                                                                 '70:b6:4f:4d:96:91'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:4d:96:90',
                                             'name': 'EPON0/2:8',
                                             'serial_number': None},
                '70:b6:4f:4d:bb:00': {       'dev_macs': [       '40:ee:15:6f:f4:c9',
                                                                 '70:b6:4f:4d:bb:01'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:4d:bb:00',
                                             'name': 'EPON0/1:4',
                                             'serial_number': None},
                '70:b6:4f:78:cb:88': {       'dev_macs': [       '40:ee:15:3d:c1:09',
                                                                 '70:b6:4f:78:cb:89'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:78:cb:88',
                                             'name': 'EPON0/1:15',
                                             'serial_number': None},
                '70:b6:4f:79:14:a0': {       'dev_macs': [       '40:ee:15:3d:e0:c1',
                                                                 '70:b6:4f:79:14:a1'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:79:14:a0',
                                             'name': 'EPON0/1:10',
                                             'serial_number': None},
                '70:b6:4f:79:55:b8': {       'dev_macs': [       '40:ee:15:6f:50:e1',
                                                                 '70:b6:4f:79:55:b9'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:79:55:b8',
                                             'name': 'EPON0/1:14',
                                             'serial_number': None},
                '70:b6:4f:79:57:08': {       'dev_macs': [       '40:ee:15:5c:0b:05',
                                                                 '70:b6:4f:79:57:09'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:79:57:08',
                                             'name': 'EPON0/1:1',
                                             'serial_number': None},
                '70:b6:4f:d1:57:08': {       'dev_macs': [       '40:ee:15:50:62:3d',
                                                                 '70:b6:4f:d1:57:09'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:d1:57:08',
                                             'name': 'EPON0/1:12',
                                             'serial_number': None},
                '70:b6:4f:d1:cf:48': {       'dev_macs': [       '40:ee:15:69:37:69',
                                                                 '70:b6:4f:d1:cf:49'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:d1:cf:48',
                                             'name': 'EPON0/1:13',
                                             'serial_number': None},
                '80:07:1b:38:00:e8': {       'dev_macs': ['40:ee:15:3d:e1:11'],
                                             'ip_address': None,
                                             'mac_address': '80:07:1b:38:00:e8',
                                             'name': 'EPON0/1:8',
                                             'serial_number': None},
                '80:07:1b:98:b8:58': {       'dev_macs': ['40:ee:15:6f:1b:31'],
                                             'ip_address': None,
                                             'mac_address': '80:07:1b:98:b8:58',
                                             'name': 'EPON0/1:2',
                                             'serial_number': None},
                '98:45:62:9f:3b:ac': {       'dev_macs': ['1c:56:8e:32:ce:51'],
                                             'ip_address': None,
                                             'mac_address': '98:45:62:9f:3b:ac',
                                             'name': 'EPON0/2:5',
                                             'serial_number': None},
                '98:45:62:aa:5b:e7': {       'dev_macs': ['e8:65:d4:83:a9:c8'],
                                             'ip_address': None,
                                             'mac_address': '98:45:62:aa:5b:e7',
                                             'name': 'EPON0/2:4',
                                             'serial_number': None},
                '98:45:62:d8:37:2a': {       'dev_macs': ['40:ee:15:3d:85:31'],
                                             'ip_address': None,
                                             'mac_address': '98:45:62:d8:37:2a',
                                             'name': 'EPON0/1:16',
                                             'serial_number': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 32.0,
                                'interfaces': [       {       'admin_up': False,
                                                              'id': '10',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '98:45:62:96:38:1e',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/2',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MWVpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '11',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '98:45:62:96:38:1f',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/3',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MWZpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '12',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '98:45:62:96:38:20',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/4',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjBpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '13',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '98:45:62:96:38:21',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/5',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjFpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '14',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '98:45:62:96:38:22',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/6',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjJpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '15',
                                                              'in_discards': '9',
                                                              'in_errors': '9',
                                                              'in_nucast_pkts': '17929',
                                                              'in_octets': '140982718035',
                                                              'in_ucast_pkts': '279891014',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2159',
                                                                                       'in_octets': '1035597521',
                                                                                       'in_ucast_pkts': '2495753',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '163372898',
                                                                                       'out_ucast_pkts': '1310617',
                                                                                       'poller_hash': 'NzA6YjY6NGY6Nzk6NTc6MDhpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '1',
                                                                                       'in_octets': '11091919063',
                                                                                       'in_ucast_pkts': '31906963',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '107418255112',
                                                                                       'out_ucast_pkts': '85900409',
                                                                                       'poller_hash': 'ODA6MDc6MWI6OTg6Yjg6NThpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '12',
                                                                                       'in_octets': '7367125726',
                                                                                       'in_ucast_pkts': '16643730',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '30950603463',
                                                                                       'out_ucast_pkts': '28057005',
                                                                                       'poller_hash': 'NzA6YjY6NGY6MDA6MmM6MThpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2749',
                                                                                       'in_octets': '1286630549',
                                                                                       'in_ucast_pkts': '5681387',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '19663813919',
                                                                                       'out_ucast_pkts': '14862842',
                                                                                       'poller_hash': 'NzA6YjY6NGY6NGQ6YmI6MDBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '1',
                                                                                       'in_octets': '29876216439',
                                                                                       'in_ucast_pkts': '28252887',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '36576260650',
                                                                                       'out_ucast_pkts': '37615828',
                                                                                       'poller_hash': 'ODA6MDc6MWI6Mzg6MDA6ZThpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2621',
                                                                                       'in_octets': '27182041650',
                                                                                       'in_ucast_pkts': '27312689',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '25425373519',
                                                                                       'out_ucast_pkts': '28380921',
                                                                                       'poller_hash': 'NzA6YjY6NGY6Nzk6MTQ6YTBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2636',
                                                                                       'in_octets': '12898166279',
                                                                                       'in_ucast_pkts': '37114423',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '92739063558',
                                                                                       'out_ucast_pkts': '65751144',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZDE6NTc6MDhpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2441',
                                                                                       'in_octets': '1963983265',
                                                                                       'in_ucast_pkts': '7787599',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '29134246557',
                                                                                       'out_ucast_pkts': '22867670',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZDE6Y2Y6NDhpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2607',
                                                                                       'in_octets': '19109664916',
                                                                                       'in_ucast_pkts': '32210729',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '59348661266',
                                                                                       'out_ucast_pkts': '49987346',
                                                                                       'poller_hash': 'NzA6YjY6NGY6Nzk6NTU6YjhpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2690',
                                                                                       'in_octets': '1016546284',
                                                                                       'in_ucast_pkts': '6025437',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '35005488575',
                                                                                       'out_ucast_pkts': '24786349',
                                                                                       'poller_hash': 'NzA6YjY6NGY6Nzg6Y2I6ODhpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '1',
                                                                                       'in_octets': '1244782132',
                                                                                       'in_ucast_pkts': '3082783',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '13659305316',
                                                                                       'out_ucast_pkts': '10659586',
                                                                                       'poller_hash': 'OTg6NDU6NjI6ZDg6Mzc6MmFpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '7',
                                                                                       'in_octets': '5162048618',
                                                                                       'in_ucast_pkts': '16352480',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '70137150293',
                                                                                       'out_ucast_pkts': '52019299',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6ZDY6OWQ6NWRpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '4',
                                                                                       'in_octets': '21747995593',
                                                                                       'in_ucast_pkts': '65024154',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '160591682406',
                                                                                       'out_ucast_pkts': '120038783',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6ZDY6OGQ6NWRpbnRm'}],
                                                              'mac_address': '98:45:62:96:38:23',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '95035',
                                                              'out_octets': '680826508271',
                                                              'out_ucast_pkts': '542237794',
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                              'pons': [       {       'description': '0/1',
                                                                                      'id': '15',
                                                                                      'links': [       {       'fiber_length': 1169,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6Nzk6NTc6MDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.0,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 4.7},
                                                                                                       {       'fiber_length': 1224,
                                                                                                               'poller_hash': 'ODA6MDc6MWI6OTg6Yjg6NThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -21.4,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 4.7},
                                                                                                       {       'fiber_length': 1114,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6MDA6MmM6MThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.9,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 4.7},
                                                                                                       {       'fiber_length': 953,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6NGQ6YmI6MDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -21.0,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 4.7},
                                                                                                       {       'fiber_length': 935,
                                                                                                               'poller_hash': 'ODA6MDc6MWI6Mzg6MDA6ZThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -21.0,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 4.7},
                                                                                                       {       'fiber_length': 1140,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6Nzk6MTQ6YTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.5,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 4.7},
                                                                                                       {       'fiber_length': 857,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZDE6NTc6MDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -20.1,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 4.7},
                                                                                                       {       'fiber_length': 1105,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZDE6Y2Y6NDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -23.7,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 4.7},
                                                                                                       {       'fiber_length': 1195,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6Nzk6NTU6YjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.6,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 4.7},
                                                                                                       {       'fiber_length': 908,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6Nzg6Y2I6ODhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.3,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 4.7},
                                                                                                       {       'fiber_length': 989,
                                                                                                               'poller_hash': 'OTg6NDU6NjI6ZDg6Mzc6MmFpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -23.7,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 4.7},
                                                                                                       {       'fiber_length': 1045,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6ZDY6OWQ6NWRpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -21.3,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 4.7},
                                                                                                       {       'fiber_length': 1131,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6ZDY6OGQ6NWRpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -21.6,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 4.7}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/1',
                                                                                      'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '16',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '5468',
                                                              'in_octets': '163725315288',
                                                              'in_ucast_pkts': '406928891',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '1',
                                                                                       'in_octets': '97784663',
                                                                                       'in_ucast_pkts': '561422',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2306403446',
                                                                                       'out_ucast_pkts': '1771537',
                                                                                       'poller_hash': 'NzA6YjY6NGY6MDA6MGI6NDhpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '2344803422',
                                                                                       'in_ucast_pkts': '15537749',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '120118878354',
                                                                                       'out_ucast_pkts': '86963960',
                                                                                       'poller_hash': 'OTg6NDU6NjI6YWE6NWI6ZTdpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '23',
                                                                                       'in_octets': '3325362519',
                                                                                       'in_ucast_pkts': '12340023',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '54162075875',
                                                                                       'out_ucast_pkts': '42015156',
                                                                                       'poller_hash': 'OTg6NDU6NjI6OWY6M2I6YWNpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2768',
                                                                                       'in_octets': '5928905610',
                                                                                       'in_ucast_pkts': '21854229',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '85674672119',
                                                                                       'out_ucast_pkts': '71321313',
                                                                                       'poller_hash': 'NzA6YjY6NGY6NGQ6OTY6OTBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '10',
                                                                                       'in_octets': '2811814106',
                                                                                       'in_ucast_pkts': '24787115',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '82717868792',
                                                                                       'out_ucast_pkts': '57310261',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6ZDY6ODg6YWRpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '4',
                                                                                       'in_octets': '4231853452',
                                                                                       'in_ucast_pkts': '43687026',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '125444750515',
                                                                                       'out_ucast_pkts': '84922443',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6ZDY6ODk6NGRpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2614',
                                                                                       'in_octets': '61735930',
                                                                                       'in_ucast_pkts': '366328',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '27392575',
                                                                                       'out_ucast_pkts': '169963',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6MDU6YTg6YzJpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '11',
                                                                                       'in_octets': '14262842463',
                                                                                       'in_ucast_pkts': '30290172',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '75803597917',
                                                                                       'out_ucast_pkts': '67317311',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6YmQ6Y2Y6MTJpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '26',
                                                                                       'in_octets': '127454407157',
                                                                                       'in_ucast_pkts': '232972907',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '446407518848',
                                                                                       'out_ucast_pkts': '334519816',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MmM6ODg6NTZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '9',
                                                                                       'in_octets': '3205898316',
                                                                                       'in_ucast_pkts': '24532694',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '73575057421',
                                                                                       'out_ucast_pkts': '51310915',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6YmQ6Y2Q6YTJpbnRm'}],
                                                              'mac_address': '98:45:62:96:38:24',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/2',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '95035',
                                                              'out_octets': '1066250290152',
                                                              'out_ucast_pkts': '797621757',
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm',
                                                              'pons': [       {       'description': '0/2',
                                                                                      'id': '16',
                                                                                      'links': [       {       'fiber_length': 958,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6MDA6MGI6NDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -21.8,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'fiber_length': 958,
                                                                                                               'poller_hash': 'OTg6NDU6NjI6YWE6NWI6ZTdpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -20.5,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'fiber_length': 982,
                                                                                                               'poller_hash': 'OTg6NDU6NjI6OWY6M2I6YWNpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -20.5,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'fiber_length': 1031,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6NGQ6OTY6OTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -20.5,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'fiber_length': 945,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6ZDY6ODg6YWRpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -21.1,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'fiber_length': 1055,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6ZDY6ODk6NGRpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -20.9,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'fiber_length': 1057,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6MDU6YTg6YzJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -20.0,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'fiber_length': 955,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6YmQ6Y2Y6MTJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -20.8,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'fiber_length': 1127,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MmM6ODg6NTZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -21.7,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'fiber_length': 927,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6YmQ6Y2Q6YTJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -24.2,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/2',
                                                                                      'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '17',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '98:45:62:96:38:25',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/3',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '77655',
                                                              'out_octets': '10867210',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjVpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '18',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '98:45:62:96:38:26',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/4',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '77655',
                                                              'out_octets': '10867210',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjZpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '9',
                                                              'in_discards': '416420',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '907017',
                                                              'in_octets': '1752942210720',
                                                              'in_ucast_pkts': '1344219525',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '98:45:62:96:38:1d',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '544815',
                                                              'out_octets': '307952179313',
                                                              'out_ucast_pkts': '691178385',
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MWRpbnRm',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'BDCOM',
                                'mem': 55.0,
                                'model': 'P3310D',
                                'serial_number': '00325001127',
                                'sw_version': '10.1.0F Build 74816',
                                'system_mac_address': '98:45:62:96:38:1c',
                                'temperature': 50.0},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '34',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '2306403446',
                                                                       'in_ucast_pkts': '1771537',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '2306403446',
                                                                                                'in_ucast_pkts': '1771537',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '1',
                                                                                                'out_octets': '97784663',
                                                                                                'out_ucast_pkts': '561422',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:2',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1',
                                                                       'out_octets': '97784663',
                                                                       'out_ucast_pkts': '561422',
                                                                       'poller_hash': 'NzA6YjY6NGY6MDA6MGI6NDhpbnRm',
                                                                       'pons': [       {       'description': '0/2:2',
                                                                                               'id': '34',
                                                                                               'links': [       {       'fiber_length': 958,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -16.4,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.6}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:2',
                                                                                               'poller_hash': 'NzA6YjY6NGY6MDA6MGI6NDhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ee:15:3e:8e:99'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1',
                                                                       'in_octets': '97784663',
                                                                       'in_ucast_pkts': '561422',
                                                                       'mac_address': '70:b6:4f:00:0b:48',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2306403446',
                                                                       'out_ucast_pkts': '1771537',
                                                                       'poller_hash': 'NzA6YjY6NGY6MDA6MGI6NDhldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'ALFOCOM',
                                         'model': 'AFEN-01GS',
                                         'name': 'EPON0/2:2',
                                         'poller_hash': 'NzA6YjY6NGY6MDA6MGI6NDhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V1.0.5',
                                         'system_mac_address': '70:b6:4f:00:0b:48'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '36',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '163372898',
                                                                       'in_ucast_pkts': '1310617',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '163372898',
                                                                                                'in_ucast_pkts': '1310617',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2159',
                                                                                                'out_octets': '1035597521',
                                                                                                'out_ucast_pkts': '2495753',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2159',
                                                                       'out_octets': '1035597521',
                                                                       'out_ucast_pkts': '2495753',
                                                                       'poller_hash': 'NzA6YjY6NGY6Nzk6NTc6MDhpbnRm',
                                                                       'pons': [       {       'description': '0/1:1',
                                                                                               'id': '36',
                                                                                               'links': [       {       'fiber_length': 1169,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -18.3,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.9}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:1',
                                                                                               'poller_hash': 'NzA6YjY6NGY6Nzk6NTc6MDhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ee:15:5c:0b:05',
                                                                                                        '70:b6:4f:79:57:09'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2159',
                                                                       'in_octets': '1035597521',
                                                                       'in_ucast_pkts': '2495753',
                                                                       'mac_address': '70:b6:4f:79:57:08',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '163372898',
                                                                       'out_ucast_pkts': '1310617',
                                                                       'poller_hash': 'NzA6YjY6NGY6Nzk6NTc6MDhldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'V2801SG',
                                         'name': 'EPON0/1:1',
                                         'poller_hash': 'NzA6YjY6NGY6Nzk6NTc6MDhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.8P1T8',
                                         'system_mac_address': '70:b6:4f:79:57:08'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '37',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '107418255112',
                                                                       'in_ucast_pkts': '85900409',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '107418255112',
                                                                                                'in_ucast_pkts': '85900409',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '1',
                                                                                                'out_octets': '11091919063',
                                                                                                'out_ucast_pkts': '31906963',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:2',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1',
                                                                       'out_octets': '11091919063',
                                                                       'out_ucast_pkts': '31906963',
                                                                       'poller_hash': 'ODA6MDc6MWI6OTg6Yjg6NThpbnRm',
                                                                       'pons': [       {       'description': '0/1:2',
                                                                                               'id': '37',
                                                                                               'links': [       {       'fiber_length': 1224,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.9}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/1:2',
                                                                                               'poller_hash': 'ODA6MDc6MWI6OTg6Yjg6NThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ee:15:6f:1b:31'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1',
                                                                       'in_octets': '11091919063',
                                                                       'in_ucast_pkts': '31906963',
                                                                       'mac_address': '80:07:1b:98:b8:58',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '107418255112',
                                                                       'out_ucast_pkts': '85900409',
                                                                       'poller_hash': 'ODA6MDc6MWI6OTg6Yjg6NThldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'ALFOCOM',
                                         'model': 'AFEN-01GS',
                                         'name': 'EPON0/1:2',
                                         'poller_hash': 'ODA6MDc6MWI6OTg6Yjg6NThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V1.0.3',
                                         'system_mac_address': '80:07:1b:98:b8:58'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '38',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '30950603463',
                                                                       'in_ucast_pkts': '28057005',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '30950603463',
                                                                                                'in_ucast_pkts': '28057005',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '12',
                                                                                                'out_octets': '7367125726',
                                                                                                'out_ucast_pkts': '16643730',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:3',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '12',
                                                                       'out_octets': '7367125726',
                                                                       'out_ucast_pkts': '16643730',
                                                                       'poller_hash': 'NzA6YjY6NGY6MDA6MmM6MThpbnRm',
                                                                       'pons': [       {       'description': '0/1:3',
                                                                                               'id': '38',
                                                                                               'links': [       {       'fiber_length': 1114,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -19.9,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.8}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/1:3',
                                                                                               'poller_hash': 'NzA6YjY6NGY6MDA6MmM6MThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ee:15:3f:24:d9'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '12',
                                                                       'in_octets': '7367125726',
                                                                       'in_ucast_pkts': '16643730',
                                                                       'mac_address': '70:b6:4f:00:2c:18',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '30950603463',
                                                                       'out_ucast_pkts': '28057005',
                                                                       'poller_hash': 'NzA6YjY6NGY6MDA6MmM6MThldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'ALFOCOM',
                                         'model': 'AFEN-01GS',
                                         'name': 'EPON0/1:3',
                                         'poller_hash': 'NzA6YjY6NGY6MDA6MmM6MThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V1.0.5',
                                         'system_mac_address': '70:b6:4f:00:2c:18'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '39',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '19663813919',
                                                                       'in_ucast_pkts': '14862842',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '19663813919',
                                                                                                'in_ucast_pkts': '14862842',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2749',
                                                                                                'out_octets': '1286630549',
                                                                                                'out_ucast_pkts': '5681387',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:4',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2749',
                                                                       'out_octets': '1286630549',
                                                                       'out_ucast_pkts': '5681387',
                                                                       'poller_hash': 'NzA6YjY6NGY6NGQ6YmI6MDBpbnRm',
                                                                       'pons': [       {       'description': '0/1:4',
                                                                                               'id': '39',
                                                                                               'links': [       {       'fiber_length': 953,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -17.4,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.3}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:4',
                                                                                               'poller_hash': 'NzA6YjY6NGY6NGQ6YmI6MDBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ee:15:6f:f4:c9',
                                                                                                        '70:b6:4f:4d:bb:01'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2749',
                                                                       'in_octets': '1286630549',
                                                                       'in_ucast_pkts': '5681387',
                                                                       'mac_address': '70:b6:4f:4d:bb:00',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '19663813919',
                                                                       'out_ucast_pkts': '14862842',
                                                                       'poller_hash': 'NzA6YjY6NGY6NGQ6YmI6MDBldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'V2801SG',
                                         'name': 'EPON0/1:4',
                                         'poller_hash': 'NzA6YjY6NGY6NGQ6YmI6MDBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.7P1T8',
                                         'system_mac_address': '70:b6:4f:4d:bb:00'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '40',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '120118878354',
                                                                       'in_ucast_pkts': '86963960',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '120118878354',
                                                                                                'in_ucast_pkts': '86963960',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '2344803422',
                                                                                                'out_ucast_pkts': '15537749',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:4',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '2344803422',
                                                                       'out_ucast_pkts': '15537749',
                                                                       'poller_hash': 'OTg6NDU6NjI6YWE6NWI6ZTdpbnRm',
                                                                       'pons': [       {       'description': '0/2:4',
                                                                                               'id': '40',
                                                                                               'links': [       {       'fiber_length': 958,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -14.4,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.9}],
                                                                                               'max_distance': 20000,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:4',
                                                                                               'poller_hash': 'OTg6NDU6NjI6YWE6NWI6ZTdpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:65:d4:83:a9:c8'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '2344803422',
                                                                       'in_ucast_pkts': '15537749',
                                                                       'mac_address': '98:45:62:aa:5b:e7',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '120118878354',
                                                                       'out_ucast_pkts': '86963960',
                                                                       'poller_hash': 'OTg6NDU6NjI6YWE6NWI6ZTdldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'BDCOM',
                                         'model': 'GP1501D1',
                                         'name': 'EPON0/2:4',
                                         'poller_hash': 'OTg6NDU6NjI6YWE6NWI6ZTdvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '10.0.26B.554',
                                         'system_mac_address': '98:45:62:aa:5b:e7'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '41',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '54162075875',
                                                                       'in_ucast_pkts': '42015156',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '54162075875',
                                                                                                'in_ucast_pkts': '42015156',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '23',
                                                                                                'out_octets': '3325362519',
                                                                                                'out_ucast_pkts': '12340023',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:5',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '23',
                                                                       'out_octets': '3325362519',
                                                                       'out_ucast_pkts': '12340023',
                                                                       'poller_hash': 'OTg6NDU6NjI6OWY6M2I6YWNpbnRm',
                                                                       'pons': [       {       'description': '0/2:5',
                                                                                               'id': '41',
                                                                                               'links': [       {       'fiber_length': 982,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -15.4,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:5',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OWY6M2I6YWNpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:56:8e:32:ce:51'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '23',
                                                                       'in_octets': '3325362519',
                                                                       'in_ucast_pkts': '12340023',
                                                                       'mac_address': '98:45:62:9f:3b:ac',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '54162075875',
                                                                       'out_ucast_pkts': '42015156',
                                                                       'poller_hash': 'OTg6NDU6NjI6OWY6M2I6YWNldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'BDCOM',
                                         'model': 'GP1501D1',
                                         'name': 'EPON0/2:5',
                                         'poller_hash': 'OTg6NDU6NjI6OWY6M2I6YWNvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '10.0.26B.554',
                                         'system_mac_address': '98:45:62:9f:3b:ac'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '47',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '85674672119',
                                                                       'in_ucast_pkts': '71321313',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '85674672119',
                                                                                                'in_ucast_pkts': '71321313',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2768',
                                                                                                'out_octets': '5928905610',
                                                                                                'out_ucast_pkts': '21854229',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:8',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2768',
                                                                       'out_octets': '5928905610',
                                                                       'out_ucast_pkts': '21854229',
                                                                       'poller_hash': 'NzA6YjY6NGY6NGQ6OTY6OTBpbnRm',
                                                                       'pons': [       {       'description': '0/2:8',
                                                                                               'id': '47',
                                                                                               'links': [       {       'fiber_length': 1031,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -16.6,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.3}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:8',
                                                                                               'poller_hash': 'NzA6YjY6NGY6NGQ6OTY6OTBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ee:15:51:fd:8d',
                                                                                                        '70:b6:4f:4d:96:91'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2768',
                                                                       'in_octets': '5928905610',
                                                                       'in_ucast_pkts': '21854229',
                                                                       'mac_address': '70:b6:4f:4d:96:90',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '85674672119',
                                                                       'out_ucast_pkts': '71321313',
                                                                       'poller_hash': 'NzA6YjY6NGY6NGQ6OTY6OTBldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'V2801SG',
                                         'name': 'EPON0/2:8',
                                         'poller_hash': 'NzA6YjY6NGY6NGQ6OTY6OTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.7P1T8',
                                         'system_mac_address': '70:b6:4f:4d:96:90'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '48',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '36576260650',
                                                                       'in_ucast_pkts': '37615828',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '36576260650',
                                                                                                'in_ucast_pkts': '37615828',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '1',
                                                                                                'out_octets': '29876216439',
                                                                                                'out_ucast_pkts': '28252887',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:8',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1',
                                                                       'out_octets': '29876216439',
                                                                       'out_ucast_pkts': '28252887',
                                                                       'poller_hash': 'ODA6MDc6MWI6Mzg6MDA6ZThpbnRm',
                                                                       'pons': [       {       'description': '0/1:8',
                                                                                               'id': '48',
                                                                                               'links': [       {       'fiber_length': 935,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.9}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:8',
                                                                                               'poller_hash': 'ODA6MDc6MWI6Mzg6MDA6ZThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ee:15:3d:e1:11'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1',
                                                                       'in_octets': '29876216439',
                                                                       'in_ucast_pkts': '28252887',
                                                                       'mac_address': '80:07:1b:38:00:e8',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '36576260650',
                                                                       'out_ucast_pkts': '37615828',
                                                                       'poller_hash': 'ODA6MDc6MWI6Mzg6MDA6ZThldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': '2801HE',
                                         'name': 'EPON0/1:8',
                                         'poller_hash': 'ODA6MDc6MWI6Mzg6MDA6ZThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V1.7.5',
                                         'system_mac_address': '80:07:1b:38:00:e8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '51',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '25425373519',
                                                                       'in_ucast_pkts': '28380921',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '25425373519',
                                                                                                'in_ucast_pkts': '28380921',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2621',
                                                                                                'out_octets': '27182041650',
                                                                                                'out_ucast_pkts': '27312689',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:10',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2621',
                                                                       'out_octets': '27182041650',
                                                                       'out_ucast_pkts': '27312689',
                                                                       'poller_hash': 'NzA6YjY6NGY6Nzk6MTQ6YTBpbnRm',
                                                                       'pons': [       {       'description': '0/1:10',
                                                                                               'id': '51',
                                                                                               'links': [       {       'fiber_length': 1140,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -18.9,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.8}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:10',
                                                                                               'poller_hash': 'NzA6YjY6NGY6Nzk6MTQ6YTBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ee:15:3d:e0:c1',
                                                                                                        '70:b6:4f:79:14:a1'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2621',
                                                                       'in_octets': '27182041650',
                                                                       'in_ucast_pkts': '27312689',
                                                                       'mac_address': '70:b6:4f:79:14:a0',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '25425373519',
                                                                       'out_ucast_pkts': '28380921',
                                                                       'poller_hash': 'NzA6YjY6NGY6Nzk6MTQ6YTBldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'V2801SG',
                                         'name': 'EPON0/1:10',
                                         'poller_hash': 'NzA6YjY6NGY6Nzk6MTQ6YTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.8P1T8',
                                         'system_mac_address': '70:b6:4f:79:14:a0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '53',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '82717868792',
                                                                       'in_ucast_pkts': '57310261',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '82717868792',
                                                                                                'in_ucast_pkts': '57310261',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '10',
                                                                                                'out_octets': '2811814106',
                                                                                                'out_ucast_pkts': '24787115',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:10',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '10',
                                                                       'out_octets': '2811814106',
                                                                       'out_ucast_pkts': '24787115',
                                                                       'poller_hash': 'MWM6ZWY6MDM6ZDY6ODg6YWRpbnRm',
                                                                       'pons': [       {       'description': '0/2:10',
                                                                                               'id': '53',
                                                                                               'links': [       {       'fiber_length': 945,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -15.1,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.3}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:10',
                                                                                               'poller_hash': 'MWM6ZWY6MDM6ZDY6ODg6YWRpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '10',
                                                                       'in_octets': '2811814106',
                                                                       'in_ucast_pkts': '24787115',
                                                                       'mac_address': '1c:ef:03:d6:88:ad',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '82717868792',
                                                                       'out_ucast_pkts': '57310261',
                                                                       'poller_hash': 'MWM6ZWY6MDM6ZDY6ODg6YWRldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/2:10',
                                         'poller_hash': 'MWM6ZWY6MDM6ZDY6ODg6YWRvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:d6:88:ad'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '54',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '92739063558',
                                                                       'in_ucast_pkts': '65751144',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '92739063558',
                                                                                                'in_ucast_pkts': '65751144',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2636',
                                                                                                'out_octets': '12898166279',
                                                                                                'out_ucast_pkts': '37114423',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:12',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2636',
                                                                       'out_octets': '12898166279',
                                                                       'out_ucast_pkts': '37114423',
                                                                       'poller_hash': 'NzA6YjY6NGY6ZDE6NTc6MDhpbnRm',
                                                                       'pons': [       {       'description': '0/1:12',
                                                                                               'id': '54',
                                                                                               'links': [       {       'fiber_length': 857,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -18.1,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:12',
                                                                                               'poller_hash': 'NzA6YjY6NGY6ZDE6NTc6MDhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ee:15:50:62:3d',
                                                                                                        '70:b6:4f:d1:57:09'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2636',
                                                                       'in_octets': '12898166279',
                                                                       'in_ucast_pkts': '37114423',
                                                                       'mac_address': '70:b6:4f:d1:57:08',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '92739063558',
                                                                       'out_ucast_pkts': '65751144',
                                                                       'poller_hash': 'NzA6YjY6NGY6ZDE6NTc6MDhldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'V2801SG',
                                         'name': 'EPON0/1:12',
                                         'poller_hash': 'NzA6YjY6NGY6ZDE6NTc6MDhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.8P1T8',
                                         'system_mac_address': '70:b6:4f:d1:57:08'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '55',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '29134246557',
                                                                       'in_ucast_pkts': '22867670',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '29134246557',
                                                                                                'in_ucast_pkts': '22867670',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2441',
                                                                                                'out_octets': '1963983265',
                                                                                                'out_ucast_pkts': '7787599',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:13',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2441',
                                                                       'out_octets': '1963983265',
                                                                       'out_ucast_pkts': '7787599',
                                                                       'poller_hash': 'NzA6YjY6NGY6ZDE6Y2Y6NDhpbnRm',
                                                                       'pons': [       {       'description': '0/1:13',
                                                                                               'id': '55',
                                                                                               'links': [       {       'fiber_length': 1105,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -22.9,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.3}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:13',
                                                                                               'poller_hash': 'NzA6YjY6NGY6ZDE6Y2Y6NDhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ee:15:69:37:69',
                                                                                                        '70:b6:4f:d1:cf:49'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2441',
                                                                       'in_octets': '1963983265',
                                                                       'in_ucast_pkts': '7787599',
                                                                       'mac_address': '70:b6:4f:d1:cf:48',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '29134246557',
                                                                       'out_ucast_pkts': '22867670',
                                                                       'poller_hash': 'NzA6YjY6NGY6ZDE6Y2Y6NDhldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'V2801SG',
                                         'name': 'EPON0/1:13',
                                         'poller_hash': 'NzA6YjY6NGY6ZDE6Y2Y6NDhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.8P1T8',
                                         'system_mac_address': '70:b6:4f:d1:cf:48'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '56',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '59348661266',
                                                                       'in_ucast_pkts': '49987346',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '59348661266',
                                                                                                'in_ucast_pkts': '49987346',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2607',
                                                                                                'out_octets': '19109664916',
                                                                                                'out_ucast_pkts': '32210729',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:14',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2607',
                                                                       'out_octets': '19109664916',
                                                                       'out_ucast_pkts': '32210729',
                                                                       'poller_hash': 'NzA6YjY6NGY6Nzk6NTU6YjhpbnRm',
                                                                       'pons': [       {       'description': '0/1:14',
                                                                                               'id': '56',
                                                                                               'links': [       {       'fiber_length': 1195,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.9}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:14',
                                                                                               'poller_hash': 'NzA6YjY6NGY6Nzk6NTU6YjhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ee:15:6f:50:e1',
                                                                                                        '70:b6:4f:79:55:b9'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2607',
                                                                       'in_octets': '19109664916',
                                                                       'in_ucast_pkts': '32210729',
                                                                       'mac_address': '70:b6:4f:79:55:b8',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '59348661266',
                                                                       'out_ucast_pkts': '49987346',
                                                                       'poller_hash': 'NzA6YjY6NGY6Nzk6NTU6YjhldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'V2801SG',
                                         'name': 'EPON0/1:14',
                                         'poller_hash': 'NzA6YjY6NGY6Nzk6NTU6YjhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.8P1T8',
                                         'system_mac_address': '70:b6:4f:79:55:b8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '57',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '35005488575',
                                                                       'in_ucast_pkts': '24786349',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '35005488575',
                                                                                                'in_ucast_pkts': '24786349',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2690',
                                                                                                'out_octets': '1016546284',
                                                                                                'out_ucast_pkts': '6025437',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:15',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2690',
                                                                       'out_octets': '1016546284',
                                                                       'out_ucast_pkts': '6025437',
                                                                       'poller_hash': 'NzA6YjY6NGY6Nzg6Y2I6ODhpbnRm',
                                                                       'pons': [       {       'description': '0/1:15',
                                                                                               'id': '57',
                                                                                               'links': [       {       'fiber_length': 908,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -18.4,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.8}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:15',
                                                                                               'poller_hash': 'NzA6YjY6NGY6Nzg6Y2I6ODhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ee:15:3d:c1:09',
                                                                                                        '70:b6:4f:78:cb:89'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2690',
                                                                       'in_octets': '1016546284',
                                                                       'in_ucast_pkts': '6025437',
                                                                       'mac_address': '70:b6:4f:78:cb:88',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '35005488575',
                                                                       'out_ucast_pkts': '24786349',
                                                                       'poller_hash': 'NzA6YjY6NGY6Nzg6Y2I6ODhldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'V2801SG',
                                         'name': 'EPON0/1:15',
                                         'poller_hash': 'NzA6YjY6NGY6Nzg6Y2I6ODhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.8P1T8',
                                         'system_mac_address': '70:b6:4f:78:cb:88'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '58',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '13659305316',
                                                                       'in_ucast_pkts': '10659586',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '13659305316',
                                                                                                'in_ucast_pkts': '10659586',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '1',
                                                                                                'out_octets': '1244782132',
                                                                                                'out_ucast_pkts': '3082783',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:16',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1',
                                                                       'out_octets': '1244782132',
                                                                       'out_ucast_pkts': '3082783',
                                                                       'poller_hash': 'OTg6NDU6NjI6ZDg6Mzc6MmFpbnRm',
                                                                       'pons': [       {       'description': '0/1:16',
                                                                                               'id': '58',
                                                                                               'links': [       {       'fiber_length': 989,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -20.2,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 20000,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:16',
                                                                                               'poller_hash': 'OTg6NDU6NjI6ZDg6Mzc6MmFpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ee:15:3d:85:31'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1',
                                                                       'in_octets': '1244782132',
                                                                       'in_ucast_pkts': '3082783',
                                                                       'mac_address': '98:45:62:d8:37:2a',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '13659305316',
                                                                       'out_ucast_pkts': '10659586',
                                                                       'poller_hash': 'OTg6NDU6NjI6ZDg6Mzc6MmFldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'BDCOM',
                                         'model': 'P1501D1',
                                         'name': 'EPON0/1:16',
                                         'poller_hash': 'OTg6NDU6NjI6ZDg6Mzc6MmFvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '10.0.26B.711',
                                         'system_mac_address': '98:45:62:d8:37:2a'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '59',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '70137150293',
                                                                       'in_ucast_pkts': '52019299',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '70137150293',
                                                                                                'in_ucast_pkts': '52019299',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '7',
                                                                                                'out_octets': '5162048618',
                                                                                                'out_ucast_pkts': '16352480',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:17',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7',
                                                                       'out_octets': '5162048618',
                                                                       'out_ucast_pkts': '16352480',
                                                                       'poller_hash': 'MWM6ZWY6MDM6ZDY6OWQ6NWRpbnRm',
                                                                       'pons': [       {       'description': '0/1:17',
                                                                                               'id': '59',
                                                                                               'links': [       {       'fiber_length': 1045,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -17.4,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.8}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:17',
                                                                                               'poller_hash': 'MWM6ZWY6MDM6ZDY6OWQ6NWRpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:ef:03:d6:9d:5e'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7',
                                                                       'in_octets': '5162048618',
                                                                       'in_ucast_pkts': '16352480',
                                                                       'mac_address': '1c:ef:03:d6:9d:5d',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '70137150293',
                                                                       'out_ucast_pkts': '52019299',
                                                                       'poller_hash': 'MWM6ZWY6MDM6ZDY6OWQ6NWRldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/1:17',
                                         'poller_hash': 'MWM6ZWY6MDM6ZDY6OWQ6NWRvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:d6:9d:5d'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '60',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '160591682406',
                                                                       'in_ucast_pkts': '120038783',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '160591682406',
                                                                                                'in_ucast_pkts': '120038783',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '4',
                                                                                                'out_octets': '21747995593',
                                                                                                'out_ucast_pkts': '65024154',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:18',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4',
                                                                       'out_octets': '21747995593',
                                                                       'out_ucast_pkts': '65024154',
                                                                       'poller_hash': 'MWM6ZWY6MDM6ZDY6OGQ6NWRpbnRm',
                                                                       'pons': [       {       'description': '0/1:18',
                                                                                               'id': '60',
                                                                                               'links': [       {       'fiber_length': 1131,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -18.4,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:18',
                                                                                               'poller_hash': 'MWM6ZWY6MDM6ZDY6OGQ6NWRpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:ef:03:d6:8d:5e'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4',
                                                                       'in_octets': '21747995593',
                                                                       'in_ucast_pkts': '65024154',
                                                                       'mac_address': '1c:ef:03:d6:8d:5d',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '160591682406',
                                                                       'out_ucast_pkts': '120038783',
                                                                       'poller_hash': 'MWM6ZWY6MDM6ZDY6OGQ6NWRldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/1:18',
                                         'poller_hash': 'MWM6ZWY6MDM6ZDY6OGQ6NWRvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:d6:8d:5d'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '61',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '125444750515',
                                                                       'in_ucast_pkts': '84922443',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '125444750515',
                                                                                                'in_ucast_pkts': '84922443',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '4',
                                                                                                'out_octets': '4231853452',
                                                                                                'out_ucast_pkts': '43687026',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:11',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4',
                                                                       'out_octets': '4231853452',
                                                                       'out_ucast_pkts': '43687026',
                                                                       'poller_hash': 'MWM6ZWY6MDM6ZDY6ODk6NGRpbnRm',
                                                                       'pons': [       {       'description': '0/2:11',
                                                                                               'id': '61',
                                                                                               'links': [       {       'fiber_length': 1055,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -15.2,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:11',
                                                                                               'poller_hash': 'MWM6ZWY6MDM6ZDY6ODk6NGRpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:ef:03:d6:89:4e'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4',
                                                                       'in_octets': '4231853452',
                                                                       'in_ucast_pkts': '43687026',
                                                                       'mac_address': '1c:ef:03:d6:89:4d',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '125444750515',
                                                                       'out_ucast_pkts': '84922443',
                                                                       'poller_hash': 'MWM6ZWY6MDM6ZDY6ODk6NGRldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/2:11',
                                         'poller_hash': 'MWM6ZWY6MDM6ZDY6ODk6NGRvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:d6:89:4d'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '62',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '27392575',
                                                                       'in_ucast_pkts': '169963',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '27392575',
                                                                                                'in_ucast_pkts': '169963',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2614',
                                                                                                'out_octets': '61735930',
                                                                                                'out_ucast_pkts': '366328',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:12',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2614',
                                                                       'out_octets': '61735930',
                                                                       'out_ucast_pkts': '366328',
                                                                       'poller_hash': 'MWM6ZWY6MDM6MDU6YTg6YzJpbnRm',
                                                                       'pons': [       {       'description': '0/2:12',
                                                                                               'id': '62',
                                                                                               'links': [       {       'fiber_length': 1057,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -17.0,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:12',
                                                                                               'poller_hash': 'MWM6ZWY6MDM6MDU6YTg6YzJpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:56:8e:32:e9:51',
                                                                                                        '1c:ef:03:05:a8:c3'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2614',
                                                                       'in_octets': '61735930',
                                                                       'in_ucast_pkts': '366328',
                                                                       'mac_address': '1c:ef:03:05:a8:c2',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '27392575',
                                                                       'out_ucast_pkts': '169963',
                                                                       'poller_hash': 'MWM6ZWY6MDM6MDU6YTg6YzJldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'V2801SG',
                                         'name': 'EPON0/2:12',
                                         'poller_hash': 'MWM6ZWY6MDM6MDU6YTg6YzJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.8P1T8',
                                         'system_mac_address': '1c:ef:03:05:a8:c2'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '63',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '75803597917',
                                                                       'in_ucast_pkts': '67317311',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '75803597917',
                                                                                                'in_ucast_pkts': '67317311',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '11',
                                                                                                'out_octets': '14262842463',
                                                                                                'out_ucast_pkts': '30290172',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:13',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '11',
                                                                       'out_octets': '14262842463',
                                                                       'out_ucast_pkts': '30290172',
                                                                       'poller_hash': 'MWM6ZWY6MDM6YmQ6Y2Y6MTJpbnRm',
                                                                       'pons': [       {       'description': '0/2:13',
                                                                                               'id': '63',
                                                                                               'links': [       {       'fiber_length': 955,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:13',
                                                                                               'poller_hash': 'MWM6ZWY6MDM6YmQ6Y2Y6MTJpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:ef:03:bd:cf:13'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '11',
                                                                       'in_octets': '14262842463',
                                                                       'in_ucast_pkts': '30290172',
                                                                       'mac_address': '1c:ef:03:bd:cf:12',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '75803597917',
                                                                       'out_ucast_pkts': '67317311',
                                                                       'poller_hash': 'MWM6ZWY6MDM6YmQ6Y2Y6MTJldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/2:13',
                                         'poller_hash': 'MWM6ZWY6MDM6YmQ6Y2Y6MTJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.0.0B0',
                                         'system_mac_address': '1c:ef:03:bd:cf:12'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '64',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '446407518848',
                                                                       'in_ucast_pkts': '334519816',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '446407518848',
                                                                                                'in_ucast_pkts': '334519816',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '26',
                                                                                                'out_octets': '127454407157',
                                                                                                'out_ucast_pkts': '232972907',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:14',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '26',
                                                                       'out_octets': '127454407157',
                                                                       'out_ucast_pkts': '232972907',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MmM6ODg6NTZpbnRm',
                                                                       'pons': [       {       'description': '0/2:14',
                                                                                               'id': '64',
                                                                                               'links': [       {       'fiber_length': 1127,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -15.5,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:14',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MmM6ODg6NTZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:2c:88:57'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '26',
                                                                       'in_octets': '127454407157',
                                                                       'in_ucast_pkts': '232972907',
                                                                       'mac_address': '6c:68:a4:2c:88:56',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '446407518848',
                                                                       'out_ucast_pkts': '334519816',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MmM6ODg6NTZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/2:14',
                                         'poller_hash': 'NmM6Njg6YTQ6MmM6ODg6NTZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:2c:88:56'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '65',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '73575057421',
                                                                       'in_ucast_pkts': '51310915',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '73575057421',
                                                                                                'in_ucast_pkts': '51310915',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '9',
                                                                                                'out_octets': '3205898316',
                                                                                                'out_ucast_pkts': '24532694',
                                                                                                'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:15',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '9',
                                                                       'out_octets': '3205898316',
                                                                       'out_ucast_pkts': '24532694',
                                                                       'poller_hash': 'MWM6ZWY6MDM6YmQ6Y2Q6YTJpbnRm',
                                                                       'pons': [       {       'description': '0/2:15',
                                                                                               'id': '65',
                                                                                               'links': [       {       'fiber_length': 927,
                                                                                                                        'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -19.3,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:15',
                                                                                               'poller_hash': 'MWM6ZWY6MDM6YmQ6Y2Q6YTJpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:ef:03:bd:cd:a3'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '9',
                                                                       'in_octets': '3205898316',
                                                                       'in_ucast_pkts': '24532694',
                                                                       'mac_address': '1c:ef:03:bd:cd:a2',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '73575057421',
                                                                       'out_ucast_pkts': '51310915',
                                                                       'poller_hash': 'MWM6ZWY6MDM6YmQ6Y2Q6YTJldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/2:15',
                                         'poller_hash': 'MWM6ZWY6MDM6YmQ6Y2Q6YTJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:bd:cd:a2'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_bdcom_p3600_P3600_16E_10_7_214_1(self):
        obj = self.run_data("bdcom.p3600.P3600-16E.10_7_214_1")
        exp_info = {
                'model': 'P3600-16E',
                'sta_count': 41,
                'sw_version': '10.1.0G Build 104155',
                'vendor': 'BDCOM'
        }
        exp_stats = {
         'serial_number': '0000329000756'
        }
        exp_sta_stats = {
                '1c:ef:03:53:08:60': {       'dev_macs': ['1c:ef:03:53:08:61'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:53:08:60',
                                             'name': 'EPON0/8:5',
                                             'serial_number': None},
                '1c:ef:03:56:17:00': {       'dev_macs': ['1c:ef:03:56:17:01'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:56:17:00',
                                             'name': 'EPON0/15:2',
                                             'serial_number': None},
                '1c:ef:03:56:1e:e0': {       'dev_macs': ['1c:ef:03:56:1e:e1'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:56:1e:e0',
                                             'name': 'EPON0/8:6',
                                             'serial_number': None},
                '1c:ef:03:56:23:a0': {       'dev_macs': ['1c:ef:03:56:23:a1'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:56:23:a0',
                                             'name': 'EPON0/7:3',
                                             'serial_number': None},
                '1c:ef:03:bd:25:22': {       'dev_macs': ['1c:ef:03:bd:25:23'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:bd:25:22',
                                             'name': 'EPON0/5:3',
                                             'serial_number': None},
                '6c:68:a4:1e:7c:4f': {       'dev_macs': ['6c:68:a4:1e:7c:50'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1e:7c:4f',
                                             'name': 'EPON0/4:1',
                                             'serial_number': None},
                '6c:68:a4:1e:bf:8f': {       'dev_macs': ['6c:68:a4:1e:bf:90'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1e:bf:8f',
                                             'name': 'EPON0/12:2',
                                             'serial_number': None},
                '6c:68:a4:1e:c4:9f': {       'dev_macs': ['6c:68:a4:1e:c4:a0'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1e:c4:9f',
                                             'name': 'EPON0/15:1',
                                             'serial_number': None},
                '6c:68:a4:1e:c5:2f': {       'dev_macs': ['6c:68:a4:1e:c5:30'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1e:c5:2f',
                                             'name': 'EPON0/1:1',
                                             'serial_number': None},
                '6c:68:a4:1e:c8:6f': {       'dev_macs': ['6c:68:a4:1e:c8:70'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1e:c8:6f',
                                             'name': 'EPON0/12:7',
                                             'serial_number': None},
                '6c:68:a4:1e:d5:cf': {       'dev_macs': ['6c:68:a4:1e:d5:d0'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1e:d5:cf',
                                             'name': 'EPON0/3:1',
                                             'serial_number': None},
                '6c:68:a4:1e:d7:3f': {       'dev_macs': ['6c:68:a4:1e:d7:40'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1e:d7:3f',
                                             'name': 'EPON0/1:3',
                                             'serial_number': None},
                '6c:68:a4:1f:4c:8f': {       'dev_macs': ['6c:68:a4:1f:4c:90'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1f:4c:8f',
                                             'name': 'EPON0/14:1',
                                             'serial_number': None},
                '6c:68:a4:1f:86:4f': {       'dev_macs': ['6c:68:a4:1f:86:50'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1f:86:4f',
                                             'name': 'EPON0/14:2',
                                             'serial_number': None},
                '6c:68:a4:1f:b0:0f': {       'dev_macs': ['6c:68:a4:1f:b0:10'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1f:b0:0f',
                                             'name': 'EPON0/11:2',
                                             'serial_number': None},
                '6c:68:a4:1f:f5:6f': {       'dev_macs': ['6c:68:a4:1f:f5:70'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1f:f5:6f',
                                             'name': 'EPON0/5:1',
                                             'serial_number': None},
                '6c:68:a4:20:00:2f': {       'dev_macs': ['6c:68:a4:20:00:30'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:20:00:2f',
                                             'name': 'EPON0/12:4',
                                             'serial_number': None},
                '6c:68:a4:20:0b:9f': {       'dev_macs': ['6c:68:a4:20:0b:a0'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:20:0b:9f',
                                             'name': 'EPON0/7:4',
                                             'serial_number': None},
                '6c:68:a4:20:3e:6f': {       'dev_macs': ['6c:68:a4:20:3e:70'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:20:3e:6f',
                                             'name': 'EPON0/5:2',
                                             'serial_number': None},
                '6c:68:a4:20:41:6f': {       'dev_macs': ['6c:68:a4:20:41:70'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:20:41:6f',
                                             'name': 'EPON0/2:1',
                                             'serial_number': None},
                '6c:68:a4:20:41:bf': {       'dev_macs': ['6c:68:a4:20:41:c0'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:20:41:bf',
                                             'name': 'EPON0/11:4',
                                             'serial_number': None},
                '6c:68:a4:20:44:5f': {       'dev_macs': ['6c:68:a4:20:44:60'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:20:44:5f',
                                             'name': 'EPON0/7:2',
                                             'serial_number': None},
                '6c:68:a4:20:48:ff': {       'dev_macs': ['6c:68:a4:20:49:00'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:20:48:ff',
                                             'name': 'EPON0/12:5',
                                             'serial_number': None},
                '6c:68:a4:20:50:4f': {       'dev_macs': ['6c:68:a4:20:50:50'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:20:50:4f',
                                             'name': 'EPON0/12:6',
                                             'serial_number': None},
                '6c:68:a4:20:50:df': {       'dev_macs': ['6c:68:a4:20:50:e0'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:20:50:df',
                                             'name': 'EPON0/7:1',
                                             'serial_number': None},
                '6c:68:a4:20:55:ef': {       'dev_macs': ['6c:68:a4:20:55:f0'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:20:55:ef',
                                             'name': 'EPON0/7:5',
                                             'serial_number': None},
                '6c:68:a4:58:18:ac': {       'dev_macs': ['6c:68:a4:58:18:ad'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:58:18:ac',
                                             'name': 'EPON0/7:6',
                                             'serial_number': None},
                '6c:68:a4:58:34:fc': {       'dev_macs': ['6c:68:a4:58:34:fd'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:58:34:fc',
                                             'name': 'EPON0/2:2',
                                             'serial_number': None},
                '6c:68:a4:58:3f:6c': {       'dev_macs': ['6c:68:a4:58:3f:6d'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:58:3f:6c',
                                             'name': 'EPON0/15:4',
                                             'serial_number': None},
                '6c:68:a4:58:50:3c': {       'dev_macs': ['6c:68:a4:7d:05:33'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:58:50:3c',
                                             'name': 'EPON0/7:8',
                                             'serial_number': None},
                '6c:68:a4:58:59:ec': {       'dev_macs': ['6c:68:a4:59:68:fd'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:58:59:ec',
                                             'name': 'EPON0/3:2',
                                             'serial_number': None},
                '6c:68:a4:58:a9:3c': {       'dev_macs': ['6c:68:a4:58:a9:3d'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:58:a9:3c',
                                             'name': 'EPON0/16:4',
                                             'serial_number': None},
                '6c:68:a4:59:5e:1c': {       'dev_macs': ['6c:68:a4:59:5e:1d'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:59:5e:1c',
                                             'name': 'EPON0/4:3',
                                             'serial_number': None},
                '6c:68:a4:59:68:fc': {       'dev_macs': ['6c:68:a4:7c:cd:13'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:59:68:fc',
                                             'name': 'EPON0/5:4',
                                             'serial_number': None},
                '6c:68:a4:59:71:bc': {       'dev_macs': ['6c:68:a4:58:59:ed'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:59:71:bc',
                                             'name': 'EPON0/7:7',
                                             'serial_number': None},
                '6c:68:a4:59:aa:0c': {       'dev_macs': ['6c:68:a4:59:aa:0d'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:59:aa:0c',
                                             'name': 'EPON0/12:8',
                                             'serial_number': None},
                '6c:68:a4:5a:17:3c': {       'dev_macs': ['6c:68:a4:5a:17:3d'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:5a:17:3c',
                                             'name': 'EPON0/16:3',
                                             'serial_number': None},
                '6c:68:a4:7c:6a:02': {       'dev_macs': ['6c:68:a4:7c:6a:33'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:7c:6a:02',
                                             'name': 'EPON0/2:3',
                                             'serial_number': None},
                '6c:68:a4:7c:6a:32': {       'dev_macs': ['6c:68:a4:7c:6a:03'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:7c:6a:32',
                                             'name': 'EPON0/4:4',
                                             'serial_number': None},
                '6c:68:a4:7c:cd:12': {       'dev_macs': ['6c:68:a4:58:50:3d'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:7c:cd:12',
                                             'name': 'EPON0/2:4',
                                             'serial_number': None},
                '6c:68:a4:7d:05:32': {       'dev_macs': ['6c:68:a4:59:71:bd'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:7d:05:32',
                                             'name': 'EPON0/1:4',
                                             'serial_number': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 13.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '33',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:cf:4f:52',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NTJpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '34',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:cf:4f:53',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/2',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NTNpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '35',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:cf:4f:54',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/3',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NTRpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '36',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:cf:4f:55',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/4',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NTVpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '37',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:cf:4f:56',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/5',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NTZpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '38',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:cf:4f:57',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/6',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NTdpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '39',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:cf:4f:58',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/7',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NThpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '40',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:cf:4f:59',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/8',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NTlpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '41',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:cf:4f:5a',
                                                              'mtu': 1700,
                                                              'name': 'TGigaEthernet0/1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NWFpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '42',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '68',
                                                              'in_octets': '4851290217',
                                                              'in_ucast_pkts': '3517793',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:cf:4f:5b',
                                                              'mtu': 1700,
                                                              'name': 'TGigaEthernet0/2',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '447',
                                                              'out_octets': '462985627',
                                                              'out_ucast_pkts': '1325290',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NWJpbnRm',
                                                              'speed': '10000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '43',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:cf:4f:5c',
                                                              'mtu': 1700,
                                                              'name': 'TGigaEthernet0/3',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NWNpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '44',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:cf:4f:5d',
                                                              'mtu': 1700,
                                                              'name': 'TGigaEthernet0/4',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NWRpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '45',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:cf:4f:5e',
                                                              'mtu': 1700,
                                                              'name': 'TGigaEthernet0/5',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NWVpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '46',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:cf:4f:5f',
                                                              'mtu': 1700,
                                                              'name': 'TGigaEthernet0/6',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NWZpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '47',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '6',
                                                              'in_octets': '7064106',
                                                              'in_ucast_pkts': '29357',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '5412621',
                                                                                       'in_ucast_pkts': '24630',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '63955294',
                                                                                       'out_ucast_pkts': '55615',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6ZDc6M2ZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '1526646',
                                                                                       'in_ucast_pkts': '4199',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1601315',
                                                                                       'out_ucast_pkts': '4261',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6N2Q6MDU6MzJpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '125133',
                                                                                       'in_ucast_pkts': '538',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '403298',
                                                                                       'out_ucast_pkts': '633',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6YzU6MmZpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:4f:60',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '65954129',
                                                              'out_ucast_pkts': '60507',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjBpbnRm',
                                                              'pons': [       {       'description': '0/1',
                                                                                      'id': '47',
                                                                                      'links': [       {       'connected_time': '725',
                                                                                                               'fiber_length': 1452,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6ZDc6M2ZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -19.4,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '720',
                                                                                                               'fiber_length': 1011,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2Q6MDU6MzJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -23.9,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '720',
                                                                                                               'fiber_length': 1023,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6YzU6MmZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -20.5,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.9}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/1',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjBpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '48',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '8',
                                                              'in_octets': '17251989',
                                                              'in_ucast_pkts': '100037',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '6573920',
                                                                                       'in_ucast_pkts': '28135',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '64035287',
                                                                                       'out_ucast_pkts': '58619',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NDE6NmZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '8782803',
                                                                                       'in_ucast_pkts': '61383',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '149479888',
                                                                                       'out_ucast_pkts': '111446',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6NTg6MzQ6ZmNpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '1876392',
                                                                                       'in_ucast_pkts': '10276',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '13237189',
                                                                                       'out_ucast_pkts': '12797',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6N2M6NmE6MDJpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '26771',
                                                                                       'in_ucast_pkts': '293',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '4599',
                                                                                       'out_ucast_pkts': '49',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6N2M6Y2Q6MTJpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:4f:61',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/2',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '226647400',
                                                              'out_ucast_pkts': '182817',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjFpbnRm',
                                                              'pons': [       {       'description': '0/2',
                                                                                      'id': '48',
                                                                                      'links': [       {       'connected_time': '721',
                                                                                                               'fiber_length': 1118,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6NDE6NmZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.9,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '720',
                                                                                                               'fiber_length': 1054,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTg6MzQ6ZmNpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.4,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '721',
                                                                                                               'fiber_length': 1469,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2M6NmE6MDJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -20.6,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '720',
                                                                                                               'fiber_length': 1397,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2M6Y2Q6MTJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.7,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.9}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/2',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjFpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '49',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '4',
                                                              'in_octets': '8003703',
                                                              'in_ucast_pkts': '72887',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '448479',
                                                                                       'in_ucast_pkts': '2208',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3727324',
                                                                                       'out_ucast_pkts': '3692',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6NTg6NTk6ZWNpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '7555224',
                                                                                       'in_ucast_pkts': '70679',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '201697477',
                                                                                       'out_ucast_pkts': '141307',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6ZDU6Y2ZpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:4f:62',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/3',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '205384888',
                                                              'out_ucast_pkts': '144998',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjJpbnRm',
                                                              'pons': [       {       'description': '0/3',
                                                                                      'id': '49',
                                                                                      'links': [       {       'connected_time': '721',
                                                                                                               'fiber_length': 1480,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTg6NTk6ZWNpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -19.7,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '725',
                                                                                                               'fiber_length': 1598,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6ZDU6Y2ZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -20.5,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/3',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjJpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '50',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '8',
                                                              'in_octets': '1933266',
                                                              'in_ucast_pkts': '16324',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '4',
                                                                                       'in_octets': '541024',
                                                                                       'in_ucast_pkts': '5739',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '4373',
                                                                                       'out_ucast_pkts': '45',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6N2M6NGZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '1162741',
                                                                                       'in_ucast_pkts': '9472',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '29421243',
                                                                                       'out_ucast_pkts': '24307',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6NTk6NWU6MWNpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '230856',
                                                                                       'in_ucast_pkts': '1114',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1241354',
                                                                                       'out_ucast_pkts': '1655',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6N2M6NmE6MzJpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:4f:63',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/4',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '30661646',
                                                              'out_ucast_pkts': '25919',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjNpbnRm',
                                                              'pons': [       {       'description': '0/4',
                                                                                      'id': '50',
                                                                                      'links': [       {       'connected_time': '722',
                                                                                                               'fiber_length': 1725,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6N2M6NGZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -21.4,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '720',
                                                                                                               'fiber_length': 1652,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTk6NWU6MWNpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -23.5,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '725',
                                                                                                               'fiber_length': 1607,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2M6NmE6MzJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -23.6,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/4',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjNpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '51',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '8',
                                                              'in_octets': '21085820',
                                                              'in_ucast_pkts': '167757',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '20889',
                                                                                       'in_ucast_pkts': '232',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '4919',
                                                                                       'out_ucast_pkts': '54',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6ZjU6NmZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '12608501',
                                                                                       'in_ucast_pkts': '105256',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '914824762',
                                                                                       'out_ucast_pkts': '606716',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6M2U6NmZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '5799795',
                                                                                       'in_ucast_pkts': '38780',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '199419887',
                                                                                       'out_ucast_pkts': '153972',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6YmQ6MjU6MjJpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '2662894',
                                                                                       'in_ucast_pkts': '23506',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '59386185',
                                                                                       'out_ucast_pkts': '43091',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6NTk6Njg6ZmNpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:4f:64',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/5',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1173628208',
                                                              'out_ucast_pkts': '803819',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjRpbnRm',
                                                              'pons': [       {       'description': '0/5',
                                                                                      'id': '51',
                                                                                      'links': [       {       'connected_time': '721',
                                                                                                               'fiber_length': 2255,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWY6ZjU6NmZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -19.6,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.2},
                                                                                                       {       'connected_time': '664',
                                                                                                               'fiber_length': 1928,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6M2U6NmZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -20.7,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.2},
                                                                                                       {       'connected_time': '721',
                                                                                                               'fiber_length': 1907,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6YmQ6MjU6MjJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.2},
                                                                                                       {       'connected_time': '721',
                                                                                                               'fiber_length': 2142,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTk6Njg6ZmNpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.2,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.2}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/5',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjRpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '52',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:cf:4f:65',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/6',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjVpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '53',
                                                              'in_discards': '1',
                                                              'in_errors': '1',
                                                              'in_nucast_pkts': '19',
                                                              'in_octets': '25479576',
                                                              'in_ucast_pkts': '173835',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '1732358',
                                                                                       'in_ucast_pkts': '9926',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3703',
                                                                                       'out_ucast_pkts': '35',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NDQ6NWZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '5',
                                                                                       'in_octets': '8789794',
                                                                                       'in_ucast_pkts': '70356',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '192143976',
                                                                                       'out_ucast_pkts': '153624',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6MGI6OWZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '2099246',
                                                                                       'in_ucast_pkts': '20933',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '70568449',
                                                                                       'out_ucast_pkts': '48851',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6NTY6MjM6YTBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '329383',
                                                                                       'in_ucast_pkts': '1306',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '939731',
                                                                                       'out_ucast_pkts': '1532',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NTU6ZWZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '1763074',
                                                                                       'in_ucast_pkts': '10432',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '67495765',
                                                                                       'out_ucast_pkts': '53701',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6NTg6MTg6YWNpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '4797451',
                                                                                       'in_ucast_pkts': '29246',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '72723948',
                                                                                       'out_ucast_pkts': '58629',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6NTk6NzE6YmNpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '5118948',
                                                                                       'in_ucast_pkts': '28742',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '155385159',
                                                                                       'out_ucast_pkts': '119375',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6NTg6NTA6M2NpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '855331',
                                                                                       'in_ucast_pkts': '2969',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2742671',
                                                                                       'out_ucast_pkts': '3932',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NTA6ZGZpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:4f:66',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/7',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '560672544',
                                                              'out_ucast_pkts': '439486',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjZpbnRm',
                                                              'pons': [       {       'description': '0/7',
                                                                                      'id': '53',
                                                                                      'links': [       {       'connected_time': '722',
                                                                                                               'fiber_length': 2498,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6NDQ6NWZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.7,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '633',
                                                                                                               'fiber_length': 2479,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6MGI6OWZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.6,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '722',
                                                                                                               'fiber_length': 2481,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6NTY6MjM6YTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -21.9,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '720',
                                                                                                               'fiber_length': 2310,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6NTU6ZWZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -24.2,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '721',
                                                                                                               'fiber_length': 2317,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTg6MTg6YWNpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -28.2,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '721',
                                                                                                               'fiber_length': 2307,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTk6NzE6YmNpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -18.9,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '720',
                                                                                                               'fiber_length': 2529,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTg6NTA6M2NpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.8,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '720',
                                                                                                               'fiber_length': 2106,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6NTA6ZGZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -20.8,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/7',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjZpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '54',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '4',
                                                              'in_octets': '14116306',
                                                              'in_ucast_pkts': '127740',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '6616570',
                                                                                       'in_ucast_pkts': '62981',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '164915631',
                                                                                       'out_ucast_pkts': '116295',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6NTM6MDg6NjBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '7510105',
                                                                                       'in_ucast_pkts': '64759',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '291934916',
                                                                                       'out_ucast_pkts': '218971',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6NTY6MWU6ZTBpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:4f:67',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/8',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '456833051',
                                                              'out_ucast_pkts': '335056',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjdpbnRm',
                                                              'pons': [       {       'description': '0/8',
                                                                                      'id': '54',
                                                                                      'links': [       {       'connected_time': '720',
                                                                                                               'fiber_length': 2322,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6NTM6MDg6NjBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -20.2,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 6.0},
                                                                                                       {       'connected_time': '721',
                                                                                                               'fiber_length': 2061,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6NTY6MWU6ZTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -19.1,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 6.0}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/8',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjdpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '55',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:cf:4f:68',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/9',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjhpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '56',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:cf:4f:69',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/10',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjlpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '57',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '4',
                                                              'in_octets': '6070346',
                                                              'in_ucast_pkts': '36002',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '6011530',
                                                                                       'in_ucast_pkts': '35375',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '197754516',
                                                                                       'out_ucast_pkts': '139023',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6YjA6MGZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '58816',
                                                                                       'in_ucast_pkts': '629',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3767',
                                                                                       'out_ucast_pkts': '36',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NDE6YmZpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:4f:6a',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/11',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '197717015',
                                                              'out_ucast_pkts': '139057',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmFpbnRm',
                                                              'pons': [       {       'description': '0/11',
                                                                                      'id': '57',
                                                                                      'links': [       {       'connected_time': '718',
                                                                                                               'fiber_length': 1399,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWY6YjA6MGZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -20.0,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '718',
                                                                                                               'fiber_length': 1584,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6NDE6YmZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -24.9,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.9}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/11',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmFpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '58',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '12',
                                                              'in_octets': '27370840',
                                                              'in_ucast_pkts': '252752',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '2383749',
                                                                                       'in_ucast_pkts': '6999',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3071347',
                                                                                       'out_ucast_pkts': '6377',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6YmY6OGZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '5538731',
                                                                                       'in_ucast_pkts': '40557',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '166303560',
                                                                                       'out_ucast_pkts': '130056',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6MDA6MmZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '360528',
                                                                                       'in_ucast_pkts': '2735',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3703',
                                                                                       'out_ucast_pkts': '35',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NDg6ZmZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '23937',
                                                                                       'in_ucast_pkts': '150',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '27875',
                                                                                       'out_ucast_pkts': '169',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NTA6NGZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '18976069',
                                                                                       'in_ucast_pkts': '202062',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1246932321',
                                                                                       'out_ucast_pkts': '832374',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6Yzg6NmZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '96598',
                                                                                       'in_ucast_pkts': '257',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '74756',
                                                                                       'out_ucast_pkts': '242',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6NTk6YWE6MGNpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:4f:6b',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/12',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1415839500',
                                                              'out_ucast_pkts': '968893',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmJpbnRm',
                                                              'pons': [       {       'description': '0/12',
                                                                                      'id': '58',
                                                                                      'links': [       {       'connected_time': '718',
                                                                                                               'fiber_length': 1655,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6YmY6OGZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.4,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.4},
                                                                                                       {       'connected_time': '718',
                                                                                                               'fiber_length': 1345,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6MDA6MmZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -20.3,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.4},
                                                                                                       {       'connected_time': '718',
                                                                                                               'fiber_length': 1488,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6NDg6ZmZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -19.3,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.4},
                                                                                                       {       'connected_time': '718',
                                                                                                               'fiber_length': 1438,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6NTA6NGZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -30.0,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.4},
                                                                                                       {       'connected_time': '718',
                                                                                                               'fiber_length': 1446,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6Yzg6NmZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -20.6,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.4},
                                                                                                       {       'connected_time': '718',
                                                                                                               'fiber_length': 1688,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTk6YWE6MGNpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.1,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.4}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/12',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmJpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '59',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:cf:4f:6c',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/13',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmNpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '60',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '4',
                                                              'in_octets': '9926505',
                                                              'in_ucast_pkts': '86514',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '472794',
                                                                                       'in_ucast_pkts': '2688',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3767',
                                                                                       'out_ucast_pkts': '36',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6NGM6OGZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '9457582',
                                                                                       'in_ucast_pkts': '83827',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '311776169',
                                                                                       'out_ucast_pkts': '227841',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6ODY6NGZpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:4f:6d',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/14',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '311769310',
                                                              'out_ucast_pkts': '227816',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmRpbnRm',
                                                              'pons': [       {       'description': '0/14',
                                                                                      'id': '60',
                                                                                      'links': [       {       'connected_time': '713',
                                                                                                               'fiber_length': 1420,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWY6NGM6OGZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -20.2,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '714',
                                                                                                               'fiber_length': 1782,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWY6ODY6NGZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -21.4,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.9}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/14',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmRpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '61',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '6',
                                                              'in_octets': '4689428',
                                                              'in_ucast_pkts': '33013',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '2512681',
                                                                                       'in_ucast_pkts': '23225',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '113171141',
                                                                                       'out_ucast_pkts': '76457',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6YzQ6OWZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '91313',
                                                                                       'in_ucast_pkts': '940',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3703',
                                                                                       'out_ucast_pkts': '35',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6NTY6MTc6MDBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '2095893',
                                                                                       'in_ucast_pkts': '8848',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '48273710',
                                                                                       'out_ucast_pkts': '38961',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6NTg6M2Y6NmNpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:4f:6e',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/15',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '161448554',
                                                              'out_ucast_pkts': '115453',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmVpbnRm',
                                                              'pons': [       {       'description': '0/15',
                                                                                      'id': '61',
                                                                                      'links': [       {       'connected_time': '713',
                                                                                                               'fiber_length': 1872,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6YzQ6OWZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -21.9,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '714',
                                                                                                               'fiber_length': 2022,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6NTY6MTc6MDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -20.7,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '714',
                                                                                                               'fiber_length': 1860,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTg6M2Y6NmNpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.3,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/15',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmVpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '62',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '4',
                                                              'in_octets': '313648496',
                                                              'in_ucast_pkts': '220285',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '313617635',
                                                                                       'in_ucast_pkts': '220055',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '43529773',
                                                                                       'out_ucast_pkts': '77540',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6NWE6MTc6M2NpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2',
                                                                                       'in_octets': '30861',
                                                                                       'in_ucast_pkts': '230',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '34057',
                                                                                       'out_ucast_pkts': '186',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6NTg6YTk6M2NpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:4f:6f',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/16',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '43563830',
                                                              'out_ucast_pkts': '77726',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmZpbnRm',
                                                              'pons': [       {       'description': '0/16',
                                                                                      'id': '62',
                                                                                      'links': [       {       'connected_time': '714',
                                                                                                               'fiber_length': 2022,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6NWE6MTc6M2NpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -23.2,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '714',
                                                                                                               'fiber_length': 2390,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTg6YTk6M2NpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -26.0,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/16',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmZpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1}],
                                'manufacturer': 'BDCOM',
                                'mem': 71.0,
                                'model': 'P3600-16E',
                                'serial_number': '0000329000756',
                                'sw_version': '10.1.0G Build 104155',
                                'system_mac_address': '00:55:b1:cf:4f:51',
                                'temperature': 49.0},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '103',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '3071347',
                                                                       'in_ucast_pkts': '6377',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '3071347',
                                                                                                'in_ucast_pkts': '6377',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '2383749',
                                                                                                'out_ucast_pkts': '6999',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmJpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/12:2',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '2383749',
                                                                       'out_ucast_pkts': '6999',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6YmY6OGZpbnRm',
                                                                       'pons': [       {       'description': '0/12:2',
                                                                                               'id': '103',
                                                                                               'links': [       {       'connected_time': '718',
                                                                                                                        'fiber_length': 1655,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -16.5,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.2}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/12:2',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6YmY6OGZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:1e:bf:90'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '2383749',
                                                                       'in_ucast_pkts': '6999',
                                                                       'mac_address': '6c:68:a4:1e:bf:8f',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3071347',
                                                                       'out_ucast_pkts': '6377',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6YmY6OGZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/12:2',
                                         'poller_hash': 'NmM6Njg6YTQ6MWU6YmY6OGZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:1e:bf:8f',
                                         'uptime': '718'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '104',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '3767',
                                                                       'in_ucast_pkts': '36',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '3767',
                                                                                                'in_ucast_pkts': '36',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '472794',
                                                                                                'out_ucast_pkts': '2688',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmRpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/14:1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '472794',
                                                                       'out_ucast_pkts': '2688',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6NGM6OGZpbnRm',
                                                                       'pons': [       {       'description': '0/14:1',
                                                                                               'id': '104',
                                                                                               'links': [       {       'connected_time': '713',
                                                                                                                        'fiber_length': 1420,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmRpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -14.6,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.3}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/14:1',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWY6NGM6OGZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:1f:4c:90'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '472794',
                                                                       'in_ucast_pkts': '2688',
                                                                       'mac_address': '6c:68:a4:1f:4c:8f',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3767',
                                                                       'out_ucast_pkts': '36',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6NGM6OGZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/14:1',
                                         'poller_hash': 'NmM6Njg6YTQ6MWY6NGM6OGZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:1f:4c:8f',
                                         'uptime': '713'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '107',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '3703',
                                                                       'in_ucast_pkts': '35',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '3703',
                                                                                                'in_ucast_pkts': '35',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '1732358',
                                                                                                'out_ucast_pkts': '9926',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjZpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/7:2',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '1732358',
                                                                       'out_ucast_pkts': '9926',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NDQ6NWZpbnRm',
                                                                       'pons': [       {       'description': '0/7:2',
                                                                                               'id': '107',
                                                                                               'links': [       {       'connected_time': '722',
                                                                                                                        'fiber_length': 2498,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjZpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -16.3,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/7:2',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6NDQ6NWZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:20:44:60'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '1732358',
                                                                       'in_ucast_pkts': '9926',
                                                                       'mac_address': '6c:68:a4:20:44:5f',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3703',
                                                                       'out_ucast_pkts': '35',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NDQ6NWZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/7:2',
                                         'poller_hash': 'NmM6Njg6YTQ6MjA6NDQ6NWZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:20:44:5f',
                                         'uptime': '722'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '108',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '43529773',
                                                                       'in_ucast_pkts': '77540',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '43529773',
                                                                                                'in_ucast_pkts': '77540',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '313617635',
                                                                                                'out_ucast_pkts': '220055',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmZpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/16:3',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '313617635',
                                                                       'out_ucast_pkts': '220055',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NWE6MTc6M2NpbnRm',
                                                                       'pons': [       {       'description': '0/16:3',
                                                                                               'id': '108',
                                                                                               'links': [       {       'connected_time': '714',
                                                                                                                        'fiber_length': 2022,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmZpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -17.6,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/16:3',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6NWE6MTc6M2NpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:5a:17:3d'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '313617635',
                                                                       'in_ucast_pkts': '220055',
                                                                       'mac_address': '6c:68:a4:5a:17:3c',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '43529773',
                                                                       'out_ucast_pkts': '77540',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NWE6MTc6M2NldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/16:3',
                                         'poller_hash': 'NmM6Njg6YTQ6NWE6MTc6M2NvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:5a:17:3c',
                                         'uptime': '714'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '109',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '34057',
                                                                       'in_ucast_pkts': '186',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '34057',
                                                                                                'in_ucast_pkts': '186',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '30861',
                                                                                                'out_ucast_pkts': '230',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmZpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/16:4',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '30861',
                                                                       'out_ucast_pkts': '230',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTg6YTk6M2NpbnRm',
                                                                       'pons': [       {       'description': '0/16:4',
                                                                                               'id': '109',
                                                                                               'links': [       {       'connected_time': '714',
                                                                                                                        'fiber_length': 2390,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmZpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -20.4,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/16:4',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTg6YTk6M2NpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:58:a9:3d'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '30861',
                                                                       'in_ucast_pkts': '230',
                                                                       'mac_address': '6c:68:a4:58:a9:3c',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '34057',
                                                                       'out_ucast_pkts': '186',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTg6YTk6M2NldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/16:4',
                                         'poller_hash': 'NmM6Njg6YTQ6NTg6YTk6M2NvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:58:a9:3c',
                                         'uptime': '714'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '110',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '192143976',
                                                                       'in_ucast_pkts': '153624',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '192143976',
                                                                                                'in_ucast_pkts': '153624',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '5',
                                                                                                'out_octets': '8789794',
                                                                                                'out_ucast_pkts': '70356',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjZpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/7:4',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '5',
                                                                       'out_octets': '8789794',
                                                                       'out_ucast_pkts': '70356',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6MGI6OWZpbnRm',
                                                                       'pons': [       {       'description': '0/7:4',
                                                                                               'id': '110',
                                                                                               'links': [       {       'connected_time': '633',
                                                                                                                        'fiber_length': 2479,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjZpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -17.3,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/7:4',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6MGI6OWZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:20:0b:a0'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5',
                                                                       'in_octets': '8789794',
                                                                       'in_ucast_pkts': '70356',
                                                                       'mac_address': '6c:68:a4:20:0b:9f',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '192143976',
                                                                       'out_ucast_pkts': '153624',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6MGI6OWZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/7:4',
                                         'poller_hash': 'NmM6Njg6YTQ6MjA6MGI6OWZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:20:0b:9f',
                                         'uptime': '633'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '111',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '113171141',
                                                                       'in_ucast_pkts': '76457',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '113171141',
                                                                                                'in_ucast_pkts': '76457',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '2512681',
                                                                                                'out_ucast_pkts': '23225',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmVpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/15:1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '2512681',
                                                                       'out_ucast_pkts': '23225',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6YzQ6OWZpbnRm',
                                                                       'pons': [       {       'description': '0/15:1',
                                                                                               'id': '111',
                                                                                               'links': [       {       'connected_time': '713',
                                                                                                                        'fiber_length': 1872,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmVpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -16.2,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/15:1',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6YzQ6OWZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:1e:c4:a0'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '2512681',
                                                                       'in_ucast_pkts': '23225',
                                                                       'mac_address': '6c:68:a4:1e:c4:9f',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '113171141',
                                                                       'out_ucast_pkts': '76457',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6YzQ6OWZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/15:1',
                                         'poller_hash': 'NmM6Njg6YTQ6MWU6YzQ6OWZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:1e:c4:9f',
                                         'uptime': '713'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '113',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '166303560',
                                                                       'in_ucast_pkts': '130056',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '166303560',
                                                                                                'in_ucast_pkts': '130056',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '5538731',
                                                                                                'out_ucast_pkts': '40557',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmJpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/12:4',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '5538731',
                                                                       'out_ucast_pkts': '40557',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6MDA6MmZpbnRm',
                                                                       'pons': [       {       'description': '0/12:4',
                                                                                               'id': '113',
                                                                                               'links': [       {       'connected_time': '718',
                                                                                                                        'fiber_length': 1345,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -15.4,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/12:4',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6MDA6MmZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:20:00:30'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '5538731',
                                                                       'in_ucast_pkts': '40557',
                                                                       'mac_address': '6c:68:a4:20:00:2f',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '166303560',
                                                                       'out_ucast_pkts': '130056',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6MDA6MmZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/12:4',
                                         'poller_hash': 'NmM6Njg6YTQ6MjA6MDA6MmZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:20:00:2f',
                                         'uptime': '718'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '114',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '197754516',
                                                                       'in_ucast_pkts': '139023',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '197754516',
                                                                                                'in_ucast_pkts': '139023',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '6011530',
                                                                                                'out_ucast_pkts': '35375',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmFpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/11:2',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '6011530',
                                                                       'out_ucast_pkts': '35375',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6YjA6MGZpbnRm',
                                                                       'pons': [       {       'description': '0/11:2',
                                                                                               'id': '114',
                                                                                               'links': [       {       'connected_time': '718',
                                                                                                                        'fiber_length': 1399,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmFpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -15.1,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/11:2',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWY6YjA6MGZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:1f:b0:10'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '6011530',
                                                                       'in_ucast_pkts': '35375',
                                                                       'mac_address': '6c:68:a4:1f:b0:0f',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '197754516',
                                                                       'out_ucast_pkts': '139023',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6YjA6MGZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/11:2',
                                         'poller_hash': 'NmM6Njg6YTQ6MWY6YjA6MGZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:1f:b0:0f',
                                         'uptime': '718'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '115',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '3703',
                                                                       'in_ucast_pkts': '35',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '3703',
                                                                                                'in_ucast_pkts': '35',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '360528',
                                                                                                'out_ucast_pkts': '2735',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmJpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/12:5',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '360528',
                                                                       'out_ucast_pkts': '2735',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NDg6ZmZpbnRm',
                                                                       'pons': [       {       'description': '0/12:5',
                                                                                               'id': '115',
                                                                                               'links': [       {       'connected_time': '718',
                                                                                                                        'fiber_length': 1488,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -13.5,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/12:5',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6NDg6ZmZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:20:49:00'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '360528',
                                                                       'in_ucast_pkts': '2735',
                                                                       'mac_address': '6c:68:a4:20:48:ff',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3703',
                                                                       'out_ucast_pkts': '35',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NDg6ZmZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/12:5',
                                         'poller_hash': 'NmM6Njg6YTQ6MjA6NDg6ZmZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:20:48:ff',
                                         'uptime': '718'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '117',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '63955294',
                                                                       'in_ucast_pkts': '55615',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '63955294',
                                                                                                'in_ucast_pkts': '55615',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '5412621',
                                                                                                'out_ucast_pkts': '24630',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjBpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:3',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '5412621',
                                                                       'out_ucast_pkts': '24630',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6ZDc6M2ZpbnRm',
                                                                       'pons': [       {       'description': '0/1:3',
                                                                                               'id': '117',
                                                                                               'links': [       {       'connected_time': '725',
                                                                                                                        'fiber_length': 1452,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjBpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -14.4,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.7}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:3',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6ZDc6M2ZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:1e:d7:40'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '5412621',
                                                                       'in_ucast_pkts': '24630',
                                                                       'mac_address': '6c:68:a4:1e:d7:3f',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '63955294',
                                                                       'out_ucast_pkts': '55615',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6ZDc6M2ZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/1:3',
                                         'poller_hash': 'NmM6Njg6YTQ6MWU6ZDc6M2ZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:1e:d7:3f',
                                         'uptime': '725'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '121',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '164915631',
                                                                       'in_ucast_pkts': '116295',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '164915631',
                                                                                                'in_ucast_pkts': '116295',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '6616570',
                                                                                                'out_ucast_pkts': '62981',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjdpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/8:5',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '6616570',
                                                                       'out_ucast_pkts': '62981',
                                                                       'poller_hash': 'MWM6ZWY6MDM6NTM6MDg6NjBpbnRm',
                                                                       'pons': [       {       'description': '0/8:5',
                                                                                               'id': '121',
                                                                                               'links': [       {       'connected_time': '720',
                                                                                                                        'fiber_length': 2322,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjdpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -14.2,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/8:5',
                                                                                               'poller_hash': 'MWM6ZWY6MDM6NTM6MDg6NjBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:ef:03:53:08:61'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '6616570',
                                                                       'in_ucast_pkts': '62981',
                                                                       'mac_address': '1c:ef:03:53:08:60',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '164915631',
                                                                       'out_ucast_pkts': '116295',
                                                                       'poller_hash': 'MWM6ZWY6MDM6NTM6MDg6NjBldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/8:5',
                                         'poller_hash': 'MWM6ZWY6MDM6NTM6MDg6NjBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:53:08:60',
                                         'uptime': '720'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '122',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '4919',
                                                                       'in_ucast_pkts': '54',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '4919',
                                                                                                'in_ucast_pkts': '54',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '20889',
                                                                                                'out_ucast_pkts': '232',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjRpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/5:1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '20889',
                                                                       'out_ucast_pkts': '232',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6ZjU6NmZpbnRm',
                                                                       'pons': [       {       'description': '0/5:1',
                                                                                               'id': '122',
                                                                                               'links': [       {       'connected_time': '721',
                                                                                                                        'fiber_length': 2255,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjRpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -14.9,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/5:1',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWY6ZjU6NmZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:1f:f5:70'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '20889',
                                                                       'in_ucast_pkts': '232',
                                                                       'mac_address': '6c:68:a4:1f:f5:6f',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '4919',
                                                                       'out_ucast_pkts': '54',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6ZjU6NmZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/5:1',
                                         'poller_hash': 'NmM6Njg6YTQ6MWY6ZjU6NmZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:1f:f5:6f',
                                         'uptime': '721'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '123',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '4373',
                                                                       'in_ucast_pkts': '45',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '4373',
                                                                                                'in_ucast_pkts': '45',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '4',
                                                                                                'out_octets': '541024',
                                                                                                'out_ucast_pkts': '5739',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjNpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/4:1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4',
                                                                       'out_octets': '541024',
                                                                       'out_ucast_pkts': '5739',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6N2M6NGZpbnRm',
                                                                       'pons': [       {       'description': '0/4:1',
                                                                                               'id': '123',
                                                                                               'links': [       {       'connected_time': '722',
                                                                                                                        'fiber_length': 1725,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -18.6,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/4:1',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6N2M6NGZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:1e:7c:50'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4',
                                                                       'in_octets': '541024',
                                                                       'in_ucast_pkts': '5739',
                                                                       'mac_address': '6c:68:a4:1e:7c:4f',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '4373',
                                                                       'out_ucast_pkts': '45',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6N2M6NGZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/4:1',
                                         'poller_hash': 'NmM6Njg6YTQ6MWU6N2M6NGZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:1e:7c:4f',
                                         'uptime': '722'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '125',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '3703',
                                                                       'in_ucast_pkts': '35',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '3703',
                                                                                                'in_ucast_pkts': '35',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '91313',
                                                                                                'out_ucast_pkts': '940',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmVpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/15:2',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '91313',
                                                                       'out_ucast_pkts': '940',
                                                                       'poller_hash': 'MWM6ZWY6MDM6NTY6MTc6MDBpbnRm',
                                                                       'pons': [       {       'description': '0/15:2',
                                                                                               'id': '125',
                                                                                               'links': [       {       'connected_time': '714',
                                                                                                                        'fiber_length': 2022,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmVpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -14.4,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/15:2',
                                                                                               'poller_hash': 'MWM6ZWY6MDM6NTY6MTc6MDBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:ef:03:56:17:01'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '91313',
                                                                       'in_ucast_pkts': '940',
                                                                       'mac_address': '1c:ef:03:56:17:00',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3703',
                                                                       'out_ucast_pkts': '35',
                                                                       'poller_hash': 'MWM6ZWY6MDM6NTY6MTc6MDBldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/15:2',
                                         'poller_hash': 'MWM6ZWY6MDM6NTY6MTc6MDBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:56:17:00',
                                         'uptime': '714'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '126',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '291934916',
                                                                       'in_ucast_pkts': '218971',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '291934916',
                                                                                                'in_ucast_pkts': '218971',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '7510105',
                                                                                                'out_ucast_pkts': '64759',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjdpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/8:6',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '7510105',
                                                                       'out_ucast_pkts': '64759',
                                                                       'poller_hash': 'MWM6ZWY6MDM6NTY6MWU6ZTBpbnRm',
                                                                       'pons': [       {       'description': '0/8:6',
                                                                                               'id': '126',
                                                                                               'links': [       {       'connected_time': '721',
                                                                                                                        'fiber_length': 2061,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjdpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -14.1,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/8:6',
                                                                                               'poller_hash': 'MWM6ZWY6MDM6NTY6MWU6ZTBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:ef:03:56:1e:e1'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '7510105',
                                                                       'in_ucast_pkts': '64759',
                                                                       'mac_address': '1c:ef:03:56:1e:e0',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '291934916',
                                                                       'out_ucast_pkts': '218971',
                                                                       'poller_hash': 'MWM6ZWY6MDM6NTY6MWU6ZTBldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/8:6',
                                         'poller_hash': 'MWM6ZWY6MDM6NTY6MWU6ZTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:56:1e:e0',
                                         'uptime': '721'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '127',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '70568449',
                                                                       'in_ucast_pkts': '48851',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '70568449',
                                                                                                'in_ucast_pkts': '48851',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '2099246',
                                                                                                'out_ucast_pkts': '20933',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjZpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/7:3',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '2099246',
                                                                       'out_ucast_pkts': '20933',
                                                                       'poller_hash': 'MWM6ZWY6MDM6NTY6MjM6YTBpbnRm',
                                                                       'pons': [       {       'description': '0/7:3',
                                                                                               'id': '127',
                                                                                               'links': [       {       'connected_time': '722',
                                                                                                                        'fiber_length': 2481,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjZpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -17.3,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/7:3',
                                                                                               'poller_hash': 'MWM6ZWY6MDM6NTY6MjM6YTBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:ef:03:56:23:a1'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '2099246',
                                                                       'in_ucast_pkts': '20933',
                                                                       'mac_address': '1c:ef:03:56:23:a0',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '70568449',
                                                                       'out_ucast_pkts': '48851',
                                                                       'poller_hash': 'MWM6ZWY6MDM6NTY6MjM6YTBldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/7:3',
                                         'poller_hash': 'MWM6ZWY6MDM6NTY6MjM6YTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:56:23:a0',
                                         'uptime': '722'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '128',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '3767',
                                                                       'in_ucast_pkts': '36',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '3767',
                                                                                                'in_ucast_pkts': '36',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '58816',
                                                                                                'out_ucast_pkts': '629',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmFpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/11:4',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '58816',
                                                                       'out_ucast_pkts': '629',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NDE6YmZpbnRm',
                                                                       'pons': [       {       'description': '0/11:4',
                                                                                               'id': '128',
                                                                                               'links': [       {       'connected_time': '718',
                                                                                                                        'fiber_length': 1584,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmFpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -20.4,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.6}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/11:4',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6NDE6YmZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:20:41:c0'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '58816',
                                                                       'in_ucast_pkts': '629',
                                                                       'mac_address': '6c:68:a4:20:41:bf',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3767',
                                                                       'out_ucast_pkts': '36',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NDE6YmZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/11:4',
                                         'poller_hash': 'NmM6Njg6YTQ6MjA6NDE6YmZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:20:41:bf',
                                         'uptime': '718'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '129',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '3727324',
                                                                       'in_ucast_pkts': '3692',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '3727324',
                                                                                                'in_ucast_pkts': '3692',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '448479',
                                                                                                'out_ucast_pkts': '2208',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjJpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/3:2',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '448479',
                                                                       'out_ucast_pkts': '2208',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTg6NTk6ZWNpbnRm',
                                                                       'pons': [       {       'description': '0/3:2',
                                                                                               'id': '129',
                                                                                               'links': [       {       'connected_time': '721',
                                                                                                                        'fiber_length': 1480,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -17.1,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/3:2',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTg6NTk6ZWNpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:59:68:fd'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '448479',
                                                                       'in_ucast_pkts': '2208',
                                                                       'mac_address': '6c:68:a4:58:59:ec',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3727324',
                                                                       'out_ucast_pkts': '3692',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTg6NTk6ZWNldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/3:2',
                                         'poller_hash': 'NmM6Njg6YTQ6NTg6NTk6ZWNvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:58:59:ec',
                                         'uptime': '721'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '130',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '311776169',
                                                                       'in_ucast_pkts': '227841',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '311776169',
                                                                                                'in_ucast_pkts': '227841',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '9457582',
                                                                                                'out_ucast_pkts': '83827',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmRpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/14:2',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '9457582',
                                                                       'out_ucast_pkts': '83827',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6ODY6NGZpbnRm',
                                                                       'pons': [       {       'description': '0/14:2',
                                                                                               'id': '130',
                                                                                               'links': [       {       'connected_time': '714',
                                                                                                                        'fiber_length': 1782,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmRpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -13.9,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/14:2',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWY6ODY6NGZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:1f:86:50'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '9457582',
                                                                       'in_ucast_pkts': '83827',
                                                                       'mac_address': '6c:68:a4:1f:86:4f',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '311776169',
                                                                       'out_ucast_pkts': '227841',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6ODY6NGZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/14:2',
                                         'poller_hash': 'NmM6Njg6YTQ6MWY6ODY6NGZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:1f:86:4f',
                                         'uptime': '714'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '131',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '914824762',
                                                                       'in_ucast_pkts': '606716',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '914824762',
                                                                                                'in_ucast_pkts': '606716',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '12608501',
                                                                                                'out_ucast_pkts': '105256',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjRpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/5:2',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '12608501',
                                                                       'out_ucast_pkts': '105256',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6M2U6NmZpbnRm',
                                                                       'pons': [       {       'description': '0/5:2',
                                                                                               'id': '131',
                                                                                               'links': [       {       'connected_time': '664',
                                                                                                                        'fiber_length': 1928,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjRpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -15.1,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/5:2',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6M2U6NmZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:20:3e:70'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '12608501',
                                                                       'in_ucast_pkts': '105256',
                                                                       'mac_address': '6c:68:a4:20:3e:6f',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '914824762',
                                                                       'out_ucast_pkts': '606716',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6M2U6NmZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/5:2',
                                         'poller_hash': 'NmM6Njg6YTQ6MjA6M2U6NmZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:20:3e:6f',
                                         'uptime': '664'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '132',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '199419887',
                                                                       'in_ucast_pkts': '153972',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '199419887',
                                                                                                'in_ucast_pkts': '153972',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '5799795',
                                                                                                'out_ucast_pkts': '38780',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjRpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/5:3',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '5799795',
                                                                       'out_ucast_pkts': '38780',
                                                                       'poller_hash': 'MWM6ZWY6MDM6YmQ6MjU6MjJpbnRm',
                                                                       'pons': [       {       'description': '0/5:3',
                                                                                               'id': '132',
                                                                                               'links': [       {       'connected_time': '721',
                                                                                                                        'fiber_length': 1907,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjRpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'tx_link_rate': '1250000000'}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/5:3',
                                                                                               'poller_hash': 'MWM6ZWY6MDM6YmQ6MjU6MjJpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:ef:03:bd:25:23'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '5799795',
                                                                       'in_ucast_pkts': '38780',
                                                                       'mac_address': '1c:ef:03:bd:25:22',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '199419887',
                                                                       'out_ucast_pkts': '153972',
                                                                       'poller_hash': 'MWM6ZWY6MDM6YmQ6MjU6MjJldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/5:3',
                                         'poller_hash': 'MWM6ZWY6MDM6YmQ6MjU6MjJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:bd:25:22',
                                         'uptime': '721'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '133',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '939731',
                                                                       'in_ucast_pkts': '1532',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '939731',
                                                                                                'in_ucast_pkts': '1532',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '329383',
                                                                                                'out_ucast_pkts': '1306',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjZpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/7:5',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '329383',
                                                                       'out_ucast_pkts': '1306',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NTU6ZWZpbnRm',
                                                                       'pons': [       {       'description': '0/7:5',
                                                                                               'id': '133',
                                                                                               'links': [       {       'connected_time': '720',
                                                                                                                        'fiber_length': 2310,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjZpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -17.8,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/7:5',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6NTU6ZWZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:20:55:f0'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '329383',
                                                                       'in_ucast_pkts': '1306',
                                                                       'mac_address': '6c:68:a4:20:55:ef',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '939731',
                                                                       'out_ucast_pkts': '1532',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NTU6ZWZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/7:5',
                                         'poller_hash': 'NmM6Njg6YTQ6MjA6NTU6ZWZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:20:55:ef',
                                         'uptime': '720'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '135',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '64035287',
                                                                       'in_ucast_pkts': '58619',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '64035287',
                                                                                                'in_ucast_pkts': '58619',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '6573920',
                                                                                                'out_ucast_pkts': '28135',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjFpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '6573920',
                                                                       'out_ucast_pkts': '28135',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NDE6NmZpbnRm',
                                                                       'pons': [       {       'description': '0/2:1',
                                                                                               'id': '135',
                                                                                               'links': [       {       'connected_time': '721',
                                                                                                                        'fiber_length': 1118,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjFpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -19.5,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:1',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6NDE6NmZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:20:41:70'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '6573920',
                                                                       'in_ucast_pkts': '28135',
                                                                       'mac_address': '6c:68:a4:20:41:6f',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '64035287',
                                                                       'out_ucast_pkts': '58619',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NDE6NmZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/2:1',
                                         'poller_hash': 'NmM6Njg6YTQ6MjA6NDE6NmZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:20:41:6f',
                                         'uptime': '721'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '137',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '201697477',
                                                                       'in_ucast_pkts': '141307',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '201697477',
                                                                                                'in_ucast_pkts': '141307',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '7555224',
                                                                                                'out_ucast_pkts': '70679',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjJpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/3:1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '7555224',
                                                                       'out_ucast_pkts': '70679',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6ZDU6Y2ZpbnRm',
                                                                       'pons': [       {       'description': '0/3:1',
                                                                                               'id': '137',
                                                                                               'links': [       {       'connected_time': '725',
                                                                                                                        'fiber_length': 1598,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -12.9,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/3:1',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6ZDU6Y2ZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:1e:d5:d0'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '7555224',
                                                                       'in_ucast_pkts': '70679',
                                                                       'mac_address': '6c:68:a4:1e:d5:cf',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '201697477',
                                                                       'out_ucast_pkts': '141307',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6ZDU6Y2ZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/3:1',
                                         'poller_hash': 'NmM6Njg6YTQ6MWU6ZDU6Y2ZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:1e:d5:cf',
                                         'uptime': '725'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '138',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '27875',
                                                                       'in_ucast_pkts': '169',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '27875',
                                                                                                'in_ucast_pkts': '169',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '23937',
                                                                                                'out_ucast_pkts': '150',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmJpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/12:6',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '23937',
                                                                       'out_ucast_pkts': '150',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NTA6NGZpbnRm',
                                                                       'pons': [       {       'description': '0/12:6',
                                                                                               'id': '138',
                                                                                               'links': [       {       'connected_time': '718',
                                                                                                                        'fiber_length': 1438,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -26.0,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/12:6',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6NTA6NGZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:20:50:50'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '23937',
                                                                       'in_ucast_pkts': '150',
                                                                       'mac_address': '6c:68:a4:20:50:4f',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '27875',
                                                                       'out_ucast_pkts': '169',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NTA6NGZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/12:6',
                                         'poller_hash': 'NmM6Njg6YTQ6MjA6NTA6NGZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:20:50:4f',
                                         'uptime': '718'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '139',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '1246932321',
                                                                       'in_ucast_pkts': '832374',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '1246932321',
                                                                                                'in_ucast_pkts': '832374',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '18976069',
                                                                                                'out_ucast_pkts': '202062',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmJpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/12:7',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '18976069',
                                                                       'out_ucast_pkts': '202062',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6Yzg6NmZpbnRm',
                                                                       'pons': [       {       'description': '0/12:7',
                                                                                               'id': '139',
                                                                                               'links': [       {       'connected_time': '718',
                                                                                                                        'fiber_length': 1446,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -16.5,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.8}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/12:7',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6Yzg6NmZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:1e:c8:70'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '18976069',
                                                                       'in_ucast_pkts': '202062',
                                                                       'mac_address': '6c:68:a4:1e:c8:6f',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1246932321',
                                                                       'out_ucast_pkts': '832374',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6Yzg6NmZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/12:7',
                                         'poller_hash': 'NmM6Njg6YTQ6MWU6Yzg6NmZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:1e:c8:6f',
                                         'uptime': '718'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '142',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '29421243',
                                                                       'in_ucast_pkts': '24307',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '29421243',
                                                                                                'in_ucast_pkts': '24307',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '1162741',
                                                                                                'out_ucast_pkts': '9472',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjNpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/4:3',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '1162741',
                                                                       'out_ucast_pkts': '9472',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTk6NWU6MWNpbnRm',
                                                                       'pons': [       {       'description': '0/4:3',
                                                                                               'id': '142',
                                                                                               'links': [       {       'connected_time': '720',
                                                                                                                        'fiber_length': 1652,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -18.8,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/4:3',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTk6NWU6MWNpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:59:5e:1d'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '1162741',
                                                                       'in_ucast_pkts': '9472',
                                                                       'mac_address': '6c:68:a4:59:5e:1c',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '29421243',
                                                                       'out_ucast_pkts': '24307',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTk6NWU6MWNldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/4:3',
                                         'poller_hash': 'NmM6Njg6YTQ6NTk6NWU6MWNvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:59:5e:1c',
                                         'uptime': '720'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '143',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '67495765',
                                                                       'in_ucast_pkts': '53701',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '67495765',
                                                                                                'in_ucast_pkts': '53701',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '1763074',
                                                                                                'out_ucast_pkts': '10432',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjZpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/7:6',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '1763074',
                                                                       'out_ucast_pkts': '10432',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTg6MTg6YWNpbnRm',
                                                                       'pons': [       {       'description': '0/7:6',
                                                                                               'id': '143',
                                                                                               'links': [       {       'connected_time': '721',
                                                                                                                        'fiber_length': 2317,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjZpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -23.9,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/7:6',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTg6MTg6YWNpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:58:18:ad'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '1763074',
                                                                       'in_ucast_pkts': '10432',
                                                                       'mac_address': '6c:68:a4:58:18:ac',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '67495765',
                                                                       'out_ucast_pkts': '53701',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTg6MTg6YWNldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/7:6',
                                         'poller_hash': 'NmM6Njg6YTQ6NTg6MTg6YWNvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:58:18:ac',
                                         'uptime': '721'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '144',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '74756',
                                                                       'in_ucast_pkts': '242',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '74756',
                                                                                                'in_ucast_pkts': '242',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '96598',
                                                                                                'out_ucast_pkts': '257',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmJpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/12:8',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '96598',
                                                                       'out_ucast_pkts': '257',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTk6YWE6MGNpbnRm',
                                                                       'pons': [       {       'description': '0/12:8',
                                                                                               'id': '144',
                                                                                               'links': [       {       'connected_time': '718',
                                                                                                                        'fiber_length': 1688,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -16.1,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.3}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/12:8',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTk6YWE6MGNpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:59:aa:0d'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '96598',
                                                                       'in_ucast_pkts': '257',
                                                                       'mac_address': '6c:68:a4:59:aa:0c',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '74756',
                                                                       'out_ucast_pkts': '242',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTk6YWE6MGNldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/12:8',
                                         'poller_hash': 'NmM6Njg6YTQ6NTk6YWE6MGNvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:59:aa:0c',
                                         'uptime': '718'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '145',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '48273710',
                                                                       'in_ucast_pkts': '38961',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '48273710',
                                                                                                'in_ucast_pkts': '38961',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '2095893',
                                                                                                'out_ucast_pkts': '8848',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmVpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/15:4',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '2095893',
                                                                       'out_ucast_pkts': '8848',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTg6M2Y6NmNpbnRm',
                                                                       'pons': [       {       'description': '0/15:4',
                                                                                               'id': '145',
                                                                                               'links': [       {       'connected_time': '714',
                                                                                                                        'fiber_length': 1860,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NmVpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -15.8,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/15:4',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTg6M2Y6NmNpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:58:3f:6d'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '2095893',
                                                                       'in_ucast_pkts': '8848',
                                                                       'mac_address': '6c:68:a4:58:3f:6c',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '48273710',
                                                                       'out_ucast_pkts': '38961',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTg6M2Y6NmNldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/15:4',
                                         'poller_hash': 'NmM6Njg6YTQ6NTg6M2Y6NmNvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:58:3f:6c',
                                         'uptime': '714'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '146',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '149479888',
                                                                       'in_ucast_pkts': '111446',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '149479888',
                                                                                                'in_ucast_pkts': '111446',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '8782803',
                                                                                                'out_ucast_pkts': '61383',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjFpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:2',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '8782803',
                                                                       'out_ucast_pkts': '61383',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTg6MzQ6ZmNpbnRm',
                                                                       'pons': [       {       'description': '0/2:2',
                                                                                               'id': '146',
                                                                                               'links': [       {       'connected_time': '720',
                                                                                                                        'fiber_length': 1054,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjFpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -19.7,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:2',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTg6MzQ6ZmNpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:58:34:fd'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '8782803',
                                                                       'in_ucast_pkts': '61383',
                                                                       'mac_address': '6c:68:a4:58:34:fc',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '149479888',
                                                                       'out_ucast_pkts': '111446',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTg6MzQ6ZmNldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/2:2',
                                         'poller_hash': 'NmM6Njg6YTQ6NTg6MzQ6ZmNvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:58:34:fc',
                                         'uptime': '720'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '148',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '1241354',
                                                                       'in_ucast_pkts': '1655',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '1241354',
                                                                                                'in_ucast_pkts': '1655',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '230856',
                                                                                                'out_ucast_pkts': '1114',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjNpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/4:4',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '230856',
                                                                       'out_ucast_pkts': '1114',
                                                                       'poller_hash': 'NmM6Njg6YTQ6N2M6NmE6MzJpbnRm',
                                                                       'pons': [       {       'description': '0/4:4',
                                                                                               'id': '148',
                                                                                               'links': [       {       'connected_time': '725',
                                                                                                                        'fiber_length': 1607,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -19.6,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.2}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/4:4',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2M6NmE6MzJpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:7c:6a:03'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '230856',
                                                                       'in_ucast_pkts': '1114',
                                                                       'mac_address': '6c:68:a4:7c:6a:32',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1241354',
                                                                       'out_ucast_pkts': '1655',
                                                                       'poller_hash': 'NmM6Njg6YTQ6N2M6NmE6MzJldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/4:4',
                                         'poller_hash': 'NmM6Njg6YTQ6N2M6NmE6MzJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:7c:6a:32',
                                         'uptime': '725'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '149',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '59386185',
                                                                       'in_ucast_pkts': '43091',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '59386185',
                                                                                                'in_ucast_pkts': '43091',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '2662894',
                                                                                                'out_ucast_pkts': '23506',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjRpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/5:4',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '2662894',
                                                                       'out_ucast_pkts': '23506',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTk6Njg6ZmNpbnRm',
                                                                       'pons': [       {       'description': '0/5:4',
                                                                                               'id': '149',
                                                                                               'links': [       {       'connected_time': '721',
                                                                                                                        'fiber_length': 2142,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjRpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -18.9,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.1}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/5:4',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTk6Njg6ZmNpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:7c:cd:13'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '2662894',
                                                                       'in_ucast_pkts': '23506',
                                                                       'mac_address': '6c:68:a4:59:68:fc',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '59386185',
                                                                       'out_ucast_pkts': '43091',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTk6Njg6ZmNldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/5:4',
                                         'poller_hash': 'NmM6Njg6YTQ6NTk6Njg6ZmNvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:59:68:fc',
                                         'uptime': '721'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '150',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '72723948',
                                                                       'in_ucast_pkts': '58629',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '72723948',
                                                                                                'in_ucast_pkts': '58629',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '4797451',
                                                                                                'out_ucast_pkts': '29246',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjZpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/7:7',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '4797451',
                                                                       'out_ucast_pkts': '29246',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTk6NzE6YmNpbnRm',
                                                                       'pons': [       {       'description': '0/7:7',
                                                                                               'id': '150',
                                                                                               'links': [       {       'connected_time': '721',
                                                                                                                        'fiber_length': 2307,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjZpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -14.1,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/7:7',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTk6NzE6YmNpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:58:59:ed'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '4797451',
                                                                       'in_ucast_pkts': '29246',
                                                                       'mac_address': '6c:68:a4:59:71:bc',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '72723948',
                                                                       'out_ucast_pkts': '58629',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTk6NzE6YmNldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/7:7',
                                         'poller_hash': 'NmM6Njg6YTQ6NTk6NzE6YmNvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:59:71:bc',
                                         'uptime': '721'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '151',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '13237189',
                                                                       'in_ucast_pkts': '12797',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '13237189',
                                                                                                'in_ucast_pkts': '12797',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '1876392',
                                                                                                'out_ucast_pkts': '10276',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjFpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:3',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '1876392',
                                                                       'out_ucast_pkts': '10276',
                                                                       'poller_hash': 'NmM6Njg6YTQ6N2M6NmE6MDJpbnRm',
                                                                       'pons': [       {       'description': '0/2:3',
                                                                                               'id': '151',
                                                                                               'links': [       {       'connected_time': '721',
                                                                                                                        'fiber_length': 1469,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjFpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -16.5,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.9}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:3',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2M6NmE6MDJpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:7c:6a:33'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '1876392',
                                                                       'in_ucast_pkts': '10276',
                                                                       'mac_address': '6c:68:a4:7c:6a:02',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '13237189',
                                                                       'out_ucast_pkts': '12797',
                                                                       'poller_hash': 'NmM6Njg6YTQ6N2M6NmE6MDJldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/2:3',
                                         'poller_hash': 'NmM6Njg6YTQ6N2M6NmE6MDJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:7c:6a:02',
                                         'uptime': '721'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '152',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '155385159',
                                                                       'in_ucast_pkts': '119375',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '155385159',
                                                                                                'in_ucast_pkts': '119375',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '5118948',
                                                                                                'out_ucast_pkts': '28742',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjZpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/7:8',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '5118948',
                                                                       'out_ucast_pkts': '28742',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTg6NTA6M2NpbnRm',
                                                                       'pons': [       {       'description': '0/7:8',
                                                                                               'id': '152',
                                                                                               'links': [       {       'connected_time': '720',
                                                                                                                        'fiber_length': 2529,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjZpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -16.9,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/7:8',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6NTg6NTA6M2NpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:7d:05:33'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '5118948',
                                                                       'in_ucast_pkts': '28742',
                                                                       'mac_address': '6c:68:a4:58:50:3c',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '155385159',
                                                                       'out_ucast_pkts': '119375',
                                                                       'poller_hash': 'NmM6Njg6YTQ6NTg6NTA6M2NldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/7:8',
                                         'poller_hash': 'NmM6Njg6YTQ6NTg6NTA6M2NvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:58:50:3c',
                                         'uptime': '720'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '153',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '1601315',
                                                                       'in_ucast_pkts': '4261',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '1601315',
                                                                                                'in_ucast_pkts': '4261',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '1526646',
                                                                                                'out_ucast_pkts': '4199',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjBpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:4',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '1526646',
                                                                       'out_ucast_pkts': '4199',
                                                                       'poller_hash': 'NmM6Njg6YTQ6N2Q6MDU6MzJpbnRm',
                                                                       'pons': [       {       'description': '0/1:4',
                                                                                               'id': '153',
                                                                                               'links': [       {       'connected_time': '720',
                                                                                                                        'fiber_length': 1011,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjBpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -17.3,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:4',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2Q6MDU6MzJpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:59:71:bd'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '1526646',
                                                                       'in_ucast_pkts': '4199',
                                                                       'mac_address': '6c:68:a4:7d:05:32',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1601315',
                                                                       'out_ucast_pkts': '4261',
                                                                       'poller_hash': 'NmM6Njg6YTQ6N2Q6MDU6MzJldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/1:4',
                                         'poller_hash': 'NmM6Njg6YTQ6N2Q6MDU6MzJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:7d:05:32',
                                         'uptime': '720'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '154',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '4599',
                                                                       'in_ucast_pkts': '49',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '4599',
                                                                                                'in_ucast_pkts': '49',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '26771',
                                                                                                'out_ucast_pkts': '293',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjFpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:4',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '26771',
                                                                       'out_ucast_pkts': '293',
                                                                       'poller_hash': 'NmM6Njg6YTQ6N2M6Y2Q6MTJpbnRm',
                                                                       'pons': [       {       'description': '0/2:4',
                                                                                               'id': '154',
                                                                                               'links': [       {       'connected_time': '720',
                                                                                                                        'fiber_length': 1397,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjFpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -17.1,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:4',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2M6Y2Q6MTJpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:58:50:3d'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '26771',
                                                                       'in_ucast_pkts': '293',
                                                                       'mac_address': '6c:68:a4:7c:cd:12',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '4599',
                                                                       'out_ucast_pkts': '49',
                                                                       'poller_hash': 'NmM6Njg6YTQ6N2M6Y2Q6MTJldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/2:4',
                                         'poller_hash': 'NmM6Njg6YTQ6N2M6Y2Q6MTJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:7c:cd:12',
                                         'uptime': '720'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '98',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '403298',
                                                                       'in_ucast_pkts': '633',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '403298',
                                                                                                'in_ucast_pkts': '633',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '125133',
                                                                                                'out_ucast_pkts': '538',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjBpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '125133',
                                                                       'out_ucast_pkts': '538',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6YzU6MmZpbnRm',
                                                                       'pons': [       {       'description': '0/1:1',
                                                                                               'id': '98',
                                                                                               'links': [       {       'connected_time': '720',
                                                                                                                        'fiber_length': 1023,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjBpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -14.8,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.3}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:1',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6YzU6MmZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:1e:c5:30'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '125133',
                                                                       'in_ucast_pkts': '538',
                                                                       'mac_address': '6c:68:a4:1e:c5:2f',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '403298',
                                                                       'out_ucast_pkts': '633',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6YzU6MmZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/1:1',
                                         'poller_hash': 'NmM6Njg6YTQ6MWU6YzU6MmZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:1e:c5:2f',
                                         'uptime': '720'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '99',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '2742671',
                                                                       'in_ucast_pkts': '3932',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '2742671',
                                                                                                'in_ucast_pkts': '3932',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2',
                                                                                                'out_octets': '855331',
                                                                                                'out_ucast_pkts': '2969',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjZpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/7:1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2',
                                                                       'out_octets': '855331',
                                                                       'out_ucast_pkts': '2969',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NTA6ZGZpbnRm',
                                                                       'pons': [       {       'description': '0/7:1',
                                                                                               'id': '99',
                                                                                               'links': [       {       'connected_time': '720',
                                                                                                                        'fiber_length': 2106,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6NGY6NjZpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -14.9,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/7:1',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6NTA6ZGZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:68:a4:20:50:e0'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2',
                                                                       'in_octets': '855331',
                                                                       'in_ucast_pkts': '2969',
                                                                       'mac_address': '6c:68:a4:20:50:df',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2742671',
                                                                       'out_ucast_pkts': '3932',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6NTA6ZGZldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/7:1',
                                         'poller_hash': 'NmM6Njg6YTQ6MjA6NTA6ZGZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:20:50:df',
                                         'uptime': '720'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_bdcom_p3600_P3616_2TE_10_144_200_2(self):
        obj = self.run_data("bdcom.p3600.P3616-2TE.10_144_200_2")
        exp_info = {
                'model': 'P3616-2TE',
                'sta_count': 53,
                'sw_version': '10.1.0F Build 84472',
                'vendor': 'BDCOM'
        }
        exp_stats = {
         'serial_number': '00315078920'
        }
        exp_sta_stats = {
                '1c:ef:03:52:8d:70': {       'dev_macs': ['1c:ef:03:52:8d:71'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:52:8d:70',
                                             'name': 'EPON0/11:4',
                                             'serial_number': None},
                '1c:ef:03:52:cc:20': {       'dev_macs': ['1c:ef:03:52:cc:21'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:52:cc:20',
                                             'name': 'EPON0/13:1',
                                             'serial_number': None},
                '1c:ef:03:53:50:80': {       'dev_macs': ['1c:ef:03:53:50:81'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:53:50:80',
                                             'name': 'EPON0/1:4',
                                             'serial_number': None},
                '1c:ef:03:53:dd:c0': {       'dev_macs': ['1c:ef:03:53:dd:c1'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:53:dd:c0',
                                             'name': 'EPON0/13:4',
                                             'serial_number': None},
                '1c:ef:03:54:3f:00': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:54:3f:00',
                                             'name': 'EPON0/2:5',
                                             'serial_number': None},
                '1c:ef:03:55:f5:f0': {       'dev_macs': ['1c:ef:03:55:f5:f1'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:55:f5:f0',
                                             'name': 'EPON0/1:2',
                                             'serial_number': None},
                '1c:ef:03:57:0c:10': {       'dev_macs': ['1c:ef:03:57:0c:11'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:57:0c:10',
                                             'name': 'EPON0/6:3',
                                             'serial_number': None},
                '1c:ef:03:57:18:d0': {       'dev_macs': ['1c:ef:03:57:18:d1'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:57:18:d0',
                                             'name': 'EPON0/13:2',
                                             'serial_number': None},
                '1c:ef:03:57:1d:d0': {       'dev_macs': ['1c:ef:03:57:1d:d1'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:57:1d:d0',
                                             'name': 'EPON0/13:6',
                                             'serial_number': None},
                '1c:ef:03:76:19:42': {       'dev_macs': ['1c:ef:03:76:19:43'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:76:19:42',
                                             'name': 'EPON0/13:11',
                                             'serial_number': None},
                '1c:ef:03:76:38:12': {       'dev_macs': ['1c:ef:03:76:38:13'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:76:38:12',
                                             'name': 'EPON0/4:2',
                                             'serial_number': None},
                '1c:ef:03:76:39:52': {       'dev_macs': ['1c:ef:03:76:39:53'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:76:39:52',
                                             'name': 'EPON0/13:12',
                                             'serial_number': None},
                '1c:ef:03:76:47:42': {       'dev_macs': ['1c:ef:03:76:47:43'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:76:47:42',
                                             'name': 'EPON0/2:8',
                                             'serial_number': None},
                '1c:ef:03:76:e6:92': {       'dev_macs': ['1c:ef:03:76:e6:93'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:76:e6:92',
                                             'name': 'EPON0/13:10',
                                             'serial_number': None},
                '1c:ef:03:77:39:22': {       'dev_macs': ['1c:ef:03:77:39:23'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:77:39:22',
                                             'name': 'EPON0/11:9',
                                             'serial_number': None},
                '1c:ef:03:77:52:32': {       'dev_macs': ['1c:ef:03:77:52:33'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:77:52:32',
                                             'name': 'EPON0/2:6',
                                             'serial_number': None},
                '1c:ef:03:77:64:82': {       'dev_macs': ['1c:ef:03:77:64:83'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:77:64:82',
                                             'name': 'EPON0/11:8',
                                             'serial_number': None},
                '1c:ef:03:bd:2e:32': {       'dev_macs': ['1c:ef:03:bd:2e:33'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:bd:2e:32',
                                             'name': 'EPON0/11:10',
                                             'serial_number': None},
                '1c:ef:03:d6:9a:2d': {       'dev_macs': ['1c:ef:03:d6:9a:2e'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:d6:9a:2d',
                                             'name': 'EPON0/10:8',
                                             'serial_number': None},
                '1c:ef:03:d7:21:bd': {       'dev_macs': ['1c:ef:03:d7:21:be'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:d7:21:bd',
                                             'name': 'EPON0/2:9',
                                             'serial_number': None},
                '1c:ef:03:d7:53:ed': {       'dev_macs': ['1c:ef:03:d7:53:ee'],
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:d7:53:ed',
                                             'name': 'EPON0/12:6',
                                             'serial_number': None},
                '6c:68:a4:1e:a7:0f': {       'dev_macs': ['6c:68:a4:1e:a7:10'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1e:a7:0f',
                                             'name': 'EPON0/6:6',
                                             'serial_number': None},
                '6c:68:a4:1e:e3:2f': {       'dev_macs': ['6c:68:a4:1e:e3:30'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1e:e3:2f',
                                             'name': 'EPON0/8:2',
                                             'serial_number': None},
                '6c:68:a4:1e:e4:5f': {       'dev_macs': ['6c:68:a4:1e:e4:60'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1e:e4:5f',
                                             'name': 'EPON0/4:3',
                                             'serial_number': None},
                '6c:68:a4:1f:5a:af': {       'dev_macs': ['6c:68:a4:1f:5a:b0'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1f:5a:af',
                                             'name': 'EPON0/2:10',
                                             'serial_number': None},
                '6c:68:a4:1f:eb:0f': {       'dev_macs': ['6c:68:a4:1f:eb:10'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1f:eb:0f',
                                             'name': 'EPON0/13:14',
                                             'serial_number': None},
                '6c:68:a4:20:09:2f': {       'dev_macs': ['6c:68:a4:20:09:30'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:20:09:2f',
                                             'name': 'EPON0/13:13',
                                             'serial_number': None},
                '6c:68:a4:20:22:5f': {       'dev_macs': ['6c:68:a4:20:22:60'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:20:22:5f',
                                             'name': 'EPON0/3:5',
                                             'serial_number': None},
                '6c:68:a4:2c:26:76': {       'dev_macs': ['6c:68:a4:2c:26:77'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:2c:26:76',
                                             'name': 'EPON0/1:5',
                                             'serial_number': None},
                '70:b6:4f:4d:0d:68': {       'dev_macs': ['40:ee:15:40:4d:1d'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:4d:0d:68',
                                             'name': 'EPON0/12:1',
                                             'serial_number': None},
                '70:b6:4f:4d:32:10': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:4d:32:10',
                                             'name': 'EPON0/6:2',
                                             'serial_number': None},
                '70:b6:4f:4d:a1:90': {       'dev_macs': [       '40:ee:15:4d:1c:c5',
                                                                 '70:b6:4f:4d:a1:91'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:4d:a1:90',
                                             'name': 'EPON0/10:3',
                                             'serial_number': None},
                '70:b6:4f:4d:bb:b8': {       'dev_macs': [       '40:ee:15:4d:36:0d',
                                                                 '70:b6:4f:4d:bb:b9'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:4d:bb:b8',
                                             'name': 'EPON0/12:2',
                                             'serial_number': None},
                '70:b6:4f:d2:29:98': {       'dev_macs': [       '40:ee:15:68:b0:19',
                                                                 '70:b6:4f:d2:29:99'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:d2:29:98',
                                             'name': 'EPON0/11:6',
                                             'serial_number': None},
                '70:b6:4f:d2:29:f0': {       'dev_macs': [       '40:ee:15:50:ac:cd',
                                                                 '70:b6:4f:d2:29:f1'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:d2:29:f0',
                                             'name': 'EPON0/12:4',
                                             'serial_number': None},
                '70:b6:4f:e5:95:10': {       'dev_macs': ['70:b6:4f:e5:95:11'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:e5:95:10',
                                             'name': 'EPON0/6:5',
                                             'serial_number': None},
                '70:b6:4f:e5:c2:10': {       'dev_macs': ['70:b6:4f:e5:c2:11'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:e5:c2:10',
                                             'name': 'EPON0/14:3',
                                             'serial_number': None},
                '70:b6:4f:e6:02:30': {       'dev_macs': ['70:b6:4f:e6:02:31'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:e6:02:30',
                                             'name': 'EPON0/14:4',
                                             'serial_number': None},
                '70:b6:4f:e6:56:10': {       'dev_macs': ['70:b6:4f:e6:56:11'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:e6:56:10',
                                             'name': 'EPON0/4:1',
                                             'serial_number': None},
                '70:b6:4f:e6:b4:80': {       'dev_macs': ['70:b6:4f:e6:b4:81'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:e6:b4:80',
                                             'name': 'EPON0/3:3',
                                             'serial_number': None},
                '70:b6:4f:e6:b8:70': {       'dev_macs': ['70:b6:4f:e6:b8:71'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:e6:b8:70',
                                             'name': 'EPON0/10:7',
                                             'serial_number': None},
                '70:b6:4f:e7:03:d0': {       'dev_macs': ['70:b6:4f:e7:03:d1'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:e7:03:d0',
                                             'name': 'EPON0/6:4',
                                             'serial_number': None},
                '70:b6:4f:e7:10:e0': {       'dev_macs': ['70:b6:4f:e7:10:e1'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:e7:10:e0',
                                             'name': 'EPON0/3:4',
                                             'serial_number': None},
                '70:b6:4f:fb:44:e8': {       'dev_macs': ['70:b6:4f:fb:44:e9'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fb:44:e8',
                                             'name': 'EPON0/1:3',
                                             'serial_number': None},
                '70:b6:4f:fb:5f:e8': {       'dev_macs': ['70:b6:4f:fb:5f:e9'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fb:5f:e8',
                                             'name': 'EPON0/2:2',
                                             'serial_number': None},
                '70:b6:4f:fb:9b:c8': {       'dev_macs': ['70:b6:4f:fb:9b:c9'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fb:9b:c8',
                                             'name': 'EPON0/2:4',
                                             'serial_number': None},
                '70:b6:4f:fb:9d:28': {       'dev_macs': ['70:b6:4f:fb:9d:29'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fb:9d:28',
                                             'name': 'EPON0/6:1',
                                             'serial_number': None},
                '70:b6:4f:fb:b2:18': {       'dev_macs': ['70:b6:4f:fb:b2:19'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fb:b2:18',
                                             'name': 'EPON0/14:2',
                                             'serial_number': None},
                '70:b6:4f:fc:06:38': {       'dev_macs': ['70:b6:4f:fc:06:39'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fc:06:38',
                                             'name': 'EPON0/3:1',
                                             'serial_number': None},
                '70:b6:4f:fc:15:18': {       'dev_macs': ['70:b6:4f:fc:15:19'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fc:15:18',
                                             'name': 'EPON0/11:1',
                                             'serial_number': None},
                '70:b6:4f:fc:2f:f8': {       'dev_macs': ['70:b6:4f:fc:2f:f9'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fc:2f:f8',
                                             'name': 'EPON0/12:3',
                                             'serial_number': None},
                '70:b6:4f:fd:36:c8': {       'dev_macs': ['70:b6:4f:fd:36:c9'],
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fd:36:c8',
                                             'name': 'EPON0/2:3',
                                             'serial_number': None},
                '80:07:1b:d4:94:40': {       'dev_macs': ['40:ee:15:40:39:5d'],
                                             'ip_address': None,
                                             'mac_address': '80:07:1b:d4:94:40',
                                             'name': 'EPON0/12:5',
                                             'serial_number': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 30.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '65',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:45:62:4d',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NGRpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '66',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:45:62:4e',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/2',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NGVpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '67',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:45:62:4f',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/3',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NGZpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '68',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:45:62:50',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/4',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTBpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '69',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:45:62:51',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/5',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTFpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '70',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:45:62:52',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/6',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTJpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '71',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:45:62:53',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/7',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTNpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '72',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:45:62:54',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/8',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTRpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '73',
                                                              'in_discards': '229708978',
                                                              'in_errors': '4244604',
                                                              'in_nucast_pkts': '18655027',
                                                              'in_octets': '278503361377258',
                                                              'in_ucast_pkts': '211960521123',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:45:62:55',
                                                              'mtu': 1700,
                                                              'name': 'TGigaEthernet0/1',
                                                              'oper_up': True,
                                                              'out_discards': '5',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '23348114',
                                                              'out_octets': '22129969960180',
                                                              'out_ucast_pkts': '76975390304',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTVpbnRm',
                                                              'speed': '10000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '74',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:45:62:56',
                                                              'mtu': 1700,
                                                              'name': 'TGigaEthernet0/2',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTZpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '75',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1500,
                                                              'name': 'FastEthernet0/1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'NzVpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '76',
                                                              'in_discards': '13',
                                                              'in_errors': '13',
                                                              'in_nucast_pkts': '63207',
                                                              'in_octets': '1066670890533',
                                                              'in_ucast_pkts': '4139042421',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '4366',
                                                                                       'in_octets': '471674578691',
                                                                                       'in_ucast_pkts': '2045802890',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '8215308880705',
                                                                                       'out_ucast_pkts': '6313977320',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6NTU6ZjU6ZjBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2738',
                                                                                       'in_octets': '284140393026',
                                                                                       'in_ucast_pkts': '626231320',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2273657898273',
                                                                                       'out_ucast_pkts': '1802390858',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZmI6NDQ6ZThpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '1620',
                                                                                       'in_octets': '82620512697',
                                                                                       'in_ucast_pkts': '328655785',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1438281648167',
                                                                                       'out_ucast_pkts': '1064126004',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6NTM6NTA6ODBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '70',
                                                                                       'in_octets': '33546932842',
                                                                                       'in_ucast_pkts': '168263067',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '435906803151',
                                                                                       'out_ucast_pkts': '332027063',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MmM6MjY6NzZpbnRm'}],
                                                              'mac_address': '00:55:b1:45:62:57',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '15588001850567',
                                                              'out_ucast_pkts': '11927130593',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTdpbnRm',
                                                              'pons': [       {       'description': '0/1',
                                                                                      'id': '76',
                                                                                      'links': [       {       'fiber_length': 4024,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6NTU6ZjU6ZjBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -21.4,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'fiber_length': 4105,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZmI6NDQ6ZThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -21.9,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'fiber_length': 3992,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6NTM6NTA6ODBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.9,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'fiber_length': 3887,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MmM6MjY6NzZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.2,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/1',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTdpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '77',
                                                              'in_discards': '7',
                                                              'in_errors': '7',
                                                              'in_nucast_pkts': '156674',
                                                              'in_octets': '3472378425423',
                                                              'in_ucast_pkts': '12256100960',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '4247',
                                                                                       'in_octets': '1059204966586',
                                                                                       'in_ucast_pkts': '2923192037',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '9330005095841',
                                                                                       'out_ucast_pkts': '7050890460',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZmI6NWY6ZThpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '3182',
                                                                                       'in_octets': '395937446924',
                                                                                       'in_ucast_pkts': '1243883584',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '4491878836511',
                                                                                       'out_ucast_pkts': '3639225516',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZmQ6MzY6YzhpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2369',
                                                                                       'in_octets': '380300167755',
                                                                                       'in_ucast_pkts': '2086342628',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '7659441485159',
                                                                                       'out_ucast_pkts': '6139055666',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZmI6OWI6YzhpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '3678',
                                                                                       'in_octets': '281898152580',
                                                                                       'in_ucast_pkts': '874108379',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3007581087413',
                                                                                       'out_ucast_pkts': '2406872906',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6NTQ6M2Y6MDBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '11323',
                                                                                       'in_octets': '147227930968',
                                                                                       'in_ucast_pkts': '539730438',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2287541325050',
                                                                                       'out_ucast_pkts': '1798509598',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6Nzc6NTI6MzJpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '604',
                                                                                       'in_octets': '488430892999',
                                                                                       'in_ucast_pkts': '890071225',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1680641989316',
                                                                                       'out_ucast_pkts': '1464639353',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6NzY6NDc6NDJpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '1270',
                                                                                       'in_octets': '88198428061',
                                                                                       'in_ucast_pkts': '395262554',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1201688184709',
                                                                                       'out_ucast_pkts': '1006561479',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6ZDc6MjE6YmRpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '64',
                                                                                       'in_octets': '32086019565',
                                                                                       'in_ucast_pkts': '72606685',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '291878417467',
                                                                                       'out_ucast_pkts': '216068773',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6NWE6YWZpbnRm'}],
                                                              'mac_address': '00:55:b1:45:62:58',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/2',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '43908830244561',
                                                              'out_ucast_pkts': '34030820485',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThpbnRm',
                                                              'pons': [       {       'description': '0/2',
                                                                                      'id': '77',
                                                                                      'links': [       {       'fiber_length': 4308,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZmI6NWY6ZThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -23.0,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.3},
                                                                                                       {       'fiber_length': 5362,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZmQ6MzY6YzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -21.4,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.3},
                                                                                                       {       'fiber_length': 4620,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZmI6OWI6YzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -26.5,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.3},
                                                                                                       {       'fiber_length': 4378,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6NTQ6M2Y6MDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.2,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.3},
                                                                                                       {       'fiber_length': 4193,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6Nzc6NTI6MzJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -21.4,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.3},
                                                                                                       {       'fiber_length': 4555,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6NzY6NDc6NDJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.2,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.3},
                                                                                                       {       'fiber_length': 4589,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6ZDc6MjE6YmRpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -21.1,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.3},
                                                                                                       {       'fiber_length': 5192,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWY6NWE6YWZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -25.6,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.3}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/2',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '78',
                                                              'in_discards': '1184',
                                                              'in_errors': '1184',
                                                              'in_nucast_pkts': '7776',
                                                              'in_octets': '1048310170684',
                                                              'in_ucast_pkts': '3895530489',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '1505',
                                                                                       'in_octets': '382820657384',
                                                                                       'in_ucast_pkts': '1601959706',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2086854229981',
                                                                                       'out_ucast_pkts': '2074588134',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZTY6YjQ6ODBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '1625',
                                                                                       'in_octets': '408112064118',
                                                                                       'in_ucast_pkts': '757826938',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3837831711817',
                                                                                       'out_ucast_pkts': '2918756923',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZTc6MTA6ZTBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '569',
                                                                                       'in_octets': '2483908896',
                                                                                       'in_ucast_pkts': '6833369',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '9662876235',
                                                                                       'out_ucast_pkts': '9319794',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6MjI6NWZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2470',
                                                                                       'in_octets': '170560138283',
                                                                                       'in_ucast_pkts': '791303612',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3818969722832',
                                                                                       'out_ucast_pkts': '2818871706',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZmM6MDY6MzhpbnRm'}],
                                                              'mac_address': '00:55:b1:45:62:59',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/3',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '12001809394510',
                                                              'out_ucast_pkts': '9419208812',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTlpbnRm',
                                                              'pons': [       {       'description': '0/3',
                                                                                      'id': '78',
                                                                                      'links': [       {       'fiber_length': 4790,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZTY6YjQ6ODBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.3,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'fiber_length': 5210,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZTc6MTA6ZTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -24.4,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'fiber_length': 4973,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6MjI6NWZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -23.1,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'fiber_length': 5314,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZmM6MDY6MzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -26.9,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.8}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/3',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTlpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '79',
                                                              'in_discards': '3',
                                                              'in_errors': '3',
                                                              'in_nucast_pkts': '4420',
                                                              'in_octets': '648379467329',
                                                              'in_ucast_pkts': '1762068925',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2082',
                                                                                       'in_octets': '325646049474',
                                                                                       'in_ucast_pkts': '683347209',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1780593622048',
                                                                                       'out_ucast_pkts': '1402939414',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZTY6NTY6MTBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2034',
                                                                                       'in_octets': '240820535001',
                                                                                       'in_ucast_pkts': '778095310',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2798298793343',
                                                                                       'out_ucast_pkts': '2146680999',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6NzY6Mzg6MTJpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '304',
                                                                                       'in_octets': '81912898483',
                                                                                       'in_ucast_pkts': '300626436',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1002233889376',
                                                                                       'out_ucast_pkts': '760242403',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6ZTQ6NWZpbnRm'}],
                                                              'mac_address': '00:55:b1:45:62:5a',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/4',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '5581208890771',
                                                              'out_ucast_pkts': '4310052890',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWFpbnRm',
                                                              'pons': [       {       'description': '0/4',
                                                                                      'id': '79',
                                                                                      'links': [       {       'fiber_length': 5798,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZTY6NTY6MTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.0,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'fiber_length': 5017,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6NzY6Mzg6MTJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -20.5,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'fiber_length': 5701,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6ZTQ6NWZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.1,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.9}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/4',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWFpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '80',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:45:62:5f',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/9',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '82665335',
                                                              'out_ucast_pkts': '190122',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWZpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '81',
                                                              'in_discards': '970',
                                                              'in_errors': '970',
                                                              'in_nucast_pkts': '279380',
                                                              'in_octets': '2309259435509',
                                                              'in_ucast_pkts': '7727298637',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '112768',
                                                                                       'in_octets': '462143081462',
                                                                                       'in_ucast_pkts': '1637509182',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '5047204076541',
                                                                                       'out_ucast_pkts': '3920864195',
                                                                                       'poller_hash': 'NzA6YjY6NGY6NGQ6YTE6OTBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2133',
                                                                                       'in_octets': '351118588521',
                                                                                       'in_ucast_pkts': '1803046434',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '5861362235867',
                                                                                       'out_ucast_pkts': '4411114827',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZTY6Yjg6NzBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '925',
                                                                                       'in_octets': '101075745225',
                                                                                       'in_ucast_pkts': '618457227',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2185000905456',
                                                                                       'out_ucast_pkts': '1621816578',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6ZDY6OWE6MmRpbnRm'}],
                                                              'mac_address': '00:55:b1:45:62:60',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/10',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '30086108483308',
                                                              'out_ucast_pkts': '22409772282',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjBpbnRm',
                                                              'pons': [       {       'description': '0/10',
                                                                                      'id': '81',
                                                                                      'links': [       {       'fiber_length': 3541,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6NGQ6YTE6OTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -24.6,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6},
                                                                                                       {       'fiber_length': 3684,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZTY6Yjg6NzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -24.3,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6},
                                                                                                       {       'fiber_length': 3718,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6ZDY6OWE6MmRpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -23.9,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/10',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjBpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '82',
                                                              'in_discards': '831',
                                                              'in_errors': '831',
                                                              'in_nucast_pkts': '110775',
                                                              'in_octets': '3108376733173',
                                                              'in_ucast_pkts': '11810047357',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '3775',
                                                                                       'in_octets': '582728921661',
                                                                                       'in_ucast_pkts': '1313370376',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '4056601561089',
                                                                                       'out_ucast_pkts': '3221645575',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZmM6MTU6MThpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '4564',
                                                                                       'in_octets': '532294732435',
                                                                                       'in_ucast_pkts': '3051960609',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '8052218494171',
                                                                                       'out_ucast_pkts': '6007784456',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6NTI6OGQ6NzBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '87834',
                                                                                       'in_octets': '148981464876',
                                                                                       'in_ucast_pkts': '1112548127',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '6829535310497',
                                                                                       'out_ucast_pkts': '4792364054',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZDI6Mjk6OThpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2114',
                                                                                       'in_octets': '368382710336',
                                                                                       'in_ucast_pkts': '1155186334',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3989373514281',
                                                                                       'out_ucast_pkts': '3119386367',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6Nzc6NjQ6ODJpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '1206',
                                                                                       'in_octets': '397306755928',
                                                                                       'in_ucast_pkts': '865390378',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2483684297390',
                                                                                       'out_ucast_pkts': '2039165512',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6Nzc6Mzk6MjJpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '1326',
                                                                                       'in_octets': '165183637081',
                                                                                       'in_ucast_pkts': '465101081',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1338077653711',
                                                                                       'out_ucast_pkts': '1057371627',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6YmQ6MmU6MzJpbnRm'}],
                                                              'mac_address': '00:55:b1:45:62:61',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/11',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '40736420286157',
                                                              'out_ucast_pkts': '30827185004',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFpbnRm',
                                                              'pons': [       {       'description': '0/11',
                                                                                      'id': '82',
                                                                                      'links': [       {       'fiber_length': 3911,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZmM6MTU6MThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -24.5,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6},
                                                                                                       {       'fiber_length': 3896,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6NTI6OGQ6NzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -23.5,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6},
                                                                                                       {       'fiber_length': 3961,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZDI6Mjk6OThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.7,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6},
                                                                                                       {       'fiber_length': 5594,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6Nzc6NjQ6ODJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -30.4,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6},
                                                                                                       {       'fiber_length': 3347,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6Nzc6Mzk6MjJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.1,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6},
                                                                                                       {       'fiber_length': 3212,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6YmQ6MmU6MzJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.7,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/11',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '83',
                                                              'in_discards': '1524',
                                                              'in_errors': '1524',
                                                              'in_nucast_pkts': '404942',
                                                              'in_octets': '1784116484536',
                                                              'in_ucast_pkts': '7528049545',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '125804',
                                                                                       'in_octets': '376529379416',
                                                                                       'in_ucast_pkts': '2111121809',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '7908301367818',
                                                                                       'out_ucast_pkts': '5858989773',
                                                                                       'poller_hash': 'NzA6YjY6NGY6NGQ6MGQ6NjhpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '111795',
                                                                                       'in_octets': '352258649331',
                                                                                       'in_ucast_pkts': '1682188370',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '4893236083434',
                                                                                       'out_ucast_pkts': '4156134898',
                                                                                       'poller_hash': 'NzA6YjY6NGY6NGQ6YmI6YjhpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '3705',
                                                                                       'in_octets': '667239624558',
                                                                                       'in_ucast_pkts': '1630763077',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '4668623967216',
                                                                                       'out_ucast_pkts': '3652428195',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZmM6MmY6ZjhpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '87903',
                                                                                       'in_octets': '105344204223',
                                                                                       'in_ucast_pkts': '539225362',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2627263793545',
                                                                                       'out_ucast_pkts': '2034886356',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZDI6Mjk6ZjBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '75002',
                                                                                       'in_octets': '208437557583',
                                                                                       'in_ucast_pkts': '1128732869',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '5582165847035',
                                                                                       'out_ucast_pkts': '4239794999',
                                                                                       'poller_hash': 'ODA6MDc6MWI6ZDQ6OTQ6NDBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '733',
                                                                                       'in_octets': '74307084056',
                                                                                       'in_ucast_pkts': '436018089',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2635619653468',
                                                                                       'out_ucast_pkts': '1843268952',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6ZDc6NTM6ZWRpbnRm'}],
                                                              'mac_address': '00:55:b1:45:62:62',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/12',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '28315293087410',
                                                              'out_ucast_pkts': '21785693212',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJpbnRm',
                                                              'pons': [       {       'description': '0/12',
                                                                                      'id': '83',
                                                                                      'links': [       {       'fiber_length': 4488,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6NGQ6MGQ6NjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.0,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6},
                                                                                                       {       'fiber_length': 3989,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6NGQ6YmI6YjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -28.2,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6},
                                                                                                       {       'fiber_length': 3977,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZmM6MmY6ZjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -24.4,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6},
                                                                                                       {       'fiber_length': 3882,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZDI6Mjk6ZjBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -26.9,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6},
                                                                                                       {       'fiber_length': 3945,
                                                                                                               'poller_hash': 'ODA6MDc6MWI6ZDQ6OTQ6NDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -25.5,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6},
                                                                                                       {       'fiber_length': 3742,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6ZDc6NTM6ZWRpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -23.5,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/12',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '84',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:45:62:5b',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/5',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '82665335',
                                                              'out_ucast_pkts': '190122',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWJpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '85',
                                                              'in_discards': '52608',
                                                              'in_errors': '52608',
                                                              'in_nucast_pkts': '137031',
                                                              'in_octets': '2294255061066',
                                                              'in_ucast_pkts': '6979100453',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2868',
                                                                                       'in_octets': '353535568725',
                                                                                       'in_ucast_pkts': '1164056056',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3440500469741',
                                                                                       'out_ucast_pkts': '2684734861',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6NTc6MGM6MTBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '5110',
                                                                                       'in_octets': '549496199724',
                                                                                       'in_ucast_pkts': '1315442567',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '5252847491463',
                                                                                       'out_ucast_pkts': '4004029511',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZTc6MDM6ZDBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '3236',
                                                                                       'in_octets': '244669951791',
                                                                                       'in_ucast_pkts': '1092973113',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '6240222958329',
                                                                                       'out_ucast_pkts': '4411440996',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZTU6OTU6MTBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '543',
                                                                                       'in_octets': '13808634777',
                                                                                       'in_ucast_pkts': '75386086',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '266973917205',
                                                                                       'out_ucast_pkts': '208339632',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6YTc6MGZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '3893',
                                                                                       'in_octets': '278178310246',
                                                                                       'in_ucast_pkts': '590040468',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2105659526257',
                                                                                       'out_ucast_pkts': '1714850629',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZmI6OWQ6MjhpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '121381',
                                                                                       'in_octets': '854566398913',
                                                                                       'in_ucast_pkts': '2741202166',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '11352351267545',
                                                                                       'out_ucast_pkts': '8761947932',
                                                                                       'poller_hash': 'NzA6YjY6NGY6NGQ6MzI6MTBpbnRm'}],
                                                              'mac_address': '00:55:b1:45:62:5c',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/6',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '28658638259690',
                                                              'out_ucast_pkts': '21785533671',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWNpbnRm',
                                                              'pons': [       {       'description': '0/6',
                                                                                      'id': '85',
                                                                                      'links': [       {       'fiber_length': 5177,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6NTc6MGM6MTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -23.7,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6},
                                                                                                       {       'fiber_length': 4730,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZTc6MDM6ZDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -26.3,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6},
                                                                                                       {       'fiber_length': 4527,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZTU6OTU6MTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -24.9,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6},
                                                                                                       {       'fiber_length': 4310,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6YTc6MGZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -23.4,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6},
                                                                                                       {       'fiber_length': 4584,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZmI6OWQ6MjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -23.4,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6},
                                                                                                       {       'fiber_length': 4165,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6NGQ6MzI6MTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -21.3,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/6',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWNpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '86',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:45:62:5d',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/7',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '82665335',
                                                              'out_ucast_pkts': '190122',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWRpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '87',
                                                              'in_discards': '177',
                                                              'in_errors': '177',
                                                              'in_nucast_pkts': '19480',
                                                              'in_octets': '190138221651',
                                                              'in_ucast_pkts': '723060689',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '532',
                                                                                       'in_octets': '63112572044',
                                                                                       'in_ucast_pkts': '339813830',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '869811077504',
                                                                                       'out_ucast_pkts': '627441142',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6ZTM6MmZpbnRm'}],
                                                              'mac_address': '00:55:b1:45:62:5e',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/8',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1972965069866',
                                                              'out_ucast_pkts': '1503093597',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWVpbnRm',
                                                              'pons': [       {       'description': '0/8',
                                                                                      'id': '87',
                                                                                      'links': [       {       'fiber_length': 4071,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6ZTM6MmZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -24.9,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.6}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/8',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWVpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '88',
                                                              'in_discards': '171',
                                                              'in_errors': '171',
                                                              'in_nucast_pkts': '55537',
                                                              'in_octets': '4524311559174',
                                                              'in_ucast_pkts': '12801048303',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '3202',
                                                                                       'in_octets': '2132226288330',
                                                                                       'in_ucast_pkts': '4944481934',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '15835715220414',
                                                                                       'out_ucast_pkts': '12685286384',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6NTI6Y2M6MjBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '1663',
                                                                                       'in_octets': '400520226391',
                                                                                       'in_ucast_pkts': '1255398658',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3478250167964',
                                                                                       'out_ucast_pkts': '2815034972',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6NTc6MTg6ZDBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '3465',
                                                                                       'in_octets': '205736207218',
                                                                                       'in_ucast_pkts': '1397393137',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '6134028292352',
                                                                                       'out_ucast_pkts': '4247981167',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6NTM6ZGQ6YzBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2321',
                                                                                       'in_octets': '329589566506',
                                                                                       'in_ucast_pkts': '750577457',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2581351147716',
                                                                                       'out_ucast_pkts': '1996047750',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6NTc6MWQ6ZDBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '3566',
                                                                                       'in_octets': '220195238065',
                                                                                       'in_ucast_pkts': '913878789',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2300093212729',
                                                                                       'out_ucast_pkts': '1831160956',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6NzY6ZTY6OTJpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '920',
                                                                                       'in_octets': '124565056535',
                                                                                       'in_ucast_pkts': '329906495',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '876610806614',
                                                                                       'out_ucast_pkts': '727412386',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6NzY6MTk6NDJpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '334',
                                                                                       'in_octets': '24386064425',
                                                                                       'in_ucast_pkts': '95765436',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '361811125149',
                                                                                       'out_ucast_pkts': '276584892',
                                                                                       'poller_hash': 'MWM6ZWY6MDM6NzY6Mzk6NTJpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '521',
                                                                                       'in_octets': '14900130384',
                                                                                       'in_ucast_pkts': '63172474',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '266193040821',
                                                                                       'out_ucast_pkts': '200656777',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6MDk6MmZpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '493',
                                                                                       'in_octets': '35840640862',
                                                                                       'in_ucast_pkts': '152090451',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '807006694706',
                                                                                       'out_ucast_pkts': '639548895',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6ZWI6MGZpbnRm'}],
                                                              'mac_address': '00:55:b1:45:62:63',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/13',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '43913616243984',
                                                              'out_ucast_pkts': '34029879303',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRm',
                                                              'pons': [       {       'description': '0/13',
                                                                                      'id': '88',
                                                                                      'links': [       {       'fiber_length': 3353,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6NTI6Y2M6MjBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -23.5,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'fiber_length': 3416,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6NTc6MTg6ZDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -24.5,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'fiber_length': 3132,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6NTM6ZGQ6YzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.2,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'fiber_length': 4114,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6NTc6MWQ6ZDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -24.0,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'fiber_length': 3638,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6NzY6ZTY6OTJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -26.5,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'fiber_length': 3622,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6NzY6MTk6NDJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -24.9,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'fiber_length': 3762,
                                                                                                               'poller_hash': 'MWM6ZWY6MDM6NzY6Mzk6NTJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -23.2,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'fiber_length': 2792,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6MDk6MmZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.0,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'fiber_length': 2747,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWY6ZWI6MGZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -22.2,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/13',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '89',
                                                              'in_discards': '43',
                                                              'in_errors': '43',
                                                              'in_nucast_pkts': '8157',
                                                              'in_octets': '1346969230365',
                                                              'in_ucast_pkts': '7478281241',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '1067',
                                                                                       'in_octets': '325156131989',
                                                                                       'in_ucast_pkts': '2096884865',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '5787593563795',
                                                                                       'out_ucast_pkts': '4230170564',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZmI6YjI6MThpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '2207',
                                                                                       'in_octets': '269036311138',
                                                                                       'in_ucast_pkts': '1893905975',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '6773575540708',
                                                                                       'out_ucast_pkts': '4735942020',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZTU6YzI6MTBpbnRm'},
                                                                               {       'in_errors': '0',
                                                                                       'in_nucast_pkts': '1092',
                                                                                       'in_octets': '251394136891',
                                                                                       'in_ucast_pkts': '1261762611',
                                                                                       'oper_up': True,
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '4533380639133',
                                                                                       'out_ucast_pkts': '3498195928',
                                                                                       'poller_hash': 'NzA6YjY6NGY6ZTY6MDI6MzBpbnRm'}],
                                                              'mac_address': '00:55:b1:45:62:64',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/14',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '26536641014129',
                                                              'out_ucast_pkts': '19520012223',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjRpbnRm',
                                                              'pons': [       {       'description': '0/14',
                                                                                      'id': '89',
                                                                                      'links': [       {       'fiber_length': 3838,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZmI6YjI6MThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -28.2,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'fiber_length': 3335,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZTU6YzI6MTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -27.4,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'fiber_length': 4352,
                                                                                                               'poller_hash': 'NzA6YjY6NGY6ZTY6MDI6MzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1250000000',
                                                                                                               'rx_power': -24.0,
                                                                                                               'tx_link_rate': '1250000000',
                                                                                                               'tx_power': 5.7}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/14',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjRpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1250000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1250000000'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '90',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:45:62:65',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/15',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '82665335',
                                                              'out_ucast_pkts': '190122',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjVpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '91',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:55:b1:45:62:66',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/16',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '82665335',
                                                              'out_ucast_pkts': '190122',
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjZpbnRm',
                                                              'type': 1}],
                                'manufacturer': 'BDCOM',
                                'mem': 34.0,
                                'model': 'P3616-2TE',
                                'serial_number': '00315078920',
                                'sw_version': '10.1.0F Build 84472',
                                'system_mac_address': '00:55:b1:45:62:4c',
                                'temperature': 56.0},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '102',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '5047204076541',
                                                                       'in_ucast_pkts': '3920864195',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '5047204076541',
                                                                                                'in_ucast_pkts': '3920864195',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '112768',
                                                                                                'out_octets': '462143081462',
                                                                                                'out_ucast_pkts': '1637509182',
                                                                                                'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjBpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/10:3',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '112768',
                                                                       'out_octets': '462143081462',
                                                                       'out_ucast_pkts': '1637509182',
                                                                       'poller_hash': 'NzA6YjY6NGY6NGQ6YTE6OTBpbnRm',
                                                                       'pons': [       {       'description': '0/10:3',
                                                                                               'id': '102',
                                                                                               'links': [       {       'fiber_length': 3541,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjBpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -18.2,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/10:3',
                                                                                               'poller_hash': 'NzA6YjY6NGY6NGQ6YTE6OTBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ee:15:4d:1c:c5',
                                                                                                        '70:b6:4f:4d:a1:91'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '112768',
                                                                       'in_octets': '462143081462',
                                                                       'in_ucast_pkts': '1637509182',
                                                                       'mac_address': '70:b6:4f:4d:a1:90',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '5047204076541',
                                                                       'out_ucast_pkts': '3920864195',
                                                                       'poller_hash': 'NzA6YjY6NGY6NGQ6YTE6OTBldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'V2801SG',
                                         'name': 'EPON0/10:3',
                                         'poller_hash': 'NzA6YjY6NGY6NGQ6YTE6OTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.7P1T8',
                                         'system_mac_address': '70:b6:4f:4d:a1:90'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '103',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '4056601561089',
                                                                       'in_ucast_pkts': '3221645575',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '4056601561089',
                                                                                                'in_ucast_pkts': '3221645575',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '3775',
                                                                                                'out_octets': '582728921661',
                                                                                                'out_ucast_pkts': '1313370376',
                                                                                                'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/11:1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3775',
                                                                       'out_octets': '582728921661',
                                                                       'out_ucast_pkts': '1313370376',
                                                                       'poller_hash': 'NzA6YjY6NGY6ZmM6MTU6MThpbnRm',
                                                                       'pons': [       {       'description': '0/11:1',
                                                                                               'id': '103',
                                                                                               'links': [       {       'fiber_length': 3911,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -19.6,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.3}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/11:1',
                                                                                               'poller_hash': 'NzA6YjY6NGY6ZmM6MTU6MThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '70:b6:4f:fc:15:19'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3775',
                                                                       'in_octets': '582728921661',
                                                                       'in_ucast_pkts': '1313370376',
                                                                       'mac_address': '70:b6:4f:fc:15:18',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '4056601561089',
                                                                       'out_ucast_pkts': '3221645575',
                                                                       'poller_hash': 'NzA6YjY6NGY6ZmM6MTU6MThldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/11:1',
                                         'poller_hash': 'NzA6YjY6NGY6ZmM6MTU6MThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:fc:15:18'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '104',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '7908301367818',
                                                                       'in_ucast_pkts': '5858989773',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '7908301367818',
                                                                                                'in_ucast_pkts': '5858989773',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '125804',
                                                                                                'out_octets': '376529379416',
                                                                                                'out_ucast_pkts': '2111121809',
                                                                                                'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/12:1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '125804',
                                                                       'out_octets': '376529379416',
                                                                       'out_ucast_pkts': '2111121809',
                                                                       'poller_hash': 'NzA6YjY6NGY6NGQ6MGQ6NjhpbnRm',
                                                                       'pons': [       {       'description': '0/12:1',
                                                                                               'id': '104',
                                                                                               'links': [       {       'fiber_length': 4488,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -16.3,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.3}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/12:1',
                                                                                               'poller_hash': 'NzA6YjY6NGY6NGQ6MGQ6NjhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ee:15:40:4d:1d'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '125804',
                                                                       'in_octets': '376529379416',
                                                                       'in_ucast_pkts': '2111121809',
                                                                       'mac_address': '70:b6:4f:4d:0d:68',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '7908301367818',
                                                                       'out_ucast_pkts': '5858989773',
                                                                       'poller_hash': 'NzA6YjY6NGY6NGQ6MGQ6NjhldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'V2801SG',
                                         'name': 'EPON0/12:1',
                                         'poller_hash': 'NzA6YjY6NGY6NGQ6MGQ6NjhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.7P1T8',
                                         'system_mac_address': '70:b6:4f:4d:0d:68'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '108',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '4893236083434',
                                                                       'in_ucast_pkts': '4156134898',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '4893236083434',
                                                                                                'in_ucast_pkts': '4156134898',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '111795',
                                                                                                'out_octets': '352258649331',
                                                                                                'out_ucast_pkts': '1682188370',
                                                                                                'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/12:2',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '111795',
                                                                       'out_octets': '352258649331',
                                                                       'out_ucast_pkts': '1682188370',
                                                                       'poller_hash': 'NzA6YjY6NGY6NGQ6YmI6YjhpbnRm',
                                                                       'pons': [       {       'description': '0/12:2',
                                                                                               'id': '108',
                                                                                               'links': [       {       'fiber_length': 3989,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -22.7,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/12:2',
                                                                                               'poller_hash': 'NzA6YjY6NGY6NGQ6YmI6YjhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ee:15:4d:36:0d',
                                                                                                        '70:b6:4f:4d:bb:b9'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '111795',
                                                                       'in_octets': '352258649331',
                                                                       'in_ucast_pkts': '1682188370',
                                                                       'mac_address': '70:b6:4f:4d:bb:b8',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '4893236083434',
                                                                       'out_ucast_pkts': '4156134898',
                                                                       'poller_hash': 'NzA6YjY6NGY6NGQ6YmI6YjhldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'V2801SG',
                                         'name': 'EPON0/12:2',
                                         'poller_hash': 'NzA6YjY6NGY6NGQ6YmI6YjhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.7P1T8',
                                         'system_mac_address': '70:b6:4f:4d:bb:b8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '109',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '4668623967216',
                                                                       'in_ucast_pkts': '3652428195',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '4668623967216',
                                                                                                'in_ucast_pkts': '3652428195',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '3705',
                                                                                                'out_octets': '667239624558',
                                                                                                'out_ucast_pkts': '1630763077',
                                                                                                'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/12:3',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3705',
                                                                       'out_octets': '667239624558',
                                                                       'out_ucast_pkts': '1630763077',
                                                                       'poller_hash': 'NzA6YjY6NGY6ZmM6MmY6ZjhpbnRm',
                                                                       'pons': [       {       'description': '0/12:3',
                                                                                               'id': '109',
                                                                                               'links': [       {       'fiber_length': 3977,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/12:3',
                                                                                               'poller_hash': 'NzA6YjY6NGY6ZmM6MmY6ZjhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '70:b6:4f:fc:2f:f9'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3705',
                                                                       'in_octets': '667239624558',
                                                                       'in_ucast_pkts': '1630763077',
                                                                       'mac_address': '70:b6:4f:fc:2f:f8',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '4668623967216',
                                                                       'out_ucast_pkts': '3652428195',
                                                                       'poller_hash': 'NzA6YjY6NGY6ZmM6MmY6ZjhldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/12:3',
                                         'poller_hash': 'NzA6YjY6NGY6ZmM6MmY6ZjhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:fc:2f:f8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '112',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '9330005095841',
                                                                       'in_ucast_pkts': '7050890460',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '9330005095841',
                                                                                                'in_ucast_pkts': '7050890460',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '4247',
                                                                                                'out_octets': '1059204966586',
                                                                                                'out_ucast_pkts': '2923192037',
                                                                                                'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:2',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4247',
                                                                       'out_octets': '1059204966586',
                                                                       'out_ucast_pkts': '2923192037',
                                                                       'poller_hash': 'NzA6YjY6NGY6ZmI6NWY6ZThpbnRm',
                                                                       'pons': [       {       'description': '0/2:2',
                                                                                               'id': '112',
                                                                                               'links': [       {       'fiber_length': 4308,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -16.4,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:2',
                                                                                               'poller_hash': 'NzA6YjY6NGY6ZmI6NWY6ZThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '70:b6:4f:fb:5f:e9'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4247',
                                                                       'in_octets': '1059204966586',
                                                                       'in_ucast_pkts': '2923192037',
                                                                       'mac_address': '70:b6:4f:fb:5f:e8',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '9330005095841',
                                                                       'out_ucast_pkts': '7050890460',
                                                                       'poller_hash': 'NzA6YjY6NGY6ZmI6NWY6ZThldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/2:2',
                                         'poller_hash': 'NzA6YjY6NGY6ZmI6NWY6ZThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:fb:5f:e8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '113',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '4491878836511',
                                                                       'in_ucast_pkts': '3639225516',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '4491878836511',
                                                                                                'in_ucast_pkts': '3639225516',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '3182',
                                                                                                'out_octets': '395937446924',
                                                                                                'out_ucast_pkts': '1243883584',
                                                                                                'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:3',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3182',
                                                                       'out_octets': '395937446924',
                                                                       'out_ucast_pkts': '1243883584',
                                                                       'poller_hash': 'NzA6YjY6NGY6ZmQ6MzY6YzhpbnRm',
                                                                       'pons': [       {       'description': '0/2:3',
                                                                                               'id': '113',
                                                                                               'links': [       {       'fiber_length': 5362,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -15.8,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.3}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:3',
                                                                                               'poller_hash': 'NzA6YjY6NGY6ZmQ6MzY6YzhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '70:b6:4f:fd:36:c9'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3182',
                                                                       'in_octets': '395937446924',
                                                                       'in_ucast_pkts': '1243883584',
                                                                       'mac_address': '70:b6:4f:fd:36:c8',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '4491878836511',
                                                                       'out_ucast_pkts': '3639225516',
                                                                       'poller_hash': 'NzA6YjY6NGY6ZmQ6MzY6YzhldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/2:3',
                                         'poller_hash': 'NzA6YjY6NGY6ZmQ6MzY6YzhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:fd:36:c8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '114',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '7659441485159',
                                                                       'in_ucast_pkts': '6139055666',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '7659441485159',
                                                                                                'in_ucast_pkts': '6139055666',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2369',
                                                                                                'out_octets': '380300167755',
                                                                                                'out_ucast_pkts': '2086342628',
                                                                                                'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:4',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2369',
                                                                       'out_octets': '380300167755',
                                                                       'out_ucast_pkts': '2086342628',
                                                                       'poller_hash': 'NzA6YjY6NGY6ZmI6OWI6YzhpbnRm',
                                                                       'pons': [       {       'description': '0/2:4',
                                                                                               'id': '114',
                                                                                               'links': [       {       'fiber_length': 4620,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -19.3,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:4',
                                                                                               'poller_hash': 'NzA6YjY6NGY6ZmI6OWI6YzhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '70:b6:4f:fb:9b:c9'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2369',
                                                                       'in_octets': '380300167755',
                                                                       'in_ucast_pkts': '2086342628',
                                                                       'mac_address': '70:b6:4f:fb:9b:c8',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '7659441485159',
                                                                       'out_ucast_pkts': '6139055666',
                                                                       'poller_hash': 'NzA6YjY6NGY6ZmI6OWI6YzhldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/2:4',
                                         'poller_hash': 'NzA6YjY6NGY6ZmI6OWI6YzhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:fb:9b:c8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '115',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '8215308880705',
                                                                       'in_ucast_pkts': '6313977320',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '8215308880705',
                                                                                                'in_ucast_pkts': '6313977320',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '4366',
                                                                                                'out_octets': '471674578691',
                                                                                                'out_ucast_pkts': '2045802890',
                                                                                                'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTdpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:2',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4366',
                                                                       'out_octets': '471674578691',
                                                                       'out_ucast_pkts': '2045802890',
                                                                       'poller_hash': 'MWM6ZWY6MDM6NTU6ZjU6ZjBpbnRm',
                                                                       'pons': [       {       'description': '0/1:2',
                                                                                               'id': '115',
                                                                                               'links': [       {       'fiber_length': 4024,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTdpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -15.8,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:2',
                                                                                               'poller_hash': 'MWM6ZWY6MDM6NTU6ZjU6ZjBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:ef:03:55:f5:f1'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4366',
                                                                       'in_octets': '471674578691',
                                                                       'in_ucast_pkts': '2045802890',
                                                                       'mac_address': '1c:ef:03:55:f5:f0',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '8215308880705',
                                                                       'out_ucast_pkts': '6313977320',
                                                                       'poller_hash': 'MWM6ZWY6MDM6NTU6ZjU6ZjBldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/1:2',
                                         'poller_hash': 'MWM6ZWY6MDM6NTU6ZjU6ZjBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:55:f5:f0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '118',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '15835715220414',
                                                                       'in_ucast_pkts': '12685286384',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '15835715220414',
                                                                                                'in_ucast_pkts': '12685286384',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '3202',
                                                                                                'out_octets': '2132226288330',
                                                                                                'out_ucast_pkts': '4944481934',
                                                                                                'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/13:1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3202',
                                                                       'out_octets': '2132226288330',
                                                                       'out_ucast_pkts': '4944481934',
                                                                       'poller_hash': 'MWM6ZWY6MDM6NTI6Y2M6MjBpbnRm',
                                                                       'pons': [       {       'description': '0/13:1',
                                                                                               'id': '118',
                                                                                               'links': [       {       'fiber_length': 3353,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1250000000',
                                                                                                                        'rx_power': -16.3,
                                                                                                                        'tx_link_rate': '1250000000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/13:1',
                                                                                               'poller_hash': 'MWM6ZWY6MDM6NTI6Y2M6MjBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1250000000',
                                                                                               'tx_link_rate': '1250000000'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:ef:03:52:cc:21'],
                                                                       'id': 'eth0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3202',
                                                                       'in_octets': '2132226288330',
                                                                       'in_ucast_pkts': '4944481934',
                                                                       'mac_address': '1c:ef:03:52:cc:20',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '15835715220414',
                                                                       'out_ucast_pkts': '12685286384',
                                                                       'poller_hash': 'MWM6ZWY6MDM6NTI6Y2M6MjBldGgw',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/13:1',
                                         'poller_hash': 'MWM6ZWY6MDM6NTI6Y2M6MjBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:52:cc:20'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '119',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '3478250167964',
                                                                       'in_ucast_pkts': '2815034972',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '3478250167964',
                                                                                                'in_ucast_pkts': '2815034972',
                                                                                                'in_unknown_protos': '0',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '1663',
                                                                                                'out_octets': '400520226391',
                                                                                                'out_ucast_pkts': '1255398658',
                                                                                                'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRm'}],
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/13:2',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': 