import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestCalixModels(DeviceTestCase):

    def test_calix_exa_E7_2_EXA_3_3_21_2_01(self):
        obj = self.run_data("calix.exa.E7-2 (EXA).3.3.21.2.01")
        exp_info = {
                'model': 'E7-2 (EXA)',
                'sta_count': 52,
                'sw_version': '3.3.21.2',
                'vendor': 'Calix'
        }
        exp_stats = {
         'serial_number': '71704975659', 'system_mac_address': None
        }
        exp_sta_stats = {
                '44:65:7f:7b:94:5e': {       'dev_macs': ['58:6d:8f:8a:8d:a7'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:94:5e',
                                             'name': '335 Hall Drive',
                                             'serial_number': '5A3756',
                                             'system_mac_address': None},
                '44:65:7f:bb:3d:88': {       'dev_macs': ['98:18:88:cd:a1:14'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:3d:88',
                                             'name': '8720 Castle Creek Road',
                                             'serial_number': '65F572',
                                             'system_mac_address': None},
                '44:65:7f:bb:49:9a': {       'dev_macs': ['e0:cb:bc:19:d8:a0'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:49:9a',
                                             'name': '562 Midnight Mine Road',
                                             'serial_number': '65F978',
                                             'system_mac_address': None},
                '44:65:7f:bb:49:a0': {       'dev_macs': ['2c:b8:ed:41:e9:c9'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:49:a0',
                                             'name': '243 Conundrum Creek Road',
                                             'serial_number': '65F97A',
                                             'system_mac_address': None},
                '44:65:7f:bb:49:e2': {       'dev_macs': ['f8:9e:28:7e:ad:76'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:49:e2',
                                             'name': '507 Mariposa Rd',
                                             'serial_number': '65F990',
                                             'system_mac_address': None},
                '44:65:7f:bb:4a:00': {       'dev_macs': ['48:f8:b3:b6:7b:ed'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4a:00',
                                             'name': '2400 Castle Creek Road',
                                             'serial_number': '65F99A',
                                             'system_mac_address': None},
                '44:65:7f:bb:4a:06': {       'dev_macs': ['90:a7:c1:97:7f:4a'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4a:06',
                                             'name': '33 Fall Creek RD',
                                             'serial_number': '65F99C',
                                             'system_mac_address': None},
                '44:65:7f:bb:4a:2a': {       'dev_macs': ['d4:6a:91:b0:57:49'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4a:2a',
                                             'name': '245 Conundrum Creek Road',
                                             'serial_number': '65F9A8',
                                             'system_mac_address': None},
                '44:65:7f:bb:4a:48': {       'dev_macs': ['00:30:44:2f:63:24'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4a:48',
                                             'name': '201 Mariposa',
                                             'serial_number': '65F9B2',
                                             'system_mac_address': None},
                '44:65:7f:bb:4a:66': {       'dev_macs': ['24:f5:a2:0b:17:d4'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4a:66',
                                             'name': '365 Hall Dr',
                                             'serial_number': '65F9BC',
                                             'system_mac_address': None},
                '44:65:7f:bb:4a:78': {       'dev_macs': ['d4:6a:91:b0:6f:61'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4a:78',
                                             'name': '633 N Hayden Rd',
                                             'serial_number': '65F9C2',
                                             'system_mac_address': None},
                '44:65:7f:bb:4a:93': {       'dev_macs': ['14:9f:43:19:ec:4d'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4a:93',
                                             'name': '8475 Castle Creek Rd',
                                             'serial_number': '65F9CB',
                                             'system_mac_address': None},
                '44:65:7f:bb:4a:a5': {       'dev_macs': ['18:90:88:41:91:60'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4a:a5',
                                             'name': '11 Fall Creek Road',
                                             'serial_number': '65F9D1',
                                             'system_mac_address': None},
                '44:65:7f:bb:4a:c3': {       'dev_macs': ['0c:80:63:a0:0b:9d'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4a:c3',
                                             'name': '4929 Castle Creek Road',
                                             'serial_number': '65F9DB',
                                             'system_mac_address': None},
                '44:65:7f:bb:4b:17': {       'dev_macs': ['d4:6a:91:77:55:27'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4b:17',
                                             'name': '226 Conundrum Creek Road',
                                             'serial_number': '65F9F7',
                                             'system_mac_address': None},
                '48:77:46:1d:47:b7': {       'dev_macs': ['00:1b:17:00:21:17'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:1d:47:b7',
                                             'name': '565 Midnight Mine Rd.',
                                             'serial_number': '6FDE00',
                                             'system_mac_address': None},
                '48:77:46:81:3c:71': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:81:3c:71',
                                             'name': '289 Conundrum Creek Road',
                                             'serial_number': '754A13',
                                             'system_mac_address': None},
                '48:77:46:96:32:42': {       'dev_macs': ['2c:b8:ed:70:f7:e9'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:32:42',
                                             'name': '250 North Hayden Road',
                                             'serial_number': '7705F3',
                                             'system_mac_address': None},
                '48:77:46:96:36:c5': {       'dev_macs': ['98:ed:7e:0f:db:81'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:36:c5',
                                             'name': '800 South Hayden Road',
                                             'serial_number': '770774',
                                             'system_mac_address': None},
                '48:77:46:96:37:70': {       'dev_macs': ['d4:6a:91:b0:ce:45'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:37:70',
                                             'name': '201 Conundrum Creek Road',
                                             'serial_number': '7707AD',
                                             'system_mac_address': None},
                '48:77:46:96:37:8e': {       'dev_macs': ['f8:bc:0e:3d:e5:01'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:37:8e',
                                             'name': '251 Conundrum Creek Road',
                                             'serial_number': '7707B7',
                                             'system_mac_address': None},
                '48:77:46:96:38:b1': {       'dev_macs': ['d4:6a:91:b8:50:d5'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:38:b1',
                                             'name': '828 Conundrum Creek Road',
                                             'serial_number': '770818',
                                             'system_mac_address': None},
                '48:77:46:96:39:50': {       'dev_macs': ['84:d3:43:59:3f:75'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:39:50',
                                             'name': '46 Lower Hurricane Road',
                                             'serial_number': '77084D',
                                             'system_mac_address': None},
                '60:db:98:1d:2f:4b': {       'dev_macs': ['d0:76:8f:e6:14:21'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:1d:2f:4b',
                                             'name': '724 N Hayden',
                                             'serial_number': 'A196FE',
                                             'system_mac_address': None},
                '60:db:98:1d:68:42': {       'dev_macs': ['08:30:6b:37:63:31'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:1d:68:42',
                                             'name': '10080 Castle Creek Road',
                                             'serial_number': 'A1AA13',
                                             'system_mac_address': None},
                '60:db:98:1d:7b:86': {       'dev_macs': ['e0:cb:bc:9d:72:91'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:1d:7b:86',
                                             'name': '302 Midnight Mine',
                                             'serial_number': 'A1B07F',
                                             'system_mac_address': None},
                '60:db:98:1d:7b:ec': {       'dev_macs': ['90:a7:c1:ca:0a:0b'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:1d:7b:ec',
                                             'name': '4360 Castle Creek Road',
                                             'serial_number': 'A1B0A1',
                                             'system_mac_address': None},
                '60:db:98:83:b4:db': {       'dev_macs': ['18:c2:41:11:1a:41'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:83:b4:db',
                                             'name': '3224 Castle Creek Road',
                                             'serial_number': 'B2E917',
                                             'system_mac_address': None},
                '60:db:98:88:4b:c9': {       'dev_macs': ['d4:3f:32:7b:d0:81'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:88:4b:c9',
                                             'name': '9676 Castle Creek Rd.',
                                             'serial_number': 'B3AF53',
                                             'system_mac_address': None},
                '84:d3:43:4f:87:42': {       'dev_macs': ['e4:38:83:53:d5:a4'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:4f:87:42',
                                             'name': '5387 Castle Creek Road',
                                             'serial_number': 'C1B7A1',
                                             'system_mac_address': None},
                '84:d3:43:4f:8b:9b': {       'dev_macs': ['e4:38:83:1d:53:01'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:4f:8b:9b',
                                             'name': '255 Conundrum Creek Rd.',
                                             'serial_number': 'C1B914',
                                             'system_mac_address': None},
                '84:d3:43:9f:33:5a': {       'dev_macs': ['ac:8b:a9:11:24:15'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:9f:33:5a',
                                             'name': '360 South Hayden Road',
                                             'serial_number': 'D9C506',
                                             'system_mac_address': None},
                '84:d3:43:9f:33:f0': {       'dev_macs': ['d4:6a:91:b0:9d:cd'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:9f:33:f0',
                                             'name': '1030 North Hayden Road',
                                             'serial_number': 'D9C538',
                                             'system_mac_address': None},
                '84:d3:43:9f:34:6b': {       'dev_macs': ['18:b1:69:bf:8c:2d'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:9f:34:6b',
                                             'name': '101 South Hayden Road',
                                             'serial_number': 'D9C561',
                                             'system_mac_address': None},
                'cc:be:59:bb:3c:ae': {       'dev_macs': ['18:b1:69:c7:49:7d'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3c:ae',
                                             'name': '490 North Hayden Road',
                                             'serial_number': '5A5771',
                                             'system_mac_address': None},
                'cc:be:59:bb:3c:b7': {       'dev_macs': ['fc:ec:da:d3:eb:2b'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3c:b7',
                                             'name': '500 South Hayden Road',
                                             'serial_number': '5A5774',
                                             'system_mac_address': None},
                'cc:be:59:bb:3c:cc': {       'dev_macs': ['f8:9e:28:7f:31:3d'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3c:cc',
                                             'name': '200 Midnight Mine Rd',
                                             'serial_number': '5A577B',
                                             'system_mac_address': None},
                'cc:be:59:bb:3c:d5': {       'dev_macs': ['90:a7:c1:dd:52:6e'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3c:d5',
                                             'name': '195 North Hayden Road',
                                             'serial_number': '5A577E',
                                             'system_mac_address': None},
                'cc:be:59:bb:3c:d8': {       'dev_macs': ['d4:6a:91:b0:80:21'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3c:d8',
                                             'name': '931 North Hayden Road',
                                             'serial_number': '5A577F',
                                             'system_mac_address': None},
                'cc:be:59:bb:3c:f0': {       'dev_macs': ['f8:9e:28:84:01:e5'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3c:f0',
                                             'name': '1900 Castle Creek',
                                             'serial_number': '5A5787',
                                             'system_mac_address': None},
                'cc:be:59:bb:3c:fc': {       'dev_macs': ['f8:bc:0e:62:8c:e0'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3c:fc',
                                             'name': '303 Mariposa',
                                             'serial_number': '5A578B',
                                             'system_mac_address': None},
                'cc:be:59:bb:3d:38': {       'dev_macs': ['d4:6a:91:ba:9b:0d'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3d:38',
                                             'name': '55-Hall-Dr',
                                             'serial_number': '5A579F',
                                             'system_mac_address': None},
                'cc:be:59:bb:3d:44': {       'dev_macs': [       '00:18:0a:85:5b:76',
                                                                 '18:b1:69:d8:18:44'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3d:44',
                                             'name': '225 Music School Road',
                                             'serial_number': '5A57A3',
                                             'system_mac_address': None},
                'cc:be:59:bb:3d:e0': {       'dev_macs': [       '20:b5:c6:1a:4d:a9',
                                                                 'ac:17:c8:d0:52:ba',
                                                                 'ec:13:b2:92:c7:e8'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3d:e0',
                                             'name': '188 Loges Spring Road',
                                             'serial_number': '5A57D7',
                                             'system_mac_address': None},
                'd0:76:8f:20:e1:df': {       'dev_macs': ['a4:13:4e:b2:d7:89'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:20:e1:df',
                                             'name': '918 Castle Creek Road',
                                             'serial_number': '87E4F6',
                                             'system_mac_address': None},
                'd0:76:8f:20:eb:ba': {       'dev_macs': ['e0:cb:bc:23:e6:80'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:20:eb:ba',
                                             'name': '9555 Castle Creek Road',
                                             'serial_number': '87E83F',
                                             'system_mac_address': None},
                'd0:76:8f:20:ed:3d': {       'dev_macs': ['d0:76:8f:47:4c:84'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:20:ed:3d',
                                             'name': '9669 Castle Creek Rd',
                                             'serial_number': '87E8C0',
                                             'system_mac_address': None},
                'd0:76:8f:20:ed:43': {       'dev_macs': ['44:65:7f:5d:b8:7d'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:20:ed:43',
                                             'name': '247 Conundrum Creek Road',
                                             'serial_number': '87E8C2',
                                             'system_mac_address': None},
                'd0:76:8f:20:ed:8b': {       'dev_macs': ['2c:3f:0b:cc:47:d5'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:20:ed:8b',
                                             'name': '6770 Castle Creek Rd',
                                             'serial_number': '87E8DA',
                                             'system_mac_address': None},
                'd0:76:8f:20:ed:9d': {       'dev_macs': ['d0:76:8f:43:cb:26'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:20:ed:9d',
                                             'name': '5190 Castle Creek Road',
                                             'serial_number': '87E8E0',
                                             'system_mac_address': None},
                'd0:76:8f:20:ed:e8': {       'dev_macs': ['60:db:98:2e:23:92'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:20:ed:e8',
                                             'name': '249 Conundrum Creed Road',
                                             'serial_number': '87E8F9',
                                             'system_mac_address': None},
                'd0:76:8f:20:ed:f1': {       'dev_macs': ['f0:1d:2d:28:03:1a'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:20:ed:f1',
                                             'name': '786 Midnight Mine Road',
                                             'serial_number': '87E8FC',
                                             'system_mac_address': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': 'front',
                                                              'name': 'Craft-FE: front',
                                                              'oper_up': True,
                                                              'poller_hash': 'NzE3MDQ5NzU2NTlmcm9udA=='},
                                                      {       'admin_up': True,
                                                              'id': 'rear',
                                                              'mac_address': 'cc:be:59:dd:49:34',
                                                              'name': 'Craft-FE: rear',
                                                              'oper_up': True,
                                                              'poller_hash': 'NzE3MDQ5NzU2NTlyZWFy'}],
                                'manufacturer': 'Calix',
                                'model': 'E7-2 (EXA)',
                                'modules': [       {       'id': '1',
                                                           'interfaces': [       {       'admin_up': False,
                                                                                         'id': '1/x1',
                                                                                         'mac_address': 'cc:be:59:dd:49:41',
                                                                                         'name': 'ethernet '
                                                                                                 '1/x1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS94MQ=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/x2',
                                                                                         'mac_address': 'cc:be:59:dd:49:42',
                                                                                         'name': 'backplane-link '
                                                                                                 '1/x2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwYmFja3BsYW5lLWxpbmsgMS94Mg=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/x3',
                                                                                         'in_discards': '321331857',
                                                                                         'in_errors': '1',
                                                                                         'in_nucast_pkts': '926804611',
                                                                                         'in_octets': '1137375406058983',
                                                                                         'in_ucast_pkts': '994035325684',
                                                                                         'mac_address': 'cc:be:59:dd:49:43',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01510',
                                                                                         'name': 'ethernet '
                                                                                                 '1/x3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '28731941',
                                                                                         'out_octets': '255516862471612',
                                                                                         'out_ucast_pkts': '552823821192',
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS94Mw==',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/x4',
                                                                                         'mac_address': 'cc:be:59:dd:49:44',
                                                                                         'name': 'ethernet '
                                                                                                 '1/x4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS94NA=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g1',
                                                                                         'mac_address': 'cc:be:59:dd:49:35',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS9nMQ=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g2',
                                                                                         'mac_address': 'cc:be:59:dd:49:36',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS9nMg=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g3',
                                                                                         'mac_address': 'cc:be:59:dd:49:37',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS9nMw=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g4',
                                                                                         'mac_address': 'cc:be:59:dd:49:38',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS9nNA=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g5',
                                                                                         'mac_address': 'cc:be:59:dd:49:39',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS9nNQ=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g6',
                                                                                         'mac_address': 'cc:be:59:dd:49:3a',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS9nNg=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g7',
                                                                                         'mac_address': 'cc:be:59:dd:49:3b',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS9nNw=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g8',
                                                                                         'mac_address': 'cc:be:59:dd:49:3c',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS9nOA=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/1',
                                                                                         'in_discards': '2949527',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2815056',
                                                                                         'in_octets': '84842217419112',
                                                                                         'in_ucast_pkts': '208406382331',
                                                                                         'links': [       {       'in_nucast_pkts': '176063',
                                                                                                                  'in_octets': '40067089099',
                                                                                                                  'in_ucast_pkts': '96792701',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2734383',
                                                                                                                  'out_octets': '290258977559',
                                                                                                                  'out_ucast_pkts': '234081149',
                                                                                                                  'poller_hash': 'NUE1NzhCcGVlcmludGZwb24gMQ=='},
                                                                                                          {       'in_nucast_pkts': '1234',
                                                                                                                  'in_octets': '186240624026',
                                                                                                                  'in_ucast_pkts': '307827127',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2734372',
                                                                                                                  'out_octets': '704982126702',
                                                                                                                  'out_ucast_pkts': '599154359',
                                                                                                                  'poller_hash': 'NUE1NzlGcGVlcmludGZwb24gNA=='},
                                                                                                          {       'in_nucast_pkts': '10032',
                                                                                                                  'in_octets': '2852619297284',
                                                                                                                  'in_ucast_pkts': '8428494942',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '25413054',
                                                                                                                  'out_octets': '14405879247210',
                                                                                                                  'out_ucast_pkts': '15377582243',
                                                                                                                  'poller_hash': 'NUE1NzcxcGVlcmludGZwb24gMTA='},
                                                                                                          {       'in_nucast_pkts': '30',
                                                                                                                  'in_octets': '88922456999',
                                                                                                                  'in_ucast_pkts': '204225416',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7120187',
                                                                                                                  'out_octets': '356413659481',
                                                                                                                  'out_ucast_pkts': '337909250',
                                                                                                                  'poller_hash': 'NUE1Nzc0cGVlcmludGZwb24gMTM='},
                                                                                                          {       'in_nucast_pkts': '24469',
                                                                                                                  'in_octets': '562585928224',
                                                                                                                  'in_ucast_pkts': '2571947579',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5144218',
                                                                                                                  'out_octets': '11283419248947',
                                                                                                                  'out_ucast_pkts': '8059338835',
                                                                                                                  'poller_hash': 'NjVGOTdBcGVlcmludGZwb24gMjM='},
                                                                                                          {       'in_nucast_pkts': '208',
                                                                                                                  'in_octets': '36272719293',
                                                                                                                  'in_ucast_pkts': '91533264',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '930338',
                                                                                                                  'out_octets': '176189583814',
                                                                                                                  'out_ucast_pkts': '149639608',
                                                                                                                  'poller_hash': 'NjVGOUE4cGVlcmludGZwb24gMjY='},
                                                                                                          {       'in_nucast_pkts': '27911',
                                                                                                                  'in_octets': '294828226782',
                                                                                                                  'in_ucast_pkts': '705821653',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7120145',
                                                                                                                  'out_octets': '1589882880928',
                                                                                                                  'out_ucast_pkts': '1308545161',
                                                                                                                  'poller_hash': 'NjVGOTlDcGVlcmludGZwb24gMjk='},
                                                                                                          {       'in_nucast_pkts': '3010234',
                                                                                                                  'in_octets': '217720770624',
                                                                                                                  'in_ucast_pkts': '397584691',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2734539',
                                                                                                                  'out_octets': '1108794159980',
                                                                                                                  'out_ucast_pkts': '934621662',
                                                                                                                  'poller_hash': 'NzcwNUYzcGVlcmludGZwb24gMzM='},
                                                                                                          {       'in_nucast_pkts': '108727',
                                                                                                                  'in_octets': '45496889486',
                                                                                                                  'in_ucast_pkts': '116318682',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1348430',
                                                                                                                  'out_octets': '415663794894',
                                                                                                                  'out_ucast_pkts': '322015966',
                                                                                                                  'poller_hash': 'NzcwNzc0cGVlcmludGZwb24gMzQ='},
                                                                                                          {       'in_nucast_pkts': '171394',
                                                                                                                  'in_octets': '654679710660',
                                                                                                                  'in_ucast_pkts': '2750126701',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9779525',
                                                                                                                  'out_octets': '9037610709124',
                                                                                                                  'out_ucast_pkts': '6466286550',
                                                                                                                  'poller_hash': 'NzcwODREcGVlcmludGZwb24gMzU='},
                                                                                                          {       'in_nucast_pkts': '17498036',
                                                                                                                  'in_octets': '352385315511',
                                                                                                                  'in_ucast_pkts': '851085530',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7120345',
                                                                                                                  'out_octets': '997458059485',
                                                                                                                  'out_ucast_pkts': '1127824748',
                                                                                                                  'poller_hash': 'RDlDNTA2cGVlcmludGZwb24gMzY='},
                                                                                                          {       'in_nucast_pkts': '1156',
                                                                                                                  'in_octets': '39568907075',
                                                                                                                  'in_ucast_pkts': '54240597',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2734478',
                                                                                                                  'out_octets': '22418154661',
                                                                                                                  'out_ucast_pkts': '45704735',
                                                                                                                  'poller_hash': 'NzcwN0FEcGVlcmludGZwb24gMzc='},
                                                                                                          {       'in_nucast_pkts': '10',
                                                                                                                  'in_octets': '61454528867',
                                                                                                                  'in_ucast_pkts': '158311674',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2734382',
                                                                                                                  'out_octets': '312103541153',
                                                                                                                  'out_ucast_pkts': '276749832',
                                                                                                                  'poller_hash': 'ODdFOEMycGVlcmludGZwb24gNDI='},
                                                                                                          {       'in_nucast_pkts': '48535',
                                                                                                                  'in_octets': '814229307310',
                                                                                                                  'in_ucast_pkts': '840518346',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2734312',
                                                                                                                  'out_octets': '575757668258',
                                                                                                                  'out_ucast_pkts': '834901598',
                                                                                                                  'poller_hash': 'ODdFOEMwcGVlcmludGZwb24gNDQ='},
                                                                                                          {       'in_nucast_pkts': '44047',
                                                                                                                  'in_octets': '103472552064',
                                                                                                                  'in_ucast_pkts': '188354799',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2734382',
                                                                                                                  'out_octets': '387716168648',
                                                                                                                  'out_ucast_pkts': '333342217',
                                                                                                                  'poller_hash': 'ODdFOEZDcGVlcmludGZwb24gNDU='},
                                                                                                          {       'in_nucast_pkts': '28',
                                                                                                                  'in_octets': '16657570381',
                                                                                                                  'in_ucast_pkts': '24205522',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '536216',
                                                                                                                  'out_octets': '38092635283',
                                                                                                                  'out_ucast_pkts': '38479116',
                                                                                                                  'poller_hash': 'ODdFNEY2cGVlcmludGZwb24gNDY='},
                                                                                                          {       'in_nucast_pkts': '14044',
                                                                                                                  'in_octets': '91752893348',
                                                                                                                  'in_ucast_pkts': '152741186',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '805284',
                                                                                                                  'out_octets': '673963412102',
                                                                                                                  'out_ucast_pkts': '515862812',
                                                                                                                  'poller_hash': 'ODdFOEUwcGVlcmludGZwb24gNDc='},
                                                                                                          {       'in_nucast_pkts': '73',
                                                                                                                  'in_octets': '26084726657',
                                                                                                                  'in_ucast_pkts': '108987981',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2332653',
                                                                                                                  'out_octets': '566483296474',
                                                                                                                  'out_ucast_pkts': '421537522',
                                                                                                                  'poller_hash': 'QTFCMEExcGVlcmludGZwb24gNTI='},
                                                                                                          {       'in_nucast_pkts': '581',
                                                                                                                  'in_octets': '192478347818',
                                                                                                                  'in_ucast_pkts': '252204314',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2734380',
                                                                                                                  'out_octets': '534705195964',
                                                                                                                  'out_ucast_pkts': '451004343',
                                                                                                                  'poller_hash': 'RDlDNTM4cGVlcmludGZwb24gNTg='},
                                                                                                          {       'in_nucast_pkts': '5723',
                                                                                                                  'in_octets': '759715561723',
                                                                                                                  'in_ucast_pkts': '1334369941',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10522629',
                                                                                                                  'out_octets': '2376277071923',
                                                                                                                  'out_ucast_pkts': '2232565667',
                                                                                                                  'poller_hash': 'QjJFOTE3cGVlcmludGZwb24gNTk='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': 'gpon '
                                                                                                 '1/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '27321422',
                                                                                         'out_octets': '436263420765219',
                                                                                         'out_ucast_pkts': '380586276206',
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/1',
                                                                                                                 'id': '1/1',
                                                                                                                 'links': [       {       'connected_time': '5284846',
                                                                                                                                          'fiber_length': 2706,
                                                                                                                                          'poller_hash': 'NUE1NzhCcGVlcnBvbnBvbiAx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546},
                                                                                                                                  {       'connected_time': '5284867',
                                                                                                                                          'fiber_length': 2338,
                                                                                                                                          'poller_hash': 'NUE1NzlGcGVlcnBvbnBvbiA0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -11.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546},
                                                                                                                                  {       'connected_time': '5000829',
                                                                                                                                          'fiber_length': 4390,
                                                                                                                                          'poller_hash': 'NUE1NzcxcGVlcnBvbnBvbiAxMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546},
                                                                                                                                  {       'connected_time': '13646275',
                                                                                                                                          'fiber_length': 6112,
                                                                                                                                          'poller_hash': 'NUE1Nzc0cGVlcnBvbnBvbiAxMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546},
                                                                                                                                  {       'connected_time': '9912502',
                                                                                                                                          'fiber_length': 9226,
                                                                                                                                          'poller_hash': 'NjVGOTdBcGVlcnBvbnBvbiAyMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546},
                                                                                                                                  {       'connected_time': '1799597',
                                                                                                                                          'fiber_length': 9436,
                                                                                                                                          'poller_hash': 'NjVGOUE4cGVlcnBvbnBvbiAyNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546},
                                                                                                                                  {       'connected_time': '13646296',
                                                                                                                                          'fiber_length': 16098,
                                                                                                                                          'poller_hash': 'NjVGOTlDcGVlcnBvbnBvbiAyOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546},
                                                                                                                                  {       'connected_time': '5284937',
                                                                                                                                          'fiber_length': 4245,
                                                                                                                                          'poller_hash': 'NzcwNUYzcGVlcnBvbnBvbiAzMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546},
                                                                                                                                  {       'connected_time': '2608712',
                                                                                                                                          'fiber_length': 6766,
                                                                                                                                          'poller_hash': 'NzcwNzc0cGVlcnBvbnBvbiAzNA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546},
                                                                                                                                  {       'connected_time': '18328994',
                                                                                                                                          'fiber_length': 12247,
                                                                                                                                          'poller_hash': 'NzcwODREcGVlcnBvbnBvbiAzNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546},
                                                                                                                                  {       'connected_time': '13646463',
                                                                                                                                          'fiber_length': 5867,
                                                                                                                                          'poller_hash': 'RDlDNTA2cGVlcnBvbnBvbiAzNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546},
                                                                                                                                  {       'connected_time': '5284909',
                                                                                                                                          'fiber_length': 9557,
                                                                                                                                          'poller_hash': 'NzcwN0FEcGVlcnBvbnBvbiAzNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546},
                                                                                                                                  {       'connected_time': '5284951',
                                                                                                                                          'fiber_length': 9326,
                                                                                                                                          'poller_hash': 'ODdFOEMycGVlcnBvbnBvbiA0Mg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546},
                                                                                                                                  {       'connected_time': '5284947',
                                                                                                                                          'fiber_length': 16415,
                                                                                                                                          'poller_hash': 'ODdFOEMwcGVlcnBvbnBvbiA0NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546},
                                                                                                                                  {       'connected_time': '5284972',
                                                                                                                                          'fiber_length': 5675,
                                                                                                                                          'poller_hash': 'ODdFOEZDcGVlcnBvbnBvbiA0NQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546},
                                                                                                                                  {       'connected_time': '1037046',
                                                                                                                                          'fiber_length': 1210,
                                                                                                                                          'poller_hash': 'ODdFNEY2cGVlcnBvbnBvbiA0Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546},
                                                                                                                                  {       'connected_time': '1557644',
                                                                                                                                          'fiber_length': 8767,
                                                                                                                                          'poller_hash': 'ODdFOEUwcGVlcnBvbnBvbiA0Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546},
                                                                                                                                  {       'connected_time': '4508235',
                                                                                                                                          'fiber_length': 8865,
                                                                                                                                          'poller_hash': 'QTFCMEExcGVlcnBvbnBvbiA1Mg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546},
                                                                                                                                  {       'connected_time': '5284918',
                                                                                                                                          'fiber_length': 5495,
                                                                                                                                          'poller_hash': 'RDlDNTM4cGVlcnBvbnBvbiA1OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546},
                                                                                                                                  {       'connected_time': '19844944',
                                                                                                                                          'fiber_length': 4930,
                                                                                                                                          'poller_hash': 'QjJFOTE3cGVlcnBvbnBvbiA1OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.546}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/1',
                                                                                                                 'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/2',
                                                                                         'in_discards': '11255100',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '10363069',
                                                                                         'in_octets': '82190148851380',
                                                                                         'in_ucast_pkts': '172629074319',
                                                                                         'links': [       {       'in_nucast_pkts': '31',
                                                                                                                  'in_octets': '223818990',
                                                                                                                  'in_ucast_pkts': '542279',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10350',
                                                                                                                  'out_octets': '1597683410',
                                                                                                                  'out_ucast_pkts': '1400738',
                                                                                                                  'poller_hash': 'NUE1NzdFcGVlcmludGZwb24gNQ=='},
                                                                                                          {       'in_nucast_pkts': '11165',
                                                                                                                  'in_octets': '3600718473251',
                                                                                                                  'in_ucast_pkts': '6886205199',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '23721172',
                                                                                                                  'out_octets': '14248392652958',
                                                                                                                  'out_ucast_pkts': '12267178778',
                                                                                                                  'poller_hash': 'NUE1NzdGcGVlcmludGZwb24gOA=='},
                                                                                                          {       'in_nucast_pkts': '312894',
                                                                                                                  'in_octets': '288135280445',
                                                                                                                  'in_ucast_pkts': '376491678',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2544635',
                                                                                                                  'out_octets': '356480418128',
                                                                                                                  'out_ucast_pkts': '423663140',
                                                                                                                  'poller_hash': 'NUE1NzdCcGVlcmludGZwb24gOQ=='},
                                                                                                          {       'in_nucast_pkts': '5348566',
                                                                                                                  'in_octets': '360362579786',
                                                                                                                  'in_ucast_pkts': '1805680881',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '15745197',
                                                                                                                  'out_octets': '3525691748503',
                                                                                                                  'out_ucast_pkts': '3049521108',
                                                                                                                  'poller_hash': 'NUE1N0Q3cGVlcmludGZwb24gMTE='},
                                                                                                          {       'in_nucast_pkts': '210294',
                                                                                                                  'in_octets': '793657526076',
                                                                                                                  'in_ucast_pkts': '2911087860',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10611216',
                                                                                                                  'out_octets': '6154763088346',
                                                                                                                  'out_ucast_pkts': '4856100063',
                                                                                                                  'poller_hash': 'NUEzNzU2cGVlcmludGZwb24gMTI='},
                                                                                                          {       'in_nucast_pkts': '140817',
                                                                                                                  'in_octets': '43526612318',
                                                                                                                  'in_ucast_pkts': '105243538',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2734360',
                                                                                                                  'out_octets': '224135890121',
                                                                                                                  'out_ucast_pkts': '190802357',
                                                                                                                  'poller_hash': 'NjVGOTlBcGVlcmludGZwb24gMTU='},
                                                                                                          {       'in_nucast_pkts': '18274',
                                                                                                                  'in_octets': '144619437466',
                                                                                                                  'in_ucast_pkts': '466542387',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2734353',
                                                                                                                  'out_octets': '1190440074064',
                                                                                                                  'out_ucast_pkts': '957047302',
                                                                                                                  'poller_hash': 'NjVGOUJDcGVlcmludGZwb24gMTc='},
                                                                                                          {       'in_nucast_pkts': '2828',
                                                                                                                  'in_octets': '53927652105',
                                                                                                                  'in_ucast_pkts': '277155870',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6658640',
                                                                                                                  'out_octets': '679750927990',
                                                                                                                  'out_ucast_pkts': '521435249',
                                                                                                                  'poller_hash': 'NjVGOUMycGVlcmludGZwb24gMTg='},
                                                                                                          {       'in_nucast_pkts': '505295',
                                                                                                                  'in_octets': '141101115558',
                                                                                                                  'in_ucast_pkts': '735244312',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4139413',
                                                                                                                  'out_octets': '1706920341165',
                                                                                                                  'out_ucast_pkts': '1495644335',
                                                                                                                  'poller_hash': 'NjVGOUNCcGVlcmludGZwb24gMjA='},
                                                                                                          {       'in_nucast_pkts': '5510727',
                                                                                                                  'in_octets': '57048431516',
                                                                                                                  'in_ucast_pkts': '200881698',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2734198',
                                                                                                                  'out_octets': '423086148492',
                                                                                                                  'out_ucast_pkts': '336982933',
                                                                                                                  'poller_hash': 'NjVGOURCcGVlcmludGZwb24gMjE='},
                                                                                                          {       'in_nucast_pkts': '196879',
                                                                                                                  'in_octets': '170279679756',
                                                                                                                  'in_ucast_pkts': '321039254',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7119924',
                                                                                                                  'out_octets': '474004095447',
                                                                                                                  'out_ucast_pkts': '483951712',
                                                                                                                  'poller_hash': 'NjVGOUY3cGVlcmludGZwb24gMjI='},
                                                                                                          {       'in_nucast_pkts': '8',
                                                                                                                  'in_octets': '12672773644',
                                                                                                                  'in_ucast_pkts': '34114509',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2734366',
                                                                                                                  'out_octets': '87930246826',
                                                                                                                  'out_ucast_pkts': '74620220',
                                                                                                                  'poller_hash': 'NjVGOUIycGVlcmludGZwb24gMjQ='},
                                                                                                          {       'in_nucast_pkts': '1304323',
                                                                                                                  'in_octets': '233073283825',
                                                                                                                  'in_ucast_pkts': '1161931645',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10563251',
                                                                                                                  'out_octets': '1347639752577',
                                                                                                                  'out_ucast_pkts': '1669345201',
                                                                                                                  'poller_hash': 'NjVGOTkwcGVlcmludGZwb24gMjc='},
                                                                                                          {       'in_nucast_pkts': '176103',
                                                                                                                  'in_octets': '150738037472',
                                                                                                                  'in_ucast_pkts': '197583812',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2734380',
                                                                                                                  'out_octets': '265574845004',
                                                                                                                  'out_ucast_pkts': '256657048',
                                                                                                                  'poller_hash': 'NjVGOUQxcGVlcmludGZwb24gMjg='},
                                                                                                          {       'in_nucast_pkts': '1531045',
                                                                                                                  'in_octets': '2827788469933',
                                                                                                                  'in_ucast_pkts': '3471705499',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '12454397',
                                                                                                                  'out_octets': '1956529249253',
                                                                                                                  'out_ucast_pkts': '2428541483',
                                                                                                                  'poller_hash': 'NjVGNTcycGVlcmludGZwb24gMzA='},
                                                                                                          {       'in_nucast_pkts': '220123',
                                                                                                                  'in_octets': '57681515449',
                                                                                                                  'in_ucast_pkts': '108831123',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2734414',
                                                                                                                  'out_octets': '55669231773',
                                                                                                                  'out_ucast_pkts': '104606883',
                                                                                                                  'poller_hash': 'NzcwN0I3cGVlcmludGZwb24gMzk='},
                                                                                                          {       'in_nucast_pkts': '105015',
                                                                                                                  'in_octets': '491633924991',
                                                                                                                  'in_ucast_pkts': '775972033',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2737222',
                                                                                                                  'out_octets': '1334353739000',
                                                                                                                  'out_ucast_pkts': '1174321046',
                                                                                                                  'poller_hash': 'NzcwODE4cGVlcmludGZwb24gNDA='},
                                                                                                          {       'in_nucast_pkts': '24688',
                                                                                                                  'in_octets': '87870368060',
                                                                                                                  'in_ucast_pkts': '203607225',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1526632',
                                                                                                                  'out_octets': '347028852316',
                                                                                                                  'out_ucast_pkts': '299740110',
                                                                                                                  'poller_hash': 'ODdFOEY5cGVlcmludGZwb24gNDE='},
                                                                                                          {       'in_nucast_pkts': '899388',
                                                                                                                  'in_octets': '70475402263',
                                                                                                                  'in_ucast_pkts': '389734442',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7120245',
                                                                                                                  'out_octets': '173534541847',
                                                                                                                  'out_ucast_pkts': '430935022',
                                                                                                                  'poller_hash': 'ODdFODNGcGVlcmludGZwb24gNDM='},
                                                                                                          {       'in_nucast_pkts': '222609',
                                                                                                                  'in_octets': '74226469056',
                                                                                                                  'in_ucast_pkts': '184298193',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1746792',
                                                                                                                  'out_octets': '350074673282',
                                                                                                                  'out_ucast_pkts': '348447929',
                                                                                                                  'poller_hash': 'ODdFOERBcGVlcmludGZwb24gNDk='},
                                                                                                          {       'in_nucast_pkts': '139',
                                                                                                                  'in_octets': '58510544',
                                                                                                                  'in_ucast_pkts': '682642',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3593299',
                                                                                                                  'out_octets': '432283376',
                                                                                                                  'out_ucast_pkts': '694538',
                                                                                                                  'poller_hash': 'NzU0QTEzcGVlcmludGZwb24gNTA='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': 'gpon '
                                                                                                 '1/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '27321424',
                                                                                         'out_octets': '363405753602319',
                                                                                         'out_ucast_pkts': '312803919978',
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/2',
                                                                                                                 'id': '1/2',
                                                                                                                 'links': [       {       'connected_time': '19925',
                                                                                                                                          'fiber_length': 3763,
                                                                                                                                          'poller_hash': 'NUE1NzdFcGVlcnBvbnBvbiA1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '1733596',
                                                                                                                                          'fiber_length': 5170,
                                                                                                                                          'poller_hash': 'NUE1NzdGcGVlcnBvbnBvbiA4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '4917658',
                                                                                                                                          'fiber_length': 4470,
                                                                                                                                          'poller_hash': 'NUE1NzdCcGVlcnBvbnBvbiA5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '19848307',
                                                                                                                                          'fiber_length': 4593,
                                                                                                                                          'poller_hash': 'NUE1N0Q3cGVlcnBvbnBvbiAxMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '19852747',
                                                                                                                                          'fiber_length': 2600,
                                                                                                                                          'poller_hash': 'NUEzNzU2cGVlcnBvbnBvbiAxMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '5284908',
                                                                                                                                          'fiber_length': 4156,
                                                                                                                                          'poller_hash': 'NjVGOTlBcGVlcnBvbnBvbiAxNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '5284878',
                                                                                                                                          'fiber_length': 2806,
                                                                                                                                          'poller_hash': 'NjVGOUJDcGVlcnBvbnBvbiAxNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '12793691',
                                                                                                                                          'fiber_length': 4621,
                                                                                                                                          'poller_hash': 'NjVGOUMycGVlcnBvbnBvbiAxOA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '7965735',
                                                                                                                                          'fiber_length': 14844,
                                                                                                                                          'poller_hash': 'NjVGOUNCcGVlcnBvbnBvbiAyMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '5284909',
                                                                                                                                          'fiber_length': 8209,
                                                                                                                                          'poller_hash': 'NjVGOURCcGVlcnBvbnBvbiAyMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '13646353',
                                                                                                                                          'fiber_length': 9281,
                                                                                                                                          'poller_hash': 'NjVGOUY3cGVlcnBvbnBvbiAyMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '5284881',
                                                                                                                                          'fiber_length': 2896,
                                                                                                                                          'poller_hash': 'NjVGOUIycGVlcnBvbnBvbiAyNA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '19846654',
                                                                                                                                          'fiber_length': 2809,
                                                                                                                                          'poller_hash': 'NjVGOTkwcGVlcnBvbnBvbiAyNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '5284879',
                                                                                                                                          'fiber_length': 15610,
                                                                                                                                          'poller_hash': 'NjVGOUQxcGVlcnBvbnBvbiAyOA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '23303187',
                                                                                                                                          'fiber_length': 14808,
                                                                                                                                          'poller_hash': 'NjVGNTcycGVlcnBvbnBvbiAzMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '5284896',
                                                                                                                                          'fiber_length': 9623,
                                                                                                                                          'poller_hash': 'NzcwN0I3cGVlcnBvbnBvbiAzOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '5286732',
                                                                                                                                          'fiber_length': 10628,
                                                                                                                                          'poller_hash': 'NzcwODE4cGVlcnBvbnBvbiA0MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '2953310',
                                                                                                                                          'fiber_length': 9349,
                                                                                                                                          'poller_hash': 'ODdFOEY5cGVlcnBvbnBvbiA0MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '13646493',
                                                                                                                                          'fiber_length': 16245,
                                                                                                                                          'poller_hash': 'ODdFODNGcGVlcnBvbnBvbiA0Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '3378457',
                                                                                                                                          'fiber_length': 11463,
                                                                                                                                          'poller_hash': 'ODdFOERBcGVlcnBvbnBvbiA0OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '5284870',
                                                                                                                                          'fiber_length': 9650,
                                                                                                                                          'poller_hash': 'NzU0QTEzcGVlcnBvbnBvbiA1MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/2',
                                                                                                                 'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/3',
                                                                                         'in_discards': '919586',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '29703',
                                                                                         'in_octets': '88419464277855',
                                                                                         'in_ucast_pkts': '171494640559',
                                                                                         'links': [       {       'in_nucast_pkts': '5633372',
                                                                                                                  'in_octets': '1236885566319',
                                                                                                                  'in_ucast_pkts': '2378249612',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2734556',
                                                                                                                  'out_octets': '3618629467361',
                                                                                                                  'out_ucast_pkts': '3717357813',
                                                                                                                  'poller_hash': 'NUE1N0EzcGVlcmludGZwb24gNg=='},
                                                                                                          {       'in_nucast_pkts': '931133',
                                                                                                                  'in_octets': '1543596373882',
                                                                                                                  'in_ucast_pkts': '7525283451',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7533149',
                                                                                                                  'out_octets': '19302978352834',
                                                                                                                  'out_ucast_pkts': '14795144662',
                                                                                                                  'poller_hash': 'NUE1Nzg3cGVlcmludGZwb24gNw=='},
                                                                                                          {       'in_nucast_pkts': '344658',
                                                                                                                  'in_octets': '245922843950',
                                                                                                                  'in_ucast_pkts': '514691603',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2734504',
                                                                                                                  'out_octets': '776319115597',
                                                                                                                  'out_ucast_pkts': '771555784',
                                                                                                                  'poller_hash': 'NjVGOTc4cGVlcmludGZwb24gMTk='},
                                                                                                          {       'in_nucast_pkts': '1591',
                                                                                                                  'in_octets': '27290031556',
                                                                                                                  'in_ucast_pkts': '75057413',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2734398',
                                                                                                                  'out_octets': '179900676589',
                                                                                                                  'out_ucast_pkts': '167956118',
                                                                                                                  'poller_hash': 'RDlDNTYxcGVlcmludGZwb24gMjU='},
                                                                                                          {       'in_nucast_pkts': '564563',
                                                                                                                  'in_octets': '1697536847168',
                                                                                                                  'in_ucast_pkts': '2565095522',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5802484',
                                                                                                                  'out_octets': '3639967948082',
                                                                                                                  'out_ucast_pkts': '3762752195',
                                                                                                                  'poller_hash': 'NkZERTAwcGVlcmludGZwb24gMzE='},
                                                                                                          {       'in_nucast_pkts': '5985469',
                                                                                                                  'in_octets': '182036303663',
                                                                                                                  'in_ucast_pkts': '726100786',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7641516',
                                                                                                                  'out_octets': '2931585917097',
                                                                                                                  'out_ucast_pkts': '2131570502',
                                                                                                                  'poller_hash': 'QTFBQTEzcGVlcmludGZwb24gNTE='},
                                                                                                          {       'in_nucast_pkts': '2897238',
                                                                                                                  'in_octets': '157158899219',
                                                                                                                  'in_ucast_pkts': '380823862',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2734297',
                                                                                                                  'out_octets': '1110123197583',
                                                                                                                  'out_ucast_pkts': '967341478',
                                                                                                                  'poller_hash': 'QTFCMDdGcGVlcmludGZwb24gNTM='},
                                                                                                          {       'in_nucast_pkts': '79',
                                                                                                                  'in_octets': '215666796',
                                                                                                                  'in_ucast_pkts': '695167',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2257',
                                                                                                                  'out_octets': '2032819518',
                                                                                                                  'out_ucast_pkts': '1538463',
                                                                                                                  'poller_hash': 'QTE5NkZFcGVlcmludGZwb24gNTQ='},
                                                                                                          {       'in_nucast_pkts': '4458532',
                                                                                                                  'in_octets': '85471149613',
                                                                                                                  'in_ucast_pkts': '486824134',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1693362',
                                                                                                                  'out_octets': '5259131350134',
                                                                                                                  'out_ucast_pkts': '3599306268',
                                                                                                                  'poller_hash': 'QzFCN0ExcGVlcmludGZwb24gNTU='},
                                                                                                          {       'in_nucast_pkts': '6139889',
                                                                                                                  'in_octets': '66803181990',
                                                                                                                  'in_ucast_pkts': '154082391',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2331162',
                                                                                                                  'out_octets': '393623627914',
                                                                                                                  'out_ucast_pkts': '340804218',
                                                                                                                  'poller_hash': 'QzFCOTE0cGVlcmludGZwb24gNTY='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': 'gpon '
                                                                                                 '1/3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '27321424',
                                                                                         'out_octets': '337524913778887',
                                                                                         'out_ucast_pkts': '300299379792',
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/3',
                                                                                                                 'id': '1/3',
                                                                                                                 'links': [       {       'connected_time': '5284873',
                                                                                                                                          'fiber_length': 1750,
                                                                                                                                          'poller_hash': 'NUE1N0EzcGVlcnBvbnBvbiA2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.465},
                                                                                                                                  {       'connected_time': '14178240',
                                                                                                                                          'fiber_length': 2793,
                                                                                                                                          'poller_hash': 'NUE1Nzg3cGVlcnBvbnBvbiA3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.465},
                                                                                                                                  {       'connected_time': '5284885',
                                                                                                                                          'fiber_length': 5818,
                                                                                                                                          'poller_hash': 'NjVGOTc4cGVlcnBvbnBvbiAxOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.465},
                                                                                                                                  {       'connected_time': '5284905',
                                                                                                                                          'fiber_length': 5296,
                                                                                                                                          'poller_hash': 'RDlDNTYxcGVlcnBvbnBvbiAyNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.465},
                                                                                                                                  {       'connected_time': '2561311',
                                                                                                                                          'fiber_length': 5404,
                                                                                                                                          'poller_hash': 'NkZERTAwcGVlcnBvbnBvbiAzMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.465},
                                                                                                                                  {       'connected_time': '5284356',
                                                                                                                                          'fiber_length': 17008,
                                                                                                                                          'poller_hash': 'QTFBQTEzcGVlcnBvbnBvbiA1MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.465},
                                                                                                                                  {       'connected_time': '5284932',
                                                                                                                                          'fiber_length': 5116,
                                                                                                                                          'poller_hash': 'QTFCMDdGcGVlcnBvbnBvbiA1Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.465},
                                                                                                                                  {       'connected_time': '4413',
                                                                                                                                          'fiber_length': 4761,
                                                                                                                                          'poller_hash': 'QTE5NkZFcGVlcnBvbnBvbiA1NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.465},
                                                                                                                                  {       'connected_time': '3276843',
                                                                                                                                          'fiber_length': 9251,
                                                                                                                                          'poller_hash': 'QzFCN0ExcGVlcnBvbnBvbiA1NQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.465},
                                                                                                                                  {       'connected_time': '4505786',
                                                                                                                                          'fiber_length': 9858,
                                                                                                                                          'poller_hash': 'QzFCOTE0cGVlcnBvbnBvbiA1Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.465}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/3',
                                                                                                                 'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/4',
                                                                                         'in_discards': '166',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '3027',
                                                                                         'in_octets': '49867755694',
                                                                                         'in_ucast_pkts': '104177656',
                                                                                         'links': [       {       'in_nucast_pkts': '220078',
                                                                                                                  'in_octets': '46083847434',
                                                                                                                  'in_ucast_pkts': '65775745',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2734394',
                                                                                                                  'out_octets': '76741141824',
                                                                                                                  'out_ucast_pkts': '82008684',
                                                                                                                  'poller_hash': 'QjNBRjUzcGVlcmludGZwb24gNjA='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05121',
                                                                                         'name': 'gpon '
                                                                                                 '1/4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '6811430',
                                                                                         'out_octets': '107170615373',
                                                                                         'out_ucast_pkts': '132962717',
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzQ=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/4',
                                                                                                                 'id': '1/4',
                                                                                                                 'links': [       {       'connected_time': '5284910',
                                                                                                                                          'fiber_length': 16352,
                                                                                                                                          'poller_hash': 'QjNBRjUzcGVlcnBvbnBvbiA2MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.484}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/4',
                                                                                                                 'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzQ=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-03656',
                                                           'name': 'GPON-4r2',
                                                           'poller_hash': 'MjExODA2NjAwNTUw',
                                                           'serial_number': '211806600550',
                                                           'sw_version': '3.3.21.2',
                                                           'uptime': '146554060'}],
                                'serial_number': '71704975659',
                                'sw_version': '3.3.21.2',
                                'system_mac_address': 'cc:be:59:dd:49:33'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f8:bc:0e:62:8c:e0'],
                                                                       'id': '1/g1',
                                                                       'in_nucast_pkts': '176063',
                                                                       'in_octets': '40067089099',
                                                                       'in_ucast_pkts': '96792701',
                                                                       'mac_address': 'cc:be:59:bb:3c:fc',
                                                                       'mtu': 2000,
                                                                       'name': '1/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2734383',
                                                                       'out_octets': '290258977559',
                                                                       'out_ucast_pkts': '234081149',
                                                                       'poller_hash': 'NUE1NzhCcGVlcmludGYxL2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_nucast_pkts': '2734383',
                                                                       'in_octets': '290258977559',
                                                                       'in_ucast_pkts': '234081149',
                                                                       'links': [       {       'in_nucast_pkts': '2734383',
                                                                                                'in_octets': '290258977559',
                                                                                                'in_ucast_pkts': '234081149',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '176063',
                                                                                                'out_octets': '40067089099',
                                                                                                'out_ucast_pkts': '96792701',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '176063',
                                                                       'out_octets': '40067089099',
                                                                       'out_ucast_pkts': '96792701',
                                                                       'poller_hash': 'NUE1NzhCcGVlcmludGZwb24gMQ==',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '1',
                                                                                               'links': [       {       'connected_time': '5284846',
                                                                                                                        'fiber_length': 2706,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NUE1NzhCcGVlcnBvbnBvbiAx',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '303 Mariposa',
                                         'poller_hash': 'NUE1NzhC',
                                         'serial_number': '5A578B',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3c:fc',
                                         'uptime': '5284846'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd4:6a:91:ba:9b:0d'],
                                                                       'id': '4/g1',
                                                                       'in_nucast_pkts': '1234',
                                                                       'in_octets': '186240624026',
                                                                       'in_ucast_pkts': '307827127',
                                                                       'mac_address': 'cc:be:59:bb:3d:38',
                                                                       'mtu': 2000,
                                                                       'name': '4/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2734372',
                                                                       'out_octets': '704982126702',
                                                                       'out_ucast_pkts': '599154359',
                                                                       'poller_hash': 'NUE1NzlGcGVlcmludGY0L2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '4',
                                                                       'in_nucast_pkts': '2734372',
                                                                       'in_octets': '704982126702',
                                                                       'in_ucast_pkts': '599154359',
                                                                       'links': [       {       'in_nucast_pkts': '2734372',
                                                                                                'in_octets': '704982126702',
                                                                                                'in_ucast_pkts': '599154359',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '1234',
                                                                                                'out_octets': '186240624026',
                                                                                                'out_ucast_pkts': '307827127',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1234',
                                                                       'out_octets': '186240624026',
                                                                       'out_ucast_pkts': '307827127',
                                                                       'poller_hash': 'NUE1NzlGcGVlcmludGZwb24gNA==',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '4',
                                                                                               'links': [       {       'connected_time': '5284867',
                                                                                                                        'fiber_length': 2338,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NUE1NzlGcGVlcnBvbnBvbiA0',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '55-Hall-Dr',
                                         'poller_hash': 'NUE1NzlG',
                                         'serial_number': '5A579F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3d:38',
                                         'uptime': '5284867'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '90:a7:c1:dd:52:6e'],
                                                                       'id': '5/g1',
                                                                       'in_nucast_pkts': '31',
                                                                       'in_octets': '223818990',
                                                                       'in_ucast_pkts': '542279',
                                                                       'mac_address': 'cc:be:59:bb:3c:d5',
                                                                       'mtu': 2000,
                                                                       'name': '5/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '10350',
                                                                       'out_octets': '1597683410',
                                                                       'out_ucast_pkts': '1400738',
                                                                       'poller_hash': 'NUE1NzdFcGVlcmludGY1L2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '5',
                                                                       'in_nucast_pkts': '10350',
                                                                       'in_octets': '1597683410',
                                                                       'in_ucast_pkts': '1400738',
                                                                       'links': [       {       'in_nucast_pkts': '10350',
                                                                                                'in_octets': '1597683410',
                                                                                                'in_ucast_pkts': '1400738',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '31',
                                                                                                'out_octets': '223818990',
                                                                                                'out_ucast_pkts': '542279',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '31',
                                                                       'out_octets': '223818990',
                                                                       'out_ucast_pkts': '542279',
                                                                       'poller_hash': 'NUE1NzdFcGVlcmludGZwb24gNQ==',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '5',
                                                                                               'links': [       {       'connected_time': '19925',
                                                                                                                        'fiber_length': 3763,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NUE1NzdFcGVlcnBvbnBvbiA1',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '195 North Hayden Road',
                                         'poller_hash': 'NUE1NzdF',
                                         'serial_number': '5A577E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3c:d5',
                                         'uptime': '19925'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:18:0a:85:5b:76',
                                                                                                        '18:b1:69:d8:18:44'],
                                                                       'id': '6/g1',
                                                                       'in_nucast_pkts': '5633372',
                                                                       'in_octets': '1236885566319',
                                                                       'in_ucast_pkts': '2378249612',
                                                                       'mac_address': 'cc:be:59:bb:3d:44',
                                                                       'mtu': 2000,
                                                                       'name': '6/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2734556',
                                                                       'out_octets': '3618629467361',
                                                                       'out_ucast_pkts': '3717357813',
                                                                       'poller_hash': 'NUE1N0EzcGVlcmludGY2L2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '6',
                                                                       'in_nucast_pkts': '2734556',
                                                                       'in_octets': '3618629467361',
                                                                       'in_ucast_pkts': '3717357813',
                                                                       'links': [       {       'in_nucast_pkts': '2734556',
                                                                                                'in_octets': '3618629467361',
                                                                                                'in_ucast_pkts': '3717357813',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '5633372',
                                                                                                'out_octets': '1236885566319',
                                                                                                'out_ucast_pkts': '2378249612',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '5633372',
                                                                       'out_octets': '1236885566319',
                                                                       'out_ucast_pkts': '2378249612',
                                                                       'poller_hash': 'NUE1N0EzcGVlcmludGZwb24gNg==',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '6',
                                                                                               'links': [       {       'connected_time': '5284873',
                                                                                                                        'fiber_length': 1750,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NUE1N0EzcGVlcnBvbnBvbiA2',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '225 Music School Road',
                                         'poller_hash': 'NUE1N0Ez',
                                         'serial_number': '5A57A3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3d:44',
                                         'uptime': '5284873'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f8:9e:28:84:01:e5'],
                                                                       'id': '7/g1',
                                                                       'in_nucast_pkts': '931133',
                                                                       'in_octets': '1543596373882',
                                                                       'in_ucast_pkts': '7525283451',
                                                                       'mac_address': 'cc:be:59:bb:3c:f0',
                                                                       'mtu': 2000,
                                                                       'name': '7/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '7533149',
                                                                       'out_octets': '19302978352834',
                                                                       'out_ucast_pkts': '14795144662',
                                                                       'poller_hash': 'NUE1Nzg3cGVlcmludGY3L2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '7',
                                                                       'in_nucast_pkts': '7533149',
                                                                       'in_octets': '19302978352834',
                                                                       'in_ucast_pkts': '14795144662',
                                                                       'links': [       {       'in_nucast_pkts': '7533149',
                                                                                                'in_octets': '19302978352834',
                                                                                                'in_ucast_pkts': '14795144662',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '931133',
                                                                                                'out_octets': '1543596373882',
                                                                                                'out_ucast_pkts': '7525283451',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '931133',
                                                                       'out_octets': '1543596373882',
                                                                       'out_ucast_pkts': '7525283451',
                                                                       'poller_hash': 'NUE1Nzg3cGVlcmludGZwb24gNw==',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '7',
                                                                                               'links': [       {       'connected_time': '14178240',
                                                                                                                        'fiber_length': 2793,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NUE1Nzg3cGVlcnBvbnBvbiA3',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '1900 Castle Creek',
                                         'poller_hash': 'NUE1Nzg3',
                                         'serial_number': '5A5787',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3c:f0',
                                         'uptime': '14178240'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd4:6a:91:b0:80:21'],
                                                                       'id': '8/g1',
                                                                       'in_nucast_pkts': '11165',
                                                                       'in_octets': '3600718473251',
                                                                       'in_ucast_pkts': '6886205199',
                                                                       'mac_address': 'cc:be:59:bb:3c:d8',
                                                                       'mtu': 2000,
                                                                       'name': '8/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '23721172',
                                                                       'out_octets': '14248392652958',
                                                                       'out_ucast_pkts': '12267178778',
                                                                       'poller_hash': 'NUE1NzdGcGVlcmludGY4L2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '8',
                                                                       'in_nucast_pkts': '23721172',
                                                                       'in_octets': '14248392652958',
                                                                       'in_ucast_pkts': '12267178778',
                                                                       'links': [       {       'in_nucast_pkts': '23721172',
                                                                                                'in_octets': '14248392652958',
                                                                                                'in_ucast_pkts': '12267178778',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '11165',
                                                                                                'out_octets': '3600718473251',
                                                                                                'out_ucast_pkts': '6886205199',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '11165',
                                                                       'out_octets': '3600718473251',
                                                                       'out_ucast_pkts': '6886205199',
                                                                       'poller_hash': 'NUE1NzdGcGVlcmludGZwb24gOA==',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '8',
                                                                                               'links': [       {       'connected_time': '1733596',
                                                                                                                        'fiber_length': 5170,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NUE1NzdGcGVlcnBvbnBvbiA4',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '931 North Hayden Road',
                                         'poller_hash': 'NUE1NzdG',
                                         'serial_number': '5A577F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3c:d8',
                                         'uptime': '1733596'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f8:9e:28:7f:31:3d'],
                                                                       'id': '9/g1',
                                                                       'in_nucast_pkts': '312894',
                                                                       'in_octets': '288135280445',
                                                                       'in_ucast_pkts': '376491678',
                                                                       'mac_address': 'cc:be:59:bb:3c:cc',
                                                                       'mtu': 2000,
                                                                       'name': '9/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2544635',
                                                                       'out_octets': '356480418128',
                                                                       'out_ucast_pkts': '423663140',
                                                                       'poller_hash': 'NUE1NzdCcGVlcmludGY5L2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '9',
                                                                       'in_nucast_pkts': '2544635',
                                                                       'in_octets': '356480418128',
                                                                       'in_ucast_pkts': '423663140',
                                                                       'links': [       {       'in_nucast_pkts': '2544635',
                                                                                                'in_octets': '356480418128',
                                                                                                'in_ucast_pkts': '423663140',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '312894',
                                                                                                'out_octets': '288135280445',
                                                                                                'out_ucast_pkts': '376491678',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '312894',
                                                                       'out_octets': '288135280445',
                                                                       'out_ucast_pkts': '376491678',
                                                                       'poller_hash': 'NUE1NzdCcGVlcmludGZwb24gOQ==',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '9',
                                                                                               'links': [       {       'connected_time': '4917658',
                                                                                                                        'fiber_length': 4470,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NUE1NzdCcGVlcnBvbnBvbiA5',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '200 Midnight Mine Rd',
                                         'poller_hash': 'NUE1NzdC',
                                         'serial_number': '5A577B',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3c:cc',
                                         'uptime': '4917658'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '18:b1:69:c7:49:7d'],
                                                                       'id': '10/g1',
                                                                       'in_nucast_pkts': '10032',
                                                                       'in_octets': '2852619297284',
                                                                       'in_ucast_pkts': '8428494942',
                                                                       'mac_address': 'cc:be:59:bb:3c:ae',
                                                                       'mtu': 2000,
                                                                       'name': '10/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '25413054',
                                                                       'out_octets': '14405879247210',
                                                                       'out_ucast_pkts': '15377582243',
                                                                       'poller_hash': 'NUE1NzcxcGVlcmludGYxMC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '10',
                                                                       'in_nucast_pkts': '25413054',
                                                                       'in_octets': '14405879247210',
                                                                       'in_ucast_pkts': '15377582243',
                                                                       'links': [       {       'in_nucast_pkts': '25413054',
                                                                                                'in_octets': '14405879247210',
                                                                                                'in_ucast_pkts': '15377582243',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '10032',
                                                                                                'out_octets': '2852619297284',
                                                                                                'out_ucast_pkts': '8428494942',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '10032',
                                                                       'out_octets': '2852619297284',
                                                                       'out_ucast_pkts': '8428494942',
                                                                       'poller_hash': 'NUE1NzcxcGVlcmludGZwb24gMTA=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '10',
                                                                                               'links': [       {       'connected_time': '5000829',
                                                                                                                        'fiber_length': 4390,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NUE1NzcxcGVlcnBvbnBvbiAxMA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '490 North Hayden Road',
                                         'poller_hash': 'NUE1Nzcx',
                                         'serial_number': '5A5771',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3c:ae',
                                         'uptime': '5000829'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '20:b5:c6:1a:4d:a9',
                                                                                                        'ac:17:c8:d0:52:ba',
                                                                                                        'ec:13:b2:92:c7:e8'],
                                                                       'id': '11/g1',
                                                                       'in_nucast_pkts': '5348566',
                                                                       'in_octets': '360362579786',
                                                                       'in_ucast_pkts': '1805680881',
                                                                       'mac_address': 'cc:be:59:bb:3d:e0',
                                                                       'mtu': 2000,
                                                                       'name': '11/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '15745197',
                                                                       'out_octets': '3525691748503',
                                                                       'out_ucast_pkts': '3049521108',
                                                                       'poller_hash': 'NUE1N0Q3cGVlcmludGYxMS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '11',
                                                                       'in_nucast_pkts': '15745197',
                                                                       'in_octets': '3525691748503',
                                                                       'in_ucast_pkts': '3049521108',
                                                                       'links': [       {       'in_nucast_pkts': '15745197',
                                                                                                'in_octets': '3525691748503',
                                                                                                'in_ucast_pkts': '3049521108',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '5348566',
                                                                                                'out_octets': '360362579786',
                                                                                                'out_ucast_pkts': '1805680881',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '5348566',
                                                                       'out_octets': '360362579786',
                                                                       'out_ucast_pkts': '1805680881',
                                                                       'poller_hash': 'NUE1N0Q3cGVlcmludGZwb24gMTE=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '11',
                                                                                               'links': [       {       'connected_time': '19848307',
                                                                                                                        'fiber_length': 4593,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NUE1N0Q3cGVlcnBvbnBvbiAxMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '188 Loges Spring Road',
                                         'poller_hash': 'NUE1N0Q3',
                                         'serial_number': '5A57D7',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3d:e0',
                                         'uptime': '19848307'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '58:6d:8f:8a:8d:a7'],
                                                                       'id': '12/g1',
                                                                       'in_nucast_pkts': '210294',
                                                                       'in_octets': '793657526076',
                                                                       'in_ucast_pkts': '2911087860',
                                                                       'mac_address': '44:65:7f:7b:94:5e',
                                                                       'mtu': 2000,
                                                                       'name': '12/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '10611216',
                                                                       'out_octets': '6154763088346',
                                                                       'out_ucast_pkts': '4856100063',
                                                                       'poller_hash': 'NUEzNzU2cGVlcmludGYxMi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '12',
                                                                       'in_nucast_pkts': '10611216',
                                                                       'in_octets': '6154763088346',
                                                                       'in_ucast_pkts': '4856100063',
                                                                       'links': [       {       'in_nucast_pkts': '10611216',
                                                                                                'in_octets': '6154763088346',
                                                                                                'in_ucast_pkts': '4856100063',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '210294',
                                                                                                'out_octets': '793657526076',
                                                                                                'out_ucast_pkts': '2911087860',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '210294',
                                                                       'out_octets': '793657526076',
                                                                       'out_ucast_pkts': '2911087860',
                                                                       'poller_hash': 'NUEzNzU2cGVlcmludGZwb24gMTI=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '12',
                                                                                               'links': [       {       'connected_time': '19852747',
                                                                                                                        'fiber_length': 2600,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NUEzNzU2cGVlcnBvbnBvbiAxMg==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '335 Hall Drive',
                                         'poller_hash': 'NUEzNzU2',
                                         'serial_number': '5A3756',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:7b:94:5e',
                                         'uptime': '19852747'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'fc:ec:da:d3:eb:2b'],
                                                                       'id': '13/g1',
                                                                       'in_nucast_pkts': '30',
                                                                       'in_octets': '88922456999',
                                                                       'in_ucast_pkts': '204225416',
                                                                       'mac_address': 'cc:be:59:bb:3c:b7',
                                                                       'mtu': 2000,
                                                                       'name': '13/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '7120187',
                                                                       'out_octets': '356413659481',
                                                                       'out_ucast_pkts': '337909250',
                                                                       'poller_hash': 'NUE1Nzc0cGVlcmludGYxMy9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '13',
                                                                       'in_nucast_pkts': '7120187',
                                                                       'in_octets': '356413659481',
                                                                       'in_ucast_pkts': '337909250',
                                                                       'links': [       {       'in_nucast_pkts': '7120187',
                                                                                                'in_octets': '356413659481',
                                                                                                'in_ucast_pkts': '337909250',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '30',
                                                                                                'out_octets': '88922456999',
                                                                                                'out_ucast_pkts': '204225416',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '30',
                                                                       'out_octets': '88922456999',
                                                                       'out_ucast_pkts': '204225416',
                                                                       'poller_hash': 'NUE1Nzc0cGVlcmludGZwb24gMTM=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '13',
                                                                                               'links': [       {       'connected_time': '13646275',
                                                                                                                        'fiber_length': 6112,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NUE1Nzc0cGVlcnBvbnBvbiAxMw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '500 South Hayden Road',
                                         'poller_hash': 'NUE1Nzc0',
                                         'serial_number': '5A5774',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3c:b7',
                                         'uptime': '13646275'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:f8:b3:b6:7b:ed'],
                                                                       'id': '15/g1',
                                                                       'in_nucast_pkts': '140817',
                                                                       'in_octets': '43526612318',
                                                                       'in_ucast_pkts': '105243538',
                                                                       'mac_address': '44:65:7f:bb:4a:00',
                                                                       'mtu': 2000,
                                                                       'name': '15/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2734360',
                                                                       'out_octets': '224135890121',
                                                                       'out_ucast_pkts': '190802357',
                                                                       'poller_hash': 'NjVGOTlBcGVlcmludGYxNS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '15',
                                                                       'in_nucast_pkts': '2734360',
                                                                       'in_octets': '224135890121',
                                                                       'in_ucast_pkts': '190802357',
                                                                       'links': [       {       'in_nucast_pkts': '2734360',
                                                                                                'in_octets': '224135890121',
                                                                                                'in_ucast_pkts': '190802357',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '140817',
                                                                                                'out_octets': '43526612318',
                                                                                                'out_ucast_pkts': '105243538',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '140817',
                                                                       'out_octets': '43526612318',
                                                                       'out_ucast_pkts': '105243538',
                                                                       'poller_hash': 'NjVGOTlBcGVlcmludGZwb24gMTU=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '15',
                                                                                               'links': [       {       'connected_time': '5284908',
                                                                                                                        'fiber_length': 4156,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NjVGOTlBcGVlcnBvbnBvbiAxNQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '2400 Castle Creek Road',
                                         'poller_hash': 'NjVGOTlB',
                                         'serial_number': '65F99A',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4a:00',
                                         'uptime': '5284908'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '24:f5:a2:0b:17:d4'],
                                                                       'id': '17/g1',
                                                                       'in_nucast_pkts': '18274',
                                                                       'in_octets': '144619437466',
                                                                       'in_ucast_pkts': '466542387',
                                                                       'mac_address': '44:65:7f:bb:4a:66',
                                                                       'mtu': 2000,
                                                                       'name': '17/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2734353',
                                                                       'out_octets': '1190440074064',
                                                                       'out_ucast_pkts': '957047302',
                                                                       'poller_hash': 'NjVGOUJDcGVlcmludGYxNy9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '17',
                                                                       'in_nucast_pkts': '2734353',
                                                                       'in_octets': '1190440074064',
                                                                       'in_ucast_pkts': '957047302',
                                                                       'links': [       {       'in_nucast_pkts': '2734353',
                                                                                                'in_octets': '1190440074064',
                                                                                                'in_ucast_pkts': '957047302',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '18274',
                                                                                                'out_octets': '144619437466',
                                                                                                'out_ucast_pkts': '466542387',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '18274',
                                                                       'out_octets': '144619437466',
                                                                       'out_ucast_pkts': '466542387',
                                                                       'poller_hash': 'NjVGOUJDcGVlcmludGZwb24gMTc=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '17',
                                                                                               'links': [       {       'connected_time': '5284878',
                                                                                                                        'fiber_length': 2806,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NjVGOUJDcGVlcnBvbnBvbiAxNw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '365 Hall Dr',
                                         'poller_hash': 'NjVGOUJD',
                                         'serial_number': '65F9BC',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4a:66',
                                         'uptime': '5284878'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd4:6a:91:b0:6f:61'],
                                                                       'id': '18/g1',
                                                                       'in_nucast_pkts': '2828',
                                                                       'in_octets': '53927652105',
                                                                       'in_ucast_pkts': '277155870',
                                                                       'mac_address': '44:65:7f:bb:4a:78',
                                                                       'mtu': 2000,
                                                                       'name': '18/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '6658640',
                                                                       'out_octets': '679750927990',
                                                                       'out_ucast_pkts': '521435249',
                                                                       'poller_hash': 'NjVGOUMycGVlcmludGYxOC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '18',
                                                                       'in_nucast_pkts': '6658640',
                                                                       'in_octets': '679750927990',
                                                                       'in_ucast_pkts': '521435249',
                                                                       'links': [       {       'in_nucast_pkts': '6658640',
                                                                                                'in_octets': '679750927990',
                                                                                                'in_ucast_pkts': '521435249',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '2828',
                                                                                                'out_octets': '53927652105',
                                                                                                'out_ucast_pkts': '277155870',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2828',
                                                                       'out_octets': '53927652105',
                                                                       'out_ucast_pkts': '277155870',
                                                                       'poller_hash': 'NjVGOUMycGVlcmludGZwb24gMTg=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '18',
                                                                                               'links': [       {       'connected_time': '12793691',
                                                                                                                        'fiber_length': 4621,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NjVGOUMycGVlcnBvbnBvbiAxOA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '633 N Hayden Rd',
                                         'poller_hash': 'NjVGOUMy',
                                         'serial_number': '65F9C2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4a:78',
                                         'uptime': '12793691'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e0:cb:bc:19:d8:a0'],
                                                                       'id': '19/g1',
                                                                       'in_nucast_pkts': '344658',
                                                                       'in_octets': '245922843950',
                                                                       'in_ucast_pkts': '514691603',
                                                                       'mac_address': '44:65:7f:bb:49:9a',
                                                                       'mtu': 2000,
                                                                       'name': '19/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2734504',
                                                                       'out_octets': '776319115597',
                                                                       'out_ucast_pkts': '771555784',
                                                                       'poller_hash': 'NjVGOTc4cGVlcmludGYxOS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '19',
                                                                       'in_nucast_pkts': '2734504',
                                                                       'in_octets': '776319115597',
                                                                       'in_ucast_pkts': '771555784',
                                                                       'links': [       {       'in_nucast_pkts': '2734504',
                                                                                                'in_octets': '776319115597',
                                                                                                'in_ucast_pkts': '771555784',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '344658',
                                                                                                'out_octets': '245922843950',
                                                                                                'out_ucast_pkts': '514691603',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '344658',
                                                                       'out_octets': '245922843950',
                                                                       'out_ucast_pkts': '514691603',
                                                                       'poller_hash': 'NjVGOTc4cGVlcmludGZwb24gMTk=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '19',
                                                                                               'links': [       {       'connected_time': '5284885',
                                                                                                                        'fiber_length': 5818,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NjVGOTc4cGVlcnBvbnBvbiAxOQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '562 Midnight Mine Road',
                                         'poller_hash': 'NjVGOTc4',
                                         'serial_number': '65F978',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:49:9a',
                                         'uptime': '5284885'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '14:9f:43:19:ec:4d'],
                                                                       'id': '20/g1',
                                                                       'in_nucast_pkts': '505295',
                                                                       'in_octets': '141101115558',
                                                                       'in_ucast_pkts': '735244312',
                                                                       'mac_address': '44:65:7f:bb:4a:93',
                                                                       'mtu': 2000,
                                                                       'name': '20/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '4139413',
                                                                       'out_octets': '1706920341165',
                                                                       'out_ucast_pkts': '1495644335',
                                                                       'poller_hash': 'NjVGOUNCcGVlcmludGYyMC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '20',
                                                                       'in_nucast_pkts': '4139413',
                                                                       'in_octets': '1706920341165',
                                                                       'in_ucast_pkts': '1495644335',
                                                                       'links': [       {       'in_nucast_pkts': '4139413',
                                                                                                'in_octets': '1706920341165',
                                                                                                'in_ucast_pkts': '1495644335',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '505295',
                                                                                                'out_octets': '141101115558',
                                                                                                'out_ucast_pkts': '735244312',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '505295',
                                                                       'out_octets': '141101115558',
                                                                       'out_ucast_pkts': '735244312',
                                                                       'poller_hash': 'NjVGOUNCcGVlcmludGZwb24gMjA=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '20',
                                                                                               'links': [       {       'connected_time': '7965735',
                                                                                                                        'fiber_length': 14844,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NjVGOUNCcGVlcnBvbnBvbiAyMA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '8475 Castle Creek Rd',
                                         'poller_hash': 'NjVGOUNC',
                                         'serial_number': '65F9CB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4a:93',
                                         'uptime': '7965735'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0c:80:63:a0:0b:9d'],
                                                                       'id': '21/g1',
                                                                       'in_nucast_pkts': '5510727',
                                                                       'in_octets': '57048431516',
                                                                       'in_ucast_pkts': '200881698',
                                                                       'mac_address': '44:65:7f:bb:4a:c3',
                                                                       'mtu': 2000,
                                                                       'name': '21/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2734198',
                                                                       'out_octets': '423086148492',
                                                                       'out_ucast_pkts': '336982933',
                                                                       'poller_hash': 'NjVGOURCcGVlcmludGYyMS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '21',
                                                                       'in_nucast_pkts': '2734198',
                                                                       'in_octets': '423086148492',
                                                                       'in_ucast_pkts': '336982933',
                                                                       'links': [       {       'in_nucast_pkts': '2734198',
                                                                                                'in_octets': '423086148492',
                                                                                                'in_ucast_pkts': '336982933',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '5510727',
                                                                                                'out_octets': '57048431516',
                                                                                                'out_ucast_pkts': '200881698',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '5510727',
                                                                       'out_octets': '57048431516',
                                                                       'out_ucast_pkts': '200881698',
                                                                       'poller_hash': 'NjVGOURCcGVlcmludGZwb24gMjE=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '21',
                                                                                               'links': [       {       'connected_time': '5284909',
                                                                                                                        'fiber_length': 8209,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NjVGOURCcGVlcnBvbnBvbiAyMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '4929 Castle Creek Road',
                                         'poller_hash': 'NjVGOURC',
                                         'serial_number': '65F9DB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4a:c3',
                                         'uptime': '5284909'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd4:6a:91:77:55:27'],
                                                                       'id': '22/g1',
                                                                       'in_nucast_pkts': '196879',
                                                                       'in_octets': '170279679756',
                                                                       'in_ucast_pkts': '321039254',
                                                                       'mac_address': '44:65:7f:bb:4b:17',
                                                                       'mtu': 2000,
                                                                       'name': '22/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '7119924',
                                                                       'out_octets': '474004095447',
                                                                       'out_ucast_pkts': '483951712',
                                                                       'poller_hash': 'NjVGOUY3cGVlcmludGYyMi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '22',
                                                                       'in_nucast_pkts': '7119924',
                                                                       'in_octets': '474004095447',
                                                                       'in_ucast_pkts': '483951712',
                                                                       'links': [       {       'in_nucast_pkts': '7119924',
                                                                                                'in_octets': '474004095447',
                                                                                                'in_ucast_pkts': '483951712',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '196879',
                                                                                                'out_octets': '170279679756',
                                                                                                'out_ucast_pkts': '321039254',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '196879',
                                                                       'out_octets': '170279679756',
                                                                       'out_ucast_pkts': '321039254',
                                                                       'poller_hash': 'NjVGOUY3cGVlcmludGZwb24gMjI=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '22',
                                                                                               'links': [       {       'connected_time': '13646353',
                                                                                                                        'fiber_length': 9281,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NjVGOUY3cGVlcnBvbnBvbiAyMg==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '226 Conundrum Creek Road',
                                         'poller_hash': 'NjVGOUY3',
                                         'serial_number': '65F9F7',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4b:17',
                                         'uptime': '13646353'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '2c:b8:ed:41:e9:c9'],
                                                                       'id': '23/g1',
                                                                       'in_nucast_pkts': '24469',
                                                                       'in_octets': '562585928224',
                                                                       'in_ucast_pkts': '2571947579',
                                                                       'mac_address': '44:65:7f:bb:49:a0',
                                                                       'mtu': 2000,
                                                                       'name': '23/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '5144218',
                                                                       'out_octets': '11283419248947',
                                                                       'out_ucast_pkts': '8059338835',
                                                                       'poller_hash': 'NjVGOTdBcGVlcmludGYyMy9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '23',
                                                                       'in_nucast_pkts': '5144218',
                                                                       'in_octets': '11283419248947',
                                                                       'in_ucast_pkts': '8059338835',
                                                                       'links': [       {       'in_nucast_pkts': '5144218',
                                                                                                'in_octets': '11283419248947',
                                                                                                'in_ucast_pkts': '8059338835',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '24469',
                                                                                                'out_octets': '562585928224',
                                                                                                'out_ucast_pkts': '2571947579',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '24469',
                                                                       'out_octets': '562585928224',
                                                                       'out_ucast_pkts': '2571947579',
                                                                       'poller_hash': 'NjVGOTdBcGVlcmludGZwb24gMjM=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '23',
                                                                                               'links': [       {       'connected_time': '9912502',
                                                                                                                        'fiber_length': 9226,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NjVGOTdBcGVlcnBvbnBvbiAyMw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '243 Conundrum Creek Road',
                                         'poller_hash': 'NjVGOTdB',
                                         'serial_number': '65F97A',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:49:a0',
                                         'uptime': '9912502'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:30:44:2f:63:24'],
                                                                       'id': '24/g1',
                                                                       'in_nucast_pkts': '8',
                                                                       'in_octets': '12672773644',
                                                                       'in_ucast_pkts': '34114509',
                                                                       'mac_address': '44:65:7f:bb:4a:48',
                                                                       'mtu': 2000,
                                                                       'name': '24/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2734366',
                                                                       'out_octets': '87930246826',
                                                                       'out_ucast_pkts': '74620220',
                                                                       'poller_hash': 'NjVGOUIycGVlcmludGYyNC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '24',
                                                                       'in_nucast_pkts': '2734366',
                                                                       'in_octets': '87930246826',
                                                                       'in_ucast_pkts': '74620220',
                                                                       'links': [       {       'in_nucast_pkts': '2734366',
                                                                                                'in_octets': '87930246826',
                                                                                                'in_ucast_pkts': '74620220',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '8',
                                                                                                'out_octets': '12672773644',
                                                                                                'out_ucast_pkts': '34114509',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '8',
                                                                       'out_octets': '12672773644',
                                                                       'out_ucast_pkts': '34114509',
                                                                       'poller_hash': 'NjVGOUIycGVlcmludGZwb24gMjQ=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '24',
                                                                                               'links': [       {       'connected_time': '5284881',
                                                                                                                        'fiber_length': 2896,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NjVGOUIycGVlcnBvbnBvbiAyNA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '201 Mariposa',
                                         'poller_hash': 'NjVGOUIy',
                                         'serial_number': '65F9B2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4a:48',
                                         'uptime': '5284881'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '18:b1:69:bf:8c:2d'],
                                                                       'id': '25/g1',
                                                                       'in_nucast_pkts': '1591',
                                                                       'in_octets': '27290031556',
                                                                       'in_ucast_pkts': '75057413',
                                                                       'mac_address': '84:d3:43:9f:34:6b',
                                                                       'mtu': 2000,
                                                                       'name': '25/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2734398',
                                                                       'out_octets': '179900676589',
                                                                       'out_ucast_pkts': '167956118',
                                                                       'poller_hash': 'RDlDNTYxcGVlcmludGYyNS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '25',
                                                                       'in_nucast_pkts': '2734398',
                                                                       'in_octets': '179900676589',
                                                                       'in_ucast_pkts': '167956118',
                                                                       'links': [       {       'in_nucast_pkts': '2734398',
                                                                                                'in_octets': '179900676589',
                                                                                                'in_ucast_pkts': '167956118',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '1591',
                                                                                                'out_octets': '27290031556',
                                                                                                'out_ucast_pkts': '75057413',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1591',
                                                                       'out_octets': '27290031556',
                                                                       'out_ucast_pkts': '75057413',
                                                                       'poller_hash': 'RDlDNTYxcGVlcmludGZwb24gMjU=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '25',
                                                                                               'links': [       {       'connected_time': '5284905',
                                                                                                                        'fiber_length': 5296,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'RDlDNTYxcGVlcnBvbnBvbiAyNQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '101 South Hayden Road',
                                         'poller_hash': 'RDlDNTYx',
                                         'serial_number': 'D9C561',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '84:d3:43:9f:34:6b',
                                         'uptime': '5284905'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd4:6a:91:b0:57:49'],
                                                                       'id': '26/g1',
                                                                       'in_nucast_pkts': '208',
                                                                       'in_octets': '36272719293',
                                                                       'in_ucast_pkts': '91533264',
                                                                       'mac_address': '44:65:7f:bb:4a:2a',
                                                                       'mtu': 2000,
                                                                       'name': '26/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '930338',
                                                                       'out_octets': '176189583814',
                                                                       'out_ucast_pkts': '149639608',
                                                                       'poller_hash': 'NjVGOUE4cGVlcmludGYyNi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '26',
                                                                       'in_nucast_pkts': '930338',
                                                                       'in_octets': '176189583814',
                                                                       'in_ucast_pkts': '149639608',
                                                                       'links': [       {       'in_nucast_pkts': '930338',
                                                                                                'in_octets': '176189583814',
                                                                                                'in_ucast_pkts': '149639608',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '208',
                                                                                                'out_octets': '36272719293',
                                                                                                'out_ucast_pkts': '91533264',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '208',
                                                                       'out_octets': '36272719293',
                                                                       'out_ucast_pkts': '91533264',
                                                                       'poller_hash': 'NjVGOUE4cGVlcmludGZwb24gMjY=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '26',
                                                                                               'links': [       {       'connected_time': '1799597',
                                                                                                                        'fiber_length': 9436,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NjVGOUE4cGVlcnBvbnBvbiAyNg==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '245 Conundrum Creek Road',
                                         'poller_hash': 'NjVGOUE4',
                                         'serial_number': '65F9A8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4a:2a',
                                         'uptime': '1799597'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f8:9e:28:7e:ad:76'],
                                                                       'id': '27/g1',
                                                                       'in_nucast_pkts': '1304323',
                                                                       'in_octets': '233073283825',
                                                                       'in_ucast_pkts': '1161931645',
                                                                       'mac_address': '44:65:7f:bb:49:e2',
                                                                       'mtu': 2000,
                                                                       'name': '27/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '10563251',
                                                                       'out_octets': '1347639752577',
                                                                       'out_ucast_pkts': '1669345201',
                                                                       'poller_hash': 'NjVGOTkwcGVlcmludGYyNy9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '27',
                                                                       'in_nucast_pkts': '10563251',
                                                                       'in_octets': '1347639752577',
                                                                       'in_ucast_pkts': '1669345201',
                                                                       'links': [       {       'in_nucast_pkts': '10563251',
                                                                                                'in_octets': '1347639752577',
                                                                                                'in_ucast_pkts': '1669345201',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '1304323',
                                                                                                'out_octets': '233073283825',
                                                                                                'out_ucast_pkts': '1161931645',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1304323',
                                                                       'out_octets': '233073283825',
                                                                       'out_ucast_pkts': '1161931645',
                                                                       'poller_hash': 'NjVGOTkwcGVlcmludGZwb24gMjc=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '27',
                                                                                               'links': [       {       'connected_time': '19846654',
                                                                                                                        'fiber_length': 2809,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NjVGOTkwcGVlcnBvbnBvbiAyNw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '507 Mariposa Rd',
                                         'poller_hash': 'NjVGOTkw',
                                         'serial_number': '65F990',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:49:e2',
                                         'uptime': '19846654'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '18:90:88:41:91:60'],
                                                                       'id': '28/g1',
                                                                       'in_nucast_pkts': '176103',
                                                                       'in_octets': '150738037472',
                                                                       'in_ucast_pkts': '197583812',
                                                                       'mac_address': '44:65:7f:bb:4a:a5',
                                                                       'mtu': 2000,
                                                                       'name': '28/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2734380',
                                                                       'out_octets': '265574845004',
                                                                       'out_ucast_pkts': '256657048',
                                                                       'poller_hash': 'NjVGOUQxcGVlcmludGYyOC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '28',
                                                                       'in_nucast_pkts': '2734380',
                                                                       'in_octets': '265574845004',
                                                                       'in_ucast_pkts': '256657048',
                                                                       'links': [       {       'in_nucast_pkts': '2734380',
                                                                                                'in_octets': '265574845004',
                                                                                                'in_ucast_pkts': '256657048',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '176103',
                                                                                                'out_octets': '150738037472',
                                                                                                'out_ucast_pkts': '197583812',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '176103',
                                                                       'out_octets': '150738037472',
                                                                       'out_ucast_pkts': '197583812',
                                                                       'poller_hash': 'NjVGOUQxcGVlcmludGZwb24gMjg=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '28',
                                                                                               'links': [       {       'connected_time': '5284879',
                                                                                                                        'fiber_length': 15610,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NjVGOUQxcGVlcnBvbnBvbiAyOA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '11 Fall Creek Road',
                                         'poller_hash': 'NjVGOUQx',
                                         'serial_number': '65F9D1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4a:a5',
                                         'uptime': '5284879'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '90:a7:c1:97:7f:4a'],
                                                                       'id': '29/g1',
                                                                       'in_nucast_pkts': '27911',
                                                                       'in_octets': '294828226782',
                                                                       'in_ucast_pkts': '705821653',
                                                                       'mac_address': '44:65:7f:bb:4a:06',
                                                                       'mtu': 2000,
                                                                       'name': '29/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '7120145',
                                                                       'out_octets': '1589882880928',
                                                                       'out_ucast_pkts': '1308545161',
                                                                       'poller_hash': 'NjVGOTlDcGVlcmludGYyOS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '29',
                                                                       'in_nucast_pkts': '7120145',
                                                                       'in_octets': '1589882880928',
                                                                       'in_ucast_pkts': '1308545161',
                                                                       'links': [       {       'in_nucast_pkts': '7120145',
                                                                                                'in_octets': '1589882880928',
                                                                                                'in_ucast_pkts': '1308545161',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '27911',
                                                                                                'out_octets': '294828226782',
                                                                                                'out_ucast_pkts': '705821653',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '27911',
                                                                       'out_octets': '294828226782',
                                                                       'out_ucast_pkts': '705821653',
                                                                       'poller_hash': 'NjVGOTlDcGVlcmludGZwb24gMjk=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '29',
                                                                                               'links': [       {       'connected_time': '13646296',
                                                                                                                        'fiber_length': 16098,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NjVGOTlDcGVlcnBvbnBvbiAyOQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '33 Fall Creek RD',
                                         'poller_hash': 'NjVGOTlD',
                                         'serial_number': '65F99C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4a:06',
                                         'uptime': '13646296'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '98:18:88:cd:a1:14'],
                                                                       'id': '30/g1',
                                                                       'in_nucast_pkts': '1531045',
                                                                       'in_octets': '2827788469933',
                                                                       'in_ucast_pkts': '3471705499',
                                                                       'mac_address': '44:65:7f:bb:3d:88',
                                                                       'mtu': 2000,
                                                                       'name': '30/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '12454397',
                                                                       'out_octets': '1956529249253',
                                                                       'out_ucast_pkts': '2428541483',
                                                                       'poller_hash': 'NjVGNTcycGVlcmludGYzMC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '30',
                                                                       'in_nucast_pkts': '12454397',
                                                                       'in_octets': '1956529249253',
                                                                       'in_ucast_pkts': '2428541483',
                                                                       'links': [       {       'in_nucast_pkts': '12454397',
                                                                                                'in_octets': '1956529249253',
                                                                                                'in_ucast_pkts': '2428541483',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '1531045',
                                                                                                'out_octets': '2827788469933',
                                                                                                'out_ucast_pkts': '3471705499',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1531045',
                                                                       'out_octets': '2827788469933',
                                                                       'out_ucast_pkts': '3471705499',
                                                                       'poller_hash': 'NjVGNTcycGVlcmludGZwb24gMzA=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '30',
                                                                                               'links': [       {       'connected_time': '23303187',
                                                                                                                        'fiber_length': 14808,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NjVGNTcycGVlcnBvbnBvbiAzMA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '8720 Castle Creek Road',
                                         'poller_hash': 'NjVGNTcy',
                                         'serial_number': '65F572',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:3d:88',
                                         'uptime': '23303187'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:1b:17:00:21:17'],
                                                                       'id': '31/g1',
                                                                       'in_nucast_pkts': '564563',
                                                                       'in_octets': '1697536847168',
                                                                       'in_ucast_pkts': '2565095522',
                                                                       'mac_address': '48:77:46:1d:47:ba',
                                                                       'mtu': 1496,
                                                                       'name': '31/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '5802484',
                                                                       'out_octets': '3639967948082',
                                                                       'out_ucast_pkts': '3762752195',
                                                                       'poller_hash': 'NkZERTAwcGVlcmludGYzMS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '31/g2',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mac_address': '48:77:46:1d:47:bb',
                                                                       'mtu': 1496,
                                                                       'name': '31/g2',
                                                                       'oper_up': False,
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NkZERTAwcGVlcmludGYzMS9nMg=='},
                                                               {       'admin_up': True,
                                                                       'id': '31/g3',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mac_address': '48:77:46:1d:47:bc',
                                                                       'mtu': 1496,
                                                                       'name': '31/g3',
                                                                       'oper_up': False,
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NkZERTAwcGVlcmludGYzMS9nMw=='},
                                                               {       'admin_up': True,
                                                                       'id': '31/g4',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mac_address': '48:77:46:1d:47:bd',
                                                                       'mtu': 1496,
                                                                       'name': '31/g4',
                                                                       'oper_up': False,
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NkZERTAwcGVlcmludGYzMS9nNA=='},
                                                               {       'admin_up': True,
                                                                       'id': '31',
                                                                       'in_nucast_pkts': '5802484',
                                                                       'in_octets': '3639967948082',
                                                                       'in_ucast_pkts': '3762752195',
                                                                       'links': [       {       'in_nucast_pkts': '5802484',
                                                                                                'in_octets': '3639967948082',
                                                                                                'in_ucast_pkts': '3762752195',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '564563',
                                                                                                'out_octets': '1697536847168',
                                                                                                'out_ucast_pkts': '2565095522',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '564563',
                                                                       'out_octets': '1697536847168',
                                                                       'out_ucast_pkts': '2565095522',
                                                                       'poller_hash': 'NkZERTAwcGVlcmludGZwb24gMzE=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '31',
                                                                                               'links': [       {       'connected_time': '2561311',
                                                                                                                        'fiber_length': 5404,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NkZERTAwcGVlcnBvbnBvbiAzMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '844G-1',
                                         'name': '565 Midnight Mine Rd.',
                                         'poller_hash': 'NkZERTAw',
                                         'serial_number': '6FDE00',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '11.2.6.10.2',
                                         'system_mac_address': '48:77:46:1d:47:b7',
                                         'uptime': '2561311'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '2c:b8:ed:70:f7:e9'],
                                                                       'id': '33/g1',
                                                                       'in_nucast_pkts': '3010234',
                                                                       'in_octets': '217720770624',
                                                                       'in_ucast_pkts': '397584691',
                                                                       'mac_address': '48:77:46:96:32:42',
                                                                       'mtu': 2000,
                                                                       'name': '33/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2734539',
                                                                       'out_octets': '1108794159980',
                                                                       'out_ucast_pkts': '934621662',
                                                                       'poller_hash': 'NzcwNUYzcGVlcmludGYzMy9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '33',
                                                                       'in_nucast_pkts': '2734539',
                                                                       'in_octets': '1108794159980',
                                                                       'in_ucast_pkts': '934621662',
                                                                       'links': [       {       'in_nucast_pkts': '2734539',
                                                                                                'in_octets': '1108794159980',
                                                                                                'in_ucast_pkts': '934621662',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '3010234',
                                                                                                'out_octets': '217720770624',
                                                                                                'out_ucast_pkts': '397584691',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '3010234',
                                                                       'out_octets': '217720770624',
                                                                       'out_ucast_pkts': '397584691',
                                                                       'poller_hash': 'NzcwNUYzcGVlcmludGZwb24gMzM=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '33',
                                                                                               'links': [       {       'connected_time': '5284937',
                                                                                                                        'fiber_length': 4245,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NzcwNUYzcGVlcnBvbnBvbiAzMw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '250 North Hayden Road',
                                         'poller_hash': 'NzcwNUYz',
                                         'serial_number': '7705F3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '48:77:46:96:32:42',
                                         'uptime': '5284937'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '98:ed:7e:0f:db:81'],
                                                                       'id': '34/g1',
                                                                       'in_nucast_pkts': '108727',
                                                                       'in_octets': '45496889486',
                                                                       'in_ucast_pkts': '116318682',
                                                                       'mac_address': '48:77:46:96:36:c5',
                                                                       'mtu': 2000,
                                                                       'name': '34/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1348430',
                                                                       'out_octets': '415663794894',
                                                                       'out_ucast_pkts': '322015966',
                                                                       'poller_hash': 'NzcwNzc0cGVlcmludGYzNC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '34',
                                                                       'in_nucast_pkts': '1348430',
                                                                       'in_octets': '415663794894',
                                                                       'in_ucast_pkts': '322015966',
                                                                       'links': [       {       'in_nucast_pkts': '1348430',
                                                                                                'in_octets': '415663794894',
                                                                                                'in_ucast_pkts': '322015966',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '108727',
                                                                                                'out_octets': '45496889486',
                                                                                                'out_ucast_pkts': '116318682',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '108727',
                                                                       'out_octets': '45496889486',
                                                                       'out_ucast_pkts': '116318682',
                                                                       'poller_hash': 'NzcwNzc0cGVlcmludGZwb24gMzQ=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '34',
                                                                                               'links': [       {       'connected_time': '2608712',
                                                                                                                        'fiber_length': 6766,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NzcwNzc0cGVlcnBvbnBvbiAzNA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '800 South Hayden Road',
                                         'poller_hash': 'NzcwNzc0',
                                         'serial_number': '770774',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '48:77:46:96:36:c5',
                                         'uptime': '2608712'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:59:3f:75'],
                                                                       'id': '35/g1',
                                                                       'in_nucast_pkts': '171394',
                                                                       'in_octets': '654679710660',
                                                                       'in_ucast_pkts': '2750126701',
                                                                       'mac_address': '48:77:46:96:39:50',
                                                                       'mtu': 2000,
                                                                       'name': '35/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '9779525',
                                                                       'out_octets': '9037610709124',
                                                                       'out_ucast_pkts': '6466286550',
                                                                       'poller_hash': 'NzcwODREcGVlcmludGYzNS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '35',
                                                                       'in_nucast_pkts': '9779525',
                                                                       'in_octets': '9037610709124',
                                                                       'in_ucast_pkts': '6466286550',
                                                                       'links': [       {       'in_nucast_pkts': '9779525',
                                                                                                'in_octets': '9037610709124',
                                                                                                'in_ucast_pkts': '6466286550',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '171394',
                                                                                                'out_octets': '654679710660',
                                                                                                'out_ucast_pkts': '2750126701',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '171394',
                                                                       'out_octets': '654679710660',
                                                                       'out_ucast_pkts': '2750126701',
                                                                       'poller_hash': 'NzcwODREcGVlcmludGZwb24gMzU=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '35',
                                                                                               'links': [       {       'connected_time': '18328994',
                                                                                                                        'fiber_length': 12247,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NzcwODREcGVlcnBvbnBvbiAzNQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '46 Lower Hurricane Road',
                                         'poller_hash': 'NzcwODRE',
                                         'serial_number': '77084D',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '48:77:46:96:39:50',
                                         'uptime': '18328994'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'ac:8b:a9:11:24:15'],
                                                                       'id': '36/g1',
                                                                       'in_nucast_pkts': '17498036',
                                                                       'in_octets': '352385315511',
                                                                       'in_ucast_pkts': '851085530',
                                                                       'mac_address': '84:d3:43:9f:33:5a',
                                                                       'mtu': 2000,
                                                                       'name': '36/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '7120345',
                                                                       'out_octets': '997458059485',
                                                                       'out_ucast_pkts': '1127824748',
                                                                       'poller_hash': 'RDlDNTA2cGVlcmludGYzNi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '36',
                                                                       'in_nucast_pkts': '7120345',
                                                                       'in_octets': '997458059485',
                                                                       'in_ucast_pkts': '1127824748',
                                                                       'links': [       {       'in_nucast_pkts': '7120345',
                                                                                                'in_octets': '997458059485',
                                                                                                'in_ucast_pkts': '1127824748',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '17498036',
                                                                                                'out_octets': '352385315511',
                                                                                                'out_ucast_pkts': '851085530',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '17498036',
                                                                       'out_octets': '352385315511',
                                                                       'out_ucast_pkts': '851085530',
                                                                       'poller_hash': 'RDlDNTA2cGVlcmludGZwb24gMzY=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '36',
                                                                                               'links': [       {       'connected_time': '13646463',
                                                                                                                        'fiber_length': 5867,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'RDlDNTA2cGVlcnBvbnBvbiAzNg==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '360 South Hayden Road',
                                         'poller_hash': 'RDlDNTA2',
                                         'serial_number': 'D9C506',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '84:d3:43:9f:33:5a',
                                         'uptime': '13646463'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd4:6a:91:b0:ce:45'],
                                                                       'id': '37/g1',
                                                                       'in_nucast_pkts': '1156',
                                                                       'in_octets': '39568907075',
                                                                       'in_ucast_pkts': '54240597',
                                                                       'mac_address': '48:77:46:96:37:70',
                                                                       'mtu': 2000,
                                                                       'name': '37/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2734478',
                                                                       'out_octets': '22418154661',
                                                                       'out_ucast_pkts': '45704735',
                                                                       'poller_hash': 'NzcwN0FEcGVlcmludGYzNy9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '37',
                                                                       'in_nucast_pkts': '2734478',
                                                                       'in_octets': '22418154661',
                                                                       'in_ucast_pkts': '45704735',
                                                                       'links': [       {       'in_nucast_pkts': '2734478',
                                                                                                'in_octets': '22418154661',
                                                                                                'in_ucast_pkts': '45704735',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '1156',
                                                                                                'out_octets': '39568907075',
                                                                                                'out_ucast_pkts': '54240597',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1156',
                                                                       'out_octets': '39568907075',
                                                                       'out_ucast_pkts': '54240597',
                                                                       'poller_hash': 'NzcwN0FEcGVlcmludGZwb24gMzc=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '37',
                                                                                               'links': [       {       'connected_time': '5284909',
                                                                                                                        'fiber_length': 9557,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NzcwN0FEcGVlcnBvbnBvbiAzNw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '201 Conundrum Creek Road',
                                         'poller_hash': 'NzcwN0FE',
                                         'serial_number': '7707AD',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '48:77:46:96:37:70',
                                         'uptime': '5284909'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f8:bc:0e:3d:e5:01'],
                                                                       'id': '39/g1',
                                                                       'in_nucast_pkts': '220123',
                                                                       'in_octets': '57681515449',
                                                                       'in_ucast_pkts': '108831123',
                                                                       'mac_address': '48:77:46:96:37:8e',
                                                                       'mtu': 2000,
                                                                       'name': '39/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2734414',
                                                                       'out_octets': '55669231773',
                                                                       'out_ucast_pkts': '104606883',
                                                                       'poller_hash': 'NzcwN0I3cGVlcmludGYzOS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '39',
                                                                       'in_nucast_pkts': '2734414',
                                                                       'in_octets': '55669231773',
                                                                       'in_ucast_pkts': '104606883',
                                                                       'links': [       {       'in_nucast_pkts': '2734414',
                                                                                                'in_octets': '55669231773',
                                                                                                'in_ucast_pkts': '104606883',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '220123',
                                                                                                'out_octets': '57681515449',
                                                                                                'out_ucast_pkts': '108831123',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '220123',
                                                                       'out_octets': '57681515449',
                                                                       'out_ucast_pkts': '108831123',
                                                                       'poller_hash': 'NzcwN0I3cGVlcmludGZwb24gMzk=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '39',
                                                                                               'links': [       {       'connected_time': '5284896',
                                                                                                                        'fiber_length': 9623,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NzcwN0I3cGVlcnBvbnBvbiAzOQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '251 Conundrum Creek Road',
                                         'poller_hash': 'NzcwN0I3',
                                         'serial_number': '7707B7',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '48:77:46:96:37:8e',
                                         'uptime': '5284896'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd4:6a:91:b8:50:d5'],
                                                                       'id': '40/g1',
                                                                       'in_nucast_pkts': '105015',
                                                                       'in_octets': '491633924991',
                                                                       'in_ucast_pkts': '775972033',
                                                                       'mac_address': '48:77:46:96:38:b1',
                                                                       'mtu': 2000,
                                                                       'name': '40/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2737222',
                                                                       'out_octets': '1334353739000',
                                                                       'out_ucast_pkts': '1174321046',
                                                                       'poller_hash': 'NzcwODE4cGVlcmludGY0MC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '40',
                                                                       'in_nucast_pkts': '2737222',
                                                                       'in_octets': '1334353739000',
                                                                       'in_ucast_pkts': '1174321046',
                                                                       'links': [       {       'in_nucast_pkts': '2737222',
                                                                                                'in_octets': '1334353739000',
                                                                                                'in_ucast_pkts': '1174321046',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '105015',
                                                                                                'out_octets': '491633924991',
                                                                                                'out_ucast_pkts': '775972033',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '105015',
                                                                       'out_octets': '491633924991',
                                                                       'out_ucast_pkts': '775972033',
                                                                       'poller_hash': 'NzcwODE4cGVlcmludGZwb24gNDA=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '40',
                                                                                               'links': [       {       'connected_time': '5286732',
                                                                                                                        'fiber_length': 10628,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NzcwODE4cGVlcnBvbnBvbiA0MA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '828 Conundrum Creek Road',
                                         'poller_hash': 'NzcwODE4',
                                         'serial_number': '770818',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '48:77:46:96:38:b1',
                                         'uptime': '5286732'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:2e:23:92'],
                                                                       'id': '41/g1',
                                                                       'in_nucast_pkts': '24688',
                                                                       'in_octets': '87870368060',
                                                                       'in_ucast_pkts': '203607225',
                                                                       'mac_address': 'd0:76:8f:20:ed:e8',
                                                                       'mtu': 2000,
                                                                       'name': '41/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1526632',
                                                                       'out_octets': '347028852316',
                                                                       'out_ucast_pkts': '299740110',
                                                                       'poller_hash': 'ODdFOEY5cGVlcmludGY0MS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '41',
                                                                       'in_nucast_pkts': '1526632',
                                                                       'in_octets': '347028852316',
                                                                       'in_ucast_pkts': '299740110',
                                                                       'links': [       {       'in_nucast_pkts': '1526632',
                                                                                                'in_octets': '347028852316',
                                                                                                'in_ucast_pkts': '299740110',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '24688',
                                                                                                'out_octets': '87870368060',
                                                                                                'out_ucast_pkts': '203607225',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '24688',
                                                                       'out_octets': '87870368060',
                                                                       'out_ucast_pkts': '203607225',
                                                                       'poller_hash': 'ODdFOEY5cGVlcmludGZwb24gNDE=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '41',
                                                                                               'links': [       {       'connected_time': '2953310',
                                                                                                                        'fiber_length': 9349,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'ODdFOEY5cGVlcnBvbnBvbiA0MQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '249 Conundrum Creed Road',
                                         'poller_hash': 'ODdFOEY5',
                                         'serial_number': '87E8F9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'd0:76:8f:20:ed:e8',
                                         'uptime': '2953310'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '44:65:7f:5d:b8:7d'],
                                                                       'id': '42/g1',
                                                                       'in_nucast_pkts': '10',
                                                                       'in_octets': '61454528867',
                                                                       'in_ucast_pkts': '158311674',
                                                                       'mac_address': 'd0:76:8f:20:ed:43',
                                                                       'mtu': 2000,
                                                                       'name': '42/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2734382',
                                                                       'out_octets': '312103541153',
                                                                       'out_ucast_pkts': '276749832',
                                                                       'poller_hash': 'ODdFOEMycGVlcmludGY0Mi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '42',
                                                                       'in_nucast_pkts': '2734382',
                                                                       'in_octets': '312103541153',
                                                                       'in_ucast_pkts': '276749832',
                                                                       'links': [       {       'in_nucast_pkts': '2734382',
                                                                                                'in_octets': '312103541153',
                                                                                                'in_ucast_pkts': '276749832',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '10',
                                                                                                'out_octets': '61454528867',
                                                                                                'out_ucast_pkts': '158311674',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '10',
                                                                       'out_octets': '61454528867',
                                                                       'out_ucast_pkts': '158311674',
                                                                       'poller_hash': 'ODdFOEMycGVlcmludGZwb24gNDI=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '42',
                                                                                               'links': [       {       'connected_time': '5284951',
                                                                                                                        'fiber_length': 9326,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'ODdFOEMycGVlcnBvbnBvbiA0Mg==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '247 Conundrum Creek Road',
                                         'poller_hash': 'ODdFOEMy',
                                         'serial_number': '87E8C2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'd0:76:8f:20:ed:43',
                                         'uptime': '5284951'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e0:cb:bc:23:e6:80'],
                                                                       'id': '43/g1',
                                                                       'in_nucast_pkts': '899388',
                                                                       'in_octets': '70475402263',
                                                                       'in_ucast_pkts': '389734442',
                                                                       'mac_address': 'd0:76:8f:20:eb:ba',
                                                                       'mtu': 2000,
                                                                       'name': '43/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '7120245',
                                                                       'out_octets': '173534541847',
                                                                       'out_ucast_pkts': '430935022',
                                                                       'poller_hash': 'ODdFODNGcGVlcmludGY0My9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '43',
                                                                       'in_nucast_pkts': '7120245',
                                                                       'in_octets': '173534541847',
                                                                       'in_ucast_pkts': '430935022',
                                                                       'links': [       {       'in_nucast_pkts': '7120245',
                                                                                                'in_octets': '173534541847',
                                                                                                'in_ucast_pkts': '430935022',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '899388',
                                                                                                'out_octets': '70475402263',
                                                                                                'out_ucast_pkts': '389734442',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '899388',
                                                                       'out_octets': '70475402263',
                                                                       'out_ucast_pkts': '389734442',
                                                                       'poller_hash': 'ODdFODNGcGVlcmludGZwb24gNDM=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '43',
                                                                                               'links': [       {       'connected_time': '13646493',
                                                                                                                        'fiber_length': 16245,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'ODdFODNGcGVlcnBvbnBvbiA0Mw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '9555 Castle Creek Road',
                                         'poller_hash': 'ODdFODNG',
                                         'serial_number': '87E83F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'd0:76:8f:20:eb:ba',
                                         'uptime': '13646493'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:47:4c:84'],
                                                                       'id': '44/g1',
                                                                       'in_nucast_pkts': '48535',
                                                                       'in_octets': '814229307310',
                                                                       'in_ucast_pkts': '840518346',
                                                                       'mac_address': 'd0:76:8f:20:ed:3d',
                                                                       'mtu': 2000,
                                                                       'name': '44/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2734312',
                                                                       'out_octets': '575757668258',
                                                                       'out_ucast_pkts': '834901598',
                                                                       'poller_hash': 'ODdFOEMwcGVlcmludGY0NC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '44',
                                                                       'in_nucast_pkts': '2734312',
                                                                       'in_octets': '575757668258',
                                                                       'in_ucast_pkts': '834901598',
                                                                       'links': [       {       'in_nucast_pkts': '2734312',
                                                                                                'in_octets': '575757668258',
                                                                                                'in_ucast_pkts': '834901598',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '48535',
                                                                                                'out_octets': '814229307310',
                                                                                                'out_ucast_pkts': '840518346',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '48535',
                                                                       'out_octets': '814229307310',
                                                                       'out_ucast_pkts': '840518346',
                                                                       'poller_hash': 'ODdFOEMwcGVlcmludGZwb24gNDQ=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '44',
                                                                                               'links': [       {       'connected_time': '5284947',
                                                                                                                        'fiber_length': 16415,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'ODdFOEMwcGVlcnBvbnBvbiA0NA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '9669 Castle Creek Rd',
                                         'poller_hash': 'ODdFOEMw',
                                         'serial_number': '87E8C0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'd0:76:8f:20:ed:3d',
                                         'uptime': '5284947'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f0:1d:2d:28:03:1a'],
                                                                       'id': '45/g1',
                                                                       'in_nucast_pkts': '44047',
                                                                       'in_octets': '103472552064',
                                                                       'in_ucast_pkts': '188354799',
                                                                       'mac_address': 'd0:76:8f:20:ed:f1',
                                                                       'mtu': 2000,
                                                                       'name': '45/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2734382',
                                                                       'out_octets': '387716168648',
                                                                       'out_ucast_pkts': '333342217',
                                                                       'poller_hash': 'ODdFOEZDcGVlcmludGY0NS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '45',
                                                                       'in_nucast_pkts': '2734382',
                                                                       'in_octets': '387716168648',
                                                                       'in_ucast_pkts': '333342217',
                                                                       'links': [       {       'in_nucast_pkts': '2734382',
                                                                                                'in_octets': '387716168648',
                                                                                                'in_ucast_pkts': '333342217',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '44047',
                                                                                                'out_octets': '103472552064',
                                                                                                'out_ucast_pkts': '188354799',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '44047',
                                                                       'out_octets': '103472552064',
                                                                       'out_ucast_pkts': '188354799',
                                                                       'poller_hash': 'ODdFOEZDcGVlcmludGZwb24gNDU=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '45',
                                                                                               'links': [       {       'connected_time': '5284972',
                                                                                                                        'fiber_length': 5675,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'ODdFOEZDcGVlcnBvbnBvbiA0NQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '786 Midnight Mine Road',
                                         'poller_hash': 'ODdFOEZD',
                                         'serial_number': '87E8FC',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'd0:76:8f:20:ed:f1',
                                         'uptime': '5284972'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'a4:13:4e:b2:d7:89'],
                                                                       'id': '46/g1',
                                                                       'in_nucast_pkts': '28',
                                                                       'in_octets': '16657570381',
                                                                       'in_ucast_pkts': '24205522',
                                                                       'mac_address': 'd0:76:8f:20:e1:df',
                                                                       'mtu': 2000,
                                                                       'name': '46/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '536216',
                                                                       'out_octets': '38092635283',
                                                                       'out_ucast_pkts': '38479116',
                                                                       'poller_hash': 'ODdFNEY2cGVlcmludGY0Ni9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '46',
                                                                       'in_nucast_pkts': '536216',
                                                                       'in_octets': '38092635283',
                                                                       'in_ucast_pkts': '38479116',
                                                                       'links': [       {       'in_nucast_pkts': '536216',
                                                                                                'in_octets': '38092635283',
                                                                                                'in_ucast_pkts': '38479116',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '28',
                                                                                                'out_octets': '16657570381',
                                                                                                'out_ucast_pkts': '24205522',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '28',
                                                                       'out_octets': '16657570381',
                                                                       'out_ucast_pkts': '24205522',
                                                                       'poller_hash': 'ODdFNEY2cGVlcmludGZwb24gNDY=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '46',
                                                                                               'links': [       {       'connected_time': '1037046',
                                                                                                                        'fiber_length': 1210,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'ODdFNEY2cGVlcnBvbnBvbiA0Ng==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '918 Castle Creek Road',
                                         'poller_hash': 'ODdFNEY2',
                                         'serial_number': '87E4F6',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'd0:76:8f:20:e1:df',
                                         'uptime': '1037046'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:43:cb:26'],
                                                                       'id': '47/g1',
                                                                       'in_nucast_pkts': '14044',
                                                                       'in_octets': '91752893348',
                                                                       'in_ucast_pkts': '152741186',
                                                                       'mac_address': 'd0:76:8f:20:ed:9d',
                                                                       'mtu': 2000,
                                                                       'name': '47/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '805284',
                                                                       'out_octets': '673963412102',
                                                                       'out_ucast_pkts': '515862812',
                                                                       'poller_hash': 'ODdFOEUwcGVlcmludGY0Ny9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '47',
                                                                       'in_nucast_pkts': '805284',
                                                                       'in_octets': '673963412102',
                                                                       'in_ucast_pkts': '515862812',
                                                                       'links': [       {       'in_nucast_pkts': '805284',
                                                                                                'in_octets': '673963412102',
                                                                                                'in_ucast_pkts': '515862812',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '14044',
                                                                                                'out_octets': '91752893348',
                                                                                                'out_ucast_pkts': '152741186',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '14044',
                                                                       'out_octets': '91752893348',
                                                                       'out_ucast_pkts': '152741186',
                                                                       'poller_hash': 'ODdFOEUwcGVlcmludGZwb24gNDc=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '47',
                                                                                               'links': [       {       'connected_time': '1557644',
                                                                                                                        'fiber_length': 8767,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'ODdFOEUwcGVlcnBvbnBvbiA0Nw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '5190 Castle Creek Road',
                                         'poller_hash': 'ODdFOEUw',
                                         'serial_number': '87E8E0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'd0:76:8f:20:ed:9d',
                                         'uptime': '1557644'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '2c:3f:0b:cc:47:d5'],
                                                                       'id': '49/g1',
                                                                       'in_nucast_pkts': '222609',
                                                                       'in_octets': '74226469056',
                                                                       'in_ucast_pkts': '184298193',
                                                                       'mac_address': 'd0:76:8f:20:ed:8b',
                                                                       'mtu': 2000,
                                                                       'name': '49/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1746792',
                                                                       'out_octets': '350074673282',
                                                                       'out_ucast_pkts': '348447929',
                                                                       'poller_hash': 'ODdFOERBcGVlcmludGY0OS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '49',
                                                                       'in_nucast_pkts': '1746792',
                                                                       'in_octets': '350074673282',
                                                                       'in_ucast_pkts': '348447929',
                                                                       'links': [       {       'in_nucast_pkts': '1746792',
                                                                                                'in_octets': '350074673282',
                                                                                                'in_ucast_pkts': '348447929',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '222609',
                                                                                                'out_octets': '74226469056',
                                                                                                'out_ucast_pkts': '184298193',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '222609',
                                                                       'out_octets': '74226469056',
                                                                       'out_ucast_pkts': '184298193',
                                                                       'poller_hash': 'ODdFOERBcGVlcmludGZwb24gNDk=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '49',
                                                                                               'links': [       {       'connected_time': '3378457',
                                                                                                                        'fiber_length': 11463,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'ODdFOERBcGVlcnBvbnBvbiA0OQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '6770 Castle Creek Rd',
                                         'poller_hash': 'ODdFOERB',
                                         'serial_number': '87E8DA',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'd0:76:8f:20:ed:8b',
                                         'uptime': '3378457'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '50/g1',
                                                                       'in_nucast_pkts': '139',
                                                                       'in_octets': '58510544',
                                                                       'in_ucast_pkts': '682642',
                                                                       'mac_address': '48:77:46:81:3c:74',
                                                                       'mtu': 2000,
                                                                       'name': '50/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '3593299',
                                                                       'out_octets': '432283376',
                                                                       'out_ucast_pkts': '694538',
                                                                       'poller_hash': 'NzU0QTEzcGVlcmludGY1MC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '50/g2',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mac_address': '48:77:46:81:3c:75',
                                                                       'mtu': 2000,
                                                                       'name': '50/g2',
                                                                       'oper_up': False,
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NzU0QTEzcGVlcmludGY1MC9nMg=='},
                                                               {       'admin_up': True,
                                                                       'id': '50/g3',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mac_address': '48:77:46:81:3c:76',
                                                                       'mtu': 2000,
                                                                       'name': '50/g3',
                                                                       'oper_up': False,
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NzU0QTEzcGVlcmludGY1MC9nMw=='},
                                                               {       'admin_up': True,
                                                                       'id': '50/g4',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mac_address': '48:77:46:81:3c:77',
                                                                       'mtu': 2000,
                                                                       'name': '50/g4',
                                                                       'oper_up': False,
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NzU0QTEzcGVlcmludGY1MC9nNA=='},
                                                               {       'admin_up': True,
                                                                       'id': '50',
                                                                       'in_nucast_pkts': '3593299',
                                                                       'in_octets': '432283376',
                                                                       'in_ucast_pkts': '694538',
                                                                       'links': [       {       'in_nucast_pkts': '3593299',
                                                                                                'in_octets': '432283376',
                                                                                                'in_ucast_pkts': '694538',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '139',
                                                                                                'out_octets': '58510544',
                                                                                                'out_ucast_pkts': '682642',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '139',
                                                                       'out_octets': '58510544',
                                                                       'out_ucast_pkts': '682642',
                                                                       'poller_hash': 'NzU0QTEzcGVlcmludGZwb24gNTA=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '50',
                                                                                               'links': [       {       'connected_time': '5284870',
                                                                                                                        'fiber_length': 9650,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NzU0QTEzcGVlcnBvbnBvbiA1MA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '844G-1',
                                         'name': '289 Conundrum Creek Road',
                                         'poller_hash': 'NzU0QTEz',
                                         'serial_number': '754A13',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:81:3c:71',
                                         'uptime': '5284870'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '08:30:6b:37:63:31'],
                                                                       'id': '51/g1',
                                                                       'in_nucast_pkts': '5985469',
                                                                       'in_octets': '182036303663',
                                                                       'in_ucast_pkts': '726100786',
                                                                       'mac_address': '60:db:98:1d:68:42',
                                                                       'mtu': 2000,
                                                                       'name': '51/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '7641516',
                                                                       'out_octets': '2931585917097',
                                                                       'out_ucast_pkts': '2131570502',
                                                                       'poller_hash': 'QTFBQTEzcGVlcmludGY1MS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '51',
                                                                       'in_nucast_pkts': '7641516',
                                                                       'in_octets': '2931585917097',
                                                                       'in_ucast_pkts': '2131570502',
                                                                       'links': [       {       'in_nucast_pkts': '7641516',
                                                                                                'in_octets': '2931585917097',
                                                                                                'in_ucast_pkts': '2131570502',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '5985469',
                                                                                                'out_octets': '182036303663',
                                                                                                'out_ucast_pkts': '726100786',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '5985469',
                                                                       'out_octets': '182036303663',
                                                                       'out_ucast_pkts': '726100786',
                                                                       'poller_hash': 'QTFBQTEzcGVlcmludGZwb24gNTE=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '51',
                                                                                               'links': [       {       'connected_time': '5284356',
                                                                                                                        'fiber_length': 17008,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QTFBQTEzcGVlcnBvbnBvbiA1MQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '10080 Castle Creek Road',
                                         'poller_hash': 'QTFBQTEz',
                                         'serial_number': 'A1AA13',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '60:db:98:1d:68:42',
                                         'uptime': '5284356'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '90:a7:c1:ca:0a:0b'],
                                                                       'id': '52/g1',
                                                                       'in_nucast_pkts': '73',
                                                                       'in_octets': '26084726657',
                                                                       'in_ucast_pkts': '108987981',
                                                                       'mac_address': '60:db:98:1d:7b:ec',
                                                                       'mtu': 2000,
                                                                       'name': '52/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2332653',
                                                                       'out_octets': '566483296474',
                                                                       'out_ucast_pkts': '421537522',
                                                                       'poller_hash': 'QTFCMEExcGVlcmludGY1Mi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '52',
                                                                       'in_nucast_pkts': '2332653',
                                                                       'in_octets': '566483296474',
                                                                       'in_ucast_pkts': '421537522',
                                                                       'links': [       {       'in_nucast_pkts': '2332653',
                                                                                                'in_octets': '566483296474',
                                                                                                'in_ucast_pkts': '421537522',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '73',
                                                                                                'out_octets': '26084726657',
                                                                                                'out_ucast_pkts': '108987981',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '73',
                                                                       'out_octets': '26084726657',
                                                                       'out_ucast_pkts': '108987981',
                                                                       'poller_hash': 'QTFCMEExcGVlcmludGZwb24gNTI=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '52',
                                                                                               'links': [       {       'connected_time': '4508235',
                                                                                                                        'fiber_length': 8865,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QTFCMEExcGVlcnBvbnBvbiA1Mg==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '4360 Castle Creek Road',
                                         'poller_hash': 'QTFCMEEx',
                                         'serial_number': 'A1B0A1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '60:db:98:1d:7b:ec',
                                         'uptime': '4508235'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e0:cb:bc:9d:72:91'],
                                                                       'id': '53/g1',
                                                                       'in_nucast_pkts': '2897238',
                                                                       'in_octets': '157158899219',
                                                                       'in_ucast_pkts': '380823862',
                                                                       'mac_address': '60:db:98:1d:7b:86',
                                                                       'mtu': 2000,
                                                                       'name': '53/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2734297',
                                                                       'out_octets': '1110123197583',
                                                                       'out_ucast_pkts': '967341478',
                                                                       'poller_hash': 'QTFCMDdGcGVlcmludGY1My9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '53',
                                                                       'in_nucast_pkts': '2734297',
                                                                       'in_octets': '1110123197583',
                                                                       'in_ucast_pkts': '967341478',
                                                                       'links': [       {       'in_nucast_pkts': '2734297',
                                                                                                'in_octets': '1110123197583',
                                                                                                'in_ucast_pkts': '967341478',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '2897238',
                                                                                                'out_octets': '157158899219',
                                                                                                'out_ucast_pkts': '380823862',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2897238',
                                                                       'out_octets': '157158899219',
                                                                       'out_ucast_pkts': '380823862',
                                                                       'poller_hash': 'QTFCMDdGcGVlcmludGZwb24gNTM=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '53',
                                                                                               'links': [       {       'connected_time': '5284932',
                                                                                                                        'fiber_length': 5116,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QTFCMDdGcGVlcnBvbnBvbiA1Mw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '302 Midnight Mine',
                                         'poller_hash': 'QTFCMDdG',
                                         'serial_number': 'A1B07F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '60:db:98:1d:7b:86',
                                         'uptime': '5284932'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e6:14:21'],
                                                                       'id': '54/g1',
                                                                       'in_nucast_pkts': '79',
                                                                       'in_octets': '215666796',
                                                                       'in_ucast_pkts': '695167',
                                                                       'mac_address': '60:db:98:1d:2f:4b',
                                                                       'mtu': 2000,
                                                                       'name': '54/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2257',
                                                                       'out_octets': '2032819518',
                                                                       'out_ucast_pkts': '1538463',
                                                                       'poller_hash': 'QTE5NkZFcGVlcmludGY1NC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '54',
                                                                       'in_nucast_pkts': '2257',
                                                                       'in_octets': '2032819518',
                                                                       'in_ucast_pkts': '1538463',
                                                                       'links': [       {       'in_nucast_pkts': '2257',
                                                                                                'in_octets': '2032819518',
                                                                                                'in_ucast_pkts': '1538463',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '79',
                                                                                                'out_octets': '215666796',
                                                                                                'out_ucast_pkts': '695167',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '79',
                                                                       'out_octets': '215666796',
                                                                       'out_ucast_pkts': '695167',
                                                                       'poller_hash': 'QTE5NkZFcGVlcmludGZwb24gNTQ=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '54',
                                                                                               'links': [       {       'connected_time': '4413',
                                                                                                                        'fiber_length': 4761,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QTE5NkZFcGVlcnBvbnBvbiA1NA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '724 N Hayden',
                                         'poller_hash': 'QTE5NkZF',
                                         'serial_number': 'A196FE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '60:db:98:1d:2f:4b',
                                         'uptime': '4413'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e4:38:83:53:d5:a4'],
                                                                       'id': '55/g1',
                                                                       'in_nucast_pkts': '4458532',
                                                                       'in_octets': '85471149613',
                                                                       'in_ucast_pkts': '486824134',
                                                                       'mac_address': '84:d3:43:4f:87:42',
                                                                       'mtu': 2000,
                                                                       'name': '55/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1693362',
                                                                       'out_octets': '5259131350134',
                                                                       'out_ucast_pkts': '3599306268',
                                                                       'poller_hash': 'QzFCN0ExcGVlcmludGY1NS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '55',
                                                                       'in_nucast_pkts': '1693362',
                                                                       'in_octets': '5259131350134',
                                                                       'in_ucast_pkts': '3599306268',
                                                                       'links': [       {       'in_nucast_pkts': '1693362',
                                                                                                'in_octets': '5259131350134',
                                                                                                'in_ucast_pkts': '3599306268',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '4458532',
                                                                                                'out_octets': '85471149613',
                                                                                                'out_ucast_pkts': '486824134',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '4458532',
                                                                       'out_octets': '85471149613',
                                                                       'out_ucast_pkts': '486824134',
                                                                       'poller_hash': 'QzFCN0ExcGVlcmludGZwb24gNTU=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '55',
                                                                                               'links': [       {       'connected_time': '3276843',
                                                                                                                        'fiber_length': 9251,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QzFCN0ExcGVlcnBvbnBvbiA1NQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '5387 Castle Creek Road',
                                         'poller_hash': 'QzFCN0Ex',
                                         'serial_number': 'C1B7A1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '84:d3:43:4f:87:42',
                                         'uptime': '3276843'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e4:38:83:1d:53:01'],
                                                                       'id': '56/g1',
                                                                       'in_nucast_pkts': '6139889',
                                                                       'in_octets': '66803181990',
                                                                       'in_ucast_pkts': '154082391',
                                                                       'mac_address': '84:d3:43:4f:8b:9b',
                                                                       'mtu': 2000,
                                                                       'name': '56/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2331162',
                                                                       'out_octets': '393623627914',
                                                                       'out_ucast_pkts': '340804218',
                                                                       'poller_hash': 'QzFCOTE0cGVlcmludGY1Ni9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '56',
                                                                       'in_nucast_pkts': '2331162',
                                                                       'in_octets': '393623627914',
                                                                       'in_ucast_pkts': '340804218',
                                                                       'links': [       {       'in_nucast_pkts': '2331162',
                                                                                                'in_octets': '393623627914',
                                                                                                'in_ucast_pkts': '340804218',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '6139889',
                                                                                                'out_octets': '66803181990',
                                                                                                'out_ucast_pkts': '154082391',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '6139889',
                                                                       'out_octets': '66803181990',
                                                                       'out_ucast_pkts': '154082391',
                                                                       'poller_hash': 'QzFCOTE0cGVlcmludGZwb24gNTY=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '56',
                                                                                               'links': [       {       'connected_time': '4505786',
                                                                                                                        'fiber_length': 9858,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QzFCOTE0cGVlcnBvbnBvbiA1Ng==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '255 Conundrum Creek Rd.',
                                         'poller_hash': 'QzFCOTE0',
                                         'serial_number': 'C1B914',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '84:d3:43:4f:8b:9b',
                                         'uptime': '4505786'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd4:6a:91:b0:9d:cd'],
                                                                       'id': '58/g1',
                                                                       'in_nucast_pkts': '581',
                                                                       'in_octets': '192478347818',
                                                                       'in_ucast_pkts': '252204314',
                                                                       'mac_address': '84:d3:43:9f:33:f0',
                                                                       'mtu': 2000,
                                                                       'name': '58/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2734380',
                                                                       'out_octets': '534705195964',
                                                                       'out_ucast_pkts': '451004343',
                                                                       'poller_hash': 'RDlDNTM4cGVlcmludGY1OC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '58',
                                                                       'in_nucast_pkts': '2734380',
                                                                       'in_octets': '534705195964',
                                                                       'in_ucast_pkts': '451004343',
                                                                       'links': [       {       'in_nucast_pkts': '2734380',
                                                                                                'in_octets': '534705195964',
                                                                                                'in_ucast_pkts': '451004343',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '581',
                                                                                                'out_octets': '192478347818',
                                                                                                'out_ucast_pkts': '252204314',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '581',
                                                                       'out_octets': '192478347818',
                                                                       'out_ucast_pkts': '252204314',
                                                                       'poller_hash': 'RDlDNTM4cGVlcmludGZwb24gNTg=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '58',
                                                                                               'links': [       {       'connected_time': '5284918',
                                                                                                                        'fiber_length': 5495,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'RDlDNTM4cGVlcnBvbnBvbiA1OA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '1030 North Hayden Road',
                                         'poller_hash': 'RDlDNTM4',
                                         'serial_number': 'D9C538',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '84:d3:43:9f:33:f0',
                                         'uptime': '5284918'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '18:c2:41:11:1a:41'],
                                                                       'id': '59/g1',
                                                                       'in_nucast_pkts': '5723',
                                                                       'in_octets': '759715561723',
                                                                       'in_ucast_pkts': '1334369941',
                                                                       'mac_address': '60:db:98:83:b4:db',
                                                                       'mtu': 2000,
                                                                       'name': '59/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '10522629',
                                                                       'out_octets': '2376277071923',
                                                                       'out_ucast_pkts': '2232565667',
                                                                       'poller_hash': 'QjJFOTE3cGVlcmludGY1OS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '59',
                                                                       'in_nucast_pkts': '10522629',
                                                                       'in_octets': '2376277071923',
                                                                       'in_ucast_pkts': '2232565667',
                                                                       'links': [       {       'in_nucast_pkts': '10522629',
                                                                                                'in_octets': '2376277071923',
                                                                                                'in_ucast_pkts': '2232565667',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '5723',
                                                                                                'out_octets': '759715561723',
                                                                                                'out_ucast_pkts': '1334369941',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '5723',
                                                                       'out_octets': '759715561723',
                                                                       'out_ucast_pkts': '1334369941',
                                                                       'poller_hash': 'QjJFOTE3cGVlcmludGZwb24gNTk=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '59',
                                                                                               'links': [       {       'connected_time': '19844944',
                                                                                                                        'fiber_length': 4930,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QjJFOTE3cGVlcnBvbnBvbiA1OQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '3224 Castle Creek Road',
                                         'poller_hash': 'QjJFOTE3',
                                         'serial_number': 'B2E917',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '60:db:98:83:b4:db',
                                         'uptime': '19844944'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd4:3f:32:7b:d0:81'],
                                                                       'id': '60/g1',
                                                                       'in_nucast_pkts': '220078',
                                                                       'in_octets': '46083847434',
                                                                       'in_ucast_pkts': '65775745',
                                                                       'mac_address': '60:db:98:88:4b:c9',
                                                                       'mtu': 2000,
                                                                       'name': '60/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2734394',
                                                                       'out_octets': '76741141824',
                                                                       'out_ucast_pkts': '82008684',
                                                                       'poller_hash': 'QjNBRjUzcGVlcmludGY2MC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '60',
                                                                       'in_nucast_pkts': '2734394',
                                                                       'in_octets': '76741141824',
                                                                       'in_ucast_pkts': '82008684',
                                                                       'links': [       {       'in_nucast_pkts': '2734394',
                                                                                                'in_octets': '76741141824',
                                                                                                'in_ucast_pkts': '82008684',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '220078',
                                                                                                'out_octets': '46083847434',
                                                                                                'out_ucast_pkts': '65775745',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzQ='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '220078',
                                                                       'out_octets': '46083847434',
                                                                       'out_ucast_pkts': '65775745',
                                                                       'poller_hash': 'QjNBRjUzcGVlcmludGZwb24gNjA=',
                                                                       'pons': [       {       'description': 'pon '
                                                                                                              '1',
                                                                                               'id': '60',
                                                                                               'links': [       {       'connected_time': '5284910',
                                                                                                                        'fiber_length': 16352,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzQ=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QjNBRjUzcGVlcnBvbnBvbiA2MA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '9676 Castle Creek Rd.',
                                         'poller_hash': 'QjNBRjUz',
                                         'serial_number': 'B3AF53',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '60:db:98:88:4b:c9',
                                         'uptime': '5284910'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_calix_exa_E7_2_EXA_3_4_30_40_01(self):
        obj = self.run_data("calix.exa.E7-2 (EXA).3.4.30.40.01")
        exp_info = {
                'model': 'E7-2 (EXA)',
                'sta_count': 346,
                'sw_version': '3.4.30.40',
                'vendor': 'Calix'
        }
        exp_stats = {
         'serial_number': '71702970268', 'system_mac_address': None
        }
        exp_sta_stats = {
                '00:06:31:06:38:37': {       'dev_macs': ['78:da:6e:46:5e:e7'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:06:38:37',
                                             'name': 'ont 185',
                                             'serial_number': '7FF5',
                                             'system_mac_address': None},
                '00:06:31:08:4a:08': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4a:08',
                                             'name': '93 Elma Centre',
                                             'serial_number': 'F0F8',
                                             'system_mac_address': None},
                '00:06:31:08:4a:56': {       'dev_macs': ['c0:c9:e3:ab:9a:c5'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4a:56',
                                             'name': '140 Monument Rd',
                                             'serial_number': 'F1F8',
                                             'system_mac_address': None},
                '00:06:31:08:4b:82': {       'dev_macs': ['34:98:b5:6d:56:26'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4b:82',
                                             'name': '157 Main St. Atwood',
                                             'serial_number': 'F23A',
                                             'system_mac_address': None},
                '00:06:31:08:4c:8d': {       'dev_macs': ['ac:15:a2:4e:e8:e5'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4c:8d',
                                             'name': '108 Blair St. Atwood',
                                             'serial_number': 'F23C',
                                             'system_mac_address': None},
                '00:06:31:08:de:8d': {       'dev_macs': ['e4:6f:13:45:27:eb'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:de:8d',
                                             'name': '281 Main St, Atwood',
                                             'serial_number': '153C3',
                                             'system_mac_address': None},
                '00:06:31:08:e2:95': {       'dev_macs': ['04:42:1a:10:3c:70'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:e2:95',
                                             'name': '7319 ROAD 164',
                                             'serial_number': '15452',
                                             'system_mac_address': None},
                '00:06:31:08:e2:e6': {       'dev_macs': ['b0:be:76:94:41:25'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:e2:e6',
                                             'name': '231 Main St. Atwood',
                                             'serial_number': '1545D',
                                             'system_mac_address': None},
                '00:06:31:11:f0:4e': {       'dev_macs': ['10:be:f5:d3:4f:4b'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:11:f0:4e',
                                             'name': '210B Main St. Atwood',
                                             'serial_number': '1303D',
                                             'system_mac_address': None},
                '00:06:31:11:f6:cc': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:11:f6:cc',
                                             'name': '185 Main St. Atwood',
                                             'serial_number': '13538',
                                             'system_mac_address': None},
                '00:06:31:11:f7:7d': {       'dev_macs': ['c0:8c:60:0f:dd:00'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:11:f7:7d',
                                             'name': '218A Main St. Atwood',
                                             'serial_number': '13548',
                                             'system_mac_address': None},
                '00:06:31:15:a1:e0': {       'dev_macs': ['14:59:c0:b8:c4:11'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a1:e0',
                                             'name': '171 Main St. Atwood',
                                             'serial_number': '3CC08',
                                             'system_mac_address': None},
                '00:06:31:15:a8:61': {       'dev_macs': [       '00:23:69:a6:8c:09',
                                                                 '00:03:e6:5e:77:76',
                                                                 '00:03:e6:5e:77:e6'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a8:61',
                                             'name': '138 King St. Atwood',
                                             'serial_number': '3CFA8',
                                             'system_mac_address': None},
                '00:06:31:15:a9:1e': {       'dev_macs': ['c8:d3:a3:5c:39:af'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:1e',
                                             'name': '127 Main St. Atwood',
                                             'serial_number': '3CF4A',
                                             'system_mac_address': None},
                '00:06:31:15:a9:2d': {       'dev_macs': [       '00:03:e6:d8:e4:5c',
                                                                 '04:7c:16:e8:46:88'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:2d',
                                             'name': '151 Queen St. Atwood',
                                             'serial_number': '3D0FA',
                                             'system_mac_address': None},
                '00:06:31:15:a9:32': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:32',
                                             'name': '7434 ROAD 164',
                                             'serial_number': '3D0FC',
                                             'system_mac_address': None},
                '00:06:31:15:a9:37': {       'dev_macs': ['10:62:eb:9b:c8:3b'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:37',
                                             'name': '7418 Rd. 164 Atwood',
                                             'serial_number': '3D0F2',
                                             'system_mac_address': None},
                '00:06:31:15:a9:46': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:46',
                                             'name': '7272 Rd. 164 Atwood',
                                             'serial_number': '3D0F4',
                                             'system_mac_address': None},
                '00:06:31:15:a9:64': {       'dev_macs': ['28:87:ba:bd:b8:55'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:64',
                                             'name': '7480 Rd. 164 Atwood',
                                             'serial_number': '3D0EF',
                                             'system_mac_address': None},
                '00:06:31:18:c1:01': {       'dev_macs': ['70:3a:cb:43:d6:35'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:18:c1:01',
                                             'name': '184 Main St. Atwood',
                                             'serial_number': '3CF4E',
                                             'system_mac_address': None},
                '00:06:31:18:c1:ce': {       'dev_macs': [       '24:4b:fe:0a:f8:e8',
                                                                 '00:03:e6:31:45:e6'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:18:c1:ce',
                                             'name': '136 King St. Atwood',
                                             'serial_number': '3CF9D',
                                             'system_mac_address': None},
                '00:06:31:18:c2:ff': {       'dev_macs': ['c0:06:c3:07:a6:a9'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:18:c2:ff',
                                             'name': '236 Main St. Atwood',
                                             'serial_number': '3CFA0',
                                             'system_mac_address': None},
                '00:06:31:1e:52:10': {       'dev_macs': [       '98:fc:11:45:a0:e9',
                                                                 '00:03:e6:30:ec:d0',
                                                                 '00:03:e6:60:30:f8'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1e:52:10',
                                             'name': '7428 Road 164',
                                             'serial_number': '3D0E9',
                                             'system_mac_address': None},
                '00:06:31:1e:56:75': {       'dev_macs': ['94:56:41:2b:48:10'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1e:56:75',
                                             'name': '7412 Rd. 164 Atwood',
                                             'serial_number': '3D0F6',
                                             'system_mac_address': None},
                '00:06:31:1f:07:23': {       'dev_macs': ['c0:a0:bb:c6:c7:67'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:07:23',
                                             'name': '7470 Rd. 164 Atwood',
                                             'serial_number': '41522',
                                             'system_mac_address': None},
                '00:06:31:1f:07:55': {       'dev_macs': ['c8:d3:a3:66:49:00'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:07:55',
                                             'name': '171 Monument Rd. Atwood',
                                             'serial_number': '41530',
                                             'system_mac_address': None},
                '00:06:31:1f:07:82': {       'dev_macs': ['f0:2f:74:7a:d2:d0'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:07:82',
                                             'name': '7333 Road 164',
                                             'serial_number': '41585',
                                             'system_mac_address': None},
                '00:06:31:1f:08:4f': {       'dev_macs': ['78:98:e8:4a:f8:3a'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:08:4f',
                                             'name': '130 Monument Road',
                                             'serial_number': '41591',
                                             'system_mac_address': None},
                '00:06:31:1f:08:d6': {       'dev_macs': ['00:03:e6:a5:6b:b8'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:08:d6',
                                             'name': '243 Main St. Atwood',
                                             'serial_number': '41549',
                                             'system_mac_address': None},
                '00:06:31:20:00:37': {       'dev_macs': ['b8:38:61:b6:0b:fa'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:00:37',
                                             'name': '246 Queen St. Atwood',
                                             'serial_number': '4157E',
                                             'system_mac_address': None},
                '00:06:31:20:00:64': {       'dev_macs': [       '34:97:f6:a7:2c:b8',
                                                                 '00:03:e6:5e:94:fa',
                                                                 '00:03:e6:5e:9f:1e'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:00:64',
                                             'name': '139 Queen St. Atwood',
                                             'serial_number': '41535',
                                             'system_mac_address': None},
                '00:06:31:20:00:69': {       'dev_macs': ['24:4b:fe:ad:ce:00'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:00:69',
                                             'name': '129 Main St. Atwood',
                                             'serial_number': '415B0',
                                             'system_mac_address': None},
                '00:06:31:20:01:45': {       'dev_macs': [       '00:1a:79:45:5f:4d',
                                                                 '00:1a:79:6c:0b:24',
                                                                 '08:bf:b8:b5:1f:f8'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:45',
                                             'name': '247 Queen St. Atwood',
                                             'serial_number': '415AB',
                                             'system_mac_address': None},
                '00:06:31:20:01:5e': {       'dev_macs': [       '60:38:e0:72:6a:53',
                                                                 '00:03:e6:65:05:e4',
                                                                 '00:03:e6:6b:b6:8c'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:5e',
                                             'name': '7475 Rd. 164 Atwood',
                                             'serial_number': '4153F',
                                             'system_mac_address': None},
                '00:06:31:20:01:6d': {       'dev_macs': [       '00:97:f6:d0:2f:0a',
                                                                 '00:03:e6:5e:77:f0',
                                                                 '00:03:e6:5e:78:56'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:6d',
                                             'name': '218 King St. Atwood',
                                             'serial_number': '418B8',
                                             'system_mac_address': None},
                '00:06:31:20:01:81': {       'dev_macs': [       '00:22:4d:6a:5a:0b',
                                                                 '00:5f:67:a4:74:95'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:81',
                                             'name': '190 KING STREET ATWOOD',
                                             'serial_number': '418B7',
                                             'system_mac_address': None},
                '00:06:31:20:01:b8': {       'dev_macs': ['d0:17:c2:5a:01:48'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:b8',
                                             'name': '220 Queen St.',
                                             'serial_number': '4152F',
                                             'system_mac_address': None},
                '00:06:31:20:02:3a': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:02:3a',
                                             'name': '215 KING STREET ATWOOD',
                                             'serial_number': '4153C',
                                             'system_mac_address': None},
                '00:06:31:20:02:5d': {       'dev_macs': ['0c:0e:76:e9:25:1a'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:02:5d',
                                             'name': '128 King St. Atwood',
                                             'serial_number': '415FE',
                                             'system_mac_address': None},
                '00:06:31:20:a1:a2': {       'dev_macs': [       '48:77:46:9a:61:95',
                                                                 '00:03:e6:db:52:24',
                                                                 '60:db:98:09:3a:86',
                                                                 'b8:94:70:f3:e0:78',
                                                                 '0c:0e:76:4a:a6:ad',
                                                                 '40:9b:cd:2c:e9:b3'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:a1:a2',
                                             'name': '7429 ROAD 164',
                                             'serial_number': '49340',
                                             'system_mac_address': None},
                '00:06:31:34:38:18': {       'dev_macs': ['c4:e9:0a:4e:e9:d4'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:34:38:18',
                                             'name': '87 Baker St. Atwood',
                                             'serial_number': '757AC',
                                             'system_mac_address': None},
                '00:06:31:34:38:27': {       'dev_macs': ['28:87:ba:bd:a2:69'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:34:38:27',
                                             'name': '153 Queen St. Atwood',
                                             'serial_number': '757BB',
                                             'system_mac_address': None},
                '00:06:31:34:38:28': {       'dev_macs': ['0c:b6:d2:50:99:de'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:34:38:28',
                                             'name': '167 Fisher Ave',
                                             'serial_number': '757BC',
                                             'system_mac_address': None},
                '00:06:31:3c:5f:10': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:5f:10',
                                             'name': '192 WOODVIEW ATWOOD',
                                             'serial_number': '7FE2A',
                                             'system_mac_address': None},
                '00:06:31:3c:5f:6a': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:5f:6a',
                                             'name': '133 Bowman Ct',
                                             'serial_number': '7FE84',
                                             'system_mac_address': None},
                '00:06:31:3c:cc:a6': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:cc:a6',
                                             'name': '137 King St. Atwood',
                                             'serial_number': '86BBE',
                                             'system_mac_address': None},
                '00:06:31:3c:d5:37': {       'dev_macs': ['60:45:cb:66:ac:68'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:d5:37',
                                             'name': '169 Fisher Ave. Atwood',
                                             'serial_number': '8744F',
                                             'system_mac_address': None},
                '00:06:31:3c:ea:9c': {       'dev_macs': ['ec:4f:82:a4:90:bc'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:ea:9c',
                                             'name': '7462 ROAD 164',
                                             'serial_number': '889B4',
                                             'system_mac_address': None},
                '00:06:31:47:4b:6c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:47:4b:6c',
                                             'name': '278 QUEEN STREET ATWOOD',
                                             'serial_number': '8A280',
                                             'system_mac_address': None},
                '00:06:31:57:b0:79': {       'dev_macs': ['e0:46:ee:35:a4:40'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:57:b0:79',
                                             'name': '247 Woodview Dr. Atwood',
                                             'serial_number': 'A9FB9',
                                             'system_mac_address': None},
                '00:06:31:5f:60:b4': {       'dev_macs': [       'ec:4f:82:ac:eb:ec',
                                                                 '00:03:e6:a2:15:b8',
                                                                 '00:03:e6:a4:ce:27'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:60:b4',
                                             'name': '250 Woodview Atwood',
                                             'serial_number': 'C4FF4',
                                             'system_mac_address': None},
                '00:06:31:5f:60:d0': {       'dev_macs': ['64:29:43:71:1f:bc'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:60:d0',
                                             'name': '128 James St. Atwood',
                                             'serial_number': 'C5010',
                                             'system_mac_address': None},
                '00:06:31:5f:68:8d': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:68:8d',
                                             'name': '136 Main St. Atwood',
                                             'serial_number': 'C57CD',
                                             'system_mac_address': None},
                '00:06:31:5f:69:10': {       'dev_macs': ['d0:76:8f:02:f3:7a'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:69:10',
                                             'name': '194 Main St. Atwood (Upper)',
                                             'serial_number': 'C5850',
                                             'system_mac_address': None},
                '00:06:31:5f:69:2b': {       'dev_macs': ['84:d3:43:6d:ec:45'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:69:2b',
                                             'name': '176 Main St. Atwood',
                                             'serial_number': 'C586B',
                                             'system_mac_address': None},
                '00:06:31:5f:d1:76': {       'dev_macs': ['a0:36:bc:15:e3:08'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:d1:76',
                                             'name': '225 Queen St',
                                             'serial_number': 'CC0B6',
                                             'system_mac_address': None},
                '00:06:31:6f:c4:65': {       'dev_macs': ['c8:e3:06:44:27:20'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:6f:c4:65',
                                             'name': '211 King St. Atwood',
                                             'serial_number': 'F23A5',
                                             'system_mac_address': None},
                '00:06:31:90:39:05': {       'dev_macs': ['cc:be:59:2d:a9:3a'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:39:05',
                                             'name': '207 KING STREET ATWOOD',
                                             'serial_number': '124845',
                                             'system_mac_address': None},
                '00:06:31:90:f0:9d': {       'dev_macs': ['ec:4f:82:2d:78:46'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f0:9d',
                                             'name': '152 Queen St. Atwood',
                                             'serial_number': '12FFDD',
                                             'system_mac_address': None},
                '00:06:31:90:f0:ae': {       'dev_macs': ['28:87:ba:87:1b:b3'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f0:ae',
                                             'name': '134 BOWMAN CT',
                                             'serial_number': '12FFEE',
                                             'system_mac_address': None},
                '00:06:31:90:f1:1f': {       'dev_macs': [       'd0:76:8f:91:11:92',
                                                                 '5c:0f:fb:17:6f:a5'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:1f',
                                             'name': '101 PARKVIEW CR',
                                             'serial_number': '13005F',
                                             'system_mac_address': None},
                '00:06:31:90:f1:4b': {       'dev_macs': ['84:d3:43:0f:62:41'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:4b',
                                             'name': '184 King St. Atwood',
                                             'serial_number': '13008B',
                                             'system_mac_address': None},
                '00:06:31:90:f1:4d': {       'dev_macs': [       '04:92:26:66:10:dc',
                                                                 '28:87:ba:bd:b9:21',
                                                                 '3c:37:86:90:9f:42'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:4d',
                                             'name': '170 John St. Atwood',
                                             'serial_number': '13008D',
                                             'system_mac_address': None},
                '00:06:31:90:f1:5a': {       'dev_macs': ['00:5f:67:f1:36:8b'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:5a',
                                             'name': '159 Main St. Atwood',
                                             'serial_number': '13009A',
                                             'system_mac_address': None},
                '00:06:31:b7:29:e8': {       'dev_macs': [       'bc:22:28:af:2f:0b',
                                                                 '6c:5a:b0:21:bd:b6'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:b7:29:e8',
                                             'name': '200B Main St. Atwood',
                                             'serial_number': '161021',
                                             'system_mac_address': None},
                '00:06:31:b7:5c:3e': {       'dev_macs': ['e4:c3:2a:85:66:41'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:b7:5c:3e',
                                             'name': '201 Ellen St. Atwood',
                                             'serial_number': '164277',
                                             'system_mac_address': None},
                '00:06:31:b7:5c:48': {       'dev_macs': ['70:4f:57:be:53:1c'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:b7:5c:48',
                                             'name': '136 Queen St. Atwood',
                                             'serial_number': '164281',
                                             'system_mac_address': None},
                '00:06:31:dd:56:87': {       'dev_macs': ['f8:e9:03:bb:4d:c5'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:dd:56:87',
                                             'name': '145 King St. Atwood',
                                             'serial_number': '175E66',
                                             'system_mac_address': None},
                '00:06:31:dd:56:bf': {       'dev_macs': ['d0:76:8f:91:d4:6f'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:dd:56:bf',
                                             'name': '96 ARTHUR STREET EAST ATWOOD',
                                             'serial_number': '175E6D',
                                             'system_mac_address': None},
                '00:06:31:dd:73:d7': {       'dev_macs': ['d0:76:8f:91:d3:9e'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:dd:73:d7',
                                             'name': '209 QUEEN STREET ATWOOD',
                                             'serial_number': '176210',
                                             'system_mac_address': None},
                '00:06:31:e3:f9:63': {       'dev_macs': ['60:db:98:57:b5:0e'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:f9:63',
                                             'name': '123 Queen St. Atwood',
                                             'serial_number': '1999C5',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:43': {       'dev_macs': ['f8:1a:2b:04:bc:e1'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:43',
                                             'name': '141&143 John St. Atwood',
                                             'serial_number': '1999E1',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:53': {       'dev_macs': ['cc:be:59:2d:a8:fb'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:53',
                                             'name': '7422 Road 164',
                                             'serial_number': '1999E3',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:83': {       'dev_macs': ['14:91:82:c1:9e:b6'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:83',
                                             'name': '220B Main St. Atwood',
                                             'serial_number': '1999E9',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:eb': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:eb',
                                             'name': '168 John St. Atwood',
                                             'serial_number': '1999F6',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:f3': {       'dev_macs': ['0c:b6:d2:3f:42:f7'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:f3',
                                             'name': '209 King St. Atwood',
                                             'serial_number': '1999F7',
                                             'system_mac_address': None},
                '00:06:31:e3:fb:3b': {       'dev_macs': ['5c:e9:31:72:5c:41'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fb:3b',
                                             'name': '266 Main St. Atwood',
                                             'serial_number': '199A00',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:13': {       'dev_macs': [       '60:38:e0:12:de:ad',
                                                                 '00:03:e6:a2:74:84'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:13',
                                             'name': '203 Main St. Atwood',
                                             'serial_number': '199A1B',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:63': {       'dev_macs': ['44:65:7f:89:0f:54'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:63',
                                             'name': '190 Main St. Atwood',
                                             'serial_number': '199A25',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:a3': {       'dev_macs': ['c8:f7:50:64:96:52'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:a3',
                                             'name': '141 Arthur St. Atwood',
                                             'serial_number': '199A2D',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:c3': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:c3',
                                             'name': '7433 Road 164',
                                             'serial_number': '199A31',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:cb': {       'dev_macs': ['08:62:66:9b:79:ac'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:cb',
                                             'name': '132 FISHER AV',
                                             'serial_number': '199A32',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:eb': {       'dev_macs': ['60:db:98:08:f2:b9'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:eb',
                                             'name': '7442 Rd. 164 Atwood',
                                             'serial_number': '199A36',
                                             'system_mac_address': None},
                '00:06:31:e3:fd:03': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fd:03',
                                             'name': '177 Main St. Atwood',
                                             'serial_number': '199A39',
                                             'system_mac_address': None},
                '00:06:31:ff:48:34': {       'dev_macs': ['08:b4:b1:e6:44:f5'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:ff:48:34',
                                             'name': '163 Queen St. Atwood',
                                             'serial_number': '1C4DA9',
                                             'system_mac_address': None},
                '04:bc:9f:00:17:d9': {       'dev_macs': [       '04:a1:51:cd:4a:03',
                                                                 'd0:76:58:e0:09:76'],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:00:17:d9',
                                             'name': '161 John St. Atwood',
                                             'serial_number': 'EBC2EE',
                                             'system_mac_address': None},
                '04:bc:9f:5c:08:21': {       'dev_macs': ['b8:94:70:f3:e8:55'],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:08:21',
                                             'name': '260 QUEEN STREET ATWOOD',
                                             'serial_number': '1274784',
                                             'system_mac_address': None},
                '04:bc:9f:5c:19:71': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:19:71',
                                             'name': '252 MAIN ST ATWOOD',
                                             'serial_number': '12749AE',
                                             'system_mac_address': None},
                '04:bc:9f:5c:1a:89': {       'dev_macs': ['b8:94:70:f3:df:de'],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:1a:89',
                                             'name': '192 KING STREET ATWOOD',
                                             'serial_number': '12749D1',
                                             'system_mac_address': None},
                '04:bc:9f:5c:1b:19': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:1b:19',
                                             'name': '169 MAIN STREET',
                                             'serial_number': '12749E3',
                                             'system_mac_address': None},
                '04:bc:9f:5c:1d:81': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:1d:81',
                                             'name': '302 WOODVIEW DR ATWOOD',
                                             'serial_number': '1274A30',
                                             'system_mac_address': None},
                '04:bc:9f:5c:1e:19': {       'dev_macs': ['b8:94:70:f3:e9:05'],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:1e:19',
                                             'name': '260 MAIN STREET ATWOOD',
                                             'serial_number': '1274A43',
                                             'system_mac_address': None},
                '04:bc:9f:5c:1e:b9': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:1e:b9',
                                             'name': '7335 ROAD 164',
                                             'serial_number': '1274A57',
                                             'system_mac_address': None},
                '04:bc:9f:5c:1f:51': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:1f:51',
                                             'name': '219 QUEEN STREET ATWOOD',
                                             'serial_number': '1274A6A',
                                             'system_mac_address': None},
                '04:bc:9f:5c:21:31': {       'dev_macs': [       '44:65:7f:88:46:a8',
                                                                 '00:03:e6:f9:fa:e6'],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:21:31',
                                             'name': '183 KING STREET',
                                             'serial_number': '1274AA6',
                                             'system_mac_address': None},
                '04:bc:9f:5c:3f:a1': {       'dev_macs': [       'b8:94:70:f3:e8:13',
                                                                 '5c:0f:fb:37:46:30'],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:3f:a1',
                                             'name': '276 QUEEN STREET ATWOOD',
                                             'serial_number': '1274E74',
                                             'system_mac_address': None},
                '04:bc:9f:5c:52:99': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:52:99',
                                             'name': '185 ELLEN STREET',
                                             'serial_number': '12750D3',
                                             'system_mac_address': None},
                '04:bc:9f:5c:58:61': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:58:61',
                                             'name': '156 JAMES STREET ATWOOD',
                                             'serial_number': '127518C',
                                             'system_mac_address': None},
                '44:65:7f:33:20:d4': {       'dev_macs': ['c4:b3:01:da:29:df'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:20:d4',
                                             'name': '279 McCourt Pl Atwood',
                                             'serial_number': '640AE4',
                                             'system_mac_address': None},
                '44:65:7f:33:20:e8': {       'dev_macs': ['60:db:98:09:3c:d8'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:20:e8',
                                             'name': '270 MCCOURT PL',
                                             'serial_number': '640AED',
                                             'system_mac_address': None},
                '44:65:7f:33:21:6e': {       'dev_macs': ['44:65:7f:88:d1:23'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:21:6e',
                                             'name': '277 McCourt Pl Atwood',
                                             'serial_number': '640B2F',
                                             'system_mac_address': None},
                '44:65:7f:33:21:ae': {       'dev_macs': ['44:65:7f:89:0c:d5'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:21:ae',
                                             'name': '116B Monument Rd Atwood',
                                             'serial_number': '640B4F',
                                             'system_mac_address': None},
                '44:65:7f:7b:d3:fa': {       'dev_macs': ['d0:76:8f:02:ee:f7'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d3:fa',
                                             'name': '152 MAIN STREET ATWOOD',
                                             'serial_number': '5A6B99',
                                             'system_mac_address': None},
                '44:65:7f:7b:d6:2b': {       'dev_macs': ['a8:5e:45:da:7a:cc'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d6:2b',
                                             'name': '130 JAMES STREET ATWOOD',
                                             'serial_number': '5A6C54',
                                             'system_mac_address': None},
                '44:65:7f:7b:d6:e5': {       'dev_macs': ['d0:76:8f:02:f2:04'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d6:e5',
                                             'name': '182 QUEEN STREET ATWOOD',
                                             'serial_number': '5A6C92',
                                             'system_mac_address': None},
                '44:65:7f:7b:d7:15': {       'dev_macs': ['60:db:98:09:3a:02'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d7:15',
                                             'name': '278 MCCOURT PL',
                                             'serial_number': '5A6CA2',
                                             'system_mac_address': None},
                '48:77:46:07:b2:49': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:07:b2:49',
                                             'name': '242 Main St. Atwood',
                                             'serial_number': '6AC2C7',
                                             'system_mac_address': None},
                '48:77:46:08:95:89': {       'dev_macs': [       'cc:be:59:c3:46:af',
                                                                 '00:03:e6:db:51:ce',
                                                                 '00:03:e6:dd:43:e8'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:08:95:89',
                                             'name': '7416 Rd. 164 Atwood',
                                             'serial_number': '6DBC98',
                                             'system_mac_address': None},
                '48:77:46:3a:58:0a': {       'dev_macs': ['68:ff:7b:33:bb:d5'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:58:0a',
                                             'name': '166 Queen St. Atwood',
                                             'serial_number': '721D1C',
                                             'system_mac_address': None},
                '48:77:46:3a:71:12': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:71:12',
                                             'name': '7616 Rd 164 Atwood',
                                             'serial_number': '72203D',
                                             'system_mac_address': None},
                '48:77:46:3a:71:32': {       'dev_macs': ['44:65:7f:88:45:88'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:71:32',
                                             'name': '210 King St. Atwood',
                                             'serial_number': '722041',
                                             'system_mac_address': None},
                '48:77:46:3a:72:52': {       'dev_macs': ['ec:4f:82:2c:6f:95'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:72:52',
                                             'name': '133 Main St Atwood',
                                             'serial_number': '722065',
                                             'system_mac_address': None},
                '48:77:46:3a:7f:c2': {       'dev_macs': ['60:db:98:09:1e:ae'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:7f:c2',
                                             'name': '288 Woodview Dr. Atwood',
                                             'serial_number': '722213',
                                             'system_mac_address': None},
                '48:77:46:3b:21:9a': {       'dev_macs': ['ec:4f:82:2d:6c:25'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3b:21:9a',
                                             'name': '186 Queen St. Atwood',
                                             'serial_number': '72364E',
                                             'system_mac_address': None},
                '48:77:46:3b:3f:aa': {       'dev_macs': ['d0:76:8f:91:4f:93'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3b:3f:aa',
                                             'name': '84 PARKVIEW CR',
                                             'serial_number': '723A10',
                                             'system_mac_address': None},
                '48:77:46:8c:12:34': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:8c:12:34',
                                             'name': '197 Ellen St. Atwood',
                                             'serial_number': '76ACE8',
                                             'system_mac_address': None},
                '48:77:46:a2:1b:1c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a2:1b:1c',
                                             'name': '7482 Rd. 164 Atwood',
                                             'serial_number': '71A492',
                                             'system_mac_address': None},
                '48:77:46:a2:1d:64': {       'dev_macs': ['60:db:98:09:38:b8'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a2:1d:64',
                                             'name': '86 BAKER ST',
                                             'serial_number': '71A4DB',
                                             'system_mac_address': None},
                '48:77:46:a3:8d:b4': {       'dev_macs': ['60:db:98:09:37:2c'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:8d:b4',
                                             'name': '7474 Rd. 164 Atwood',
                                             'serial_number': '71D2E5',
                                             'system_mac_address': None},
                '48:77:46:a3:b6:dc': {       'dev_macs': ['c8:7f:54:b6:58:a8'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:b6:dc',
                                             'name': '197 Main St. Atwood',
                                             'serial_number': '71D80A',
                                             'system_mac_address': None},
                '48:77:46:a3:bb:44': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:bb:44',
                                             'name': '999-100-3053',
                                             'serial_number': '71D897',
                                             'system_mac_address': None},
                '48:77:46:a3:bb:8c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:bb:8c',
                                             'name': '216B Main St. Atwood',
                                             'serial_number': '71D8A0',
                                             'system_mac_address': None},
                '48:77:46:cd:52:5e': {       'dev_macs': [       '28:3b:82:35:8a:4d',
                                                                 '00:03:e6:60:41:58',
                                                                 '00:03:e6:6b:ba:d8',
                                                                 '00:03:e6:a5:6f:d8',
                                                                 '5c:0f:fb:14:37:76'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:cd:52:5e',
                                             'name': '5994 Line 77 Atwood',
                                             'serial_number': '76CFF8',
                                             'system_mac_address': None},
                '48:77:46:ce:1f:1e': {       'dev_macs': ['00:ad:24:60:e3:af'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:ce:1f:1e',
                                             'name': '325 Main St. Atwood',
                                             'serial_number': '76E990',
                                             'system_mac_address': None},
                '48:77:46:ce:20:6e': {       'dev_macs': ['a0:ab:1b:81:fa:0b'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:ce:20:6e',
                                             'name': '208 Queen St. Atwood',
                                             'serial_number': '76E9BA',
                                             'system_mac_address': None},
                '48:77:46:ce:63:7e': {       'dev_macs': ['bc:ae:c5:a5:70:8c'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:ce:63:7e',
                                             'name': '131 Fisher Ave Atwood',
                                             'serial_number': '76F21C',
                                             'system_mac_address': None},
                '48:77:46:f8:75:8c': {       'dev_macs': ['74:b6:b6:a0:82:61'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:f8:75:8c',
                                             'name': '271 WOODVIEW DR',
                                             'serial_number': '82A55A',
                                             'system_mac_address': None},
                '60:db:98:4e:6b:64': {       'dev_macs': ['60:db:98:09:1d:43'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:6b:64',
                                             'name': '281 QUEEN STREET ATWOOD',
                                             'serial_number': 'A9C32C',
                                             'system_mac_address': None},
                '60:db:98:4e:8e:34': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:8e:34',
                                             'name': '151 MAIN STREET ATWOOD',
                                             'serial_number': 'A9C786',
                                             'system_mac_address': None},
                '60:db:98:4e:90:0c': {       'dev_macs': ['60:db:98:55:b5:57'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:90:0c',
                                             'name': '277 QUEEN STREET ATWOOD',
                                             'serial_number': 'A9C7C1',
                                             'system_mac_address': None},
                '60:db:98:4e:96:cc': {       'dev_macs': ['60:db:98:55:b7:7d'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:96:cc',
                                             'name': '140 MAIN STREET ATWOOD',
                                             'serial_number': 'A9C899',
                                             'system_mac_address': None},
                '60:db:98:4e:99:cc': {       'dev_macs': ['18:e7:28:04:0d:84'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:99:cc',
                                             'name': '269 Main St. Atwood',
                                             'serial_number': 'A9C8F9',
                                             'system_mac_address': None},
                '60:db:98:4e:9b:8c': {       'dev_macs': [       '84:d3:43:0f:bb:5f',
                                                                 '5c:0f:fb:17:69:f0',
                                                                 '5c:0f:fb:17:6d:b7',
                                                                 '5c:0f:fb:17:6e:7b',
                                                                 '5c:0f:fb:17:6f:60'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:9b:8c',
                                             'name': '150 KING STREET ATWOOD',
                                             'serial_number': 'A9C931',
                                             'system_mac_address': None},
                '60:db:98:73:9c:74': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:73:9c:74',
                                             'name': '150 MAIN STREET ATWOOD',
                                             'serial_number': 'B0A2A0',
                                             'system_mac_address': None},
                '60:db:98:8e:fe:5a': {       'dev_macs': ['b8:94:70:9e:ce:59'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8e:fe:5a',
                                             'name': '158 Main St. Atwood',
                                             'serial_number': 'B510E2',
                                             'system_mac_address': None},
                '60:db:98:8e:ff:a7': {       'dev_macs': ['60:db:98:81:fc:1a'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8e:ff:a7',
                                             'name': '232 WOODVIEW DR',
                                             'serial_number': 'B51151',
                                             'system_mac_address': None},
                '60:db:98:8f:01:6f': {       'dev_macs': ['60:db:98:09:3b:d0'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8f:01:6f',
                                             'name': '271 QUEEN STREET ATWOOD',
                                             'serial_number': 'B511E9',
                                             'system_mac_address': None},
                '60:db:98:8f:01:d5': {       'dev_macs': ['08:5a:11:ba:2d:aa'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8f:01:d5',
                                             'name': '279 QUEEN STREET ATWOOD',
                                             'serial_number': 'B5120B',
                                             'system_mac_address': None},
                '60:db:98:8f:02:05': {       'dev_macs': [       '84:d3:43:0f:ba:36',
                                                                 '5c:0f:fb:17:69:9d'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8f:02:05',
                                             'name': '273 QUEEN STREET ATWOOD',
                                             'serial_number': 'B5121B',
                                             'system_mac_address': None},
                '84:d3:43:7c:e3:b7': {       'dev_macs': ['44:65:7f:88:cc:01'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7c:e3:b7',
                                             'name': '251 MAIN STREET ATWOOD',
                                             'serial_number': 'C811E0',
                                             'system_mac_address': None},
                '84:d3:43:7d:04:3f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:04:3f',
                                             'name': '165 MAIN STREET ATWOOD',
                                             'serial_number': 'C815F1',
                                             'system_mac_address': None},
                '84:d3:43:7d:1d:57': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:1d:57',
                                             'name': '354 MAIN STREET ATWOOD',
                                             'serial_number': 'C81914',
                                             'system_mac_address': None},
                '84:d3:43:7d:36:97': {       'dev_macs': ['54:af:97:59:9d:c0'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:36:97',
                                             'name': '280 MCCOURT PLACE',
                                             'serial_number': 'C81C3C',
                                             'system_mac_address': None},
                '84:d3:43:7d:36:af': {       'dev_macs': ['ec:4f:82:ac:d0:1d'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:36:af',
                                             'name': '252 King St. Atwood',
                                             'serial_number': 'C81C3F',
                                             'system_mac_address': None},
                '84:d3:43:7d:38:8f': {       'dev_macs': ['b8:94:70:bc:c5:74'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:38:8f',
                                             'name': '133 GEORGE AVENUE ATWOOD',
                                             'serial_number': 'C81C7B',
                                             'system_mac_address': None},
                '84:d3:43:7d:3a:a7': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:3a:a7',
                                             'name': '150 MONUMENT RD',
                                             'serial_number': 'C81CBE',
                                             'system_mac_address': None},
                '84:d3:43:7d:40:2f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:40:2f',
                                             'name': '269 MAIN STREET ATWOOD',
                                             'serial_number': 'C81D6F',
                                             'system_mac_address': None},
                '84:d3:43:7d:42:6f': {       'dev_macs': ['d0:76:8f:02:f5:e2'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:42:6f',
                                             'name': '137 QUEEN STREET ATWOOD',
                                             'serial_number': 'C81DB7',
                                             'system_mac_address': None},
                '84:d3:43:7d:43:37': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:43:37',
                                             'name': '7444 ROAD 164',
                                             'serial_number': 'C81DD0',
                                             'system_mac_address': None},
                '84:d3:43:7d:43:47': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:43:47',
                                             'name': '153 King St. Atwood',
                                             'serial_number': 'C81DD2',
                                             'system_mac_address': None},
                '84:d3:43:7d:43:8f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:43:8f',
                                             'name': '219 KING STREET ATWOOD',
                                             'serial_number': 'C81DDB',
                                             'system_mac_address': None},
                '84:d3:43:7d:44:bf': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:44:bf',
                                             'name': '135 FISHER AV',
                                             'serial_number': 'C81E01',
                                             'system_mac_address': None},
                '84:d3:43:7d:46:37': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:46:37',
                                             'name': '278 MAIN STREET ATWOOD',
                                             'serial_number': 'C81E30',
                                             'system_mac_address': None},
                '84:d3:43:7d:46:af': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:46:af',
                                             'name': '145 ARTHUR STREET E ATWOOD',
                                             'serial_number': 'C81E3F',
                                             'system_mac_address': None},
                '84:d3:43:7d:4e:c7': {       'dev_macs': ['60:db:98:09:1b:d8'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:4e:c7',
                                             'name': '216 King St. Atwood',
                                             'serial_number': 'C81F42',
                                             'system_mac_address': None},
                '84:d3:43:7d:5e:3f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:5e:3f',
                                             'name': '143 MONUMENT RD',
                                             'serial_number': 'C82131',
                                             'system_mac_address': None},
                '84:d3:43:7d:d9:4f': {       'dev_macs': ['cc:be:59:c3:46:dc'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:d9:4f',
                                             'name': '205 Queen St. Atwood',
                                             'serial_number': 'C83093',
                                             'system_mac_address': None},
                '84:d3:43:7d:e5:47': {       'dev_macs': ['ac:9e:17:e1:df:fc'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:e5:47',
                                             'name': '189 Main St. Atwood',
                                             'serial_number': 'C83212',
                                             'system_mac_address': None},
                '84:d3:43:7e:15:87': {       'dev_macs': ['60:db:98:09:1c:bf'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:15:87',
                                             'name': '257 KING STREET ATWOOD',
                                             'serial_number': 'C8381A',
                                             'system_mac_address': None},
                '84:d3:43:7e:30:27': {       'dev_macs': ['60:db:98:09:39:52'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:30:27',
                                             'name': '171 KING STREET ATWOOD',
                                             'serial_number': 'C83B6E',
                                             'system_mac_address': None},
                '84:d3:43:7e:30:d7': {       'dev_macs': [       '00:1a:79:77:d4:ba',
                                                                 'd0:76:8f:02:ed:34',
                                                                 '5c:0f:fb:15:8d:44'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:30:d7',
                                             'name': '280 QUEEN STREET ATWOOD',
                                             'serial_number': 'C83B84',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:6f': {       'dev_macs': ['60:db:98:55:b5:a4'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:6f',
                                             'name': '113 MONUMENT RD',
                                             'serial_number': 'C83B97',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:77': {       'dev_macs': ['ec:4f:82:a5:05:2c'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:77',
                                             'name': 'RIKI DOIG',
                                             'serial_number': 'C83B98',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:97': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:97',
                                             'name': '291 WOODVIEW DR',
                                             'serial_number': 'C83B9C',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:cf': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:cf',
                                             'name': '160 JOHN STREET ATWOOD',
                                             'serial_number': 'C83BA3',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:0f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:0f',
                                             'name': '158 KING STREET',
                                             'serial_number': 'C83BAB',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:27': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:27',
                                             'name': '196 MAIN STREET ATWOOD',
                                             'serial_number': 'C83BAE',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:37': {       'dev_macs': ['54:99:63:a4:94:0a'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:37',
                                             'name': '129 Bowman Ct',
                                             'serial_number': 'C83BB0',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:8f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:8f',
                                             'name': '131 MAIN STREET ATWOOD',
                                             'serial_number': 'C83BBB',
                                             'system_mac_address': None},
                '84:d3:43:7e:33:17': {       'dev_macs': ['f8:85:f9:a3:99:14'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:33:17',
                                             'name': '204 ELLEN ST',
                                             'serial_number': 'C83BCC',
                                             'system_mac_address': None},
                '84:d3:43:7e:33:87': {       'dev_macs': ['60:db:98:09:39:d6'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:33:87',
                                             'name': '273 WOODVIEW DR',
                                             'serial_number': 'C83BDA',
                                             'system_mac_address': None},
                '84:d3:43:7e:34:4f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:34:4f',
                                             'name': '171 James St. Atwood',
                                             'serial_number': 'C83BF3',
                                             'system_mac_address': None},
                '84:d3:43:7e:35:17': {       'dev_macs': ['ec:ce:13:54:1e:99'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:35:17',
                                             'name': '235 MAIN STREET ATWOOD',
                                             'serial_number': 'C83C0C',
                                             'system_mac_address': None},
                '84:d3:43:7e:45:07': {       'dev_macs': ['d0:76:8f:91:d3:f6'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:45:07',
                                             'name': '164 King Street Atwood',
                                             'serial_number': 'C83E0A',
                                             'system_mac_address': None},
                '84:d3:43:95:93:da': {       'dev_macs': ['d0:76:8f:02:ed:ef'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:95:93:da',
                                             'name': '280 WOODVIEW DR.',
                                             'serial_number': 'CBD29A',
                                             'system_mac_address': None},
                '84:d3:43:96:01:9a': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:96:01:9a',
                                             'name': '7452 ROAD 164',
                                             'serial_number': 'CBE052',
                                             'system_mac_address': None},
                'b8:94:70:ba:e1:a5': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e1:a5',
                                             'name': 'BUCHANAN JEFF & CATHY',
                                             'serial_number': '1195149',
                                             'system_mac_address': None},
                'b8:94:70:ba:e1:e5': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e1:e5',
                                             'name': '127 MONUMENT RD',
                                             'serial_number': '1195151',
                                             'system_mac_address': None},
                'b8:94:70:ba:e2:35': {       'dev_macs': [       '04:bc:9f:46:8f:4c',
                                                                 '5c:0f:fb:15:5a:4a',
                                                                 '5c:0f:fb:24:54:8a',
                                                                 '5c:0f:fb:2f:d0:cd'],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e2:35',
                                             'name': '163 KING ST ATWOOD',
                                             'serial_number': '119515B',
                                             'system_mac_address': None},
                'b8:94:70:ba:e4:a5': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e4:a5',
                                             'name': '134 MAIN STREET ATWOOD',
                                             'serial_number': '11951A9',
                                             'system_mac_address': None},
                'b8:94:70:c6:e9:57': {       'dev_macs': ['04:bc:9f:46:91:25'],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:c6:e9:57',
                                             'name': '159 FISHER AV',
                                             'serial_number': '11B2235',
                                             'system_mac_address': None},
                'b8:94:70:c6:ed:97': {       'dev_macs': ['cc:be:59:2d:a9:af'],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:c6:ed:97',
                                             'name': '179 MAIN STREET ATWOOD',
                                             'serial_number': '11B22BD',
                                             'system_mac_address': None},
                'b8:94:70:c7:04:f7': {       'dev_macs': ['04:bc:9f:46:92:b1'],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:c7:04:f7',
                                             'name': '210 QUEEN STREET ATWOOD',
                                             'serial_number': '11B25A9',
                                             'system_mac_address': None},
                'cc:be:59:04:29:90': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:04:29:90',
                                             'name': '7430 Rd. 164 Atwood',
                                             'serial_number': '3EBA19',
                                             'system_mac_address': None},
                'cc:be:59:04:2b:60': {       'dev_macs': ['ec:4f:82:ad:0e:69'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:04:2b:60',
                                             'name': '222B Main St. Lower',
                                             'serial_number': '3EBA53',
                                             'system_mac_address': None},
                'cc:be:59:0c:b5:b4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0c:b5:b4',
                                             'name': '202 MAIN STREET ATWOOD',
                                             'serial_number': '3ADD6E',
                                             'system_mac_address': None},
                'cc:be:59:0c:b5:cc': {       'dev_macs': [       'cc:be:59:2d:a5:ec',
                                                                 '00:03:e6:31:3f:30'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0c:b5:cc',
                                             'name': '189 King St. Atwood',
                                             'serial_number': '3ADD71',
                                             'system_mac_address': None},
                'cc:be:59:0d:27:04': {       'dev_macs': ['b4:0f:3b:8a:b5:09'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:27:04',
                                             'name': '214 MAIN STREET ATWOOD',
                                             'serial_number': '3AEB98',
                                             'system_mac_address': None},
                'cc:be:59:0d:27:f4': {       'dev_macs': ['ec:4f:82:a8:83:a7'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:27:f4',
                                             'name': '143 James St. Atwood',
                                             'serial_number': '3AEBB6',
                                             'system_mac_address': None},
                'cc:be:59:0d:28:2c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:28:2c',
                                             'name': '275 WOODVIEW DR',
                                             'serial_number': '3AEBBD',
                                             'system_mac_address': None},
                'cc:be:59:0d:28:44': {       'dev_macs': [       'b8:94:70:bc:b8:17',
                                                                 '5c:0f:fb:2f:cd:35'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:28:44',
                                             'name': '141 BOWMAN CT',
                                             'serial_number': '3AEBC0',
                                             'system_mac_address': None},
                'cc:be:59:0d:28:84': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:28:84',
                                             'name': '112 BLAIR ST',
                                             'serial_number': '3AEBC8',
                                             'system_mac_address': None},
                'cc:be:59:0d:2b:3c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:2b:3c',
                                             'name': '189 Ellen St. Atwood',
                                             'serial_number': '3AEC1F',
                                             'system_mac_address': None},
                'cc:be:59:0d:2b:4c': {       'dev_macs': ['60:db:98:09:3b:af'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:2b:4c',
                                             'name': '240 WOODVIEW DR',
                                             'serial_number': '3AEC21',
                                             'system_mac_address': None},
                'cc:be:59:1a:fb:43': {       'dev_macs': ['f0:a7:31:21:47:f1'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:1a:fb:43',
                                             'name': 'asdasd',
                                             'serial_number': '393C00',
                                             'system_mac_address': None},
                'cc:be:59:2b:a9:47': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:2b:a9:47',
                                             'name': '123 Main St. N. Atwood',
                                             'serial_number': '3FB35D',
                                             'system_mac_address': None},
                'cc:be:59:46:c9:cf': {       'dev_macs': ['3c:97:0e:5c:68:9b'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:46:c9:cf',
                                             'name': '246 King St. Atwood',
                                             'serial_number': '39507A',
                                             'system_mac_address': None},
                'cc:be:59:47:32:bf': {       'dev_macs': ['9c:3d:cf:f0:22:48'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:47:32:bf',
                                             'name': '169 James St. Atwood',
                                             'serial_number': '433E5F',
                                             'system_mac_address': None},
                'cc:be:59:50:17:31': {       'dev_macs': ['cc:be:59:2f:2d:99'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:50:17:31',
                                             'name': '163 Fisher Ave Atwood',
                                             'serial_number': '43C21A',
                                             'system_mac_address': None},
                'cc:be:59:50:17:95': {       'dev_macs': ['38:d5:47:c5:be:68'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:50:17:95',
                                             'name': '202 Ellen St Atwood',
                                             'serial_number': '43C24C',
                                             'system_mac_address': None},
                'cc:be:59:50:1a:b7': {       'dev_macs': ['cc:be:59:2d:a8:7d'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:50:1a:b7',
                                             'name': '155 Queen St Atwood',
                                             'serial_number': '43C3DD',
                                             'system_mac_address': None},
                'cc:be:59:52:6d:37': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:52:6d:37',
                                             'name': '7306 Rd 164 Atwood',
                                             'serial_number': '3FC3C2',
                                             'system_mac_address': None},
                'cc:be:59:5f:16:62': {       'dev_macs': ['60:db:98:59:a4:87'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:5f:16:62',
                                             'name': '104 MONUMENT RD',
                                             'serial_number': '455673',
                                             'system_mac_address': None},
                'cc:be:59:6a:dd:5e': {       'dev_macs': ['d8:07:b6:e3:1e:1f'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6a:dd:5e',
                                             'name': '182 Ellen St. Atwood',
                                             'serial_number': '46CE0A',
                                             'system_mac_address': None},
                'cc:be:59:6d:3d:5e': {       'dev_macs': ['20:aa:4b:72:5d:90'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:3d:5e',
                                             'name': '130 John St. Atwood',
                                             'serial_number': '3FFFE3',
                                             'system_mac_address': None},
                'cc:be:59:6d:5a:be': {       'dev_macs': ['78:32:1b:41:9b:28'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:5a:be',
                                             'name': '129 King St. Atwood',
                                             'serial_number': '40038F',
                                             'system_mac_address': None},
                'cc:be:59:6d:5c:e6': {       'dev_macs': ['f0:2f:74:e9:8a:30'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:5c:e6',
                                             'name': '151 King St. Atwood',
                                             'serial_number': '4003D4',
                                             'system_mac_address': None},
                'cc:be:59:6d:60:ee': {       'dev_macs': ['10:7b:44:3f:13:74'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:60:ee',
                                             'name': '148 King St. Atwood',
                                             'serial_number': '400455',
                                             'system_mac_address': None},
                'cc:be:59:6d:7e:3e': {       'dev_macs': ['d0:76:8f:1f:58:38'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:7e:3e',
                                             'name': '208 KING STREET ATWOOD',
                                             'serial_number': '4007FF',
                                             'system_mac_address': None},
                'cc:be:59:6d:85:26': {       'dev_macs': [       '60:db:98:09:1b:ac',
                                                                 '00:03:e6:f0:ee:34',
                                                                 '00:03:e6:f0:fa:ee',
                                                                 '5c:0f:fb:2f:ca:9b'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:85:26',
                                             'name': '279 WOODVIEW DR',
                                             'serial_number': '4008DC',
                                             'system_mac_address': None},
                'cc:be:59:6d:e8:d6': {       'dev_macs': [       '60:63:4c:62:8e:f6',
                                                                 'd8:bb:c1:4e:e7:7d'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:e8:d6',
                                             'name': '254 Queen St. Atwood',
                                             'serial_number': '4703AF',
                                             'system_mac_address': None},
                'cc:be:59:6e:14:ca': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6e:14:ca',
                                             'name': '135 Queen St. Atwood',
                                             'serial_number': '47092C',
                                             'system_mac_address': None},
                'cc:be:59:6e:6e:da': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6e:6e:da',
                                             'name': '256 Main St. Atwood',
                                             'serial_number': '47146E',
                                             'system_mac_address': None},
                'cc:be:59:6e:ae:96': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6e:ae:96',
                                             'name': '186 MAIN STREET',
                                             'serial_number': '471C63',
                                             'system_mac_address': None},
                'cc:be:59:6f:29:52': {       'dev_macs': ['e0:1c:fc:80:86:fc'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:29:52',
                                             'name': '146 Monument Rd',
                                             'serial_number': '55E123',
                                             'system_mac_address': None},
                'cc:be:59:6f:74:d2': {       'dev_macs': ['44:65:7f:41:8d:d9'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:74:d2',
                                             'name': '186 Ellen St. Atwood',
                                             'serial_number': '55EA90',
                                             'system_mac_address': None},
                'cc:be:59:6f:fd:92': {       'dev_macs': ['00:0e:c6:80:85:24'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:fd:92',
                                             'name': '154 Monument Rd',
                                             'serial_number': '55FBA5',
                                             'system_mac_address': None},
                'cc:be:59:6f:ff:1a': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:ff:1a',
                                             'name': '208 Main St. Atwood',
                                             'serial_number': '55FBD6',
                                             'system_mac_address': None},
                'cc:be:59:70:33:7e': {       'dev_macs': [       'a8:63:7d:7a:84:91',
                                                                 '78:32:1b:6e:4d:d6'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:70:33:7e',
                                             'name': '220 MAIN STREET ATWOOD',
                                             'serial_number': '560262',
                                             'system_mac_address': None},
                'cc:be:59:70:33:86': {       'dev_macs': ['ec:4f:82:2d:61:e1'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:70:33:86',
                                             'name': '7436 Rd. 164 Atwood',
                                             'serial_number': '560263',
                                             'system_mac_address': None},
                'cc:be:59:70:81:36': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:70:81:36',
                                             'name': '7446 ROAD 164',
                                             'serial_number': '560C19',
                                             'system_mac_address': None},
                'cc:be:59:af:a5:9b': {       'dev_macs': ['60:db:98:09:3b:20'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:af:a5:9b',
                                             'name': '137 MAIN STREET ATWOOD',
                                             'serial_number': '4E36A8',
                                             'system_mac_address': None},
                'cc:be:59:af:d8:7b': {       'dev_macs': ['68:ff:7b:32:2b:d1'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:af:d8:7b',
                                             'name': '62 PARKVIEW CR',
                                             'serial_number': '4E3D04',
                                             'system_mac_address': None},
                'cc:be:59:b3:7c:9b': {       'dev_macs': ['c8:4f:86:1b:44:8f'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:b3:7c:9b',
                                             'name': '269 Main St. Atwood',
                                             'serial_number': '4EB17D',
                                             'system_mac_address': None},
                'cc:be:59:b7:3b:67': {       'dev_macs': ['ec:08:6b:5a:b4:e1'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:b7:3b:67',
                                             'name': '253 Queen St.',
                                             'serial_number': '4D111F',
                                             'system_mac_address': None},
                'cc:be:59:ca:db:7a': {       'dev_macs': ['44:65:7f:37:fe:45'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ca:db:7a',
                                             'name': '129 James St. Atwood',
                                             'serial_number': '42816E',
                                             'system_mac_address': None},
                'cc:be:59:ca:dc:92': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ca:dc:92',
                                             'name': '164 FISHER AV',
                                             'serial_number': '428191',
                                             'system_mac_address': None},
                'cc:be:59:ca:de:8a': {       'dev_macs': ['cc:be:59:c3:47:d8'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ca:de:8a',
                                             'name': '145 Queen St Atwood',
                                             'serial_number': '4281D0',
                                             'system_mac_address': None},
                'cc:be:59:cb:43:da': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:43:da',
                                             'name': '261 King St Atwood',
                                             'serial_number': '42B9D3',
                                             'system_mac_address': None},
                'cc:be:59:cb:44:72': {       'dev_macs': ['44:65:7f:37:fd:64'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:44:72',
                                             'name': '7464 Rd 164 Atwood',
                                             'serial_number': '42B9E6',
                                             'system_mac_address': None},
                'cc:be:59:cb:6c:5a': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:6c:5a',
                                             'name': '272 McCourt Place Atwood',
                                             'serial_number': '42BEE3',
                                             'system_mac_address': None},
                'cc:be:59:cb:7e:02': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:7e:02',
                                             'name': '275 MCCOURT PL',
                                             'serial_number': '42C118',
                                             'system_mac_address': None},
                'cc:be:59:cb:95:e2': {       'dev_macs': [       '44:65:7f:37:fe:21',
                                                                 '00:03:e6:a2:75:ce',
                                                                 '00:03:e6:da:2f:b7'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:95:e2',
                                             'name': '167 Queen St, Atwood',
                                             'serial_number': '42C414',
                                             'system_mac_address': None},
                'cc:be:59:cb:bb:ba': {       'dev_macs': ['b8:94:70:bc:c3:f3'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:bb:ba',
                                             'name': '98 ELMA CENTRE ST',
                                             'serial_number': '42C8CF',
                                             'system_mac_address': None},
                'cc:be:59:cb:bd:12': {       'dev_macs': ['cc:be:59:2d:a9:94'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:bd:12',
                                             'name': '94 Elma Centre Atwood',
                                             'serial_number': '42C8FA',
                                             'system_mac_address': None},
                'cc:be:59:cb:bf:3a': {       'dev_macs': ['cc:be:59:c3:c8:f0'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:bf:3a',
                                             'name': '273 McCourt Pl Atwood',
                                             'serial_number': '42C93F',
                                             'system_mac_address': None},
                'cc:be:59:cb:ea:02': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:ea:02',
                                             'name': '7426 Road 164 Atwood',
                                             'serial_number': '42CE98',
                                             'system_mac_address': None},
                'cc:be:59:cc:03:2a': {       'dev_macs': ['14:59:c0:c0:f0:6d'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:03:2a',
                                             'name': '182 King St Atwood',
                                             'serial_number': '42D1BD',
                                             'system_mac_address': None},
                'cc:be:59:cc:0b:1a': {       'dev_macs': ['44:65:7f:3e:ab:7f'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:0b:1a',
                                             'name': '155 Fischer Ave Atwood',
                                             'serial_number': '42D2BB',
                                             'system_mac_address': None},
                'cc:be:59:cc:11:3a': {       'dev_macs': ['44:65:7f:88:45:be'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:11:3a',
                                             'name': '134 King St Atwood',
                                             'serial_number': '42D37F',
                                             'system_mac_address': None},
                'cc:be:59:cc:11:ba': {       'dev_macs': ['48:77:46:9a:55:a1'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:11:ba',
                                             'name': '187 King St Atwood',
                                             'serial_number': '42D38F',
                                             'system_mac_address': None},
                'cc:be:59:eb:02:16': {       'dev_macs': ['90:9a:4a:e1:bc:92'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:02:16',
                                             'name': '128 Queen St. Atwood',
                                             'serial_number': '555CB8',
                                             'system_mac_address': None},
                'cc:be:59:eb:39:ae': {       'dev_macs': ['3c:7c:3f:cb:7b:60'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:39:ae',
                                             'name': '154 King St. Atwood',
                                             'serial_number': '5563AB',
                                             'system_mac_address': None},
                'cc:be:59:eb:39:be': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:39:be',
                                             'name': '7456 ROAD 164',
                                             'serial_number': '5563AD',
                                             'system_mac_address': None},
                'cc:be:59:eb:3a:06': {       'dev_macs': ['74:ea:3a:a1:63:97'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3a:06',
                                             'name': '190 Ellen St. Atwood',
                                             'serial_number': '5563B6',
                                             'system_mac_address': None},
                'cc:be:59:eb:3a:de': {       'dev_macs': ['cc:be:59:32:9a:92'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3a:de',
                                             'name': '167 John St. Atwood',
                                             'serial_number': '5563D1',
                                             'system_mac_address': None},
                'cc:be:59:eb:3a:ee': {       'dev_macs': ['70:4f:57:be:6c:6c'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3a:ee',
                                             'name': '205 Ellen St. Atwood',
                                             'serial_number': '5563D3',
                                             'system_mac_address': None},
                'cc:be:59:eb:3b:d6': {       'dev_macs': ['d0:76:8f:02:f3:17'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3b:d6',
                                             'name': '171 QUEEN STREET ATWOOD',
                                             'serial_number': '5563F0',
                                             'system_mac_address': None},
                'cc:be:59:ef:f4:de': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f4:de',
                                             'name': '106 BLAIR ST',
                                             'serial_number': '4D41EE',
                                             'system_mac_address': None},
                'cc:be:59:ef:f5:0e': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f5:0e',
                                             'name': '207 Main St. Atwood',
                                             'serial_number': '4D41F4',
                                             'system_mac_address': None},
                'cc:be:59:ef:f5:16': {       'dev_macs': ['cc:be:59:c3:c8:06'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f5:16',
                                             'name': '283 Woodview Dr. Atwood',
                                             'serial_number': '4D41F5',
                                             'system_mac_address': None},
                'cc:be:59:ef:f5:26': {       'dev_macs': ['c4:41:1e:a9:9e:28'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f5:26',
                                             'name': '170 King St. Atwood',
                                             'serial_number': '4D41F7',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:56': {       'dev_macs': ['d0:76:8f:1f:55:36'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:56',
                                             'name': '169 King St. Atwood',
                                             'serial_number': '4D423D',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:7e': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:7e',
                                             'name': '204 King St. Atwood',
                                             'serial_number': '4D4242',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:d6': {       'dev_macs': ['bc:0f:9a:77:c2:bd'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:d6',
                                             'name': '217 Queen St. Atwood',
                                             'serial_number': '4D424D',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:e6': {       'dev_macs': ['d0:76:8f:1f:54:c8'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:e6',
                                             'name': '127 KING STREET ATWOOD',
                                             'serial_number': '4D424F',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:ee': {       'dev_macs': ['70:4c:a5:6e:2c:96'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:ee',
                                             'name': '5972 Perth Line 72',
                                             'serial_number': '4D4250',
                                             'system_mac_address': None},
                'd0:76:8f:06:e5:fe': {       'dev_macs': ['60:32:b1:41:b1:b1'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:06:e5:fe',
                                             'name': '165 JOHN STREET ATWOOD',
                                             'serial_number': '844BE5',
                                             'system_mac_address': None},
                'd0:76:8f:07:19:91': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:07:19:91',
                                             'name': '170 Main St. Unit B',
                                             'serial_number': '8678B6',
                                             'system_mac_address': None},
                'd0:76:8f:08:14:ab': {       'dev_macs': ['84:d3:43:0f:bc:5c'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:14:ab',
                                             'name': '119 PARKVIEW CR',
                                             'serial_number': '86938B',
                                             'system_mac_address': None},
                'd0:76:8f:08:15:33': {       'dev_macs': [       'd0:76:8f:02:ef:5a',
                                                                 '00:03:e6:dd:2e:f3',
                                                                 '00:03:e6:dd:31:31',
                                                                 '00:03:e6:dd:32:0c'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:15:33',
                                             'name': '236 WOODVIEW DR',
                                             'serial_number': '86939C',
                                             'system_mac_address': None},
                'd0:76:8f:08:16:83': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:16:83',
                                             'name': '135 KING STREET ATWOOD',
                                             'serial_number': '8693C6',
                                             'system_mac_address': None},
                'd0:76:8f:08:17:4b': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:17:4b',
                                             'name': '215 QUEEN STREET ATWOOD',
                                             'serial_number': '8693DF',
                                             'system_mac_address': None},
                'd0:76:8f:08:18:33': {       'dev_macs': ['d0:76:8f:1f:64:40'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:18:33',
                                             'name': '276 MCCOURT PL',
                                             'serial_number': '8693FC',
                                             'system_mac_address': None},
                'd0:76:8f:08:19:1b': {       'dev_macs': ['68:9c:e2:a1:d4:22'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:19:1b',
                                             'name': '7495 ROAD 164',
                                             'serial_number': '869419',
                                             'system_mac_address': None},
                'd0:76:8f:1b:9e:6b': {       'dev_macs': ['cc:be:59:32:94:2c'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:9e:6b',
                                             'name': '138 Main St Atwood',
                                             'serial_number': '87241B',
                                             'system_mac_address': None},
                'd0:76:8f:1b:9e:bb': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:9e:bb',
                                             'name': '241 WOODVIEW DR',
                                             'serial_number': '872425',
                                             'system_mac_address': None},
                'd0:76:8f:1b:9e:e3': {       'dev_macs': ['cc:be:59:32:95:f7'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:9e:e3',
                                             'name': '166 FISHER AV',
                                             'serial_number': '87242A',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a0:83': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a0:83',
                                             'name': '265 Queen St. Atwood',
                                             'serial_number': '87245E',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a1:13': {       'dev_macs': ['ec:08:6b:46:40:b9'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a1:13',
                                             'name': '7497 Rd. 164 Atwood',
                                             'serial_number': '872470',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a1:1b': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a1:1b',
                                             'name': '124 MAIN STREET ATWOOD',
                                             'serial_number': '872471',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a5:73': {       'dev_macs': ['ec:4f:82:2b:47:52'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a5:73',
                                             'name': '202 Queen St. Atwood',
                                             'serial_number': '8724FC',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a7:3b': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a7:3b',
                                             'name': '155 Main St. Atwood',
                                             'serial_number': '872535',
                                             'system_mac_address': None},
                'd0:76:8f:a9:53:88': {       'dev_macs': ['d0:76:8f:1f:61:b7'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:a9:53:88',
                                             'name': '162 FISHER AV',
                                             'serial_number': '954F45',
                                             'system_mac_address': None},
                'd0:76:8f:aa:4e:f4': {       'dev_macs': ['d0:76:8f:91:d2:6a'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:4e:f4',
                                             'name': '139 MONUMENT RD ATWOOD',
                                             'serial_number': '956F04',
                                             'system_mac_address': None},
                'd0:76:8f:aa:4f:e4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:4f:e4',
                                             'name': '222 King St. Atwood',
                                             'serial_number': '956F22',
                                             'system_mac_address': None},
                'd0:76:8f:aa:50:04': {       'dev_macs': [       'd0:76:8f:02:f1:d8',
                                                                 '00:03:e6:db:aa:5d',
                                                                 '00:03:e6:dd:46:d3'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:50:04',
                                             'name': '166 MAIN ST ATWOOD',
                                             'serial_number': '956F26',
                                             'system_mac_address': None},
                'd0:76:8f:aa:54:0c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:54:0c',
                                             'name': '100 ARTHUR ST EAST ATWOOD',
                                             'serial_number': '956FA7',
                                             'system_mac_address': None},
                'ec:4f:82:02:06:79': {       'dev_macs': ['d8:50:e6:d6:6f:cc'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:02:06:79',
                                             'name': '91 Arthur St. Atwood',
                                             'serial_number': '1F7DA1',
                                             'system_mac_address': None},
                'ec:4f:82:08:2e:cd': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:08:2e:cd',
                                             'name': '112 Arthur Street, Atwood',
                                             'serial_number': '1C5DCF',
                                             'system_mac_address': None},
                'ec:4f:82:32:25:97': {       'dev_macs': [       'cc:be:59:c3:c8:45',
                                                                 '00:03:e6:a5:70:b1'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:25:97',
                                             'name': '256 Woodview Dr.',
                                             'serial_number': '248AC3',
                                             'system_mac_address': None},
                'ec:4f:82:32:25:af': {       'dev_macs': ['ec:4f:82:ac:ec:2b'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:25:af',
                                             'name': '274 Woodview Dr. Atwood',
                                             'serial_number': '248AC6',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:0f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:0f',
                                             'name': '194 Queen St. Atwood',
                                             'serial_number': '248AD2',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:37': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:37',
                                             'name': '215 Main St. Atwood',
                                             'serial_number': '248AD7',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:97': {       'dev_macs': ['ec:4f:82:a5:13:d5'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:97',
                                             'name': '144 King St. Atwood',
                                             'serial_number': '248AE3',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:af': {       'dev_macs': ['d0:76:8f:1f:5f:44'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:af',
                                             'name': '209 Main St. Atwood',
                                             'serial_number': '248AE6',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:cf': {       'dev_macs': [       '24:4b:fe:1e:92:58',
                                                                 '00:03:e6:9b:3b:f8'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:cf',
                                             'name': '129 Parkview Cr. Atwood',
                                             'serial_number': '248AEA',
                                             'system_mac_address': None},
                'ec:4f:82:32:27:1f': {       'dev_macs': ['b8:94:70:f3:e4:40'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:27:1f',
                                             'name': '193 ELLEN  ST',
                                             'serial_number': '248AF4',
                                             'system_mac_address': None},
                'ec:4f:82:33:d5:0f': {       'dev_macs': ['ec:4f:82:a8:85:b1'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:33:d5:0f',
                                             'name': '157 Monument Rd',
                                             'serial_number': '1FC4EF',
                                             'system_mac_address': None},
                'ec:4f:82:44:18:1f': {       'dev_macs': ['cc:be:59:c3:c2:54'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:44:18:1f',
                                             'name': '194 KING STREET ATWOOD',
                                             'serial_number': '23A003',
                                             'system_mac_address': None},
                'ec:4f:82:4c:a5:67': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:4c:a5:67',
                                             'name': '147 KING STREET ATWOOD',
                                             'serial_number': '25B5F9',
                                             'system_mac_address': None},
                'ec:4f:82:59:55:07': {       'dev_macs': ['98:ed:7e:e2:f9:00'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:59:55:07',
                                             'name': '287 WOODVIEW DR',
                                             'serial_number': '2AA878',
                                             'system_mac_address': None},
                'ec:4f:82:59:5b:77': {       'dev_macs': ['14:59:c0:4e:56:a7'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:59:5b:77',
                                             'name': '252 Woodview Dr. Atwood',
                                             'serial_number': '2AA946',
                                             'system_mac_address': None},
                'ec:4f:82:67:6d:cd': {       'dev_macs': ['ec:4f:82:2a:b0:02'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:67:6d:cd',
                                             'name': '217 KING STREET ATWOOD',
                                             'serial_number': '25D8AE',
                                             'system_mac_address': None},
                'ec:4f:82:67:71:b5': {       'dev_macs': ['30:de:4b:ee:0c:42'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:67:71:b5',
                                             'name': '237 WOODVIEW DR',
                                             'serial_number': '25D92B',
                                             'system_mac_address': None},
                'ec:4f:82:67:71:fd': {       'dev_macs': ['90:9a:4a:80:de:2b'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:67:71:fd',
                                             'name': '136 MONUMENT RD',
                                             'serial_number': '25D934',
                                             'system_mac_address': None},
                'ec:4f:82:7a:23:67': {       'dev_macs': ['a8:5e:45:77:90:9c'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:7a:23:67',
                                             'name': '165 Fisher Ave',
                                             'serial_number': '2F3AD9',
                                             'system_mac_address': None},
                'ec:4f:82:8d:3f:60': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:3f:60',
                                             'name': '154 Main St. Atwood',
                                             'serial_number': '321033',
                                             'system_mac_address': None},
                'ec:4f:82:8d:4b:60': {       'dev_macs': [       'b0:e4:d5:25:60:b8',
                                                                 'b0:e4:d5:53:dc:d4'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:4b:60',
                                             'name': '256 KING STREET ATWOOD',
                                             'serial_number': '3211B3',
                                             'system_mac_address': None},
                'ec:4f:82:8d:76:88': {       'dev_macs': ['cc:be:59:2f:2d:51'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:76:88',
                                             'name': '98 Parkview Cr Atwood',
                                             'serial_number': '321718',
                                             'system_mac_address': None},
                'ec:4f:82:8d:7a:d8': {       'dev_macs': ['cc:be:59:2f:2d:d8'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:7a:d8',
                                             'name': '162 Queen St Atwood',
                                             'serial_number': '3217A2',
                                             'system_mac_address': None},
                'ec:4f:82:8d:7c:18': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:7c:18',
                                             'name': '159 John St',
                                             'serial_number': '3217CA',
                                             'system_mac_address': None},
                'ec:4f:82:8d:88:88': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:88:88',
                                             'name': '145 Bowman Ct. Atwwod',
                                             'serial_number': '321958',
                                             'system_mac_address': None},
                'ec:4f:82:8d:dc:60': {       'dev_macs': [       '48:77:46:f8:b1:52',
                                                                 '00:03:e6:a2:18:14',
                                                                 '00:03:e6:da:34:39',
                                                                 '00:03:e6:da:35:7f'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:dc:60',
                                             'name': '157 Fisher Ave Atwood',
                                             'serial_number': '3223D3',
                                             'system_mac_address': None},
                'ec:4f:82:8d:dd:90': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:dd:90',
                                             'name': '211 Main St Atwood',
                                             'serial_number': '3223F9',
                                             'system_mac_address': None},
                'ec:4f:82:8e:00:f0': {       'dev_macs': ['50:91:e3:bc:40:14'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8e:00:f0',
                                             'name': '123 PARKVIEW CR',
                                             'serial_number': '322865',
                                             'system_mac_address': None},
                'ec:4f:82:8e:05:d0': {       'dev_macs': ['cc:be:59:2d:a8:6b'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8e:05:d0',
                                             'name': '124 Queen St Atwood',
                                             'serial_number': '322901',
                                             'system_mac_address': None},
                'ec:4f:82:92:f6:18': {       'dev_macs': ['e4:6f:13:fa:d2:a7'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:f6:18',
                                             'name': '216A Main St. Atwood',
                                             'serial_number': '32954F',
                                             'system_mac_address': None},
                'ec:4f:82:92:fa:80': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fa:80',
                                             'name': '132 BOWMAN CT',
                                             'serial_number': '3295DC',
                                             'system_mac_address': None},
                'ec:4f:82:92:fd:50': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fd:50',
                                             'name': '158 James St. Atwood',
                                             'serial_number': '329636',
                                             'system_mac_address': None},
                'ec:4f:82:92:fd:68': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fd:68',
                                             'name': '272 Main St. Atwood',
                                             'serial_number': '329639',
                                             'system_mac_address': None},
                'ec:4f:82:92:fd:80': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fd:80',
                                             'name': '94 Baker St. Atwood',
                                             'serial_number': '32963C',
                                             'system_mac_address': None},
                'ec:4f:82:92:fd:b0': {       'dev_macs': ['d0:76:8f:02:f4:61'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fd:b0',
                                             'name': '167 MAIN STREET ATWOOD',
                                             'serial_number': '329642',
                                             'system_mac_address': None},
                'ec:4f:82:9b:b6:b4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:9b:b6:b4',
                                             'name': '266 Woodview Dr. Atwood',
                                             'serial_number': '33AD09',
                                             'system_mac_address': None},
                'ec:4f:82:9c:fa:6c': {       'dev_macs': ['60:db:98:57:a7:59'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:9c:fa:6c',
                                             'name': '156 QUEEN STREET ATWOOD',
                                             'serial_number': '33D580',
                                             'system_mac_address': None},
                'ec:4f:82:a2:ae:49': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:a2:ae:49',
                                             'name': '170 MAIN STREET ATWOOD',
                                             'serial_number': '349D6E',
                                             'system_mac_address': None},
                'ec:4f:82:b8:2c:40': {       'dev_macs': ['04:bc:9f:46:91:51'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b8:2c:40',
                                             'name': '88 Parkview Cr. Atwood',
                                             'serial_number': '2FCC31',
                                             'system_mac_address': None},
                'ec:4f:82:b8:2c:78': {       'dev_macs': ['ec:4f:82:a8:88:15'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b8:2c:78',
                                             'name': '122 King St. Atwood',
                                             'serial_number': '2FCC38',
                                             'system_mac_address': None},
                'ec:4f:82:b8:31:c0': {       'dev_macs': ['d8:47:32:21:92:dd'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b8:31:c0',
                                             'name': '193 Main St. Atwood',
                                             'serial_number': '2FCCE1',
                                             'system_mac_address': None},
                'ec:4f:82:b9:18:80': {       'dev_macs': [       '70:4d:7b:d4:71:fc',
                                                                 '00:03:e6:da:b2:fc',
                                                                 '00:03:e6:dd:30:1e'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b9:18:80',
                                             'name': '137 Bowman Ct',
                                             'serial_number': '2FE9BA',
                                             'system_mac_address': None},
                'ec:4f:82:b9:1a:48': {       'dev_macs': ['60:db:98:55:b5:62'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b9:1a:48',
                                             'name': '132 QUEEN STREET ATWOOD',
                                             'serial_number': '2FE9F3',
                                             'system_mac_address': None},
                'ec:4f:82:b9:1a:c8': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b9:1a:c8',
                                             'name': '264 MAIN STREET ATWOOD',
                                             'serial_number': '2FEA03',
                                             'system_mac_address': None},
                'ec:4f:82:be:ac:21': {       'dev_macs': ['2c:b8:ed:43:0e:71'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:be:ac:21',
                                             'name': '217 MAIN STREET ATWOOD',
                                             'serial_number': '3788C1',
                                             'system_mac_address': None},
                'ec:4f:82:c0:c3:b0': {       'dev_macs': ['84:16:f9:25:86:23'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:c0:c3:b0',
                                             'name': '145 John St.',
                                             'serial_number': '3655A9',
                                             'system_mac_address': None},
                'ec:4f:82:cb:05:18': {       'dev_macs': [       '14:91:82:2e:68:01',
                                                                 'c4:e9:0a:56:61:4e',
                                                                 '00:03:e6:60:14:92'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:05:18',
                                             'name': '164 John St. Atwood',
                                             'serial_number': '2C9A0E',
                                             'system_mac_address': None},
                'ec:4f:82:cb:2b:48': {       'dev_macs': ['bc:0f:9a:66:68:50'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:2b:48',
                                             'name': '130 Main St. Atwood',
                                             'serial_number': '2C9ED4',
                                             'system_mac_address': None},
                'ec:4f:82:cb:4d:14': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:4d:14',
                                             'name': '130 ARTHUR STREET ATWOOD',
                                             'serial_number': '2CA30D',
                                             'system_mac_address': None},
                'ec:4f:82:cb:9e:b8': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:9e:b8',
                                             'name': '229 WOODVIEW DR',
                                             'serial_number': '38F111',
                                             'system_mac_address': None},
                'ec:4f:82:cb:a2:88': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:a2:88',
                                             'name': '140 Queen St. Atwood',
                                             'serial_number': '38F18B',
                                             'system_mac_address': None},
                'ec:4f:82:cb:a5:80': {       'dev_macs': ['40:b0:76:05:6e:34'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:a5:80',
                                             'name': '146 Queen St. Atwood',
                                             'serial_number': '38F1EA',
                                             'system_mac_address': None},
                'ec:4f:82:cb:a6:18': {       'dev_macs': ['44:65:7f:88:47:4a'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:a6:18',
                                             'name': '134 Monument Rd',
                                             'serial_number': '38F1FD',
                                             'system_mac_address': None},
                'ec:4f:82:cc:6c:04': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cc:6c:04',
                                             'name': '144 Bowman Ct',
                                             'serial_number': '390AB8',
                                             'system_mac_address': None},
                'ec:4f:82:da:ad:58': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:da:ad:58',
                                             'name': '153 MAIN STREET ATWOOD',
                                             'serial_number': '2E914A',
                                             'system_mac_address': None},
                'ec:4f:82:db:f0:ec': {       'dev_macs': ['cc:be:59:33:61:a0'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:db:f0:ec',
                                             'name': '298 Woodview Dr.',
                                             'serial_number': '2EB9B8',
                                             'system_mac_address': None},
                'ec:4f:82:dc:a5:2c': {       'dev_macs': ['74:da:da:d0:fb:96'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:dc:a5:2c',
                                             'name': '147 Queen St. Atwood',
                                             'serial_number': '2ED03F',
                                             'system_mac_address': None},
                'ec:4f:82:dc:f1:b4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:dc:f1:b4',
                                             'name': '161 MONUMENT RD',
                                             'serial_number': '2ED9D0',
                                             'system_mac_address': None},
                'ec:4f:82:dc:f2:dc': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:dc:f2:dc',
                                             'name': '130 King St. Atwood',
                                             'serial_number': '2ED9F5',
                                             'system_mac_address': None},
                'ec:4f:82:e0:0a:e0': {       'dev_macs': [       '44:65:7f:88:d1:b3',
                                                                 'c8:78:7d:65:b1:70'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:e0:0a:e0',
                                             'name': '200A MAIN STREET ATWOOD',
                                             'serial_number': '3961A9',
                                             'system_mac_address': None},
                'f8:85:f9:06:4e:64': {       'dev_macs': ['a8:5e:45:ca:b9:68'],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:06:4e:64',
                                             'name': '176 King St. Atwood',
                                             'serial_number': 'BF1E1B',
                                             'system_mac_address': None},
                'f8:85:f9:06:6c:cc': {       'dev_macs': ['48:f8:b3:8f:10:d9'],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:06:6c:cc',
                                             'name': '182 MAIN STREET',
                                             'serial_number': 'BF21E8',
                                             'system_mac_address': None},
                'f8:85:f9:06:77:e4': {       'dev_macs': [       '60:db:98:09:1b:5f',
                                                                 '00:03:e6:dd:44:ab',
                                                                 '00:03:e6:ec:0b:a6'],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:06:77:e4',
                                             'name': '128 Main St. Atwood',
                                             'serial_number': 'BF234B',
                                             'system_mac_address': None},
                'f8:85:f9:6f:1b:dd': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:1b:dd',
                                             'name': '186 King St. Atwood',
                                             'serial_number': 'BF242A',
                                             'system_mac_address': None},
                'f8:85:f9:6f:20:25': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:20:25',
                                             'name': '161 Fisher Ave',
                                             'serial_number': 'BF24B4',
                                             'system_mac_address': None},
                'f8:85:f9:6f:21:0d': {       'dev_macs': [       '3c:7c:3f:6d:e1:58',
                                                                 '00:03:e6:5e:8d:7c',
                                                                 '00:03:e6:5e:8d:86',
                                                                 '00:03:e6:5e:8d:94'],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:21:0d',
                                             'name': '7488 ROAD 164',
                                             'serial_number': 'BF24D1',
                                             'system_mac_address': None},
                'f8:85:f9:6f:22:05': {       'dev_macs': ['54:b8:0a:0f:4d:a3'],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:22:05',
                                             'name': '194 Ellen St. Atwood',
                                             'serial_number': 'BF24F1',
                                             'system_mac_address': None},
                'f8:85:f9:6f:22:a5': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:22:a5',
                                             'name': '248 Queen St. Atwood',
                                             'serial_number': 'BF2505',
                                             'system_mac_address': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': 'front',
                                                              'mac_address': 'cc:be:59:12:6a:c8',
                                                              'name': 'Craft-FE: front',
                                                              'oper_up': True,
                                                              'poller_hash': 'NzE3MDI5NzAyNjhmcm9udA=='},
                                                      {       'admin_up': False,
                                                              'id': 'rear',
                                                              'name': 'Craft-FE: rear',
                                                              'oper_up': False,
                                                              'poller_hash': 'NzE3MDI5NzAyNjhyZWFy'}],
                                'manufacturer': 'Calix',
                                'model': 'E7-2 (EXA)',
                                'modules': [       {       'id': '1',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '1/x3',
                                                                                         'in_discards': '22066471',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2055811800',
                                                                                         'in_octets': '3268271941218923',
                                                                                         'in_ucast_pkts': '7988630168557',
                                                                                         'mac_address': 'cc:be:59:12:6a:d7',
                                                                                         'manufacturer': 'FiberStore',
                                                                                         'model': 'SFP-10G-DAC',
                                                                                         'name': 'ethernet '
                                                                                                 '1/x3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '11186623188988',
                                                                                         'out_octets': '37751016217300259',
                                                                                         'out_ucast_pkts': '17718179369464',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS94Mw==',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/x4',
                                                                                         'in_discards': '3548079',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '29975911',
                                                                                         'in_octets': '1387085597679571',
                                                                                         'in_ucast_pkts': '1028599713923',
                                                                                         'mac_address': 'cc:be:59:12:6a:d8',
                                                                                         'manufacturer': 'FS',
                                                                                         'model': 'SFPP-PC02',
                                                                                         'name': 'MCCL-SUBS '
                                                                                                 '1/x4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '47548902',
                                                                                         'out_octets': '45622510171783',
                                                                                         'out_ucast_pkts': '186640701128',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4TUNDTC1TVUJTIDEveDQ=',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g1',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2564',
                                                                                         'in_octets': '682781',
                                                                                         'in_ucast_pkts': '3781',
                                                                                         'mac_address': 'cc:be:59:12:6a:c9',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01669',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '403942606',
                                                                                         'out_octets': '28616817959',
                                                                                         'out_ucast_pkts': '1106681',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nMQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g2',
                                                                                         'mac_address': 'cc:be:59:12:6a:ca',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nMg=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g3',
                                                                                         'mac_address': 'cc:be:59:12:6a:cb',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nMw=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g4',
                                                                                         'mac_address': 'cc:be:59:12:6a:cc',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nNA=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/1',
                                                                                         'in_discards': '170923',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '24508384',
                                                                                         'in_octets': '19459843771535',
                                                                                         'in_ucast_pkts': '75757688327',
                                                                                         'links': [       {       'in_nucast_pkts': '16762455',
                                                                                                                  'in_octets': '70204451740',
                                                                                                                  'in_ucast_pkts': '261058060',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4808925079',
                                                                                                                  'out_octets': '6788295262021',
                                                                                                                  'out_ucast_pkts': '662272233',
                                                                                                                  'poller_hash': 'MzIyOTAxcGVlcmludGZwb24gMw=='},
                                                                                                          {       'in_nucast_pkts': '80017',
                                                                                                                  'in_octets': '22791722679',
                                                                                                                  'in_ucast_pkts': '100201310',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2763651',
                                                                                                                  'out_octets': '960762354684',
                                                                                                                  'out_ucast_pkts': '662322966',
                                                                                                                  'poller_hash': 'OTU2RjA0cGVlcmludGZwb24gMjA='},
                                                                                                          {       'in_nucast_pkts': '1165849',
                                                                                                                  'in_octets': '51249230868',
                                                                                                                  'in_ucast_pkts': '125133744',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1853350146',
                                                                                                                  'out_octets': '2900462206228',
                                                                                                                  'out_ucast_pkts': '369607008',
                                                                                                                  'poller_hash': 'MUZDNEVGcGVlcmludGZwb24gNzI='},
                                                                                                          {       'in_nucast_pkts': '29192519',
                                                                                                                  'in_octets': '33142288765',
                                                                                                                  'in_ucast_pkts': '139018738',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13574695306',
                                                                                                                  'out_octets': '17908342000088',
                                                                                                                  'out_ucast_pkts': '384907984',
                                                                                                                  'poller_hash': 'NTVGQkE1cGVlcmludGZwb24gNzM='},
                                                                                                          {       'in_nucast_pkts': '24523505',
                                                                                                                  'in_octets': '287498003643',
                                                                                                                  'in_ucast_pkts': '648716563',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '21877025227',
                                                                                                                  'out_octets': '30665774126929',
                                                                                                                  'out_ucast_pkts': '1694183032',
                                                                                                                  'poller_hash': 'MkVEOUQwcGVlcmludGZwb24gNzQ='},
                                                                                                          {       'in_nucast_pkts': '6749',
                                                                                                                  'in_octets': '3852929289',
                                                                                                                  'in_ucast_pkts': '17880526',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2329409',
                                                                                                                  'out_octets': '22584770638',
                                                                                                                  'out_ucast_pkts': '24408100',
                                                                                                                  'poller_hash': 'NDE1MzBwZWVyaW50ZnBvbiA3NQ=='},
                                                                                                          {       'in_nucast_pkts': '4',
                                                                                                                  'in_octets': '28382784110',
                                                                                                                  'in_ucast_pkts': '201086947',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1213665',
                                                                                                                  'out_octets': '1135926935744',
                                                                                                                  'out_ucast_pkts': '802254093',
                                                                                                                  'poller_hash': 'NjQwQjRGcGVlcmludGZwb24gODc='},
                                                                                                          {       'in_nucast_pkts': '930044',
                                                                                                                  'in_octets': '143320015514',
                                                                                                                  'in_ucast_pkts': '163816235',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2615667',
                                                                                                                  'out_octets': '195894569301',
                                                                                                                  'out_ucast_pkts': '1035302301580',
                                                                                                                  'poller_hash': 'RjFGOHBlZXJpbnRmcG9uIDEwNw=='},
                                                                                                          {       'in_nucast_pkts': '11',
                                                                                                                  'in_octets': '84766214598',
                                                                                                                  'in_ucast_pkts': '329890166',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2329368',
                                                                                                                  'out_octets': '1614633842914',
                                                                                                                  'out_ucast_pkts': '1236212379',
                                                                                                                  'poller_hash': 'MzhGMUZEcGVlcmludGZwb24gMTA5'},
                                                                                                          {       'in_nucast_pkts': '7791',
                                                                                                                  'in_octets': '107264142604',
                                                                                                                  'in_ucast_pkts': '260519178',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2328744',
                                                                                                                  'out_octets': '779670150476',
                                                                                                                  'out_ucast_pkts': '647984720',
                                                                                                                  'poller_hash': 'MjVEOTM0cGVlcmludGZwb24gMTEw'},
                                                                                                          {       'in_nucast_pkts': '19866636',
                                                                                                                  'in_octets': '144157764298',
                                                                                                                  'in_ucast_pkts': '534301387',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '15214544349',
                                                                                                                  'out_octets': '21564080000991',
                                                                                                                  'out_ucast_pkts': '1223917547',
                                                                                                                  'poller_hash': 'NTVFMTIzcGVlcmludGZwb24gMTEx'},
                                                                                                          {       'in_nucast_pkts': '8820381',
                                                                                                                  'in_octets': '15932578317',
                                                                                                                  'in_ucast_pkts': '36170373',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10986459275',
                                                                                                                  'out_octets': '14678008998841',
                                                                                                                  'out_ucast_pkts': '106761744',
                                                                                                                  'poller_hash': 'MTk5OUM1cGVlcmludGZwb24gMTEy'},
                                                                                                          {       'in_nucast_pkts': '76518',
                                                                                                                  'in_octets': '30022906092',
                                                                                                                  'in_ucast_pkts': '131042508',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1213678',
                                                                                                                  'out_octets': '458662916474',
                                                                                                                  'out_ucast_pkts': '348536866',
                                                                                                                  'poller_hash': 'NDU1NjczcGVlcmludGZwb24gMTEz'},
                                                                                                          {       'in_nucast_pkts': '682561',
                                                                                                                  'in_octets': '24342877742',
                                                                                                                  'in_ucast_pkts': '322518895',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2261822',
                                                                                                                  'out_octets': '27878800578',
                                                                                                                  'out_ucast_pkts': '402115856',
                                                                                                                  'poller_hash': 'QTlDOEY5cGVlcmludGZwb24gMTE0'},
                                                                                                          {       'in_nucast_pkts': '1004837',
                                                                                                                  'in_octets': '11890079618',
                                                                                                                  'in_ucast_pkts': '86456303',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2239470965',
                                                                                                                  'out_octets': '3528418988788',
                                                                                                                  'out_ucast_pkts': '389255172',
                                                                                                                  'poller_hash': 'MkZDQzM4cGVlcmludGZwb24gMTc2'},
                                                                                                          {       'in_nucast_pkts': '71',
                                                                                                                  'in_octets': '18503449161',
                                                                                                                  'in_ucast_pkts': '101314460',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1062411',
                                                                                                                  'out_octets': '617482604456',
                                                                                                                  'out_ucast_pkts': '427283810',
                                                                                                                  'poller_hash': 'QzgyMTMxcGVlcmludGZwb24gMTYxNjU3'},
                                                                                                          {       'in_nucast_pkts': '63899',
                                                                                                                  'in_octets': '15344278556',
                                                                                                                  'in_ucast_pkts': '84573984',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2792830',
                                                                                                                  'out_octets': '407629398128',
                                                                                                                  'out_ucast_pkts': '304469223',
                                                                                                                  'poller_hash': 'QzgzQjk3cGVlcmludGZwb24gMTcwNzEy'},
                                                                                                          {       'in_nucast_pkts': '5594968',
                                                                                                                  'in_octets': '1812704054',
                                                                                                                  'in_ucast_pkts': '6871053',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '16431809508',
                                                                                                                  'out_octets': '21860732239386',
                                                                                                                  'out_ucast_pkts': '5056521',
                                                                                                                  'poller_hash': 'QzgxQ0JFcGVlcmludGZwb24gMjA2Njgw'},
                                                                                                          {       'in_nucast_pkts': '2228',
                                                                                                                  'in_octets': '34516397798',
                                                                                                                  'in_ucast_pkts': '211983475',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10981485',
                                                                                                                  'out_octets': '1410318759746',
                                                                                                                  'out_ucast_pkts': '1002859845',
                                                                                                                  'poller_hash': 'MTE5NTE1MXBlZXJpbnRmcG9uIDIxNDYyMA=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '670250914706',
                                                                                         'out_octets': '1177828149076297',
                                                                                         'out_ucast_pkts': '206279751628',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzE=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/1',
                                                                                                                 'id': '1/1',
                                                                                                                 'links': [       {       'connected_time': '22611148',
                                                                                                                                          'fiber_length': 1957,
                                                                                                                                          'poller_hash': 'MzIyOTAxcGVlcnBvbnBvbiAz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '3157666',
                                                                                                                                          'fiber_length': 1818,
                                                                                                                                          'poller_hash': 'OTU2RjA0cGVlcnBvbnBvbiAyMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '3157686',
                                                                                                                                          'fiber_length': 1840,
                                                                                                                                          'poller_hash': 'MUZDNEVGcGVlcnBvbnBvbiA3Mg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '22596255',
                                                                                                                                          'fiber_length': 1895,
                                                                                                                                          'poller_hash': 'NTVGQkE1cGVlcnBvbnBvbiA3Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '22596070',
                                                                                                                                          'fiber_length': 1848,
                                                                                                                                          'poller_hash': 'MkVEOUQwcGVlcnBvbnBvbiA3NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '7140142',
                                                                                                                                          'fiber_length': 1837,
                                                                                                                                          'poller_hash': 'NDE1MzBwZWVycG9ucG9uIDc1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '3157665',
                                                                                                                                          'fiber_length': 1476,
                                                                                                                                          'poller_hash': 'NjQwQjRGcGVlcnBvbnBvbiA4Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '22595614',
                                                                                                                                          'fiber_length': 1677,
                                                                                                                                          'poller_hash': 'RjFGOHBlZXJwb25wb24gMTA3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '7140204',
                                                                                                                                          'fiber_length': 1731,
                                                                                                                                          'poller_hash': 'MzhGMUZEcGVlcnBvbnBvbiAxMDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '7140171',
                                                                                                                                          'fiber_length': 1740,
                                                                                                                                          'poller_hash': 'MjVEOTM0cGVlcnBvbnBvbiAxMTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '22595819',
                                                                                                                                          'fiber_length': 1735,
                                                                                                                                          'poller_hash': 'NTVFMTIzcGVlcnBvbnBvbiAxMTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '7140270',
                                                                                                                                          'fiber_length': 1714,
                                                                                                                                          'poller_hash': 'MTk5OUM1cGVlcnBvbnBvbiAxMTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '3157715',
                                                                                                                                          'fiber_length': 1671,
                                                                                                                                          'poller_hash': 'NDU1NjczcGVlcnBvbnBvbiAxMTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '3157718',
                                                                                                                                          'fiber_length': 1876,
                                                                                                                                          'poller_hash': 'QTlDOEY5cGVlcnBvbnBvbiAxMTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '3157733',
                                                                                                                                          'fiber_length': 1677,
                                                                                                                                          'poller_hash': 'MkZDQzM4cGVlcnBvbnBvbiAxNzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '2057344',
                                                                                                                                          'fiber_length': 1800,
                                                                                                                                          'poller_hash': 'QzgyMTMxcGVlcnBvbnBvbiAxNjE2NTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '3157903',
                                                                                                                                          'fiber_length': 1525,
                                                                                                                                          'poller_hash': 'QzgzQjk3cGVlcnBvbnBvbiAxNzA3MTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '22611304',
                                                                                                                                          'fiber_length': 1970,
                                                                                                                                          'poller_hash': 'QzgxQ0JFcGVlcnBvbnBvbiAyMDY2ODA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '21284641',
                                                                                                                                          'fiber_length': 1831,
                                                                                                                                          'poller_hash': 'MTE5NTE1MXBlZXJwb25wb24gMjE0NjIw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/1',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzE=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/2',
                                                                                         'in_discards': '3127',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '17222329',
                                                                                         'in_octets': '16169577909766',
                                                                                         'in_ucast_pkts': '85410354182',
                                                                                         'links': [       {       'in_nucast_pkts': '28984453',
                                                                                                                  'in_octets': '2109553826724',
                                                                                                                  'in_ucast_pkts': '3261872744',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '35821247014',
                                                                                                                  'out_octets': '54925610933453',
                                                                                                                  'out_ucast_pkts': '5637297806',
                                                                                                                  'poller_hash': 'M0ZCMzVEcGVlcmludGZwb24gMjg='},
                                                                                                          {       'in_nucast_pkts': '2629',
                                                                                                                  'in_octets': '21342295399',
                                                                                                                  'in_ucast_pkts': '103849977',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '26377',
                                                                                                                  'out_octets': '277002248617',
                                                                                                                  'out_ucast_pkts': '217886450',
                                                                                                                  'poller_hash': 'QzU3Q0RwZWVyaW50ZnBvbiA0OQ=='},
                                                                                                          {       'in_nucast_pkts': '28344454',
                                                                                                                  'in_octets': '34717765451',
                                                                                                                  'in_ucast_pkts': '88054333',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '30009120892',
                                                                                                                  'out_octets': '40675136634688',
                                                                                                                  'out_ucast_pkts': '216851673',
                                                                                                                  'poller_hash': 'QkYyMzRCcGVlcmludGZwb24gMTE2'},
                                                                                                          {       'in_nucast_pkts': '11932314',
                                                                                                                  'in_octets': '124698278476',
                                                                                                                  'in_ucast_pkts': '415847780',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3348111483',
                                                                                                                  'out_octets': '5004114340649',
                                                                                                                  'out_ucast_pkts': '1269365098',
                                                                                                                  'poller_hash': 'MkM5RUQ0cGVlcmludGZwb24gMTE3'},
                                                                                                          {       'in_nucast_pkts': '7',
                                                                                                                  'in_octets': '20674265441',
                                                                                                                  'in_ucast_pkts': '203764808',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2792890',
                                                                                                                  'out_octets': '688076286006',
                                                                                                                  'out_ucast_pkts': '467146989',
                                                                                                                  'poller_hash': 'QzgzQjk4cGVlcmludGZwb24gMTcxNzA5'},
                                                                                                          {       'in_nucast_pkts': '1574380',
                                                                                                                  'in_octets': '1692152168',
                                                                                                                  'in_ucast_pkts': '6766974',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4339553678',
                                                                                                                  'out_octets': '5760537432394',
                                                                                                                  'out_ucast_pkts': '9636651',
                                                                                                                  'poller_hash': 'MTE5NTFBOXBlZXJpbnRmcG9uIDIxNjAwOQ=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '721876051727',
                                                                                         'out_octets': '1207351947282154',
                                                                                         'out_ucast_pkts': '191895877851',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzI=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/2',
                                                                                                                 'id': '1/2',
                                                                                                                 'links': [       {       'connected_time': '22596031',
                                                                                                                                          'fiber_length': 1169,
                                                                                                                                          'poller_hash': 'M0ZCMzVEcGVlcnBvbnBvbiAyOA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '3157643',
                                                                                                                                          'fiber_length': 1160,
                                                                                                                                          'poller_hash': 'QzU3Q0RwZWVycG9ucG9uIDQ5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '22595913',
                                                                                                                                          'fiber_length': 1117,
                                                                                                                                          'poller_hash': 'QkYyMzRCcGVlcnBvbnBvbiAxMTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '22595930',
                                                                                                                                          'fiber_length': 1104,
                                                                                                                                          'poller_hash': 'MkM5RUQ0cGVlcnBvbnBvbiAxMTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '3157911',
                                                                                                                                          'fiber_length': 498,
                                                                                                                                          'poller_hash': 'QzgzQjk4cGVlcnBvbnBvbiAxNzE3MDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '3157897',
                                                                                                                                          'fiber_length': 1188,
                                                                                                                                          'poller_hash': 'MTE5NTFBOXBlZXJwb25wb24gMjE2MDA5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/2',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzI=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/3',
                                                                                         'in_discards': '43192',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '4845113',
                                                                                         'in_octets': '16920488771062',
                                                                                         'in_ucast_pkts': '81943958358',
                                                                                         'links': [       {       'in_nucast_pkts': '7',
                                                                                                                  'in_octets': '4982758078',
                                                                                                                  'in_ucast_pkts': '24305068',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2792513',
                                                                                                                  'out_octets': '220213841595',
                                                                                                                  'out_ucast_pkts': '164115572',
                                                                                                                  'poller_hash': 'ODcyNDFCcGVlcmludGZwb24gMzE='},
                                                                                                          {       'in_nucast_pkts': '29071',
                                                                                                                  'in_octets': '43004740334',
                                                                                                                  'in_ucast_pkts': '175432776',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2792452',
                                                                                                                  'out_octets': '881512971642',
                                                                                                                  'out_ucast_pkts': '651400316',
                                                                                                                  'poller_hash': 'QjUxMEUycGVlcmludGZwb24gMzY='},
                                                                                                          {       'in_nucast_pkts': '7277298',
                                                                                                                  'in_octets': '36662378914',
                                                                                                                  'in_ucast_pkts': '348766566',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1623066761',
                                                                                                                  'out_octets': '4335528267458',
                                                                                                                  'out_ucast_pkts': '1613365308',
                                                                                                                  'poller_hash': 'MzIxMDMzcGVlcmludGZwb24gNDQ='},
                                                                                                          {       'in_nucast_pkts': '4529892',
                                                                                                                  'in_octets': '677606086057',
                                                                                                                  'in_ucast_pkts': '1673832387',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11686271',
                                                                                                                  'out_octets': '5543450301974',
                                                                                                                  'out_ucast_pkts': '4108369543',
                                                                                                                  'poller_hash': 'QTlDNzg2cGVlcmludGZwb24gODU='},
                                                                                                          {       'in_nucast_pkts': '4081',
                                                                                                                  'in_octets': '70074000755',
                                                                                                                  'in_ucast_pkts': '585501519',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2615593',
                                                                                                                  'out_octets': '2274446777954',
                                                                                                                  'out_ucast_pkts': '5895925382',
                                                                                                                  'poller_hash': 'M0NGNEFwZWVyaW50ZnBvbiAxMjE='},
                                                                                                          {       'in_nucast_pkts': '17722',
                                                                                                                  'in_octets': '470653155986',
                                                                                                                  'in_ucast_pkts': '3576736550',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2613252',
                                                                                                                  'out_octets': '12610479856500',
                                                                                                                  'out_ucast_pkts': '13228952463',
                                                                                                                  'poller_hash': 'NDE1QjBwZWVyaW50ZnBvbiAxMjI='},
                                                                                                          {       'in_nucast_pkts': '6934',
                                                                                                                  'in_octets': '43834594959',
                                                                                                                  'in_ucast_pkts': '118049750',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2596567',
                                                                                                                  'out_octets': '726784151362',
                                                                                                                  'out_ucast_pkts': '568657384',
                                                                                                                  'poller_hash': 'NzIyMDY1cGVlcmludGZwb24gMTI0'},
                                                                                                          {       'in_nucast_pkts': '224544',
                                                                                                                  'in_octets': '119190752531',
                                                                                                                  'in_ucast_pkts': '591159734',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2616094',
                                                                                                                  'out_octets': '3359658297766',
                                                                                                                  'out_ucast_pkts': '2515823928',
                                                                                                                  'poller_hash': 'NEUzNkE4cGVlcmludGZwb24gMTI2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MkU5MTRBcGVlcmludGZwb24gMTM1'},
                                                                                                          {       'in_nucast_pkts': '394253',
                                                                                                                  'in_octets': '3991700274',
                                                                                                                  'in_ucast_pkts': '32695244',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '952726',
                                                                                                                  'out_octets': '147105647292',
                                                                                                                  'out_ucast_pkts': '99627080',
                                                                                                                  'poller_hash': 'ODcyNTM1cGVlcmludGZwb24gMTM2'},
                                                                                                          {       'in_nucast_pkts': '4794',
                                                                                                                  'in_octets': '10595090791',
                                                                                                                  'in_ucast_pkts': '67004529',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1213695',
                                                                                                                  'out_octets': '314468133244',
                                                                                                                  'out_ucast_pkts': '227558734',
                                                                                                                  'poller_hash': 'MTMwMDlBcGVlcmludGZwb24gMTM4'},
                                                                                                          {       'in_nucast_pkts': '161',
                                                                                                                  'in_octets': '26328890944',
                                                                                                                  'in_ucast_pkts': '325498906',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2329258',
                                                                                                                  'out_octets': '832926222817',
                                                                                                                  'out_ucast_pkts': '567448275',
                                                                                                                  'poller_hash': 'RjIzQXBlZXJpbnRmcG9uIDEzOQ=='},
                                                                                                          {       'in_nucast_pkts': '207532',
                                                                                                                  'in_octets': '730525013123',
                                                                                                                  'in_ucast_pkts': '1801704287',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2616077',
                                                                                                                  'out_octets': '8808208337119',
                                                                                                                  'out_ucast_pkts': '6736440732',
                                                                                                                  'poller_hash': 'MzI5NjQycGVlcmludGZwb24gMTQy'},
                                                                                                          {       'in_nucast_pkts': '20772',
                                                                                                                  'in_octets': '112474982429',
                                                                                                                  'in_ucast_pkts': '777285870',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2615565',
                                                                                                                  'out_octets': '4137233533511',
                                                                                                                  'out_ucast_pkts': '7209983971',
                                                                                                                  'poller_hash': 'M0NDMDhwZWVyaW50ZnBvbiAxNDQ='},
                                                                                                          {       'in_nucast_pkts': '174938',
                                                                                                                  'in_octets': '25300072394',
                                                                                                                  'in_ucast_pkts': '180012004',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2329266',
                                                                                                                  'out_octets': '666219322589',
                                                                                                                  'out_ucast_pkts': '471063200',
                                                                                                                  'poller_hash': 'QzU4NkJwZWVyaW50ZnBvbiAxNDY='},
                                                                                                          {       'in_nucast_pkts': '91769',
                                                                                                                  'in_octets': '334947715734',
                                                                                                                  'in_ucast_pkts': '741441216',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2617167',
                                                                                                                  'out_octets': '3929250222649',
                                                                                                                  'out_ucast_pkts': '7214024163',
                                                                                                                  'poller_hash': 'M0NGNEVwZWVyaW50ZnBvbiAxNDg='},
                                                                                                          {       'in_nucast_pkts': '9687',
                                                                                                                  'in_octets': '62802201826',
                                                                                                                  'in_ucast_pkts': '397677676',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2615513',
                                                                                                                  'out_octets': '3106325405985',
                                                                                                                  'out_ucast_pkts': '2166569533',
                                                                                                                  'poller_hash': 'MTk5QTI1cGVlcmludGZwb24gMTUw'},
                                                                                                          {       'in_nucast_pkts': '13056275',
                                                                                                                  'in_octets': '65403877968',
                                                                                                                  'in_ucast_pkts': '182579225',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '15060366116',
                                                                                                                  'out_octets': '20316615158424',
                                                                                                                  'out_ucast_pkts': '658477763',
                                                                                                                  'poller_hash': 'MTk5QTM5cGVlcmludGZwb24gMTUx'},
                                                                                                          {       'in_nucast_pkts': '31159',
                                                                                                                  'in_octets': '1392650361',
                                                                                                                  'in_ucast_pkts': '3682858',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13922460',
                                                                                                                  'out_octets': '10369663108',
                                                                                                                  'out_ucast_pkts': '12016088',
                                                                                                                  'poller_hash': 'QzgzMjEycGVlcmludGZwb24gMTUz'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MTM1MzhwZWVyaW50ZnBvbiAxNTQ='},
                                                                                                          {       'in_nucast_pkts': '26290394',
                                                                                                                  'in_octets': '680103968783',
                                                                                                                  'in_ucast_pkts': '1098372876',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '36378197396',
                                                                                                                  'out_octets': '53317609750415',
                                                                                                                  'out_ucast_pkts': '3646369748',
                                                                                                                  'poller_hash': 'NzFEODBBcGVlcmludGZwb24gMTU1'},
                                                                                                          {       'in_nucast_pkts': '2414303',
                                                                                                                  'in_octets': '34256232016',
                                                                                                                  'in_ucast_pkts': '153611015',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2280710469',
                                                                                                                  'out_octets': '3550306293972',
                                                                                                                  'out_ucast_pkts': '381007732',
                                                                                                                  'poller_hash': 'QjBBMkEwcGVlcmludGZwb24gMTUwODcy'},
                                                                                                          {       'in_nucast_pkts': '21229520',
                                                                                                                  'in_octets': '270487643737',
                                                                                                                  'in_ucast_pkts': '1474452418',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '18587767777',
                                                                                                                  'out_octets': '31041611545175',
                                                                                                                  'out_ucast_pkts': '4509608102',
                                                                                                                  'poller_hash': 'QkYyMUU4cGVlcmludGZwb24gMTY0MDYz'},
                                                                                                          {       'in_nucast_pkts': '292',
                                                                                                                  'in_octets': '7928485781',
                                                                                                                  'in_ucast_pkts': '31936544',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1630758',
                                                                                                                  'out_octets': '114602780717',
                                                                                                                  'out_ucast_pkts': '84936349',
                                                                                                                  'poller_hash': 'QzgzQkJCcGVlcmludGZwb24gMTcyMzA5'},
                                                                                                          {       'in_nucast_pkts': '5846594',
                                                                                                                  'in_octets': '32810123647',
                                                                                                                  'in_ucast_pkts': '234104953',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8722062662',
                                                                                                                  'out_octets': '12047667765035',
                                                                                                                  'out_ucast_pkts': '512449958',
                                                                                                                  'poller_hash': 'QzgxNUYxcGVlcmludGZwb24gMjA3MzUy'},
                                                                                                          {       'in_nucast_pkts': '20',
                                                                                                                  'in_octets': '51888542082',
                                                                                                                  'in_ucast_pkts': '310291829',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2792898',
                                                                                                                  'out_octets': '2377415312085',
                                                                                                                  'out_ucast_pkts': '1665087387',
                                                                                                                  'poller_hash': 'MTFCMjJCRHBlZXJpbnRmcG9uIDIxMjA4OA=='},
                                                                                                          {       'in_nucast_pkts': '12819',
                                                                                                                  'in_octets': '52801852771',
                                                                                                                  'in_ucast_pkts': '458959477',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '105358',
                                                                                                                  'out_octets': '2139162809315',
                                                                                                                  'out_ucast_pkts': '1496041891',
                                                                                                                  'poller_hash': 'NDcxQzYzcGVlcmludGZwb24gMjI0Njc5'},
                                                                                                          {       'in_nucast_pkts': '13919',
                                                                                                                  'in_octets': '8460733575',
                                                                                                                  'in_ucast_pkts': '27853984',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '368830',
                                                                                                                  'out_octets': '129004056659',
                                                                                                                  'out_ucast_pkts': '99298371',
                                                                                                                  'poller_hash': 'MTI3NDlFM3BlZXJpbnRmcG9uIDIzODM4MQ=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '482578398622',
                                                                                         'out_octets': '1025856430803115',
                                                                                         'out_ucast_pkts': '266309199984',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzM=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/3',
                                                                                                                 'id': '1/3',
                                                                                                                 'links': [       {       'connected_time': '3157647',
                                                                                                                                          'fiber_length': 1137,
                                                                                                                                          'poller_hash': 'ODcyNDFCcGVlcnBvbnBvbiAzMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '3157781',
                                                                                                                                          'fiber_length': 1008,
                                                                                                                                          'poller_hash': 'QjUxMEUycGVlcnBvbnBvbiAzNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '9922932',
                                                                                                                                          'fiber_length': 982,
                                                                                                                                          'poller_hash': 'MzIxMDMzcGVlcnBvbnBvbiA0NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '22611303',
                                                                                                                                          'fiber_length': 1125,
                                                                                                                                          'poller_hash': 'QTlDNzg2cGVlcnBvbnBvbiA4NQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '22595776',
                                                                                                                                          'fiber_length': 1090,
                                                                                                                                          'poller_hash': 'M0NGNEFwZWVycG9ucG9uIDEyMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '22595756',
                                                                                                                                          'fiber_length': 1070,
                                                                                                                                          'poller_hash': 'NDE1QjBwZWVycG9ucG9uIDEyMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '22596146',
                                                                                                                                          'fiber_length': 1128,
                                                                                                                                          'poller_hash': 'NzIyMDY1cGVlcnBvbnBvbiAxMjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '22596036',
                                                                                                                                          'fiber_length': 1156,
                                                                                                                                          'poller_hash': 'NEUzNkE4cGVlcnBvbnBvbiAxMjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '22596041',
                                                                                                                                          'fiber_length': 956,
                                                                                                                                          'poller_hash': 'MkU5MTRBcGVlcnBvbnBvbiAxMzU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '774556',
                                                                                                                                          'fiber_length': 1017,
                                                                                                                                          'poller_hash': 'ODcyNTM1cGVlcnBvbnBvbiAxMzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '3157715',
                                                                                                                                          'fiber_length': 958,
                                                                                                                                          'poller_hash': 'MTMwMDlBcGVlcnBvbnBvbiAxMzg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '7140271',
                                                                                                                                          'fiber_length': 825,
                                                                                                                                          'poller_hash': 'RjIzQXBlZXJwb25wb24gMTM5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '22596217',
                                                                                                                                          'fiber_length': 837,
                                                                                                                                          'poller_hash': 'MzI5NjQycGVlcnBvbnBvbiAxNDI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '22595858',
                                                                                                                                          'fiber_length': 708,
                                                                                                                                          'poller_hash': 'M0NDMDhwZWVycG9ucG9uIDE0NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '7140182',
                                                                                                                                          'fiber_length': 726,
                                                                                                                                          'poller_hash': 'QzU4NkJwZWVycG9ucG9uIDE0Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '22595849',
                                                                                                                                          'fiber_length': 571,
                                                                                                                                          'poller_hash': 'M0NGNEVwZWVycG9ucG9uIDE0OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '22596104',
                                                                                                                                          'fiber_length': 614,
                                                                                                                                          'poller_hash': 'MTk5QTI1cGVlcnBvbnBvbiAxNTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '22596057',
                                                                                                                                          'fiber_length': 751,
                                                                                                                                          'poller_hash': 'MTk5QTM5cGVlcnBvbnBvbiAxNTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '22610889',
                                                                                                                                          'fiber_length': 742,
                                                                                                                                          'poller_hash': 'QzgzMjEycGVlcnBvbnBvbiAxNTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '7140025',
                                                                                                                                          'fiber_length': 608,
                                                                                                                                          'poller_hash': 'MTM1MzhwZWVycG9ucG9uIDE1NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '22595983',
                                                                                                                                          'fiber_length': 672,
                                                                                                                                          'poller_hash': 'NzFEODBBcGVlcnBvbnBvbiAxNTU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '3157880',
                                                                                                                                          'fiber_length': 1026,
                                                                                                                                          'poller_hash': 'QjBBMkEwcGVlcnBvbnBvbiAxNTA4NzI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '22596243',
                                                                                                                                          'fiber_length': 682,
                                                                                                                                          'poller_hash': 'QkYyMUU4cGVlcnBvbnBvbiAxNjQwNjM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '3157860',
                                                                                                                                          'fiber_length': 1206,
                                                                                                                                          'poller_hash': 'QzgzQkJCcGVlcnBvbnBvbiAxNzIzMDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '22611474',
                                                                                                                                          'fiber_length': 930,
                                                                                                                                          'poller_hash': 'QzgxNUYxcGVlcnBvbnBvbiAyMDczNTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '3157904',
                                                                                                                                          'fiber_length': 856,
                                                                                                                                          'poller_hash': 'MTFCMjJCRHBlZXJwb25wb24gMjEyMDg4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '12614621',
                                                                                                                                          'fiber_length': 657,
                                                                                                                                          'poller_hash': 'NDcxQzYzcGVlcnBvbnBvbiAyMjQ2Nzk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617},
                                                                                                                                  {       'connected_time': '713389',
                                                                                                                                          'fiber_length': 923,
                                                                                                                                          'poller_hash': 'MTI3NDlFM3BlZXJwb25wb24gMjM4Mzgx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.617}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/3',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzM=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/4',
                                                                                         'in_discards': '175614',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2041401',
                                                                                         'in_octets': '13643534817843',
                                                                                         'in_ucast_pkts': '54606225674',
                                                                                         'links': [       {       'in_nucast_pkts': '17221999',
                                                                                                                  'in_octets': '5435997639',
                                                                                                                  'in_ucast_pkts': '20349986',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '40783913661',
                                                                                                                  'out_octets': '53925606990237',
                                                                                                                  'out_ucast_pkts': '15054214',
                                                                                                                  'poller_hash': 'MzIyM0Y5cGVlcmludGZwb24gOQ=='},
                                                                                                          {       'in_nucast_pkts': '101',
                                                                                                                  'in_octets': '24073246237',
                                                                                                                  'in_ucast_pkts': '196569434',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '26380',
                                                                                                                  'out_octets': '721472616815',
                                                                                                                  'out_ucast_pkts': '501329898',
                                                                                                                  'poller_hash': 'M0FERDZFcGVlcmludGZwb24gMTc='},
                                                                                                          {       'in_nucast_pkts': '20733',
                                                                                                                  'in_octets': '800925056357',
                                                                                                                  'in_ucast_pkts': '2700856227',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '189398',
                                                                                                                  'out_octets': '8058666123633',
                                                                                                                  'out_ucast_pkts': '5933649850',
                                                                                                                  'poller_hash': 'NEQ0MUY0cGVlcmludGZwb24gMjk='},
                                                                                                          {       'in_nucast_pkts': '16332109',
                                                                                                                  'in_octets': '978475133395',
                                                                                                                  'in_ucast_pkts': '3051523039',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8916520783',
                                                                                                                  'out_octets': '24145082992873',
                                                                                                                  'out_ucast_pkts': '9044267762',
                                                                                                                  'poller_hash': 'Mzk2MUE5cGVlcmludGZwb24gNTA='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MUM1RENGcGVlcmludGZwb24gOTM='},
                                                                                                          {       'in_nucast_pkts': '1278251',
                                                                                                                  'in_octets': '2660997041',
                                                                                                                  'in_ucast_pkts': '9252330',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1910595268',
                                                                                                                  'out_octets': '2556786871843',
                                                                                                                  'out_ucast_pkts': '29701497',
                                                                                                                  'poller_hash': 'QzU4NTBwZWVyaW50ZnBvbiAxNTc='},
                                                                                                          {       'in_nucast_pkts': '18864859',
                                                                                                                  'in_octets': '319227208970',
                                                                                                                  'in_ucast_pkts': '1563186402',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11809629756',
                                                                                                                  'out_octets': '20606665280780',
                                                                                                                  'out_ucast_pkts': '3945726834',
                                                                                                                  'poller_hash': 'NTVGQkQ2cGVlcmludGZwb24gMTU5'},
                                                                                                          {       'in_nucast_pkts': '10530',
                                                                                                                  'in_octets': '74101747140',
                                                                                                                  'in_ucast_pkts': '697207282',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2619367',
                                                                                                                  'out_octets': '3020010197614',
                                                                                                                  'out_ucast_pkts': '1037201666350',
                                                                                                                  'poller_hash': 'MTMwM0RwZWVyaW50ZnBvbiAxNjA='},
                                                                                                          {       'in_nucast_pkts': '6534920',
                                                                                                                  'in_octets': '81818762376',
                                                                                                                  'in_ucast_pkts': '275123810',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2228570765',
                                                                                                                  'out_octets': '3529686668837',
                                                                                                                  'out_ucast_pkts': '584685192',
                                                                                                                  'poller_hash': 'MTk5QTFCcGVlcmludGZwb24gMTYx'},
                                                                                                          {       'in_nucast_pkts': '1770462',
                                                                                                                  'in_octets': '143562063635',
                                                                                                                  'in_ucast_pkts': '690333833',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2499090082',
                                                                                                                  'out_octets': '6978646126070',
                                                                                                                  'out_ucast_pkts': '2615842715',
                                                                                                                  'poller_hash': 'MjQ4QUU2cGVlcmludGZwb24gMTYy'},
                                                                                                          {       'in_nucast_pkts': '3957911',
                                                                                                                  'in_octets': '280926042735',
                                                                                                                  'in_ucast_pkts': '1490806869',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5230704',
                                                                                                                  'out_octets': '7575383843528',
                                                                                                                  'out_ucast_pkts': '5519408793',
                                                                                                                  'poller_hash': 'MTYxMDIxcGVlcmludGZwb24gMTYz'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MjQ4QUQ3cGVlcmludGZwb24gMTY0'},
                                                                                                          {       'in_nucast_pkts': '72722',
                                                                                                                  'in_octets': '132194680389',
                                                                                                                  'in_ucast_pkts': '492864355',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2615437',
                                                                                                                  'out_octets': '1010528083227',
                                                                                                                  'out_ucast_pkts': '932756342',
                                                                                                                  'poller_hash': 'Mzc4OEMxcGVlcmludGZwb24gMTY1'},
                                                                                                          {       'in_nucast_pkts': '2706',
                                                                                                                  'in_octets': '20544286587',
                                                                                                                  'in_ucast_pkts': '130742288',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1213694',
                                                                                                                  'out_octets': '536216131247',
                                                                                                                  'out_ucast_pkts': '383061699',
                                                                                                                  'poller_hash': 'MkZDQ0UxcGVlcmludGZwb24gMTY2'},
                                                                                                          {       'in_nucast_pkts': '5923168',
                                                                                                                  'in_octets': '122022322021',
                                                                                                                  'in_ucast_pkts': '591964696',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '14675963429',
                                                                                                                  'out_octets': '23223427685402',
                                                                                                                  'out_ucast_pkts': '2693188877',
                                                                                                                  'poller_hash': 'QzgzQkFFcGVlcmludGZwb24gMTY2MTIx'},
                                                                                                          {       'in_nucast_pkts': '194472',
                                                                                                                  'in_octets': '232456341',
                                                                                                                  'in_ucast_pkts': '685624',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1660490',
                                                                                                                  'out_octets': '328968239',
                                                                                                                  'out_ucast_pkts': '603883',
                                                                                                                  'poller_hash': 'QzgxRDZGcGVlcmludGZwb24gMjExNjUz'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '343895232662',
                                                                                         'out_octets': '676833525583247',
                                                                                         'out_ucast_pkts': '154969972688',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzQ=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/4',
                                                                                                                 'id': '1/4',
                                                                                                                 'links': [       {       'connected_time': '22611221',
                                                                                                                                          'fiber_length': 662,
                                                                                                                                          'poller_hash': 'MzIyM0Y5cGVlcnBvbnBvbiA5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.703},
                                                                                                                                  {       'connected_time': '3157649',
                                                                                                                                          'fiber_length': 518,
                                                                                                                                          'poller_hash': 'M0FERDZFcGVlcnBvbnBvbiAxNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.703},
                                                                                                                                  {       'connected_time': '22596210',
                                                                                                                                          'fiber_length': 545,
                                                                                                                                          'poller_hash': 'NEQ0MUY0cGVlcnBvbnBvbiAyOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.703},
                                                                                                                                  {       'connected_time': '22596199',
                                                                                                                                          'fiber_length': 536,
                                                                                                                                          'poller_hash': 'Mzk2MUE5cGVlcnBvbnBvbiA1MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.703},
                                                                                                                                  {       'connected_time': '22596012',
                                                                                                                                          'fiber_length': 166,
                                                                                                                                          'poller_hash': 'MUM1RENGcGVlcnBvbnBvbiA5Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.703},
                                                                                                                                  {       'connected_time': '3157644',
                                                                                                                                          'fiber_length': 593,
                                                                                                                                          'poller_hash': 'QzU4NTBwZWVycG9ucG9uIDE1Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.703},
                                                                                                                                  {       'connected_time': '22596090',
                                                                                                                                          'fiber_length': 484,
                                                                                                                                          'poller_hash': 'NTVGQkQ2cGVlcnBvbnBvbiAxNTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.703},
                                                                                                                                  {       'connected_time': '22595398',
                                                                                                                                          'fiber_length': 358,
                                                                                                                                          'poller_hash': 'MTMwM0RwZWVycG9ucG9uIDE2MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.703},
                                                                                                                                  {       'connected_time': '7140327',
                                                                                                                                          'fiber_length': 539,
                                                                                                                                          'poller_hash': 'MTk5QTFCcGVlcnBvbnBvbiAxNjE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.703},
                                                                                                                                  {       'connected_time': '22596174',
                                                                                                                                          'fiber_length': 573,
                                                                                                                                          'poller_hash': 'MjQ4QUU2cGVlcnBvbnBvbiAxNjI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.703},
                                                                                                                                  {       'connected_time': '22596246',
                                                                                                                                          'fiber_length': 514,
                                                                                                                                          'poller_hash': 'MTYxMDIxcGVlcnBvbnBvbiAxNjM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.703},
                                                                                                                                  {       'connected_time': '7140324',
                                                                                                                                          'fiber_length': 582,
                                                                                                                                          'poller_hash': 'MjQ4QUQ3cGVlcnBvbnBvbiAxNjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.703},
                                                                                                                                  {       'connected_time': '22596067',
                                                                                                                                          'fiber_length': 612,
                                                                                                                                          'poller_hash': 'Mzc4OEMxcGVlcnBvbnBvbiAxNjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.703},
                                                                                                                                  {       'connected_time': '3157728',
                                                                                                                                          'fiber_length': 647,
                                                                                                                                          'poller_hash': 'MkZDQ0UxcGVlcnBvbnBvbiAxNjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.703},
                                                                                                                                  {       'connected_time': '22611560',
                                                                                                                                          'fiber_length': 667,
                                                                                                                                          'poller_hash': 'QzgzQkFFcGVlcnBvbnBvbiAxNjYxMjE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.703},
                                                                                                                                  {       'connected_time': '3157915',
                                                                                                                                          'fiber_length': 1018,
                                                                                                                                          'poller_hash': 'QzgxRDZGcGVlcnBvbnBvbiAyMTE2NTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.703}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/4',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzQ=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/5',
                                                                                         'in_discards': '10449',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '55837193',
                                                                                         'in_octets': '35950665107414',
                                                                                         'in_ucast_pkts': '112748207646',
                                                                                         'links': [       {       'in_nucast_pkts': '86612',
                                                                                                                  'in_octets': '7246134184761',
                                                                                                                  'in_ucast_pkts': '10167968578',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11921',
                                                                                                                  'out_octets': '25102930859642',
                                                                                                                  'out_ucast_pkts': '21175022139',
                                                                                                                  'poller_hash': 'NEQ0MjUwcGVlcmludGZwb24gNg=='},
                                                                                                          {       'in_nucast_pkts': '8',
                                                                                                                  'in_octets': '26974510516',
                                                                                                                  'in_ucast_pkts': '75613507',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1213640',
                                                                                                                  'out_octets': '236984436999',
                                                                                                                  'out_ucast_pkts': '181623810',
                                                                                                                  'poller_hash': 'NDNDMjFBcGVlcmludGZwb24gMTM='},
                                                                                                          {       'in_nucast_pkts': '17993258',
                                                                                                                  'in_octets': '318432944813',
                                                                                                                  'in_ucast_pkts': '885345532',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '20871029376',
                                                                                                                  'out_octets': '30359284475855',
                                                                                                                  'out_ucast_pkts': '1870321894',
                                                                                                                  'poller_hash': 'MkZFQTAzcGVlcmludGZwb24gMjQ='},
                                                                                                          {       'in_nucast_pkts': '7285679',
                                                                                                                  'in_octets': '28395234008',
                                                                                                                  'in_ucast_pkts': '97383154',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3628749275',
                                                                                                                  'out_octets': '5019500777394',
                                                                                                                  'out_ucast_pkts': '245094266',
                                                                                                                  'poller_hash': 'NkFDMkM3cGVlcmludGZwb24gNDA='},
                                                                                                          {       'in_nucast_pkts': '23939997',
                                                                                                                  'in_octets': '2018113991486',
                                                                                                                  'in_ucast_pkts': '3872720296',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '44195838292',
                                                                                                                  'out_octets': '65807863911423',
                                                                                                                  'out_ucast_pkts': '6677537337',
                                                                                                                  'poller_hash': 'NzZFOTkwcGVlcmludGZwb24gMTgy'},
                                                                                                          {       'in_nucast_pkts': '175',
                                                                                                                  'in_octets': '12971028902',
                                                                                                                  'in_ucast_pkts': '57881731',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2328768',
                                                                                                                  'out_octets': '94020677757',
                                                                                                                  'out_ucast_pkts': '99563701',
                                                                                                                  'poller_hash': 'MTUzQzNwZWVyaW50ZnBvbiAxODM='},
                                                                                                          {       'in_nucast_pkts': '4884145',
                                                                                                                  'in_octets': '148214501842',
                                                                                                                  'in_ucast_pkts': '1938669503',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4881378',
                                                                                                                  'out_octets': '170372663778',
                                                                                                                  'out_ucast_pkts': '2468433320',
                                                                                                                  'poller_hash': 'N0ZGNXBlZXJpbnRmcG9uIDE4NQ=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MzI5NjM5cGVlcmludGZwb24gMTg3'},
                                                                                                          {       'in_nucast_pkts': '20488',
                                                                                                                  'in_octets': '975505989903',
                                                                                                                  'in_ucast_pkts': '5365956629',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2612757',
                                                                                                                  'out_octets': '15158392309637',
                                                                                                                  'out_ucast_pkts': '11860709707',
                                                                                                                  'poller_hash': 'MTk5QTAwcGVlcmludGZwb24gMTg4'},
                                                                                                          {       'in_nucast_pkts': '20330',
                                                                                                                  'in_octets': '60977566461',
                                                                                                                  'in_ucast_pkts': '198468800',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2424736',
                                                                                                                  'out_octets': '607362999924',
                                                                                                                  'out_ucast_pkts': '4770698175',
                                                                                                                  'poller_hash': 'M0NGQTBwZWVyaW50ZnBvbiAxOTA='},
                                                                                                          {       'in_nucast_pkts': '114304',
                                                                                                                  'in_octets': '175277438163',
                                                                                                                  'in_ucast_pkts': '560288893',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '188382',
                                                                                                                  'out_octets': '2365465755582',
                                                                                                                  'out_ucast_pkts': '1798685862',
                                                                                                                  'poller_hash': 'NDcxNDZFcGVlcmludGZwb24gMTkx'},
                                                                                                          {       'in_nucast_pkts': '8771028',
                                                                                                                  'in_octets': '6232562022',
                                                                                                                  'in_ucast_pkts': '8619537234',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '17034441084',
                                                                                                                  'out_octets': '22718287742355',
                                                                                                                  'out_ucast_pkts': '47289437545',
                                                                                                                  'poller_hash': 'NDE1NDlwZWVyaW50ZnBvbiAxOTQ='},
                                                                                                          {       'in_nucast_pkts': '61',
                                                                                                                  'in_octets': '54984802716',
                                                                                                                  'in_ucast_pkts': '184886129',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2467631',
                                                                                                                  'out_octets': '191692592014',
                                                                                                                  'out_ucast_pkts': '202952611',
                                                                                                                  'poller_hash': 'NEVCMTdEcGVlcmludGZwb24gMTk1'},
                                                                                                          {       'in_nucast_pkts': '22913755',
                                                                                                                  'in_octets': '40596383314',
                                                                                                                  'in_ucast_pkts': '145822417',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '34751933333',
                                                                                                                  'out_octets': '47403788433923',
                                                                                                                  'out_ucast_pkts': '479181496',
                                                                                                                  'poller_hash': 'QkYyNEI0cGVlcmludGZwb24gMTk2'},
                                                                                                          {       'in_nucast_pkts': '3107',
                                                                                                                  'in_octets': '354546919679',
                                                                                                                  'in_ucast_pkts': '1227984392',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2615609',
                                                                                                                  'out_octets': '4982890926177',
                                                                                                                  'out_ucast_pkts': '3843821275',
                                                                                                                  'poller_hash': 'MkYzQUQ5cGVlcmludGZwb24gMTk3'},
                                                                                                          {       'in_nucast_pkts': '18683211',
                                                                                                                  'in_octets': '218390196013',
                                                                                                                  'in_ucast_pkts': '823626254',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '15978853641',
                                                                                                                  'out_octets': '24613218920839',
                                                                                                                  'out_ucast_pkts': '2525397081',
                                                                                                                  'poller_hash': 'NzU3QkNwZWVyaW50ZnBvbiAxOTg='},
                                                                                                          {       'in_nucast_pkts': '8366',
                                                                                                                  'in_octets': '12162331475',
                                                                                                                  'in_ucast_pkts': '32523246',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13913141',
                                                                                                                  'out_octets': '95384684890',
                                                                                                                  'out_ucast_pkts': '79365279',
                                                                                                                  'poller_hash': 'QzgxMUUwcGVlcmludGZwb24gMTU3NzUz'},
                                                                                                          {       'in_nucast_pkts': '4',
                                                                                                                  'in_octets': '38481780048',
                                                                                                                  'in_ucast_pkts': '152160621',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5899506',
                                                                                                                  'out_octets': '304128691753',
                                                                                                                  'out_ucast_pkts': '327681804',
                                                                                                                  'poller_hash': 'QzgzQzBDcGVlcmludGZwb24gMTc0NDY0'},
                                                                                                          {       'in_nucast_pkts': '136',
                                                                                                                  'in_octets': '31254448322',
                                                                                                                  'in_ucast_pkts': '264663269',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1630758',
                                                                                                                  'out_octets': '1786504015649',
                                                                                                                  'out_ucast_pkts': '1232478682',
                                                                                                                  'poller_hash': 'QzgxRTMwcGVlcmludGZwb24gMjA2NDkw'},
                                                                                                          {       'in_nucast_pkts': '77350',
                                                                                                                  'in_octets': '26700020913',
                                                                                                                  'in_ucast_pkts': '46728908',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2792840',
                                                                                                                  'out_octets': '279996882769',
                                                                                                                  'out_ucast_pkts': '206876705',
                                                                                                                  'poller_hash': 'MTI3NEE0M3BlZXJpbnRmcG9uIDIzNTA4Mg=='},
                                                                                                          {       'in_nucast_pkts': '467197',
                                                                                                                  'in_octets': '22058250809',
                                                                                                                  'in_ucast_pkts': '184699132',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3422276',
                                                                                                                  'out_octets': '975971778082',
                                                                                                                  'out_ucast_pkts': '686546003',
                                                                                                                  'poller_hash': 'MTI3NDlBRXBlZXJpbnRmcG9uIDIzNjE3Ng=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '657484758503',
                                                                                         'out_octets': '1164635982710945',
                                                                                         'out_ucast_pkts': '242917795495',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzU=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/5',
                                                                                                                 'id': '1/5',
                                                                                                                 'links': [       {       'connected_time': '22596354',
                                                                                                                                          'fiber_length': 1529,
                                                                                                                                          'poller_hash': 'NEQ0MjUwcGVlcnBvbnBvbiA2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '3157622',
                                                                                                                                          'fiber_length': 1307,
                                                                                                                                          'poller_hash': 'NDNDMjFBcGVlcnBvbnBvbiAxMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '22596486',
                                                                                                                                          'fiber_length': 670,
                                                                                                                                          'poller_hash': 'MkZFQTAzcGVlcnBvbnBvbiAyNA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '7140162',
                                                                                                                                          'fiber_length': 691,
                                                                                                                                          'poller_hash': 'NkFDMkM3cGVlcnBvbnBvbiA0MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '22596131',
                                                                                                                                          'fiber_length': 1441,
                                                                                                                                          'poller_hash': 'NzZFOTkwcGVlcnBvbnBvbiAxODI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '7140050',
                                                                                                                                          'fiber_length': 881,
                                                                                                                                          'poller_hash': 'MTUzQzNwZWVycG9ucG9uIDE4Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '22595108',
                                                                                                                                          'fiber_length': 834,
                                                                                                                                          'poller_hash': 'N0ZGNXBlZXJwb25wb24gMTg1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '1891958',
                                                                                                                                          'fiber_length': 938,
                                                                                                                                          'poller_hash': 'MzI5NjM5cGVlcnBvbnBvbiAxODc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '22596120',
                                                                                                                                          'fiber_length': 953,
                                                                                                                                          'poller_hash': 'MTk5QTAwcGVlcnBvbnBvbiAxODg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '9750754',
                                                                                                                                          'fiber_length': 667,
                                                                                                                                          'poller_hash': 'M0NGQTBwZWVycG9ucG9uIDE5MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '22596498',
                                                                                                                                          'fiber_length': 578,
                                                                                                                                          'poller_hash': 'NDcxNDZFcGVlcnBvbnBvbiAxOTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '22596033',
                                                                                                                                          'fiber_length': 705,
                                                                                                                                          'poller_hash': 'NDE1NDlwZWVycG9ucG9uIDE5NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '12739691',
                                                                                                                                          'fiber_length': 761,
                                                                                                                                          'poller_hash': 'NEVCMTdEcGVlcnBvbnBvbiAxOTU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '18171715',
                                                                                                                                          'fiber_length': 1360,
                                                                                                                                          'poller_hash': 'QkYyNEI0cGVlcnBvbnBvbiAxOTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '22595892',
                                                                                                                                          'fiber_length': 1317,
                                                                                                                                          'poller_hash': 'MkYzQUQ5cGVlcnBvbnBvbiAxOTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '22596647',
                                                                                                                                          'fiber_length': 1356,
                                                                                                                                          'poller_hash': 'NzU3QkNwZWVycG9ucG9uIDE5OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '22611491',
                                                                                                                                          'fiber_length': 1022,
                                                                                                                                          'poller_hash': 'QzgxMUUwcGVlcnBvbnBvbiAxNTc3NTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '7140421',
                                                                                                                                          'fiber_length': 971,
                                                                                                                                          'poller_hash': 'QzgzQzBDcGVlcnBvbnBvbiAxNzQ0NjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '3157893',
                                                                                                                                          'fiber_length': 896,
                                                                                                                                          'poller_hash': 'QzgxRTMwcGVlcnBvbnBvbiAyMDY0OTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '3157879',
                                                                                                                                          'fiber_length': 712,
                                                                                                                                          'poller_hash': 'MTI3NEE0M3BlZXJwb25wb24gMjM1MDgy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745},
                                                                                                                                  {       'connected_time': '1840043',
                                                                                                                                          'fiber_length': 683,
                                                                                                                                          'poller_hash': 'MTI3NDlBRXBlZXJwb25wb24gMjM2MTc2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.745}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/5',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzU=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/6',
                                                                                         'in_discards': '70405',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '24576091',
                                                                                         'in_octets': '23823826170278',
                                                                                         'in_ucast_pkts': '110028274249',
                                                                                         'links': [       {       'in_nucast_pkts': '33406775',
                                                                                                                  'in_octets': '674018532705',
                                                                                                                  'in_ucast_pkts': '1625076004',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '61789247333',
                                                                                                                  'out_octets': '87491712674823',
                                                                                                                  'out_ucast_pkts': '3947113842',
                                                                                                                  'poller_hash': 'MzIxMUIzcGVlcmludGZwb24gNA=='},
                                                                                                          {       'in_nucast_pkts': '23004',
                                                                                                                  'in_octets': '35842588900',
                                                                                                                  'in_ucast_pkts': '349001514',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2412099',
                                                                                                                  'out_octets': '981424993462',
                                                                                                                  'out_ucast_pkts': '673151790',
                                                                                                                  'poller_hash': 'NDJCOUQzcGVlcmludGZwb24gMTA='},
                                                                                                          {       'in_nucast_pkts': '8518882',
                                                                                                                  'in_octets': '112311271016',
                                                                                                                  'in_ucast_pkts': '659236804',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '15885032487',
                                                                                                                  'out_octets': '26564038794981',
                                                                                                                  'out_ucast_pkts': '3977020801',
                                                                                                                  'poller_hash': 'ODcyNDJBcGVlcmludGZwb24gMTU='},
                                                                                                          {       'in_nucast_pkts': '9239626',
                                                                                                                  'in_octets': '440746541551',
                                                                                                                  'in_ucast_pkts': '1572426618',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '25430836004',
                                                                                                                  'out_octets': '38999557732280',
                                                                                                                  'out_ucast_pkts': '4040686426',
                                                                                                                  'poller_hash': 'NDI4MTkxcGVlcmludGZwb24gMzU='},
                                                                                                          {       'in_nucast_pkts': '3934604',
                                                                                                                  'in_octets': '17738917930',
                                                                                                                  'in_ucast_pkts': '87090839',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3118966986',
                                                                                                                  'out_octets': '4781037887815',
                                                                                                                  'out_ucast_pkts': '436867814',
                                                                                                                  'poller_hash': 'MzIyM0QzcGVlcmludGZwb24gNDM='},
                                                                                                          {       'in_nucast_pkts': '21',
                                                                                                                  'in_octets': '19328453372',
                                                                                                                  'in_ucast_pkts': '162713461',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2792507',
                                                                                                                  'out_octets': '625861156458',
                                                                                                                  'out_ucast_pkts': '435684880',
                                                                                                                  'poller_hash': 'NDJEMkJCcGVlcmludGZwb24gODM='},
                                                                                                          {       'in_nucast_pkts': '5628',
                                                                                                                  'in_octets': '519675113712',
                                                                                                                  'in_ucast_pkts': '4503829080',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2614774',
                                                                                                                  'out_octets': '14194668319916',
                                                                                                                  'out_ucast_pkts': '9903019156',
                                                                                                                  'poller_hash': 'ODc0NEZwZWVyaW50ZnBvbiAxMjc='},
                                                                                                          {       'in_nucast_pkts': '5840592',
                                                                                                                  'in_octets': '11904913487',
                                                                                                                  'in_ucast_pkts': '54538810',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9973976058',
                                                                                                                  'out_octets': '13137681765073',
                                                                                                                  'out_ucast_pkts': '86566585',
                                                                                                                  'poller_hash': 'NEQxMTFGcGVlcmludGZwb24gMjAz'},
                                                                                                          {       'in_nucast_pkts': '4884578',
                                                                                                                  'in_octets': '162079247831',
                                                                                                                  'in_ucast_pkts': '1628422511',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4881481',
                                                                                                                  'out_octets': '141621030745',
                                                                                                                  'out_ucast_pkts': '2046858771',
                                                                                                                  'poller_hash': 'NDE1N0VwZWVyaW50ZnBvbiAyMDY='},
                                                                                                          {       'in_nucast_pkts': '106504',
                                                                                                                  'in_octets': '197293007987',
                                                                                                                  'in_ucast_pkts': '2077223050',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2615734',
                                                                                                                  'out_octets': '8656147523092',
                                                                                                                  'out_ucast_pkts': '10160289605',
                                                                                                                  'poller_hash': 'NDE1QUJwZWVyaW50ZnBvbiAyMDc='},
                                                                                                          {       'in_nucast_pkts': '1015411',
                                                                                                                  'in_octets': '188157527434',
                                                                                                                  'in_ucast_pkts': '1336797775',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '179968',
                                                                                                                  'out_octets': '7524374009748',
                                                                                                                  'out_ucast_pkts': '5200764205',
                                                                                                                  'poller_hash': 'QkYyNTA1cGVlcmludGZwb24gMjA4'},
                                                                                                          {       'in_nucast_pkts': '1478792',
                                                                                                                  'in_octets': '356913014996',
                                                                                                                  'in_ucast_pkts': '2029893216',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2626724',
                                                                                                                  'out_octets': '9350153604106',
                                                                                                                  'out_ucast_pkts': '6875007624',
                                                                                                                  'poller_hash': 'NDcwM0FGcGVlcmludGZwb24gMjA5'},
                                                                                                          {       'in_nucast_pkts': '1617205',
                                                                                                                  'in_octets': '53578499670',
                                                                                                                  'in_ucast_pkts': '230113680',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3880085580',
                                                                                                                  'out_octets': '5700981462338',
                                                                                                                  'out_ucast_pkts': '431381719',
                                                                                                                  'poller_hash': 'ODcyNDVFcGVlcmludGZwb24gMjEw'},
                                                                                                          {       'in_nucast_pkts': '697509',
                                                                                                                  'in_octets': '612437049',
                                                                                                                  'in_ucast_pkts': '2707649',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '859280181',
                                                                                                                  'out_octets': '1125743891673',
                                                                                                                  'out_ucast_pkts': '8075816',
                                                                                                                  'poller_hash': 'Mzk1MDdBcGVlcmludGZwb24gMjEx'},
                                                                                                          {       'in_nucast_pkts': '7',
                                                                                                                  'in_octets': '21832160773',
                                                                                                                  'in_ucast_pkts': '101037466',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2792684',
                                                                                                                  'out_octets': '799429890888',
                                                                                                                  'out_ucast_pkts': '562259664',
                                                                                                                  'poller_hash': 'QzgxQzNGcGVlcmludGZwb24gMjEy'},
                                                                                                          {       'in_nucast_pkts': '1616219',
                                                                                                                  'in_octets': '484424245901',
                                                                                                                  'in_ucast_pkts': '1976408962',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1527888454',
                                                                                                                  'out_octets': '10417309455843',
                                                                                                                  'out_ucast_pkts': '6066643760',
                                                                                                                  'poller_hash': 'MTk5QTMycGVlcmludGZwb24gMjE0'},
                                                                                                          {       'in_nucast_pkts': '22866748',
                                                                                                                  'in_octets': '11090421092',
                                                                                                                  'in_ucast_pkts': '52396610',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '38610649759',
                                                                                                                  'out_octets': '51111577074117',
                                                                                                                  'out_ucast_pkts': '114459024',
                                                                                                                  'poller_hash': 'NzZGMjFDcGVlcmludGZwb24gMjE3'},
                                                                                                          {       'in_nucast_pkts': '217649',
                                                                                                                  'in_octets': '361026411438',
                                                                                                                  'in_ucast_pkts': '1003596653',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2616110',
                                                                                                                  'out_octets': '7986278435982',
                                                                                                                  'out_ucast_pkts': '5687399104',
                                                                                                                  'poller_hash': 'NEQ0MjRGcGVlcmludGZwb24gMjE4'},
                                                                                                          {       'in_nucast_pkts': '17818321',
                                                                                                                  'in_octets': '89249298481',
                                                                                                                  'in_ucast_pkts': '393761937',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6130535591',
                                                                                                                  'out_octets': '9468170774583',
                                                                                                                  'out_ucast_pkts': '1285372342',
                                                                                                                  'poller_hash': 'NDAwMzhGcGVlcmludGZwb24gMjE5'},
                                                                                                          {       'in_nucast_pkts': '249836',
                                                                                                                  'in_octets': '6706856995',
                                                                                                                  'in_ucast_pkts': '69983952',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '204306',
                                                                                                                  'out_octets': '421813717334',
                                                                                                                  'out_ucast_pkts': '285910901',
                                                                                                                  'poller_hash': 'ODZCQkVwZWVyaW50ZnBvbiAyMjA='},
                                                                                                          {       'in_nucast_pkts': '63911',
                                                                                                                  'in_octets': '40026413424',
                                                                                                                  'in_ucast_pkts': '116655004',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2792735',
                                                                                                                  'out_octets': '534501350920',
                                                                                                                  'out_ucast_pkts': '405861390',
                                                                                                                  'poller_hash': 'OTU0RjQ1cGVlcmludGZwb24gMTQzODgy'},
                                                                                                          {       'in_nucast_pkts': '13315',
                                                                                                                  'in_octets': '36976351193',
                                                                                                                  'in_ucast_pkts': '50402613',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '767208',
                                                                                                                  'out_octets': '134181009575',
                                                                                                                  'out_ucast_pkts': '107998433',
                                                                                                                  'poller_hash': 'MTI3NDc4NHBlZXJpbnRmcG9uIDE0OTExNw=='},
                                                                                                          {       'in_nucast_pkts': '2478165',
                                                                                                                  'in_octets': '10588479202',
                                                                                                                  'in_ucast_pkts': '46094761',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6136637182',
                                                                                                                  'out_octets': '8368922992079',
                                                                                                                  'out_ucast_pkts': '193078859',
                                                                                                                  'poller_hash': 'QzgzODFBcGVlcmludGZwb24gMTYwOTk2'},
                                                                                                          {       'in_nucast_pkts': '33720',
                                                                                                                  'in_octets': '42797106622',
                                                                                                                  'in_ucast_pkts': '252143645',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1630677',
                                                                                                                  'out_octets': '1014595641202',
                                                                                                                  'out_ucast_pkts': '741038342',
                                                                                                                  'poller_hash': 'QzgxRTAxcGVlcmludGZwb24gMjA1NDU2'},
                                                                                                          {       'in_nucast_pkts': '5242623',
                                                                                                                  'in_octets': '25321948749',
                                                                                                                  'in_ucast_pkts': '77027161',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4920881484',
                                                                                                                  'out_octets': '6742074329001',
                                                                                                                  'out_ucast_pkts': '293060116',
                                                                                                                  'poller_hash': 'MTE5NTE0OXBlZXJpbnRmcG9uIDIxNTk2OQ=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '992180906540',
                                                                                         'out_octets': '1782532146221458',
                                                                                         'out_ucast_pkts': '318904315705',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzY=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/6',
                                                                                                                 'id': '1/6',
                                                                                                                 'links': [       {       'connected_time': '22611010',
                                                                                                                                          'fiber_length': 1274,
                                                                                                                                          'poller_hash': 'MzIxMUIzcGVlcnBvbnBvbiA0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '3157663',
                                                                                                                                          'fiber_length': 1320,
                                                                                                                                          'poller_hash': 'NDJCOUQzcGVlcnBvbnBvbiAxMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '22611036',
                                                                                                                                          'fiber_length': 1491,
                                                                                                                                          'poller_hash': 'ODcyNDJBcGVlcnBvbnBvbiAxNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '22611287',
                                                                                                                                          'fiber_length': 1490,
                                                                                                                                          'poller_hash': 'NDI4MTkxcGVlcnBvbnBvbiAzNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '3157713',
                                                                                                                                          'fiber_length': 1451,
                                                                                                                                          'poller_hash': 'MzIyM0QzcGVlcnBvbnBvbiA0Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '3157697',
                                                                                                                                          'fiber_length': 1337,
                                                                                                                                          'poller_hash': 'NDJEMkJCcGVlcnBvbnBvbiA4Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '22596137',
                                                                                                                                          'fiber_length': 1387,
                                                                                                                                          'poller_hash': 'ODc0NEZwZWVycG9ucG9uIDEyNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '22596058',
                                                                                                                                          'fiber_length': 1329,
                                                                                                                                          'poller_hash': 'NEQxMTFGcGVlcnBvbnBvbiAyMDM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '22595972',
                                                                                                                                          'fiber_length': 1247,
                                                                                                                                          'poller_hash': 'NDE1N0VwZWVycG9ucG9uIDIwNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '22596010',
                                                                                                                                          'fiber_length': 1273,
                                                                                                                                          'poller_hash': 'NDE1QUJwZWVycG9ucG9uIDIwNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '22595443',
                                                                                                                                          'fiber_length': 1353,
                                                                                                                                          'poller_hash': 'QkYyNTA1cGVlcnBvbnBvbiAyMDg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '22595834',
                                                                                                                                          'fiber_length': 1330,
                                                                                                                                          'poller_hash': 'NDcwM0FGcGVlcnBvbnBvbiAyMDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '3157763',
                                                                                                                                          'fiber_length': 1476,
                                                                                                                                          'poller_hash': 'ODcyNDVFcGVlcnBvbnBvbiAyMTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '2348456',
                                                                                                                                          'fiber_length': 1207,
                                                                                                                                          'poller_hash': 'Mzk1MDdBcGVlcnBvbnBvbiAyMTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '3157763',
                                                                                                                                          'fiber_length': 1300,
                                                                                                                                          'poller_hash': 'QzgxQzNGcGVlcnBvbnBvbiAyMTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '22596010',
                                                                                                                                          'fiber_length': 1074,
                                                                                                                                          'poller_hash': 'MTk5QTMycGVlcnBvbnBvbiAyMTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '22596158',
                                                                                                                                          'fiber_length': 1007,
                                                                                                                                          'poller_hash': 'NzZGMjFDcGVlcnBvbnBvbiAyMTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '22596281',
                                                                                                                                          'fiber_length': 1327,
                                                                                                                                          'poller_hash': 'NEQ0MjRGcGVlcnBvbnBvbiAyMTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '22596029',
                                                                                                                                          'fiber_length': 1198,
                                                                                                                                          'poller_hash': 'NDAwMzhGcGVlcnBvbnBvbiAyMTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '1319609',
                                                                                                                                          'fiber_length': 1227,
                                                                                                                                          'poller_hash': 'ODZCQkVwZWVycG9ucG9uIDIyMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '3157871',
                                                                                                                                          'fiber_length': 1530,
                                                                                                                                          'poller_hash': 'OTU0RjQ1cGVlcnBvbnBvbiAxNDM4ODI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '716385',
                                                                                                                                          'fiber_length': 1323,
                                                                                                                                          'poller_hash': 'MTI3NDc4NHBlZXJwb25wb24gMTQ5MTE3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '3157846',
                                                                                                                                          'fiber_length': 1226,
                                                                                                                                          'poller_hash': 'QzgzODFBcGVlcnBvbnBvbiAxNjA5OTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '3157882',
                                                                                                                                          'fiber_length': 1090,
                                                                                                                                          'poller_hash': 'QzgxRTAxcGVlcnBvbnBvbiAyMDU0NTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971},
                                                                                                                                  {       'connected_time': '5707254',
                                                                                                                                          'fiber_length': 1180,
                                                                                                                                          'poller_hash': 'MTE5NTE0OXBlZXJwb25wb24gMjE1OTY5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.971}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/6',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzY=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/7',
                                                                                         'in_discards': '5702',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '9138121',
                                                                                         'in_octets': '20699893477012',
                                                                                         'in_ucast_pkts': '88628164901',
                                                                                         'links': [       {       'in_nucast_pkts': '23491206',
                                                                                                                  'in_octets': '78025059320',
                                                                                                                  'in_ucast_pkts': '268922800',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10585270530',
                                                                                                                  'out_octets': '14972497573075',
                                                                                                                  'out_ucast_pkts': '1016769433',
                                                                                                                  'poller_hash': 'M0FERDcxcGVlcmludGZwb24gMQ=='},
                                                                                                          {       'in_nucast_pkts': '73830',
                                                                                                                  'in_octets': '71923744467',
                                                                                                                  'in_ucast_pkts': '167453230',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1231743',
                                                                                                                  'out_octets': '770757776907',
                                                                                                                  'out_ucast_pkts': '593591198',
                                                                                                                  'poller_hash': 'MzNENTgwcGVlcmludGZwb24gMg=='},
                                                                                                          {       'in_nucast_pkts': '3340855',
                                                                                                                  'in_octets': '21222371731',
                                                                                                                  'in_ucast_pkts': '116300220',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1480563024',
                                                                                                                  'out_octets': '2328127684184',
                                                                                                                  'out_ucast_pkts': '278974325',
                                                                                                                  'poller_hash': 'NDJDNDE0cGVlcmludGZwb24gNQ=='},
                                                                                                          {       'in_nucast_pkts': '2729',
                                                                                                                  'in_octets': '8496391441',
                                                                                                                  'in_ucast_pkts': '29565658',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1213609',
                                                                                                                  'out_octets': '88324367015',
                                                                                                                  'out_ucast_pkts': '67316494',
                                                                                                                  'poller_hash': 'NDNDMjRDcGVlcmludGZwb24gOA=='},
                                                                                                          {       'in_nucast_pkts': '5458731',
                                                                                                                  'in_octets': '177989528067',
                                                                                                                  'in_ucast_pkts': '1395188355',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '14048269070',
                                                                                                                  'out_octets': '23644816852948',
                                                                                                                  'out_ucast_pkts': '4076525972',
                                                                                                                  'poller_hash': 'MzIxN0NBcGVlcmludGZwb24gMTE='},
                                                                                                          {       'in_nucast_pkts': '10852856',
                                                                                                                  'in_octets': '244525212672',
                                                                                                                  'in_ucast_pkts': '383424430',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '17075838779',
                                                                                                                  'out_octets': '23747912311247',
                                                                                                                  'out_ucast_pkts': '1169579144',
                                                                                                                  'poller_hash': 'MzIxNzE4cGVlcmludGZwb24gMTI='},
                                                                                                          {       'in_nucast_pkts': '2316087',
                                                                                                                  'in_octets': '36692058150',
                                                                                                                  'in_ucast_pkts': '112018823',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '983189863',
                                                                                                                  'out_octets': '1783176320253',
                                                                             