import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestCalixModels(DeviceTestCase):

    def test_calix_exa_E7_2_EXA_3_3_21_2_01(self):
        obj = self.run_data("calix.exa.E7-2 (EXA).3.3.21.2.01")
        exp_info = {
                'model': 'E7-2 (EXA)',
                'sta_count': 61,
                'sw_version': '3.3.21.2',
                'vendor': 'Calix'
        }
        exp_stats = {
         'serial_number': '71704975659', 'system_mac_address': None
        }
        exp_sta_stats = {
                None: {       'dev_macs': [],
                              'ip_address': None,
                              'mac_address': None,
                              'name': 'ont 61',
                              'serial_number': 'B2E9D6',
                              'system_mac_address': None},
                '44:65:7f:7b:94:5e': {       'dev_macs': ['58:6d:8f:8a:8d:a7'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:94:5e',
                                             'name': 'ont 12',
                                             'serial_number': '5A3756',
                                             'system_mac_address': None},
                '44:65:7f:bb:3d:88': {       'dev_macs': ['98:18:88:cd:a1:14'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:3d:88',
                                             'name': 'ont 30',
                                             'serial_number': '65F572',
                                             'system_mac_address': None},
                '44:65:7f:bb:49:9a': {       'dev_macs': ['e0:cb:bc:19:d8:a0'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:49:9a',
                                             'name': 'ont 19',
                                             'serial_number': '65F978',
                                             'system_mac_address': None},
                '44:65:7f:bb:49:a0': {       'dev_macs': ['2c:b8:ed:41:e9:c9'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:49:a0',
                                             'name': 'ont 23',
                                             'serial_number': '65F97A',
                                             'system_mac_address': None},
                '44:65:7f:bb:49:e2': {       'dev_macs': ['f8:9e:28:7e:ad:76'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:49:e2',
                                             'name': 'ont 27',
                                             'serial_number': '65F990',
                                             'system_mac_address': None},
                '44:65:7f:bb:4a:00': {       'dev_macs': ['48:f8:b3:b6:7b:ed'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4a:00',
                                             'name': 'ont 15',
                                             'serial_number': '65F99A',
                                             'system_mac_address': None},
                '44:65:7f:bb:4a:06': {       'dev_macs': ['90:a7:c1:97:7f:4a'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4a:06',
                                             'name': 'ont 29',
                                             'serial_number': '65F99C',
                                             'system_mac_address': None},
                '44:65:7f:bb:4a:2a': {       'dev_macs': ['d4:6a:91:b0:57:49'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4a:2a',
                                             'name': 'ont 26',
                                             'serial_number': '65F9A8',
                                             'system_mac_address': None},
                '44:65:7f:bb:4a:48': {       'dev_macs': ['00:30:44:2f:63:24'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4a:48',
                                             'name': 'ont 24',
                                             'serial_number': '65F9B2',
                                             'system_mac_address': None},
                '44:65:7f:bb:4a:66': {       'dev_macs': ['24:f5:a2:0b:17:d4'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4a:66',
                                             'name': 'ont 17',
                                             'serial_number': '65F9BC',
                                             'system_mac_address': None},
                '44:65:7f:bb:4a:78': {       'dev_macs': ['d4:6a:91:b0:6f:61'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4a:78',
                                             'name': 'ont 18',
                                             'serial_number': '65F9C2',
                                             'system_mac_address': None},
                '44:65:7f:bb:4a:93': {       'dev_macs': ['14:9f:43:19:ec:4d'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4a:93',
                                             'name': 'ont 20',
                                             'serial_number': '65F9CB',
                                             'system_mac_address': None},
                '44:65:7f:bb:4a:a5': {       'dev_macs': ['18:90:88:41:91:60'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4a:a5',
                                             'name': 'ont 28',
                                             'serial_number': '65F9D1',
                                             'system_mac_address': None},
                '44:65:7f:bb:4a:c3': {       'dev_macs': ['0c:80:63:a0:0b:9d'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4a:c3',
                                             'name': 'ont 21',
                                             'serial_number': '65F9DB',
                                             'system_mac_address': None},
                '44:65:7f:bb:4b:17': {       'dev_macs': ['d4:6a:91:77:55:27'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:bb:4b:17',
                                             'name': 'ont 22',
                                             'serial_number': '65F9F7',
                                             'system_mac_address': None},
                '48:77:46:1d:47:b7': {       'dev_macs': ['00:1b:17:00:21:17'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:1d:47:b7',
                                             'name': 'ont 31',
                                             'serial_number': '6FDE00',
                                             'system_mac_address': None},
                '48:77:46:81:3c:71': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:81:3c:71',
                                             'name': 'ont 50',
                                             'serial_number': '754A13',
                                             'system_mac_address': None},
                '48:77:46:96:32:42': {       'dev_macs': ['2c:b8:ed:70:f7:e9'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:32:42',
                                             'name': 'ont 33',
                                             'serial_number': '7705F3',
                                             'system_mac_address': None},
                '48:77:46:96:36:c5': {       'dev_macs': ['98:ed:7e:0f:db:81'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:36:c5',
                                             'name': 'ont 34',
                                             'serial_number': '770774',
                                             'system_mac_address': None},
                '48:77:46:96:37:70': {       'dev_macs': ['d4:6a:91:b0:ce:45'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:37:70',
                                             'name': 'ont 37',
                                             'serial_number': '7707AD',
                                             'system_mac_address': None},
                '48:77:46:96:37:8e': {       'dev_macs': ['f8:bc:0e:3d:e5:01'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:37:8e',
                                             'name': 'ont 39',
                                             'serial_number': '7707B7',
                                             'system_mac_address': None},
                '48:77:46:96:38:b1': {       'dev_macs': ['d4:6a:91:b8:50:d5'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:38:b1',
                                             'name': 'ont 40',
                                             'serial_number': '770818',
                                             'system_mac_address': None},
                '48:77:46:96:39:50': {       'dev_macs': ['84:d3:43:59:3f:75'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:96:39:50',
                                             'name': 'ont 35',
                                             'serial_number': '77084D',
                                             'system_mac_address': None},
                '60:db:98:1d:2f:4b': {       'dev_macs': ['d0:76:8f:e6:14:21'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:1d:2f:4b',
                                             'name': 'ont 54',
                                             'serial_number': 'A196FE',
                                             'system_mac_address': None},
                '60:db:98:1d:68:42': {       'dev_macs': ['08:30:6b:37:63:31'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:1d:68:42',
                                             'name': 'ont 51',
                                             'serial_number': 'A1AA13',
                                             'system_mac_address': None},
                '60:db:98:1d:7b:86': {       'dev_macs': ['e0:cb:bc:9d:72:91'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:1d:7b:86',
                                             'name': 'ont 53',
                                             'serial_number': 'A1B07F',
                                             'system_mac_address': None},
                '60:db:98:1d:7b:ec': {       'dev_macs': ['90:a7:c1:ca:0a:0b'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:1d:7b:ec',
                                             'name': 'ont 52',
                                             'serial_number': 'A1B0A1',
                                             'system_mac_address': None},
                '60:db:98:83:b4:db': {       'dev_macs': ['18:c2:41:11:1a:41'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:83:b4:db',
                                             'name': 'ont 59',
                                             'serial_number': 'B2E917',
                                             'system_mac_address': None},
                '60:db:98:88:4b:c9': {       'dev_macs': ['d4:3f:32:7b:d0:81'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:88:4b:c9',
                                             'name': 'ont 60',
                                             'serial_number': 'B3AF53',
                                             'system_mac_address': None},
                '84:d3:43:4f:87:42': {       'dev_macs': ['e4:38:83:53:d5:a4'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:4f:87:42',
                                             'name': 'ont 55',
                                             'serial_number': 'C1B7A1',
                                             'system_mac_address': None},
                '84:d3:43:4f:8b:9b': {       'dev_macs': ['e4:38:83:1d:53:01'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:4f:8b:9b',
                                             'name': 'ont 56',
                                             'serial_number': 'C1B914',
                                             'system_mac_address': None},
                '84:d3:43:9f:33:5a': {       'dev_macs': ['ac:8b:a9:11:24:15'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:9f:33:5a',
                                             'name': 'ont 36',
                                             'serial_number': 'D9C506',
                                             'system_mac_address': None},
                '84:d3:43:9f:33:f0': {       'dev_macs': ['d4:6a:91:b0:9d:cd'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:9f:33:f0',
                                             'name': 'ont 58',
                                             'serial_number': 'D9C538',
                                             'system_mac_address': None},
                '84:d3:43:9f:34:6b': {       'dev_macs': ['18:b1:69:bf:8c:2d'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:9f:34:6b',
                                             'name': 'ont 25',
                                             'serial_number': 'D9C561',
                                             'system_mac_address': None},
                'cc:be:59:bb:3c:ae': {       'dev_macs': ['18:b1:69:c7:49:7d'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3c:ae',
                                             'name': 'ont 10',
                                             'serial_number': '5A5771',
                                             'system_mac_address': None},
                'cc:be:59:bb:3c:b7': {       'dev_macs': ['fc:ec:da:d3:eb:2b'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3c:b7',
                                             'name': 'ont 13',
                                             'serial_number': '5A5774',
                                             'system_mac_address': None},
                'cc:be:59:bb:3c:cc': {       'dev_macs': ['f8:9e:28:7f:31:3d'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3c:cc',
                                             'name': 'ont 9',
                                             'serial_number': '5A577B',
                                             'system_mac_address': None},
                'cc:be:59:bb:3c:d5': {       'dev_macs': ['90:a7:c1:dd:52:6e'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3c:d5',
                                             'name': 'ont 5',
                                             'serial_number': '5A577E',
                                             'system_mac_address': None},
                'cc:be:59:bb:3c:d8': {       'dev_macs': ['d4:6a:91:b0:80:21'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3c:d8',
                                             'name': 'ont 8',
                                             'serial_number': '5A577F',
                                             'system_mac_address': None},
                'cc:be:59:bb:3c:f0': {       'dev_macs': ['f8:9e:28:84:01:e5'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3c:f0',
                                             'name': 'ont 7',
                                             'serial_number': '5A5787',
                                             'system_mac_address': None},
                'cc:be:59:bb:3c:fc': {       'dev_macs': ['f8:bc:0e:62:8c:e0'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3c:fc',
                                             'name': 'ont 1',
                                             'serial_number': '5A578B',
                                             'system_mac_address': None},
                'cc:be:59:bb:3d:38': {       'dev_macs': ['d4:6a:91:ba:9b:0d'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3d:38',
                                             'name': '11689',
                                             'serial_number': '5A579F',
                                             'system_mac_address': None},
                'cc:be:59:bb:3d:44': {       'dev_macs': [       '00:18:0a:85:5b:76',
                                                                 '18:b1:69:d8:18:44'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3d:44',
                                             'name': 'ont 6',
                                             'serial_number': '5A57A3',
                                             'system_mac_address': None},
                'cc:be:59:bb:3d:e0': {       'dev_macs': [       '20:b5:c6:1a:4d:a9',
                                                                 'ac:17:c8:d0:52:ba',
                                                                 'ec:13:b2:92:c7:e8'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:bb:3d:e0',
                                             'name': 'ont 11',
                                             'serial_number': '5A57D7',
                                             'system_mac_address': None},
                'd0:76:8f:20:e1:df': {       'dev_macs': ['a4:13:4e:b2:d7:89'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:20:e1:df',
                                             'name': 'ont 46',
                                             'serial_number': '87E4F6',
                                             'system_mac_address': None},
                'd0:76:8f:20:eb:ba': {       'dev_macs': ['e0:cb:bc:23:e6:80'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:20:eb:ba',
                                             'name': 'ont 43',
                                             'serial_number': '87E83F',
                                             'system_mac_address': None},
                'd0:76:8f:20:ed:1f': {       'dev_macs': ['d0:76:8f:47:4b:c9'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:20:ed:1f',
                                             'name': 'ont 48',
                                             'serial_number': '87E8B6',
                                             'system_mac_address': None},
                'd0:76:8f:20:ed:3d': {       'dev_macs': ['d0:76:8f:47:4c:84'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:20:ed:3d',
                                             'name': 'ont 44',
                                             'serial_number': '87E8C0',
                                             'system_mac_address': None},
                'd0:76:8f:20:ed:43': {       'dev_macs': ['44:65:7f:5d:b8:7d'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:20:ed:43',
                                             'name': 'ont 42',
                                             'serial_number': '87E8C2',
                                             'system_mac_address': None},
                'd0:76:8f:20:ed:8b': {       'dev_macs': ['2c:3f:0b:cc:47:d5'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:20:ed:8b',
                                             'name': 'ont 49',
                                             'serial_number': '87E8DA',
                                             'system_mac_address': None},
                'd0:76:8f:20:ed:9d': {       'dev_macs': ['d0:76:8f:43:cb:26'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:20:ed:9d',
                                             'name': 'ont 47',
                                             'serial_number': '87E8E0',
                                             'system_mac_address': None},
                'd0:76:8f:20:ed:e8': {       'dev_macs': ['60:db:98:2e:23:92'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:20:ed:e8',
                                             'name': 'ont 41',
                                             'serial_number': '87E8F9',
                                             'system_mac_address': None},
                'd0:76:8f:20:ed:f1': {       'dev_macs': ['f0:1d:2d:28:03:1a'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:20:ed:f1',
                                             'name': 'ont 45',
                                             'serial_number': '87E8FC',
                                             'system_mac_address': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': 'front',
                                                              'name': 'Craft-FE: front',
                                                              'oper_up': True,
                                                              'poller_hash': 'NzE3MDQ5NzU2NTlmcm9udA=='},
                                                      {       'admin_up': True,
                                                              'id': 'rear',
                                                              'mac_address': 'cc:be:59:dd:49:34',
                                                              'name': 'Craft-FE: rear',
                                                              'oper_up': True,
                                                              'poller_hash': 'NzE3MDQ5NzU2NTlyZWFy'}],
                                'manufacturer': 'Calix',
                                'model': 'E7-2 (EXA)',
                                'modules': [       {       'id': '1',
                                                           'interfaces': [       {       'admin_up': False,
                                                                                         'id': '1/x1',
                                                                                         'mac_address': 'cc:be:59:dd:49:41',
                                                                                         'name': 'ethernet '
                                                                                                 '1/x1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS94MQ=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/x2',
                                                                                         'mac_address': 'cc:be:59:dd:49:42',
                                                                                         'name': 'backplane-link '
                                                                                                 '1/x2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwYmFja3BsYW5lLWxpbmsgMS94Mg=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/x3',
                                                                                         'in_discards': '302611870',
                                                                                         'in_errors': '1',
                                                                                         'in_nucast_pkts': '892751386',
                                                                                         'in_octets': '1099882653145745',
                                                                                         'in_ucast_pkts': '963381632602',
                                                                                         'mac_address': 'cc:be:59:dd:49:43',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01510',
                                                                                         'name': 'ethernet '
                                                                                                 '1/x3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '28015044',
                                                                                         'out_octets': '249478410119316',
                                                                                         'out_ucast_pkts': '538578083288',
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS94Mw==',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/x4',
                                                                                         'mac_address': 'cc:be:59:dd:49:44',
                                                                                         'name': 'ethernet '
                                                                                                 '1/x4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS94NA=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g1',
                                                                                         'mac_address': 'cc:be:59:dd:49:35',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS9nMQ=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g2',
                                                                                         'mac_address': 'cc:be:59:dd:49:36',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS9nMg=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g3',
                                                                                         'mac_address': 'cc:be:59:dd:49:37',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS9nMw=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g4',
                                                                                         'mac_address': 'cc:be:59:dd:49:38',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS9nNA=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g5',
                                                                                         'mac_address': 'cc:be:59:dd:49:39',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS9nNQ=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g6',
                                                                                         'mac_address': 'cc:be:59:dd:49:3a',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS9nNg=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g7',
                                                                                         'mac_address': 'cc:be:59:dd:49:3b',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS9nNw=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g8',
                                                                                         'mac_address': 'cc:be:59:dd:49:3c',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZXRoZXJuZXQgMS9nOA=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/1',
                                                                                         'in_discards': '2774346',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2639830',
                                                                                         'in_octets': '82750831601307',
                                                                                         'in_ucast_pkts': '203964013094',
                                                                                         'links': [       {       'in_nucast_pkts': '72883',
                                                                                                                  'in_octets': '2883783555',
                                                                                                                  'in_ucast_pkts': '8462956',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133080',
                                                                                                                  'out_octets': '5422890191',
                                                                                                                  'out_ucast_pkts': '8908175',
                                                                                                                  'poller_hash': 'NUE1NzhCcGVlcmludGZwb24gMQ=='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'NUE1Nzk3cGVlcmludGZwb24gMw=='},
                                                                                                          {       'in_nucast_pkts': '571',
                                                                                                                  'in_octets': '114289794841',
                                                                                                                  'in_ucast_pkts': '123004564',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133074',
                                                                                                                  'out_octets': '93448348627',
                                                                                                                  'out_ucast_pkts': '113469660',
                                                                                                                  'poller_hash': 'NUE1NzlGcGVlcmludGZwb24gNA=='},
                                                                                                          {       'in_nucast_pkts': '9189',
                                                                                                                  'in_octets': '2590648443784',
                                                                                                                  'in_ucast_pkts': '7715835298',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '23811765',
                                                                                                                  'out_octets': '12953463873216',
                                                                                                                  'out_ucast_pkts': '13973446537',
                                                                                                                  'poller_hash': 'NUE1NzcxcGVlcmludGZwb24gMTA='},
                                                                                                          {       'in_nucast_pkts': '30',
                                                                                                                  'in_octets': '74518837138',
                                                                                                                  'in_ucast_pkts': '169461049',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5518902',
                                                                                                                  'out_octets': '286543884514',
                                                                                                                  'out_ucast_pkts': '274282756',
                                                                                                                  'poller_hash': 'NUE1Nzc0cGVlcmludGZwb24gMTM='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'NjVGOUQ3cGVlcmludGZwb24gMTY='},
                                                                                                          {       'in_nucast_pkts': '16923',
                                                                                                                  'in_octets': '400218288096',
                                                                                                                  'in_ucast_pkts': '1860422808',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3542911',
                                                                                                                  'out_octets': '7501061406012',
                                                                                                                  'out_ucast_pkts': '5350556622',
                                                                                                                  'poller_hash': 'NjVGOTdBcGVlcmludGZwb24gMjM='},
                                                                                                          {       'in_nucast_pkts': '248',
                                                                                                                  'in_octets': '43777761120',
                                                                                                                  'in_ucast_pkts': '121674387',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133060',
                                                                                                                  'out_octets': '226431071171',
                                                                                                                  'out_ucast_pkts': '181931775',
                                                                                                                  'poller_hash': 'NjVGOUE4cGVlcmludGZwb24gMjY='},
                                                                                                          {       'in_nucast_pkts': '23456',
                                                                                                                  'in_octets': '265604438022',
                                                                                                                  'in_ucast_pkts': '663794915',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5518850',
                                                                                                                  'out_octets': '1545996695471',
                                                                                                                  'out_ucast_pkts': '1261360682',
                                                                                                                  'poller_hash': 'NjVGOTlDcGVlcmludGZwb24gMjk='},
                                                                                                          {       'in_nucast_pkts': '1651299',
                                                                                                                  'in_octets': '93838668249',
                                                                                                                  'in_ucast_pkts': '177164788',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133232',
                                                                                                                  'out_octets': '458971098167',
                                                                                                                  'out_ucast_pkts': '393313856',
                                                                                                                  'poller_hash': 'NzcwNUYzcGVlcmludGZwb24gMzM='},
                                                                                                          {       'in_nucast_pkts': '91140',
                                                                                                                  'in_octets': '4102186531',
                                                                                                                  'in_ucast_pkts': '13492335',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133075',
                                                                                                                  'out_octets': '8493386630',
                                                                                                                  'out_ucast_pkts': '13938723',
                                                                                                                  'poller_hash': 'NzcwNzc0cGVlcmludGZwb24gMzQ='},
                                                                                                          {       'in_nucast_pkts': '142992',
                                                                                                                  'in_octets': '509658800222',
                                                                                                                  'in_ucast_pkts': '2306434980',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8178228',
                                                                                                                  'out_octets': '7314319364072',
                                                                                                                  'out_ucast_pkts': '5233644364',
                                                                                                                  'poller_hash': 'NzcwODREcGVlcmludGZwb24gMzU='},
                                                                                                          {       'in_nucast_pkts': '13555010',
                                                                                                                  'in_octets': '296418060164',
                                                                                                                  'in_ucast_pkts': '705040830',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5519036',
                                                                                                                  'out_octets': '906858338071',
                                                                                                                  'out_ucast_pkts': '979473102',
                                                                                                                  'poller_hash': 'RDlDNTA2cGVlcmludGZwb24gMzY='},
                                                                                                          {       'in_nucast_pkts': '473',
                                                                                                                  'in_octets': '17196202418',
                                                                                                                  'in_ucast_pkts': '22035717',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133180',
                                                                                                                  'out_octets': '2808141278',
                                                                                                                  'out_ucast_pkts': '15033973',
                                                                                                                  'poller_hash': 'NzcwN0FEcGVlcmludGZwb24gMzc='},
                                                                                                          {       'in_nucast_pkts': '10',
                                                                                                                  'in_octets': '28353529388',
                                                                                                                  'in_ucast_pkts': '64702932',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133072',
                                                                                                                  'out_octets': '98506262240',
                                                                                                                  'out_ucast_pkts': '94861576',
                                                                                                                  'poller_hash': 'ODdFOEMycGVlcmludGZwb24gNDI='},
                                                                                                          {       'in_nucast_pkts': '20098',
                                                                                                                  'in_octets': '334267541034',
                                                                                                                  'in_ucast_pkts': '364046805',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133065',
                                                                                                                  'out_octets': '199897727129',
                                                                                                                  'out_ucast_pkts': '332981704',
                                                                                                                  'poller_hash': 'ODdFOEMwcGVlcmludGZwb24gNDQ='},
                                                                                                          {       'in_nucast_pkts': '18221',
                                                                                                                  'in_octets': '47071000308',
                                                                                                                  'in_ucast_pkts': '74306327',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133064',
                                                                                                                  'out_octets': '128292175655',
                                                                                                                  'out_ucast_pkts': '116860106',
                                                                                                                  'poller_hash': 'ODdFOEZDcGVlcmludGZwb24gNDU='},
                                                                                                          {       'in_nucast_pkts': '27',
                                                                                                                  'in_octets': '15450352542',
                                                                                                                  'in_ucast_pkts': '55526928',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133068',
                                                                                                                  'out_octets': '127263228235',
                                                                                                                  'out_ucast_pkts': '106607052',
                                                                                                                  'poller_hash': 'ODdFNEY2cGVlcmludGZwb24gNDY='},
                                                                                                          {       'in_nucast_pkts': '19712',
                                                                                                                  'in_octets': '21830599722',
                                                                                                                  'in_ucast_pkts': '45257907',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133058',
                                                                                                                  'out_octets': '85480137767',
                                                                                                                  'out_ucast_pkts': '79941818',
                                                                                                                  'poller_hash': 'ODdFOEUwcGVlcmludGZwb24gNDc='},
                                                                                                          {       'in_nucast_pkts': '73',
                                                                                                                  'in_octets': '9967560576',
                                                                                                                  'in_ucast_pkts': '36052038',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '731356',
                                                                                                                  'out_octets': '166699532948',
                                                                                                                  'out_ucast_pkts': '125305250',
                                                                                                                  'poller_hash': 'QTFCMEExcGVlcmludGZwb24gNTI='},
                                                                                                          {       'in_nucast_pkts': '254',
                                                                                                                  'in_octets': '57258707053',
                                                                                                                  'in_ucast_pkts': '69768059',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133081',
                                                                                                                  'out_octets': '105867693687',
                                                                                                                  'out_ucast_pkts': '93777885',
                                                                                                                  'poller_hash': 'RDlDNTM4cGVlcmludGZwb24gNTg='},
                                                                                                          {       'in_nucast_pkts': '5030',
                                                                                                                  'in_octets': '603680179080',
                                                                                                                  'in_ucast_pkts': '1039460290',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8921335',
                                                                                                                  'out_octets': '1866036657186',
                                                                                                                  'out_ucast_pkts': '1726170447',
                                                                                                                  'poller_hash': 'QjJFOTE3cGVlcmludGZwb24gNTk='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': 'gpon '
                                                                                                 '1/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '25789994',
                                                                                         'out_octets': '423318588214404',
                                                                                         'out_ucast_pkts': '370078880577',
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE=',
                                                                                         'pons': [       {       'id': '1/1',
                                                                                                                 'links': [       {       'connected_time': '2187282',
                                                                                                                                          'fiber_length': 2706,
                                                                                                                                          'poller_hash': 'NUE1NzhCcGVlcnBvbnBvbiAx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'poller_hash': 'NUE1Nzk3cGVlcnBvbnBvbiAz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'connected_time': '2187290',
                                                                                                                                          'fiber_length': 2338,
                                                                                                                                          'poller_hash': 'NUE1NzlGcGVlcnBvbnBvbiA0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -11.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'connected_time': '1903254',
                                                                                                                                          'fiber_length': 4390,
                                                                                                                                          'poller_hash': 'NUE1NzcxcGVlcnBvbnBvbiAxMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'connected_time': '10548708',
                                                                                                                                          'fiber_length': 6112,
                                                                                                                                          'poller_hash': 'NUE1Nzc0cGVlcnBvbnBvbiAxMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'poller_hash': 'NjVGOUQ3cGVlcnBvbnBvbiAxNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'connected_time': '6814891',
                                                                                                                                          'fiber_length': 9226,
                                                                                                                                          'poller_hash': 'NjVGOTdBcGVlcnBvbnBvbiAyMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'connected_time': '2187306',
                                                                                                                                          'fiber_length': 9436,
                                                                                                                                          'poller_hash': 'NjVGOUE4cGVlcnBvbnBvbiAyNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'connected_time': '10548707',
                                                                                                                                          'fiber_length': 16098,
                                                                                                                                          'poller_hash': 'NjVGOTlDcGVlcnBvbnBvbiAyOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'connected_time': '2187325',
                                                                                                                                          'fiber_length': 4245,
                                                                                                                                          'poller_hash': 'NzcwNUYzcGVlcnBvbnBvbiAzMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'connected_time': '2187325',
                                                                                                                                          'fiber_length': 6766,
                                                                                                                                          'poller_hash': 'NzcwNzc0cGVlcnBvbnBvbiAzNA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'connected_time': '15231401',
                                                                                                                                          'fiber_length': 12247,
                                                                                                                                          'poller_hash': 'NzcwODREcGVlcnBvbnBvbiAzNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'connected_time': '10548846',
                                                                                                                                          'fiber_length': 5867,
                                                                                                                                          'poller_hash': 'RDlDNTA2cGVlcnBvbnBvbiAzNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'connected_time': '2187316',
                                                                                                                                          'fiber_length': 9557,
                                                                                                                                          'poller_hash': 'NzcwN0FEcGVlcnBvbnBvbiAzNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'connected_time': '2187332',
                                                                                                                                          'fiber_length': 9326,
                                                                                                                                          'poller_hash': 'ODdFOEMycGVlcnBvbnBvbiA0Mg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'connected_time': '2187332',
                                                                                                                                          'fiber_length': 16415,
                                                                                                                                          'poller_hash': 'ODdFOEMwcGVlcnBvbnBvbiA0NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'connected_time': '2187338',
                                                                                                                                          'fiber_length': 5675,
                                                                                                                                          'poller_hash': 'ODdFOEZDcGVlcnBvbnBvbiA0NQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'connected_time': '2187318',
                                                                                                                                          'fiber_length': 1210,
                                                                                                                                          'poller_hash': 'ODdFNEY2cGVlcnBvbnBvbiA0Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'connected_time': '2187318',
                                                                                                                                          'fiber_length': 8768,
                                                                                                                                          'poller_hash': 'ODdFOEUwcGVlcnBvbnBvbiA0Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'connected_time': '1410644',
                                                                                                                                          'fiber_length': 8865,
                                                                                                                                          'poller_hash': 'QTFCMEExcGVlcnBvbnBvbiA1Mg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'connected_time': '2187322',
                                                                                                                                          'fiber_length': 5495,
                                                                                                                                          'poller_hash': 'RDlDNTM4cGVlcnBvbnBvbiA1OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59},
                                                                                                                                  {       'connected_time': '16747358',
                                                                                                                                          'fiber_length': 4930,
                                                                                                                                          'poller_hash': 'QjJFOTE3cGVlcnBvbnBvbiA1OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.59}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/1',
                                                                                                                 'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/2',
                                                                                         'in_discards': '11136648',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '10244490',
                                                                                         'in_octets': '80254445777368',
                                                                                         'in_ucast_pkts': '168411291429',
                                                                                         'links': [       {       'in_nucast_pkts': '634',
                                                                                                                  'in_octets': '4934692495',
                                                                                                                  'in_ucast_pkts': '25309262',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133049',
                                                                                                                  'out_octets': '63454308375',
                                                                                                                  'out_ucast_pkts': '52581496',
                                                                                                                  'poller_hash': 'NUE1NzdFcGVlcmludGZwb24gNQ=='},
                                                                                                          {       'in_nucast_pkts': '10444',
                                                                                                                  'in_octets': '3402892258053',
                                                                                                                  'in_ucast_pkts': '6328299166',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '22119864',
                                                                                                                  'out_octets': '13286618868587',
                                                                                                                  'out_ucast_pkts': '11421691319',
                                                                                                                  'poller_hash': 'NUE1NzdGcGVlcmludGZwb24gOA=='},
                                                                                                          {       'in_nucast_pkts': '115850',
                                                                                                                  'in_octets': '76213564384',
                                                                                                                  'in_ucast_pkts': '105564953',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '943338',
                                                                                                                  'out_octets': '102334064634',
                                                                                                                  'out_ucast_pkts': '122335534',
                                                                                                                  'poller_hash': 'NUE1NzdCcGVlcmludGZwb24gOQ=='},
                                                                                                          {       'in_nucast_pkts': '5144466',
                                                                                                                  'in_octets': '314198829138',
                                                                                                                  'in_ucast_pkts': '1599186451',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13442102',
                                                                                                                  'out_octets': '2877133593595',
                                                                                                                  'out_ucast_pkts': '2511326905',
                                                                                                                  'poller_hash': 'NUE1N0Q3cGVlcmludGZwb24gMTE='},
                                                                                                          {       'in_nucast_pkts': '173463',
                                                                                                                  'in_octets': '682220030194',
                                                                                                                  'in_ucast_pkts': '2488446957',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9009928',
                                                                                                                  'out_octets': '5124549764417',
                                                                                                                  'out_ucast_pkts': '4069926013',
                                                                                                                  'poller_hash': 'NUEzNzU2cGVlcmludGZwb24gMTI='},
                                                                                                          {       'in_nucast_pkts': '40380',
                                                                                                                  'in_octets': '11614770716',
                                                                                                                  'in_ucast_pkts': '31510264',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133061',
                                                                                                                  'out_octets': '63778312445',
                                                                                                                  'out_ucast_pkts': '53249905',
                                                                                                                  'poller_hash': 'NjVGOTlBcGVlcmludGZwb24gMTU='},
                                                                                                          {       'in_nucast_pkts': '7643',
                                                                                                                  'in_octets': '74235436731',
                                                                                                                  'in_ucast_pkts': '239974542',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133069',
                                                                                                                  'out_octets': '562259540353',
                                                                                                                  'out_ucast_pkts': '451507162',
                                                                                                                  'poller_hash': 'NjVGOUJDcGVlcmludGZwb24gMTc='},
                                                                                                          {       'in_nucast_pkts': '2088',
                                                                                                                  'in_octets': '47361504598',
                                                                                                                  'in_ucast_pkts': '228314513',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5057344',
                                                                                                                  'out_octets': '470087412789',
                                                                                                                  'out_ucast_pkts': '373385399',
                                                                                                                  'poller_hash': 'NjVGOUMycGVlcmludGZwb24gMTg='},
                                                                                                          {       'in_nucast_pkts': '308829',
                                                                                                                  'in_octets': '109563990593',
                                                                                                                  'in_ucast_pkts': '604678467',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2538106',
                                                                                                                  'out_octets': '1451406802867',
                                                                                                                  'out_ucast_pkts': '1245722947',
                                                                                                                  'poller_hash': 'NjVGOUNCcGVlcmludGZwb24gMjA='},
                                                                                                          {       'in_nucast_pkts': '2320407',
                                                                                                                  'in_octets': '21268071688',
                                                                                                                  'in_ucast_pkts': '73830715',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133014',
                                                                                                                  'out_octets': '171842134106',
                                                                                                                  'out_ucast_pkts': '136437981',
                                                                                                                  'poller_hash': 'NjVGOURCcGVlcmludGZwb24gMjE='},
                                                                                                          {       'in_nucast_pkts': '153046',
                                                                                                                  'in_octets': '143485571958',
                                                                                                                  'in_ucast_pkts': '270527333',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5518678',
                                                                                                                  'out_octets': '408767146846',
                                                                                                                  'out_ucast_pkts': '412665246',
                                                                                                                  'poller_hash': 'NjVGOUY3cGVlcmludGZwb24gMjI='},
                                                                                                          {       'in_nucast_pkts': '5',
                                                                                                                  'in_octets': '2737313463',
                                                                                                                  'in_ucast_pkts': '7054539',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133074',
                                                                                                                  'out_octets': '3534931892',
                                                                                                                  'out_ucast_pkts': '6920957',
                                                                                                                  'poller_hash': 'NjVGOUIycGVlcmludGZwb24gMjQ='},
                                                                                                          {       'in_nucast_pkts': '1100146',
                                                                                                                  'in_octets': '192452729514',
                                                                                                                  'in_ucast_pkts': '1012809090',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8961986',
                                                                                                                  'out_octets': '1122511628428',
                                                                                                                  'out_ucast_pkts': '1404166036',
                                                                                                                  'poller_hash': 'NjVGOTkwcGVlcmludGZwb24gMjc='},
                                                                                                          {       'in_nucast_pkts': '72903',
                                                                                                                  'in_octets': '57158826193',
                                                                                                                  'in_ucast_pkts': '62750285',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133060',
                                                                                                                  'out_octets': '52044343917',
                                                                                                                  'out_ucast_pkts': '58818296',
                                                                                                                  'poller_hash': 'NjVGOUQxcGVlcmludGZwb24gMjg='},
                                                                                                          {       'in_nucast_pkts': '1326988',
                                                                                                                  'in_octets': '2415884519871',
                                                                                                                  'in_ucast_pkts': '2963042639',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10853116',
                                                                                                                  'out_octets': '1694694587113',
                                                                                                                  'out_ucast_pkts': '2094419729',
                                                                                                                  'poller_hash': 'NjVGNTcycGVlcmludGZwb24gMzA='},
                                                                                                          {       'in_nucast_pkts': '91130',
                                                                                                                  'in_octets': '24817670168',
                                                                                                                  'in_ucast_pkts': '47105905',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133087',
                                                                                                                  'out_octets': '21547513175',
                                                                                                                  'out_ucast_pkts': '44109768',
                                                                                                                  'poller_hash': 'NzcwN0I3cGVlcmludGZwb24gMzk='},
                                                                                                          {       'in_nucast_pkts': '42249',
                                                                                                                  'in_octets': '164927143321',
                                                                                                                  'in_ucast_pkts': '251460406',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1135918',
                                                                                                                  'out_octets': '370736254670',
                                                                                                                  'out_ucast_pkts': '357493456',
                                                                                                                  'poller_hash': 'NzcwODE4cGVlcmludGZwb24gNDA='},
                                                                                                          {       'in_nucast_pkts': '18274',
                                                                                                                  'in_octets': '48844911950',
                                                                                                                  'in_ucast_pkts': '183919036',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133062',
                                                                                                                  'out_octets': '275605480279',
                                                                                                                  'out_ucast_pkts': '222478954',
                                                                                                                  'poller_hash': 'ODdFOEY5cGVlcmludGZwb24gNDE='},
                                                                                                          {       'in_nucast_pkts': '695241',
                                                                                                                  'in_octets': '59031269008',
                                                                                                                  'in_ucast_pkts': '308924851',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5518931',
                                                                                                                  'out_octets': '153308866060',
                                                                                                                  'out_ucast_pkts': '350439981',
                                                                                                                  'poller_hash': 'ODdFODNGcGVlcmludGZwb24gNDM='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdFOEI2cGVlcmludGZwb24gNDg='},
                                                                                                          {       'in_nucast_pkts': '18535',
                                                                                                                  'in_octets': '12872761482',
                                                                                                                  'in_ucast_pkts': '25551415',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '145499',
                                                                                                                  'out_octets': '51267773432',
                                                                                                                  'out_ucast_pkts': '49236980',
                                                                                                                  'poller_hash': 'ODdFOERBcGVlcmludGZwb24gNDk='},
                                                                                                          {       'in_nucast_pkts': '65',
                                                                                                                  'in_octets': '24299832',
                                                                                                                  'in_ucast_pkts': '283129',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1470065',
                                                                                                                  'out_octets': '174008963',
                                                                                                                  'out_ucast_pkts': '285138',
                                                                                                                  'poller_hash': 'NzU0QTEzcGVlcmludGZwb24gNTA='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': 'gpon '
                                                                                                 '1/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '25789994',
                                                                                         'out_octets': '355698674062921',
                                                                                         'out_ucast_pkts': '306015444164',
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI=',
                                                                                         'pons': [       {       'id': '1/2',
                                                                                                                 'links': [       {       'connected_time': '2187285',
                                                                                                                                          'fiber_length': 3763,
                                                                                                                                          'poller_hash': 'NUE1NzdFcGVlcnBvbnBvbiA1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '73121696',
                                                                                                                                          'fiber_length': 5170,
                                                                                                                                          'poller_hash': 'NUE1NzdGcGVlcnBvbnBvbiA4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '1820068',
                                                                                                                                          'fiber_length': 4470,
                                                                                                                                          'poller_hash': 'NUE1NzdCcGVlcnBvbnBvbiA5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '16750736',
                                                                                                                                          'fiber_length': 4593,
                                                                                                                                          'poller_hash': 'NUE1N0Q3cGVlcnBvbnBvbiAxMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '16755175',
                                                                                                                                          'fiber_length': 2600,
                                                                                                                                          'poller_hash': 'NUEzNzU2cGVlcnBvbnBvbiAxMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '2187311',
                                                                                                                                          'fiber_length': 4156,
                                                                                                                                          'poller_hash': 'NjVGOTlBcGVlcnBvbnBvbiAxNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '2187297',
                                                                                                                                          'fiber_length': 2806,
                                                                                                                                          'poller_hash': 'NjVGOUJDcGVlcnBvbnBvbiAxNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '9696102',
                                                                                                                                          'fiber_length': 4621,
                                                                                                                                          'poller_hash': 'NjVGOUMycGVlcnBvbnBvbiAxOA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '4868125',
                                                                                                                                          'fiber_length': 14844,
                                                                                                                                          'poller_hash': 'NjVGOUNCcGVlcnBvbnBvbiAyMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '2187311',
                                                                                                                                          'fiber_length': 8209,
                                                                                                                                          'poller_hash': 'NjVGOURCcGVlcnBvbnBvbiAyMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '10548759',
                                                                                                                                          'fiber_length': 9281,
                                                                                                                                          'poller_hash': 'NjVGOUY3cGVlcnBvbnBvbiAyMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '2187300',
                                                                                                                                          'fiber_length': 2896,
                                                                                                                                          'poller_hash': 'NjVGOUIycGVlcnBvbnBvbiAyNA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '16749060',
                                                                                                                                          'fiber_length': 2809,
                                                                                                                                          'poller_hash': 'NjVGOTkwcGVlcnBvbnBvbiAyNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '2187286',
                                                                                                                                          'fiber_length': 15610,
                                                                                                                                          'poller_hash': 'NjVGOUQxcGVlcnBvbnBvbiAyOA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '20205601',
                                                                                                                                          'fiber_length': 14808,
                                                                                                                                          'poller_hash': 'NjVGNTcycGVlcnBvbnBvbiAzMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '2187309',
                                                                                                                                          'fiber_length': 9623,
                                                                                                                                          'poller_hash': 'NzcwN0I3cGVlcnBvbnBvbiAzOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '2189127',
                                                                                                                                          'fiber_length': 10628,
                                                                                                                                          'poller_hash': 'NzcwODE4cGVlcnBvbnBvbiA0MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '2187321',
                                                                                                                                          'fiber_length': 9349,
                                                                                                                                          'poller_hash': 'ODdFOEY5cGVlcnBvbnBvbiA0MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '10548868',
                                                                                                                                          'fiber_length': 16245,
                                                                                                                                          'poller_hash': 'ODdFODNGcGVlcnBvbnBvbiA0Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '2187369',
                                                                                                                                          'fiber_length': 16892,
                                                                                                                                          'poller_hash': 'ODdFOEI2cGVlcnBvbnBvbiA0OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -28.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '280816',
                                                                                                                                          'fiber_length': 11463,
                                                                                                                                          'poller_hash': 'ODdFOERBcGVlcnBvbnBvbiA0OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638},
                                                                                                                                  {       'connected_time': '2187302',
                                                                                                                                          'fiber_length': 9650,
                                                                                                                                          'poller_hash': 'NzU0QTEzcGVlcnBvbnBvbiA1MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.638}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/2',
                                                                                                                 'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/3',
                                                                                         'in_discards': '919586',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '29676',
                                                                                         'in_octets': '86438929134692',
                                                                                         'in_ucast_pkts': '165962062548',
                                                                                         'links': [       {       'oper_up': False,
                                                                                                                  'poller_hash': 'QTE5NjhEcGVlcmludGZwb24gMg=='},
                                                                                                          {       'in_nucast_pkts': '2331642',
                                                                                                                  'in_octets': '539390718177',
                                                                                                                  'in_ucast_pkts': '1013592404',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133266',
                                                                                                                  'out_octets': '1523386675060',
                                                                                                                  'out_ucast_pkts': '1544265213',
                                                                                                                  'poller_hash': 'NUE1N0EzcGVlcmludGZwb24gNg=='},
                                                                                                          {       'in_nucast_pkts': '727091',
                                                                                                                  'in_octets': '1174807272822',
                                                                                                                  'in_ucast_pkts': '5546791328',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5931865',
                                                                                                                  'out_octets': '14159026974024',
                                                                                                                  'out_ucast_pkts': '10935932643',
                                                                                                                  'poller_hash': 'NUE1Nzg3cGVlcmludGZwb24gNw=='},
                                                                                                          {       'in_nucast_pkts': '141103',
                                                                                                                  'in_octets': '176364858165',
                                                                                                                  'in_ucast_pkts': '276626654',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133052',
                                                                                                                  'out_octets': '294338997120',
                                                                                                                  'out_ucast_pkts': '339329725',
                                                                                                                  'poller_hash': 'NjVGOTc4cGVlcmludGZwb24gMTk='},
                                                                                                          {       'in_nucast_pkts': '909',
                                                                                                                  'in_octets': '11713464589',
                                                                                                                  'in_ucast_pkts': '29364792',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133100',
                                                                                                                  'out_octets': '71465681197',
                                                                                                                  'out_ucast_pkts': '67354686',
                                                                                                                  'poller_hash': 'RDlDNTYxcGVlcmludGZwb24gMjU='},
                                                                                                          {       'in_nucast_pkts': '407956',
                                                                                                                  'in_octets': '1221510266311',
                                                                                                                  'in_ucast_pkts': '1902168430',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4201226',
                                                                                                                  'out_octets': '2666271319266',
                                                                                                                  'out_ucast_pkts': '2758555872',
                                                                                                                  'poller_hash': 'NkZERTAwcGVlcmludGZwb24gMzE='},
                                                                                                          {       'in_nucast_pkts': '2803911',
                                                                                                                  'in_octets': '88885220656',
                                                                                                                  'in_ucast_pkts': '376329088',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3250413',
                                                                                                                  'out_octets': '1464460157576',
                                                                                                                  'out_ucast_pkts': '1051686707',
                                                                                                                  'poller_hash': 'QTFBQTEzcGVlcmludGZwb24gNTE='},
                                                                                                          {       'in_nucast_pkts': '1199037',
                                                                                                                  'in_octets': '80659296870',
                                                                                                                  'in_ucast_pkts': '159415156',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1132991',
                                                                                                                  'out_octets': '401868040849',
                                                                                                                  'out_ucast_pkts': '357587845',
                                                                                                                  'poller_hash': 'QTFCMDdGcGVlcmludGZwb24gNTM='},
                                                                                                          {       'in_nucast_pkts': '20128',
                                                                                                                  'in_octets': '59116492195',
                                                                                                                  'in_ucast_pkts': '124159327',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133060',
                                                                                                                  'out_octets': '318231122168',
                                                                                                                  'out_ucast_pkts': '281319241',
                                                                                                                  'poller_hash': 'QTE5NkZFcGVlcmludGZwb24gNTQ='},
                                                                                                          {       'in_nucast_pkts': '244152',
                                                                                                                  'in_octets': '4951942502',
                                                                                                                  'in_ucast_pkts': '18061776',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '92597',
                                                                                                                  'out_octets': '68868023275',
                                                                                                                  'out_ucast_pkts': '54607158',
                                                                                                                  'poller_hash': 'QzFCN0ExcGVlcmludGZwb24gNTU='},
                                                                                                          {       'in_nucast_pkts': '1917695',
                                                                                                                  'in_octets': '33404130864',
                                                                                                                  'in_ucast_pkts': '75236121',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '729855',
                                                                                                                  'out_octets': '234878026699',
                                                                                                                  'out_ucast_pkts': '188918246',
                                                                                                                  'poller_hash': 'QzFCOTE0cGVlcmludGZwb24gNTY='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': 'gpon '
                                                                                                 '1/3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '25789994',
                                                                                         'out_octets': '320761120680106',
                                                                                         'out_ucast_pkts': '287022761942',
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM=',
                                                                                         'pons': [       {       'id': '1/3',
                                                                                                                 'links': [       {       'poller_hash': 'QTE5NjhEcGVlcnBvbnBvbiAy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.502},
                                                                                                                                  {       'connected_time': '2187295',
                                                                                                                                          'fiber_length': 1750,
                                                                                                                                          'poller_hash': 'NUE1N0EzcGVlcnBvbnBvbiA2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.502},
                                                                                                                                  {       'connected_time': '11080677',
                                                                                                                                          'fiber_length': 2793,
                                                                                                                                          'poller_hash': 'NUE1Nzg3cGVlcnBvbnBvbiA3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.502},
                                                                                                                                  {       'connected_time': '2187297',
                                                                                                                                          'fiber_length': 5818,
                                                                                                                                          'poller_hash': 'NjVGOTc4cGVlcnBvbnBvbiAxOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.502},
                                                                                                                                  {       'connected_time': '2187310',
                                                                                                                                          'fiber_length': 5296,
                                                                                                                                          'poller_hash': 'RDlDNTYxcGVlcnBvbnBvbiAyNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.502},
                                                                                                                                  {       'connected_time': '3758742',
                                                                                                                                          'fiber_length': 5404,
                                                                                                                                          'poller_hash': 'NkZERTAwcGVlcnBvbnBvbiAzMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.502},
                                                                                                                                  {       'connected_time': '2186727',
                                                                                                                                          'fiber_length': 17008,
                                                                                                                                          'poller_hash': 'QTFBQTEzcGVlcnBvbnBvbiA1MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.502},
                                                                                                                                  {       'connected_time': '2187323',
                                                                                                                                          'fiber_length': 5116,
                                                                                                                                          'poller_hash': 'QTFCMDdGcGVlcnBvbnBvbiA1Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.502},
                                                                                                                                  {       'connected_time': '2187321',
                                                                                                                                          'fiber_length': 4761,
                                                                                                                                          'poller_hash': 'QTE5NkZFcGVlcnBvbnBvbiA1NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.502},
                                                                                                                                  {       'connected_time': '179258',
                                                                                                                                          'fiber_length': 9251,
                                                                                                                                          'poller_hash': 'QzFCN0ExcGVlcnBvbnBvbiA1NQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.502},
                                                                                                                                  {       'connected_time': '1408174',
                                                                                                                                          'fiber_length': 9858,
                                                                                                                                          'poller_hash': 'QzFCOTE0cGVlcnBvbnBvbiA1Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.502}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/3',
                                                                                                                 'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/4',
                                                                                         'in_discards': '166',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '3027',
                                                                                         'in_octets': '19428361280',
                                                                                         'in_ucast_pkts': '56085791',
                                                                                         'links': [       {       'in_nucast_pkts': '91113',
                                                                                                                  'in_octets': '8341811894',
                                                                                                                  'in_ucast_pkts': '12390242',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1133090',
                                                                                                                  'out_octets': '2692153091',
                                                                                                                  'out_ucast_pkts': '7782692',
                                                                                                                  'poller_hash': 'QjNBRjUzcGVlcmludGZwb24gNjA='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05121',
                                                                                         'name': 'gpon '
                                                                                                 '1/4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '5280000',
                                                                                         'out_octets': '32755566837',
                                                                                         'out_ucast_pkts': '58828044',
                                                                                         'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzQ=',
                                                                                         'pons': [       {       'id': '1/4',
                                                                                                                 'links': [       {       'connected_time': '2187322',
                                                                                                                                          'fiber_length': 16352,
                                                                                                                                          'poller_hash': 'QjNBRjUzcGVlcnBvbnBvbiA2MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.526}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/4',
                                                                                                                 'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzQ=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-03656',
                                                           'name': 'GPON-4r2',
                                                           'poller_hash': 'MjExODA2NjAwNTUw',
                                                           'serial_number': '211806600550',
                                                           'sw_version': '3.3.21.2',
                                                           'uptime': '143456558'}],
                                'serial_number': '71704975659',
                                'sw_version': '3.3.21.2',
                                'system_mac_address': 'cc:be:59:dd:49:33'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f8:bc:0e:62:8c:e0'],
                                                                       'id': '1/g1',
                                                                       'in_nucast_pkts': '72883',
                                                                       'in_octets': '2883783555',
                                                                       'in_ucast_pkts': '8462956',
                                                                       'mac_address': 'cc:be:59:bb:3c:fc',
                                                                       'mtu': 2000,
                                                                       'name': '1/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133080',
                                                                       'out_octets': '5422890191',
                                                                       'out_ucast_pkts': '8908175',
                                                                       'poller_hash': 'NUE1NzhCcGVlcmludGYxL2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_nucast_pkts': '1133080',
                                                                       'in_octets': '5422890191',
                                                                       'in_ucast_pkts': '8908175',
                                                                       'links': [       {       'in_nucast_pkts': '1133080',
                                                                                                'in_octets': '5422890191',
                                                                                                'in_ucast_pkts': '8908175',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '72883',
                                                                                                'out_octets': '2883783555',
                                                                                                'out_ucast_pkts': '8462956',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '72883',
                                                                       'out_octets': '2883783555',
                                                                       'out_ucast_pkts': '8462956',
                                                                       'poller_hash': 'NUE1NzhCcGVlcmludGZwb24gMQ==',
                                                                       'pons': [       {       'id': '1',
                                                                                               'links': [       {       'connected_time': '2187282',
                                                                                                                        'fiber_length': 2706,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'NUE1NzhCcGVlcnBvbnBvbiAx',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 1',
                                         'poller_hash': 'NUE1NzhC',
                                         'serial_number': '5A578B',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3c:fc',
                                         'uptime': '2187282'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2/g1',
                                                                       'name': '2/g1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QTE5NjhEcGVlcmludGYyL2cx'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QTE5NjhEcGVlcmludGZwb24gMg==',
                                                                       'pons': [       {       'id': '2',
                                                                                               'links': [       {       'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'tx_link_rate': '1244160000'}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -7.0,
                                                                                               'minimum_loss': -30.0,
                                                                                               'name': 'pon '
                                                                                                       '2',
                                                                                               'poller_hash': 'QTE5NjhEcGVlcnBvbnBvbiAy',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'name': 'ont 2',
                                         'poller_hash': 'QTE5NjhE',
                                         'serial_number': 'A1968D',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '3/g1',
                                                                       'name': '3/g1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NUE1Nzk3cGVlcmludGYzL2cx'},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NUE1Nzk3cGVlcmludGZwb24gMw==',
                                                                       'pons': [       {       'id': '3',
                                                                                               'links': [       {       'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'tx_link_rate': '1244160000'}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -7.0,
                                                                                               'minimum_loss': -30.0,
                                                                                               'name': 'pon '
                                                                                                       '3',
                                                                                               'poller_hash': 'NUE1Nzk3cGVlcnBvbnBvbiAz',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'name': 'ont 3',
                                         'poller_hash': 'NUE1Nzk3',
                                         'serial_number': '5A5797',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd4:6a:91:ba:9b:0d'],
                                                                       'id': '4/g1',
                                                                       'in_nucast_pkts': '571',
                                                                       'in_octets': '114289794841',
                                                                       'in_ucast_pkts': '123004564',
                                                                       'mac_address': 'cc:be:59:bb:3d:38',
                                                                       'mtu': 2000,
                                                                       'name': '4/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133074',
                                                                       'out_octets': '93448348627',
                                                                       'out_ucast_pkts': '113469660',
                                                                       'poller_hash': 'NUE1NzlGcGVlcmludGY0L2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '4',
                                                                       'in_nucast_pkts': '1133074',
                                                                       'in_octets': '93448348627',
                                                                       'in_ucast_pkts': '113469660',
                                                                       'links': [       {       'in_nucast_pkts': '1133074',
                                                                                                'in_octets': '93448348627',
                                                                                                'in_ucast_pkts': '113469660',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '571',
                                                                                                'out_octets': '114289794841',
                                                                                                'out_ucast_pkts': '123004564',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 4',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '571',
                                                                       'out_octets': '114289794841',
                                                                       'out_ucast_pkts': '123004564',
                                                                       'poller_hash': 'NUE1NzlGcGVlcmludGZwb24gNA==',
                                                                       'pons': [       {       'id': '4',
                                                                                               'links': [       {       'connected_time': '2187290',
                                                                                                                        'fiber_length': 2338,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '4',
                                                                                               'poller_hash': 'NUE1NzlGcGVlcnBvbnBvbiA0',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': '11689',
                                         'poller_hash': 'NUE1NzlG',
                                         'serial_number': '5A579F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3d:38',
                                         'uptime': '2187290'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '90:a7:c1:dd:52:6e'],
                                                                       'id': '5/g1',
                                                                       'in_nucast_pkts': '634',
                                                                       'in_octets': '4934692495',
                                                                       'in_ucast_pkts': '25309262',
                                                                       'mac_address': 'cc:be:59:bb:3c:d5',
                                                                       'mtu': 2000,
                                                                       'name': '5/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133049',
                                                                       'out_octets': '63454308375',
                                                                       'out_ucast_pkts': '52581496',
                                                                       'poller_hash': 'NUE1NzdFcGVlcmludGY1L2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '5',
                                                                       'in_nucast_pkts': '1133049',
                                                                       'in_octets': '63454308375',
                                                                       'in_ucast_pkts': '52581496',
                                                                       'links': [       {       'in_nucast_pkts': '1133049',
                                                                                                'in_octets': '63454308375',
                                                                                                'in_ucast_pkts': '52581496',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '634',
                                                                                                'out_octets': '4934692495',
                                                                                                'out_ucast_pkts': '25309262',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 5',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '634',
                                                                       'out_octets': '4934692495',
                                                                       'out_ucast_pkts': '25309262',
                                                                       'poller_hash': 'NUE1NzdFcGVlcmludGZwb24gNQ==',
                                                                       'pons': [       {       'id': '5',
                                                                                               'links': [       {       'connected_time': '2187285',
                                                                                                                        'fiber_length': 3763,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '5',
                                                                                               'poller_hash': 'NUE1NzdFcGVlcnBvbnBvbiA1',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 5',
                                         'poller_hash': 'NUE1NzdF',
                                         'serial_number': '5A577E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3c:d5',
                                         'uptime': '2187285'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:18:0a:85:5b:76',
                                                                                                        '18:b1:69:d8:18:44'],
                                                                       'id': '6/g1',
                                                                       'in_nucast_pkts': '2331642',
                                                                       'in_octets': '539390718177',
                                                                       'in_ucast_pkts': '1013592404',
                                                                       'mac_address': 'cc:be:59:bb:3d:44',
                                                                       'mtu': 2000,
                                                                       'name': '6/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133266',
                                                                       'out_octets': '1523386675060',
                                                                       'out_ucast_pkts': '1544265213',
                                                                       'poller_hash': 'NUE1N0EzcGVlcmludGY2L2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '6',
                                                                       'in_nucast_pkts': '1133266',
                                                                       'in_octets': '1523386675060',
                                                                       'in_ucast_pkts': '1544265213',
                                                                       'links': [       {       'in_nucast_pkts': '1133266',
                                                                                                'in_octets': '1523386675060',
                                                                                                'in_ucast_pkts': '1544265213',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '2331642',
                                                                                                'out_octets': '539390718177',
                                                                                                'out_ucast_pkts': '1013592404',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 6',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2331642',
                                                                       'out_octets': '539390718177',
                                                                       'out_ucast_pkts': '1013592404',
                                                                       'poller_hash': 'NUE1N0EzcGVlcmludGZwb24gNg==',
                                                                       'pons': [       {       'id': '6',
                                                                                               'links': [       {       'connected_time': '2187295',
                                                                                                                        'fiber_length': 1750,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '6',
                                                                                               'poller_hash': 'NUE1N0EzcGVlcnBvbnBvbiA2',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 6',
                                         'poller_hash': 'NUE1N0Ez',
                                         'serial_number': '5A57A3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3d:44',
                                         'uptime': '2187295'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f8:9e:28:84:01:e5'],
                                                                       'id': '7/g1',
                                                                       'in_nucast_pkts': '727091',
                                                                       'in_octets': '1174807272822',
                                                                       'in_ucast_pkts': '5546791328',
                                                                       'mac_address': 'cc:be:59:bb:3c:f0',
                                                                       'mtu': 2000,
                                                                       'name': '7/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '5931865',
                                                                       'out_octets': '14159026974024',
                                                                       'out_ucast_pkts': '10935932643',
                                                                       'poller_hash': 'NUE1Nzg3cGVlcmludGY3L2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '7',
                                                                       'in_nucast_pkts': '5931865',
                                                                       'in_octets': '14159026974024',
                                                                       'in_ucast_pkts': '10935932643',
                                                                       'links': [       {       'in_nucast_pkts': '5931865',
                                                                                                'in_octets': '14159026974024',
                                                                                                'in_ucast_pkts': '10935932643',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '727091',
                                                                                                'out_octets': '1174807272822',
                                                                                                'out_ucast_pkts': '5546791328',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 7',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '727091',
                                                                       'out_octets': '1174807272822',
                                                                       'out_ucast_pkts': '5546791328',
                                                                       'poller_hash': 'NUE1Nzg3cGVlcmludGZwb24gNw==',
                                                                       'pons': [       {       'id': '7',
                                                                                               'links': [       {       'connected_time': '11080677',
                                                                                                                        'fiber_length': 2793,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '7',
                                                                                               'poller_hash': 'NUE1Nzg3cGVlcnBvbnBvbiA3',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 7',
                                         'poller_hash': 'NUE1Nzg3',
                                         'serial_number': '5A5787',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3c:f0',
                                         'uptime': '11080677'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd4:6a:91:b0:80:21'],
                                                                       'id': '8/g1',
                                                                       'in_nucast_pkts': '10444',
                                                                       'in_octets': '3402892258053',
                                                                       'in_ucast_pkts': '6328299166',
                                                                       'mac_address': 'cc:be:59:bb:3c:d8',
                                                                       'mtu': 2000,
                                                                       'name': '8/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '22119864',
                                                                       'out_octets': '13286618868587',
                                                                       'out_ucast_pkts': '11421691319',
                                                                       'poller_hash': 'NUE1NzdGcGVlcmludGY4L2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '8',
                                                                       'in_nucast_pkts': '22119864',
                                                                       'in_octets': '13286618868587',
                                                                       'in_ucast_pkts': '11421691319',
                                                                       'links': [       {       'in_nucast_pkts': '22119864',
                                                                                                'in_octets': '13286618868587',
                                                                                                'in_ucast_pkts': '11421691319',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '10444',
                                                                                                'out_octets': '3402892258053',
                                                                                                'out_ucast_pkts': '6328299166',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 8',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '10444',
                                                                       'out_octets': '3402892258053',
                                                                       'out_ucast_pkts': '6328299166',
                                                                       'poller_hash': 'NUE1NzdGcGVlcmludGZwb24gOA==',
                                                                       'pons': [       {       'id': '8',
                                                                                               'links': [       {       'connected_time': '73121696',
                                                                                                                        'fiber_length': 5170,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '8',
                                                                                               'poller_hash': 'NUE1NzdGcGVlcnBvbnBvbiA4',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 8',
                                         'poller_hash': 'NUE1NzdG',
                                         'serial_number': '5A577F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3c:d8',
                                         'uptime': '73121696'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f8:9e:28:7f:31:3d'],
                                                                       'id': '9/g1',
                                                                       'in_nucast_pkts': '115850',
                                                                       'in_octets': '76213564384',
                                                                       'in_ucast_pkts': '105564953',
                                                                       'mac_address': 'cc:be:59:bb:3c:cc',
                                                                       'mtu': 2000,
                                                                       'name': '9/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '943338',
                                                                       'out_octets': '102334064634',
                                                                       'out_ucast_pkts': '122335534',
                                                                       'poller_hash': 'NUE1NzdCcGVlcmludGY5L2cx',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '9',
                                                                       'in_nucast_pkts': '943338',
                                                                       'in_octets': '102334064634',
                                                                       'in_ucast_pkts': '122335534',
                                                                       'links': [       {       'in_nucast_pkts': '943338',
                                                                                                'in_octets': '102334064634',
                                                                                                'in_ucast_pkts': '122335534',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '115850',
                                                                                                'out_octets': '76213564384',
                                                                                                'out_ucast_pkts': '105564953',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 9',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '115850',
                                                                       'out_octets': '76213564384',
                                                                       'out_ucast_pkts': '105564953',
                                                                       'poller_hash': 'NUE1NzdCcGVlcmludGZwb24gOQ==',
                                                                       'pons': [       {       'id': '9',
                                                                                               'links': [       {       'connected_time': '1820068',
                                                                                                                        'fiber_length': 4470,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '9',
                                                                                               'poller_hash': 'NUE1NzdCcGVlcnBvbnBvbiA5',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 9',
                                         'poller_hash': 'NUE1NzdC',
                                         'serial_number': '5A577B',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3c:cc',
                                         'uptime': '1820068'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '18:b1:69:c7:49:7d'],
                                                                       'id': '10/g1',
                                                                       'in_nucast_pkts': '9189',
                                                                       'in_octets': '2590648443784',
                                                                       'in_ucast_pkts': '7715835298',
                                                                       'mac_address': 'cc:be:59:bb:3c:ae',
                                                                       'mtu': 2000,
                                                                       'name': '10/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '23811765',
                                                                       'out_octets': '12953463873216',
                                                                       'out_ucast_pkts': '13973446537',
                                                                       'poller_hash': 'NUE1NzcxcGVlcmludGYxMC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '10',
                                                                       'in_nucast_pkts': '23811765',
                                                                       'in_octets': '12953463873216',
                                                                       'in_ucast_pkts': '13973446537',
                                                                       'links': [       {       'in_nucast_pkts': '23811765',
                                                                                                'in_octets': '12953463873216',
                                                                                                'in_ucast_pkts': '13973446537',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '9189',
                                                                                                'out_octets': '2590648443784',
                                                                                                'out_ucast_pkts': '7715835298',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 10',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '9189',
                                                                       'out_octets': '2590648443784',
                                                                       'out_ucast_pkts': '7715835298',
                                                                       'poller_hash': 'NUE1NzcxcGVlcmludGZwb24gMTA=',
                                                                       'pons': [       {       'id': '10',
                                                                                               'links': [       {       'connected_time': '1903254',
                                                                                                                        'fiber_length': 4390,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '10',
                                                                                               'poller_hash': 'NUE1NzcxcGVlcnBvbnBvbiAxMA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 10',
                                         'poller_hash': 'NUE1Nzcx',
                                         'serial_number': '5A5771',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3c:ae',
                                         'uptime': '1903254'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '20:b5:c6:1a:4d:a9',
                                                                                                        'ac:17:c8:d0:52:ba',
                                                                                                        'ec:13:b2:92:c7:e8'],
                                                                       'id': '11/g1',
                                                                       'in_nucast_pkts': '5144466',
                                                                       'in_octets': '314198829138',
                                                                       'in_ucast_pkts': '1599186451',
                                                                       'mac_address': 'cc:be:59:bb:3d:e0',
                                                                       'mtu': 2000,
                                                                       'name': '11/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '13442102',
                                                                       'out_octets': '2877133593595',
                                                                       'out_ucast_pkts': '2511326905',
                                                                       'poller_hash': 'NUE1N0Q3cGVlcmludGYxMS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '11',
                                                                       'in_nucast_pkts': '13442102',
                                                                       'in_octets': '2877133593595',
                                                                       'in_ucast_pkts': '2511326905',
                                                                       'links': [       {       'in_nucast_pkts': '13442102',
                                                                                                'in_octets': '2877133593595',
                                                                                                'in_ucast_pkts': '2511326905',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '5144466',
                                                                                                'out_octets': '314198829138',
                                                                                                'out_ucast_pkts': '1599186451',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 11',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '5144466',
                                                                       'out_octets': '314198829138',
                                                                       'out_ucast_pkts': '1599186451',
                                                                       'poller_hash': 'NUE1N0Q3cGVlcmludGZwb24gMTE=',
                                                                       'pons': [       {       'id': '11',
                                                                                               'links': [       {       'connected_time': '16750736',
                                                                                                                        'fiber_length': 4593,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '11',
                                                                                               'poller_hash': 'NUE1N0Q3cGVlcnBvbnBvbiAxMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 11',
                                         'poller_hash': 'NUE1N0Q3',
                                         'serial_number': '5A57D7',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3d:e0',
                                         'uptime': '16750736'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '58:6d:8f:8a:8d:a7'],
                                                                       'id': '12/g1',
                                                                       'in_nucast_pkts': '173463',
                                                                       'in_octets': '682220030194',
                                                                       'in_ucast_pkts': '2488446957',
                                                                       'mac_address': '44:65:7f:7b:94:5e',
                                                                       'mtu': 2000,
                                                                       'name': '12/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '9009928',
                                                                       'out_octets': '5124549764417',
                                                                       'out_ucast_pkts': '4069926013',
                                                                       'poller_hash': 'NUEzNzU2cGVlcmludGYxMi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '12',
                                                                       'in_nucast_pkts': '9009928',
                                                                       'in_octets': '5124549764417',
                                                                       'in_ucast_pkts': '4069926013',
                                                                       'links': [       {       'in_nucast_pkts': '9009928',
                                                                                                'in_octets': '5124549764417',
                                                                                                'in_ucast_pkts': '4069926013',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '173463',
                                                                                                'out_octets': '682220030194',
                                                                                                'out_ucast_pkts': '2488446957',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 12',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '173463',
                                                                       'out_octets': '682220030194',
                                                                       'out_ucast_pkts': '2488446957',
                                                                       'poller_hash': 'NUEzNzU2cGVlcmludGZwb24gMTI=',
                                                                       'pons': [       {       'id': '12',
                                                                                               'links': [       {       'connected_time': '16755175',
                                                                                                                        'fiber_length': 2600,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '12',
                                                                                               'poller_hash': 'NUEzNzU2cGVlcnBvbnBvbiAxMg==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 12',
                                         'poller_hash': 'NUEzNzU2',
                                         'serial_number': '5A3756',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:7b:94:5e',
                                         'uptime': '16755175'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'fc:ec:da:d3:eb:2b'],
                                                                       'id': '13/g1',
                                                                       'in_nucast_pkts': '30',
                                                                       'in_octets': '74518837138',
                                                                       'in_ucast_pkts': '169461049',
                                                                       'mac_address': 'cc:be:59:bb:3c:b7',
                                                                       'mtu': 2000,
                                                                       'name': '13/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '5518902',
                                                                       'out_octets': '286543884514',
                                                                       'out_ucast_pkts': '274282756',
                                                                       'poller_hash': 'NUE1Nzc0cGVlcmludGYxMy9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '13',
                                                                       'in_nucast_pkts': '5518902',
                                                                       'in_octets': '286543884514',
                                                                       'in_ucast_pkts': '274282756',
                                                                       'links': [       {       'in_nucast_pkts': '5518902',
                                                                                                'in_octets': '286543884514',
                                                                                                'in_ucast_pkts': '274282756',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '30',
                                                                                                'out_octets': '74518837138',
                                                                                                'out_ucast_pkts': '169461049',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 13',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '30',
                                                                       'out_octets': '74518837138',
                                                                       'out_ucast_pkts': '169461049',
                                                                       'poller_hash': 'NUE1Nzc0cGVlcmludGZwb24gMTM=',
                                                                       'pons': [       {       'id': '13',
                                                                                               'links': [       {       'connected_time': '10548708',
                                                                                                                        'fiber_length': 6112,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '13',
                                                                                               'poller_hash': 'NUE1Nzc0cGVlcnBvbnBvbiAxMw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 13',
                                         'poller_hash': 'NUE1Nzc0',
                                         'serial_number': '5A5774',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'cc:be:59:bb:3c:b7',
                                         'uptime': '10548708'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '14/g1',
                                                                       'mtu': 0,
                                                                       'name': '14/g1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'NEQ5QUY0cGVlcmludGYxNC9nMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': '14/g2',
                                                                       'mtu': 0,
                                                                       'name': '14/g2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'NEQ5QUY0cGVlcmludGYxNC9nMg=='},
                                                               {       'admin_up': True,
                                                                       'id': '14/g3',
                                                                       'mtu': 0,
                                                                       'name': '14/g3',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'NEQ5QUY0cGVlcmludGYxNC9nMw=='},
                                                               {       'admin_up': True,
                                                                       'id': '14/g4',
                                                                       'mtu': 0,
                                                                       'name': '14/g4',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'NEQ5QUY0cGVlcmludGYxNC9nNA=='},
                                                               {       'admin_up': True,
                                                                       'id': '14',
                                                                       'name': 'pon 14',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NEQ5QUY0cGVlcmludGZwb24gMTQ='}],
                                         'name': 'ont 14',
                                         'poller_hash': 'NEQ5QUY0',
                                         'serial_number': '4D9AF4',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:f8:b3:b6:7b:ed'],
                                                                       'id': '15/g1',
                                                                       'in_nucast_pkts': '40380',
                                                                       'in_octets': '11614770716',
                                                                       'in_ucast_pkts': '31510264',
                                                                       'mac_address': '44:65:7f:bb:4a:00',
                                                                       'mtu': 2000,
                                                                       'name': '15/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133061',
                                                                       'out_octets': '63778312445',
                                                                       'out_ucast_pkts': '53249905',
                                                                       'poller_hash': 'NjVGOTlBcGVlcmludGYxNS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '15',
                                                                       'in_nucast_pkts': '1133061',
                                                                       'in_octets': '63778312445',
                                                                       'in_ucast_pkts': '53249905',
                                                                       'links': [       {       'in_nucast_pkts': '1133061',
                                                                                                'in_octets': '63778312445',
                                                                                                'in_ucast_pkts': '53249905',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '40380',
                                                                                                'out_octets': '11614770716',
                                                                                                'out_ucast_pkts': '31510264',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 15',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '40380',
                                                                       'out_octets': '11614770716',
                                                                       'out_ucast_pkts': '31510264',
                                                                       'poller_hash': 'NjVGOTlBcGVlcmludGZwb24gMTU=',
                                                                       'pons': [       {       'id': '15',
                                                                                               'links': [       {       'connected_time': '2187311',
                                                                                                                        'fiber_length': 4156,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '15',
                                                                                               'poller_hash': 'NjVGOTlBcGVlcnBvbnBvbiAxNQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 15',
                                         'poller_hash': 'NjVGOTlB',
                                         'serial_number': '65F99A',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4a:00',
                                         'uptime': '2187311'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '16/g1',
                                                                       'name': '16/g1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NjVGOUQ3cGVlcmludGYxNi9nMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': '16',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 16',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NjVGOUQ3cGVlcmludGZwb24gMTY=',
                                                                       'pons': [       {       'id': '16',
                                                                                               'links': [       {       'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'tx_link_rate': '1244160000'}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -7.0,
                                                                                               'minimum_loss': -30.0,
                                                                                               'name': 'pon '
                                                                                                       '16',
                                                                                               'poller_hash': 'NjVGOUQ3cGVlcnBvbnBvbiAxNg==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'name': 'ont 16',
                                         'poller_hash': 'NjVGOUQ3',
                                         'serial_number': '65F9D7',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '24:f5:a2:0b:17:d4'],
                                                                       'id': '17/g1',
                                                                       'in_nucast_pkts': '7643',
                                                                       'in_octets': '74235436731',
                                                                       'in_ucast_pkts': '239974542',
                                                                       'mac_address': '44:65:7f:bb:4a:66',
                                                                       'mtu': 2000,
                                                                       'name': '17/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133069',
                                                                       'out_octets': '562259540353',
                                                                       'out_ucast_pkts': '451507162',
                                                                       'poller_hash': 'NjVGOUJDcGVlcmludGYxNy9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '17',
                                                                       'in_nucast_pkts': '1133069',
                                                                       'in_octets': '562259540353',
                                                                       'in_ucast_pkts': '451507162',
                                                                       'links': [       {       'in_nucast_pkts': '1133069',
                                                                                                'in_octets': '562259540353',
                                                                                                'in_ucast_pkts': '451507162',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '7643',
                                                                                                'out_octets': '74235436731',
                                                                                                'out_ucast_pkts': '239974542',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 17',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '7643',
                                                                       'out_octets': '74235436731',
                                                                       'out_ucast_pkts': '239974542',
                                                                       'poller_hash': 'NjVGOUJDcGVlcmludGZwb24gMTc=',
                                                                       'pons': [       {       'id': '17',
                                                                                               'links': [       {       'connected_time': '2187297',
                                                                                                                        'fiber_length': 2806,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '17',
                                                                                               'poller_hash': 'NjVGOUJDcGVlcnBvbnBvbiAxNw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 17',
                                         'poller_hash': 'NjVGOUJD',
                                         'serial_number': '65F9BC',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4a:66',
                                         'uptime': '2187297'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd4:6a:91:b0:6f:61'],
                                                                       'id': '18/g1',
                                                                       'in_nucast_pkts': '2088',
                                                                       'in_octets': '47361504598',
                                                                       'in_ucast_pkts': '228314513',
                                                                       'mac_address': '44:65:7f:bb:4a:78',
                                                                       'mtu': 2000,
                                                                       'name': '18/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '5057344',
                                                                       'out_octets': '470087412789',
                                                                       'out_ucast_pkts': '373385399',
                                                                       'poller_hash': 'NjVGOUMycGVlcmludGYxOC9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '18',
                                                                       'in_nucast_pkts': '5057344',
                                                                       'in_octets': '470087412789',
                                                                       'in_ucast_pkts': '373385399',
                                                                       'links': [       {       'in_nucast_pkts': '5057344',
                                                                                                'in_octets': '470087412789',
                                                                                                'in_ucast_pkts': '373385399',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '2088',
                                                                                                'out_octets': '47361504598',
                                                                                                'out_ucast_pkts': '228314513',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 18',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2088',
                                                                       'out_octets': '47361504598',
                                                                       'out_ucast_pkts': '228314513',
                                                                       'poller_hash': 'NjVGOUMycGVlcmludGZwb24gMTg=',
                                                                       'pons': [       {       'id': '18',
                                                                                               'links': [       {       'connected_time': '9696102',
                                                                                                                        'fiber_length': 4621,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '18',
                                                                                               'poller_hash': 'NjVGOUMycGVlcnBvbnBvbiAxOA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 18',
                                         'poller_hash': 'NjVGOUMy',
                                         'serial_number': '65F9C2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4a:78',
                                         'uptime': '9696102'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e0:cb:bc:19:d8:a0'],
                                                                       'id': '19/g1',
                                                                       'in_nucast_pkts': '141103',
                                                                       'in_octets': '176364858165',
                                                                       'in_ucast_pkts': '276626654',
                                                                       'mac_address': '44:65:7f:bb:49:9a',
                                                                       'mtu': 2000,
                                                                       'name': '19/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133052',
                                                                       'out_octets': '294338997120',
                                                                       'out_ucast_pkts': '339329725',
                                                                       'poller_hash': 'NjVGOTc4cGVlcmludGYxOS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '19',
                                                                       'in_nucast_pkts': '1133052',
                                                                       'in_octets': '294338997120',
                                                                       'in_ucast_pkts': '339329725',
                                                                       'links': [       {       'in_nucast_pkts': '1133052',
                                                                                                'in_octets': '294338997120',
                                                                                                'in_ucast_pkts': '339329725',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '141103',
                                                                                                'out_octets': '176364858165',
                                                                                                'out_ucast_pkts': '276626654',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 19',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '141103',
                                                                       'out_octets': '176364858165',
                                                                       'out_ucast_pkts': '276626654',
                                                                       'poller_hash': 'NjVGOTc4cGVlcmludGZwb24gMTk=',
                                                                       'pons': [       {       'id': '19',
                                                                                               'links': [       {       'connected_time': '2187297',
                                                                                                                        'fiber_length': 5818,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '19',
                                                                                               'poller_hash': 'NjVGOTc4cGVlcnBvbnBvbiAxOQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 19',
                                         'poller_hash': 'NjVGOTc4',
                                         'serial_number': '65F978',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:49:9a',
                                         'uptime': '2187297'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '14:9f:43:19:ec:4d'],
                                                                       'id': '20/g1',
                                                                       'in_nucast_pkts': '308829',
                                                                       'in_octets': '109563990593',
                                                                       'in_ucast_pkts': '604678467',
                                                                       'mac_address': '44:65:7f:bb:4a:93',
                                                                       'mtu': 2000,
                                                                       'name': '20/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2538106',
                                                                       'out_octets': '1451406802867',
                                                                       'out_ucast_pkts': '1245722947',
                                                                       'poller_hash': 'NjVGOUNCcGVlcmludGYyMC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '20',
                                                                       'in_nucast_pkts': '2538106',
                                                                       'in_octets': '1451406802867',
                                                                       'in_ucast_pkts': '1245722947',
                                                                       'links': [       {       'in_nucast_pkts': '2538106',
                                                                                                'in_octets': '1451406802867',
                                                                                                'in_ucast_pkts': '1245722947',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '308829',
                                                                                                'out_octets': '109563990593',
                                                                                                'out_ucast_pkts': '604678467',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 20',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '308829',
                                                                       'out_octets': '109563990593',
                                                                       'out_ucast_pkts': '604678467',
                                                                       'poller_hash': 'NjVGOUNCcGVlcmludGZwb24gMjA=',
                                                                       'pons': [       {       'id': '20',
                                                                                               'links': [       {       'connected_time': '4868125',
                                                                                                                        'fiber_length': 14844,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '20',
                                                                                               'poller_hash': 'NjVGOUNCcGVlcnBvbnBvbiAyMA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 20',
                                         'poller_hash': 'NjVGOUNC',
                                         'serial_number': '65F9CB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4a:93',
                                         'uptime': '4868125'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0c:80:63:a0:0b:9d'],
                                                                       'id': '21/g1',
                                                                       'in_nucast_pkts': '2320407',
                                                                       'in_octets': '21268071688',
                                                                       'in_ucast_pkts': '73830715',
                                                                       'mac_address': '44:65:7f:bb:4a:c3',
                                                                       'mtu': 2000,
                                                                       'name': '21/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133014',
                                                                       'out_octets': '171842134106',
                                                                       'out_ucast_pkts': '136437981',
                                                                       'poller_hash': 'NjVGOURCcGVlcmludGYyMS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '21',
                                                                       'in_nucast_pkts': '1133014',
                                                                       'in_octets': '171842134106',
                                                                       'in_ucast_pkts': '136437981',
                                                                       'links': [       {       'in_nucast_pkts': '1133014',
                                                                                                'in_octets': '171842134106',
                                                                                                'in_ucast_pkts': '136437981',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '2320407',
                                                                                                'out_octets': '21268071688',
                                                                                                'out_ucast_pkts': '73830715',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 21',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2320407',
                                                                       'out_octets': '21268071688',
                                                                       'out_ucast_pkts': '73830715',
                                                                       'poller_hash': 'NjVGOURCcGVlcmludGZwb24gMjE=',
                                                                       'pons': [       {       'id': '21',
                                                                                               'links': [       {       'connected_time': '2187311',
                                                                                                                        'fiber_length': 8209,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '21',
                                                                                               'poller_hash': 'NjVGOURCcGVlcnBvbnBvbiAyMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 21',
                                         'poller_hash': 'NjVGOURC',
                                         'serial_number': '65F9DB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4a:c3',
                                         'uptime': '2187311'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd4:6a:91:77:55:27'],
                                                                       'id': '22/g1',
                                                                       'in_nucast_pkts': '153046',
                                                                       'in_octets': '143485571958',
                                                                       'in_ucast_pkts': '270527333',
                                                                       'mac_address': '44:65:7f:bb:4b:17',
                                                                       'mtu': 2000,
                                                                       'name': '22/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '5518678',
                                                                       'out_octets': '408767146846',
                                                                       'out_ucast_pkts': '412665246',
                                                                       'poller_hash': 'NjVGOUY3cGVlcmludGYyMi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '22',
                                                                       'in_nucast_pkts': '5518678',
                                                                       'in_octets': '408767146846',
                                                                       'in_ucast_pkts': '412665246',
                                                                       'links': [       {       'in_nucast_pkts': '5518678',
                                                                                                'in_octets': '408767146846',
                                                                                                'in_ucast_pkts': '412665246',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '153046',
                                                                                                'out_octets': '143485571958',
                                                                                                'out_ucast_pkts': '270527333',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 22',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '153046',
                                                                       'out_octets': '143485571958',
                                                                       'out_ucast_pkts': '270527333',
                                                                       'poller_hash': 'NjVGOUY3cGVlcmludGZwb24gMjI=',
                                                                       'pons': [       {       'id': '22',
                                                                                               'links': [       {       'connected_time': '10548759',
                                                                                                                        'fiber_length': 9281,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '22',
                                                                                               'poller_hash': 'NjVGOUY3cGVlcnBvbnBvbiAyMg==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 22',
                                         'poller_hash': 'NjVGOUY3',
                                         'serial_number': '65F9F7',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4b:17',
                                         'uptime': '10548759'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '2c:b8:ed:41:e9:c9'],
                                                                       'id': '23/g1',
                                                                       'in_nucast_pkts': '16923',
                                                                       'in_octets': '400218288096',
                                                                       'in_ucast_pkts': '1860422808',
                                                                       'mac_address': '44:65:7f:bb:49:a0',
                                                                       'mtu': 2000,
                                                                       'name': '23/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '3542911',
                                                                       'out_octets': '7501061406012',
                                                                       'out_ucast_pkts': '5350556622',
                                                                       'poller_hash': 'NjVGOTdBcGVlcmludGYyMy9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '23',
                                                                       'in_nucast_pkts': '3542911',
                                                                       'in_octets': '7501061406012',
                                                                       'in_ucast_pkts': '5350556622',
                                                                       'links': [       {       'in_nucast_pkts': '3542911',
                                                                                                'in_octets': '7501061406012',
                                                                                                'in_ucast_pkts': '5350556622',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '16923',
                                                                                                'out_octets': '400218288096',
                                                                                                'out_ucast_pkts': '1860422808',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 23',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '16923',
                                                                       'out_octets': '400218288096',
                                                                       'out_ucast_pkts': '1860422808',
                                                                       'poller_hash': 'NjVGOTdBcGVlcmludGZwb24gMjM=',
                                                                       'pons': [       {       'id': '23',
                                                                                               'links': [       {       'connected_time': '6814891',
                                                                                                                        'fiber_length': 9226,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '23',
                                                                                               'poller_hash': 'NjVGOTdBcGVlcnBvbnBvbiAyMw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 23',
                                         'poller_hash': 'NjVGOTdB',
                                         'serial_number': '65F97A',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:49:a0',
                                         'uptime': '6814891'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:30:44:2f:63:24'],
                                                                       'id': '24/g1',
                                                                       'in_nucast_pkts': '5',
                                                                       'in_octets': '2737313463',
                                                                       'in_ucast_pkts': '7054539',
                                                                       'mac_address': '44:65:7f:bb:4a:48',
                                                                       'mtu': 2000,
                                                                       'name': '24/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133074',
                                                                       'out_octets': '3534931892',
                                                                       'out_ucast_pkts': '6920957',
                                                                       'poller_hash': 'NjVGOUIycGVlcmludGYyNC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '24',
                                                                       'in_nucast_pkts': '1133074',
                                                                       'in_octets': '3534931892',
                                                                       'in_ucast_pkts': '6920957',
                                                                       'links': [       {       'in_nucast_pkts': '1133074',
                                                                                                'in_octets': '3534931892',
                                                                                                'in_ucast_pkts': '6920957',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '5',
                                                                                                'out_octets': '2737313463',
                                                                                                'out_ucast_pkts': '7054539',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 24',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '5',
                                                                       'out_octets': '2737313463',
                                                                       'out_ucast_pkts': '7054539',
                                                                       'poller_hash': 'NjVGOUIycGVlcmludGZwb24gMjQ=',
                                                                       'pons': [       {       'id': '24',
                                                                                               'links': [       {       'connected_time': '2187300',
                                                                                                                        'fiber_length': 2896,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '24',
                                                                                               'poller_hash': 'NjVGOUIycGVlcnBvbnBvbiAyNA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 24',
                                         'poller_hash': 'NjVGOUIy',
                                         'serial_number': '65F9B2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4a:48',
                                         'uptime': '2187300'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '18:b1:69:bf:8c:2d'],
                                                                       'id': '25/g1',
                                                                       'in_nucast_pkts': '909',
                                                                       'in_octets': '11713464589',
                                                                       'in_ucast_pkts': '29364792',
                                                                       'mac_address': '84:d3:43:9f:34:6b',
                                                                       'mtu': 2000,
                                                                       'name': '25/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133100',
                                                                       'out_octets': '71465681197',
                                                                       'out_ucast_pkts': '67354686',
                                                                       'poller_hash': 'RDlDNTYxcGVlcmludGYyNS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '25',
                                                                       'in_nucast_pkts': '1133100',
                                                                       'in_octets': '71465681197',
                                                                       'in_ucast_pkts': '67354686',
                                                                       'links': [       {       'in_nucast_pkts': '1133100',
                                                                                                'in_octets': '71465681197',
                                                                                                'in_ucast_pkts': '67354686',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '909',
                                                                                                'out_octets': '11713464589',
                                                                                                'out_ucast_pkts': '29364792',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 25',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '909',
                                                                       'out_octets': '11713464589',
                                                                       'out_ucast_pkts': '29364792',
                                                                       'poller_hash': 'RDlDNTYxcGVlcmludGZwb24gMjU=',
                                                                       'pons': [       {       'id': '25',
                                                                                               'links': [       {       'connected_time': '2187310',
                                                                                                                        'fiber_length': 5296,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '25',
                                                                                               'poller_hash': 'RDlDNTYxcGVlcnBvbnBvbiAyNQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 25',
                                         'poller_hash': 'RDlDNTYx',
                                         'serial_number': 'D9C561',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '84:d3:43:9f:34:6b',
                                         'uptime': '2187310'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd4:6a:91:b0:57:49'],
                                                                       'id': '26/g1',
                                                                       'in_nucast_pkts': '248',
                                                                       'in_octets': '43777761120',
                                                                       'in_ucast_pkts': '121674387',
                                                                       'mac_address': '44:65:7f:bb:4a:2a',
                                                                       'mtu': 2000,
                                                                       'name': '26/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133060',
                                                                       'out_octets': '226431071171',
                                                                       'out_ucast_pkts': '181931775',
                                                                       'poller_hash': 'NjVGOUE4cGVlcmludGYyNi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '26',
                                                                       'in_nucast_pkts': '1133060',
                                                                       'in_octets': '226431071171',
                                                                       'in_ucast_pkts': '181931775',
                                                                       'links': [       {       'in_nucast_pkts': '1133060',
                                                                                                'in_octets': '226431071171',
                                                                                                'in_ucast_pkts': '181931775',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '248',
                                                                                                'out_octets': '43777761120',
                                                                                                'out_ucast_pkts': '121674387',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 26',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '248',
                                                                       'out_octets': '43777761120',
                                                                       'out_ucast_pkts': '121674387',
                                                                       'poller_hash': 'NjVGOUE4cGVlcmludGZwb24gMjY=',
                                                                       'pons': [       {       'id': '26',
                                                                                               'links': [       {       'connected_time': '2187306',
                                                                                                                        'fiber_length': 9436,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '26',
                                                                                               'poller_hash': 'NjVGOUE4cGVlcnBvbnBvbiAyNg==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 26',
                                         'poller_hash': 'NjVGOUE4',
                                         'serial_number': '65F9A8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4a:2a',
                                         'uptime': '2187306'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f8:9e:28:7e:ad:76'],
                                                                       'id': '27/g1',
                                                                       'in_nucast_pkts': '1100146',
                                                                       'in_octets': '192452729514',
                                                                       'in_ucast_pkts': '1012809090',
                                                                       'mac_address': '44:65:7f:bb:49:e2',
                                                                       'mtu': 2000,
                                                                       'name': '27/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '8961986',
                                                                       'out_octets': '1122511628428',
                                                                       'out_ucast_pkts': '1404166036',
                                                                       'poller_hash': 'NjVGOTkwcGVlcmludGYyNy9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '27',
                                                                       'in_nucast_pkts': '8961986',
                                                                       'in_octets': '1122511628428',
                                                                       'in_ucast_pkts': '1404166036',
                                                                       'links': [       {       'in_nucast_pkts': '8961986',
                                                                                                'in_octets': '1122511628428',
                                                                                                'in_ucast_pkts': '1404166036',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '1100146',
                                                                                                'out_octets': '192452729514',
                                                                                                'out_ucast_pkts': '1012809090',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 27',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1100146',
                                                                       'out_octets': '192452729514',
                                                                       'out_ucast_pkts': '1012809090',
                                                                       'poller_hash': 'NjVGOTkwcGVlcmludGZwb24gMjc=',
                                                                       'pons': [       {       'id': '27',
                                                                                               'links': [       {       'connected_time': '16749060',
                                                                                                                        'fiber_length': 2809,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '27',
                                                                                               'poller_hash': 'NjVGOTkwcGVlcnBvbnBvbiAyNw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 27',
                                         'poller_hash': 'NjVGOTkw',
                                         'serial_number': '65F990',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:49:e2',
                                         'uptime': '16749060'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '18:90:88:41:91:60'],
                                                                       'id': '28/g1',
                                                                       'in_nucast_pkts': '72903',
                                                                       'in_octets': '57158826193',
                                                                       'in_ucast_pkts': '62750285',
                                                                       'mac_address': '44:65:7f:bb:4a:a5',
                                                                       'mtu': 2000,
                                                                       'name': '28/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133060',
                                                                       'out_octets': '52044343917',
                                                                       'out_ucast_pkts': '58818296',
                                                                       'poller_hash': 'NjVGOUQxcGVlcmludGYyOC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '28',
                                                                       'in_nucast_pkts': '1133060',
                                                                       'in_octets': '52044343917',
                                                                       'in_ucast_pkts': '58818296',
                                                                       'links': [       {       'in_nucast_pkts': '1133060',
                                                                                                'in_octets': '52044343917',
                                                                                                'in_ucast_pkts': '58818296',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '72903',
                                                                                                'out_octets': '57158826193',
                                                                                                'out_ucast_pkts': '62750285',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 28',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '72903',
                                                                       'out_octets': '57158826193',
                                                                       'out_ucast_pkts': '62750285',
                                                                       'poller_hash': 'NjVGOUQxcGVlcmludGZwb24gMjg=',
                                                                       'pons': [       {       'id': '28',
                                                                                               'links': [       {       'connected_time': '2187286',
                                                                                                                        'fiber_length': 15610,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '28',
                                                                                               'poller_hash': 'NjVGOUQxcGVlcnBvbnBvbiAyOA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 28',
                                         'poller_hash': 'NjVGOUQx',
                                         'serial_number': '65F9D1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4a:a5',
                                         'uptime': '2187286'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '90:a7:c1:97:7f:4a'],
                                                                       'id': '29/g1',
                                                                       'in_nucast_pkts': '23456',
                                                                       'in_octets': '265604438022',
                                                                       'in_ucast_pkts': '663794915',
                                                                       'mac_address': '44:65:7f:bb:4a:06',
                                                                       'mtu': 2000,
                                                                       'name': '29/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '5518850',
                                                                       'out_octets': '1545996695471',
                                                                       'out_ucast_pkts': '1261360682',
                                                                       'poller_hash': 'NjVGOTlDcGVlcmludGYyOS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '29',
                                                                       'in_nucast_pkts': '5518850',
                                                                       'in_octets': '1545996695471',
                                                                       'in_ucast_pkts': '1261360682',
                                                                       'links': [       {       'in_nucast_pkts': '5518850',
                                                                                                'in_octets': '1545996695471',
                                                                                                'in_ucast_pkts': '1261360682',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '23456',
                                                                                                'out_octets': '265604438022',
                                                                                                'out_ucast_pkts': '663794915',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 29',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '23456',
                                                                       'out_octets': '265604438022',
                                                                       'out_ucast_pkts': '663794915',
                                                                       'poller_hash': 'NjVGOTlDcGVlcmludGZwb24gMjk=',
                                                                       'pons': [       {       'id': '29',
                                                                                               'links': [       {       'connected_time': '10548707',
                                                                                                                        'fiber_length': 16098,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '29',
                                                                                               'poller_hash': 'NjVGOTlDcGVlcnBvbnBvbiAyOQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 29',
                                         'poller_hash': 'NjVGOTlD',
                                         'serial_number': '65F99C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:4a:06',
                                         'uptime': '10548707'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '98:18:88:cd:a1:14'],
                                                                       'id': '30/g1',
                                                                       'in_nucast_pkts': '1326988',
                                                                       'in_octets': '2415884519871',
                                                                       'in_ucast_pkts': '2963042639',
                                                                       'mac_address': '44:65:7f:bb:3d:88',
                                                                       'mtu': 2000,
                                                                       'name': '30/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '10853116',
                                                                       'out_octets': '1694694587113',
                                                                       'out_ucast_pkts': '2094419729',
                                                                       'poller_hash': 'NjVGNTcycGVlcmludGYzMC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '30',
                                                                       'in_nucast_pkts': '10853116',
                                                                       'in_octets': '1694694587113',
                                                                       'in_ucast_pkts': '2094419729',
                                                                       'links': [       {       'in_nucast_pkts': '10853116',
                                                                                                'in_octets': '1694694587113',
                                                                                                'in_ucast_pkts': '2094419729',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '1326988',
                                                                                                'out_octets': '2415884519871',
                                                                                                'out_ucast_pkts': '2963042639',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 30',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1326988',
                                                                       'out_octets': '2415884519871',
                                                                       'out_ucast_pkts': '2963042639',
                                                                       'poller_hash': 'NjVGNTcycGVlcmludGZwb24gMzA=',
                                                                       'pons': [       {       'id': '30',
                                                                                               'links': [       {       'connected_time': '20205601',
                                                                                                                        'fiber_length': 14808,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '30',
                                                                                               'poller_hash': 'NjVGNTcycGVlcnBvbnBvbiAzMA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 30',
                                         'poller_hash': 'NjVGNTcy',
                                         'serial_number': '65F572',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '44:65:7f:bb:3d:88',
                                         'uptime': '20205601'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:1b:17:00:21:17'],
                                                                       'id': '31/g1',
                                                                       'in_nucast_pkts': '407956',
                                                                       'in_octets': '1221510266311',
                                                                       'in_ucast_pkts': '1902168430',
                                                                       'mac_address': '48:77:46:1d:47:ba',
                                                                       'mtu': 1496,
                                                                       'name': '31/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '4201226',
                                                                       'out_octets': '2666271319266',
                                                                       'out_ucast_pkts': '2758555872',
                                                                       'poller_hash': 'NkZERTAwcGVlcmludGYzMS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '31/g2',
                                                                       'mac_address': '48:77:46:1d:47:bb',
                                                                       'name': '31/g2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NkZERTAwcGVlcmludGYzMS9nMg=='},
                                                               {       'admin_up': True,
                                                                       'id': '31/g3',
                                                                       'mac_address': '48:77:46:1d:47:bc',
                                                                       'name': '31/g3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NkZERTAwcGVlcmludGYzMS9nMw=='},
                                                               {       'admin_up': True,
                                                                       'id': '31/g4',
                                                                       'mac_address': '48:77:46:1d:47:bd',
                                                                       'name': '31/g4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NkZERTAwcGVlcmludGYzMS9nNA=='},
                                                               {       'admin_up': True,
                                                                       'id': '31',
                                                                       'in_nucast_pkts': '4201226',
                                                                       'in_octets': '2666271319266',
                                                                       'in_ucast_pkts': '2758555872',
                                                                       'links': [       {       'in_nucast_pkts': '4201226',
                                                                                                'in_octets': '2666271319266',
                                                                                                'in_ucast_pkts': '2758555872',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '407956',
                                                                                                'out_octets': '1221510266311',
                                                                                                'out_ucast_pkts': '1902168430',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 31',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '407956',
                                                                       'out_octets': '1221510266311',
                                                                       'out_ucast_pkts': '1902168430',
                                                                       'poller_hash': 'NkZERTAwcGVlcmludGZwb24gMzE=',
                                                                       'pons': [       {       'id': '31',
                                                                                               'links': [       {       'connected_time': '3758742',
                                                                                                                        'fiber_length': 5404,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '31',
                                                                                               'poller_hash': 'NkZERTAwcGVlcnBvbnBvbiAzMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '844G-1',
                                         'name': 'ont 31',
                                         'poller_hash': 'NkZERTAw',
                                         'serial_number': '6FDE00',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '11.2.6.10.2',
                                         'system_mac_address': '48:77:46:1d:47:b7',
                                         'uptime': '3758742'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '32/g1',
                                                                       'mtu': 0,
                                                                       'name': '32/g1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'NzU0QTFCcGVlcmludGYzMi9nMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': '32/g2',
                                                                       'mtu': 0,
                                                                       'name': '32/g2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'NzU0QTFCcGVlcmludGYzMi9nMg=='},
                                                               {       'admin_up': True,
                                                                       'id': '32/g3',
                                                                       'mtu': 0,
                                                                       'name': '32/g3',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'NzU0QTFCcGVlcmludGYzMi9nMw=='},
                                                               {       'admin_up': True,
                                                                       'id': '32/g4',
                                                                       'mtu': 0,
                                                                       'name': '32/g4',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'NzU0QTFCcGVlcmludGYzMi9nNA=='},
                                                               {       'admin_up': True,
                                                                       'id': '32',
                                                                       'name': 'pon 32',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NzU0QTFCcGVlcmludGZwb24gMzI='}],
                                         'name': 'ont 32',
                                         'poller_hash': 'NzU0QTFC',
                                         'serial_number': '754A1B',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '2c:b8:ed:70:f7:e9'],
                                                                       'id': '33/g1',
                                                                       'in_nucast_pkts': '1651299',
                                                                       'in_octets': '93838668249',
                                                                       'in_ucast_pkts': '177164788',
                                                                       'mac_address': '48:77:46:96:32:42',
                                                                       'mtu': 2000,
                                                                       'name': '33/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133232',
                                                                       'out_octets': '458971098167',
                                                                       'out_ucast_pkts': '393313856',
                                                                       'poller_hash': 'NzcwNUYzcGVlcmludGYzMy9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '33',
                                                                       'in_nucast_pkts': '1133232',
                                                                       'in_octets': '458971098167',
                                                                       'in_ucast_pkts': '393313856',
                                                                       'links': [       {       'in_nucast_pkts': '1133232',
                                                                                                'in_octets': '458971098167',
                                                                                                'in_ucast_pkts': '393313856',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '1651299',
                                                                                                'out_octets': '93838668249',
                                                                                                'out_ucast_pkts': '177164788',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 33',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1651299',
                                                                       'out_octets': '93838668249',
                                                                       'out_ucast_pkts': '177164788',
                                                                       'poller_hash': 'NzcwNUYzcGVlcmludGZwb24gMzM=',
                                                                       'pons': [       {       'id': '33',
                                                                                               'links': [       {       'connected_time': '2187325',
                                                                                                                        'fiber_length': 4245,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '33',
                                                                                               'poller_hash': 'NzcwNUYzcGVlcnBvbnBvbiAzMw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 33',
                                         'poller_hash': 'NzcwNUYz',
                                         'serial_number': '7705F3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '48:77:46:96:32:42',
                                         'uptime': '2187325'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '98:ed:7e:0f:db:81'],
                                                                       'id': '34/g1',
                                                                       'in_nucast_pkts': '91140',
                                                                       'in_octets': '4102186531',
                                                                       'in_ucast_pkts': '13492335',
                                                                       'mac_address': '48:77:46:96:36:c5',
                                                                       'mtu': 2000,
                                                                       'name': '34/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133075',
                                                                       'out_octets': '8493386630',
                                                                       'out_ucast_pkts': '13938723',
                                                                       'poller_hash': 'NzcwNzc0cGVlcmludGYzNC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '34',
                                                                       'in_nucast_pkts': '1133075',
                                                                       'in_octets': '8493386630',
                                                                       'in_ucast_pkts': '13938723',
                                                                       'links': [       {       'in_nucast_pkts': '1133075',
                                                                                                'in_octets': '8493386630',
                                                                                                'in_ucast_pkts': '13938723',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '91140',
                                                                                                'out_octets': '4102186531',
                                                                                                'out_ucast_pkts': '13492335',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 34',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '91140',
                                                                       'out_octets': '4102186531',
                                                                       'out_ucast_pkts': '13492335',
                                                                       'poller_hash': 'NzcwNzc0cGVlcmludGZwb24gMzQ=',
                                                                       'pons': [       {       'id': '34',
                                                                                               'links': [       {       'connected_time': '2187325',
                                                                                                                        'fiber_length': 6766,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '34',
                                                                                               'poller_hash': 'NzcwNzc0cGVlcnBvbnBvbiAzNA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 34',
                                         'poller_hash': 'NzcwNzc0',
                                         'serial_number': '770774',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '48:77:46:96:36:c5',
                                         'uptime': '2187325'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:59:3f:75'],
                                                                       'id': '35/g1',
                                                                       'in_nucast_pkts': '142992',
                                                                       'in_octets': '509658800222',
                                                                       'in_ucast_pkts': '2306434980',
                                                                       'mac_address': '48:77:46:96:39:50',
                                                                       'mtu': 2000,
                                                                       'name': '35/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '8178228',
                                                                       'out_octets': '7314319364072',
                                                                       'out_ucast_pkts': '5233644364',
                                                                       'poller_hash': 'NzcwODREcGVlcmludGYzNS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '35',
                                                                       'in_nucast_pkts': '8178228',
                                                                       'in_octets': '7314319364072',
                                                                       'in_ucast_pkts': '5233644364',
                                                                       'links': [       {       'in_nucast_pkts': '8178228',
                                                                                                'in_octets': '7314319364072',
                                                                                                'in_ucast_pkts': '5233644364',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '142992',
                                                                                                'out_octets': '509658800222',
                                                                                                'out_ucast_pkts': '2306434980',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 35',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '142992',
                                                                       'out_octets': '509658800222',
                                                                       'out_ucast_pkts': '2306434980',
                                                                       'poller_hash': 'NzcwODREcGVlcmludGZwb24gMzU=',
                                                                       'pons': [       {       'id': '35',
                                                                                               'links': [       {       'connected_time': '15231401',
                                                                                                                        'fiber_length': 12247,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '35',
                                                                                               'poller_hash': 'NzcwODREcGVlcnBvbnBvbiAzNQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 35',
                                         'poller_hash': 'NzcwODRE',
                                         'serial_number': '77084D',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '48:77:46:96:39:50',
                                         'uptime': '15231401'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'ac:8b:a9:11:24:15'],
                                                                       'id': '36/g1',
                                                                       'in_nucast_pkts': '13555010',
                                                                       'in_octets': '296418060164',
                                                                       'in_ucast_pkts': '705040830',
                                                                       'mac_address': '84:d3:43:9f:33:5a',
                                                                       'mtu': 2000,
                                                                       'name': '36/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '5519036',
                                                                       'out_octets': '906858338071',
                                                                       'out_ucast_pkts': '979473102',
                                                                       'poller_hash': 'RDlDNTA2cGVlcmludGYzNi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '36',
                                                                       'in_nucast_pkts': '5519036',
                                                                       'in_octets': '906858338071',
                                                                       'in_ucast_pkts': '979473102',
                                                                       'links': [       {       'in_nucast_pkts': '5519036',
                                                                                                'in_octets': '906858338071',
                                                                                                'in_ucast_pkts': '979473102',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '13555010',
                                                                                                'out_octets': '296418060164',
                                                                                                'out_ucast_pkts': '705040830',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 36',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '13555010',
                                                                       'out_octets': '296418060164',
                                                                       'out_ucast_pkts': '705040830',
                                                                       'poller_hash': 'RDlDNTA2cGVlcmludGZwb24gMzY=',
                                                                       'pons': [       {       'id': '36',
                                                                                               'links': [       {       'connected_time': '10548846',
                                                                                                                        'fiber_length': 5867,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '36',
                                                                                               'poller_hash': 'RDlDNTA2cGVlcnBvbnBvbiAzNg==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 36',
                                         'poller_hash': 'RDlDNTA2',
                                         'serial_number': 'D9C506',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '84:d3:43:9f:33:5a',
                                         'uptime': '10548846'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd4:6a:91:b0:ce:45'],
                                                                       'id': '37/g1',
                                                                       'in_nucast_pkts': '473',
                                                                       'in_octets': '17196202418',
                                                                       'in_ucast_pkts': '22035717',
                                                                       'mac_address': '48:77:46:96:37:70',
                                                                       'mtu': 2000,
                                                                       'name': '37/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133180',
                                                                       'out_octets': '2808141278',
                                                                       'out_ucast_pkts': '15033973',
                                                                       'poller_hash': 'NzcwN0FEcGVlcmludGYzNy9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '37',
                                                                       'in_nucast_pkts': '1133180',
                                                                       'in_octets': '2808141278',
                                                                       'in_ucast_pkts': '15033973',
                                                                       'links': [       {       'in_nucast_pkts': '1133180',
                                                                                                'in_octets': '2808141278',
                                                                                                'in_ucast_pkts': '15033973',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '473',
                                                                                                'out_octets': '17196202418',
                                                                                                'out_ucast_pkts': '22035717',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 37',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '473',
                                                                       'out_octets': '17196202418',
                                                                       'out_ucast_pkts': '22035717',
                                                                       'poller_hash': 'NzcwN0FEcGVlcmludGZwb24gMzc=',
                                                                       'pons': [       {       'id': '37',
                                                                                               'links': [       {       'connected_time': '2187316',
                                                                                                                        'fiber_length': 9557,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '37',
                                                                                               'poller_hash': 'NzcwN0FEcGVlcnBvbnBvbiAzNw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 37',
                                         'poller_hash': 'NzcwN0FE',
                                         'serial_number': '7707AD',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '48:77:46:96:37:70',
                                         'uptime': '2187316'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '38/g1',
                                                                       'mtu': 0,
                                                                       'name': '38/g1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'PG5vbmU+cGVlcmludGYzOC9nMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': '38',
                                                                       'name': 'pon 38',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'PG5vbmU+cGVlcmludGZwb24gMzg='}],
                                         'name': 'ont 38',
                                         'poller_hash': 'PG5vbmU+',
                                         'serial_number': '<none>',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f8:bc:0e:3d:e5:01'],
                                                                       'id': '39/g1',
                                                                       'in_nucast_pkts': '91130',
                                                                       'in_octets': '24817670168',
                                                                       'in_ucast_pkts': '47105905',
                                                                       'mac_address': '48:77:46:96:37:8e',
                                                                       'mtu': 2000,
                                                                       'name': '39/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133087',
                                                                       'out_octets': '21547513175',
                                                                       'out_ucast_pkts': '44109768',
                                                                       'poller_hash': 'NzcwN0I3cGVlcmludGYzOS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '39',
                                                                       'in_nucast_pkts': '1133087',
                                                                       'in_octets': '21547513175',
                                                                       'in_ucast_pkts': '44109768',
                                                                       'links': [       {       'in_nucast_pkts': '1133087',
                                                                                                'in_octets': '21547513175',
                                                                                                'in_ucast_pkts': '44109768',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '91130',
                                                                                                'out_octets': '24817670168',
                                                                                                'out_ucast_pkts': '47105905',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 39',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '91130',
                                                                       'out_octets': '24817670168',
                                                                       'out_ucast_pkts': '47105905',
                                                                       'poller_hash': 'NzcwN0I3cGVlcmludGZwb24gMzk=',
                                                                       'pons': [       {       'id': '39',
                                                                                               'links': [       {       'connected_time': '2187309',
                                                                                                                        'fiber_length': 9623,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '39',
                                                                                               'poller_hash': 'NzcwN0I3cGVlcnBvbnBvbiAzOQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 39',
                                         'poller_hash': 'NzcwN0I3',
                                         'serial_number': '7707B7',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '48:77:46:96:37:8e',
                                         'uptime': '2187309'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd4:6a:91:b8:50:d5'],
                                                                       'id': '40/g1',
                                                                       'in_nucast_pkts': '42249',
                                                                       'in_octets': '164927143321',
                                                                       'in_ucast_pkts': '251460406',
                                                                       'mac_address': '48:77:46:96:38:b1',
                                                                       'mtu': 2000,
                                                                       'name': '40/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1135918',
                                                                       'out_octets': '370736254670',
                                                                       'out_ucast_pkts': '357493456',
                                                                       'poller_hash': 'NzcwODE4cGVlcmludGY0MC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '40',
                                                                       'in_nucast_pkts': '1135918',
                                                                       'in_octets': '370736254670',
                                                                       'in_ucast_pkts': '357493456',
                                                                       'links': [       {       'in_nucast_pkts': '1135918',
                                                                                                'in_octets': '370736254670',
                                                                                                'in_ucast_pkts': '357493456',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '42249',
                                                                                                'out_octets': '164927143321',
                                                                                                'out_ucast_pkts': '251460406',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 40',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '42249',
                                                                       'out_octets': '164927143321',
                                                                       'out_ucast_pkts': '251460406',
                                                                       'poller_hash': 'NzcwODE4cGVlcmludGZwb24gNDA=',
                                                                       'pons': [       {       'id': '40',
                                                                                               'links': [       {       'connected_time': '2189127',
                                                                                                                        'fiber_length': 10628,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '40',
                                                                                               'poller_hash': 'NzcwODE4cGVlcnBvbnBvbiA0MA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 40',
                                         'poller_hash': 'NzcwODE4',
                                         'serial_number': '770818',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '48:77:46:96:38:b1',
                                         'uptime': '2189127'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:2e:23:92'],
                                                                       'id': '41/g1',
                                                                       'in_nucast_pkts': '18274',
                                                                       'in_octets': '48844911950',
                                                                       'in_ucast_pkts': '183919036',
                                                                       'mac_address': 'd0:76:8f:20:ed:e8',
                                                                       'mtu': 2000,
                                                                       'name': '41/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133062',
                                                                       'out_octets': '275605480279',
                                                                       'out_ucast_pkts': '222478954',
                                                                       'poller_hash': 'ODdFOEY5cGVlcmludGY0MS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '41',
                                                                       'in_nucast_pkts': '1133062',
                                                                       'in_octets': '275605480279',
                                                                       'in_ucast_pkts': '222478954',
                                                                       'links': [       {       'in_nucast_pkts': '1133062',
                                                                                                'in_octets': '275605480279',
                                                                                                'in_ucast_pkts': '222478954',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '18274',
                                                                                                'out_octets': '48844911950',
                                                                                                'out_ucast_pkts': '183919036',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 41',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '18274',
                                                                       'out_octets': '48844911950',
                                                                       'out_ucast_pkts': '183919036',
                                                                       'poller_hash': 'ODdFOEY5cGVlcmludGZwb24gNDE=',
                                                                       'pons': [       {       'id': '41',
                                                                                               'links': [       {       'connected_time': '2187321',
                                                                                                                        'fiber_length': 9349,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '41',
                                                                                               'poller_hash': 'ODdFOEY5cGVlcnBvbnBvbiA0MQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 41',
                                         'poller_hash': 'ODdFOEY5',
                                         'serial_number': '87E8F9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'd0:76:8f:20:ed:e8',
                                         'uptime': '2187321'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '44:65:7f:5d:b8:7d'],
                                                                       'id': '42/g1',
                                                                       'in_nucast_pkts': '10',
                                                                       'in_octets': '28353529388',
                                                                       'in_ucast_pkts': '64702932',
                                                                       'mac_address': 'd0:76:8f:20:ed:43',
                                                                       'mtu': 2000,
                                                                       'name': '42/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133072',
                                                                       'out_octets': '98506262240',
                                                                       'out_ucast_pkts': '94861576',
                                                                       'poller_hash': 'ODdFOEMycGVlcmludGY0Mi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '42',
                                                                       'in_nucast_pkts': '1133072',
                                                                       'in_octets': '98506262240',
                                                                       'in_ucast_pkts': '94861576',
                                                                       'links': [       {       'in_nucast_pkts': '1133072',
                                                                                                'in_octets': '98506262240',
                                                                                                'in_ucast_pkts': '94861576',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '10',
                                                                                                'out_octets': '28353529388',
                                                                                                'out_ucast_pkts': '64702932',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 42',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '10',
                                                                       'out_octets': '28353529388',
                                                                       'out_ucast_pkts': '64702932',
                                                                       'poller_hash': 'ODdFOEMycGVlcmludGZwb24gNDI=',
                                                                       'pons': [       {       'id': '42',
                                                                                               'links': [       {       'connected_time': '2187332',
                                                                                                                        'fiber_length': 9326,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '42',
                                                                                               'poller_hash': 'ODdFOEMycGVlcnBvbnBvbiA0Mg==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 42',
                                         'poller_hash': 'ODdFOEMy',
                                         'serial_number': '87E8C2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'd0:76:8f:20:ed:43',
                                         'uptime': '2187332'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e0:cb:bc:23:e6:80'],
                                                                       'id': '43/g1',
                                                                       'in_nucast_pkts': '695241',
                                                                       'in_octets': '59031269008',
                                                                       'in_ucast_pkts': '308924851',
                                                                       'mac_address': 'd0:76:8f:20:eb:ba',
                                                                       'mtu': 2000,
                                                                       'name': '43/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '5518931',
                                                                       'out_octets': '153308866060',
                                                                       'out_ucast_pkts': '350439981',
                                                                       'poller_hash': 'ODdFODNGcGVlcmludGY0My9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '43',
                                                                       'in_nucast_pkts': '5518931',
                                                                       'in_octets': '153308866060',
                                                                       'in_ucast_pkts': '350439981',
                                                                       'links': [       {       'in_nucast_pkts': '5518931',
                                                                                                'in_octets': '153308866060',
                                                                                                'in_ucast_pkts': '350439981',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '695241',
                                                                                                'out_octets': '59031269008',
                                                                                                'out_ucast_pkts': '308924851',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 43',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '695241',
                                                                       'out_octets': '59031269008',
                                                                       'out_ucast_pkts': '308924851',
                                                                       'poller_hash': 'ODdFODNGcGVlcmludGZwb24gNDM=',
                                                                       'pons': [       {       'id': '43',
                                                                                               'links': [       {       'connected_time': '10548868',
                                                                                                                        'fiber_length': 16245,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '43',
                                                                                               'poller_hash': 'ODdFODNGcGVlcnBvbnBvbiA0Mw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 43',
                                         'poller_hash': 'ODdFODNG',
                                         'serial_number': '87E83F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'd0:76:8f:20:eb:ba',
                                         'uptime': '10548868'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:47:4c:84'],
                                                                       'id': '44/g1',
                                                                       'in_nucast_pkts': '20098',
                                                                       'in_octets': '334267541034',
                                                                       'in_ucast_pkts': '364046805',
                                                                       'mac_address': 'd0:76:8f:20:ed:3d',
                                                                       'mtu': 2000,
                                                                       'name': '44/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133065',
                                                                       'out_octets': '199897727129',
                                                                       'out_ucast_pkts': '332981704',
                                                                       'poller_hash': 'ODdFOEMwcGVlcmludGY0NC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '44',
                                                                       'in_nucast_pkts': '1133065',
                                                                       'in_octets': '199897727129',
                                                                       'in_ucast_pkts': '332981704',
                                                                       'links': [       {       'in_nucast_pkts': '1133065',
                                                                                                'in_octets': '199897727129',
                                                                                                'in_ucast_pkts': '332981704',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '20098',
                                                                                                'out_octets': '334267541034',
                                                                                                'out_ucast_pkts': '364046805',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 44',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '20098',
                                                                       'out_octets': '334267541034',
                                                                       'out_ucast_pkts': '364046805',
                                                                       'poller_hash': 'ODdFOEMwcGVlcmludGZwb24gNDQ=',
                                                                       'pons': [       {       'id': '44',
                                                                                               'links': [       {       'connected_time': '2187332',
                                                                                                                        'fiber_length': 16415,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '44',
                                                                                               'poller_hash': 'ODdFOEMwcGVlcnBvbnBvbiA0NA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 44',
                                         'poller_hash': 'ODdFOEMw',
                                         'serial_number': '87E8C0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'd0:76:8f:20:ed:3d',
                                         'uptime': '2187332'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f0:1d:2d:28:03:1a'],
                                                                       'id': '45/g1',
                                                                       'in_nucast_pkts': '18221',
                                                                       'in_octets': '47071000308',
                                                                       'in_ucast_pkts': '74306327',
                                                                       'mac_address': 'd0:76:8f:20:ed:f1',
                                                                       'mtu': 2000,
                                                                       'name': '45/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133064',
                                                                       'out_octets': '128292175655',
                                                                       'out_ucast_pkts': '116860106',
                                                                       'poller_hash': 'ODdFOEZDcGVlcmludGY0NS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '45',
                                                                       'in_nucast_pkts': '1133064',
                                                                       'in_octets': '128292175655',
                                                                       'in_ucast_pkts': '116860106',
                                                                       'links': [       {       'in_nucast_pkts': '1133064',
                                                                                                'in_octets': '128292175655',
                                                                                                'in_ucast_pkts': '116860106',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '18221',
                                                                                                'out_octets': '47071000308',
                                                                                                'out_ucast_pkts': '74306327',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 45',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '18221',
                                                                       'out_octets': '47071000308',
                                                                       'out_ucast_pkts': '74306327',
                                                                       'poller_hash': 'ODdFOEZDcGVlcmludGZwb24gNDU=',
                                                                       'pons': [       {       'id': '45',
                                                                                               'links': [       {       'connected_time': '2187338',
                                                                                                                        'fiber_length': 5675,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '45',
                                                                                               'poller_hash': 'ODdFOEZDcGVlcnBvbnBvbiA0NQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 45',
                                         'poller_hash': 'ODdFOEZD',
                                         'serial_number': '87E8FC',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'd0:76:8f:20:ed:f1',
                                         'uptime': '2187338'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'a4:13:4e:b2:d7:89'],
                                                                       'id': '46/g1',
                                                                       'in_nucast_pkts': '27',
                                                                       'in_octets': '15450352542',
                                                                       'in_ucast_pkts': '55526928',
                                                                       'mac_address': 'd0:76:8f:20:e1:df',
                                                                       'mtu': 2000,
                                                                       'name': '46/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133068',
                                                                       'out_octets': '127263228235',
                                                                       'out_ucast_pkts': '106607052',
                                                                       'poller_hash': 'ODdFNEY2cGVlcmludGY0Ni9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '46',
                                                                       'in_nucast_pkts': '1133068',
                                                                       'in_octets': '127263228235',
                                                                       'in_ucast_pkts': '106607052',
                                                                       'links': [       {       'in_nucast_pkts': '1133068',
                                                                                                'in_octets': '127263228235',
                                                                                                'in_ucast_pkts': '106607052',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '27',
                                                                                                'out_octets': '15450352542',
                                                                                                'out_ucast_pkts': '55526928',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 46',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '27',
                                                                       'out_octets': '15450352542',
                                                                       'out_ucast_pkts': '55526928',
                                                                       'poller_hash': 'ODdFNEY2cGVlcmludGZwb24gNDY=',
                                                                       'pons': [       {       'id': '46',
                                                                                               'links': [       {       'connected_time': '2187318',
                                                                                                                        'fiber_length': 1210,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '46',
                                                                                               'poller_hash': 'ODdFNEY2cGVlcnBvbnBvbiA0Ng==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 46',
                                         'poller_hash': 'ODdFNEY2',
                                         'serial_number': '87E4F6',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'd0:76:8f:20:e1:df',
                                         'uptime': '2187318'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:43:cb:26'],
                                                                       'id': '47/g1',
                                                                       'in_nucast_pkts': '19712',
                                                                       'in_octets': '21830599722',
                                                                       'in_ucast_pkts': '45257907',
                                                                       'mac_address': 'd0:76:8f:20:ed:9d',
                                                                       'mtu': 2000,
                                                                       'name': '47/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133058',
                                                                       'out_octets': '85480137767',
                                                                       'out_ucast_pkts': '79941818',
                                                                       'poller_hash': 'ODdFOEUwcGVlcmludGY0Ny9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '47',
                                                                       'in_nucast_pkts': '1133058',
                                                                       'in_octets': '85480137767',
                                                                       'in_ucast_pkts': '79941818',
                                                                       'links': [       {       'in_nucast_pkts': '1133058',
                                                                                                'in_octets': '85480137767',
                                                                                                'in_ucast_pkts': '79941818',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '19712',
                                                                                                'out_octets': '21830599722',
                                                                                                'out_ucast_pkts': '45257907',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 47',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '19712',
                                                                       'out_octets': '21830599722',
                                                                       'out_ucast_pkts': '45257907',
                                                                       'poller_hash': 'ODdFOEUwcGVlcmludGZwb24gNDc=',
                                                                       'pons': [       {       'id': '47',
                                                                                               'links': [       {       'connected_time': '2187318',
                                                                                                                        'fiber_length': 8768,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '47',
                                                                                               'poller_hash': 'ODdFOEUwcGVlcnBvbnBvbiA0Nw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 47',
                                         'poller_hash': 'ODdFOEUw',
                                         'serial_number': '87E8E0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'd0:76:8f:20:ed:9d',
                                         'uptime': '2187318'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:47:4b:c9'],
                                                                       'id': '48/g1',
                                                                       'in_nucast_pkts': '20119',
                                                                       'in_octets': '27492432608',
                                                                       'in_ucast_pkts': '70321202',
                                                                       'mac_address': 'd0:76:8f:20:ed:1f',
                                                                       'mtu': 2000,
                                                                       'name': '48/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133093',
                                                                       'out_octets': '213424053593',
                                                                       'out_ucast_pkts': '167785382',
                                                                       'poller_hash': 'ODdFOEI2cGVlcmludGY0OC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '48',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 48',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdFOEI2cGVlcmludGZwb24gNDg=',
                                                                       'pons': [       {       'id': '48',
                                                                                               'links': [       {       'connected_time': '2187369',
                                                                                                                        'fiber_length': 16892,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '48',
                                                                                               'poller_hash': 'ODdFOEI2cGVlcnBvbnBvbiA0OA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 48',
                                         'poller_hash': 'ODdFOEI2',
                                         'serial_number': '87E8B6',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'd0:76:8f:20:ed:1f',
                                         'uptime': '2187369'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '2c:3f:0b:cc:47:d5'],
                                                                       'id': '49/g1',
                                                                       'in_nucast_pkts': '18535',
                                                                       'in_octets': '12872761482',
                                                                       'in_ucast_pkts': '25551415',
                                                                       'mac_address': 'd0:76:8f:20:ed:8b',
                                                                       'mtu': 2000,
                                                                       'name': '49/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '145499',
                                                                       'out_octets': '51267773432',
                                                                       'out_ucast_pkts': '49236980',
                                                                       'poller_hash': 'ODdFOERBcGVlcmludGY0OS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '49',
                                                                       'in_nucast_pkts': '145499',
                                                                       'in_octets': '51267773432',
                                                                       'in_ucast_pkts': '49236980',
                                                                       'links': [       {       'in_nucast_pkts': '145499',
                                                                                                'in_octets': '51267773432',
                                                                                                'in_ucast_pkts': '49236980',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '18535',
                                                                                                'out_octets': '12872761482',
                                                                                                'out_ucast_pkts': '25551415',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 49',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '18535',
                                                                       'out_octets': '12872761482',
                                                                       'out_ucast_pkts': '25551415',
                                                                       'poller_hash': 'ODdFOERBcGVlcmludGZwb24gNDk=',
                                                                       'pons': [       {       'id': '49',
                                                                                               'links': [       {       'connected_time': '280816',
                                                                                                                        'fiber_length': 11463,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '49',
                                                                                               'poller_hash': 'ODdFOERBcGVlcnBvbnBvbiA0OQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 49',
                                         'poller_hash': 'ODdFOERB',
                                         'serial_number': '87E8DA',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': 'd0:76:8f:20:ed:8b',
                                         'uptime': '280816'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '50/g1',
                                                                       'in_nucast_pkts': '65',
                                                                       'in_octets': '24299832',
                                                                       'in_ucast_pkts': '283129',
                                                                       'mac_address': '48:77:46:81:3c:74',
                                                                       'mtu': 2000,
                                                                       'name': '50/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1470065',
                                                                       'out_octets': '174008963',
                                                                       'out_ucast_pkts': '285138',
                                                                       'poller_hash': 'NzU0QTEzcGVlcmludGY1MC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '50/g2',
                                                                       'mac_address': '48:77:46:81:3c:75',
                                                                       'name': '50/g2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NzU0QTEzcGVlcmludGY1MC9nMg=='},
                                                               {       'admin_up': True,
                                                                       'id': '50/g3',
                                                                       'mac_address': '48:77:46:81:3c:76',
                                                                       'name': '50/g3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NzU0QTEzcGVlcmludGY1MC9nMw=='},
                                                               {       'admin_up': True,
                                                                       'id': '50/g4',
                                                                       'mac_address': '48:77:46:81:3c:77',
                                                                       'name': '50/g4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NzU0QTEzcGVlcmludGY1MC9nNA=='},
                                                               {       'admin_up': True,
                                                                       'id': '50',
                                                                       'in_nucast_pkts': '1470065',
                                                                       'in_octets': '174008963',
                                                                       'in_ucast_pkts': '285138',
                                                                       'links': [       {       'in_nucast_pkts': '1470065',
                                                                                                'in_octets': '174008963',
                                                                                                'in_ucast_pkts': '285138',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '65',
                                                                                                'out_octets': '24299832',
                                                                                                'out_ucast_pkts': '283129',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzI='}],
                                                                       'name': 'pon 50',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '65',
                                                                       'out_octets': '24299832',
                                                                       'out_ucast_pkts': '283129',
                                                                       'poller_hash': 'NzU0QTEzcGVlcmludGZwb24gNTA=',
                                                                       'pons': [       {       'id': '50',
                                                                                               'links': [       {       'connected_time': '2187302',
                                                                                                                        'fiber_length': 9650,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzI=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '50',
                                                                                               'poller_hash': 'NzU0QTEzcGVlcnBvbnBvbiA1MA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '844G-1',
                                         'name': 'ont 50',
                                         'poller_hash': 'NzU0QTEz',
                                         'serial_number': '754A13',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': '48:77:46:81:3c:71',
                                         'uptime': '2187302'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '08:30:6b:37:63:31'],
                                                                       'id': '51/g1',
                                                                       'in_nucast_pkts': '2803911',
                                                                       'in_octets': '88885220656',
                                                                       'in_ucast_pkts': '376329088',
                                                                       'mac_address': '60:db:98:1d:68:42',
                                                                       'mtu': 2000,
                                                                       'name': '51/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '3250413',
                                                                       'out_octets': '1464460157576',
                                                                       'out_ucast_pkts': '1051686707',
                                                                       'poller_hash': 'QTFBQTEzcGVlcmludGY1MS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '51',
                                                                       'in_nucast_pkts': '3250413',
                                                                       'in_octets': '1464460157576',
                                                                       'in_ucast_pkts': '1051686707',
                                                                       'links': [       {       'in_nucast_pkts': '3250413',
                                                                                                'in_octets': '1464460157576',
                                                                                                'in_ucast_pkts': '1051686707',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '2803911',
                                                                                                'out_octets': '88885220656',
                                                                                                'out_ucast_pkts': '376329088',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 51',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '2803911',
                                                                       'out_octets': '88885220656',
                                                                       'out_ucast_pkts': '376329088',
                                                                       'poller_hash': 'QTFBQTEzcGVlcmludGZwb24gNTE=',
                                                                       'pons': [       {       'id': '51',
                                                                                               'links': [       {       'connected_time': '2186727',
                                                                                                                        'fiber_length': 17008,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '51',
                                                                                               'poller_hash': 'QTFBQTEzcGVlcnBvbnBvbiA1MQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 51',
                                         'poller_hash': 'QTFBQTEz',
                                         'serial_number': 'A1AA13',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '60:db:98:1d:68:42',
                                         'uptime': '2186727'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '90:a7:c1:ca:0a:0b'],
                                                                       'id': '52/g1',
                                                                       'in_nucast_pkts': '73',
                                                                       'in_octets': '9967560576',
                                                                       'in_ucast_pkts': '36052038',
                                                                       'mac_address': '60:db:98:1d:7b:ec',
                                                                       'mtu': 2000,
                                                                       'name': '52/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '731356',
                                                                       'out_octets': '166699532948',
                                                                       'out_ucast_pkts': '125305250',
                                                                       'poller_hash': 'QTFCMEExcGVlcmludGY1Mi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '52',
                                                                       'in_nucast_pkts': '731356',
                                                                       'in_octets': '166699532948',
                                                                       'in_ucast_pkts': '125305250',
                                                                       'links': [       {       'in_nucast_pkts': '731356',
                                                                                                'in_octets': '166699532948',
                                                                                                'in_ucast_pkts': '125305250',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '73',
                                                                                                'out_octets': '9967560576',
                                                                                                'out_ucast_pkts': '36052038',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 52',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '73',
                                                                       'out_octets': '9967560576',
                                                                       'out_ucast_pkts': '36052038',
                                                                       'poller_hash': 'QTFCMEExcGVlcmludGZwb24gNTI=',
                                                                       'pons': [       {       'id': '52',
                                                                                               'links': [       {       'connected_time': '1410644',
                                                                                                                        'fiber_length': 8865,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '52',
                                                                                               'poller_hash': 'QTFCMEExcGVlcnBvbnBvbiA1Mg==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 52',
                                         'poller_hash': 'QTFCMEEx',
                                         'serial_number': 'A1B0A1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '60:db:98:1d:7b:ec',
                                         'uptime': '1410644'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e0:cb:bc:9d:72:91'],
                                                                       'id': '53/g1',
                                                                       'in_nucast_pkts': '1199037',
                                                                       'in_octets': '80659296870',
                                                                       'in_ucast_pkts': '159415156',
                                                                       'mac_address': '60:db:98:1d:7b:86',
                                                                       'mtu': 2000,
                                                                       'name': '53/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1132991',
                                                                       'out_octets': '401868040849',
                                                                       'out_ucast_pkts': '357587845',
                                                                       'poller_hash': 'QTFCMDdGcGVlcmludGY1My9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '53',
                                                                       'in_nucast_pkts': '1132991',
                                                                       'in_octets': '401868040849',
                                                                       'in_ucast_pkts': '357587845',
                                                                       'links': [       {       'in_nucast_pkts': '1132991',
                                                                                                'in_octets': '401868040849',
                                                                                                'in_ucast_pkts': '357587845',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '1199037',
                                                                                                'out_octets': '80659296870',
                                                                                                'out_ucast_pkts': '159415156',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 53',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1199037',
                                                                       'out_octets': '80659296870',
                                                                       'out_ucast_pkts': '159415156',
                                                                       'poller_hash': 'QTFCMDdGcGVlcmludGZwb24gNTM=',
                                                                       'pons': [       {       'id': '53',
                                                                                               'links': [       {       'connected_time': '2187323',
                                                                                                                        'fiber_length': 5116,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '53',
                                                                                               'poller_hash': 'QTFCMDdGcGVlcnBvbnBvbiA1Mw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 53',
                                         'poller_hash': 'QTFCMDdG',
                                         'serial_number': 'A1B07F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '60:db:98:1d:7b:86',
                                         'uptime': '2187323'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:e6:14:21'],
                                                                       'id': '54/g1',
                                                                       'in_nucast_pkts': '20128',
                                                                       'in_octets': '59116492195',
                                                                       'in_ucast_pkts': '124159327',
                                                                       'mac_address': '60:db:98:1d:2f:4b',
                                                                       'mtu': 2000,
                                                                       'name': '54/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133060',
                                                                       'out_octets': '318231122168',
                                                                       'out_ucast_pkts': '281319241',
                                                                       'poller_hash': 'QTE5NkZFcGVlcmludGY1NC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '54',
                                                                       'in_nucast_pkts': '1133060',
                                                                       'in_octets': '318231122168',
                                                                       'in_ucast_pkts': '281319241',
                                                                       'links': [       {       'in_nucast_pkts': '1133060',
                                                                                                'in_octets': '318231122168',
                                                                                                'in_ucast_pkts': '281319241',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '20128',
                                                                                                'out_octets': '59116492195',
                                                                                                'out_ucast_pkts': '124159327',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 54',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '20128',
                                                                       'out_octets': '59116492195',
                                                                       'out_ucast_pkts': '124159327',
                                                                       'poller_hash': 'QTE5NkZFcGVlcmludGZwb24gNTQ=',
                                                                       'pons': [       {       'id': '54',
                                                                                               'links': [       {       'connected_time': '2187321',
                                                                                                                        'fiber_length': 4761,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '54',
                                                                                               'poller_hash': 'QTE5NkZFcGVlcnBvbnBvbiA1NA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 54',
                                         'poller_hash': 'QTE5NkZF',
                                         'serial_number': 'A196FE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '60:db:98:1d:2f:4b',
                                         'uptime': '2187321'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e4:38:83:53:d5:a4'],
                                                                       'id': '55/g1',
                                                                       'in_nucast_pkts': '244152',
                                                                       'in_octets': '4951942502',
                                                                       'in_ucast_pkts': '18061776',
                                                                       'mac_address': '84:d3:43:4f:87:42',
                                                                       'mtu': 2000,
                                                                       'name': '55/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '92597',
                                                                       'out_octets': '68868023275',
                                                                       'out_ucast_pkts': '54607158',
                                                                       'poller_hash': 'QzFCN0ExcGVlcmludGY1NS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '55',
                                                                       'in_nucast_pkts': '92597',
                                                                       'in_octets': '68868023275',
                                                                       'in_ucast_pkts': '54607158',
                                                                       'links': [       {       'in_nucast_pkts': '92597',
                                                                                                'in_octets': '68868023275',
                                                                                                'in_ucast_pkts': '54607158',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '244152',
                                                                                                'out_octets': '4951942502',
                                                                                                'out_ucast_pkts': '18061776',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 55',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '244152',
                                                                       'out_octets': '4951942502',
                                                                       'out_ucast_pkts': '18061776',
                                                                       'poller_hash': 'QzFCN0ExcGVlcmludGZwb24gNTU=',
                                                                       'pons': [       {       'id': '55',
                                                                                               'links': [       {       'connected_time': '179258',
                                                                                                                        'fiber_length': 9251,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '55',
                                                                                               'poller_hash': 'QzFCN0ExcGVlcnBvbnBvbiA1NQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 55',
                                         'poller_hash': 'QzFCN0Ex',
                                         'serial_number': 'C1B7A1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '84:d3:43:4f:87:42',
                                         'uptime': '179258'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e4:38:83:1d:53:01'],
                                                                       'id': '56/g1',
                                                                       'in_nucast_pkts': '1917695',
                                                                       'in_octets': '33404130864',
                                                                       'in_ucast_pkts': '75236121',
                                                                       'mac_address': '84:d3:43:4f:8b:9b',
                                                                       'mtu': 2000,
                                                                       'name': '56/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '729855',
                                                                       'out_octets': '234878026699',
                                                                       'out_ucast_pkts': '188918246',
                                                                       'poller_hash': 'QzFCOTE0cGVlcmludGY1Ni9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '56',
                                                                       'in_nucast_pkts': '729855',
                                                                       'in_octets': '234878026699',
                                                                       'in_ucast_pkts': '188918246',
                                                                       'links': [       {       'in_nucast_pkts': '729855',
                                                                                                'in_octets': '234878026699',
                                                                                                'in_ucast_pkts': '188918246',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '1917695',
                                                                                                'out_octets': '33404130864',
                                                                                                'out_ucast_pkts': '75236121',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzM='}],
                                                                       'name': 'pon 56',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1917695',
                                                                       'out_octets': '33404130864',
                                                                       'out_ucast_pkts': '75236121',
                                                                       'poller_hash': 'QzFCOTE0cGVlcmludGZwb24gNTY=',
                                                                       'pons': [       {       'id': '56',
                                                                                               'links': [       {       'connected_time': '1408174',
                                                                                                                        'fiber_length': 9858,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzM=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '56',
                                                                                               'poller_hash': 'QzFCOTE0cGVlcnBvbnBvbiA1Ng==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 56',
                                         'poller_hash': 'QzFCOTE0',
                                         'serial_number': 'C1B914',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '84:d3:43:4f:8b:9b',
                                         'uptime': '1408174'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '57/g1',
                                                                       'mtu': 0,
                                                                       'name': '57/g1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QjFCMEY5cGVlcmludGY1Ny9nMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': '57',
                                                                       'name': 'pon 57',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QjFCMEY5cGVlcmludGZwb24gNTc='}],
                                         'name': 'ont 57',
                                         'poller_hash': 'QjFCMEY5',
                                         'serial_number': 'B1B0F9',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd4:6a:91:b0:9d:cd'],
                                                                       'id': '58/g1',
                                                                       'in_nucast_pkts': '254',
                                                                       'in_octets': '57258707053',
                                                                       'in_ucast_pkts': '69768059',
                                                                       'mac_address': '84:d3:43:9f:33:f0',
                                                                       'mtu': 2000,
                                                                       'name': '58/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133081',
                                                                       'out_octets': '105867693687',
                                                                       'out_ucast_pkts': '93777885',
                                                                       'poller_hash': 'RDlDNTM4cGVlcmludGY1OC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '58',
                                                                       'in_nucast_pkts': '1133081',
                                                                       'in_octets': '105867693687',
                                                                       'in_ucast_pkts': '93777885',
                                                                       'links': [       {       'in_nucast_pkts': '1133081',
                                                                                                'in_octets': '105867693687',
                                                                                                'in_ucast_pkts': '93777885',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '254',
                                                                                                'out_octets': '57258707053',
                                                                                                'out_ucast_pkts': '69768059',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 58',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '254',
                                                                       'out_octets': '57258707053',
                                                                       'out_ucast_pkts': '69768059',
                                                                       'poller_hash': 'RDlDNTM4cGVlcmludGZwb24gNTg=',
                                                                       'pons': [       {       'id': '58',
                                                                                               'links': [       {       'connected_time': '2187322',
                                                                                                                        'fiber_length': 5495,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '58',
                                                                                               'poller_hash': 'RDlDNTM4cGVlcnBvbnBvbiA1OA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 58',
                                         'poller_hash': 'RDlDNTM4',
                                         'serial_number': 'D9C538',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '84:d3:43:9f:33:f0',
                                         'uptime': '2187322'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '18:c2:41:11:1a:41'],
                                                                       'id': '59/g1',
                                                                       'in_nucast_pkts': '5030',
                                                                       'in_octets': '603680179080',
                                                                       'in_ucast_pkts': '1039460290',
                                                                       'mac_address': '60:db:98:83:b4:db',
                                                                       'mtu': 2000,
                                                                       'name': '59/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '8921335',
                                                                       'out_octets': '1866036657186',
                                                                       'out_ucast_pkts': '1726170447',
                                                                       'poller_hash': 'QjJFOTE3cGVlcmludGY1OS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '59',
                                                                       'in_nucast_pkts': '8921335',
                                                                       'in_octets': '1866036657186',
                                                                       'in_ucast_pkts': '1726170447',
                                                                       'links': [       {       'in_nucast_pkts': '8921335',
                                                                                                'in_octets': '1866036657186',
                                                                                                'in_ucast_pkts': '1726170447',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '5030',
                                                                                                'out_octets': '603680179080',
                                                                                                'out_ucast_pkts': '1039460290',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzE='}],
                                                                       'name': 'pon 59',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '5030',
                                                                       'out_octets': '603680179080',
                                                                       'out_ucast_pkts': '1039460290',
                                                                       'poller_hash': 'QjJFOTE3cGVlcmludGZwb24gNTk=',
                                                                       'pons': [       {       'id': '59',
                                                                                               'links': [       {       'connected_time': '16747358',
                                                                                                                        'fiber_length': 4930,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzE=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '59',
                                                                                               'poller_hash': 'QjJFOTE3cGVlcnBvbnBvbiA1OQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 59',
                                         'poller_hash': 'QjJFOTE3',
                                         'serial_number': 'B2E917',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '60:db:98:83:b4:db',
                                         'uptime': '16747358'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd4:3f:32:7b:d0:81'],
                                                                       'id': '60/g1',
                                                                       'in_nucast_pkts': '91113',
                                                                       'in_octets': '8341811894',
                                                                       'in_ucast_pkts': '12390242',
                                                                       'mac_address': '60:db:98:88:4b:c9',
                                                                       'mtu': 2000,
                                                                       'name': '60/g1',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '1133090',
                                                                       'out_octets': '2692153091',
                                                                       'out_ucast_pkts': '7782692',
                                                                       'poller_hash': 'QjNBRjUzcGVlcmludGY2MC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '60',
                                                                       'in_nucast_pkts': '1133090',
                                                                       'in_octets': '2692153091',
                                                                       'in_ucast_pkts': '7782692',
                                                                       'links': [       {       'in_nucast_pkts': '1133090',
                                                                                                'in_octets': '2692153091',
                                                                                                'in_ucast_pkts': '7782692',
                                                                                                'oper_up': True,
                                                                                                'out_nucast_pkts': '91113',
                                                                                                'out_octets': '8341811894',
                                                                                                'out_ucast_pkts': '12390242',
                                                                                                'poller_hash': 'MjExODA2NjAwNTUwZ3BvbiAxLzQ='}],
                                                                       'name': 'pon 60',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '91113',
                                                                       'out_octets': '8341811894',
                                                                       'out_ucast_pkts': '12390242',
                                                                       'poller_hash': 'QjNBRjUzcGVlcmludGZwb24gNjA=',
                                                                       'pons': [       {       'id': '60',
                                                                                               'links': [       {       'connected_time': '2187322',
                                                                                                                        'fiber_length': 16352,
                                                                                                                        'poller_hash': 'MjExODA2NjAwNTUwcG9uZ3BvbiAxLzQ=',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': 'pon '
                                                                                                       '60',
                                                                                               'poller_hash': 'QjNBRjUzcGVlcnBvbnBvbiA2MA==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'Calix',
                                         'model': '803G',
                                         'name': 'ont 60',
                                         'poller_hash': 'QjNBRjUz',
                                         'serial_number': 'B3AF53',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.9.8.11',
                                         'system_mac_address': '60:db:98:88:4b:c9',
                                         'uptime': '2187322'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '61/g1',
                                                                       'mtu': 0,
                                                                       'name': '61/g1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QjJFOUQ2cGVlcmludGY2MS9nMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': '61',
                                                                       'name': 'pon 61',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QjJFOUQ2cGVlcmludGZwb24gNjE='}],
                                         'name': 'ont 61',
                                         'poller_hash': 'QjJFOUQ2',
                                         'serial_number': 'B2E9D6',
                                         'status': 'ELEMENT_STATUS_OFFLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_calix_exa_E7_2_EXA_3_4_30_40_01(self):
        obj = self.run_data("calix.exa.E7-2 (EXA).3.4.30.40.01")
        exp_info = {
                'model': 'E7-2 (EXA)',
                'sta_count': 365,
                'sw_version': '3.4.30.40',
                'vendor': 'Calix'
        }
        exp_stats = {
         'serial_number': '71702970268', 'system_mac_address': None
        }
        exp_sta_stats = {
                None: {       'dev_macs': [],
                              'ip_address': None,
                              'mac_address': None,
                              'name': '7335 ROAD 164',
                              'serial_number': '3FFAB9',
                              'system_mac_address': None},
                '00:06:31:06:38:37': {       'dev_macs': ['78:da:6e:46:5e:e7'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:06:38:37',
                                             'name': 'ont 185',
                                             'serial_number': '7FF5',
                                             'system_mac_address': None},
                '00:06:31:08:4a:08': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4a:08',
                                             'name': '93 Elma Centre',
                                             'serial_number': 'F0F8',
                                             'system_mac_address': None},
                '00:06:31:08:4a:56': {       'dev_macs': ['c0:c9:e3:ab:9a:c5'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4a:56',
                                             'name': '140 Monument Rd',
                                             'serial_number': 'F1F8',
                                             'system_mac_address': None},
                '00:06:31:08:4b:82': {       'dev_macs': ['34:98:b5:6d:56:26'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4b:82',
                                             'name': '157 Main St. Atwood',
                                             'serial_number': 'F23A',
                                             'system_mac_address': None},
                '00:06:31:08:4c:8d': {       'dev_macs': ['ac:15:a2:4e:e8:e5'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4c:8d',
                                             'name': '108 Blair St. Atwood',
                                             'serial_number': 'F23C',
                                             'system_mac_address': None},
                '00:06:31:08:de:8d': {       'dev_macs': ['e4:6f:13:45:27:eb'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:de:8d',
                                             'name': '281 Main St, Atwood',
                                             'serial_number': '153C3',
                                             'system_mac_address': None},
                '00:06:31:08:e2:95': {       'dev_macs': ['04:42:1a:10:3c:70'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:e2:95',
                                             'name': '7319 ROAD 164',
                                             'serial_number': '15452',
                                             'system_mac_address': None},
                '00:06:31:08:e2:e6': {       'dev_macs': ['b0:be:76:94:41:25'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:e2:e6',
                                             'name': '231 Main St. Atwood',
                                             'serial_number': '1545D',
                                             'system_mac_address': None},
                '00:06:31:11:f0:4e': {       'dev_macs': ['10:be:f5:d3:4f:4b'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:11:f0:4e',
                                             'name': '210B Main St. Atwood',
                                             'serial_number': '1303D',
                                             'system_mac_address': None},
                '00:06:31:11:f6:cc': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:11:f6:cc',
                                             'name': '185 Main St. Atwood',
                                             'serial_number': '13538',
                                             'system_mac_address': None},
                '00:06:31:11:f7:7d': {       'dev_macs': ['c0:8c:60:0f:dd:00'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:11:f7:7d',
                                             'name': '218A Main St. Atwood',
                                             'serial_number': '13548',
                                             'system_mac_address': None},
                '00:06:31:15:a1:e0': {       'dev_macs': ['14:59:c0:b8:c4:11'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a1:e0',
                                             'name': '171 Main St. Atwood',
                                             'serial_number': '3CC08',
                                             'system_mac_address': None},
                '00:06:31:15:a8:61': {       'dev_macs': [       '00:23:69:a6:8c:09',
                                                                 '00:03:e6:5e:77:76',
                                                                 '00:03:e6:5e:77:e6'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a8:61',
                                             'name': '138 King St. Atwood',
                                             'serial_number': '3CFA8',
                                             'system_mac_address': None},
                '00:06:31:15:a8:b0': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a8:b0',
                                             'name': '93 Arthur St. Atwood',
                                             'serial_number': '3CFA6',
                                             'system_mac_address': None},
                '00:06:31:15:a9:1e': {       'dev_macs': ['c8:d3:a3:5c:39:af'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:1e',
                                             'name': '127 Main St. Atwood',
                                             'serial_number': '3CF4A',
                                             'system_mac_address': None},
                '00:06:31:15:a9:2d': {       'dev_macs': [       '04:7c:16:e8:46:88',
                                                                 '00:03:e6:9b:3d:64'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:2d',
                                             'name': '151 Queen St. Atwood',
                                             'serial_number': '3D0FA',
                                             'system_mac_address': None},
                '00:06:31:15:a9:32': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:32',
                                             'name': '7434 ROAD 164',
                                             'serial_number': '3D0FC',
                                             'system_mac_address': None},
                '00:06:31:15:a9:37': {       'dev_macs': ['10:62:eb:9b:c8:3b'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:37',
                                             'name': '7418 Rd. 164 Atwood',
                                             'serial_number': '3D0F2',
                                             'system_mac_address': None},
                '00:06:31:15:a9:46': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:46',
                                             'name': '7272 Rd. 164 Atwood',
                                             'serial_number': '3D0F4',
                                             'system_mac_address': None},
                '00:06:31:15:a9:64': {       'dev_macs': ['28:87:ba:bd:b8:55'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:64',
                                             'name': '7480 Rd. 164 Atwood',
                                             'serial_number': '3D0EF',
                                             'system_mac_address': None},
                '00:06:31:18:c1:01': {       'dev_macs': ['70:3a:cb:43:d6:35'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:18:c1:01',
                                             'name': '184 Main St. Atwood',
                                             'serial_number': '3CF4E',
                                             'system_mac_address': None},
                '00:06:31:18:c1:ce': {       'dev_macs': [       '24:4b:fe:0a:f8:e8',
                                                                 '00:03:e6:31:45:e6'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:18:c1:ce',
                                             'name': '136 King St. Atwood',
                                             'serial_number': '3CF9D',
                                             'system_mac_address': None},
                '00:06:31:18:c2:fa': {       'dev_macs': ['c8:78:7d:ea:2b:3e'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:18:c2:fa',
                                             'name': '90 Baker St. Atwood',
                                             'serial_number': '3CFAA',
                                             'system_mac_address': None},
                '00:06:31:18:c2:ff': {       'dev_macs': ['c0:06:c3:07:a6:a9'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:18:c2:ff',
                                             'name': '236 Main St. Atwood',
                                             'serial_number': '3CFA0',
                                             'system_mac_address': None},
                '00:06:31:1e:52:10': {       'dev_macs': [       '98:fc:11:45:a0:e9',
                                                                 '00:03:e6:30:ec:d0',
                                                                 '00:03:e6:60:30:f8'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1e:52:10',
                                             'name': '7428 Road 164',
                                             'serial_number': '3D0E9',
                                             'system_mac_address': None},
                '00:06:31:1e:56:75': {       'dev_macs': ['94:56:41:2b:48:10'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1e:56:75',
                                             'name': '7412 Rd. 164 Atwood',
                                             'serial_number': '3D0F6',
                                             'system_mac_address': None},
                '00:06:31:1f:06:f6': {       'dev_macs': ['c8:d7:19:8a:7d:58'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:06:f6',
                                             'name': '219 Queen St. Atwood',
                                             'serial_number': '41542',
                                             'system_mac_address': None},
                '00:06:31:1f:07:23': {       'dev_macs': ['c0:a0:bb:c6:c7:67'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:07:23',
                                             'name': '7470 Rd. 164 Atwood',
                                             'serial_number': '41522',
                                             'system_mac_address': None},
                '00:06:31:1f:07:55': {       'dev_macs': ['c8:d3:a3:66:49:00'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:07:55',
                                             'name': '171 Monument Rd. Atwood',
                                             'serial_number': '41530',
                                             'system_mac_address': None},
                '00:06:31:1f:07:82': {       'dev_macs': ['f0:2f:74:7a:d2:d0'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:07:82',
                                             'name': '7333 Road 164',
                                             'serial_number': '41585',
                                             'system_mac_address': None},
                '00:06:31:1f:08:4f': {       'dev_macs': ['78:98:e8:4a:f8:3a'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:08:4f',
                                             'name': '130 Monument Road',
                                             'serial_number': '41591',
                                             'system_mac_address': None},
                '00:06:31:1f:08:d6': {       'dev_macs': ['00:03:e6:a5:6b:b8'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:08:d6',
                                             'name': '243 Main St. Atwood',
                                             'serial_number': '41549',
                                             'system_mac_address': None},
                '00:06:31:20:00:37': {       'dev_macs': ['b8:38:61:b6:0b:fa'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:00:37',
                                             'name': '246 Queen St. Atwood',
                                             'serial_number': '4157E',
                                             'system_mac_address': None},
                '00:06:31:20:00:64': {       'dev_macs': [       '34:97:f6:a7:2c:b8',
                                                                 '00:03:e6:5e:94:fa',
                                                                 '00:03:e6:5e:9f:1e'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:00:64',
                                             'name': '139 Queen St. Atwood',
                                             'serial_number': '41535',
                                             'system_mac_address': None},
                '00:06:31:20:00:69': {       'dev_macs': ['24:4b:fe:ad:ce:00'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:00:69',
                                             'name': '129 Main St. Atwood',
                                             'serial_number': '415B0',
                                             'system_mac_address': None},
                '00:06:31:20:01:45': {       'dev_macs': [       '00:1a:79:45:5f:4d',
                                                                 '00:1a:79:6c:0b:24',
                                                                 '08:bf:b8:b5:1f:f8'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:45',
                                             'name': '247 Queen St. Atwood',
                                             'serial_number': '415AB',
                                             'system_mac_address': None},
                '00:06:31:20:01:5e': {       'dev_macs': [       '60:38:e0:72:6a:53',
                                                                 '00:03:e6:65:05:e4',
                                                                 '00:03:e6:6b:b6:8c'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:5e',
                                             'name': '7475 Rd. 164 Atwood',
                                             'serial_number': '4153F',
                                             'system_mac_address': None},
                '00:06:31:20:01:6d': {       'dev_macs': [       '00:97:f6:d0:2f:0a',
                                                                 '00:03:e6:5e:77:f0',
                                                                 '00:03:e6:5e:78:56'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:6d',
                                             'name': '218 King St. Atwood',
                                             'serial_number': '418B8',
                                             'system_mac_address': None},
                '00:06:31:20:01:81': {       'dev_macs': ['00:5f:67:a4:74:95'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:81',
                                             'name': '190 KING STREET ATWOOD',
                                             'serial_number': '418B7',
                                             'system_mac_address': None},
                '00:06:31:20:01:b8': {       'dev_macs': ['d0:17:c2:5a:01:48'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:b8',
                                             'name': '220 Queen St.',
                                             'serial_number': '4152F',
                                             'system_mac_address': None},
                '00:06:31:20:02:3a': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:02:3a',
                                             'name': '215 KING STREET ATWOOD',
                                             'serial_number': '4153C',
                                             'system_mac_address': None},
                '00:06:31:20:02:5d': {       'dev_macs': ['0c:0e:76:e9:25:1a'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:02:5d',
                                             'name': '128 King St. Atwood',
                                             'serial_number': '415FE',
                                             'system_mac_address': None},
                '00:06:31:20:03:2a': {       'dev_macs': ['64:29:43:08:35:6c'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:03:2a',
                                             'name': '169 Main St. Atwood',
                                             'serial_number': '418AC',
                                             'system_mac_address': None},
                '00:06:31:20:03:61': {       'dev_macs': [       'c8:7f:54:23:67:38',
                                                                 '00:03:e6:31:1a:2c',
                                                                 '00:03:e6:5f:26:90'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:03:61',
                                             'name': '252 Main St. Atwood',
                                             'serial_number': '418B5',
                                             'system_mac_address': None},
                '00:06:31:20:a1:a2': {       'dev_macs': [       '48:77:46:9a:61:95',
                                                                 '00:03:e6:db:52:24',
                                                                 '60:db:98:09:3a:86',
                                                                 'b8:94:70:f3:e0:78',
                                                                 '0c:0e:76:4a:a6:ad',
                                                                 '40:9b:cd:2c:e9:b3'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:a1:a2',
                                             'name': '7429 ROAD 164',
                                             'serial_number': '49340',
                                             'system_mac_address': None},
                '00:06:31:34:38:18': {       'dev_macs': ['c4:e9:0a:4e:e9:d4'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:34:38:18',
                                             'name': '87 Baker St. Atwood',
                                             'serial_number': '757AC',
                                             'system_mac_address': None},
                '00:06:31:34:38:27': {       'dev_macs': ['28:87:ba:bd:a2:69'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:34:38:27',
                                             'name': '153 Queen St. Atwood',
                                             'serial_number': '757BB',
                                             'system_mac_address': None},
                '00:06:31:34:38:28': {       'dev_macs': ['0c:b6:d2:50:99:de'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:34:38:28',
                                             'name': '167 Fisher Ave',
                                             'serial_number': '757BC',
                                             'system_mac_address': None},
                '00:06:31:3c:5f:10': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:5f:10',
                                             'name': '192 WOODVIEW ATWOOD',
                                             'serial_number': '7FE2A',
                                             'system_mac_address': None},
                '00:06:31:3c:5f:6a': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:5f:6a',
                                             'name': '133 Bowman Ct',
                                             'serial_number': '7FE84',
                                             'system_mac_address': None},
                '00:06:31:3c:cc:73': {       'dev_macs': ['48:f8:b3:8f:00:da'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:cc:73',
                                             'name': '142 JOHN STREET ATWOOD',
                                             'serial_number': '86B8B',
                                             'system_mac_address': None},
                '00:06:31:3c:cc:a6': {       'dev_macs': ['18:a6:f7:e2:9e:f3'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:cc:a6',
                                             'name': '137 King St. Atwood',
                                             'serial_number': '86BBE',
                                             'system_mac_address': None},
                '00:06:31:3c:d5:37': {       'dev_macs': ['60:45:cb:66:ac:68'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:d5:37',
                                             'name': '169 Fisher Ave. Atwood',
                                             'serial_number': '8744F',
                                             'system_mac_address': None},
                '00:06:31:3c:ea:9c': {       'dev_macs': ['ec:4f:82:a4:90:bc'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:ea:9c',
                                             'name': '7462 ROAD 164',
                                             'serial_number': '889B4',
                                             'system_mac_address': None},
                '00:06:31:47:4b:6c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:47:4b:6c',
                                             'name': '278 QUEEN STREET ATWOOD',
                                             'serial_number': '8A280',
                                             'system_mac_address': None},
                '00:06:31:57:b0:79': {       'dev_macs': ['e0:46:ee:35:a4:40'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:57:b0:79',
                                             'name': '247 Woodview Dr. Atwood',
                                             'serial_number': 'A9FB9',
                                             'system_mac_address': None},
                '00:06:31:5f:60:b4': {       'dev_macs': [       'ec:4f:82:ac:eb:ec',
                                                                 '00:03:e6:a2:15:b8',
                                                                 '00:03:e6:a4:ce:27'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:60:b4',
                                             'name': '250 Woodview Atwood',
                                             'serial_number': 'C4FF4',
                                             'system_mac_address': None},
                '00:06:31:5f:60:d0': {       'dev_macs': ['a8:63:7d:4e:f7:4c'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:60:d0',
                                             'name': '128 James St. Atwood',
                                             'serial_number': 'C5010',
                                             'system_mac_address': None},
                '00:06:31:5f:68:8d': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:68:8d',
                                             'name': '136 Main St. Atwood',
                                             'serial_number': 'C57CD',
                                             'system_mac_address': None},
                '00:06:31:5f:69:10': {       'dev_macs': ['d0:76:8f:02:f3:7a'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:69:10',
                                             'name': '194 Main St. Atwood (Upper)',
                                             'serial_number': 'C5850',
                                             'system_mac_address': None},
                '00:06:31:5f:69:2b': {       'dev_macs': ['84:d3:43:6d:ec:45'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:69:2b',
                                             'name': '176 Main St. Atwood',
                                             'serial_number': 'C586B',
                                             'system_mac_address': None},
                '00:06:31:5f:d1:76': {       'dev_macs': ['a0:36:bc:15:e3:08'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:d1:76',
                                             'name': '225 Queen St',
                                             'serial_number': 'CC0B6',
                                             'system_mac_address': None},
                '00:06:31:6f:c4:65': {       'dev_macs': ['c8:e3:06:44:27:20'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:6f:c4:65',
                                             'name': '211 King St. Atwood',
                                             'serial_number': 'F23A5',
                                             'system_mac_address': None},
                '00:06:31:90:39:05': {       'dev_macs': ['cc:be:59:2d:a9:3a'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:39:05',
                                             'name': '207 KING STREET ATWOOD',
                                             'serial_number': '124845',
                                             'system_mac_address': None},
                '00:06:31:90:f0:9d': {       'dev_macs': ['ec:4f:82:2d:78:46'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f0:9d',
                                             'name': '152 Queen St. Atwood',
                                             'serial_number': '12FFDD',
                                             'system_mac_address': None},
                '00:06:31:90:f0:ae': {       'dev_macs': ['28:87:ba:87:1b:b3'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f0:ae',
                                             'name': '134 BOWMAN CT',
                                             'serial_number': '12FFEE',
                                             'system_mac_address': None},
                '00:06:31:90:f1:1f': {       'dev_macs': [       'd0:76:8f:91:11:92',
                                                                 '00:03:e6:db:4d:b3'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:1f',
                                             'name': '101 PARKVIEW CR',
                                             'serial_number': '13005F',
                                             'system_mac_address': None},
                '00:06:31:90:f1:4b': {       'dev_macs': ['84:d3:43:0f:62:41'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:4b',
                                             'name': '184 King St. Atwood',
                                             'serial_number': '13008B',
                                             'system_mac_address': None},
                '00:06:31:90:f1:4d': {       'dev_macs': [       '04:92:26:66:10:dc',
                                                                 '28:87:ba:bd:b9:21',
                                                                 '3c:37:86:90:9f:42'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:4d',
                                             'name': '170 John St. Atwood',
                                             'serial_number': '13008D',
                                             'system_mac_address': None},
                '00:06:31:90:f1:5a': {       'dev_macs': ['00:5f:67:f1:36:8b'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:5a',
                                             'name': '159 Main St. Atwood',
                                             'serial_number': '13009A',
                                             'system_mac_address': None},
                '00:06:31:b7:29:e8': {       'dev_macs': [       'bc:22:28:af:2f:0b',
                                                                 '6c:5a:b0:21:bd:b6'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:b7:29:e8',
                                             'name': '200B Main St. Atwood',
                                             'serial_number': '161021',
                                             'system_mac_address': None},
                '00:06:31:b7:5c:3e': {       'dev_macs': ['e4:c3:2a:85:66:41'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:b7:5c:3e',
                                             'name': '201 Ellen St. Atwood',
                                             'serial_number': '164277',
                                             'system_mac_address': None},
                '00:06:31:b7:5c:48': {       'dev_macs': ['70:4f:57:be:53:1c'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:b7:5c:48',
                                             'name': '136 Queen St. Atwood',
                                             'serial_number': '164281',
                                             'system_mac_address': None},
                '00:06:31:dd:56:87': {       'dev_macs': ['f8:e9:03:bb:4d:c5'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:dd:56:87',
                                             'name': '145 King St. Atwood',
                                             'serial_number': '175E66',
                                             'system_mac_address': None},
                '00:06:31:dd:56:bf': {       'dev_macs': ['d0:76:8f:91:d4:6f'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:dd:56:bf',
                                             'name': '96 ARTHUR STREET EAST ATWOOD',
                                             'serial_number': '175E6D',
                                             'system_mac_address': None},
                '00:06:31:dd:73:d7': {       'dev_macs': ['d0:76:8f:91:d3:9e'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:dd:73:d7',
                                             'name': '209 QUEEN STREET ATWOOD',
                                             'serial_number': '176210',
                                             'system_mac_address': None},
                '00:06:31:e3:f9:63': {       'dev_macs': ['60:db:98:57:b5:0e'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:f9:63',
                                             'name': '123 Queen St. Atwood',
                                             'serial_number': '1999C5',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:43': {       'dev_macs': ['f8:1a:2b:04:bc:e1'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:43',
                                             'name': '141&143 John St. Atwood',
                                             'serial_number': '1999E1',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:53': {       'dev_macs': ['cc:be:59:2d:a8:fb'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:53',
                                             'name': '7422 Road 164',
                                             'serial_number': '1999E3',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:83': {       'dev_macs': ['14:91:82:c1:9e:b6'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:83',
                                             'name': '220B Main St. Atwood',
                                             'serial_number': '1999E9',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:eb': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:eb',
                                             'name': '168 John St. Atwood',
                                             'serial_number': '1999F6',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:f3': {       'dev_macs': ['0c:b6:d2:3f:42:f7'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:f3',
                                             'name': '209 King St. Atwood',
                                             'serial_number': '1999F7',
                                             'system_mac_address': None},
                '00:06:31:e3:fb:3b': {       'dev_macs': ['5c:e9:31:72:5c:41'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fb:3b',
                                             'name': '266 Main St. Atwood',
                                             'serial_number': '199A00',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:13': {       'dev_macs': [       '60:38:e0:12:de:ad',
                                                                 '00:03:e6:a2:74:84'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:13',
                                             'name': '203 Main St. Atwood',
                                             'serial_number': '199A1B',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:63': {       'dev_macs': ['44:65:7f:89:0f:54'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:63',
                                             'name': '190 Main St. Atwood',
                                             'serial_number': '199A25',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:a3': {       'dev_macs': ['c8:f7:50:64:96:52'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:a3',
                                             'name': '141 Arthur St. Atwood',
                                             'serial_number': '199A2D',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:c3': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:c3',
                                             'name': '7433 Road 164',
                                             'serial_number': '199A31',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:cb': {       'dev_macs': ['08:62:66:9b:79:ac'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:cb',
                                             'name': '132 FISHER AV',
                                             'serial_number': '199A32',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:eb': {       'dev_macs': ['60:db:98:08:f2:b9'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:eb',
                                             'name': '7442 Rd. 164 Atwood',
                                             'serial_number': '199A36',
                                             'system_mac_address': None},
                '00:06:31:e3:fd:03': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fd:03',
                                             'name': '177 Main St. Atwood',
                                             'serial_number': '199A39',
                                             'system_mac_address': None},
                '00:06:31:ff:48:34': {       'dev_macs': ['08:b4:b1:e6:44:f5'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:ff:48:34',
                                             'name': '163 Queen St. Atwood',
                                             'serial_number': '1C4DA9',
                                             'system_mac_address': None},
                '04:bc:9f:00:17:d9': {       'dev_macs': [       '04:a1:51:cd:4a:03',
                                                                 'd0:76:58:e0:09:76'],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:00:17:d9',
                                             'name': '161 John St. Atwood',
                                             'serial_number': 'EBC2EE',
                                             'system_mac_address': None},
                '04:bc:9f:5c:1a:89': {       'dev_macs': ['b8:94:70:f3:df:de'],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:1a:89',
                                             'name': '192 KING STREET ATWOOD',
                                             'serial_number': '12749D1',
                                             'system_mac_address': None},
                '04:bc:9f:5c:1d:81': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:1d:81',
                                             'name': '302 WOODVIEW DR ATWOOD',
                                             'serial_number': '1274A30',
                                             'system_mac_address': None},
                '04:bc:9f:5c:1e:19': {       'dev_macs': ['b8:94:70:f3:e9:05'],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:1e:19',
                                             'name': '260 MAIN STREET ATWOOD',
                                             'serial_number': '1274A43',
                                             'system_mac_address': None},
                '04:bc:9f:5c:21:31': {       'dev_macs': [       '44:65:7f:88:46:a8',
                                                                 '00:03:e6:f9:fa:e6'],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:21:31',
                                             'name': '183 KING STREET',
                                             'serial_number': '1274AA6',
                                             'system_mac_address': None},
                '04:bc:9f:5c:3f:a1': {       'dev_macs': [       'b8:94:70:f3:e8:13',
                                                                 '5c:0f:fb:37:46:30'],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:3f:a1',
                                             'name': '276 QUEEN STREET ATWOOD',
                                             'serial_number': '1274E74',
                                             'system_mac_address': None},
                '04:bc:9f:5c:52:99': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:52:99',
                                             'name': '185 ELLEN STREET',
                                             'serial_number': '12750D3',
                                             'system_mac_address': None},
                '04:bc:9f:5c:58:61': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:58:61',
                                             'name': '156 JAMES STREET ATWOOD',
                                             'serial_number': '127518C',
                                             'system_mac_address': None},
                '44:65:7f:33:20:d4': {       'dev_macs': ['c4:b3:01:da:29:df'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:20:d4',
                                             'name': '279 McCourt Pl Atwood',
                                             'serial_number': '640AE4',
                                             'system_mac_address': None},
                '44:65:7f:33:20:e8': {       'dev_macs': ['60:db:98:09:3c:d8'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:20:e8',
                                             'name': '270 MCCOURT PL',
                                             'serial_number': '640AED',
                                             'system_mac_address': None},
                '44:65:7f:33:21:6e': {       'dev_macs': ['44:65:7f:88:d1:23'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:21:6e',
                                             'name': '277 McCourt Pl Atwood',
                                             'serial_number': '640B2F',
                                             'system_mac_address': None},
                '44:65:7f:33:21:ae': {       'dev_macs': ['44:65:7f:89:0c:d5'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:21:ae',
                                             'name': '116B Monument Rd Atwood',
                                             'serial_number': '640B4F',
                                             'system_mac_address': None},
                '44:65:7f:7b:d3:fa': {       'dev_macs': ['d0:76:8f:02:ee:f7'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d3:fa',
                                             'name': '152 MAIN STREET ATWOOD',
                                             'serial_number': '5A6B99',
                                             'system_mac_address': None},
                '44:65:7f:7b:d6:2b': {       'dev_macs': ['a8:5e:45:da:7a:cc'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d6:2b',
                                             'name': '130 JAMES STREET ATWOOD',
                                             'serial_number': '5A6C54',
                                             'system_mac_address': None},
                '44:65:7f:7b:d6:e5': {       'dev_macs': ['d0:76:8f:02:f2:04'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d6:e5',
                                             'name': '182 QUEEN STREET ATWOOD',
                                             'serial_number': '5A6C92',
                                             'system_mac_address': None},
                '44:65:7f:7b:d7:15': {       'dev_macs': ['60:db:98:09:3a:02'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d7:15',
                                             'name': '278 MCCOURT PL',
                                             'serial_number': '5A6CA2',
                                             'system_mac_address': None},
                '48:77:46:07:b2:49': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:07:b2:49',
                                             'name': '242 Main St. Atwood',
                                             'serial_number': '6AC2C7',
                                             'system_mac_address': None},
                '48:77:46:08:95:89': {       'dev_macs': [       'cc:be:59:c3:46:af',
                                                                 '00:03:e6:db:51:ce',
                                                                 '00:03:e6:dd:43:e8'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:08:95:89',
                                             'name': '7416 Rd. 164 Atwood',
                                             'serial_number': '6DBC98',
                                             'system_mac_address': None},
                '48:77:46:3a:58:0a': {       'dev_macs': ['68:ff:7b:33:bb:d5'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:58:0a',
                                             'name': '166 Queen St. Atwood',
                                             'serial_number': '721D1C',
                                             'system_mac_address': None},
                '48:77:46:3a:71:12': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:71:12',
                                             'name': '7616 Rd 164 Atwood',
                                             'serial_number': '72203D',
                                             'system_mac_address': None},
                '48:77:46:3a:71:32': {       'dev_macs': ['44:65:7f:88:45:88'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:71:32',
                                             'name': '210 King St. Atwood',
                                             'serial_number': '722041',
                                             'system_mac_address': None},
                '48:77:46:3a:72:52': {       'dev_macs': ['ec:4f:82:2c:6f:95'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:72:52',
                                             'name': '133 Main St Atwood',
                                             'serial_number': '722065',
                                             'system_mac_address': None},
                '48:77:46:3a:7f:c2': {       'dev_macs': ['60:db:98:09:1e:ae'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:7f:c2',
                                             'name': '288 Woodview Dr. Atwood',
                                             'serial_number': '722213',
                                             'system_mac_address': None},
                '48:77:46:3b:21:9a': {       'dev_macs': ['ec:4f:82:2d:6c:25'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3b:21:9a',
                                             'name': '186 Queen St. Atwood',
                                             'serial_number': '72364E',
                                             'system_mac_address': None},
                '48:77:46:3b:3f:aa': {       'dev_macs': ['d0:76:8f:91:4f:93'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3b:3f:aa',
                                             'name': '84 PARKVIEW CR',
                                             'serial_number': '723A10',
                                             'system_mac_address': None},
                '48:77:46:8c:12:34': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:8c:12:34',
                                             'name': '197 Ellen St. Atwood',
                                             'serial_number': '76ACE8',
                                             'system_mac_address': None},
                '48:77:46:a2:1b:1c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a2:1b:1c',
                                             'name': '7482 Rd. 164 Atwood',
                                             'serial_number': '71A492',
                                             'system_mac_address': None},
                '48:77:46:a2:1d:64': {       'dev_macs': ['60:db:98:09:38:b8'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a2:1d:64',
                                             'name': '86 BAKER ST',
                                             'serial_number': '71A4DB',
                                             'system_mac_address': None},
                '48:77:46:a3:8d:b4': {       'dev_macs': ['60:db:98:09:37:2c'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:8d:b4',
                                             'name': '7474 Rd. 164 Atwood',
                                             'serial_number': '71D2E5',
                                             'system_mac_address': None},
                '48:77:46:a3:b6:dc': {       'dev_macs': ['c8:7f:54:b6:58:a8'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:b6:dc',
                                             'name': '197 Main St. Atwood',
                                             'serial_number': '71D80A',
                                             'system_mac_address': None},
                '48:77:46:a3:bb:44': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:bb:44',
                                             'name': '999-100-3053',
                                             'serial_number': '71D897',
                                             'system_mac_address': None},
                '48:77:46:a3:bb:8c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:bb:8c',
                                             'name': '216B Main St. Atwood',
                                             'serial_number': '71D8A0',
                                             'system_mac_address': None},
                '48:77:46:cd:52:5e': {       'dev_macs': [       '28:3b:82:35:8a:4d',
                                                                 '00:03:e6:60:41:58',
                                                                 '00:03:e6:6b:ba:d8',
                                                                 '00:03:e6:a5:6f:d8',
                                                                 '5c:0f:fb:14:37:76'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:cd:52:5e',
                                             'name': '5994 Line 77 Atwood',
                                             'serial_number': '76CFF8',
                                             'system_mac_address': None},
                '48:77:46:ce:1f:1e': {       'dev_macs': ['00:ad:24:60:e3:af'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:ce:1f:1e',
                                             'name': '325 Main St. Atwood',
                                             'serial_number': '76E990',
                                             'system_mac_address': None},
                '48:77:46:ce:20:6e': {       'dev_macs': ['a0:ab:1b:81:fa:0b'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:ce:20:6e',
                                             'name': '208 Queen St. Atwood',
                                             'serial_number': '76E9BA',
                                             'system_mac_address': None},
                '48:77:46:ce:63:7e': {       'dev_macs': ['bc:ae:c5:a5:70:8c'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:ce:63:7e',
                                             'name': '131 Fisher Ave Atwood',
                                             'serial_number': '76F21C',
                                             'system_mac_address': None},
                '48:77:46:f8:75:8c': {       'dev_macs': ['74:b6:b6:a0:82:61'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:f8:75:8c',
                                             'name': '271 WOODVIEW DR',
                                             'serial_number': '82A55A',
                                             'system_mac_address': None},
                '60:db:98:4e:6b:64': {       'dev_macs': ['60:db:98:09:1d:43'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:6b:64',
                                             'name': '281 QUEEN STREET ATWOOD',
                                             'serial_number': 'A9C32C',
                                             'system_mac_address': None},
                '60:db:98:4e:8e:34': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:8e:34',
                                             'name': '151 MAIN STREET ATWOOD',
                                             'serial_number': 'A9C786',
                                             'system_mac_address': None},
                '60:db:98:4e:90:0c': {       'dev_macs': ['60:db:98:55:b5:57'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:90:0c',
                                             'name': '277 QUEEN STREET ATWOOD',
                                             'serial_number': 'A9C7C1',
                                             'system_mac_address': None},
                '60:db:98:4e:96:cc': {       'dev_macs': ['60:db:98:55:b7:7d'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:96:cc',
                                             'name': '140 MAIN STREET ATWOOD',
                                             'serial_number': 'A9C899',
                                             'system_mac_address': None},
                '60:db:98:4e:99:cc': {       'dev_macs': ['18:e7:28:04:0d:84'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:99:cc',
                                             'name': '269 Main St. Atwood',
                                             'serial_number': 'A9C8F9',
                                             'system_mac_address': None},
                '60:db:98:4e:9b:8c': {       'dev_macs': [       '84:d3:43:0f:bb:5f',
                                                                 '5c:0f:fb:17:69:f0',
                                                                 '5c:0f:fb:17:6d:b7',
                                                                 '5c:0f:fb:17:6e:7b',
                                                                 '5c:0f:fb:17:6f:60'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:9b:8c',
                                             'name': '150 KING STREET ATWOOD',
                                             'serial_number': 'A9C931',
                                             'system_mac_address': None},
                '60:db:98:73:9c:74': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:73:9c:74',
                                             'name': '150 MAIN STREET ATWOOD',
                                             'serial_number': 'B0A2A0',
                                             'system_mac_address': None},
                '60:db:98:8e:fe:5a': {       'dev_macs': ['b8:94:70:9e:ce:59'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8e:fe:5a',
                                             'name': '158 Main St. Atwood',
                                             'serial_number': 'B510E2',
                                             'system_mac_address': None},
                '60:db:98:8e:ff:a7': {       'dev_macs': ['60:db:98:81:fc:1a'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8e:ff:a7',
                                             'name': '232 WOODVIEW DR',
                                             'serial_number': 'B51151',
                                             'system_mac_address': None},
                '60:db:98:8f:01:6f': {       'dev_macs': ['60:db:98:09:3b:d0'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8f:01:6f',
                                             'name': '271 QUEEN STREET ATWOOD',
                                             'serial_number': 'B511E9',
                                             'system_mac_address': None},
                '60:db:98:8f:01:d5': {       'dev_macs': ['08:5a:11:ba:2d:aa'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8f:01:d5',
                                             'name': '279 QUEEN STREET ATWOOD',
                                             'serial_number': 'B5120B',
                                             'system_mac_address': None},
                '60:db:98:8f:02:05': {       'dev_macs': [       '84:d3:43:0f:ba:36',
                                                                 '5c:0f:fb:17:69:9d'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8f:02:05',
                                             'name': '273 QUEEN STREET ATWOOD',
                                             'serial_number': 'B5121B',
                                             'system_mac_address': None},
                '84:d3:43:7c:e3:b7': {       'dev_macs': ['44:65:7f:88:cc:01'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7c:e3:b7',
                                             'name': '251 MAIN STREET ATWOOD',
                                             'serial_number': 'C811E0',
                                             'system_mac_address': None},
                '84:d3:43:7d:04:3f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:04:3f',
                                             'name': '165 MAIN STREET ATWOOD',
                                             'serial_number': 'C815F1',
                                             'system_mac_address': None},
                '84:d3:43:7d:1d:57': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:1d:57',
                                             'name': '354 MAIN STREET ATWOOD',
                                             'serial_number': 'C81914',
                                             'system_mac_address': None},
                '84:d3:43:7d:36:97': {       'dev_macs': ['54:af:97:59:9d:c0'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:36:97',
                                             'name': '280 MCCOURT PLACE',
                                             'serial_number': 'C81C3C',
                                             'system_mac_address': None},
                '84:d3:43:7d:36:af': {       'dev_macs': ['ec:4f:82:ac:d0:1d'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:36:af',
                                             'name': '252 King St. Atwood',
                                             'serial_number': 'C81C3F',
                                             'system_mac_address': None},
                '84:d3:43:7d:38:8f': {       'dev_macs': ['b8:94:70:bc:c5:74'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:38:8f',
                                             'name': '133 GEORGE AVENUE ATWOOD',
                                             'serial_number': 'C81C7B',
                                             'system_mac_address': None},
                '84:d3:43:7d:3a:a7': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:3a:a7',
                                             'name': '150 MONUMENT RD',
                                             'serial_number': 'C81CBE',
                                             'system_mac_address': None},
                '84:d3:43:7d:40:2f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:40:2f',
                                             'name': '269 MAIN STREET ATWOOD',
                                             'serial_number': 'C81D6F',
                                             'system_mac_address': None},
                '84:d3:43:7d:42:6f': {       'dev_macs': ['d0:76:8f:02:f5:e2'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:42:6f',
                                             'name': '137 QUEEN STREET ATWOOD',
                                             'serial_number': 'C81DB7',
                                             'system_mac_address': None},
                '84:d3:43:7d:43:37': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:43:37',
                                             'name': '7444 ROAD 164',
                                             'serial_number': 'C81DD0',
                                             'system_mac_address': None},
                '84:d3:43:7d:43:47': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:43:47',
                                             'name': '153 King St. Atwood',
                                             'serial_number': 'C81DD2',
                                             'system_mac_address': None},
                '84:d3:43:7d:43:8f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:43:8f',
                                             'name': '219 KING STREET ATWOOD',
                                             'serial_number': 'C81DDB',
                                             'system_mac_address': None},
                '84:d3:43:7d:44:bf': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:44:bf',
                                             'name': '135 FISHER AV',
                                             'serial_number': 'C81E01',
                                             'system_mac_address': None},
                '84:d3:43:7d:46:37': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:46:37',
                                             'name': '278 MAIN STREET ATWOOD',
                                             'serial_number': 'C81E30',
                                             'system_mac_address': None},
                '84:d3:43:7d:46:af': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:46:af',
                                             'name': '145 ARTHUR STREET E ATWOOD',
                                             'serial_number': 'C81E3F',
                                             'system_mac_address': None},
                '84:d3:43:7d:4e:c7': {       'dev_macs': ['60:db:98:09:1b:d8'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:4e:c7',
                                             'name': '216 King St. Atwood',
                                             'serial_number': 'C81F42',
                                             'system_mac_address': None},
                '84:d3:43:7d:5e:3f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:5e:3f',
                                             'name': '143 MONUMENT RD',
                                             'serial_number': 'C82131',
                                             'system_mac_address': None},
                '84:d3:43:7d:d9:4f': {       'dev_macs': ['cc:be:59:c3:46:dc'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:d9:4f',
                                             'name': '205 Queen St. Atwood',
                                             'serial_number': 'C83093',
                                             'system_mac_address': None},
                '84:d3:43:7d:e5:47': {       'dev_macs': ['ac:9e:17:e1:df:fc'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:e5:47',
                                             'name': '189 Main St. Atwood',
                                             'serial_number': 'C83212',
                                             'system_mac_address': None},
                '84:d3:43:7e:15:87': {       'dev_macs': ['60:db:98:09:1c:bf'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:15:87',
                                             'name': '257 KING STREET ATWOOD',
                                             'serial_number': 'C8381A',
                                             'system_mac_address': None},
                '84:d3:43:7e:30:27': {       'dev_macs': ['60:db:98:09:39:52'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:30:27',
                                             'name': '171 KING STREET ATWOOD',
                                             'serial_number': 'C83B6E',
                                             'system_mac_address': None},
                '84:d3:43:7e:30:d7': {       'dev_macs': [       '00:1a:79:77:d4:ba',
                                                                 'd0:76:8f:02:ed:34',
                                                                 '5c:0f:fb:15:8d:44'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:30:d7',
                                             'name': '280 QUEEN STREET ATWOOD',
                                             'serial_number': 'C83B84',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:6f': {       'dev_macs': ['60:db:98:55:b5:a4'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:6f',
                                             'name': '113 MONUMENT RD',
                                             'serial_number': 'C83B97',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:77': {       'dev_macs': ['ec:4f:82:a5:05:2c'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:77',
                                             'name': 'RIKI DOIG',
                                             'serial_number': 'C83B98',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:97': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:97',
                                             'name': '291 WOODVIEW DR',
                                             'serial_number': 'C83B9C',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:cf': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:cf',
                                             'name': '160 JOHN STREET ATWOOD',
                                             'serial_number': 'C83BA3',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:0f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:0f',
                                             'name': '158 KING STREET',
                                             'serial_number': 'C83BAB',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:27': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:27',
                                             'name': '196 MAIN STREET ATWOOD',
                                             'serial_number': 'C83BAE',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:37': {       'dev_macs': ['54:99:63:a4:94:0a'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:37',
                                             'name': '129 Bowman Ct',
                                             'serial_number': 'C83BB0',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:8f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:8f',
                                             'name': '131 MAIN STREET ATWOOD',
                                             'serial_number': 'C83BBB',
                                             'system_mac_address': None},
                '84:d3:43:7e:33:17': {       'dev_macs': [       'f8:85:f9:a3:99:14',
                                                                 '5c:0f:fb:14:3b:f8',
                                                                 '5c:0f:fb:17:6c:3b'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:33:17',
                                             'name': '204 ELLEN ST',
                                             'serial_number': 'C83BCC',
                                             'system_mac_address': None},
                '84:d3:43:7e:33:87': {       'dev_macs': ['60:db:98:09:39:d6'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:33:87',
                                             'name': '273 WOODVIEW DR',
                                             'serial_number': 'C83BDA',
                                             'system_mac_address': None},
                '84:d3:43:7e:34:4f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:34:4f',
                                             'name': '171 James St. Atwood',
                                             'serial_number': 'C83BF3',
                                             'system_mac_address': None},
                '84:d3:43:7e:35:17': {       'dev_macs': ['ec:ce:13:54:1e:99'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:35:17',
                                             'name': '235 MAIN STREET ATWOOD',
                                             'serial_number': 'C83C0C',
                                             'system_mac_address': None},
                '84:d3:43:7e:45:07': {       'dev_macs': ['d0:76:8f:91:d3:f6'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:45:07',
                                             'name': '164 King Street Atwood',
                                             'serial_number': 'C83E0A',
                                             'system_mac_address': None},
                '84:d3:43:95:93:da': {       'dev_macs': [       'd0:76:8f:02:ed:ef',
                                                                 '00:03:e6:a2:18:68',
                                                                 '00:03:e6:da:ba:b7'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:95:93:da',
                                             'name': '280 WOODVIEW DR.',
                                             'serial_number': 'CBD29A',
                                             'system_mac_address': None},
                '84:d3:43:96:01:9a': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:96:01:9a',
                                             'name': '7452 ROAD 164',
                                             'serial_number': 'CBE052',
                                             'system_mac_address': None},
                'b8:94:70:ba:e1:a5': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e1:a5',
                                             'name': 'BUCHANAN JEFF & CATHY',
                                             'serial_number': '1195149',
                                             'system_mac_address': None},
                'b8:94:70:ba:e1:e5': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e1:e5',
                                             'name': '127 MONUMENT RD',
                                             'serial_number': '1195151',
                                             'system_mac_address': None},
                'b8:94:70:ba:e2:35': {       'dev_macs': [       '04:bc:9f:46:8f:4c',
                                                                 '5c:0f:fb:15:5a:4a',
                                                                 '5c:0f:fb:24:54:8a',
                                                                 '5c:0f:fb:2f:d0:cd'],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e2:35',
                                             'name': '163 KING ST ATWOOD',
                                             'serial_number': '119515B',
                                             'system_mac_address': None},
                'b8:94:70:ba:e4:a5': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e4:a5',
                                             'name': '134 MAIN STREET ATWOOD',
                                             'serial_number': '11951A9',
                                             'system_mac_address': None},
                'b8:94:70:c6:e9:57': {       'dev_macs': ['04:bc:9f:46:91:25'],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:c6:e9:57',
                                             'name': '159 FISHER AV',
                                             'serial_number': '11B2235',
                                             'system_mac_address': None},
                'b8:94:70:c6:ed:97': {       'dev_macs': ['cc:be:59:2d:a9:af'],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:c6:ed:97',
                                             'name': '179 MAIN STREET ATWOOD',
                                             'serial_number': '11B22BD',
                                             'system_mac_address': None},
                'b8:94:70:c7:04:f7': {       'dev_macs': ['04:bc:9f:46:92:b1'],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:c7:04:f7',
                                             'name': '210 QUEEN STREET ATWOOD',
                                             'serial_number': '11B25A9',
                                             'system_mac_address': None},
                'cc:be:59:04:29:90': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:04:29:90',
                                             'name': '7430 Rd. 164 Atwood',
                                             'serial_number': '3EBA19',
                                             'system_mac_address': None},
                'cc:be:59:04:2b:60': {       'dev_macs': ['ec:4f:82:ad:0e:69'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:04:2b:60',
                                             'name': '222B Main St. Lower',
                                             'serial_number': '3EBA53',
                                             'system_mac_address': None},
                'cc:be:59:0c:b5:b4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0c:b5:b4',
                                             'name': '202 MAIN STREET ATWOOD',
                                             'serial_number': '3ADD6E',
                                             'system_mac_address': None},
                'cc:be:59:0c:b5:cc': {       'dev_macs': [       'cc:be:59:2d:a5:ec',
                                                                 '00:03:e6:31:3f:30'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0c:b5:cc',
                                             'name': '189 King St. Atwood',
                                             'serial_number': '3ADD71',
                                             'system_mac_address': None},
                'cc:be:59:0d:27:04': {       'dev_macs': ['b4:0f:3b:8a:b5:09'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:27:04',
                                             'name': '214 MAIN STREET ATWOOD',
                                             'serial_number': '3AEB98',
                                             'system_mac_address': None},
                'cc:be:59:0d:27:f4': {       'dev_macs': ['ec:4f:82:a8:83:a7'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:27:f4',
                                             'name': '143 James St. Atwood',
                                             'serial_number': '3AEBB6',
                                             'system_mac_address': None},
                'cc:be:59:0d:28:2c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:28:2c',
                                             'name': '275 WOODVIEW DR',
                                             'serial_number': '3AEBBD',
                                             'system_mac_address': None},
                'cc:be:59:0d:28:44': {       'dev_macs': [       'b8:94:70:bc:b8:17',
                                                                 '5c:0f:fb:2f:cd:35'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:28:44',
                                             'name': '141 BOWMAN CT',
                                             'serial_number': '3AEBC0',
                                             'system_mac_address': None},
                'cc:be:59:0d:28:84': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:28:84',
                                             'name': '112 BLAIR ST',
                                             'serial_number': '3AEBC8',
                                             'system_mac_address': None},
                'cc:be:59:0d:2b:3c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:2b:3c',
                                             'name': '189 Ellen St. Atwood',
                                             'serial_number': '3AEC1F',
                                             'system_mac_address': None},
                'cc:be:59:0d:2b:4c': {       'dev_macs': ['60:db:98:09:3b:af'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:2b:4c',
                                             'name': '240 WOODVIEW DR',
                                             'serial_number': '3AEC21',
                                             'system_mac_address': None},
                'cc:be:59:2b:a9:47': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:2b:a9:47',
                                             'name': '123 Main St. N. Atwood',
                                             'serial_number': '3FB35D',
                                             'system_mac_address': None},
                'cc:be:59:46:c9:cf': {       'dev_macs': ['3c:97:0e:5c:68:9b'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:46:c9:cf',
                                             'name': '246 King St. Atwood',
                                             'serial_number': '39507A',
                                             'system_mac_address': None},
                'cc:be:59:47:32:bf': {       'dev_macs': ['9c:3d:cf:f0:22:48'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:47:32:bf',
                                             'name': '169 James St. Atwood',
                                             'serial_number': '433E5F',
                                             'system_mac_address': None},
                'cc:be:59:50:17:31': {       'dev_macs': ['cc:be:59:2f:2d:99'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:50:17:31',
                                             'name': '163 Fisher Ave Atwood',
                                             'serial_number': '43C21A',
                                             'system_mac_address': None},
                'cc:be:59:50:17:95': {       'dev_macs': ['38:d5:47:c5:be:68'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:50:17:95',
                                             'name': '202 Ellen St Atwood',
                                             'serial_number': '43C24C',
                                             'system_mac_address': None},
                'cc:be:59:50:1a:b7': {       'dev_macs': ['cc:be:59:2d:a8:7d'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:50:1a:b7',
                                             'name': '155 Queen St Atwood',
                                             'serial_number': '43C3DD',
                                             'system_mac_address': None},
                'cc:be:59:52:6d:37': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:52:6d:37',
                                             'name': '7306 Rd 164 Atwood',
                                             'serial_number': '3FC3C2',
                                             'system_mac_address': None},
                'cc:be:59:5f:16:62': {       'dev_macs': ['60:db:98:59:a4:87'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:5f:16:62',
                                             'name': '104 MONUMENT RD',
                                             'serial_number': '455673',
                                             'system_mac_address': None},
                'cc:be:59:6a:dd:5e': {       'dev_macs': [       '74:ea:3a:a7:d7:05',
                                                                 'd8:07:b6:e3:1e:1f'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6a:dd:5e',
                                             'name': '182 Ellen St. Atwood',
                                             'serial_number': '46CE0A',
                                             'system_mac_address': None},
                'cc:be:59:6d:3d:5e': {       'dev_macs': ['20:aa:4b:72:5d:90'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:3d:5e',
                                             'name': '130 John St. Atwood',
                                             'serial_number': '3FFFE3',
                                             'system_mac_address': None},
                'cc:be:59:6d:5a:be': {       'dev_macs': ['78:32:1b:41:9b:28'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:5a:be',
                                             'name': '129 King St. Atwood',
                                             'serial_number': '40038F',
                                             'system_mac_address': None},
                'cc:be:59:6d:5c:e6': {       'dev_macs': ['f0:2f:74:e9:8a:30'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:5c:e6',
                                             'name': '151 King St. Atwood',
                                             'serial_number': '4003D4',
                                             'system_mac_address': None},
                'cc:be:59:6d:60:ee': {       'dev_macs': ['10:7b:44:3f:13:74'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:60:ee',
                                             'name': '148 King St. Atwood',
                                             'serial_number': '400455',
                                             'system_mac_address': None},
                'cc:be:59:6d:7e:3e': {       'dev_macs': ['d0:76:8f:1f:58:38'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:7e:3e',
                                             'name': '208 KING STREET ATWOOD',
                                             'serial_number': '4007FF',
                                             'system_mac_address': None},
                'cc:be:59:6d:85:26': {       'dev_macs': [       '60:db:98:09:1b:ac',
                                                                 '00:03:e6:f0:ee:34',
                                                                 '00:03:e6:f0:fa:ee',
                                                                 '5c:0f:fb:2f:ca:9b'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:85:26',
                                             'name': '279 WOODVIEW DR',
                                             'serial_number': '4008DC',
                                             'system_mac_address': None},
                'cc:be:59:6d:b9:be': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:b9:be',
                                             'name': '233 Woodview Dr. Atwood',
                                             'serial_number': '400F64',
                                             'system_mac_address': None},
                'cc:be:59:6d:e8:d6': {       'dev_macs': ['60:63:4c:62:8e:f6'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:e8:d6',
                                             'name': '254 Queen St. Atwood',
                                             'serial_number': '4703AF',
                                             'system_mac_address': None},
                'cc:be:59:6e:14:ca': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6e:14:ca',
                                             'name': '135 Queen St. Atwood',
                                             'serial_number': '47092C',
                                             'system_mac_address': None},
                'cc:be:59:6e:6e:da': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6e:6e:da',
                                             'name': '256 Main St. Atwood',
                                             'serial_number': '47146E',
                                             'system_mac_address': None},
                'cc:be:59:6e:ae:96': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6e:ae:96',
                                             'name': '186 MAIN STREET',
                                             'serial_number': '471C63',
                                             'system_mac_address': None},
                'cc:be:59:6f:1d:c2': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:1d:c2',
                                             'name': '250 MAIN STREET ATWOOD',
                                             'serial_number': '55DFB1',
                                             'system_mac_address': None},
                'cc:be:59:6f:29:52': {       'dev_macs': ['e0:1c:fc:80:86:fc'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:29:52',
                                             'name': '146 Monument Rd',
                                             'serial_number': '55E123',
                                             'system_mac_address': None},
                'cc:be:59:6f:74:d2': {       'dev_macs': ['44:65:7f:41:8d:d9'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:74:d2',
                                             'name': '186 Ellen St. Atwood',
                                             'serial_number': '55EA90',
                                             'system_mac_address': None},
                'cc:be:59:6f:fd:92': {       'dev_macs': ['00:0e:c6:80:85:24'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:fd:92',
                                             'name': '154 Monument Rd',
                                             'serial_number': '55FBA5',
                                             'system_mac_address': None},
                'cc:be:59:6f:ff:1a': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:ff:1a',
                                             'name': '208 Main St. Atwood',
                                             'serial_number': '55FBD6',
                                             'system_mac_address': None},
                'cc:be:59:70:33:7e': {       'dev_macs': [       'a8:63:7d:7a:84:91',
                                                                 '78:32:1b:6e:4d:d6'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:70:33:7e',
                                             'name': '220 MAIN STREET ATWOOD',
                                             'serial_number': '560262',
                                             'system_mac_address': None},
                'cc:be:59:70:33:86': {       'dev_macs': ['ec:4f:82:2d:61:e1'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:70:33:86',
                                             'name': '7436 Rd. 164 Atwood',
                                             'serial_number': '560263',
                                             'system_mac_address': None},
                'cc:be:59:70:81:36': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:70:81:36',
                                             'name': '7446 ROAD 164',
                                             'serial_number': '560C19',
                                             'system_mac_address': None},
                'cc:be:59:af:a5:9b': {       'dev_macs': ['60:db:98:09:3b:20'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:af:a5:9b',
                                             'name': '137 MAIN STREET ATWOOD',
                                             'serial_number': '4E36A8',
                                             'system_mac_address': None},
                'cc:be:59:af:d8:7b': {       'dev_macs': ['68:ff:7b:32:2b:d1'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:af:d8:7b',
                                             'name': '62 PARKVIEW CR',
                                             'serial_number': '4E3D04',
                                             'system_mac_address': None},
                'cc:be:59:b3:7c:9b': {       'dev_macs': ['c8:4f:86:1b:44:8f'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:b3:7c:9b',
                                             'name': '269 Main St. Atwood',
                                             'serial_number': '4EB17D',
                                             'system_mac_address': None},
                'cc:be:59:b7:3b:67': {       'dev_macs': ['ec:08:6b:5a:b4:e1'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:b7:3b:67',
                                             'name': '253 Queen St.',
                                             'serial_number': '4D111F',
                                             'system_mac_address': None},
                'cc:be:59:ca:db:7a': {       'dev_macs': ['44:65:7f:37:fe:45'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ca:db:7a',
                                             'name': '129 James St. Atwood',
                                             'serial_number': '42816E',
                                             'system_mac_address': None},
                'cc:be:59:ca:dc:92': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ca:dc:92',
                                             'name': '164 FISHER AV',
                                             'serial_number': '428191',
                                             'system_mac_address': None},
                'cc:be:59:ca:de:8a': {       'dev_macs': ['cc:be:59:c3:47:d8'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ca:de:8a',
                                             'name': '145 Queen St Atwood',
                                             'serial_number': '4281D0',
                                             'system_mac_address': None},
                'cc:be:59:cb:43:da': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:43:da',
                                             'name': '261 King St Atwood',
                                             'serial_number': '42B9D3',
                                             'system_mac_address': None},
                'cc:be:59:cb:44:72': {       'dev_macs': ['44:65:7f:37:fd:64'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:44:72',
                                             'name': '7464 Rd 164 Atwood',
                                             'serial_number': '42B9E6',
                                             'system_mac_address': None},
                'cc:be:59:cb:6c:5a': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:6c:5a',
                                             'name': '272 McCourt Place Atwood',
                                             'serial_number': '42BEE3',
                                             'system_mac_address': None},
                'cc:be:59:cb:7e:02': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:7e:02',
                                             'name': '275 MCCOURT PL',
                                             'serial_number': '42C118',
                                             'system_mac_address': None},
                'cc:be:59:cb:95:e2': {       'dev_macs': [       '44:65:7f:37:fe:21',
                                                                 '00:03:e6:a2:75:ce',
                                                                 '00:03:e6:da:2f:b7'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:95:e2',
                                             'name': '167 Queen St, Atwood',
                                             'serial_number': '42C414',
                                             'system_mac_address': None},
                'cc:be:59:cb:bb:ba': {       'dev_macs': ['b8:94:70:bc:c3:f3'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:bb:ba',
                                             'name': '98 ELMA CENTRE ST',
                                             'serial_number': '42C8CF',
                                             'system_mac_address': None},
                'cc:be:59:cb:bd:12': {       'dev_macs': ['cc:be:59:2d:a9:94'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:bd:12',
                                             'name': '94 Elma Centre Atwood',
                                             'serial_number': '42C8FA',
                                             'system_mac_address': None},
                'cc:be:59:cb:bf:3a': {       'dev_macs': ['cc:be:59:c3:c8:f0'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:bf:3a',
                                             'name': '273 McCourt Pl Atwood',
                                             'serial_number': '42C93F',
                                             'system_mac_address': None},
                'cc:be:59:cb:ea:02': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:ea:02',
                                             'name': '7426 Road 164 Atwood',
                                             'serial_number': '42CE98',
                                             'system_mac_address': None},
                'cc:be:59:cc:03:2a': {       'dev_macs': ['14:59:c0:c0:f0:6d'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:03:2a',
                                             'name': '182 King St Atwood',
                                             'serial_number': '42D1BD',
                                             'system_mac_address': None},
                'cc:be:59:cc:0b:1a': {       'dev_macs': ['44:65:7f:3e:ab:7f'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:0b:1a',
                                             'name': '155 Fischer Ave Atwood',
                                             'serial_number': '42D2BB',
                                             'system_mac_address': None},
                'cc:be:59:cc:11:3a': {       'dev_macs': ['44:65:7f:88:45:be'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:11:3a',
                                             'name': '134 King St Atwood',
                                             'serial_number': '42D37F',
                                             'system_mac_address': None},
                'cc:be:59:cc:11:ba': {       'dev_macs': ['48:77:46:9a:55:a1'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:11:ba',
                                             'name': '187 King St Atwood',
                                             'serial_number': '42D38F',
                                             'system_mac_address': None},
                'cc:be:59:eb:39:ae': {       'dev_macs': ['3c:7c:3f:cb:7b:60'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:39:ae',
                                             'name': '154 King St. Atwood',
                                             'serial_number': '5563AB',
                                             'system_mac_address': None},
                'cc:be:59:eb:39:be': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:39:be',
                                             'name': '7456 ROAD 164',
                                             'serial_number': '5563AD',
                                             'system_mac_address': None},
                'cc:be:59:eb:3a:06': {       'dev_macs': ['74:ea:3a:a1:63:97'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3a:06',
                                             'name': '190 Ellen St. Atwood',
                                             'serial_number': '5563B6',
                                             'system_mac_address': None},
                'cc:be:59:eb:3a:de': {       'dev_macs': ['cc:be:59:32:9a:92'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3a:de',
                                             'name': '167 John St. Atwood',
                                             'serial_number': '5563D1',
                                             'system_mac_address': None},
                'cc:be:59:eb:3a:ee': {       'dev_macs': ['70:4f:57:be:6c:6c'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3a:ee',
                                             'name': '205 Ellen St. Atwood',
                                             'serial_number': '5563D3',
                                             'system_mac_address': None},
                'cc:be:59:eb:3b:d6': {       'dev_macs': ['d0:76:8f:02:f3:17'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3b:d6',
                                             'name': '171 QUEEN STREET ATWOOD',
                                             'serial_number': '5563F0',
                                             'system_mac_address': None},
                'cc:be:59:ef:f4:de': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f4:de',
                                             'name': '106 BLAIR ST',
                                             'serial_number': '4D41EE',
                                             'system_mac_address': None},
                'cc:be:59:ef:f5:0e': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f5:0e',
                                             'name': '207 Main St. Atwood',
                                             'serial_number': '4D41F4',
                                             'system_mac_address': None},
                'cc:be:59:ef:f5:16': {       'dev_macs': ['cc:be:59:c3:c8:06'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f5:16',
                                             'name': '283 Woodview Dr. Atwood',
                                             'serial_number': '4D41F5',
                                             'system_mac_address': None},
                'cc:be:59:ef:f5:26': {       'dev_macs': ['c4:41:1e:a9:9e:28'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f5:26',
                                             'name': '170 King St. Atwood',
                                             'serial_number': '4D41F7',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:56': {       'dev_macs': ['d0:76:8f:1f:55:36'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:56',
                                             'name': '169 King St. Atwood',
                                             'serial_number': '4D423D',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:7e': {       'dev_macs': ['f8:e9:03:b8:be:91'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:7e',
                                             'name': '204 King St. Atwood',
                                             'serial_number': '4D4242',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:d6': {       'dev_macs': ['bc:0f:9a:77:c2:bd'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:d6',
                                             'name': '217 Queen St. Atwood',
                                             'serial_number': '4D424D',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:e6': {       'dev_macs': ['d0:76:8f:1f:54:c8'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:e6',
                                             'name': '127 KING STREET ATWOOD',
                                             'serial_number': '4D424F',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:ee': {       'dev_macs': ['70:4c:a5:6e:2c:96'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:ee',
                                             'name': '5972 Perth Line 72',
                                             'serial_number': '4D4250',
                                             'system_mac_address': None},
                'd0:76:8f:06:e5:fe': {       'dev_macs': ['60:32:b1:41:b1:b1'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:06:e5:fe',
                                             'name': '165 JOHN STREET ATWOOD',
                                             'serial_number': '844BE5',
                                             'system_mac_address': None},
                'd0:76:8f:07:19:91': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:07:19:91',
                                             'name': '170 Main St. Unit B',
                                             'serial_number': '8678B6',
                                             'system_mac_address': None},
                'd0:76:8f:08:14:ab': {       'dev_macs': ['84:d3:43:0f:bc:5c'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:14:ab',
                                             'name': '119 PARKVIEW CR',
                                             'serial_number': '86938B',
                                             'system_mac_address': None},
                'd0:76:8f:08:15:33': {       'dev_macs': [       'd0:76:8f:02:ef:5a',
                                                                 '00:03:e6:dd:2e:f3',
                                                                 '00:03:e6:dd:31:31',
                                                                 '00:03:e6:dd:32:0c'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:15:33',
                                             'name': '236 WOODVIEW DR',
                                             'serial_number': '86939C',
                                             'system_mac_address': None},
                'd0:76:8f:08:16:83': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:16:83',
                                             'name': '135 KING STREET ATWOOD',
                                             'serial_number': '8693C6',
                                             'system_mac_address': None},
                'd0:76:8f:08:17:4b': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:17:4b',
                                             'name': '215 QUEEN STREET ATWOOD',
                                             'serial_number': '8693DF',
                                             'system_mac_address': None},
                'd0:76:8f:08:18:33': {       'dev_macs': ['d0:76:8f:1f:64:40'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:18:33',
                                             'name': '276 MCCOURT PL',
                                             'serial_number': '8693FC',
                                             'system_mac_address': None},
                'd0:76:8f:08:19:1b': {       'dev_macs': ['68:9c:e2:a1:d4:22'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:19:1b',
                                             'name': '7495 ROAD 164',
                                             'serial_number': '869419',
                                             'system_mac_address': None},
                'd0:76:8f:1b:9e:6b': {       'dev_macs': ['cc:be:59:32:94:2c'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:9e:6b',
                                             'name': '138 Main St Atwood',
                                             'serial_number': '87241B',
                                             'system_mac_address': None},
                'd0:76:8f:1b:9e:bb': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:9e:bb',
                                             'name': '241 WOODVIEW DR',
                                             'serial_number': '872425',
                                             'system_mac_address': None},
                'd0:76:8f:1b:9e:e3': {       'dev_macs': ['cc:be:59:32:95:f7'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:9e:e3',
                                             'name': '166 FISHER AV',
                                             'serial_number': '87242A',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a0:83': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a0:83',
                                             'name': '265 Queen St. Atwood',
                                             'serial_number': '87245E',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a1:13': {       'dev_macs': ['ec:08:6b:46:40:b9'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a1:13',
                                             'name': '7497 Rd. 164 Atwood',
                                             'serial_number': '872470',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a1:1b': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a1:1b',
                                             'name': '124 MAIN STREET ATWOOD',
                                             'serial_number': '872471',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a5:73': {       'dev_macs': ['ec:4f:82:2b:47:52'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a5:73',
                                             'name': '202 Queen St. Atwood',
                                             'serial_number': '8724FC',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a7:3b': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a7:3b',
                                             'name': '155 Main St. Atwood',
                                             'serial_number': '872535',
                                             'system_mac_address': None},
                'd0:76:8f:a9:53:88': {       'dev_macs': ['d0:76:8f:1f:61:b7'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:a9:53:88',
                                             'name': '162 FISHER AV',
                                             'serial_number': '954F45',
                                             'system_mac_address': None},
                'd0:76:8f:aa:4e:f4': {       'dev_macs': ['d0:76:8f:91:d2:6a'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:4e:f4',
                                             'name': '139 MONUMENT RD ATWOOD',
                                             'serial_number': '956F04',
                                             'system_mac_address': None},
                'd0:76:8f:aa:4f:e4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:4f:e4',
                                             'name': '222 King St. Atwood',
                                             'serial_number': '956F22',
                                             'system_mac_address': None},
                'd0:76:8f:aa:50:04': {       'dev_macs': [       'd0:76:8f:02:f1:d8',
                                                                 '00:03:e6:db:aa:5d',
                                                                 '00:03:e6:dd:46:d3'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:50:04',
                                             'name': '166 MAIN ST ATWOOD',
                                             'serial_number': '956F26',
                                             'system_mac_address': None},
                'd0:76:8f:aa:54:0c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:54:0c',
                                             'name': '100 ARTHUR ST EAST ATWOOD',
                                             'serial_number': '956FA7',
                                             'system_mac_address': None},
                'ec:4f:82:02:06:79': {       'dev_macs': ['d8:50:e6:d6:6f:cc'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:02:06:79',
                                             'name': '91 Arthur St. Atwood',
                                             'serial_number': '1F7DA1',
                                             'system_mac_address': None},
                'ec:4f:82:08:2e:cd': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:08:2e:cd',
                                             'name': '112 Arthur Street, Atwood',
                                             'serial_number': '1C5DCF',
                                             'system_mac_address': None},
                'ec:4f:82:32:25:97': {       'dev_macs': [       'cc:be:59:c3:c8:45',
                                                                 '00:03:e6:a5:70:b1'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:25:97',
                                             'name': '256 Woodview Dr.',
                                             'serial_number': '248AC3',
                                             'system_mac_address': None},
                'ec:4f:82:32:25:af': {       'dev_macs': ['ec:4f:82:ac:ec:2b'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:25:af',
                                             'name': '274 Woodview Dr. Atwood',
                                             'serial_number': '248AC6',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:0f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:0f',
                                             'name': '194 Queen St. Atwood',
                                             'serial_number': '248AD2',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:37': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:37',
                                             'name': '215 Main St. Atwood',
                                             'serial_number': '248AD7',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:97': {       'dev_macs': ['ec:4f:82:a5:13:d5'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:97',
                                             'name': '144 King St. Atwood',
                                             'serial_number': '248AE3',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:af': {       'dev_macs': ['d0:76:8f:1f:5f:44'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:af',
                                             'name': '209 Main St. Atwood',
                                             'serial_number': '248AE6',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:cf': {       'dev_macs': [       '24:4b:fe:1e:92:58',
                                                                 '00:03:e6:9b:3b:f8'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:cf',
                                             'name': '129 Parkview Cr. Atwood',
                                             'serial_number': '248AEA',
                                             'system_mac_address': None},
                'ec:4f:82:32:27:1f': {       'dev_macs': ['b8:94:70:f3:e4:40'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:27:1f',
                                             'name': '193 ELLEN  ST',
                                             'serial_number': '248AF4',
                                             'system_mac_address': None},
                'ec:4f:82:33:d5:0f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:33:d5:0f',
                                             'name': '157 Monument Rd',
                                             'serial_number': '1FC4EF',
                                             'system_mac_address': None},
                'ec:4f:82:44:18:1f': {       'dev_macs': ['cc:be:59:c3:c2:54'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:44:18:1f',
                                             'name': '194 KING STREET ATWOOD',
                                             'serial_number': '23A003',
                                             'system_mac_address': None},
                'ec:4f:82:4c:a5:67': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:4c:a5:67',
                                             'name': '147 KING STREET ATWOOD',
                                             'serial_number': '25B5F9',
                                             'system_mac_address': None},
                'ec:4f:82:59:55:07': {       'dev_macs': ['98:ed:7e:e2:f9:00'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:59:55:07',
                                             'name': '287 WOODVIEW DR',
                                             'serial_number': '2AA878',
                                             'system_mac_address': None},
                'ec:4f:82:59:5b:77': {       'dev_macs': ['14:59:c0:4e:56:a7'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:59:5b:77',
                                             'name': '252 Woodview Dr. Atwood',
                                             'serial_number': '2AA946',
                                             'system_mac_address': None},
                'ec:4f:82:67:6d:cd': {       'dev_macs': ['ec:4f:82:2a:b0:02'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:67:6d:cd',
                                             'name': '217 KING STREET ATWOOD',
                                             'serial_number': '25D8AE',
                                             'system_mac_address': None},
                'ec:4f:82:67:71:b5': {       'dev_macs': ['30:de:4b:ee:0c:42'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:67:71:b5',
                                             'name': '237 WOODVIEW DR',
                                             'serial_number': '25D92B',
                                             'system_mac_address': None},
                'ec:4f:82:67:71:fd': {       'dev_macs': ['90:9a:4a:80:de:2b'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:67:71:fd',
                                             'name': '136 MONUMENT RD',
                                             'serial_number': '25D934',
                                             'system_mac_address': None},
                'ec:4f:82:7a:23:67': {       'dev_macs': ['a8:5e:45:77:90:9c'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:7a:23:67',
                                             'name': '165 Fisher Ave',
                                             'serial_number': '2F3AD9',
                                             'system_mac_address': None},
                'ec:4f:82:8d:3f:60': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:3f:60',
                                             'name': '154 Main St. Atwood',
                                             'serial_number': '321033',
                                             'system_mac_address': None},
                'ec:4f:82:8d:4b:60': {       'dev_macs': [       'b0:e4:d5:25:60:b8',
                                                                 'b0:e4:d5:53:dc:d4'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:4b:60',
                                             'name': '256 KING STREET ATWOOD',
                                             'serial_number': '3211B3',
                                             'system_mac_address': None},
                'ec:4f:82:8d:76:88': {       'dev_macs': ['cc:be:59:2f:2d:51'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:76:88',
                                             'name': '98 Parkview Cr Atwood',
                                             'serial_number': '321718',
                                             'system_mac_address': None},
                'ec:4f:82:8d:7a:d8': {       'dev_macs': ['cc:be:59:2f:2d:d8'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:7a:d8',
                                             'name': '162 Queen St Atwood',
                                             'serial_number': '3217A2',
                                             'system_mac_address': None},
                'ec:4f:82:8d:7c:18': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:7c:18',
                                             'name': '159 John St',
                                             'serial_number': '3217CA',
                                             'system_mac_address': None},
                'ec:4f:82:8d:88:88': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:88:88',
                                             'name': '145 Bowman Ct. Atwwod',
                                             'serial_number': '321958',
                                             'system_mac_address': None},
                'ec:4f:82:8d:dc:60': {       'dev_macs': [       '48:77:46:f8:b1:52',
                                                                 '00:03:e6:a2:18:14',
                                                                 '00:03:e6:da:34:39',
                                                                 '00:03:e6:da:35:7f'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:dc:60',
                                             'name': '157 Fisher Ave Atwood',
                                             'serial_number': '3223D3',
                                             'system_mac_address': None},
                'ec:4f:82:8d:dd:90': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:dd:90',
                                             'name': '211 Main St Atwood',
                                             'serial_number': '3223F9',
                                             'system_mac_address': None},
                'ec:4f:82:8e:00:f0': {       'dev_macs': ['50:91:e3:bc:40:14'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8e:00:f0',
                                             'name': '123 PARKVIEW CR',
                                             'serial_number': '322865',
                                             'system_mac_address': None},
                'ec:4f:82:8e:05:d0': {       'dev_macs': ['cc:be:59:2d:a8:6b'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8e:05:d0',
                                             'name': '124 Queen St Atwood',
                                             'serial_number': '322901',
                                             'system_mac_address': None},
                'ec:4f:82:92:f6:18': {       'dev_macs': ['e4:6f:13:fa:d2:a7'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:f6:18',
                                             'name': '216A Main St. Atwood',
                                             'serial_number': '32954F',
                                             'system_mac_address': None},
                'ec:4f:82:92:fa:80': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fa:80',
                                             'name': '132 BOWMAN CT',
                                             'serial_number': '3295DC',
                                             'system_mac_address': None},
                'ec:4f:82:92:fd:50': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fd:50',
                                             'name': '158 James St. Atwood',
                                             'serial_number': '329636',
                                             'system_mac_address': None},
                'ec:4f:82:92:fd:68': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fd:68',
                                             'name': '272 Main St. Atwood',
                                             'serial_number': '329639',
                                             'system_mac_address': None},
                'ec:4f:82:92:fd:80': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fd:80',
                                             'name': '94 Baker St. Atwood',
                                             'serial_number': '32963C',
                                             'system_mac_address': None},
                'ec:4f:82:92:fd:b0': {       'dev_macs': ['d0:76:8f:02:f4:61'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fd:b0',
                                             'name': '167 MAIN STREET ATWOOD',
                                             'serial_number': '329642',
                                             'system_mac_address': None},
                'ec:4f:82:9b:b6:b4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:9b:b6:b4',
                                             'name': '266 Woodview Dr. Atwood',
                                             'serial_number': '33AD09',
                                             'system_mac_address': None},
                'ec:4f:82:9c:fa:6c': {       'dev_macs': ['60:db:98:57:a7:59'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:9c:fa:6c',
                                             'name': '156 QUEEN STREET ATWOOD',
                                             'serial_number': '33D580',
                                             'system_mac_address': None},
                'ec:4f:82:a2:ae:49': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:a2:ae:49',
                                             'name': '170 MAIN STREET ATWOOD',
                                             'serial_number': '349D6E',
                                             'system_mac_address': None},
                'ec:4f:82:b8:2c:40': {       'dev_macs': ['04:bc:9f:46:91:51'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b8:2c:40',
                                             'name': '88 Parkview Cr. Atwood',
                                             'serial_number': '2FCC31',
                                             'system_mac_address': None},
                'ec:4f:82:b8:2c:78': {       'dev_macs': ['ec:4f:82:a8:88:15'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b8:2c:78',
                                             'name': '122 King St. Atwood',
                                             'serial_number': '2FCC38',
                                             'system_mac_address': None},
                'ec:4f:82:b8:31:c0': {       'dev_macs': ['d8:47:32:21:92:dd'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b8:31:c0',
                                             'name': '193 Main St. Atwood',
                                             'serial_number': '2FCCE1',
                                             'system_mac_address': None},
                'ec:4f:82:b9:18:80': {       'dev_macs': [       '70:4d:7b:d4:71:fc',
                                                                 '00:03:e6:da:b2:fc',
                                                                 '00:03:e6:dd:30:1e'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b9:18:80',
                                             'name': '137 Bowman Ct',
                                             'serial_number': '2FE9BA',
                                             'system_mac_address': None},
                'ec:4f:82:b9:1a:48': {       'dev_macs': ['60:db:98:55:b5:62'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b9:1a:48',
                                             'name': '132 QUEEN STREET ATWOOD',
                                             'serial_number': '2FE9F3',
                                             'system_mac_address': None},
                'ec:4f:82:b9:1a:c8': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b9:1a:c8',
                                             'name': '264 MAIN STREET ATWOOD',
                                             'serial_number': '2FEA03',
                                             'system_mac_address': None},
                'ec:4f:82:be:ac:21': {       'dev_macs': ['2c:b8:ed:43:0e:71'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:be:ac:21',
                                             'name': '217 MAIN STREET ATWOOD',
                                             'serial_number': '3788C1',
                                             'system_mac_address': None},
                'ec:4f:82:c0:c3:b0': {       'dev_macs': ['84:16:f9:25:86:23'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:c0:c3:b0',
                                             'name': '145 John St.',
                                             'serial_number': '3655A9',
                                             'system_mac_address': None},
                'ec:4f:82:cb:05:18': {       'dev_macs': [       '14:91:82:2e:68:01',
                                                                 'c4:e9:0a:56:61:4e',
                                                                 '00:03:e6:60:14:92'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:05:18',
                                             'name': '164 John St. Atwood',
                                             'serial_number': '2C9A0E',
                                             'system_mac_address': None},
                'ec:4f:82:cb:2b:48': {       'dev_macs': ['bc:0f:9a:66:68:50'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:2b:48',
                                             'name': '130 Main St. Atwood',
                                             'serial_number': '2C9ED4',
                                             'system_mac_address': None},
                'ec:4f:82:cb:4d:14': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:4d:14',
                                             'name': '130 ARTHUR STREET ATWOOD',
                                             'serial_number': '2CA30D',
                                             'system_mac_address': None},
                'ec:4f:82:cb:9e:b8': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:9e:b8',
                                             'name': '229 WOODVIEW DR',
                                             'serial_number': '38F111',
                                             'system_mac_address': None},
                'ec:4f:82:cb:a2:88': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:a2:88',
                                             'name': '140 Queen St. Atwood',
                                             'serial_number': '38F18B',
                                             'system_mac_address': None},
                'ec:4f:82:cb:a5:80': {       'dev_macs': ['40:b0:76:05:6e:34'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:a5:80',
                                             'name': '146 Queen St. Atwood',
                                             'serial_number': '38F1EA',
                                             'system_mac_address': None},
                'ec:4f:82:cb:a6:18': {       'dev_macs': ['44:65:7f:88:47:4a'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:a6:18',
                                             'name': '134 Monument Rd',
                                             'serial_number': '38F1FD',
                                             'system_mac_address': None},
                'ec:4f:82:cc:6c:04': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cc:6c:04',
                                             'name': '144 Bowman Ct',
                                             'serial_number': '390AB8',
                                             'system_mac_address': None},
                'ec:4f:82:da:ad:58': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:da:ad:58',
                                             'name': '153 MAIN STREET ATWOOD',
                                             'serial_number': '2E914A',
                                             'system_mac_address': None},
                'ec:4f:82:db:f0:ec': {       'dev_macs': ['cc:be:59:33:61:a0'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:db:f0:ec',
                                             'name': '298 Woodview Dr.',
                                             'serial_number': '2EB9B8',
                                             'system_mac_address': None},
                'ec:4f:82:dc:a5:2c': {       'dev_macs': ['74:da:da:d0:fb:96'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:dc:a5:2c',
                                             'name': '147 Queen St. Atwood',
                                             'serial_number': '2ED03F',
                                             'system_mac_address': None},
                'ec:4f:82:dc:f1:b4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:dc:f1:b4',
                                             'name': '161 MONUMENT RD',
                                             'serial_number': '2ED9D0',
                                             'system_mac_address': None},
                'ec:4f:82:dc:f2:dc': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:dc:f2:dc',
                                             'name': '130 King St. Atwood',
                                             'serial_number': '2ED9F5',
                                             'system_mac_address': None},
                'ec:4f:82:e0:0a:e0': {       'dev_macs': [       '44:65:7f:88:d1:b3',
                                                                 'c8:78:7d:65:b1:70'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:e0:0a:e0',
                                             'name': '200A MAIN STREET ATWOOD',
                                             'serial_number': '3961A9',
                                             'system_mac_address': None},
                'f8:85:f9:06:4e:64': {       'dev_macs': ['a8:5e:45:ca:b9:68'],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:06:4e:64',
                                             'name': '176 King St. Atwood',
                                             'serial_number': 'BF1E1B',
                                             'system_mac_address': None},
                'f8:85:f9:06:6c:cc': {       'dev_macs': ['48:f8:b3:8f:10:d9'],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:06:6c:cc',
                                             'name': '182 MAIN STREET',
                                             'serial_number': 'BF21E8',
                                             'system_mac_address': None},
                'f8:85:f9:06:77:e4': {       'dev_macs': [       '60:db:98:09:1b:5f',
                                                                 '00:03:e6:dd:44:ab',
                                                                 '00:03:e6:ec:0b:a6'],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:06:77:e4',
                                             'name': '128 Main St. Atwood',
                                             'serial_number': 'BF234B',
                                             'system_mac_address': None},
                'f8:85:f9:6f:1b:dd': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:1b:dd',
                                             'name': '186 King St. Atwood',
                                             'serial_number': 'BF242A',
                                             'system_mac_address': None},
                'f8:85:f9:6f:20:25': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:20:25',
                                             'name': '161 Fisher Ave',
                                             'serial_number': 'BF24B4',
                                             'system_mac_address': None},
                'f8:85:f9:6f:21:0d': {       'dev_macs': [       '3c:7c:3f:6d:e1:58',
                                                                 '00:03:e6:5e:8d:7c',
                                                                 '00:03:e6:5e:8d:86',
                                                                 '00:03:e6:5e:8d:94'],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:21:0d',
                                             'name': '7488 ROAD 164',
                                             'serial_number': 'BF24D1',
                                             'system_mac_address': None},
                'f8:85:f9:6f:22:05': {       'dev_macs': ['54:b8:0a:0f:4d:a3'],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:22:05',
                                             'name': '194 Ellen St. Atwood',
                                             'serial_number': 'BF24F1',
                                             'system_mac_address': None},
                'f8:85:f9:6f:22:a5': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:22:a5',
                                             'name': '248 Queen St. Atwood',
                                             'serial_number': 'BF2505',
                                             'system_mac_address': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': 'front',
                                                              'mac_address': 'cc:be:59:12:6a:c8',
                                                              'name': 'Craft-FE: front',
                                                              'oper_up': True,
                                                              'poller_hash': 'NzE3MDI5NzAyNjhmcm9udA=='},
                                                      {       'admin_up': False,
                                                              'id': 'rear',
                                                              'name': 'Craft-FE: rear',
                                                              'oper_up': False,
                                                              'poller_hash': 'NzE3MDI5NzAyNjhyZWFy'}],
                                'manufacturer': 'Calix',
                                'model': 'E7-2 (EXA)',
                                'modules': [       {       'id': '1',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '1/x3',
                                                                                         'in_discards': '21746180',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2009698925',
                                                                                         'in_octets': '3203197839539376',
                                                                                         'in_ucast_pkts': '7839168241514',
                                                                                         'mac_address': 'cc:be:59:12:6a:d7',
                                                                                         'manufacturer': 'FiberStore',
                                                                                         'model': 'SFP-10G-DAC',
                                                                                         'name': 'ethernet '
                                                                                                 '1/x3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '10790170802497',
                                                                                         'out_octets': '36792262944623630',
                                                                                         'out_ucast_pkts': '17383740106177',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS94Mw==',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/x4',
                                                                                         'in_discards': '2759025',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '25446436',
                                                                                         'in_octets': '1181429756823574',
                                                                                         'in_ucast_pkts': '876579766521',
                                                                                         'mac_address': 'cc:be:59:12:6a:d8',
                                                                                         'manufacturer': 'FS',
                                                                                         'model': 'SFPP-PC02',
                                                                                         'name': 'MCCL-SUBS '
                                                                                                 '1/x4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '42974334',
                                                                                         'out_octets': '39097737387555',
                                                                                         'out_ucast_pkts': '161145087361',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4TUNDTC1TVUJTIDEveDQ=',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g1',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2564',
                                                                                         'in_octets': '682781',
                                                                                         'in_ucast_pkts': '3781',
                                                                                         'mac_address': 'cc:be:59:12:6a:c9',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01669',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '365241799',
                                                                                         'out_octets': '25892593606',
                                                                                         'out_ucast_pkts': '1097653',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nMQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g2',
                                                                                         'mac_address': 'cc:be:59:12:6a:ca',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nMg=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g3',
                                                                                         'mac_address': 'cc:be:59:12:6a:cb',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nMw=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g4',
                                                                                         'mac_address': 'cc:be:59:12:6a:cc',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nNA=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/1',
                                                                                         'in_discards': '170604',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '23309068',
                                                                                         'in_octets': '19033336863003',
                                                                                         'in_ucast_pkts': '73856651506',
                                                                                         'links': [       {       'in_nucast_pkts': '14426361',
                                                                                                                  'in_octets': '60309678501',
                                                                                                                  'in_ucast_pkts': '223227841',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4061446793',
                                                                                                                  'out_octets': '5750152080487',
                                                                                                                  'out_ucast_pkts': '573349918',
                                                                                                                  'poller_hash': 'MzIyOTAxcGVlcmludGZwb24gMw=='},
                                                                                                          {       'in_nucast_pkts': '152',
                                                                                                                  'in_octets': '163114766',
                                                                                                                  'in_ucast_pkts': '757656',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5688',
                                                                                                                  'out_octets': '5144905196',
                                                                                                                  'out_ucast_pkts': '3485813',
                                                                                                                  'poller_hash': 'OTU2RjA0cGVlcmludGZwb24gMjA='},
                                                                                                          {       'in_nucast_pkts': '2725',
                                                                                                                  'in_octets': '762715',
                                                                                                                  'in_ucast_pkts': '2439',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5260889',
                                                                                                                  'out_octets': '6931288062',
                                                                                                                  'out_ucast_pkts': '2037',
                                                                                                                  'poller_hash': 'MUZDNEVGcGVlcmludGZwb24gNzI='},
                                                                                                          {       'in_nucast_pkts': '24731224',
                                                                                                                  'in_octets': '27636893073',
                                                                                                                  'in_ucast_pkts': '116993278',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11657626815',
                                                                                                                  'out_octets': '15385392682423',
                                                                                                                  'out_ucast_pkts': '325640979',
                                                                                                                  'poller_hash': 'NTVGQkE1cGVlcmludGZwb24gNzM='},
                                                                                                          {       'in_nucast_pkts': '21023108',
                                                                                                                  'in_octets': '236755723904',
                                                                                                                  'in_ucast_pkts': '515490044',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '18685913074',
                                                                                                                  'out_octets': '26214887731213',
                                                                                                                  'out_ucast_pkts': '1419317475',
                                                                                                                  'poller_hash': 'MkVEOUQwcGVlcmludGZwb24gNzQ='},
                                                                                                          {       'in_nucast_pkts': '4074',
                                                                                                                  'in_octets': '2125191094',
                                                                                                                  'in_ucast_pkts': '9708788',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1100054',
                                                                                                                  'out_octets': '12179722366',
                                                                                                                  'out_ucast_pkts': '13469805',
                                                                                                                  'poller_hash': 'NDE1MzBwZWVyaW50ZnBvbiA3NQ=='},
                                                                                                          {       'in_nucast_pkts': '7',
                                                                                                                  'in_octets': '1768619',
                                                                                                                  'in_ucast_pkts': '4485',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2460',
                                                                                                                  'out_octets': '14303731',
                                                                                                                  'out_ucast_pkts': '12300',
                                                                                                                  'poller_hash': 'NjQwQjRGcGVlcmludGZwb24gODc='},
                                                                                                          {       'in_nucast_pkts': '771797',
                                                                                                                  'in_octets': '115229887604',
                                                                                                                  'in_ucast_pkts': '129184341',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386374',
                                                                                                                  'out_octets': '150720910231',
                                                                                                                  'out_ucast_pkts': '1035254528667',
                                                                                                                  'poller_hash': 'RjFGOHBlZXJpbnRmcG9uIDEwNw=='},
                                                                                                          {       'in_nucast_pkts': '7',
                                                                                                                  'in_octets': '58011461589',
                                                                                                                  'in_ucast_pkts': '232174000',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1100028',
                                                                                                                  'out_octets': '1098910241265',
                                                                                                                  'out_ucast_pkts': '841759606',
                                                                                                                  'poller_hash': 'MzhGMUZEcGVlcmludGZwb24gMTA5'},
                                                                                                          {       'in_nucast_pkts': '4971',
                                                                                                                  'in_octets': '62217170777',
                                                                                                                  'in_ucast_pkts': '128864785',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1099432',
                                                                                                                  'out_octets': '416820855431',
                                                                                                                  'out_ucast_pkts': '346127511',
                                                                                                                  'poller_hash': 'MjVEOTM0cGVlcmludGZwb24gMTEw'},
                                                                                                          {       'in_nucast_pkts': '17046341',
                                                                                                                  'in_octets': '120771042419',
                                                                                                                  'in_ucast_pkts': '449155485',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13117920469',
                                                                                                                  'out_octets': '18492475385804',
                                                                                                                  'out_ucast_pkts': '978905359',
                                                                                                                  'poller_hash': 'NTVFMTIzcGVlcmludGZwb24gMTEx'},
                                                                                                          {       'in_nucast_pkts': '4918344',
                                                                                                                  'in_octets': '7262840385',
                                                                                                                  'in_ucast_pkts': '20199630',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6087535562',
                                                                                                                  'out_octets': '8131122821961',
                                                                                                                  'out_ucast_pkts': '65215871',
                                                                                                                  'poller_hash': 'MTk5OUM1cGVlcmludGZwb24gMTEy'},
                                                                                                          {       'in_nucast_pkts': '144',
                                                                                                                  'in_octets': '1646891',
                                                                                                                  'in_ucast_pkts': '7968',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2474',
                                                                                                                  'out_octets': '1229947',
                                                                                                                  'out_ucast_pkts': '7384',
                                                                                                                  'poller_hash': 'NDU1NjczcGVlcmludGZwb24gMTEz'},
                                                                                                          {       'in_nucast_pkts': '1478',
                                                                                                                  'in_octets': '51950219',
                                                                                                                  'in_ucast_pkts': '688591',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4839',
                                                                                                                  'out_octets': '59972785',
                                                                                                                  'out_ucast_pkts': '865621',
                                                                                                                  'poller_hash': 'QTlDOEY5cGVlcmludGZwb24gMTE0'},
                                                                                                          {       'in_nucast_pkts': '2330',
                                                                                                                  'in_octets': '2170596',
                                                                                                                  'in_ucast_pkts': '6028',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5356676',
                                                                                                                  'out_octets': '7065998465',
                                                                                                                  'out_ucast_pkts': '7667',
                                                                                                                  'poller_hash': 'MkZDQzM4cGVlcmludGZwb24gMTc2'},
                                                                                                          {       'in_nucast_pkts': '14',
                                                                                                                  'in_octets': '1677003',
                                                                                                                  'in_ucast_pkts': '5536',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3621',
                                                                                                                  'out_octets': '2702604',
                                                                                                                  'out_ucast_pkts': '4829',
                                                                                                                  'poller_hash': 'QzgyMTMxcGVlcmludGZwb24gMTYxNjU3'},
                                                                                                          {       'in_nucast_pkts': '152',
                                                                                                                  'in_octets': '2270507',
                                                                                                                  'in_ucast_pkts': '10372',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5885',
                                                                                                                  'out_octets': '3847837',
                                                                                                                  'out_ucast_pkts': '10691',
                                                                                                                  'poller_hash': 'QzgzQjk3cGVlcmludGZwb24gMTcwNzEy'},
                                                                                                          {       'in_nucast_pkts': '4772196',
                                                                                                                  'in_octets': '1546502614',
                                                                                                                  'in_ucast_pkts': '5853370',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '14034473257',
                                                                                                                  'out_octets': '18674366632405',
                                                                                                                  'out_ucast_pkts': '4304423',
                                                                                                                  'poller_hash': 'QzgxQ0JFcGVlcmludGZwb24gMjA2Njgw'},
                                                                                                          {       'in_nucast_pkts': '1729',
                                                                                                                  'in_octets': '26637567874',
                                                                                                                  'in_ucast_pkts': '158650509',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9326112',
                                                                                                                  'out_octets': '1094810714962',
                                                                                                                  'out_ucast_pkts': '787464700',
                                                                                                                  'poller_hash': 'MTE5NTE1MXBlZXJpbnRmcG9uIDIxNDYyMA=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '653527657019',
                                                                                         'out_octets': '1147706645361438',
                                                                                         'out_ucast_pkts': '200366150610',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzE=',
                                                                                         'pons': [       {       'id': '1/1',
                                                                                                                 'links': [       {       'connected_time': '19405459',
                                                                                                                                          'fiber_length': 1957,
                                                                                                                                          'poller_hash': 'MzIyOTAxcGVlcnBvbnBvbiAz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '6503',
                                                                                                                                          'fiber_length': 1818,
                                                                                                                                          'poller_hash': 'OTU2RjA0cGVlcnBvbnBvbiAyMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '6535',
                                                                                                                                          'fiber_length': 1840,
                                                                                                                                          'poller_hash': 'MUZDNEVGcGVlcnBvbnBvbiA3Mg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '19390586',
                                                                                                                                          'fiber_length': 1895,
                                                                                                                                          'poller_hash': 'NTVGQkE1cGVlcnBvbnBvbiA3Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '19390423',
                                                                                                                                          'fiber_length': 1848,
                                                                                                                                          'poller_hash': 'MkVEOUQwcGVlcnBvbnBvbiA3NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '3934507',
                                                                                                                                          'fiber_length': 1837,
                                                                                                                                          'poller_hash': 'NDE1MzBwZWVycG9ucG9uIDc1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '6550',
                                                                                                                                          'fiber_length': 1476,
                                                                                                                                          'poller_hash': 'NjQwQjRGcGVlcnBvbnBvbiA4Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '19390022',
                                                                                                                                          'fiber_length': 1677,
                                                                                                                                          'poller_hash': 'RjFGOHBlZXJwb25wb24gMTA3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '3934557',
                                                                                                                                          'fiber_length': 1731,
                                                                                                                                          'poller_hash': 'MzhGMUZEcGVlcnBvbnBvbiAxMDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '3934539',
                                                                                                                                          'fiber_length': 1740,
                                                                                                                                          'poller_hash': 'MjVEOTM0cGVlcnBvbnBvbiAxMTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '19390195',
                                                                                                                                          'fiber_length': 1735,
                                                                                                                                          'poller_hash': 'NTVFMTIzcGVlcnBvbnBvbiAxMTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '3934592',
                                                                                                                                          'fiber_length': 1714,
                                                                                                                                          'poller_hash': 'MTk5OUM1cGVlcnBvbnBvbiAxMTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '6561',
                                                                                                                                          'fiber_length': 1670,
                                                                                                                                          'poller_hash': 'NDU1NjczcGVlcnBvbnBvbiAxMTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '6570',
                                                                                                                                          'fiber_length': 1876,
                                                                                                                                          'poller_hash': 'QTlDOEY5cGVlcnBvbnBvbiAxMTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '6594',
                                                                                                                                          'fiber_length': 1677,
                                                                                                                                          'poller_hash': 'MkZDQzM4cGVlcnBvbnBvbiAxNzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '6720',
                                                                                                                                          'fiber_length': 1800,
                                                                                                                                          'poller_hash': 'QzgyMTMxcGVlcnBvbnBvbiAxNjE2NTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '6725',
                                                                                                                                          'fiber_length': 1526,
                                                                                                                                          'poller_hash': 'QzgzQjk3cGVlcnBvbnBvbiAxNzA3MTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '19405627',
                                                                                                                                          'fiber_length': 1970,
                                                                                                                                          'poller_hash': 'QzgxQ0JFcGVlcnBvbnBvbiAyMDY2ODA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '18078923',
                                                                                                                                          'fiber_length': 1831,
                                                                                                                                          'poller_hash': 'MTE5NTE1MXBlZXJwb25wb24gMjE0NjIw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/1',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzE=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/2',
                                                                                         'in_discards': '3126',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '17072804',
                                                                                         'in_octets': '16065984389647',
                                                                                         'in_ucast_pkts': '84749664772',
                                                                                         'links': [       {       'in_nucast_pkts': '24905017',
                                                                                                                  'in_octets': '1725857808563',
                                                                                                                  'in_ucast_pkts': '2754254689',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '30816406695',
                                                                                                                  'out_octets': '47150047846312',
                                                                                                                  'out_ucast_pkts': '4766686018',
                                                                                                                  'poller_hash': 'M0ZCMzVEcGVlcmludGZwb24gMjg='},
                                                                                                          {       'in_nucast_pkts': '10',
                                                                                                                  'in_octets': '67191506',
                                                                                                                  'in_ucast_pkts': '673202',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '117',
                                                                                                                  'out_octets': '4260141010',
                                                                                                                  'out_ucast_pkts': '2842082',
                                                                                                                  'poller_hash': 'QzU3Q0RwZWVyaW50ZnBvbiA0OQ=='},
                                                                                                          {       'in_nucast_pkts': '24245164',
                                                                                                                  'in_octets': '29966802131',
                                                                                                                  'in_ucast_pkts': '74110193',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '25262168755',
                                                                                                                  'out_octets': '34240677910116',
                                                                                                                  'out_ucast_pkts': '184700328',
                                                                                                                  'poller_hash': 'QkYyMzRCcGVlcmludGZwb24gMTE2'},
                                                                                                          {       'in_nucast_pkts': '10182429',
                                                                                                                  'in_octets': '107416091887',
                                                                                                                  'in_ucast_pkts': '359487562',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2738549422',
                                                                                                                  'out_octets': '4169320638795',
                                                                                                                  'out_ucast_pkts': '1119353210',
                                                                                                                  'poller_hash': 'MkM5RUQ0cGVlcmludGZwb24gMTE3'},
                                                                                                          {       'in_nucast_pkts': '11',
                                                                                                                  'in_octets': '955099',
                                                                                                                  'in_ucast_pkts': '1177',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5940',
                                                                                                                  'out_octets': '647993',
                                                                                                                  'out_ucast_pkts': '1489',
                                                                                                                  'poller_hash': 'QzgzQjk4cGVlcmludGZwb24gMTcxNzA5'},
                                                                                                          {       'in_nucast_pkts': '3838',
                                                                                                                  'in_octets': '6973039',
                                                                                                                  'in_ucast_pkts': '28443',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9375833',
                                                                                                                  'out_octets': '12391258919',
                                                                                                                  'out_ucast_pkts': '91264',
                                                                                                                  'poller_hash': 'MTE5NTFBOXBlZXJpbnRmcG9uIDIxNjAwOQ=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '709141466335',
                                                                                         'out_octets': '1188027186317738',
                                                                                         'out_ucast_pkts': '190345644998',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzI=',
                                                                                         'pons': [       {       'id': '1/2',
                                                                                                                 'links': [       {       'connected_time': '19390357',
                                                                                                                                          'fiber_length': 1169,
                                                                                                                                          'poller_hash': 'M0ZCMzVEcGVlcnBvbnBvbiAyOA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.798},
                                                                                                                                  {       'connected_time': '6522',
                                                                                                                                          'fiber_length': 1162,
                                                                                                                                          'poller_hash': 'QzU3Q0RwZWVycG9ucG9uIDQ5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.798},
                                                                                                                                  {       'connected_time': '19390244',
                                                                                                                                          'fiber_length': 1117,
                                                                                                                                          'poller_hash': 'QkYyMzRCcGVlcnBvbnBvbiAxMTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.798},
                                                                                                                                  {       'connected_time': '19390274',
                                                                                                                                          'fiber_length': 1104,
                                                                                                                                          'poller_hash': 'MkM5RUQ0cGVlcnBvbnBvbiAxMTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.798},
                                                                                                                                  {       'connected_time': '6727',
                                                                                                                                          'fiber_length': 499,
                                                                                                                                          'poller_hash': 'QzgzQjk4cGVlcnBvbnBvbiAxNzE3MDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.798},
                                                                                                                                  {       'connected_time': '6736',
                                                                                                                                          'fiber_length': 1189,
                                                                                                                                          'poller_hash': 'MTE5NTFBOXBlZXJwb25wb24gMjE2MDA5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.798}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/2',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzI=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/3',
                                                                                         'in_discards': '20186',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '4561798',
                                                                                         'in_octets': '16196359150521',
                                                                                         'in_ucast_pkts': '78693101583',
                                                                                         'links': [       {       'in_nucast_pkts': '9',
                                                                                                                  'in_octets': '3116759',
                                                                                                                  'in_ucast_pkts': '9732',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5713',
                                                                                                                  'out_octets': '21385516',
                                                                                                                  'out_ucast_pkts': '19880',
                                                                                                                  'poller_hash': 'ODcyNDFCcGVlcmludGZwb24gMzE='},
                                                                                                          {       'in_nucast_pkts': '121',
                                                                                                                  'in_octets': '9489788',
                                                                                                                  'in_ucast_pkts': '29558',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5617',
                                                                                                                  'out_octets': '21335116',
                                                                                                                  'out_ucast_pkts': '33844',
                                                                                                                  'poller_hash': 'QjUxMEUycGVlcmludGZwb24gMzY='},
                                                                                                          {       'in_nucast_pkts': '4940713',
                                                                                                                  'in_octets': '24088163307',
                                                                                                                  'in_ucast_pkts': '217954469',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1167923318',
                                                                                                                  'out_octets': '2870596401544',
                                                                                                                  'out_ucast_pkts': '993942311',
                                                                                                                  'poller_hash': 'MzIxMDMzcGVlcmludGZwb24gNDQ='},
                                                                                                          {       'in_nucast_pkts': '302866',
                                                                                                                  'in_octets': '601220944816',
                                                                                                                  'in_ucast_pkts': '1477766145',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10016060',
                                                                                                                  'out_octets': '4826003747146',
                                                                                                                  'out_ucast_pkts': '3577019255',
                                                                                                                  'poller_hash': 'QTlDNzg2cGVlcmludGZwb24gODU='},
                                                                                                          {       'in_nucast_pkts': '4046',
                                                                                                                  'in_octets': '61144526811',
                                                                                                                  'in_ucast_pkts': '511222990',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386233',
                                                                                                                  'out_octets': '1962944481468',
                                                                                                                  'out_ucast_pkts': '5673115796',
                                                                                                                  'poller_hash': 'M0NGNEFwZWVyaW50ZnBvbiAxMjE='},
                                                                                                          {       'in_nucast_pkts': '17246',
                                                                                                                  'in_octets': '405453546508',
                                                                                                                  'in_ucast_pkts': '3074058263',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1384716',
                                                                                                                  'out_octets': '10889826294103',
                                                                                                                  'out_ucast_pkts': '12003556838',
                                                                                                                  'poller_hash': 'NDE1QjBwZWVyaW50ZnBvbiAxMjI='},
                                                                                                          {       'in_nucast_pkts': '6930',
                                                                                                                  'in_octets': '38381220809',
                                                                                                                  'in_ucast_pkts': '98348307',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1367399',
                                                                                                                  'out_octets': '577357822511',
                                                                                                                  'out_ucast_pkts': '457969456',
                                                                                                                  'poller_hash': 'NzIyMDY1cGVlcmludGZwb24gMTI0'},
                                                                                                          {       'in_nucast_pkts': '146267',
                                                                                                                  'in_octets': '100199613789',
                                                                                                                  'in_ucast_pkts': '499458682',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386805',
                                                                                                                  'out_octets': '2766932658742',
                                                                                                                  'out_ucast_pkts': '2068951490',
                                                                                                                  'poller_hash': 'NEUzNkE4cGVlcmludGZwb24gMTI2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MkU5MTRBcGVlcmludGZwb24gMTM1'},
                                                                                                          {       'in_nucast_pkts': '2685545',
                                                                                                                  'in_octets': '36905156693',
                                                                                                                  'in_ucast_pkts': '133032087',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1604450293',
                                                                                                                  'out_octets': '2791936920109',
                                                                                                                  'out_ucast_pkts': '697322558',
                                                                                                                  'poller_hash': 'ODcyNTM1cGVlcmludGZwb24gMTM2'},
                                                                                                          {       'in_nucast_pkts': '14',
                                                                                                                  'in_octets': '27403847',
                                                                                                                  'in_ucast_pkts': '51305',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2479',
                                                                                                                  'out_octets': '9753789',
                                                                                                                  'out_ucast_pkts': '34338',
                                                                                                                  'poller_hash': 'MTMwMDlBcGVlcmludGZwb24gMTM4'},
                                                                                                          {       'in_nucast_pkts': '32',
                                                                                                                  'in_octets': '13575608995',
                                                                                                                  'in_ucast_pkts': '161357185',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1099953',
                                                                                                                  'out_octets': '402269755613',
                                                                                                                  'out_ucast_pkts': '275161768',
                                                                                                                  'poller_hash': 'RjIzQXBlZXJpbnRmcG9uIDEzOQ=='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'M0NGMzNwZWVyaW50ZnBvbiAxNDA='},
                                                                                                          {       'in_nucast_pkts': '137545',
                                                                                                                  'in_octets': '599234933988',
                                                                                                                  'in_ucast_pkts': '1561093028',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386729',
                                                                                                                  'out_octets': '8048291992664',
                                                                                                                  'out_ucast_pkts': '6106967496',
                                                                                                                  'poller_hash': 'MzI5NjQycGVlcmludGZwb24gMTQy'},
                                                                                                          {       'in_nucast_pkts': '348985',
                                                                                                                  'in_octets': '170551943099',
                                                                                                                  'in_ucast_pkts': '4996031275',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386183',
                                                                                                                  'out_octets': '3422787394021',
                                                                                                                  'out_ucast_pkts': '6893084140',
                                                                                                                  'poller_hash': 'NDE4QUNwZWVyaW50ZnBvbiAxNDM='},
                                                                                                          {       'in_nucast_pkts': '18753',
                                                                                                                  'in_octets': '98908602951',
                                                                                                                  'in_ucast_pkts': '682698886',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386215',
                                                                                                                  'out_octets': '3575790593083',
                                                                                                                  'out_ucast_pkts': '6815985420',
                                                                                                                  'poller_hash': 'M0NDMDhwZWVyaW50ZnBvbiAxNDQ='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'RjEwNnBlZXJpbnRmcG9uIDE0NQ=='},
                                                                                                          {       'in_nucast_pkts': '105893',
                                                                                                                  'in_octets': '8132787662',
                                                                                                                  'in_ucast_pkts': '42189952',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1099951',
                                                                                                                  'out_octets': '248681671933',
                                                                                                                  'out_ucast_pkts': '181820855',
                                                                                                                  'poller_hash': 'QzU4NkJwZWVyaW50ZnBvbiAxNDY='},
                                                                                                          {       'in_nucast_pkts': '86723',
                                                                                                                  'in_octets': '285029426390',
                                                                                                                  'in_ucast_pkts': '649496464',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1387831',
                                                                                                                  'out_octets': '3507390340013',
                                                                                                                  'out_ucast_pkts': '6889596465',
                                                                                                                  'poller_hash': 'M0NGNEVwZWVyaW50ZnBvbiAxNDg='},
                                                                                                          {       'in_nucast_pkts': '9683',
                                                                                                                  'in_octets': '52833084913',
                                                                                                                  'in_ucast_pkts': '336634022',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386144',
                                                                                                                  'out_octets': '2615194154140',
                                                                                                                  'out_ucast_pkts': '1824473385',
                                                                                                                  'poller_hash': 'MTk5QTI1cGVlcmludGZwb24gMTUw'},
                                                                                                          {       'in_nucast_pkts': '11002152',
                                                                                                                  'in_octets': '50861917711',
                                                                                                                  'in_ucast_pkts': '142857423',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '12349656799',
                                                                                                                  'out_octets': '16616507692124',
                                                                                                                  'out_ucast_pkts': '520423219',
                                                                                                                  'poller_hash': 'MTk5QTM5cGVlcmludGZwb24gMTUx'},
                                                                                                          {       'in_nucast_pkts': '28339',
                                                                                                                  'in_octets': '1377698258',
                                                                                                                  'in_ucast_pkts': '3608864',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11090259',
                                                                                                                  'out_octets': '9952070738',
                                                                                                                  'out_ucast_pkts': '11547558',
                                                                                                                  'poller_hash': 'QzgzMjEycGVlcmludGZwb24gMTUz'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MTM1MzhwZWVyaW50ZnBvbiAxNTQ='},
                                                                                                          {       'in_nucast_pkts': '22382442',
                                                                                                                  'in_octets': '563047437996',
                                                                                                                  'in_ucast_pkts': '927589655',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '31291058047',
                                                                                                                  'out_octets': '45925718639665',
                                                                                                                  'out_ucast_pkts': '3168337373',
                                                                                                                  'poller_hash': 'NzFEODBBcGVlcmludGZwb24gMTU1'},
                                                                                                          {       'in_nucast_pkts': '5079',
                                                                                                                  'in_octets': '5395898',
                                                                                                                  'in_ucast_pkts': '26563',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '926199',
                                                                                                                  'out_octets': '1051863040',
                                                                                                                  'out_ucast_pkts': '38335',
                                                                                                                  'poller_hash': 'QjBBMkEwcGVlcmludGZwb24gMTUwODcy'},
                                                                                                          {       'in_nucast_pkts': '18260231',
                                                                                                                  'in_octets': '229166762218',
                                                                                                                  'in_ucast_pkts': '1282483864',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '16612994304',
                                                                                                                  'out_octets': '27534570097849',
                                                                                                                  'out_ucast_pkts': '3832164023',
                                                                                                                  'poller_hash': 'QkYyMUU4cGVlcmludGZwb24gMTY0MDYz'},
                                                                                                          {       'in_nucast_pkts': '6',
                                                                                                                  'in_octets': '123004',
                                                                                                                  'in_ucast_pkts': '1421',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3627',
                                                                                                                  'out_octets': '568290',
                                                                                                                  'out_ucast_pkts': '1366',
                                                                                                                  'poller_hash': 'QzgzQkJCcGVlcmludGZwb24gMTcyMzA5'},
                                                                                                          {       'in_nucast_pkts': '5021835',
                                                                                                                  'in_octets': '28903638561',
                                                                                                                  'in_ucast_pkts': '206091604',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7459536351',
                                                                                                                  'out_octets': '10326906505788',
                                                                                                                  'out_ucast_pkts': '454034474',
                                                                                                                  'poller_hash': 'QzgxNUYxcGVlcmludGZwb24gMjA3MzUy'},
                                                                                                          {       'in_nucast_pkts': '11',
                                                                                                                  'in_octets': '5612380',
                                                                                                                  'in_ucast_pkts': '15063',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5947',
                                                                                                                  'out_octets': '9258942',
                                                                                                                  'out_ucast_pkts': '15368',
                                                                                                                  'poller_hash': 'MTFCMjJCRHBlZXJpbnRmcG9uIDIxMjA4OA=='},
                                                                                                          {       'in_nucast_pkts': '8753',
                                                                                                                  'in_octets': '40757090866',
                                                                                                                  'in_ucast_pkts': '355013977',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '78618',
                                                                                                                  'out_octets': '1612502543011',
                                                                                                                  'out_ucast_pkts': '1125759672',
                                                                                                                  'poller_hash': 'NDcxQzYzcGVlcmludGZwb24gMjI0Njc5'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '469978994322',
                                                                                         'out_octets': '993447312171218',
                                                                                         'out_ucast_pkts': '255187014744',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzM=',
                                                                                         'pons': [       {       'id': '1/3',
                                                                                                                 'links': [       {       'connected_time': '6513',
                                                                                                                                          'fiber_length': 1138,
                                                                                                                                          'poller_hash': 'ODcyNDFCcGVlcnBvbnBvbiAzMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '6513',
                                                                                                                                          'fiber_length': 1009,
                                                                                                                                          'poller_hash': 'QjUxMEUycGVlcnBvbnBvbiAzNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '6717227',
                                                                                                                                          'fiber_length': 982,
                                                                                                                                          'poller_hash': 'MzIxMDMzcGVlcnBvbnBvbiA0NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19405583',
                                                                                                                                          'fiber_length': 1125,
                                                                                                                                          'poller_hash': 'QTlDNzg2cGVlcnBvbnBvbiA4NQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390157',
                                                                                                                                          'fiber_length': 1090,
                                                                                                                                          'poller_hash': 'M0NGNEFwZWVycG9ucG9uIDEyMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390138',
                                                                                                                                          'fiber_length': 1070,
                                                                                                                                          'poller_hash': 'NDE1QjBwZWVycG9ucG9uIDEyMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390454',
                                                                                                                                          'fiber_length': 1128,
                                                                                                                                          'poller_hash': 'NzIyMDY1cGVlcnBvbnBvbiAxMjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390358',
                                                                                                                                          'fiber_length': 1156,
                                                                                                                                          'poller_hash': 'NEUzNkE4cGVlcnBvbnBvbiAxMjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390365',
                                                                                                                                          'fiber_length': 956,
                                                                                                                                          'poller_hash': 'MkU5MTRBcGVlcnBvbnBvbiAxMzU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '15001651',
                                                                                                                                          'fiber_length': 1017,
                                                                                                                                          'poller_hash': 'ODcyNTM1cGVlcnBvbnBvbiAxMzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '6576',
                                                                                                                                          'fiber_length': 958,
                                                                                                                                          'poller_hash': 'MTMwMDlBcGVlcnBvbnBvbiAxMzg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '3934596',
                                                                                                                                          'fiber_length': 825,
                                                                                                                                          'poller_hash': 'RjIzQXBlZXJwb25wb24gMTM5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'poller_hash': 'M0NGMzNwZWVycG9ucG9uIDE0MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390523',
                                                                                                                                          'fiber_length': 837,
                                                                                                                                          'poller_hash': 'MzI5NjQycGVlcnBvbnBvbiAxNDI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390309',
                                                                                                                                          'fiber_length': 755,
                                                                                                                                          'poller_hash': 'NDE4QUNwZWVycG9ucG9uIDE0Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390248',
                                                                                                                                          'fiber_length': 708,
                                                                                                                                          'poller_hash': 'M0NDMDhwZWVycG9ucG9uIDE0NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'poller_hash': 'RjEwNnBlZXJwb25wb24gMTQ1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '3934552',
                                                                                                                                          'fiber_length': 726,
                                                                                                                                          'poller_hash': 'QzU4NkJwZWVycG9ucG9uIDE0Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390238',
                                                                                                                                          'fiber_length': 571,
                                                                                                                                          'poller_hash': 'M0NGNEVwZWVycG9ucG9uIDE0OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390434',
                                                                                                                                          'fiber_length': 614,
                                                                                                                                          'poller_hash': 'MTk5QTI1cGVlcnBvbnBvbiAxNTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390383',
                                                                                                                                          'fiber_length': 751,
                                                                                                                                          'poller_hash': 'MTk5QTM5cGVlcnBvbnBvbiAxNTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19405243',
                                                                                                                                          'fiber_length': 742,
                                                                                                                                          'poller_hash': 'QzgzMjEycGVlcnBvbnBvbiAxNTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '3934466',
                                                                                                                                          'fiber_length': 608,
                                                                                                                                          'poller_hash': 'MTM1MzhwZWVycG9ucG9uIDE1NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390331',
                                                                                                                                          'fiber_length': 672,
                                                                                                                                          'poller_hash': 'NzFEODBBcGVlcnBvbnBvbiAxNTU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '6714',
                                                                                                                                          'fiber_length': 1024,
                                                                                                                                          'poller_hash': 'QjBBMkEwcGVlcnBvbnBvbiAxNTA4NzI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390601',
                                                                                                                                          'fiber_length': 682,
                                                                                                                                          'poller_hash': 'QkYyMUU4cGVlcnBvbnBvbiAxNjQwNjM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '6729',
                                                                                                                                          'fiber_length': 1206,
                                                                                                                                          'poller_hash': 'QzgzQkJCcGVlcnBvbnBvbiAxNzIzMDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19405770',
                                                                                                                                          'fiber_length': 930,
                                                                                                                                          'poller_hash': 'QzgxNUYxcGVlcnBvbnBvbiAyMDczNTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '6733',
                                                                                                                                          'fiber_length': 855,
                                                                                                                                          'poller_hash': 'MTFCMjJCRHBlZXJwb25wb24gMjEyMDg4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '9408957',
                                                                                                                                          'fiber_length': 657,
                                                                                                                                          'poller_hash': 'NDcxQzYzcGVlcnBvbnBvbiAyMjQ2Nzk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/3',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzM=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/4',
                                                                                         'in_discards': '175610',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1843041',
                                                                                         'in_octets': '12913142133057',
                                                                                         'in_ucast_pkts': '52147557426',
                                                                                         'links': [       {       'in_nucast_pkts': '14766525',
                                                                                                                  'in_octets': '4667171082',
                                                                                                                  'in_ucast_pkts': '17501186',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '34375659601',
                                                                                                                  'out_octets': '45437220166811',
                                                                                                                  'out_ucast_pkts': '12946276',
                                                                                                                  'poller_hash': 'MzIyM0Y5cGVlcmludGZwb24gOQ=='},
                                                                                                          {       'in_nucast_pkts': '4',
                                                                                                                  'in_octets': '64123943',
                                                                                                                  'in_ucast_pkts': '230121',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '120',
                                                                                                                  'out_octets': '2345339333',
                                                                                                                  'out_ucast_pkts': '1639823',
                                                                                                                  'poller_hash': 'M0FERDZFcGVlcmludGZwb24gMTc='},
                                                                                                          {       'in_nucast_pkts': '18634',
                                                                                                                  'in_octets': '704042675369',
                                                                                                                  'in_ucast_pkts': '2298933884',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '162619',
                                                                                                                  'out_octets': '6895644341453',
                                                                                                                  'out_ucast_pkts': '5080391620',
                                                                                                                  'poller_hash': 'NEQ0MUY0cGVlcmludGZwb24gMjk='},
                                                                                                          {       'in_nucast_pkts': '16022086',
                                                                                                                  'in_octets': '612880030550',
                                                                                                                  'in_ucast_pkts': '2363601698',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8912643048',
                                                                                                                  'out_octets': '21544993819067',
                                                                                                                  'out_ucast_pkts': '7090104502',
                                                                                                                  'poller_hash': 'Mzk2MUE5cGVlcmludGZwb24gNTA='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MUM1RENGcGVlcmludGZwb24gOTM='},
                                                                                                          {       'in_nucast_pkts': '2875',
                                                                                                                  'in_octets': '3950815',
                                                                                                                  'in_ucast_pkts': '13008',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1841066',
                                                                                                                  'out_octets': '2276297323',
                                                                                                                  'out_ucast_pkts': '12667',
                                                                                                                  'poller_hash': 'QzU4NTBwZWVyaW50ZnBvbiAxNTc='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODcyNDY2cGVlcmludGZwb24gMTU4'},
                                                                                                          {       'in_nucast_pkts': '16055108',
                                                                                                                  'in_octets': '273455373420',
                                                                                                                  'in_ucast_pkts': '1342556711',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9446551768',
                                                                                                                  'out_octets': '16835443332332',
                                                                                                                  'out_ucast_pkts': '3442710019',
                                                                                                                  'poller_hash': 'NTVGQkQ2cGVlcmludGZwb24gMTU5'},
                                                                                                          {       'in_nucast_pkts': '8184',
                                                                                                                  'in_octets': '61853897867',
                                                                                                                  'in_ucast_pkts': '580481683',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1390005',
                                                                                                                  'out_octets': '2539153668262',
                                                                                                                  'out_ucast_pkts': '1036867013103',
                                                                                                                  'poller_hash': 'MTMwM0RwZWVyaW50ZnBvbiAxNjA='},
                                                                                                          {       'in_nucast_pkts': '3682257',
                                                                                                                  'in_octets': '55641856044',
                                                                                                                  'in_ucast_pkts': '174418514',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1114413728',
                                                                                                                  'out_octets': '1757347867191',
                                                                                                                  'out_ucast_pkts': '318037054',
                                                                                                                  'poller_hash': 'MTk5QTFCcGVlcmludGZwb24gMTYx'},
                                                                                                          {       'in_nucast_pkts': '153896',
                                                                                                                  'in_octets': '106273570681',
                                                                                                                  'in_ucast_pkts': '570938064',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386681',
                                                                                                                  'out_octets': '3106788220373',
                                                                                                                  'out_ucast_pkts': '2203513848',
                                                                                                                  'poller_hash': 'MjQ4QUU2cGVlcmludGZwb24gMTYy'},
                                                                                                          {       'in_nucast_pkts': '3940888',
                                                                                                                  'in_octets': '244620591467',
                                                                                                                  'in_ucast_pkts': '1301187165',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2772231',
                                                                                                                  'out_octets': '6399897404892',
                                                                                                                  'out_ucast_pkts': '4681323209',
                                                                                                                  'poller_hash': 'MTYxMDIxcGVlcmludGZwb24gMTYz'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MjQ4QUQ3cGVlcmludGZwb24gMTY0'},
                                                                                                          {       'in_nucast_pkts': '63434',
                                                                                                                  'in_octets': '93619764910',
                                                                                                                  'in_ucast_pkts': '376057059',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386092',
                                                                                                                  'out_octets': '798574098607',
                                                                                                                  'out_ucast_pkts': '725262283',
                                                                                                                  'poller_hash': 'Mzc4OEMxcGVlcmludGZwb24gMTY1'},
                                                                                                          {       'in_nucast_pkts': '25',
                                                                                                                  'in_octets': '40387247',
                                                                                                                  'in_ucast_pkts': '76758',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2486',
                                                                                                                  'out_octets': '111954275',
                                                                                                                  'out_ucast_pkts': '99398',
                                                                                                                  'poller_hash': 'MkZDQ0UxcGVlcmludGZwb24gMTY2'},
                                                                                                          {       'in_nucast_pkts': '5078939',
                                                                                                                  'in_octets': '103510214833',
                                                                                                                  'in_ucast_pkts': '501449826',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '12663043525',
                                                                                                                  'out_octets': '19993512958248',
                                                                                                                  'out_ucast_pkts': '2284179464',
                                                                                                                  'poller_hash': 'QzgzQkFFcGVlcmludGZwb24gMTY2MTIx'},
                                                                                                          {       'in_nucast_pkts': '469',
                                                                                                                  'in_octets': '9224060',
                                                                                                                  'in_ucast_pkts': '11359',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3635',
                                                                                                                  'out_octets': '1457864',
                                                                                                                  'out_ucast_pkts': '9158',
                                                                                                                  'poller_hash': 'QzgxRDZGcGVlcmludGZwb24gMjExNjUz'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '331061945463',
                                                                                         'out_octets': '650061634981684',
                                                                                         'out_ucast_pkts': '148022435795',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzQ=',
                                                                                         'pons': [       {       'id': '1/4',
                                                                                                                 'links': [       {       'connected_time': '19405519',
                                                                                                                                          'fiber_length': 662,
                                                                                                                                          'poller_hash': 'MzIyM0Y5cGVlcnBvbnBvbiA5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '6500',
                                                                                                                                          'fiber_length': 519,
                                                                                                                                          'poller_hash': 'M0FERDZFcGVlcnBvbnBvbiAxNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '19390538',
                                                                                                                                          'fiber_length': 545,
                                                                                                                                          'poller_hash': 'NEQ0MUY0cGVlcnBvbnBvbiAyOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '19390525',
                                                                                                                                          'fiber_length': 536,
                                                                                                                                          'poller_hash': 'Mzk2MUE5cGVlcnBvbnBvbiA1MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '19390348',
                                                                                                                                          'fiber_length': 166,
                                                                                                                                          'poller_hash': 'MUM1RENGcGVlcnBvbnBvbiA5Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '6585',
                                                                                                                                          'fiber_length': 593,
                                                                                                                                          'poller_hash': 'QzU4NTBwZWVycG9ucG9uIDE1Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'poller_hash': 'ODcyNDY2cGVlcnBvbnBvbiAxNTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '19390443',
                                                                                                                                          'fiber_length': 484,
                                                                                                                                          'poller_hash': 'NTVGQkQ2cGVlcnBvbnBvbiAxNTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '19389854',
                                                                                                                                          'fiber_length': 358,
                                                                                                                                          'poller_hash': 'MTMwM0RwZWVycG9ucG9uIDE2MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '3934641',
                                                                                                                                          'fiber_length': 539,
                                                                                                                                          'poller_hash': 'MTk5QTFCcGVlcnBvbnBvbiAxNjE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '19390507',
                                                                                                                                          'fiber_length': 573,
                                                                                                                                          'poller_hash': 'MjQ4QUU2cGVlcnBvbnBvbiAxNjI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '19390558',
                                                                                                                                          'fiber_length': 514,
                                                                                                                                          'poller_hash': 'MTYxMDIxcGVlcnBvbnBvbiAxNjM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '3934638',
                                                                                                                                          'fiber_length': 582,
                                                                                                                                          'poller_hash': 'MjQ4QUQ3cGVlcnBvbnBvbiAxNjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '19390412',
                                                                                                                                          'fiber_length': 612,
                                                                                                                                          'poller_hash': 'Mzc4OEMxcGVlcnBvbnBvbiAxNjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '6592',
                                                                                                                                          'fiber_length': 647,
                                                                                                                                          'poller_hash': 'MkZDQ0UxcGVlcnBvbnBvbiAxNjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '19405835',
                                                                                                                                          'fiber_length': 667,
                                                                                                                                          'poller_hash': 'QzgzQkFFcGVlcnBvbnBvbiAxNjYxMjE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '6733',
                                                                                                                                          'fiber_length': 1018,
                                                                                                                                          'poller_hash': 'QzgxRDZGcGVlcnBvbnBvbiAyMTE2NTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/4',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzQ=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/5',
                                                                                         'in_discards': '9354',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '54861940',
                                                                                         'in_octets': '34541443029974',
                                                                                         'in_ucast_pkts': '107969692978',
                                                                                         'links': [       {       'in_nucast_pkts': '76648',
                                                                                                                  'in_octets': '6706222216880',
                                                                                                                  'in_ucast_pkts': '8862398649',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6588',
                                                                                                                  'out_octets': '21029169923618',
                                                                                                                  'out_ucast_pkts': '17799433632',
                                                                                                                  'poller_hash': 'NEQ0MjUwcGVlcmludGZwb24gNg=='},
                                                                                                          {       'in_nucast_pkts': '4',
                                                                                                                  'in_octets': '664858',
                                                                                                                  'in_ucast_pkts': '1342',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2426',
                                                                                                                  'out_octets': '506156',
                                                                                                                  'out_ucast_pkts': '1853',
                                                                                                                  'poller_hash': 'NDNDMjFBcGVlcmludGZwb24gMTM='},
                                                                                                          {       'in_nucast_pkts': '2495',
                                                                                                                  'in_octets': '101600777213',
                                                                                                                  'in_ucast_pkts': '496716650',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '161540',
                                                                                                                  'out_octets': '1441733798363',
                                                                                                                  'out_ucast_pkts': '1061259499',
                                                                                                                  'poller_hash': 'MkZFQTAzcGVlcmludGZwb24gMjQ='},
                                                                                                          {       'in_nucast_pkts': '4037980',
                                                                                                                  'in_octets': '15760568328',
                                                                                                                  'in_ucast_pkts': '55832427',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1956936500',
                                                                                                                  'out_octets': '2706081227818',
                                                                                                                  'out_ucast_pkts': '138188864',
                                                                                                                  'poller_hash': 'NkFDMkM3cGVlcmludGZwb24gNDA='},
                                                                                                          {       'in_nucast_pkts': '358',
                                                                                                                  'in_octets': '10656018811',
                                                                                                                  'in_ucast_pkts': '42236528',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '32599',
                                                                                                                  'out_octets': '301319411713',
                                                                                                                  'out_ucast_pkts': '225977576',
                                                                                                                  'poller_hash': 'NTVERkIxcGVlcmludGZwb24gOTk='},
                                                                                                          {       'in_nucast_pkts': '20554050',
                                                                                                                  'in_octets': '1708728012025',
                                                                                                                  'in_ucast_pkts': '3264311713',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '37805846855',
                                                                                                                  'out_octets': '56109813674033',
                                                                                                                  'out_ucast_pkts': '5571141513',
                                                                                                                  'poller_hash': 'NzZFOTkwcGVlcmludGZwb24gMTgy'},
                                                                                                          {       'in_nucast_pkts': '124',
                                                                                                                  'in_octets': '7353304034',
                                                                                                                  'in_ucast_pkts': '33329601',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1099387',
                                                                                                                  'out_octets': '50215859465',
                                                                                                                  'out_ucast_pkts': '54282931',
                                                                                                                  'poller_hash': 'MTUzQzNwZWVyaW50ZnBvbiAxODM='},
                                                                                                          {       'in_nucast_pkts': '4191298',
                                                                                                                  'in_octets': '127902658074',
                                                                                                                  'in_ucast_pkts': '1673452807',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4188179',
                                                                                                                  'out_octets': '147853446342',
                                                                                                                  'out_ucast_pkts': '2143135121',
                                                                                                                  'poller_hash': 'N0ZGNXBlZXJpbnRmcG9uIDE4NQ=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MzI5NjM5cGVlcmludGZwb24gMTg3'},
                                                                                                          {       'in_nucast_pkts': '16423',
                                                                                                                  'in_octets': '783969764314',
                                                                                                                  'in_ucast_pkts': '4401458227',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1383732',
                                                                                                                  'out_octets': '12731032645353',
                                                                                                                  'out_ucast_pkts': '9920974618',
                                                                                                                  'poller_hash': 'MTk5QTAwcGVlcmludGZwb24gMTg4'},
                                                                                                          {       'in_nucast_pkts': '15383',
                                                                                                                  'in_octets': '36647451113',
                                                                                                                  'in_ucast_pkts': '129445477',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1195470',
                                                                                                                  'out_octets': '419600402448',
                                                                                                                  'out_ucast_pkts': '4619621729',
                                                                                                                  'poller_hash': 'M0NGQTBwZWVyaW50ZnBvbiAxOTA='},
                                                                                                          {       'in_nucast_pkts': '90358',
                                                                                                                  'in_octets': '155069479497',
                                                                                                                  'in_ucast_pkts': '477465281',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '161671',
                                                                                                                  'out_octets': '1935277873487',
                                                                                                                  'out_ucast_pkts': '1482722663',
                                                                                                                  'poller_hash': 'NDcxNDZFcGVlcmludGZwb24gMTkx'},
                                                                                                          {       'in_nucast_pkts': '17924465',
                                                                                                                  'in_octets': '95413601896',
                                                                                                                  'in_ucast_pkts': '479199069',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13779772295',
                                                                                                                  'out_octets': '19803353682131',
                                                                                                                  'out_ucast_pkts': '31347054441',
                                                                                                                  'poller_hash': 'NDE4QjVwZWVyaW50ZnBvbiAxOTI='},
                                                                                                          {       'in_nucast_pkts': '7521695',
                                                                                                                  'in_octets': '5386103805',
                                                                                                                  'in_ucast_pkts': '8615479107',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '14603224547',
                                                                                                                  'out_octets': '19478649738920',
                                                                                                                  'out_ucast_pkts': '42988401390',
                                                                                                                  'poller_hash': 'NDE1NDlwZWVyaW50ZnBvbiAxOTQ='},
                                                                                                          {       'in_nucast_pkts': '43',
                                                                                                                  'in_octets': '41261268809',
                                                                                                                  'in_ucast_pkts': '138751939',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1239974',
                                                                                                                  'out_octets': '153499824116',
                                                                                                                  'out_ucast_pkts': '158214066',
                                                                                                                  'poller_hash': 'NEVCMTdEcGVlcmludGZwb24gMTk1'},
                                                                                                          {       'in_nucast_pkts': '18788849',
                                                                                                                  'in_octets': '30829213022',
                                                                                                                  'in_ucast_pkts': '117449246',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '27970573552',
                                                                                                                  'out_octets': '38155847999041',
                                                                                                                  'out_ucast_pkts': '377119525',
                                                                                                                  'poller_hash': 'QkYyNEI0cGVlcmludGZwb24gMTk2'},
                                                                                                          {       'in_nucast_pkts': '3093',
                                                                                                                  'in_octets': '313175202109',
                                                                                                                  'in_ucast_pkts': '1077617375',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386224',
                                                                                                                  'out_octets': '4426017396835',
                                                                                                                  'out_ucast_pkts': '3417133255',
                                                                                                                  'poller_hash': 'MkYzQUQ5cGVlcmludGZwb24gMTk3'},
                                                                                                          {       'in_nucast_pkts': '16033335',
                                                                                                                  'in_octets': '185872446437',
                                                                                                                  'in_ucast_pkts': '704132694',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13846294440',
                                                                                                                  'out_octets': '21277671333267',
                                                                                                                  'out_ucast_pkts': '2122786133',
                                                                                                                  'poller_hash': 'NzU3QkNwZWVyaW50ZnBvbiAxOTg='},
                                                                                                          {       'in_nucast_pkts': '8358',
                                                                                                                  'in_octets': '12035487568',
                                                                                                                  'in_ucast_pkts': '32274899',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11080807',
                                                                                                                  'out_octets': '95069621511',
                                                                                                                  'out_ucast_pkts': '78792194',
                                                                                                                  'poller_hash': 'QzgxMUUwcGVlcmludGZwb24gMTU3NzUz'},
                                                                                                          {       'in_nucast_pkts': '4',
                                                                                                                  'in_octets': '21742553599',
                                                                                                                  'in_ucast_pkts': '82110616',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3067156',
                                                                                                                  'out_octets': '164589208812',
                                                                                                                  'out_ucast_pkts': '178320166',
                                                                                                                  'poller_hash': 'QzgzQzBDcGVlcmludGZwb24gMTc0NDY0'},
                                                                                                          {       'in_nucast_pkts': '5',
                                                                                                                  'in_octets': '62860902',
                                                                                                                  'in_ucast_pkts': '453911',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3630',
                                                                                                                  'out_octets': '4864885612',
                                                                                                                  'out_ucast_pkts': '3384257',
                                                                                                                  'poller_hash': 'QzgxRTMwcGVlcmludGZwb24gMjA2NDkw'},
                                                                                                          {       'in_nucast_pkts': '118',
                                                                                                                  'in_octets': '1525385',
                                                                                                                  'in_ucast_pkts': '4087',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5896',
                                                                                                                  'out_octets': '4292994',
                                                                                                                  'out_ucast_pkts': '4935',
                                                                                                                  'poller_hash': 'MTI3NEE0M3BlZXJpbnRmcG9uIDIzNTA4Mg=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '643090205895',
                                                                                         'out_octets': '1130198444520889',
                                                                                         'out_ucast_pkts': '230891808443',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzU=',
                                                                                         'pons': [       {       'id': '1/5',
                                                                                                                 'links': [       {       'connected_time': '19390661',
                                                                                                                                          'fiber_length': 1529,
                                                                                                                                          'poller_hash': 'NEQ0MjUwcGVlcnBvbnBvbiA2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '6501',
                                                                                                                                          'fiber_length': 1307,
                                                                                                                                          'poller_hash': 'NDNDMjFBcGVlcnBvbnBvbiAxMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390781',
                                                                                                                                          'fiber_length': 670,
                                                                                                                                          'poller_hash': 'MkZFQTAzcGVlcnBvbnBvbiAyNA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3934517',
                                                                                                                                          'fiber_length': 691,
                                                                                                                                          'poller_hash': 'NkFDMkM3cGVlcnBvbnBvbiA0MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3934581',
                                                                                                                                          'fiber_length': 614,
                                                                                                                                          'poller_hash': 'NTVERkIxcGVlcnBvbnBvbiA5OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390456',
                                                                                                                                          'fiber_length': 1441,
                                                                                                                                          'poller_hash': 'NzZFOTkwcGVlcnBvbnBvbiAxODI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3934487',
                                                                                                                                          'fiber_length': 881,
                                                                                                                                          'poller_hash': 'MTUzQzNwZWVycG9ucG9uIDE4Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19389542',
                                                                                                                                          'fiber_length': 834,
                                                                                                                                          'poller_hash': 'N0ZGNXBlZXJwb25wb24gMTg1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3190884',
                                                                                                                                          'fiber_length': 938,
                                                                                                                                          'poller_hash': 'MzI5NjM5cGVlcnBvbnBvbiAxODc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390446',
                                                                                                                                          'fiber_length': 953,
                                                                                                                                          'poller_hash': 'MTk5QTAwcGVlcnBvbnBvbiAxODg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '6545165',
                                                                                                                                          'fiber_length': 667,
                                                                                                                                          'poller_hash': 'M0NGQTBwZWVycG9ucG9uIDE5MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390788',
                                                                                                                                          'fiber_length': 578,
                                                                                                                                          'poller_hash': 'NDcxNDZFcGVlcnBvbnBvbiAxOTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390325',
                                                                                                                                          'fiber_length': 511,
                                                                                                                                          'poller_hash': 'NDE4QjVwZWVycG9ucG9uIDE5Mg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390404',
                                                                                                                                          'fiber_length': 705,
                                                                                                                                          'poller_hash': 'NDE1NDlwZWVycG9ucG9uIDE5NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '9534047',
                                                                                                                                          'fiber_length': 761,
                                                                                                                                          'poller_hash': 'NEVCMTdEcGVlcnBvbnBvbiAxOTU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14966086',
                                                                                                                                          'fiber_length': 1360,
                                                                                                                                          'poller_hash': 'QkYyNEI0cGVlcnBvbnBvbiAxOTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390255',
                                                                                                                                          'fiber_length': 1317,
                                                                                                                                          'poller_hash': 'MkYzQUQ5cGVlcnBvbnBvbiAxOTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390894',
                                                                                                                                          'fiber_length': 1356,
                                                                                                                                          'poller_hash': 'NzU3QkNwZWVycG9ucG9uIDE5OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19405775',
                                                                                                                                          'fiber_length': 1022,
                                                                                                                                          'poller_hash': 'QzgxMUUwcGVlcnBvbnBvbiAxNTc3NTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3934746',
                                                                                                                                          'fiber_length': 971,
                                                                                                                                          'poller_hash': 'QzgzQzBDcGVlcnBvbnBvbiAxNzQ0NjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '6731',
                                                                                                                                          'fiber_length': 896,
                                                                                                                                          'poller_hash': 'QzgxRTMwcGVlcnBvbnBvbiAyMDY0OTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '6741',
                                                                                                                                          'fiber_length': 712,
                                                                                                                                          'poller_hash': 'MTI3NEE0M3BlZXJwb25wb24gMjM1MDgy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/5',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzU=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/6',
                                                                                         'in_discards': '69581',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '23381187',
                                                                                         'in_octets': '23025238037254',
                                                                                         'in_ucast_pkts': '105799694860',
                                                                                         'links': [       {       'in_nucast_pkts': '28526120',
                                                                                                                  'in_octets': '568154610771',
                                                                                                                  'in_ucast_pkts': '1350865412',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '51995420168',
                                                                                                                  'out_octets': '73518102627770',
                                                                                                                  'out_ucast_pkts': '3255313107',
                                                                                                                  'poller_hash': 'MzIxMUIzcGVlcmludGZwb24gNA=='},
                                                                                                          {       'in_nucast_pkts': '65',
                                                                                                                  'in_octets': '4368623',
                                                                                                                  'in_ucast_pkts': '19671',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4751',
                                                                                                                  'out_octets': '28484047',
                                                                                                                  'out_ucast_pkts': '27957',
                                                                                                                  'poller_hash': 'NDJCOUQzcGVlcmludGZwb24gMTA='},
                                                                                                          {       'in_nucast_pkts': '5343629',
                                                                                                                  'in_octets': '95077221746',
                                                                                                                  'in_ucast_pkts': '529741166',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5927147649',
                                                                                                                  'out_octets': '12025967720167',
                                                                                                                  'out_ucast_pkts': '3140085217',
                                                                                                                  'poller_hash': 'ODcyNDJBcGVlcmludGZwb24gMTU='},
                                                                                                          {       'in_nucast_pkts': '7932343',
                                                                                                                  'in_octets': '379427203754',
                                                                                                                  'in_ucast_pkts': '1375510644',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '21102418876',
                                                                                                                  'out_octets': '32511333686372',
                                                                                                                  'out_ucast_pkts': '3495427169',
                                                                                                                  'poller_hash': 'NDI4MTkxcGVlcmludGZwb24gMzU='},
                                                                                                          {       'in_nucast_pkts': '9067',
                                                                                                                  'in_octets': '12084736',
                                                                                                                  'in_ucast_pkts': '45554',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5264533',
                                                                                                                  'out_octets': '7006867797',
                                                                                                                  'out_ucast_pkts': '65232',
                                                                                                                  'poller_hash': 'MzIyM0QzcGVlcmludGZwb24gNDM='},
                                                                                                          {       'in_nucast_pkts': '11',
                                                                                                                  'in_octets': '2902884',
                                                                                                                  'in_ucast_pkts': '9128',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5743',
                                                                                                                  'out_octets': '14491974',
                                                                                                                  'out_ucast_pkts': '14937',
                                                                                                                  'poller_hash': 'NDJEMkJCcGVlcmludGZwb24gODM='},
                                                                                                          {       'in_nucast_pkts': '5621',
                                                                                                                  'in_octets': '457235585891',
                                                                                                                  'in_ucast_pkts': '3934417804',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1385708',
                                                                                                                  'out_octets': '12280732556853',
                                                                                                                  'out_ucast_pkts': '8573524412',
                                                                                                                  'poller_hash': 'ODc0NEZwZWVyaW50ZnBvbiAxMjc='},
                                                                                                          {       'in_nucast_pkts': '5008464',
                                                                                                                  'in_octets': '9569087222',
                                                                                                                  'in_ucast_pkts': '44964954',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8669241530',
                                                                                                                  'out_octets': '11431962414901',
                                                                                                                  'out_ucast_pkts': '67922248',
                                                                                                                  'poller_hash': 'NEQxMTFGcGVlcmludGZwb24gMjAz'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'MkZDQzMycGVlcmludGZwb24gMjA0'},
                                                                                                          {       'in_nucast_pkts': '4191592',
                                                                                                                  'in_octets': '133115653890',
                                                                                                                  'in_ucast_pkts': '1343537907',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4188282',
                                                                                                                  'out_octets': '117561543729',
                                                                                                                  'out_ucast_pkts': '1699545451',
                                                                                                                  'poller_hash': 'NDE1N0VwZWVyaW50ZnBvbiAyMDY='},
                                                                                                          {       'in_nucast_pkts': '106396',
                                                                                                                  'in_octets': '168056082339',
                                                                                                                  'in_ucast_pkts': '1742969445',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386371',
                                                                                                                  'out_octets': '7353602929133',
                                                                                                                  'out_ucast_pkts': '9273460053',
                                                                                                                  'poller_hash': 'NDE1QUJwZWVyaW50ZnBvbiAyMDc='},
                                                                                                          {       'in_nucast_pkts': '879739',
                                                                                                                  'in_octets': '177959208670',
                                                                                                                  'in_ucast_pkts': '1265089313',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '161552',
                                                                                                                  'out_octets': '6897593984919',
                                                                                                                  'out_ucast_pkts': '4771688594',
                                                                                                                  'poller_hash': 'QkYyNTA1cGVlcmludGZwb24gMjA4'},
                                                                                                          {       'in_nucast_pkts': '1194938',
                                                                                                                  'in_octets': '300591692965',
                                                                                                                  'in_ucast_pkts': '1683242525',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1396438',
                                                                                                                  'out_octets': '7807776397156',
                                                                                                                  'out_ucast_pkts': '5739639267',
                                                                                                                  'poller_hash': 'NDcwM0FGcGVlcmludGZwb24gMjA5'},
                                                                                                          {       'in_nucast_pkts': '3974',
                                                                                                                  'in_octets': '88679893',
                                                                                                                  'in_ucast_pkts': '285470',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10587684',
                                                                                                                  'out_octets': '14506395541',
                                                                                                                  'out_ucast_pkts': '555126',
                                                                                                                  'poller_hash': 'ODcyNDVFcGVlcmludGZwb24gMjEw'},
                                                                                                          {       'in_nucast_pkts': '547077',
                                                                                                                  'in_octets': '48997048',
                                                                                                                  'in_ucast_pkts': '121237',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '702030655',
                                                                                                                  'out_octets': '901314821648',
                                                                                                                  'out_ucast_pkts': '50641',
                                                                                                                  'poller_hash': 'Mzk1MDdBcGVlcmludGZwb24gMjEx'},
                                                                                                          {       'in_nucast_pkts': '13',
                                                                                                                  'in_octets': '13448712',
                                                                                                                  'in_ucast_pkts': '45247',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5807',
                                                                                                                  'out_octets': '102004522',
                                                                                                                  'out_ucast_pkts': '89515',
                                                                                                                  'poller_hash': 'QzgxQzNGcGVlcmludGZwb24gMjEy'},
                                                                                                          {       'in_nucast_pkts': '8725',
                                                                                                                  'in_octets': '445237972309',
                                                                                                                  'in_ucast_pkts': '1789264096',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386186',
                                                                                                                  'out_octets': '7580893671797',
                                                                                                                  'out_ucast_pkts': '5463039243',
                                                                                                                  'poller_hash': 'MTk5QTMycGVlcmludGZwb24gMjE0'},
                                                                                                          {       'in_nucast_pkts': '19614569',
                                                                                                                  'in_octets': '8924615687',
                                                                                                                  'in_ucast_pkts': '43832288',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '32527275166',
                                                                                                                  'out_octets': '43045622886244',
                                                                                                                  'out_ucast_pkts': '97496231',
                                                                                                                  'poller_hash': 'NzZGMjFDcGVlcmludGZwb24gMjE3'},
                                                                                                          {       'in_nucast_pkts': '141865',
                                                                                                                  'in_octets': '298537094010',
                                                                                                                  'in_ucast_pkts': '819241090',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386735',
                                                                                                                  'out_octets': '6671076853108',
                                                                                                                  'out_ucast_pkts': '4753375244',
                                                                                                                  'poller_hash': 'NEQ0MjRGcGVlcmludGZwb24gMjE4'},
                                                                                                          {       'in_nucast_pkts': '15279728',
                                                                                                                  'in_octets': '78993986421',
                                                                                                                  'in_ucast_pkts': '348930806',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4883067820',
                                                                                                                  'out_octets': '7691316761838',
                                                                                                                  'out_ucast_pkts': '1147039084',
                                                                                                                  'poller_hash': 'NDAwMzhGcGVlcmludGZwb24gMjE5'},
                                                                                                          {       'in_nucast_pkts': '17254741',
                                                                                                                  'in_octets': '31335367609',
                                                                                                                  'in_ucast_pkts': '132428569',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4838994595',
                                                                                                                  'out_octets': '6798783089236',
                                                                                                                  'out_ucast_pkts': '552297618',
                                                                                                                  'poller_hash': 'ODZCQkVwZWVyaW50ZnBvbiAyMjA='},
                                                                                                          {       'in_nucast_pkts': '117',
                                                                                                                  'in_octets': '56174164',
                                                                                                                  'in_ucast_pkts': '700367',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5868',
                                                                                                                  'out_octets': '7099287088',
                                                                                                                  'out_ucast_pkts': '5134064',
                                                                                                                  'poller_hash': 'OTU0RjQ1cGVlcmludGZwb24gMTQzODgy'},
                                                                                                          {       'in_nucast_pkts': '6205',
                                                                                                                  'in_octets': '15955044',
                                                                                                                  'in_ucast_pkts': '51100',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11731833',
                                                                                                                  'out_octets': '15327352364',
                                                                                                                  'out_ucast_pkts': '84554',
                                                                                                                  'poller_hash': 'QzgzODFBcGVlcmludGZwb24gMTYwOTk2'},
                                                                                                          {       'in_nucast_pkts': '72',
                                                                                                                  'in_octets': '10595188',
                                                                                                                  'in_ucast_pkts': '66927',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3629',
                                                                                                                  'out_octets': '214175425',
                                                                                                                  'out_ucast_pkts': '162025',
                                                                                                                  'poller_hash': 'QzgxRTAxcGVlcmludGZwb24gMjA1NDU2'},
                                                                                                          {       'in_nucast_pkts': '2338834',
                                                                                                                  'in_octets': '11882242199',
                                                                                                                  'in_ucast_pkts': '35982567',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2196929415',
                                                                                                                  'out_octets': '2994730567182',
                                                                                                                  'out_ucast_pkts': '136342500',
                                                                                                                  'poller_hash': 'MTE5NTE0OXBlZXJpbnRmcG9uIDIxNTk2OQ=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '961651137666',
                                                                                         'out_octets': '1723828697957576',
                                                                                         'out_ucast_pkts': '306256689816',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzY=',
                                                                                         'pons': [       {       'id': '1/6',
                                                                                                                 'links': [       {       'connected_time': '19405327',
                                                                                                                                          'fiber_length': 1274,
                                                                                                                                          'poller_hash': 'MzIxMUIzcGVlcnBvbnBvbiA0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '6498',
                                                                                                                                          'fiber_length': 1321,
                                                                                                                                          'poller_hash': 'NDJCOUQzcGVlcnBvbnBvbiAxMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19405350',
                                                                                                                                          'fiber_length': 1491,
                                                                                                                                          'poller_hash': 'ODcyNDJBcGVlcnBvbnBvbiAxNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19405580',
                                                                                                                                          'fiber_length': 1490,
                                                                                                                                          'poller_hash': 'NDI4MTkxcGVlcnBvbnBvbiAzNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '6521',
                                                                                                                                          'fiber_length': 1451,
                                                                                                                                          'poller_hash': 'MzIyM0QzcGVlcnBvbnBvbiA0Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '6544',
                                                                                                                                          'fiber_length': 1338,
                                                                                                                                          'poller_hash': 'NDJEMkJCcGVlcnBvbnBvbiA4Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390480',
                                                                                                                                          'fiber_length': 1387,
                                                                                                                                          'poller_hash': 'ODc0NEZwZWVycG9ucG9uIDEyNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390403',
                                                                                                                                          'fiber_length': 1329,
                                                                                                                                          'poller_hash': 'NEQxMTFGcGVlcnBvbnBvbiAyMDM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'poller_hash': 'MkZDQzMycGVlcnBvbnBvbiAyMDQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390355',
                                                                                                                                          'fiber_length': 1247,
                                                                                                                                          'poller_hash': 'NDE1N0VwZWVycG9ucG9uIDIwNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390381',
                                                                                                                                          'fiber_length': 1273,
                                                                                                                                          'poller_hash': 'NDE1QUJwZWVycG9ucG9uIDIwNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19389821',
                                                                                                                                          'fiber_length': 1353,
                                                                                                                                          'poller_hash': 'QkYyNTA1cGVlcnBvbnBvbiAyMDg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390191',
                                                                                                                                          'fiber_length': 1330,
                                                                                                                                          'poller_hash': 'NDcwM0FGcGVlcnBvbnBvbiAyMDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '6613',
                                                                                                                                          'fiber_length': 1476,
                                                                                                                                          'poller_hash': 'ODcyNDVFcGVlcnBvbnBvbiAyMTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '1816548',
                                                                                                                                          'fiber_length': 1207,
                                                                                                                                          'poller_hash': 'Mzk1MDdBcGVlcnBvbnBvbiAyMTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '6615',
                                                                                                                                          'fiber_length': 1300,
                                                                                                                                          'poller_hash': 'QzgxQzNGcGVlcnBvbnBvbiAyMTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390326',
                                                                                                                                          'fiber_length': 1074,
                                                                                                                                          'poller_hash': 'MTk5QTMycGVlcnBvbnBvbiAyMTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390476',
                                                                                                                                          'fiber_length': 1007,
                                                                                                                                          'poller_hash': 'NzZGMjFDcGVlcnBvbnBvbiAyMTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390588',
                                                                                                                                          'fiber_length': 1327,
                                                                                                                                          'poller_hash': 'NEQ0MjRGcGVlcnBvbnBvbiAyMTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390361',
                                                                                                                                          'fiber_length': 1198,
                                                                                                                                          'poller_hash': 'NDAwMzhGcGVlcnBvbnBvbiAyMTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390377',
                                                                                                                                          'fiber_length': 1227,
                                                                                                                                          'poller_hash': 'ODZCQkVwZWVycG9ucG9uIDIyMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '6711',
                                                                                                                                          'fiber_length': 1530,
                                                                                                                                          'poller_hash': 'OTU0RjQ1cGVlcnBvbnBvbiAxNDM4ODI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.